'use strict';

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

var _postcss = require('postcss');

var _postcss2 = _interopRequireDefault(_postcss);

var _perfectionist = require('perfectionist');

var _perfectionist2 = _interopRequireDefault(_perfectionist);

var _registerConfigAsDependency = require('./lib/registerConfigAsDependency');

var _registerConfigAsDependency2 = _interopRequireDefault(_registerConfigAsDependency);

var _substituteTailwindAtRules = require('./lib/substituteTailwindAtRules');

var _substituteTailwindAtRules2 = _interopRequireDefault(_substituteTailwindAtRules);

var _evaluateTailwindFunctions = require('./lib/evaluateTailwindFunctions');

var _evaluateTailwindFunctions2 = _interopRequireDefault(_evaluateTailwindFunctions);

var _substituteVariantsAtRules = require('./lib/substituteVariantsAtRules');

var _substituteVariantsAtRules2 = _interopRequireDefault(_substituteVariantsAtRules);

var _substituteResponsiveAtRules = require('./lib/substituteResponsiveAtRules');

var _substituteResponsiveAtRules2 = _interopRequireDefault(_substituteResponsiveAtRules);

var _substituteScreenAtRules = require('./lib/substituteScreenAtRules');

var _substituteScreenAtRules2 = _interopRequireDefault(_substituteScreenAtRules);

var _substituteClassApplyAtRules = require('./lib/substituteClassApplyAtRules');

var _substituteClassApplyAtRules2 = _interopRequireDefault(_substituteClassApplyAtRules);

var _mergeConfigWithDefaults = require('./util/mergeConfigWithDefaults');

var _mergeConfigWithDefaults2 = _interopRequireDefault(_mergeConfigWithDefaults);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const plugin = _postcss2.default.plugin('tailwind', config => {
  const plugins = [];

  if (!_lodash2.default.isUndefined(config)) {
    plugins.push((0, _registerConfigAsDependency2.default)(_path2.default.resolve(config)));
  }

  const lazyConfig = () => {
    if (_lodash2.default.isUndefined(config)) {
      return require('../defaultConfig')();
    }

    delete require.cache[require.resolve(_path2.default.resolve(config))];
    return (0, _mergeConfigWithDefaults2.default)(require(_path2.default.resolve(config)), require('../defaultConfig')());
  };

  return (0, _postcss2.default)(...plugins, ...[(0, _substituteTailwindAtRules2.default)(lazyConfig), (0, _evaluateTailwindFunctions2.default)(lazyConfig), (0, _substituteVariantsAtRules2.default)(lazyConfig), (0, _substituteResponsiveAtRules2.default)(lazyConfig), (0, _substituteScreenAtRules2.default)(lazyConfig), (0, _substituteClassApplyAtRules2.default)(lazyConfig), (0, _perfectionist2.default)({
    cascade: true,
    colorShorthand: true,
    indentSize: 2,
    maxSelectorLength: 1,
    maxValueLength: false,
    trimLeadingZero: true,
    trimTrailingZeros: true
  })]);
});

plugin.defaultConfig = function () {
  // prettier-ignore
  throw new Error("`require('tailwindcss').defaultConfig()` is no longer a function, access it instead as `require('tailwindcss/defaultConfig')()`.");
};

module.exports = plugin;