'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

exports.default = function (config) {
  return function (css) {
    const unwrappedConfig = config();

    const [pluginComponents, pluginUtilities] = (0, _processPlugins2.default)(unwrappedConfig);

    css.walkAtRules('tailwind', atRule => {
      if (atRule.params === 'preflight') {
        const preflightTree = _postcss2.default.parse(_fs2.default.readFileSync(`${__dirname}/../../css/preflight.css`, 'utf8'));

        preflightTree.walk(node => node.source = atRule.source);

        atRule.before(preflightTree);
        atRule.remove();
      }

      if (atRule.params === 'components') {
        const pluginComponentTree = _postcss2.default.root({
          nodes: pluginComponents
        });

        pluginComponentTree.walk(node => node.source = atRule.source);

        atRule.before(pluginComponentTree);
        atRule.remove();
      }

      if (atRule.params === 'utilities') {
        const utilities = (0, _generateModules2.default)(_utilityModules2.default, unwrappedConfig.modules, unwrappedConfig);

        if (unwrappedConfig.options.important) {
          utilities.walkDecls(decl => decl.important = true);
        }

        const tailwindUtilityTree = _postcss2.default.root({
          nodes: utilities.nodes
        });

        const pluginUtilityTree = _postcss2.default.root({
          nodes: pluginUtilities
        });

        (0, _prefixTree2.default)(tailwindUtilityTree, unwrappedConfig.options.prefix);

        tailwindUtilityTree.walk(node => node.source = atRule.source);
        pluginUtilityTree.walk(node => node.source = atRule.source);

        atRule.before(tailwindUtilityTree);
        atRule.before(pluginUtilityTree);
        atRule.remove();
      }
    });
  };
};

var _fs = require('fs');

var _fs2 = _interopRequireDefault(_fs);

var _postcss = require('postcss');

var _postcss2 = _interopRequireDefault(_postcss);

var _utilityModules = require('../utilityModules');

var _utilityModules2 = _interopRequireDefault(_utilityModules);

var _prefixTree = require('../util/prefixTree');

var _prefixTree2 = _interopRequireDefault(_prefixTree);

var _generateModules = require('../util/generateModules');

var _generateModules2 = _interopRequireDefault(_generateModules);

var _processPlugins = require('../util/processPlugins');

var _processPlugins2 = _interopRequireDefault(_processPlugins);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }