'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

exports.default = function (config) {
  return function (css) {
    const unwrappedConfig = config();

    css.walkAtRules('variants', atRule => {
      const variants = _postcss2.default.list.comma(atRule.params);

      if (variants.includes('responsive')) {
        const responsiveParent = _postcss2.default.atRule({ name: 'responsive' });
        atRule.before(responsiveParent);
        responsiveParent.append(atRule);
      }

      atRule.before(atRule.clone().nodes);

      _lodash2.default.forEach(['group-hover', 'hover', 'focus', 'active'], variant => {
        if (variants.includes(variant)) {
          variantGenerators[variant](atRule, unwrappedConfig);
        }
      });

      atRule.remove();
    });
  };
};

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

var _postcss = require('postcss');

var _postcss2 = _interopRequireDefault(_postcss);

var _buildSelectorVariant = require('../util/buildSelectorVariant');

var _buildSelectorVariant2 = _interopRequireDefault(_buildSelectorVariant);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function buildPseudoClassVariant(selector, pseudoClass, separator) {
  return `${(0, _buildSelectorVariant2.default)(selector, pseudoClass, separator)}:${pseudoClass}`;
}

function generatePseudoClassVariant(pseudoClass) {
  return (container, config) => {
    const cloned = container.clone();

    cloned.walkRules(rule => {
      rule.selector = buildPseudoClassVariant(rule.selector, pseudoClass, config.options.separator);
    });

    container.before(cloned.nodes);
  };
}

const variantGenerators = {
  'group-hover': (container, { options: { separator } }) => {
    const cloned = container.clone();

    cloned.walkRules(rule => {
      rule.selector = `.group:hover ${(0, _buildSelectorVariant2.default)(rule.selector, 'group-hover', separator)}`;
    });

    container.before(cloned.nodes);
  },
  hover: generatePseudoClassVariant('hover'),
  focus: generatePseudoClassVariant('focus'),
  active: generatePseudoClassVariant('active')
};