#!/usr/bin/env node
'use strict';

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _fsExtra = require('fs-extra');

var _fsExtra2 = _interopRequireDefault(_fsExtra);

var _ = require('..');

var _2 = _interopRequireDefault(_);

var _postcss = require('postcss');

var _postcss2 = _interopRequireDefault(_postcss);

var _process = require('process');

var _process2 = _interopRequireDefault(_process);

var _commander = require('commander');

var _commander2 = _interopRequireDefault(_commander);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* eslint-disable no-process-exit */

function writeStrategy(options) {
  if (options.output === undefined) {
    return output => {
      _process2.default.stdout.write(output);
    };
  }
  return output => {
    _fsExtra2.default.outputFileSync(options.output, output);
  };
}

function buildTailwind(inputFile, config, write) {
  console.warn('Building Tailwind!');

  const input = _fsExtra2.default.readFileSync(inputFile, 'utf8');

  return (0, _postcss2.default)([(0, _2.default)(config)]).process(input, { from: inputFile }).then(result => {
    write(result.css);
    console.warn('Finished building Tailwind!');
  }).catch(error => console.error(error));
}

const packageJson = require(_path2.default.resolve(__dirname, '../package.json'));

_commander2.default.version(packageJson.version).usage('<command> [<args>]');

_commander2.default.command('init [filename]').usage('[options] [filename]').action((filename = 'tailwind.js') => {
  let destination = _path2.default.resolve(filename);

  if (!_path2.default.extname(filename).includes('.js')) {
    destination += '.js';
  }

  if (_fsExtra2.default.existsSync(destination)) {
    console.error(`Destination ${destination} already exists, aborting.`);
    _process2.default.exit(1);
  }

  const output = _fsExtra2.default.readFileSync(_path2.default.resolve(__dirname, '../defaultConfig.stub.js'), 'utf8');
  _fsExtra2.default.outputFileSync(destination, output.replace('// let defaultConfig', 'let defaultConfig'));
  _fsExtra2.default.outputFileSync(destination, output.replace("require('./plugins/container')", "require('tailwindcss/plugins/container')"));
  console.warn(`Generated Tailwind config: ${destination}`);
  _process2.default.exit();
});

_commander2.default.command('build').usage('[options] <file ...>').option('-c, --config [path]', 'Path to config file').option('-o, --output [path]', 'Output file').action((file, options) => {
  let inputFile = _commander2.default.args[0];

  if (!inputFile) {
    console.error('No input file given!');
    _process2.default.exit(1);
  }

  buildTailwind(inputFile, options.config, writeStrategy(options)).then(() => {
    _process2.default.exit();
  });
});

_commander2.default.command('*', null, {
  noHelp: true
}).action(() => {
  _commander2.default.help();
});

_commander2.default.parse(_process2.default.argv);

if (_commander2.default.args.length === 0) {
  _commander2.default.help();
  _process2.default.exit();
}