'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = generateVariantFunction;

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

var _postcss = require('postcss');

var _postcss2 = _interopRequireDefault(_postcss);

var _escapeClassName = require('./escapeClassName');

var _escapeClassName2 = _interopRequireDefault(_escapeClassName);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function generateVariantFunction(generator) {
  return (container, config) => {
    const cloned = _postcss2.default.root({ nodes: container.clone().nodes });

    container.before(_lodash2.default.defaultTo(generator({
      container: cloned,
      separator: (0, _escapeClassName2.default)(config.options.separator),
      modifySelectors: modifierFunction => {
        cloned.walkRules(rule => {
          rule.selector = modifierFunction({
            className: rule.selector.slice(1),
            selector: rule.selector
          });
        });
        return cloned;
      }
    }), cloned).nodes);
  };
}