'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

exports.default = function (config, { variantGenerators: pluginVariantGenerators }) {
  return function (css) {
    const variantGenerators = _extends({}, defaultVariantGenerators, pluginVariantGenerators);

    css.walkAtRules('variants', atRule => {
      const variants = _postcss2.default.list.comma(atRule.params).filter(variant => variant !== '');

      if (variants.includes('responsive')) {
        const responsiveParent = _postcss2.default.atRule({ name: 'responsive' });
        atRule.before(responsiveParent);
        responsiveParent.append(atRule);
      }

      atRule.before(atRule.clone().nodes);

      _lodash2.default.forEach(_lodash2.default.without(variants, 'responsive'), variant => {
        variantGenerators[variant](atRule, config);
      });

      atRule.remove();
    });
  };
};

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

var _postcss = require('postcss');

var _postcss2 = _interopRequireDefault(_postcss);

var _generateVariantFunction = require('../util/generateVariantFunction');

var _generateVariantFunction2 = _interopRequireDefault(_generateVariantFunction);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function generatePseudoClassVariant(pseudoClass) {
  return (0, _generateVariantFunction2.default)(({ modifySelectors, separator }) => {
    return modifySelectors(({ className }) => {
      return `.${pseudoClass}${separator}${className}:${pseudoClass}`;
    });
  });
}

const defaultVariantGenerators = {
  'group-hover': (0, _generateVariantFunction2.default)(({ modifySelectors, separator }) => {
    return modifySelectors(({ className }) => {
      return `.group:hover .group-hover${separator}${className}`;
    });
  }),
  hover: generatePseudoClassVariant('hover'),
  'focus-within': generatePseudoClassVariant('focus-within'),
  focus: generatePseudoClassVariant('focus'),
  active: generatePseudoClassVariant('active')
};