"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;

var _lodash = _interopRequireDefault(require("lodash"));

var _postcss = _interopRequireDefault(require("postcss"));

var _generateVariantFunction = _interopRequireDefault(require("../util/generateVariantFunction"));

var _escapeClassName = _interopRequireDefault(require("../util/escapeClassName"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function generatePseudoClassVariant(pseudoClass) {
  return (0, _generateVariantFunction.default)(({
    modifySelectors,
    separator
  }) => {
    return modifySelectors(({
      className
    }) => {
      return `.${(0, _escapeClassName.default)(`${pseudoClass}${separator}${className}`)}:${pseudoClass}`;
    });
  });
}

function ensureIncludesDefault(variants) {
  return variants.includes('default') ? variants : ['default', ...variants];
}

const defaultVariantGenerators = {
  default: (0, _generateVariantFunction.default)(() => {}),
  'group-hover': (0, _generateVariantFunction.default)(({
    modifySelectors,
    separator
  }) => {
    return modifySelectors(({
      className
    }) => {
      return `.group:hover .${(0, _escapeClassName.default)(`group-hover${separator}${className}`)}`;
    });
  }),
  hover: generatePseudoClassVariant('hover'),
  'focus-within': generatePseudoClassVariant('focus-within'),
  focus: generatePseudoClassVariant('focus'),
  active: generatePseudoClassVariant('active')
};

function _default(config, {
  variantGenerators: pluginVariantGenerators
}) {
  return function (css) {
    const variantGenerators = { ...defaultVariantGenerators,
      ...pluginVariantGenerators
    };
    css.walkAtRules('variants', atRule => {
      const variants = _postcss.default.list.comma(atRule.params).filter(variant => variant !== '');

      if (variants.includes('responsive')) {
        const responsiveParent = _postcss.default.atRule({
          name: 'responsive'
        });

        atRule.before(responsiveParent);
        responsiveParent.append(atRule);
      }

      _lodash.default.forEach(_lodash.default.without(ensureIncludesDefault(variants), 'responsive'), variant => {
        variantGenerators[variant](atRule, config);
      });

      atRule.remove();
    });
  };
}