
'use strict';

var targaryen = require('../../../../../index'), // in your app this would be require('targaryen')
  users = targaryen.users;

targaryen.setFirebaseData(require('./data.json'));
targaryen.setFirebaseRules(require('./rules.json'));

describe('A valid set of security rules and data', function() {

  beforeEach(function() {
    jasmine.addMatchers(targaryen.jasmine.matchers);
  });

  it('can be tested against', function() {

    expect(users.unauthenticated).cannotRead('users/password:500f6e96-92c6-4f60-ad5d-207253aee4d3');
    expect(users.password).canRead('users/password:500f6e96-92c6-4f60-ad5d-207253aee4d3');

    expect(users.password).cannotWrite('users/password:500f6e96-92c6-4f60-ad5d-207253aee4d3/innocent', true);
    expect({ uid: 'password:3403291b-fdc9-4995-9a54-9656241c835d' }).canWrite('users/password:500f6e96-92c6-4f60-ad5d-207253aee4d3/on-fire', true);

  });

});

