tc-angular-chartjs
==================

[![Build Status](https://travis-ci.org/carlcraig/tc-angular-chartjs.svg)](https://travis-ci.org/carlcraig/tc-angular-chartjs)

[Documentation](http://carlcraig.github.io/tc-angular-chartjs/)

### Add Chart.js to your angular applications

tc-angular-chartjs provides you with directives for all chartjs chart types.

- Line Charts
- Bar Charts
- Radar Charts
- Polar Area Charts
- Pie Charts
- Doughnut Charts

You can see all the [Chart.js Documentation](http://www.chartjs.org/docs/) on their website.

Installation
============

Grab the latest version of `Chart.js` and `tc-angular-chartjs`.

Load `Chart.js` and `tc-angular-chartjs` as you would with normal scripts.

```html
<script type="text/javascript" src="js/Chart.js"></script>
<script type="text/javascript" src="js/angular.js"></script>
<script type="text/javascript" src="js/tc-angular-chartjs.js"></script>
```

Make sure you use `dist/tc-angular-chartjs.js` or `dist/tc-angular-chartjs.min.js`

Require `tc.chartjs` in your application modules where you require `Chart.js`.

```javascript
angular.module( 'app', ['tc.chartjs']);
```

Basic Usage
===========

There are 6 different directives.

- tc-chartjs
- tc-chartjs-line
- tc-chartjs-bar
- tc-chartjs-radar
- tc-chartjs-polararea
- tc-chartjs-pie
- tc-chartjs-doughnut

Just place one of these directives on a `canvas` element to create a Chart.js chart.

```html
<canvas tc-chartjs-doughnut width="350" height="350"></canvas>
```

You will also want to give the chart some `data` and `options`. These can be provided
by assigning $scope variables to `chart-options` and `chart-data` attributes on the same canvas element.

```html
<canvas tc-chartjs-doughnut chart-data="myData" chart-options="myOptions" chart-click="onChartClick(data, event)" width="350" height="350"></canvas>
```
```javascript
$scope.myData = [
  { value : 50, color : "#F7464A" },
  { value : 90, color : "#E2EAE9" },
  { value : 75, color : "#D4CCC5" },
  { value : 30, color : "#949FB1"}
];

$scope.myOptions =  {
  // Chart.js options can go here.
};

$scope.onChartClick = function (data, event) {
  console.log(data, event);
};

```

Using the `tc-chartjs` directive
================================

When using the `tc-chartjs` directive you will need to add an additional attribute to
say which type of chart should be created.

Just attach a `chart-type=""` attribute to the canvas element.

```html
<canvas tc-chartjs chart-type="doughnut" chart-data="data" chart-options="options" width="350" height="350"></canvas>
```

Available Types:

- line
- bar
- radar
- polararea
- pie
- doughnut

Passing another value to chart-type than the above will try to create a chart of
that type, which is useful if you have extended Chart.js with custom chart types,
e.g. through plugins.

Contributing
============

- [Open a Pull Request (PR)](https://github.com/carlcraig/tc-angular-chartjs/pull/new/master)
- Make sure your PR is on a new branch you created from the latest version of master branch
- Please do not open a PR from your master branch
- Open a PR even if your code is incomplete to start a discussion and to collect feedback
- Please make sure all unit tests pass, and add new tests for any added features.


License
=======

tc-angular-chartjs is dual licensed with the Apache-2.0 or MIT license.

See LICENSE-APACHE-2.0 and LICENSE-MIT for more details.

