import { JSX } from "preact";
import { CookieSameSite, Hanko } from "@teamhanko/hanko-frontend-sdk";
import { Translations } from "./i18n/translations";
export interface HankoAuthAdditionalProps {
    experimental?: string;
    prefilledEmail?: string;
    prefilledUsername?: string;
}
export declare interface HankoAuthElementProps extends JSX.HTMLAttributes<HTMLElement>, HankoAuthAdditionalProps {
}
export declare interface HankoProfileElementProps extends JSX.HTMLAttributes<HTMLElement> {
}
export declare interface HankoEventsElementProps extends JSX.HTMLAttributes<HTMLElement> {
}
declare global {
    namespace JSX {
        interface IntrinsicElements {
            "hanko-auth": HankoAuthElementProps;
            "hanko-login": HankoAuthElementProps;
            "hanko-registration": HankoAuthElementProps;
            "hanko-profile": HankoProfileElementProps;
            "hanko-events": HankoEventsElementProps;
        }
    }
}
export interface RegisterOptions {
    shadow?: boolean;
    injectStyles?: boolean;
    enablePasskeys?: boolean;
    hidePasskeyButtonOnLogin?: boolean;
    translations?: Translations;
    translationsLocation?: string;
    fallbackLanguage?: string;
    storageKey?: string;
    cookieDomain?: string;
    cookieSameSite?: CookieSameSite;
}
export interface RegisterResult {
    hanko: Hanko;
}
export declare const register: (api: string, options?: RegisterOptions) => Promise<RegisterResult>;
