import { JSXInternal } from "preact/src/jsx";
import { ComponentChildren, h } from "preact";
import { StateUpdater } from "preact/compat";
import { Hanko } from "@teamhanko/hanko-frontend-sdk";
import { Translations } from "../i18n/translations";
import { Handlers } from "@teamhanko/hanko-frontend-sdk/dist/lib/flow-api/types/state-handling";
import { Error as FlowError } from "@teamhanko/hanko-frontend-sdk/dist/lib/flow-api/types/error";
import SignalLike = JSXInternal.SignalLike;
type ExperimentalFeature = "conditionalMediation";
type ExperimentalFeatures = ExperimentalFeature[];
export type ComponentName = "auth" | "login" | "registration" | "profile" | "events";
export interface GlobalOptions {
    hanko?: Hanko;
    injectStyles?: boolean;
    enablePasskeys?: boolean;
    hidePasskeyButtonOnLogin?: boolean;
    translations?: Translations;
    translationsLocation?: string;
    fallbackLanguage?: string;
}
export type UIAction = "email-submit" | "passkey-submit" | "passkey-rename" | "passkey-delete" | "passcode-resend" | "passcode-submit" | "password-submit" | "password-recovery" | "password-delete" | "choose-login-method" | "switch-flow" | "email-set-primary" | "email-delete" | "email-verify" | "username-set" | "username-delete" | "skip" | "back" | "account_delete" | "retry" | "thirdparty-submit" | "session-delete";
interface UIState {
    username?: string;
    email?: string;
    loadingAction?: UIAction;
    succeededAction?: UIAction;
    lastAction?: UIAction;
    error?: FlowError;
}
interface Context {
    hanko: Hanko;
    page: h.JSX.Element;
    setPage: StateUpdater<h.JSX.Element>;
    init: (compName: ComponentName) => void;
    isDisabled: boolean;
    componentName: ComponentName;
    setComponentName: StateUpdater<ComponentName>;
    experimentalFeatures?: ExperimentalFeatures;
    lang: string;
    hidePasskeyButtonOnLogin: boolean;
    prefilledEmail?: string;
    prefilledUsername?: string;
    stateHandler: Handlers;
    setLoadingAction: StateUpdater<UIAction>;
    setSucceededAction: StateUpdater<UIAction>;
    uiState: UIState;
    setUIState: StateUpdater<UIState>;
    initialComponentName: ComponentName;
}
export declare const AppContext: import("preact").Context<Context>;
interface Props {
    lang?: string | SignalLike<string>;
    experimental?: string;
    prefilledEmail?: string;
    prefilledUsername?: string;
    componentName: ComponentName;
    globalOptions: GlobalOptions;
    children?: ComponentChildren;
    createWebauthnAbortSignal: () => AbortSignal;
}
declare const AppProvider: ({ lang, experimental, prefilledEmail, prefilledUsername, globalOptions, createWebauthnAbortSignal, ...props }: Props) => JSXInternal.Element;
export default AppProvider;
