import { ConfigClient } from "./lib/client/ConfigClient";
import { EnterpriseClient } from "./lib/client/EnterpriseClient";
import { PasscodeClient } from "./lib/client/PasscodeClient";
import { PasswordClient } from "./lib/client/PasswordClient";
import { UserClient } from "./lib/client/UserClient";
import { WebauthnClient } from "./lib/client/WebauthnClient";
import { EmailClient } from "./lib/client/EmailClient";
import { ThirdPartyClient } from "./lib/client/ThirdPartyClient";
import { TokenClient } from "./lib/client/TokenClient";
import { Listener } from "./lib/events/Listener";
import { Relay } from "./lib/events/Relay";
import { Session } from "./lib/Session";
/**
 * The options for the Hanko class
 *
 * @interface
 * @property {number=} timeout - The http request timeout in milliseconds. Defaults to 13000ms
 * @property {string=} cookieName - The name of the session cookie set from the SDK. Defaults to "hanko"
 * @property {string=} localStorageKey - The prefix / name of the local storage keys. Defaults to "hanko"
 */
export interface HankoOptions {
    timeout?: number;
    cookieName?: string;
    localStorageKey?: string;
}
/**
 * A class that bundles all available SDK functions.
 *
 * @extends {Listener}
 * @param {string} api - The URL of your Hanko API instance
 * @param {HankoOptions=} options - The options that can be used
 */
declare class Hanko extends Listener {
    api: string;
    config: ConfigClient;
    user: UserClient;
    webauthn: WebauthnClient;
    password: PasswordClient;
    passcode: PasscodeClient;
    email: EmailClient;
    thirdParty: ThirdPartyClient;
    enterprise: EnterpriseClient;
    token: TokenClient;
    relay: Relay;
    session: Session;
    constructor(api: string, options?: HankoOptions);
}
export interface InternalOptions {
    timeout: number;
    cookieName: string;
    localStorageKey: string;
}
export { Hanko };
