import { SessionDetail } from "./events/CustomEvents";
import { SessionState } from "./state/session/SessionState";
import { Cookie } from "./Cookie";
/**
 * Options for Session
 *
 * @category SDK
 * @subcategory Internal
 * @property {string} cookieName - The name of the session cookie set from the SDK.
 * @property {string} localStorageKey - The prefix / name of the local storage keys.
 */
interface SessionOptions {
    cookieName: string;
    localStorageKey: string;
}
/**
 A class representing a session.

 @category SDK
 @subcategory Session
 @param {SessionOptions} options - The options that can be used
 */
export declare class Session {
    _sessionState: SessionState;
    _cookie: Cookie;
    constructor(options: SessionOptions);
    /**
     Retrieves the session details.
  
     @returns {SessionDetail} The session details.
     */
    get(): SessionDetail;
    /**
     Checks if the user is logged in.
  
     @returns {boolean} true if the user is logged in, false otherwise.
     */
    isValid(): boolean;
    /**
     Retrieves the session details.
  
     @ignore
     @returns {SessionDetail} The session details.
     */
    _get(): SessionDetail;
    /**
     Checks if the auth flow is completed. The value resets after the next login attempt.
  
     @returns {boolean} Returns true if the authentication flow is completed, false otherwise
     */
    isAuthFlowCompleted(): boolean;
    /**
     Validates the session.
  
     @private
     @param {SessionDetail} detail - The session details to validate.
     @returns {boolean} true if the session details are valid, false otherwise.
     */
    private static validate;
}
export {};
