/**
 * @interface
 * @category SDK
 * @subcategory Internal
 * @property {boolean=} leading - Whether to allow the function to be called on the leading edge of the wait timeout.
 * @property {boolean=} trailing - Whether to allow the function to be called on the trailing edge of the wait timeout.
 */
interface ThrottleOptions {
    leading?: boolean;
    trailing?: boolean;
}
type ThrottledFunction<T extends (...args: any[]) => any> = (...args: Parameters<T>) => void;
/**
 * Provides throttle functionality.
 *
 * @hideconstructor
 * @category SDK
 * @subcategory Internal
 */
export declare class Throttle {
    /**
     * Throttles a function, ensuring that it can only be called once per `wait` milliseconds.
     *
     * @static
     * @param {function} func - The function to throttle.
     * @param {number} wait - The number of milliseconds to wait between function invocations.
     * @param {ThrottleOptions} options - Optional configuration for the throttle.
     * @returns {function} A throttled version of the original function.
     */
    static throttle<T extends (...args: any[]) => any>(func: T, wait: number, options?: ThrottleOptions): ThrottledFunction<T>;
}
export {};
