import { Config } from "../Dto";
import { Client } from "./Client";
/**
 * A class for retrieving configurations from the API.
 *
 * @category SDK
 * @subcategory Clients
 * @extends {Client}
 */
declare class ConfigClient extends Client {
    /**
     * Retrieves the frontend configuration.
     * @return {Promise<Config>}
     * @throws {RequestTimeoutError}
     * @throws {TechnicalError}
     * @see https://docs.hanko.io/api/public#tag/.well-known/operation/getConfig
     */
    get(): Promise<Config>;
}
export { ConfigClient };
