import { Client } from "./Client";
import { Email, Emails } from "../Dto";
/**
 * Manages email addresses of the current user.
 *
 * @constructor
 * @category SDK
 * @subcategory Clients
 * @extends {Client}
 */
declare class EmailClient extends Client {
    /**
     * Returns a list of all email addresses assigned to the current user.
     *
     * @return {Promise<Emails>}
     * @throws {UnauthorizedError}
     * @throws {RequestTimeoutError}
     * @throws {TechnicalError}
     * @see https://docs.hanko.io/api/public#tag/Email-Management/operation/listEmails
     */
    list(): Promise<Emails>;
    /**
     * Adds a new email address to the current user.
     *
     * @param {string} address - The email address to be added.
     * @return {Promise<Email>}
     * @throws {EmailAddressAlreadyExistsError}
     * @throws {MaxNumOfEmailAddressesReachedError}
     * @throws {RequestTimeoutError}
     * @throws {TechnicalError}
     * @throws {UnauthorizedError}
     * @see https://docs.hanko.io/api/public#tag/Email-Management/operation/createEmail
     */
    create(address: string): Promise<Email>;
    /**
     * Marks the specified email address as primary.
     *
     * @param {string} emailID - The ID of the email address to be updated
     * @return {Promise<void>}
     * @throws {RequestTimeoutError}
     * @throws {TechnicalError}
     * @throws {UnauthorizedError}
     * @see https://docs.hanko.io/api/public#tag/Email-Management/operation/setPrimaryEmail
     */
    setPrimaryEmail(emailID: string): Promise<void>;
    /**
     * Deletes the specified email address.
     *
     * @param {string} emailID - The ID of the email address to be deleted
     * @return {Promise<void>}
     * @throws {RequestTimeoutError}
     * @throws {TechnicalError}
     * @throws {UnauthorizedError}
     * @see https://docs.hanko.io/api/public#tag/Email-Management/operation/deleteEmail
     */
    delete(emailID: string): Promise<void>;
}
export { EmailClient };
