import { Client } from "./Client";
import { ThirdPartyError } from "../Errors";
/**
 * A class that handles communication with the Hanko API for the purposes
 * of authenticating through a third party provider.
 *
 * @constructor
 * @category SDK
 * @subcategory Clients
 * @extends {Client}
 */
export declare class EnterpriseClient extends Client {
    /**
     * Extracts the domain from an email address
     * @param {string} email E-Mail address of the user from which the domain will be extracted.
     * @throws {ThirdPartyError}
     * @private
     */
    private getDomain;
    /**
     * Performs a request to the Hanko API to check if there is a provider for the users e-mail domain
     *
     * @param {string} email - E-Mail address of the user to login
     */
    hasProvider(email: string): Promise<boolean>;
    /**
     * Performs a request to the Hanko API that redirects to the given
     * third party provider.
     *
     * @param {string} email - E-Mail address of the user
     * @param {string} redirectTo - The URL to redirect to after a successful third party authentication
     * @throws {ThirdPartyError}
     * @see http://docs.hanko.io/api/public#tag/Third-Party/operation/enterpriseAuth
     */
    auth(email: string, redirectTo: string): void;
    /**
     * Get a third party error from the current location's query params.
     * @returns {(ThirdPartyError|undefined)} The ThirdPartyError.
     */
    getError(): ThirdPartyError;
}
