import { PasswordState } from "../state/users/PasswordState";
import { PasscodeState } from "../state/users/PasscodeState";
import { Client } from "./Client";
import { HttpClientOptions } from "./HttpClient";
/**
 * A class to handle passwords.
 *
 * @constructor
 * @category SDK
 * @subcategory Clients
 * @extends {Client}
 */
declare class PasswordClient extends Client {
    passwordState: PasswordState;
    passcodeState: PasscodeState;
    constructor(api: string, options: HttpClientOptions);
    /**
     * Logs in a user with a password.
     *
     * @param {string} userID - The UUID of the user.
     * @param {string} password - The password.
     * @return {Promise<void>}
     * @throws {InvalidPasswordError}
     * @throws {RequestTimeoutError}
     * @throws {TechnicalError}
     * @throws {TooManyRequestsError}
     * @see https://docs.hanko.io/api/public#tag/Password/operation/passwordLogin
     */
    login(userID: string, password: string): Promise<void>;
    /**
     * Updates a password.
     *
     * @param {string} userID - The UUID of the user.
     * @param {string} password - The new password.
     * @return {Promise<void>}
     * @throws {RequestTimeoutError}
     * @throws {UnauthorizedError}
     * @throws {TechnicalError}
     * @see https://docs.hanko.io/api/public#tag/Password/operation/password
     */
    update(userID: string, password: string): Promise<void>;
    /**
     * Returns the number of seconds the rate limiting is active for.
     *
     * @param {string} userID - The UUID of the user.
     * @return {number}
     */
    getRetryAfter(userID: string): number;
}
export { PasswordClient };
