import { Client } from "./Client";
/**
 * Client responsible for exchanging one time tokens for session JWTs.
 *
 * @constructor
 * @category SDK
 * @subcategory Clients
 * @extends {Client}
 */
export declare class TokenClient extends Client {
    /**
     * Validate a one time token to retrieve a session JWT. Does nothing
     * if the current window location does not contain a 'hanko_token' in the
     * search query.
     *
     * @return {Promise<void>}
     * @throws {TechnicalError}
     * https://docs.hanko.io/api/api/public#tag/Token/operation/token
     */
    validate(): Promise<void>;
}
