/**
 * The type of the `hanko-session-created` event.
 * @typedef {string} sessionCreatedType
 * @memberOf Listener
 */
export declare const sessionCreatedType: "hanko-session-created";
/**
 * The type of the `hanko-session-expired` event.
 * @typedef {string} sessionExpiredType
 * @memberOf Listener
 */
export declare const sessionExpiredType: "hanko-session-expired";
/**
 * The type of the `hanko-user-logged-out` event.
 * @typedef {string} userLoggedOutType
 * @memberOf Listener
 */
export declare const userLoggedOutType: "hanko-user-logged-out";
/**
 * The type of the `hanko-user-deleted` event.
 * @typedef {string} userDeletedType
 * @memberOf Listener
 */
export declare const userDeletedType: "hanko-user-deleted";
/**
 * The type of the `hanko-auth-flow-completed` event.
 * @typedef {string} authFlowCompletedType
 * @memberOf Listener
 */
export declare const authFlowCompletedType: "hanko-auth-flow-completed";
/**
 * The data passed in the `hanko-session-created` or `hanko-session-resumed` event.
 *
 * @interface
 * @category SDK
 * @subcategory Events
 * @property {string=} jwt - The JSON web token associated with the session. Only present when the Hanko-API allows the JWT to be accessible client-side.
 * @property {number} expirationSeconds - The number of seconds until the JWT expires.
 * @property {string} userID - The user associated with the session.
 */
export interface SessionDetail {
    jwt?: string;
    expirationSeconds: number;
    userID: string;
}
/**
 * The data passed in the `hanko-auth-flow-completed` event.
 *
 * @interface
 * @category SDK
 * @subcategory Events
 * @property {string} userID - The user associated with the removed session.
 */
export interface AuthFlowCompletedDetail {
    userID: string;
}
/**
 * A custom event that includes a detail object.
 *
 * @category SDK
 * @subcategory Events
 * @extends CustomEvent
 * @ignore
 * @param {string} type - The type of the event.
 * @param {T} detail - The detail object to include in the event.
 */
export declare class CustomEventWithDetail<T> extends CustomEvent<T> {
    constructor(type: string, detail: T);
}
