import { SessionDetail, AuthFlowCompletedDetail } from "./CustomEvents";
import { SessionState } from "../state/session/SessionState";
/**
 * Options for Dispatcher
 *
 * @category SDK
 * @subcategory Internal
 * @property {string} localStorageKey - The prefix / name of the local storage keys.
 */
interface DispatcherOptions {
    localStorageKey: string;
}
/**
 * A class that dispatches custom events.
 *
 * @category SDK
 * @subcategory Internal
 * @param {DispatcherOptions} options - The options that can be used
 */
export declare class Dispatcher {
    _dispatchEvent: any;
    _sessionState: SessionState;
    constructor(options: DispatcherOptions);
    /**
     * Dispatches a custom event.
     *
     * @param {string} type
     * @param {T} detail
     * @private
     */
    private dispatch;
    /**
     * Dispatches a "hanko-session-created" event to the document with the specified detail.
     *
     * @param {SessionDetail} detail - The event detail.
     */
    dispatchSessionCreatedEvent(detail: SessionDetail): void;
    /**
     * Dispatches a "hanko-session-expired" event to the document.
     */
    dispatchSessionExpiredEvent(): void;
    /**
     * Dispatches a "hanko-user-logged-out" event to the document.
     */
    dispatchUserLoggedOutEvent(): void;
    /**
     * Dispatches a "hanko-user-deleted" event to the document.
     */
    dispatchUserDeletedEvent(): void;
    /**
     * Dispatches a "hanko-auth-flow-completed" event to the document with the specified detail.
     *
     * @param {AuthFlowCompletedDetail} detail - The event detail.
     */
    dispatchAuthFlowCompletedEvent(detail: AuthFlowCompletedDetail): void;
}
export {};
