import { LocalStorageUsers } from "./users/UserState";
import { LocalStorageSession } from "./session/SessionState";
/**
 * @interface
 * @category SDK
 * @subcategory Internal
 * @property {LocalStorageUsers=} users - The user states.
 */
interface LocalStorage {
    users?: LocalStorageUsers;
    session?: LocalStorageSession;
}
/**
 * A class to read and write local storage contents.
 *
 * @abstract
 * @param {string} key - The local storage key.
 * @category SDK
 * @subcategory Internal
 */
declare abstract class State {
    key: string;
    ls: LocalStorage;
    constructor(key: string);
    /**
     * Reads and decodes the locally stored data.
     *
     * @return {State}
     */
    read(): State;
    /**
     * Encodes and writes the data to the local storage.
     *
     * @return {State}
     */
    write(): State;
    /**
     * Converts a timestamp into remaining seconds that you can count down.
     *
     * @static
     * @param {number} time - Timestamp in seconds (since January 1, 1970 00:00:00 UTC).
     * @return {number}
     */
    static timeToRemainingSeconds(time?: number): number;
    /**
     * Converts a number of seconds into a timestamp.
     *
     * @static
     * @param {number} seconds - Remaining seconds to be converted into a timestamp.
     * @return {number}
     */
    static remainingSecondsToTime(seconds?: number): number;
}
export { State };
export type { LocalStorage };
