import { State } from "../State";
/**
 * Options for SessionState
 *
 * @category SDK
 * @subcategory Internal
 * @property {string} localStorageKey - The prefix / name of the local storage keys.
 */
interface SessionStateOptions {
    localStorageKey: string;
}
/**
 * @interface
 * @category SDK
 * @subcategory Internal
 * @property {Object.<string, LocalStorageSession>} - A dictionary for mapping users to their states.
 */
export interface LocalStorageSession {
    expiry: number;
    userID: string;
    authFlowCompleted: boolean;
}
/**
 * A class to read and write local storage contents regarding sessions.
 *
 * @extends State
 * @param {SessionStateOptions} options - The options that can be used
 * @category SDK
 * @subcategory Internal
 */
declare class SessionState extends State {
    constructor(options: SessionStateOptions);
    /**
     * Reads the current state.
     *
     * @public
     * @return {SessionState}
     */
    read(): SessionState;
    /**
     * Gets the session state.
     *
     * @return {LocalStorageSession}
     */
    getState(): LocalStorageSession;
    /**
     * Gets the number of seconds until the active session is valid.
     *
     * @return {number}
     */
    getExpirationSeconds(): number;
    /**
     * Sets the number of seconds until the active session is valid.
     *
     * @param {number} seconds - The number of seconds
     * @return {SessionState}
     */
    setExpirationSeconds(seconds: number): SessionState;
    /**
     * Gets the user id.
     */
    getUserID(): string;
    /**
     * Sets the user id.
     *
     * @param {string} userID - The user id
     * @return {SessionState}
     */
    setUserID(userID: string): SessionState;
    /**
     * Gets the authFlowCompleted indicator.
     */
    getAuthFlowCompleted(): boolean;
    /**
     * Sets the authFlowCompleted indicator.
     *
     * @param {string} completed - The authFlowCompleted indicator.
     * @return {SessionState}
     */
    setAuthFlowCompleted(completed: boolean): SessionState;
    /**
     * Removes the session details.
     *
     * @return {SessionState}
     */
    reset(): SessionState;
}
export { SessionState };
