import { UserState } from "./UserState";
/**
 * @interface
 * @category SDK
 * @subcategory Internal
 * @property {number=} retryAfter - Timestamp (in seconds since January 1, 1970 00:00:00 UTC) indicating when the next password login can be attempted.
 */
export interface LocalStoragePassword {
    retryAfter?: number;
}
/**
 * A class that manages the password login state.
 *
 * @extends UserState
 * @category SDK
 * @subcategory Internal
 */
declare class PasswordState extends UserState {
    /**
     * Get the password state.
     *
     * @private
     * @param {string} userID - The UUID of the user.
     * @return {LocalStoragePassword}
     */
    private getState;
    /**
     * Reads the current state.
     *
     * @public
     * @return {PasswordState}
     */
    read(): PasswordState;
    /**
     * Gets the number of seconds until when a new password login can be attempted.
     *
     * @param {string} userID - The UUID of the user.
     * @return {number}
     */
    getRetryAfter(userID: string): number;
    /**
     * Sets the number of seconds until a new password login can be attempted.
     *
     * @param {string} userID - The UUID of the user.
     * @param {string} seconds - Number of seconds the passcode is valid for.
     * @return {PasswordState}
     */
    setRetryAfter(userID: string, seconds: number): PasswordState;
}
export { PasswordState };
