import { EnterpriseClient } from "./lib/client/EnterpriseClient";
import { UserClient } from "./lib/client/UserClient";
import { EmailClient } from "./lib/client/EmailClient";
import { ThirdPartyClient } from "./lib/client/ThirdPartyClient";
import { TokenClient } from "./lib/client/TokenClient";
import { Listener } from "./lib/events/Listener";
import { Relay } from "./lib/events/Relay";
import { Session } from "./lib/Session";
import { CookieSameSite } from "./lib/Cookie";
import { Flow } from "./lib/flow-api/Flow";
import { SessionClient } from "./lib/client/SessionClient";
/**
 * The options for the Hanko class
 *
 * @interface
 * @property {number=} timeout - The http request timeout in milliseconds. Defaults to 13000ms
 * @property {string=} cookieName - The name of the session cookie set from the SDK. Defaults to "hanko"
 * @property {string=} cookieDomain - The domain where the cookie set from the SDK is available. Defaults to the domain of the page where the cookie was created.
 * @property {string=} cookieSameSite - Specify whether/when cookies are sent with cross-site requests. Defaults to "lax".
 * @property {string=} localStorageKey - The prefix / name of the local storage keys. Defaults to "hanko"
 */
export interface HankoOptions {
    timeout?: number;
    cookieName?: string;
    cookieDomain?: string;
    cookieSameSite?: CookieSameSite;
    localStorageKey?: string;
}
/**
 * A class that bundles all available SDK functions.
 *
 * @extends {Listener}
 * @param {string} api - The URL of your Hanko API instance
 * @param {HankoOptions=} options - The options that can be used
 */
declare class Hanko extends Listener {
    api: string;
    user: UserClient;
    email: EmailClient;
    thirdParty: ThirdPartyClient;
    enterprise: EnterpriseClient;
    token: TokenClient;
    sessionClient: SessionClient;
    relay: Relay;
    session: Session;
    flow: Flow;
    constructor(api: string, options?: HankoOptions);
}
export interface InternalOptions {
    timeout: number;
    cookieName: string;
    cookieDomain?: string;
    cookieSameSite?: CookieSameSite;
    localStorageKey: string;
}
export { Hanko };
