import { CookieAttributes } from "js-cookie";
/**
 * Options for Cookie
 *
 * @category SDK
 * @subcategory Internal
 * @property {string} cookieName - The name of the session cookie set from the SDK.
 * @property {string=} cookieDomain - The domain where the cookie set from the SDK is available. Defaults to the domain of the page where the cookie was created.
 * @property {string=} cookieSameSite -Specify whether/when cookies are sent with cross-site requests. Defaults to "lax".
 */
interface CookieOptions {
    cookieName: string;
    cookieDomain?: string;
    cookieSameSite?: CookieSameSite;
}
export type CookieSameSite = "strict" | "Strict" | "lax" | "Lax" | "none" | "None";
/**
 * A class to manage cookies.
 *
 * @category SDK
 * @subcategory Internal
 * @param {CookieOptions} options - The options that can be used
 */
export declare class Cookie {
    authCookieName: string;
    authCookieDomain?: string;
    authCookieSameSite: CookieSameSite;
    constructor(options: CookieOptions);
    /**
     * Returns the authentication token that was stored in the cookie.
     *
     * @return {string}
     */
    getAuthCookie(): string;
    /**
     * Stores the authentication token to the cookie.
     *
     * @param {string} token - The authentication token to be stored.
     * @param {CookieAttributes} options - Options for setting the auth cookie.
     */
    setAuthCookie(token: string, options?: CookieAttributes): void;
    /**
     * Removes the cookie used for authentication.
     */
    removeAuthCookie(): void;
}
export {};
