/**
 * A class to check the browser's WebAuthn support.
 *
 * @hideconstructor
 * @category SDK
 * @subcategory Utilities
 */
declare class WebauthnSupport {
    /**
     * Does a simple check to test for the credential management API functions we need, and an indication of
     * public key credential authentication support.
     *
     * @see https://developers.google.com/web/updates/2018/03/webauthn-credential-management
     * @return boolean
     */
    static supported(): boolean;
    /**
     * Checks whether a user-verifying platform authenticator is available.
     *
     * @return Promise<boolean>
     */
    static isPlatformAuthenticatorAvailable(): Promise<boolean>;
    /**
     * Checks whether external CTAP2 security keys are supported.
     *
     * @return Promise<boolean>
     */
    static isSecurityKeySupported(): Promise<boolean>;
    /**
     * Checks whether autofill assisted requests are supported.
     *
     * @return Promise<boolean>
     */
    static isConditionalMediationAvailable(): Promise<boolean>;
}
export { WebauthnSupport };
