import { Client } from "./Client";
import { SessionCheckResponse } from "../Dto";
/**
 * A class that handles communication with the Hanko API for the purposes
 * of sessions.
 *
 * @constructor
 * @category SDK
 * @subcategory Clients
 * @extends {Client}
 */
export declare class SessionClient extends Client {
    /**
     * Checks if the current session is still valid.
     *
     * @return {Promise<SessionCheckResponse>}
     * @throws {TechnicalError}
     */
    isValid(): Promise<SessionCheckResponse>;
}
