import { Client } from "./Client";
import { ThirdPartyError } from "../Errors";
/**
 * A class that handles communication with the Hanko API for the purposes
 * of authenticating through a third party provider.
 *
 * @constructor
 * @category SDK
 * @subcategory Clients
 * @extends {Client}
 */
export declare class ThirdPartyClient extends Client {
    /**
     * Performs a request to the Hanko API that redirects to the given
     * third party provider.
     *
     * @param {string} provider - The name of the third party provider
     * @param {string} redirectTo - The URL to redirect to after a successful third party authentication
     * @throws {ThirdPartyError}
     * @see http://docs.hanko.io/api/public#tag/Third-Party/operation/thirdPartyAuth
     */
    auth(provider: string, redirectTo: string): Promise<void>;
    /**
     * Get a third party error from the current location's query params.
     * @returns {(ThirdPartyError|undefined)} The ThirdPartyError.
     */
    getError(): ThirdPartyError;
}
