import { Client } from "../client/Client";
import { State } from "./State";
import { Action } from "./types/action";
import { FlowPath, Handlers } from "./types/state-handling";
type ExtendedHandlers = Handlers & {
    onError?: (e: unknown) => any;
};
declare class Flow extends Client {
    init(initPath: FlowPath, handlers: ExtendedHandlers): Promise<void>;
    fromString(init: string, handlers: ExtendedHandlers): Promise<void>;
    /**
     * Runs a handler for a given state.
     *
     * If the handler returns an action or a state, this method will run the next
     * appropriate handler for that state. (Recursively)
     *
     * If the handlers passed to `init` do not contain an `onError` handler,
     * this method will throw.
     *
     * @see InvalidStateError
     * @see HandlerNotFoundError
     *
     * @example
     * const handlerResult = await run("/login", {
     *   // all login handlers are in here, one of which will be called
     *   // based on what the /login endpoint returns
     * });
     */
    run: (state: State<any>, handlers: ExtendedHandlers) => Promise<unknown>;
}
export declare class HandlerNotFoundError extends Error {
    state: State<any>;
    constructor(state: State<any>);
}
export declare class InvalidStateError extends Error {
    state: State<any>;
    constructor(state: State<any>);
}
export declare function isAction(x: any): x is Action<unknown>;
export { Flow };
