import { FetchNextState, StateName, Actions, Payloads } from "./types/state-handling";
import { Error } from "./types/error";
import { Action } from "./types/action";
import { Input } from "./types/input";
type InputValues<TInput extends Record<string, Input<any>>> = {
    [K in keyof TInput]?: TInput[K]["value"];
};
type CreateAction<TAction extends Action<any>> = (inputs: InputValues<TAction["inputs"]>) => TAction & {
    run: () => Promise<State<any>>;
    validate: () => TAction;
    tryValidate: () => ValidationError | void;
};
type ActionFunctions = {
    [TStateName in keyof Actions]: {
        [TActionName in keyof Actions[TStateName]]: Actions[TStateName][TActionName] extends Action<infer Inputs> ? CreateAction<Action<Inputs>> : never;
    };
};
interface StateResponse<TStateName extends StateName> {
    name: StateName;
    status: number;
    payload?: Payloads[TStateName];
    actions?: Actions[TStateName];
    csrf_token: string;
    error: Error;
}
declare class State<TStateName extends StateName> implements Omit<StateResponse<TStateName>, "actions"> {
    #private;
    readonly name: StateName;
    readonly payload?: Payloads[TStateName];
    readonly error: Error;
    readonly status: number;
    readonly csrf_token: string;
    readonly actions: ActionFunctions[TStateName];
    private readonly fetchNextState;
    toJSON(): {
        name: StateName;
        payload: Payloads[TStateName];
        error: Error;
        status: number;
        csrf_token: string;
        actions: Actions[TStateName];
    };
    constructor({ name, payload, error, status, actions, csrf_token }: StateResponse<TStateName>, fetchNextState: FetchNextState);
    runAction(action: Action<any>, csrfToken: string): Promise<State<any>>;
    validateAction(action: Action<{
        [key: string]: Input<unknown>;
    }>): void;
}
export declare enum ValidationReason {
    InvalidInputDefinition = 0,
    MinLength = 1,
    MaxLength = 2,
    Required = 3
}
export declare class ValidationError<TWanted = undefined> extends Error {
    reason: ValidationReason;
    inputName: string;
    wanted: TWanted;
    actual: TWanted;
    constructor(opts: {
        reason: ValidationReason;
        inputName: string;
        wanted: TWanted;
        actual: TWanted;
        message: string;
    });
}
export declare function isState(x: any): x is State<any>;
export { State };
