var telnet = require('./lib')
var telnet_server = require('telnet')

srv = telnet_server.createServer(function(c) {
  c.write(new Buffer("BusyBox v1.19.2 () built-in shell (ash)\n"
    + "Enter 'help' for a list of built-in commands.\n\n/ # ", 'ascii'))

  c.on('data', function(data) {
    if (data.toString().indexOf('uptime\n') !== -1) {
      c.write(new Buffer("23:14  up 1 day, 21:50, 6 users, "
        + "load averages: 1.41 1.43 1.41\r\n", 'ascii'))
      c.write(new Buffer("/ # ", 'ascii'))
    }
    else if (data.toString().indexOf('df\n') !== -1) {
      c.write(new Buffer("/dev/disk1     112Gi   87Gi   25Gi    78% 1913034 4293054245    0%   /\r\n", 'ascii'))
      c.write(new Buffer("/ # ", 'ascii'))
    }
  })
})

srv.listen(2323)

var connection = new telnet()

connection.connect({
  host: '127.0.0.1',
  port: 2323,
  execTimeout: 1000,
  negotiationMandatory: false
})
.then(function() {
  connection.shell(function(error, stream) {
    stream.on('data', (data) => {
      console.log(data.toString())
      /*
      console.log('%%%%%% new data:', data.toString())
      console.log('---------------')
      */
    })

    setTimeout(() => stream.write('uptime\n'), 500)
    setTimeout(() => stream.write('df\n'), 1000)
    setTimeout(() => connection.end(), 1100)

    stream.on("error", (error) => console.log(error))
  })
})
