# template-helpers [![NPM version](https://img.shields.io/npm/v/template-helpers.svg?style=flat)](https://www.npmjs.com/package/template-helpers) [![NPM downloads](https://img.shields.io/npm/dm/template-helpers.svg?style=flat)](https://npmjs.org/package/template-helpers) [![Build Status](https://img.shields.io/travis/jonschlinkert/template-helpers.svg?style=flat)](https://travis-ci.org/jonschlinkert/template-helpers)

Generic JavaScript helpers that can be used with any template engine. Handlebars, Lo-Dash, Underscore, or any engine that supports helper functions.

- [Install](#install)
- [Usage](#usage)
  * [Use with any template engine](#use-with-any-template-engine)
  * [Namespacing](#namespacing)
- [API](#api)
  * [array](#array)
  * [code](#code)
  * [collection](#collection)
  * [conditional](#conditional)
  * [fs](#fs)
  * [html](#html)
  * [index](#index)
  * [math](#math)
  * [object](#object)
  * [path](#path)
  * [string](#string)
  * [Code coverage](#code-coverage)
- [About](#about)
  * [Related projects](#related-projects)
  * [Contributing](#contributing)
  * [Building docs](#building-docs)
  * [Running tests](#running-tests)
  * [Author](#author)
  * [License](#license)

_(TOC generated by [verb](https://github.com/verbose/verb) using [markdown-toc](https://github.com/jonschlinkert/markdown-toc))_

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save template-helpers
```

In addition to the [related projects](#related-projects) listed below, also take a look at the [helpers org](https://github.com/helpers), there are 60+ specialized helpers that can be used individually.

## Usage

To get all helpers:

```js
var helpers = require('template-helpers')();
console.log(helpers);
```

**Get a specific helper category**

```js
// get only the math helpers
var helpers = require('template-helpers')('math');
```

**Get multiple helper categories**

```js
// get only the math helpers
var helpers = require('template-helpers')(['math', 'string']);
```

### Use with any template engine

**Lo-Dash Example**

```js
var helpers = require('template-helpers')('array');

// pass helpers on `imports`
var imports = {imports: helpers};

// compile a template
var fn = _.template('<%= first(foo) %>', imports);

// render
fn({foo: ['a', 'b', 'c']});
//=> 'a'
```

### Namespacing

Handlebars and Lo-Dash both allow **dot notation** to be used for referencing helpers. I'd be happy to add examples for other engines if someone wants to do a PR.

**Example**

```js
<%= path.dirname("a/b/c/d.js") %>
```

This can be used as a way of working around potential naming conflicts.

## API

_(The following **API Table of Contents** is generated by [verb](https://github.com/verbose/verb). See the [verbfile.js](verbfile.js) for more details.)_

## Categories

Currently **86 helpers** in **10 categories**:

* **[array](#array)** ([code](lib/array.js) | [unit tests](test/array.js))
* **[code](#code)** ([code](lib/code.js) | [unit tests](test/code.js))
* **[collection](#collection)** ([code](lib/collection.js) | [unit tests](test/collection.js))
* **[conditional](#conditional)** ([code](lib/conditional.js) | [unit tests](test/conditional.js))
* **[fs](#fs)** ([code](lib/fs.js) | [unit tests](test/fs.js))
* **[html](#html)** ([code](lib/html.js) | [unit tests](test/html.js))
* **[math](#math)** ([code](lib/math.js) | [unit tests](test/math.js))
* **[object](#object)** ([code](lib/object.js) | [unit tests](test/object.js))
* **[path](#path)** ([code](lib/path.js) | [unit tests](test/path.js))
* **[string](#string)** ([code](lib/string.js) | [unit tests](test/string.js))

## All helpers

### [array helpers](#array)

Visit the: [code](lib/array.js) | [unit tests](test/array.js) | [issues](https://github.com/jonschlinkert/template-helpers/issues?utf8=%E2%9C%93&q=is%3Aissue+is%3Aopen+array+helpers))

* **[isArray](#isArray)** ([code](lib/array.js#L22) | [unit tests](test/array.js#L18))
* **[arrayify](#arrayify)** ([code](lib/array.js#L46) | [unit tests](test/array.js#L25))
* **[first](#first)** ([code](lib/array.js#L64) | [unit tests](test/array.js#L32))
* **[last](#last)** ([code](lib/array.js#L87) | [unit tests](test/array.js#L48))
* **[before](#before)** ([code](lib/array.js#L112) | [unit tests](test/array.js#L61))
* **[after](#after)** ([code](lib/array.js#L132) | [unit tests](test/array.js#L71))
* **[each](#each)** ([code](lib/array.js#L159) | [unit tests](test/array.js#L98))
* **[map](#map)** ([code](lib/array.js#L201) | [unit tests](test/array.js#L122))
* **[join](#join)** ([code](lib/array.js#L232) | [unit tests](test/array.js#L82))
* **[sort](#sort)** ([code](lib/array.js#L257) | [unit tests](test/array.js#L137))
* **[length](#length)** ([code](lib/array.js#L291) | [unit tests](test/array.js#L162))
* **[compact](#compact)** ([code](lib/array.js#L309) | [unit tests](test/array.js#L178))
* **[difference](#difference)** ([code](lib/array.js#L328) | [unit tests](test/array.js#L189))
* **[unique](#unique)** ([code](lib/array.js#L364) | [unit tests](test/array.js#L205))
* **[union](#union)** ([code](lib/array.js#L394) | [unit tests](test/array.js#L215))
* **[shuffle](#shuffle)** ([code](lib/array.js#L411) | [no tests])

### [code helpers](#code)

Visit the: [code](lib/code.js) | [unit tests](test/code.js) | [issues](https://github.com/jonschlinkert/template-helpers/issues?utf8=%E2%9C%93&q=is%3Aissue+is%3Aopen+code+helpers))

* **[embed](#embed)** ([code](lib/code.js#L24) | [unit tests](test/code.js#L33))
* **[jsfiddle](#jsfiddle)** ([code](lib/code.js#L48) | [unit tests](test/code.js#L24))

### [collection helpers](#collection)

Visit the: [code](lib/collection.js) | [unit tests](test/collection.js) | [issues](https://github.com/jonschlinkert/template-helpers/issues?utf8=%E2%9C%93&q=is%3Aissue+is%3Aopen+collection+helpers))

* **[any](#any)** ([code](lib/collection.js#L15) | [unit tests](test/collection.js#L17))
* **[filter](#filter)** ([code](lib/collection.js#L32) | [unit tests](test/collection.js#L34))

### [conditional helpers](#conditional)

Visit the: [code](lib/conditional.js) | [unit tests](test/conditional.js) | [issues](https://github.com/jonschlinkert/template-helpers/issues?utf8=%E2%9C%93&q=is%3Aissue+is%3Aopen+conditional+helpers))

* **[_if](#_if)** ([code](lib/conditional.js#L13) | [no tests])

### [fs helpers](#fs)

Visit the: [code](lib/fs.js) | [unit tests](test/fs.js) | [issues](https://github.com/jonschlinkert/template-helpers/issues?utf8=%E2%9C%93&q=is%3Aissue+is%3Aopen+fs+helpers))

* **[exists](#exists)** ([code](lib/fs.js#L19) | [unit tests](test/fs.js#L17))
* **[read](#read)** ([code](lib/fs.js#L35) | [unit tests](test/fs.js#L23))

### [html helpers](#html)

Visit the: [code](lib/html.js) | [unit tests](test/html.js) | [issues](https://github.com/jonschlinkert/template-helpers/issues?utf8=%E2%9C%93&q=is%3Aissue+is%3Aopen+html+helpers))

* **[escapeHtml](#escapeHtml)** ([code](lib/html.js#L18) | [unit tests](test/html.js#L17))
* **[sanitize](#sanitize)** ([code](lib/html.js#L46) | [unit tests](test/html.js#L27))

### [math helpers](#math)

Visit the: [code](lib/math.js) | [unit tests](test/math.js) | [issues](https://github.com/jonschlinkert/template-helpers/issues?utf8=%E2%9C%93&q=is%3Aissue+is%3Aopen+math+helpers))

* **[add](#add)** ([code](lib/math.js#L18) | [unit tests](test/math.js#L17))
* **[subtract](#subtract)** ([code](lib/math.js#L35) | [unit tests](test/math.js#L23))
* **[divide](#divide)** ([code](lib/math.js#L53) | [unit tests](test/math.js#L29))
* **[multiply](#multiply)** ([code](lib/math.js#L71) | [unit tests](test/math.js#L35))
* **[floor](#floor)** ([code](lib/math.js#L89) | [unit tests](test/math.js#L41))
* **[ceil](#ceil)** ([code](lib/math.js#L107) | [unit tests](test/math.js#L47))
* **[round](#round)** ([code](lib/math.js#L128) | [unit tests](test/math.js#L53))
* **[sum](#sum)** ([code](lib/math.js#L145) | [unit tests](test/math.js#L60))

### [object helpers](#object)

Visit the: [code](lib/object.js) | [unit tests](test/object.js) | [issues](https://github.com/jonschlinkert/template-helpers/issues?utf8=%E2%9C%93&q=is%3Aissue+is%3Aopen+object+helpers))

* **[fallback](#fallback)** ([code](lib/object.js#L22) | [unit tests](test/object.js#L18))
* **[stringify](#stringify)** ([code](lib/object.js#L39) | [unit tests](test/object.js#L26))
* **[parse](#parse)** ([code](lib/object.js#L56) | [unit tests](test/object.js#L33))
* **[get](#get)** ([code](lib/object.js#L74) | [no tests])
* **[keys](#keys)** ([code](lib/object.js#L91) | [unit tests](test/object.js#L64))
* **[isObject](#isObject)** ([code](lib/object.js#L112) | [unit tests](test/object.js#L40))
* **[isPlainObject](#isPlainObject)** ([code](lib/object.js#L135) | [unit tests](test/object.js#L48))
* **[hasOwn](#hasOwn)** ([code](lib/object.js#L149) | [unit tests](test/object.js#L57))
* **[omit](#omit)** ([code](lib/object.js#L167) | [unit tests](test/object.js#L98))
* **[forIn](#forIn)** ([code](lib/object.js#L185) | [unit tests](test/object.js#L70))
* **[forOwn](#forOwn)** ([code](lib/object.js#L207) | [unit tests](test/object.js#L84))
* **[extend](#extend)** ([code](lib/object.js#L224) | [unit tests](test/object.js#L105))
* **[merge](#merge)** ([code](lib/object.js#L257) | [unit tests](test/object.js#L132))

### [path helpers](#path)

Visit the: [code](lib/path.js) | [unit tests](test/path.js) | [issues](https://github.com/jonschlinkert/template-helpers/issues?utf8=%E2%9C%93&q=is%3Aissue+is%3Aopen+path+helpers))

* **[dirname](#dirname)** ([code](lib/path.js#L20) | [unit tests](test/path.js#L18))
* **[basename](#basename)** ([code](lib/path.js#L38) | [unit tests](test/path.js#L24))
* **[filename](#filename)** ([code](lib/path.js#L56) | [unit tests](test/path.js#L30))
* **[extname](#extname)** ([code](lib/path.js#L74) | [unit tests](test/path.js#L36))
* **[ext](#ext)** ([code](lib/path.js#L74) | [unit tests](test/path.js#L36))
* **[resolve](#resolve)** ([code](lib/path.js#L110) | [unit tests](test/path.js#L48))
* **[relative](#relative)** ([code](lib/path.js#L129) | [unit tests](test/path.js#L54))
* **[segments](#segments)** ([code](lib/path.js#L160) | [unit tests](test/path.js#L108))
* **[join](#join)** ([code](lib/path.js#L182) | [unit tests](test/path.js#L101))
* **[isAbsolute](#isAbsolute)** ([code](lib/path.js#L217) | [unit tests](test/path.js#L82))
* **[isRelative](#isRelative)** ([code](lib/path.js#L252) | [unit tests](test/path.js#L63))

### [string helpers](#string)

Visit the: [code](lib/string.js) | [unit tests](test/string.js) | [issues](https://github.com/jonschlinkert/template-helpers/issues?utf8=%E2%9C%93&q=is%3Aissue+is%3Aopen+string+helpers))

* **[camelcase](#camelcase)** ([code](lib/string.js#L18) | [unit tests](test/string.js#L111))
* **[centerAlign](#centerAlign)** ([code](lib/string.js#L45) | [no tests])
* **[chop](#chop)** ([code](lib/string.js#L69) | [unit tests](test/string.js#L51))
* **[count](#count)** ([code](lib/string.js#L90) | [unit tests](test/string.js#L290))
* **[dotcase](#dotcase)** ([code](lib/string.js#L110) | [unit tests](test/string.js#L175))
* **[ellipsis](#ellipsis)** ([code](lib/string.js#L135) | [unit tests](test/string.js#L381))
* **[isString](#isString)** ([code](lib/string.js#L157) | [no tests])
* **[lower](#lower)** ([code](lib/string.js#L174) | [unit tests](test/string.js#L17))
* **[lowercase](#lowercase)** ([code](lib/string.js#L174) | [unit tests](test/string.js#L17))
* **[pascalcase](#pascalcase)** ([code](lib/string.js#L191) | [unit tests](test/string.js#L132))
* **[snakecase](#snakecase)** ([code](lib/string.js#L211) | [unit tests](test/string.js#L154))
* **[split](#split)** ([code](lib/string.js#L233) | [no tests])
* **[strip](#strip)** ([code](lib/string.js#L250) | [unit tests](test/string.js#L73))
* **[stripIndent](#stripIndent)** ([code](lib/string.js#L269) | [unit tests](test/string.js#L87))
* **[trim](#trim)** ([code](lib/string.js#L298) | [unit tests](test/string.js#L37))
* **[dashcase](#dashcase)** ([code](lib/string.js#L317) | [unit tests](test/string.js#L196))
* **[pathcase](#pathcase)** ([code](lib/string.js#L339) | [unit tests](test/string.js#L217))
* **[sentencecase](#sentencecase)** ([code](lib/string.js#L361) | [unit tests](test/string.js#L238))
* **[hyphenate](#hyphenate)** ([code](lib/string.js#L380) | [unit tests](test/string.js#L252))
* **[slugify](#slugify)** ([code](lib/string.js#L399) | [unit tests](test/string.js#L270))
* **[reverse](#reverse)** ([code](lib/string.js#L414) | [unit tests](test/string.js#L304))
* **[rightAlign](#rightAlign)** ([code](lib/string.js#L432) | [no tests])
* **[replace](#replace)** ([code](lib/string.js#L451) | [unit tests](test/string.js#L343))
* **[titleize](#titleize)** ([code](lib/string.js#Lundefined) | [no tests])
* **[titlecase](#titlecase)** ([code](lib/string.js#L473) | [unit tests](test/string.js#L361))
* **[truncate](#truncate)** ([code](lib/string.js#L492) | [unit tests](test/string.js#L371))
* **[upper](#upper)** ([code](lib/string.js#L509) | [unit tests](test/string.js#L27))
* **[uppercase](#uppercase)** ([code](lib/string.js#L509) | [unit tests](test/string.js#L27))
* **[wordwrap](#wordwrap)** ([code](lib/string.js#L531) | [unit tests](test/string.js#L313))

### array

#### [isArray](lib/array.js#L22)

Returns true if `value` is an array.

**Params**

* `value` **{any}**: The value to test.
* `returns` **{Boolean}**

**Example**

```js
<%= isArray('a, b, c') %>
//=> 'false'

<%= isArray(['a, b, c']) %>
//=> 'true'
```

#### [arrayify](lib/array.js#L46)

Cast `val` to an array.

**Params**

* `val` **{any}**: The value to arrayify.
* `returns` **{Array}**: An array.
* `returns` **{Array}**

**Example**

```js
<%= arrayify('a') %>
//=> '["a"]'

<%= arrayify({a: 'b'}) %>
//=> '[{a: "b"}]'

<%= arrayify(['a']) %>
//=> '["a"]'
```

#### [first](lib/array.js#L64)

Returns the first item, or first `n` items of an array.

**Params**

* `array` **{Array}**
* `n` **{Number}**: Number of items to return, starting at `0`.
* `returns` **{Array}**

**Example**

```js
<%= first(['a', 'b', 'c', 'd', 'e'], 2) %>
//=> '["a", "b"]'
```

#### [last](lib/array.js#L87)

Returns the last item, or last `n` items of an array.

**Params**

* `array` **{Array}**
* `n` **{Number}**: Number of items to return, starting with the last item.
* `returns` **{Array}**

**Example**

```js
<%= last(['a', 'b', 'c', 'd', 'e'], 2) %>
//=> '["d", "e"]'
```

#### [before](lib/array.js#L112)

Returns all of the items in an array up to the specified number Opposite of `<%= after() %`.

**Params**

* `array` **{Array}**
* `n` **{Number}**
* `returns` **{Array}**: Array excluding items after the given number.

**Example**

```js
<%= before(['a', 'b', 'c'], 2) %>
//=> '["a", "b"]'
```

#### [after](lib/array.js#L132)

Returns all of the items in an arry after the specified index. Opposite of `<%= before() %`.

**Params**

* `array` **{Array}**: Collection
* `n` **{Number}**: Starting index (number of items to exclude)
* `returns` **{Array}**: Array exluding `n` items.

**Example**

```js
<%= after(['a', 'b', 'c'], 1) %>
//=> '["c"]'
```

#### [each](lib/array.js#L159)

Calling `fn` on each element of the given `array` with the given `context`.

Assuming that `double` has been registered as a helper:

**Params**

* `array` **{Array}**
* `fn` **{String}**: The function to call on each element in the given array.
* `returns` **{String}**

**Examples**

```js
function double(str) {
  return str + str;
}
```

```js
<%= each(['a', 'b', 'c'], double, ctx) %>
//=> '["aa", "bb", "cc"]'
```

#### [map](lib/array.js#L201)

Returns a new array, created by calling `function` on each element of the given `array`.

Assuming that `double` has been registered as a helper:

**Params**

* `array` **{Array}**
* `fn` **{String}**: The function to call on each element in the given array.
* `returns` **{String}**

**Examples**

```js
function double(str) {
  return str + str;
}
```

```js
<%= map(['a', 'b', 'c'], double) %>
//=> '["aa", "bb", "cc"]'
```

#### [join](lib/array.js#L232)

Join all elements of array into a string, optionally using a given separator.

**Params**

* `array` **{Array}**
* `sep` **{String}**: The separator to use.
* `returns` **{String}**

**Example**

```js
<%= join(['a', 'b', 'c']) %>
//=> 'a, b, c'

<%= join(['a', 'b', 'c'], '-') %>
//=> 'a-b-c'
```

#### [sort](lib/array.js#L257)

Sort the given `array`. If an array of objects is passed, you may optionally pass a `key` to sort on as the second argument. You may alternatively pass a sorting function as the second argument.

**Params**

* `array` **{Array}**: the array to sort.
* `key` **{String|Function}**: The object key to sort by, or sorting function.

**Example**

```js
<%= sort(["b", "a", "c"]) %>
//=> 'a,b,c'

<%= sort([{a: "zzz"}, {a: "aaa"}], "a") %>
//=> '[{"a":"aaa"},{"a":"zzz"}]'
```

#### [length](lib/array.js#L291)

Returns the length of the given array.

**Params**

* `array` **{Array}**
* `returns` **{Number}**: The length of the array.

**Example**

```js
<%= length(['a', 'b', 'c']) %>
//=> 3
```

#### [compact](lib/array.js#L309)

Returns an array with all falsey values removed.

**Params**

* `arr` **{Array}**
* `returns` **{Array}**

**Example**

```js
<%= compact([null, a, undefined, 0, false, b, c, '']) %>
//=> '["a", "b", "c"]'
```

#### [difference](lib/array.js#L328)

Return the difference between the first array and additional arrays.

**Params**

* `array` **{Array}**: The array to compare againts.
* `arrays` **{Array}**: One or more additional arrays.
* `returns` **{Array}**

**Example**

```js
<%= difference(["a", "c"], ["a", "b"]) %>
//=> '["c"]'
```

#### [unique](lib/array.js#L364)

Return an array, free of duplicate values.

**Params**

* `array` **{Array}**: The array to uniquify
* `returns` **{Array}**: Duplicate-free array

**Example**

```js
<%= unique(['a', 'b', 'c', 'c']) %
=> '["a", "b", "c"]'
```

#### [union](lib/array.js#L394)

Returns an array of unique values using strict equality for comparisons.

**Params**

* `arr` **{Array}**
* `returns` **{Array}**

**Example**

```js
<%= union(["a"], ["b"], ["c"]) %>
//=> '["a", "b", "c"]'
```

#### [shuffle](lib/array.js#L411)

Shuffle the items in an array.

**Params**

* `arr` **{Array}**
* `returns` **{Array}**

**Example**

```js
<%= shuffle(["a", "b", "c"]) %>
//=> ["c", "a", "b"]
```

### code

#### [embed](lib/code.js#L24)

Embed code from an external file as preformatted text.

**Params**

* `fp` **{String}**: filepath to the file to embed.
* `language` **{String}**: Optionally specify the language to use for syntax highlighting.
* `returns` **{String}**

**Example**

```js
<%= embed('path/to/file.js') %>

// specify the language to use
<%= embed('path/to/file.hbs', 'html') %>
```

#### [jsfiddle](lib/code.js#L48)

Generate the HTML for a jsFiddle link with the given `params`

**Params**

* `params` **{Object}**
* `returns` **{String}**

**Example**

```js
<%= jsfiddle({id: '0dfk10ks', {tabs: true}}) %>
```

### collection

#### [any](lib/collection.js#L15)

Returns `true` if `value` exists in the given string, array
or object. See [any](https://github.com/jonschlinkert/any) for documentation.

**Params**

* `value` **{any}**
* `target` **{any}**
* `options` **{Object}**

#### [filter](lib/collection.js#L32)

Filter the given array or object to contain only the matching values.

**Params**

* `arr` **{Array}**
* `returns` **{Array}**

**Example**

```js
<%= filter(['foo', 'bar', 'baz']) %>
//=> '["a", "b", "c"]'
```

### conditional

#### [_if](lib/conditional.js#L13)

Return true if `key` is an own, enumerable property
of the given `obj`.

**Params**

* `object` **{Object}**
* `key` **{String}**
* `returns` **{Boolean}**

### fs

#### [exists](lib/fs.js#L19)

Return true if a file exists

**Params**

* `filepath` **{String}**: Path of the file to check.
* `returns` **{Boolean}**: True if the file exists

**Example**

```js
<%= exists("foo.js") %>
```

#### [read](lib/fs.js#L35)

Read a file from the file system and inject its content

**Params**

* `filepath` **{String}**: Path of the file to read.
* `returns` **{String}**: Contents of the given file.

**Example**

```js
<%= read("foo.js") %>
```

### html

#### [escapeHtml](lib/html.js#L18)

Escape HTML characters in a string.

**Params**

* `str` **{String}**: String of HTML with characters to escape.
* `returns` **{String}**

**Example**

```js
<%= escapeHtml("<span>foo</span>") %>
//=> &lt;span&gt;foo&lt;&#x2F;span&gt;
```

#### [sanitize](lib/html.js#L46)

Strip HTML tags from a string, so that only the text nodes are preserved.

**Params**

* `str` **{String}**: The string of HTML to sanitize.
* `returns` **{String}**

**Example**

```js
<%= sanitize("<span>foo</span>") %>
//=> 'foo'
```

### math

#### [add](lib/math.js#L18)

Return the product of `a` plus `b`.

**Params**

* `a` **{Number}**
* `b` **{Number}**

**Example**

```js
<%= add(1, 2) %>
//=> '3'
```

#### [subtract](lib/math.js#L35)

Subtract `b` from `a`.

**Params**

* `a` **{Number}**
* `b` **{Number}**

**Example**

```js
<%= subtract(5, 2) %>
//=> '3'
```

#### [divide](lib/math.js#L53)

Divide `a` (the numerator) by `b` (the divisor).

**Params**

* `a` **{Number}**: the numerator.
* `b` **{Number}**: the divisor.
* `returns` **{Number}**: The quotient of `a` divided by `b`.

**Example**

```js
<%= divide(10, 2) %>
//=> '5'
```

#### [multiply](lib/math.js#L71)

Multiply `a` by `b`.

**Params**

* `a` **{Number}**
* `b` **{Number}**
* `returns` **{Number}**: The product of `a` times `b`.

**Example**

```js
<%= divide(10, 2) %>
//=> '5'
```

#### [floor](lib/math.js#L89)

Returns the largest integer less than or equal to the given `number`.

**Params**

* `number` **{Number}**
* `returns` **{Number}**

**Example**

```js
<%= floor(10.6) %>
//=> '10'
```

#### [ceil](lib/math.js#L107)

Returns the smallest integer greater than or equal to the given `number`.

**Params**

* `number` **{Number}**
* `returns` **{Number}**

**Example**

```js
<%= ceil(10.1) %>
//=> '11'
```

#### [round](lib/math.js#L128)

Returns the value of the given `number` rounded to the nearest integer.

**Params**

* `number` **{Number}**
* `returns` **{Number}**

**Example**

```js
<%= round(10.1) %>
//=> '10'

<%= round(10.5) %>
//=> '11'
```

#### [sum](lib/math.js#L145)

Returns the sum of all numbers in the given array.

**Params**

* `number` **{Number}**
* `returns` **{Number}**

**Example**

```js
<%= sum([1, 2, 3, 4, 5]) %>
//=> '15'
```

### object

#### [fallback](lib/object.js#L22)

Specify a fallback value to use when the desired value is undefined. Note that undefined variables that are _not object properties_ with throw an error.

**Params**

* `a` **{any}**: The desired value.
* `b` **{any}**: The fallback ("default") value
* `returns` **{any}**: Either `a` or `b`

**Example**

```js
// when `title` is undefined, use the generic `site.title`
<%= fallback(page.title, site.title) %>
```

#### [stringify](lib/object.js#L39)

Stringify an object using `JSON.stringify()`.

**Params**

* `object` **{Object}**
* `returns` **{String}**

**Example**

```js
<%= stringify({a: "a"}) %>
//=> '{"a":"a"}'
```

#### [parse](lib/object.js#L56)

Parse a string into an object using `JSON.parse()`.

**Params**

* `str` **{String}**: The string to parse.
* `returns` **{Object}**: The parsed object.

**Example**

```js
<%= parse('{"foo":"bar"}')["foo"] %>
//=> 'bar'
```

#### [get](lib/object.js#L74)

Use property paths (`a.b.c`) get a nested value from an object.

**Params**

* `object` **{Object}**
* `path` **{String}**: Dot notation for the property to get.
* `returns` **{String}**

**Example**

```js
<%= get({a: {b: 'c'}}, 'a.b') %>
//=> 'c'
```

#### [keys](lib/object.js#L91)

Returns an array of keys from the given `object`.

**Params**

* `object` **{Object}**
* `returns` **{Array}**: Keys from `object`

**Example**

```js
<%= keys({a: 'b', c: 'd'}) %>
//=> '["a", "c"]'
```

#### [isObject](lib/object.js#L112)

Return true if the given `value` is an object, and not `null` or an array.

**Params**

* `value` **{Object}**: The value to check.
* `returns` **{Boolean}**

**Example**

```js
<%= isObject(['a', 'b', 'c']) %>
//=> 'false'

<%= isObject({a: 'b'}) %>
//=> 'true'
```

#### [isPlainObject](lib/object.js#L135)

Return true if the given `value` is a plain object.

**Params**

* `value` **{Object}**: The value to check.
* `returns` **{Boolean}**

**Example**

```js
<%= isPlainObject(['a', 'b', 'c']) %>
//=> 'false'

<%= isPlainObject({a: 'b'}) %>
//=> 'true'

<%= isPlainObject(/foo/g) %>
//=> 'false'
```

#### [hasOwn](lib/object.js#L149)

Return true if `key` is an own, enumerable property
of the given `obj`.

**Params**

* `object` **{Object}**
* `key` **{String}**
* `returns` **{Boolean}**

#### [omit](lib/object.js#L167)

Return a copy of `object` exclusing the given `keys`.

**Params**

* `object` **{Object}**: Object with keys to omit.
* `keys` **{String}**: Keys to omit.
* `returns` **{Boolean}**

**Example**

```js
<%= omit({a: 'a', b: 'b', c: 'c'}, ['a', 'c']) %>
//=> '{b: "b"}'
```

#### [forIn](lib/object.js#L185)

Return a copy of `object` exclusing the given `keys`.

**Params**

* `object` **{Object}**: Object with keys to omit.
* `keys` **{String}**: Keys to omit.
* `returns` **{Boolean}**

**Example**

```js
<%= omit({a: 'a', b: 'b', c: 'c'}, ['a', 'c']) %>
//=> '{b: "b"}'
```

#### [forOwn](lib/object.js#L207)

Return a copy of `object` exclusing the given `keys`.

**Params**

* `object` **{Object}**: Object with keys to omit.
* `keys` **{String}**: Keys to omit.
* `returns` **{Boolean}**

**Example**

```js
<%= omit({a: 'a', b: 'b', c: 'c'}, ['a', 'c']) %>
//=> '{b: "b"}'
```

#### [extend](lib/object.js#L224)

Extend `o` with properties of other `objects`.

**Params**

* `o` **{Object}**: The target object. Pass an empty object to shallow clone.
* `objects` **{Object}**
* `returns` **{Object}**

#### [merge](lib/object.js#L257)

Recursively combine the properties of `o` with the
properties of other `objects`.

**Params**

* `o` **{Object}**: The target object. Pass an empty object to shallow clone.
* `objects` **{Object}**
* `returns` **{Object}**

### path

#### [dirname](lib/path.js#L20)

Return the dirname for the given `filepath`. Uses the node.js [path](https://nodejs.org/api/path.html) module.

**Params**

* `filepath` **{String}**
* `returns` **{String}**: Returns the directory part of the file path.

**Example**

```js
<%= dirname("a/b/c/d") %>
//=> 'a/b/c'
```

#### [basename](lib/path.js#L38)

Return the basename for the given `filepath`. Uses the node.js [path](https://nodejs.org/api/path.html) module.

**Params**

* `filepath` **{String}**
* `returns` **{String}**: Returns the basename part of the file path.

**Example**

```js
<%= basename("a/b/c/d.js") %>
//=> 'd.js'
```

#### [filename](lib/path.js#L56)

Return the filename for the given `filepath`, excluding extension.

**Params**

* `filepath` **{String}**
* `returns` **{String}**: Returns the file name part of the file path.

**Example**

```js
<%= basename("a/b/c/d.js") %>
//=> 'd'
```

#### [extname](lib/path.js#L74)

Return the file extension for the given `filepath`. Uses the node.js [path](https://nodejs.org/api/path.html) module.

**Params**

* `filepath` **{String}**
* `returns` **{String}**: Returns a file extension

**Example**

```js
<%= extname("foo.js") %>
//=> '.js'
```

#### [ext](lib/path.js#L92)

Return the file extension for the given `filepath`, excluding the `.`.

**Params**

* `filepath` **{String}**
* `returns` **{String}**: Returns a file extension without dot.

**Example**

```js
<%= ext("foo.js") %>
//=> 'js'
```

#### [resolve](lib/path.js#L110)

Resolves the given paths to an absolute path. Uses the node.js [path](https://nodejs.org/api/path.html) module.

**Params**

* `filepath` **{String}**
* `returns` **{String}**: Returns a resolve

**Example**

```js
<%= resolve('/foo/bar', './baz') %>
//=> '/foo/bar/baz'
```

#### [relative](lib/path.js#L129)

Get the relative path from file `a` to file `b`. Typically `a` and `b` would be variables passed on the context. Uses the node.js [path](https://nodejs.org/api/path.html) module.

**Params**

* `a` **{String}**: The "from" file path.
* `b` **{String}**: The "to" file path.
* `returns` **{String}**: Returns a relative path.

**Example**

```js
<%= relative(a, b) %>
```

#### [segments](lib/path.js#L160)

Get specific (joined) segments of a file path by passing a range of array indices.

**Params**

* `filepath` **{String}**: The file path to split into segments.
* `returns` **{String}**: Returns a single, joined file path.

**Example**

```js
<%= segments("a/b/c/d", "2", "3") %>
//=> 'c/d'

<%= segments("a/b/c/d", "1", "3") %>
//=> 'b/c/d'

<%= segments("a/b/c/d", "1", "2") %>
//=> 'b/c'
```

#### [join](lib/path.js#L182)

Join all arguments together and normalize the resulting `filepath`. Uses the node.js [path](https://nodejs.org/api/path.html) module.

**Note**: there is also a `join()` array helper, dot notation
can be used with helpers to differentiate. Example: `<%= path.join() %>`.

**Params**

* `filepaths` **{String}**: List of file paths.
* `returns` **{String}**: Returns a single, joined file path.

**Example**

```js
<%= join("a", "b") %>
//=> 'a/b'
```

#### [isAbsolute](lib/path.js#L217)

Returns true if a file path is an absolute path. An absolute path will always resolve to the same location, regardless of the working directory. Uses the node.js [path](https://nodejs.org/api/path.html) module.

**Params**

* `filepath` **{String}**
* `returns` **{String}**: Returns a resolve

**Example**

```js
// posix
<%= isAbsolute('/foo/bar') %>
//=> 'true'
<%= isAbsolute('qux/') %>
//=> 'false'
<%= isAbsolute('.') %>
//=> 'false'

// Windows
<%= isAbsolute('//server') %>
//=> 'true'
<%= isAbsolute('C:/foo/..') %>
//=> 'true'
<%= isAbsolute('bar\\baz') %>
//=> 'false'
<%= isAbsolute('.') %>
//=> 'false'
```

#### [isRelative](lib/path.js#L252)

Returns true if a file path is an absolute path. An absolute path will always resolve to the same location, regardless of the working directory. Uses the node.js [path](https://nodejs.org/api/path.html) module.

**Params**

* `filepath` **{String}**
* `returns` **{String}**: Returns a resolve

**Example**

```js
// posix
<%= isRelative('/foo/bar') %>
//=> 'false'
<%= isRelative('qux/') %>
//=> 'true'
<%= isRelative('.') %>
//=> 'true'

// Windows
<%= isRelative('//server') %>
//=> 'false'
<%= isRelative('C:/foo/..') %>
//=> 'false'
<%= isRelative('bar\\baz') %>
//=> 'true'
<%= isRelative('.') %>
//=> 'true'
```

### string

#### [camelcase](lib/string.js#L18)

camelCase the characters in `string`.

**Params**

* `string` **{String}**: The string to camelcase.
* `returns` **{String}**

**Example**

```js
<%= camelcase("foo bar baz") %>
//=> 'fooBarBaz'
```

#### [centerAlign](lib/string.js#L45)

Center align the characters in a string using non-breaking spaces.

**Params**

* `str` **{String}**: The string to reverse.
* `returns` **{String}**: Centered string.

**Example**

```js
<%= centerAlign("abc") %>
```

#### [chop](lib/string.js#L69)

Like trim, but removes both extraneous whitespace and non-word characters from the beginning and end of a string.

**Params**

* `string` **{String}**: The string to chop.
* `returns` **{String}**

**Example**

```js
<%= chop("_ABC_") %>
//=> 'ABC'

<%= chop("-ABC-") %>
//=> 'ABC'

<%= chop(" ABC ") %>
//=> 'ABC'
```

#### [count](lib/string.js#L90)

Count the number of occurrances of a substring within a string.

**Params**

* `string` **{String}**
* `substring` **{String}**
* `returns` **{Number}**: The occurances of `substring` in `string`

**Example**

```js
<%= count("abcabcabc", "a") %>
//=> '3'
```

#### [dotcase](lib/string.js#L110)

dot.case the characters in `string`.

**Params**

* `string` **{String}**
* `returns` **{String}**

**Example**

```js
<%= dotcase("a-b-c d_e") %>
//=> 'a.b.c.d.e'
```

#### [ellipsis](lib/string.js#L135)

Truncate a string to the specified `length`, and append it with an elipsis, `…`.

**Params**

* `str` **{String}**
* `length` **{Number}**: The desired length of the returned string.
* `ch` **{String}**: Optionally pass custom characters to append. Default is `…`.
* `returns` **{String}**: The truncated string.

**Example**

```js
<%= ellipsis("<span>foo bar baz</span>", 7) %>
//=> 'foo bar…'
```

#### [isString](lib/string.js#L157)

Returns true if the value is a string.

**Params**

* `val` **{String}**
* `returns` **{Boolean}**: True if the value is a string.

**Example**

```js
<%= isString('abc') %>
//=> 'true'

<%= isString(null) %>
//=> 'false'
```

#### [lowercase](lib/string.js#L174)

Lowercase the characters in the given `string`.

**Params**

* `string` **{String}**: The string to lowercase.
* `returns` **{String}**

**Example**

```js
<%= lowercase("ABC") %>
//=> 'abc'
```

#### [pascalcase](lib/string.js#L191)

PascalCase the characters in `string`.

**Params**

* `string` **{String}**
* `returns` **{String}**

**Example**

```js
<%= pascalcase("foo bar baz") %>
//=> 'FooBarBaz'
```

#### [snakecase](lib/string.js#L211)

snake_case the characters in `string`.

**Params**

* `string` **{String}**
* `returns` **{String}**

**Example**

```js
<%= snakecase("a-b-c d_e") %>
//=> 'a_b_c_d_e'
```

#### [split](lib/string.js#L233)

Split `string` by the given `character`.

**Params**

* `string` **{String}**: The string to split.
* `returns` **{String}** `character`: Default is `,`

**Example**

```js
<%= split("a,b,c", ",") %>
//=> ['a', 'b', 'c']
```

#### [strip](lib/string.js#L250)

Strip `substring` from the given `string`.

**Params**

* `substring` **{String|RegExp}**: The string or regex pattern of the substring to remove.
* `string` **{String}**: The target string.

**Example**

```js
<%= strip("foo-bar", "foo-") %>
//=> 'bar'
```

#### [stripIndent](lib/string.js#L269)

Strip the indentation from a `string`.

**Params**

* `string` **{String}**: The string to strip indentation from.
* `returns` **{String}**

**Example**

```js
<%= stripIndent("  _ABC_") %>
//=> 'ABC'
```

#### [trim](lib/string.js#L298)

Trim extraneous whitespace from the beginning and end of a string.

**Params**

* `string` **{String}**: The string to trim.
* `returns` **{String}**

**Example**

```js
<%= trim("  ABC   ") %>
//=> 'ABC'
```

#### [dashcase](lib/string.js#L317)

dash-case the characters in `string`. This is similar to [slugify](https://github.com/simov/slugify), but [slugify](https://github.com/simov/slugify) makes the string compatible to be used as a URL slug.

**Params**

* `string` **{String}**
* `returns` **{String}**

**Example**

```js
<%= dashcase("a b.c d_e") %>
//=> 'a-b-c-d-e'
```

#### [pathcase](lib/string.js#L339)

path/case the characters in `string`.

**Params**

* `string` **{String}**
* `returns` **{String}**

**Example**

```js
<%= pathcase("a-b-c d_e") %>
//=> 'a/b/c/d/e'
```

#### [sentencecase](lib/string.js#L361)

Sentence-case the characters in `string`.

**Params**

* `string` **{String}**
* `returns` **{String}**

**Example**

```js
<%= sentencecase("foo bar baz.") %>
//=> 'Foo bar baz.'
```

#### [hyphenate](lib/string.js#L380)

Replace spaces in a string with hyphens. This

**Params**

* `string` **{String}**
* `returns` **{String}**

**Example**

```js
<%= hyphenate("a b c") %>
//=> 'a-b-c'
```

#### [reverse](lib/string.js#L414)

Reverse the characters in a string.

**Params**

* `str` **{String}**: The string to reverse.
* `returns` **{String}**

**Example**

```js
<%= reverse("abc") %>
//=> 'cba'
```

#### [rightAlign](lib/string.js#L432)

Right align the characters in a string using non-breaking spaces.

**Params**

* `str` **{String}**: The string to reverse.
* `returns` **{String}**: Right-aligned string.

**Example**

```js
<%= rightAlign(str) %>
```

#### [replace](lib/string.js#L451)

Replace occurrences of `a` with `b`.

**Params**

* `str` **{String}**
* `a` **{String|RegExp}**: Can be a string or regexp.
* `b` **{String}**
* `returns` **{String}**

**Example**

```js
<%= replace("abcabc", /a/, "z") %>
//=> 'zbczbc'
```

#### [titlecase](lib/string.js#L473)

Truncate a string by removing all HTML tags and limiting the result to the specified `length`.

**Params**

* `str` **{String}**
* `length` **{Number}**: The desired length of the returned string.
* `returns` **{String}**: The truncated string.

**Example**

```js
<%= titlecase("big deal") %>
//=> 'foo bar'
```

#### [truncate](lib/string.js#L492)

Truncate a string by removing all HTML tags and limiting the result to the specified `length`.

**Params**

* `str` **{String}**
* `length` **{Number}**: The desired length of the returned string.
* `returns` **{String}**: The truncated string.

**Example**

```js
<%= truncate("<span>foo bar baz</span>", 7) %>
//=> 'foo bar'
```

#### [uppercase](lib/string.js#L509)

Uppercase the characters in a string.

**Params**

* `string` **{String}**: The string to uppercase.
* `returns` **{String}**

**Example**

```js
<%= uppercase("abc") %>
//=> 'ABC'
```

#### [wordwrap](lib/string.js#L531)

Wrap words to a specified width using [word-wrap](https://github.com/jonschlinkert/word-wrap).

**Params**

* `string` **{String}**: The string with words to wrap.
* `object` **{Options}**: Options to pass to [word-wrap](https://github.com/jonschlinkert/word-wrap)
* `returns` **{String}**: Formatted string.

**Example**

```js
<%= wordwrap("a b c d e f", {width: 5, newline: '<br>  '}) %>
//=> '  a b c <br>  d e f'
```

### Code coverage

```
Statements   : 94.61% ( 439/464 )
Branches     : 88.37% ( 190/215 )
Functions    : 96.94% ( 95/98 )
Lines        : 94.42% ( 389/412 )
```

## About

### Related projects

* [assemble](https://www.npmjs.com/package/assemble): Get the rocks out of your socks! Assemble makes you fast at creating web projects… [more](https://github.com/assemble/assemble) | [homepage](https://github.com/assemble/assemble "Get the rocks out of your socks! Assemble makes you fast at creating web projects. Assemble is used by thousands of projects for rapid prototyping, creating themes, scaffolds, boilerplates, e-books, UI components, API documentation, blogs, building websit")
* [handlebars-helpers](https://www.npmjs.com/package/handlebars-helpers): More than 130 Handlebars helpers in ~20 categories. Helpers can be used with Assemble, Generate… [more](https://github.com/assemble/handlebars-helpers) | [homepage](https://github.com/assemble/handlebars-helpers "More than 130 Handlebars helpers in ~20 categories. Helpers can be used with Assemble, Generate, Verb, Ghost, gulp-handlebars, grunt-handlebars, consolidate, or any node.js/Handlebars project.")
* [helper-cache](https://www.npmjs.com/package/helper-cache): Easily register and get helper functions to be passed to any template engine or node.js… [more](https://github.com/jonschlinkert/helper-cache) | [homepage](https://github.com/jonschlinkert/helper-cache "Easily register and get helper functions to be passed to any template engine or node.js application. Methods for both sync and async helpers.")
* [template](https://www.npmjs.com/package/template): Render templates using any engine. Supports, layouts, pages, partials and custom template types. Use template… [more](https://github.com/jonschlinkert/template) | [homepage](https://github.com/jonschlinkert/template "Render templates using any engine. Supports, layouts, pages, partials and custom template types. Use template helpers, middleware, routes, loaders, and lots more. Powers assemble, verb and other node.js apps.")
* [utils](https://www.npmjs.com/package/utils): Fast, generic JavaScript/node.js utility functions. | [homepage](https://github.com/jonschlinkert/utils "Fast, generic JavaScript/node.js utility functions.")
* [verb](https://www.npmjs.com/package/verb): Documentation generator for GitHub projects. Verb is extremely powerful, easy to use, and is used… [more](https://github.com/verbose/verb) | [homepage](https://github.com/verbose/verb "Documentation generator for GitHub projects. Verb is extremely powerful, easy to use, and is used on hundreds of projects of all sizes to generate everything from API docs to readmes.")

### Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

### Building docs

_(This document was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme) (a [verb](https://github.com/verbose/verb) generator), please don't edit the readme directly. Any changes to the readme must be made in [.verb.md](.verb.md).)_

To generate the readme and API documentation with [verb](https://github.com/verbose/verb):

```sh
$ npm install -g verb verb-generate-readme && verb
```

### Running tests

Install dev dependencies:

```sh
$ npm install -d && npm test
```

### Author

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](http://twitter.com/jonschlinkert)

### License

Copyright © 2016, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT license](https://github.com/jonschlinkert/template-helpers/blob/master/LICENSE).

***

_This file was generated by [verb](https://github.com/verbose/verb), v0.9.0, on July 19, 2016._