/**
    * @license
    * Copyright 2019 Google LLC. All Rights Reserved.
    * Licensed under the Apache License, Version 2.0 (the "License");
    * you may not use this file except in compliance with the License.
    * You may obtain a copy of the License at
    *
    * http://www.apache.org/licenses/LICENSE-2.0
    *
    * Unless required by applicable law or agreed to in writing, software
    * distributed under the License is distributed on an "AS IS" BASIS,
    * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    * See the License for the specific language governing permissions and
    * limitations under the License.
    * =============================================================================
    */
import*as tf from"@tensorflow/tfjs-core";import{tidy,util,oneHot,scalar,range,Tensor,browser,pad3d,slice3d,div,sub}from"@tensorflow/tfjs-core";import{loadGraphModel}from"@tensorflow/tfjs-converter";function __awaiter(e,t,r,a){return new(r||(r=Promise))(function(n,o){function i(e){try{d(a.next(e))}catch(e){o(e)}}function s(e){try{d(a.throw(e))}catch(e){o(e)}}function d(e){e.done?n(e.value):new r(function(t){t(e.value)}).then(i,s)}d((a=a.apply(e,t||[])).next())})}function __generator(e,t){var r,a,n,o,i={label:0,sent:function(){if(1&n[0])throw n[1];return n[1]},trys:[],ops:[]};return o={next:s(0),throw:s(1),return:s(2)},"function"==typeof Symbol&&(o[Symbol.iterator]=function(){return this}),o;function s(o){return function(s){return function(o){if(r)throw new TypeError("Generator is already executing.");for(;i;)try{if(r=1,a&&(n=2&o[0]?a.return:o[0]?a.throw||((n=a.return)&&n.call(a),0):a.next)&&!(n=n.call(a,o[1])).done)return n;switch(a=0,n&&(o=[2&o[0],n.value]),o[0]){case 0:case 1:n=o;break;case 4:return i.label++,{value:o[1],done:!1};case 5:i.label++,a=o[1],o=[0];continue;case 7:o=i.ops.pop(),i.trys.pop();continue;default:if(!(n=(n=i.trys).length>0&&n[n.length-1])&&(6===o[0]||2===o[0])){i=0;continue}if(3===o[0]&&(!n||o[1]>n[0]&&o[1]<n[3])){i.label=o[1];break}if(6===o[0]&&i.label<n[1]){i.label=n[1],n=o;break}if(n&&i.label<n[2]){i.label=n[2],i.ops.push(o);break}n[2]&&i.ops.pop(),i.trys.pop();continue}o=t.call(e,i)}catch(e){o=[6,e],a=0}finally{r=n=0}if(5&o[0])throw o[1];return{value:o[0]?o[1]:void 0,done:!0}}([o,s])}}}var mobileNet100Architecture=[["conv2d",2],["separableConv",1],["separableConv",2],["separableConv",1],["separableConv",2],["separableConv",1],["separableConv",2],["separableConv",1],["separableConv",1],["separableConv",1],["separableConv",1],["separableConv",1],["separableConv",2],["separableConv",1]],mobileNet75Architecture=[["conv2d",2],["separableConv",1],["separableConv",2],["separableConv",1],["separableConv",2],["separableConv",1],["separableConv",2],["separableConv",1],["separableConv",1],["separableConv",1],["separableConv",1],["separableConv",1],["separableConv",1],["separableConv",1]],mobileNet50Architecture=[["conv2d",2],["separableConv",1],["separableConv",2],["separableConv",1],["separableConv",2],["separableConv",1],["separableConv",2],["separableConv",1],["separableConv",1],["separableConv",1],["separableConv",1],["separableConv",1],["separableConv",1],["separableConv",1]],mobileNet25Architecture=mobileNet50Architecture,VALID_OUTPUT_STRIDES=[8,16,32];function assertValidOutputStride(e){util.assert("number"==typeof e,function(){return"outputStride is not a number"}),util.assert(VALID_OUTPUT_STRIDES.indexOf(e)>=0,function(){return"outputStride of "+e+" is invalid. It must be either 8, 16, or 32"})}var mobileNetArchitectures={100:mobileNet100Architecture,75:mobileNet75Architecture,50:mobileNet50Architecture,25:mobileNet25Architecture};function toOutputStridedLayers(e,t){var r=1,a=1;return e.map(function(e,n){var o,i,s=e[0],d=e[1];return r===t?(o=1,i=a,a*=d):(o=d,i=1,r*=d),{blockId:n,convType:s,stride:o,rate:i,outputStride:r}})}var MobileNet=function(){function e(e,t){this.PREPROCESS_DIVISOR=scalar(127.5),this.ONE=scalar(1),this.modelWeights=e,this.convolutionDefinitions=t}return e.prototype.predict=function(e,t){var r=this,a=div(e.toFloat(),this.PREPROCESS_DIVISOR),n=sub(a,this.ONE);return toOutputStridedLayers(this.convolutionDefinitions,t).reduce(function(e,t){var a=t.blockId,n=t.stride,o=t.convType,i=t.rate;if("conv2d"===o)return r.conv(e,n,a);if("separableConv"===o)return r.separableConv(e,n,a,i);throw Error("Unknown conv type of "+o)},n)},e.prototype.convToOutput=function(e,t){return e.conv2d(this.weights(t),1,"same").add(this.convBias(t,!1))},e.prototype.conv=function(e,t,r){var a=this.weights("Conv2d_"+String(r));return e.conv2d(a,t,"same").add(this.convBias("Conv2d_"+String(r))).clipByValue(0,6)},e.prototype.separableConv=function(e,t,r,a){void 0===a&&(a=1);var n="Conv2d_"+String(r)+"_depthwise",o="Conv2d_"+String(r)+"_pointwise";return e.depthwiseConv2D(this.depthwiseWeights(n),t,"same","NHWC",a).add(this.depthwiseBias(n)).clipByValue(0,6).conv2d(this.weights(o),[1,1],"same").add(this.convBias(o)).clipByValue(0,6)},e.prototype.weights=function(e){return this.modelWeights.weights(e)},e.prototype.convBias=function(e,t){return void 0===t&&(t=!0),this.modelWeights.convBias(e,t)},e.prototype.depthwiseBias=function(e){return this.modelWeights.depthwiseBias(e)},e.prototype.depthwiseWeights=function(e){return this.modelWeights.depthwiseWeights(e)},e.prototype.dispose=function(){this.modelWeights.dispose()},e}(),BASE_URL="https://storage.googleapis.com/tfjs-models/savedmodel/",checkpoints={1:{url:BASE_URL+"posenet_mobilenet_100_partmap/",architecture:mobileNetArchitectures[100]},.75:{url:BASE_URL+"posenet_mobilenet_075_partmap/",architecture:mobileNetArchitectures[75]},.5:{url:BASE_URL+"posenet_mobilenet_050_partmap/",architecture:mobileNetArchitectures[50]},.25:{url:BASE_URL+"posenet_mobilenet_025_partmap/",architecture:mobileNetArchitectures[25]}};function toFlattenedOneHotPartMap(e){var t=e.shape[2],r=e.argMax(2).reshape([-1]);return oneHot(r,t)}function clipByMask2d(e,t){return e.mul(t)}function toMask(e,t){return tidy(function(){return e.greater(scalar(t)).toInt()})}function decodePartSegmentation(e,t){var r=t.shape,a=r[0],n=r[1],o=r[2];return tidy(function(){var r=toFlattenedOneHotPartMap(t),i=range(0,o,1,"int32").expandDims(1);return clipByMask2d(r.matMul(i).toInt().reshape([a,n]).add(scalar(1,"int32")),e).sub(scalar(1,"int32"))})}var ModelWeights=function(){function e(e){this.graphModel=e}return e.prototype.weights=function(e){return this.getVariable("MobilenetV1/"+e+"/weights")},e.prototype.convBias=function(e,t){return void 0===t&&(t=!0),this.getVariable("MobilenetV1/"+e+"/Conv2D_bias")},e.prototype.depthwiseBias=function(e){return this.getVariable("MobilenetV1/"+e+"/depthwise_bias")},e.prototype.depthwiseWeights=function(e){return this.getVariable("MobilenetV1/"+e+"/depthwise_weights")},e.prototype.getVariable=function(e){return this.graphModel.weights[""+e][0]},e.prototype.dispose=function(){this.graphModel.dispose()},e}();function toInputTensor(e){return e instanceof Tensor?e:browser.fromPixels(e)}function resizeAndPadTo(e,t,r){var a=t[0],n=t[1];void 0===r&&(r=!1);var o,i,s,d,u,l,c=e.shape,p=c[0],h=c[1]/p;if(h>n/a){o=n;var f=a-(i=Math.ceil(o/h));s=0,d=0,u=Math.floor(f/2),l=a-(i+u)}else{i=a;var v=n-(o=Math.ceil(a*h));s=Math.floor(v/2),d=n-(o+s),u=0,l=0}return{resizedAndPadded:tidy(function(){var t;return t=r?e.reverse(1).resizeBilinear([i,o]):e.resizeBilinear([i,o]),pad3d(t,[[u,l],[s,d],[0,0]])}),paddedBy:[[u,l],[s,d]]}}function scaleAndCropToInputTensorShape(e,t,r,a){var n=t[0],o=t[1],i=r[0],s=r[1],d=a[0],u=d[0],l=d[1],c=a[1],p=c[0],h=c[1];return tidy(function(){return removePaddingAndResizeBack(e.resizeBilinear([i,s],!0),[n,o],[[u,l],[p,h]])})}function removePaddingAndResizeBack(e,t,r){var a=t[0],n=t[1],o=r[0],i=o[0],s=o[1],d=r[1],u=d[0],l=d[1],c=e.shape,p=c[0],h=c[1],f=p-(i+s),v=h-(u+l);return tidy(function(){return slice3d(e,[i,u,0],[f,v,e.shape[2]]).resizeBilinear([a,n],!0)})}var _this=void 0,segmentationModelImageDimensions=[353,257],BodyPix=function(){function e(e){this.mobileNet=e}return e.prototype.predictForSegmentation=function(e,t){var r=this;return void 0===t&&(t=16),assertValidOutputStride(t),tidy(function(){var a=r.mobileNet.predict(e,t);return r.mobileNet.convToOutput(a,"segment_2").sigmoid()})},e.prototype.predictForPartMap=function(e,t){var r=this;return void 0===t&&(t=16),assertValidOutputStride(t),tidy(function(){var a=r.mobileNet.predict(e,t),n=r.mobileNet.convToOutput(a,"segment_2"),o=r.mobileNet.convToOutput(a,"part_heatmap_2");return{segmentScores:n.sigmoid(),partHeatmapScores:o.sigmoid()}})},e.prototype.estimatePersonSegmentationActivation=function(e,t,r){var a=this;return void 0===t&&(t=16),void 0===r&&(r=.5),assertValidOutputStride(t),tidy(function(){var n=toInputTensor(e),o=resizeAndPadTo(n,segmentationModelImageDimensions),i=o.resizedAndPadded,s=o.paddedBy,d=a.predictForSegmentation(i,t),u=i.shape,l=u[0],c=u[1],p=n.shape;return toMask(scaleAndCropToInputTensorShape(d,[p[0],p[1]],[l,c],s).squeeze(),r)})},e.prototype.estimatePersonSegmentation=function(e,t,r){return void 0===t&&(t=16),void 0===r&&(r=.5),__awaiter(this,void 0,void 0,function(){var a,n,o,i,s;return __generator(this,function(d){switch(d.label){case 0:return a=this.estimatePersonSegmentationActivation(e,t,r),n=a.shape,o=n[0],i=n[1],[4,a.data()];case 1:return s=d.sent(),a.dispose(),[2,{height:o,width:i,data:s}]}})})},e.prototype.estimatePartSegmentationActivation=function(e,t,r){var a=this;return void 0===t&&(t=16),void 0===r&&(r=.5),assertValidOutputStride(t),tidy(function(){var n=toInputTensor(e),o=resizeAndPadTo(n,segmentationModelImageDimensions),i=o.resizedAndPadded,s=o.paddedBy,d=a.predictForPartMap(i,t),u=d.segmentScores,l=d.partHeatmapScores,c=i.shape,p=c[0],h=c[1],f=n.shape,v=f[0],m=f[1],g=scaleAndCropToInputTensorShape(u,[v,m],[p,h],s),b=scaleAndCropToInputTensorShape(l,[v,m],[p,h],s);return decodePartSegmentation(toMask(g.squeeze(),r),b)})},e.prototype.estimatePartSegmentation=function(e,t,r){return void 0===t&&(t=16),void 0===r&&(r=.5),__awaiter(this,void 0,void 0,function(){var a,n,o,i,s;return __generator(this,function(d){switch(d.label){case 0:return a=this.estimatePartSegmentationActivation(e,t,r),n=a.shape,o=n[0],i=n[1],[4,a.data()];case 1:return s=d.sent(),a.dispose(),[2,{height:o,width:i,data:s}]}})})},e.prototype.dispose=function(){this.mobileNet.dispose()},e}();function load(e){return void 0===e&&(e=.75),__awaiter(this,void 0,void 0,function(){var t,r;return __generator(this,function(a){switch(a.label){case 0:if(null==tf)throw new Error("Cannot find TensorFlow.js. If you are using a <script> tag, please also include @tensorflow/tfjs on the page before using this model.");return t=Object.keys(checkpoints),util.assert("number"==typeof e,function(){return"got multiplier type of "+typeof e+" when it should be a number."}),util.assert(t.indexOf(e.toString())>=0,function(){return"invalid multiplier value of "+e+".  No checkpoint exists for that multiplier. Must be one of "+t.join(",")+"."}),[4,mobilenetLoader.load(e)];case 1:return r=a.sent(),[2,new BodyPix(r)]}})})}var mobilenetLoader={load:function(e){return __awaiter(_this,void 0,void 0,function(){var t,r,a,n;return __generator(this,function(o){switch(o.label){case 0:return t=checkpoints[e],r=t.url,[4,loadGraphModel(r+"model.json")];case 1:return a=o.sent(),n=new ModelWeights(a),[2,new MobileNet(n,t.architecture)]}})})}};function cpuBlur(e,t,r){for(var a=e.getContext("2d"),n=0,o=1/(2*Math.PI*5*5),i=r<3?1:2,s=-r;s<=r;s+=i)for(var d=-r;d<=r;d+=i){n+=o*Math.exp(-(d*d+s*s)/50)}for(s=-r;s<=r;s+=i)for(d=-r;d<=r;d+=i)a.globalAlpha=o*Math.exp(-(d*d+s*s)/50)/n*r,a.drawImage(t,d,s);a.globalAlpha=1}var offScreenCanvases={};function isSafari(){return/^((?!chrome|android).)*safari/i.test(navigator.userAgent)}function assertSameDimensions(e,t,r,a){var n=e.width,o=e.height,i=t.width,s=t.height;if(n!==i||o!==s)throw new Error("error: dimensions must match. "+r+" has dimensions "+n+"x"+o+", "+a+" has dimensions "+i+"x"+s)}function flipCanvasHorizontal(e){var t=e.getContext("2d");t.scale(-1,1),t.translate(-e.width,0)}function drawWithCompositing(e,t,r){e.globalCompositeOperation=r,e.drawImage(t,0,0)}function createOffScreenCanvas(){return document.createElement("canvas")}function ensureOffscreenCanvasCreated(e){return offScreenCanvases[e]||(offScreenCanvases[e]=createOffScreenCanvas()),offScreenCanvases[e]}function drawAndBlurImageOnCanvas(e,t,r){var a=e.height,n=e.width,o=r.getContext("2d");r.width=n,r.height=a,o.clearRect(0,0,n,a),o.save(),isSafari()?cpuBlur(r,e,t):(o.filter="blur("+t+"px)",o.drawImage(e,0,0,n,a)),o.restore()}function drawAndBlurImageOnOffScreenCanvas(e,t,r){var a=ensureOffscreenCanvasCreated(r);return 0===t?renderImageToCanvas(e,a):drawAndBlurImageOnCanvas(e,t,a),a}function renderImageToCanvas(e,t){var r=e.width,a=e.height;t.width=r,t.height=a,t.getContext("2d").drawImage(e,0,0,r,a)}function renderImageDataToCanvas(e,t){t.width=e.width,t.height=e.height,t.getContext("2d").putImageData(e,0,0)}function renderImageDataToOffScreenCanvas(e,t){var r=ensureOffscreenCanvasCreated(t);return renderImageDataToCanvas(e,r),r}function toMaskImageData(e,t){void 0===t&&(t=!0);for(var r=e.width,a=e.height,n=e.data,o=new Uint8ClampedArray(r*a*4),i=0;i<a*r;++i){var s=255*(t?1-n[i]:n[i]),d=4*i;o[d+0]=0,o[d+1]=0,o[d+2]=0,o[d+3]=Math.round(s)}return new ImageData(o,r,a)}function toColoredPartImageData(e,t){for(var r=e.width,a=e.height,n=e.data,o=new Uint8ClampedArray(r*a*4),i=0;i<a*r;++i){var s=Math.round(n[i]),d=4*i;if(-1===s)o[d+0]=255,o[d+1]=255,o[d+2]=255,o[d+3]=255;else{var u=t[s];if(!u)throw new Error("No color could be found for part id "+s);o[d+0]=u[0],o[d+1]=u[1],o[d+2]=u[2],o[d+3]=255}}return new ImageData(o,r,a)}var CANVAS_NAMES={blurred:"blurred",blurredMask:"blurred-mask",mask:"mask",lowresPartMask:"lowres-part-mask"};function drawMask(e,t,r,a,n,o){void 0===a&&(a=.7),void 0===n&&(n=0),void 0===o&&(o=!1),assertSameDimensions(t,r,"image","mask");var i=drawAndBlurImageOnOffScreenCanvas(renderImageDataToOffScreenCanvas(r,CANVAS_NAMES.mask),n,CANVAS_NAMES.blurredMask);e.width=i.width,e.height=i.height;var s=e.getContext("2d");s.save(),o&&flipCanvasHorizontal(e),s.drawImage(t,0,0),s.globalAlpha=a,s.drawImage(i,0,0),s.restore()}function drawPixelatedMask(e,t,r,a,n,o,i){void 0===a&&(a=.7),void 0===n&&(n=0),void 0===o&&(o=!1),void 0===i&&(i=10),assertSameDimensions(t,r,"image","mask");var s=drawAndBlurImageOnOffScreenCanvas(renderImageDataToOffScreenCanvas(r,CANVAS_NAMES.mask),n,CANVAS_NAMES.blurredMask);e.width=s.width,e.height=s.height;var d=e.getContext("2d");d.save(),o&&flipCanvasHorizontal(e);var u=ensureOffscreenCanvasCreated(CANVAS_NAMES.lowresPartMask),l=u.getContext("2d");u.width=s.width*(1/i),u.height=s.height*(1/i),l.drawImage(s,0,0,s.width,s.height,0,0,u.width,u.height),d.imageSmoothingEnabled=!1,d.drawImage(u,0,0,u.width,u.height,0,0,e.width,e.height);for(var c=0;c<u.width;c++)d.beginPath(),d.strokeStyle="#ffffff",d.moveTo(i*c,0),d.lineTo(i*c,e.height),d.stroke();for(c=0;c<u.height;c++)d.beginPath(),d.strokeStyle="#ffffff",d.moveTo(0,i*c),d.lineTo(e.width,i*c),d.stroke();d.globalAlpha=1-a,d.drawImage(t,0,0),d.restore()}function createPersonMask(e,t){var r=renderImageDataToOffScreenCanvas(toMaskImageData(e,!1),CANVAS_NAMES.mask);return 0===t?r:drawAndBlurImageOnOffScreenCanvas(r,t,CANVAS_NAMES.blurredMask)}function drawBokehEffect(e,t,r,a,n,o){void 0===a&&(a=3),void 0===n&&(n=3),void 0===o&&(o=!1),assertSameDimensions(t,r,"image","segmentation");var i=drawAndBlurImageOnOffScreenCanvas(t,a,CANVAS_NAMES.blurred),s=createPersonMask(r,n),d=e.getContext("2d");d.save(),o&&flipCanvasHorizontal(e),d.drawImage(t,0,0),drawWithCompositing(d,s,"destination-in"),drawWithCompositing(d,i,"destination-over"),d.restore()}var partChannels=["leftFace","rightFace","rightUpperLegFront","rightLowerLegBack","rightUpperLegBack","leftLowerLegFront","leftUpperLegFront","leftUpperLegBack","leftLowerLegBack","rightFeet","rightLowerLegFront","leftFeet","torsoFront","torsoBack","rightUpperArmFront","rightUpperArmBack","rightLowerArmBack","leftLowerArmFront","leftUpperArmFront","leftUpperArmBack","leftLowerArmBack","rightHand","rightLowerArmFront","leftHand"];export{BodyPix,load,checkpoints,decodePartSegmentation,toMask,drawBokehEffect,drawMask,drawPixelatedMask,toColoredPartImageData,toMaskImageData,partChannels,resizeAndPadTo,scaleAndCropToInputTensorShape};
