/**
 * @license
 * Copyright 2020 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports,require("@tensorflow/tfjs-core"),require("seedrandom")):"function"==typeof define&&define.amd?define(["exports","@tensorflow/tfjs-core","seedrandom"],t):t((e=e||self).tf=e.tf||{},e.tf,e.seedrandom)}(this,(function(e,t,a){"use strict";function n(e,a){Array.isArray(e)||(e=[e]),e.forEach(e=>{null!=e&&t.util.assert("complex64"!==e.dtype,()=>`${a} does not support complex64 tensors in the CPU backend.`)})}const s=t.kernel_impls.nonMaxSuppressionV3Impl,o=t.kernel_impls.split,r=t.kernel_impls.tile,i=t.kernel_impls.topkImpl,d=t.kernel_impls.whereImpl;class l extends t.KernelBackend{constructor(){super(),this.blockSize=48,this.firstUse=!0,this.data=new t.DataStorage(this,t.engine())}write(e,a,n){this.firstUse&&(this.firstUse=!1,t.env().get("IS_NODE")&&t.backend_util.warn("\n============================\nHi there 👋. Looks like you are running TensorFlow.js in Node.js. To speed things up dramatically, install our node backend, which binds to TensorFlow C++, by running npm i @tensorflow/tfjs-node, or npm i @tensorflow/tfjs-node-gpu if you have CUDA. Then call require('@tensorflow/tfjs-node'); (-gpu suffix for CUDA) at the start of your program. Visit https://github.com/tensorflow/tfjs-node for more details.\n============================"));const s={};return this.data.set(s,{values:e,dtype:n,refCount:1}),s}makeTensorInfo(e,a,n){let s;if("string"===a&&null!=n&&n.length>0&&t.util.isString(n[0])){const o=n.map(e=>t.util.encodeString(e));s=this.write(o,e,a)}else s=this.write(n,e,a);return{dataId:s,shape:e,dtype:a}}incRef(e){this.data.get(e).refCount++}decRef(e){if(this.data.has(e)){this.data.get(e).refCount--}}move(e,t,a,n){this.data.set(e,{values:t,dtype:n,refCount:1})}numDataIds(){return this.data.numDataIds()}async read(e){return this.readSync(e)}readSync(e){const{dtype:a,complexTensorInfos:n}=this.data.get(e);if("complex64"===a){const e=this.readSync(n.real.dataId),a=this.readSync(n.imag.dataId);return t.backend_util.mergeRealAndImagArrays(e,a)}return this.data.get(e).values}bufferSync(e){const a=this.readSync(e.dataId);let n=a;if("string"===e.dtype)try{n=a.map(e=>t.util.decodeString(e))}catch(e){throw new Error("Failed to decode encoded string bytes into utf-8")}return t.buffer(e.shape,e.dtype,n)}makeOutput(e,a,n){const s=this.write(e,a,n);return t.engine().makeTensorFromDataId(s,a,n,this)}disposeData(e){if(this.data.has(e)){const{complexTensorInfos:t}=this.data.get(e);null!=t&&(this.disposeData(t.real.dataId),this.disposeData(t.imag.dataId)),this.data.delete(e)}}disposeIntermediateTensorInfo(e){const t=e.dataId;if(this.data.has(t)){const e=this.data.get(t);e.refCount--,e.refCount<1&&this.disposeData(t)}}async time(e){const a=t.util.now();return e(),{kernelMs:t.util.now()-a}}memory(){return{unreliable:!0,reasons:["The reported memory is an upper bound. Due to automatic garbage collection, the true allocated memory may be less."]}}stridedSlice(e,a,s,o){n(e,"stridedSlice");const r=t.slice_util.computeOutShape(a,s,o);if(r.some(e=>0===e))return t.tensor([],r);const i=t.buffer(r,e.dtype),d=this.bufferSync(e);for(let e=0;e<i.size;e++){const t=i.indexToLoc(e),n=new Array(t.length);for(let e=0;e<n.length;e++)n[e]=t[e]*o[e]+a[e];i.set(d.get(...n),...t)}return i.toTensor()}diag(e){const a=this.readSync(e.dataId),n=t.buffer([e.size,e.size],e.dtype),s=n.values;for(let t=0;t<a.length;t++)s[t*e.size+t]=a[t];return n.toTensor()}unstack(e,a){const n=e.shape[a],s=new Array(e.rank-1);let o=0;for(let t=0;t<e.rank;t++)t!==a&&(s[o++]=e.shape[t]);const r=new Array(e.rank).fill(0),i=e.shape.slice();i[a]=1;const d=new Array(n);for(let n=0;n<d.length;n++)r[a]=n,d[n]=t.slice(e,r,i).reshape(s);return d}reverse(e,a){n(e,"reverse");const s=t.buffer(e.shape,e.dtype),o=this.bufferSync(e);for(let t=0;t<s.size;t++){const n=s.indexToLoc(t),r=n.slice();a.forEach(t=>r[t]=e.shape[t]-1-r[t]),s.set(o.get(...r),...n)}return s.toTensor()}neg(e){return n(e,"neg"),t.mul(t.scalar(-1),e)}addN(e){n(e,"addN");const a=e.map(e=>this.readSync(e.dataId)),s=t.buffer(e[0].shape,e[0].dtype),o=s.values;for(let t=0;t<e.length;t++){const e=a[t];for(let t=0;t<o.length;t++)o[t]+=e[t]}return s.toTensor()}softmax(e,a){const n=t.util.parseAxisParam([a],e.shape),s=t.max(e,n),o=t.backend_util.expandShapeToKeepDim(s.shape,n),r=t.sub(e,s.reshape(o)),i=t.exp(r),d=this.sum(i,n).reshape(o);return t.div(i,d)}pow(e,t){return n([e,t],"pow"),this.broadcastedBinaryOp(e,t,e.dtype,(e,t)=>Math.pow(e,t))}floorDiv(e,t){n([e,t],"floorDiv");return this.broadcastedBinaryOp(e,t,"int32",(e,t)=>Math.floor(e/t))}sum(e,a){n(e,"sum"),t.backend_util.assertAxesAreInnerMostDims("sum",a,e.rank);const[s,o]=t.backend_util.computeOutAndReduceShapes(e.shape,a),r=t.upcastType(e.dtype,"int32"),i=t.zeros(s,r),d=t.util.sizeFromShape(o),l=this.readSync(i.dataId),c=this.readSync(e.dataId);for(let e=0;e<l.length;++e){const t=e*d;let a=0;for(let e=0;e<d;++e)a+=c[t+e];l[e]=a}return i}prod(e,a){n(e,"sum");const[s,o]=t.backend_util.computeOutAndReduceShapes(e.shape,a),r=t.upcastType(e.dtype,"int32"),i=t.zeros(s,r),d=t.util.sizeFromShape(o),l=this.readSync(i.dataId),c=this.readSync(e.dataId);for(let e=0;e<l.length;++e){const t=e*d;let a=1;for(let e=0;e<d;++e)a*=c[t+e];l[e]=a}return i}unsortedSegmentSum(e,a,s){n(e,"unsortedSegmentSum");const o=[],r=e.rank-a.rank;for(let e=0;e<r;++e)a=a.expandDims(e+1);for(let n=0;n<s;++n){const s=t.scalar(n,"int32"),r=t.equal(s,a).asType("float32").mul(e).sum(0);o.push(r)}return t.stack(o)}argMin(e,a){n(e,"argMin");const s=[a];t.backend_util.assertAxesAreInnerMostDims("argMin",s,e.rank);const[o,r]=t.backend_util.computeOutAndReduceShapes(e.shape,s),i=t.zeros(o,"int32"),d=t.util.sizeFromShape(r),l=this.readSync(i.dataId),c=this.readSync(e.dataId);for(let e=0;e<l.length;++e){const t=e*d;let a=c[t],n=0;for(let e=0;e<d;++e){const s=c[t+e];s<a&&(a=s,n=e)}l[e]=n}return i}argMax(e,a){n(e,"argMax");const s=[a];t.backend_util.assertAxesAreInnerMostDims("argMax",s,e.rank);const[o,r]=t.backend_util.computeOutAndReduceShapes(e.shape,s),i=t.zeros(o,"int32"),d=t.util.sizeFromShape(r),l=this.readSync(i.dataId),c=this.readSync(e.dataId);for(let e=0;e<l.length;++e){const t=e*d;let a=c[t],n=0;for(let e=0;e<d;++e){const s=c[t+e];s>a&&(a=s,n=e)}l[e]=n}return i}cumsum(e,a,s,o){if(n(e,"cumsum"),a!==e.rank-1)throw new Error(`backend.cumsum in CPU expects an inner-most axis=${e.rank-1} `+`but got axis=${a}`);const r=t.upcastType(e.dtype,"int32"),i=t.zeros(e.shape,r),d=this.readSync(i.dataId),l=this.readSync(e.dataId),c=e.shape[e.rank-1],u=o?(e,t)=>e+c-t-1:(e,t)=>e+t;for(let e=0;e<l.length;e+=c)for(let t=0;t<c;t++){const a=u(e,t);if(0===t)d[a]=s?0:l[a];else{const n=u(e,t-1);d[a]=s?l[n]+d[n]:l[a]+d[n]}}return i}equal(e,t){return n([e,t],"equal"),this.broadcastedBinaryOp(e,t,"bool",(e,t)=>e===t?1:0)}notEqual(e,t){return n([e,t],"notEqual"),this.broadcastedBinaryOp(e,t,"bool",(e,t)=>e!==t?1:0)}less(e,t){return n([e,t],"less"),this.broadcastedBinaryOp(e,t,"bool",(e,t)=>e<t?1:0)}lessEqual(e,t){return n([e,t],"lessEqual"),this.broadcastedBinaryOp(e,t,"bool",(e,t)=>e<=t?1:0)}greater(e,t){return n([e,t],"greater"),this.broadcastedBinaryOp(e,t,"bool",(e,t)=>e>t?1:0)}greaterEqual(e,t){return n([e,t],"greaterEqual"),this.broadcastedBinaryOp(e,t,"bool",(e,t)=>e>=t?1:0)}logicalAnd(e,t){return n([e,t],"logicalAnd"),this.broadcastedBinaryOp(e,t,"bool",(e,t)=>e&&t)}logicalOr(e,t){return n([e,t],"logicalOr"),this.broadcastedBinaryOp(e,t,"bool",(e,t)=>e||t)}select(e,a,s){n([e,a,s],"select");const o=this.readSync(e.dataId),r=this.readSync(a.dataId),i=this.readSync(s.dataId),d=t.zeros(a.shape,t.upcastType(a.dtype,s.dtype)),l=this.readSync(d.dataId);let c=0;const u=0===e.rank||e.rank>1||1===a.rank?1:t.util.sizeFromShape(a.shape.slice(1));for(let e=0;e<o.length;e++)for(let t=0;t<u;t++)1===o[e]?l[c++]=r[e]:l[c++]=i[e];return d}where(e){n([e],"where");const t=this.readSync(e.dataId);return d(e.shape,t)}topk(e,t,a){n(e,"topk");const s=this.readSync(e.dataId);return i(s,e.shape,e.dtype,t,a)}min(e,a){n(e,"min"),t.backend_util.assertAxesAreInnerMostDims("min",a,e.rank);const[s,o]=t.backend_util.computeOutAndReduceShapes(e.shape,a),r=t.zeros(s,e.dtype),i=t.util.sizeFromShape(o),d=this.readSync(r.dataId),l=this.readSync(e.dataId);for(let e=0;e<d.length;++e){const t=e*i;let a=l[t];for(let e=0;e<i;++e){const n=l[t+e];n<a&&(a=n)}d[e]=a}return r}minimum(e,t){return n([e,t],"minimum"),this.broadcastedBinaryOp(e,t,e.dtype,(e,t)=>Math.min(e,t))}mod(e,t){return n([e,t],"mod"),this.broadcastedBinaryOp(e,t,e.dtype,(e,t)=>{const a=e%t;return e<0&&t<0||e>=0&&t>=0?a:(a+t)%t})}maximum(e,t){return n([e,t],"maximum"),this.broadcastedBinaryOp(e,t,e.dtype,(e,t)=>Math.max(e,t))}all(e,a){n(e,"all"),t.backend_util.assertAxesAreInnerMostDims("all",a,e.rank);const[s,o]=t.backend_util.computeOutAndReduceShapes(e.shape,a),r=t.zeros(s,e.dtype),i=t.util.sizeFromShape(o),d=this.readSync(r.dataId),l=this.readSync(e.dataId);for(let e=0;e<d.length;++e){const t=e*i;let a=l[t];for(let e=0;e<i;++e){const n=l[t+e];a=a&&n}d[e]=a}return r}any(e,a){n(e,"any"),t.backend_util.assertAxesAreInnerMostDims("any",a,e.rank);const[s,o]=t.backend_util.computeOutAndReduceShapes(e.shape,a),r=t.zeros(s,e.dtype),i=t.util.sizeFromShape(o),d=this.readSync(r.dataId),l=this.readSync(e.dataId);for(let e=0;e<d.length;++e){const t=e*i;let a=l[t];for(let e=0;e<i;++e){const n=l[t+e];a=a||n}d[e]=a}return r}squaredDifference(e,t){return n([e,t],"squaredDifference"),this.broadcastedBinaryOp(e,t,e.dtype,(e,t)=>{const a=e-t;return a*a})}eluDer(e,t){n([e,t],"eluDer");const a=new Float32Array(t.size),s=this.readSync(t.dataId),o=this.readSync(e.dataId);for(let e=0;e<s.length;++e){const t=s[e];a[e]=t>=1?o[e]:o[e]*(t+1)}return this.makeOutput(a,t.shape,"float32")}atan2(e,t){return n([e,t],"atan2"),this.broadcastedBinaryOp(e,t,e.dtype,(e,t)=>Math.atan2(e,t))}tile(e,t){return n(e,"tile"),r(this.bufferSync(e),t)}gather(e,a,s){n([e,a],"gather");const o=e.shape.slice(),r=this.readSync(a.dataId);o[s]=r.length;const i=t.buffer(o,e.dtype),d=this.bufferSync(e);for(let e=0;e<i.size;++e){const t=i.indexToLoc(e),a=t.slice();a[s]=r[t[s]];const n=d.locToIndex(a);i.values[e]=d.values[n]}return i.toTensor()}batchToSpaceND(e,a,s){n([e],"batchToSpaceND");const o=a.reduce((e,t)=>e*t),r=t.backend_util.getReshaped(e.shape,a,o),i=t.backend_util.getPermuted(r.length,a.length),d=t.backend_util.getReshapedPermuted(e.shape,a,o),l=t.backend_util.getSliceBeginCoords(s,a.length),c=t.backend_util.getSliceSize(d,s,a.length);return t.transpose(e.reshape(r),i).reshape(d).slice(l,c)}pool3d(e,a,s){n(e,"pool3d");const o=a.strideDepth,r=a.strideHeight,i=a.strideWidth,d=a.dilationDepth,l=a.dilationHeight,c=a.dilationWidth,u=a.effectiveFilterDepth,p=a.effectiveFilterHeight,h=a.effectiveFilterWidth,f=a.padInfo.front,m=a.padInfo.top,k=a.padInfo.left,g="max"===s?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY,I=this.readSync(e.dataId),b=t.buffer(a.outShape,e.dtype),y=b.values,S=a.outShape[1]*a.outShape[2]*a.outShape[3]*a.outShape[4],N=a.outShape[2]*a.outShape[3]*a.outShape[4],T=a.outShape[3]*a.outShape[4],F=a.outShape[4];for(let t=0;t<a.batchSize;++t){const n=t*S,b=t*e.strides[0];for(let t=0;t<a.inChannels;++t)for(let S=0;S<a.outDepth;++S){const x=S*o-f;let v=x;for(;v<0;)v+=d;const M=Math.min(a.inDepth,u+x),A=n+S*N;for(let n=0;n<a.outHeight;++n){const o=n*r-m;let u=o;for(;u<0;)u+=l;const f=Math.min(a.inHeight,p+o),S=A+n*T;for(let n=0;n<a.outWidth;++n){const o=n*i-k;let r=o;for(;r<0;)r+=c;const p=Math.min(a.inWidth,h+o),m=S+n*F;let N=g,T=0,x=0;for(let a=v;a<M;a+=d){const n=b+a*e.strides[1];for(let a=u;a<f;a+=l){const o=n+a*e.strides[2];for(let a=r;a<p;a+=c){const n=I[o+a*e.strides[3]+t];if("max"===s&&n>N?N=n:"avg"===s&&(T+=n,x++),isNaN(N))break}if(isNaN(N))break}if(isNaN(N))break}y[m+t]="avg"===s?T/x:N}}}}return b.toTensor()}avgPool3d(e,t){return n(e,"avgPool3d"),this.pool3d(e,t,"avg").toFloat()}avgPool3dBackprop(e,a,s){n([e,a],"avgPool3dBackprop");const o=s.strideDepth,r=s.strideHeight,i=s.strideWidth,d=s.filterDepth,l=s.filterHeight,c=s.filterWidth,u=s.dilationDepth,p=s.dilationHeight,h=s.dilationWidth,f=s.effectiveFilterDepth,m=s.effectiveFilterHeight,k=s.effectiveFilterWidth,g=f-1-s.padInfo.front,I=k-1-s.padInfo.left,b=m-1-s.padInfo.top,y=t.buffer(a.shape,"float32"),S=1/(d*l*c),N=this.bufferSync(e);for(let e=0;e<s.batchSize;++e)for(let t=0;t<s.inChannels;++t)for(let a=0;a<s.inDepth;++a)for(let n=0;n<s.inHeight;++n)for(let d=0;d<s.inWidth;++d){const l=a-g,c=n-b,T=d-I;let F=0;for(let a=0;a<f;a+=u){const n=(l+a)/o;if(!(n<0||n>=s.outDepth||Math.floor(n)!==n))for(let a=0;a<m;a+=p){const o=(c+a)/r;if(!(o<0||o>=s.outHeight||Math.floor(o)!==o))for(let a=0;a<k;a+=h){const r=(T+a)/i;r<0||r>=s.outWidth||Math.floor(r)!==r||(F+=N.get(e,n,o,r,t))}}}y.set(F*S,e,a,n,d,t)}return y.toTensor()}maxPool3d(e,t){return n(e,"maxPool3d"),this.pool3d(e,t,"max").toFloat()}maxPool3dPositions(e,a){const n=t.buffer(a.outShape,"int32"),s=a.strideDepth,o=a.strideHeight,r=a.strideWidth,i=a.dilationDepth,d=a.dilationHeight,l=a.dilationWidth,c=a.effectiveFilterDepth,u=a.effectiveFilterHeight,p=a.effectiveFilterWidth,h=a.padInfo.front,f=a.padInfo.top,m=a.padInfo.left,k=this.bufferSync(e);for(let e=0;e<a.batchSize;++e)for(let t=0;t<a.inChannels;++t)for(let g=0;g<a.outDepth;++g){const I=g*s-h;let b=I;for(;b<0;)b+=i;const y=Math.min(a.inDepth,c+I);for(let s=0;s<a.outHeight;++s){const c=s*o-f;let h=c;for(;h<0;)h+=d;const S=Math.min(a.inHeight,u+c);for(let o=0;o<a.outWidth;++o){const f=o*r-m;let N=f;for(;N<0;)N+=l;const T=Math.min(a.inWidth,p+f);let F=Number.NEGATIVE_INFINITY,x=-1;for(let a=b;a<y;a+=i){const n=a-I;for(let s=h;s<S;s+=d){const o=s-c;for(let r=N;r<T;r+=l){const i=r-f,d=k.get(e,a,s,r,t);d>=F&&(F=d,x=n*u*p+o*u+i)}}}n.set(x,e,g,s,o,t)}}}return n.toTensor()}maxPool3dBackprop(e,a,s,o){n([a,s],"maxPool3dBackprop");const r=this.maxPool3dPositions(a,o),i=o.strideDepth,d=o.strideHeight,l=o.strideWidth,c=o.dilationDepth,u=o.dilationHeight,p=o.dilationWidth,h=o.effectiveFilterDepth,f=o.effectiveFilterHeight,m=o.effectiveFilterWidth,k=h-1-o.padInfo.front,g=m-1-o.padInfo.left,I=f-1-o.padInfo.top,b=t.buffer(a.shape,"float32"),y=this.bufferSync(r),S=this.bufferSync(e);for(let e=0;e<o.batchSize;++e)for(let t=0;t<o.inChannels;++t)for(let a=0;a<o.inDepth;++a)for(let n=0;n<o.inHeight;++n)for(let s=0;s<o.inWidth;++s){const r=a-k,N=n-I,T=s-g;let F=0;for(let a=0;a<h;a+=c){const n=(r+a)/i;if(!(n<0||n>=o.outDepth||Math.floor(n)!==n))for(let s=0;s<f;s+=u){const r=(N+s)/d;if(!(r<0||r>=o.outHeight||Math.floor(r)!==r))for(let i=0;i<m;i+=p){const d=(T+i)/l;if(d<0||d>=o.outWidth||Math.floor(d)!==d)continue;const c=h*f*m-1-y.get(e,n,r,d,t)===a*f*m+s*m+i?1:0;0!==c&&(F+=S.get(e,n,r,d,t)*c)}}}b.set(F,e,a,n,s,t)}return b.toTensor()}resizeBilinear(e,a,s,o){n(e,"resizeBilinear");const[r,i,d,l]=e.shape,c=this.readSync(e.dataId),u=new Float32Array(t.util.sizeFromShape([r,a,s,l])),p=[o&&a>1?i-1:i,o&&s>1?d-1:d],h=[o&&a>1?a-1:a,o&&s>1?s-1:s];let f=0;const m=p[0]/h[0],k=p[1]/h[1];for(let t=0;t<r;t++)for(let n=0;n<a;n++){const a=m*n,o=Math.floor(a),r=a-o,p=Math.min(i-1,Math.ceil(a)),h=t*e.strides[0]+o*e.strides[1],g=t*e.strides[0]+p*e.strides[1];for(let t=0;t<s;t++){const a=k*t,n=Math.floor(a),s=a-n,o=Math.min(d-1,Math.ceil(a)),i=h+n*e.strides[2],p=g+n*e.strides[2],m=h+o*e.strides[2],I=g+o*e.strides[2];for(let e=0;e<l;e++){const t=c[i+e],a=c[p+e],n=t+(c[m+e]-t)*s,o=n+(a+(c[I+e]-a)*s-n)*r;u[f++]=o}}}return t.tensor(u,[r,a,s,l])}resizeBilinearBackprop(e,a,s){n([e,a],"resizeBilinearBackprop");const[o,r,i,d]=a.shape,[,l,c]=e.shape,u=new Float32Array(o*r*i*d),p=[s&&l>1?r-1:r,s&&c>1?i-1:i],h=[s&&l>1?l-1:l,s&&c>1?c-1:c],f=p[0]/h[0],m=p[1]/h[1],k=this.readSync(e.dataId);let g=0;for(let e=0;e<o;e++){const t=e*a.strides[0];for(let e=0;e<l;e++){const n=e*f,s=Math.floor(n),o=Math.min(Math.ceil(n),r-1),l=t+s*a.strides[1],p=t+o*a.strides[1],h=n-s,I=1-h;for(let e=0;e<c;e++){const t=e*m,n=Math.floor(t),s=Math.min(Math.ceil(t),i-1),o=t-n,r=1-o,c=l+n*a.strides[2],f=l+s*a.strides[2],b=p+n*a.strides[2],y=p+s*a.strides[2],S=I*r,N=I*o,T=h*r,F=h*o;for(let e=0;e<d;e++){const t=k[g++];u[c+e]+=t*S,u[f+e]+=t*N,u[b+e]+=t*T,u[y+e]+=t*F}}}}return t.tensor4d(u,[o,i,r,d],a.dtype)}resizeNearestNeighbor(e,a,s,o){n(e,"resizeNearestNeighbor");const[r,i,d,l]=e.shape,c=this.readSync(e.dataId),u=new Float32Array(r*a*s*l),p=[o&&a>1?i-1:i,o&&s>1?d-1:d],h=[o&&a>1?a-1:a,o&&s>1?s-1:s],f=p[0]/h[0],m=p[1]/h[1];let k=0;for(let t=0;t<r;t++){const n=t*e.strides[0];for(let t=0;t<a;t++){const a=f*t,r=n+Math.min(i-1,o?Math.round(a):Math.floor(a))*e.strides[1];for(let t=0;t<s;t++){const a=m*t,n=r+Math.min(d-1,o?Math.round(a):Math.floor(a))*e.strides[2];for(let e=0;e<l;e++){const t=c[n+e];u[k++]=t}}}}return t.tensor(u,[r,a,s,l],e.dtype)}resizeNearestNeighborBackprop(e,a,s){n([e,a],"resizeNearestNeighborBackprop");const[o,r,i,d]=a.shape,[,l,c]=e.shape,u=new Float32Array(o*r*i*d),p=this.readSync(e.dataId),h=[s&&l>1?r-1:r,s&&c>1?i-1:i],f=[s&&l>1?l-1:l,s&&c>1?c-1:c],m=h[0]/f[0],k=h[1]/f[1],g=1/m,I=1/k,b=2*Math.ceil(g)+2,y=2*Math.ceil(I)+2;for(let t=0;t<o;t++){const n=t*a.strides[0];for(let t=0;t<r;t++){const o=n+t*a.strides[1],h=Math.floor(t*g),f=Math.floor(h-b/2);for(let h=0;h<i;h++){const g=o+h*a.strides[2],S=Math.floor(h*I),N=Math.floor(S-y/2);for(let a=0;a<d;a++){let o=0;for(let d=0;d<b;d++){const u=d+f;if(u<0||u>=l)continue;const g=n+u*e.strides[1],I=u*m;if(t===Math.min(r-1,s?Math.round(I):Math.floor(I)))for(let t=0;t<y;t++){const n=t+N;if(n<0||n>=c)continue;const r=g+n*e.strides[2],d=n*k;h===Math.min(i-1,s?Math.round(d):Math.floor(d))&&(o+=p[r+a])}}u[g+a]=o}}}}return t.tensor4d(u,a.shape,a.dtype)}localResponseNormalization4D(e,a,s,o,r){n(e,"localResponseNormalization4D");const i=e.shape[3],d=i-1,l=this.readSync(e.dataId),c=e.size,u=new Float32Array(c);function p(e){const t=e%i;let n=e-t+Math.max(0,t-a);const s=e-t+Math.min(t+a,d);let o=0;for(;n<=s;n++){const e=l[n];o+=e*e}return o}for(let e=0;e<c;e++){const t=p(e),a=l[e]*Math.pow(s+o*t,-r);u[e]=a}return t.tensor4d(u,e.shape)}LRNGrad(e,a,s,o,r,i,d){n(e,"LRNGrad");const l=e.shape[3],c=this.readSync(e.dataId),u=this.readSync(a.dataId),p=this.readSync(s.dataId),h=new Float32Array(e.size),f=e.size;for(let e=0;e<f;e++){const t=e%l,a=e-t+Math.max(0,t-o),n=e-t+Math.min(l,t+o+1);let s=0;for(let e=a;e<n;e++)s+=Math.pow(u[e],2);s=i*s+r;for(let t=a;t<n;t++){let a=-2*i*d*u[t]*p[e]/s;e===t&&(a+=Math.pow(s,-d)),a*=c[e],h[t]+=a}}return t.tensor4d(h,e.shape)}multinomial(e,s,o,r){n(e,"multinomial");const i=s?e:t.softmax(e),d=i.shape[0],l=i.shape[1],c=t.zeros([d,o],"int32"),u=this.readSync(c.dataId),p=this.readSync(i.dataId);for(let e=0;e<d;++e){const t=e*l,n=new Float32Array(l-1);n[0]=p[t];for(let e=1;e<n.length;++e)n[e]=n[e-1]+p[t+e];const s=a.alea(r.toString()),i=e*o;for(let e=0;e<o;++e){const t=s();u[i+e]=n.length;for(let a=0;a<n.length;a++)if(t<n[a]){u[i+e]=a;break}}}return c}oneHot(e,a,s,o){n(e,"oneHot");const r=new Float32Array(e.size*a);r.fill(o);const i=this.readSync(e.dataId);for(let t=0;t<e.size;++t)i[t]>=0&&i[t]<a&&(r[t*a+i[t]]=s);return t.tensor2d(r,[e.size,a],"int32")}nonMaxSuppression(e,t,a,o,r){n(e,"nonMaxSuppression");const i=this.readSync(e.dataId),d=this.readSync(t.dataId);return s(i,d,a,o,r)}depthToSpace(e,a,n){t.util.assert("NHWC"===n,()=>`Only NHWC dataFormat supported on CPU for depthToSpace. Got ${n}`),t.util.assert(a>1,()=>`blockSize should be > 1 for depthToSpace, but was: ${a}`);const s=e.shape[0],o=e.shape[1],r=e.shape[2],i=e.shape[3],d=o*a,l=r*a,c=i/(a*a),u=this.readSync(e.dataId),p=new Float32Array(s*d*l*c);let h=0;for(let e=0;e<s;++e)for(let t=0;t<d;++t){const n=Math.floor(t/a),s=t%a;for(let t=0;t<l;++t){const d=Math.floor(t/a),l=(s*a+t%a)*c;for(let t=0;t<c;++t){const a=t+l+i*(d+r*(n+o*e));p[h++]=u[a]}}}return t.tensor4d(p,[s,d,l,c])}broadcastedBinaryOp(e,a,n,s){const o=t.backend_util.assertAndGetBroadcastShape(e.shape,a.shape),r=t.buffer(o,n),i=this.readSync(e.dataId),d=this.readSync(a.dataId),l=t.backend_util.getBroadcastDims(e.shape,o),c=t.backend_util.getBroadcastDims(a.shape,o),u=r.values;if(l.length+c.length===0)for(let e=0;e<u.length;++e)u[e]=s(i[e%i.length],d[e%d.length]);else{const t=this.bufferSync(e),n=this.bufferSync(a);for(let o=0;o<u.length;++o){const p=r.indexToLoc(o),h=p.slice(-e.rank);l.forEach(e=>h[e]=0);const f=t.locToIndex(h),m=p.slice(-a.rank);c.forEach(e=>m[e]=0);const k=n.locToIndex(m);u[o]=s(i[f],d[k])}}return r.toTensor()}split(e,t,a){return o(e,t,a)}dispose(){}floatPrecision(){return 32}epsilon(){return super.epsilon()}cropAndResize(e,a,n,s,o,r){const[i,d,l,c]=e.shape,u=a.shape[0],[p,h]=s,f=t.buffer([u,p,h,c],"float32"),m=this.readSync(a.dataId),k=this.readSync(n.dataId),g=this.readSync(e.dataId),I=e.strides,b=f.strides;for(let e=0;e<u;e++){const t=4*e,a=m[t],n=m[t+1],s=m[t+2],u=m[t+3],y=k[e];if(y>=i)continue;const S=p>1?(s-a)*(d-1)/(p-1):0,N=h>1?(u-n)*(l-1)/(h-1):0;for(let t=0;t<p;t++){const i=p>1?a*(d-1)+t*S:.5*(a+s)*(d-1);if(i<0||i>d-1)for(let a=0;a<h;a++)for(let n=0;n<c;n++){const s=n+a*b[2]+t*b[1]+e*b[0];f.values[s]=r}else if("bilinear"===o){const a=Math.floor(i),s=Math.ceil(i),o=i-a;for(let i=0;i<h;i++){const d=h>1?n*(l-1)+i*N:.5*(n+u)*(l-1);if(d<0||d>l-1){for(let a=0;a<c;a++){const n=a+i*b[2]+t*b[1]+e*b[0];f.values[n]=r}continue}const p=Math.floor(d),m=Math.ceil(d),k=d-p;for(let n=0;n<c;n++){let r=n+p*I[2]+a*I[1]+y*I[0];const d=g[r];r=n+m*I[2]+a*I[1]+y*I[0];const l=g[r];r=n+p*I[2]+s*I[1]+y*I[0];const c=g[r];r=n+m*I[2]+s*I[1]+y*I[0];const u=d+(l-d)*k,h=c+(g[r]-c)*k;r=n+i*b[2]+t*b[1]+e*b[0],f.values[r]=u+(h-u)*o}}}else for(let a=0;a<h;++a){const s=h>1?n*(l-1)+a*N:.5*(n+u)*(l-1);if(s<0||s>l-1){for(let n=0;n<c;n++){const s=n+a*b[2]+t*b[1]+e*b[0];f.values[s]=r}continue}const o=Math.round(s),d=Math.round(i);for(let n=0;n<c;n++){const s=n+o*I[2]+d*I[1]+y*I[0],r=n+a*b[2]+t*b[1]+e*b[0];f.values[r]=g[s]}}}}return f.toTensor()}sparseToDense(e,a,n,s){const{sliceRank:o,numUpdates:r,sliceSize:i,strides:d,outputSize:l}=t.backend_util.calculateShapes(a,e,n);return this.scatter(e,a,n,l,i,r,o,d,s,!1)}gatherND(e,a){const n=a.shape,s=n[n.length-1],[o,r,i,d]=t.backend_util.prepareAndValidate(e,a);if(0===r)return t.tensor([],o,e.dtype);const l=new t.TensorBuffer([r,i],e.dtype),c=this.readSync(a.dataId),u=this.readSync(e.dataId);for(let t=0;t<r;t++){const a=[];let n=0;for(let e=0;e<s;e++){const o=c[t*s+e];n+=o*d[e],a.push(o)}if(n<0||n>=e.size/i)throw new Error(`Invalid indices: ${a} does not index into ${e.shape}`);for(let e=0;e<i;e++)l.values[t*i+e]=u[n*i+e]}return l.toTensor().reshape(o)}scatterND(e,a,n){const{sliceRank:s,numUpdates:o,sliceSize:r,strides:i,outputSize:d}=t.backend_util.calculateShapes(a,e,n),l=t.scalar(0);return this.scatter(e,a,n,d,r,o,s,i,l,!0)}onesLike(e){if("string"===e.dtype)throw new Error("onesLike is not supported for string tensors");return t.fill(e.shape,1,e.dtype)}zerosLike(e){const a=t.util.getArrayFromDType(e.dtype,t.util.sizeFromShape(e.shape));return this.makeOutput(a,e.shape,e.dtype)}linspace(e,a,n){return t.backend_util.linspaceImpl(e,a,n)}scatter(e,a,n,s,o,r,i,d,l,c){const u=[s/o,o],p=this.readSync(e.dataId),h=this.readSync(a.dataId);if(0===s)return t.tensor([],n,a.dtype);const f=new t.TensorBuffer(u,a.dtype);f.values.fill(this.readSync(l.dataId)[0]);for(let e=0;e<r;e++){const t=[];let r=0;for(let a=0;a<i;a++){const n=p[e*i+a];t.push(n),r+=n*d[a]}if(r<0||r>=s/o)throw new Error(`Invalid indices: ${t} does not index into ${n}`);for(let t=0;t<o;t++)c?f.values[r*o+t]+=h[e*o+t]:f.values[r*o+t]=0===a.rank?h[0]:h[e*o+t]}return f.toTensor().reshape(n)}}function c(e){const t=new Float32Array(e.length);for(let a=0;a<e.length;++a)t[a]=Math.abs(e[a]);return t}const u={kernelName:t.Abs,backendName:"cpu",kernelFunc:e=>{const{x:a}=e.inputs,n=e.backend;let s=new Float32Array(t.util.sizeFromShape(a.shape));if("complex64"!==a.dtype){s=c(n.data.get(a.dataId).values)}else{const e=n.data.get(a.dataId),t=e.complexTensorInfos.real,o=e.complexTensorInfos.imag,r=n.data.get(t.dataId).values,i=n.data.get(o.dataId).values;for(let e=0;e<r.length;e++){const t=r[e],a=i[e];s[e]=Math.hypot(t,a)}}return n.makeOutput(s,a.shape,"float32")}};function p(e){return(a,n,s,o,r)=>{const i=t.backend_util.assertAndGetBroadcastShape(a,n),d=i.length,l=t.util.computeStrides(i),c=t.util.sizeFromShape(i),u=t.util.getTypedArrayFromDType(r,c),p=a.length,h=n.length,f=t.util.computeStrides(a),m=t.util.computeStrides(n),k=t.backend_util.getBroadcastDims(a,i),g=t.backend_util.getBroadcastDims(n,i);if(k.length+g.length===0)for(let t=0;t<u.length;++t)u[t]=e(s[t%s.length],o[t%o.length]);else for(let a=0;a<u.length;++a){const n=t.util.indexToLoc(a,d,l),r=n.slice(-p);k.forEach(e=>r[e]=0);const i=t.util.locToIndex(r,p,f),c=n.slice(-h);g.forEach(e=>c[e]=0);const I=t.util.locToIndex(c,h,m);u[a]=e(s[i],o[I])}return[u,i]}}function h(e){const{inputs:t,backend:a}=e,{real:n,imag:s}=t,o=a.data.get(n.dataId).values,r=a.data.get(s.dataId).values,i=a.makeTensorInfo(n.shape,"complex64");return a.data.get(i.dataId).complexTensorInfos={real:a.makeTensorInfo(n.shape,"float32",o),imag:a.makeTensorInfo(s.shape,"float32",r)},i}const f={kernelName:t.Complex,backendName:"cpu",kernelFunc:h};function m(e){const{inputs:t,backend:a}=e,{x:n}=t;return a.incRef(n.dataId),{dataId:n.dataId,shape:n.shape,dtype:n.dtype}}const k={kernelName:t.Identity,backendName:"cpu",kernelFunc:m};function g(e){const{inputs:t,backend:a}=e,{input:n}=t,s=a.data.get(n.dataId).complexTensorInfos.real,o=a.data.get(s.dataId).values;return a.makeTensorInfo(s.shape,s.dtype,o)}const I={kernelName:t.Real,backendName:"cpu",kernelFunc:g};function b(e){const{inputs:a,backend:n,attrs:s}=e,{x:o}=a,{dtype:r}=s;if("complex64"===r){if("complex64"===o.dtype)return m({inputs:{x:o},backend:n});const e=t.zeros(o.shape),a=b({inputs:{x:o},backend:n,attrs:{dtype:"float32"}}),s=h({inputs:{real:a,imag:e},backend:n});return e.dispose(),n.disposeIntermediateTensorInfo(a),s}if("complex64"===o.dtype){const e=g({inputs:{input:o},backend:n}),t=b({inputs:{x:e},backend:n,attrs:{dtype:r}});return n.disposeIntermediateTensorInfo(e),t}if(!t.util.hasEncodingLoss(o.dtype,r)){const e=m({inputs:{x:o},backend:n});return{dataId:e.dataId,shape:e.shape,dtype:r}}if("int32"===r){const e=n.data.get(o.dataId).values,t=Int32Array.from(e);return n.makeTensorInfo(o.shape,"int32",t)}if("bool"===r){const e=n.data.get(o.dataId).values,a=t.util.toTypedArray([0],o.dtype),[s,r]=p((e,t)=>e!==t?1:0)(o.shape,[],e,a,"bool");return n.makeTensorInfo(r,"bool",s)}throw new Error(`Error in Cast: failed to cast ${o.dtype} to ${r}`)}const y={kernelName:t.Cast,backendName:"cpu",kernelFunc:b};function S(e,t,a,s){return null==a?({inputs:a,backend:o})=>{const{a:r,b:i}=a,d=o;n([r,i],e);const l=d.data.get(r.dataId).values,c=d.data.get(i.dataId).values,u=s||r.dtype,[p,h]=t(r.shape,i.shape,l,c,u);return d.makeTensorInfo(h,u,p)}:({inputs:e,backend:n})=>{const{a:o,b:r}=e,i=n;if("complex64"===o.dtype||"complex64"===r.dtype){const e=b({inputs:{x:o},backend:i,attrs:{dtype:"complex64"}}),t=i.data.get(e.dataId),n=t.complexTensorInfos.real,s=t.complexTensorInfos.imag,d=i.data.get(n.dataId).values,l=i.data.get(s.dataId).values,c=b({inputs:{x:r},backend:i,attrs:{dtype:"complex64"}}),u=i.data.get(c.dataId),p=u.complexTensorInfos.real,f=u.complexTensorInfos.imag,m=i.data.get(p.dataId).values,k=i.data.get(f.dataId).values,[g,I,y]=a(o.shape,r.shape,d,l,m,k),S=i.makeTensorInfo(y,"float32",g),N=i.makeTensorInfo(y,"float32",I),T=h({inputs:{real:S,imag:N},backend:i});return i.disposeIntermediateTensorInfo(e),i.disposeIntermediateTensorInfo(c),i.disposeIntermediateTensorInfo(S),i.disposeIntermediateTensorInfo(N),T}{const e=i.data.get(o.dataId).values,a=i.data.get(r.dataId).values,n=s||o.dtype,[d,l]=t(o.shape,r.shape,e,a,n);return i.makeTensorInfo(l,n,d)}}}function N(e){return(a,n,s,o,r,i)=>{const d=t.backend_util.assertAndGetBroadcastShape(a,n),l=t.util.sizeFromShape(d),c=d.length,u=t.util.computeStrides(d),p=t.util.getTypedArrayFromDType("float32",l),h=t.util.getTypedArrayFromDType("float32",l),f=t.backend_util.getBroadcastDims(a,d),m=t.backend_util.getBroadcastDims(n,d),k=t.backend_util.mergeRealAndImagArrays(s,o),g=t.backend_util.mergeRealAndImagArrays(r,i),I=a.length,b=t.util.computeStrides(a),y=n.length,S=t.util.computeStrides(n);if(f.length+m.length===0)for(let t=0;t<p.length;t++){const a=t%k.length,n=t%g.length,s=e(k[2*a],k[2*a+1],g[2*n],g[2*n+1]);p[t]=s.real,h[t]=s.imag}else for(let a=0;a<p.length;a++){const n=t.util.indexToLoc(a,c,u),s=n.slice(-I);f.forEach(e=>s[e]=0);const o=t.util.locToIndex(s,I,b),r=n.slice(-y);m.forEach(e=>r[e]=0);const i=t.util.locToIndex(r,y,S),d=e(k[2*o],k[2*o+1],g[2*i],g[2*i+1]);p[a]=d.real,h[a]=d.imag}return[p,h,d]}}const T=p((e,t)=>e+t),F=N((e,t,a,n)=>({real:e+a,imag:t+n})),x=S(t.Add,T,F),v={kernelName:t.Add,backendName:"cpu",kernelFunc:x};function M(e){return(a,n,s)=>{const o=t.util.getTypedArrayFromDType(n,a.length);for(let t=0;t<a.length;++t)o[t]=e(a[t],s);return o}}function A(e,a,s){return({inputs:o,attrs:r,backend:i})=>{const{x:d}=o;if(n(d,e),"string"===d.dtype||"string"===s)throw new Error("unaryKernelFunc does not support string input/output");const l=i,c=l.data.get(d.dataId).values,u=t.util.sizeFromShape(d.shape),p=s||d.dtype,h=t.util.getArrayFromDType(p,u);for(let e=0;e<u;++e)h[e]=a(c[e],r);return l.makeTensorInfo(d.shape,p,h)}}function D(e,t,a){return({inputs:s,attrs:o,backend:r})=>{const{x:i}=s;if(n(i,e),"string"===i.dtype||"string"===a)throw new Error("unaryKernelFunc does not support string input/output");const d=r,l=d.data.get(i.dataId).values,c=a||i.dtype,u=t(l,c,o);return d.makeTensorInfo(i.shape,c,u)}}const _=M(e=>Math.ceil(e)),z=D(t.Ceil,_),W={kernelName:t.Ceil,backendName:"cpu",kernelFunc:z},w=M(e=>Math.exp(e)),H=D(t.Exp,w),C={kernelName:t.Exp,backendName:"cpu",kernelFunc:H},B=M(e=>Math.expm1(e)),E=D(t.Expm1,B),R={kernelName:t.Expm1,backendName:"cpu",kernelFunc:E},P=M(e=>Math.floor(e)),O=D(t.Floor,P),q={kernelName:t.Floor,backendName:"cpu",kernelFunc:O},$=M(e=>Math.log(e)),L=D(t.Log,$),V={kernelName:t.Log,backendName:"cpu",kernelFunc:L};function G(e,a,n,s){const o=t.util.getTypedArrayFromDType(s,t.util.sizeFromShape(n));for(let t=0;t<o.length;++t){const n=t*a;let s=e[n];for(let t=0;t<a;++t){const a=e[n+t];a>s&&(s=a)}o[t]=s}return o}const U=p((e,t)=>e*t),j=N((e,t,a,n)=>({real:e*a-t*n,imag:e*n+t*a})),K=S(t.Multiply,U,j),Y={kernelName:t.Multiply,backendName:"cpu",kernelFunc:K},Z=p((e,t)=>e!==t?1:0),J=S(t.NotEqual,Z,null,"bool"),Q={kernelName:t.NotEqual,backendName:"cpu",kernelFunc:J},X=M(e=>1/Math.sqrt(e)),ee=D(t.Rsqrt,X),te={kernelName:t.Rsqrt,backendName:"cpu",kernelFunc:ee};function ae(e,a,n,s,o){const r=t.slice_util.isSliceContinous(s,a,n),i=t.util.sizeFromShape(n),d=t.util.computeStrides(s);if(r){const n=t.slice_util.computeFlatOffset(a,d);return e.subarray(n,n+i)}const l=t.util.getTypedArrayFromDType(o,i);for(let o=0;o<i;++o){const r=n.length,i=t.util.computeStrides(n),c=t.util.indexToLoc(o,r,i).map((e,t)=>e+a[t]),u=t.util.locToIndex(c,s.length,d);l[o]=e[u]}return l}function ne(e){const{inputs:a,backend:s,attrs:o}=e,{x:r}=a,{begin:i,size:d}=o;n(r,"slice");const[l,c]=t.slice_util.parseSliceParams(r,i,d);t.slice_util.assertParamsValid(r,l,c);const u=ae(s.data.get(r.dataId).values,l,c,r.shape,r.dtype);return s.makeTensorInfo(c,r.dtype,u)}const se={kernelName:t.Slice,backendName:"cpu",kernelFunc:ne},oe=p((e,t)=>{const a=e-t;return a*a}),re=S(t.SquaredDifference,oe),ie={kernelName:t.SquaredDifference,backendName:"cpu",kernelFunc:re},de=p((e,t)=>e-t),le=N((e,t,a,n)=>({real:e-a,imag:t-n})),ce=S(t.Sub,de,le),ue={kernelName:t.Sub,backendName:"cpu",kernelFunc:ce};function pe(e,a,n,s,o){const r=a.length,i=t.util.sizeFromShape(a),d=t.util.computeStrides(a),l=t.util.computeStrides(o),c=t.util.getTypedArrayFromDType(n,t.util.sizeFromShape(o));for(let a=0;a<i;++a){const n=t.util.indexToLoc(a,r,d),o=new Array(n.length);for(let e=0;e<o.length;e++)o[e]=n[s[e]];c[t.util.locToIndex(o,r,l)]=e[a]}return c}function he(e,a,n,s){const o=t.util.parseAxisParam(a,n)[0],r=[1,n[0],1];for(let e=0;e<o;e++)r[0]*=n[e];r[1]=n[o];for(let e=o+1;e<n.length;e++)r[2]*=n[e];const i={},d=new Int32Array(n[o]),l=new t.TensorBuffer(r,s,e),c=[],u=1===r[0]&&1===r[2];for(let t=0;t<n[o];t++){let a;if(u)a=e[t].toString();else{const e=[];for(let a=0;a<r[0];a++)for(let n=0;n<r[2];n++)e.push(l.get(a,t,n));a=e.join(",")}if(void 0!==i[a])d[t]=i[a];else{const e=Object.keys(i).length;i[a]=e,d[t]=e,c.push(t)}}const p=r.slice();p[1]=Object.keys(i).length;const h=new t.TensorBuffer(p,s);c.forEach((e,t)=>{for(let a=0;a<r[0];a++)for(let n=0;n<r[2];n++)h.set(l.get(a,e,n),a,t,n)});const f=n.slice();return f[o]=p[1],{outputValues:h.values,outputShape:f,indices:d}}var fe=Object.freeze({__proto__:null,simpleAbsImpl:c,addImpl:T,ceilImpl:_,expImpl:w,expm1Impl:B,floorImpl:P,logImpl:$,maxImpl:G,multiplyImpl:U,notEqualImpl:Z,rsqrtImpl:X,sliceImpl:ae,squaredDifferenceImpl:oe,subImpl:de,transposeImpl:pe,uniqueImpl:he});t.registerBackend("cpu",()=>new l,1);const me=A(t.Elu,e=>e>=0?e:Math.exp(e)-1),ke={kernelName:t.Elu,backendName:"cpu",kernelFunc:me},ge=p((e,t)=>e<0?t*e:e);function Ie(e){const{inputs:t,backend:a}=e,{x:s,alpha:o}=t;n([s,o],"prelu");const r=a.data.get(s.dataId).values,i=a.data.get(o.dataId).values,[d,l]=ge(s.shape,o.shape,r,i,s.dtype);return a.makeTensorInfo(l,s.dtype,d)}const be={kernelName:t.Prelu,backendName:"cpu",kernelFunc:Ie},ye=A(t.Relu,e=>Math.max(0,e)),Se={kernelName:t.Relu,backendName:"cpu",kernelFunc:ye},Ne=A(t.Relu6,e=>Math.min(Math.max(0,e),6)),Te={kernelName:t.Relu6,backendName:"cpu",kernelFunc:Ne};function Fe(e,t,a,n){if("linear"===a)return m({inputs:{x:t},backend:e});if("relu"===a)return ye({inputs:{x:t},backend:e});if("elu"===a)return me({inputs:{x:t},backend:e});if("relu6"===a)return Ne({inputs:{x:t},backend:e});if("prelu"===a)return Ie({inputs:{x:t,alpha:n},backend:e});throw new Error(`Activation ${a} has not been implemented for the CPU backend.`)}function xe(e){const{inputs:a,backend:n,attrs:s}=e,{x:o}=a,{shape:r}=s,i=t.util.sizeFromShape(o.shape),d=t.util.inferFromImplicitShape(r,i),l=t.util.sizeFromShape(d);t.util.assert(i===l,()=>`The new shape (${d}) has ${l} elements and the old `+`shape (${o.shape}) has ${i} elements. The new shape and old `+"shape must have the same number of elements."),n.incRef(o.dataId);const c=n.data.get(o.dataId);if(null!=c.complexTensorInfos){const e=c.complexTensorInfos.real,t=c.complexTensorInfos.imag;e.shape=d,t.shape=d}return{dataId:o.dataId,shape:d,dtype:o.dtype}}const ve={kernelName:t.Reshape,backendName:"cpu",kernelFunc:xe};function Me(e){const{inputs:a,backend:s,attrs:o}=e,{a:r,b:i}=a,{transposeA:d,transposeB:l}=o;n([r,i],"matMul");const c=r.shape.length,u=i.shape.length,p=d?r.shape[c-2]:r.shape[c-1],h=l?i.shape[u-1]:i.shape[u-2],f=d?r.shape[c-1]:r.shape[c-2],m=l?i.shape[u-2]:i.shape[u-1],k=r.shape.slice(0,-2),g=i.shape.slice(0,-2),I=t.util.sizeFromShape(k),b=t.util.sizeFromShape(g),y=I===b||1===I||1===b;t.util.assert(c>=2&&u>=2&&y,()=>"Error in matMul: the input batch dimensions must either be the same or at least one input batch dimension must be 1. Got input "+`batch dimensions of (${k}) and (${g}).`);const S=(I>b?r.shape.slice(0,-2):i.shape.slice(0,-2)).concat([f,m]);t.util.assert(p===h,()=>`Error in matMul: inner shapes (${p}) and (`+`${h}) of Tensors with shapes ${r.shape} and `+`${i.shape} and transposeA=${d}`+` and transposeB=${l} must match.`);const N=l?[b,m,h]:[b,h,m],T=xe({inputs:{x:r},backend:s,attrs:{shape:d?[I,p,f]:[I,f,p]}}),F=xe({inputs:{x:i},backend:s,attrs:{shape:N}}),x=d?T.shape[1]:T.shape[2],v=d?T.shape[2]:T.shape[1],M=l?F.shape[1]:F.shape[2],A=Math.max(I,b),D=s.data.get(T.dataId).values,_=s.data.get(F.dataId).values,z=t.util.computeStrides(T.shape),W=t.util.computeStrides(F.shape),[w,H,C]=d?[z[0],1,z[1]]:[z[0],z[1],1],[B,E,R]=l?[1,W[1],W[0]]:[W[1],1,W[0]],P=v*M,O=t.buffer([A,v,M],T.dtype),q=O.values,$=s.blockSize;for(let e=0;e<A;e++)for(let t=0;t<v;t+=$)for(let a=0;a<M;a+=$)for(let n=0;n<x;n+=$){const s=Math.min(t+$,v),o=Math.min(a+$,M),r=Math.min(n+$,x);for(let i=t;i<s;i++)for(let t=a;t<o;t++){let a=0;for(let s=n;s<r;s++){const n=Math.min(e,I-1)*w,o=Math.min(e,b-1)*R;a+=D[n+i*H+s*C]*_[s*B+t*E+o]}q[e*P+(i*M+t)]+=a}}return s.disposeIntermediateTensorInfo(T),s.disposeIntermediateTensorInfo(F),s.makeTensorInfo(S,O.dtype,O.values)}const Ae={kernelName:t.BatchMatMul,backendName:"cpu",kernelFunc:Me};const De={kernelName:t._FusedMatMul,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:a,attrs:n}=e,{a:s,b:o,bias:r,preluActivationWeights:i}=t,{transposeA:d,transposeB:l,activation:c}=n;let u,p,h;const f=[];u=Me({inputs:{a:s,b:o},attrs:{transposeA:d,transposeB:l},backend:a}),r&&(p=x({inputs:{a:u,b:r},backend:a}),f.push(u),u=p),c&&(h=Fe(a,u,c,i),f.push(u),u=h);for(const e of f)a.disposeIntermediateTensorInfo(e);return u}},_e=A(t.Acos,e=>Math.acos(e)),ze={kernelName:t.Acos,backendName:"cpu",kernelFunc:_e},We=A(t.Acosh,e=>Math.acosh(e)),we={kernelName:t.Acosh,backendName:"cpu",kernelFunc:We},He=A(t.Asin,e=>Math.asin(e)),Ce={kernelName:t.Asin,backendName:"cpu",kernelFunc:He},Be=A(t.Asinh,e=>Math.asinh(e)),Ee={kernelName:t.Asinh,backendName:"cpu",kernelFunc:Be},Re=A(t.Atan,e=>Math.atan(e)),Pe={kernelName:t.Atan,backendName:"cpu",kernelFunc:Re},Oe=A(t.Atanh,e=>Math.atanh(e)),qe={kernelName:t.Atanh,backendName:"cpu",kernelFunc:Oe};function $e(e,a,n,s,o,r){const i=o.strideHeight,d=o.strideWidth,l=o.dilationHeight,c=o.dilationWidth,u=o.effectiveFilterHeight,p=o.effectiveFilterWidth,h=o.padInfo.top,f=o.padInfo.left,m="max"===r?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY,k=t.buffer(o.outShape,n),g=k.values,I=o.outShape[1]*o.outShape[2]*o.outShape[3],b=o.outShape[2]*o.outShape[3],y=o.outShape[3];for(let t=0;t<o.batchSize;++t){const a=t*I,n=t*s[0];for(let t=0;t<o.inChannels;++t)for(let k=0;k<o.outHeight;++k){const I=k*i-h,S=Math.max(0,I),N=Math.min(o.inHeight,u+I),T=a+k*b;for(let a=0;a<o.outWidth;++a){const i=a*d-f,u=Math.max(0,i),h=Math.min(o.inWidth,p+i);let k=m,I=0,b=0;for(let a=S;a<N;a+=l){const o=n+a*s[1];for(let a=u;a<h;a+=c){const n=e[o+a*s[2]+t];"max"===r&&n>k?k=n:"avg"===r&&(I+=n,b++)}if(isNaN(k))break}g[T+a*y+t]="avg"===r?I/b:k}}}return k}function Le(e,a,n,s,o=!1,r=!1){const i=t.buffer(s.outShape,"int32"),d=s.strideHeight,l=s.strideWidth,c=s.dilationHeight,u=s.dilationWidth,p=s.effectiveFilterHeight,h=s.effectiveFilterWidth,f=s.padInfo.top,m=s.padInfo.left,k=t.buffer(a,n,e);for(let e=0;e<s.batchSize;++e)for(let t=0;t<s.inChannels;++t)for(let a=0;a<s.outHeight;++a){const n=a*d-f;let g=n;for(;g<0;)g+=c;const I=Math.min(s.inHeight,p+n);for(let d=0;d<s.outWidth;++d){const p=d*l-m;let f=p;for(;f<0;)f+=u;const b=Math.min(s.inWidth,h+p);let y=Number.NEGATIVE_INFINITY,S=-1;for(let a=g;a<I;a+=c){const i=a-n;for(let n=f;n<b;n+=u){const d=n-p,l=k.get(e,a,n,t);l>y&&(y=l,S=o?r?((e*s.inHeight+a)*s.inWidth+n)*s.inChannels+t:(a*s.inWidth+n)*s.inChannels+t:i*h+d)}}i.set(S,e,a,d,t)}}return i}const Ve={kernelName:t.AvgPool,backendName:"cpu",kernelFunc:function(e){const{inputs:a,backend:s,attrs:o}=e,{x:r}=a;n(r,"avgPool");const{filterSize:i,strides:d,pad:l,dimRoundingMode:c}=o;t.util.assert(t.backend_util.eitherStridesOrDilationsAreOne(d,1),()=>"Error in avgPool: Either strides or dilations must be 1. "+`Got strides ${d} and dilations '1'`);const u=t.backend_util.computePool2DInfo(r.shape,i,d,1,l,c);let p;if(1===u.filterWidth&&1===u.filterHeight&&t.util.arraysEqual(u.inShape,u.outShape))p=m({inputs:{x:r},backend:s});else{const e=s.data.get(r.dataId).values,a=t.util.computeStrides(r.shape),n=$e(e,r.shape,r.dtype,a,u,"avg");p=s.makeTensorInfo(u.outShape,r.dtype,n.values)}return p}};const Ge={kernelName:t.AvgPoolBackprop,backendName:"cpu",kernelFunc:function(e){const{inputs:a,backend:s,attrs:o}=e,{dy:r,input:i}=a,d=i;n([r,i],"avgPoolBackprop");const{filterSize:l,strides:c,pad:u}=o,p=t.backend_util.computePool2DInfo(d.shape,l,c,1,u),h=p.strideHeight,f=p.strideWidth,m=p.filterHeight,k=p.filterWidth,g=p.dilationHeight,I=p.dilationWidth,b=p.effectiveFilterHeight,y=p.effectiveFilterWidth,S=y-1-p.padInfo.left,N=b-1-p.padInfo.top,T=t.buffer(d.shape,"float32"),F=1/(m*k),x=s.data.get(r.dataId).values,v=t.buffer(r.shape,"float32",x);for(let e=0;e<p.batchSize;++e)for(let t=0;t<p.inChannels;++t)for(let a=0;a<p.inHeight;++a)for(let n=0;n<p.inWidth;++n){const s=a-N,o=n-S;let r=0;for(let a=0;a<b;a+=g){const n=(s+a)/h;if(!(n<0||n>=p.outHeight||Math.floor(n)!==n))for(let a=0;a<y;a+=I){const s=(o+a)/f;s<0||s>=p.outWidth||Math.floor(s)!==s||(r+=v.get(e,n,s,t))}}T.set(r*F,e,a,n,t)}return s.makeTensorInfo(T.shape,T.dtype,T.values)}};const Ue={kernelName:t.FusedBatchNorm,backendName:"cpu",kernelFunc:function(e){const{inputs:a,backend:s,attrs:o}=e,{x:r,scale:i,offset:d,mean:l,variance:c}=a;t.util.assert(l.shape.length===c.shape.length,()=>"Batch normalization gradient requires mean and variance to have equal ranks."),t.util.assert(null==d||l.shape.length===d.shape.length,()=>"Batch normalization gradient requires mean and offset to have equal ranks."),t.util.assert(null==i||l.shape.length===i.shape.length,()=>"Batch normalization gradient requires mean and scale to have equal ranks."),n([r,l,c,i,d],"batchNorm");let{varianceEpsilon:u}=o;null==u&&(u=.001);const p=s.data.get(r.dataId).values,h=s.data.get(l.dataId).values,f=s.data.get(c.dataId).values,m=i?s.data.get(i.dataId).values:new Float32Array([1]),k=d?s.data.get(d.dataId).values:new Float32Array([0]),g=new Float32Array(p.length),I=k.length,b=m.length,y=f.length,S=h.length;let N=0,T=0,F=0,x=0;for(let e=0;e<p.length;++e)g[e]=k[N++]+(p[e]-h[T++])*m[F++]/Math.sqrt(f[x++]+u),N>=I&&(N=0),T>=S&&(T=0),F>=b&&(F=0),x>=y&&(x=0);return s.makeTensorInfo(r.shape,r.dtype,g)}},je=A(t.ClipByValue,(e,t)=>{const a=t;return e>a.clipValueMax?a.clipValueMax:e<a.clipValueMin?a.clipValueMin:e}),Ke={kernelName:t.ClipByValue,backendName:"cpu",kernelFunc:je};function Ye(e){const{inputs:t,backend:a}=e,{input:n}=t,s=a.data.get(n.dataId).complexTensorInfos.imag,o=a.data.get(s.dataId).values;return a.makeTensorInfo(s.shape,s.dtype,o)}const Ze={kernelName:t.Imag,backendName:"cpu",kernelFunc:Ye};function Je(e){const{inputs:a,backend:n,attrs:s}=e,{axis:o}=s,r=t.util.parseAxisParam(o,a[0].shape)[0];let i=t.backend_util.computeOutShape(a.map(e=>e.shape),r);if(0===t.util.sizeFromShape(i))return n.makeTensorInfo(i,a[0].dtype,[]);const d=a.filter(e=>t.util.sizeFromShape(e.shape)>0);if(1===d.length)return d[0];const l=d.map(e=>e.shape);if(t.backend_util.assertParamsConsistent(l,r),"complex64"===d[0].dtype){const e=d.map(e=>g({inputs:{input:e},backend:n})),t=d.map(e=>Ye({inputs:{input:e},backend:n})),a=Je({inputs:e,backend:n,attrs:{axis:r}}),s=Je({inputs:t,backend:n,attrs:{axis:r}}),o=h({inputs:{real:a,imag:s},backend:n});return e.forEach(e=>n.disposeIntermediateTensorInfo(e)),t.forEach(e=>n.disposeIntermediateTensorInfo(e)),n.disposeIntermediateTensorInfo(a),n.disposeIntermediateTensorInfo(s),o}const c=d.map(e=>{const a=t.util.sizeFromShape(e.shape.slice(r));return xe({inputs:{x:e},backend:n,attrs:{shape:[-1,a]}})});i=t.backend_util.computeOutShape(c.map(e=>e.shape),1);const u=t.util.getTypedArrayFromDType(d[0].dtype,t.util.sizeFromShape(i));if(1===c[0].shape[0]){let e=0;c.forEach(a=>{const s=n.data.get(a.dataId).values,o=t.util.sizeFromShape(a.shape);u.set(s,e),e+=o})}else{let e=0;c.forEach(t=>{const a=n.data.get(t.dataId).values;let s=0;for(let n=0;n<t.shape[0];++n){const o=n*i[1]+e;for(let e=0;e<t.shape[1];++e)u[o+e]=a[s++]}e+=t.shape[1]})}const p=t.backend_util.computeOutShape(d.map(e=>e.shape),r),f=n.makeTensorInfo(p,a[0].dtype,u);return c.forEach(e=>n.disposeIntermediateTensorInfo(e)),f}const Qe={kernelName:t.Concat,backendName:"cpu",kernelFunc:Je};function Xe(e){const{inputs:a,backend:s,attrs:o}=e,{x:r,filter:i}=a,{strides:d,pad:l,dataFormat:c,dilations:u,dimRoundingMode:p}=o;n([r,i],"conv2d");const h=t.backend_util.convertConv2DDataFormat(c),f=t.backend_util.computeConv2DInfo(r.shape,i.shape,d,u,l,p,!1,h),m=f.filterHeight,k=f.filterWidth,g=f.dilationHeight,I=f.dilationWidth,b=f.padInfo.left,y=f.padInfo.top,S="channelsLast"===f.dataFormat,N=new t.TensorBuffer(f.outShape,r.dtype),T=t.util.computeStrides(r.shape),F=t.util.computeStrides(i.shape),x=T[0],v=S?T[1]:T[2],M=S?T[2]:1,A=S?1:T[1],D=N.strides[0],_=S?N.strides[1]:N.strides[2],z=S?N.strides[2]:1,W=S?1:N.strides[1],w=s.data.get(r.dataId).values,H=s.data.get(i.dataId).values,C=N.values;for(let e=0;e<f.batchSize;++e){const t=e*x,a=e*D;for(let e=0;e<f.outHeight;++e){const n=a+e*_,s=e*f.strideHeight-y;for(let e=0;e<m;++e){const a=s+e*g;if(a<0||a>=f.inHeight)continue;const o=e*F[0],r=t+a*v;for(let e=0;e<f.outWidth;++e){const t=n+e*z,a=e*f.strideWidth-b;for(let e=0;e<k;++e){const n=a+e*I;if(n<0||n>=f.inWidth)continue;const s=r+n*M;let i=o+e*F[1];for(let e=0;e<f.inChannels;++e){const a=w[s+e*A];for(let e=0;e<f.outChannels;++e)C[t+e*W]+=a*H[i+e];i+=f.outChannels}}}}}}return s.makeTensorInfo(N.shape,N.dtype,C)}const et={kernelName:t.Conv2D,backendName:"cpu",kernelFunc:Xe};const tt={kernelName:t.Conv2DBackpropFilter,backendName:"cpu",kernelFunc:function(e){const{inputs:a,backend:s,attrs:o}=e,{x:r,dy:i}=a,{strides:d,pad:l,dataFormat:c,dimRoundingMode:u,filterShape:p}=o;n([r,i],"conv2dBackpropFilter");const h=t.backend_util.convertConv2DDataFormat(c),f=t.backend_util.computeConv2DInfo(r.shape,p,d,1,l,u,!1,h),{strideHeight:m,strideWidth:k,filterHeight:g,filterWidth:I}=f,b="channelsLast"===f.dataFormat,y=new t.TensorBuffer(f.filterShape,"float32"),S=f.padInfo.left,N=f.padInfo.top,T=s.data.get(r.dataId).values,F=s.data.get(i.dataId).values,x=new t.TensorBuffer(r.shape,r.dtype,T),v=new t.TensorBuffer(i.shape,i.dtype,F);for(let e=0;e<g;++e){const t=Math.max(0,Math.ceil((N-e)/m)),a=Math.min(f.outHeight,(f.inHeight+N-e)/m);for(let n=0;n<I;++n){const s=Math.max(0,Math.ceil((S-n)/k)),o=Math.min(f.outWidth,(f.inWidth+S-n)/k);for(let r=0;r<f.inChannels;++r)for(let i=0;i<f.outChannels;++i){let d=0;for(let l=0;l<f.batchSize;++l)for(let c=t;c<a;++c){const t=e+c*m-N;for(let e=s;e<o;++e){const a=n+e*k-S;d+=b?x.get(l,t,a,r)*v.get(l,c,e,i):x.get(l,r,t,a)*v.get(l,i,c,e)}}y.set(d,e,n,r,i)}}}return s.makeTensorInfo(y.shape,y.dtype,y.values)}};const at={kernelName:t.Conv2DBackpropInput,backendName:"cpu",kernelFunc:function(e){const{inputs:a,backend:s,attrs:o}=e,{dy:r,filter:i}=a,{inputShape:d,strides:l,pad:c,dataFormat:u,dimRoundingMode:p}=o;n([r,i],"conv2dBackpropInput");const h=t.util.computeStrides(i.shape),f=t.util.computeStrides(r.shape);let m=t.backend_util.convertConv2DDataFormat(u);const k=t.backend_util.computeConv2DInfo(d,i.shape,l,1,c,p,!1,m),g=new t.TensorBuffer(k.inShape,"float32"),I=g.values,b=s.data.get(r.dataId).values,y=s.data.get(i.dataId).values,[S,N,T]=h,{batchSize:F,filterHeight:x,filterWidth:v,inChannels:M,inHeight:A,inWidth:D,outChannels:_,outHeight:z,outWidth:W,strideHeight:w,strideWidth:H}=k;m=k.dataFormat;const C=x-1-k.padInfo.top,B=v-1-k.padInfo.left,E="channelsLast"===m,R=g.strides[0],P=E?g.strides[1]:g.strides[2],O=E?g.strides[2]:1,q=E?1:g.strides[1],$=f[0],L=E?f[1]:f[2],V=E?f[2]:1,G=E?1:f[1];for(let e=0;e<F;++e)for(let t=0;t<M;++t)for(let a=0;a<A;++a){const n=a-C,s=Math.max(0,Math.ceil(n/w)),o=Math.min(z,(x+n)/w);for(let r=0;r<D;++r){const i=r-B,d=Math.max(0,Math.ceil(i/H)),l=Math.min(W,(v+i)/H);let c=0;for(let a=s;a<o;++a){const s=a*w-n;for(let n=d;n<l;++n){const o=$*e+L*a+V*n,r=S*(x-1-s)+N*(v-1-(n*H-i))+T*t;for(let e=0;e<_;++e){c+=b[o+G*e]*y[r+e]}}}I[R*e+P*a+O*r+q*t]=c}}return s.makeTensorInfo(g.shape,g.dtype,g.values)}};const nt={kernelName:t.Conv3D,backendName:"cpu",kernelFunc:function(e){const{inputs:a,backend:s,attrs:o}=e,{x:r,filter:i}=a,{strides:d,pad:l,dilations:c}=o;n([r,i],"conv3d");const u=t.backend_util.computeConv3DInfo(r.shape,i.shape,d,c,l),{filterDepth:p,filterHeight:h,filterWidth:f,dilationDepth:m,dilationHeight:k,dilationWidth:g,padInfo:I}=u,b=I.front,y=I.left,S=I.top,N=new t.TensorBuffer(u.outShape,r.dtype),T=s.data.get(r.dataId).values,F=s.data.get(i.dataId).values,x=N.values,v=t.util.computeStrides(r.shape),M=t.util.computeStrides(i.shape);for(let e=0;e<u.batchSize;++e){const t=e*v[0],a=e*N.strides[0];for(let e=0;e<u.outDepth;++e){const n=a+e*N.strides[1],s=e*u.strideDepth-b;for(let e=0;e<p;++e){const a=s+e*m;if(a<0||a>=u.inDepth)continue;const o=e*M[0],r=t+a*v[1];for(let e=0;e<u.outHeight;++e){const t=n+e*N.strides[2],a=e*u.strideHeight-S;for(let e=0;e<h;++e){const n=a+e*k;if(n<0||n>=u.inHeight)continue;const s=o+e*M[1],i=r+n*v[2];for(let e=0;e<u.outWidth;++e){const a=t+e*u.outChannels,n=e*u.strideWidth-y;for(let e=0;e<f;++e){const t=n+e*g;if(t<0||t>=u.inWidth)continue;const o=s+e*M[2],r=i+t*u.inChannels;let d=o;for(let e=0;e<u.inChannels;++e){const t=T[r+e];for(let e=0;e<u.outChannels;++e)x[a+e]+=t*F[d+e];d+=u.outChannels}}}}}}}}return s.makeTensorInfo(N.shape,N.dtype,N.values)}};const st={kernelName:t.Conv3DBackpropFilterV2,backendName:"cpu",kernelFunc:function(e){const{inputs:a,backend:s,attrs:o}=e,{x:r,dy:i}=a,{strides:d,pad:l,filterShape:c}=o;n([r,i],"conv3dBackpropFilterV2");const u=t.util.computeStrides(r.shape),p=t.util.computeStrides(i.shape),h=t.backend_util.computeConv3DInfo(r.shape,c,d,1,l),f=h.strideDepth,m=h.strideHeight,k=h.strideWidth,g=h.filterDepth,I=h.filterHeight,b=h.filterWidth,y=new t.TensorBuffer(h.filterShape,"float32"),S=y.values,[N,T,F,x]=y.strides,v=s.data.get(i.dataId).values,[M,A,D,_]=p,z=s.data.get(r.dataId).values,[W,w,H,C]=u,B=h.padInfo.front,E=h.padInfo.left,R=h.padInfo.top;for(let e=0;e<g;++e){const t=Math.max(0,Math.ceil((B-e)/f)),a=Math.min(h.outDepth,(h.inDepth+B-e)/f),n=e*N;for(let s=0;s<I;++s){const o=Math.max(0,Math.ceil((R-s)/m)),r=Math.min(h.outHeight,(h.inHeight+R-s)/m),i=s*T+n;for(let n=0;n<b;++n){const d=Math.max(0,Math.ceil((E-n)/k)),l=Math.min(h.outWidth,(h.inWidth+E-n)/k),c=n*F+i;for(let i=0;i<h.inChannels;++i){const u=i*x+c;for(let c=0;c<h.outChannels;++c){let p=0;for(let u=0;u<h.batchSize;++u){const h=u*W,g=u*M;for(let u=t;u<a;++u){const t=(e+u*f-B)*w+h,a=u*A+g;for(let e=o;e<r;++e){const o=(s+e*m-R)*H+t,r=e*D+a;for(let e=d;e<l;++e){const t=e*_+r;p+=z[(n+e*k-E)*C+o+i]*v[t+c]}}}}S[u+c]=p}}}}}return s.makeTensorInfo(y.shape,y.dtype,y.values)}};const ot={kernelName:t.Conv3DBackpropInputV2,backendName:"cpu",kernelFunc:function(e){const{inputs:a,backend:s,attrs:o}=e,{dy:r,filter:i}=a,{pad:d,strides:l,inputShape:c}=o;n([r],"conv3dBackpropInputV2");const u=t.util.computeStrides(r.shape),p=t.util.computeStrides(i.shape),h=t.backend_util.computeConv3DInfo(c,i.shape,l,1,d),f=new t.TensorBuffer(h.inShape,"float32"),m=f.values,[k,g,I,b]=f.strides,y=s.data.get(r.dataId).values,[S,N,T,F]=u,x=s.data.get(i.dataId).values,[v,M,A,D]=p,{batchSize:_,filterDepth:z,filterHeight:W,filterWidth:w,inChannels:H,inDepth:C,inHeight:B,inWidth:E,outChannels:R,outDepth:P,outHeight:O,outWidth:q,strideDepth:$,strideHeight:L,strideWidth:V}=h,G=z-1-h.padInfo.front,U=W-1-h.padInfo.top,j=w-1-h.padInfo.left;for(let e=0;e<_;++e)for(let t=0;t<H;++t)for(let a=0;a<C;++a){const n=a-G,s=Math.max(0,Math.ceil(n/$)),o=Math.min(P,(z+n)/$);for(let r=0;r<B;++r){const i=r-U,d=Math.max(0,Math.ceil(i/L)),l=Math.min(O,(W+i)/L);for(let c=0;c<E;++c){const u=c-j,p=Math.max(0,Math.ceil(u/V)),h=Math.min(q,(w+u)/V);let f=0;for(let a=s;a<o;++a){const s=a*$-n;for(let n=d;n<l;++n){const o=n*L-i;for(let r=p;r<h;++r){const i=S*e+N*a+T*n+F*r,d=v*(z-1-s)+M*(W-1-o)+A*(w-1-(r*V-u))+D*t;for(let e=0;e<R;++e){f+=y[i+e]*x[d+e]}}}}m[k*e+g*a+I*r+b*c+t]=f}}}return s.makeTensorInfo(f.shape,f.dtype,f.values)}},rt=A(t.Cos,e=>Math.cos(e)),it={kernelName:t.Cos,backendName:"cpu",kernelFunc:rt},dt=A(t.Cosh,e=>Math.cosh(e)),lt={kernelName:t.Cosh,backendName:"cpu",kernelFunc:dt};function ct(e){const{inputs:a,backend:s,attrs:o}=e,{x:r,filter:i}=a,{strides:d,pad:l,dilations:c,dimRoundingMode:u}=o;n([r,i],"depthwiseConv2DNative");const p=t.util.computeStrides(r.shape),h=t.util.computeStrides(i.shape);let f=c;null==f&&(f=[1,1]),t.util.assert(t.backend_util.eitherStridesOrDilationsAreOne(d,f),()=>"Error in depthwiseConv2d: Either strides or dilations must be "+`1. Got strides ${d} and dilations '${f}'`);const m=t.backend_util.computeConv2DInfo(r.shape,i.shape,d,f,l,u,!0),{filterHeight:k,filterWidth:g,dilationHeight:I,dilationWidth:b,padInfo:y}=m,S=y.left,N=y.top,T=m.outChannels/m.inChannels,F=new t.TensorBuffer(m.outShape,r.dtype),x=s.data.get(r.dataId).values,v=s.data.get(i.dataId).values,M=F.values;for(let e=0;e<m.batchSize;++e){const t=e*p[0],a=e*F.strides[0];for(let e=0;e<m.outHeight;++e){const n=a+e*F.strides[1],s=e*m.strideHeight-S;for(let e=0;e<k;++e){const a=s+e*I;if(a<0||a>=m.inHeight)continue;const o=e*h[0],r=t+a*p[1];for(let e=0;e<m.outWidth;++e){const t=n+e*F.strides[2],a=e*m.strideWidth-N;for(let e=0;e<g;++e){const n=a+e*b;if(n<0||n>=m.inWidth)continue;const s=o+e*h[1],i=r+n*m.inChannels;let d=t,l=s;for(let e=0;e<m.inChannels;++e){const t=x[i+e];for(let e=0;e<T;++e)M[d+e]+=t*v[l+e];d+=T,l+=T}}}}}}return s.makeTensorInfo(F.shape,F.dtype,F.values)}const ut={kernelName:t.DepthwiseConv2dNative,backendName:"cpu",kernelFunc:ct};const pt={kernelName:t.DepthwiseConv2dNativeBackpropFilter,backendName:"cpu",kernelFunc:function(e){const{inputs:a,backend:s,attrs:o}=e,{x:r,dy:i}=a,{strides:d,dilations:l,pad:c,dimRoundingMode:u,filterShape:p}=o;n([r,i],"depthwiseConv2dNativeBackpropFilter");const h=t.backend_util.computeConv2DInfo(r.shape,p,d,l,c,u,!0),{strideHeight:f,strideWidth:m,filterHeight:k,filterWidth:g}=h,I=new t.TensorBuffer(h.filterShape,"float32"),b=h.padInfo.left,y=h.padInfo.top,S=h.outChannels/h.inChannels,N=s.data.get(r.dataId).values,T=new t.TensorBuffer(r.shape,r.dtype,N),F=s.data.get(i.dataId).values,x=new t.TensorBuffer(i.shape,i.dtype,F);for(let e=0;e<k;++e){const t=Math.max(0,Math.ceil((y-e)/f)),a=Math.min(h.outHeight,(h.inHeight+y-e)/f);for(let n=0;n<g;++n){const s=Math.max(0,Math.ceil((b-n)/m)),o=Math.min(h.outWidth,(h.inWidth+b-n)/m);for(let r=0;r<h.outChannels;++r){const i=Math.trunc(r/S),d=r%S;let l=0;for(let d=0;d<h.batchSize;++d)for(let c=t;c<a;++c){const t=e+c*f-y;for(let e=s;e<o;++e){const a=n+e*m-b;l+=T.get(d,t,a,i)*x.get(d,c,e,r)}}I.set(l,e,n,i,d)}}}return s.makeTensorInfo(I.shape,I.dtype,I.values)}};const ht={kernelName:t.DepthwiseConv2dNativeBackpropInput,backendName:"cpu",kernelFunc:function(e){const{inputs:a,backend:s,attrs:o}=e,{dy:r,filter:i}=a,{strides:d,dilations:l,pad:c,dimRoundingMode:u,inputShape:p}=o;n([r,i],"depthwiseConv2DNativeBackpropInput");const h=t.util.computeStrides(r.shape),f=t.util.computeStrides(i.shape),m=t.backend_util.computeConv2DInfo(p,i.shape,d,l,c,u,!0),k=new t.TensorBuffer(m.inShape,"float32"),g=k.values,[I,b,y]=k.strides,S=s.data.get(r.dataId).values,[N,T,F]=h,x=s.data.get(i.dataId).values,[v,M,A]=f,{batchSize:D,filterHeight:_,filterWidth:z,inChannels:W,inHeight:w,inWidth:H,outChannels:C,outHeight:B,outWidth:E,strideHeight:R,strideWidth:P}=m,O=_-1-m.padInfo.top,q=z-1-m.padInfo.left,$=C/W;for(let e=0;e<D;++e)for(let t=0;t<W;++t)for(let a=0;a<w;++a){const n=a-O,s=Math.max(0,Math.ceil(n/R)),o=Math.min(B,(_+n)/R);for(let r=0;r<H;++r){const i=r-q,d=Math.max(0,Math.ceil(i/P)),l=Math.min(E,(z+i)/P);let c=0;for(let a=s;a<o;++a){const s=a*R-n;for(let n=d;n<l;++n){const o=N*e+T*a+F*n,r=v*(_-1-s)+M*(z-1-(n*P-i))+A*t;for(let e=0;e<$;++e){c+=S[o+(t*$+e)]*x[r+e]}}}g[I*e+b*a+y*r+t]=c}}return s.makeTensorInfo(k.shape,k.dtype,k.values)}},ft={kernelName:t.Dilation2D,backendName:"cpu",kernelFunc:({inputs:e,backend:a,attrs:n})=>{const{x:s,filter:o}=e,{strides:r,pad:i,dilations:d}=n,l=a,c=l.data.get(s.dataId).values,u=s.shape.length,p=l.data.get(o.dataId).values,h=o.shape.length,{batchSize:f,inHeight:m,inWidth:k,inChannels:g,outHeight:I,outWidth:b,padInfo:y,strideHeight:S,strideWidth:N,filterHeight:T,filterWidth:F,dilationHeight:x,dilationWidth:v,outShape:M}=t.backend_util.computeDilation2DInfo(s.shape,o.shape,r,i,"NHWC",d),A=t.util.sizeFromShape(M),D=M.length,_=t.util.getArrayFromDType(s.dtype,A);for(let e=0;e<f;++e)for(let a=0;a<I;++a){const n=a*S-y.top;for(let r=0;r<b;++r){const i=r*N-y.left;for(let d=0;d<g;++d){let l=Number.MIN_SAFE_INTEGER;for(let a=0;a<T;++a){const r=n+a*x;if(r>=0&&r<m)for(let n=0;n<F;++n){const f=i+n*v;if(f>=0&&f<k){const i=t.util.locToIndex([e,r,f,d],u,t.util.computeStrides(s.shape)),m=t.util.locToIndex([a,n,d],h,t.util.computeStrides(o.shape)),k=c[i]+p[m];k>l&&(l=k)}}}_[t.util.locToIndex([e,a,r,d],D,t.util.computeStrides(M))]=l}}}return{dataId:l.write(t.util.toTypedArray(_,s.dtype),M,s.dtype),shape:M,dtype:s.dtype}}},mt={kernelName:t.Dilation2DBackpropFilter,backendName:"cpu",kernelFunc:({inputs:e,backend:a,attrs:n})=>{const{x:s,filter:o,dy:r}=e,{strides:i,pad:d,dilations:l}=n,c=a,u=t.util.toNestedArray(s.shape,c.data.get(s.dataId).values),p=t.util.toNestedArray(o.shape,c.data.get(o.dataId).values),{batchSize:h,inHeight:f,inWidth:m,inChannels:k,outHeight:g,outWidth:I,padInfo:b,strideHeight:y,strideWidth:S,filterHeight:N,filterWidth:T,dilationHeight:F,dilationWidth:x,outShape:v}=t.backend_util.computeDilation2DInfo(s.shape,o.shape,i,d,"NHWC",l);t.util.assert(r.rank===v.length,()=>`Error in ${t.Dilation2DBackpropFilter}, dy `+`must have the same rank as output ${v.length}, but got `+`${r.rank}`);const M=t.util.toNestedArray(v,c.data.get(r.dataId).values),A=t.util.makeZerosNestedTypedArray(o.shape,o.dtype);for(let e=0;e<h;++e)for(let t=0;t<g;++t){const a=t*y-b.top;for(let n=0;n<I;++n){const s=n*S-b.left;for(let o=0;o<k;++o){let r=Number.MIN_SAFE_INTEGER,i=0,d=0;for(let t=0;t<N;++t){const n=a+t*F;if(n>=0&&n<f)for(let a=0;a<T;++a){const l=s+a*x;if(l>=0&&l<m){const s=u[e][n][l][o]+p[t][a][o];s>r&&(r=s,i=t,d=a)}}}A[i][d][o]+=M[e][t][n][o]}}}return{dataId:c.write(t.util.toTypedArray(A,s.dtype),o.shape,o.dtype),shape:o.shape,dtype:o.dtype}}},kt={kernelName:t.Dilation2DBackpropInput,backendName:"cpu",kernelFunc:({inputs:e,backend:a,attrs:n})=>{const{x:s,filter:o,dy:r}=e,{strides:i,pad:d,dilations:l}=n,c=a,u=t.util.toNestedArray(s.shape,c.data.get(s.dataId).values),p=t.util.toNestedArray(o.shape,c.data.get(o.dataId).values),{batchSize:h,inHeight:f,inWidth:m,inChannels:k,outHeight:g,outWidth:I,padInfo:b,strideHeight:y,strideWidth:S,filterHeight:N,filterWidth:T,dilationHeight:F,dilationWidth:x,outShape:v}=t.backend_util.computeDilation2DInfo(s.shape,o.shape,i,d,"NHWC",l);t.util.assert(r.rank===v.length,()=>`Error in ${t.Dilation2DBackpropInput}, dy `+`must have the same rank as output ${v.length}, but got `+`${r.rank}`);const M=t.util.toNestedArray(v,c.data.get(r.dataId).values),A=t.util.makeZerosNestedTypedArray(s.shape,s.dtype);for(let e=0;e<h;++e)for(let t=0;t<g;++t){const a=t*y-b.top;for(let n=0;n<I;++n){const s=n*S-b.left;for(let o=0;o<k;++o){let r=Number.MIN_SAFE_INTEGER,i=a<0?0:a,d=s<0?0:s;for(let t=0;t<N;++t){const n=a+t*F;if(n>=0&&n<f)for(let a=0;a<T;++a){const l=s+a*x;if(l>=0&&l<m){const s=u[e][n][l][o]+p[t][a][o];s>r&&(r=s,i=n,d=l)}}}A[e][i][d][o]+=M[e][t][n][o]}}}return{dataId:c.write(t.util.toTypedArray(A,s.dtype),s.shape,s.dtype),shape:s.shape,dtype:s.dtype}}},gt=p((e,t)=>e/t),It=S(t.Div,gt),bt={kernelName:t.Div,backendName:"cpu",kernelFunc:It},yt=t.backend_util.ERF_P,St=t.backend_util.ERF_A1,Nt=t.backend_util.ERF_A2,Tt=t.backend_util.ERF_A3,Ft=t.backend_util.ERF_A4,xt=t.backend_util.ERF_A5,vt=A(t.Erf,e=>{const t=Math.sign(e),a=Math.abs(e),n=1/(1+yt*a);return t*(1-((((xt*n+Ft)*n+Tt)*n+Nt)*n+St)*n*Math.exp(-a*a))}),Mt={kernelName:t.Erf,backendName:"cpu",kernelFunc:vt};function At(e,a,n){const s=e.shape,o=s[0],r=s[1],i=n.data.get(e.dataId),d=i.complexTensorInfos.real,l=i.complexTensorInfos.imag,c=[o,r],u=t.util.sizeFromShape(c),p=t.util.getTypedArrayFromDType("float32",u),f=t.util.getTypedArrayFromDType("float32",u);for(let e=0;e<o;e++){const s=ne({inputs:{x:d},backend:n,attrs:{begin:[e,0],size:[1,r]}}),o=ne({inputs:{x:l},backend:n,attrs:{begin:[e,0],size:[1,r]}}),i=h({inputs:{real:s,imag:o},backend:n}),{real:c,imag:u}=Dt(i,a,n),m=t.backend_util.mergeRealAndImagArrays(c,u);for(let a=0;a<r;a++){const n=t.backend_util.getComplexWithIndex(m,a);p[e*r+a]=n.real,f[e*r+a]=n.imag}n.disposeIntermediateTensorInfo(s),n.disposeIntermediateTensorInfo(o),n.disposeIntermediateTensorInfo(i)}const m=n.makeTensorInfo(c,"float32",p),k=n.makeTensorInfo(c,"float32",f),g=h({inputs:{real:m,imag:k},backend:n});return n.disposeIntermediateTensorInfo(m),n.disposeIntermediateTensorInfo(k),g}function Dt(e,a,n){const s=t.util.sizeFromShape(e.shape),o=n.data.get(e.dataId),r=n.data.get(o.complexTensorInfos.real.dataId).values,i=n.data.get(o.complexTensorInfos.imag.dataId).values;if(0==((d=s)&d-1)){const o=function e(a,n,s,o,r){if(1===s)return{real:a,imag:n};const i=t.backend_util.mergeRealAndImagArrays(a,n),d=s/2,l=t.backend_util.complexWithEvenIndex(i),c=l.real,u=l.imag,p=[c.length],f=r.makeTensorInfo(p,"float32",c),m=r.makeTensorInfo(p,"float32",u),k=h({inputs:{real:f,imag:m},backend:r}),I=t.backend_util.complexWithOddIndex(i),b=I.real,y=I.imag,S=[b.length],N=r.makeTensorInfo(S,"float32",b),T=r.makeTensorInfo(S,"float32",y),F=h({inputs:{real:N,imag:T},backend:r}),v=e(c,u,d,o,r),M=v.real,A=v.imag,D=[M.length],_=r.makeTensorInfo(D,"float32",M),z=r.makeTensorInfo(D,"float32",A),W=h({inputs:{real:_,imag:z},backend:r}),w=e(b,y,d,o,r),H=w.real,C=w.imag,B=[H.length],E=r.makeTensorInfo(B,"float32",H),R=r.makeTensorInfo(B,"float32",C),P=h({inputs:{real:E,imag:R},backend:r}),O=t.backend_util.exponents(s,o),q=[O.real.length],$=r.makeTensorInfo(q,"float32",O.real),L=r.makeTensorInfo(q,"float32",O.imag),V=h({inputs:{real:$,imag:L},backend:r}),G=K({inputs:{a:V,b:P},backend:r}),U=x({inputs:{a:W,b:G},backend:r}),j=ce({inputs:{a:W,b:G},backend:r}),Y=g({inputs:{input:U},backend:r}),Z=g({inputs:{input:j},backend:r}),J=Ye({inputs:{input:U},backend:r}),Q=Ye({inputs:{input:j},backend:r}),X=Je({inputs:[Y,Z],backend:r,attrs:{axis:0}}),ee=Je({inputs:[J,Q],backend:r,attrs:{axis:0}}),te=r.data.get(X.dataId).values,ae=r.data.get(ee.dataId).values;return r.disposeIntermediateTensorInfo(f),r.disposeIntermediateTensorInfo(m),r.disposeIntermediateTensorInfo(k),r.disposeIntermediateTensorInfo(N),r.disposeIntermediateTensorInfo(T),r.disposeIntermediateTensorInfo(F),r.disposeIntermediateTensorInfo(_),r.disposeIntermediateTensorInfo(z),r.disposeIntermediateTensorInfo(W),r.disposeIntermediateTensorInfo(E),r.disposeIntermediateTensorInfo(R),r.disposeIntermediateTensorInfo(P),r.disposeIntermediateTensorInfo($),r.disposeIntermediateTensorInfo(L),r.disposeIntermediateTensorInfo(V),r.disposeIntermediateTensorInfo(G),r.disposeIntermediateTensorInfo(U),r.disposeIntermediateTensorInfo(j),r.disposeIntermediateTensorInfo(Y),r.disposeIntermediateTensorInfo(J),r.disposeIntermediateTensorInfo(Z),r.disposeIntermediateTensorInfo(Q),r.disposeIntermediateTensorInfo(X),r.disposeIntermediateTensorInfo(ee),{real:te,imag:ae}}(r,i,s,a,n),d=[e.shape[0],e.shape[1]];if(a){const e=n.makeTensorInfo(d,"float32",o.real),a=n.makeTensorInfo(d,"float32",o.imag),r=n.makeTensorInfo([],"float32",t.util.createScalarValue(s,"float32")),i=m({inputs:{x:r},backend:n}),l=bt.kernelFunc({inputs:{a:e,b:r},backend:n}),c=bt.kernelFunc({inputs:{a:a,b:i},backend:n}),u=n.data.get(l.dataId).values,p=n.data.get(c.dataId).values;return n.disposeIntermediateTensorInfo(e),n.disposeIntermediateTensorInfo(a),n.disposeIntermediateTensorInfo(r),n.disposeIntermediateTensorInfo(i),n.disposeIntermediateTensorInfo(l),n.disposeIntermediateTensorInfo(c),{real:u,imag:p}}return o}{const e=function(e,a,n){const s=new Float32Array(2*a);for(let o=0;o<a;o++){let r=0,i=0;for(let s=0;s<a;s++){const d=t.backend_util.exponent(o*s,a,n),l=t.backend_util.getComplexWithIndex(e,s);r+=l.real*d.real-l.imag*d.imag,i+=l.real*d.imag+l.imag*d.real}n&&(r/=a,i/=a),t.backend_util.assignToTypedArray(s,r,i,o)}return s}(t.backend_util.mergeRealAndImagArrays(r,i),s,a);return t.backend_util.splitRealAndImagArrays(e)}var d}const _t={kernelName:t.FFT,backendName:"cpu",kernelFunc:function(e){const{inputs:a,backend:n}=e,{input:s}=a,o=t.util.sizeFromShape(s.shape),r=s.shape[s.shape.length-1],i=xe({inputs:{x:s},backend:n,attrs:{shape:[o/r,r]}}),d=At(i,!1,n),l=xe({inputs:{x:d},backend:n,attrs:{shape:s.shape}});return n.disposeIntermediateTensorInfo(i),n.disposeIntermediateTensorInfo(d),l}};const zt={kernelName:t.Fill,backendName:"cpu",kernelFunc:function(e){const{backend:a,attrs:n}=e,{shape:s,value:o,dtype:r}=n,i=r||t.util.inferDtype(o),d=t.util.getArrayFromDType(i,t.util.sizeFromShape(s));return function(e,t,a){e.fill(t)}(d,o),a.makeTensorInfo(s,i,d)}};const Wt={kernelName:t.FlipLeftRight,backendName:"cpu",kernelFunc:({inputs:e,attrs:a,backend:n})=>{const{image:s}=e,o=n,r=t.util.getTypedArrayFromDType(s.dtype,t.util.sizeFromShape(s.shape)),[i,d,l,c]=s.shape,u=o.data.get(s.dataId).values;for(let e=0;e<i;e++){const t=e*l*d*c;for(let e=0;e<d;e++){const a=e*(l*c);for(let n=0;n<l;n++){const s=n*c;for(let o=0;o<c;o++){const d=[i,e,n,o][2],p=Math.round(l-d),h=t+a+s+o;let f=u[h];if(p>=0&&p<l){f=u[t+a+p*c+o]}r[h]=f}}}}return{dataId:o.write(r,s.shape,s.dtype),shape:s.shape,dtype:s.dtype}}};const wt={kernelName:t.FusedConv2D,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:a,attrs:n}=e,{x:s,filter:o,bias:r,preluActivationWeights:i}=t,{strides:d,pad:l,dataFormat:c,dilations:u,dimRoundingMode:p,activation:h}=n;let f=Xe({inputs:{x:s,filter:o},backend:a,attrs:{strides:d,pad:l,dataFormat:c,dilations:u,dimRoundingMode:p}});if(r){const e=f;f=x({inputs:{a:f,b:r},backend:a}),a.disposeIntermediateTensorInfo(e)}if(h){const e=f;f=Fe(a,f,h,i),a.disposeIntermediateTensorInfo(e)}return f}};const Ht={kernelName:t.FusedDepthwiseConv2D,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:a,attrs:n}=e,{x:s,filter:o,bias:r,preluActivationWeights:i}=t,{strides:d,pad:l,dataFormat:c,dilations:u,dimRoundingMode:p,activation:h}=n;let f=ct({inputs:{x:s,filter:o},backend:a,attrs:{strides:d,pad:l,dataFormat:c,dilations:u,dimRoundingMode:p}});if(r){const e=f;f=x({inputs:{a:f,b:r},backend:a}),a.disposeIntermediateTensorInfo(e)}if(h){const e=f;f=Fe(a,f,h,i),a.disposeIntermediateTensorInfo(e)}return f}};const Ct={kernelName:t.IFFT,backendName:"cpu",kernelFunc:function(e){const{inputs:a,backend:n}=e,{input:s}=a,o=t.util.sizeFromShape(s.shape),r=s.shape[s.shape.length-1],i=xe({inputs:{x:s},backend:n,attrs:{shape:[o/r,r]}}),d=At(i,!0,n),l=xe({inputs:{x:d},backend:n,attrs:{shape:s.shape}});return n.disposeIntermediateTensorInfo(i),n.disposeIntermediateTensorInfo(d),l}},Bt=A(t.IsFinite,e=>Number.isFinite(e)?1:0,"bool"),Et={kernelName:t.IsFinite,backendName:"cpu",kernelFunc:Bt},Rt=A(t.IsInf,e=>Math.abs(e)===1/0?1:0,"bool"),Pt={kernelName:t.IsInf,backendName:"cpu",kernelFunc:Rt},Ot=A(t.IsNan,e=>Number.isNaN(e)?1:0,"bool"),qt={kernelName:t.IsNan,backendName:"cpu",kernelFunc:Ot},$t=A(t.Log1p,e=>Math.log1p(e)),Lt={kernelName:t.Log1p,backendName:"cpu",kernelFunc:$t},Vt=A(t.LogicalNot,e=>e?0:1,"bool"),Gt={kernelName:t.LogicalNot,backendName:"cpu",kernelFunc:Vt},Ut={kernelName:t.Max,backendName:"cpu",kernelFunc:({inputs:e,attrs:a,backend:s})=>{const{x:o}=e,{reductionIndices:r,keepDims:i}=a,d=s;let l=o.shape;const c=l.length,u=t.util.parseAxisParam(r,l);let p=u;const h=t.backend_util.getAxesPermutation(p,c);let f=d.data.get(o.dataId).values;if(null!=h){const e=new Array(c);for(let t=0;t<e.length;t++)e[t]=l[h[t]];f=pe(f,l,o.dtype,h,e),p=t.backend_util.getInnerMostAxes(p.length,c),l=e}n(o,"max"),t.backend_util.assertAxesAreInnerMostDims("max",p,c);const[m,k]=t.backend_util.computeOutAndReduceShapes(l,p),g=G(f,t.util.sizeFromShape(k),m,o.dtype),I=d.write(g,m,o.dtype);let b=m;if(i){b=t.backend_util.expandShapeToKeepDim(m,u)}return{dataId:I,shape:b,dtype:o.dtype}}};const jt={kernelName:t.MaxPool,backendName:"cpu",kernelFunc:function(e){const{inputs:a,backend:s,attrs:o}=e,{x:r}=a;n(r,"maxPool");const{filterSize:i,strides:d,pad:l,dimRoundingMode:c}=o;t.util.assert(t.backend_util.eitherStridesOrDilationsAreOne(d,1),()=>"Error in maxPool: Either strides or dilations must be 1. "+`Got strides ${d} and dilations '1'`);const u=t.backend_util.computePool2DInfo(r.shape,i,d,1,l,c);let p;if(1===u.filterWidth&&1===u.filterHeight&&t.util.arraysEqual(u.inShape,u.outShape))p=m({inputs:{x:r},backend:s});else{const e=s.data.get(r.dataId).values,a=t.util.computeStrides(r.shape),n=$e(e,r.shape,r.dtype,a,u,"max");p=s.makeTensorInfo(u.outShape,r.dtype,n.values)}return p}};const Kt={kernelName:t.MaxPoolBackprop,backendName:"cpu",kernelFunc:function(e){const{inputs:a,backend:s,attrs:o}=e,{dy:r,input:i,output:d}=a,l=i;n([i,d],"maxPoolBackprop");const{filterSize:c,strides:u,pad:p,dimRoundingMode:h}=o,f=t.backend_util.computePool2DInfo(l.shape,c,u,1,p,h),m=s.data.get(l.dataId).values,k=t.buffer(f.outShape,l.dtype,Le(m,l.shape,l.dtype,f).values),g=f.strideHeight,I=f.strideWidth,b=f.dilationHeight,y=f.dilationWidth,S=f.effectiveFilterHeight,N=f.effectiveFilterWidth,T=N-1-f.padInfo.left,F=S-1-f.padInfo.top,x=t.buffer(l.shape,"float32"),v=s.data.get(r.dataId).values,M=t.buffer(r.shape,"float32",v);for(let e=0;e<f.batchSize;++e)for(let t=0;t<f.inChannels;++t)for(let a=0;a<f.inHeight;++a)for(let n=0;n<f.inWidth;++n){const s=a-F,o=n-T;let r=0;for(let a=0;a<S;a+=b){const n=(s+a)/g;if(!(n<0||n>=f.outHeight||Math.floor(n)!==n))for(let s=0;s<N;s+=y){const i=(o+s)/I;if(i<0||i>=f.outWidth||Math.floor(i)!==i)continue;const d=S*N-1-k.get(e,n,i,t)===a*N+s?1:0;0!==d&&(r+=M.get(e,n,i,t)*d)}}x.set(r,e,a,n,t)}return s.makeTensorInfo(x.shape,x.dtype,x.values)}};const Yt={kernelName:t.MaxPoolWithArgmax,backendName:"cpu",kernelFunc:({inputs:e,attrs:a,backend:s})=>{const{x:o}=e,{filterSize:r,strides:i,pad:d,includeBatchInIndex:l}=a,c=s;n(o,"MaxPoolWithArgmax");const u=c.data.get(o.dataId).values,p=t.backend_util.computePool2DInfo(o.shape,r,i,[1,1],d),[h,f]=function(e,a,n,s,o){const r=$e(e,0,n,t.util.computeStrides(a),o,"max"),i=Le(e,a,n,o,!0,s);return[r.values,i.values]}(u,o.shape,o.dtype,l,p),m=c.write(h,p.outShape,o.dtype),k=c.write(f,p.outShape,o.dtype);return[{dataId:m,shape:p.outShape,dtype:o.dtype},{dataId:k,shape:p.outShape,dtype:"int32"}]}};const Zt={kernelName:t.MirrorPad,backendName:"cpu",kernelFunc:function(e){const{inputs:a,backend:s,attrs:o}=e,{x:r}=a,{paddings:i,mode:d}=o;n(r,"mirrorPad");const l=i.map((e,t)=>e[0]+r.shape[t]+e[1]),c=i.map(e=>e[0]),u=i.map((e,t)=>e[0]+r.shape[t]),p="reflect"===d?0:1,h=s.data.get(r.dataId).values,f=r.shape.length,m=t.util.computeStrides(r.shape),k=t.util.sizeFromShape(l),g=l.length,I=t.util.computeStrides(l),b=t.util.getTypedArrayFromDType(r.dtype,k);for(let e=0;e<k;e++){let a=t.util.indexToLoc(e,g,I);for(let e=0;e<g;e++)a[e]<c[e]?a[e]=2*c[e]-a[e]-p:a[e]>=u[e]&&(a[e]=2*(u[e]-1)-a[e]+p);a=a.map((e,t)=>e-c[t]);const n=t.util.locToIndex(a,f,m);b[e]=h[n]}return{dataId:s.write(b,l,r.dtype),shape:l,dtype:r.dtype}}},Jt=t.kernel_impls.nonMaxSuppressionV4Impl,Qt={kernelName:t.NonMaxSuppressionV4,backendName:"cpu",kernelFunc:({inputs:e,backend:t,attrs:a})=>{const{boxes:s,scores:o}=e,{maxOutputSize:r,iouThreshold:i,scoreThreshold:d,padToMaxOutputSize:l}=a,c=t;n(s,"NonMaxSuppressionPadded");const u=c.data.get(s.dataId).values,p=c.data.get(o.dataId).values,{selectedIndices:h,validOutputs:f}=Jt(u,p,r,i,d,l);return[h,f]}},Xt=t.kernel_impls.nonMaxSuppressionV5Impl,ea={kernelName:t.NonMaxSuppressionV5,backendName:"cpu",kernelFunc:({inputs:e,backend:t,attrs:a})=>{const{boxes:s,scores:o}=e,{maxOutputSize:r,iouThreshold:i,scoreThreshold:d,softNmsSigma:l}=a,c=t;n(s,"NonMaxSuppressionWithScore");const u=c.data.get(s.dataId).values,p=c.data.get(o.dataId).values,h=r,f=i,m=d,k=l,{selectedIndices:g,selectedScores:I}=Xt(u,p,h,f,m,k);return[g,I]}};const ta={kernelName:t.PadV2,backendName:"cpu",kernelFunc:function(e){const{inputs:a,backend:s,attrs:o}=e,{x:r}=a,{paddings:i,constantValue:d}=o;n(r,"pad");const l=i.map((e,t)=>e[0]+r.shape[t]+e[1]),c=i.map(e=>e[0]),u=s.data.get(r.dataId).values,p=t.util.sizeFromShape(r.shape),h=r.shape.length,f=t.util.computeStrides(r.shape),m=t.util.sizeFromShape(l),k=l.length,g=t.util.computeStrides(l),I=t.util.getTypedArrayFromDType(r.dtype,m);0!==d&&I.fill(d);for(let e=0;e<p;e++){const a=t.util.indexToLoc(e,h,f).map((e,t)=>e+c[t]);I[t.util.locToIndex(a,k,g)]=u[e]}return{dataId:s.write(I,l,r.dtype),shape:l,dtype:r.dtype}}},aa=A(t.Reciprocal,e=>1/e),na={kernelName:t.Reciprocal,backendName:"cpu",kernelFunc:aa},sa={kernelName:t.RotateWithOffset,backendName:"cpu",kernelFunc:({inputs:e,attrs:a,backend:n})=>{const{image:s}=e,{radians:o,fillValue:r,center:i}=a,d=n,l=t.util.getTypedArrayFromDType(s.dtype,t.util.sizeFromShape(s.shape)),[c,u,p,h]=s.shape,[f,m]=t.backend_util.getImageCenter(i,u,p),k=Math.sin(o),g=Math.cos(o),I=d.data.get(s.dataId).values;for(let e=0;e<c;e++){const t=e*p*u*h;for(let e=0;e<u;e++){const a=e*(p*h);for(let n=0;n<p;n++){const s=n*h;for(let o=0;o<h;o++){const i=[c,e,n,o],d=i[2],b=i[1];let y=(d-f)*g-(b-m)*k,S=(d-f)*k+(b-m)*g;y=Math.round(y+f),S=Math.round(S+m);let N=r;if("number"!=typeof r&&(N=3===o?255:r[o]),y>=0&&y<p&&S>=0&&S<u){N=I[t+S*(p*h)+y*h+o]}l[t+a+s+o]=N}}}}return{dataId:d.write(l,s.shape,s.dtype),shape:s.shape,dtype:s.dtype}}},oa=A(t.Round,e=>{const t=Math.floor(e);return e-t<.5?Math.floor(e):e-t>.5?Math.ceil(e):t%2==0?t:t+1}),ra={kernelName:t.Round,backendName:"cpu",kernelFunc:oa},ia=t.backend_util.SELU_SCALEALPHA,da=t.backend_util.SELU_SCALE,la=A(t.Selu,e=>e>=0?da*e:ia*(Math.exp(e)-1)),ca={kernelName:t.Selu,backendName:"cpu",kernelFunc:la},ua=A(t.Sigmoid,e=>1/(1+Math.exp(-e))),pa={kernelName:t.Sigmoid,backendName:"cpu",kernelFunc:ua},ha=A(t.Sign,e=>e<0?-1:e>0?1:0),fa={kernelName:t.Sign,backendName:"cpu",kernelFunc:ha},ma=A(t.Sin,e=>Math.sin(e)),ka={kernelName:t.Sin,backendName:"cpu",kernelFunc:ma},ga=A(t.Sinh,e=>Math.sinh(e)),Ia={kernelName:t.Sinh,backendName:"cpu",kernelFunc:ga},ba=Math.log(1.1920928955078125e-7)+2,ya=A(t.Softplus,e=>{const t=e>-ba,a=e<ba,n=Math.exp(e);let s;return s=a?n:t?e:Math.log(1+n),s}),Sa={kernelName:t.Softplus,backendName:"cpu",kernelFunc:ya};function Na(e){const{inputs:t,attrs:a,backend:s}=e,{x:o}=t,{perm:r}=a;n(o,"transpose");const i=o.shape.length,d=new Array(i);for(let e=0;e<d.length;e++)d[e]=o.shape[r[e]];const l=pe(s.data.get(o.dataId).values,o.shape,o.dtype,r,d);return{dataId:s.write(l,d,o.dtype),shape:d,dtype:o.dtype}}const Ta={kernelName:t.Transpose,backendName:"cpu",kernelFunc:Na};const Fa={kernelName:t.SpaceToBatchND,backendName:"cpu",kernelFunc:function(e){const{inputs:a,backend:s,attrs:o}=e,{x:r}=a,{blockShape:i,paddings:d}=o;n([r],"spaceToBatchND");const l=t.util.sizeFromShape(i),c=[[0,0]];c.push(...d);for(let e=1+i.length;e<r.shape.length;++e)c.push([0,0]);const u=ta.kernelFunc({inputs:{x:r},backend:s,attrs:{paddings:c,constantValue:0}}),p=t.backend_util.getReshaped(u.shape,i,l,!1),h=t.backend_util.getPermuted(p.length,i.length,!1),f=t.backend_util.getReshapedPermuted(u.shape,i,l,!1),m=xe({inputs:{x:u},backend:s,attrs:{shape:p}}),k=Na({inputs:{x:m},backend:s,attrs:{perm:h}}),g=xe({inputs:{x:k},backend:s,attrs:{shape:f}});return s.disposeIntermediateTensorInfo(u),s.disposeIntermediateTensorInfo(m),s.disposeIntermediateTensorInfo(k),g}},xa=A(t.Sqrt,e=>Math.sqrt(e)),va={kernelName:t.Sqrt,backendName:"cpu",kernelFunc:xa},Ma={kernelName:t.Square,backendName:"cpu",kernelFunc:({inputs:e,backend:t})=>{const{x:a}=e,s=t;n(a,"square");const o=s.data.get(a.dataId).values,r=new Float32Array(o.length);for(let e=0;e<o.length;++e){const t=o[e];r[e]=t*t}return{dataId:s.write(r,a.shape,a.dtype),shape:a.shape,dtype:a.dtype}}},Aa=A(t.Step,(e,t)=>{const a=t;return isNaN(e)?NaN:e>0?1:a.alpha}),Da={kernelName:t.Step,backendName:"cpu",kernelFunc:Aa},_a=A(t.Tan,e=>Math.tan(e)),za={kernelName:t.Tan,backendName:"cpu",kernelFunc:_a},Wa=A(t.Tanh,e=>Math.tanh(e)),wa={kernelName:t.Tanh,backendName:"cpu",kernelFunc:Wa};const Ha={kernelName:t.Unique,backendName:"cpu",kernelFunc:function(e){const{inputs:t,attrs:a,backend:s}=e,{axis:o}=a,{x:r}=t;n(r,"unique");const i=s.data.get(r.dataId).values,{outputValues:d,outputShape:l,indices:c}=he(i,o,r.shape,r.dtype);return[s.makeTensorInfo(l,r.dtype,d),s.makeTensorInfo([c.length],"int32",c)]}},Ca=[De,u,ze,we,v,Ce,Ee,Pe,qe,Ve,Ge,Ae,Ue,y,W,Ke,f,Qe,tt,at,et,st,ot,nt,it,lt,ut,pt,ht,ft,kt,mt,bt,ke,Mt,C,R,_t,zt,Wt,q,wt,Ht,k,Ct,Ze,Et,Pt,qt,V,Lt,Gt,jt,Kt,Yt,Ut,Zt,Y,Qt,ea,Q,ta,be,I,na,Se,Te,ve,sa,ra,te,ca,pa,fa,ka,Ia,se,Sa,Fa,va,Ma,ie,Da,ue,za,wa,Ta,Ha];for(const e of Ca)t.registerKernel(e);e.MathBackendCPU=l,e.shared=fe,e.version_cpu="2.7.0",Object.defineProperty(e,"__esModule",{value:!0})}));
//# sourceMappingURL=tf-backend-cpu.es2017.min.js.map
