/**
 * @license
 * Copyright 2020 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports,require("@tensorflow/tfjs-core"),require("seedrandom")):"function"==typeof define&&define.amd?define(["exports","@tensorflow/tfjs-core","seedrandom"],t):t((e=e||self).tf=e.tf||{},e.tf,e.seedrandom)}(this,(function(e,t,a){"use strict";var r=function(e,t){return(r=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var a in t)t.hasOwnProperty(a)&&(e[a]=t[a])})(e,t)};function n(e,t,a,r){return new(a||(a=Promise))((function(n,i){function o(e){try{d(r.next(e))}catch(e){i(e)}}function s(e){try{d(r.throw(e))}catch(e){i(e)}}function d(e){var t;e.done?n(e.value):(t=e.value,t instanceof a?t:new a((function(e){e(t)}))).then(o,s)}d((r=r.apply(e,t||[])).next())}))}function i(e,t){var a,r,n,i,o={label:0,sent:function(){if(1&n[0])throw n[1];return n[1]},trys:[],ops:[]};return i={next:s(0),throw:s(1),return:s(2)},"function"==typeof Symbol&&(i[Symbol.iterator]=function(){return this}),i;function s(i){return function(s){return function(i){if(a)throw new TypeError("Generator is already executing.");for(;o;)try{if(a=1,r&&(n=2&i[0]?r.return:i[0]?r.throw||((n=r.return)&&n.call(r),0):r.next)&&!(n=n.call(r,i[1])).done)return n;switch(r=0,n&&(i=[2&i[0],n.value]),i[0]){case 0:case 1:n=i;break;case 4:return o.label++,{value:i[1],done:!1};case 5:o.label++,r=i[1],i=[0];continue;case 7:i=o.ops.pop(),o.trys.pop();continue;default:if(!(n=o.trys,(n=n.length>0&&n[n.length-1])||6!==i[0]&&2!==i[0])){o=0;continue}if(3===i[0]&&(!n||i[1]>n[0]&&i[1]<n[3])){o.label=i[1];break}if(6===i[0]&&o.label<n[1]){o.label=n[1],n=i;break}if(n&&o.label<n[2]){o.label=n[2],o.ops.push(i);break}n[2]&&o.ops.pop(),o.trys.pop();continue}i=t.call(e,o)}catch(e){i=[6,e],r=0}finally{a=n=0}if(5&i[0])throw i[1];return{value:i[0]?i[1]:void 0,done:!0}}([i,s])}}}function o(e,a){Array.isArray(e)||(e=[e]),e.forEach((function(e){null!=e&&t.util.assert("complex64"!==e.dtype,(function(){return a+" does not support complex64 tensors in the CPU backend."}))}))}var s=t.kernel_impls.nonMaxSuppressionV3Impl,d=t.kernel_impls.split,u=t.kernel_impls.tile,p=t.kernel_impls.topkImpl,l=t.kernel_impls.whereImpl,c=function(e){function c(){var a=e.call(this)||this;return a.blockSize=48,a.firstUse=!0,a.data=new t.DataStorage(a,t.engine()),a}return function(e,t){function a(){this.constructor=e}r(e,t),e.prototype=null===t?Object.create(t):(a.prototype=t.prototype,new a)}(c,e),c.prototype.write=function(e,a,r){this.firstUse&&(this.firstUse=!1,t.env().get("IS_NODE")&&t.backend_util.warn("\n============================\nHi there 👋. Looks like you are running TensorFlow.js in Node.js. To speed things up dramatically, install our node backend, which binds to TensorFlow C++, by running npm i @tensorflow/tfjs-node, or npm i @tensorflow/tfjs-node-gpu if you have CUDA. Then call require('@tensorflow/tfjs-node'); (-gpu suffix for CUDA) at the start of your program. Visit https://github.com/tensorflow/tfjs-node for more details.\n============================"));var n={};return this.data.set(n,{values:e,dtype:r,refCount:1}),n},c.prototype.makeTensorInfo=function(e,a,r){var n;if("string"===a&&null!=r&&r.length>0&&t.util.isString(r[0])){var i=r.map((function(e){return t.util.encodeString(e)}));n=this.write(i,e,a)}else n=this.write(r,e,a);return{dataId:n,shape:e,dtype:a}},c.prototype.incRef=function(e){this.data.get(e).refCount++},c.prototype.decRef=function(e){this.data.has(e)&&this.data.get(e).refCount--},c.prototype.move=function(e,t,a,r){this.data.set(e,{values:t,dtype:r,refCount:1})},c.prototype.numDataIds=function(){return this.data.numDataIds()},c.prototype.read=function(e){return n(this,void 0,void 0,(function(){return i(this,(function(t){return[2,this.readSync(e)]}))}))},c.prototype.readSync=function(e){var a=this.data.get(e),r=a.dtype,n=a.complexTensorInfos;if("complex64"===r){var i=this.readSync(n.real.dataId),o=this.readSync(n.imag.dataId);return t.backend_util.mergeRealAndImagArrays(i,o)}return this.data.get(e).values},c.prototype.bufferSync=function(e){var a=this.readSync(e.dataId),r=a;if("string"===e.dtype)try{r=a.map((function(e){return t.util.decodeString(e)}))}catch(e){throw new Error("Failed to decode encoded string bytes into utf-8")}return t.buffer(e.shape,e.dtype,r)},c.prototype.makeOutput=function(e,a,r){var n=this.write(e,a,r);return t.engine().makeTensorFromDataId(n,a,r,this)},c.prototype.disposeData=function(e){if(this.data.has(e)){var t=this.data.get(e).complexTensorInfos;null!=t&&(this.disposeData(t.real.dataId),this.disposeData(t.imag.dataId)),this.data.delete(e)}},c.prototype.disposeIntermediateTensorInfo=function(e){var t=e.dataId;if(this.data.has(t)){var a=this.data.get(t);a.refCount--,a.refCount<1&&this.disposeData(t)}},c.prototype.time=function(e){return n(this,void 0,void 0,(function(){var a;return i(this,(function(r){return a=t.util.now(),e(),[2,{kernelMs:t.util.now()-a}]}))}))},c.prototype.memory=function(){return{unreliable:!0,reasons:["The reported memory is an upper bound. Due to automatic garbage collection, the true allocated memory may be less."]}},c.prototype.stridedSlice=function(e,a,r,n){o(e,"stridedSlice");var i=t.slice_util.computeOutShape(a,r,n);if(i.some((function(e){return 0===e})))return t.tensor([],i);for(var s=t.buffer(i,e.dtype),d=this.bufferSync(e),u=0;u<s.size;u++){for(var p=s.indexToLoc(u),l=new Array(p.length),c=0;c<l.length;c++)l[c]=p[c]*n[c]+a[c];s.set.apply(s,[d.get.apply(d,l)].concat(p))}return s.toTensor()},c.prototype.diag=function(e){for(var a=this.readSync(e.dataId),r=t.buffer([e.size,e.size],e.dtype),n=r.values,i=0;i<a.length;i++)n[i*e.size+i]=a[i];return r.toTensor()},c.prototype.unstack=function(e,a){for(var r=e.shape[a],n=new Array(e.rank-1),i=0,o=0;o<e.rank;o++)o!==a&&(n[i++]=e.shape[o]);var s=new Array(e.rank).fill(0),d=e.shape.slice();d[a]=1;var u=new Array(r);for(o=0;o<u.length;o++)s[a]=o,u[o]=t.slice(e,s,d).reshape(n);return u},c.prototype.reverse=function(e,a){o(e,"reverse");for(var r=t.buffer(e.shape,e.dtype),n=this.bufferSync(e),i=function(t){var i=r.indexToLoc(t),o=i.slice();a.forEach((function(t){return o[t]=e.shape[t]-1-o[t]})),r.set.apply(r,[n.get.apply(n,o)].concat(i))},s=0;s<r.size;s++)i(s);return r.toTensor()},c.prototype.neg=function(e){return o(e,"neg"),t.mul(t.scalar(-1),e)},c.prototype.addN=function(e){var a=this;o(e,"addN");for(var r=e.map((function(e){return a.readSync(e.dataId)})),n=t.buffer(e[0].shape,e[0].dtype),i=n.values,s=0;s<e.length;s++)for(var d=r[s],u=0;u<i.length;u++)i[u]+=d[u];return n.toTensor()},c.prototype.softmax=function(e,a){var r=t.util.parseAxisParam([a],e.shape),n=t.max(e,r),i=t.backend_util.expandShapeToKeepDim(n.shape,r),o=t.sub(e,n.reshape(i)),s=t.exp(o),d=this.sum(s,r).reshape(i);return t.div(s,d)},c.prototype.pow=function(e,t){return o([e,t],"pow"),this.broadcastedBinaryOp(e,t,e.dtype,(function(e,t){return Math.pow(e,t)}))},c.prototype.floorDiv=function(e,t){o([e,t],"floorDiv");return this.broadcastedBinaryOp(e,t,"int32",(function(e,t){return Math.floor(e/t)}))},c.prototype.sum=function(e,a){o(e,"sum"),t.backend_util.assertAxesAreInnerMostDims("sum",a,e.rank);for(var r=t.backend_util.computeOutAndReduceShapes(e.shape,a),n=r[0],i=r[1],s=t.upcastType(e.dtype,"int32"),d=t.zeros(n,s),u=t.util.sizeFromShape(i),p=this.readSync(d.dataId),l=this.readSync(e.dataId),c=0;c<p.length;++c){for(var f=c*u,h=0,m=0;m<u;++m)h+=l[f+m];p[c]=h}return d},c.prototype.prod=function(e,a){o(e,"sum");for(var r=t.backend_util.computeOutAndReduceShapes(e.shape,a),n=r[0],i=r[1],s=t.upcastType(e.dtype,"int32"),d=t.zeros(n,s),u=t.util.sizeFromShape(i),p=this.readSync(d.dataId),l=this.readSync(e.dataId),c=0;c<p.length;++c){for(var f=c*u,h=1,m=0;m<u;++m)h*=l[f+m];p[c]=h}return d},c.prototype.unsortedSegmentSum=function(e,a,r){o(e,"unsortedSegmentSum");for(var n=[],i=e.rank-a.rank,s=0;s<i;++s)a=a.expandDims(s+1);for(s=0;s<r;++s){var d=t.scalar(s,"int32"),u=t.equal(d,a).asType("float32").mul(e).sum(0);n.push(u)}return t.stack(n)},c.prototype.argMin=function(e,a){o(e,"argMin");var r=[a];t.backend_util.assertAxesAreInnerMostDims("argMin",r,e.rank);for(var n=t.backend_util.computeOutAndReduceShapes(e.shape,r),i=n[0],s=n[1],d=t.zeros(i,"int32"),u=t.util.sizeFromShape(s),p=this.readSync(d.dataId),l=this.readSync(e.dataId),c=0;c<p.length;++c){for(var f=c*u,h=l[f],m=0,v=0;v<u;++v){var k=l[f+v];k<h&&(h=k,m=v)}p[c]=m}return d},c.prototype.argMax=function(e,a){o(e,"argMax");var r=[a];t.backend_util.assertAxesAreInnerMostDims("argMax",r,e.rank);for(var n=t.backend_util.computeOutAndReduceShapes(e.shape,r),i=n[0],s=n[1],d=t.zeros(i,"int32"),u=t.util.sizeFromShape(s),p=this.readSync(d.dataId),l=this.readSync(e.dataId),c=0;c<p.length;++c){for(var f=c*u,h=l[f],m=0,v=0;v<u;++v){var k=l[f+v];k>h&&(h=k,m=v)}p[c]=m}return d},c.prototype.cumsum=function(e,a,r,n){if(o(e,"cumsum"),a!==e.rank-1)throw new Error("backend.cumsum in CPU expects an inner-most axis="+(e.rank-1)+" but got axis="+a);for(var i=t.upcastType(e.dtype,"int32"),s=t.zeros(e.shape,i),d=this.readSync(s.dataId),u=this.readSync(e.dataId),p=e.shape[e.rank-1],l=n?function(e,t){return e+p-t-1}:function(e,t){return e+t},c=0;c<u.length;c+=p)for(var f=0;f<p;f++){var h=l(c,f);if(0===f)d[h]=r?0:u[h];else{var m=l(c,f-1);d[h]=r?u[m]+d[m]:u[h]+d[m]}}return s},c.prototype.equal=function(e,t){return o([e,t],"equal"),this.broadcastedBinaryOp(e,t,"bool",(function(e,t){return e===t?1:0}))},c.prototype.notEqual=function(e,t){return o([e,t],"notEqual"),this.broadcastedBinaryOp(e,t,"bool",(function(e,t){return e!==t?1:0}))},c.prototype.less=function(e,t){return o([e,t],"less"),this.broadcastedBinaryOp(e,t,"bool",(function(e,t){return e<t?1:0}))},c.prototype.lessEqual=function(e,t){return o([e,t],"lessEqual"),this.broadcastedBinaryOp(e,t,"bool",(function(e,t){return e<=t?1:0}))},c.prototype.greater=function(e,t){return o([e,t],"greater"),this.broadcastedBinaryOp(e,t,"bool",(function(e,t){return e>t?1:0}))},c.prototype.greaterEqual=function(e,t){return o([e,t],"greaterEqual"),this.broadcastedBinaryOp(e,t,"bool",(function(e,t){return e>=t?1:0}))},c.prototype.logicalAnd=function(e,t){return o([e,t],"logicalAnd"),this.broadcastedBinaryOp(e,t,"bool",(function(e,t){return e&&t}))},c.prototype.logicalOr=function(e,t){return o([e,t],"logicalOr"),this.broadcastedBinaryOp(e,t,"bool",(function(e,t){return e||t}))},c.prototype.select=function(e,a,r){o([e,a,r],"select");for(var n=this.readSync(e.dataId),i=this.readSync(a.dataId),s=this.readSync(r.dataId),d=t.zeros(a.shape,t.upcastType(a.dtype,r.dtype)),u=this.readSync(d.dataId),p=0,l=0===e.rank||e.rank>1||1===a.rank?1:t.util.sizeFromShape(a.shape.slice(1)),c=0;c<n.length;c++)for(var f=0;f<l;f++)1===n[c]?u[p++]=i[c]:u[p++]=s[c];return d},c.prototype.where=function(e){o([e],"where");var t=this.readSync(e.dataId);return l(e.shape,t)},c.prototype.topk=function(e,t,a){o(e,"topk");var r=this.readSync(e.dataId);return p(r,e.shape,e.dtype,t,a)},c.prototype.min=function(e,a){o(e,"min"),t.backend_util.assertAxesAreInnerMostDims("min",a,e.rank);for(var r=t.backend_util.computeOutAndReduceShapes(e.shape,a),n=r[0],i=r[1],s=t.zeros(n,e.dtype),d=t.util.sizeFromShape(i),u=this.readSync(s.dataId),p=this.readSync(e.dataId),l=0;l<u.length;++l){for(var c=l*d,f=p[c],h=0;h<d;++h){var m=p[c+h];m<f&&(f=m)}u[l]=f}return s},c.prototype.minimum=function(e,t){return o([e,t],"minimum"),this.broadcastedBinaryOp(e,t,e.dtype,(function(e,t){return Math.min(e,t)}))},c.prototype.mod=function(e,t){return o([e,t],"mod"),this.broadcastedBinaryOp(e,t,e.dtype,(function(e,t){var a=e%t;return e<0&&t<0||e>=0&&t>=0?a:(a+t)%t}))},c.prototype.maximum=function(e,t){return o([e,t],"maximum"),this.broadcastedBinaryOp(e,t,e.dtype,(function(e,t){return Math.max(e,t)}))},c.prototype.all=function(e,a){o(e,"all"),t.backend_util.assertAxesAreInnerMostDims("all",a,e.rank);for(var r=t.backend_util.computeOutAndReduceShapes(e.shape,a),n=r[0],i=r[1],s=t.zeros(n,e.dtype),d=t.util.sizeFromShape(i),u=this.readSync(s.dataId),p=this.readSync(e.dataId),l=0;l<u.length;++l){for(var c=l*d,f=p[c],h=0;h<d;++h){var m=p[c+h];f=f&&m}u[l]=f}return s},c.prototype.any=function(e,a){o(e,"any"),t.backend_util.assertAxesAreInnerMostDims("any",a,e.rank);for(var r=t.backend_util.computeOutAndReduceShapes(e.shape,a),n=r[0],i=r[1],s=t.zeros(n,e.dtype),d=t.util.sizeFromShape(i),u=this.readSync(s.dataId),p=this.readSync(e.dataId),l=0;l<u.length;++l){for(var c=l*d,f=p[c],h=0;h<d;++h){var m=p[c+h];f=f||m}u[l]=f}return s},c.prototype.squaredDifference=function(e,t){return o([e,t],"squaredDifference"),this.broadcastedBinaryOp(e,t,e.dtype,(function(e,t){var a=e-t;return a*a}))},c.prototype.eluDer=function(e,t){o([e,t],"eluDer");for(var a=new Float32Array(t.size),r=this.readSync(t.dataId),n=this.readSync(e.dataId),i=0;i<r.length;++i){var s=r[i];a[i]=s>=1?n[i]:n[i]*(s+1)}return this.makeOutput(a,t.shape,"float32")},c.prototype.atan2=function(e,t){return o([e,t],"atan2"),this.broadcastedBinaryOp(e,t,e.dtype,(function(e,t){return Math.atan2(e,t)}))},c.prototype.tile=function(e,t){return o(e,"tile"),u(this.bufferSync(e),t)},c.prototype.gather=function(e,a,r){o([e,a],"gather");var n=e.shape.slice(),i=this.readSync(a.dataId);n[r]=i.length;for(var s=t.buffer(n,e.dtype),d=this.bufferSync(e),u=0;u<s.size;++u){var p=s.indexToLoc(u),l=p.slice();l[r]=i[p[r]];var c=d.locToIndex(l);s.values[u]=d.values[c]}return s.toTensor()},c.prototype.batchToSpaceND=function(e,a,r){o([e],"batchToSpaceND");var n=a.reduce((function(e,t){return e*t})),i=t.backend_util.getReshaped(e.shape,a,n),s=t.backend_util.getPermuted(i.length,a.length),d=t.backend_util.getReshapedPermuted(e.shape,a,n),u=t.backend_util.getSliceBeginCoords(r,a.length),p=t.backend_util.getSliceSize(d,r,a.length);return t.transpose(e.reshape(i),s).reshape(d).slice(u,p)},c.prototype.pool3d=function(e,a,r){o(e,"pool3d");for(var n=a.strideDepth,i=a.strideHeight,s=a.strideWidth,d=a.dilationDepth,u=a.dilationHeight,p=a.dilationWidth,l=a.effectiveFilterDepth,c=a.effectiveFilterHeight,f=a.effectiveFilterWidth,h=a.padInfo.front,m=a.padInfo.top,v=a.padInfo.left,k="max"===r?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY,g=this.readSync(e.dataId),I=t.buffer(a.outShape,e.dtype),y=I.values,b=a.outShape[1]*a.outShape[2]*a.outShape[3]*a.outShape[4],S=a.outShape[2]*a.outShape[3]*a.outShape[4],N=a.outShape[3]*a.outShape[4],T=a.outShape[4],x=0;x<a.batchSize;++x)for(var F=x*b,M=x*e.strides[0],A=0;A<a.inChannels;++A)for(var D=0;D<a.outDepth;++D){for(var _=D*n-h,w=_;w<0;)w+=d;for(var z=Math.min(a.inDepth,l+_),W=F+D*S,H=0;H<a.outHeight;++H){for(var C=H*i-m,B=C;B<0;)B+=u;for(var E=Math.min(a.inHeight,c+C),R=W+H*N,P=0;P<a.outWidth;++P){for(var O=P*s-v,q=O;q<0;)q+=p;for(var L=Math.min(a.inWidth,f+O),V=R+P*T,G=k,j=0,U=0,K=w;K<z;K+=d){for(var Y=M+K*e.strides[1],Z=B;Z<E;Z+=u){for(var J=Y+Z*e.strides[2],Q=q;Q<L;Q+=p){var X=g[J+Q*e.strides[3]+A];if("max"===r&&X>G?G=X:"avg"===r&&(j+=X,U++),isNaN(G))break}if(isNaN(G))break}if(isNaN(G))break}y[V+A]="avg"===r?j/U:G}}}return I.toTensor()},c.prototype.avgPool3d=function(e,t){return o(e,"avgPool3d"),this.pool3d(e,t,"avg").toFloat()},c.prototype.avgPool3dBackprop=function(e,a,r){o([e,a],"avgPool3dBackprop");for(var n=r.strideDepth,i=r.strideHeight,s=r.strideWidth,d=r.filterDepth,u=r.filterHeight,p=r.filterWidth,l=r.dilationDepth,c=r.dilationHeight,f=r.dilationWidth,h=r.effectiveFilterDepth,m=r.effectiveFilterHeight,v=r.effectiveFilterWidth,k=h-1-r.padInfo.front,g=v-1-r.padInfo.left,I=m-1-r.padInfo.top,y=t.buffer(a.shape,"float32"),b=1/(d*u*p),S=this.bufferSync(e),N=0;N<r.batchSize;++N)for(var T=0;T<r.inChannels;++T)for(var x=0;x<r.inDepth;++x)for(var F=0;F<r.inHeight;++F)for(var M=0;M<r.inWidth;++M){for(var A=x-k,D=F-I,_=M-g,w=0,z=0;z<h;z+=l){var W=(A+z)/n;if(!(W<0||W>=r.outDepth||Math.floor(W)!==W))for(var H=0;H<m;H+=c){var C=(D+H)/i;if(!(C<0||C>=r.outHeight||Math.floor(C)!==C))for(var B=0;B<v;B+=f){var E=(_+B)/s;if(!(E<0||E>=r.outWidth||Math.floor(E)!==E))w+=S.get(N,W,C,E,T)}}}y.set(w*b,N,x,F,M,T)}return y.toTensor()},c.prototype.maxPool3d=function(e,t){return o(e,"maxPool3d"),this.pool3d(e,t,"max").toFloat()},c.prototype.maxPool3dPositions=function(e,a){for(var r=t.buffer(a.outShape,"int32"),n=a.strideDepth,i=a.strideHeight,o=a.strideWidth,s=a.dilationDepth,d=a.dilationHeight,u=a.dilationWidth,p=a.effectiveFilterDepth,l=a.effectiveFilterHeight,c=a.effectiveFilterWidth,f=a.padInfo.front,h=a.padInfo.top,m=a.padInfo.left,v=this.bufferSync(e),k=0;k<a.batchSize;++k)for(var g=0;g<a.inChannels;++g)for(var I=0;I<a.outDepth;++I){for(var y=I*n-f,b=y;b<0;)b+=s;for(var S=Math.min(a.inDepth,p+y),N=0;N<a.outHeight;++N){for(var T=N*i-h,x=T;x<0;)x+=d;for(var F=Math.min(a.inHeight,l+T),M=0;M<a.outWidth;++M){for(var A=M*o-m,D=A;D<0;)D+=u;for(var _=Math.min(a.inWidth,c+A),w=Number.NEGATIVE_INFINITY,z=-1,W=b;W<S;W+=s)for(var H=W-y,C=x;C<F;C+=d)for(var B=C-T,E=D;E<_;E+=u){var R=E-A,P=v.get(k,W,C,E,g);P>=w&&(w=P,z=H*l*c+B*l+R)}r.set(z,k,I,N,M,g)}}}return r.toTensor()},c.prototype.maxPool3dBackprop=function(e,a,r,n){o([a,r],"maxPool3dBackprop");for(var i=this.maxPool3dPositions(a,n),s=n.strideDepth,d=n.strideHeight,u=n.strideWidth,p=n.dilationDepth,l=n.dilationHeight,c=n.dilationWidth,f=n.effectiveFilterDepth,h=n.effectiveFilterHeight,m=n.effectiveFilterWidth,v=f-1-n.padInfo.front,k=m-1-n.padInfo.left,g=h-1-n.padInfo.top,I=t.buffer(a.shape,"float32"),y=this.bufferSync(i),b=this.bufferSync(e),S=0;S<n.batchSize;++S)for(var N=0;N<n.inChannels;++N)for(var T=0;T<n.inDepth;++T)for(var x=0;x<n.inHeight;++x)for(var F=0;F<n.inWidth;++F){for(var M=T-v,A=x-g,D=F-k,_=0,w=0;w<f;w+=p){var z=(M+w)/s;if(!(z<0||z>=n.outDepth||Math.floor(z)!==z))for(var W=0;W<h;W+=l){var H=(A+W)/d;if(!(H<0||H>=n.outHeight||Math.floor(H)!==H))for(var C=0;C<m;C+=c){var B=(D+C)/u;if(!(B<0||B>=n.outWidth||Math.floor(B)!==B)){var E=f*h*m-1-y.get(S,z,H,B,N)===w*h*m+W*m+C?1:0;if(0!==E)_+=b.get(S,z,H,B,N)*E}}}}I.set(_,S,T,x,F,N)}return I.toTensor()},c.prototype.resizeBilinear=function(e,a,r,n){o(e,"resizeBilinear");for(var i=e.shape,s=i[0],d=i[1],u=i[2],p=i[3],l=this.readSync(e.dataId),c=new Float32Array(t.util.sizeFromShape([s,a,r,p])),f=[n&&a>1?d-1:d,n&&r>1?u-1:u],h=[n&&a>1?a-1:a,n&&r>1?r-1:r],m=0,v=f[0]/h[0],k=f[1]/h[1],g=0;g<s;g++)for(var I=0;I<a;I++)for(var y=v*I,b=Math.floor(y),S=y-b,N=Math.min(d-1,Math.ceil(y)),T=g*e.strides[0]+b*e.strides[1],x=g*e.strides[0]+N*e.strides[1],F=0;F<r;F++)for(var M=k*F,A=Math.floor(M),D=M-A,_=Math.min(u-1,Math.ceil(M)),w=T+A*e.strides[2],z=x+A*e.strides[2],W=T+_*e.strides[2],H=x+_*e.strides[2],C=0;C<p;C++){var B=l[w+C],E=l[z+C],R=B+(l[W+C]-B)*D,P=R+(E+(l[H+C]-E)*D-R)*S;c[m++]=P}return t.tensor(c,[s,a,r,p])},c.prototype.resizeBilinearBackprop=function(e,a,r){o([e,a],"resizeBilinearBackprop");for(var n=a.shape,i=n[0],s=n[1],d=n[2],u=n[3],p=e.shape,l=p[1],c=p[2],f=new Float32Array(i*s*d*u),h=[r&&l>1?s-1:s,r&&c>1?d-1:d],m=[r&&l>1?l-1:l,r&&c>1?c-1:c],v=h[0]/m[0],k=h[1]/m[1],g=this.readSync(e.dataId),I=0,y=0;y<i;y++)for(var b=y*a.strides[0],S=0;S<l;S++)for(var N=S*v,T=Math.floor(N),x=Math.min(Math.ceil(N),s-1),F=b+T*a.strides[1],M=b+x*a.strides[1],A=N-T,D=1-A,_=0;_<c;_++)for(var w=_*k,z=Math.floor(w),W=Math.min(Math.ceil(w),d-1),H=w-z,C=1-H,B=F+z*a.strides[2],E=F+W*a.strides[2],R=M+z*a.strides[2],P=M+W*a.strides[2],O=D*C,q=D*H,L=A*C,V=A*H,G=0;G<u;G++){var j=g[I++];f[B+G]+=j*O,f[E+G]+=j*q,f[R+G]+=j*L,f[P+G]+=j*V}return t.tensor4d(f,[i,d,s,u],a.dtype)},c.prototype.resizeNearestNeighbor=function(e,a,r,n){o(e,"resizeNearestNeighbor");for(var i=e.shape,s=i[0],d=i[1],u=i[2],p=i[3],l=this.readSync(e.dataId),c=new Float32Array(s*a*r*p),f=[n&&a>1?d-1:d,n&&r>1?u-1:u],h=[n&&a>1?a-1:a,n&&r>1?r-1:r],m=f[0]/h[0],v=f[1]/h[1],k=0,g=0;g<s;g++)for(var I=g*e.strides[0],y=0;y<a;y++)for(var b=m*y,S=I+Math.min(d-1,n?Math.round(b):Math.floor(b))*e.strides[1],N=0;N<r;N++)for(var T=v*N,x=S+Math.min(u-1,n?Math.round(T):Math.floor(T))*e.strides[2],F=0;F<p;F++){var M=l[x+F];c[k++]=M}return t.tensor(c,[s,a,r,p],e.dtype)},c.prototype.resizeNearestNeighborBackprop=function(e,a,r){o([e,a],"resizeNearestNeighborBackprop");for(var n=a.shape,i=n[0],s=n[1],d=n[2],u=n[3],p=e.shape,l=p[1],c=p[2],f=new Float32Array(i*s*d*u),h=this.readSync(e.dataId),m=[r&&l>1?s-1:s,r&&c>1?d-1:d],v=[r&&l>1?l-1:l,r&&c>1?c-1:c],k=m[0]/v[0],g=m[1]/v[1],I=1/k,y=1/g,b=2*Math.ceil(I)+2,S=2*Math.ceil(y)+2,N=0;N<i;N++)for(var T=N*a.strides[0],x=0;x<s;x++)for(var F=T+x*a.strides[1],M=Math.floor(x*I),A=Math.floor(M-b/2),D=0;D<d;D++)for(var _=F+D*a.strides[2],w=Math.floor(D*y),z=Math.floor(w-S/2),W=0;W<u;W++){for(var H=0,C=0;C<b;C++){var B=C+A;if(!(B<0||B>=l)){var E=T+B*e.strides[1],R=B*k;if(x===Math.min(s-1,r?Math.round(R):Math.floor(R)))for(var P=0;P<S;P++){var O=P+z;if(!(O<0||O>=c)){var q=E+O*e.strides[2],L=O*g;D===Math.min(d-1,r?Math.round(L):Math.floor(L))&&(H+=h[q+W])}}}}f[_+W]=H}return t.tensor4d(f,a.shape,a.dtype)},c.prototype.localResponseNormalization4D=function(e,a,r,n,i){o(e,"localResponseNormalization4D");var s=e.shape[3],d=s-1,u=this.readSync(e.dataId),p=e.size,l=new Float32Array(p);function c(e){for(var t=e%s,r=e-t+Math.max(0,t-a),n=e-t+Math.min(t+a,d),i=0;r<=n;r++){var o=u[r];i+=o*o}return i}for(var f=0;f<p;f++){var h=c(f),m=u[f]*Math.pow(r+n*h,-i);l[f]=m}return t.tensor4d(l,e.shape)},c.prototype.LRNGrad=function(e,a,r,n,i,s,d){o(e,"LRNGrad");for(var u=e.shape[3],p=this.readSync(e.dataId),l=this.readSync(a.dataId),c=this.readSync(r.dataId),f=new Float32Array(e.size),h=e.size,m=0;m<h;m++){for(var v=m%u,k=m-v+Math.max(0,v-n),g=m-v+Math.min(u,v+n+1),I=0,y=k;y<g;y++)I+=Math.pow(l[y],2);I=s*I+i;for(y=k;y<g;y++){var b=-2*s*d*l[y]*c[m]/I;m===y&&(b+=Math.pow(I,-d)),b*=p[m],f[y]+=b}}return t.tensor4d(f,e.shape)},c.prototype.multinomial=function(e,r,n,i){o(e,"multinomial");for(var s=r?e:t.softmax(e),d=s.shape[0],u=s.shape[1],p=t.zeros([d,n],"int32"),l=this.readSync(p.dataId),c=this.readSync(s.dataId),f=0;f<d;++f){var h=f*u,m=new Float32Array(u-1);m[0]=c[h];for(var v=1;v<m.length;++v)m[v]=m[v-1]+c[h+v];for(var k=a.alea(i.toString()),g=f*n,I=0;I<n;++I){var y=k();l[g+I]=m.length;for(var b=0;b<m.length;b++)if(y<m[b]){l[g+I]=b;break}}}return p},c.prototype.oneHot=function(e,a,r,n){o(e,"oneHot");var i=new Float32Array(e.size*a);i.fill(n);for(var s=this.readSync(e.dataId),d=0;d<e.size;++d)s[d]>=0&&s[d]<a&&(i[d*a+s[d]]=r);return t.tensor2d(i,[e.size,a],"int32")},c.prototype.nonMaxSuppression=function(e,t,a,r,n){o(e,"nonMaxSuppression");var i=this.readSync(e.dataId),d=this.readSync(t.dataId);return s(i,d,a,r,n)},c.prototype.depthToSpace=function(e,a,r){t.util.assert("NHWC"===r,(function(){return"Only NHWC dataFormat supported on CPU for depthToSpace. Got "+r})),t.util.assert(a>1,(function(){return"blockSize should be > 1 for depthToSpace, but was: "+a}));for(var n=e.shape[0],i=e.shape[1],o=e.shape[2],s=e.shape[3],d=i*a,u=o*a,p=s/(a*a),l=this.readSync(e.dataId),c=new Float32Array(n*d*u*p),f=0,h=0;h<n;++h)for(var m=0;m<d;++m)for(var v=Math.floor(m/a),k=m%a,g=0;g<u;++g)for(var I=Math.floor(g/a),y=(k*a+g%a)*p,b=0;b<p;++b){var S=b+y+s*(I+o*(v+i*h));c[f++]=l[S]}return t.tensor4d(c,[n,d,u,p])},c.prototype.broadcastedBinaryOp=function(e,a,r,n){var i=t.backend_util.assertAndGetBroadcastShape(e.shape,a.shape),o=t.buffer(i,r),s=this.readSync(e.dataId),d=this.readSync(a.dataId),u=t.backend_util.getBroadcastDims(e.shape,i),p=t.backend_util.getBroadcastDims(a.shape,i),l=o.values;if(u.length+p.length===0)for(var c=0;c<l.length;++c)l[c]=n(s[c%s.length],d[c%d.length]);else{var f=this.bufferSync(e),h=this.bufferSync(a),m=function(t){var r=o.indexToLoc(t),i=r.slice(-e.rank);u.forEach((function(e){return i[e]=0}));var c=f.locToIndex(i),m=r.slice(-a.rank);p.forEach((function(e){return m[e]=0}));var v=h.locToIndex(m);l[t]=n(s[c],d[v])};for(c=0;c<l.length;++c)m(c)}return o.toTensor()},c.prototype.split=function(e,t,a){return d(e,t,a)},c.prototype.dispose=function(){},c.prototype.floatPrecision=function(){return 32},c.prototype.epsilon=function(){return e.prototype.epsilon.call(this)},c.prototype.cropAndResize=function(e,a,r,n,i,o){for(var s=e.shape,d=s[0],u=s[1],p=s[2],l=s[3],c=a.shape[0],f=n[0],h=n[1],m=t.buffer([c,f,h,l],"float32"),v=this.readSync(a.dataId),k=this.readSync(r.dataId),g=this.readSync(e.dataId),I=e.strides,y=m.strides,b=0;b<c;b++){var S=4*b,N=v[S],T=v[S+1],x=v[S+2],F=v[S+3],M=k[b];if(!(M>=d))for(var A=f>1?(x-N)*(u-1)/(f-1):0,D=h>1?(F-T)*(p-1)/(h-1):0,_=0;_<f;_++){var w=f>1?N*(u-1)+_*A:.5*(N+x)*(u-1);if(w<0||w>u-1)for(var z=0;z<h;z++)for(var W=0;W<l;W++){var H=W+z*y[2]+_*y[1]+b*y[0];m.values[H]=o}else if("bilinear"===i){var C=Math.floor(w),B=Math.ceil(w),E=w-C;for(z=0;z<h;z++){if((U=h>1?T*(p-1)+z*D:.5*(T+F)*(p-1))<0||U>p-1)for(W=0;W<l;W++){H=W+z*y[2]+_*y[1]+b*y[0];m.values[H]=o}else{var R=Math.floor(U),P=Math.ceil(U),O=U-R;for(W=0;W<l;W++){var q=g[H=W+R*I[2]+C*I[1]+M*I[0]],L=g[H=W+P*I[2]+C*I[1]+M*I[0]],V=g[H=W+R*I[2]+B*I[1]+M*I[0]],G=q+(L-q)*O,j=V+(g[H=W+P*I[2]+B*I[1]+M*I[0]]-V)*O;H=W+z*y[2]+_*y[1]+b*y[0],m.values[H]=G+(j-G)*E}}}}else for(z=0;z<h;++z){var U;if((U=h>1?T*(p-1)+z*D:.5*(T+F)*(p-1))<0||U>p-1)for(W=0;W<l;W++){H=W+z*y[2]+_*y[1]+b*y[0];m.values[H]=o}else{var K=Math.round(U),Y=Math.round(w);for(W=0;W<l;W++){var Z=W+K*I[2]+Y*I[1]+M*I[0],J=W+z*y[2]+_*y[1]+b*y[0];m.values[J]=g[Z]}}}}}return m.toTensor()},c.prototype.sparseToDense=function(e,a,r,n){var i=t.backend_util.calculateShapes(a,e,r),o=i.sliceRank,s=i.numUpdates,d=i.sliceSize,u=i.strides,p=i.outputSize;return this.scatter(e,a,r,p,d,s,o,u,n,!1)},c.prototype.gatherND=function(e,a){var r=a.shape,n=r[r.length-1],i=t.backend_util.prepareAndValidate(e,a),o=i[0],s=i[1],d=i[2],u=i[3];if(0===s)return t.tensor([],o,e.dtype);for(var p=new t.TensorBuffer([s,d],e.dtype),l=this.readSync(a.dataId),c=this.readSync(e.dataId),f=0;f<s;f++){for(var h=[],m=0,v=0;v<n;v++){var k=l[f*n+v];m+=k*u[v],h.push(k)}if(m<0||m>=e.size/d)throw new Error("Invalid indices: "+h+" does not index into "+e.shape);for(var g=0;g<d;g++)p.values[f*d+g]=c[m*d+g]}return p.toTensor().reshape(o)},c.prototype.scatterND=function(e,a,r){var n=t.backend_util.calculateShapes(a,e,r),i=n.sliceRank,o=n.numUpdates,s=n.sliceSize,d=n.strides,u=n.outputSize,p=t.scalar(0);return this.scatter(e,a,r,u,s,o,i,d,p,!0)},c.prototype.onesLike=function(e){if("string"===e.dtype)throw new Error("onesLike is not supported for string tensors");return t.fill(e.shape,1,e.dtype)},c.prototype.zerosLike=function(e){var a=t.util.getArrayFromDType(e.dtype,t.util.sizeFromShape(e.shape));return this.makeOutput(a,e.shape,e.dtype)},c.prototype.linspace=function(e,a,r){return t.backend_util.linspaceImpl(e,a,r)},c.prototype.scatter=function(e,a,r,n,i,o,s,d,u,p){var l=[n/i,i],c=this.readSync(e.dataId),f=this.readSync(a.dataId);if(0===n)return t.tensor([],r,a.dtype);var h=new t.TensorBuffer(l,a.dtype);h.values.fill(this.readSync(u.dataId)[0]);for(var m=0;m<o;m++){for(var v=[],k=0,g=0;g<s;g++){var I=c[m*s+g];v.push(I),k+=I*d[g]}if(k<0||k>=n/i)throw new Error("Invalid indices: "+v+" does not index into "+r);for(var y=0;y<i;y++)p?h.values[k*i+y]+=f[m*i+y]:h.values[k*i+y]=0===a.rank?f[0]:f[m*i+y]}return h.toTensor().reshape(r)},c}(t.KernelBackend);function f(e){for(var t=new Float32Array(e.length),a=0;a<e.length;++a)t[a]=Math.abs(e[a]);return t}var h={kernelName:t.Abs,backendName:"cpu",kernelFunc:function(e){var a=e.inputs.x,r=e.backend,n=new Float32Array(t.util.sizeFromShape(a.shape));if("complex64"!==a.dtype)n=f(r.data.get(a.dataId).values);else for(var i=r.data.get(a.dataId),o=i.complexTensorInfos.real,s=i.complexTensorInfos.imag,d=r.data.get(o.dataId).values,u=r.data.get(s.dataId).values,p=0;p<d.length;p++){var l=d[p],c=u[p];n[p]=Math.hypot(l,c)}return r.makeOutput(n,a.shape,"float32")}};function m(e){return function(a,r,n,i,o){var s=t.backend_util.assertAndGetBroadcastShape(a,r),d=s.length,u=t.util.computeStrides(s),p=t.util.sizeFromShape(s),l=t.util.getTypedArrayFromDType(o,p),c=a.length,f=r.length,h=t.util.computeStrides(a),m=t.util.computeStrides(r),v=t.backend_util.getBroadcastDims(a,s),k=t.backend_util.getBroadcastDims(r,s);if(v.length+k.length===0)for(var g=0;g<l.length;++g)l[g]=e(n[g%n.length],i[g%i.length]);else{var I=function(a){var r=t.util.indexToLoc(a,d,u),o=r.slice(-c);v.forEach((function(e){return o[e]=0}));var s=t.util.locToIndex(o,c,h),p=r.slice(-f);k.forEach((function(e){return p[e]=0}));var g=t.util.locToIndex(p,f,m);l[a]=e(n[s],i[g])};for(g=0;g<l.length;++g)I(g)}return[l,s]}}function v(e){var t=e.inputs,a=e.backend,r=t.real,n=t.imag,i=a.data.get(r.dataId).values,o=a.data.get(n.dataId).values,s=a.makeTensorInfo(r.shape,"complex64");return a.data.get(s.dataId).complexTensorInfos={real:a.makeTensorInfo(r.shape,"float32",i),imag:a.makeTensorInfo(n.shape,"float32",o)},s}var k={kernelName:t.Complex,backendName:"cpu",kernelFunc:v};function g(e){var t=e.inputs,a=e.backend,r=t.x;return a.incRef(r.dataId),{dataId:r.dataId,shape:r.shape,dtype:r.dtype}}var I={kernelName:t.Identity,backendName:"cpu",kernelFunc:g};function y(e){var t=e.inputs,a=e.backend,r=t.input,n=a.data.get(r.dataId).complexTensorInfos.real,i=a.data.get(n.dataId).values;return a.makeTensorInfo(n.shape,n.dtype,i)}var b={kernelName:t.Real,backendName:"cpu",kernelFunc:y};function S(e){var a=e.inputs,r=e.backend,n=e.attrs,i=a.x,o=n.dtype;if("complex64"===o){if("complex64"===i.dtype)return g({inputs:{x:i},backend:r});var s=t.zeros(i.shape),d=S({inputs:{x:i},backend:r,attrs:{dtype:"float32"}}),u=v({inputs:{real:d,imag:s},backend:r});return s.dispose(),r.disposeIntermediateTensorInfo(d),u}if("complex64"===i.dtype){var p=y({inputs:{input:i},backend:r}),u=S({inputs:{x:p},backend:r,attrs:{dtype:o}});return r.disposeIntermediateTensorInfo(p),u}if(!t.util.hasEncodingLoss(i.dtype,o))return{dataId:(u=g({inputs:{x:i},backend:r})).dataId,shape:u.shape,dtype:o};if("int32"===o){var l=r.data.get(i.dataId).values,c=Int32Array.from(l);return r.makeTensorInfo(i.shape,"int32",c)}if("bool"===o){var f=r.data.get(i.dataId).values,h=t.util.toTypedArray([0],i.dtype),k=m((function(e,t){return e!==t?1:0}))(i.shape,[],f,h,"bool"),I=k[0],b=k[1];return r.makeTensorInfo(b,"bool",I)}throw new Error("Error in Cast: failed to cast "+i.dtype+" to "+o)}var N={kernelName:t.Cast,backendName:"cpu",kernelFunc:S};function T(e,t,a,r){return null==a?function(a){var n=a.inputs,i=a.backend,s=n,d=s.a,u=s.b,p=i;o([d,u],e);var l=p.data.get(d.dataId).values,c=p.data.get(u.dataId).values,f=r||d.dtype,h=t(d.shape,u.shape,l,c,f),m=h[0],v=h[1];return p.makeTensorInfo(v,f,m)}:function(e){var n=e.inputs,i=e.backend,o=n,s=o.a,d=o.b,u=i;if("complex64"===s.dtype||"complex64"===d.dtype){var p=S({inputs:{x:s},backend:u,attrs:{dtype:"complex64"}}),l=u.data.get(p.dataId),c=l.complexTensorInfos.real,f=l.complexTensorInfos.imag,h=u.data.get(c.dataId).values,m=u.data.get(f.dataId).values,k=S({inputs:{x:d},backend:u,attrs:{dtype:"complex64"}}),g=u.data.get(k.dataId),I=g.complexTensorInfos.real,y=g.complexTensorInfos.imag,b=u.data.get(I.dataId).values,N=u.data.get(y.dataId).values,T=a(s.shape,d.shape,h,m,b,N),x=T[0],F=T[1],M=T[2],A=u.makeTensorInfo(M,"float32",x),D=u.makeTensorInfo(M,"float32",F),_=v({inputs:{real:A,imag:D},backend:u});return u.disposeIntermediateTensorInfo(p),u.disposeIntermediateTensorInfo(k),u.disposeIntermediateTensorInfo(A),u.disposeIntermediateTensorInfo(D),_}var w=u.data.get(s.dataId).values,z=u.data.get(d.dataId).values,W=r||s.dtype,H=t(s.shape,d.shape,w,z,W),C=H[0];M=H[1];return u.makeTensorInfo(M,W,C)}}function x(e){return function(a,r,n,i,o,s){var d=t.backend_util.assertAndGetBroadcastShape(a,r),u=t.util.sizeFromShape(d),p=d.length,l=t.util.computeStrides(d),c=t.util.getTypedArrayFromDType("float32",u),f=t.util.getTypedArrayFromDType("float32",u),h=t.backend_util.getBroadcastDims(a,d),m=t.backend_util.getBroadcastDims(r,d),v=t.backend_util.mergeRealAndImagArrays(n,i),k=t.backend_util.mergeRealAndImagArrays(o,s),g=a.length,I=t.util.computeStrides(a),y=r.length,b=t.util.computeStrides(r);if(h.length+m.length===0)for(var S=0;S<c.length;S++){var N=S%v.length,T=S%k.length,x=e(v[2*N],v[2*N+1],k[2*T],k[2*T+1]);c[S]=x.real,f[S]=x.imag}else{var F=function(a){var r=t.util.indexToLoc(a,p,l),n=r.slice(-g);h.forEach((function(e){return n[e]=0}));var i=t.util.locToIndex(n,g,I),o=r.slice(-y);m.forEach((function(e){return o[e]=0}));var s=t.util.locToIndex(o,y,b),d=e(v[2*i],v[2*i+1],k[2*s],k[2*s+1]);c[a]=d.real,f[a]=d.imag};for(S=0;S<c.length;S++)F(S)}return[c,f,d]}}var F=m((function(e,t){return e+t})),M=x((function(e,t,a,r){return{real:e+a,imag:t+r}})),A=T(t.Add,F,M),D={kernelName:t.Add,backendName:"cpu",kernelFunc:A};function _(e){return function(a,r,n){for(var i=t.util.getTypedArrayFromDType(r,a.length),o=0;o<a.length;++o)i[o]=e(a[o],n);return i}}function w(e,a,r){return function(n){var i=n.inputs,s=n.attrs,d=n.backend,u=i.x;if(o(u,e),"string"===u.dtype||"string"===r)throw new Error("unaryKernelFunc does not support string input/output");for(var p=d,l=p.data.get(u.dataId).values,c=t.util.sizeFromShape(u.shape),f=r||u.dtype,h=t.util.getArrayFromDType(f,c),m=0;m<c;++m)h[m]=a(l[m],s);return p.makeTensorInfo(u.shape,f,h)}}function z(e,t,a){return function(r){var n=r.inputs,i=r.attrs,s=r.backend,d=n.x;if(o(d,e),"string"===d.dtype||"string"===a)throw new Error("unaryKernelFunc does not support string input/output");var u=s,p=u.data.get(d.dataId).values,l=a||d.dtype,c=t(p,l,i);return u.makeTensorInfo(d.shape,l,c)}}var W=_((function(e){return Math.ceil(e)})),H=z(t.Ceil,W),C={kernelName:t.Ceil,backendName:"cpu",kernelFunc:H},B=_((function(e){return Math.exp(e)})),E=z(t.Exp,B),R={kernelName:t.Exp,backendName:"cpu",kernelFunc:E},P=_((function(e){return Math.expm1(e)})),O=z(t.Expm1,P),q={kernelName:t.Expm1,backendName:"cpu",kernelFunc:O},L=_((function(e){return Math.floor(e)})),V=z(t.Floor,L),G={kernelName:t.Floor,backendName:"cpu",kernelFunc:V},j=_((function(e){return Math.log(e)})),U=z(t.Log,j),K={kernelName:t.Log,backendName:"cpu",kernelFunc:U};function Y(e,a,r,n){for(var i=t.util.getTypedArrayFromDType(n,t.util.sizeFromShape(r)),o=0;o<i.length;++o){for(var s=o*a,d=e[s],u=0;u<a;++u){var p=e[s+u];p>d&&(d=p)}i[o]=d}return i}var Z=m((function(e,t){return e*t})),J=x((function(e,t,a,r){return{real:e*a-t*r,imag:e*r+t*a}})),Q=T(t.Multiply,Z,J),X={kernelName:t.Multiply,backendName:"cpu",kernelFunc:Q},$=m((function(e,t){return e!==t?1:0})),ee=T(t.NotEqual,$,null,"bool"),te={kernelName:t.NotEqual,backendName:"cpu",kernelFunc:ee},ae=_((function(e){return 1/Math.sqrt(e)})),re=z(t.Rsqrt,ae),ne={kernelName:t.Rsqrt,backendName:"cpu",kernelFunc:re};function ie(e,a,r,n,i){var o=t.slice_util.isSliceContinous(n,a,r),s=t.util.sizeFromShape(r),d=t.util.computeStrides(n);if(o){var u=t.slice_util.computeFlatOffset(a,d);return e.subarray(u,u+s)}for(var p=t.util.getTypedArrayFromDType(i,s),l=0;l<s;++l){var c=r.length,f=t.util.computeStrides(r),h=t.util.indexToLoc(l,c,f).map((function(e,t){return e+a[t]})),m=t.util.locToIndex(h,n.length,d);p[l]=e[m]}return p}function oe(e){var a=e.inputs,r=e.backend,n=e.attrs,i=a.x,s=n.begin,d=n.size;o(i,"slice");var u=t.slice_util.parseSliceParams(i,s,d),p=u[0],l=u[1];t.slice_util.assertParamsValid(i,p,l);var c=ie(r.data.get(i.dataId).values,p,l,i.shape,i.dtype);return r.makeTensorInfo(l,i.dtype,c)}var se={kernelName:t.Slice,backendName:"cpu",kernelFunc:oe},de=m((function(e,t){var a=e-t;return a*a})),ue=T(t.SquaredDifference,de),pe={kernelName:t.SquaredDifference,backendName:"cpu",kernelFunc:ue},le=m((function(e,t){return e-t})),ce=x((function(e,t,a,r){return{real:e-a,imag:t-r}})),fe=T(t.Sub,le,ce),he={kernelName:t.Sub,backendName:"cpu",kernelFunc:fe};function me(e,a,r,n,i){for(var o=a.length,s=t.util.sizeFromShape(a),d=t.util.computeStrides(a),u=t.util.computeStrides(i),p=t.util.getTypedArrayFromDType(r,t.util.sizeFromShape(i)),l=0;l<s;++l){for(var c=t.util.indexToLoc(l,o,d),f=new Array(c.length),h=0;h<f.length;h++)f[h]=c[n[h]];p[t.util.locToIndex(f,o,u)]=e[l]}return p}function ve(e,a,r,n){for(var i=t.util.parseAxisParam(a,r)[0],o=[1,r[0],1],s=0;s<i;s++)o[0]*=r[s];o[1]=r[i];for(s=i+1;s<r.length;s++)o[2]*=r[s];var d={},u=new Int32Array(r[i]),p=new t.TensorBuffer(o,n,e),l=[],c=1===o[0]&&1===o[2];for(s=0;s<r[i];s++){var f=void 0;if(c)f=e[s].toString();else{for(var h=[],m=0;m<o[0];m++)for(var v=0;v<o[2];v++)h.push(p.get(m,s,v));f=h.join(",")}if(void 0!==d[f])u[s]=d[f];else{var k=Object.keys(d).length;d[f]=k,u[s]=k,l.push(s)}}var g=o.slice();g[1]=Object.keys(d).length;var I=new t.TensorBuffer(g,n);l.forEach((function(e,t){for(var a=0;a<o[0];a++)for(var r=0;r<o[2];r++)I.set(p.get(a,e,r),a,t,r)}));var y=r.slice();return y[i]=g[1],{outputValues:I.values,outputShape:y,indices:u}}var ke={__proto__:null,simpleAbsImpl:f,addImpl:F,ceilImpl:W,expImpl:B,expm1Impl:P,floorImpl:L,logImpl:j,maxImpl:Y,multiplyImpl:Z,notEqualImpl:$,rsqrtImpl:ae,sliceImpl:ie,squaredDifferenceImpl:de,subImpl:le,transposeImpl:me,uniqueImpl:ve};t.registerBackend("cpu",(function(){return new c}),1);var ge=w(t.Elu,(function(e){return e>=0?e:Math.exp(e)-1})),Ie={kernelName:t.Elu,backendName:"cpu",kernelFunc:ge},ye=m((function(e,t){return e<0?t*e:e}));function be(e){var t=e.inputs,a=e.backend,r=t.x,n=t.alpha;o([r,n],"prelu");var i=a.data.get(r.dataId).values,s=a.data.get(n.dataId).values,d=ye(r.shape,n.shape,i,s,r.dtype),u=d[0],p=d[1];return a.makeTensorInfo(p,r.dtype,u)}var Se={kernelName:t.Prelu,backendName:"cpu",kernelFunc:be},Ne=w(t.Relu,(function(e){return Math.max(0,e)})),Te={kernelName:t.Relu,backendName:"cpu",kernelFunc:Ne},xe=w(t.Relu6,(function(e){return Math.min(Math.max(0,e),6)})),Fe={kernelName:t.Relu6,backendName:"cpu",kernelFunc:xe};function Me(e,t,a,r){if("linear"===a)return g({inputs:{x:t},backend:e});if("relu"===a)return Ne({inputs:{x:t},backend:e});if("elu"===a)return ge({inputs:{x:t},backend:e});if("relu6"===a)return xe({inputs:{x:t},backend:e});if("prelu"===a)return be({inputs:{x:t,alpha:r},backend:e});throw new Error("Activation "+a+" has not been implemented for the CPU backend.")}function Ae(e){var a=e.inputs,r=e.backend,n=e.attrs,i=a.x,o=n.shape,s=t.util.sizeFromShape(i.shape),d=t.util.inferFromImplicitShape(o,s),u=t.util.sizeFromShape(d);t.util.assert(s===u,(function(){return"The new shape ("+d+") has "+u+" elements and the old shape ("+i.shape+") has "+s+" elements. The new shape and old shape must have the same number of elements."})),r.incRef(i.dataId);var p=r.data.get(i.dataId);if(null!=p.complexTensorInfos){var l=p.complexTensorInfos.real,c=p.complexTensorInfos.imag;l.shape=d,c.shape=d}return{dataId:i.dataId,shape:d,dtype:i.dtype}}var De={kernelName:t.Reshape,backendName:"cpu",kernelFunc:Ae};function _e(e){var a=e.inputs,r=e.backend,n=e.attrs,i=a.a,s=a.b,d=n.transposeA,u=n.transposeB;o([i,s],"matMul");var p=i.shape.length,l=s.shape.length,c=d?i.shape[p-2]:i.shape[p-1],f=u?s.shape[l-1]:s.shape[l-2],h=d?i.shape[p-1]:i.shape[p-2],m=u?s.shape[l-2]:s.shape[l-1],v=i.shape.slice(0,-2),k=s.shape.slice(0,-2),g=t.util.sizeFromShape(v),I=t.util.sizeFromShape(k),y=g===I||1===g||1===I;t.util.assert(p>=2&&l>=2&&y,(function(){return"Error in matMul: the input batch dimensions must either be the same or at least one input batch dimension must be 1. Got input batch dimensions of ("+v+") and ("+k+")."}));var b=(g>I?i.shape.slice(0,-2):s.shape.slice(0,-2)).concat([h,m]);t.util.assert(c===f,(function(){return"Error in matMul: inner shapes ("+c+") and ("+f+") of Tensors with shapes "+i.shape+" and "+s.shape+" and transposeA="+d+" and transposeB="+u+" must match."}));for(var S=u?[I,m,f]:[I,f,m],N=Ae({inputs:{x:i},backend:r,attrs:{shape:d?[g,c,h]:[g,h,c]}}),T=Ae({inputs:{x:s},backend:r,attrs:{shape:S}}),x=d?N.shape[1]:N.shape[2],F=d?N.shape[2]:N.shape[1],M=u?T.shape[1]:T.shape[2],A=Math.max(g,I),D=r.data.get(N.dataId).values,_=r.data.get(T.dataId).values,w=t.util.computeStrides(N.shape),z=t.util.computeStrides(T.shape),W=d?[w[0],1,w[1]]:[w[0],w[1],1],H=W[0],C=W[1],B=W[2],E=u?[1,z[1],z[0]]:[z[1],1,z[0]],R=E[0],P=E[1],O=E[2],q=F*M,L=t.buffer([A,F,M],N.dtype),V=L.values,G=r.blockSize,j=0;j<A;j++)for(var U=0;U<F;U+=G)for(var K=0;K<M;K+=G)for(var Y=0;Y<x;Y+=G)for(var Z=Math.min(U+G,F),J=Math.min(K+G,M),Q=Math.min(Y+G,x),X=U;X<Z;X++)for(var $=K;$<J;$++){for(var ee=0,te=Y;te<Q;te++){var ae=Math.min(j,g-1)*H,re=Math.min(j,I-1)*O;ee+=D[ae+X*C+te*B]*_[te*R+$*P+re]}V[j*q+(X*M+$)]+=ee}return r.disposeIntermediateTensorInfo(N),r.disposeIntermediateTensorInfo(T),r.makeTensorInfo(b,L.dtype,L.values)}var we={kernelName:t.BatchMatMul,backendName:"cpu",kernelFunc:_e};var ze={kernelName:t._FusedMatMul,backendName:"cpu",kernelFunc:function(e){var t,a,r,n=e.inputs,i=e.backend,o=e.attrs,s=n.a,d=n.b,u=n.bias,p=n.preluActivationWeights,l=o.transposeA,c=o.transposeB,f=o.activation,h=[];t=_e({inputs:{a:s,b:d},attrs:{transposeA:l,transposeB:c},backend:i}),u&&(a=A({inputs:{a:t,b:u},backend:i}),h.push(t),t=a),f&&(r=Me(i,t,f,p),h.push(t),t=r);for(var m=0,v=h;m<v.length;m++){var k=v[m];i.disposeIntermediateTensorInfo(k)}return t}},We=w(t.Acos,(function(e){return Math.acos(e)})),He={kernelName:t.Acos,backendName:"cpu",kernelFunc:We},Ce=w(t.Acosh,(function(e){return Math.acosh(e)})),Be={kernelName:t.Acosh,backendName:"cpu",kernelFunc:Ce},Ee=w(t.Asin,(function(e){return Math.asin(e)})),Re={kernelName:t.Asin,backendName:"cpu",kernelFunc:Ee},Pe=w(t.Asinh,(function(e){return Math.asinh(e)})),Oe={kernelName:t.Asinh,backendName:"cpu",kernelFunc:Pe},qe=w(t.Atan,(function(e){return Math.atan(e)})),Le={kernelName:t.Atan,backendName:"cpu",kernelFunc:qe},Ve=w(t.Atanh,(function(e){return Math.atanh(e)})),Ge={kernelName:t.Atanh,backendName:"cpu",kernelFunc:Ve};function je(e,a,r,n,i,o){for(var s=i.strideHeight,d=i.strideWidth,u=i.dilationHeight,p=i.dilationWidth,l=i.effectiveFilterHeight,c=i.effectiveFilterWidth,f=i.padInfo.top,h=i.padInfo.left,m="max"===o?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY,v=t.buffer(i.outShape,r),k=v.values,g=i.outShape[1]*i.outShape[2]*i.outShape[3],I=i.outShape[2]*i.outShape[3],y=i.outShape[3],b=0;b<i.batchSize;++b)for(var S=b*g,N=b*n[0],T=0;T<i.inChannels;++T)for(var x=0;x<i.outHeight;++x)for(var F=x*s-f,M=Math.max(0,F),A=Math.min(i.inHeight,l+F),D=S+x*I,_=0;_<i.outWidth;++_){for(var w=_*d-h,z=Math.max(0,w),W=Math.min(i.inWidth,c+w),H=m,C=0,B=0,E=M;E<A;E+=u){for(var R=N+E*n[1],P=z;P<W;P+=p){var O=e[R+P*n[2]+T];"max"===o&&O>H?H=O:"avg"===o&&(C+=O,B++)}if(isNaN(H))break}k[D+_*y+T]="avg"===o?C/B:H}return v}function Ue(e,a,r,n,i,o){void 0===i&&(i=!1),void 0===o&&(o=!1);for(var s=t.buffer(n.outShape,"int32"),d=n.strideHeight,u=n.strideWidth,p=n.dilationHeight,l=n.dilationWidth,c=n.effectiveFilterHeight,f=n.effectiveFilterWidth,h=n.padInfo.top,m=n.padInfo.left,v=t.buffer(a,r,e),k=0;k<n.batchSize;++k)for(var g=0;g<n.inChannels;++g)for(var I=0;I<n.outHeight;++I){for(var y=I*d-h,b=y;b<0;)b+=p;for(var S=Math.min(n.inHeight,c+y),N=0;N<n.outWidth;++N){for(var T=N*u-m,x=T;x<0;)x+=l;for(var F=Math.min(n.inWidth,f+T),M=Number.NEGATIVE_INFINITY,A=-1,D=b;D<S;D+=p)for(var _=D-y,w=x;w<F;w+=l){var z=w-T,W=v.get(k,D,w,g);W>M&&(M=W,A=i?o?((k*n.inHeight+D)*n.inWidth+w)*n.inChannels+g:(D*n.inWidth+w)*n.inChannels+g:_*f+z)}s.set(A,k,I,N,g)}}return s}var Ke={kernelName:t.AvgPool,backendName:"cpu",kernelFunc:function(e){var a=e.inputs,r=e.backend,n=e.attrs,i=a.x;o(i,"avgPool");var s=n.filterSize,d=n.strides,u=n.pad,p=n.dimRoundingMode;t.util.assert(t.backend_util.eitherStridesOrDilationsAreOne(d,1),(function(){return"Error in avgPool: Either strides or dilations must be 1. Got strides "+d+" and dilations '1'"}));var l,c=t.backend_util.computePool2DInfo(i.shape,s,d,1,u,p);if(1===c.filterWidth&&1===c.filterHeight&&t.util.arraysEqual(c.inShape,c.outShape))l=g({inputs:{x:i},backend:r});else{var f=r.data.get(i.dataId).values,h=t.util.computeStrides(i.shape),m=je(f,i.shape,i.dtype,h,c,"avg");l=r.makeTensorInfo(c.outShape,i.dtype,m.values)}return l}};var Ye={kernelName:t.AvgPoolBackprop,backendName:"cpu",kernelFunc:function(e){var a=e.inputs,r=e.backend,n=e.attrs,i=a.dy,s=a.input,d=s;o([i,s],"avgPoolBackprop");for(var u=n.filterSize,p=n.strides,l=n.pad,c=t.backend_util.computePool2DInfo(d.shape,u,p,1,l),f=c.strideHeight,h=c.strideWidth,m=c.filterHeight,v=c.filterWidth,k=c.dilationHeight,g=c.dilationWidth,I=c.effectiveFilterHeight,y=c.effectiveFilterWidth,b=y-1-c.padInfo.left,S=I-1-c.padInfo.top,N=t.buffer(d.shape,"float32"),T=1/(m*v),x=r.data.get(i.dataId).values,F=t.buffer(i.shape,"float32",x),M=0;M<c.batchSize;++M)for(var A=0;A<c.inChannels;++A)for(var D=0;D<c.inHeight;++D)for(var _=0;_<c.inWidth;++_){for(var w=D-S,z=_-b,W=0,H=0;H<I;H+=k){var C=(w+H)/f;if(!(C<0||C>=c.outHeight||Math.floor(C)!==C))for(var B=0;B<y;B+=g){var E=(z+B)/h;if(!(E<0||E>=c.outWidth||Math.floor(E)!==E))W+=F.get(M,C,E,A)}}N.set(W*T,M,D,_,A)}return r.makeTensorInfo(N.shape,N.dtype,N.values)}};var Ze={kernelName:t.FusedBatchNorm,backendName:"cpu",kernelFunc:function(e){var a=e.inputs,r=e.backend,n=e.attrs,i=a.x,s=a.scale,d=a.offset,u=a.mean,p=a.variance;t.util.assert(u.shape.length===p.shape.length,(function(){return"Batch normalization gradient requires mean and variance to have equal ranks."})),t.util.assert(null==d||u.shape.length===d.shape.length,(function(){return"Batch normalization gradient requires mean and offset to have equal ranks."})),t.util.assert(null==s||u.shape.length===s.shape.length,(function(){return"Batch normalization gradient requires mean and scale to have equal ranks."})),o([i,u,p,s,d],"batchNorm");var l=n.varianceEpsilon;null==l&&(l=.001);for(var c=r.data.get(i.dataId).values,f=r.data.get(u.dataId).values,h=r.data.get(p.dataId).values,m=s?r.data.get(s.dataId).values:new Float32Array([1]),v=d?r.data.get(d.dataId).values:new Float32Array([0]),k=new Float32Array(c.length),g=v.length,I=m.length,y=h.length,b=f.length,S=0,N=0,T=0,x=0,F=0;F<c.length;++F)k[F]=v[S++]+(c[F]-f[N++])*m[T++]/Math.sqrt(h[x++]+l),S>=g&&(S=0),N>=b&&(N=0),T>=I&&(T=0),x>=y&&(x=0);return r.makeTensorInfo(i.shape,i.dtype,k)}},Je=w(t.ClipByValue,(function(e,t){var a=t;return e>a.clipValueMax?a.clipValueMax:e<a.clipValueMin?a.clipValueMin:e})),Qe={kernelName:t.ClipByValue,backendName:"cpu",kernelFunc:Je};function Xe(e){var t=e.inputs,a=e.backend,r=t.input,n=a.data.get(r.dataId).complexTensorInfos.imag,i=a.data.get(n.dataId).values;return a.makeTensorInfo(n.shape,n.dtype,i)}var $e={kernelName:t.Imag,backendName:"cpu",kernelFunc:Xe};function et(e){var a=e.inputs,r=e.backend,n=e.attrs.axis,i=t.util.parseAxisParam(n,a[0].shape)[0],o=t.backend_util.computeOutShape(a.map((function(e){return e.shape})),i);if(0===t.util.sizeFromShape(o))return r.makeTensorInfo(o,a[0].dtype,[]);var s=a.filter((function(e){return t.util.sizeFromShape(e.shape)>0}));if(1===s.length)return s[0];var d=s.map((function(e){return e.shape}));if(t.backend_util.assertParamsConsistent(d,i),"complex64"===s[0].dtype){var u=s.map((function(e){return y({inputs:{input:e},backend:r})})),p=s.map((function(e){return Xe({inputs:{input:e},backend:r})})),l=et({inputs:u,backend:r,attrs:{axis:i}}),c=et({inputs:p,backend:r,attrs:{axis:i}}),f=v({inputs:{real:l,imag:c},backend:r});return u.forEach((function(e){return r.disposeIntermediateTensorInfo(e)})),p.forEach((function(e){return r.disposeIntermediateTensorInfo(e)})),r.disposeIntermediateTensorInfo(l),r.disposeIntermediateTensorInfo(c),f}var h=s.map((function(e){var a=t.util.sizeFromShape(e.shape.slice(i));return Ae({inputs:{x:e},backend:r,attrs:{shape:[-1,a]}})}));o=t.backend_util.computeOutShape(h.map((function(e){return e.shape})),1);var m=t.util.getTypedArrayFromDType(s[0].dtype,t.util.sizeFromShape(o));if(1===h[0].shape[0]){var k=0;h.forEach((function(e){var a=r.data.get(e.dataId).values,n=t.util.sizeFromShape(e.shape);m.set(a,k),k+=n}))}else{var g=0;h.forEach((function(e){for(var t=r.data.get(e.dataId).values,a=0,n=0;n<e.shape[0];++n)for(var i=n*o[1]+g,s=0;s<e.shape[1];++s)m[i+s]=t[a++];g+=e.shape[1]}))}var I=t.backend_util.computeOutShape(s.map((function(e){return e.shape})),i),b=r.makeTensorInfo(I,a[0].dtype,m);return h.forEach((function(e){return r.disposeIntermediateTensorInfo(e)})),b}var tt={kernelName:t.Concat,backendName:"cpu",kernelFunc:et};function at(e){var a=e.inputs,r=e.backend,n=e.attrs,i=a.x,s=a.filter,d=n.strides,u=n.pad,p=n.dataFormat,l=n.dilations,c=n.dimRoundingMode;o([i,s],"conv2d");for(var f=t.backend_util.convertConv2DDataFormat(p),h=t.backend_util.computeConv2DInfo(i.shape,s.shape,d,l,u,c,!1,f),m=h.filterHeight,v=h.filterWidth,k=h.dilationHeight,g=h.dilationWidth,I=h.padInfo.left,y=h.padInfo.top,b="channelsLast"===h.dataFormat,S=new t.TensorBuffer(h.outShape,i.dtype),N=t.util.computeStrides(i.shape),T=t.util.computeStrides(s.shape),x=N[0],F=b?N[1]:N[2],M=b?N[2]:1,A=b?1:N[1],D=S.strides[0],_=b?S.strides[1]:S.strides[2],w=b?S.strides[2]:1,z=b?1:S.strides[1],W=r.data.get(i.dataId).values,H=r.data.get(s.dataId).values,C=S.values,B=0;B<h.batchSize;++B)for(var E=B*x,R=B*D,P=0;P<h.outHeight;++P)for(var O=R+P*_,q=P*h.strideHeight-y,L=0;L<m;++L){var V=q+L*k;if(!(V<0||V>=h.inHeight))for(var G=L*T[0],j=E+V*F,U=0;U<h.outWidth;++U)for(var K=O+U*w,Y=U*h.strideWidth-I,Z=0;Z<v;++Z){var J=Y+Z*g;if(!(J<0||J>=h.inWidth))for(var Q=j+J*M,X=G+Z*T[1],$=0;$<h.inChannels;++$){for(var ee=W[Q+$*A],te=0;te<h.outChannels;++te)C[K+te*z]+=ee*H[X+te];X+=h.outChannels}}}return r.makeTensorInfo(S.shape,S.dtype,C)}var rt={kernelName:t.Conv2D,backendName:"cpu",kernelFunc:at};var nt={kernelName:t.Conv2DBackpropFilter,backendName:"cpu",kernelFunc:function(e){var a=e.inputs,r=e.backend,n=e.attrs,i=a.x,s=a.dy,d=n.strides,u=n.pad,p=n.dataFormat,l=n.dimRoundingMode,c=n.filterShape;o([i,s],"conv2dBackpropFilter");for(var f=t.backend_util.convertConv2DDataFormat(p),h=t.backend_util.computeConv2DInfo(i.shape,c,d,1,u,l,!1,f),m=h.strideHeight,v=h.strideWidth,k=h.filterHeight,g=h.filterWidth,I="channelsLast"===h.dataFormat,y=new t.TensorBuffer(h.filterShape,"float32"),b=h.padInfo.left,S=h.padInfo.top,N=r.data.get(i.dataId).values,T=r.data.get(s.dataId).values,x=new t.TensorBuffer(i.shape,i.dtype,N),F=new t.TensorBuffer(s.shape,s.dtype,T),M=0;M<k;++M)for(var A=Math.max(0,Math.ceil((S-M)/m)),D=Math.min(h.outHeight,(h.inHeight+S-M)/m),_=0;_<g;++_)for(var w=Math.max(0,Math.ceil((b-_)/v)),z=Math.min(h.outWidth,(h.inWidth+b-_)/v),W=0;W<h.inChannels;++W)for(var H=0;H<h.outChannels;++H){for(var C=0,B=0;B<h.batchSize;++B)for(var E=A;E<D;++E)for(var R=M+E*m-S,P=w;P<z;++P){var O=_+P*v-b;C+=I?x.get(B,R,O,W)*F.get(B,E,P,H):x.get(B,W,R,O)*F.get(B,H,E,P)}y.set(C,M,_,W,H)}return r.makeTensorInfo(y.shape,y.dtype,y.values)}};var it={kernelName:t.Conv2DBackpropInput,backendName:"cpu",kernelFunc:function(e){var a=e.inputs,r=e.backend,n=e.attrs,i=a.dy,s=a.filter,d=n.inputShape,u=n.strides,p=n.pad,l=n.dataFormat,c=n.dimRoundingMode;o([i,s],"conv2dBackpropInput");var f=t.util.computeStrides(s.shape),h=t.util.computeStrides(i.shape),m=t.backend_util.convertConv2DDataFormat(l),v=t.backend_util.computeConv2DInfo(d,s.shape,u,1,p,c,!1,m),k=new t.TensorBuffer(v.inShape,"float32"),g=k.values,I=r.data.get(i.dataId).values,y=r.data.get(s.dataId).values,b=f[0],S=f[1],N=f[2],T=v.batchSize,x=v.filterHeight,F=v.filterWidth,M=v.inChannels,A=v.inHeight,D=v.inWidth,_=v.outChannels,w=v.outHeight,z=v.outWidth,W=v.strideHeight,H=v.strideWidth;m=v.dataFormat;for(var C=x-1-v.padInfo.top,B=F-1-v.padInfo.left,E="channelsLast"===m,R=k.strides[0],P=E?k.strides[1]:k.strides[2],O=E?k.strides[2]:1,q=E?1:k.strides[1],L=h[0],V=E?h[1]:h[2],G=E?h[2]:1,j=E?1:h[1],U=0;U<T;++U)for(var K=0;K<M;++K)for(var Y=0;Y<A;++Y)for(var Z=Y-C,J=Math.max(0,Math.ceil(Z/W)),Q=Math.min(w,(x+Z)/W),X=0;X<D;++X){for(var $=X-B,ee=Math.max(0,Math.ceil($/H)),te=Math.min(z,(F+$)/H),ae=0,re=J;re<Q;++re)for(var ne=re*W-Z,ie=ee;ie<te;++ie)for(var oe=L*U+V*re+G*ie,se=b*(x-1-ne)+S*(F-1-(ie*H-$))+N*K,de=0;de<_;++de){ae+=I[oe+j*de]*y[se+de]}g[R*U+P*Y+O*X+q*K]=ae}return r.makeTensorInfo(k.shape,k.dtype,k.values)}};var ot={kernelName:t.Conv3D,backendName:"cpu",kernelFunc:function(e){var a=e.inputs,r=e.backend,n=e.attrs,i=a.x,s=a.filter,d=n.strides,u=n.pad,p=n.dilations;o([i,s],"conv3d");for(var l=t.backend_util.computeConv3DInfo(i.shape,s.shape,d,p,u),c=l.filterDepth,f=l.filterHeight,h=l.filterWidth,m=l.dilationDepth,v=l.dilationHeight,k=l.dilationWidth,g=l.padInfo,I=g.front,y=g.left,b=g.top,S=new t.TensorBuffer(l.outShape,i.dtype),N=r.data.get(i.dataId).values,T=r.data.get(s.dataId).values,x=S.values,F=t.util.computeStrides(i.shape),M=t.util.computeStrides(s.shape),A=0;A<l.batchSize;++A)for(var D=A*F[0],_=A*S.strides[0],w=0;w<l.outDepth;++w)for(var z=_+w*S.strides[1],W=w*l.strideDepth-I,H=0;H<c;++H){var C=W+H*m;if(!(C<0||C>=l.inDepth))for(var B=H*M[0],E=D+C*F[1],R=0;R<l.outHeight;++R)for(var P=z+R*S.strides[2],O=R*l.strideHeight-b,q=0;q<f;++q){var L=O+q*v;if(!(L<0||L>=l.inHeight))for(var V=B+q*M[1],G=E+L*F[2],j=0;j<l.outWidth;++j)for(var U=P+j*l.outChannels,K=j*l.strideWidth-y,Y=0;Y<h;++Y){var Z=K+Y*k;if(!(Z<0||Z>=l.inWidth))for(var J=V+Y*M[2],Q=G+Z*l.inChannels,X=J,$=0;$<l.inChannels;++$){for(var ee=N[Q+$],te=0;te<l.outChannels;++te)x[U+te]+=ee*T[X+te];X+=l.outChannels}}}}return r.makeTensorInfo(S.shape,S.dtype,S.values)}};var st={kernelName:t.Conv3DBackpropFilterV2,backendName:"cpu",kernelFunc:function(e){var a=e.inputs,r=e.backend,n=e.attrs,i=a.x,s=a.dy,d=n.strides,u=n.pad,p=n.filterShape;o([i,s],"conv3dBackpropFilterV2");for(var l=t.util.computeStrides(i.shape),c=t.util.computeStrides(s.shape),f=t.backend_util.computeConv3DInfo(i.shape,p,d,1,u),h=f.strideDepth,m=f.strideHeight,v=f.strideWidth,k=f.filterDepth,g=f.filterHeight,I=f.filterWidth,y=new t.TensorBuffer(f.filterShape,"float32"),b=y.values,S=y.strides,N=S[0],T=S[1],x=S[2],F=S[3],M=r.data.get(s.dataId).values,A=c[0],D=c[1],_=c[2],w=c[3],z=r.data.get(i.dataId).values,W=l[0],H=l[1],C=l[2],B=l[3],E=f.padInfo.front,R=f.padInfo.left,P=f.padInfo.top,O=0;O<k;++O)for(var q=Math.max(0,Math.ceil((E-O)/h)),L=Math.min(f.outDepth,(f.inDepth+E-O)/h),V=O*N,G=0;G<g;++G)for(var j=Math.max(0,Math.ceil((P-G)/m)),U=Math.min(f.outHeight,(f.inHeight+P-G)/m),K=G*T+V,Y=0;Y<I;++Y)for(var Z=Math.max(0,Math.ceil((R-Y)/v)),J=Math.min(f.outWidth,(f.inWidth+R-Y)/v),Q=Y*x+K,X=0;X<f.inChannels;++X)for(var $=X*F+Q,ee=0;ee<f.outChannels;++ee){for(var te=0,ae=0;ae<f.batchSize;++ae)for(var re=ae*W,ne=ae*A,ie=q;ie<L;++ie)for(var oe=(O+ie*h-E)*H+re,se=ie*D+ne,de=j;de<U;++de)for(var ue=(G+de*m-P)*C+oe,pe=de*_+se,le=Z;le<J;++le){var ce=le*w+pe;te+=z[(Y+le*v-R)*B+ue+X]*M[ce+ee]}b[$+ee]=te}return r.makeTensorInfo(y.shape,y.dtype,y.values)}};var dt={kernelName:t.Conv3DBackpropInputV2,backendName:"cpu",kernelFunc:function(e){var a=e.inputs,r=e.backend,n=e.attrs,i=a.dy,s=a.filter,d=n.pad,u=n.strides,p=n.inputShape;o([i],"conv3dBackpropInputV2");for(var l=t.util.computeStrides(i.shape),c=t.util.computeStrides(s.shape),f=t.backend_util.computeConv3DInfo(p,s.shape,u,1,d),h=new t.TensorBuffer(f.inShape,"float32"),m=h.values,v=h.strides,k=v[0],g=v[1],I=v[2],y=v[3],b=r.data.get(i.dataId).values,S=l[0],N=l[1],T=l[2],x=l[3],F=r.data.get(s.dataId).values,M=c[0],A=c[1],D=c[2],_=c[3],w=f.batchSize,z=f.filterDepth,W=f.filterHeight,H=f.filterWidth,C=f.inChannels,B=f.inDepth,E=f.inHeight,R=f.inWidth,P=f.outChannels,O=f.outDepth,q=f.outHeight,L=f.outWidth,V=f.strideDepth,G=f.strideHeight,j=f.strideWidth,U=z-1-f.padInfo.front,K=W-1-f.padInfo.top,Y=H-1-f.padInfo.left,Z=0;Z<w;++Z)for(var J=0;J<C;++J)for(var Q=0;Q<B;++Q)for(var X=Q-U,$=Math.max(0,Math.ceil(X/V)),ee=Math.min(O,(z+X)/V),te=0;te<E;++te)for(var ae=te-K,re=Math.max(0,Math.ceil(ae/G)),ne=Math.min(q,(W+ae)/G),ie=0;ie<R;++ie){for(var oe=ie-Y,se=Math.max(0,Math.ceil(oe/j)),de=Math.min(L,(H+oe)/j),ue=0,pe=$;pe<ee;++pe)for(var le=pe*V-X,ce=re;ce<ne;++ce)for(var fe=ce*G-ae,he=se;he<de;++he)for(var me=S*Z+N*pe+T*ce+x*he,ve=M*(z-1-le)+A*(W-1-fe)+D*(H-1-(he*j-oe))+_*J,ke=0;ke<P;++ke){ue+=b[me+ke]*F[ve+ke]}m[k*Z+g*Q+I*te+y*ie+J]=ue}return r.makeTensorInfo(h.shape,h.dtype,h.values)}},ut=w(t.Cos,(function(e){return Math.cos(e)})),pt={kernelName:t.Cos,backendName:"cpu",kernelFunc:ut},lt=w(t.Cosh,(function(e){return Math.cosh(e)})),ct={kernelName:t.Cosh,backendName:"cpu",kernelFunc:lt};function ft(e){var a=e.inputs,r=e.backend,n=e.attrs,i=a.x,s=a.filter,d=n.strides,u=n.pad,p=n.dilations,l=n.dimRoundingMode;o([i,s],"depthwiseConv2DNative");var c=t.util.computeStrides(i.shape),f=t.util.computeStrides(s.shape),h=p;null==h&&(h=[1,1]),t.util.assert(t.backend_util.eitherStridesOrDilationsAreOne(d,h),(function(){return"Error in depthwiseConv2d: Either strides or dilations must be 1. Got strides "+d+" and dilations '"+h+"'"}));for(var m=t.backend_util.computeConv2DInfo(i.shape,s.shape,d,h,u,l,!0),v=m.filterHeight,k=m.filterWidth,g=m.dilationHeight,I=m.dilationWidth,y=m.padInfo,b=y.left,S=y.top,N=m.outChannels/m.inChannels,T=new t.TensorBuffer(m.outShape,i.dtype),x=r.data.get(i.dataId).values,F=r.data.get(s.dataId).values,M=T.values,A=0;A<m.batchSize;++A)for(var D=A*c[0],_=A*T.strides[0],w=0;w<m.outHeight;++w)for(var z=_+w*T.strides[1],W=w*m.strideHeight-b,H=0;H<v;++H){var C=W+H*g;if(!(C<0||C>=m.inHeight))for(var B=H*f[0],E=D+C*c[1],R=0;R<m.outWidth;++R)for(var P=z+R*T.strides[2],O=R*m.strideWidth-S,q=0;q<k;++q){var L=O+q*I;if(!(L<0||L>=m.inWidth))for(var V=B+q*f[1],G=E+L*m.inChannels,j=P,U=V,K=0;K<m.inChannels;++K){for(var Y=x[G+K],Z=0;Z<N;++Z)M[j+Z]+=Y*F[U+Z];j+=N,U+=N}}}return r.makeTensorInfo(T.shape,T.dtype,T.values)}var ht={kernelName:t.DepthwiseConv2dNative,backendName:"cpu",kernelFunc:ft};var mt={kernelName:t.DepthwiseConv2dNativeBackpropFilter,backendName:"cpu",kernelFunc:function(e){var a=e.inputs,r=e.backend,n=e.attrs,i=a.x,s=a.dy,d=n.strides,u=n.dilations,p=n.pad,l=n.dimRoundingMode,c=n.filterShape;o([i,s],"depthwiseConv2dNativeBackpropFilter");for(var f=t.backend_util.computeConv2DInfo(i.shape,c,d,u,p,l,!0),h=f.strideHeight,m=f.strideWidth,v=f.filterHeight,k=f.filterWidth,g=new t.TensorBuffer(f.filterShape,"float32"),I=f.padInfo.left,y=f.padInfo.top,b=f.outChannels/f.inChannels,S=r.data.get(i.dataId).values,N=new t.TensorBuffer(i.shape,i.dtype,S),T=r.data.get(s.dataId).values,x=new t.TensorBuffer(s.shape,s.dtype,T),F=0;F<v;++F)for(var M=Math.max(0,Math.ceil((y-F)/h)),A=Math.min(f.outHeight,(f.inHeight+y-F)/h),D=0;D<k;++D)for(var _=Math.max(0,Math.ceil((I-D)/m)),w=Math.min(f.outWidth,(f.inWidth+I-D)/m),z=0;z<f.outChannels;++z){for(var W=Math.trunc(z/b),H=z%b,C=0,B=0;B<f.batchSize;++B)for(var E=M;E<A;++E)for(var R=F+E*h-y,P=_;P<w;++P){var O=D+P*m-I;C+=N.get(B,R,O,W)*x.get(B,E,P,z)}g.set(C,F,D,W,H)}return r.makeTensorInfo(g.shape,g.dtype,g.values)}};var vt={kernelName:t.DepthwiseConv2dNativeBackpropInput,backendName:"cpu",kernelFunc:function(e){var a=e.inputs,r=e.backend,n=e.attrs,i=a.dy,s=a.filter,d=n.strides,u=n.dilations,p=n.pad,l=n.dimRoundingMode,c=n.inputShape;o([i,s],"depthwiseConv2DNativeBackpropInput");for(var f=t.util.computeStrides(i.shape),h=t.util.computeStrides(s.shape),m=t.backend_util.computeConv2DInfo(c,s.shape,d,u,p,l,!0),v=new t.TensorBuffer(m.inShape,"float32"),k=v.values,g=v.strides,I=g[0],y=g[1],b=g[2],S=r.data.get(i.dataId).values,N=f[0],T=f[1],x=f[2],F=r.data.get(s.dataId).values,M=h[0],A=h[1],D=h[2],_=m.batchSize,w=m.filterHeight,z=m.filterWidth,W=m.inChannels,H=m.inHeight,C=m.inWidth,B=m.outChannels,E=m.outHeight,R=m.outWidth,P=m.strideHeight,O=m.strideWidth,q=w-1-m.padInfo.top,L=z-1-m.padInfo.left,V=B/W,G=0;G<_;++G)for(var j=0;j<W;++j)for(var U=0;U<H;++U)for(var K=U-q,Y=Math.max(0,Math.ceil(K/P)),Z=Math.min(E,(w+K)/P),J=0;J<C;++J){for(var Q=J-L,X=Math.max(0,Math.ceil(Q/O)),$=Math.min(R,(z+Q)/O),ee=0,te=Y;te<Z;++te)for(var ae=te*P-K,re=X;re<$;++re)for(var ne=N*G+T*te+x*re,ie=M*(w-1-ae)+A*(z-1-(re*O-Q))+D*j,oe=0;oe<V;++oe){ee+=S[ne+(j*V+oe)]*F[ie+oe]}k[I*G+y*U+b*J+j]=ee}return r.makeTensorInfo(v.shape,v.dtype,v.values)}},kt={kernelName:t.Dilation2D,backendName:"cpu",kernelFunc:function(e){for(var a=e.inputs,r=e.backend,n=e.attrs,i=a,o=i.x,s=i.filter,d=n,u=d.strides,p=d.pad,l=d.dilations,c=r,f=c.data.get(o.dataId).values,h=o.shape.length,m=c.data.get(s.dataId).values,v=s.shape.length,k=t.backend_util.computeDilation2DInfo(o.shape,s.shape,u,p,"NHWC",l),g=k.batchSize,I=k.inHeight,y=k.inWidth,b=k.inChannels,S=k.outHeight,N=k.outWidth,T=k.padInfo,x=k.strideHeight,F=k.strideWidth,M=k.filterHeight,A=k.filterWidth,D=k.dilationHeight,_=k.dilationWidth,w=k.outShape,z=t.util.sizeFromShape(w),W=w.length,H=t.util.getArrayFromDType(o.dtype,z),C=0;C<g;++C)for(var B=0;B<S;++B)for(var E=B*x-T.top,R=0;R<N;++R)for(var P=R*F-T.left,O=0;O<b;++O){for(var q=Number.MIN_SAFE_INTEGER,L=0;L<M;++L){var V=E+L*D;if(V>=0&&V<I)for(var G=0;G<A;++G){var j=P+G*_;if(j>=0&&j<y){var U=t.util.locToIndex([C,V,j,O],h,t.util.computeStrides(o.shape)),K=t.util.locToIndex([L,G,O],v,t.util.computeStrides(s.shape)),Y=f[U]+m[K];Y>q&&(q=Y)}}}H[t.util.locToIndex([C,B,R,O],W,t.util.computeStrides(w))]=q}return{dataId:c.write(t.util.toTypedArray(H,o.dtype),w,o.dtype),shape:w,dtype:o.dtype}}},gt={kernelName:t.Dilation2DBackpropFilter,backendName:"cpu",kernelFunc:function(e){var a=e.inputs,r=e.backend,n=e.attrs,i=a,o=i.x,s=i.filter,d=i.dy,u=n,p=u.strides,l=u.pad,c=u.dilations,f=r,h=t.util.toNestedArray(o.shape,f.data.get(o.dataId).values),m=t.util.toNestedArray(s.shape,f.data.get(s.dataId).values),v=t.backend_util.computeDilation2DInfo(o.shape,s.shape,p,l,"NHWC",c),k=v.batchSize,g=v.inHeight,I=v.inWidth,y=v.inChannels,b=v.outHeight,S=v.outWidth,N=v.padInfo,T=v.strideHeight,x=v.strideWidth,F=v.filterHeight,M=v.filterWidth,A=v.dilationHeight,D=v.dilationWidth,_=v.outShape;t.util.assert(d.rank===_.length,(function(){return"Error in "+t.Dilation2DBackpropFilter+", dy must have the same rank as output "+_.length+", but got "+d.rank}));for(var w=t.util.toNestedArray(_,f.data.get(d.dataId).values),z=t.util.makeZerosNestedTypedArray(s.shape,s.dtype),W=0;W<k;++W)for(var H=0;H<b;++H)for(var C=H*T-N.top,B=0;B<S;++B)for(var E=B*x-N.left,R=0;R<y;++R){for(var P=Number.MIN_SAFE_INTEGER,O=0,q=0,L=0;L<F;++L){var V=C+L*A;if(V>=0&&V<g)for(var G=0;G<M;++G){var j=E+G*D;if(j>=0&&j<I){var U=h[W][V][j][R]+m[L][G][R];U>P&&(P=U,O=L,q=G)}}}z[O][q][R]+=w[W][H][B][R]}return{dataId:f.write(t.util.toTypedArray(z,o.dtype),s.shape,s.dtype),shape:s.shape,dtype:s.dtype}}},It={kernelName:t.Dilation2DBackpropInput,backendName:"cpu",kernelFunc:function(e){var a=e.inputs,r=e.backend,n=e.attrs,i=a,o=i.x,s=i.filter,d=i.dy,u=n,p=u.strides,l=u.pad,c=u.dilations,f=r,h=t.util.toNestedArray(o.shape,f.data.get(o.dataId).values),m=t.util.toNestedArray(s.shape,f.data.get(s.dataId).values),v=t.backend_util.computeDilation2DInfo(o.shape,s.shape,p,l,"NHWC",c),k=v.batchSize,g=v.inHeight,I=v.inWidth,y=v.inChannels,b=v.outHeight,S=v.outWidth,N=v.padInfo,T=v.strideHeight,x=v.strideWidth,F=v.filterHeight,M=v.filterWidth,A=v.dilationHeight,D=v.dilationWidth,_=v.outShape;t.util.assert(d.rank===_.length,(function(){return"Error in "+t.Dilation2DBackpropInput+", dy must have the same rank as output "+_.length+", but got "+d.rank}));for(var w=t.util.toNestedArray(_,f.data.get(d.dataId).values),z=t.util.makeZerosNestedTypedArray(o.shape,o.dtype),W=0;W<k;++W)for(var H=0;H<b;++H)for(var C=H*T-N.top,B=0;B<S;++B)for(var E=B*x-N.left,R=0;R<y;++R){for(var P=Number.MIN_SAFE_INTEGER,O=C<0?0:C,q=E<0?0:E,L=0;L<F;++L){var V=C+L*A;if(V>=0&&V<g)for(var G=0;G<M;++G){var j=E+G*D;if(j>=0&&j<I){var U=h[W][V][j][R]+m[L][G][R];U>P&&(P=U,O=V,q=j)}}}z[W][O][q][R]+=w[W][H][B][R]}return{dataId:f.write(t.util.toTypedArray(z,o.dtype),o.shape,o.dtype),shape:o.shape,dtype:o.dtype}}},yt=m((function(e,t){return e/t})),bt=T(t.Div,yt),St={kernelName:t.Div,backendName:"cpu",kernelFunc:bt},Nt=t.backend_util.ERF_P,Tt=t.backend_util.ERF_A1,xt=t.backend_util.ERF_A2,Ft=t.backend_util.ERF_A3,Mt=t.backend_util.ERF_A4,At=t.backend_util.ERF_A5,Dt=w(t.Erf,(function(e){var t=Math.sign(e),a=Math.abs(e),r=1/(1+Nt*a);return t*(1-((((At*r+Mt)*r+Ft)*r+xt)*r+Tt)*r*Math.exp(-a*a))})),_t={kernelName:t.Erf,backendName:"cpu",kernelFunc:Dt};function wt(e,a,r){for(var n=e.shape,i=n[0],o=n[1],s=r.data.get(e.dataId),d=s.complexTensorInfos.real,u=s.complexTensorInfos.imag,p=[i,o],l=t.util.sizeFromShape(p),c=t.util.getTypedArrayFromDType("float32",l),f=t.util.getTypedArrayFromDType("float32",l),h=0;h<i;h++){for(var m=oe({inputs:{x:d},backend:r,attrs:{begin:[h,0],size:[1,o]}}),k=oe({inputs:{x:u},backend:r,attrs:{begin:[h,0],size:[1,o]}}),g=v({inputs:{real:m,imag:k},backend:r}),I=zt(g,a,r),y=I.real,b=I.imag,S=t.backend_util.mergeRealAndImagArrays(y,b),N=0;N<o;N++){var T=t.backend_util.getComplexWithIndex(S,N);c[h*o+N]=T.real,f[h*o+N]=T.imag}r.disposeIntermediateTensorInfo(m),r.disposeIntermediateTensorInfo(k),r.disposeIntermediateTensorInfo(g)}var x=r.makeTensorInfo(p,"float32",c),F=r.makeTensorInfo(p,"float32",f),M=v({inputs:{real:x,imag:F},backend:r});return r.disposeIntermediateTensorInfo(x),r.disposeIntermediateTensorInfo(F),M}function zt(e,a,r){var n=t.util.sizeFromShape(e.shape),i=r.data.get(e.dataId),o=r.data.get(i.complexTensorInfos.real.dataId).values,s=r.data.get(i.complexTensorInfos.imag.dataId).values;if(0==((b=n)&b-1)){var d=function e(a,r,n,i,o){if(1===n)return{real:a,imag:r};var s=t.backend_util.mergeRealAndImagArrays(a,r),d=n/2,u=t.backend_util.complexWithEvenIndex(s),p=u.real,l=u.imag,c=[p.length],f=o.makeTensorInfo(c,"float32",p),h=o.makeTensorInfo(c,"float32",l),m=v({inputs:{real:f,imag:h},backend:o}),k=t.backend_util.complexWithOddIndex(s),g=k.real,I=k.imag,b=[g.length],S=o.makeTensorInfo(b,"float32",g),N=o.makeTensorInfo(b,"float32",I),T=v({inputs:{real:S,imag:N},backend:o}),x=e(p,l,d,i,o),F=x.real,M=x.imag,D=[F.length],_=o.makeTensorInfo(D,"float32",F),w=o.makeTensorInfo(D,"float32",M),z=v({inputs:{real:_,imag:w},backend:o}),W=e(g,I,d,i,o),H=W.real,C=W.imag,B=[H.length],E=o.makeTensorInfo(B,"float32",H),R=o.makeTensorInfo(B,"float32",C),P=v({inputs:{real:E,imag:R},backend:o}),O=t.backend_util.exponents(n,i),q=[O.real.length],L=o.makeTensorInfo(q,"float32",O.real),V=o.makeTensorInfo(q,"float32",O.imag),G=v({inputs:{real:L,imag:V},backend:o}),j=Q({inputs:{a:G,b:P},backend:o}),U=A({inputs:{a:z,b:j},backend:o}),K=fe({inputs:{a:z,b:j},backend:o}),Y=y({inputs:{input:U},backend:o}),Z=y({inputs:{input:K},backend:o}),J=Xe({inputs:{input:U},backend:o}),X=Xe({inputs:{input:K},backend:o}),$=et({inputs:[Y,Z],backend:o,attrs:{axis:0}}),ee=et({inputs:[J,X],backend:o,attrs:{axis:0}}),te=o.data.get($.dataId).values,ae=o.data.get(ee.dataId).values;return o.disposeIntermediateTensorInfo(f),o.disposeIntermediateTensorInfo(h),o.disposeIntermediateTensorInfo(m),o.disposeIntermediateTensorInfo(S),o.disposeIntermediateTensorInfo(N),o.disposeIntermediateTensorInfo(T),o.disposeIntermediateTensorInfo(_),o.disposeIntermediateTensorInfo(w),o.disposeIntermediateTensorInfo(z),o.disposeIntermediateTensorInfo(E),o.disposeIntermediateTensorInfo(R),o.disposeIntermediateTensorInfo(P),o.disposeIntermediateTensorInfo(L),o.disposeIntermediateTensorInfo(V),o.disposeIntermediateTensorInfo(G),o.disposeIntermediateTensorInfo(j),o.disposeIntermediateTensorInfo(U),o.disposeIntermediateTensorInfo(K),o.disposeIntermediateTensorInfo(Y),o.disposeIntermediateTensorInfo(J),o.disposeIntermediateTensorInfo(Z),o.disposeIntermediateTensorInfo(X),o.disposeIntermediateTensorInfo($),o.disposeIntermediateTensorInfo(ee),{real:te,imag:ae}}(o,s,n,a,r),u=[e.shape[0],e.shape[1]];if(a){var p=r.makeTensorInfo(u,"float32",d.real),l=r.makeTensorInfo(u,"float32",d.imag),c=r.makeTensorInfo([],"float32",t.util.createScalarValue(n,"float32")),f=g({inputs:{x:c},backend:r}),h=St.kernelFunc({inputs:{a:p,b:c},backend:r}),m=St.kernelFunc({inputs:{a:l,b:f},backend:r}),k=r.data.get(h.dataId).values,I=r.data.get(m.dataId).values;return r.disposeIntermediateTensorInfo(p),r.disposeIntermediateTensorInfo(l),r.disposeIntermediateTensorInfo(c),r.disposeIntermediateTensorInfo(f),r.disposeIntermediateTensorInfo(h),r.disposeIntermediateTensorInfo(m),{real:k,imag:I}}return d}var b,S=function(e,a,r){for(var n=new Float32Array(2*a),i=0;i<a;i++){for(var o=0,s=0,d=0;d<a;d++){var u=t.backend_util.exponent(i*d,a,r),p=t.backend_util.getComplexWithIndex(e,d);o+=p.real*u.real-p.imag*u.imag,s+=p.real*u.imag+p.imag*u.real}r&&(o/=a,s/=a),t.backend_util.assignToTypedArray(n,o,s,i)}return n}(t.backend_util.mergeRealAndImagArrays(o,s),n,a);return t.backend_util.splitRealAndImagArrays(S)}var Wt={kernelName:t.FFT,backendName:"cpu",kernelFunc:function(e){var a=e.inputs,r=e.backend,n=a.input,i=t.util.sizeFromShape(n.shape),o=n.shape[n.shape.length-1],s=Ae({inputs:{x:n},backend:r,attrs:{shape:[i/o,o]}}),d=wt(s,!1,r),u=Ae({inputs:{x:d},backend:r,attrs:{shape:n.shape}});return r.disposeIntermediateTensorInfo(s),r.disposeIntermediateTensorInfo(d),u}};var Ht={kernelName:t.Fill,backendName:"cpu",kernelFunc:function(e){var a=e.backend,r=e.attrs,n=r.shape,i=r.value,o=r.dtype||t.util.inferDtype(i),s=t.util.getArrayFromDType(o,t.util.sizeFromShape(n));return function(e,t,a){e.fill(t)}(s,i),a.makeTensorInfo(n,o,s)}};var Ct={kernelName:t.FlipLeftRight,backendName:"cpu",kernelFunc:function(e){for(var a=e.inputs,r=(e.attrs,e.backend),n=a.image,i=r,o=t.util.getTypedArrayFromDType(n.dtype,t.util.sizeFromShape(n.shape)),s=n.shape,d=s[0],u=s[1],p=s[2],l=s[3],c=i.data.get(n.dataId).values,f=0;f<d;f++)for(var h=f*p*u*l,m=0;m<u;m++)for(var v=m*(p*l),k=0;k<p;k++)for(var g=k*l,I=0;I<l;I++){var y=[d,m,k,I][2],b=Math.round(p-y),S=h+v+g+I,N=c[S];if(b>=0&&b<p)N=c[h+v+b*l+I];o[S]=N}return{dataId:i.write(o,n.shape,n.dtype),shape:n.shape,dtype:n.dtype}}};var Bt={kernelName:t.FusedConv2D,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,a=e.backend,r=e.attrs,n=t.x,i=t.filter,o=t.bias,s=t.preluActivationWeights,d=r.strides,u=r.pad,p=r.dataFormat,l=r.dilations,c=r.dimRoundingMode,f=r.activation,h=at({inputs:{x:n,filter:i},backend:a,attrs:{strides:d,pad:u,dataFormat:p,dilations:l,dimRoundingMode:c}});if(o){var m=h;h=A({inputs:{a:h,b:o},backend:a}),a.disposeIntermediateTensorInfo(m)}if(f){m=h;h=Me(a,h,f,s),a.disposeIntermediateTensorInfo(m)}return h}};var Et={kernelName:t.FusedDepthwiseConv2D,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,a=e.backend,r=e.attrs,n=t.x,i=t.filter,o=t.bias,s=t.preluActivationWeights,d=r.strides,u=r.pad,p=r.dataFormat,l=r.dilations,c=r.dimRoundingMode,f=r.activation,h=ft({inputs:{x:n,filter:i},backend:a,attrs:{strides:d,pad:u,dataFormat:p,dilations:l,dimRoundingMode:c}});if(o){var m=h;h=A({inputs:{a:h,b:o},backend:a}),a.disposeIntermediateTensorInfo(m)}if(f){m=h;h=Me(a,h,f,s),a.disposeIntermediateTensorInfo(m)}return h}};var Rt={kernelName:t.IFFT,backendName:"cpu",kernelFunc:function(e){var a=e.inputs,r=e.backend,n=a.input,i=t.util.sizeFromShape(n.shape),o=n.shape[n.shape.length-1],s=Ae({inputs:{x:n},backend:r,attrs:{shape:[i/o,o]}}),d=wt(s,!0,r),u=Ae({inputs:{x:d},backend:r,attrs:{shape:n.shape}});return r.disposeIntermediateTensorInfo(s),r.disposeIntermediateTensorInfo(d),u}},Pt=w(t.IsFinite,(function(e){return Number.isFinite(e)?1:0}),"bool"),Ot={kernelName:t.IsFinite,backendName:"cpu",kernelFunc:Pt},qt=w(t.IsInf,(function(e){return Math.abs(e)===1/0?1:0}),"bool"),Lt={kernelName:t.IsInf,backendName:"cpu",kernelFunc:qt},Vt=w(t.IsNan,(function(e){return Number.isNaN(e)?1:0}),"bool"),Gt={kernelName:t.IsNan,backendName:"cpu",kernelFunc:Vt},jt=w(t.Log1p,(function(e){return Math.log1p(e)})),Ut={kernelName:t.Log1p,backendName:"cpu",kernelFunc:jt},Kt=w(t.LogicalNot,(function(e){return e?0:1}),"bool"),Yt={kernelName:t.LogicalNot,backendName:"cpu",kernelFunc:Kt},Zt={kernelName:t.Max,backendName:"cpu",kernelFunc:function(e){var a=e.inputs,r=e.attrs,n=e.backend,i=a.x,s=r,d=s.reductionIndices,u=s.keepDims,p=n,l=i.shape,c=l.length,f=t.util.parseAxisParam(d,l),h=f,m=t.backend_util.getAxesPermutation(h,c),v=p.data.get(i.dataId).values;if(null!=m){for(var k=new Array(c),g=0;g<k.length;g++)k[g]=l[m[g]];v=me(v,l,i.dtype,m,k),h=t.backend_util.getInnerMostAxes(h.length,c),l=k}o(i,"max"),t.backend_util.assertAxesAreInnerMostDims("max",h,c);var I=t.backend_util.computeOutAndReduceShapes(l,h),y=I[0],b=I[1],S=Y(v,t.util.sizeFromShape(b),y,i.dtype),N=p.write(S,y,i.dtype),T=y;u&&(T=k=t.backend_util.expandShapeToKeepDim(y,f));return{dataId:N,shape:T,dtype:i.dtype}}};var Jt={kernelName:t.MaxPool,backendName:"cpu",kernelFunc:function(e){var a=e.inputs,r=e.backend,n=e.attrs,i=a.x;o(i,"maxPool");var s=n.filterSize,d=n.strides,u=n.pad,p=n.dimRoundingMode;t.util.assert(t.backend_util.eitherStridesOrDilationsAreOne(d,1),(function(){return"Error in maxPool: Either strides or dilations must be 1. Got strides "+d+" and dilations '1'"}));var l,c=t.backend_util.computePool2DInfo(i.shape,s,d,1,u,p);if(1===c.filterWidth&&1===c.filterHeight&&t.util.arraysEqual(c.inShape,c.outShape))l=g({inputs:{x:i},backend:r});else{var f=r.data.get(i.dataId).values,h=t.util.computeStrides(i.shape),m=je(f,i.shape,i.dtype,h,c,"max");l=r.makeTensorInfo(c.outShape,i.dtype,m.values)}return l}};var Qt={kernelName:t.MaxPoolBackprop,backendName:"cpu",kernelFunc:function(e){var a=e.inputs,r=e.backend,n=e.attrs,i=a.dy,s=a.input,d=s;o([s,a.output],"maxPoolBackprop");for(var u=n.filterSize,p=n.strides,l=n.pad,c=n.dimRoundingMode,f=t.backend_util.computePool2DInfo(d.shape,u,p,1,l,c),h=r.data.get(d.dataId).values,m=t.buffer(f.outShape,d.dtype,Ue(h,d.shape,d.dtype,f).values),v=f.strideHeight,k=f.strideWidth,g=f.dilationHeight,I=f.dilationWidth,y=f.effectiveFilterHeight,b=f.effectiveFilterWidth,S=b-1-f.padInfo.left,N=y-1-f.padInfo.top,T=t.buffer(d.shape,"float32"),x=r.data.get(i.dataId).values,F=t.buffer(i.shape,"float32",x),M=0;M<f.batchSize;++M)for(var A=0;A<f.inChannels;++A)for(var D=0;D<f.inHeight;++D)for(var _=0;_<f.inWidth;++_){for(var w=D-N,z=_-S,W=0,H=0;H<y;H+=g){var C=(w+H)/v;if(!(C<0||C>=f.outHeight||Math.floor(C)!==C))for(var B=0;B<b;B+=I){var E=(z+B)/k;if(!(E<0||E>=f.outWidth||Math.floor(E)!==E)){var R=y*b-1-m.get(M,C,E,A)===H*b+B?1:0;if(0!==R)W+=F.get(M,C,E,A)*R}}}T.set(W,M,D,_,A)}return r.makeTensorInfo(T.shape,T.dtype,T.values)}};var Xt={kernelName:t.MaxPoolWithArgmax,backendName:"cpu",kernelFunc:function(e){var a=e.inputs,r=e.attrs,n=e.backend,i=a.x,s=r,d=s.filterSize,u=s.strides,p=s.pad,l=s.includeBatchInIndex,c=n;o(i,"MaxPoolWithArgmax");var f=c.data.get(i.dataId).values,h=t.backend_util.computePool2DInfo(i.shape,d,u,[1,1],p),m=function(e,a,r,n,i){var o=je(e,0,r,t.util.computeStrides(a),i,"max"),s=Ue(e,a,r,i,!0,n);return[o.values,s.values]}(f,i.shape,i.dtype,l,h),v=m[0],k=m[1],g=c.write(v,h.outShape,i.dtype),I=c.write(k,h.outShape,i.dtype);return[{dataId:g,shape:h.outShape,dtype:i.dtype},{dataId:I,shape:h.outShape,dtype:"int32"}]}};var $t={kernelName:t.MirrorPad,backendName:"cpu",kernelFunc:function(e){var a=e.inputs,r=e.backend,n=e.attrs,i=a.x,s=n.paddings,d=n.mode;o(i,"mirrorPad");for(var u=s.map((function(e,t){return e[0]+i.shape[t]+e[1]})),p=s.map((function(e){return e[0]})),l=s.map((function(e,t){return e[0]+i.shape[t]})),c="reflect"===d?0:1,f=r.data.get(i.dataId).values,h=i.shape.length,m=t.util.computeStrides(i.shape),v=t.util.sizeFromShape(u),k=u.length,g=t.util.computeStrides(u),I=t.util.getTypedArrayFromDType(i.dtype,v),y=0;y<v;y++){for(var b=t.util.indexToLoc(y,k,g),S=0;S<k;S++)b[S]<p[S]?b[S]=2*p[S]-b[S]-c:b[S]>=l[S]&&(b[S]=2*(l[S]-1)-b[S]+c);b=b.map((function(e,t){return e-p[t]}));var N=t.util.locToIndex(b,h,m);I[y]=f[N]}return{dataId:r.write(I,u,i.dtype),shape:u,dtype:i.dtype}}},ea=t.kernel_impls.nonMaxSuppressionV4Impl,ta={kernelName:t.NonMaxSuppressionV4,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,a=e.backend,r=e.attrs,n=t,i=n.boxes,s=n.scores,d=r,u=d.maxOutputSize,p=d.iouThreshold,l=d.scoreThreshold,c=d.padToMaxOutputSize,f=a;o(i,"NonMaxSuppressionPadded");var h=f.data.get(i.dataId).values,m=f.data.get(s.dataId).values,v=ea(h,m,u,p,l,c);return[v.selectedIndices,v.validOutputs]}},aa=t.kernel_impls.nonMaxSuppressionV5Impl,ra={kernelName:t.NonMaxSuppressionV5,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,a=e.backend,r=e.attrs,n=t,i=n.boxes,s=n.scores,d=r,u=d.maxOutputSize,p=d.iouThreshold,l=d.scoreThreshold,c=d.softNmsSigma,f=a;o(i,"NonMaxSuppressionWithScore");var h=f.data.get(i.dataId).values,m=f.data.get(s.dataId).values,v=aa(h,m,u,p,l,c);return[v.selectedIndices,v.selectedScores]}};var na={kernelName:t.PadV2,backendName:"cpu",kernelFunc:function(e){var a=e.inputs,r=e.backend,n=e.attrs,i=a.x,s=n.paddings,d=n.constantValue;o(i,"pad");var u=s.map((function(e,t){return e[0]+i.shape[t]+e[1]})),p=s.map((function(e){return e[0]})),l=r.data.get(i.dataId).values,c=t.util.sizeFromShape(i.shape),f=i.shape.length,h=t.util.computeStrides(i.shape),m=t.util.sizeFromShape(u),v=u.length,k=t.util.computeStrides(u),g=t.util.getTypedArrayFromDType(i.dtype,m);0!==d&&g.fill(d);for(var I=0;I<c;I++){var y=t.util.indexToLoc(I,f,h).map((function(e,t){return e+p[t]}));g[t.util.locToIndex(y,v,k)]=l[I]}return{dataId:r.write(g,u,i.dtype),shape:u,dtype:i.dtype}}},ia=w(t.Reciprocal,(function(e){return 1/e})),oa={kernelName:t.Reciprocal,backendName:"cpu",kernelFunc:ia},sa={kernelName:t.RotateWithOffset,backendName:"cpu",kernelFunc:function(e){for(var a=e.inputs,r=e.attrs,n=e.backend,i=a.image,o=r,s=o.radians,d=o.fillValue,u=o.center,p=n,l=t.util.getTypedArrayFromDType(i.dtype,t.util.sizeFromShape(i.shape)),c=i.shape,f=c[0],h=c[1],m=c[2],v=c[3],k=t.backend_util.getImageCenter(u,h,m),g=k[0],I=k[1],y=Math.sin(s),b=Math.cos(s),S=p.data.get(i.dataId).values,N=0;N<f;N++)for(var T=N*m*h*v,x=0;x<h;x++)for(var F=x*(m*v),M=0;M<m;M++)for(var A=M*v,D=0;D<v;D++){var _=[f,x,M,D],w=_[2],z=_[1],W=(w-g)*b-(z-I)*y,H=(w-g)*y+(z-I)*b;W=Math.round(W+g),H=Math.round(H+I);var C=d;if("number"!=typeof d&&(C=3===D?255:d[D]),W>=0&&W<m&&H>=0&&H<h)C=S[T+H*(m*v)+W*v+D];l[T+F+A+D]=C}return{dataId:p.write(l,i.shape,i.dtype),shape:i.shape,dtype:i.dtype}}},da=w(t.Round,(function(e){var t=Math.floor(e);return e-t<.5?Math.floor(e):e-t>.5?Math.ceil(e):t%2==0?t:t+1})),ua={kernelName:t.Round,backendName:"cpu",kernelFunc:da},pa=t.backend_util.SELU_SCALEALPHA,la=t.backend_util.SELU_SCALE,ca=w(t.Selu,(function(e){return e>=0?la*e:pa*(Math.exp(e)-1)})),fa={kernelName:t.Selu,backendName:"cpu",kernelFunc:ca},ha=w(t.Sigmoid,(function(e){return 1/(1+Math.exp(-e))})),ma={kernelName:t.Sigmoid,backendName:"cpu",kernelFunc:ha},va=w(t.Sign,(function(e){return e<0?-1:e>0?1:0})),ka={kernelName:t.Sign,backendName:"cpu",kernelFunc:va},ga=w(t.Sin,(function(e){return Math.sin(e)})),Ia={kernelName:t.Sin,backendName:"cpu",kernelFunc:ga},ya=w(t.Sinh,(function(e){return Math.sinh(e)})),ba={kernelName:t.Sinh,backendName:"cpu",kernelFunc:ya},Sa=Math.log(1.1920928955078125e-7)+2,Na=w(t.Softplus,(function(e){var t=e>-Sa,a=e<Sa,r=Math.exp(e);return a?r:t?e:Math.log(1+r)})),Ta={kernelName:t.Softplus,backendName:"cpu",kernelFunc:Na};function xa(e){var t=e.inputs,a=e.attrs,r=e.backend,n=t.x,i=a.perm;o(n,"transpose");for(var s=n.shape.length,d=new Array(s),u=0;u<d.length;u++)d[u]=n.shape[i[u]];var p=me(r.data.get(n.dataId).values,n.shape,n.dtype,i,d);return{dataId:r.write(p,d,n.dtype),shape:d,dtype:n.dtype}}var Fa={kernelName:t.Transpose,backendName:"cpu",kernelFunc:xa};var Ma={kernelName:t.SpaceToBatchND,backendName:"cpu",kernelFunc:function(e){var a=e.inputs,r=e.backend,n=e.attrs,i=a.x,s=n.blockShape,d=n.paddings;o([i],"spaceToBatchND");var u=t.util.sizeFromShape(s),p=[[0,0]];p.push.apply(p,d);for(var l=1+s.length;l<i.shape.length;++l)p.push([0,0]);var c=na.kernelFunc({inputs:{x:i},backend:r,attrs:{paddings:p,constantValue:0}}),f=t.backend_util.getReshaped(c.shape,s,u,!1),h=t.backend_util.getPermuted(f.length,s.length,!1),m=t.backend_util.getReshapedPermuted(c.shape,s,u,!1),v=Ae({inputs:{x:c},backend:r,attrs:{shape:f}}),k=xa({inputs:{x:v},backend:r,attrs:{perm:h}}),g=Ae({inputs:{x:k},backend:r,attrs:{shape:m}});return r.disposeIntermediateTensorInfo(c),r.disposeIntermediateTensorInfo(v),r.disposeIntermediateTensorInfo(k),g}},Aa=w(t.Sqrt,(function(e){return Math.sqrt(e)})),Da={kernelName:t.Sqrt,backendName:"cpu",kernelFunc:Aa},_a={kernelName:t.Square,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,a=e.backend,r=t.x,n=a;o(r,"square");for(var i=n.data.get(r.dataId).values,s=new Float32Array(i.length),d=0;d<i.length;++d){var u=i[d];s[d]=u*u}return{dataId:n.write(s,r.shape,r.dtype),shape:r.shape,dtype:r.dtype}}},wa=w(t.Step,(function(e,t){var a=t;return isNaN(e)?NaN:e>0?1:a.alpha})),za={kernelName:t.Step,backendName:"cpu",kernelFunc:wa},Wa=w(t.Tan,(function(e){return Math.tan(e)})),Ha={kernelName:t.Tan,backendName:"cpu",kernelFunc:Wa},Ca=w(t.Tanh,(function(e){return Math.tanh(e)})),Ba={kernelName:t.Tanh,backendName:"cpu",kernelFunc:Ca};for(var Ea={kernelName:t.Unique,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,a=e.attrs,r=e.backend,n=a.axis,i=t.x;o(i,"unique");var s=ve(r.data.get(i.dataId).values,n,i.shape,i.dtype),d=s.outputValues,u=s.outputShape,p=s.indices;return[r.makeTensorInfo(u,i.dtype,d),r.makeTensorInfo([p.length],"int32",p)]}},Ra=0,Pa=[ze,h,He,Be,D,Re,Oe,Le,Ge,Ke,Ye,we,Ze,N,C,Qe,k,tt,nt,it,rt,st,dt,ot,pt,ct,ht,mt,vt,kt,It,gt,St,Ie,_t,R,q,Wt,Ht,Ct,G,Bt,Et,I,Rt,$e,Ot,Lt,Gt,K,Ut,Yt,Jt,Qt,Xt,Zt,$t,X,ta,ra,te,na,Se,b,oa,Te,Fe,De,sa,ua,ne,fa,ma,ka,Ia,ba,se,Ta,Ma,Da,_a,pe,za,he,Ha,Ba,Fa,Ea];Ra<Pa.length;Ra++){var Oa=Pa[Ra];t.registerKernel(Oa)}e.MathBackendCPU=c,e.shared=ke,e.version_cpu="2.7.0",Object.defineProperty(e,"__esModule",{value:!0})}));
//# sourceMappingURL=tf-backend-cpu.min.js.map
