/**
 * @license
 * Copyright 2020 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports,require("@tensorflow/tfjs-core"),require("seedrandom")):"function"==typeof define&&define.amd?define(["exports","@tensorflow/tfjs-core","seedrandom"],t):t((e=e||self).tf=e.tf||{},e.tf,e.seedrandom)}(this,(function(e,t,n){"use strict";function a(e,n){Array.isArray(e)||(e=[e]),e.forEach(e=>{null!=e&&t.util.assert("complex64"!==e.dtype,()=>`${n} does not support complex64 tensors in the CPU backend.`)})}const s=t.kernel_impls.whereImpl;class o extends t.KernelBackend{constructor(){super(),this.blockSize=48,this.firstUse=!0,this.data=new t.DataStorage(this,t.engine())}write(e,n,a){this.firstUse&&(this.firstUse=!1,t.env().get("IS_NODE")&&t.backend_util.warn("\n============================\nHi there 👋. Looks like you are running TensorFlow.js in Node.js. To speed things up dramatically, install our node backend, which binds to TensorFlow C++, by running npm i @tensorflow/tfjs-node, or npm i @tensorflow/tfjs-node-gpu if you have CUDA. Then call require('@tensorflow/tfjs-node'); (-gpu suffix for CUDA) at the start of your program. Visit https://github.com/tensorflow/tfjs-node for more details.\n============================"));const s={};return this.data.set(s,{values:e,dtype:a,refCount:1}),s}makeTensorInfo(e,n,a){let s;if("string"===n&&null!=a&&a.length>0&&t.util.isString(a[0])){const o=a.map(e=>t.util.encodeString(e));s=this.write(o,e,n)}else s=this.write(a,e,n);return{dataId:s,shape:e,dtype:n}}incRef(e){this.data.get(e).refCount++}decRef(e){if(this.data.has(e)){this.data.get(e).refCount--}}move(e,t,n,a){this.data.set(e,{values:t,dtype:a,refCount:1})}numDataIds(){return this.data.numDataIds()}async read(e){return this.readSync(e)}readSync(e){const{dtype:n,complexTensorInfos:a}=this.data.get(e);if("complex64"===n){const e=this.readSync(a.real.dataId),n=this.readSync(a.imag.dataId);return t.backend_util.mergeRealAndImagArrays(e,n)}return this.data.get(e).values}bufferSync(e){const n=this.readSync(e.dataId);let a=n;if("string"===e.dtype)try{a=n.map(e=>t.util.decodeString(e))}catch(e){throw new Error("Failed to decode encoded string bytes into utf-8")}return t.buffer(e.shape,e.dtype,a)}makeOutput(e,n,a){const s=this.write(e,n,a);return t.engine().makeTensorFromDataId(s,n,a,this)}disposeData(e){if(this.data.has(e)){const{complexTensorInfos:t}=this.data.get(e);null!=t&&(this.disposeData(t.real.dataId),this.disposeData(t.imag.dataId)),this.data.delete(e)}}disposeIntermediateTensorInfo(e){const t=e.dataId;if(this.data.has(t)){const e=this.data.get(t);e.refCount--,e.refCount<1&&this.disposeData(t)}}async time(e){const n=t.util.now();return e(),{kernelMs:t.util.now()-n}}memory(){return{unreliable:!0,reasons:["The reported memory is an upper bound. Due to automatic garbage collection, the true allocated memory may be less."]}}where(e){a([e],"where");const t=this.readSync(e.dataId);return s(e.shape,t)}dispose(){}floatPrecision(){return 32}epsilon(){return super.epsilon()}}function r(e){const t=new Float32Array(e.length);for(let n=0;n<e.length;++n)t[n]=Math.abs(e[n]);return t}const i={kernelName:t.Abs,backendName:"cpu",kernelFunc:e=>{const{x:n}=e.inputs,s=e.backend;a(n,"abs");let o=new Float32Array(t.util.sizeFromShape(n.shape));return o=r(s.data.get(n.dataId).values),s.makeOutput(o,n.shape,"float32")}};function l(e){return(n,a,s,o,r)=>{const i=t.backend_util.assertAndGetBroadcastShape(n,a),l=i.length,d=t.util.computeStrides(i),c=t.util.sizeFromShape(i),u=t.util.getTypedArrayFromDType(r,c),p=n.length,h=a.length,f=t.util.computeStrides(n),m=t.util.computeStrides(a),k=t.backend_util.getBroadcastDims(n,i),b=t.backend_util.getBroadcastDims(a,i);if(k.length+b.length===0)for(let t=0;t<u.length;++t)u[t]=e(s[t%s.length],o[t%o.length]);else for(let n=0;n<u.length;++n){const a=t.util.indexToLoc(n,l,d),r=a.slice(-p);k.forEach(e=>r[e]=0);const i=t.util.locToIndex(r,p,f),c=a.slice(-h);b.forEach(e=>c[e]=0);const I=t.util.locToIndex(c,h,m);u[n]=e(s[i],o[I])}return[u,i]}}function d(e){const{inputs:t,backend:n}=e,{real:a,imag:s}=t,o=n.data.get(a.dataId).values,r=n.data.get(s.dataId).values,i=n.makeTensorInfo(a.shape,"complex64");return n.data.get(i.dataId).complexTensorInfos={real:n.makeTensorInfo(a.shape,"float32",o),imag:n.makeTensorInfo(s.shape,"float32",r)},i}const c={kernelName:t.Complex,backendName:"cpu",kernelFunc:d};function u(e,n,a="float32"){if("complex64"===a){return d({inputs:{real:u(e,n,"float32"),imag:u(e,n,"float32")},backend:e})}const s=t.util.makeZerosTypedArray(t.util.sizeFromShape(n),a);return e.makeTensorInfo(n,a,s)}function p(e){const{inputs:t,backend:n}=e,{x:a}=t;return n.incRef(a.dataId),{dataId:a.dataId,shape:a.shape,dtype:a.dtype}}const h={kernelName:t.Identity,backendName:"cpu",kernelFunc:p};function f(e){const{inputs:t,backend:n}=e,{input:a}=t,s=n.data.get(a.dataId).complexTensorInfos.real,o=n.data.get(s.dataId).values;return n.makeTensorInfo(s.shape,s.dtype,o)}const m={kernelName:t.Real,backendName:"cpu",kernelFunc:f};function k(e){const{inputs:n,backend:a,attrs:s}=e,{x:o}=n,{dtype:r}=s;if("complex64"===r){if("complex64"===o.dtype)return p({inputs:{x:o},backend:a});const e=u(a,o.shape,o.dtype),t=k({inputs:{x:o},backend:a,attrs:{dtype:"float32"}}),n=d({inputs:{real:t,imag:e},backend:a});return a.disposeIntermediateTensorInfo(e),a.disposeIntermediateTensorInfo(t),n}if("complex64"===o.dtype){const e=f({inputs:{input:o},backend:a}),t=k({inputs:{x:e},backend:a,attrs:{dtype:r}});return a.disposeIntermediateTensorInfo(e),t}if(!t.util.hasEncodingLoss(o.dtype,r)){const e=p({inputs:{x:o},backend:a});return{dataId:e.dataId,shape:e.shape,dtype:r}}if("int32"===r){const e=a.data.get(o.dataId).values,t=Int32Array.from(e);return a.makeTensorInfo(o.shape,"int32",t)}if("bool"===r){const e=a.data.get(o.dataId).values,n=t.util.toTypedArray([0],o.dtype),[s,r]=l((e,t)=>e!==t?1:0)(o.shape,[],e,n,"bool");return a.makeTensorInfo(r,"bool",s)}throw new Error(`Error in Cast: failed to cast ${o.dtype} to ${r}`)}const b={kernelName:t.Cast,backendName:"cpu",kernelFunc:k};function I(e,t,n,s){return null==n?({inputs:n,backend:o})=>{const{a:r,b:i}=n,l=o;a([r,i],e);const d=l.data.get(r.dataId).values,c=l.data.get(i.dataId).values,u=s||r.dtype,[p,h]=t(r.shape,i.shape,d,c,u);return l.makeTensorInfo(h,u,p)}:({inputs:e,backend:a})=>{const{a:o,b:r}=e,i=a;if("complex64"===o.dtype||"complex64"===r.dtype){const e=k({inputs:{x:o},backend:i,attrs:{dtype:"complex64"}}),t=i.data.get(e.dataId),a=t.complexTensorInfos.real,s=t.complexTensorInfos.imag,l=i.data.get(a.dataId).values,c=i.data.get(s.dataId).values,u=k({inputs:{x:r},backend:i,attrs:{dtype:"complex64"}}),p=i.data.get(u.dataId),h=p.complexTensorInfos.real,f=p.complexTensorInfos.imag,m=i.data.get(h.dataId).values,b=i.data.get(f.dataId).values,[I,g,y]=n(o.shape,r.shape,l,c,m,b),N=i.makeTensorInfo(y,"float32",I),x=i.makeTensorInfo(y,"float32",g),T=d({inputs:{real:N,imag:x},backend:i});return i.disposeIntermediateTensorInfo(e),i.disposeIntermediateTensorInfo(u),i.disposeIntermediateTensorInfo(N),i.disposeIntermediateTensorInfo(x),T}{const e=i.data.get(o.dataId).values,n=i.data.get(r.dataId).values,a=s||o.dtype,[l,d]=t(o.shape,r.shape,e,n,a);return i.makeTensorInfo(d,a,l)}}}function g(e){return(n,a,s,o,r,i)=>{const l=t.backend_util.assertAndGetBroadcastShape(n,a),d=t.util.sizeFromShape(l),c=l.length,u=t.util.computeStrides(l),p=t.util.getTypedArrayFromDType("float32",d),h=t.util.getTypedArrayFromDType("float32",d),f=t.backend_util.getBroadcastDims(n,l),m=t.backend_util.getBroadcastDims(a,l),k=t.backend_util.mergeRealAndImagArrays(s,o),b=t.backend_util.mergeRealAndImagArrays(r,i),I=n.length,g=t.util.computeStrides(n),y=a.length,N=t.util.computeStrides(a);if(f.length+m.length===0)for(let t=0;t<p.length;t++){const n=t%k.length,a=t%b.length,s=e(k[2*n],k[2*n+1],b[2*a],b[2*a+1]);p[t]=s.real,h[t]=s.imag}else for(let n=0;n<p.length;n++){const a=t.util.indexToLoc(n,c,u),s=a.slice(-I);f.forEach(e=>s[e]=0);const o=t.util.locToIndex(s,I,g),r=a.slice(-y);m.forEach(e=>r[e]=0);const i=t.util.locToIndex(r,y,N),l=e(k[2*o],k[2*o+1],b[2*i],b[2*i+1]);p[n]=l.real,h[n]=l.imag}return[p,h,l]}}const y=l((e,t)=>e+t),N=g((e,t,n,a)=>({real:e+n,imag:t+a})),x=I(t.Add,y,N),T={kernelName:t.Add,backendName:"cpu",kernelFunc:x};function S(e,n,a,s,o){const r=t.util.sizeFromShape(s),i=t.util.makeZerosTypedArray(o,a);for(let t=0;t<e.length;t++){const a=e[t];if(a<0)throw new Error("Input x must be non-negative!");a>=o||(i[a]+=r>0?n[t]:1)}return i}function F(e,n,a,s=!1){const o=e.shape[0],r=e.shape[1],i=t.buffer([o,a],n.dtype);for(let t=0;t<o;t++)for(let o=0;o<r;o++){const r=e.get(t,o);if(r<0)throw new Error("Input x must be non-negative!");r>=a||(s?i.set(1,t,r):n.size>0?i.set(i.get(t,r)+n.get(t,o),t,r):i.set(i.get(t,r)+1,t,r))}return i}function v(e){return(n,a,s)=>{const o=t.util.getTypedArrayFromDType(a,n.length);for(let t=0;t<n.length;++t)o[t]=e(n[t],s);return o}}function M(e,n,s){return({inputs:o,attrs:r,backend:i})=>{const{x:l}=o;if(a(l,e),"string"===l.dtype||"string"===s)throw new Error("unaryKernelFunc does not support string input/output");const d=i,c=d.data.get(l.dataId).values,u=t.util.sizeFromShape(l.shape),p=s||l.dtype,h=t.util.getArrayFromDType(p,u);for(let e=0;e<u;++e)h[e]=n(c[e],r);return d.makeTensorInfo(l.shape,p,h)}}function A(e,t,n){return({inputs:s,attrs:o,backend:r})=>{const{x:i}=s;if(a(i,e),"string"===i.dtype||"string"===n)throw new Error("unaryKernelFunc does not support string input/output");const l=r,d=l.data.get(i.dataId).values,c=n||i.dtype,u=t(d,c,o);return l.makeTensorInfo(i.shape,c,u)}}const D=v(e=>Math.ceil(e)),_=A(t.Ceil,D),z={kernelName:t.Ceil,backendName:"cpu",kernelFunc:_},w=v(e=>Math.exp(e)),W=A(t.Exp,w),C={kernelName:t.Exp,backendName:"cpu",kernelFunc:W},H=v(e=>Math.expm1(e)),E=A(t.Expm1,H),R={kernelName:t.Expm1,backendName:"cpu",kernelFunc:E},P=v(e=>Math.floor(e)),B=A(t.Floor,P),L={kernelName:t.Floor,backendName:"cpu",kernelFunc:B};function V(e,n,a){const s=t.buffer(a,e.dtype);for(let t=0;t<s.size;++t){const a=s.indexToLoc(t).slice(),o=a[0],r=a[2],i=n.locToIndex([o,r]);a[2]=n.values[i];const l=e.locToIndex(a);s.values[t]=e.values[l]}return s}const O=l((e,t)=>e>t?1:0),$=I(t.Greater,O,null,"bool"),G={kernelName:t.Greater,backendName:"cpu",kernelFunc:$},q=l((e,t)=>e<t?1:0),U=I(t.Less,q,null,"bool"),Z={kernelName:t.Less,backendName:"cpu",kernelFunc:U};function j(e,n,a){const s=(n-e)/(a-1),o=t.util.makeZerosTypedArray(a,"float32");o[0]=e;for(let e=1;e<o.length;e++)o[e]=o[e-1]+s;return o}const K=v(e=>Math.log(e)),Y=A(t.Log,K),J={kernelName:t.Log,backendName:"cpu",kernelFunc:Y};function Q(e,n,a,s){const o=t.util.getTypedArrayFromDType(s,t.util.sizeFromShape(a));for(let t=0;t<o.length;++t){const a=t*n;let s=e[a];for(let t=0;t<n;++t){const n=e[a+t];n>s&&(s=n)}o[t]=s}return o}const X=l((e,t)=>Math.max(e,t)),ee=I(t.Maximum,X),te={kernelName:t.Maximum,backendName:"cpu",kernelFunc:ee},ne=l((e,t)=>Math.min(e,t)),ae=I(t.Minimum,ne),se={kernelName:t.Minimum,backendName:"cpu",kernelFunc:ae},oe=l((e,t)=>e*t),re=g((e,t,n,a)=>({real:e*n-t*a,imag:e*a+t*n})),ie=I(t.Multiply,oe,re),le={kernelName:t.Multiply,backendName:"cpu",kernelFunc:ie};function de(e,n,a){const s=t.util.createScalarValue(-1,a);return oe([],n,s,e,a)}const ce={kernelName:t.Neg,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{x:s}=t;a(s,"neg");const o=n.data.get(s.dataId).values,[r,i]=de(o,s.shape,s.dtype);return n.makeTensorInfo(i,s.dtype,r)}},ue=l((e,t)=>e!==t?1:0),pe=I(t.NotEqual,ue,null,"bool"),he={kernelName:t.NotEqual,backendName:"cpu",kernelFunc:pe};function fe(e,n,a,s,o){const r=n.length,i=t.util.sizeFromShape(n),l=t.util.computeStrides(n),d=t.util.computeStrides(o),c=t.util.getTypedArrayFromDType(a,t.util.sizeFromShape(o));for(let n=0;n<i;++n){const a=t.util.indexToLoc(n,r,l),o=new Array(a.length);for(let e=0;e<o.length;e++)o[e]=a[s[e]];c[t.util.locToIndex(o,r,d)]=e[n]}return c}function me(e){const{inputs:t,attrs:n,backend:s}=e,{x:o}=t,{perm:r}=n;a(o,"transpose");const i=o.shape.length,l=new Array(i);for(let e=0;e<l.length;e++)l[e]=o.shape[r[e]];const d=fe(s.data.get(o.dataId).values,o.shape,o.dtype,r,l);return{dataId:s.write(d,l,o.dtype),shape:l,dtype:o.dtype}}const ke={kernelName:t.Transpose,backendName:"cpu",kernelFunc:me};function be(e,n,a,s){const[o,r]=t.backend_util.computeOutAndReduceShapes(e,s),i=t.upcastType(n,"int32"),l=t.util.makeZerosTypedArray(t.util.sizeFromShape(o),i),d=t.util.sizeFromShape(r);for(let e=0;e<l.length;++e){const t=e*d;let n=1;for(let e=0;e<d;++e)n*=a[t+e];l[e]=n}return{outVals:l,outShape:o,outDtype:i}}const Ie={kernelName:t.Prod,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r}=n,{axis:i,keepDims:l}=o;a(r,"prod");const d=r.shape.length,c=t.util.parseAxisParam(i,r.shape),u=t.backend_util.getAxesPermutation(c,d);let p=c,h=r;const f=[];null!=u&&(h=me({inputs:{x:r},backend:s,attrs:{perm:u}}),f.push(h),p=t.backend_util.getInnerMostAxes(p.length,d));const m=s.data.get(h.dataId).values,{outVals:k,outShape:b,outDtype:I}=be(h.shape,h.dtype,m,p);let g=b;return l&&(g=t.backend_util.expandShapeToKeepDim(b,c)),f.forEach(e=>s.disposeIntermediateTensorInfo(e)),s.makeTensorInfo(g,I,k)}};function ge(e,n,a,s){if(e===n||e<n&&a<0||n<e&&a>1)return t.util.makeZerosTypedArray(0,s);const o=Math.abs(Math.ceil((n-e)/a)),r=t.util.makeZerosTypedArray(o,s);n<e&&1===a&&(a=-1),r[0]=e;for(let e=1;e<r.length;e++)r[e]=r[e-1]+a;return r}const ye=v(e=>1/Math.sqrt(e)),Ne=A(t.Rsqrt,ye),xe={kernelName:t.Rsqrt,backendName:"cpu",kernelFunc:Ne};function Te(e,n,a,s,o){const r=t.slice_util.isSliceContinous(s,n,a),i=t.util.sizeFromShape(a),l=t.util.computeStrides(s);if(r){const a=t.slice_util.computeFlatOffset(n,l);return"string"===o?e.slice(a,a+i):e.subarray(a,a+i)}const d="string"===o?t.backend_util.fromUint8ToStringArray(e):e,c=t.buffer(s,o,d),u=t.buffer(a,o);for(let e=0;e<u.size;++e){const t=u.indexToLoc(e),a=t.map((e,t)=>e+n[t]);u.set(c.get(...a),...t)}return"string"===o?t.backend_util.fromStringArrayToUint8(u.values):u.values}function Se(e){const{inputs:n,backend:s,attrs:o}=e,{x:r}=n,{begin:i,size:l}=o;a(r,"slice");const[d,c]=t.slice_util.parseSliceParams(r,i,l);t.slice_util.assertParamsValid(r,d,c);const u=Te(s.data.get(r.dataId).values,d,c,r.shape,r.dtype);return s.makeTensorInfo(c,r.dtype,u)}const Fe={kernelName:t.Slice,backendName:"cpu",kernelFunc:Se},ve=l((e,t)=>{const n=e-t;return n*n}),Me=I(t.SquaredDifference,ve),Ae={kernelName:t.SquaredDifference,backendName:"cpu",kernelFunc:Me};function De(e,n,a,s){const o=t.buffer(e,n.dtype);for(let e=0;e<o.size;e++){const t=o.indexToLoc(e),r=new Array(t.length);for(let e=0;e<r.length;e++)r[e]=t[e]*a[e]+s[e];o.set(n.get(...r),...t)}return o}const _e=l((e,t)=>e-t),ze=g((e,t,n,a)=>({real:e-n,imag:t-a})),we=I(t.Sub,_e,ze),We={kernelName:t.Sub,backendName:"cpu",kernelFunc:we};function Ce(e,n){const a=new Array(e.rank);for(let t=0;t<a.length;t++)a[t]=e.shape[t]*n[t];const s=t.buffer(a,e.dtype);for(let t=0;t<s.values.length;++t){const n=s.indexToLoc(t),a=new Array(e.rank);for(let t=0;t<a.length;t++)a[t]=n[t]%e.shape[t];const o=e.locToIndex(a);s.values[t]=e.values[o]}return s}function He(e,n,a,s,o){const r=n[n.length-1],[i,l]=[e.length/r,r],d=t.util.getTypedArrayFromDType(a,i*s),c=t.util.getTypedArrayFromDType("int32",i*s);for(let t=0;t<i;t++){const n=t*l,a=e.subarray(n,n+l),o=[];for(let e=0;e<a.length;e++)o.push({value:a[e],index:e});o.sort((e,t)=>t.value-e.value);const r=t*s,i=d.subarray(r,r+s),u=c.subarray(r,r+s);for(let e=0;e<s;e++)i[e]=o[e].value,u[e]=o[e].index}const u=n.slice();return u[u.length-1]=s,[t.buffer(u,a,d),t.buffer(u,"int32",c)]}function Ee(e,n,a,s){const o=t.util.parseAxisParam(n,a)[0],r=[1,a[0],1];for(let e=0;e<o;e++)r[0]*=a[e];r[1]=a[o];for(let e=o+1;e<a.length;e++)r[2]*=a[e];const i={},l=new Int32Array(a[o]),d=new t.TensorBuffer(r,s,e),c=[],u=1===r[0]&&1===r[2];for(let t=0;t<a[o];t++){let n;if(u)n=e[t].toString();else{const e=[];for(let n=0;n<r[0];n++)for(let a=0;a<r[2];a++)e.push(d.get(n,t,a));n=e.join(",")}if(void 0!==i[n])l[t]=i[n];else{const e=Object.keys(i).length;i[n]=e,l[t]=e,c.push(t)}}const p=r.slice();p[1]=Object.keys(i).length;const h=new t.TensorBuffer(p,s);c.forEach((e,t)=>{for(let n=0;n<r[0];n++)for(let a=0;a<r[2];a++)h.set(d.get(n,e,a),n,t,a)});const f=a.slice();return f[o]=p[1],{outputValues:h.values,outputShape:f,indices:l}}var Re=Object.freeze({__proto__:null,simpleAbsImpl:r,addImpl:y,bincountImpl:S,bincountReduceImpl:F,ceilImpl:D,expImpl:w,expm1Impl:H,floorImpl:P,gatherV2Impl:V,greaterImpl:O,lessImpl:q,linSpaceImpl:j,logImpl:K,maxImpl:Q,maximumImpl:X,minimumImpl:ne,multiplyImpl:oe,negImpl:de,notEqualImpl:ue,prodImpl:be,rangeImpl:ge,rsqrtImpl:ye,sliceImpl:Te,squaredDifferenceImpl:ve,stridedSliceImpl:De,subImpl:_e,tileImpl:Ce,topKImpl:He,transposeImpl:fe,uniqueImpl:Ee});t.registerBackend("cpu",()=>new o,1);const Pe=M(t.Elu,e=>e>=0?e:Math.exp(e)-1),Be={kernelName:t.Elu,backendName:"cpu",kernelFunc:Pe};function Le(e){const{inputs:n,backend:s,attrs:o}=e,{x:r}=n,{alpha:i}=o;a([r],"leakyRelu");const l=t.util.sizeFromShape(r.shape),d=s.data.get(r.dataId).values,c=t.util.getTypedArrayFromDType("float32",l);for(let e=0;e<d.length;e++)c[e]=d[e]<0?i*d[e]:d[e];return s.makeTensorInfo(r.shape,"float32",c)}const Ve={kernelName:t.LeakyRelu,backendName:"cpu",kernelFunc:Le},Oe=l((e,t)=>e<0?t*e:e);function $e(e){const{inputs:t,backend:n}=e,{x:s,alpha:o}=t;a([s,o],"prelu");const r=n.data.get(s.dataId).values,i=n.data.get(o.dataId).values,[l,d]=Oe(s.shape,o.shape,r,i,s.dtype);return n.makeTensorInfo(d,s.dtype,l)}const Ge={kernelName:t.Prelu,backendName:"cpu",kernelFunc:$e},qe=M(t.Relu,e=>Math.max(0,e)),Ue={kernelName:t.Relu,backendName:"cpu",kernelFunc:qe},Ze=M(t.Relu6,e=>Math.min(Math.max(0,e),6)),je={kernelName:t.Relu6,backendName:"cpu",kernelFunc:Ze};function Ke(e,t,n,a,s){if("linear"===n)return p({inputs:{x:t},backend:e});if("relu"===n)return qe({inputs:{x:t},backend:e});if("elu"===n)return Pe({inputs:{x:t},backend:e});if("relu6"===n)return Ze({inputs:{x:t},backend:e});if("prelu"===n)return $e({inputs:{x:t,alpha:a},backend:e});if("leakyrelu"===n)return Le({inputs:{x:t},backend:e,attrs:{alpha:s}});throw new Error(`Activation ${n} has not been implemented for the CPU backend.`)}function Ye(e){const{inputs:n,backend:a,attrs:s}=e,{x:o}=n,{shape:r}=s,i=t.util.sizeFromShape(o.shape),l=t.util.inferFromImplicitShape(r,i),d=t.util.sizeFromShape(l);t.util.assert(i===d,()=>`The new shape (${l}) has ${d} elements and the old `+`shape (${o.shape}) has ${i} elements. The new shape and old `+"shape must have the same number of elements."),a.incRef(o.dataId);const c=a.data.get(o.dataId);if(null!=c.complexTensorInfos){const e=c.complexTensorInfos.real,t=c.complexTensorInfos.imag;e.shape=l,t.shape=l}return{dataId:o.dataId,shape:l,dtype:o.dtype}}const Je={kernelName:t.Reshape,backendName:"cpu",kernelFunc:Ye};function Qe(e){const{inputs:n,backend:s,attrs:o}=e,{a:r,b:i}=n,{transposeA:l,transposeB:d}=o;a([r,i],"matMul");const c=r.shape.length,u=i.shape.length,p=l?r.shape[c-2]:r.shape[c-1],h=d?i.shape[u-1]:i.shape[u-2],f=l?r.shape[c-1]:r.shape[c-2],m=d?i.shape[u-2]:i.shape[u-1],k=r.shape.slice(0,-2),b=i.shape.slice(0,-2),I=t.util.sizeFromShape(k),g=t.util.sizeFromShape(b),y=I===g||1===I||1===g;t.util.assert(c>=2&&u>=2&&y,()=>"Error in matMul: the input batch dimensions must either be the same or at least one input batch dimension must be 1. Got input "+`batch dimensions of (${k}) and (${b}).`);const N=(I>g?r.shape.slice(0,-2):i.shape.slice(0,-2)).concat([f,m]);t.util.assert(p===h,()=>`Error in matMul: inner shapes (${p}) and (`+`${h}) of Tensors with shapes ${r.shape} and `+`${i.shape} and transposeA=${l}`+` and transposeB=${d} must match.`);const x=d?[g,m,h]:[g,h,m],T=Ye({inputs:{x:r},backend:s,attrs:{shape:l?[I,p,f]:[I,f,p]}}),S=Ye({inputs:{x:i},backend:s,attrs:{shape:x}}),F=l?T.shape[1]:T.shape[2],v=l?T.shape[2]:T.shape[1],M=d?S.shape[1]:S.shape[2],A=Math.max(I,g),D=s.data.get(T.dataId).values,_=s.data.get(S.dataId).values,z=t.util.computeStrides(T.shape),w=t.util.computeStrides(S.shape),[W,C,H]=l?[z[0],1,z[1]]:[z[0],z[1],1],[E,R,P]=d?[1,w[1],w[0]]:[w[1],1,w[0]],B=v*M,L=t.buffer([A,v,M],T.dtype),V=L.values,O=s.blockSize;for(let e=0;e<A;e++)for(let t=0;t<v;t+=O)for(let n=0;n<M;n+=O)for(let a=0;a<F;a+=O){const s=Math.min(t+O,v),o=Math.min(n+O,M),r=Math.min(a+O,F);for(let i=t;i<s;i++)for(let t=n;t<o;t++){let n=0;for(let s=a;s<r;s++){const a=Math.min(e,I-1)*W,o=Math.min(e,g-1)*P;n+=D[a+i*C+s*H]*_[s*E+t*R+o]}V[e*B+(i*M+t)]+=n}}return s.disposeIntermediateTensorInfo(T),s.disposeIntermediateTensorInfo(S),s.makeTensorInfo(N,L.dtype,L.values)}const Xe={kernelName:t.BatchMatMul,backendName:"cpu",kernelFunc:Qe};const et={kernelName:t._FusedMatMul,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{a:s,b:o,bias:r,preluActivationWeights:i}=t,{transposeA:l,transposeB:d,activation:c,leakyreluAlpha:u}=a;let p,h,f;const m=[];p=Qe({inputs:{a:s,b:o},attrs:{transposeA:l,transposeB:d},backend:n}),r&&(h=x({inputs:{a:p,b:r},backend:n}),m.push(p),p=h),c&&(f=Ke(n,p,c,i,u),m.push(p),p=f);for(const e of m)n.disposeIntermediateTensorInfo(e);return p}},tt=M(t.Acos,e=>Math.acos(e)),nt={kernelName:t.Acos,backendName:"cpu",kernelFunc:tt},at=M(t.Acosh,e=>Math.acosh(e)),st={kernelName:t.Acosh,backendName:"cpu",kernelFunc:at};const ot={kernelName:t.AddN,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s}=e,o=n;a(n,"addN");const r=o.map(e=>s.data.get(e.dataId).values),i=t.buffer(o[0].shape,o[0].dtype),l=i.values;for(let e=0;e<o.length;e++){const t=r[e];for(let e=0;e<l.length;e++)l[e]+=t[e]}return s.makeTensorInfo(i.shape,i.dtype,i.values)}};const rt={kernelName:t.All,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r}=n,{axis:i,keepDims:l}=o;a(r,"all");const d=t.util.parseAxisParam(i,r.shape);let c=d;const u=t.backend_util.getAxesPermutation(c,r.shape.length);let p=r;null!=u&&(p=me({inputs:{x:r},backend:s,attrs:{perm:u}}),c=t.backend_util.getInnerMostAxes(c.length,r.shape.length)),t.backend_util.assertAxesAreInnerMostDims("all",c,p.shape.length);const[h,f]=t.backend_util.computeOutAndReduceShapes(p.shape,c),m=t.util.sizeFromShape(f),k=t.util.makeZerosTypedArray(t.util.sizeFromShape(h),p.dtype),b=s.data.get(p.dataId).values;for(let e=0;e<k.length;++e){const t=e*m;let n=b[t];for(let e=0;e<m;++e){const a=b[t+e];n=n&&a}k[e]=n}null!=u&&s.disposeIntermediateTensorInfo(p);const I=s.makeTensorInfo(h,p.dtype,k);if(l){const e=Ye({inputs:{x:I},backend:s,attrs:{shape:t.backend_util.expandShapeToKeepDim(h,d)}});return s.disposeIntermediateTensorInfo(I),e}return I}};const it={kernelName:t.Any,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r}=n,{axis:i,keepDims:l}=o;a(r,"any");const d=t.util.parseAxisParam(i,r.shape);let c=d;const u=t.backend_util.getAxesPermutation(c,r.shape.length);let p=r;null!=u&&(p=me({inputs:{x:r},backend:s,attrs:{perm:u}}),c=t.backend_util.getInnerMostAxes(c.length,r.shape.length)),t.backend_util.assertAxesAreInnerMostDims("any",c,p.shape.length);const[h,f]=t.backend_util.computeOutAndReduceShapes(p.shape,c),m=t.util.sizeFromShape(f),k=t.util.makeZerosTypedArray(t.util.sizeFromShape(h),p.dtype),b=s.data.get(p.dataId).values;for(let e=0;e<k.length;++e){const t=e*m;let n=b[t];for(let e=0;e<m;++e){const a=b[t+e];n=n||a}k[e]=n}null!=u&&s.disposeIntermediateTensorInfo(p);const I=s.makeTensorInfo(h,p.dtype,k);if(l){const e=Ye({inputs:{x:I},backend:s,attrs:{shape:t.backend_util.expandShapeToKeepDim(h,d)}});return s.disposeIntermediateTensorInfo(I),e}return I}};const lt={kernelName:t.ArgMax,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r}=n,{axis:i}=o;a(r,"argMax");let l=t.util.parseAxisParam(i,r.shape);const d=t.backend_util.getAxesPermutation(l,r.shape.length);let c=r;const u=[];null!=d&&(c=me({inputs:{x:r},backend:s,attrs:{perm:d}}),u.push(c),l=t.backend_util.getInnerMostAxes(l.length,c.shape.length)),l=[l[0]],t.backend_util.assertAxesAreInnerMostDims("argMax",l,c.shape.length);const[p,h]=t.backend_util.computeOutAndReduceShapes(c.shape,l),f=t.util.sizeFromShape(p),m=t.util.makeZerosTypedArray(f,"int32"),k=t.util.sizeFromShape(h),b=s.data.get(c.dataId).values;for(let e=0;e<m.length;++e){const t=e*k;let n=b[t],a=0;for(let e=0;e<k;++e){const s=b[t+e];s>n&&(n=s,a=e)}m[e]=a}return u.forEach(e=>s.disposeIntermediateTensorInfo(e)),s.makeTensorInfo(p,"int32",m)}};const dt={kernelName:t.ArgMin,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r}=n,{axis:i}=o;a(r,"argMin");let l=t.util.parseAxisParam(i,r.shape);const d=t.backend_util.getAxesPermutation(l,r.shape.length);let c=r;const u=[];null!=d&&(c=me({inputs:{x:r},backend:s,attrs:{perm:d}}),u.push(c),l=t.backend_util.getInnerMostAxes(l.length,c.shape.length)),l=[l[0]],t.backend_util.assertAxesAreInnerMostDims("argMin",l,c.shape.length);const[p,h]=t.backend_util.computeOutAndReduceShapes(c.shape,l),f=t.util.sizeFromShape(p),m=t.util.makeZerosTypedArray(f,"int32"),k=t.util.sizeFromShape(h),b=s.data.get(c.dataId).values;for(let e=0;e<m.length;++e){const t=e*k;let n=b[t],a=0;for(let e=0;e<k;++e){const s=b[t+e];s<n&&(n=s,a=e)}m[e]=a}return u.forEach(e=>s.disposeIntermediateTensorInfo(e)),s.makeTensorInfo(p,"int32",m)}},ct=M(t.Asin,e=>Math.asin(e)),ut={kernelName:t.Asin,backendName:"cpu",kernelFunc:ct},pt=M(t.Asinh,e=>Math.asinh(e)),ht={kernelName:t.Asinh,backendName:"cpu",kernelFunc:pt},ft=M(t.Atan,e=>Math.atan(e)),mt={kernelName:t.Atan,backendName:"cpu",kernelFunc:ft},kt=l((e,t)=>Math.atan2(e,t)),bt=I(t.Atan2,kt),It={kernelName:t.Atan2,backendName:"cpu",kernelFunc:bt},gt=M(t.Atanh,e=>Math.atanh(e)),yt={kernelName:t.Atanh,backendName:"cpu",kernelFunc:gt};function Nt(e,n,a,s,o,r){const i=o.strideHeight,l=o.strideWidth,d=o.dilationHeight,c=o.dilationWidth,u=o.effectiveFilterHeight,p=o.effectiveFilterWidth,h=o.padInfo.top,f=o.padInfo.left,m="max"===r?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY,k=t.buffer(o.outShape,a),b=k.values,I=o.outShape[1]*o.outShape[2]*o.outShape[3],g=o.outShape[2]*o.outShape[3],y=o.outShape[3];for(let t=0;t<o.batchSize;++t){const n=t*I,a=t*s[0];for(let t=0;t<o.inChannels;++t)for(let k=0;k<o.outHeight;++k){const I=k*i-h,N=Math.max(0,I),x=Math.min(o.inHeight,u+I),T=n+k*g;for(let n=0;n<o.outWidth;++n){const i=n*l-f,u=Math.max(0,i),h=Math.min(o.inWidth,p+i);let k=m,I=0,g=0;for(let n=N;n<x;n+=d){const o=a+n*s[1];for(let n=u;n<h;n+=c){const a=e[o+n*s[2]+t];"max"===r&&a>k?k=a:"avg"===r&&(I+=a,g++)}if(isNaN(k))break}b[T+n*y+t]="avg"===r?I/g:k}}}return k}function xt(e,n,a,s,o=!1,r=!1){const i=t.buffer(s.outShape,"int32"),l=s.strideHeight,d=s.strideWidth,c=s.dilationHeight,u=s.dilationWidth,p=s.effectiveFilterHeight,h=s.effectiveFilterWidth,f=s.padInfo.top,m=s.padInfo.left,k=t.buffer(n,a,e);for(let e=0;e<s.batchSize;++e)for(let t=0;t<s.inChannels;++t)for(let n=0;n<s.outHeight;++n){const a=n*l-f;let b=a;for(;b<0;)b+=c;const I=Math.min(s.inHeight,p+a);for(let l=0;l<s.outWidth;++l){const p=l*d-m;let f=p;for(;f<0;)f+=u;const g=Math.min(s.inWidth,h+p);let y=Number.NEGATIVE_INFINITY,N=-1;for(let n=b;n<I;n+=c){const i=n-a;for(let a=f;a<g;a+=u){const l=a-p,d=k.get(e,n,a,t);d>y&&(y=d,N=o?r?((e*s.inHeight+n)*s.inWidth+a)*s.inChannels+t:(n*s.inWidth+a)*s.inChannels+t:i*h+l)}}i.set(N,e,n,l,t)}}return i}function Tt(e,n,a,s,o,r){const i=o.strideDepth,l=o.strideHeight,d=o.strideWidth,c=o.dilationDepth,u=o.dilationHeight,p=o.dilationWidth,h=o.effectiveFilterDepth,f=o.effectiveFilterHeight,m=o.effectiveFilterWidth,k=o.padInfo.front,b=o.padInfo.top,I=o.padInfo.left,g="max"===r?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY,y=t.buffer(o.outShape,a),N=y.values,x=o.outShape[1]*o.outShape[2]*o.outShape[3]*o.outShape[4],T=o.outShape[2]*o.outShape[3]*o.outShape[4],S=o.outShape[3]*o.outShape[4],F=o.outShape[4];for(let t=0;t<o.batchSize;++t){const n=t*x,a=t*s[0];for(let t=0;t<o.inChannels;++t)for(let y=0;y<o.outDepth;++y){const x=y*i-k;let v=x;for(;v<0;)v+=c;const M=Math.min(o.inDepth,h+x),A=n+y*T;for(let n=0;n<o.outHeight;++n){const i=n*l-b;let h=i;for(;h<0;)h+=u;const k=Math.min(o.inHeight,f+i),y=A+n*S;for(let n=0;n<o.outWidth;++n){const i=n*d-I;let l=i;for(;l<0;)l+=p;const f=Math.min(o.inWidth,m+i),b=y+n*F;let x=g,T=0,S=0;for(let n=v;n<M;n+=c){const o=a+n*s[1];for(let n=h;n<k;n+=u){const a=o+n*s[2];for(let n=l;n<f;n+=p){const o=e[a+n*s[3]+t];if("max"===r&&o>x?x=o:"avg"===r&&(T+=o,S++),isNaN(x))break}if(isNaN(x))break}if(isNaN(x))break}N[b+t]="avg"===r?T/S:x}}}}return y}const St={kernelName:t.AvgPool,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r}=n;a(r,"avgPool");const{filterSize:i,strides:l,pad:d,dimRoundingMode:c}=o;t.util.assert(t.backend_util.eitherStridesOrDilationsAreOne(l,1),()=>"Error in avgPool: Either strides or dilations must be 1. "+`Got strides ${l} and dilations '1'`);const u=t.backend_util.computePool2DInfo(r.shape,i,l,1,d,c);let h;if(1===u.filterWidth&&1===u.filterHeight&&t.util.arraysEqual(u.inShape,u.outShape))h=p({inputs:{x:r},backend:s});else{const e=s.data.get(r.dataId).values,n=t.util.computeStrides(r.shape),a=Nt(e,r.shape,r.dtype,n,u,"avg");h=s.makeTensorInfo(u.outShape,r.dtype,a.values)}return h}};const Ft={kernelName:t.AvgPool3D,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r}=n,{filterSize:i,strides:l,pad:d,dimRoundingMode:c,dataFormat:u,dilations:p}=o;a(r,"avgPool3d");let h=p;null==h&&(h=[1,1,1]);const f=t.backend_util.computePool3DInfo(r.shape,i,l,h,d,c,u),m=Tt(s.data.get(r.dataId).values,r.shape,r.dtype,t.util.computeStrides(r.shape),f,"avg");return s.makeTensorInfo(m.shape,"float32",m.values)}};const vt={kernelName:t.AvgPool3DGrad,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{dy:r,input:i}=n,{filterSize:l,strides:d,pad:c,dilations:u,dimRoundingMode:p}=o;a([r,i],"avgPool3DGrad");const h=t.backend_util.computePool3DInfo(i.shape,l,d,u,c,p),f=h.strideDepth,m=h.strideHeight,k=h.strideWidth,b=h.filterDepth,I=h.filterHeight,g=h.filterWidth,y=h.dilationDepth,N=h.dilationHeight,x=h.dilationWidth,T=h.effectiveFilterDepth,S=h.effectiveFilterHeight,F=h.effectiveFilterWidth,v=T-1-h.padInfo.front,M=F-1-h.padInfo.left,A=S-1-h.padInfo.top,D=t.buffer(i.shape,"float32"),_=1/(b*I*g),z=s.bufferSync(r);for(let e=0;e<h.batchSize;++e)for(let t=0;t<h.inChannels;++t)for(let n=0;n<h.inDepth;++n)for(let a=0;a<h.inHeight;++a)for(let s=0;s<h.inWidth;++s){const o=n-v,r=a-A,i=s-M;let l=0;for(let n=0;n<T;n+=y){const a=(o+n)/f;if(!(a<0||a>=h.outDepth||Math.floor(a)!==a))for(let n=0;n<S;n+=N){const s=(r+n)/m;if(!(s<0||s>=h.outHeight||Math.floor(s)!==s))for(let n=0;n<F;n+=x){const o=(i+n)/k;o<0||o>=h.outWidth||Math.floor(o)!==o||(l+=z.get(e,a,s,o,t))}}}D.set(l*_,e,n,a,s,t)}return s.makeTensorInfo(D.shape,D.dtype,D.values)}};const Mt={kernelName:t.AvgPoolGrad,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{dy:r,input:i}=n,l=i;a([r,i],"avgPoolGrad");const{filterSize:d,strides:c,pad:u}=o,p=t.backend_util.computePool2DInfo(l.shape,d,c,1,u),h=p.strideHeight,f=p.strideWidth,m=p.filterHeight,k=p.filterWidth,b=p.dilationHeight,I=p.dilationWidth,g=p.effectiveFilterHeight,y=p.effectiveFilterWidth,N=y-1-p.padInfo.left,x=g-1-p.padInfo.top,T=t.buffer(l.shape,"float32"),S=1/(m*k),F=s.data.get(r.dataId).values,v=t.buffer(r.shape,"float32",F);for(let e=0;e<p.batchSize;++e)for(let t=0;t<p.inChannels;++t)for(let n=0;n<p.inHeight;++n)for(let a=0;a<p.inWidth;++a){const s=n-x,o=a-N;let r=0;for(let n=0;n<g;n+=b){const a=(s+n)/h;if(!(a<0||a>=p.outHeight||Math.floor(a)!==a))for(let n=0;n<y;n+=I){const s=(o+n)/f;s<0||s>=p.outWidth||Math.floor(s)!==s||(r+=v.get(e,a,s,t))}}T.set(r*S,e,n,a,t)}return s.makeTensorInfo(T.shape,T.dtype,T.values)}};const At={kernelName:t.FusedBatchNorm,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r,scale:i,offset:l,mean:d,variance:c}=n;t.util.assert(d.shape.length===c.shape.length,()=>"Batch normalization gradient requires mean and variance to have equal ranks."),t.util.assert(null==l||d.shape.length===l.shape.length,()=>"Batch normalization gradient requires mean and offset to have equal ranks."),t.util.assert(null==i||d.shape.length===i.shape.length,()=>"Batch normalization gradient requires mean and scale to have equal ranks."),a([r,d,c,i,l],"batchNorm");let{varianceEpsilon:u}=o;null==u&&(u=.001);const p=s.data.get(r.dataId).values,h=s.data.get(d.dataId).values,f=s.data.get(c.dataId).values,m=i?s.data.get(i.dataId).values:new Float32Array([1]),k=l?s.data.get(l.dataId).values:new Float32Array([0]),b=new Float32Array(p.length),I=k.length,g=m.length,y=f.length,N=h.length;let x=0,T=0,S=0,F=0;for(let e=0;e<p.length;++e)b[e]=k[x++]+(p[e]-h[T++])*m[S++]/Math.sqrt(f[F++]+u),x>=I&&(x=0),T>=N&&(T=0),S>=g&&(S=0),F>=y&&(F=0);return s.makeTensorInfo(r.shape,r.dtype,b)}};const Dt={kernelName:t.BatchToSpaceND,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r}=n,{blockShape:i,crops:l}=o;a([r],"batchToSpaceND");const d=i.reduce((e,t)=>e*t),c=t.backend_util.getReshaped(r.shape,i,d),u=t.backend_util.getPermuted(c.length,i.length),p=t.backend_util.getReshapedPermuted(r.shape,i,d),h=t.backend_util.getSliceBeginCoords(l,i.length),f=t.backend_util.getSliceSize(p,l,i.length),m=Ye({inputs:{x:r},backend:s,attrs:{shape:c}}),k=me({inputs:{x:m},backend:s,attrs:{perm:u}}),b=Ye({inputs:{x:k},backend:s,attrs:{shape:p}}),I=Se({inputs:{x:b},backend:s,attrs:{begin:h,size:f}});return s.disposeIntermediateTensorInfo(m),s.disposeIntermediateTensorInfo(k),s.disposeIntermediateTensorInfo(b),I}};const _t={kernelName:t.Bincount,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{x:s,weights:o}=t,{size:r}=a,i=S(n.data.get(s.dataId).values,n.data.get(o.dataId).values,o.dtype,o.shape,r);return n.makeTensorInfo([r],o.dtype,i)}},zt=M(t.ClipByValue,(e,t)=>{const n=t;return e>n.clipValueMax?n.clipValueMax:e<n.clipValueMin?n.clipValueMin:e}),wt={kernelName:t.ClipByValue,backendName:"cpu",kernelFunc:zt},Wt={kernelName:t.ComplexAbs,backendName:"cpu",kernelFunc:e=>{const{x:n}=e.inputs,a=e.backend,s=new Float32Array(t.util.sizeFromShape(n.shape)),o=a.data.get(n.dataId),r=o.complexTensorInfos.real,i=o.complexTensorInfos.imag,l=a.data.get(r.dataId).values,d=a.data.get(i.dataId).values;for(let e=0;e<l.length;e++){const t=l[e],n=d[e];s[e]=Math.hypot(t,n)}return a.makeOutput(s,n.shape,"float32")}};function Ct(e){const{inputs:t,backend:n}=e,{input:a}=t,s=n.data.get(a.dataId).complexTensorInfos.imag,o=n.data.get(s.dataId).values;return n.makeTensorInfo(s.shape,s.dtype,o)}const Ht={kernelName:t.Imag,backendName:"cpu",kernelFunc:Ct};function Et(e){const{inputs:n,backend:a,attrs:s}=e,{axis:o}=s,r=t.util.parseAxisParam(o,n[0].shape)[0];let i=t.backend_util.computeOutShape(n.map(e=>e.shape),r);if(0===t.util.sizeFromShape(i))return a.makeTensorInfo(i,n[0].dtype,[]);const l=n.filter(e=>t.util.sizeFromShape(e.shape)>0);if(1===l.length)return p({inputs:{x:l[0]},backend:a});const c=l.map(e=>e.shape);if(t.backend_util.assertParamsConsistent(c,r),"complex64"===l[0].dtype){const e=l.map(e=>f({inputs:{input:e},backend:a})),t=l.map(e=>Ct({inputs:{input:e},backend:a})),n=Et({inputs:e,backend:a,attrs:{axis:r}}),s=Et({inputs:t,backend:a,attrs:{axis:r}}),o=d({inputs:{real:n,imag:s},backend:a});return e.forEach(e=>a.disposeIntermediateTensorInfo(e)),t.forEach(e=>a.disposeIntermediateTensorInfo(e)),a.disposeIntermediateTensorInfo(n),a.disposeIntermediateTensorInfo(s),o}const u=l.map(e=>{const n=t.util.sizeFromShape(e.shape.slice(r));return Ye({inputs:{x:e},backend:a,attrs:{shape:[-1,n]}})});i=t.backend_util.computeOutShape(u.map(e=>e.shape),1);const h=t.util.getTypedArrayFromDType(l[0].dtype,t.util.sizeFromShape(i));if(1===u[0].shape[0]){let e=0;u.forEach(n=>{const s=a.data.get(n.dataId).values,o=t.util.sizeFromShape(n.shape);h.set(s,e),e+=o})}else{let e=0;u.forEach(t=>{const n=a.data.get(t.dataId).values;let s=0;for(let a=0;a<t.shape[0];++a){const o=a*i[1]+e;for(let e=0;e<t.shape[1];++e)h[o+e]=n[s++]}e+=t.shape[1]})}const m=t.backend_util.computeOutShape(l.map(e=>e.shape),r),k=a.makeTensorInfo(m,n[0].dtype,h);return u.forEach(e=>a.disposeIntermediateTensorInfo(e)),k}const Rt={kernelName:t.Concat,backendName:"cpu",kernelFunc:Et};function Pt(e){const{inputs:n,backend:s,attrs:o}=e,{x:r,filter:i}=n,{strides:l,pad:d,dataFormat:c,dilations:u,dimRoundingMode:p}=o;a([r,i],"conv2d");const h=t.backend_util.convertConv2DDataFormat(c),f=t.backend_util.computeConv2DInfo(r.shape,i.shape,l,u,d,p,!1,h),m=f.filterHeight,k=f.filterWidth,b=f.dilationHeight,I=f.dilationWidth,g=f.padInfo.left,y=f.padInfo.top,N="channelsLast"===f.dataFormat,x=new t.TensorBuffer(f.outShape,r.dtype),T=t.util.computeStrides(r.shape),S=t.util.computeStrides(i.shape),F=T[0],v=N?T[1]:T[2],M=N?T[2]:1,A=N?1:T[1],D=x.strides[0],_=N?x.strides[1]:x.strides[2],z=N?x.strides[2]:1,w=N?1:x.strides[1],W=s.data.get(r.dataId).values,C=s.data.get(i.dataId).values,H=x.values;for(let e=0;e<f.batchSize;++e){const t=e*F,n=e*D;for(let e=0;e<f.outHeight;++e){const a=n+e*_,s=e*f.strideHeight-y;for(let e=0;e<m;++e){const n=s+e*b;if(n<0||n>=f.inHeight)continue;const o=e*S[0],r=t+n*v;for(let e=0;e<f.outWidth;++e){const t=a+e*z,n=e*f.strideWidth-g;for(let e=0;e<k;++e){const a=n+e*I;if(a<0||a>=f.inWidth)continue;const s=r+a*M;let i=o+e*S[1];for(let e=0;e<f.inChannels;++e){const n=W[s+e*A];for(let e=0;e<f.outChannels;++e)H[t+e*w]+=n*C[i+e];i+=f.outChannels}}}}}}return s.makeTensorInfo(x.shape,x.dtype,H)}const Bt={kernelName:t.Conv2D,backendName:"cpu",kernelFunc:Pt};const Lt={kernelName:t.Conv2DBackpropFilter,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r,dy:i}=n,{strides:l,pad:d,dataFormat:c,dimRoundingMode:u,filterShape:p}=o;a([r,i],"conv2dBackpropFilter");const h=t.backend_util.convertConv2DDataFormat(c),f=t.backend_util.computeConv2DInfo(r.shape,p,l,1,d,u,!1,h),{strideHeight:m,strideWidth:k,filterHeight:b,filterWidth:I}=f,g="channelsLast"===f.dataFormat,y=new t.TensorBuffer(f.filterShape,"float32"),N=f.padInfo.left,x=f.padInfo.top,T=s.data.get(r.dataId).values,S=s.data.get(i.dataId).values,F=new t.TensorBuffer(r.shape,r.dtype,T),v=new t.TensorBuffer(i.shape,i.dtype,S);for(let e=0;e<b;++e){const t=Math.max(0,Math.ceil((x-e)/m)),n=Math.min(f.outHeight,(f.inHeight+x-e)/m);for(let a=0;a<I;++a){const s=Math.max(0,Math.ceil((N-a)/k)),o=Math.min(f.outWidth,(f.inWidth+N-a)/k);for(let r=0;r<f.inChannels;++r)for(let i=0;i<f.outChannels;++i){let l=0;for(let d=0;d<f.batchSize;++d)for(let c=t;c<n;++c){const t=e+c*m-x;for(let e=s;e<o;++e){const n=a+e*k-N;l+=g?F.get(d,t,n,r)*v.get(d,c,e,i):F.get(d,r,t,n)*v.get(d,i,c,e)}}y.set(l,e,a,r,i)}}}return s.makeTensorInfo(y.shape,y.dtype,y.values)}};const Vt={kernelName:t.Conv2DBackpropInput,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{dy:r,filter:i}=n,{inputShape:l,strides:d,pad:c,dataFormat:u,dimRoundingMode:p}=o;a([r,i],"conv2dBackpropInput");const h=t.util.computeStrides(i.shape),f=t.util.computeStrides(r.shape);let m=t.backend_util.convertConv2DDataFormat(u);const k=t.backend_util.computeConv2DInfo(l,i.shape,d,1,c,p,!1,m),b=new t.TensorBuffer(k.inShape,"float32"),I=b.values,g=s.data.get(r.dataId).values,y=s.data.get(i.dataId).values,[N,x,T]=h,{batchSize:S,filterHeight:F,filterWidth:v,inChannels:M,inHeight:A,inWidth:D,outChannels:_,outHeight:z,outWidth:w,strideHeight:W,strideWidth:C}=k;m=k.dataFormat;const H=F-1-k.padInfo.top,E=v-1-k.padInfo.left,R="channelsLast"===m,P=b.strides[0],B=R?b.strides[1]:b.strides[2],L=R?b.strides[2]:1,V=R?1:b.strides[1],O=f[0],$=R?f[1]:f[2],G=R?f[2]:1,q=R?1:f[1];for(let e=0;e<S;++e)for(let t=0;t<M;++t)for(let n=0;n<A;++n){const a=n-H,s=Math.max(0,Math.ceil(a/W)),o=Math.min(z,(F+a)/W);for(let r=0;r<D;++r){const i=r-E,l=Math.max(0,Math.ceil(i/C)),d=Math.min(w,(v+i)/C);let c=0;for(let n=s;n<o;++n){const s=n*W-a;for(let a=l;a<d;++a){const o=O*e+$*n+G*a,r=N*(F-1-s)+x*(v-1-(a*C-i))+T*t;for(let e=0;e<_;++e){c+=g[o+q*e]*y[r+e]}}}I[P*e+B*n+L*r+V*t]=c}}return s.makeTensorInfo(b.shape,b.dtype,b.values)}};const Ot={kernelName:t.Conv3D,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r,filter:i}=n,{strides:l,pad:d,dilations:c}=o;a([r,i],"conv3d");const u=t.backend_util.computeConv3DInfo(r.shape,i.shape,l,c,d),{filterDepth:p,filterHeight:h,filterWidth:f,dilationDepth:m,dilationHeight:k,dilationWidth:b,padInfo:I}=u,g=I.front,y=I.left,N=I.top,x=new t.TensorBuffer(u.outShape,r.dtype),T=s.data.get(r.dataId).values,S=s.data.get(i.dataId).values,F=x.values,v=t.util.computeStrides(r.shape),M=t.util.computeStrides(i.shape);for(let e=0;e<u.batchSize;++e){const t=e*v[0],n=e*x.strides[0];for(let e=0;e<u.outDepth;++e){const a=n+e*x.strides[1],s=e*u.strideDepth-g;for(let e=0;e<p;++e){const n=s+e*m;if(n<0||n>=u.inDepth)continue;const o=e*M[0],r=t+n*v[1];for(let e=0;e<u.outHeight;++e){const t=a+e*x.strides[2],n=e*u.strideHeight-N;for(let e=0;e<h;++e){const a=n+e*k;if(a<0||a>=u.inHeight)continue;const s=o+e*M[1],i=r+a*v[2];for(let e=0;e<u.outWidth;++e){const n=t+e*u.outChannels,a=e*u.strideWidth-y;for(let e=0;e<f;++e){const t=a+e*b;if(t<0||t>=u.inWidth)continue;const o=s+e*M[2],r=i+t*u.inChannels;let l=o;for(let e=0;e<u.inChannels;++e){const t=T[r+e];for(let e=0;e<u.outChannels;++e)F[n+e]+=t*S[l+e];l+=u.outChannels}}}}}}}}return s.makeTensorInfo(x.shape,x.dtype,x.values)}};const $t={kernelName:t.Conv3DBackpropFilterV2,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r,dy:i}=n,{strides:l,pad:d,filterShape:c}=o;a([r,i],"conv3dBackpropFilterV2");const u=t.util.computeStrides(r.shape),p=t.util.computeStrides(i.shape),h=t.backend_util.computeConv3DInfo(r.shape,c,l,1,d),f=h.strideDepth,m=h.strideHeight,k=h.strideWidth,b=h.filterDepth,I=h.filterHeight,g=h.filterWidth,y=new t.TensorBuffer(h.filterShape,"float32"),N=y.values,[x,T,S,F]=y.strides,v=s.data.get(i.dataId).values,[M,A,D,_]=p,z=s.data.get(r.dataId).values,[w,W,C,H]=u,E=h.padInfo.front,R=h.padInfo.left,P=h.padInfo.top;for(let e=0;e<b;++e){const t=Math.max(0,Math.ceil((E-e)/f)),n=Math.min(h.outDepth,(h.inDepth+E-e)/f),a=e*x;for(let s=0;s<I;++s){const o=Math.max(0,Math.ceil((P-s)/m)),r=Math.min(h.outHeight,(h.inHeight+P-s)/m),i=s*T+a;for(let a=0;a<g;++a){const l=Math.max(0,Math.ceil((R-a)/k)),d=Math.min(h.outWidth,(h.inWidth+R-a)/k),c=a*S+i;for(let i=0;i<h.inChannels;++i){const u=i*F+c;for(let c=0;c<h.outChannels;++c){let p=0;for(let u=0;u<h.batchSize;++u){const h=u*w,b=u*M;for(let u=t;u<n;++u){const t=(e+u*f-E)*W+h,n=u*A+b;for(let e=o;e<r;++e){const o=(s+e*m-P)*C+t,r=e*D+n;for(let e=l;e<d;++e){const t=e*_+r;p+=z[(a+e*k-R)*H+o+i]*v[t+c]}}}}N[u+c]=p}}}}}return s.makeTensorInfo(y.shape,y.dtype,y.values)}};const Gt={kernelName:t.Conv3DBackpropInputV2,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{dy:r,filter:i}=n,{pad:l,strides:d,inputShape:c}=o;a([r],"conv3dBackpropInputV2");const u=t.util.computeStrides(r.shape),p=t.util.computeStrides(i.shape),h=t.backend_util.computeConv3DInfo(c,i.shape,d,1,l),f=new t.TensorBuffer(h.inShape,"float32"),m=f.values,[k,b,I,g]=f.strides,y=s.data.get(r.dataId).values,[N,x,T,S]=u,F=s.data.get(i.dataId).values,[v,M,A,D]=p,{batchSize:_,filterDepth:z,filterHeight:w,filterWidth:W,inChannels:C,inDepth:H,inHeight:E,inWidth:R,outChannels:P,outDepth:B,outHeight:L,outWidth:V,strideDepth:O,strideHeight:$,strideWidth:G}=h,q=z-1-h.padInfo.front,U=w-1-h.padInfo.top,Z=W-1-h.padInfo.left;for(let e=0;e<_;++e)for(let t=0;t<C;++t)for(let n=0;n<H;++n){const a=n-q,s=Math.max(0,Math.ceil(a/O)),o=Math.min(B,(z+a)/O);for(let r=0;r<E;++r){const i=r-U,l=Math.max(0,Math.ceil(i/$)),d=Math.min(L,(w+i)/$);for(let c=0;c<R;++c){const u=c-Z,p=Math.max(0,Math.ceil(u/G)),h=Math.min(V,(W+u)/G);let f=0;for(let n=s;n<o;++n){const s=n*O-a;for(let a=l;a<d;++a){const o=a*$-i;for(let r=p;r<h;++r){const i=N*e+x*n+T*a+S*r,l=v*(z-1-s)+M*(w-1-o)+A*(W-1-(r*G-u))+D*t;for(let e=0;e<P;++e){f+=y[i+e]*F[l+e]}}}}m[k*e+b*n+I*r+g*c+t]=f}}}return s.makeTensorInfo(f.shape,f.dtype,f.values)}},qt=M(t.Cos,e=>Math.cos(e)),Ut={kernelName:t.Cos,backendName:"cpu",kernelFunc:qt},Zt=M(t.Cosh,e=>Math.cosh(e)),jt={kernelName:t.Cosh,backendName:"cpu",kernelFunc:Zt};const Kt={kernelName:t.CropAndResize,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{image:o,boxes:r,boxInd:i}=n,{cropSize:l,method:d,extrapolationValue:c}=s,[u,p,h,f]=o.shape,m=r.shape[0],[k,b]=l,I=t.buffer([m,k,b,f],"float32"),g=a.data.get(r.dataId).values,y=a.data.get(i.dataId).values,N=a.data.get(o.dataId).values,x=t.util.computeStrides(o.shape),T=t.util.computeStrides(I.shape);for(let e=0;e<m;e++){const t=4*e,n=g[t],a=g[t+1],s=g[t+2],o=g[t+3],r=y[e];if(r>=u)continue;const i=k>1?(s-n)*(p-1)/(k-1):0,l=b>1?(o-a)*(h-1)/(b-1):0;for(let t=0;t<k;t++){const u=k>1?n*(p-1)+t*i:.5*(n+s)*(p-1);if(u<0||u>p-1)for(let n=0;n<b;n++)for(let a=0;a<f;a++){const s=a+n*T[2]+t*T[1]+e*T[0];I.values[s]=c}else if("bilinear"===d){const n=Math.floor(u),s=Math.ceil(u),i=u-n;for(let d=0;d<b;d++){const u=b>1?a*(h-1)+d*l:.5*(a+o)*(h-1);if(u<0||u>h-1){for(let n=0;n<f;n++){const a=n+d*T[2]+t*T[1]+e*T[0];I.values[a]=c}continue}const p=Math.floor(u),m=Math.ceil(u),k=u-p;for(let a=0;a<f;a++){let o=a+p*x[2]+n*x[1]+r*x[0];const l=N[o];o=a+m*x[2]+n*x[1]+r*x[0];const c=N[o];o=a+p*x[2]+s*x[1]+r*x[0];const u=N[o];o=a+m*x[2]+s*x[1]+r*x[0];const h=l+(c-l)*k,f=u+(N[o]-u)*k;o=a+d*T[2]+t*T[1]+e*T[0],I.values[o]=h+(f-h)*i}}}else for(let n=0;n<b;++n){const s=b>1?a*(h-1)+n*l:.5*(a+o)*(h-1);if(s<0||s>h-1){for(let a=0;a<f;a++){const s=a+n*T[2]+t*T[1]+e*T[0];I.values[s]=c}continue}const i=Math.round(s),d=Math.round(u);for(let a=0;a<f;a++){const s=a+i*x[2]+d*x[1]+r*x[0],o=a+n*T[2]+t*T[1]+e*T[0];I.values[o]=N[s]}}}}return a.makeTensorInfo(I.shape,I.dtype,I.values)}};const Yt={kernelName:t.Cumsum,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r}=n,{axis:i,exclusive:l,reverse:d}=o;a(r,"cumsum");const c=t.backend_util.getAxesPermutation([i],r.shape.length);let u=r;null!=c&&(u=me({inputs:{x:r},backend:s,attrs:{perm:c}}));const p=t.backend_util.getInnerMostAxes(1,r.shape.length)[0];if(p!==u.shape.length-1)throw new Error("backend.cumsum in CPU expects an inner-most "+`axis=${u.shape.length-1} but got axis=${p}`);const h=t.upcastType(u.dtype,"int32"),f=t.util.makeZerosTypedArray(t.util.sizeFromShape(u.shape),h),m=s.data.get(u.dataId).values,k=u.shape[u.shape.length-1],b=d?(e,t)=>e+k-t-1:(e,t)=>e+t;for(let e=0;e<m.length;e+=k)for(let t=0;t<k;t++){const n=b(e,t);if(0===t)f[n]=l?0:m[n];else{const a=b(e,t-1);f[n]=l?m[a]+f[a]:m[n]+f[a]}}const I=s.makeTensorInfo(u.shape,h,f);if(null!=c){const e=me({inputs:{x:I},backend:s,attrs:{perm:t.backend_util.getUndoAxesPermutation(c)}});return s.disposeIntermediateTensorInfo(I),s.disposeIntermediateTensorInfo(u),e}return I}};const Jt={kernelName:t.DenseBincount,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{x:s,weights:o}=t,{size:r,binaryOutput:i}=a;if(1===s.shape.length){const e=S(n.data.get(s.dataId).values,n.data.get(o.dataId).values,o.dtype,o.shape,r);return n.makeTensorInfo([r],o.dtype,e)}if(2===s.shape.length){const e=F(n.bufferSync(s),n.bufferSync(o),r,i);return n.makeTensorInfo(e.shape,o.dtype,e.values)}throw new Error("Error in denseBincount: input must be at most rank 2, but got rank"+`${s.shape.length}.`)}};const Qt={kernelName:t.DepthToSpace,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{x:o}=n,{blockSize:r,dataFormat:i}=s;t.util.assert("NHWC"===i,()=>`Only NHWC dataFormat supported on CPU for depthToSpace. Got ${i}`),t.util.assert(r>1,()=>`blockSize should be > 1 for depthToSpace, but was: ${r}`);const l=o.shape[0],d=o.shape[1],c=o.shape[2],u=o.shape[3],p=d*r,h=c*r,f=u/(r*r),m=a.data.get(o.dataId).values,k=new Float32Array(l*p*h*f);let b=0;for(let e=0;e<l;++e)for(let t=0;t<p;++t){const n=Math.floor(t/r),a=t%r;for(let t=0;t<h;++t){const s=Math.floor(t/r),o=(a*r+t%r)*f;for(let t=0;t<f;++t){const a=t+o+u*(s+c*(n+d*e));k[b++]=m[a]}}}return a.makeTensorInfo([l,p,h,f],o.dtype,k)}};function Xt(e){const{inputs:n,backend:s,attrs:o}=e,{x:r,filter:i}=n,{strides:l,pad:d,dilations:c,dimRoundingMode:u}=o;a([r,i],"depthwiseConv2DNative");const p=t.util.computeStrides(r.shape),h=t.util.computeStrides(i.shape);let f=c;null==f&&(f=[1,1]),t.util.assert(t.backend_util.eitherStridesOrDilationsAreOne(l,f),()=>"Error in depthwiseConv2d: Either strides or dilations must be "+`1. Got strides ${l} and dilations '${f}'`);const m=t.backend_util.computeConv2DInfo(r.shape,i.shape,l,f,d,u,!0),{filterHeight:k,filterWidth:b,dilationHeight:I,dilationWidth:g,padInfo:y}=m,N=y.left,x=y.top,T=m.outChannels/m.inChannels,S=new t.TensorBuffer(m.outShape,r.dtype),F=s.data.get(r.dataId).values,v=s.data.get(i.dataId).values,M=S.values;for(let e=0;e<m.batchSize;++e){const t=e*p[0],n=e*S.strides[0];for(let e=0;e<m.outHeight;++e){const a=n+e*S.strides[1],s=e*m.strideHeight-N;for(let e=0;e<k;++e){const n=s+e*I;if(n<0||n>=m.inHeight)continue;const o=e*h[0],r=t+n*p[1];for(let e=0;e<m.outWidth;++e){const t=a+e*S.strides[2],n=e*m.strideWidth-x;for(let e=0;e<b;++e){const a=n+e*g;if(a<0||a>=m.inWidth)continue;const s=o+e*h[1],i=r+a*m.inChannels;let l=t,d=s;for(let e=0;e<m.inChannels;++e){const t=F[i+e];for(let e=0;e<T;++e)M[l+e]+=t*v[d+e];l+=T,d+=T}}}}}}return s.makeTensorInfo(S.shape,S.dtype,S.values)}const en={kernelName:t.DepthwiseConv2dNative,backendName:"cpu",kernelFunc:Xt};const tn={kernelName:t.DepthwiseConv2dNativeBackpropFilter,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r,dy:i}=n,{strides:l,dilations:d,pad:c,dimRoundingMode:u,filterShape:p}=o;a([r,i],"depthwiseConv2dNativeBackpropFilter");const h=t.backend_util.computeConv2DInfo(r.shape,p,l,d,c,u,!0),{strideHeight:f,strideWidth:m,filterHeight:k,filterWidth:b}=h,I=new t.TensorBuffer(h.filterShape,"float32"),g=h.padInfo.left,y=h.padInfo.top,N=h.outChannels/h.inChannels,x=s.data.get(r.dataId).values,T=new t.TensorBuffer(r.shape,r.dtype,x),S=s.data.get(i.dataId).values,F=new t.TensorBuffer(i.shape,i.dtype,S);for(let e=0;e<k;++e){const t=Math.max(0,Math.ceil((y-e)/f)),n=Math.min(h.outHeight,(h.inHeight+y-e)/f);for(let a=0;a<b;++a){const s=Math.max(0,Math.ceil((g-a)/m)),o=Math.min(h.outWidth,(h.inWidth+g-a)/m);for(let r=0;r<h.outChannels;++r){const i=Math.trunc(r/N),l=r%N;let d=0;for(let l=0;l<h.batchSize;++l)for(let c=t;c<n;++c){const t=e+c*f-y;for(let e=s;e<o;++e){const n=a+e*m-g;d+=T.get(l,t,n,i)*F.get(l,c,e,r)}}I.set(d,e,a,i,l)}}}return s.makeTensorInfo(I.shape,I.dtype,I.values)}};const nn={kernelName:t.DepthwiseConv2dNativeBackpropInput,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{dy:r,filter:i}=n,{strides:l,dilations:d,pad:c,dimRoundingMode:u,inputShape:p}=o;a([r,i],"depthwiseConv2DNativeBackpropInput");const h=t.util.computeStrides(r.shape),f=t.util.computeStrides(i.shape),m=t.backend_util.computeConv2DInfo(p,i.shape,l,d,c,u,!0),k=new t.TensorBuffer(m.inShape,"float32"),b=k.values,[I,g,y]=k.strides,N=s.data.get(r.dataId).values,[x,T,S]=h,F=s.data.get(i.dataId).values,[v,M,A]=f,{batchSize:D,filterHeight:_,filterWidth:z,inChannels:w,inHeight:W,inWidth:C,outChannels:H,outHeight:E,outWidth:R,strideHeight:P,strideWidth:B}=m,L=_-1-m.padInfo.top,V=z-1-m.padInfo.left,O=H/w;for(let e=0;e<D;++e)for(let t=0;t<w;++t)for(let n=0;n<W;++n){const a=n-L,s=Math.max(0,Math.ceil(a/P)),o=Math.min(E,(_+a)/P);for(let r=0;r<C;++r){const i=r-V,l=Math.max(0,Math.ceil(i/B)),d=Math.min(R,(z+i)/B);let c=0;for(let n=s;n<o;++n){const s=n*P-a;for(let a=l;a<d;++a){const o=x*e+T*n+S*a,r=v*(_-1-s)+M*(z-1-(a*B-i))+A*t;for(let e=0;e<O;++e){c+=N[o+(t*O+e)]*F[r+e]}}}b[I*e+g*n+y*r+t]=c}}return s.makeTensorInfo(k.shape,k.dtype,k.values)}};const an={kernelName:t.Diag,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a}=e,{x:s}=n,o=t.util.sizeFromShape(s.shape),r=a.data.get(s.dataId).values,i=t.buffer([o,o],s.dtype),l=i.values;for(let e=0;e<r.length;e++)l[e*o+e]=r[e];const d=[...s.shape,...s.shape];return a.makeTensorInfo(d,i.dtype,i.values)}},sn={kernelName:t.Dilation2D,backendName:"cpu",kernelFunc:({inputs:e,backend:n,attrs:a})=>{const{x:s,filter:o}=e,{strides:r,pad:i,dilations:l}=a,d=n,c=d.data.get(s.dataId).values,u=s.shape.length,p=d.data.get(o.dataId).values,h=o.shape.length,{batchSize:f,inHeight:m,inWidth:k,inChannels:b,outHeight:I,outWidth:g,padInfo:y,strideHeight:N,strideWidth:x,filterHeight:T,filterWidth:S,dilationHeight:F,dilationWidth:v,outShape:M}=t.backend_util.computeDilation2DInfo(s.shape,o.shape,r,i,"NHWC",l),A=t.util.sizeFromShape(M),D=M.length,_=t.util.getArrayFromDType(s.dtype,A);for(let e=0;e<f;++e)for(let n=0;n<I;++n){const a=n*N-y.top;for(let r=0;r<g;++r){const i=r*x-y.left;for(let l=0;l<b;++l){let d=Number.MIN_SAFE_INTEGER;for(let n=0;n<T;++n){const r=a+n*F;if(r>=0&&r<m)for(let a=0;a<S;++a){const f=i+a*v;if(f>=0&&f<k){const i=t.util.locToIndex([e,r,f,l],u,t.util.computeStrides(s.shape)),m=t.util.locToIndex([n,a,l],h,t.util.computeStrides(o.shape)),k=c[i]+p[m];k>d&&(d=k)}}}_[t.util.locToIndex([e,n,r,l],D,t.util.computeStrides(M))]=d}}}return{dataId:d.write(t.util.toTypedArray(_,s.dtype),M,s.dtype),shape:M,dtype:s.dtype}}},on={kernelName:t.Dilation2DBackpropFilter,backendName:"cpu",kernelFunc:({inputs:e,backend:n,attrs:a})=>{const{x:s,filter:o,dy:r}=e,{strides:i,pad:l,dilations:d}=a,c=n,u=t.util.toNestedArray(s.shape,c.data.get(s.dataId).values),p=t.util.toNestedArray(o.shape,c.data.get(o.dataId).values),{batchSize:h,inHeight:f,inWidth:m,inChannels:k,outHeight:b,outWidth:I,padInfo:g,strideHeight:y,strideWidth:N,filterHeight:x,filterWidth:T,dilationHeight:S,dilationWidth:F,outShape:v}=t.backend_util.computeDilation2DInfo(s.shape,o.shape,i,l,"NHWC",d);t.util.assert(r.rank===v.length,()=>`Error in ${t.Dilation2DBackpropFilter}, dy `+`must have the same rank as output ${v.length}, but got `+`${r.rank}`);const M=t.util.toNestedArray(v,c.data.get(r.dataId).values),A=t.util.makeZerosNestedTypedArray(o.shape,o.dtype);for(let e=0;e<h;++e)for(let t=0;t<b;++t){const n=t*y-g.top;for(let a=0;a<I;++a){const s=a*N-g.left;for(let o=0;o<k;++o){let r=Number.MIN_SAFE_INTEGER,i=0,l=0;for(let t=0;t<x;++t){const a=n+t*S;if(a>=0&&a<f)for(let n=0;n<T;++n){const d=s+n*F;if(d>=0&&d<m){const s=u[e][a][d][o]+p[t][n][o];s>r&&(r=s,i=t,l=n)}}}A[i][l][o]+=M[e][t][a][o]}}}return{dataId:c.write(t.util.toTypedArray(A,s.dtype),o.shape,o.dtype),shape:o.shape,dtype:o.dtype}}},rn={kernelName:t.Dilation2DBackpropInput,backendName:"cpu",kernelFunc:({inputs:e,backend:n,attrs:a})=>{const{x:s,filter:o,dy:r}=e,{strides:i,pad:l,dilations:d}=a,c=n,u=t.util.toNestedArray(s.shape,c.data.get(s.dataId).values),p=t.util.toNestedArray(o.shape,c.data.get(o.dataId).values),{batchSize:h,inHeight:f,inWidth:m,inChannels:k,outHeight:b,outWidth:I,padInfo:g,strideHeight:y,strideWidth:N,filterHeight:x,filterWidth:T,dilationHeight:S,dilationWidth:F,outShape:v}=t.backend_util.computeDilation2DInfo(s.shape,o.shape,i,l,"NHWC",d);t.util.assert(r.rank===v.length,()=>`Error in ${t.Dilation2DBackpropInput}, dy `+`must have the same rank as output ${v.length}, but got `+`${r.rank}`);const M=t.util.toNestedArray(v,c.data.get(r.dataId).values),A=t.util.makeZerosNestedTypedArray(s.shape,s.dtype);for(let e=0;e<h;++e)for(let t=0;t<b;++t){const n=t*y-g.top;for(let a=0;a<I;++a){const s=a*N-g.left;for(let o=0;o<k;++o){let r=Number.MIN_SAFE_INTEGER,i=n<0?0:n,l=s<0?0:s;for(let t=0;t<x;++t){const a=n+t*S;if(a>=0&&a<f)for(let n=0;n<T;++n){const d=s+n*F;if(d>=0&&d<m){const s=u[e][a][d][o]+p[t][n][o];s>r&&(r=s,i=a,l=d)}}}A[e][i][l][o]+=M[e][t][a][o]}}}return{dataId:c.write(t.util.toTypedArray(A,s.dtype),s.shape,s.dtype),shape:s.shape,dtype:s.dtype}}};const ln={kernelName:t.EluGrad,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s}=e,{dy:o,y:r}=n;a([o,r],"eluGrad");const i=new Float32Array(t.util.sizeFromShape(r.shape)),l=s.data.get(r.dataId).values,d=s.data.get(o.dataId).values;for(let e=0;e<l.length;++e){const t=l[e];i[e]=t>=1?d[e]:d[e]*(t+1)}return s.makeTensorInfo(r.shape,"float32",i)}},dn=l((e,t)=>e===t?1:0),cn=I(t.Equal,dn,null,"bool"),un={kernelName:t.Equal,backendName:"cpu",kernelFunc:cn},pn=t.backend_util.ERF_P,hn=t.backend_util.ERF_A1,fn=t.backend_util.ERF_A2,mn=t.backend_util.ERF_A3,kn=t.backend_util.ERF_A4,bn=t.backend_util.ERF_A5,In=M(t.Erf,e=>{const t=Math.sign(e),n=Math.abs(e),a=1/(1+pn*n);return t*(1-((((bn*a+kn)*a+mn)*a+fn)*a+hn)*a*Math.exp(-n*n))}),gn={kernelName:t.Erf,backendName:"cpu",kernelFunc:In};function yn(e){const{inputs:n,backend:a,attrs:s}=e,{input:o}=n,{dim:r}=s,i=o.shape.length,l=o.shape.slice();let d=r;return r<0&&(t.util.assert(-(i+1)<=r,()=>`Axis must be in the interval [${-(i+1)}, ${i}]`),d=i+r+1),l.splice(d,0,1),Ye({inputs:{x:o},backend:a,attrs:{shape:l}})}const Nn={kernelName:t.ExpandDims,backendName:"cpu",kernelFunc:yn},xn=l((e,t)=>e/t),Tn=I(t.RealDiv,xn),Sn={kernelName:t.RealDiv,backendName:"cpu",kernelFunc:Tn};function Fn(e,n,a){const s=e.shape,o=s[0],r=s[1],i=a.data.get(e.dataId),l=i.complexTensorInfos.real,c=i.complexTensorInfos.imag,u=[o,r],p=t.util.sizeFromShape(u),h=t.util.getTypedArrayFromDType("float32",p),f=t.util.getTypedArrayFromDType("float32",p);for(let e=0;e<o;e++){const s=Se({inputs:{x:l},backend:a,attrs:{begin:[e,0],size:[1,r]}}),o=Se({inputs:{x:c},backend:a,attrs:{begin:[e,0],size:[1,r]}}),i=d({inputs:{real:s,imag:o},backend:a}),{real:u,imag:p}=vn(i,n,a),m=t.backend_util.mergeRealAndImagArrays(u,p);for(let n=0;n<r;n++){const a=t.backend_util.getComplexWithIndex(m,n);h[e*r+n]=a.real,f[e*r+n]=a.imag}a.disposeIntermediateTensorInfo(s),a.disposeIntermediateTensorInfo(o),a.disposeIntermediateTensorInfo(i)}const m=a.makeTensorInfo(u,"float32",h),k=a.makeTensorInfo(u,"float32",f),b=d({inputs:{real:m,imag:k},backend:a});return a.disposeIntermediateTensorInfo(m),a.disposeIntermediateTensorInfo(k),b}function vn(e,n,a){const s=t.util.sizeFromShape(e.shape),o=a.data.get(e.dataId),r=a.data.get(o.complexTensorInfos.real.dataId).values,i=a.data.get(o.complexTensorInfos.imag.dataId).values;if(0==((l=s)&l-1)){const o=function e(n,a,s,o,r){if(1===s)return{real:n,imag:a};const i=t.backend_util.mergeRealAndImagArrays(n,a),l=s/2,c=t.backend_util.complexWithEvenIndex(i),u=c.real,p=c.imag,h=[u.length],m=r.makeTensorInfo(h,"float32",u),k=r.makeTensorInfo(h,"float32",p),b=d({inputs:{real:m,imag:k},backend:r}),I=t.backend_util.complexWithOddIndex(i),g=I.real,y=I.imag,N=[g.length],T=r.makeTensorInfo(N,"float32",g),S=r.makeTensorInfo(N,"float32",y),F=d({inputs:{real:T,imag:S},backend:r}),v=e(u,p,l,o,r),M=v.real,A=v.imag,D=[M.length],_=r.makeTensorInfo(D,"float32",M),z=r.makeTensorInfo(D,"float32",A),w=d({inputs:{real:_,imag:z},backend:r}),W=e(g,y,l,o,r),C=W.real,H=W.imag,E=[C.length],R=r.makeTensorInfo(E,"float32",C),P=r.makeTensorInfo(E,"float32",H),B=d({inputs:{real:R,imag:P},backend:r}),L=t.backend_util.exponents(s,o),V=[L.real.length],O=r.makeTensorInfo(V,"float32",L.real),$=r.makeTensorInfo(V,"float32",L.imag),G=d({inputs:{real:O,imag:$},backend:r}),q=ie({inputs:{a:G,b:B},backend:r}),U=x({inputs:{a:w,b:q},backend:r}),Z=we({inputs:{a:w,b:q},backend:r}),j=f({inputs:{input:U},backend:r}),K=f({inputs:{input:Z},backend:r}),Y=Ct({inputs:{input:U},backend:r}),J=Ct({inputs:{input:Z},backend:r}),Q=Et({inputs:[j,K],backend:r,attrs:{axis:0}}),X=Et({inputs:[Y,J],backend:r,attrs:{axis:0}}),ee=r.data.get(Q.dataId).values,te=r.data.get(X.dataId).values;return r.disposeIntermediateTensorInfo(m),r.disposeIntermediateTensorInfo(k),r.disposeIntermediateTensorInfo(b),r.disposeIntermediateTensorInfo(T),r.disposeIntermediateTensorInfo(S),r.disposeIntermediateTensorInfo(F),r.disposeIntermediateTensorInfo(_),r.disposeIntermediateTensorInfo(z),r.disposeIntermediateTensorInfo(w),r.disposeIntermediateTensorInfo(R),r.disposeIntermediateTensorInfo(P),r.disposeIntermediateTensorInfo(B),r.disposeIntermediateTensorInfo(O),r.disposeIntermediateTensorInfo($),r.disposeIntermediateTensorInfo(G),r.disposeIntermediateTensorInfo(q),r.disposeIntermediateTensorInfo(U),r.disposeIntermediateTensorInfo(Z),r.disposeIntermediateTensorInfo(j),r.disposeIntermediateTensorInfo(Y),r.disposeIntermediateTensorInfo(K),r.disposeIntermediateTensorInfo(J),r.disposeIntermediateTensorInfo(Q),r.disposeIntermediateTensorInfo(X),{real:ee,imag:te}}(r,i,s,n,a),l=[e.shape[0],e.shape[1]];if(n){const e=a.makeTensorInfo(l,"float32",o.real),n=a.makeTensorInfo(l,"float32",o.imag),r=a.makeTensorInfo([],"float32",t.util.createScalarValue(s,"float32")),i=p({inputs:{x:r},backend:a}),d=Sn.kernelFunc({inputs:{a:e,b:r},backend:a}),c=Sn.kernelFunc({inputs:{a:n,b:i},backend:a}),u=a.data.get(d.dataId).values,h=a.data.get(c.dataId).values;return a.disposeIntermediateTensorInfo(e),a.disposeIntermediateTensorInfo(n),a.disposeIntermediateTensorInfo(r),a.disposeIntermediateTensorInfo(i),a.disposeIntermediateTensorInfo(d),a.disposeIntermediateTensorInfo(c),{real:u,imag:h}}return o}{const e=function(e,n,a){const s=new Float32Array(2*n);for(let o=0;o<n;o++){let r=0,i=0;for(let s=0;s<n;s++){const l=t.backend_util.exponent(o*s,n,a),d=t.backend_util.getComplexWithIndex(e,s);r+=d.real*l.real-d.imag*l.imag,i+=d.real*l.imag+d.imag*l.real}a&&(r/=n,i/=n),t.backend_util.assignToTypedArray(s,r,i,o)}return s}(t.backend_util.mergeRealAndImagArrays(r,i),s,n);return t.backend_util.splitRealAndImagArrays(e)}var l}const Mn={kernelName:t.FFT,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a}=e,{input:s}=n,o=t.util.sizeFromShape(s.shape),r=s.shape[s.shape.length-1],i=Ye({inputs:{x:s},backend:a,attrs:{shape:[o/r,r]}}),l=Fn(i,!1,a),d=Ye({inputs:{x:l},backend:a,attrs:{shape:s.shape}});return a.disposeIntermediateTensorInfo(i),a.disposeIntermediateTensorInfo(l),d}};function An(e){const{backend:n,attrs:a}=e,{shape:s,value:o,dtype:r}=a,i=r||t.util.inferDtype(o),l=t.util.getArrayFromDType(i,t.util.sizeFromShape(s));return function(e,t,n){e.fill(t)}(l,o),n.makeTensorInfo(s,i,l)}const Dn={kernelName:t.Fill,backendName:"cpu",kernelFunc:An};const _n={kernelName:t.FlipLeftRight,backendName:"cpu",kernelFunc:({inputs:e,attrs:n,backend:a})=>{const{image:s}=e,o=a,r=t.util.getTypedArrayFromDType(s.dtype,t.util.sizeFromShape(s.shape)),[i,l,d,c]=s.shape,u=o.data.get(s.dataId).values;for(let e=0;e<i;e++){const t=e*d*l*c;for(let e=0;e<l;e++){const n=e*(d*c);for(let a=0;a<d;a++){const s=a*c;for(let o=0;o<c;o++){const l=[i,e,a,o][2],p=Math.round(d-l),h=t+n+s+o;let f=u[h];if(p>=0&&p<d){f=u[t+n+p*c+o]}r[h]=f}}}}return{dataId:o.write(r,s.shape,s.dtype),shape:s.shape,dtype:s.dtype}}},zn=l((e,t)=>Math.floor(e/t)),wn=I(t.FloorDiv,zn,null,"int32"),Wn={kernelName:t.FloorDiv,backendName:"cpu",kernelFunc:wn};const Cn={kernelName:t.FusedConv2D,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{x:s,filter:o,bias:r,preluActivationWeights:i}=t,{strides:l,pad:d,dataFormat:c,dilations:u,dimRoundingMode:p,activation:h,leakyreluAlpha:f}=a;let m=Pt({inputs:{x:s,filter:o},backend:n,attrs:{strides:l,pad:d,dataFormat:c,dilations:u,dimRoundingMode:p}});if(r){const e=m;m=x({inputs:{a:m,b:r},backend:n}),n.disposeIntermediateTensorInfo(e)}if(h){const e=m;m=Ke(n,m,h,i,f),n.disposeIntermediateTensorInfo(e)}return m}};const Hn={kernelName:t.FusedDepthwiseConv2D,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{x:s,filter:o,bias:r,preluActivationWeights:i}=t,{strides:l,pad:d,dataFormat:c,dilations:u,dimRoundingMode:p,activation:h,leakyreluAlpha:f}=a;let m=Xt({inputs:{x:s,filter:o},backend:n,attrs:{strides:l,pad:d,dataFormat:c,dilations:u,dimRoundingMode:p}});if(r){const e=m;m=x({inputs:{a:m,b:r},backend:n}),n.disposeIntermediateTensorInfo(e)}if(h){const e=m;m=Ke(n,m,h,i,f),n.disposeIntermediateTensorInfo(e)}return m}};const En={kernelName:t.GatherNd,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a}=e,{params:s,indices:o}=n,r=t.util.sizeFromShape(s.shape),i=o.shape,l=i[i.length-1],[d,c,u,p]=t.backend_util.prepareAndValidate(s,o);if(0===c)return a.makeTensorInfo(d,s.dtype,[]);const h=t.buffer([c,u],s.dtype),f=a.data.get(o.dataId).values,m=a.data.get(s.dataId).values;for(let e=0;e<c;e++){const t=[];let n=0;for(let a=0;a<l;a++){const s=f[e*l+a];n+=s*p[a],t.push(s)}if(n<0||n>=r/u)throw new Error(`Invalid indices: ${t} does not index into ${s.shape}`);for(let t=0;t<u;t++)h.values[e*u+t]=m[n*u+t]}return a.makeTensorInfo(d,h.dtype,h.values)}};const Rn={kernelName:t.GatherV2,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r,indices:i}=n,{axis:l,batchDims:d}=o;a([r,i],"gatherV2");let c=d;null==d&&(c=0);const u=t.util.sizeFromShape(i.shape),p=t.util.parseAxisParam(l,r.shape)[0],h=t.backend_util.segment_util.collectGatherOpShapeInfo(r,i,p,c),f=Ye({inputs:{x:r},backend:s,attrs:{shape:[h.batchSize,h.outerSize,h.dimSize,h.sliceSize]}}),m=Ye({inputs:{x:i},backend:s,attrs:{shape:[h.batchSize,u/h.batchSize]}}),k=[h.batchSize,h.outerSize,u/h.batchSize,h.sliceSize],b=s.bufferSync(m),I=V(s.bufferSync(f),b,k);return s.disposeIntermediateTensorInfo(f),s.disposeIntermediateTensorInfo(m),s.makeTensorInfo(h.outputShape,I.dtype,I.values)}},Pn=l((e,t)=>e>=t?1:0),Bn=I(t.GreaterEqual,Pn,null,"bool"),Ln={kernelName:t.GreaterEqual,backendName:"cpu",kernelFunc:Bn};const Vn={kernelName:t.IFFT,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a}=e,{input:s}=n,o=t.util.sizeFromShape(s.shape),r=s.shape[s.shape.length-1],i=Ye({inputs:{x:s},backend:a,attrs:{shape:[o/r,r]}}),l=Fn(i,!0,a),d=Ye({inputs:{x:l},backend:a,attrs:{shape:s.shape}});return a.disposeIntermediateTensorInfo(i),a.disposeIntermediateTensorInfo(l),d}},On=M(t.IsFinite,e=>Number.isFinite(e)?1:0,"bool"),$n={kernelName:t.IsFinite,backendName:"cpu",kernelFunc:On},Gn=M(t.IsInf,e=>Math.abs(e)===1/0?1:0,"bool"),qn={kernelName:t.IsInf,backendName:"cpu",kernelFunc:Gn},Un=M(t.IsNan,e=>Number.isNaN(e)?1:0,"bool"),Zn={kernelName:t.IsNan,backendName:"cpu",kernelFunc:Un},jn=l((e,t)=>e<=t?1:0),Kn=I(t.LessEqual,jn,null,"bool"),Yn={kernelName:t.LessEqual,backendName:"cpu",kernelFunc:Kn};const Jn={kernelName:t.LinSpace,backendName:"cpu",kernelFunc:function(e){const{backend:t,attrs:n}=e,{start:a,stop:s,num:o}=n,r=j(a,s,o);return t.makeTensorInfo([r.length],"float32",r)}},Qn=M(t.Log1p,e=>Math.log1p(e)),Xn={kernelName:t.Log1p,backendName:"cpu",kernelFunc:Qn},ea=l((e,t)=>e&&t),ta=I(t.LogicalAnd,ea,null,"bool"),na={kernelName:t.LogicalAnd,backendName:"cpu",kernelFunc:ta},aa=M(t.LogicalNot,e=>e?0:1,"bool"),sa={kernelName:t.LogicalNot,backendName:"cpu",kernelFunc:aa},oa=l((e,t)=>e||t),ra=I(t.LogicalOr,oa,null,"bool"),ia={kernelName:t.LogicalOr,backendName:"cpu",kernelFunc:ra};const la={kernelName:t.LRN,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r}=n,{depthRadius:i,bias:l,alpha:d,beta:c}=o;a(r,"LRN");const u=r.shape[3],p=u-1,h=s.data.get(r.dataId).values,f=t.util.sizeFromShape(r.shape),m=new Float32Array(f);function k(e){const t=e%u;let n=e-t+Math.max(0,t-i);const a=e-t+Math.min(t+i,p);let s=0;for(;n<=a;n++){const e=h[n];s+=e*e}return s}for(let e=0;e<f;e++){const t=k(e),n=h[e]*Math.pow(l+d*t,-c);m[e]=n}return s.makeTensorInfo(r.shape,r.dtype,m)}};const da={kernelName:t.LRNGrad,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r,y:i,dy:l}=n,{depthRadius:d,bias:c,alpha:u,beta:p}=o;a(l,"LRNGrad");const h=t.util.sizeFromShape(l.shape),f=l.shape[3],m=s.data.get(l.dataId).values,k=s.data.get(r.dataId).values,b=s.data.get(i.dataId).values,I=new Float32Array(h),g=h;for(let e=0;e<g;e++){const t=e%f,n=e-t+Math.max(0,t-d),a=e-t+Math.min(f,t+d+1);let s=0;for(let e=n;e<a;e++)s+=Math.pow(k[e],2);s=u*s+c;for(let t=n;t<a;t++){let n=-2*u*p*k[t]*b[e]/s;e===t&&(n+=Math.pow(s,-p)),n*=m[e],I[t]+=n}}return s.makeTensorInfo(l.shape,r.dtype,I)}};function ca(e){const{inputs:n,backend:s,attrs:o}=e,{x:r}=n,{reductionIndices:i,keepDims:l}=o,d=s;let c=r.shape;const u=c.length,p=t.util.parseAxisParam(i,c);let h=p;const f=t.backend_util.getAxesPermutation(h,u);let m=d.data.get(r.dataId).values;if(null!=f){const e=new Array(u);for(let t=0;t<e.length;t++)e[t]=c[f[t]];m=fe(m,c,r.dtype,f,e),h=t.backend_util.getInnerMostAxes(h.length,u),c=e}a(r,"max"),t.backend_util.assertAxesAreInnerMostDims("max",h,u);const[k,b]=t.backend_util.computeOutAndReduceShapes(c,h),I=Q(m,t.util.sizeFromShape(b),k,r.dtype),g=d.write(I,k,r.dtype);let y=k;if(l){y=t.backend_util.expandShapeToKeepDim(k,p)}return{dataId:g,shape:y,dtype:r.dtype}}const ua={kernelName:t.Max,backendName:"cpu",kernelFunc:ca};const pa={kernelName:t.MaxPool,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r}=n;a(r,"maxPool");const{filterSize:i,strides:l,pad:d,dimRoundingMode:c}=o;t.util.assert(t.backend_util.eitherStridesOrDilationsAreOne(l,1),()=>"Error in maxPool: Either strides or dilations must be 1. "+`Got strides ${l} and dilations '1'`);const u=t.backend_util.computePool2DInfo(r.shape,i,l,1,d,c);let h;if(1===u.filterWidth&&1===u.filterHeight&&t.util.arraysEqual(u.inShape,u.outShape))h=p({inputs:{x:r},backend:s});else{const e=s.data.get(r.dataId).values,n=t.util.computeStrides(r.shape),a=Nt(e,r.shape,r.dtype,n,u,"max");h=s.makeTensorInfo(u.outShape,r.dtype,a.values)}return h}};const ha={kernelName:t.MaxPool3D,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r}=n,{filterSize:i,strides:l,pad:d,dimRoundingMode:c,dataFormat:u,dilations:p}=o;a(r,"maxPool3d");let h=p;null==h&&(h=[1,1,1]);const f=t.backend_util.computePool3DInfo(r.shape,i,l,h,d,c,u),m=Tt(s.data.get(r.dataId).values,r.shape,r.dtype,t.util.computeStrides(r.shape),f,"max");return s.makeTensorInfo(m.shape,"float32",m.values)}};const fa={kernelName:t.MaxPool3DGrad,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{dy:r,input:i}=n,{filterSize:l,strides:d,pad:c,dilations:u,dimRoundingMode:p}=o;a([r,i],"maxPool3DGrad");const h=t.backend_util.computePool3DInfo(i.shape,l,d,u,c,p),f=function(e,n){const a=t.buffer(n.outShape,"int32"),s=n.strideDepth,o=n.strideHeight,r=n.strideWidth,i=n.dilationDepth,l=n.dilationHeight,d=n.dilationWidth,c=n.effectiveFilterDepth,u=n.effectiveFilterHeight,p=n.effectiveFilterWidth,h=n.padInfo.front,f=n.padInfo.top,m=n.padInfo.left;for(let t=0;t<n.batchSize;++t)for(let k=0;k<n.inChannels;++k)for(let b=0;b<n.outDepth;++b){const I=b*s-h;let g=I;for(;g<0;)g+=i;const y=Math.min(n.inDepth,c+I);for(let s=0;s<n.outHeight;++s){const c=s*o-f;let h=c;for(;h<0;)h+=l;const N=Math.min(n.inHeight,u+c);for(let o=0;o<n.outWidth;++o){const f=o*r-m;let x=f;for(;x<0;)x+=d;const T=Math.min(n.inWidth,p+f);let S=Number.NEGATIVE_INFINITY,F=-1;for(let n=g;n<y;n+=i){const a=n-I;for(let s=h;s<N;s+=l){const o=s-c;for(let r=x;r<T;r+=d){const i=r-f,l=e.get(t,n,s,r,k);l>=S&&(S=l,F=a*u*p+o*u+i)}}}a.set(F,t,b,s,o,k)}}}return a}(s.bufferSync(i),h),m=h.strideDepth,k=h.strideHeight,b=h.strideWidth,I=h.dilationDepth,g=h.dilationHeight,y=h.dilationWidth,N=h.effectiveFilterDepth,x=h.effectiveFilterHeight,T=h.effectiveFilterWidth,S=N-1-h.padInfo.front,F=T-1-h.padInfo.left,v=x-1-h.padInfo.top,M=t.buffer(i.shape,"float32"),A=s.bufferSync(r);for(let e=0;e<h.batchSize;++e)for(let t=0;t<h.inChannels;++t)for(let n=0;n<h.inDepth;++n)for(let a=0;a<h.inHeight;++a)for(let s=0;s<h.inWidth;++s){const o=n-S,r=a-v,i=s-F;let l=0;for(let n=0;n<N;n+=I){const a=(o+n)/m;if(!(a<0||a>=h.outDepth||Math.floor(a)!==a))for(let s=0;s<x;s+=g){const o=(r+s)/k;if(!(o<0||o>=h.outHeight||Math.floor(o)!==o))for(let r=0;r<T;r+=y){const d=(i+r)/b;if(d<0||d>=h.outWidth||Math.floor(d)!==d)continue;const c=N*x*T-1-f.get(e,a,o,d,t)===n*x*T+s*T+r?1:0;0!==c&&(l+=A.get(e,a,o,d,t)*c)}}}M.set(l,e,n,a,s,t)}return s.makeTensorInfo(M.shape,M.dtype,M.values)}};const ma={kernelName:t.MaxPoolGrad,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{dy:r,input:i,output:l}=n,d=i;a([i,l],"maxPoolGrad");const{filterSize:c,strides:u,pad:p,dimRoundingMode:h}=o,f=t.backend_util.computePool2DInfo(d.shape,c,u,1,p,h),m=s.data.get(d.dataId).values,k=t.buffer(f.outShape,d.dtype,xt(m,d.shape,d.dtype,f).values),b=f.strideHeight,I=f.strideWidth,g=f.dilationHeight,y=f.dilationWidth,N=f.effectiveFilterHeight,x=f.effectiveFilterWidth,T=x-1-f.padInfo.left,S=N-1-f.padInfo.top,F=t.buffer(d.shape,"float32"),v=s.data.get(r.dataId).values,M=t.buffer(r.shape,"float32",v);for(let e=0;e<f.batchSize;++e)for(let t=0;t<f.inChannels;++t)for(let n=0;n<f.inHeight;++n)for(let a=0;a<f.inWidth;++a){const s=n-S,o=a-T;let r=0;for(let n=0;n<N;n+=g){const a=(s+n)/b;if(!(a<0||a>=f.outHeight||Math.floor(a)!==a))for(let s=0;s<x;s+=y){const i=(o+s)/I;if(i<0||i>=f.outWidth||Math.floor(i)!==i)continue;const l=N*x-1-k.get(e,a,i,t)===n*x+s?1:0;0!==l&&(r+=M.get(e,a,i,t)*l)}}F.set(r,e,n,a,t)}return s.makeTensorInfo(F.shape,F.dtype,F.values)}};const ka={kernelName:t.MaxPoolWithArgmax,backendName:"cpu",kernelFunc:({inputs:e,attrs:n,backend:s})=>{const{x:o}=e,{filterSize:r,strides:i,pad:l,includeBatchInIndex:d}=n,c=s;a(o,"MaxPoolWithArgmax");const u=c.data.get(o.dataId).values,p=t.backend_util.computePool2DInfo(o.shape,r,i,[1,1],l),[h,f]=function(e,n,a,s,o){const r=Nt(e,0,a,t.util.computeStrides(n),o,"max"),i=xt(e,n,a,o,!0,s);return[r.values,i.values]}(u,o.shape,o.dtype,d,p),m=c.write(h,p.outShape,o.dtype),k=c.write(f,p.outShape,o.dtype);return[{dataId:m,shape:p.outShape,dtype:o.dtype},{dataId:k,shape:p.outShape,dtype:"int32"}]}};function ba(e){const{inputs:n,backend:s,attrs:o}=e,{x:r}=n,{axis:i,keepDims:l}=o;let d;a(r,"sum"),d="bool"===r.dtype?k({inputs:{x:r},backend:s,attrs:{dtype:"int32"}}):p({inputs:{x:r},backend:s});const c=d.shape.length,h=t.util.parseAxisParam(i,d.shape),f=t.backend_util.getAxesPermutation(h,c);let m=h,b=d;null!=f&&(b=me({inputs:{x:d},backend:s,attrs:{perm:f}}),m=t.backend_util.getInnerMostAxes(m.length,c)),t.backend_util.assertAxesAreInnerMostDims("sum",m,b.shape.length);const[I,g]=t.backend_util.computeOutAndReduceShapes(b.shape,m);let y=u(s,I,t.backend_util.upcastType(b.dtype,"int32"));const N=t.util.sizeFromShape(g),x=s.data.get(y.dataId).values,T=s.data.get(b.dataId).values;for(let e=0;e<x.length;++e){const t=e*N;let n=0;for(let e=0;e<N;++e)n+=T[t+e];x[e]=n}if(l){const e=y;y=Ye({inputs:{x:y},backend:s,attrs:{shape:t.backend_util.expandShapeToKeepDim(y.shape,h)}}),s.disposeIntermediateTensorInfo(e)}return s.disposeIntermediateTensorInfo(d),null!=f&&s.disposeIntermediateTensorInfo(b),y}const Ia={kernelName:t.Sum,backendName:"cpu",kernelFunc:ba};const ga={kernelName:t.Mean,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{x:o}=n,{axis:r,keepDims:i}=s,l=t.util.parseAxisParam(r,o.shape),d=t.backend_util.computeOutAndReduceShapes(o.shape,l)[1],c=t.util.sizeFromShape(d),u=[],p=a.makeTensorInfo([],"float32",new Float32Array([c]));u.push(p);const h=k({inputs:{x:o},backend:a,attrs:{dtype:"float32"}});u.push(h);const f=Tn({inputs:{a:h,b:p},backend:a});u.push(f);const m=ba({inputs:{x:f},backend:a,attrs:{axis:r,keepDims:i}});return u.forEach(e=>a.disposeIntermediateTensorInfo(e)),m}};const ya={kernelName:t.Min,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r}=n,{axis:i,keepDims:l}=o;a(r,"min");const d=t.util.parseAxisParam(i,r.shape);let c=d;const u=t.backend_util.getAxesPermutation(c,r.shape.length);let p=r;null!=u&&(p=me({inputs:{x:r},backend:s,attrs:{perm:u}}),c=t.backend_util.getInnerMostAxes(c.length,r.shape.length)),t.backend_util.assertAxesAreInnerMostDims("min",c,p.shape.length);const[h,f]=t.backend_util.computeOutAndReduceShapes(p.shape,c),m=t.util.sizeFromShape(f),k=t.util.makeZerosTypedArray(t.util.sizeFromShape(h),p.dtype),b=s.data.get(p.dataId).values;for(let e=0;e<k.length;++e){const t=e*m;let n=b[t];for(let e=0;e<m;++e){const a=b[t+e];a<n&&(n=a)}k[e]=n}null!=u&&s.disposeIntermediateTensorInfo(p);const I=s.makeTensorInfo(h,p.dtype,k);if(l){const e=Ye({inputs:{x:I},backend:s,attrs:{shape:t.backend_util.expandShapeToKeepDim(h,d)}});return s.disposeIntermediateTensorInfo(I),e}return I}};const Na={kernelName:t.MirrorPad,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r}=n,{paddings:i,mode:l}=o;a(r,"mirrorPad");const d=i.map((e,t)=>e[0]+r.shape[t]+e[1]),c=i.map(e=>e[0]),u=i.map((e,t)=>e[0]+r.shape[t]),p="reflect"===l?0:1,h=s.data.get(r.dataId).values,f=r.shape.length,m=t.util.computeStrides(r.shape),k=t.util.sizeFromShape(d),b=d.length,I=t.util.computeStrides(d),g=t.util.getTypedArrayFromDType(r.dtype,k);for(let e=0;e<k;e++){let n=t.util.indexToLoc(e,b,I);for(let e=0;e<b;e++)n[e]<c[e]?n[e]=2*c[e]-n[e]-p:n[e]>=u[e]&&(n[e]=2*(u[e]-1)-n[e]+p);n=n.map((e,t)=>e-c[t]);const a=t.util.locToIndex(n,f,m);g[e]=h[a]}return{dataId:s.write(g,d,r.dtype),shape:d,dtype:r.dtype}}},xa=l((e,t)=>{const n=e%t;return e<0&&t<0||e>=0&&t>=0?n:(n+t)%t}),Ta=I(t.Mod,xa),Sa={kernelName:t.Mod,backendName:"cpu",kernelFunc:Ta};function Fa(e){const{inputs:n,backend:a,attrs:s}=e,{logits:o}=n,{dim:r}=s,i=o.shape.length;let l=r;if(-1===l&&(l=i-1),l!==i-1)throw Error("Softmax along a non-last dimension is not yet supported. "+`Logits was rank ${i} and dim was ${l}`);const d=t.util.parseAxisParam([l],o.shape),c=ca({inputs:{x:o},backend:a,attrs:{reductionIndices:d,keepDims:!1}}),u=t.backend_util.expandShapeToKeepDim(c.shape,d),p=Ye({inputs:{x:c},backend:a,attrs:{shape:u}}),h=we({inputs:{a:o,b:p},backend:a}),f=W({inputs:{x:h},backend:a}),m=ba({inputs:{x:f},backend:a,attrs:{axis:d,keepDims:!1}}),k=Ye({inputs:{x:m},backend:a,attrs:{shape:u}}),b=Tn({inputs:{a:f,b:k},backend:a});return a.disposeIntermediateTensorInfo(c),a.disposeIntermediateTensorInfo(p),a.disposeIntermediateTensorInfo(h),a.disposeIntermediateTensorInfo(f),a.disposeIntermediateTensorInfo(m),a.disposeIntermediateTensorInfo(k),b}const va={kernelName:t.Softmax,backendName:"cpu",kernelFunc:Fa};const Ma={kernelName:t.Multinomial,backendName:"cpu",kernelFunc:function(e){const{inputs:s,backend:o,attrs:r}=e,{logits:i}=s,{numSamples:l,seed:d,normalized:c}=r;a(i,"multinomial");const u=c?i:Fa({inputs:{logits:i},backend:o,attrs:{dim:-1}}),p=u.shape[0],h=u.shape[1],f=o.data.get(u.dataId).values,m=[p,l],k=t.util.makeZerosTypedArray(t.util.sizeFromShape(m),"int32");for(let e=0;e<p;++e){const t=e*h,a=new Float32Array(h-1);a[0]=f[t];for(let e=1;e<a.length;++e)a[e]=a[e-1]+f[t+e];const s=n.alea(d.toString()),o=e*l;for(let e=0;e<l;++e){const t=s();k[o+e]=a.length;for(let n=0;n<a.length;n++)if(t<a[n]){k[o+e]=n;break}}}return c||o.disposeIntermediateTensorInfo(u),o.makeTensorInfo(m,"int32",k)}},Aa=t.kernel_impls.nonMaxSuppressionV3Impl;const Da={kernelName:t.NonMaxSuppressionV3,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{boxes:o,scores:r}=t,{maxOutputSize:i,iouThreshold:l,scoreThreshold:d}=s;a(o,"NonMaxSuppression");const c=n.data.get(o.dataId).values,u=n.data.get(r.dataId).values,{selectedIndices:p}=Aa(c,u,i,l,d);return n.makeTensorInfo([p.length],"int32",new Int32Array(p))}},_a=t.kernel_impls.nonMaxSuppressionV4Impl;const za={kernelName:t.NonMaxSuppressionV4,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{boxes:o,scores:r}=t,{maxOutputSize:i,iouThreshold:l,scoreThreshold:d,padToMaxOutputSize:c}=s;a(o,"NonMaxSuppressionPadded");const u=n.data.get(o.dataId).values,p=n.data.get(r.dataId).values,{selectedIndices:h,validOutputs:f}=_a(u,p,i,l,d,c);return[n.makeTensorInfo([h.length],"int32",new Int32Array(h)),n.makeTensorInfo([],"int32",new Int32Array([f]))]}},wa=t.kernel_impls.nonMaxSuppressionV5Impl;const Wa={kernelName:t.NonMaxSuppressionV5,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{boxes:o,scores:r}=t,{maxOutputSize:i,iouThreshold:l,scoreThreshold:d,softNmsSigma:c}=s;a(o,"NonMaxSuppressionWithScore");const u=n.data.get(o.dataId).values,p=n.data.get(r.dataId).values,h=i,f=l,m=d,k=c,{selectedIndices:b,selectedScores:I}=wa(u,p,h,f,m,k);return[n.makeTensorInfo([b.length],"int32",new Int32Array(b)),n.makeTensorInfo([I.length],"float32",new Float32Array(I))]}};const Ca={kernelName:t.OneHot,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{indices:r}=n,{depth:i,onValue:l,offValue:d}=o;a(r,"oneHot");const c=t.util.sizeFromShape(r.shape),u=new Float32Array(c*i);u.fill(d);const p=s.data.get(r.dataId).values;for(let e=0;e<c;++e)p[e]>=0&&p[e]<i&&(u[e*i+p[e]]=l);return s.makeTensorInfo([...r.shape,i],"int32",u)}};function Ha(e){const{inputs:t,backend:n}=e,{x:a}=t;if("string"===a.dtype)throw new Error("zerosLike is not supported for string tensors");if("complex64"===a.dtype){const e=f({inputs:{input:a},backend:n}),t=Ha({inputs:{x:e},backend:n}),s=Ct({inputs:{input:a},backend:n}),o=Ha({inputs:{x:s},backend:n}),r=d({inputs:{real:t,imag:o},backend:n});return n.disposeIntermediateTensorInfo(e),n.disposeIntermediateTensorInfo(t),n.disposeIntermediateTensorInfo(s),n.disposeIntermediateTensorInfo(o),r}return An({backend:n,attrs:{shape:a.shape,value:0,dtype:a.dtype}})}const Ea={kernelName:t.ZerosLike,backendName:"cpu",kernelFunc:Ha};const Ra={kernelName:t.OnesLike,backendName:"cpu",kernelFunc:function e(t){const{inputs:n,backend:a}=t,{x:s}=n;if("string"===s.dtype)throw new Error("onesLike is not supported for string tensors");if("complex64"===s.dtype){const t=f({inputs:{input:s},backend:a}),n=e({inputs:{x:t},backend:a}),o=Ct({inputs:{input:s},backend:a}),r=Ha({inputs:{x:o},backend:a}),i=d({inputs:{real:n,imag:r},backend:a});return a.disposeIntermediateTensorInfo(t),a.disposeIntermediateTensorInfo(n),a.disposeIntermediateTensorInfo(o),a.disposeIntermediateTensorInfo(r),i}return An({backend:a,attrs:{shape:s.shape,value:1,dtype:s.dtype}})}};function Pa(e){const{inputs:n,backend:a,attrs:s}=e,{axis:o}=s;if(1===n.length)return yn({inputs:{input:n[0]},backend:a,attrs:{dim:o}});const r=n[0].shape,i=n[0].dtype;n.forEach(e=>{t.util.assertShapesMatch(r,e.shape,"All tensors passed to stack must have matching shapes"),t.util.assert(i===e.dtype,()=>"All tensors passed to stack must have matching dtypes")});const l=[],d=Et({inputs:n.map(e=>{const t=yn({inputs:{input:e},backend:a,attrs:{dim:o}});return l.push(t),t}),backend:a,attrs:{axis:o}});return l.forEach(e=>a.disposeIntermediateTensorInfo(e)),d}const Ba={kernelName:t.Pack,backendName:"cpu",kernelFunc:Pa};const La={kernelName:t.PadV2,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r}=n,{paddings:i,constantValue:l}=o;a(r,"pad");const d=i.map((e,t)=>e[0]+r.shape[t]+e[1]),c=i.map(e=>e[0]),u=s.data.get(r.dataId).values,p=t.util.sizeFromShape(r.shape),h=r.shape.length,f=t.util.computeStrides(r.shape),m=t.util.sizeFromShape(d),k=d.length,b=t.util.computeStrides(d),I=t.util.getTypedArrayFromDType(r.dtype,m);0!==l&&I.fill(l);for(let e=0;e<p;e++){const n=t.util.indexToLoc(e,h,f).map((e,t)=>e+c[t]);I[t.util.locToIndex(n,k,b)]=u[e]}return{dataId:s.write(I,d,r.dtype),shape:d,dtype:r.dtype}}},Va=l((e,t)=>Math.pow(e,t)),Oa=I(t.Pow,Va),$a={kernelName:t.Pow,backendName:"cpu",kernelFunc:Oa};const Ga={kernelName:t.Range,backendName:"cpu",kernelFunc:function(e){const{backend:t,attrs:n}=e,{start:a,stop:s,dtype:o,step:r}=n,i=ge(a,s,r,o);return t.makeTensorInfo([i.length],o,i)}},qa=M(t.Reciprocal,e=>1/e),Ua={kernelName:t.Reciprocal,backendName:"cpu",kernelFunc:qa};const Za={kernelName:t.ResizeBilinear,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{images:r}=n,{alignCorners:i,halfPixelCenters:l,size:d}=o;a(r,"resizeBilinear");const c=t.util.computeStrides(r.shape),[u,p]=d,[h,f,m,k]=r.shape,b=s.data.get(r.dataId).values,I=new Float32Array(t.util.sizeFromShape([h,u,p,k])),g=[i&&u>1?f-1:f,i&&p>1?m-1:m],y=[i&&u>1?u-1:u,i&&p>1?p-1:p];let N=0;const x=g[0]/y[0],T=g[1]/y[1];for(let e=0;e<h;e++)for(let t=0;t<u;t++){let n;n=l?x*(t+.5)-.5:x*t;const a=Math.max(0,Math.floor(n)),s=n-a,o=Math.min(f-1,Math.ceil(n)),r=e*c[0]+a*c[1],i=e*c[0]+o*c[1];for(let e=0;e<p;e++){let t;t=l?T*(e+.5)-.5:T*e;const n=Math.max(0,Math.floor(t)),a=t-n,o=Math.min(m-1,Math.ceil(t)),d=r+n*c[2],u=i+n*c[2],p=r+o*c[2],h=i+o*c[2];for(let e=0;e<k;e++){const t=b[d+e],n=b[u+e],o=t+(b[p+e]-t)*a,r=o+(n+(b[h+e]-n)*a-o)*s;I[N++]=r}}}return s.makeTensorInfo([h,u,p,k],"float32",I)}};const ja={kernelName:t.ResizeBilinearGrad,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{images:r,dy:i}=n,{alignCorners:l}=o;a([i,r],"resizeBilinearGrad");const d=t.util.computeStrides(r.shape),[c,u,p,h]=r.shape,[,f,m]=i.shape,k=new Float32Array(c*u*p*h),b=[l&&f>1?u-1:u,l&&m>1?p-1:p],I=[l&&f>1?f-1:f,l&&m>1?m-1:m],g=b[0]/I[0],y=b[1]/I[1],N=s.data.get(i.dataId).values;let x=0;for(let e=0;e<c;e++){const t=e*d[0];for(let e=0;e<f;e++){const n=e*g,a=Math.floor(n),s=Math.min(Math.ceil(n),u-1),o=t+a*d[1],r=t+s*d[1],i=n-a,l=1-i;for(let e=0;e<m;e++){const t=e*y,n=Math.floor(t),a=Math.min(Math.ceil(t),p-1),s=t-n,c=1-s,u=o+n*d[2],f=o+a*d[2],m=r+n*d[2],b=r+a*d[2],I=l*c,g=l*s,T=i*c,S=i*s;for(let e=0;e<h;e++){const t=N[x++];k[u+e]+=t*I,k[f+e]+=t*g,k[m+e]+=t*T,k[b+e]+=t*S}}}}return s.makeTensorInfo([c,p,u,h],"float32",k)}};const Ka={kernelName:t.ResizeNearestNeighbor,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{images:r}=n,{alignCorners:i,halfPixelCenters:l,size:d}=o;a(r,"resizeNearestNeighbor");const c=t.util.computeStrides(r.shape),[u,p]=d,[h,f,m,k]=r.shape,b=s.data.get(r.dataId).values,I=new Float32Array(h*u*p*k),g=[i&&u>1?f-1:f,i&&p>1?m-1:m],y=[i&&u>1?u-1:u,i&&p>1?p-1:p],N=g[0]/y[0],x=g[1]/y[1];let T=0;for(let e=0;e<h;e++){const t=e*c[0];for(let e=0;e<u;e++){const n=l?N*(e+.5):N*e;let a=Math.min(f-1,i?Math.round(n):Math.floor(n));l&&(a=Math.max(0,a));const s=t+a*c[1];for(let e=0;e<p;e++){const t=l?x*(e+.5):x*e;let n=Math.min(m-1,i?Math.round(t):Math.floor(t));l&&(n=Math.max(0,n));const a=s+n*c[2];for(let e=0;e<k;e++){const t=b[a+e];I[T++]=t}}}}return s.makeTensorInfo([h,u,p,k],r.dtype,I)}};const Ya={kernelName:t.ResizeNearestNeighborGrad,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{images:r,dy:i}=n,{alignCorners:l}=o;a([i,r],"resizeNearestNeighborGrad");const d=t.util.computeStrides(r.shape),c=t.util.computeStrides(i.shape),[u,p,h,f]=r.shape,[,m,k]=i.shape,b=new Float32Array(u*p*h*f),I=s.data.get(i.dataId).values,g=[l&&m>1?p-1:p,l&&k>1?h-1:h],y=[l&&m>1?m-1:m,l&&k>1?k-1:k],N=g[0]/y[0],x=g[1]/y[1],T=1/N,S=1/x,F=2*Math.ceil(T)+2,v=2*Math.ceil(S)+2;for(let e=0;e<u;e++){const t=e*d[0];for(let e=0;e<p;e++){const n=t+e*d[1],a=Math.floor(e*T),s=Math.floor(a-F/2);for(let a=0;a<h;a++){const o=n+a*d[2],r=Math.floor(a*S),i=Math.floor(r-v/2);for(let n=0;n<f;n++){let r=0;for(let o=0;o<F;o++){const d=o+s;if(d<0||d>=m)continue;const u=t+d*c[1],f=d*N;if(e===Math.min(p-1,l?Math.round(f):Math.floor(f)))for(let e=0;e<v;e++){const t=e+i;if(t<0||t>=k)continue;const s=u+t*c[2],o=t*x;a===Math.min(h-1,l?Math.round(o):Math.floor(o))&&(r+=I[s+n])}}b[o+n]=r}}}}return s.makeTensorInfo(r.shape,r.dtype,b)}};const Ja={kernelName:t.Reverse,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r}=n,{dims:i}=o;a(r,"reverse");const l=r.shape.length,d=t.util.parseAxisParam(i,r.shape);if(0===l)return p({inputs:{x:r},backend:s});const c=new t.TensorBuffer(r.shape,r.dtype),u=s.bufferSync(r);for(let e=0;e<c.size;e++){const t=c.indexToLoc(e),n=t.slice();d.forEach(e=>n[e]=r.shape[e]-1-n[e]),c.set(u.get(...n),...t)}return s.makeTensorInfo(c.shape,c.dtype,c.values)}},Qa={kernelName:t.RotateWithOffset,backendName:"cpu",kernelFunc:({inputs:e,attrs:n,backend:a})=>{const{image:s}=e,{radians:o,fillValue:r,center:i}=n,l=a,d=t.util.getTypedArrayFromDType(s.dtype,t.util.sizeFromShape(s.shape)),[c,u,p,h]=s.shape,[f,m]=t.backend_util.getImageCenter(i,u,p),k=Math.sin(o),b=Math.cos(o),I=l.data.get(s.dataId).values;for(let e=0;e<c;e++){const t=e*p*u*h;for(let e=0;e<u;e++){const n=e*(p*h);for(let a=0;a<p;a++){const s=a*h;for(let o=0;o<h;o++){const i=[c,e,a,o],l=i[2],g=i[1];let y=(l-f)*b-(g-m)*k,N=(l-f)*k+(g-m)*b;y=Math.round(y+f),N=Math.round(N+m);let x=r;if("number"!=typeof r&&(x=3===o?255:r[o]),y>=0&&y<p&&N>=0&&N<u){x=I[t+N*(p*h)+y*h+o]}d[t+n+s+o]=x}}}}return{dataId:l.write(d,s.shape,s.dtype),shape:s.shape,dtype:s.dtype}}},Xa=M(t.Round,e=>{const t=Math.floor(e);return e-t<.5?Math.floor(e):e-t>.5?Math.ceil(e):t%2==0?t:t+1}),es={kernelName:t.Round,backendName:"cpu",kernelFunc:Xa};function ts(e,n,a,s,o,r,i,l,d,c){const u=[s/o,o],p=e.values,h=n.values;if(0===s)return t.buffer(a,n.dtype);const f=t.buffer(u,n.dtype);f.values.fill(d);for(let e=0;e<r;e++){const t=[];let r=0;for(let n=0;n<i;n++){const a=p[e*i+n];t.push(a),r+=a*l[n]}if(r<0||r>=s/o)throw new Error(`Invalid indices: ${t} does not index into ${a}`);for(let t=0;t<o;t++)c?f.values[r*o+t]+=h[e*o+t]:f.values[r*o+t]=0===n.rank?h[0]:h[e*o+t]}return f}const ns={kernelName:t.ScatterNd,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{indices:o,updates:r}=n,{shape:i}=s,{sliceRank:l,numUpdates:d,sliceSize:c,strides:u,outputSize:p}=t.backend_util.calculateShapes(r,o,i),h=ts(a.bufferSync(o),a.bufferSync(r),i,p,c,d,l,u,0,!0);return a.makeTensorInfo(i,h.dtype,h.values)}};const as={kernelName:t.Select,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s}=e,{condition:o,t:r,e:i}=n;a([o,r,i],"select");const l=o.shape.length,d=s.data.get(o.dataId).values,c=s.data.get(r.dataId).values,u=s.data.get(i.dataId).values,p=t.upcastType(r.dtype,i.dtype),h=t.util.makeZerosTypedArray(t.util.sizeFromShape(r.shape),p);let f=0;const m=0===l||l>1||1===r.shape.length?1:t.util.sizeFromShape(r.shape.slice(1));for(let e=0;e<d.length;e++)for(let t=0;t<m;t++)1===d[e]?h[f++]=c[e]:h[f++]=u[e];return s.makeTensorInfo(r.shape,p,h)}},ss=t.backend_util.SELU_SCALEALPHA,os=t.backend_util.SELU_SCALE,rs=M(t.Selu,e=>e>=0?os*e:ss*(Math.exp(e)-1)),is={kernelName:t.Selu,backendName:"cpu",kernelFunc:rs},ls=M(t.Sigmoid,e=>1/(1+Math.exp(-e))),ds={kernelName:t.Sigmoid,backendName:"cpu",kernelFunc:ls},cs=M(t.Sign,e=>e<0?-1:e>0?1:0),us={kernelName:t.Sign,backendName:"cpu",kernelFunc:cs},ps=M(t.Sin,e=>Math.sin(e)),hs={kernelName:t.Sin,backendName:"cpu",kernelFunc:ps},fs=M(t.Sinh,e=>Math.sinh(e)),ms={kernelName:t.Sinh,backendName:"cpu",kernelFunc:fs},ks=Math.log(1.1920928955078125e-7)+2,bs=M(t.Softplus,e=>{const t=e>-ks,n=e<ks,a=Math.exp(e);let s;return s=n?a:t?e:Math.log(1+a),s}),Is={kernelName:t.Softplus,backendName:"cpu",kernelFunc:bs};const gs={kernelName:t.SpaceToBatchND,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r}=n,{blockShape:i,paddings:l}=o;a([r],"spaceToBatchND");const d=t.util.sizeFromShape(i),c=[[0,0]];c.push(...l);for(let e=1+i.length;e<r.shape.length;++e)c.push([0,0]);const u=La.kernelFunc({inputs:{x:r},backend:s,attrs:{paddings:c,constantValue:0}}),p=t.backend_util.getReshaped(u.shape,i,d,!1),h=t.backend_util.getPermuted(p.length,i.length,!1),f=t.backend_util.getReshapedPermuted(u.shape,i,d,!1),m=Ye({inputs:{x:u},backend:s,attrs:{shape:p}}),k=me({inputs:{x:m},backend:s,attrs:{perm:h}}),b=Ye({inputs:{x:k},backend:s,attrs:{shape:f}});return s.disposeIntermediateTensorInfo(u),s.disposeIntermediateTensorInfo(m),s.disposeIntermediateTensorInfo(k),b}};const ys={kernelName:t.SparseToDense,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{sparseIndices:o,sparseValues:r,defaultValue:i}=n,{outputShape:l}=s,{sliceRank:d,numUpdates:c,sliceSize:u,strides:p,outputSize:h}=t.backend_util.calculateShapes(r,o,l),f=ts(a.bufferSync(o),a.bufferSync(r),l,h,u,c,d,p,a.data.get(i.dataId).values[0],!1);return a.makeTensorInfo(l,f.dtype,f.values)}};const Ns={kernelName:t.SplitV,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{x:o}=n,{numOrSizeSplits:r,axis:i}=s,l=t.util.parseAxisParam(i,o.shape)[0],d=t.backend_util.prepareSplitSize(o,r,l),c=new Array(o.shape.length).fill(0),u=o.shape.slice();return d.map(e=>{const t=[...u];t[l]=e;const n=Se({inputs:{x:o},backend:a,attrs:{begin:c,size:t}});return c[l]+=e,n})}},xs=M(t.Sqrt,e=>Math.sqrt(e)),Ts={kernelName:t.Sqrt,backendName:"cpu",kernelFunc:xs},Ss={kernelName:t.Square,backendName:"cpu",kernelFunc:({inputs:e,backend:t})=>{const{x:n}=e,s=t;a(n,"square");const o=s.data.get(n.dataId).values,r=new Float32Array(o.length);for(let e=0;e<o.length;++e){const t=o[e];r[e]=t*t}return{dataId:s.write(r,n.shape,n.dtype),shape:n.shape,dtype:n.dtype}}},Fs=M(t.Step,(e,t)=>{const n=t;return isNaN(e)?NaN:e>0?1:n.alpha}),vs={kernelName:t.Step,backendName:"cpu",kernelFunc:Fs};const Ms={kernelName:t.StridedSlice,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r}=n,{begin:i,end:l,strides:d,beginMask:c,endMask:u,ellipsisMask:p,newAxisMask:h,shrinkAxisMask:f}=o;a(r,"stridedSlice");const{nonStrided:m,$begin:k,$strides:b,size:I,newShape:g,outShape:y}=t.slice_util.sliceInfo(r.shape,i,l,d,c,u,p,h,f),N=Ye({inputs:{x:r},backend:s,attrs:{shape:g}});let x;if(m){const e=Se({inputs:{x:N},backend:s,attrs:{begin:k,size:I}});x=Ye({inputs:{x:e},backend:s,attrs:{shape:y}}),s.disposeIntermediateTensorInfo(e)}else if(y.some(e=>0===e))x=s.makeTensorInfo(y,r.dtype,[]);else{const e=De(y,s.bufferSync(N),b,k);x=s.makeTensorInfo(e.shape,e.dtype,e.values)}const T=Ye({inputs:{x:x},backend:s,attrs:{shape:y}});return s.disposeIntermediateTensorInfo(N),s.disposeIntermediateTensorInfo(x),T}},As=M(t.Tan,e=>Math.tan(e)),Ds={kernelName:t.Tan,backendName:"cpu",kernelFunc:As},_s=M(t.Tanh,e=>Math.tanh(e)),zs={kernelName:t.Tanh,backendName:"cpu",kernelFunc:_s};const ws={kernelName:t.Tile,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:o}=t,{reps:r}=s;a(o,"tile");const i=Ce(n.bufferSync(o),r);return n.makeTensorInfo(i.shape,i.dtype,i.values)}};const Ws={kernelName:t.TopK,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:o}=t,{k:r,sorted:i}=s;a(o,"topk");const l=n.data.get(o.dataId).values,[d,c]=He(l,o.shape,o.dtype,r);return[n.makeTensorInfo(d.shape,d.dtype,d.values),n.makeTensorInfo(c.shape,c.dtype,c.values)]}};const Cs={kernelName:t.Unique,backendName:"cpu",kernelFunc:function(e){const{inputs:t,attrs:n,backend:s}=e,{axis:o}=n,{x:r}=t;a(r,"unique");const i=s.data.get(r.dataId).values,{outputValues:l,outputShape:d,indices:c}=Ee(i,o,r.shape,r.dtype);return[s.makeTensorInfo(d,r.dtype,l),s.makeTensorInfo([c.length],"int32",c)]}};const Hs={kernelName:t.Unpack,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{value:s}=t;let{axis:o}=a;o<0&&(o+=s.shape.length);const r=s.shape.length,i=s.shape[o],l=new Array(r-1);let d=0;for(let e=0;e<r;e++)e!==o&&(l[d++]=s.shape[e]);const c=new Array(r).fill(0),u=s.shape.slice();u[o]=1;const p=new Array(i);for(let e=0;e<p.length;e++){c[o]=e;const t=Se({inputs:{x:s},backend:n,attrs:{begin:c,size:u}});p[e]=Ye({inputs:{x:t},backend:n,attrs:{shape:l}}),n.disposeIntermediateTensorInfo(t)}return p}};const Es={kernelName:t.UnsortedSegmentSum,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r,segmentIds:i}=n,{numSegments:l}=o;a(r,"unsortedSegmentSum");const d=[],c=[],u=r.shape.length-i.shape.length;let p=i;for(let e=0;e<u;++e){const t=yn({inputs:{input:p},backend:s,attrs:{dim:e+1}});p=t,c.push(t)}for(let e=0;e<l;++e){const n=t.util.createScalarValue(e,"int32"),a=s.makeTensorInfo([],"int32",n),o=cn({inputs:{a:a,b:p},backend:s}),i=k({inputs:{x:o},backend:s,attrs:{dtype:"float32"}}),l=ie({inputs:{a:i,b:r},backend:s}),u=ba({inputs:{x:l},backend:s,attrs:{axis:0,keepDims:!1}});d.push(u),c.push(a),c.push(o),c.push(i),c.push(l),c.push(u)}const h=Pa({inputs:d,backend:s,attrs:{axis:0}});return c.forEach(e=>s.disposeIntermediateTensorInfo(e)),h}},Rs=[et,i,nt,st,T,ot,rt,it,lt,dt,ut,ht,mt,It,yt,St,Ft,vt,Mt,Xe,At,Dt,_t,b,z,wt,c,Wt,Rt,Lt,Vt,Bt,$t,Gt,Ot,Ut,jt,Kt,Yt,Jt,Qt,en,tn,nn,an,sn,rn,on,Sn,Be,ln,un,gn,C,Nn,R,Mn,Dn,_n,L,Wn,Cn,Hn,En,Rn,G,Ln,h,Vn,Ht,$n,qn,Zn,Ve,Z,Yn,Jn,J,Xn,na,sa,ia,la,da,te,pa,ha,fa,ma,ka,ua,ga,ya,se,Na,Sa,Ma,le,ce,Da,za,Wa,he,Ca,Ra,Ba,La,$a,Ge,Ie,Ga,m,Ua,Ue,je,Je,Za,ja,Ka,Ya,Ja,Qa,es,xe,ns,as,is,ds,us,hs,ms,Fe,va,Is,gs,ys,Ns,Ts,Ss,Ae,vs,Ms,We,Ia,Ds,zs,ws,Ws,ke,Cs,Hs,Es,Ea];for(const e of Rs)t.registerKernel(e);e.MathBackendCPU=o,e.shared=Re,e.version_cpu="2.8.1",Object.defineProperty(e,"__esModule",{value:!0})}));
//# sourceMappingURL=tf-backend-cpu.es2017.min.js.map
