/**
 * @license
 * Copyright 2021 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
!function(e,a){"object"==typeof exports&&"undefined"!=typeof module?a(exports,require("@tensorflow/tfjs-core"),require("seedrandom")):"function"==typeof define&&define.amd?define(["exports","@tensorflow/tfjs-core","seedrandom"],a):a((e=e||self).tf=e.tf||{},e.tf,e.seedrandom)}(this,(function(e,a,t){"use strict";var n=function(e,a){return(n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,a){e.__proto__=a}||function(e,a){for(var t in a)a.hasOwnProperty(t)&&(e[t]=a[t])})(e,a)};function r(e,a,t,n){return new(t||(t=Promise))((function(r,i){function o(e){try{u(n.next(e))}catch(e){i(e)}}function s(e){try{u(n.throw(e))}catch(e){i(e)}}function u(e){var a;e.done?r(e.value):(a=e.value,a instanceof t?a:new t((function(e){e(a)}))).then(o,s)}u((n=n.apply(e,a||[])).next())}))}function i(e,a){var t,n,r,i,o={label:0,sent:function(){if(1&r[0])throw r[1];return r[1]},trys:[],ops:[]};return i={next:s(0),throw:s(1),return:s(2)},"function"==typeof Symbol&&(i[Symbol.iterator]=function(){return this}),i;function s(i){return function(s){return function(i){if(t)throw new TypeError("Generator is already executing.");for(;o;)try{if(t=1,n&&(r=2&i[0]?n.return:i[0]?n.throw||((r=n.return)&&r.call(n),0):n.next)&&!(r=r.call(n,i[1])).done)return r;switch(n=0,r&&(i=[2&i[0],r.value]),i[0]){case 0:case 1:r=i;break;case 4:return o.label++,{value:i[1],done:!1};case 5:o.label++,n=i[1],i=[0];continue;case 7:i=o.ops.pop(),o.trys.pop();continue;default:if(!(r=o.trys,(r=r.length>0&&r[r.length-1])||6!==i[0]&&2!==i[0])){o=0;continue}if(3===i[0]&&(!r||i[1]>r[0]&&i[1]<r[3])){o.label=i[1];break}if(6===i[0]&&o.label<r[1]){o.label=r[1],r=i;break}if(r&&o.label<r[2]){o.label=r[2],o.ops.push(i);break}r[2]&&o.ops.pop(),o.trys.pop();continue}i=a.call(e,o)}catch(e){i=[6,e],n=0}finally{t=r=0}if(5&i[0])throw i[1];return{value:i[0]?i[1]:void 0,done:!0}}([i,s])}}}function o(e,t){Array.isArray(e)||(e=[e]),e.forEach((function(e){null!=e&&a.util.assert("complex64"!==e.dtype,(function(){return t+" does not support complex64 tensors in the CPU backend."}))}))}var s=a.kernel_impls.whereImpl,u=function(e){function t(){var t=e.call(this)||this;return t.blockSize=48,t.firstUse=!0,t.data=new a.DataStorage(t,a.engine()),t}return function(e,a){function t(){this.constructor=e}n(e,a),e.prototype=null===a?Object.create(a):(t.prototype=a.prototype,new t)}(t,e),t.prototype.nextDataId=function(){return t.nextDataId++},t.prototype.write=function(e,t,n){this.firstUse&&(this.firstUse=!1,a.env().get("IS_NODE")&&a.backend_util.warn("\n============================\nHi there 👋. Looks like you are running TensorFlow.js in Node.js. To speed things up dramatically, install our node backend, which binds to TensorFlow C++, by running npm i @tensorflow/tfjs-node, or npm i @tensorflow/tfjs-node-gpu if you have CUDA. Then call require('@tensorflow/tfjs-node'); (-gpu suffix for CUDA) at the start of your program. Visit https://github.com/tensorflow/tfjs-node for more details.\n============================"));var r={id:this.nextDataId()};return this.data.set(r,{values:e,dtype:n,refCount:1}),r},t.prototype.makeTensorInfo=function(e,t,n){var r;if("string"===t&&null!=n&&n.length>0&&a.util.isString(n[0])){var i=n.map((function(e){return a.util.encodeString(e)}));r=this.write(i,e,t)}else r=this.write(n,e,t);return{dataId:r,shape:e,dtype:t}},t.prototype.refCount=function(e){return this.data.has(e)?this.data.get(e).refCount:0},t.prototype.incRef=function(e){this.data.get(e).refCount++},t.prototype.decRef=function(e){this.data.has(e)&&this.data.get(e).refCount--},t.prototype.move=function(e,a,t,n,r){this.data.set(e,{values:a,dtype:n,refCount:r})},t.prototype.numDataIds=function(){return this.data.numDataIds()},t.prototype.read=function(e){return r(this,void 0,void 0,(function(){return i(this,(function(a){return[2,this.readSync(e)]}))}))},t.prototype.readSync=function(e){var t=this.data.get(e),n=t.dtype,r=t.complexTensorInfos;if("complex64"===n){var i=this.readSync(r.real.dataId),o=this.readSync(r.imag.dataId);return a.backend_util.mergeRealAndImagArrays(i,o)}return this.data.get(e).values},t.prototype.bufferSync=function(e){var t=this.readSync(e.dataId),n=t;if("string"===e.dtype)try{n=t.map((function(e){return a.util.decodeString(e)}))}catch(e){throw new Error("Failed to decode encoded string bytes into utf-8")}return a.buffer(e.shape,e.dtype,n)},t.prototype.makeOutput=function(e,t,n){var r=this.write(e,t,n);return a.engine().makeTensorFromDataId(r,t,n,this)},t.prototype.disposeData=function(e,a){if(void 0===a&&(a=!1),this.data.has(e)){if(this.data.get(e).refCount--,!a&&this.data.get(e).refCount>0)return!1;var t=this.data.get(e).complexTensorInfos;null!=t&&(this.disposeData(t.real.dataId,!0),this.disposeData(t.imag.dataId,!0)),this.data.delete(e)}return!0},t.prototype.disposeIntermediateTensorInfo=function(e){this.disposeData(e.dataId)},t.prototype.time=function(e){return r(this,void 0,void 0,(function(){var t;return i(this,(function(n){return t=a.util.now(),e(),[2,{kernelMs:a.util.now()-t}]}))}))},t.prototype.memory=function(){return{unreliable:!0,reasons:["The reported memory is an upper bound. Due to automatic garbage collection, the true allocated memory may be less."]}},t.prototype.where=function(e){o([e],"where");var a=this.readSync(e.dataId);return s(e.shape,a)},t.prototype.dispose=function(){},t.prototype.floatPrecision=function(){return 32},t.prototype.epsilon=function(){return e.prototype.epsilon.call(this)},t.nextDataId=0,t}(a.KernelBackend);function d(e){for(var a=new Float32Array(e.length),t=0;t<e.length;++t)a[t]=Math.abs(e[t]);return a}var p={kernelName:a.Abs,backendName:"cpu",kernelFunc:function(e){var t=e.inputs.x,n=e.backend;o(t,"abs");var r=new Float32Array(a.util.sizeFromShape(t.shape));return r=d(n.data.get(t.dataId).values),n.makeOutput(r,t.shape,"float32")}};function l(e){return function(t,n,r,i,o){var s=a.backend_util.assertAndGetBroadcastShape(t,n),u=s.length,d=a.util.computeStrides(s),p=a.util.sizeFromShape(s),l=a.util.getTypedArrayFromDType(o,p),c=t.length,f=n.length,h=a.util.computeStrides(t),m=a.util.computeStrides(n),v=a.backend_util.getBroadcastDims(t,s),k=a.backend_util.getBroadcastDims(n,s);if(v.length+k.length===0)for(var b=0;b<l.length;++b)l[b]=e(r[b%r.length],i[b%i.length]);else{var g=function(t){var n=a.util.indexToLoc(t,u,d),o=n.slice(-c);v.forEach((function(e){return o[e]=0}));var s=a.util.locToIndex(o,c,h),p=n.slice(-f);k.forEach((function(e){return p[e]=0}));var b=a.util.locToIndex(p,f,m);l[t]=e(r[s],i[b])};for(b=0;b<l.length;++b)g(b)}return[l,s]}}function c(e){var a=e.inputs,t=e.backend,n=a.real,r=a.imag,i=t.data.get(n.dataId).values,o=t.data.get(r.dataId).values,s=t.makeTensorInfo(n.shape,"complex64");return t.data.get(s.dataId).complexTensorInfos={real:t.makeTensorInfo(n.shape,"float32",i),imag:t.makeTensorInfo(r.shape,"float32",o)},s}var f={kernelName:a.Complex,backendName:"cpu",kernelFunc:c};function h(e,t,n){if(void 0===n&&(n="float32"),"complex64"===n)return c({inputs:{real:h(e,t,"float32"),imag:h(e,t,"float32")},backend:e});var r=a.util.makeZerosTypedArray(a.util.sizeFromShape(t),n);return e.makeTensorInfo(t,n,r)}function m(e){var a=e.inputs,t=e.backend,n=a.x;return t.incRef(n.dataId),{dataId:n.dataId,shape:n.shape,dtype:n.dtype}}var v={kernelName:a.Identity,backendName:"cpu",kernelFunc:m};function k(e){var a=e.inputs,t=e.backend,n=a.input,r=t.data.get(n.dataId).complexTensorInfos.real,i=t.data.get(r.dataId).values;return t.makeTensorInfo(r.shape,r.dtype,i)}var b={kernelName:a.Real,backendName:"cpu",kernelFunc:k};function g(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,o=r.dtype;if("complex64"===o){if("complex64"===i.dtype)return m({inputs:{x:i},backend:n});var s=h(n,i.shape,i.dtype),u=g({inputs:{x:i},backend:n,attrs:{dtype:"float32"}}),d=c({inputs:{real:u,imag:s},backend:n});return n.disposeIntermediateTensorInfo(s),n.disposeIntermediateTensorInfo(u),d}if("complex64"===i.dtype){var p=k({inputs:{input:i},backend:n}),d=g({inputs:{x:p},backend:n,attrs:{dtype:o}});return n.disposeIntermediateTensorInfo(p),d}if(!a.util.hasEncodingLoss(i.dtype,o))return{dataId:(d=m({inputs:{x:i},backend:n})).dataId,shape:d.shape,dtype:o};if("int32"===o){var f=n.data.get(i.dataId).values,v=Int32Array.from(f);return n.makeTensorInfo(i.shape,"int32",v)}if("bool"===o){var b=n.data.get(i.dataId).values,I=a.util.toTypedArray([0],i.dtype),y=l((function(e,a){return e!==a?1:0}))(i.shape,[],b,I,"bool"),N=y[0],x=y[1];return n.makeTensorInfo(x,"bool",N)}throw new Error("Error in Cast: failed to cast "+i.dtype+" to "+o)}var I={kernelName:a.Cast,backendName:"cpu",kernelFunc:g};function y(e,a,t,n){return null==t?function(t){var r=t.inputs,i=t.backend,s=r,u=s.a,d=s.b,p=i;o([u,d],e);var l=p.data.get(u.dataId).values,c=p.data.get(d.dataId).values,f=n||u.dtype,h=a(u.shape,d.shape,l,c,f),m=h[0],v=h[1];return p.makeTensorInfo(v,f,m)}:function(e){var r=e.inputs,i=e.backend,o=r,s=o.a,u=o.b,d=i;if("complex64"===s.dtype||"complex64"===u.dtype){var p=g({inputs:{x:s},backend:d,attrs:{dtype:"complex64"}}),l=d.data.get(p.dataId),f=l.complexTensorInfos.real,h=l.complexTensorInfos.imag,m=d.data.get(f.dataId).values,v=d.data.get(h.dataId).values,k=g({inputs:{x:u},backend:d,attrs:{dtype:"complex64"}}),b=d.data.get(k.dataId),I=b.complexTensorInfos.real,y=b.complexTensorInfos.imag,N=d.data.get(I.dataId).values,x=d.data.get(y.dataId).values,T=t(s.shape,u.shape,m,v,N,x),S=T[0],F=T[1],M=T[2],A=d.makeTensorInfo(M,"float32",S),D=d.makeTensorInfo(M,"float32",F),_=c({inputs:{real:A,imag:D},backend:d});return d.disposeIntermediateTensorInfo(p),d.disposeIntermediateTensorInfo(k),d.disposeIntermediateTensorInfo(A),d.disposeIntermediateTensorInfo(D),_}var w=d.data.get(s.dataId).values,z=d.data.get(u.dataId).values,W=n||s.dtype,C=a(s.shape,u.shape,w,z,W),H=C[0];M=C[1];return d.makeTensorInfo(M,W,H)}}function N(e){return function(t,n,r,i,o,s){var u=a.backend_util.assertAndGetBroadcastShape(t,n),d=a.util.sizeFromShape(u),p=u.length,l=a.util.computeStrides(u),c=a.util.getTypedArrayFromDType("float32",d),f=a.util.getTypedArrayFromDType("float32",d),h=a.backend_util.getBroadcastDims(t,u),m=a.backend_util.getBroadcastDims(n,u),v=a.backend_util.mergeRealAndImagArrays(r,i),k=a.backend_util.mergeRealAndImagArrays(o,s),b=t.length,g=a.util.computeStrides(t),I=n.length,y=a.util.computeStrides(n);if(h.length+m.length===0)for(var N=0;N<c.length;N++){var x=N%v.length,T=N%k.length,S=e(v[2*x],v[2*x+1],k[2*T],k[2*T+1]);c[N]=S.real,f[N]=S.imag}else{var F=function(t){var n=a.util.indexToLoc(t,p,l),r=n.slice(-b);h.forEach((function(e){return r[e]=0}));var i=a.util.locToIndex(r,b,g),o=n.slice(-I);m.forEach((function(e){return o[e]=0}));var s=a.util.locToIndex(o,I,y),u=e(v[2*i],v[2*i+1],k[2*s],k[2*s+1]);c[t]=u.real,f[t]=u.imag};for(N=0;N<c.length;N++)F(N)}return[c,f,u]}}var x=l((function(e,a){return e+a})),T=N((function(e,a,t,n){return{real:e+t,imag:a+n}})),S=y(a.Add,x,T),F={kernelName:a.Add,backendName:"cpu",kernelFunc:S};function M(e,t,n,r,i){for(var o=a.util.sizeFromShape(r),s=a.util.makeZerosTypedArray(i,n),u=0;u<e.length;u++){var d=e[u];if(d<0)throw new Error("Input x must be non-negative!");d>=i||(s[d]+=o>0?t[u]:1)}return s}function A(e,t,n,r){void 0===r&&(r=!1);for(var i=e.shape[0],o=e.shape[1],s=a.buffer([i,n],t.dtype),u=0;u<i;u++)for(var d=0;d<o;d++){var p=e.get(u,d);if(p<0)throw new Error("Input x must be non-negative!");p>=n||(r?s.set(1,u,p):t.size>0?s.set(s.get(u,p)+t.get(u,d),u,p):s.set(s.get(u,p)+1,u,p))}return s}function D(e){return function(t,n,r){for(var i=a.util.getTypedArrayFromDType(n,t.length),o=0;o<t.length;++o)i[o]=e(t[o],r);return i}}function _(e,t,n){return function(r){var i=r.inputs,s=r.attrs,u=r.backend,d=i.x;if(o(d,e),"string"===d.dtype||"string"===n)throw new Error("unaryKernelFunc does not support string input/output");for(var p=u,l=p.data.get(d.dataId).values,c=a.util.sizeFromShape(d.shape),f=n||d.dtype,h=a.util.getArrayFromDType(f,c),m=0;m<c;++m)h[m]=t(l[m],s);return p.makeTensorInfo(d.shape,f,h)}}function w(e,a,t){return function(n){var r=n.inputs,i=n.attrs,s=n.backend,u=r.x;if(o(u,e),"string"===u.dtype||"string"===t)throw new Error("unaryKernelFunc does not support string input/output");var d=s,p=d.data.get(u.dataId).values,l=t||u.dtype,c=a(p,l,i);return d.makeTensorInfo(u.shape,l,c)}}var z=D((function(e){return Math.ceil(e)})),W=w(a.Ceil,z),C={kernelName:a.Ceil,backendName:"cpu",kernelFunc:W};function H(e,t,n,r){var i=a.util.getArrayFromDType(n,a.util.sizeFromShape(t));if(r&&"string"!==n){var o=0;e.forEach((function(e){var t=a.util.sizeFromShape(e.shape);i.set(e.vals,o),o+=t}))}else{var s=0;e.forEach((function(e){for(var r="string"===n?a.backend_util.fromUint8ToStringArray(e.vals):e.vals,o=0,u=0;u<e.shape[0];++u)for(var d=u*t[1]+s,p=0;p<e.shape[1];++p)i[d+p]=r[o++];s+=e.shape[1]}))}return i}var E=D((function(e){return Math.exp(e)})),P=w(a.Exp,E),R={kernelName:a.Exp,backendName:"cpu",kernelFunc:P},B=D((function(e){return Math.expm1(e)})),O=w(a.Expm1,B),L={kernelName:a.Expm1,backendName:"cpu",kernelFunc:O},V=D((function(e){return Math.floor(e)})),G=w(a.Floor,V),q={kernelName:a.Floor,backendName:"cpu",kernelFunc:G};function U(e,t,n){for(var r=a.buffer(n,e.dtype),i=0;i<r.size;++i){var o=r.indexToLoc(i).slice(),s=o[0],u=o[2],d=t.locToIndex([s,u]);o[2]=t.values[d];var p=e.locToIndex(o);r.values[i]=e.values[p]}return r}var Z=l((function(e,a){return e>a?1:0})),j=y(a.Greater,Z,null,"bool"),K={kernelName:a.Greater,backendName:"cpu",kernelFunc:j},Y=l((function(e,a){return e<a?1:0})),$=y(a.Less,Y,null,"bool"),J={kernelName:a.Less,backendName:"cpu",kernelFunc:$};function Q(e,t,n){var r=(t-e)/(n-1),i=a.util.makeZerosTypedArray(n,"float32");i[0]=e;for(var o=1;o<i.length;o++)i[o]=i[o-1]+r;return i}var X=D((function(e){return Math.log(e)})),ee=w(a.Log,X),ae={kernelName:a.Log,backendName:"cpu",kernelFunc:ee};function te(e,t,n,r){for(var i=a.util.getTypedArrayFromDType(r,a.util.sizeFromShape(n)),o=0;o<i.length;++o){for(var s=o*t,u=e[s],d=0;d<t;++d){var p=e[s+d];p>u&&(u=p)}i[o]=u}return i}var ne=l((function(e,a){return Math.max(e,a)})),re=y(a.Maximum,ne),ie={kernelName:a.Maximum,backendName:"cpu",kernelFunc:re},oe=l((function(e,a){return Math.min(e,a)})),se=y(a.Minimum,oe),ue={kernelName:a.Minimum,backendName:"cpu",kernelFunc:se},de=l((function(e,a){return e*a})),pe=N((function(e,a,t,n){return{real:e*t-a*n,imag:e*n+a*t}})),le=y(a.Multiply,de,pe),ce={kernelName:a.Multiply,backendName:"cpu",kernelFunc:le};function fe(e,t,n){var r=a.util.createScalarValue(-1,n);return de([],t,r,e,n)}var he={kernelName:a.Neg,backendName:"cpu",kernelFunc:function(e){var a=e.inputs,t=e.backend,n=a.x;o(n,"neg");var r=fe(t.data.get(n.dataId).values,n.shape,n.dtype),i=r[0],s=r[1];return t.makeTensorInfo(s,n.dtype,i)}},me=l((function(e,a){return e!==a?1:0})),ve=y(a.NotEqual,me,null,"bool"),ke={kernelName:a.NotEqual,backendName:"cpu",kernelFunc:ve};function be(e,t,n,r,i){for(var o=t.length,s=a.util.sizeFromShape(t),u=a.util.computeStrides(t),d=a.util.computeStrides(i),p=a.util.getTypedArrayFromDType(n,a.util.sizeFromShape(i)),l=0;l<s;++l){for(var c=a.util.indexToLoc(l,o,u),f=new Array(c.length),h=0;h<f.length;h++)f[h]=c[r[h]];p[a.util.locToIndex(f,o,d)]=e[l]}return p}function ge(e){var a=e.inputs,t=e.attrs,n=e.backend,r=a.x,i=t.perm;o(r,"transpose");for(var s=r.shape.length,u=new Array(s),d=0;d<u.length;d++)u[d]=r.shape[i[d]];var p=be(n.data.get(r.dataId).values,r.shape,r.dtype,i,u);return{dataId:n.write(p,u,r.dtype),shape:u,dtype:r.dtype}}var Ie={kernelName:a.Transpose,backendName:"cpu",kernelFunc:ge};function ye(e,t,n,r){for(var i=a.backend_util.computeOutAndReduceShapes(e,r),o=i[0],s=i[1],u=a.upcastType(t,"int32"),d=a.util.makeZerosTypedArray(a.util.sizeFromShape(o),u),p=a.util.sizeFromShape(s),l=0;l<d.length;++l){for(var c=l*p,f=1,h=0;h<p;++h)f*=n[c+h];d[l]=f}return{outVals:d,outShape:o,outDtype:u}}var Ne={kernelName:a.Prod,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,s=r.axis,u=r.keepDims;o(i,"prod");var d=i.shape.length,p=a.util.parseAxisParam(s,i.shape),l=a.backend_util.getAxesPermutation(p,d),c=p,f=i,h=[];null!=l&&(f=ge({inputs:{x:i},backend:n,attrs:{perm:l}}),h.push(f),c=a.backend_util.getInnerMostAxes(c.length,d));var m=n.data.get(f.dataId).values,v=ye(f.shape,f.dtype,m,c),k=v.outVals,b=v.outShape,g=v.outDtype,I=b;return u&&(I=a.backend_util.expandShapeToKeepDim(b,p)),h.forEach((function(e){return n.disposeIntermediateTensorInfo(e)})),n.makeTensorInfo(I,g,k)}};function xe(e,t,n,r){if(e===t||e<t&&n<0||t<e&&n>1)return a.util.makeZerosTypedArray(0,r);var i=Math.abs(Math.ceil((t-e)/n)),o=a.util.makeZerosTypedArray(i,r);t<e&&1===n&&(n=-1),o[0]=e;for(var s=1;s<o.length;s++)o[s]=o[s-1]+n;return o}var Te=D((function(e){return 1/Math.sqrt(e)})),Se=w(a.Rsqrt,Te),Fe={kernelName:a.Rsqrt,backendName:"cpu",kernelFunc:Se};function Me(e,t,n,r,i){var o=a.slice_util.isSliceContinous(r,t,n),s=a.util.sizeFromShape(n),u=a.util.computeStrides(r);if(o){var d=a.slice_util.computeFlatOffset(t,u);return"string"===i?e.slice(d,d+s):e.subarray(d,d+s)}for(var p="string"===i?a.backend_util.fromUint8ToStringArray(e):e,l=a.buffer(r,i,p),c=a.buffer(n,i),f=0;f<c.size;++f){var h=c.indexToLoc(f),m=h.map((function(e,a){return e+t[a]}));c.set.apply(c,[l.get.apply(l,m)].concat(h))}return"string"===i?a.backend_util.fromStringArrayToUint8(c.values):c.values}function Ae(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,s=r.begin,u=r.size;o(i,"slice");var d=a.slice_util.parseSliceParams(i,s,u),p=d[0],l=d[1];a.slice_util.assertParamsValid(i,p,l);var c=Me(n.data.get(i.dataId).values,p,l,i.shape,i.dtype);return n.makeTensorInfo(l,i.dtype,c)}var De={kernelName:a.Slice,backendName:"cpu",kernelFunc:Ae},_e=l((function(e,a){var t=e-a;return t*t})),we=y(a.SquaredDifference,_e),ze={kernelName:a.SquaredDifference,backendName:"cpu",kernelFunc:we};function We(e,t,n,r){for(var i=a.buffer(e,t.dtype),o=0;o<i.size;o++){for(var s=i.indexToLoc(o),u=new Array(s.length),d=0;d<u.length;d++)u[d]=s[d]*n[d]+r[d];i.set.apply(i,[t.get.apply(t,u)].concat(s))}return i}var Ce=l((function(e,a){return e-a})),He=N((function(e,a,t,n){return{real:e-t,imag:a-n}})),Ee=y(a.Sub,Ce,He),Pe={kernelName:a.Sub,backendName:"cpu",kernelFunc:Ee};function Re(e,t){for(var n=new Array(e.rank),r=0;r<n.length;r++)n[r]=e.shape[r]*t[r];var i=a.buffer(n,e.dtype);for(r=0;r<i.values.length;++r){for(var o=i.indexToLoc(r),s=new Array(e.rank),u=0;u<s.length;u++)s[u]=o[u]%e.shape[u];var d=e.locToIndex(s);i.values[r]=e.values[d]}return i}function Be(e,t,n,r,i){for(var o=t[t.length-1],s=[e.length/o,o],u=s[0],d=s[1],p=a.util.getTypedArrayFromDType(n,u*r),l=a.util.getTypedArrayFromDType("int32",u*r),c=0;c<u;c++){for(var f=c*d,h=e.subarray(f,f+d),m=[],v=0;v<h.length;v++)m.push({value:h[v],index:v});m.sort((function(e,a){return a.value-e.value}));var k=c*r,b=p.subarray(k,k+r),g=l.subarray(k,k+r);for(v=0;v<r;v++)b[v]=m[v].value,g[v]=m[v].index}var I=t.slice();return I[I.length-1]=r,[a.buffer(I,n,p),a.buffer(I,"int32",l)]}function Oe(e,t,n,r){for(var i=a.util.parseAxisParam(t,n)[0],o=[1,n[0],1],s=0;s<i;s++)o[0]*=n[s];o[1]=n[i];for(s=i+1;s<n.length;s++)o[2]*=n[s];var u={},d=new Int32Array(n[i]),p=new a.TensorBuffer(o,r,e),l=[],c=1===o[0]&&1===o[2];for(s=0;s<n[i];s++){var f=void 0;if(c)f=e[s].toString();else{for(var h=[],m=0;m<o[0];m++)for(var v=0;v<o[2];v++)h.push(p.get(m,s,v));f=h.join(",")}if(void 0!==u[f])d[s]=u[f];else{var k=Object.keys(u).length;u[f]=k,d[s]=k,l.push(s)}}var b=o.slice();b[1]=Object.keys(u).length;var g=new a.TensorBuffer(b,r);l.forEach((function(e,a){for(var t=0;t<o[0];t++)for(var n=0;n<o[2];n++)g.set(p.get(t,e,n),t,a,n)}));var I=n.slice();return I[i]=b[1],{outputValues:g.values,outputShape:I,indices:d}}var Le={__proto__:null,simpleAbsImpl:d,addImpl:x,bincountImpl:M,bincountReduceImpl:A,ceilImpl:z,concatImpl:H,expImpl:E,expm1Impl:B,floorImpl:V,gatherV2Impl:U,greaterImpl:Z,lessImpl:Y,linSpaceImpl:Q,logImpl:X,maxImpl:te,maximumImpl:ne,minimumImpl:oe,multiplyImpl:de,negImpl:fe,notEqualImpl:me,prodImpl:ye,rangeImpl:xe,rsqrtImpl:Te,sliceImpl:Me,squaredDifferenceImpl:_e,stridedSliceImpl:We,subImpl:Ce,tileImpl:Re,topKImpl:Be,transposeImpl:be,uniqueImpl:Oe};a.registerBackend("cpu",(function(){return new u}),1);var Ve=_(a.Elu,(function(e){return e>=0?e:Math.exp(e)-1})),Ge={kernelName:a.Elu,backendName:"cpu",kernelFunc:Ve};function qe(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,s=r.alpha;o([i],"leakyRelu");for(var u=a.util.sizeFromShape(i.shape),d=n.data.get(i.dataId).values,p=a.util.getTypedArrayFromDType("float32",u),l=0;l<d.length;l++)p[l]=d[l]<0?s*d[l]:d[l];return n.makeTensorInfo(i.shape,"float32",p)}var Ue={kernelName:a.LeakyRelu,backendName:"cpu",kernelFunc:qe},Ze=l((function(e,a){return e<0?a*e:e}));function je(e){var a=e.inputs,t=e.backend,n=a.x,r=a.alpha;o([n,r],"prelu");var i=t.data.get(n.dataId).values,s=t.data.get(r.dataId).values,u=Ze(n.shape,r.shape,i,s,n.dtype),d=u[0],p=u[1];return t.makeTensorInfo(p,n.dtype,d)}var Ke={kernelName:a.Prelu,backendName:"cpu",kernelFunc:je},Ye=_(a.Relu,(function(e){return Math.max(0,e)})),$e={kernelName:a.Relu,backendName:"cpu",kernelFunc:Ye},Je=_(a.Relu6,(function(e){return Math.min(Math.max(0,e),6)})),Qe={kernelName:a.Relu6,backendName:"cpu",kernelFunc:Je};function Xe(e,a,t,n,r){if("linear"===t)return m({inputs:{x:a},backend:e});if("relu"===t)return Ye({inputs:{x:a},backend:e});if("elu"===t)return Ve({inputs:{x:a},backend:e});if("relu6"===t)return Je({inputs:{x:a},backend:e});if("prelu"===t)return je({inputs:{x:a,alpha:n},backend:e});if("leakyrelu"===t)return qe({inputs:{x:a},backend:e,attrs:{alpha:r}});throw new Error("Activation "+t+" has not been implemented for the CPU backend.")}function ea(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,o=r.shape,s=a.util.sizeFromShape(i.shape),u=a.util.inferFromImplicitShape(o,s),d=a.util.sizeFromShape(u);a.util.assert(s===d,(function(){return"The new shape ("+u+") has "+d+" elements and the old shape ("+i.shape+") has "+s+" elements. The new shape and old shape must have the same number of elements."})),n.incRef(i.dataId);var p=n.data.get(i.dataId);if(null!=p.complexTensorInfos){var l=p.complexTensorInfos.real,c=p.complexTensorInfos.imag;l.shape=u,c.shape=u}return{dataId:i.dataId,shape:u,dtype:i.dtype}}var aa={kernelName:a.Reshape,backendName:"cpu",kernelFunc:ea};function ta(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.a,s=t.b,u=r.transposeA,d=r.transposeB;o([i,s],"matMul");var p=i.shape.length,l=s.shape.length,c=u?i.shape[p-2]:i.shape[p-1],f=d?s.shape[l-1]:s.shape[l-2],h=u?i.shape[p-1]:i.shape[p-2],m=d?s.shape[l-2]:s.shape[l-1],v=i.shape.slice(0,-2),k=s.shape.slice(0,-2),b=a.util.sizeFromShape(v),g=a.util.sizeFromShape(k),I=b===g||1===b||1===g;a.util.assert(p>=2&&l>=2&&I,(function(){return"Error in matMul: the input batch dimensions must either be the same or at least one input batch dimension must be 1. Got input batch dimensions of ("+v+") and ("+k+")."}));var y=(b>g?i.shape.slice(0,-2):s.shape.slice(0,-2)).concat([h,m]);a.util.assert(c===f,(function(){return"Error in matMul: inner shapes ("+c+") and ("+f+") of Tensors with shapes "+i.shape+" and "+s.shape+" and transposeA="+u+" and transposeB="+d+" must match."}));for(var N=d?[g,m,f]:[g,f,m],x=ea({inputs:{x:i},backend:n,attrs:{shape:u?[b,c,h]:[b,h,c]}}),T=ea({inputs:{x:s},backend:n,attrs:{shape:N}}),S=u?x.shape[1]:x.shape[2],F=u?x.shape[2]:x.shape[1],M=d?T.shape[1]:T.shape[2],A=Math.max(b,g),D=n.data.get(x.dataId).values,_=n.data.get(T.dataId).values,w=a.util.computeStrides(x.shape),z=a.util.computeStrides(T.shape),W=u?[w[0],1,w[1]]:[w[0],w[1],1],C=W[0],H=W[1],E=W[2],P=d?[1,z[1],z[0]]:[z[1],1,z[0]],R=P[0],B=P[1],O=P[2],L=F*M,V=a.buffer([A,F,M],x.dtype),G=V.values,q=n.blockSize,U=0;U<A;U++)for(var Z=0;Z<F;Z+=q)for(var j=0;j<M;j+=q)for(var K=0;K<S;K+=q)for(var Y=Math.min(Z+q,F),$=Math.min(j+q,M),J=Math.min(K+q,S),Q=Z;Q<Y;Q++)for(var X=j;X<$;X++){for(var ee=0,ae=K;ae<J;ae++){var te=Math.min(U,b-1)*C,ne=Math.min(U,g-1)*O;ee+=D[te+Q*H+ae*E]*_[ae*R+X*B+ne]}G[U*L+(Q*M+X)]+=ee}return n.disposeIntermediateTensorInfo(x),n.disposeIntermediateTensorInfo(T),n.makeTensorInfo(y,V.dtype,V.values)}var na={kernelName:a.BatchMatMul,backendName:"cpu",kernelFunc:ta};var ra={kernelName:a._FusedMatMul,backendName:"cpu",kernelFunc:function(e){var a,t,n,r=e.inputs,i=e.backend,o=e.attrs,s=r.a,u=r.b,d=r.bias,p=r.preluActivationWeights,l=o.transposeA,c=o.transposeB,f=o.activation,h=o.leakyreluAlpha,m=[];a=ta({inputs:{a:s,b:u},attrs:{transposeA:l,transposeB:c},backend:i}),d&&(t=S({inputs:{a:a,b:d},backend:i}),m.push(a),a=t),f&&(n=Xe(i,a,f,p,h),m.push(a),a=n);for(var v=0,k=m;v<k.length;v++){var b=k[v];i.disposeIntermediateTensorInfo(b)}return a}},ia=_(a.Acos,(function(e){return Math.acos(e)})),oa={kernelName:a.Acos,backendName:"cpu",kernelFunc:ia},sa=_(a.Acosh,(function(e){return Math.acosh(e)})),ua={kernelName:a.Acosh,backendName:"cpu",kernelFunc:sa};var da={kernelName:a.AddN,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=t;o(t,"addN");for(var i=r.map((function(e){return n.data.get(e.dataId).values})),s=a.buffer(r[0].shape,r[0].dtype),u=s.values,d=0;d<r.length;d++)for(var p=i[d],l=0;l<u.length;l++)u[l]+=p[l];return n.makeTensorInfo(s.shape,s.dtype,s.values)}};var pa={kernelName:a.All,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,s=r.axis,u=r.keepDims;o(i,"all");var d=a.util.parseAxisParam(s,i.shape),p=d,l=a.backend_util.getAxesPermutation(p,i.shape.length),c=i;null!=l&&(c=ge({inputs:{x:i},backend:n,attrs:{perm:l}}),p=a.backend_util.getInnerMostAxes(p.length,i.shape.length)),a.backend_util.assertAxesAreInnerMostDims("all",p,c.shape.length);for(var f=a.backend_util.computeOutAndReduceShapes(c.shape,p),h=f[0],m=f[1],v=a.util.sizeFromShape(m),k=a.util.makeZerosTypedArray(a.util.sizeFromShape(h),c.dtype),b=n.data.get(c.dataId).values,g=0;g<k.length;++g){for(var I=g*v,y=b[I],N=0;N<v;++N){var x=b[I+N];y=y&&x}k[g]=y}null!=l&&n.disposeIntermediateTensorInfo(c);var T=n.makeTensorInfo(h,c.dtype,k);if(u){var S=ea({inputs:{x:T},backend:n,attrs:{shape:a.backend_util.expandShapeToKeepDim(h,d)}});return n.disposeIntermediateTensorInfo(T),S}return T}};var la={kernelName:a.Any,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,s=r.axis,u=r.keepDims;o(i,"any");var d=a.util.parseAxisParam(s,i.shape),p=d,l=a.backend_util.getAxesPermutation(p,i.shape.length),c=i;null!=l&&(c=ge({inputs:{x:i},backend:n,attrs:{perm:l}}),p=a.backend_util.getInnerMostAxes(p.length,i.shape.length)),a.backend_util.assertAxesAreInnerMostDims("any",p,c.shape.length);for(var f=a.backend_util.computeOutAndReduceShapes(c.shape,p),h=f[0],m=f[1],v=a.util.sizeFromShape(m),k=a.util.makeZerosTypedArray(a.util.sizeFromShape(h),c.dtype),b=n.data.get(c.dataId).values,g=0;g<k.length;++g){for(var I=g*v,y=b[I],N=0;N<v;++N){var x=b[I+N];y=y||x}k[g]=y}null!=l&&n.disposeIntermediateTensorInfo(c);var T=n.makeTensorInfo(h,c.dtype,k);if(u){var S=ea({inputs:{x:T},backend:n,attrs:{shape:a.backend_util.expandShapeToKeepDim(h,d)}});return n.disposeIntermediateTensorInfo(T),S}return T}};var ca={kernelName:a.ArgMax,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,s=r.axis;o(i,"argMax");var u=a.util.parseAxisParam(s,i.shape),d=a.backend_util.getAxesPermutation(u,i.shape.length),p=i,l=[];null!=d&&(p=ge({inputs:{x:i},backend:n,attrs:{perm:d}}),l.push(p),u=a.backend_util.getInnerMostAxes(u.length,p.shape.length)),u=[u[0]],a.backend_util.assertAxesAreInnerMostDims("argMax",u,p.shape.length);for(var c=a.backend_util.computeOutAndReduceShapes(p.shape,u),f=c[0],h=c[1],m=a.util.sizeFromShape(f),v=a.util.makeZerosTypedArray(m,"int32"),k=a.util.sizeFromShape(h),b=n.data.get(p.dataId).values,g=0;g<v.length;++g){for(var I=g*k,y=b[I],N=0,x=0;x<k;++x){var T=b[I+x];T>y&&(y=T,N=x)}v[g]=N}return l.forEach((function(e){return n.disposeIntermediateTensorInfo(e)})),n.makeTensorInfo(f,"int32",v)}};var fa={kernelName:a.ArgMin,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,s=r.axis;o(i,"argMin");var u=a.util.parseAxisParam(s,i.shape),d=a.backend_util.getAxesPermutation(u,i.shape.length),p=i,l=[];null!=d&&(p=ge({inputs:{x:i},backend:n,attrs:{perm:d}}),l.push(p),u=a.backend_util.getInnerMostAxes(u.length,p.shape.length)),u=[u[0]],a.backend_util.assertAxesAreInnerMostDims("argMin",u,p.shape.length);for(var c=a.backend_util.computeOutAndReduceShapes(p.shape,u),f=c[0],h=c[1],m=a.util.sizeFromShape(f),v=a.util.makeZerosTypedArray(m,"int32"),k=a.util.sizeFromShape(h),b=n.data.get(p.dataId).values,g=0;g<v.length;++g){for(var I=g*k,y=b[I],N=0,x=0;x<k;++x){var T=b[I+x];T<y&&(y=T,N=x)}v[g]=N}return l.forEach((function(e){return n.disposeIntermediateTensorInfo(e)})),n.makeTensorInfo(f,"int32",v)}},ha=_(a.Asin,(function(e){return Math.asin(e)})),ma={kernelName:a.Asin,backendName:"cpu",kernelFunc:ha},va=_(a.Asinh,(function(e){return Math.asinh(e)})),ka={kernelName:a.Asinh,backendName:"cpu",kernelFunc:va},ba=_(a.Atan,(function(e){return Math.atan(e)})),ga={kernelName:a.Atan,backendName:"cpu",kernelFunc:ba},Ia=l((function(e,a){return Math.atan2(e,a)})),ya=y(a.Atan2,Ia),Na={kernelName:a.Atan2,backendName:"cpu",kernelFunc:ya},xa=_(a.Atanh,(function(e){return Math.atanh(e)})),Ta={kernelName:a.Atanh,backendName:"cpu",kernelFunc:xa};function Sa(e,t,n,r,i,o){for(var s=i.strideHeight,u=i.strideWidth,d=i.dilationHeight,p=i.dilationWidth,l=i.effectiveFilterHeight,c=i.effectiveFilterWidth,f=i.padInfo.top,h=i.padInfo.left,m="max"===o?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY,v=a.buffer(i.outShape,n),k=v.values,b=i.outShape[1]*i.outShape[2]*i.outShape[3],g=i.outShape[2]*i.outShape[3],I=i.outShape[3],y=0;y<i.batchSize;++y)for(var N=y*b,x=y*r[0],T=0;T<i.inChannels;++T)for(var S=0;S<i.outHeight;++S)for(var F=S*s-f,M=Math.max(0,F),A=Math.min(i.inHeight,l+F),D=N+S*g,_=0;_<i.outWidth;++_){for(var w=_*u-h,z=Math.max(0,w),W=Math.min(i.inWidth,c+w),C=m,H=0,E=0,P=M;P<A;P+=d){for(var R=x+P*r[1],B=z;B<W;B+=p){var O=e[R+B*r[2]+T];"max"===o&&O>C?C=O:"avg"===o&&(H+=O,E++)}if(isNaN(C))break}k[D+_*I+T]="avg"===o?H/E:C}return v}function Fa(e,t,n,r,i,o){void 0===i&&(i=!1),void 0===o&&(o=!1);for(var s=a.buffer(r.outShape,"int32"),u=r.strideHeight,d=r.strideWidth,p=r.dilationHeight,l=r.dilationWidth,c=r.effectiveFilterHeight,f=r.effectiveFilterWidth,h=r.padInfo.top,m=r.padInfo.left,v=a.buffer(t,n,e),k=0;k<r.batchSize;++k)for(var b=0;b<r.inChannels;++b)for(var g=0;g<r.outHeight;++g){for(var I=g*u-h,y=I;y<0;)y+=p;for(var N=Math.min(r.inHeight,c+I),x=0;x<r.outWidth;++x){for(var T=x*d-m,S=T;S<0;)S+=l;for(var F=Math.min(r.inWidth,f+T),M=Number.NEGATIVE_INFINITY,A=-1,D=y;D<N;D+=p)for(var _=D-I,w=S;w<F;w+=l){var z=w-T,W=v.get(k,D,w,b);W>M&&(M=W,A=i?o?((k*r.inHeight+D)*r.inWidth+w)*r.inChannels+b:(D*r.inWidth+w)*r.inChannels+b:_*f+z)}s.set(A,k,g,x,b)}}return s}function Ma(e,t,n,r,i,o){for(var s=i.strideDepth,u=i.strideHeight,d=i.strideWidth,p=i.dilationDepth,l=i.dilationHeight,c=i.dilationWidth,f=i.effectiveFilterDepth,h=i.effectiveFilterHeight,m=i.effectiveFilterWidth,v=i.padInfo.front,k=i.padInfo.top,b=i.padInfo.left,g="max"===o?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY,I=a.buffer(i.outShape,n),y=I.values,N=i.outShape[1]*i.outShape[2]*i.outShape[3]*i.outShape[4],x=i.outShape[2]*i.outShape[3]*i.outShape[4],T=i.outShape[3]*i.outShape[4],S=i.outShape[4],F=0;F<i.batchSize;++F)for(var M=F*N,A=F*r[0],D=0;D<i.inChannels;++D)for(var _=0;_<i.outDepth;++_){for(var w=_*s-v,z=w;z<0;)z+=p;for(var W=Math.min(i.inDepth,f+w),C=M+_*x,H=0;H<i.outHeight;++H){for(var E=H*u-k,P=E;P<0;)P+=l;for(var R=Math.min(i.inHeight,h+E),B=C+H*T,O=0;O<i.outWidth;++O){for(var L=O*d-b,V=L;V<0;)V+=c;for(var G=Math.min(i.inWidth,m+L),q=B+O*S,U=g,Z=0,j=0,K=z;K<W;K+=p){for(var Y=A+K*r[1],$=P;$<R;$+=l){for(var J=Y+$*r[2],Q=V;Q<G;Q+=c){var X=e[J+Q*r[3]+D];if("max"===o&&X>U?U=X:"avg"===o&&(Z+=X,j++),isNaN(U))break}if(isNaN(U))break}if(isNaN(U))break}y[q+D]="avg"===o?Z/j:U}}}return I}var Aa={kernelName:a.AvgPool,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x;o(i,"avgPool");var s=r.filterSize,u=r.strides,d=r.pad,p=r.dimRoundingMode;a.util.assert(a.backend_util.eitherStridesOrDilationsAreOne(u,1),(function(){return"Error in avgPool: Either strides or dilations must be 1. Got strides "+u+" and dilations '1'"}));var l,c=a.backend_util.computePool2DInfo(i.shape,s,u,1,d,p);if(1===c.filterWidth&&1===c.filterHeight&&a.util.arraysEqual(c.inShape,c.outShape))l=m({inputs:{x:i},backend:n});else{var f=n.data.get(i.dataId).values,h=a.util.computeStrides(i.shape),v=Sa(f,i.shape,i.dtype,h,c,"avg");l=n.makeTensorInfo(c.outShape,i.dtype,v.values)}return l}};var Da={kernelName:a.AvgPool3D,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,s=r.filterSize,u=r.strides,d=r.pad,p=r.dimRoundingMode,l=r.dataFormat;o(i,"avgPool3d");var c=a.backend_util.computePool3DInfo(i.shape,s,u,1,d,p,l),f=Ma(n.data.get(i.dataId).values,i.shape,i.dtype,a.util.computeStrides(i.shape),c,"avg");return n.makeTensorInfo(f.shape,"float32",f.values)}};var _a={kernelName:a.AvgPool3DGrad,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.dy,s=t.input,u=r.filterSize,d=r.strides,p=r.pad,l=r.dimRoundingMode;o([i,s],"avgPool3DGrad");for(var c=a.backend_util.computePool3DInfo(s.shape,u,d,1,p,l),f=c.strideDepth,h=c.strideHeight,m=c.strideWidth,v=c.filterDepth,k=c.filterHeight,b=c.filterWidth,g=c.dilationDepth,I=c.dilationHeight,y=c.dilationWidth,N=c.effectiveFilterDepth,x=c.effectiveFilterHeight,T=c.effectiveFilterWidth,S=N-1-c.padInfo.front,F=T-1-c.padInfo.left,M=x-1-c.padInfo.top,A=a.buffer(s.shape,"float32"),D=1/(v*k*b),_=n.bufferSync(i),w=0;w<c.batchSize;++w)for(var z=0;z<c.inChannels;++z)for(var W=0;W<c.inDepth;++W)for(var C=0;C<c.inHeight;++C)for(var H=0;H<c.inWidth;++H){for(var E=W-S,P=C-M,R=H-F,B=0,O=0;O<N;O+=g){var L=(E+O)/f;if(!(L<0||L>=c.outDepth||Math.floor(L)!==L))for(var V=0;V<x;V+=I){var G=(P+V)/h;if(!(G<0||G>=c.outHeight||Math.floor(G)!==G))for(var q=0;q<T;q+=y){var U=(R+q)/m;if(!(U<0||U>=c.outWidth||Math.floor(U)!==U))B+=_.get(w,L,G,U,z)}}}A.set(B*D,w,W,C,H,z)}return n.makeTensorInfo(A.shape,A.dtype,A.values)}};var wa={kernelName:a.AvgPoolGrad,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.dy,s=t.input,u=s;o([i,s],"avgPoolGrad");for(var d=r.filterSize,p=r.strides,l=r.pad,c=a.backend_util.computePool2DInfo(u.shape,d,p,1,l),f=c.strideHeight,h=c.strideWidth,m=c.filterHeight,v=c.filterWidth,k=c.dilationHeight,b=c.dilationWidth,g=c.effectiveFilterHeight,I=c.effectiveFilterWidth,y=I-1-c.padInfo.left,N=g-1-c.padInfo.top,x=a.buffer(u.shape,"float32"),T=1/(m*v),S=n.data.get(i.dataId).values,F=a.buffer(i.shape,"float32",S),M=0;M<c.batchSize;++M)for(var A=0;A<c.inChannels;++A)for(var D=0;D<c.inHeight;++D)for(var _=0;_<c.inWidth;++_){for(var w=D-N,z=_-y,W=0,C=0;C<g;C+=k){var H=(w+C)/f;if(!(H<0||H>=c.outHeight||Math.floor(H)!==H))for(var E=0;E<I;E+=b){var P=(z+E)/h;if(!(P<0||P>=c.outWidth||Math.floor(P)!==P))W+=F.get(M,H,P,A)}}x.set(W*T,M,D,_,A)}return n.makeTensorInfo(x.shape,x.dtype,x.values)}};var za={kernelName:a.FusedBatchNorm,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,s=t.scale,u=t.offset,d=t.mean,p=t.variance;a.util.assert(d.shape.length===p.shape.length,(function(){return"Batch normalization gradient requires mean and variance to have equal ranks."})),a.util.assert(null==u||d.shape.length===u.shape.length,(function(){return"Batch normalization gradient requires mean and offset to have equal ranks."})),a.util.assert(null==s||d.shape.length===s.shape.length,(function(){return"Batch normalization gradient requires mean and scale to have equal ranks."})),o([i,d,p,s,u],"batchNorm");var l=r.varianceEpsilon;null==l&&(l=.001);for(var c=n.data.get(i.dataId).values,f=n.data.get(d.dataId).values,h=n.data.get(p.dataId).values,m=s?n.data.get(s.dataId).values:new Float32Array([1]),v=u?n.data.get(u.dataId).values:new Float32Array([0]),k=new Float32Array(c.length),b=v.length,g=m.length,I=h.length,y=f.length,N=0,x=0,T=0,S=0,F=0;F<c.length;++F)k[F]=v[N++]+(c[F]-f[x++])*m[T++]/Math.sqrt(h[S++]+l),N>=b&&(N=0),x>=y&&(x=0),T>=g&&(T=0),S>=I&&(S=0);return n.makeTensorInfo(i.shape,i.dtype,k)}};var Wa={kernelName:a.BatchToSpaceND,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,s=r.blockShape,u=r.crops;o([i],"batchToSpaceND");var d=s.reduce((function(e,a){return e*a})),p=a.backend_util.getReshaped(i.shape,s,d),l=a.backend_util.getPermuted(p.length,s.length),c=a.backend_util.getReshapedPermuted(i.shape,s,d),f=a.backend_util.getSliceBeginCoords(u,s.length),h=a.backend_util.getSliceSize(c,u,s.length),m=ea({inputs:{x:i},backend:n,attrs:{shape:p}}),v=ge({inputs:{x:m},backend:n,attrs:{perm:l}}),k=ea({inputs:{x:v},backend:n,attrs:{shape:c}}),b=Ae({inputs:{x:k},backend:n,attrs:{begin:f,size:h}});return n.disposeIntermediateTensorInfo(m),n.disposeIntermediateTensorInfo(v),n.disposeIntermediateTensorInfo(k),b}};var Ca={kernelName:a.Bincount,backendName:"cpu",kernelFunc:function(e){var a=e.inputs,t=e.backend,n=e.attrs,r=a.x,i=a.weights,o=n.size,s=M(t.data.get(r.dataId).values,t.data.get(i.dataId).values,i.dtype,i.shape,o);return t.makeTensorInfo([o],i.dtype,s)}},Ha=_(a.ClipByValue,(function(e,a){var t=a;return e>t.clipValueMax?t.clipValueMax:e<t.clipValueMin?t.clipValueMin:e})),Ea={kernelName:a.ClipByValue,backendName:"cpu",kernelFunc:Ha},Pa={kernelName:a.ComplexAbs,backendName:"cpu",kernelFunc:function(e){for(var t=e.inputs.x,n=e.backend,r=new Float32Array(a.util.sizeFromShape(t.shape)),i=n.data.get(t.dataId),o=i.complexTensorInfos.real,s=i.complexTensorInfos.imag,u=n.data.get(o.dataId).values,d=n.data.get(s.dataId).values,p=0;p<u.length;p++){var l=u[p],c=d[p];r[p]=Math.hypot(l,c)}return n.makeOutput(r,t.shape,"float32")}};function Ra(e){var a=e.inputs,t=e.backend,n=a.input,r=t.data.get(n.dataId).complexTensorInfos.imag,i=t.data.get(r.dataId).values;return t.makeTensorInfo(r.shape,r.dtype,i)}var Ba={kernelName:a.Imag,backendName:"cpu",kernelFunc:Ra};function Oa(e){var t=e.inputs,n=e.backend,r=e.attrs.axis,i=a.util.parseAxisParam(r,t[0].shape)[0],o=a.backend_util.computeOutShape(t.map((function(e){return e.shape})),i);if(0===a.util.sizeFromShape(o))return n.makeTensorInfo(o,t[0].dtype,[]);var s=t.filter((function(e){return a.util.sizeFromShape(e.shape)>0}));if(1===s.length)return m({inputs:{x:s[0]},backend:n});var u=s.map((function(e){return e.shape}));if(a.backend_util.assertParamsConsistent(u,i),"complex64"===s[0].dtype){var d=s.map((function(e){return k({inputs:{input:e},backend:n})})),p=s.map((function(e){return Ra({inputs:{input:e},backend:n})})),l=Oa({inputs:d,backend:n,attrs:{axis:i}}),f=Oa({inputs:p,backend:n,attrs:{axis:i}}),h=c({inputs:{real:l,imag:f},backend:n});return d.forEach((function(e){return n.disposeIntermediateTensorInfo(e)})),p.forEach((function(e){return n.disposeIntermediateTensorInfo(e)})),n.disposeIntermediateTensorInfo(l),n.disposeIntermediateTensorInfo(f),h}var v=s.map((function(e){var t=a.util.sizeFromShape(e.shape.slice(i));return ea({inputs:{x:e},backend:n,attrs:{shape:[-1,t]}})})),b=v.map((function(e){return{vals:n.data.get(e.dataId).values,shape:e.shape}}));o=a.backend_util.computeOutShape(v.map((function(e){return e.shape})),1);var g=1===v[0].shape[0],I=H(b,o,t[0].dtype,g),y=a.backend_util.computeOutShape(s.map((function(e){return e.shape})),i),N=n.makeTensorInfo(y,t[0].dtype,I);return v.forEach((function(e){return n.disposeIntermediateTensorInfo(e)})),N}var La={kernelName:a.Concat,backendName:"cpu",kernelFunc:Oa};function Va(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,s=t.filter,u=r.strides,d=r.pad,p=r.dataFormat,l=r.dilations,c=r.dimRoundingMode;o([i,s],"conv2d");for(var f=a.backend_util.convertConv2DDataFormat(p),h=a.backend_util.computeConv2DInfo(i.shape,s.shape,u,l,d,c,!1,f),m=h.filterHeight,v=h.filterWidth,k=h.dilationHeight,b=h.dilationWidth,g=h.padInfo.left,I=h.padInfo.top,y="channelsLast"===h.dataFormat,N=new a.TensorBuffer(h.outShape,i.dtype),x=a.util.computeStrides(i.shape),T=a.util.computeStrides(s.shape),S=x[0],F=y?x[1]:x[2],M=y?x[2]:1,A=y?1:x[1],D=N.strides[0],_=y?N.strides[1]:N.strides[2],w=y?N.strides[2]:1,z=y?1:N.strides[1],W=n.data.get(i.dataId).values,C=n.data.get(s.dataId).values,H=N.values,E=0;E<h.batchSize;++E)for(var P=E*S,R=E*D,B=0;B<h.outHeight;++B)for(var O=R+B*_,L=B*h.strideHeight-I,V=0;V<m;++V){var G=L+V*k;if(!(G<0||G>=h.inHeight))for(var q=V*T[0],U=P+G*F,Z=0;Z<h.outWidth;++Z)for(var j=O+Z*w,K=Z*h.strideWidth-g,Y=0;Y<v;++Y){var $=K+Y*b;if(!($<0||$>=h.inWidth))for(var J=U+$*M,Q=q+Y*T[1],X=0;X<h.inChannels;++X){for(var ee=W[J+X*A],ae=0;ae<h.outChannels;++ae)H[j+ae*z]+=ee*C[Q+ae];Q+=h.outChannels}}}return n.makeTensorInfo(N.shape,N.dtype,H)}var Ga={kernelName:a.Conv2D,backendName:"cpu",kernelFunc:Va};var qa={kernelName:a.Conv2DBackpropFilter,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,s=t.dy,u=r.strides,d=r.pad,p=r.dataFormat,l=r.dimRoundingMode,c=r.filterShape;o([i,s],"conv2dBackpropFilter");for(var f=a.backend_util.convertConv2DDataFormat(p),h=a.backend_util.computeConv2DInfo(i.shape,c,u,1,d,l,!1,f),m=h.strideHeight,v=h.strideWidth,k=h.filterHeight,b=h.filterWidth,g="channelsLast"===h.dataFormat,I=new a.TensorBuffer(h.filterShape,"float32"),y=h.padInfo.left,N=h.padInfo.top,x=n.data.get(i.dataId).values,T=n.data.get(s.dataId).values,S=new a.TensorBuffer(i.shape,i.dtype,x),F=new a.TensorBuffer(s.shape,s.dtype,T),M=0;M<k;++M)for(var A=Math.max(0,Math.ceil((N-M)/m)),D=Math.min(h.outHeight,(h.inHeight+N-M)/m),_=0;_<b;++_)for(var w=Math.max(0,Math.ceil((y-_)/v)),z=Math.min(h.outWidth,(h.inWidth+y-_)/v),W=0;W<h.inChannels;++W)for(var C=0;C<h.outChannels;++C){for(var H=0,E=0;E<h.batchSize;++E)for(var P=A;P<D;++P)for(var R=M+P*m-N,B=w;B<z;++B){var O=_+B*v-y;H+=g?S.get(E,R,O,W)*F.get(E,P,B,C):S.get(E,W,R,O)*F.get(E,C,P,B)}I.set(H,M,_,W,C)}return n.makeTensorInfo(I.shape,I.dtype,I.values)}};var Ua={kernelName:a.Conv2DBackpropInput,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.dy,s=t.filter,u=r.inputShape,d=r.strides,p=r.pad,l=r.dataFormat,c=r.dimRoundingMode;o([i,s],"conv2dBackpropInput");var f=a.util.computeStrides(s.shape),h=a.util.computeStrides(i.shape),m=a.backend_util.convertConv2DDataFormat(l),v=a.backend_util.computeConv2DInfo(u,s.shape,d,1,p,c,!1,m),k=new a.TensorBuffer(v.inShape,"float32"),b=k.values,g=n.data.get(i.dataId).values,I=n.data.get(s.dataId).values,y=f[0],N=f[1],x=f[2],T=v.batchSize,S=v.filterHeight,F=v.filterWidth,M=v.inChannels,A=v.inHeight,D=v.inWidth,_=v.outChannels,w=v.outHeight,z=v.outWidth,W=v.strideHeight,C=v.strideWidth;m=v.dataFormat;for(var H=S-1-v.padInfo.top,E=F-1-v.padInfo.left,P="channelsLast"===m,R=k.strides[0],B=P?k.strides[1]:k.strides[2],O=P?k.strides[2]:1,L=P?1:k.strides[1],V=h[0],G=P?h[1]:h[2],q=P?h[2]:1,U=P?1:h[1],Z=0;Z<T;++Z)for(var j=0;j<M;++j)for(var K=0;K<A;++K)for(var Y=K-H,$=Math.max(0,Math.ceil(Y/W)),J=Math.min(w,(S+Y)/W),Q=0;Q<D;++Q){for(var X=Q-E,ee=Math.max(0,Math.ceil(X/C)),ae=Math.min(z,(F+X)/C),te=0,ne=$;ne<J;++ne)for(var re=ne*W-Y,ie=ee;ie<ae;++ie)for(var oe=V*Z+G*ne+q*ie,se=y*(S-1-re)+N*(F-1-(ie*C-X))+x*j,ue=0;ue<_;++ue){te+=g[oe+U*ue]*I[se+ue]}b[R*Z+B*K+O*Q+L*j]=te}return n.makeTensorInfo(k.shape,k.dtype,k.values)}};var Za={kernelName:a.Conv3D,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,s=t.filter,u=r.strides,d=r.pad,p=r.dilations;o([i,s],"conv3d");for(var l=a.backend_util.computeConv3DInfo(i.shape,s.shape,u,p,d),c=l.filterDepth,f=l.filterHeight,h=l.filterWidth,m=l.dilationDepth,v=l.dilationHeight,k=l.dilationWidth,b=l.padInfo,g=b.front,I=b.left,y=b.top,N=new a.TensorBuffer(l.outShape,i.dtype),x=n.data.get(i.dataId).values,T=n.data.get(s.dataId).values,S=N.values,F=a.util.computeStrides(i.shape),M=a.util.computeStrides(s.shape),A=0;A<l.batchSize;++A)for(var D=A*F[0],_=A*N.strides[0],w=0;w<l.outDepth;++w)for(var z=_+w*N.strides[1],W=w*l.strideDepth-g,C=0;C<c;++C){var H=W+C*m;if(!(H<0||H>=l.inDepth))for(var E=C*M[0],P=D+H*F[1],R=0;R<l.outHeight;++R)for(var B=z+R*N.strides[2],O=R*l.strideHeight-y,L=0;L<f;++L){var V=O+L*v;if(!(V<0||V>=l.inHeight))for(var G=E+L*M[1],q=P+V*F[2],U=0;U<l.outWidth;++U)for(var Z=B+U*l.outChannels,j=U*l.strideWidth-I,K=0;K<h;++K){var Y=j+K*k;if(!(Y<0||Y>=l.inWidth))for(var $=G+K*M[2],J=q+Y*l.inChannels,Q=$,X=0;X<l.inChannels;++X){for(var ee=x[J+X],ae=0;ae<l.outChannels;++ae)S[Z+ae]+=ee*T[Q+ae];Q+=l.outChannels}}}}return n.makeTensorInfo(N.shape,N.dtype,N.values)}};var ja={kernelName:a.Conv3DBackpropFilterV2,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,s=t.dy,u=r.strides,d=r.pad,p=r.filterShape;o([i,s],"conv3dBackpropFilterV2");for(var l=a.util.computeStrides(i.shape),c=a.util.computeStrides(s.shape),f=a.backend_util.computeConv3DInfo(i.shape,p,u,1,d),h=f.strideDepth,m=f.strideHeight,v=f.strideWidth,k=f.filterDepth,b=f.filterHeight,g=f.filterWidth,I=new a.TensorBuffer(f.filterShape,"float32"),y=I.values,N=I.strides,x=N[0],T=N[1],S=N[2],F=N[3],M=n.data.get(s.dataId).values,A=c[0],D=c[1],_=c[2],w=c[3],z=n.data.get(i.dataId).values,W=l[0],C=l[1],H=l[2],E=l[3],P=f.padInfo.front,R=f.padInfo.left,B=f.padInfo.top,O=0;O<k;++O)for(var L=Math.max(0,Math.ceil((P-O)/h)),V=Math.min(f.outDepth,(f.inDepth+P-O)/h),G=O*x,q=0;q<b;++q)for(var U=Math.max(0,Math.ceil((B-q)/m)),Z=Math.min(f.outHeight,(f.inHeight+B-q)/m),j=q*T+G,K=0;K<g;++K)for(var Y=Math.max(0,Math.ceil((R-K)/v)),$=Math.min(f.outWidth,(f.inWidth+R-K)/v),J=K*S+j,Q=0;Q<f.inChannels;++Q)for(var X=Q*F+J,ee=0;ee<f.outChannels;++ee){for(var ae=0,te=0;te<f.batchSize;++te)for(var ne=te*W,re=te*A,ie=L;ie<V;++ie)for(var oe=(O+ie*h-P)*C+ne,se=ie*D+re,ue=U;ue<Z;++ue)for(var de=(q+ue*m-B)*H+oe,pe=ue*_+se,le=Y;le<$;++le){var ce=le*w+pe;ae+=z[(K+le*v-R)*E+de+Q]*M[ce+ee]}y[X+ee]=ae}return n.makeTensorInfo(I.shape,I.dtype,I.values)}};var Ka={kernelName:a.Conv3DBackpropInputV2,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.dy,s=t.filter,u=r.pad,d=r.strides,p=r.inputShape;o([i],"conv3dBackpropInputV2");for(var l=a.util.computeStrides(i.shape),c=a.util.computeStrides(s.shape),f=a.backend_util.computeConv3DInfo(p,s.shape,d,1,u),h=new a.TensorBuffer(f.inShape,"float32"),m=h.values,v=h.strides,k=v[0],b=v[1],g=v[2],I=v[3],y=n.data.get(i.dataId).values,N=l[0],x=l[1],T=l[2],S=l[3],F=n.data.get(s.dataId).values,M=c[0],A=c[1],D=c[2],_=c[3],w=f.batchSize,z=f.filterDepth,W=f.filterHeight,C=f.filterWidth,H=f.inChannels,E=f.inDepth,P=f.inHeight,R=f.inWidth,B=f.outChannels,O=f.outDepth,L=f.outHeight,V=f.outWidth,G=f.strideDepth,q=f.strideHeight,U=f.strideWidth,Z=z-1-f.padInfo.front,j=W-1-f.padInfo.top,K=C-1-f.padInfo.left,Y=0;Y<w;++Y)for(var $=0;$<H;++$)for(var J=0;J<E;++J)for(var Q=J-Z,X=Math.max(0,Math.ceil(Q/G)),ee=Math.min(O,(z+Q)/G),ae=0;ae<P;++ae)for(var te=ae-j,ne=Math.max(0,Math.ceil(te/q)),re=Math.min(L,(W+te)/q),ie=0;ie<R;++ie){for(var oe=ie-K,se=Math.max(0,Math.ceil(oe/U)),ue=Math.min(V,(C+oe)/U),de=0,pe=X;pe<ee;++pe)for(var le=pe*G-Q,ce=ne;ce<re;++ce)for(var fe=ce*q-te,he=se;he<ue;++he)for(var me=N*Y+x*pe+T*ce+S*he,ve=M*(z-1-le)+A*(W-1-fe)+D*(C-1-(he*U-oe))+_*$,ke=0;ke<B;++ke){de+=y[me+ke]*F[ve+ke]}m[k*Y+b*J+g*ae+I*ie+$]=de}return n.makeTensorInfo(h.shape,h.dtype,h.values)}},Ya=_(a.Cos,(function(e){return Math.cos(e)})),$a={kernelName:a.Cos,backendName:"cpu",kernelFunc:Ya},Ja=_(a.Cosh,(function(e){return Math.cosh(e)})),Qa={kernelName:a.Cosh,backendName:"cpu",kernelFunc:Ja};var Xa={kernelName:a.CropAndResize,backendName:"cpu",kernelFunc:function(e){for(var t=e.inputs,n=e.backend,r=e.attrs,i=t.image,o=t.boxes,s=t.boxInd,u=r.cropSize,d=r.method,p=r.extrapolationValue,l=i.shape,c=l[0],f=l[1],h=l[2],m=l[3],v=o.shape[0],k=u[0],b=u[1],g=a.buffer([v,k,b,m],"float32"),I=n.data.get(o.dataId).values,y=n.data.get(s.dataId).values,N=n.data.get(i.dataId).values,x=a.util.computeStrides(i.shape),T=a.util.computeStrides(g.shape),S=0;S<v;S++){var F=4*S,M=I[F],A=I[F+1],D=I[F+2],_=I[F+3],w=y[S];if(!(w>=c))for(var z=k>1?(D-M)*(f-1)/(k-1):0,W=b>1?(_-A)*(h-1)/(b-1):0,C=0;C<k;C++){var H=k>1?M*(f-1)+C*z:.5*(M+D)*(f-1);if(H<0||H>f-1)for(var E=0;E<b;E++)for(var P=0;P<m;P++){var R=P+E*T[2]+C*T[1]+S*T[0];g.values[R]=p}else if("bilinear"===d){var B=Math.floor(H),O=Math.ceil(H),L=H-B;for(E=0;E<b;E++){if(($=b>1?A*(h-1)+E*W:.5*(A+_)*(h-1))<0||$>h-1)for(P=0;P<m;P++){R=P+E*T[2]+C*T[1]+S*T[0];g.values[R]=p}else{var V=Math.floor($),G=Math.ceil($),q=$-V;for(P=0;P<m;P++){var U=N[R=P+V*x[2]+B*x[1]+w*x[0]],Z=N[R=P+G*x[2]+B*x[1]+w*x[0]],j=N[R=P+V*x[2]+O*x[1]+w*x[0]],K=U+(Z-U)*q,Y=j+(N[R=P+G*x[2]+O*x[1]+w*x[0]]-j)*q;R=P+E*T[2]+C*T[1]+S*T[0],g.values[R]=K+(Y-K)*L}}}}else for(E=0;E<b;++E){var $;if(($=b>1?A*(h-1)+E*W:.5*(A+_)*(h-1))<0||$>h-1)for(P=0;P<m;P++){R=P+E*T[2]+C*T[1]+S*T[0];g.values[R]=p}else{var J=Math.round($),Q=Math.round(H);for(P=0;P<m;P++){var X=P+J*x[2]+Q*x[1]+w*x[0],ee=P+E*T[2]+C*T[1]+S*T[0];g.values[ee]=N[X]}}}}}return n.makeTensorInfo(g.shape,g.dtype,g.values)}};var et={kernelName:a.Cumsum,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,s=r.axis,u=r.exclusive,d=r.reverse;o(i,"cumsum");var p=a.backend_util.getAxesPermutation([s],i.shape.length),l=i;null!=p&&(l=ge({inputs:{x:i},backend:n,attrs:{perm:p}}));var c=a.backend_util.getInnerMostAxes(1,i.shape.length)[0];if(c!==l.shape.length-1)throw new Error("backend.cumsum in CPU expects an inner-most axis="+(l.shape.length-1)+" but got axis="+c);for(var f=a.upcastType(l.dtype,"int32"),h=a.util.makeZerosTypedArray(a.util.sizeFromShape(l.shape),f),m=n.data.get(l.dataId).values,v=l.shape[l.shape.length-1],k=d?function(e,a){return e+v-a-1}:function(e,a){return e+a},b=0;b<m.length;b+=v)for(var g=0;g<v;g++){var I=k(b,g);if(0===g)h[I]=u?0:m[I];else{var y=k(b,g-1);h[I]=u?m[y]+h[y]:m[I]+h[y]}}var N=n.makeTensorInfo(l.shape,f,h);if(null!=p){var x=ge({inputs:{x:N},backend:n,attrs:{perm:a.backend_util.getUndoAxesPermutation(p)}});return n.disposeIntermediateTensorInfo(N),n.disposeIntermediateTensorInfo(l),x}return N}};var at={kernelName:a.DenseBincount,backendName:"cpu",kernelFunc:function(e){var a=e.inputs,t=e.backend,n=e.attrs,r=a.x,i=a.weights,o=n.size,s=n.binaryOutput;if(1===r.shape.length){var u=M(t.data.get(r.dataId).values,t.data.get(i.dataId).values,i.dtype,i.shape,o);return t.makeTensorInfo([o],i.dtype,u)}if(2===r.shape.length){var d=A(t.bufferSync(r),t.bufferSync(i),o,s);return t.makeTensorInfo(d.shape,i.dtype,d.values)}throw new Error("Error in denseBincount: input must be at most rank 2, but got rank"+r.shape.length+".")}};var tt={kernelName:a.DepthToSpace,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,o=r.blockSize,s=r.dataFormat;a.util.assert("NHWC"===s,(function(){return"Only NHWC dataFormat supported on CPU for depthToSpace. Got "+s})),a.util.assert(o>1,(function(){return"blockSize should be > 1 for depthToSpace, but was: "+o}));for(var u=i.shape[0],d=i.shape[1],p=i.shape[2],l=i.shape[3],c=d*o,f=p*o,h=l/(o*o),m=n.data.get(i.dataId).values,v=new Float32Array(u*c*f*h),k=0,b=0;b<u;++b)for(var g=0;g<c;++g)for(var I=Math.floor(g/o),y=g%o,N=0;N<f;++N)for(var x=Math.floor(N/o),T=(y*o+N%o)*h,S=0;S<h;++S){var F=S+T+l*(x+p*(I+d*b));v[k++]=m[F]}return n.makeTensorInfo([u,c,f,h],i.dtype,v)}};function nt(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,s=t.filter,u=r.strides,d=r.pad,p=r.dilations,l=r.dimRoundingMode;o([i,s],"depthwiseConv2DNative");var c=a.util.computeStrides(i.shape),f=a.util.computeStrides(s.shape),h=p;null==h&&(h=[1,1]),a.util.assert(a.backend_util.eitherStridesOrDilationsAreOne(u,h),(function(){return"Error in depthwiseConv2d: Either strides or dilations must be 1. Got strides "+u+" and dilations '"+h+"'"}));for(var m=a.backend_util.computeConv2DInfo(i.shape,s.shape,u,h,d,l,!0),v=m.filterHeight,k=m.filterWidth,b=m.dilationHeight,g=m.dilationWidth,I=m.padInfo,y=I.left,N=I.top,x=m.outChannels/m.inChannels,T=new a.TensorBuffer(m.outShape,i.dtype),S=n.data.get(i.dataId).values,F=n.data.get(s.dataId).values,M=T.values,A=0;A<m.batchSize;++A)for(var D=A*c[0],_=A*T.strides[0],w=0;w<m.outHeight;++w)for(var z=_+w*T.strides[1],W=w*m.strideHeight-y,C=0;C<v;++C){var H=W+C*b;if(!(H<0||H>=m.inHeight))for(var E=C*f[0],P=D+H*c[1],R=0;R<m.outWidth;++R)for(var B=z+R*T.strides[2],O=R*m.strideWidth-N,L=0;L<k;++L){var V=O+L*g;if(!(V<0||V>=m.inWidth))for(var G=E+L*f[1],q=P+V*m.inChannels,U=B,Z=G,j=0;j<m.inChannels;++j){for(var K=S[q+j],Y=0;Y<x;++Y)M[U+Y]+=K*F[Z+Y];U+=x,Z+=x}}}return n.makeTensorInfo(T.shape,T.dtype,T.values)}var rt={kernelName:a.DepthwiseConv2dNative,backendName:"cpu",kernelFunc:nt};var it={kernelName:a.DepthwiseConv2dNativeBackpropFilter,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,s=t.dy,u=r.strides,d=r.dilations,p=r.pad,l=r.dimRoundingMode,c=r.filterShape;o([i,s],"depthwiseConv2dNativeBackpropFilter");for(var f=a.backend_util.computeConv2DInfo(i.shape,c,u,d,p,l,!0),h=f.strideHeight,m=f.strideWidth,v=f.filterHeight,k=f.filterWidth,b=new a.TensorBuffer(f.filterShape,"float32"),g=f.padInfo.left,I=f.padInfo.top,y=f.outChannels/f.inChannels,N=n.data.get(i.dataId).values,x=new a.TensorBuffer(i.shape,i.dtype,N),T=n.data.get(s.dataId).values,S=new a.TensorBuffer(s.shape,s.dtype,T),F=0;F<v;++F)for(var M=Math.max(0,Math.ceil((I-F)/h)),A=Math.min(f.outHeight,(f.inHeight+I-F)/h),D=0;D<k;++D)for(var _=Math.max(0,Math.ceil((g-D)/m)),w=Math.min(f.outWidth,(f.inWidth+g-D)/m),z=0;z<f.outChannels;++z){for(var W=Math.trunc(z/y),C=z%y,H=0,E=0;E<f.batchSize;++E)for(var P=M;P<A;++P)for(var R=F+P*h-I,B=_;B<w;++B){var O=D+B*m-g;H+=x.get(E,R,O,W)*S.get(E,P,B,z)}b.set(H,F,D,W,C)}return n.makeTensorInfo(b.shape,b.dtype,b.values)}};var ot={kernelName:a.DepthwiseConv2dNativeBackpropInput,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.dy,s=t.filter,u=r.strides,d=r.dilations,p=r.pad,l=r.dimRoundingMode,c=r.inputShape;o([i,s],"depthwiseConv2DNativeBackpropInput");for(var f=a.util.computeStrides(i.shape),h=a.util.computeStrides(s.shape),m=a.backend_util.computeConv2DInfo(c,s.shape,u,d,p,l,!0),v=new a.TensorBuffer(m.inShape,"float32"),k=v.values,b=v.strides,g=b[0],I=b[1],y=b[2],N=n.data.get(i.dataId).values,x=f[0],T=f[1],S=f[2],F=n.data.get(s.dataId).values,M=h[0],A=h[1],D=h[2],_=m.batchSize,w=m.filterHeight,z=m.filterWidth,W=m.inChannels,C=m.inHeight,H=m.inWidth,E=m.outChannels,P=m.outHeight,R=m.outWidth,B=m.strideHeight,O=m.strideWidth,L=w-1-m.padInfo.top,V=z-1-m.padInfo.left,G=E/W,q=0;q<_;++q)for(var U=0;U<W;++U)for(var Z=0;Z<C;++Z)for(var j=Z-L,K=Math.max(0,Math.ceil(j/B)),Y=Math.min(P,(w+j)/B),$=0;$<H;++$){for(var J=$-V,Q=Math.max(0,Math.ceil(J/O)),X=Math.min(R,(z+J)/O),ee=0,ae=K;ae<Y;++ae)for(var te=ae*B-j,ne=Q;ne<X;++ne)for(var re=x*q+T*ae+S*ne,ie=M*(w-1-te)+A*(z-1-(ne*O-J))+D*U,oe=0;oe<G;++oe){ee+=N[re+(U*G+oe)]*F[ie+oe]}k[g*q+I*Z+y*$+U]=ee}return n.makeTensorInfo(v.shape,v.dtype,v.values)}};var st={kernelName:a.Diag,backendName:"cpu",kernelFunc:function(e){for(var t=e.inputs,n=e.backend,r=t.x,i=a.util.sizeFromShape(r.shape),o=n.data.get(r.dataId).values,s=a.buffer([i,i],r.dtype),u=s.values,d=0;d<o.length;d++)u[d*i+d]=o[d];var p=r.shape.concat(r.shape);return n.makeTensorInfo(p,s.dtype,s.values)}},ut={kernelName:a.Dilation2D,backendName:"cpu",kernelFunc:function(e){for(var t=e.inputs,n=e.backend,r=e.attrs,i=t,o=i.x,s=i.filter,u=r,d=u.strides,p=u.pad,l=u.dilations,c=n,f=c.data.get(o.dataId).values,h=o.shape.length,m=c.data.get(s.dataId).values,v=s.shape.length,k=a.backend_util.computeDilation2DInfo(o.shape,s.shape,d,p,"NHWC",l),b=k.batchSize,g=k.inHeight,I=k.inWidth,y=k.inChannels,N=k.outHeight,x=k.outWidth,T=k.padInfo,S=k.strideHeight,F=k.strideWidth,M=k.filterHeight,A=k.filterWidth,D=k.dilationHeight,_=k.dilationWidth,w=k.outShape,z=a.util.sizeFromShape(w),W=w.length,C=a.util.getArrayFromDType(o.dtype,z),H=0;H<b;++H)for(var E=0;E<N;++E)for(var P=E*S-T.top,R=0;R<x;++R)for(var B=R*F-T.left,O=0;O<y;++O){for(var L=Number.MIN_SAFE_INTEGER,V=0;V<M;++V){var G=P+V*D;if(G>=0&&G<g)for(var q=0;q<A;++q){var U=B+q*_;if(U>=0&&U<I){var Z=a.util.locToIndex([H,G,U,O],h,a.util.computeStrides(o.shape)),j=a.util.locToIndex([V,q,O],v,a.util.computeStrides(s.shape)),K=f[Z]+m[j];K>L&&(L=K)}}}C[a.util.locToIndex([H,E,R,O],W,a.util.computeStrides(w))]=L}return{dataId:c.write(a.util.toTypedArray(C,o.dtype),w,o.dtype),shape:w,dtype:o.dtype}}},dt={kernelName:a.Dilation2DBackpropFilter,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t,o=i.x,s=i.filter,u=i.dy,d=r,p=d.strides,l=d.pad,c=d.dilations,f=n,h=a.util.toNestedArray(o.shape,f.data.get(o.dataId).values),m=a.util.toNestedArray(s.shape,f.data.get(s.dataId).values),v=a.backend_util.computeDilation2DInfo(o.shape,s.shape,p,l,"NHWC",c),k=v.batchSize,b=v.inHeight,g=v.inWidth,I=v.inChannels,y=v.outHeight,N=v.outWidth,x=v.padInfo,T=v.strideHeight,S=v.strideWidth,F=v.filterHeight,M=v.filterWidth,A=v.dilationHeight,D=v.dilationWidth,_=v.outShape;a.util.assert(u.rank===_.length,(function(){return"Error in "+a.Dilation2DBackpropFilter+", dy must have the same rank as output "+_.length+", but got "+u.rank}));for(var w=a.util.toNestedArray(_,f.data.get(u.dataId).values),z=a.util.makeZerosNestedTypedArray(s.shape,s.dtype),W=0;W<k;++W)for(var C=0;C<y;++C)for(var H=C*T-x.top,E=0;E<N;++E)for(var P=E*S-x.left,R=0;R<I;++R){for(var B=Number.MIN_SAFE_INTEGER,O=0,L=0,V=0;V<F;++V){var G=H+V*A;if(G>=0&&G<b)for(var q=0;q<M;++q){var U=P+q*D;if(U>=0&&U<g){var Z=h[W][G][U][R]+m[V][q][R];Z>B&&(B=Z,O=V,L=q)}}}z[O][L][R]+=w[W][C][E][R]}return{dataId:f.write(a.util.toTypedArray(z,o.dtype),s.shape,s.dtype),shape:s.shape,dtype:s.dtype}}},pt={kernelName:a.Dilation2DBackpropInput,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t,o=i.x,s=i.filter,u=i.dy,d=r,p=d.strides,l=d.pad,c=d.dilations,f=n,h=a.util.toNestedArray(o.shape,f.data.get(o.dataId).values),m=a.util.toNestedArray(s.shape,f.data.get(s.dataId).values),v=a.backend_util.computeDilation2DInfo(o.shape,s.shape,p,l,"NHWC",c),k=v.batchSize,b=v.inHeight,g=v.inWidth,I=v.inChannels,y=v.outHeight,N=v.outWidth,x=v.padInfo,T=v.strideHeight,S=v.strideWidth,F=v.filterHeight,M=v.filterWidth,A=v.dilationHeight,D=v.dilationWidth,_=v.outShape;a.util.assert(u.rank===_.length,(function(){return"Error in "+a.Dilation2DBackpropInput+", dy must have the same rank as output "+_.length+", but got "+u.rank}));for(var w=a.util.toNestedArray(_,f.data.get(u.dataId).values),z=a.util.makeZerosNestedTypedArray(o.shape,o.dtype),W=0;W<k;++W)for(var C=0;C<y;++C)for(var H=C*T-x.top,E=0;E<N;++E)for(var P=E*S-x.left,R=0;R<I;++R){for(var B=Number.MIN_SAFE_INTEGER,O=H<0?0:H,L=P<0?0:P,V=0;V<F;++V){var G=H+V*A;if(G>=0&&G<b)for(var q=0;q<M;++q){var U=P+q*D;if(U>=0&&U<g){var Z=h[W][G][U][R]+m[V][q][R];Z>B&&(B=Z,O=G,L=U)}}}z[W][O][L][R]+=w[W][C][E][R]}return{dataId:f.write(a.util.toTypedArray(z,o.dtype),o.shape,o.dtype),shape:o.shape,dtype:o.dtype}}};var lt={kernelName:a.EluGrad,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=t.dy,i=t.y;o([r,i],"eluGrad");for(var s=new Float32Array(a.util.sizeFromShape(i.shape)),u=n.data.get(i.dataId).values,d=n.data.get(r.dataId).values,p=0;p<u.length;++p){var l=u[p];s[p]=l>=1?d[p]:d[p]*(l+1)}return n.makeTensorInfo(i.shape,"float32",s)}},ct=l((function(e,a){return e===a?1:0})),ft=y(a.Equal,ct,null,"bool"),ht={kernelName:a.Equal,backendName:"cpu",kernelFunc:ft},mt=a.backend_util.ERF_P,vt=a.backend_util.ERF_A1,kt=a.backend_util.ERF_A2,bt=a.backend_util.ERF_A3,gt=a.backend_util.ERF_A4,It=a.backend_util.ERF_A5,yt=_(a.Erf,(function(e){var a=Math.sign(e),t=Math.abs(e),n=1/(1+mt*t);return a*(1-((((It*n+gt)*n+bt)*n+kt)*n+vt)*n*Math.exp(-t*t))})),Nt={kernelName:a.Erf,backendName:"cpu",kernelFunc:yt};function xt(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.input,o=r.dim,s=i.shape.length,u=i.shape.slice(),d=o;return o<0&&(a.util.assert(-(s+1)<=o,(function(){return"Axis must be in the interval ["+-(s+1)+", "+s+"]"})),d=s+o+1),u.splice(d,0,1),ea({inputs:{x:i},backend:n,attrs:{shape:u}})}var Tt={kernelName:a.ExpandDims,backendName:"cpu",kernelFunc:xt},St=l((function(e,a){return e/a})),Ft=y(a.RealDiv,St),Mt={kernelName:a.RealDiv,backendName:"cpu",kernelFunc:Ft};function At(e,t,n){for(var r=e.shape,i=r[0],o=r[1],s=n.data.get(e.dataId),u=s.complexTensorInfos.real,d=s.complexTensorInfos.imag,p=[i,o],l=a.util.sizeFromShape(p),f=a.util.getTypedArrayFromDType("float32",l),h=a.util.getTypedArrayFromDType("float32",l),m=0;m<i;m++){for(var v=Ae({inputs:{x:u},backend:n,attrs:{begin:[m,0],size:[1,o]}}),k=Ae({inputs:{x:d},backend:n,attrs:{begin:[m,0],size:[1,o]}}),b=c({inputs:{real:v,imag:k},backend:n}),g=Dt(b,t,n),I=g.real,y=g.imag,N=a.backend_util.mergeRealAndImagArrays(I,y),x=0;x<o;x++){var T=a.backend_util.getComplexWithIndex(N,x);f[m*o+x]=T.real,h[m*o+x]=T.imag}n.disposeIntermediateTensorInfo(v),n.disposeIntermediateTensorInfo(k),n.disposeIntermediateTensorInfo(b)}var S=n.makeTensorInfo(p,"float32",f),F=n.makeTensorInfo(p,"float32",h),M=c({inputs:{real:S,imag:F},backend:n});return n.disposeIntermediateTensorInfo(S),n.disposeIntermediateTensorInfo(F),M}function Dt(e,t,n){var r=a.util.sizeFromShape(e.shape),i=n.data.get(e.dataId),o=n.data.get(i.complexTensorInfos.real.dataId).values,s=n.data.get(i.complexTensorInfos.imag.dataId).values;if(0==((y=r)&y-1)){var u=function e(t,n,r,i,o){if(1===r)return{real:t,imag:n};var s=a.backend_util.mergeRealAndImagArrays(t,n),u=r/2,d=a.backend_util.complexWithEvenIndex(s),p=d.real,l=d.imag,f=[p.length],h=o.makeTensorInfo(f,"float32",p),m=o.makeTensorInfo(f,"float32",l),v=c({inputs:{real:h,imag:m},backend:o}),b=a.backend_util.complexWithOddIndex(s),g=b.real,I=b.imag,y=[g.length],N=o.makeTensorInfo(y,"float32",g),x=o.makeTensorInfo(y,"float32",I),T=c({inputs:{real:N,imag:x},backend:o}),F=e(p,l,u,i,o),M=F.real,A=F.imag,D=[M.length],_=o.makeTensorInfo(D,"float32",M),w=o.makeTensorInfo(D,"float32",A),z=c({inputs:{real:_,imag:w},backend:o}),W=e(g,I,u,i,o),C=W.real,H=W.imag,E=[C.length],P=o.makeTensorInfo(E,"float32",C),R=o.makeTensorInfo(E,"float32",H),B=c({inputs:{real:P,imag:R},backend:o}),O=a.backend_util.exponents(r,i),L=[O.real.length],V=o.makeTensorInfo(L,"float32",O.real),G=o.makeTensorInfo(L,"float32",O.imag),q=c({inputs:{real:V,imag:G},backend:o}),U=le({inputs:{a:q,b:B},backend:o}),Z=S({inputs:{a:z,b:U},backend:o}),j=Ee({inputs:{a:z,b:U},backend:o}),K=k({inputs:{input:Z},backend:o}),Y=k({inputs:{input:j},backend:o}),$=Ra({inputs:{input:Z},backend:o}),J=Ra({inputs:{input:j},backend:o}),Q=Oa({inputs:[K,Y],backend:o,attrs:{axis:0}}),X=Oa({inputs:[$,J],backend:o,attrs:{axis:0}}),ee=o.data.get(Q.dataId).values,ae=o.data.get(X.dataId).values;return o.disposeIntermediateTensorInfo(h),o.disposeIntermediateTensorInfo(m),o.disposeIntermediateTensorInfo(v),o.disposeIntermediateTensorInfo(N),o.disposeIntermediateTensorInfo(x),o.disposeIntermediateTensorInfo(T),o.disposeIntermediateTensorInfo(_),o.disposeIntermediateTensorInfo(w),o.disposeIntermediateTensorInfo(z),o.disposeIntermediateTensorInfo(P),o.disposeIntermediateTensorInfo(R),o.disposeIntermediateTensorInfo(B),o.disposeIntermediateTensorInfo(V),o.disposeIntermediateTensorInfo(G),o.disposeIntermediateTensorInfo(q),o.disposeIntermediateTensorInfo(U),o.disposeIntermediateTensorInfo(Z),o.disposeIntermediateTensorInfo(j),o.disposeIntermediateTensorInfo(K),o.disposeIntermediateTensorInfo($),o.disposeIntermediateTensorInfo(Y),o.disposeIntermediateTensorInfo(J),o.disposeIntermediateTensorInfo(Q),o.disposeIntermediateTensorInfo(X),{real:ee,imag:ae}}(o,s,r,t,n),d=[e.shape[0],e.shape[1]];if(t){var p=n.makeTensorInfo(d,"float32",u.real),l=n.makeTensorInfo(d,"float32",u.imag),f=n.makeTensorInfo([],"float32",a.util.createScalarValue(r,"float32")),h=m({inputs:{x:f},backend:n}),v=Mt.kernelFunc({inputs:{a:p,b:f},backend:n}),b=Mt.kernelFunc({inputs:{a:l,b:h},backend:n}),g=n.data.get(v.dataId).values,I=n.data.get(b.dataId).values;return n.disposeIntermediateTensorInfo(p),n.disposeIntermediateTensorInfo(l),n.disposeIntermediateTensorInfo(f),n.disposeIntermediateTensorInfo(h),n.disposeIntermediateTensorInfo(v),n.disposeIntermediateTensorInfo(b),{real:g,imag:I}}return u}var y,N=function(e,t,n){for(var r=new Float32Array(2*t),i=0;i<t;i++){for(var o=0,s=0,u=0;u<t;u++){var d=a.backend_util.exponent(i*u,t,n),p=a.backend_util.getComplexWithIndex(e,u);o+=p.real*d.real-p.imag*d.imag,s+=p.real*d.imag+p.imag*d.real}n&&(o/=t,s/=t),a.backend_util.assignToTypedArray(r,o,s,i)}return r}(a.backend_util.mergeRealAndImagArrays(o,s),r,t);return a.backend_util.splitRealAndImagArrays(N)}var _t={kernelName:a.FFT,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=t.input,i=a.util.sizeFromShape(r.shape),o=r.shape[r.shape.length-1],s=ea({inputs:{x:r},backend:n,attrs:{shape:[i/o,o]}}),u=At(s,!1,n),d=ea({inputs:{x:u},backend:n,attrs:{shape:r.shape}});return n.disposeIntermediateTensorInfo(s),n.disposeIntermediateTensorInfo(u),d}};function wt(e){var t=e.backend,n=e.attrs,r=n.shape,i=n.value,o=n.dtype||a.util.inferDtype(i),s=a.util.getArrayFromDType(o,a.util.sizeFromShape(r));return function(e,a,t){e.fill(a)}(s,i),t.makeTensorInfo(r,o,s)}var zt={kernelName:a.Fill,backendName:"cpu",kernelFunc:wt};var Wt={kernelName:a.FlipLeftRight,backendName:"cpu",kernelFunc:function(e){for(var t=e.inputs,n=(e.attrs,e.backend),r=t.image,i=n,o=a.util.getTypedArrayFromDType(r.dtype,a.util.sizeFromShape(r.shape)),s=r.shape,u=s[0],d=s[1],p=s[2],l=s[3],c=i.data.get(r.dataId).values,f=0;f<u;f++)for(var h=f*p*d*l,m=0;m<d;m++)for(var v=m*(p*l),k=0;k<p;k++)for(var b=k*l,g=0;g<l;g++){var I=[u,m,k,g][2],y=Math.round(p-I),N=h+v+b+g,x=c[N];if(y>=0&&y<p)x=c[h+v+y*l+g];o[N]=x}return{dataId:i.write(o,r.shape,r.dtype),shape:r.shape,dtype:r.dtype}}},Ct=l((function(e,a){return Math.floor(e/a)})),Ht=y(a.FloorDiv,Ct,null,"int32"),Et={kernelName:a.FloorDiv,backendName:"cpu",kernelFunc:Ht};var Pt={kernelName:a.FusedConv2D,backendName:"cpu",kernelFunc:function(e){var a=e.inputs,t=e.backend,n=e.attrs,r=a.x,i=a.filter,o=a.bias,s=a.preluActivationWeights,u=n.strides,d=n.pad,p=n.dataFormat,l=n.dilations,c=n.dimRoundingMode,f=n.activation,h=n.leakyreluAlpha,m=Va({inputs:{x:r,filter:i},backend:t,attrs:{strides:u,pad:d,dataFormat:p,dilations:l,dimRoundingMode:c}});if(o){var v=m;m=S({inputs:{a:m,b:o},backend:t}),t.disposeIntermediateTensorInfo(v)}if(f){v=m;m=Xe(t,m,f,s,h),t.disposeIntermediateTensorInfo(v)}return m}};var Rt={kernelName:a.FusedDepthwiseConv2D,backendName:"cpu",kernelFunc:function(e){var a=e.inputs,t=e.backend,n=e.attrs,r=a.x,i=a.filter,o=a.bias,s=a.preluActivationWeights,u=n.strides,d=n.pad,p=n.dataFormat,l=n.dilations,c=n.dimRoundingMode,f=n.activation,h=n.leakyreluAlpha,m=nt({inputs:{x:r,filter:i},backend:t,attrs:{strides:u,pad:d,dataFormat:p,dilations:l,dimRoundingMode:c}});if(o){var v=m;m=S({inputs:{a:m,b:o},backend:t}),t.disposeIntermediateTensorInfo(v)}if(f){v=m;m=Xe(t,m,f,s,h),t.disposeIntermediateTensorInfo(v)}return m}};var Bt={kernelName:a.GatherNd,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=t.params,i=t.indices,o=a.util.sizeFromShape(r.shape),s=i.shape,u=s[s.length-1],d=a.backend_util.prepareAndValidate(r,i),p=d[0],l=d[1],c=d[2],f=d[3];if(0===l)return n.makeTensorInfo(p,r.dtype,[]);for(var h=a.buffer([l,c],r.dtype),m=n.data.get(i.dataId).values,v=n.data.get(r.dataId).values,k=0;k<l;k++){for(var b=[],g=0,I=0;I<u;I++){var y=m[k*u+I];g+=y*f[I],b.push(y)}if(g<0||g>=o/c)throw new Error("Invalid indices: "+b+" does not index into "+r.shape);for(var N=0;N<c;N++)h.values[k*c+N]=v[g*c+N]}return n.makeTensorInfo(p,h.dtype,h.values)}};var Ot={kernelName:a.GatherV2,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,s=t.indices,u=r.axis,d=r.batchDims;o([i,s],"gatherV2");var p=d;null==d&&(p=0);var l=a.util.sizeFromShape(s.shape),c=a.util.parseAxisParam(u,i.shape)[0],f=a.backend_util.segment_util.collectGatherOpShapeInfo(i,s,c,p),h=ea({inputs:{x:i},backend:n,attrs:{shape:[f.batchSize,f.outerSize,f.dimSize,f.sliceSize]}}),m=ea({inputs:{x:s},backend:n,attrs:{shape:[f.batchSize,l/f.batchSize]}}),v=[f.batchSize,f.outerSize,l/f.batchSize,f.sliceSize],k=n.bufferSync(m),b=U(n.bufferSync(h),k,v);return n.disposeIntermediateTensorInfo(h),n.disposeIntermediateTensorInfo(m),n.makeTensorInfo(f.outputShape,b.dtype,b.values)}},Lt=l((function(e,a){return e>=a?1:0})),Vt=y(a.GreaterEqual,Lt,null,"bool"),Gt={kernelName:a.GreaterEqual,backendName:"cpu",kernelFunc:Vt};var qt={kernelName:a.IFFT,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=t.input,i=a.util.sizeFromShape(r.shape),o=r.shape[r.shape.length-1],s=ea({inputs:{x:r},backend:n,attrs:{shape:[i/o,o]}}),u=At(s,!0,n),d=ea({inputs:{x:u},backend:n,attrs:{shape:r.shape}});return n.disposeIntermediateTensorInfo(s),n.disposeIntermediateTensorInfo(u),d}},Ut=_(a.IsFinite,(function(e){return Number.isFinite(e)?1:0}),"bool"),Zt={kernelName:a.IsFinite,backendName:"cpu",kernelFunc:Ut},jt=_(a.IsInf,(function(e){return Math.abs(e)===1/0?1:0}),"bool"),Kt={kernelName:a.IsInf,backendName:"cpu",kernelFunc:jt},Yt=_(a.IsNan,(function(e){return Number.isNaN(e)?1:0}),"bool"),$t={kernelName:a.IsNan,backendName:"cpu",kernelFunc:Yt},Jt=l((function(e,a){return e<=a?1:0})),Qt=y(a.LessEqual,Jt,null,"bool"),Xt={kernelName:a.LessEqual,backendName:"cpu",kernelFunc:Qt};var en={kernelName:a.LinSpace,backendName:"cpu",kernelFunc:function(e){var a=e.backend,t=e.attrs,n=Q(t.start,t.stop,t.num);return a.makeTensorInfo([n.length],"float32",n)}},an=_(a.Log1p,(function(e){return Math.log1p(e)})),tn={kernelName:a.Log1p,backendName:"cpu",kernelFunc:an},nn=l((function(e,a){return e&&a})),rn=y(a.LogicalAnd,nn,null,"bool"),on={kernelName:a.LogicalAnd,backendName:"cpu",kernelFunc:rn},sn=_(a.LogicalNot,(function(e){return e?0:1}),"bool"),un={kernelName:a.LogicalNot,backendName:"cpu",kernelFunc:sn},dn=l((function(e,a){return e||a})),pn=y(a.LogicalOr,dn,null,"bool"),ln={kernelName:a.LogicalOr,backendName:"cpu",kernelFunc:pn};var cn={kernelName:a.LRN,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,s=r.depthRadius,u=r.bias,d=r.alpha,p=r.beta;o(i,"LRN");var l=i.shape[3],c=l-1,f=n.data.get(i.dataId).values,h=a.util.sizeFromShape(i.shape),m=new Float32Array(h);function v(e){for(var a=e%l,t=e-a+Math.max(0,a-s),n=e-a+Math.min(a+s,c),r=0;t<=n;t++){var i=f[t];r+=i*i}return r}for(var k=0;k<h;k++){var b=v(k),g=f[k]*Math.pow(u+d*b,-p);m[k]=g}return n.makeTensorInfo(i.shape,i.dtype,m)}};var fn={kernelName:a.LRNGrad,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,s=t.y,u=t.dy,d=r.depthRadius,p=r.bias,l=r.alpha,c=r.beta;o(u,"LRNGrad");for(var f=a.util.sizeFromShape(u.shape),h=u.shape[3],m=n.data.get(u.dataId).values,v=n.data.get(i.dataId).values,k=n.data.get(s.dataId).values,b=new Float32Array(f),g=f,I=0;I<g;I++){for(var y=I%h,N=I-y+Math.max(0,y-d),x=I-y+Math.min(h,y+d+1),T=0,S=N;S<x;S++)T+=Math.pow(v[S],2);T=l*T+p;for(S=N;S<x;S++){var F=-2*l*c*v[S]*k[I]/T;I===S&&(F+=Math.pow(T,-c)),F*=m[I],b[S]+=F}}return n.makeTensorInfo(u.shape,i.dtype,b)}};function hn(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,s=r.reductionIndices,u=r.keepDims,d=n,p=i.shape,l=p.length,c=a.util.parseAxisParam(s,p),f=c,h=a.backend_util.getAxesPermutation(f,l),m=d.data.get(i.dataId).values;if(null!=h){for(var v=new Array(l),k=0;k<v.length;k++)v[k]=p[h[k]];m=be(m,p,i.dtype,h,v),f=a.backend_util.getInnerMostAxes(f.length,l),p=v}o(i,"max"),a.backend_util.assertAxesAreInnerMostDims("max",f,l);var b=a.backend_util.computeOutAndReduceShapes(p,f),g=b[0],I=b[1],y=te(m,a.util.sizeFromShape(I),g,i.dtype),N=d.write(y,g,i.dtype),x=g;u&&(x=v=a.backend_util.expandShapeToKeepDim(g,c));return{dataId:N,shape:x,dtype:i.dtype}}var mn={kernelName:a.Max,backendName:"cpu",kernelFunc:hn};var vn={kernelName:a.MaxPool,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x;o(i,"maxPool");var s=r.filterSize,u=r.strides,d=r.pad,p=r.dimRoundingMode;a.util.assert(a.backend_util.eitherStridesOrDilationsAreOne(u,1),(function(){return"Error in maxPool: Either strides or dilations must be 1. Got strides "+u+" and dilations '1'"}));var l,c=a.backend_util.computePool2DInfo(i.shape,s,u,1,d,p);if(1===c.filterWidth&&1===c.filterHeight&&a.util.arraysEqual(c.inShape,c.outShape))l=m({inputs:{x:i},backend:n});else{var f=n.data.get(i.dataId).values,h=a.util.computeStrides(i.shape),v=Sa(f,i.shape,i.dtype,h,c,"max");l=n.makeTensorInfo(c.outShape,i.dtype,v.values)}return l}};var kn={kernelName:a.MaxPool3D,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,s=r.filterSize,u=r.strides,d=r.pad,p=r.dimRoundingMode,l=r.dataFormat;o(i,"maxPool3d");var c=a.backend_util.computePool3DInfo(i.shape,s,u,1,d,p,l),f=Ma(n.data.get(i.dataId).values,i.shape,i.dtype,a.util.computeStrides(i.shape),c,"max");return n.makeTensorInfo(f.shape,"float32",f.values)}};var bn={kernelName:a.MaxPool3DGrad,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.dy,s=t.input,u=r.filterSize,d=r.strides,p=r.pad,l=r.dimRoundingMode;o([i,s],"maxPool3DGrad");for(var c=a.backend_util.computePool3DInfo(s.shape,u,d,1,p,l),f=function(e,t){for(var n=a.buffer(t.outShape,"int32"),r=t.strideDepth,i=t.strideHeight,o=t.strideWidth,s=t.dilationDepth,u=t.dilationHeight,d=t.dilationWidth,p=t.effectiveFilterDepth,l=t.effectiveFilterHeight,c=t.effectiveFilterWidth,f=t.padInfo.front,h=t.padInfo.top,m=t.padInfo.left,v=0;v<t.batchSize;++v)for(var k=0;k<t.inChannels;++k)for(var b=0;b<t.outDepth;++b){for(var g=b*r-f,I=g;I<0;)I+=s;for(var y=Math.min(t.inDepth,p+g),N=0;N<t.outHeight;++N){for(var x=N*i-h,T=x;T<0;)T+=u;for(var S=Math.min(t.inHeight,l+x),F=0;F<t.outWidth;++F){for(var M=F*o-m,A=M;A<0;)A+=d;for(var D=Math.min(t.inWidth,c+M),_=Number.NEGATIVE_INFINITY,w=-1,z=I;z<y;z+=s)for(var W=z-g,C=T;C<S;C+=u)for(var H=C-x,E=A;E<D;E+=d){var P=E-M,R=e.get(v,z,C,E,k);R>=_&&(_=R,w=W*l*c+H*l+P)}n.set(w,v,b,N,F,k)}}}return n}(n.bufferSync(s),c),h=c.strideDepth,m=c.strideHeight,v=c.strideWidth,k=c.dilationDepth,b=c.dilationHeight,g=c.dilationWidth,I=c.effectiveFilterDepth,y=c.effectiveFilterHeight,N=c.effectiveFilterWidth,x=I-1-c.padInfo.front,T=N-1-c.padInfo.left,S=y-1-c.padInfo.top,F=a.buffer(s.shape,"float32"),M=n.bufferSync(i),A=0;A<c.batchSize;++A)for(var D=0;D<c.inChannels;++D)for(var _=0;_<c.inDepth;++_)for(var w=0;w<c.inHeight;++w)for(var z=0;z<c.inWidth;++z){for(var W=_-x,C=w-S,H=z-T,E=0,P=0;P<I;P+=k){var R=(W+P)/h;if(!(R<0||R>=c.outDepth||Math.floor(R)!==R))for(var B=0;B<y;B+=b){var O=(C+B)/m;if(!(O<0||O>=c.outHeight||Math.floor(O)!==O))for(var L=0;L<N;L+=g){var V=(H+L)/v;if(!(V<0||V>=c.outWidth||Math.floor(V)!==V)){var G=I*y*N-1-f.get(A,R,O,V,D)===P*y*N+B*N+L?1:0;if(0!==G)E+=M.get(A,R,O,V,D)*G}}}}F.set(E,A,_,w,z,D)}return n.makeTensorInfo(F.shape,F.dtype,F.values)}};var gn={kernelName:a.MaxPoolGrad,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.dy,s=t.input,u=s;o([s,t.output],"maxPoolGrad");for(var d=r.filterSize,p=r.strides,l=r.pad,c=r.dimRoundingMode,f=a.backend_util.computePool2DInfo(u.shape,d,p,1,l,c),h=n.data.get(u.dataId).values,m=a.buffer(f.outShape,u.dtype,Fa(h,u.shape,u.dtype,f).values),v=f.strideHeight,k=f.strideWidth,b=f.dilationHeight,g=f.dilationWidth,I=f.effectiveFilterHeight,y=f.effectiveFilterWidth,N=y-1-f.padInfo.left,x=I-1-f.padInfo.top,T=a.buffer(u.shape,"float32"),S=n.data.get(i.dataId).values,F=a.buffer(i.shape,"float32",S),M=0;M<f.batchSize;++M)for(var A=0;A<f.inChannels;++A)for(var D=0;D<f.inHeight;++D)for(var _=0;_<f.inWidth;++_){for(var w=D-x,z=_-N,W=0,C=0;C<I;C+=b){var H=(w+C)/v;if(!(H<0||H>=f.outHeight||Math.floor(H)!==H))for(var E=0;E<y;E+=g){var P=(z+E)/k;if(!(P<0||P>=f.outWidth||Math.floor(P)!==P)){var R=I*y-1-m.get(M,H,P,A)===C*y+E?1:0;if(0!==R)W+=F.get(M,H,P,A)*R}}}T.set(W,M,D,_,A)}return n.makeTensorInfo(T.shape,T.dtype,T.values)}};var In={kernelName:a.MaxPoolWithArgmax,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.attrs,r=e.backend,i=t.x,s=n,u=s.filterSize,d=s.strides,p=s.pad,l=s.includeBatchInIndex,c=r;o(i,"MaxPoolWithArgmax");var f=c.data.get(i.dataId).values,h=a.backend_util.computePool2DInfo(i.shape,u,d,[1,1],p),m=function(e,t,n,r,i){var o=Sa(e,0,n,a.util.computeStrides(t),i,"max"),s=Fa(e,t,n,i,!0,r);return[o.values,s.values]}(f,i.shape,i.dtype,l,h),v=m[0],k=m[1],b=c.write(v,h.outShape,i.dtype),g=c.write(k,h.outShape,i.dtype);return[{dataId:b,shape:h.outShape,dtype:i.dtype},{dataId:g,shape:h.outShape,dtype:"int32"}]}};function yn(e){var t,n=e.inputs,r=e.backend,i=e.attrs,s=n.x,u=i.axis,d=i.keepDims;o(s,"sum");var p=(t="bool"===s.dtype?g({inputs:{x:s},backend:r,attrs:{dtype:"int32"}}):m({inputs:{x:s},backend:r})).shape.length,l=a.util.parseAxisParam(u,t.shape),c=a.backend_util.getAxesPermutation(l,p),f=l,v=t;null!=c&&(v=ge({inputs:{x:t},backend:r,attrs:{perm:c}}),f=a.backend_util.getInnerMostAxes(f.length,p)),a.backend_util.assertAxesAreInnerMostDims("sum",f,v.shape.length);for(var k=a.backend_util.computeOutAndReduceShapes(v.shape,f),b=k[0],I=k[1],y=h(r,b,a.backend_util.upcastType(v.dtype,"int32")),N=a.util.sizeFromShape(I),x=r.data.get(y.dataId).values,T=r.data.get(v.dataId).values,S=0;S<x.length;++S){for(var F=S*N,M=0,A=0;A<N;++A)M+=T[F+A];x[S]=M}if(d){var D=y;y=ea({inputs:{x:y},backend:r,attrs:{shape:a.backend_util.expandShapeToKeepDim(y.shape,l)}}),r.disposeIntermediateTensorInfo(D)}return r.disposeIntermediateTensorInfo(t),null!=c&&r.disposeIntermediateTensorInfo(v),y}var Nn={kernelName:a.Sum,backendName:"cpu",kernelFunc:yn};var xn={kernelName:a.Mean,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,o=r.axis,s=r.keepDims,u=a.util.parseAxisParam(o,i.shape),d=a.backend_util.computeOutAndReduceShapes(i.shape,u)[1],p=a.util.sizeFromShape(d),l=[],c=n.makeTensorInfo([],"float32",new Float32Array([p]));l.push(c);var f=g({inputs:{x:i},backend:n,attrs:{dtype:"float32"}});l.push(f);var h=Ft({inputs:{a:f,b:c},backend:n});l.push(h);var m=yn({inputs:{x:h},backend:n,attrs:{axis:o,keepDims:s}});return l.forEach((function(e){return n.disposeIntermediateTensorInfo(e)})),m}};var Tn={kernelName:a.Min,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,s=r.axis,u=r.keepDims;o(i,"min");var d=a.util.parseAxisParam(s,i.shape),p=d,l=a.backend_util.getAxesPermutation(p,i.shape.length),c=i;null!=l&&(c=ge({inputs:{x:i},backend:n,attrs:{perm:l}}),p=a.backend_util.getInnerMostAxes(p.length,i.shape.length)),a.backend_util.assertAxesAreInnerMostDims("min",p,c.shape.length);for(var f=a.backend_util.computeOutAndReduceShapes(c.shape,p),h=f[0],m=f[1],v=a.util.sizeFromShape(m),k=a.util.makeZerosTypedArray(a.util.sizeFromShape(h),c.dtype),b=n.data.get(c.dataId).values,g=0;g<k.length;++g){for(var I=g*v,y=b[I],N=0;N<v;++N){var x=b[I+N];x<y&&(y=x)}k[g]=y}null!=l&&n.disposeIntermediateTensorInfo(c);var T=n.makeTensorInfo(h,c.dtype,k);if(u){var S=ea({inputs:{x:T},backend:n,attrs:{shape:a.backend_util.expandShapeToKeepDim(h,d)}});return n.disposeIntermediateTensorInfo(T),S}return T}};var Sn={kernelName:a.MirrorPad,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,s=r.paddings,u=r.mode;o(i,"mirrorPad");for(var d=s.map((function(e,a){return e[0]+i.shape[a]+e[1]})),p=s.map((function(e){return e[0]})),l=s.map((function(e,a){return e[0]+i.shape[a]})),c="reflect"===u?0:1,f=n.data.get(i.dataId).values,h=i.shape.length,m=a.util.computeStrides(i.shape),v=a.util.sizeFromShape(d),k=d.length,b=a.util.computeStrides(d),g=a.util.getTypedArrayFromDType(i.dtype,v),I=0;I<v;I++){for(var y=a.util.indexToLoc(I,k,b),N=0;N<k;N++)y[N]<p[N]?y[N]=2*p[N]-y[N]-c:y[N]>=l[N]&&(y[N]=2*(l[N]-1)-y[N]+c);y=y.map((function(e,a){return e-p[a]}));var x=a.util.locToIndex(y,h,m);g[I]=f[x]}return{dataId:n.write(g,d,i.dtype),shape:d,dtype:i.dtype}}},Fn=l((function(e,a){var t=e%a;return e<0&&a<0||e>=0&&a>=0?t:(t+a)%a})),Mn=y(a.Mod,Fn),An={kernelName:a.Mod,backendName:"cpu",kernelFunc:Mn};function Dn(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.logits,o=r.dim,s=i.shape.length,u=o;if(-1===u&&(u=s-1),u!==s-1)throw Error("Softmax along a non-last dimension is not yet supported. Logits was rank "+s+" and dim was "+u);var d=a.util.parseAxisParam([u],i.shape),p=hn({inputs:{x:i},backend:n,attrs:{reductionIndices:d,keepDims:!1}}),l=a.backend_util.expandShapeToKeepDim(p.shape,d),c=ea({inputs:{x:p},backend:n,attrs:{shape:l}}),f=Ee({inputs:{a:i,b:c},backend:n}),h=P({inputs:{x:f},backend:n}),m=yn({inputs:{x:h},backend:n,attrs:{axis:d,keepDims:!1}}),v=ea({inputs:{x:m},backend:n,attrs:{shape:l}}),k=Ft({inputs:{a:h,b:v},backend:n});return n.disposeIntermediateTensorInfo(p),n.disposeIntermediateTensorInfo(c),n.disposeIntermediateTensorInfo(f),n.disposeIntermediateTensorInfo(h),n.disposeIntermediateTensorInfo(m),n.disposeIntermediateTensorInfo(v),k}var _n={kernelName:a.Softmax,backendName:"cpu",kernelFunc:Dn};var wn={kernelName:a.Multinomial,backendName:"cpu",kernelFunc:function(e){var n=e.inputs,r=e.backend,i=e.attrs,s=n.logits,u=i.numSamples,d=i.seed,p=i.normalized;o(s,"multinomial");for(var l=p?s:Dn({inputs:{logits:s},backend:r,attrs:{dim:-1}}),c=l.shape[0],f=l.shape[1],h=r.data.get(l.dataId).values,m=[c,u],v=a.util.makeZerosTypedArray(a.util.sizeFromShape(m),"int32"),k=0;k<c;++k){var b=k*f,g=new Float32Array(f-1);g[0]=h[b];for(var I=1;I<g.length;++I)g[I]=g[I-1]+h[b+I];for(var y=t.alea(d.toString()),N=k*u,x=0;x<u;++x){var T=y();v[N+x]=g.length;for(var S=0;S<g.length;S++)if(T<g[S]){v[N+x]=S;break}}}return p||r.disposeIntermediateTensorInfo(l),r.makeTensorInfo(m,"int32",v)}},zn=a.kernel_impls.nonMaxSuppressionV3Impl;var Wn={kernelName:a.NonMaxSuppressionV3,backendName:"cpu",kernelFunc:function(e){var a=e.inputs,t=e.backend,n=e.attrs,r=a.boxes,i=a.scores,s=n.maxOutputSize,u=n.iouThreshold,d=n.scoreThreshold;o(r,"NonMaxSuppression");var p=t.data.get(r.dataId).values,l=t.data.get(i.dataId).values,c=zn(p,l,s,u,d).selectedIndices;return t.makeTensorInfo([c.length],"int32",new Int32Array(c))}},Cn=a.kernel_impls.nonMaxSuppressionV4Impl;var Hn={kernelName:a.NonMaxSuppressionV4,backendName:"cpu",kernelFunc:function(e){var a=e.inputs,t=e.backend,n=e.attrs,r=a.boxes,i=a.scores,s=n.maxOutputSize,u=n.iouThreshold,d=n.scoreThreshold,p=n.padToMaxOutputSize;o(r,"NonMaxSuppressionPadded");var l=t.data.get(r.dataId).values,c=t.data.get(i.dataId).values,f=Cn(l,c,s,u,d,p),h=f.selectedIndices,m=f.validOutputs;return[t.makeTensorInfo([h.length],"int32",new Int32Array(h)),t.makeTensorInfo([],"int32",new Int32Array([m]))]}},En=a.kernel_impls.nonMaxSuppressionV5Impl;var Pn={kernelName:a.NonMaxSuppressionV5,backendName:"cpu",kernelFunc:function(e){var a=e.inputs,t=e.backend,n=e.attrs,r=a.boxes,i=a.scores,s=n.maxOutputSize,u=n.iouThreshold,d=n.scoreThreshold,p=n.softNmsSigma;o(r,"NonMaxSuppressionWithScore");var l=t.data.get(r.dataId).values,c=t.data.get(i.dataId).values,f=En(l,c,s,u,d,p),h=f.selectedIndices,m=f.selectedScores;return[t.makeTensorInfo([h.length],"int32",new Int32Array(h)),t.makeTensorInfo([m.length],"float32",new Float32Array(m))]}};var Rn={kernelName:a.OneHot,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.indices,s=r.depth,u=r.onValue,d=r.offValue;o(i,"oneHot");var p=a.util.sizeFromShape(i.shape),l=new Float32Array(p*s);l.fill(d);for(var c=n.data.get(i.dataId).values,f=0;f<p;++f)c[f]>=0&&c[f]<s&&(l[f*s+c[f]]=u);return n.makeTensorInfo(i.shape.concat([s]),"int32",l)}};function Bn(e){var a=e.inputs,t=e.backend,n=a.x;if("string"===n.dtype)throw new Error("zerosLike is not supported for string tensors");if("complex64"===n.dtype){var r=k({inputs:{input:n},backend:t}),i=Bn({inputs:{x:r},backend:t}),o=Ra({inputs:{input:n},backend:t}),s=Bn({inputs:{x:o},backend:t}),u=c({inputs:{real:i,imag:s},backend:t});return t.disposeIntermediateTensorInfo(r),t.disposeIntermediateTensorInfo(i),t.disposeIntermediateTensorInfo(o),t.disposeIntermediateTensorInfo(s),u}return wt({backend:t,attrs:{shape:n.shape,value:0,dtype:n.dtype}})}var On={kernelName:a.ZerosLike,backendName:"cpu",kernelFunc:Bn};var Ln={kernelName:a.OnesLike,backendName:"cpu",kernelFunc:function e(a){var t=a.inputs,n=a.backend,r=t.x;if("string"===r.dtype)throw new Error("onesLike is not supported for string tensors");if("complex64"===r.dtype){var i=k({inputs:{input:r},backend:n}),o=e({inputs:{x:i},backend:n}),s=Ra({inputs:{input:r},backend:n}),u=Bn({inputs:{x:s},backend:n}),d=c({inputs:{real:o,imag:u},backend:n});return n.disposeIntermediateTensorInfo(i),n.disposeIntermediateTensorInfo(o),n.disposeIntermediateTensorInfo(s),n.disposeIntermediateTensorInfo(u),d}return wt({backend:n,attrs:{shape:r.shape,value:1,dtype:r.dtype}})}};function Vn(e){var t=e.inputs,n=e.backend,r=e.attrs.axis;if(1===t.length)return xt({inputs:{input:t[0]},backend:n,attrs:{dim:r}});var i=t[0].shape,o=t[0].dtype;t.forEach((function(e){a.util.assertShapesMatch(i,e.shape,"All tensors passed to stack must have matching shapes"),a.util.assert(o===e.dtype,(function(){return"All tensors passed to stack must have matching dtypes"}))}));var s=[],u=Oa({inputs:t.map((function(e){var a=xt({inputs:{input:e},backend:n,attrs:{dim:r}});return s.push(a),a})),backend:n,attrs:{axis:r}});return s.forEach((function(e){return n.disposeIntermediateTensorInfo(e)})),u}var Gn={kernelName:a.Pack,backendName:"cpu",kernelFunc:Vn};var qn={kernelName:a.PadV2,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,s=r.paddings,u=r.constantValue;o(i,"pad");var d=s.map((function(e,a){return e[0]+i.shape[a]+e[1]})),p=s.map((function(e){return e[0]})),l=n.data.get(i.dataId).values,c=a.util.sizeFromShape(i.shape),f=i.shape.length,h=a.util.computeStrides(i.shape),m=a.util.sizeFromShape(d),v=d.length,k=a.util.computeStrides(d),b=a.util.getTypedArrayFromDType(i.dtype,m);0!==u&&b.fill(u);for(var g=0;g<c;g++){var I=a.util.indexToLoc(g,f,h).map((function(e,a){return e+p[a]}));b[a.util.locToIndex(I,v,k)]=l[g]}return{dataId:n.write(b,d,i.dtype),shape:d,dtype:i.dtype}}},Un=l((function(e,a){return Math.pow(e,a)})),Zn=y(a.Pow,Un),jn={kernelName:a.Pow,backendName:"cpu",kernelFunc:Zn};var Kn={kernelName:a.Range,backendName:"cpu",kernelFunc:function(e){var a=e.backend,t=e.attrs,n=t.start,r=t.stop,i=t.dtype,o=xe(n,r,t.step,i);return a.makeTensorInfo([o.length],i,o)}},Yn=_(a.Reciprocal,(function(e){return 1/e})),$n={kernelName:a.Reciprocal,backendName:"cpu",kernelFunc:Yn};var Jn={kernelName:a.ResizeBilinear,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.images,s=r.alignCorners,u=r.halfPixelCenters,d=r.size;o(i,"resizeBilinear");for(var p=a.util.computeStrides(i.shape),l=d[0],c=d[1],f=i.shape,h=f[0],m=f[1],v=f[2],k=f[3],b=n.data.get(i.dataId).values,g=new Float32Array(a.util.sizeFromShape([h,l,c,k])),I=[s&&l>1?m-1:m,s&&c>1?v-1:v],y=[s&&l>1?l-1:l,s&&c>1?c-1:c],N=0,x=I[0]/y[0],T=I[1]/y[1],S=0;S<h;S++)for(var F=0;F<l;F++){var M=void 0;M=u?x*(F+.5)-.5:x*F;for(var A=Math.max(0,Math.floor(M)),D=M-A,_=Math.min(m-1,Math.ceil(M)),w=S*p[0]+A*p[1],z=S*p[0]+_*p[1],W=0;W<c;W++){var C=void 0;C=u?T*(W+.5)-.5:T*W;for(var H=Math.max(0,Math.floor(C)),E=C-H,P=Math.min(v-1,Math.ceil(C)),R=w+H*p[2],B=z+H*p[2],O=w+P*p[2],L=z+P*p[2],V=0;V<k;V++){var G=b[R+V],q=b[B+V],U=G+(b[O+V]-G)*E,Z=U+(q+(b[L+V]-q)*E-U)*D;g[N++]=Z}}}return n.makeTensorInfo([h,l,c,k],"float32",g)}};var Qn={kernelName:a.ResizeBilinearGrad,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.images,s=t.dy,u=r.alignCorners;o([s,i],"resizeBilinearGrad");for(var d=a.util.computeStrides(i.shape),p=i.shape,l=p[0],c=p[1],f=p[2],h=p[3],m=s.shape,v=m[1],k=m[2],b=new Float32Array(l*c*f*h),g=[u&&v>1?c-1:c,u&&k>1?f-1:f],I=[u&&v>1?v-1:v,u&&k>1?k-1:k],y=g[0]/I[0],N=g[1]/I[1],x=n.data.get(s.dataId).values,T=0,S=0;S<l;S++)for(var F=S*d[0],M=0;M<v;M++)for(var A=M*y,D=Math.floor(A),_=Math.min(Math.ceil(A),c-1),w=F+D*d[1],z=F+_*d[1],W=A-D,C=1-W,H=0;H<k;H++)for(var E=H*N,P=Math.floor(E),R=Math.min(Math.ceil(E),f-1),B=E-P,O=1-B,L=w+P*d[2],V=w+R*d[2],G=z+P*d[2],q=z+R*d[2],U=C*O,Z=C*B,j=W*O,K=W*B,Y=0;Y<h;Y++){var $=x[T++];b[L+Y]+=$*U,b[V+Y]+=$*Z,b[G+Y]+=$*j,b[q+Y]+=$*K}return n.makeTensorInfo([l,f,c,h],"float32",b)}};var Xn={kernelName:a.ResizeNearestNeighbor,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.images,s=r.alignCorners,u=r.halfPixelCenters,d=r.size;o(i,"resizeNearestNeighbor");for(var p=a.util.computeStrides(i.shape),l=d[0],c=d[1],f=i.shape,h=f[0],m=f[1],v=f[2],k=f[3],b=n.data.get(i.dataId).values,g=new Float32Array(h*l*c*k),I=[s&&l>1?m-1:m,s&&c>1?v-1:v],y=[s&&l>1?l-1:l,s&&c>1?c-1:c],N=I[0]/y[0],x=I[1]/y[1],T=0,S=0;S<h;S++)for(var F=S*p[0],M=0;M<l;M++){var A=u?N*(M+.5):N*M,D=Math.min(m-1,s?Math.round(A):Math.floor(A));u&&(D=Math.max(0,D));for(var _=F+D*p[1],w=0;w<c;w++){var z=u?x*(w+.5):x*w,W=Math.min(v-1,s?Math.round(z):Math.floor(z));u&&(W=Math.max(0,W));for(var C=_+W*p[2],H=0;H<k;H++){var E=b[C+H];g[T++]=E}}}return n.makeTensorInfo([h,l,c,k],i.dtype,g)}};var er={kernelName:a.ResizeNearestNeighborGrad,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.images,s=t.dy,u=r.alignCorners;o([s,i],"resizeNearestNeighborGrad");for(var d=a.util.computeStrides(i.shape),p=a.util.computeStrides(s.shape),l=i.shape,c=l[0],f=l[1],h=l[2],m=l[3],v=s.shape,k=v[1],b=v[2],g=new Float32Array(c*f*h*m),I=n.data.get(s.dataId).values,y=[u&&k>1?f-1:f,u&&b>1?h-1:h],N=[u&&k>1?k-1:k,u&&b>1?b-1:b],x=y[0]/N[0],T=y[1]/N[1],S=1/x,F=1/T,M=2*Math.ceil(S)+2,A=2*Math.ceil(F)+2,D=0;D<c;D++)for(var _=D*d[0],w=0;w<f;w++)for(var z=_+w*d[1],W=Math.floor(w*S),C=Math.floor(W-M/2),H=0;H<h;H++)for(var E=z+H*d[2],P=Math.floor(H*F),R=Math.floor(P-A/2),B=0;B<m;B++){for(var O=0,L=0;L<M;L++){var V=L+C;if(!(V<0||V>=k)){var G=_+V*p[1],q=V*x;if(w===Math.min(f-1,u?Math.round(q):Math.floor(q)))for(var U=0;U<A;U++){var Z=U+R;if(!(Z<0||Z>=b)){var j=G+Z*p[2],K=Z*T;H===Math.min(h-1,u?Math.round(K):Math.floor(K))&&(O+=I[j+B])}}}}g[E+B]=O}return n.makeTensorInfo(i.shape,i.dtype,g)}};var ar={kernelName:a.Reverse,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,s=r.dims;o(i,"reverse");var u=i.shape.length,d=a.util.parseAxisParam(s,i.shape);if(0===u)return m({inputs:{x:i},backend:n});for(var p=new a.TensorBuffer(i.shape,i.dtype),l=n.bufferSync(i),c=function(e){var a=p.indexToLoc(e),t=a.slice();d.forEach((function(e){return t[e]=i.shape[e]-1-t[e]})),p.set.apply(p,[l.get.apply(l,t)].concat(a))},f=0;f<p.size;f++)c(f);return n.makeTensorInfo(p.shape,p.dtype,p.values)}},tr={kernelName:a.RotateWithOffset,backendName:"cpu",kernelFunc:function(e){for(var t=e.inputs,n=e.attrs,r=e.backend,i=t.image,o=n,s=o.radians,u=o.fillValue,d=o.center,p=r,l=a.util.getTypedArrayFromDType(i.dtype,a.util.sizeFromShape(i.shape)),c=i.shape,f=c[0],h=c[1],m=c[2],v=c[3],k=a.backend_util.getImageCenter(d,h,m),b=k[0],g=k[1],I=Math.sin(s),y=Math.cos(s),N=p.data.get(i.dataId).values,x=0;x<f;x++)for(var T=x*m*h*v,S=0;S<h;S++)for(var F=S*(m*v),M=0;M<m;M++)for(var A=M*v,D=0;D<v;D++){var _=[f,S,M,D],w=_[2],z=_[1],W=(w-b)*y-(z-g)*I,C=(w-b)*I+(z-g)*y;W=Math.round(W+b),C=Math.round(C+g);var H=u;if("number"!=typeof u&&(H=3===D?255:u[D]),W>=0&&W<m&&C>=0&&C<h)H=N[T+C*(m*v)+W*v+D];l[T+F+A+D]=H}return{dataId:p.write(l,i.shape,i.dtype),shape:i.shape,dtype:i.dtype}}},nr=_(a.Round,(function(e){var a=Math.floor(e);return e-a<.5?Math.floor(e):e-a>.5?Math.ceil(e):a%2==0?a:a+1})),rr={kernelName:a.Round,backendName:"cpu",kernelFunc:nr};function ir(e,t,n,r,i,o,s,u,d,p){var l=[r/i,i],c=e.values,f=t.values;if(0===r)return a.buffer(n,t.dtype);var h=a.buffer(l,t.dtype);h.values.fill(d);for(var m=0;m<o;m++){for(var v=[],k=0,b=0;b<s;b++){var g=c[m*s+b];v.push(g),k+=g*u[b]}if(k<0||k>=r/i)throw new Error("Invalid indices: "+v+" does not index into "+n);for(var I=0;I<i;I++)p?h.values[k*i+I]+=f[m*i+I]:h.values[k*i+I]=0===t.rank?f[0]:f[m*i+I]}return h}var or={kernelName:a.ScatterNd,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.indices,o=t.updates,s=r.shape,u=a.backend_util.calculateShapes(o,i,s),d=u.sliceRank,p=u.numUpdates,l=u.sliceSize,c=u.strides,f=u.outputSize,h=ir(n.bufferSync(i),n.bufferSync(o),s,f,l,p,d,c,0,!0);return n.makeTensorInfo(s,h.dtype,h.values)}};var sr={kernelName:a.Select,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=t.condition,i=t.t,s=t.e;o([r,i,s],"select");for(var u=r.shape.length,d=n.data.get(r.dataId).values,p=n.data.get(i.dataId).values,l=n.data.get(s.dataId).values,c=a.upcastType(i.dtype,s.dtype),f=a.util.makeZerosTypedArray(a.util.sizeFromShape(i.shape),c),h=0,m=0===u||u>1||1===i.shape.length?1:a.util.sizeFromShape(i.shape.slice(1)),v=0;v<d.length;v++)for(var k=0;k<m;k++)1===d[v]?f[h++]=p[v]:f[h++]=l[v];return n.makeTensorInfo(i.shape,c,f)}},ur=a.backend_util.SELU_SCALEALPHA,dr=a.backend_util.SELU_SCALE,pr=_(a.Selu,(function(e){return e>=0?dr*e:ur*(Math.exp(e)-1)})),lr={kernelName:a.Selu,backendName:"cpu",kernelFunc:pr},cr=_(a.Sigmoid,(function(e){return 1/(1+Math.exp(-e))})),fr={kernelName:a.Sigmoid,backendName:"cpu",kernelFunc:cr},hr=_(a.Sign,(function(e){return e<0?-1:e>0?1:0})),mr={kernelName:a.Sign,backendName:"cpu",kernelFunc:hr},vr=_(a.Sin,(function(e){return Math.sin(e)})),kr={kernelName:a.Sin,backendName:"cpu",kernelFunc:vr},br=_(a.Sinh,(function(e){return Math.sinh(e)})),gr={kernelName:a.Sinh,backendName:"cpu",kernelFunc:br},Ir=Math.log(1.1920928955078125e-7)+2,yr=_(a.Softplus,(function(e){var a=e>-Ir,t=e<Ir,n=Math.exp(e);return t?n:a?e:Math.log(1+n)})),Nr={kernelName:a.Softplus,backendName:"cpu",kernelFunc:yr};var xr={kernelName:a.SpaceToBatchND,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,s=r.blockShape,u=r.paddings;o([i],"spaceToBatchND");var d=a.util.sizeFromShape(s),p=[[0,0]];p.push.apply(p,u);for(var l=1+s.length;l<i.shape.length;++l)p.push([0,0]);var c=qn.kernelFunc({inputs:{x:i},backend:n,attrs:{paddings:p,constantValue:0}}),f=a.backend_util.getReshaped(c.shape,s,d,!1),h=a.backend_util.getPermuted(f.length,s.length,!1),m=a.backend_util.getReshapedPermuted(c.shape,s,d,!1),v=ea({inputs:{x:c},backend:n,attrs:{shape:f}}),k=ge({inputs:{x:v},backend:n,attrs:{perm:h}}),b=ea({inputs:{x:k},backend:n,attrs:{shape:m}});return n.disposeIntermediateTensorInfo(c),n.disposeIntermediateTensorInfo(v),n.disposeIntermediateTensorInfo(k),b}};var Tr={kernelName:a.SparseToDense,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.sparseIndices,o=t.sparseValues,s=t.defaultValue,u=r.outputShape,d=a.backend_util.calculateShapes(o,i,u),p=d.sliceRank,l=d.numUpdates,c=d.sliceSize,f=d.strides,h=d.outputSize,m=ir(n.bufferSync(i),n.bufferSync(o),u,h,c,l,p,f,n.data.get(s.dataId).values[0],!1);return n.makeTensorInfo(u,m.dtype,m.values)}};var Sr={kernelName:a.SplitV,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,o=r.numOrSizeSplits,s=r.axis,u=a.util.parseAxisParam(s,i.shape)[0],d=a.backend_util.prepareSplitSize(i,o,u),p=new Array(i.shape.length).fill(0),l=i.shape.slice();return d.map((function(e){var a=l.slice();a[u]=e;var t=Ae({inputs:{x:i},backend:n,attrs:{begin:p,size:a}});return p[u]+=e,t}))}},Fr=_(a.Sqrt,(function(e){return Math.sqrt(e)})),Mr={kernelName:a.Sqrt,backendName:"cpu",kernelFunc:Fr},Ar={kernelName:a.Square,backendName:"cpu",kernelFunc:function(e){var a=e.inputs,t=e.backend,n=a.x,r=t;o(n,"square");for(var i=r.data.get(n.dataId).values,s=new Float32Array(i.length),u=0;u<i.length;++u){var d=i[u];s[u]=d*d}return{dataId:r.write(s,n.shape,n.dtype),shape:n.shape,dtype:n.dtype}}},Dr=_(a.Step,(function(e,a){var t=a;return isNaN(e)?NaN:e>0?1:t.alpha})),_r={kernelName:a.Step,backendName:"cpu",kernelFunc:Dr};var wr={kernelName:a.StridedSlice,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,s=r.begin,u=r.end,d=r.strides,p=r.beginMask,l=r.endMask,c=r.ellipsisMask,f=r.newAxisMask,h=r.shrinkAxisMask;o(i,"stridedSlice");var m,v=a.slice_util.sliceInfo(i.shape,s,u,d,p,l,c,f,h),k=v.nonStrided,b=v.$begin,g=v.$strides,I=v.size,y=v.newShape,N=v.outShape,x=ea({inputs:{x:i},backend:n,attrs:{shape:y}});if(k){var T=Ae({inputs:{x:x},backend:n,attrs:{begin:b,size:I}});m=ea({inputs:{x:T},backend:n,attrs:{shape:N}}),n.disposeIntermediateTensorInfo(T)}else if(N.some((function(e){return 0===e})))m=n.makeTensorInfo(N,i.dtype,[]);else{var S=We(N,n.bufferSync(x),g,b);m=n.makeTensorInfo(S.shape,S.dtype,S.values)}var F=ea({inputs:{x:m},backend:n,attrs:{shape:N}});return n.disposeIntermediateTensorInfo(x),n.disposeIntermediateTensorInfo(m),F}},zr=_(a.Tan,(function(e){return Math.tan(e)})),Wr={kernelName:a.Tan,backendName:"cpu",kernelFunc:zr},Cr=_(a.Tanh,(function(e){return Math.tanh(e)})),Hr={kernelName:a.Tanh,backendName:"cpu",kernelFunc:Cr};var Er={kernelName:a.Tile,backendName:"cpu",kernelFunc:function(e){var a=e.inputs,t=e.backend,n=e.attrs,r=a.x,i=n.reps;o(r,"tile");var s=Re(t.bufferSync(r),i);return t.makeTensorInfo(s.shape,s.dtype,s.values)}};var Pr={kernelName:a.TopK,backendName:"cpu",kernelFunc:function(e){var a=e.inputs,t=e.backend,n=e.attrs,r=a.x,i=n.k;n.sorted,o(r,"topk");var s=Be(t.data.get(r.dataId).values,r.shape,r.dtype,i),u=s[0],d=s[1];return[t.makeTensorInfo(u.shape,u.dtype,u.values),t.makeTensorInfo(d.shape,d.dtype,d.values)]}};var Rr={kernelName:a.Unique,backendName:"cpu",kernelFunc:function(e){var a=e.inputs,t=e.attrs,n=e.backend,r=t.axis,i=a.x;o(i,"unique");var s=Oe(n.data.get(i.dataId).values,r,i.shape,i.dtype),u=s.outputValues,d=s.outputShape,p=s.indices;return[n.makeTensorInfo(d,i.dtype,u),n.makeTensorInfo([p.length],"int32",p)]}};var Br={kernelName:a.Unpack,backendName:"cpu",kernelFunc:function(e){var a=e.inputs,t=e.backend,n=e.attrs,r=a.value,i=n.axis;i<0&&(i+=r.shape.length);for(var o=r.shape.length,s=r.shape[i],u=new Array(o-1),d=0,p=0;p<o;p++)p!==i&&(u[d++]=r.shape[p]);var l=new Array(o).fill(0),c=r.shape.slice();c[i]=1;var f=new Array(s);for(p=0;p<f.length;p++){l[i]=p;var h=Ae({inputs:{x:r},backend:t,attrs:{begin:l,size:c}});f[p]=ea({inputs:{x:h},backend:t,attrs:{shape:u}}),t.disposeIntermediateTensorInfo(h)}return f}};for(var Or={kernelName:a.UnsortedSegmentSum,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,s=t.segmentIds,u=r.numSegments;o(i,"unsortedSegmentSum");for(var d=[],p=[],l=i.shape.length-s.shape.length,c=s,f=0;f<l;++f){var h=xt({inputs:{input:c},backend:n,attrs:{dim:f+1}});c=h,p.push(h)}for(f=0;f<u;++f){var m=a.util.createScalarValue(f,"int32"),v=n.makeTensorInfo([],"int32",m),k=ft({inputs:{a:v,b:c},backend:n}),b=g({inputs:{x:k},backend:n,attrs:{dtype:"float32"}}),I=le({inputs:{a:b,b:i},backend:n}),y=yn({inputs:{x:I},backend:n,attrs:{axis:0,keepDims:!1}});d.push(y),p.push(v),p.push(k),p.push(b),p.push(I),p.push(y)}var N=Vn({inputs:d,backend:n,attrs:{axis:0}});return p.forEach((function(e){return n.disposeIntermediateTensorInfo(e)})),N}},Lr=0,Vr=[ra,p,oa,ua,F,da,pa,la,ca,fa,ma,ka,ga,Na,Ta,Aa,Da,_a,wa,na,za,Wa,Ca,I,C,Ea,f,Pa,La,qa,Ua,Ga,ja,Ka,Za,$a,Qa,Xa,et,at,tt,rt,it,ot,st,ut,pt,dt,Mt,Ge,lt,ht,Nt,R,Tt,L,_t,zt,Wt,q,Et,Pt,Rt,Bt,Ot,K,Gt,v,qt,Ba,Zt,Kt,$t,Ue,J,Xt,en,ae,tn,on,un,ln,cn,fn,ie,vn,kn,bn,gn,In,mn,xn,Tn,ue,Sn,An,wn,ce,he,Wn,Hn,Pn,ke,Rn,Ln,Gn,qn,jn,Ke,Ne,Kn,b,$n,$e,Qe,aa,Jn,Qn,Xn,er,ar,tr,rr,Fe,or,sr,lr,fr,mr,kr,gr,De,_n,Nr,xr,Tr,Sr,Mr,Ar,ze,_r,wr,Pe,Nn,Wr,Hr,Er,Pr,Ie,Rr,Br,Or,On];Lr<Vr.length;Lr++){var Gr=Vr[Lr];a.registerKernel(Gr)}e.MathBackendCPU=u,e.shared=Le,e.version_cpu="3.2.0",Object.defineProperty(e,"__esModule",{value:!0})}));
//# sourceMappingURL=tf-backend-cpu.min.js.map
