/**
 * @license
 * Copyright 2021 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
import{util as e,kernel_impls as t,KernelBackend as n,DataStorage as a,engine as s,env as o,backend_util as r,buffer as i,Abs as d,Complex as c,Identity as l,Real as p,Cast as u,Add as h,Ceil as m,Exp as f,Expm1 as k,Floor as I,Greater as g,Less as b,Log as y,Maximum as N,Minimum as x,Multiply as T,Neg as F,NotEqual as S,Transpose as v,upcastType as M,Prod as A,Rsqrt as z,slice_util as D,Slice as w,SquaredDifference as W,Sub as H,TensorBuffer as C,registerBackend as E,Elu as P,LeakyRelu as R,Prelu as $,Relu as O,Relu6 as V,Reshape as _,BatchMatMul as B,_FusedMatMul as L,Acos as G,Acosh as q,AddN as U,All as Z,Any as j,ArgMax as K,ArgMin as Y,Asin as J,Asinh as Q,Atan as X,Atan2 as ee,Atanh as te,AvgPool as ne,AvgPool3D as ae,AvgPool3DGrad as se,AvgPoolGrad as oe,FusedBatchNorm as re,BatchToSpaceND as ie,Bincount as de,ClipByValue as ce,ComplexAbs as le,Imag as pe,Concat as ue,Conv2D as he,Conv2DBackpropFilter as me,Conv2DBackpropInput as fe,Conv3D as ke,Conv3DBackpropFilterV2 as Ie,Conv3DBackpropInputV2 as ge,Cos as be,Cosh as ye,CropAndResize as Ne,Cumsum as xe,DenseBincount as Te,DepthToSpace as Fe,DepthwiseConv2dNative as Se,DepthwiseConv2dNativeBackpropFilter as ve,DepthwiseConv2dNativeBackpropInput as Me,Diag as Ae,Dilation2D as ze,Dilation2DBackpropFilter as De,Dilation2DBackpropInput as we,EluGrad as We,Equal as He,Erf as Ce,ExpandDims as Ee,RealDiv as Pe,FFT as Re,Fill as $e,FlipLeftRight as Oe,FloorDiv as Ve,FusedConv2D as _e,FusedDepthwiseConv2D as Be,GatherNd as Le,GatherV2 as Ge,GreaterEqual as qe,IFFT as Ue,IsFinite as Ze,IsInf as je,IsNan as Ke,LessEqual as Ye,LinSpace as Je,Log1p as Qe,LogicalAnd as Xe,LogicalNot as et,LogicalOr as tt,LRN as nt,LRNGrad as at,Max as st,MaxPool as ot,MaxPool3D as rt,MaxPool3DGrad as it,MaxPoolGrad as dt,MaxPoolWithArgmax as ct,Sum as lt,Mean as pt,Min as ut,MirrorPad as ht,Mod as mt,Softmax as ft,Multinomial as kt,NonMaxSuppressionV3 as It,NonMaxSuppressionV4 as gt,NonMaxSuppressionV5 as bt,OneHot as yt,ZerosLike as Nt,OnesLike as xt,Pack as Tt,PadV2 as Ft,Pow as St,Range as vt,Reciprocal as Mt,ResizeBilinear as At,ResizeBilinearGrad as zt,ResizeNearestNeighbor as Dt,ResizeNearestNeighborGrad as wt,Reverse as Wt,RotateWithOffset as Ht,Round as Ct,ScatterNd as Et,Select as Pt,Selu as Rt,Sigmoid as $t,Sign as Ot,Sin as Vt,Sinh as _t,Softplus as Bt,SpaceToBatchND as Lt,SparseToDense as Gt,SplitV as qt,Sqrt as Ut,Square as Zt,Step as jt,StridedSlice as Kt,Tan as Yt,Tanh as Jt,Tile as Qt,TopK as Xt,Unique as en,Unpack as tn,UnsortedSegmentSum as nn,registerKernel as an}from"@tensorflow/tfjs-core";import{alea as sn}from"seedrandom";function on(t,n){Array.isArray(t)||(t=[t]),t.forEach(t=>{null!=t&&e.assert("complex64"!==t.dtype,()=>`${n} does not support complex64 tensors in the CPU backend.`)})}const rn=t.whereImpl;class dn extends n{constructor(){super(),this.blockSize=48,this.firstUse=!0,this.data=new a(this,s())}nextDataId(){return dn.nextDataId++}write(e,t,n){this.firstUse&&(this.firstUse=!1,o().get("IS_NODE")&&r.warn("\n============================\nHi there 👋. Looks like you are running TensorFlow.js in Node.js. To speed things up dramatically, install our node backend, which binds to TensorFlow C++, by running npm i @tensorflow/tfjs-node, or npm i @tensorflow/tfjs-node-gpu if you have CUDA. Then call require('@tensorflow/tfjs-node'); (-gpu suffix for CUDA) at the start of your program. Visit https://github.com/tensorflow/tfjs-node for more details.\n============================"));const a={id:this.nextDataId()};return this.data.set(a,{values:e,dtype:n,refCount:1}),a}makeTensorInfo(t,n,a){let s;if("string"===n&&null!=a&&a.length>0&&e.isString(a[0])){const o=a.map(t=>e.encodeString(t));s=this.write(o,t,n)}else s=this.write(a,t,n);return{dataId:s,shape:t,dtype:n}}refCount(e){if(this.data.has(e)){return this.data.get(e).refCount}return 0}incRef(e){this.data.get(e).refCount++}decRef(e){if(this.data.has(e)){this.data.get(e).refCount--}}move(e,t,n,a,s){this.data.set(e,{values:t,dtype:a,refCount:s})}numDataIds(){return this.data.numDataIds()}async read(e){return this.readSync(e)}readSync(e){const{dtype:t,complexTensorInfos:n}=this.data.get(e);if("complex64"===t){const e=this.readSync(n.real.dataId),t=this.readSync(n.imag.dataId);return r.mergeRealAndImagArrays(e,t)}return this.data.get(e).values}bufferSync(t){const n=this.readSync(t.dataId);let a=n;if("string"===t.dtype)try{a=n.map(t=>e.decodeString(t))}catch(e){throw new Error("Failed to decode encoded string bytes into utf-8")}return i(t.shape,t.dtype,a)}makeOutput(e,t,n){const a=this.write(e,t,n);return s().makeTensorFromDataId(a,t,n,this)}disposeData(e,t=!1){if(this.data.has(e)){if(this.data.get(e).refCount--,!t&&this.data.get(e).refCount>0)return!1;const{complexTensorInfos:n}=this.data.get(e);null!=n&&(this.disposeData(n.real.dataId,!0),this.disposeData(n.imag.dataId,!0)),this.data.delete(e)}return!0}disposeIntermediateTensorInfo(e){this.disposeData(e.dataId)}async time(t){const n=e.now();return t(),{kernelMs:e.now()-n}}memory(){return{unreliable:!0,reasons:["The reported memory is an upper bound. Due to automatic garbage collection, the true allocated memory may be less."]}}where(e){on([e],"where");const t=this.readSync(e.dataId);return rn(e.shape,t)}dispose(){}floatPrecision(){return 32}epsilon(){return super.epsilon()}}function cn(e){const t=new Float32Array(e.length);for(let n=0;n<e.length;++n)t[n]=Math.abs(e[n]);return t}dn.nextDataId=0;const ln={kernelName:d,backendName:"cpu",kernelFunc:t=>{const{x:n}=t.inputs,a=t.backend;on(n,"abs");let s=new Float32Array(e.sizeFromShape(n.shape));return s=cn(a.data.get(n.dataId).values),a.makeOutput(s,n.shape,"float32")}};function pn(t){return(n,a,s,o,i)=>{const d=r.assertAndGetBroadcastShape(n,a),c=d.length,l=e.computeStrides(d),p=e.sizeFromShape(d),u=e.getTypedArrayFromDType(i,p),h=n.length,m=a.length,f=e.computeStrides(n),k=e.computeStrides(a),I=r.getBroadcastDims(n,d),g=r.getBroadcastDims(a,d);if(I.length+g.length===0)for(let e=0;e<u.length;++e)u[e]=t(s[e%s.length],o[e%o.length]);else for(let n=0;n<u.length;++n){const a=e.indexToLoc(n,c,l),r=a.slice(-h);I.forEach(e=>r[e]=0);const i=e.locToIndex(r,h,f),d=a.slice(-m);g.forEach(e=>d[e]=0);const p=e.locToIndex(d,m,k);u[n]=t(s[i],o[p])}return[u,d]}}function un(e){const{inputs:t,backend:n}=e,{real:a,imag:s}=t,o=n.data.get(a.dataId).values,r=n.data.get(s.dataId).values,i=n.makeTensorInfo(a.shape,"complex64");return n.data.get(i.dataId).complexTensorInfos={real:n.makeTensorInfo(a.shape,"float32",o),imag:n.makeTensorInfo(s.shape,"float32",r)},i}const hn={kernelName:c,backendName:"cpu",kernelFunc:un};function mn(t,n,a="float32"){if("complex64"===a){return un({inputs:{real:mn(t,n,"float32"),imag:mn(t,n,"float32")},backend:t})}const s=e.makeZerosTypedArray(e.sizeFromShape(n),a);return t.makeTensorInfo(n,a,s)}function fn(e){const{inputs:t,backend:n}=e,{x:a}=t;return n.incRef(a.dataId),{dataId:a.dataId,shape:a.shape,dtype:a.dtype}}const kn={kernelName:l,backendName:"cpu",kernelFunc:fn};function In(e){const{inputs:t,backend:n}=e,{input:a}=t,s=n.data.get(a.dataId).complexTensorInfos.real,o=n.data.get(s.dataId).values;return n.makeTensorInfo(s.shape,s.dtype,o)}const gn={kernelName:p,backendName:"cpu",kernelFunc:In};function bn(t){const{inputs:n,backend:a,attrs:s}=t,{x:o}=n,{dtype:r}=s;if("complex64"===r){if("complex64"===o.dtype)return fn({inputs:{x:o},backend:a});const e=mn(a,o.shape,o.dtype),t=bn({inputs:{x:o},backend:a,attrs:{dtype:"float32"}}),n=un({inputs:{real:t,imag:e},backend:a});return a.disposeIntermediateTensorInfo(e),a.disposeIntermediateTensorInfo(t),n}if("complex64"===o.dtype){const e=In({inputs:{input:o},backend:a}),t=bn({inputs:{x:e},backend:a,attrs:{dtype:r}});return a.disposeIntermediateTensorInfo(e),t}if(!e.hasEncodingLoss(o.dtype,r)){const e=fn({inputs:{x:o},backend:a});return{dataId:e.dataId,shape:e.shape,dtype:r}}if("int32"===r){const e=a.data.get(o.dataId).values,t=Int32Array.from(e);return a.makeTensorInfo(o.shape,"int32",t)}if("bool"===r){const t=a.data.get(o.dataId).values,n=e.toTypedArray([0],o.dtype),[s,r]=pn((e,t)=>e!==t?1:0)(o.shape,[],t,n,"bool");return a.makeTensorInfo(r,"bool",s)}throw new Error(`Error in Cast: failed to cast ${o.dtype} to ${r}`)}const yn={kernelName:u,backendName:"cpu",kernelFunc:bn};function Nn(e,t,n,a){return null==n?({inputs:n,backend:s})=>{const{a:o,b:r}=n,i=s;on([o,r],e);const d=i.data.get(o.dataId).values,c=i.data.get(r.dataId).values,l=a||o.dtype,[p,u]=t(o.shape,r.shape,d,c,l);return i.makeTensorInfo(u,l,p)}:({inputs:e,backend:s})=>{const{a:o,b:r}=e,i=s;if("complex64"===o.dtype||"complex64"===r.dtype){const e=bn({inputs:{x:o},backend:i,attrs:{dtype:"complex64"}}),t=i.data.get(e.dataId),a=t.complexTensorInfos.real,s=t.complexTensorInfos.imag,d=i.data.get(a.dataId).values,c=i.data.get(s.dataId).values,l=bn({inputs:{x:r},backend:i,attrs:{dtype:"complex64"}}),p=i.data.get(l.dataId),u=p.complexTensorInfos.real,h=p.complexTensorInfos.imag,m=i.data.get(u.dataId).values,f=i.data.get(h.dataId).values,[k,I,g]=n(o.shape,r.shape,d,c,m,f),b=i.makeTensorInfo(g,"float32",k),y=i.makeTensorInfo(g,"float32",I),N=un({inputs:{real:b,imag:y},backend:i});return i.disposeIntermediateTensorInfo(e),i.disposeIntermediateTensorInfo(l),i.disposeIntermediateTensorInfo(b),i.disposeIntermediateTensorInfo(y),N}{const e=i.data.get(o.dataId).values,n=i.data.get(r.dataId).values,s=a||o.dtype,[d,c]=t(o.shape,r.shape,e,n,s);return i.makeTensorInfo(c,s,d)}}}function xn(t){return(n,a,s,o,i,d)=>{const c=r.assertAndGetBroadcastShape(n,a),l=e.sizeFromShape(c),p=c.length,u=e.computeStrides(c),h=e.getTypedArrayFromDType("float32",l),m=e.getTypedArrayFromDType("float32",l),f=r.getBroadcastDims(n,c),k=r.getBroadcastDims(a,c),I=r.mergeRealAndImagArrays(s,o),g=r.mergeRealAndImagArrays(i,d),b=n.length,y=e.computeStrides(n),N=a.length,x=e.computeStrides(a);if(f.length+k.length===0)for(let e=0;e<h.length;e++){const n=e%I.length,a=e%g.length,s=t(I[2*n],I[2*n+1],g[2*a],g[2*a+1]);h[e]=s.real,m[e]=s.imag}else for(let n=0;n<h.length;n++){const a=e.indexToLoc(n,p,u),s=a.slice(-b);f.forEach(e=>s[e]=0);const o=e.locToIndex(s,b,y),r=a.slice(-N);k.forEach(e=>r[e]=0);const i=e.locToIndex(r,N,x),d=t(I[2*o],I[2*o+1],g[2*i],g[2*i+1]);h[n]=d.real,m[n]=d.imag}return[h,m,c]}}const Tn=pn((e,t)=>e+t),Fn=Nn(h,Tn,xn((e,t,n,a)=>({real:e+n,imag:t+a}))),Sn={kernelName:h,backendName:"cpu",kernelFunc:Fn};function vn(t,n,a,s,o){const r=e.sizeFromShape(s),i=e.makeZerosTypedArray(o,a);for(let e=0;e<t.length;e++){const a=t[e];if(a<0)throw new Error("Input x must be non-negative!");a>=o||(i[a]+=r>0?n[e]:1)}return i}function Mn(e,t,n,a=!1){const s=e.shape[0],o=e.shape[1],r=i([s,n],t.dtype);for(let i=0;i<s;i++)for(let s=0;s<o;s++){const o=e.get(i,s);if(o<0)throw new Error("Input x must be non-negative!");o>=n||(a?r.set(1,i,o):t.size>0?r.set(r.get(i,o)+t.get(i,s),i,o):r.set(r.get(i,o)+1,i,o))}return r}function An(t){return(n,a,s)=>{const o=e.getTypedArrayFromDType(a,n.length);for(let e=0;e<n.length;++e)o[e]=t(n[e],s);return o}}function zn(t,n,a){return({inputs:s,attrs:o,backend:r})=>{const{x:i}=s;if(on(i,t),"string"===i.dtype||"string"===a)throw new Error("unaryKernelFunc does not support string input/output");const d=r,c=d.data.get(i.dataId).values,l=e.sizeFromShape(i.shape),p=a||i.dtype,u=e.getArrayFromDType(p,l);for(let e=0;e<l;++e)u[e]=n(c[e],o);return d.makeTensorInfo(i.shape,p,u)}}function Dn(e,t,n){return({inputs:a,attrs:s,backend:o})=>{const{x:r}=a;if(on(r,e),"string"===r.dtype||"string"===n)throw new Error("unaryKernelFunc does not support string input/output");const i=o,d=i.data.get(r.dataId).values,c=n||r.dtype,l=t(d,c,s);return i.makeTensorInfo(r.shape,c,l)}}const wn=An(e=>Math.ceil(e)),Wn={kernelName:m,backendName:"cpu",kernelFunc:Dn(m,wn)};function Hn(t,n,a,s){const o=e.getArrayFromDType(a,e.sizeFromShape(n));if(s&&"string"!==a){let n=0;t.forEach(t=>{const a=e.sizeFromShape(t.shape);o.set(t.vals,n),n+=a})}else{let e=0;t.forEach(t=>{const s="string"===a?r.fromUint8ToStringArray(t.vals):t.vals;let i=0;for(let a=0;a<t.shape[0];++a){const r=a*n[1]+e;for(let e=0;e<t.shape[1];++e)o[r+e]=s[i++]}e+=t.shape[1]})}return o}const Cn=An(e=>Math.exp(e)),En=Dn(f,Cn),Pn={kernelName:f,backendName:"cpu",kernelFunc:En},Rn=An(e=>Math.expm1(e)),$n={kernelName:k,backendName:"cpu",kernelFunc:Dn(k,Rn)},On=An(e=>Math.floor(e)),Vn={kernelName:I,backendName:"cpu",kernelFunc:Dn(I,On)};function _n(e,t,n){const a=i(n,e.dtype);for(let n=0;n<a.size;++n){const s=a.indexToLoc(n).slice(),o=s[0],r=s[2],i=t.locToIndex([o,r]);s[2]=t.values[i];const d=e.locToIndex(s);a.values[n]=e.values[d]}return a}const Bn=pn((e,t)=>e>t?1:0),Ln={kernelName:g,backendName:"cpu",kernelFunc:Nn(g,Bn,null,"bool")},Gn=pn((e,t)=>e<t?1:0),qn={kernelName:b,backendName:"cpu",kernelFunc:Nn(b,Gn,null,"bool")};function Un(t,n,a){const s=(n-t)/(a-1),o=e.makeZerosTypedArray(a,"float32");o[0]=t;for(let e=1;e<o.length;e++)o[e]=o[e-1]+s;return o}const Zn=An(e=>Math.log(e)),jn={kernelName:y,backendName:"cpu",kernelFunc:Dn(y,Zn)};function Kn(t,n,a,s){const o=e.getTypedArrayFromDType(s,e.sizeFromShape(a));for(let e=0;e<o.length;++e){const a=e*n;let s=t[a];for(let e=0;e<n;++e){const n=t[a+e];n>s&&(s=n)}o[e]=s}return o}const Yn=pn((e,t)=>Math.max(e,t)),Jn={kernelName:N,backendName:"cpu",kernelFunc:Nn(N,Yn)},Qn=pn((e,t)=>Math.min(e,t)),Xn={kernelName:x,backendName:"cpu",kernelFunc:Nn(x,Qn)},ea=pn((e,t)=>e*t),ta=xn((e,t,n,a)=>({real:e*n-t*a,imag:e*a+t*n})),na=Nn(T,ea,ta),aa={kernelName:T,backendName:"cpu",kernelFunc:na};function sa(t,n,a){const s=e.createScalarValue(-1,a);return ea([],n,s,t,a)}const oa={kernelName:F,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{x:a}=t;on(a,"neg");const s=n.data.get(a.dataId).values,[o,r]=sa(s,a.shape,a.dtype);return n.makeTensorInfo(r,a.dtype,o)}},ra=pn((e,t)=>e!==t?1:0),ia={kernelName:S,backendName:"cpu",kernelFunc:Nn(S,ra,null,"bool")};function da(t,n,a,s,o){const r=n.length,i=e.sizeFromShape(n),d=e.computeStrides(n),c=e.computeStrides(o),l=e.getTypedArrayFromDType(a,e.sizeFromShape(o));for(let n=0;n<i;++n){const a=e.indexToLoc(n,r,d),o=new Array(a.length);for(let e=0;e<o.length;e++)o[e]=a[s[e]];l[e.locToIndex(o,r,c)]=t[n]}return l}function ca(e){const{inputs:t,attrs:n,backend:a}=e,{x:s}=t,{perm:o}=n;on(s,"transpose");const r=s.shape.length,i=new Array(r);for(let e=0;e<i.length;e++)i[e]=s.shape[o[e]];const d=da(a.data.get(s.dataId).values,s.shape,s.dtype,o,i);return{dataId:a.write(d,i,s.dtype),shape:i,dtype:s.dtype}}const la={kernelName:v,backendName:"cpu",kernelFunc:ca};function pa(t,n,a,s){const[o,i]=r.computeOutAndReduceShapes(t,s),d=M(n,"int32"),c=e.makeZerosTypedArray(e.sizeFromShape(o),d),l=e.sizeFromShape(i);for(let e=0;e<c.length;++e){const t=e*l;let n=1;for(let e=0;e<l;++e)n*=a[t+e];c[e]=n}return{outVals:c,outShape:o,outDtype:d}}const ua={kernelName:A,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o}=n,{axis:i,keepDims:d}=s;on(o,"prod");const c=o.shape.length,l=e.parseAxisParam(i,o.shape),p=r.getAxesPermutation(l,c);let u=l,h=o;const m=[];null!=p&&(h=ca({inputs:{x:o},backend:a,attrs:{perm:p}}),m.push(h),u=r.getInnerMostAxes(u.length,c));const f=a.data.get(h.dataId).values,{outVals:k,outShape:I,outDtype:g}=pa(h.shape,h.dtype,f,u);let b=I;return d&&(b=r.expandShapeToKeepDim(I,l)),m.forEach(e=>a.disposeIntermediateTensorInfo(e)),a.makeTensorInfo(b,g,k)}};function ha(t,n,a,s){if(t===n||t<n&&a<0||n<t&&a>1)return e.makeZerosTypedArray(0,s);const o=Math.abs(Math.ceil((n-t)/a)),r=e.makeZerosTypedArray(o,s);n<t&&1===a&&(a=-1),r[0]=t;for(let e=1;e<r.length;e++)r[e]=r[e-1]+a;return r}const ma=An(e=>1/Math.sqrt(e)),fa={kernelName:z,backendName:"cpu",kernelFunc:Dn(z,ma)};function ka(t,n,a,s,o){const d=D.isSliceContinous(s,n,a),c=e.sizeFromShape(a),l=e.computeStrides(s);if(d){const e=D.computeFlatOffset(n,l);return"string"===o?t.slice(e,e+c):t.subarray(e,e+c)}const p="string"===o?r.fromUint8ToStringArray(t):t,u=i(s,o,p),h=i(a,o);for(let e=0;e<h.size;++e){const t=h.indexToLoc(e),a=t.map((e,t)=>e+n[t]);h.set(u.get(...a),...t)}return"string"===o?r.fromStringArrayToUint8(h.values):h.values}function Ia(e){const{inputs:t,backend:n,attrs:a}=e,{x:s}=t,{begin:o,size:r}=a;on(s,"slice");const[i,d]=D.parseSliceParams(s,o,r);D.assertParamsValid(s,i,d);const c=ka(n.data.get(s.dataId).values,i,d,s.shape,s.dtype);return n.makeTensorInfo(d,s.dtype,c)}const ga={kernelName:w,backendName:"cpu",kernelFunc:Ia},ba=pn((e,t)=>{const n=e-t;return n*n}),ya={kernelName:W,backendName:"cpu",kernelFunc:Nn(W,ba)};function Na(e,t,n,a){const s=i(e,t.dtype);for(let e=0;e<s.size;e++){const o=s.indexToLoc(e),r=new Array(o.length);for(let e=0;e<r.length;e++)r[e]=o[e]*n[e]+a[e];s.set(t.get(...r),...o)}return s}const xa=pn((e,t)=>e-t),Ta=Nn(H,xa,xn((e,t,n,a)=>({real:e-n,imag:t-a}))),Fa={kernelName:H,backendName:"cpu",kernelFunc:Ta};function Sa(e,t){const n=new Array(e.rank);for(let a=0;a<n.length;a++)n[a]=e.shape[a]*t[a];const a=i(n,e.dtype);for(let t=0;t<a.values.length;++t){const n=a.indexToLoc(t),s=new Array(e.rank);for(let t=0;t<s.length;t++)s[t]=n[t]%e.shape[t];const o=e.locToIndex(s);a.values[t]=e.values[o]}return a}function va(t,n,a,s,o){const r=n[n.length-1],[d,c]=[t.length/r,r],l=e.getTypedArrayFromDType(a,d*s),p=e.getTypedArrayFromDType("int32",d*s);for(let e=0;e<d;e++){const n=e*c,a=t.subarray(n,n+c),o=[];for(let e=0;e<a.length;e++)o.push({value:a[e],index:e});o.sort((e,t)=>t.value-e.value);const r=e*s,i=l.subarray(r,r+s),d=p.subarray(r,r+s);for(let e=0;e<s;e++)i[e]=o[e].value,d[e]=o[e].index}const u=n.slice();return u[u.length-1]=s,[i(u,a,l),i(u,"int32",p)]}function Ma(t,n,a,s){const o=e.parseAxisParam(n,a)[0],r=[1,a[0],1];for(let e=0;e<o;e++)r[0]*=a[e];r[1]=a[o];for(let e=o+1;e<a.length;e++)r[2]*=a[e];const i={},d=new Int32Array(a[o]),c=new C(r,s,t),l=[],p=1===r[0]&&1===r[2];for(let e=0;e<a[o];e++){let n;if(p)n=t[e].toString();else{const t=[];for(let n=0;n<r[0];n++)for(let a=0;a<r[2];a++)t.push(c.get(n,e,a));n=t.join(",")}if(void 0!==i[n])d[e]=i[n];else{const t=Object.keys(i).length;i[n]=t,d[e]=t,l.push(e)}}const u=r.slice();u[1]=Object.keys(i).length;const h=new C(u,s);l.forEach((e,t)=>{for(let n=0;n<r[0];n++)for(let a=0;a<r[2];a++)h.set(c.get(n,e,a),n,t,a)});const m=a.slice();return m[o]=u[1],{outputValues:h.values,outputShape:m,indices:d}}var Aa=Object.freeze({__proto__:null,simpleAbsImpl:cn,addImpl:Tn,bincountImpl:vn,bincountReduceImpl:Mn,ceilImpl:wn,concatImpl:Hn,expImpl:Cn,expm1Impl:Rn,floorImpl:On,gatherV2Impl:_n,greaterImpl:Bn,lessImpl:Gn,linSpaceImpl:Un,logImpl:Zn,maxImpl:Kn,maximumImpl:Yn,minimumImpl:Qn,multiplyImpl:ea,negImpl:sa,notEqualImpl:ra,prodImpl:pa,rangeImpl:ha,rsqrtImpl:ma,sliceImpl:ka,squaredDifferenceImpl:ba,stridedSliceImpl:Na,subImpl:xa,tileImpl:Sa,topKImpl:va,transposeImpl:da,uniqueImpl:Ma});const za="3.2.0";E("cpu",()=>new dn,1);const Da=zn(P,e=>e>=0?e:Math.exp(e)-1),wa={kernelName:P,backendName:"cpu",kernelFunc:Da};function Wa(t){const{inputs:n,backend:a,attrs:s}=t,{x:o}=n,{alpha:r}=s;on([o],"leakyRelu");const i=e.sizeFromShape(o.shape),d=a.data.get(o.dataId).values,c=e.getTypedArrayFromDType("float32",i);for(let e=0;e<d.length;e++)c[e]=d[e]<0?r*d[e]:d[e];return a.makeTensorInfo(o.shape,"float32",c)}const Ha={kernelName:R,backendName:"cpu",kernelFunc:Wa},Ca=pn((e,t)=>e<0?t*e:e);function Ea(e){const{inputs:t,backend:n}=e,{x:a,alpha:s}=t;on([a,s],"prelu");const o=n.data.get(a.dataId).values,r=n.data.get(s.dataId).values,[i,d]=Ca(a.shape,s.shape,o,r,a.dtype);return n.makeTensorInfo(d,a.dtype,i)}const Pa={kernelName:$,backendName:"cpu",kernelFunc:Ea},Ra=zn(O,e=>Math.max(0,e)),$a={kernelName:O,backendName:"cpu",kernelFunc:Ra},Oa=zn(V,e=>Math.min(Math.max(0,e),6)),Va={kernelName:V,backendName:"cpu",kernelFunc:Oa};function _a(e,t,n,a,s){if("linear"===n)return fn({inputs:{x:t},backend:e});if("relu"===n)return Ra({inputs:{x:t},backend:e});if("elu"===n)return Da({inputs:{x:t},backend:e});if("relu6"===n)return Oa({inputs:{x:t},backend:e});if("prelu"===n)return Ea({inputs:{x:t,alpha:a},backend:e});if("leakyrelu"===n)return Wa({inputs:{x:t},backend:e,attrs:{alpha:s}});throw new Error(`Activation ${n} has not been implemented for the CPU backend.`)}function Ba(t){const{inputs:n,backend:a,attrs:s}=t,{x:o}=n,{shape:r}=s,i=e.sizeFromShape(o.shape),d=e.inferFromImplicitShape(r,i),c=e.sizeFromShape(d);e.assert(i===c,()=>`The new shape (${d}) has ${c} elements and the old `+`shape (${o.shape}) has ${i} elements. The new shape and old `+"shape must have the same number of elements."),a.incRef(o.dataId);const l=a.data.get(o.dataId);if(null!=l.complexTensorInfos){const e=l.complexTensorInfos.real,t=l.complexTensorInfos.imag;e.shape=d,t.shape=d}return{dataId:o.dataId,shape:d,dtype:o.dtype}}const La={kernelName:_,backendName:"cpu",kernelFunc:Ba};function Ga(t){const{inputs:n,backend:a,attrs:s}=t,{a:o,b:r}=n,{transposeA:d,transposeB:c}=s;on([o,r],"matMul");const l=o.shape.length,p=r.shape.length,u=d?o.shape[l-2]:o.shape[l-1],h=c?r.shape[p-1]:r.shape[p-2],m=d?o.shape[l-1]:o.shape[l-2],f=c?r.shape[p-2]:r.shape[p-1],k=o.shape.slice(0,-2),I=r.shape.slice(0,-2),g=e.sizeFromShape(k),b=e.sizeFromShape(I),y=g===b||1===g||1===b;e.assert(l>=2&&p>=2&&y,()=>"Error in matMul: the input batch dimensions must either be the same or at least one input batch dimension must be 1. Got input "+`batch dimensions of (${k}) and (${I}).`);const N=(g>b?o.shape.slice(0,-2):r.shape.slice(0,-2)).concat([m,f]);e.assert(u===h,()=>`Error in matMul: inner shapes (${u}) and (`+`${h}) of Tensors with shapes ${o.shape} and `+`${r.shape} and transposeA=${d}`+` and transposeB=${c} must match.`);const x=c?[b,f,h]:[b,h,f],T=Ba({inputs:{x:o},backend:a,attrs:{shape:d?[g,u,m]:[g,m,u]}}),F=Ba({inputs:{x:r},backend:a,attrs:{shape:x}}),S=d?T.shape[1]:T.shape[2],v=d?T.shape[2]:T.shape[1],M=c?F.shape[1]:F.shape[2],A=Math.max(g,b),z=a.data.get(T.dataId).values,D=a.data.get(F.dataId).values,w=e.computeStrides(T.shape),W=e.computeStrides(F.shape),[H,C,E]=d?[w[0],1,w[1]]:[w[0],w[1],1],[P,R,$]=c?[1,W[1],W[0]]:[W[1],1,W[0]],O=v*M,V=i([A,v,M],T.dtype),_=V.values,B=a.blockSize;for(let e=0;e<A;e++)for(let t=0;t<v;t+=B)for(let n=0;n<M;n+=B)for(let a=0;a<S;a+=B){const s=Math.min(t+B,v),o=Math.min(n+B,M),r=Math.min(a+B,S);for(let i=t;i<s;i++)for(let t=n;t<o;t++){let n=0;for(let s=a;s<r;s++){const a=Math.min(e,g-1)*H,o=Math.min(e,b-1)*$;n+=z[a+i*C+s*E]*D[s*P+t*R+o]}_[e*O+(i*M+t)]+=n}}return a.disposeIntermediateTensorInfo(T),a.disposeIntermediateTensorInfo(F),a.makeTensorInfo(N,V.dtype,V.values)}const qa={kernelName:B,backendName:"cpu",kernelFunc:Ga};const Ua={kernelName:L,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{a:s,b:o,bias:r,preluActivationWeights:i}=t,{transposeA:d,transposeB:c,activation:l,leakyreluAlpha:p}=a;let u,h,m;const f=[];u=Ga({inputs:{a:s,b:o},attrs:{transposeA:d,transposeB:c},backend:n}),r&&(h=Fn({inputs:{a:u,b:r},backend:n}),f.push(u),u=h),l&&(m=_a(n,u,l,i,p),f.push(u),u=m);for(const e of f)n.disposeIntermediateTensorInfo(e);return u}},Za={kernelName:G,backendName:"cpu",kernelFunc:zn(G,e=>Math.acos(e))},ja={kernelName:q,backendName:"cpu",kernelFunc:zn(q,e=>Math.acosh(e))};const Ka={kernelName:U,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,a=t;on(t,"addN");const s=a.map(e=>n.data.get(e.dataId).values),o=i(a[0].shape,a[0].dtype),r=o.values;for(let e=0;e<a.length;e++){const t=s[e];for(let e=0;e<r.length;e++)r[e]+=t[e]}return n.makeTensorInfo(o.shape,o.dtype,o.values)}};const Ya={kernelName:Z,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o}=n,{axis:i,keepDims:d}=s;on(o,"all");const c=e.parseAxisParam(i,o.shape);let l=c;const p=r.getAxesPermutation(l,o.shape.length);let u=o;null!=p&&(u=ca({inputs:{x:o},backend:a,attrs:{perm:p}}),l=r.getInnerMostAxes(l.length,o.shape.length)),r.assertAxesAreInnerMostDims("all",l,u.shape.length);const[h,m]=r.computeOutAndReduceShapes(u.shape,l),f=e.sizeFromShape(m),k=e.makeZerosTypedArray(e.sizeFromShape(h),u.dtype),I=a.data.get(u.dataId).values;for(let e=0;e<k.length;++e){const t=e*f;let n=I[t];for(let e=0;e<f;++e){const a=I[t+e];n=n&&a}k[e]=n}null!=p&&a.disposeIntermediateTensorInfo(u);const g=a.makeTensorInfo(h,u.dtype,k);if(d){const e=Ba({inputs:{x:g},backend:a,attrs:{shape:r.expandShapeToKeepDim(h,c)}});return a.disposeIntermediateTensorInfo(g),e}return g}};const Ja={kernelName:j,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o}=n,{axis:i,keepDims:d}=s;on(o,"any");const c=e.parseAxisParam(i,o.shape);let l=c;const p=r.getAxesPermutation(l,o.shape.length);let u=o;null!=p&&(u=ca({inputs:{x:o},backend:a,attrs:{perm:p}}),l=r.getInnerMostAxes(l.length,o.shape.length)),r.assertAxesAreInnerMostDims("any",l,u.shape.length);const[h,m]=r.computeOutAndReduceShapes(u.shape,l),f=e.sizeFromShape(m),k=e.makeZerosTypedArray(e.sizeFromShape(h),u.dtype),I=a.data.get(u.dataId).values;for(let e=0;e<k.length;++e){const t=e*f;let n=I[t];for(let e=0;e<f;++e){const a=I[t+e];n=n||a}k[e]=n}null!=p&&a.disposeIntermediateTensorInfo(u);const g=a.makeTensorInfo(h,u.dtype,k);if(d){const e=Ba({inputs:{x:g},backend:a,attrs:{shape:r.expandShapeToKeepDim(h,c)}});return a.disposeIntermediateTensorInfo(g),e}return g}};const Qa={kernelName:K,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o}=n,{axis:i}=s;on(o,"argMax");let d=e.parseAxisParam(i,o.shape);const c=r.getAxesPermutation(d,o.shape.length);let l=o;const p=[];null!=c&&(l=ca({inputs:{x:o},backend:a,attrs:{perm:c}}),p.push(l),d=r.getInnerMostAxes(d.length,l.shape.length)),d=[d[0]],r.assertAxesAreInnerMostDims("argMax",d,l.shape.length);const[u,h]=r.computeOutAndReduceShapes(l.shape,d),m=e.sizeFromShape(u),f=e.makeZerosTypedArray(m,"int32"),k=e.sizeFromShape(h),I=a.data.get(l.dataId).values;for(let e=0;e<f.length;++e){const t=e*k;let n=I[t],a=0;for(let e=0;e<k;++e){const s=I[t+e];s>n&&(n=s,a=e)}f[e]=a}return p.forEach(e=>a.disposeIntermediateTensorInfo(e)),a.makeTensorInfo(u,"int32",f)}};const Xa={kernelName:Y,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o}=n,{axis:i}=s;on(o,"argMin");let d=e.parseAxisParam(i,o.shape);const c=r.getAxesPermutation(d,o.shape.length);let l=o;const p=[];null!=c&&(l=ca({inputs:{x:o},backend:a,attrs:{perm:c}}),p.push(l),d=r.getInnerMostAxes(d.length,l.shape.length)),d=[d[0]],r.assertAxesAreInnerMostDims("argMin",d,l.shape.length);const[u,h]=r.computeOutAndReduceShapes(l.shape,d),m=e.sizeFromShape(u),f=e.makeZerosTypedArray(m,"int32"),k=e.sizeFromShape(h),I=a.data.get(l.dataId).values;for(let e=0;e<f.length;++e){const t=e*k;let n=I[t],a=0;for(let e=0;e<k;++e){const s=I[t+e];s<n&&(n=s,a=e)}f[e]=a}return p.forEach(e=>a.disposeIntermediateTensorInfo(e)),a.makeTensorInfo(u,"int32",f)}},es={kernelName:J,backendName:"cpu",kernelFunc:zn(J,e=>Math.asin(e))},ts={kernelName:Q,backendName:"cpu",kernelFunc:zn(Q,e=>Math.asinh(e))},ns={kernelName:X,backendName:"cpu",kernelFunc:zn(X,e=>Math.atan(e))},as={kernelName:ee,backendName:"cpu",kernelFunc:Nn(ee,pn((e,t)=>Math.atan2(e,t)))},ss={kernelName:te,backendName:"cpu",kernelFunc:zn(te,e=>Math.atanh(e))};function os(e,t,n,a,s,o){const r=s.strideHeight,d=s.strideWidth,c=s.dilationHeight,l=s.dilationWidth,p=s.effectiveFilterHeight,u=s.effectiveFilterWidth,h=s.padInfo.top,m=s.padInfo.left,f="max"===o?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY,k=i(s.outShape,n),I=k.values,g=s.outShape[1]*s.outShape[2]*s.outShape[3],b=s.outShape[2]*s.outShape[3],y=s.outShape[3];for(let t=0;t<s.batchSize;++t){const n=t*g,i=t*a[0];for(let t=0;t<s.inChannels;++t)for(let k=0;k<s.outHeight;++k){const g=k*r-h,N=Math.max(0,g),x=Math.min(s.inHeight,p+g),T=n+k*b;for(let n=0;n<s.outWidth;++n){const r=n*d-m,p=Math.max(0,r),h=Math.min(s.inWidth,u+r);let k=f,g=0,b=0;for(let n=N;n<x;n+=c){const s=i+n*a[1];for(let n=p;n<h;n+=l){const r=e[s+n*a[2]+t];"max"===o&&r>k?k=r:"avg"===o&&(g+=r,b++)}if(isNaN(k))break}I[T+n*y+t]="avg"===o?g/b:k}}}return k}function rs(e,t,n,a,s=!1,o=!1){const r=i(a.outShape,"int32"),d=a.strideHeight,c=a.strideWidth,l=a.dilationHeight,p=a.dilationWidth,u=a.effectiveFilterHeight,h=a.effectiveFilterWidth,m=a.padInfo.top,f=a.padInfo.left,k=i(t,n,e);for(let e=0;e<a.batchSize;++e)for(let t=0;t<a.inChannels;++t)for(let n=0;n<a.outHeight;++n){const i=n*d-m;let I=i;for(;I<0;)I+=l;const g=Math.min(a.inHeight,u+i);for(let d=0;d<a.outWidth;++d){const u=d*c-f;let m=u;for(;m<0;)m+=p;const b=Math.min(a.inWidth,h+u);let y=Number.NEGATIVE_INFINITY,N=-1;for(let n=I;n<g;n+=l){const r=n-i;for(let i=m;i<b;i+=p){const d=i-u,c=k.get(e,n,i,t);c>y&&(y=c,N=s?o?((e*a.inHeight+n)*a.inWidth+i)*a.inChannels+t:(n*a.inWidth+i)*a.inChannels+t:r*h+d)}}r.set(N,e,n,d,t)}}return r}function is(e,t,n,a,s,o){const r=s.strideDepth,d=s.strideHeight,c=s.strideWidth,l=s.dilationDepth,p=s.dilationHeight,u=s.dilationWidth,h=s.effectiveFilterDepth,m=s.effectiveFilterHeight,f=s.effectiveFilterWidth,k=s.padInfo.front,I=s.padInfo.top,g=s.padInfo.left,b="max"===o?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY,y=i(s.outShape,n),N=y.values,x=s.outShape[1]*s.outShape[2]*s.outShape[3]*s.outShape[4],T=s.outShape[2]*s.outShape[3]*s.outShape[4],F=s.outShape[3]*s.outShape[4],S=s.outShape[4];for(let t=0;t<s.batchSize;++t){const n=t*x,i=t*a[0];for(let t=0;t<s.inChannels;++t)for(let y=0;y<s.outDepth;++y){const x=y*r-k;let v=x;for(;v<0;)v+=l;const M=Math.min(s.inDepth,h+x),A=n+y*T;for(let n=0;n<s.outHeight;++n){const r=n*d-I;let h=r;for(;h<0;)h+=p;const k=Math.min(s.inHeight,m+r),y=A+n*F;for(let n=0;n<s.outWidth;++n){const r=n*c-g;let d=r;for(;d<0;)d+=u;const m=Math.min(s.inWidth,f+r),I=y+n*S;let x=b,T=0,F=0;for(let n=v;n<M;n+=l){const s=i+n*a[1];for(let n=h;n<k;n+=p){const r=s+n*a[2];for(let n=d;n<m;n+=u){const s=e[r+n*a[3]+t];if("max"===o&&s>x?x=s:"avg"===o&&(T+=s,F++),isNaN(x))break}if(isNaN(x))break}if(isNaN(x))break}N[I+t]="avg"===o?T/F:x}}}}return y}const ds={kernelName:ne,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o}=n;on(o,"avgPool");const{filterSize:i,strides:d,pad:c,dimRoundingMode:l}=s;e.assert(r.eitherStridesOrDilationsAreOne(d,1),()=>"Error in avgPool: Either strides or dilations must be 1. "+`Got strides ${d} and dilations '1'`);const p=r.computePool2DInfo(o.shape,i,d,1,c,l);let u;if(1===p.filterWidth&&1===p.filterHeight&&e.arraysEqual(p.inShape,p.outShape))u=fn({inputs:{x:o},backend:a});else{const t=a.data.get(o.dataId).values,n=e.computeStrides(o.shape),s=os(t,o.shape,o.dtype,n,p,"avg");u=a.makeTensorInfo(p.outShape,o.dtype,s.values)}return u}};const cs={kernelName:ae,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o}=n,{filterSize:i,strides:d,pad:c,dimRoundingMode:l,dataFormat:p}=s;on(o,"avgPool3d");const u=r.computePool3DInfo(o.shape,i,d,1,c,l,p),h=is(a.data.get(o.dataId).values,o.shape,o.dtype,e.computeStrides(o.shape),u,"avg");return a.makeTensorInfo(h.shape,"float32",h.values)}};const ls={kernelName:se,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{dy:s,input:o}=t,{filterSize:d,strides:c,pad:l,dimRoundingMode:p}=a;on([s,o],"avgPool3DGrad");const u=r.computePool3DInfo(o.shape,d,c,1,l,p),h=u.strideDepth,m=u.strideHeight,f=u.strideWidth,k=u.filterDepth,I=u.filterHeight,g=u.filterWidth,b=u.dilationDepth,y=u.dilationHeight,N=u.dilationWidth,x=u.effectiveFilterDepth,T=u.effectiveFilterHeight,F=u.effectiveFilterWidth,S=x-1-u.padInfo.front,v=F-1-u.padInfo.left,M=T-1-u.padInfo.top,A=i(o.shape,"float32"),z=1/(k*I*g),D=n.bufferSync(s);for(let e=0;e<u.batchSize;++e)for(let t=0;t<u.inChannels;++t)for(let n=0;n<u.inDepth;++n)for(let a=0;a<u.inHeight;++a)for(let s=0;s<u.inWidth;++s){const o=n-S,r=a-M,i=s-v;let d=0;for(let n=0;n<x;n+=b){const a=(o+n)/h;if(!(a<0||a>=u.outDepth||Math.floor(a)!==a))for(let n=0;n<T;n+=y){const s=(r+n)/m;if(!(s<0||s>=u.outHeight||Math.floor(s)!==s))for(let n=0;n<F;n+=N){const o=(i+n)/f;o<0||o>=u.outWidth||Math.floor(o)!==o||(d+=D.get(e,a,s,o,t))}}}A.set(d*z,e,n,a,s,t)}return n.makeTensorInfo(A.shape,A.dtype,A.values)}};const ps={kernelName:oe,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{dy:s,input:o}=t,d=o;on([s,o],"avgPoolGrad");const{filterSize:c,strides:l,pad:p}=a,u=r.computePool2DInfo(d.shape,c,l,1,p),h=u.strideHeight,m=u.strideWidth,f=u.filterHeight,k=u.filterWidth,I=u.dilationHeight,g=u.dilationWidth,b=u.effectiveFilterHeight,y=u.effectiveFilterWidth,N=y-1-u.padInfo.left,x=b-1-u.padInfo.top,T=i(d.shape,"float32"),F=1/(f*k),S=n.data.get(s.dataId).values,v=i(s.shape,"float32",S);for(let e=0;e<u.batchSize;++e)for(let t=0;t<u.inChannels;++t)for(let n=0;n<u.inHeight;++n)for(let a=0;a<u.inWidth;++a){const s=n-x,o=a-N;let r=0;for(let n=0;n<b;n+=I){const a=(s+n)/h;if(!(a<0||a>=u.outHeight||Math.floor(a)!==a))for(let n=0;n<y;n+=g){const s=(o+n)/m;s<0||s>=u.outWidth||Math.floor(s)!==s||(r+=v.get(e,a,s,t))}}T.set(r*F,e,n,a,t)}return n.makeTensorInfo(T.shape,T.dtype,T.values)}};const us={kernelName:re,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o,scale:r,offset:i,mean:d,variance:c}=n;e.assert(d.shape.length===c.shape.length,()=>"Batch normalization gradient requires mean and variance to have equal ranks."),e.assert(null==i||d.shape.length===i.shape.length,()=>"Batch normalization gradient requires mean and offset to have equal ranks."),e.assert(null==r||d.shape.length===r.shape.length,()=>"Batch normalization gradient requires mean and scale to have equal ranks."),on([o,d,c,r,i],"batchNorm");let{varianceEpsilon:l}=s;null==l&&(l=.001);const p=a.data.get(o.dataId).values,u=a.data.get(d.dataId).values,h=a.data.get(c.dataId).values,m=r?a.data.get(r.dataId).values:new Float32Array([1]),f=i?a.data.get(i.dataId).values:new Float32Array([0]),k=new Float32Array(p.length),I=f.length,g=m.length,b=h.length,y=u.length;let N=0,x=0,T=0,F=0;for(let e=0;e<p.length;++e)k[e]=f[N++]+(p[e]-u[x++])*m[T++]/Math.sqrt(h[F++]+l),N>=I&&(N=0),x>=y&&(x=0),T>=g&&(T=0),F>=b&&(F=0);return a.makeTensorInfo(o.shape,o.dtype,k)}};const hs={kernelName:ie,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{x:s}=t,{blockShape:o,crops:i}=a;on([s],"batchToSpaceND");const d=o.reduce((e,t)=>e*t),c=r.getReshaped(s.shape,o,d),l=r.getPermuted(c.length,o.length),p=r.getReshapedPermuted(s.shape,o,d),u=r.getSliceBeginCoords(i,o.length),h=r.getSliceSize(p,i,o.length),m=Ba({inputs:{x:s},backend:n,attrs:{shape:c}}),f=ca({inputs:{x:m},backend:n,attrs:{perm:l}}),k=Ba({inputs:{x:f},backend:n,attrs:{shape:p}}),I=Ia({inputs:{x:k},backend:n,attrs:{begin:u,size:h}});return n.disposeIntermediateTensorInfo(m),n.disposeIntermediateTensorInfo(f),n.disposeIntermediateTensorInfo(k),I}};const ms={kernelName:de,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{x:s,weights:o}=t,{size:r}=a,i=vn(n.data.get(s.dataId).values,n.data.get(o.dataId).values,o.dtype,o.shape,r);return n.makeTensorInfo([r],o.dtype,i)}},fs={kernelName:ce,backendName:"cpu",kernelFunc:zn(ce,(e,t)=>{const n=t;return e>n.clipValueMax?n.clipValueMax:e<n.clipValueMin?n.clipValueMin:e})},ks={kernelName:le,backendName:"cpu",kernelFunc:t=>{const{x:n}=t.inputs,a=t.backend,s=new Float32Array(e.sizeFromShape(n.shape)),o=a.data.get(n.dataId),r=o.complexTensorInfos.real,i=o.complexTensorInfos.imag,d=a.data.get(r.dataId).values,c=a.data.get(i.dataId).values;for(let e=0;e<d.length;e++){const t=d[e],n=c[e];s[e]=Math.hypot(t,n)}return a.makeOutput(s,n.shape,"float32")}};function Is(e){const{inputs:t,backend:n}=e,{input:a}=t,s=n.data.get(a.dataId).complexTensorInfos.imag,o=n.data.get(s.dataId).values;return n.makeTensorInfo(s.shape,s.dtype,o)}const gs={kernelName:pe,backendName:"cpu",kernelFunc:Is};function bs(t){const{inputs:n,backend:a,attrs:s}=t,{axis:o}=s,i=e.parseAxisParam(o,n[0].shape)[0];let d=r.computeOutShape(n.map(e=>e.shape),i);if(0===e.sizeFromShape(d))return a.makeTensorInfo(d,n[0].dtype,[]);const c=n.filter(t=>e.sizeFromShape(t.shape)>0);if(1===c.length)return fn({inputs:{x:c[0]},backend:a});const l=c.map(e=>e.shape);if(r.assertParamsConsistent(l,i),"complex64"===c[0].dtype){const e=c.map(e=>In({inputs:{input:e},backend:a})),t=c.map(e=>Is({inputs:{input:e},backend:a})),n=bs({inputs:e,backend:a,attrs:{axis:i}}),s=bs({inputs:t,backend:a,attrs:{axis:i}}),o=un({inputs:{real:n,imag:s},backend:a});return e.forEach(e=>a.disposeIntermediateTensorInfo(e)),t.forEach(e=>a.disposeIntermediateTensorInfo(e)),a.disposeIntermediateTensorInfo(n),a.disposeIntermediateTensorInfo(s),o}const p=c.map(t=>{const n=e.sizeFromShape(t.shape.slice(i));return Ba({inputs:{x:t},backend:a,attrs:{shape:[-1,n]}})}),u=p.map(e=>({vals:a.data.get(e.dataId).values,shape:e.shape}));d=r.computeOutShape(p.map(e=>e.shape),1);const h=1===p[0].shape[0],m=Hn(u,d,n[0].dtype,h),f=r.computeOutShape(c.map(e=>e.shape),i),k=a.makeTensorInfo(f,n[0].dtype,m);return p.forEach(e=>a.disposeIntermediateTensorInfo(e)),k}const ys={kernelName:ue,backendName:"cpu",kernelFunc:bs};function Ns(t){const{inputs:n,backend:a,attrs:s}=t,{x:o,filter:i}=n,{strides:d,pad:c,dataFormat:l,dilations:p,dimRoundingMode:u}=s;on([o,i],"conv2d");const h=r.convertConv2DDataFormat(l),m=r.computeConv2DInfo(o.shape,i.shape,d,p,c,u,!1,h),f=m.filterHeight,k=m.filterWidth,I=m.dilationHeight,g=m.dilationWidth,b=m.padInfo.left,y=m.padInfo.top,N="channelsLast"===m.dataFormat,x=new C(m.outShape,o.dtype),T=e.computeStrides(o.shape),F=e.computeStrides(i.shape),S=T[0],v=N?T[1]:T[2],M=N?T[2]:1,A=N?1:T[1],z=x.strides[0],D=N?x.strides[1]:x.strides[2],w=N?x.strides[2]:1,W=N?1:x.strides[1],H=a.data.get(o.dataId).values,E=a.data.get(i.dataId).values,P=x.values;for(let e=0;e<m.batchSize;++e){const t=e*S,n=e*z;for(let e=0;e<m.outHeight;++e){const a=n+e*D,s=e*m.strideHeight-y;for(let e=0;e<f;++e){const n=s+e*I;if(n<0||n>=m.inHeight)continue;const o=e*F[0],r=t+n*v;for(let e=0;e<m.outWidth;++e){const t=a+e*w,n=e*m.strideWidth-b;for(let e=0;e<k;++e){const a=n+e*g;if(a<0||a>=m.inWidth)continue;const s=r+a*M;let i=o+e*F[1];for(let e=0;e<m.inChannels;++e){const n=H[s+e*A];for(let e=0;e<m.outChannels;++e)P[t+e*W]+=n*E[i+e];i+=m.outChannels}}}}}}return a.makeTensorInfo(x.shape,x.dtype,P)}const xs={kernelName:he,backendName:"cpu",kernelFunc:Ns};const Ts={kernelName:me,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{x:s,dy:o}=t,{strides:i,pad:d,dataFormat:c,dimRoundingMode:l,filterShape:p}=a;on([s,o],"conv2dBackpropFilter");const u=r.convertConv2DDataFormat(c),h=r.computeConv2DInfo(s.shape,p,i,1,d,l,!1,u),{strideHeight:m,strideWidth:f,filterHeight:k,filterWidth:I}=h,g="channelsLast"===h.dataFormat,b=new C(h.filterShape,"float32"),y=h.padInfo.left,N=h.padInfo.top,x=n.data.get(s.dataId).values,T=n.data.get(o.dataId).values,F=new C(s.shape,s.dtype,x),S=new C(o.shape,o.dtype,T);for(let e=0;e<k;++e){const t=Math.max(0,Math.ceil((N-e)/m)),n=Math.min(h.outHeight,(h.inHeight+N-e)/m);for(let a=0;a<I;++a){const s=Math.max(0,Math.ceil((y-a)/f)),o=Math.min(h.outWidth,(h.inWidth+y-a)/f);for(let r=0;r<h.inChannels;++r)for(let i=0;i<h.outChannels;++i){let d=0;for(let c=0;c<h.batchSize;++c)for(let l=t;l<n;++l){const t=e+l*m-N;for(let e=s;e<o;++e){const n=a+e*f-y;d+=g?F.get(c,t,n,r)*S.get(c,l,e,i):F.get(c,r,t,n)*S.get(c,i,l,e)}}b.set(d,e,a,r,i)}}}return n.makeTensorInfo(b.shape,b.dtype,b.values)}};const Fs={kernelName:fe,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{dy:o,filter:i}=n,{inputShape:d,strides:c,pad:l,dataFormat:p,dimRoundingMode:u}=s;on([o,i],"conv2dBackpropInput");const h=e.computeStrides(i.shape),m=e.computeStrides(o.shape);let f=r.convertConv2DDataFormat(p);const k=r.computeConv2DInfo(d,i.shape,c,1,l,u,!1,f),I=new C(k.inShape,"float32"),g=I.values,b=a.data.get(o.dataId).values,y=a.data.get(i.dataId).values,[N,x,T]=h,{batchSize:F,filterHeight:S,filterWidth:v,inChannels:M,inHeight:A,inWidth:z,outChannels:D,outHeight:w,outWidth:W,strideHeight:H,strideWidth:E}=k;f=k.dataFormat;const P=S-1-k.padInfo.top,R=v-1-k.padInfo.left,$="channelsLast"===f,O=I.strides[0],V=$?I.strides[1]:I.strides[2],_=$?I.strides[2]:1,B=$?1:I.strides[1],L=m[0],G=$?m[1]:m[2],q=$?m[2]:1,U=$?1:m[1];for(let e=0;e<F;++e)for(let t=0;t<M;++t)for(let n=0;n<A;++n){const a=n-P,s=Math.max(0,Math.ceil(a/H)),o=Math.min(w,(S+a)/H);for(let r=0;r<z;++r){const i=r-R,d=Math.max(0,Math.ceil(i/E)),c=Math.min(W,(v+i)/E);let l=0;for(let n=s;n<o;++n){const s=n*H-a;for(let a=d;a<c;++a){const o=L*e+G*n+q*a,r=N*(S-1-s)+x*(v-1-(a*E-i))+T*t;for(let e=0;e<D;++e){l+=b[o+U*e]*y[r+e]}}}g[O*e+V*n+_*r+B*t]=l}}return a.makeTensorInfo(I.shape,I.dtype,I.values)}};const Ss={kernelName:ke,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o,filter:i}=n,{strides:d,pad:c,dilations:l}=s;on([o,i],"conv3d");const p=r.computeConv3DInfo(o.shape,i.shape,d,l,c),{filterDepth:u,filterHeight:h,filterWidth:m,dilationDepth:f,dilationHeight:k,dilationWidth:I,padInfo:g}=p,b=g.front,y=g.left,N=g.top,x=new C(p.outShape,o.dtype),T=a.data.get(o.dataId).values,F=a.data.get(i.dataId).values,S=x.values,v=e.computeStrides(o.shape),M=e.computeStrides(i.shape);for(let e=0;e<p.batchSize;++e){const t=e*v[0],n=e*x.strides[0];for(let e=0;e<p.outDepth;++e){const a=n+e*x.strides[1],s=e*p.strideDepth-b;for(let e=0;e<u;++e){const n=s+e*f;if(n<0||n>=p.inDepth)continue;const o=e*M[0],r=t+n*v[1];for(let e=0;e<p.outHeight;++e){const t=a+e*x.strides[2],n=e*p.strideHeight-N;for(let e=0;e<h;++e){const a=n+e*k;if(a<0||a>=p.inHeight)continue;const s=o+e*M[1],i=r+a*v[2];for(let e=0;e<p.outWidth;++e){const n=t+e*p.outChannels,a=e*p.strideWidth-y;for(let e=0;e<m;++e){const t=a+e*I;if(t<0||t>=p.inWidth)continue;const o=s+e*M[2],r=i+t*p.inChannels;let d=o;for(let e=0;e<p.inChannels;++e){const t=T[r+e];for(let e=0;e<p.outChannels;++e)S[n+e]+=t*F[d+e];d+=p.outChannels}}}}}}}}return a.makeTensorInfo(x.shape,x.dtype,x.values)}};const vs={kernelName:Ie,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o,dy:i}=n,{strides:d,pad:c,filterShape:l}=s;on([o,i],"conv3dBackpropFilterV2");const p=e.computeStrides(o.shape),u=e.computeStrides(i.shape),h=r.computeConv3DInfo(o.shape,l,d,1,c),m=h.strideDepth,f=h.strideHeight,k=h.strideWidth,I=h.filterDepth,g=h.filterHeight,b=h.filterWidth,y=new C(h.filterShape,"float32"),N=y.values,[x,T,F,S]=y.strides,v=a.data.get(i.dataId).values,[M,A,z,D]=u,w=a.data.get(o.dataId).values,[W,H,E,P]=p,R=h.padInfo.front,$=h.padInfo.left,O=h.padInfo.top;for(let e=0;e<I;++e){const t=Math.max(0,Math.ceil((R-e)/m)),n=Math.min(h.outDepth,(h.inDepth+R-e)/m),a=e*x;for(let s=0;s<g;++s){const o=Math.max(0,Math.ceil((O-s)/f)),r=Math.min(h.outHeight,(h.inHeight+O-s)/f),i=s*T+a;for(let a=0;a<b;++a){const d=Math.max(0,Math.ceil(($-a)/k)),c=Math.min(h.outWidth,(h.inWidth+$-a)/k),l=a*F+i;for(let i=0;i<h.inChannels;++i){const p=i*S+l;for(let l=0;l<h.outChannels;++l){let u=0;for(let p=0;p<h.batchSize;++p){const h=p*W,I=p*M;for(let p=t;p<n;++p){const t=(e+p*m-R)*H+h,n=p*A+I;for(let e=o;e<r;++e){const o=(s+e*f-O)*E+t,r=e*z+n;for(let e=d;e<c;++e){const t=e*D+r;u+=w[(a+e*k-$)*P+o+i]*v[t+l]}}}}N[p+l]=u}}}}}return a.makeTensorInfo(y.shape,y.dtype,y.values)}};const Ms={kernelName:ge,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{dy:o,filter:i}=n,{pad:d,strides:c,inputShape:l}=s;on([o],"conv3dBackpropInputV2");const p=e.computeStrides(o.shape),u=e.computeStrides(i.shape),h=r.computeConv3DInfo(l,i.shape,c,1,d),m=new C(h.inShape,"float32"),f=m.values,[k,I,g,b]=m.strides,y=a.data.get(o.dataId).values,[N,x,T,F]=p,S=a.data.get(i.dataId).values,[v,M,A,z]=u,{batchSize:D,filterDepth:w,filterHeight:W,filterWidth:H,inChannels:E,inDepth:P,inHeight:R,inWidth:$,outChannels:O,outDepth:V,outHeight:_,outWidth:B,strideDepth:L,strideHeight:G,strideWidth:q}=h,U=w-1-h.padInfo.front,Z=W-1-h.padInfo.top,j=H-1-h.padInfo.left;for(let e=0;e<D;++e)for(let t=0;t<E;++t)for(let n=0;n<P;++n){const a=n-U,s=Math.max(0,Math.ceil(a/L)),o=Math.min(V,(w+a)/L);for(let r=0;r<R;++r){const i=r-Z,d=Math.max(0,Math.ceil(i/G)),c=Math.min(_,(W+i)/G);for(let l=0;l<$;++l){const p=l-j,u=Math.max(0,Math.ceil(p/q)),h=Math.min(B,(H+p)/q);let m=0;for(let n=s;n<o;++n){const s=n*L-a;for(let a=d;a<c;++a){const o=a*G-i;for(let r=u;r<h;++r){const i=N*e+x*n+T*a+F*r,d=v*(w-1-s)+M*(W-1-o)+A*(H-1-(r*q-p))+z*t;for(let e=0;e<O;++e){m+=y[i+e]*S[d+e]}}}}f[k*e+I*n+g*r+b*l+t]=m}}}return a.makeTensorInfo(m.shape,m.dtype,m.values)}},As={kernelName:be,backendName:"cpu",kernelFunc:zn(be,e=>Math.cos(e))},zs={kernelName:ye,backendName:"cpu",kernelFunc:zn(ye,e=>Math.cosh(e))};const Ds={kernelName:Ne,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{image:o,boxes:r,boxInd:d}=n,{cropSize:c,method:l,extrapolationValue:p}=s,[u,h,m,f]=o.shape,k=r.shape[0],[I,g]=c,b=i([k,I,g,f],"float32"),y=a.data.get(r.dataId).values,N=a.data.get(d.dataId).values,x=a.data.get(o.dataId).values,T=e.computeStrides(o.shape),F=e.computeStrides(b.shape);for(let e=0;e<k;e++){const t=4*e,n=y[t],a=y[t+1],s=y[t+2],o=y[t+3],r=N[e];if(r>=u)continue;const i=I>1?(s-n)*(h-1)/(I-1):0,d=g>1?(o-a)*(m-1)/(g-1):0;for(let t=0;t<I;t++){const c=I>1?n*(h-1)+t*i:.5*(n+s)*(h-1);if(c<0||c>h-1)for(let n=0;n<g;n++)for(let a=0;a<f;a++){const s=a+n*F[2]+t*F[1]+e*F[0];b.values[s]=p}else if("bilinear"===l){const n=Math.floor(c),s=Math.ceil(c),i=c-n;for(let c=0;c<g;c++){const l=g>1?a*(m-1)+c*d:.5*(a+o)*(m-1);if(l<0||l>m-1){for(let n=0;n<f;n++){const a=n+c*F[2]+t*F[1]+e*F[0];b.values[a]=p}continue}const u=Math.floor(l),h=Math.ceil(l),k=l-u;for(let a=0;a<f;a++){let o=a+u*T[2]+n*T[1]+r*T[0];const d=x[o];o=a+h*T[2]+n*T[1]+r*T[0];const l=x[o];o=a+u*T[2]+s*T[1]+r*T[0];const p=x[o];o=a+h*T[2]+s*T[1]+r*T[0];const m=d+(l-d)*k,f=p+(x[o]-p)*k;o=a+c*F[2]+t*F[1]+e*F[0],b.values[o]=m+(f-m)*i}}}else for(let n=0;n<g;++n){const s=g>1?a*(m-1)+n*d:.5*(a+o)*(m-1);if(s<0||s>m-1){for(let a=0;a<f;a++){const s=a+n*F[2]+t*F[1]+e*F[0];b.values[s]=p}continue}const i=Math.round(s),l=Math.round(c);for(let a=0;a<f;a++){const s=a+i*T[2]+l*T[1]+r*T[0],o=a+n*F[2]+t*F[1]+e*F[0];b.values[o]=x[s]}}}}return a.makeTensorInfo(b.shape,b.dtype,b.values)}};const ws={kernelName:xe,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o}=n,{axis:i,exclusive:d,reverse:c}=s;on(o,"cumsum");const l=r.getAxesPermutation([i],o.shape.length);let p=o;null!=l&&(p=ca({inputs:{x:o},backend:a,attrs:{perm:l}}));const u=r.getInnerMostAxes(1,o.shape.length)[0];if(u!==p.shape.length-1)throw new Error("backend.cumsum in CPU expects an inner-most "+`axis=${p.shape.length-1} but got axis=${u}`);const h=M(p.dtype,"int32"),m=e.makeZerosTypedArray(e.sizeFromShape(p.shape),h),f=a.data.get(p.dataId).values,k=p.shape[p.shape.length-1],I=c?(e,t)=>e+k-t-1:(e,t)=>e+t;for(let e=0;e<f.length;e+=k)for(let t=0;t<k;t++){const n=I(e,t);if(0===t)m[n]=d?0:f[n];else{const a=I(e,t-1);m[n]=d?f[a]+m[a]:f[n]+m[a]}}const g=a.makeTensorInfo(p.shape,h,m);if(null!=l){const e=ca({inputs:{x:g},backend:a,attrs:{perm:r.getUndoAxesPermutation(l)}});return a.disposeIntermediateTensorInfo(g),a.disposeIntermediateTensorInfo(p),e}return g}};const Ws={kernelName:Te,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{x:s,weights:o}=t,{size:r,binaryOutput:i}=a;if(1===s.shape.length){const e=vn(n.data.get(s.dataId).values,n.data.get(o.dataId).values,o.dtype,o.shape,r);return n.makeTensorInfo([r],o.dtype,e)}if(2===s.shape.length){const e=Mn(n.bufferSync(s),n.bufferSync(o),r,i);return n.makeTensorInfo(e.shape,o.dtype,e.values)}throw new Error("Error in denseBincount: input must be at most rank 2, but got rank"+`${s.shape.length}.`)}};const Hs={kernelName:Fe,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o}=n,{blockSize:r,dataFormat:i}=s;e.assert("NHWC"===i,()=>`Only NHWC dataFormat supported on CPU for depthToSpace. Got ${i}`),e.assert(r>1,()=>`blockSize should be > 1 for depthToSpace, but was: ${r}`);const d=o.shape[0],c=o.shape[1],l=o.shape[2],p=o.shape[3],u=c*r,h=l*r,m=p/(r*r),f=a.data.get(o.dataId).values,k=new Float32Array(d*u*h*m);let I=0;for(let e=0;e<d;++e)for(let t=0;t<u;++t){const n=Math.floor(t/r),a=t%r;for(let t=0;t<h;++t){const s=Math.floor(t/r),o=(a*r+t%r)*m;for(let t=0;t<m;++t){const a=t+o+p*(s+l*(n+c*e));k[I++]=f[a]}}}return a.makeTensorInfo([d,u,h,m],o.dtype,k)}};function Cs(t){const{inputs:n,backend:a,attrs:s}=t,{x:o,filter:i}=n,{strides:d,pad:c,dilations:l,dimRoundingMode:p}=s;on([o,i],"depthwiseConv2DNative");const u=e.computeStrides(o.shape),h=e.computeStrides(i.shape);let m=l;null==m&&(m=[1,1]),e.assert(r.eitherStridesOrDilationsAreOne(d,m),()=>"Error in depthwiseConv2d: Either strides or dilations must be "+`1. Got strides ${d} and dilations '${m}'`);const f=r.computeConv2DInfo(o.shape,i.shape,d,m,c,p,!0),{filterHeight:k,filterWidth:I,dilationHeight:g,dilationWidth:b,padInfo:y}=f,N=y.left,x=y.top,T=f.outChannels/f.inChannels,F=new C(f.outShape,o.dtype),S=a.data.get(o.dataId).values,v=a.data.get(i.dataId).values,M=F.values;for(let e=0;e<f.batchSize;++e){const t=e*u[0],n=e*F.strides[0];for(let e=0;e<f.outHeight;++e){const a=n+e*F.strides[1],s=e*f.strideHeight-N;for(let e=0;e<k;++e){const n=s+e*g;if(n<0||n>=f.inHeight)continue;const o=e*h[0],r=t+n*u[1];for(let e=0;e<f.outWidth;++e){const t=a+e*F.strides[2],n=e*f.strideWidth-x;for(let e=0;e<I;++e){const a=n+e*b;if(a<0||a>=f.inWidth)continue;const s=o+e*h[1],i=r+a*f.inChannels;let d=t,c=s;for(let e=0;e<f.inChannels;++e){const t=S[i+e];for(let e=0;e<T;++e)M[d+e]+=t*v[c+e];d+=T,c+=T}}}}}}return a.makeTensorInfo(F.shape,F.dtype,F.values)}const Es={kernelName:Se,backendName:"cpu",kernelFunc:Cs};const Ps={kernelName:ve,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{x:s,dy:o}=t,{strides:i,dilations:d,pad:c,dimRoundingMode:l,filterShape:p}=a;on([s,o],"depthwiseConv2dNativeBackpropFilter");const u=r.computeConv2DInfo(s.shape,p,i,d,c,l,!0),{strideHeight:h,strideWidth:m,filterHeight:f,filterWidth:k}=u,I=new C(u.filterShape,"float32"),g=u.padInfo.left,b=u.padInfo.top,y=u.outChannels/u.inChannels,N=n.data.get(s.dataId).values,x=new C(s.shape,s.dtype,N),T=n.data.get(o.dataId).values,F=new C(o.shape,o.dtype,T);for(let e=0;e<f;++e){const t=Math.max(0,Math.ceil((b-e)/h)),n=Math.min(u.outHeight,(u.inHeight+b-e)/h);for(let a=0;a<k;++a){const s=Math.max(0,Math.ceil((g-a)/m)),o=Math.min(u.outWidth,(u.inWidth+g-a)/m);for(let r=0;r<u.outChannels;++r){const i=Math.trunc(r/y),d=r%y;let c=0;for(let d=0;d<u.batchSize;++d)for(let l=t;l<n;++l){const t=e+l*h-b;for(let e=s;e<o;++e){const n=a+e*m-g;c+=x.get(d,t,n,i)*F.get(d,l,e,r)}}I.set(c,e,a,i,d)}}}return n.makeTensorInfo(I.shape,I.dtype,I.values)}};const Rs={kernelName:Me,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{dy:o,filter:i}=n,{strides:d,dilations:c,pad:l,dimRoundingMode:p,inputShape:u}=s;on([o,i],"depthwiseConv2DNativeBackpropInput");const h=e.computeStrides(o.shape),m=e.computeStrides(i.shape),f=r.computeConv2DInfo(u,i.shape,d,c,l,p,!0),k=new C(f.inShape,"float32"),I=k.values,[g,b,y]=k.strides,N=a.data.get(o.dataId).values,[x,T,F]=h,S=a.data.get(i.dataId).values,[v,M,A]=m,{batchSize:z,filterHeight:D,filterWidth:w,inChannels:W,inHeight:H,inWidth:E,outChannels:P,outHeight:R,outWidth:$,strideHeight:O,strideWidth:V}=f,_=D-1-f.padInfo.top,B=w-1-f.padInfo.left,L=P/W;for(let e=0;e<z;++e)for(let t=0;t<W;++t)for(let n=0;n<H;++n){const a=n-_,s=Math.max(0,Math.ceil(a/O)),o=Math.min(R,(D+a)/O);for(let r=0;r<E;++r){const i=r-B,d=Math.max(0,Math.ceil(i/V)),c=Math.min($,(w+i)/V);let l=0;for(let n=s;n<o;++n){const s=n*O-a;for(let a=d;a<c;++a){const o=x*e+T*n+F*a,r=v*(D-1-s)+M*(w-1-(a*V-i))+A*t;for(let e=0;e<L;++e){l+=N[o+(t*L+e)]*S[r+e]}}}I[g*e+b*n+y*r+t]=l}}return a.makeTensorInfo(k.shape,k.dtype,k.values)}};const $s={kernelName:Ae,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a}=t,{x:s}=n,o=e.sizeFromShape(s.shape),r=a.data.get(s.dataId).values,d=i([o,o],s.dtype),c=d.values;for(let e=0;e<r.length;e++)c[e*o+e]=r[e];const l=[...s.shape,...s.shape];return a.makeTensorInfo(l,d.dtype,d.values)}},Os={kernelName:ze,backendName:"cpu",kernelFunc:({inputs:t,backend:n,attrs:a})=>{const{x:s,filter:o}=t,{strides:i,pad:d,dilations:c}=a,l=n,p=l.data.get(s.dataId).values,u=s.shape.length,h=l.data.get(o.dataId).values,m=o.shape.length,{batchSize:f,inHeight:k,inWidth:I,inChannels:g,outHeight:b,outWidth:y,padInfo:N,strideHeight:x,strideWidth:T,filterHeight:F,filterWidth:S,dilationHeight:v,dilationWidth:M,outShape:A}=r.computeDilation2DInfo(s.shape,o.shape,i,d,"NHWC",c),z=e.sizeFromShape(A),D=A.length,w=e.getArrayFromDType(s.dtype,z);for(let t=0;t<f;++t)for(let n=0;n<b;++n){const a=n*x-N.top;for(let r=0;r<y;++r){const i=r*T-N.left;for(let d=0;d<g;++d){let c=Number.MIN_SAFE_INTEGER;for(let n=0;n<F;++n){const r=a+n*v;if(r>=0&&r<k)for(let a=0;a<S;++a){const l=i+a*M;if(l>=0&&l<I){const i=e.locToIndex([t,r,l,d],u,e.computeStrides(s.shape)),f=e.locToIndex([n,a,d],m,e.computeStrides(o.shape)),k=p[i]+h[f];k>c&&(c=k)}}}w[e.locToIndex([t,n,r,d],D,e.computeStrides(A))]=c}}}return{dataId:l.write(e.toTypedArray(w,s.dtype),A,s.dtype),shape:A,dtype:s.dtype}}},Vs={kernelName:De,backendName:"cpu",kernelFunc:({inputs:t,backend:n,attrs:a})=>{const{x:s,filter:o,dy:i}=t,{strides:d,pad:c,dilations:l}=a,p=n,u=e.toNestedArray(s.shape,p.data.get(s.dataId).values),h=e.toNestedArray(o.shape,p.data.get(o.dataId).values),{batchSize:m,inHeight:f,inWidth:k,inChannels:I,outHeight:g,outWidth:b,padInfo:y,strideHeight:N,strideWidth:x,filterHeight:T,filterWidth:F,dilationHeight:S,dilationWidth:v,outShape:M}=r.computeDilation2DInfo(s.shape,o.shape,d,c,"NHWC",l);e.assert(i.rank===M.length,()=>`Error in ${De}, dy `+`must have the same rank as output ${M.length}, but got `+`${i.rank}`);const A=e.toNestedArray(M,p.data.get(i.dataId).values),z=e.makeZerosNestedTypedArray(o.shape,o.dtype);for(let e=0;e<m;++e)for(let t=0;t<g;++t){const n=t*N-y.top;for(let a=0;a<b;++a){const s=a*x-y.left;for(let o=0;o<I;++o){let r=Number.MIN_SAFE_INTEGER,i=0,d=0;for(let t=0;t<T;++t){const a=n+t*S;if(a>=0&&a<f)for(let n=0;n<F;++n){const c=s+n*v;if(c>=0&&c<k){const s=u[e][a][c][o]+h[t][n][o];s>r&&(r=s,i=t,d=n)}}}z[i][d][o]+=A[e][t][a][o]}}}return{dataId:p.write(e.toTypedArray(z,s.dtype),o.shape,o.dtype),shape:o.shape,dtype:o.dtype}}},_s={kernelName:we,backendName:"cpu",kernelFunc:({inputs:t,backend:n,attrs:a})=>{const{x:s,filter:o,dy:i}=t,{strides:d,pad:c,dilations:l}=a,p=n,u=e.toNestedArray(s.shape,p.data.get(s.dataId).values),h=e.toNestedArray(o.shape,p.data.get(o.dataId).values),{batchSize:m,inHeight:f,inWidth:k,inChannels:I,outHeight:g,outWidth:b,padInfo:y,strideHeight:N,strideWidth:x,filterHeight:T,filterWidth:F,dilationHeight:S,dilationWidth:v,outShape:M}=r.computeDilation2DInfo(s.shape,o.shape,d,c,"NHWC",l);e.assert(i.rank===M.length,()=>`Error in ${we}, dy `+`must have the same rank as output ${M.length}, but got `+`${i.rank}`);const A=e.toNestedArray(M,p.data.get(i.dataId).values),z=e.makeZerosNestedTypedArray(s.shape,s.dtype);for(let e=0;e<m;++e)for(let t=0;t<g;++t){const n=t*N-y.top;for(let a=0;a<b;++a){const s=a*x-y.left;for(let o=0;o<I;++o){let r=Number.MIN_SAFE_INTEGER,i=n<0?0:n,d=s<0?0:s;for(let t=0;t<T;++t){const a=n+t*S;if(a>=0&&a<f)for(let n=0;n<F;++n){const c=s+n*v;if(c>=0&&c<k){const s=u[e][a][c][o]+h[t][n][o];s>r&&(r=s,i=a,d=c)}}}z[e][i][d][o]+=A[e][t][a][o]}}}return{dataId:p.write(e.toTypedArray(z,s.dtype),s.shape,s.dtype),shape:s.shape,dtype:s.dtype}}};const Bs={kernelName:We,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a}=t,{dy:s,y:o}=n;on([s,o],"eluGrad");const r=new Float32Array(e.sizeFromShape(o.shape)),i=a.data.get(o.dataId).values,d=a.data.get(s.dataId).values;for(let e=0;e<i.length;++e){const t=i[e];r[e]=t>=1?d[e]:d[e]*(t+1)}return a.makeTensorInfo(o.shape,"float32",r)}},Ls=Nn(He,pn((e,t)=>e===t?1:0),null,"bool"),Gs={kernelName:He,backendName:"cpu",kernelFunc:Ls},qs=r.ERF_P,Us=r.ERF_A1,Zs=r.ERF_A2,js=r.ERF_A3,Ks=r.ERF_A4,Ys=r.ERF_A5,Js={kernelName:Ce,backendName:"cpu",kernelFunc:zn(Ce,e=>{const t=Math.sign(e),n=Math.abs(e),a=1/(1+qs*n);return t*(1-((((Ys*a+Ks)*a+js)*a+Zs)*a+Us)*a*Math.exp(-n*n))})};function Qs(t){const{inputs:n,backend:a,attrs:s}=t,{input:o}=n,{dim:r}=s,i=o.shape.length,d=o.shape.slice();let c=r;return r<0&&(e.assert(-(i+1)<=r,()=>`Axis must be in the interval [${-(i+1)}, ${i}]`),c=i+r+1),d.splice(c,0,1),Ba({inputs:{x:o},backend:a,attrs:{shape:d}})}const Xs={kernelName:Ee,backendName:"cpu",kernelFunc:Qs},eo=Nn(Pe,pn((e,t)=>e/t)),to={kernelName:Pe,backendName:"cpu",kernelFunc:eo};function no(t,n,a){const s=t.shape,o=s[0],i=s[1],d=a.data.get(t.dataId),c=d.complexTensorInfos.real,l=d.complexTensorInfos.imag,p=[o,i],u=e.sizeFromShape(p),h=e.getTypedArrayFromDType("float32",u),m=e.getTypedArrayFromDType("float32",u);for(let e=0;e<o;e++){const t=Ia({inputs:{x:c},backend:a,attrs:{begin:[e,0],size:[1,i]}}),s=Ia({inputs:{x:l},backend:a,attrs:{begin:[e,0],size:[1,i]}}),o=un({inputs:{real:t,imag:s},backend:a}),{real:d,imag:p}=ao(o,n,a),u=r.mergeRealAndImagArrays(d,p);for(let t=0;t<i;t++){const n=r.getComplexWithIndex(u,t);h[e*i+t]=n.real,m[e*i+t]=n.imag}a.disposeIntermediateTensorInfo(t),a.disposeIntermediateTensorInfo(s),a.disposeIntermediateTensorInfo(o)}const f=a.makeTensorInfo(p,"float32",h),k=a.makeTensorInfo(p,"float32",m),I=un({inputs:{real:f,imag:k},backend:a});return a.disposeIntermediateTensorInfo(f),a.disposeIntermediateTensorInfo(k),I}function ao(t,n,a){const s=e.sizeFromShape(t.shape),o=a.data.get(t.dataId),i=a.data.get(o.complexTensorInfos.real.dataId).values,d=a.data.get(o.complexTensorInfos.imag.dataId).values;if(0==((c=s)&c-1)){const o=function e(t,n,a,s,o){if(1===a)return{real:t,imag:n};const i=r.mergeRealAndImagArrays(t,n),d=a/2,c=r.complexWithEvenIndex(i),l=c.real,p=c.imag,u=[l.length],h=o.makeTensorInfo(u,"float32",l),m=o.makeTensorInfo(u,"float32",p),f=un({inputs:{real:h,imag:m},backend:o}),k=r.complexWithOddIndex(i),I=k.real,g=k.imag,b=[I.length],y=o.makeTensorInfo(b,"float32",I),N=o.makeTensorInfo(b,"float32",g),x=un({inputs:{real:y,imag:N},backend:o}),T=e(l,p,d,s,o),F=T.real,S=T.imag,v=[F.length],M=o.makeTensorInfo(v,"float32",F),A=o.makeTensorInfo(v,"float32",S),z=un({inputs:{real:M,imag:A},backend:o}),D=e(I,g,d,s,o),w=D.real,W=D.imag,H=[w.length],C=o.makeTensorInfo(H,"float32",w),E=o.makeTensorInfo(H,"float32",W),P=un({inputs:{real:C,imag:E},backend:o}),R=r.exponents(a,s),$=[R.real.length],O=o.makeTensorInfo($,"float32",R.real),V=o.makeTensorInfo($,"float32",R.imag),_=un({inputs:{real:O,imag:V},backend:o}),B=na({inputs:{a:_,b:P},backend:o}),L=Fn({inputs:{a:z,b:B},backend:o}),G=Ta({inputs:{a:z,b:B},backend:o}),q=In({inputs:{input:L},backend:o}),U=In({inputs:{input:G},backend:o}),Z=Is({inputs:{input:L},backend:o}),j=Is({inputs:{input:G},backend:o}),K=bs({inputs:[q,U],backend:o,attrs:{axis:0}}),Y=bs({inputs:[Z,j],backend:o,attrs:{axis:0}}),J=o.data.get(K.dataId).values,Q=o.data.get(Y.dataId).values;return o.disposeIntermediateTensorInfo(h),o.disposeIntermediateTensorInfo(m),o.disposeIntermediateTensorInfo(f),o.disposeIntermediateTensorInfo(y),o.disposeIntermediateTensorInfo(N),o.disposeIntermediateTensorInfo(x),o.disposeIntermediateTensorInfo(M),o.disposeIntermediateTensorInfo(A),o.disposeIntermediateTensorInfo(z),o.disposeIntermediateTensorInfo(C),o.disposeIntermediateTensorInfo(E),o.disposeIntermediateTensorInfo(P),o.disposeIntermediateTensorInfo(O),o.disposeIntermediateTensorInfo(V),o.disposeIntermediateTensorInfo(_),o.disposeIntermediateTensorInfo(B),o.disposeIntermediateTensorInfo(L),o.disposeIntermediateTensorInfo(G),o.disposeIntermediateTensorInfo(q),o.disposeIntermediateTensorInfo(Z),o.disposeIntermediateTensorInfo(U),o.disposeIntermediateTensorInfo(j),o.disposeIntermediateTensorInfo(K),o.disposeIntermediateTensorInfo(Y),{real:J,imag:Q}}(i,d,s,n,a),c=[t.shape[0],t.shape[1]];if(n){const t=a.makeTensorInfo(c,"float32",o.real),n=a.makeTensorInfo(c,"float32",o.imag),r=a.makeTensorInfo([],"float32",e.createScalarValue(s,"float32")),i=fn({inputs:{x:r},backend:a}),d=to.kernelFunc({inputs:{a:t,b:r},backend:a}),l=to.kernelFunc({inputs:{a:n,b:i},backend:a}),p=a.data.get(d.dataId).values,u=a.data.get(l.dataId).values;return a.disposeIntermediateTensorInfo(t),a.disposeIntermediateTensorInfo(n),a.disposeIntermediateTensorInfo(r),a.disposeIntermediateTensorInfo(i),a.disposeIntermediateTensorInfo(d),a.disposeIntermediateTensorInfo(l),{real:p,imag:u}}return o}{const e=function(e,t,n){const a=new Float32Array(2*t);for(let s=0;s<t;s++){let o=0,i=0;for(let a=0;a<t;a++){const d=r.exponent(s*a,t,n),c=r.getComplexWithIndex(e,a);o+=c.real*d.real-c.imag*d.imag,i+=c.real*d.imag+c.imag*d.real}n&&(o/=t,i/=t),r.assignToTypedArray(a,o,i,s)}return a}(r.mergeRealAndImagArrays(i,d),s,n);return r.splitRealAndImagArrays(e)}var c}const so={kernelName:Re,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a}=t,{input:s}=n,o=e.sizeFromShape(s.shape),r=s.shape[s.shape.length-1],i=Ba({inputs:{x:s},backend:a,attrs:{shape:[o/r,r]}}),d=no(i,!1,a),c=Ba({inputs:{x:d},backend:a,attrs:{shape:s.shape}});return a.disposeIntermediateTensorInfo(i),a.disposeIntermediateTensorInfo(d),c}};function oo(t){const{backend:n,attrs:a}=t,{shape:s,value:o,dtype:r}=a,i=r||e.inferDtype(o),d=e.getArrayFromDType(i,e.sizeFromShape(s));return function(e,t,n){e.fill(t)}(d,o),n.makeTensorInfo(s,i,d)}const ro={kernelName:$e,backendName:"cpu",kernelFunc:oo};const io={kernelName:Oe,backendName:"cpu",kernelFunc:({inputs:t,attrs:n,backend:a})=>{const{image:s}=t,o=a,r=e.getTypedArrayFromDType(s.dtype,e.sizeFromShape(s.shape)),[i,d,c,l]=s.shape,p=o.data.get(s.dataId).values;for(let e=0;e<i;e++){const t=e*c*d*l;for(let e=0;e<d;e++){const n=e*(c*l);for(let a=0;a<c;a++){const s=a*l;for(let o=0;o<l;o++){const d=[i,e,a,o][2],u=Math.round(c-d),h=t+n+s+o;let m=p[h];if(u>=0&&u<c){m=p[t+n+u*l+o]}r[h]=m}}}}return{dataId:o.write(r,s.shape,s.dtype),shape:s.shape,dtype:s.dtype}}},co={kernelName:Ve,backendName:"cpu",kernelFunc:Nn(Ve,pn((e,t)=>Math.floor(e/t)),null,"int32")};const lo={kernelName:_e,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{x:s,filter:o,bias:r,preluActivationWeights:i}=t,{strides:d,pad:c,dataFormat:l,dilations:p,dimRoundingMode:u,activation:h,leakyreluAlpha:m}=a;let f=Ns({inputs:{x:s,filter:o},backend:n,attrs:{strides:d,pad:c,dataFormat:l,dilations:p,dimRoundingMode:u}});if(r){const e=f;f=Fn({inputs:{a:f,b:r},backend:n}),n.disposeIntermediateTensorInfo(e)}if(h){const e=f;f=_a(n,f,h,i,m),n.disposeIntermediateTensorInfo(e)}return f}};const po={kernelName:Be,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{x:s,filter:o,bias:r,preluActivationWeights:i}=t,{strides:d,pad:c,dataFormat:l,dilations:p,dimRoundingMode:u,activation:h,leakyreluAlpha:m}=a;let f=Cs({inputs:{x:s,filter:o},backend:n,attrs:{strides:d,pad:c,dataFormat:l,dilations:p,dimRoundingMode:u}});if(r){const e=f;f=Fn({inputs:{a:f,b:r},backend:n}),n.disposeIntermediateTensorInfo(e)}if(h){const e=f;f=_a(n,f,h,i,m),n.disposeIntermediateTensorInfo(e)}return f}};const uo={kernelName:Le,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a}=t,{params:s,indices:o}=n,d=e.sizeFromShape(s.shape),c=o.shape,l=c[c.length-1],[p,u,h,m]=r.prepareAndValidate(s,o);if(0===u)return a.makeTensorInfo(p,s.dtype,[]);const f=i([u,h],s.dtype),k=a.data.get(o.dataId).values,I=a.data.get(s.dataId).values;for(let e=0;e<u;e++){const t=[];let n=0;for(let a=0;a<l;a++){const s=k[e*l+a];n+=s*m[a],t.push(s)}if(n<0||n>=d/h)throw new Error(`Invalid indices: ${t} does not index into ${s.shape}`);for(let t=0;t<h;t++)f.values[e*h+t]=I[n*h+t]}return a.makeTensorInfo(p,f.dtype,f.values)}};const ho={kernelName:Ge,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o,indices:i}=n,{axis:d,batchDims:c}=s;on([o,i],"gatherV2");let l=c;null==c&&(l=0);const p=e.sizeFromShape(i.shape),u=e.parseAxisParam(d,o.shape)[0],h=r.segment_util.collectGatherOpShapeInfo(o,i,u,l),m=Ba({inputs:{x:o},backend:a,attrs:{shape:[h.batchSize,h.outerSize,h.dimSize,h.sliceSize]}}),f=Ba({inputs:{x:i},backend:a,attrs:{shape:[h.batchSize,p/h.batchSize]}}),k=[h.batchSize,h.outerSize,p/h.batchSize,h.sliceSize],I=a.bufferSync(f),g=_n(a.bufferSync(m),I,k);return a.disposeIntermediateTensorInfo(m),a.disposeIntermediateTensorInfo(f),a.makeTensorInfo(h.outputShape,g.dtype,g.values)}},mo={kernelName:qe,backendName:"cpu",kernelFunc:Nn(qe,pn((e,t)=>e>=t?1:0),null,"bool")};const fo={kernelName:Ue,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a}=t,{input:s}=n,o=e.sizeFromShape(s.shape),r=s.shape[s.shape.length-1],i=Ba({inputs:{x:s},backend:a,attrs:{shape:[o/r,r]}}),d=no(i,!0,a),c=Ba({inputs:{x:d},backend:a,attrs:{shape:s.shape}});return a.disposeIntermediateTensorInfo(i),a.disposeIntermediateTensorInfo(d),c}},ko={kernelName:Ze,backendName:"cpu",kernelFunc:zn(Ze,e=>Number.isFinite(e)?1:0,"bool")},Io={kernelName:je,backendName:"cpu",kernelFunc:zn(je,e=>Math.abs(e)===1/0?1:0,"bool")},go={kernelName:Ke,backendName:"cpu",kernelFunc:zn(Ke,e=>Number.isNaN(e)?1:0,"bool")},bo={kernelName:Ye,backendName:"cpu",kernelFunc:Nn(Ye,pn((e,t)=>e<=t?1:0),null,"bool")};const yo={kernelName:Je,backendName:"cpu",kernelFunc:function(e){const{backend:t,attrs:n}=e,{start:a,stop:s,num:o}=n,r=Un(a,s,o);return t.makeTensorInfo([r.length],"float32",r)}},No={kernelName:Qe,backendName:"cpu",kernelFunc:zn(Qe,e=>Math.log1p(e))},xo={kernelName:Xe,backendName:"cpu",kernelFunc:Nn(Xe,pn((e,t)=>e&&t),null,"bool")},To={kernelName:et,backendName:"cpu",kernelFunc:zn(et,e=>e?0:1,"bool")},Fo={kernelName:tt,backendName:"cpu",kernelFunc:Nn(tt,pn((e,t)=>e||t),null,"bool")};const So={kernelName:nt,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o}=n,{depthRadius:r,bias:i,alpha:d,beta:c}=s;on(o,"LRN");const l=o.shape[3],p=l-1,u=a.data.get(o.dataId).values,h=e.sizeFromShape(o.shape),m=new Float32Array(h);function f(e){const t=e%l;let n=e-t+Math.max(0,t-r);const a=e-t+Math.min(t+r,p);let s=0;for(;n<=a;n++){const e=u[n];s+=e*e}return s}for(let e=0;e<h;e++){const t=f(e),n=u[e]*Math.pow(i+d*t,-c);m[e]=n}return a.makeTensorInfo(o.shape,o.dtype,m)}};const vo={kernelName:at,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o,y:r,dy:i}=n,{depthRadius:d,bias:c,alpha:l,beta:p}=s;on(i,"LRNGrad");const u=e.sizeFromShape(i.shape),h=i.shape[3],m=a.data.get(i.dataId).values,f=a.data.get(o.dataId).values,k=a.data.get(r.dataId).values,I=new Float32Array(u),g=u;for(let e=0;e<g;e++){const t=e%h,n=e-t+Math.max(0,t-d),a=e-t+Math.min(h,t+d+1);let s=0;for(let e=n;e<a;e++)s+=Math.pow(f[e],2);s=l*s+c;for(let t=n;t<a;t++){let n=-2*l*p*f[t]*k[e]/s;e===t&&(n+=Math.pow(s,-p)),n*=m[e],I[t]+=n}}return a.makeTensorInfo(i.shape,o.dtype,I)}};function Mo(t){const{inputs:n,backend:a,attrs:s}=t,{x:o}=n,{reductionIndices:i,keepDims:d}=s,c=a;let l=o.shape;const p=l.length,u=e.parseAxisParam(i,l);let h=u;const m=r.getAxesPermutation(h,p);let f=c.data.get(o.dataId).values;if(null!=m){const e=new Array(p);for(let t=0;t<e.length;t++)e[t]=l[m[t]];f=da(f,l,o.dtype,m,e),h=r.getInnerMostAxes(h.length,p),l=e}on(o,"max"),r.assertAxesAreInnerMostDims("max",h,p);const[k,I]=r.computeOutAndReduceShapes(l,h),g=Kn(f,e.sizeFromShape(I),k,o.dtype),b=c.write(g,k,o.dtype);let y=k;if(d){y=r.expandShapeToKeepDim(k,u)}return{dataId:b,shape:y,dtype:o.dtype}}const Ao={kernelName:st,backendName:"cpu",kernelFunc:Mo};const zo={kernelName:ot,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o}=n;on(o,"maxPool");const{filterSize:i,strides:d,pad:c,dimRoundingMode:l}=s;e.assert(r.eitherStridesOrDilationsAreOne(d,1),()=>"Error in maxPool: Either strides or dilations must be 1. "+`Got strides ${d} and dilations '1'`);const p=r.computePool2DInfo(o.shape,i,d,1,c,l);let u;if(1===p.filterWidth&&1===p.filterHeight&&e.arraysEqual(p.inShape,p.outShape))u=fn({inputs:{x:o},backend:a});else{const t=a.data.get(o.dataId).values,n=e.computeStrides(o.shape),s=os(t,o.shape,o.dtype,n,p,"max");u=a.makeTensorInfo(p.outShape,o.dtype,s.values)}return u}};const Do={kernelName:rt,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o}=n,{filterSize:i,strides:d,pad:c,dimRoundingMode:l,dataFormat:p}=s;on(o,"maxPool3d");const u=r.computePool3DInfo(o.shape,i,d,1,c,l,p),h=is(a.data.get(o.dataId).values,o.shape,o.dtype,e.computeStrides(o.shape),u,"max");return a.makeTensorInfo(h.shape,"float32",h.values)}};const wo={kernelName:it,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{dy:s,input:o}=t,{filterSize:d,strides:c,pad:l,dimRoundingMode:p}=a;on([s,o],"maxPool3DGrad");const u=r.computePool3DInfo(o.shape,d,c,1,l,p),h=function(e,t){const n=i(t.outShape,"int32"),a=t.strideDepth,s=t.strideHeight,o=t.strideWidth,r=t.dilationDepth,d=t.dilationHeight,c=t.dilationWidth,l=t.effectiveFilterDepth,p=t.effectiveFilterHeight,u=t.effectiveFilterWidth,h=t.padInfo.front,m=t.padInfo.top,f=t.padInfo.left;for(let i=0;i<t.batchSize;++i)for(let k=0;k<t.inChannels;++k)for(let I=0;I<t.outDepth;++I){const g=I*a-h;let b=g;for(;b<0;)b+=r;const y=Math.min(t.inDepth,l+g);for(let a=0;a<t.outHeight;++a){const l=a*s-m;let h=l;for(;h<0;)h+=d;const N=Math.min(t.inHeight,p+l);for(let s=0;s<t.outWidth;++s){const m=s*o-f;let x=m;for(;x<0;)x+=c;const T=Math.min(t.inWidth,u+m);let F=Number.NEGATIVE_INFINITY,S=-1;for(let t=b;t<y;t+=r){const n=t-g;for(let a=h;a<N;a+=d){const s=a-l;for(let o=x;o<T;o+=c){const r=o-m,d=e.get(i,t,a,o,k);d>=F&&(F=d,S=n*p*u+s*p+r)}}}n.set(S,i,I,a,s,k)}}}return n}(n.bufferSync(o),u),m=u.strideDepth,f=u.strideHeight,k=u.strideWidth,I=u.dilationDepth,g=u.dilationHeight,b=u.dilationWidth,y=u.effectiveFilterDepth,N=u.effectiveFilterHeight,x=u.effectiveFilterWidth,T=y-1-u.padInfo.front,F=x-1-u.padInfo.left,S=N-1-u.padInfo.top,v=i(o.shape,"float32"),M=n.bufferSync(s);for(let e=0;e<u.batchSize;++e)for(let t=0;t<u.inChannels;++t)for(let n=0;n<u.inDepth;++n)for(let a=0;a<u.inHeight;++a)for(let s=0;s<u.inWidth;++s){const o=n-T,r=a-S,i=s-F;let d=0;for(let n=0;n<y;n+=I){const a=(o+n)/m;if(!(a<0||a>=u.outDepth||Math.floor(a)!==a))for(let s=0;s<N;s+=g){const o=(r+s)/f;if(!(o<0||o>=u.outHeight||Math.floor(o)!==o))for(let r=0;r<x;r+=b){const c=(i+r)/k;if(c<0||c>=u.outWidth||Math.floor(c)!==c)continue;const l=y*N*x-1-h.get(e,a,o,c,t)===n*N*x+s*x+r?1:0;0!==l&&(d+=M.get(e,a,o,c,t)*l)}}}v.set(d,e,n,a,s,t)}return n.makeTensorInfo(v.shape,v.dtype,v.values)}};const Wo={kernelName:dt,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{dy:s,input:o,output:d}=t,c=o;on([o,d],"maxPoolGrad");const{filterSize:l,strides:p,pad:u,dimRoundingMode:h}=a,m=r.computePool2DInfo(c.shape,l,p,1,u,h),f=n.data.get(c.dataId).values,k=i(m.outShape,c.dtype,rs(f,c.shape,c.dtype,m).values),I=m.strideHeight,g=m.strideWidth,b=m.dilationHeight,y=m.dilationWidth,N=m.effectiveFilterHeight,x=m.effectiveFilterWidth,T=x-1-m.padInfo.left,F=N-1-m.padInfo.top,S=i(c.shape,"float32"),v=n.data.get(s.dataId).values,M=i(s.shape,"float32",v);for(let e=0;e<m.batchSize;++e)for(let t=0;t<m.inChannels;++t)for(let n=0;n<m.inHeight;++n)for(let a=0;a<m.inWidth;++a){const s=n-F,o=a-T;let r=0;for(let n=0;n<N;n+=b){const a=(s+n)/I;if(!(a<0||a>=m.outHeight||Math.floor(a)!==a))for(let s=0;s<x;s+=y){const i=(o+s)/g;if(i<0||i>=m.outWidth||Math.floor(i)!==i)continue;const d=N*x-1-k.get(e,a,i,t)===n*x+s?1:0;0!==d&&(r+=M.get(e,a,i,t)*d)}}S.set(r,e,n,a,t)}return n.makeTensorInfo(S.shape,S.dtype,S.values)}};const Ho={kernelName:ct,backendName:"cpu",kernelFunc:({inputs:t,attrs:n,backend:a})=>{const{x:s}=t,{filterSize:o,strides:i,pad:d,includeBatchInIndex:c}=n,l=a;on(s,"MaxPoolWithArgmax");const p=l.data.get(s.dataId).values,u=r.computePool2DInfo(s.shape,o,i,[1,1],d),[h,m]=function(t,n,a,s,o){const r=os(t,0,a,e.computeStrides(n),o,"max"),i=rs(t,n,a,o,!0,s);return[r.values,i.values]}(p,s.shape,s.dtype,c,u),f=l.write(h,u.outShape,s.dtype),k=l.write(m,u.outShape,s.dtype);return[{dataId:f,shape:u.outShape,dtype:s.dtype},{dataId:k,shape:u.outShape,dtype:"int32"}]}};function Co(t){const{inputs:n,backend:a,attrs:s}=t,{x:o}=n,{axis:i,keepDims:d}=s;let c;on(o,"sum"),c="bool"===o.dtype?bn({inputs:{x:o},backend:a,attrs:{dtype:"int32"}}):fn({inputs:{x:o},backend:a});const l=c.shape.length,p=e.parseAxisParam(i,c.shape),u=r.getAxesPermutation(p,l);let h=p,m=c;null!=u&&(m=ca({inputs:{x:c},backend:a,attrs:{perm:u}}),h=r.getInnerMostAxes(h.length,l)),r.assertAxesAreInnerMostDims("sum",h,m.shape.length);const[f,k]=r.computeOutAndReduceShapes(m.shape,h);let I=mn(a,f,r.upcastType(m.dtype,"int32"));const g=e.sizeFromShape(k),b=a.data.get(I.dataId).values,y=a.data.get(m.dataId).values;for(let e=0;e<b.length;++e){const t=e*g;let n=0;for(let e=0;e<g;++e)n+=y[t+e];b[e]=n}if(d){const e=I;I=Ba({inputs:{x:I},backend:a,attrs:{shape:r.expandShapeToKeepDim(I.shape,p)}}),a.disposeIntermediateTensorInfo(e)}return a.disposeIntermediateTensorInfo(c),null!=u&&a.disposeIntermediateTensorInfo(m),I}const Eo={kernelName:lt,backendName:"cpu",kernelFunc:Co};const Po={kernelName:pt,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o}=n,{axis:i,keepDims:d}=s,c=e.parseAxisParam(i,o.shape),l=r.computeOutAndReduceShapes(o.shape,c)[1],p=e.sizeFromShape(l),u=[],h=a.makeTensorInfo([],"float32",new Float32Array([p]));u.push(h);const m=bn({inputs:{x:o},backend:a,attrs:{dtype:"float32"}});u.push(m);const f=eo({inputs:{a:m,b:h},backend:a});u.push(f);const k=Co({inputs:{x:f},backend:a,attrs:{axis:i,keepDims:d}});return u.forEach(e=>a.disposeIntermediateTensorInfo(e)),k}};const Ro={kernelName:ut,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o}=n,{axis:i,keepDims:d}=s;on(o,"min");const c=e.parseAxisParam(i,o.shape);let l=c;const p=r.getAxesPermutation(l,o.shape.length);let u=o;null!=p&&(u=ca({inputs:{x:o},backend:a,attrs:{perm:p}}),l=r.getInnerMostAxes(l.length,o.shape.length)),r.assertAxesAreInnerMostDims("min",l,u.shape.length);const[h,m]=r.computeOutAndReduceShapes(u.shape,l),f=e.sizeFromShape(m),k=e.makeZerosTypedArray(e.sizeFromShape(h),u.dtype),I=a.data.get(u.dataId).values;for(let e=0;e<k.length;++e){const t=e*f;let n=I[t];for(let e=0;e<f;++e){const a=I[t+e];a<n&&(n=a)}k[e]=n}null!=p&&a.disposeIntermediateTensorInfo(u);const g=a.makeTensorInfo(h,u.dtype,k);if(d){const e=Ba({inputs:{x:g},backend:a,attrs:{shape:r.expandShapeToKeepDim(h,c)}});return a.disposeIntermediateTensorInfo(g),e}return g}};const $o={kernelName:ht,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o}=n,{paddings:r,mode:i}=s;on(o,"mirrorPad");const d=r.map((e,t)=>e[0]+o.shape[t]+e[1]),c=r.map(e=>e[0]),l=r.map((e,t)=>e[0]+o.shape[t]),p="reflect"===i?0:1,u=a.data.get(o.dataId).values,h=o.shape.length,m=e.computeStrides(o.shape),f=e.sizeFromShape(d),k=d.length,I=e.computeStrides(d),g=e.getTypedArrayFromDType(o.dtype,f);for(let t=0;t<f;t++){let n=e.indexToLoc(t,k,I);for(let e=0;e<k;e++)n[e]<c[e]?n[e]=2*c[e]-n[e]-p:n[e]>=l[e]&&(n[e]=2*(l[e]-1)-n[e]+p);n=n.map((e,t)=>e-c[t]);const a=e.locToIndex(n,h,m);g[t]=u[a]}return{dataId:a.write(g,d,o.dtype),shape:d,dtype:o.dtype}}},Oo={kernelName:mt,backendName:"cpu",kernelFunc:Nn(mt,pn((e,t)=>{const n=e%t;return e<0&&t<0||e>=0&&t>=0?n:(n+t)%t}))};function Vo(t){const{inputs:n,backend:a,attrs:s}=t,{logits:o}=n,{dim:i}=s,d=o.shape.length;let c=i;if(-1===c&&(c=d-1),c!==d-1)throw Error("Softmax along a non-last dimension is not yet supported. "+`Logits was rank ${d} and dim was ${c}`);const l=e.parseAxisParam([c],o.shape),p=Mo({inputs:{x:o},backend:a,attrs:{reductionIndices:l,keepDims:!1}}),u=r.expandShapeToKeepDim(p.shape,l),h=Ba({inputs:{x:p},backend:a,attrs:{shape:u}}),m=Ta({inputs:{a:o,b:h},backend:a}),f=En({inputs:{x:m},backend:a}),k=Co({inputs:{x:f},backend:a,attrs:{axis:l,keepDims:!1}}),I=Ba({inputs:{x:k},backend:a,attrs:{shape:u}}),g=eo({inputs:{a:f,b:I},backend:a});return a.disposeIntermediateTensorInfo(p),a.disposeIntermediateTensorInfo(h),a.disposeIntermediateTensorInfo(m),a.disposeIntermediateTensorInfo(f),a.disposeIntermediateTensorInfo(k),a.disposeIntermediateTensorInfo(I),g}const _o={kernelName:ft,backendName:"cpu",kernelFunc:Vo};const Bo={kernelName:kt,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{logits:o}=n,{numSamples:r,seed:i,normalized:d}=s;on(o,"multinomial");const c=d?o:Vo({inputs:{logits:o},backend:a,attrs:{dim:-1}}),l=c.shape[0],p=c.shape[1],u=a.data.get(c.dataId).values,h=[l,r],m=e.makeZerosTypedArray(e.sizeFromShape(h),"int32");for(let e=0;e<l;++e){const t=e*p,n=new Float32Array(p-1);n[0]=u[t];for(let e=1;e<n.length;++e)n[e]=n[e-1]+u[t+e];const a=sn(i.toString()),s=e*r;for(let e=0;e<r;++e){const t=a();m[s+e]=n.length;for(let a=0;a<n.length;a++)if(t<n[a]){m[s+e]=a;break}}}return d||a.disposeIntermediateTensorInfo(c),a.makeTensorInfo(h,"int32",m)}},Lo=t.nonMaxSuppressionV3Impl;const Go={kernelName:It,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{boxes:s,scores:o}=t,{maxOutputSize:r,iouThreshold:i,scoreThreshold:d}=a;on(s,"NonMaxSuppression");const c=n.data.get(s.dataId).values,l=n.data.get(o.dataId).values,{selectedIndices:p}=Lo(c,l,r,i,d);return n.makeTensorInfo([p.length],"int32",new Int32Array(p))}},qo=t.nonMaxSuppressionV4Impl;const Uo={kernelName:gt,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{boxes:s,scores:o}=t,{maxOutputSize:r,iouThreshold:i,scoreThreshold:d,padToMaxOutputSize:c}=a;on(s,"NonMaxSuppressionPadded");const l=n.data.get(s.dataId).values,p=n.data.get(o.dataId).values,{selectedIndices:u,validOutputs:h}=qo(l,p,r,i,d,c);return[n.makeTensorInfo([u.length],"int32",new Int32Array(u)),n.makeTensorInfo([],"int32",new Int32Array([h]))]}},Zo=t.nonMaxSuppressionV5Impl;const jo={kernelName:bt,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{boxes:s,scores:o}=t,{maxOutputSize:r,iouThreshold:i,scoreThreshold:d,softNmsSigma:c}=a;on(s,"NonMaxSuppressionWithScore");const l=n.data.get(s.dataId).values,p=n.data.get(o.dataId).values,u=r,h=i,m=d,f=c,{selectedIndices:k,selectedScores:I}=Zo(l,p,u,h,m,f);return[n.makeTensorInfo([k.length],"int32",new Int32Array(k)),n.makeTensorInfo([I.length],"float32",new Float32Array(I))]}};const Ko={kernelName:yt,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{indices:o}=n,{depth:r,onValue:i,offValue:d}=s;on(o,"oneHot");const c=e.sizeFromShape(o.shape),l=new Float32Array(c*r);l.fill(d);const p=a.data.get(o.dataId).values;for(let e=0;e<c;++e)p[e]>=0&&p[e]<r&&(l[e*r+p[e]]=i);return a.makeTensorInfo([...o.shape,r],"int32",l)}};function Yo(e){const{inputs:t,backend:n}=e,{x:a}=t;if("string"===a.dtype)throw new Error("zerosLike is not supported for string tensors");if("complex64"===a.dtype){const e=In({inputs:{input:a},backend:n}),t=Yo({inputs:{x:e},backend:n}),s=Is({inputs:{input:a},backend:n}),o=Yo({inputs:{x:s},backend:n}),r=un({inputs:{real:t,imag:o},backend:n});return n.disposeIntermediateTensorInfo(e),n.disposeIntermediateTensorInfo(t),n.disposeIntermediateTensorInfo(s),n.disposeIntermediateTensorInfo(o),r}return oo({backend:n,attrs:{shape:a.shape,value:0,dtype:a.dtype}})}const Jo={kernelName:Nt,backendName:"cpu",kernelFunc:Yo};const Qo={kernelName:xt,backendName:"cpu",kernelFunc:function e(t){const{inputs:n,backend:a}=t,{x:s}=n;if("string"===s.dtype)throw new Error("onesLike is not supported for string tensors");if("complex64"===s.dtype){const t=In({inputs:{input:s},backend:a}),n=e({inputs:{x:t},backend:a}),o=Is({inputs:{input:s},backend:a}),r=Yo({inputs:{x:o},backend:a}),i=un({inputs:{real:n,imag:r},backend:a});return a.disposeIntermediateTensorInfo(t),a.disposeIntermediateTensorInfo(n),a.disposeIntermediateTensorInfo(o),a.disposeIntermediateTensorInfo(r),i}return oo({backend:a,attrs:{shape:s.shape,value:1,dtype:s.dtype}})}};function Xo(t){const{inputs:n,backend:a,attrs:s}=t,{axis:o}=s;if(1===n.length)return Qs({inputs:{input:n[0]},backend:a,attrs:{dim:o}});const r=n[0].shape,i=n[0].dtype;n.forEach(t=>{e.assertShapesMatch(r,t.shape,"All tensors passed to stack must have matching shapes"),e.assert(i===t.dtype,()=>"All tensors passed to stack must have matching dtypes")});const d=[],c=bs({inputs:n.map(e=>{const t=Qs({inputs:{input:e},backend:a,attrs:{dim:o}});return d.push(t),t}),backend:a,attrs:{axis:o}});return d.forEach(e=>a.disposeIntermediateTensorInfo(e)),c}const er={kernelName:Tt,backendName:"cpu",kernelFunc:Xo};const tr={kernelName:Ft,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o}=n,{paddings:r,constantValue:i}=s;on(o,"pad");const d=r.map((e,t)=>e[0]+o.shape[t]+e[1]),c=r.map(e=>e[0]),l=a.data.get(o.dataId).values,p=e.sizeFromShape(o.shape),u=o.shape.length,h=e.computeStrides(o.shape),m=e.sizeFromShape(d),f=d.length,k=e.computeStrides(d),I=e.getTypedArrayFromDType(o.dtype,m);0!==i&&I.fill(i);for(let t=0;t<p;t++){const n=e.indexToLoc(t,u,h).map((e,t)=>e+c[t]);I[e.locToIndex(n,f,k)]=l[t]}return{dataId:a.write(I,d,o.dtype),shape:d,dtype:o.dtype}}},nr={kernelName:St,backendName:"cpu",kernelFunc:Nn(St,pn((e,t)=>Math.pow(e,t)))};const ar={kernelName:vt,backendName:"cpu",kernelFunc:function(e){const{backend:t,attrs:n}=e,{start:a,stop:s,dtype:o,step:r}=n,i=ha(a,s,r,o);return t.makeTensorInfo([i.length],o,i)}},sr={kernelName:Mt,backendName:"cpu",kernelFunc:zn(Mt,e=>1/e)};const or={kernelName:At,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{images:o}=n,{alignCorners:r,halfPixelCenters:i,size:d}=s;on(o,"resizeBilinear");const c=e.computeStrides(o.shape),[l,p]=d,[u,h,m,f]=o.shape,k=a.data.get(o.dataId).values,I=new Float32Array(e.sizeFromShape([u,l,p,f])),g=[r&&l>1?h-1:h,r&&p>1?m-1:m],b=[r&&l>1?l-1:l,r&&p>1?p-1:p];let y=0;const N=g[0]/b[0],x=g[1]/b[1];for(let e=0;e<u;e++)for(let t=0;t<l;t++){let n;n=i?N*(t+.5)-.5:N*t;const a=Math.max(0,Math.floor(n)),s=n-a,o=Math.min(h-1,Math.ceil(n)),r=e*c[0]+a*c[1],d=e*c[0]+o*c[1];for(let e=0;e<p;e++){let t;t=i?x*(e+.5)-.5:x*e;const n=Math.max(0,Math.floor(t)),a=t-n,o=Math.min(m-1,Math.ceil(t)),l=r+n*c[2],p=d+n*c[2],u=r+o*c[2],h=d+o*c[2];for(let e=0;e<f;e++){const t=k[l+e],n=k[p+e],o=t+(k[u+e]-t)*a,r=o+(n+(k[h+e]-n)*a-o)*s;I[y++]=r}}}return a.makeTensorInfo([u,l,p,f],"float32",I)}};const rr={kernelName:zt,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{images:o,dy:r}=n,{alignCorners:i}=s;on([r,o],"resizeBilinearGrad");const d=e.computeStrides(o.shape),[c,l,p,u]=o.shape,[,h,m]=r.shape,f=new Float32Array(c*l*p*u),k=[i&&h>1?l-1:l,i&&m>1?p-1:p],I=[i&&h>1?h-1:h,i&&m>1?m-1:m],g=k[0]/I[0],b=k[1]/I[1],y=a.data.get(r.dataId).values;let N=0;for(let e=0;e<c;e++){const t=e*d[0];for(let e=0;e<h;e++){const n=e*g,a=Math.floor(n),s=Math.min(Math.ceil(n),l-1),o=t+a*d[1],r=t+s*d[1],i=n-a,c=1-i;for(let e=0;e<m;e++){const t=e*b,n=Math.floor(t),a=Math.min(Math.ceil(t),p-1),s=t-n,l=1-s,h=o+n*d[2],m=o+a*d[2],k=r+n*d[2],I=r+a*d[2],g=c*l,x=c*s,T=i*l,F=i*s;for(let e=0;e<u;e++){const t=y[N++];f[h+e]+=t*g,f[m+e]+=t*x,f[k+e]+=t*T,f[I+e]+=t*F}}}}return a.makeTensorInfo([c,p,l,u],"float32",f)}};const ir={kernelName:Dt,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{images:o}=n,{alignCorners:r,halfPixelCenters:i,size:d}=s;on(o,"resizeNearestNeighbor");const c=e.computeStrides(o.shape),[l,p]=d,[u,h,m,f]=o.shape,k=a.data.get(o.dataId).values,I=new Float32Array(u*l*p*f),g=[r&&l>1?h-1:h,r&&p>1?m-1:m],b=[r&&l>1?l-1:l,r&&p>1?p-1:p],y=g[0]/b[0],N=g[1]/b[1];let x=0;for(let e=0;e<u;e++){const t=e*c[0];for(let e=0;e<l;e++){const n=i?y*(e+.5):y*e;let a=Math.min(h-1,r?Math.round(n):Math.floor(n));i&&(a=Math.max(0,a));const s=t+a*c[1];for(let e=0;e<p;e++){const t=i?N*(e+.5):N*e;let n=Math.min(m-1,r?Math.round(t):Math.floor(t));i&&(n=Math.max(0,n));const a=s+n*c[2];for(let e=0;e<f;e++){const t=k[a+e];I[x++]=t}}}}return a.makeTensorInfo([u,l,p,f],o.dtype,I)}};const dr={kernelName:wt,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{images:o,dy:r}=n,{alignCorners:i}=s;on([r,o],"resizeNearestNeighborGrad");const d=e.computeStrides(o.shape),c=e.computeStrides(r.shape),[l,p,u,h]=o.shape,[,m,f]=r.shape,k=new Float32Array(l*p*u*h),I=a.data.get(r.dataId).values,g=[i&&m>1?p-1:p,i&&f>1?u-1:u],b=[i&&m>1?m-1:m,i&&f>1?f-1:f],y=g[0]/b[0],N=g[1]/b[1],x=1/y,T=1/N,F=2*Math.ceil(x)+2,S=2*Math.ceil(T)+2;for(let e=0;e<l;e++){const t=e*d[0];for(let e=0;e<p;e++){const n=t+e*d[1],a=Math.floor(e*x),s=Math.floor(a-F/2);for(let a=0;a<u;a++){const o=n+a*d[2],r=Math.floor(a*T),l=Math.floor(r-S/2);for(let n=0;n<h;n++){let r=0;for(let o=0;o<F;o++){const d=o+s;if(d<0||d>=m)continue;const h=t+d*c[1],k=d*y;if(e===Math.min(p-1,i?Math.round(k):Math.floor(k)))for(let e=0;e<S;e++){const t=e+l;if(t<0||t>=f)continue;const s=h+t*c[2],o=t*N;a===Math.min(u-1,i?Math.round(o):Math.floor(o))&&(r+=I[s+n])}}k[o+n]=r}}}}return a.makeTensorInfo(o.shape,o.dtype,k)}};const cr={kernelName:Wt,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o}=n,{dims:r}=s;on(o,"reverse");const i=o.shape.length,d=e.parseAxisParam(r,o.shape);if(0===i)return fn({inputs:{x:o},backend:a});const c=new C(o.shape,o.dtype),l=a.bufferSync(o);for(let e=0;e<c.size;e++){const t=c.indexToLoc(e),n=t.slice();d.forEach(e=>n[e]=o.shape[e]-1-n[e]),c.set(l.get(...n),...t)}return a.makeTensorInfo(c.shape,c.dtype,c.values)}},lr={kernelName:Ht,backendName:"cpu",kernelFunc:({inputs:t,attrs:n,backend:a})=>{const{image:s}=t,{radians:o,fillValue:i,center:d}=n,c=a,l=e.getTypedArrayFromDType(s.dtype,e.sizeFromShape(s.shape)),[p,u,h,m]=s.shape,[f,k]=r.getImageCenter(d,u,h),I=Math.sin(o),g=Math.cos(o),b=c.data.get(s.dataId).values;for(let e=0;e<p;e++){const t=e*h*u*m;for(let e=0;e<u;e++){const n=e*(h*m);for(let a=0;a<h;a++){const s=a*m;for(let o=0;o<m;o++){const r=[p,e,a,o],d=r[2],c=r[1];let y=(d-f)*g-(c-k)*I,N=(d-f)*I+(c-k)*g;y=Math.round(y+f),N=Math.round(N+k);let x=i;if("number"!=typeof i&&(x=3===o?255:i[o]),y>=0&&y<h&&N>=0&&N<u){x=b[t+N*(h*m)+y*m+o]}l[t+n+s+o]=x}}}}return{dataId:c.write(l,s.shape,s.dtype),shape:s.shape,dtype:s.dtype}}},pr={kernelName:Ct,backendName:"cpu",kernelFunc:zn(Ct,e=>{const t=Math.floor(e);return e-t<.5?Math.floor(e):e-t>.5?Math.ceil(e):t%2==0?t:t+1})};function ur(e,t,n,a,s,o,r,d,c,l){const p=[a/s,s],u=e.values,h=t.values;if(0===a)return i(n,t.dtype);const m=i(p,t.dtype);m.values.fill(c);for(let e=0;e<o;e++){const o=[];let i=0;for(let t=0;t<r;t++){const n=u[e*r+t];o.push(n),i+=n*d[t]}if(i<0||i>=a/s)throw new Error(`Invalid indices: ${o} does not index into ${n}`);for(let n=0;n<s;n++)l?m.values[i*s+n]+=h[e*s+n]:m.values[i*s+n]=0===t.rank?h[0]:h[e*s+n]}return m}const hr={kernelName:Et,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{indices:s,updates:o}=t,{shape:i}=a,{sliceRank:d,numUpdates:c,sliceSize:l,strides:p,outputSize:u}=r.calculateShapes(o,s,i),h=ur(n.bufferSync(s),n.bufferSync(o),i,u,l,c,d,p,0,!0);return n.makeTensorInfo(i,h.dtype,h.values)}};const mr={kernelName:Pt,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a}=t,{condition:s,t:o,e:r}=n;on([s,o,r],"select");const i=s.shape.length,d=a.data.get(s.dataId).values,c=a.data.get(o.dataId).values,l=a.data.get(r.dataId).values,p=M(o.dtype,r.dtype),u=e.makeZerosTypedArray(e.sizeFromShape(o.shape),p);let h=0;const m=0===i||i>1||1===o.shape.length?1:e.sizeFromShape(o.shape.slice(1));for(let e=0;e<d.length;e++)for(let t=0;t<m;t++)1===d[e]?u[h++]=c[e]:u[h++]=l[e];return a.makeTensorInfo(o.shape,p,u)}},fr=r.SELU_SCALEALPHA,kr=r.SELU_SCALE,Ir={kernelName:Rt,backendName:"cpu",kernelFunc:zn(Rt,e=>e>=0?kr*e:fr*(Math.exp(e)-1))},gr={kernelName:$t,backendName:"cpu",kernelFunc:zn($t,e=>1/(1+Math.exp(-e)))},br={kernelName:Ot,backendName:"cpu",kernelFunc:zn(Ot,e=>e<0?-1:e>0?1:0)},yr={kernelName:Vt,backendName:"cpu",kernelFunc:zn(Vt,e=>Math.sin(e))},Nr={kernelName:_t,backendName:"cpu",kernelFunc:zn(_t,e=>Math.sinh(e))},xr=Math.log(1.1920928955078125e-7)+2,Tr={kernelName:Bt,backendName:"cpu",kernelFunc:zn(Bt,e=>{const t=e>-xr,n=e<xr,a=Math.exp(e);let s;return s=n?a:t?e:Math.log(1+a),s})};const Fr={kernelName:Lt,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o}=n,{blockShape:i,paddings:d}=s;on([o],"spaceToBatchND");const c=e.sizeFromShape(i),l=[[0,0]];l.push(...d);for(let e=1+i.length;e<o.shape.length;++e)l.push([0,0]);const p=tr.kernelFunc({inputs:{x:o},backend:a,attrs:{paddings:l,constantValue:0}}),u=r.getReshaped(p.shape,i,c,!1),h=r.getPermuted(u.length,i.length,!1),m=r.getReshapedPermuted(p.shape,i,c,!1),f=Ba({inputs:{x:p},backend:a,attrs:{shape:u}}),k=ca({inputs:{x:f},backend:a,attrs:{perm:h}}),I=Ba({inputs:{x:k},backend:a,attrs:{shape:m}});return a.disposeIntermediateTensorInfo(p),a.disposeIntermediateTensorInfo(f),a.disposeIntermediateTensorInfo(k),I}};const Sr={kernelName:Gt,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{sparseIndices:s,sparseValues:o,defaultValue:i}=t,{outputShape:d}=a,{sliceRank:c,numUpdates:l,sliceSize:p,strides:u,outputSize:h}=r.calculateShapes(o,s,d),m=ur(n.bufferSync(s),n.bufferSync(o),d,h,p,l,c,u,n.data.get(i.dataId).values[0],!1);return n.makeTensorInfo(d,m.dtype,m.values)}};const vr={kernelName:qt,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o}=n,{numOrSizeSplits:i,axis:d}=s,c=e.parseAxisParam(d,o.shape)[0],l=r.prepareSplitSize(o,i,c),p=new Array(o.shape.length).fill(0),u=o.shape.slice();return l.map(e=>{const t=[...u];t[c]=e;const n=Ia({inputs:{x:o},backend:a,attrs:{begin:p,size:t}});return p[c]+=e,n})}},Mr={kernelName:Ut,backendName:"cpu",kernelFunc:zn(Ut,e=>Math.sqrt(e))},Ar={kernelName:Zt,backendName:"cpu",kernelFunc:({inputs:e,backend:t})=>{const{x:n}=e,a=t;on(n,"square");const s=a.data.get(n.dataId).values,o=new Float32Array(s.length);for(let e=0;e<s.length;++e){const t=s[e];o[e]=t*t}return{dataId:a.write(o,n.shape,n.dtype),shape:n.shape,dtype:n.dtype}}},zr={kernelName:jt,backendName:"cpu",kernelFunc:zn(jt,(e,t)=>{const n=t;return isNaN(e)?NaN:e>0?1:n.alpha})};const Dr={kernelName:Kt,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{x:s}=t,{begin:o,end:r,strides:i,beginMask:d,endMask:c,ellipsisMask:l,newAxisMask:p,shrinkAxisMask:u}=a;on(s,"stridedSlice");const{nonStrided:h,$begin:m,$strides:f,size:k,newShape:I,outShape:g}=D.sliceInfo(s.shape,o,r,i,d,c,l,p,u),b=Ba({inputs:{x:s},backend:n,attrs:{shape:I}});let y;if(h){const e=Ia({inputs:{x:b},backend:n,attrs:{begin:m,size:k}});y=Ba({inputs:{x:e},backend:n,attrs:{shape:g}}),n.disposeIntermediateTensorInfo(e)}else if(g.some(e=>0===e))y=n.makeTensorInfo(g,s.dtype,[]);else{const e=Na(g,n.bufferSync(b),f,m);y=n.makeTensorInfo(e.shape,e.dtype,e.values)}const N=Ba({inputs:{x:y},backend:n,attrs:{shape:g}});return n.disposeIntermediateTensorInfo(b),n.disposeIntermediateTensorInfo(y),N}},wr={kernelName:Yt,backendName:"cpu",kernelFunc:zn(Yt,e=>Math.tan(e))},Wr=zn(Jt,e=>Math.tanh(e));const Hr=[Ua,ln,Za,ja,Sn,Ka,Ya,Ja,Qa,Xa,es,ts,ns,as,ss,ds,cs,ls,ps,qa,us,hs,ms,yn,Wn,fs,hn,ks,ys,Ts,Fs,xs,vs,Ms,Ss,As,zs,Ds,ws,Ws,Hs,Es,Ps,Rs,$s,Os,_s,Vs,to,wa,Bs,Gs,Js,Pn,Xs,$n,so,ro,io,Vn,co,lo,po,uo,ho,Ln,mo,kn,fo,gs,ko,Io,go,Ha,qn,bo,yo,jn,No,xo,To,Fo,So,vo,Jn,zo,Do,wo,Wo,Ho,Ao,Po,Ro,Xn,$o,Oo,Bo,aa,oa,Go,Uo,jo,ia,Ko,Qo,er,tr,nr,Pa,ua,ar,gn,sr,$a,Va,La,or,rr,ir,dr,cr,lr,pr,fa,hr,mr,Ir,gr,br,yr,Nr,ga,_o,Tr,Fr,Sr,vr,Mr,Ar,ya,zr,Dr,Fa,Eo,wr,{kernelName:Jt,backendName:"cpu",kernelFunc:Wr},{kernelName:Qt,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{x:s}=t,{reps:o}=a;on(s,"tile");const r=Sa(n.bufferSync(s),o);return n.makeTensorInfo(r.shape,r.dtype,r.values)}},{kernelName:Xt,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{x:s}=t,{k:o,sorted:r}=a;on(s,"topk");const i=n.data.get(s.dataId).values,[d,c]=va(i,s.shape,s.dtype,o);return[n.makeTensorInfo(d.shape,d.dtype,d.values),n.makeTensorInfo(c.shape,c.dtype,c.values)]}},la,{kernelName:en,backendName:"cpu",kernelFunc:function(e){const{inputs:t,attrs:n,backend:a}=e,{axis:s}=n,{x:o}=t;on(o,"unique");const r=a.data.get(o.dataId).values,{outputValues:i,outputShape:d,indices:c}=Ma(r,s,o.shape,o.dtype);return[a.makeTensorInfo(d,o.dtype,i),a.makeTensorInfo([c.length],"int32",c)]}},{kernelName:tn,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{value:s}=t;let{axis:o}=a;o<0&&(o+=s.shape.length);const r=s.shape.length,i=s.shape[o],d=new Array(r-1);let c=0;for(let e=0;e<r;e++)e!==o&&(d[c++]=s.shape[e]);const l=new Array(r).fill(0),p=s.shape.slice();p[o]=1;const u=new Array(i);for(let e=0;e<u.length;e++){l[o]=e;const t=Ia({inputs:{x:s},backend:n,attrs:{begin:l,size:p}});u[e]=Ba({inputs:{x:t},backend:n,attrs:{shape:d}}),n.disposeIntermediateTensorInfo(t)}return u}},{kernelName:nn,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o,segmentIds:r}=n,{numSegments:i}=s;on(o,"unsortedSegmentSum");const d=[],c=[],l=o.shape.length-r.shape.length;let p=r;for(let e=0;e<l;++e){const t=Qs({inputs:{input:p},backend:a,attrs:{dim:e+1}});p=t,c.push(t)}for(let t=0;t<i;++t){const n=e.createScalarValue(t,"int32"),s=a.makeTensorInfo([],"int32",n),r=Ls({inputs:{a:s,b:p},backend:a}),i=bn({inputs:{x:r},backend:a,attrs:{dtype:"float32"}}),l=na({inputs:{a:i,b:o},backend:a}),u=Co({inputs:{x:l},backend:a,attrs:{axis:0,keepDims:!1}});d.push(u),c.push(s),c.push(r),c.push(i),c.push(l),c.push(u)}const u=Xo({inputs:d,backend:a,attrs:{axis:0}});return c.forEach(e=>a.disposeIntermediateTensorInfo(e)),u}},Jo];for(const e of Hr)an(e);export{dn as MathBackendCPU,Aa as shared,za as version_cpu};
//# sourceMappingURL=tf-backend-cpu.fesm.min.js.map
