/**
 * @license
 * Copyright 2021 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports,require("@tensorflow/tfjs-core"),require("seedrandom")):"function"==typeof define&&define.amd?define(["exports","@tensorflow/tfjs-core","seedrandom"],t):t((e=e||self).tf=e.tf||{},e.tf,e.seedrandom)}(this,(function(e,t,n){"use strict";function a(e,n){Array.isArray(e)||(e=[e]),e.forEach(e=>{null!=e&&t.util.assert("complex64"!==e.dtype,()=>n+" does not support complex64 tensors in the CPU backend.")})}const s=t.kernel_impls.whereImpl;class o extends t.KernelBackend{constructor(){super(),this.blockSize=48,this.firstUse=!0,this.data=new t.DataStorage(this,t.engine())}nextDataId(){return o.nextDataId++}write(e,n,a){this.firstUse&&(this.firstUse=!1,t.env().get("IS_NODE")&&t.backend_util.warn("\n============================\nHi there 👋. Looks like you are running TensorFlow.js in Node.js. To speed things up dramatically, install our node backend, which binds to TensorFlow C++, by running npm i @tensorflow/tfjs-node, or npm i @tensorflow/tfjs-node-gpu if you have CUDA. Then call require('@tensorflow/tfjs-node'); (-gpu suffix for CUDA) at the start of your program. Visit https://github.com/tensorflow/tfjs-node for more details.\n============================"));const s={id:this.nextDataId()};return this.data.set(s,{values:e,dtype:a,refCount:1}),s}makeTensorInfo(e,n,a){let s;if("string"===n&&null!=a&&a.length>0&&t.util.isString(a[0])){const o=a.map(e=>t.util.encodeString(e));s=this.write(o,e,n)}else s=this.write(a,e,n);return{dataId:s,shape:e,dtype:n}}refCount(e){if(this.data.has(e)){return this.data.get(e).refCount}return 0}incRef(e){this.data.get(e).refCount++}decRef(e){if(this.data.has(e)){this.data.get(e).refCount--}}move(e,t,n,a,s){this.data.set(e,{values:t,dtype:a,refCount:s})}numDataIds(){return this.data.numDataIds()}async read(e){return this.readSync(e)}readSync(e){const{dtype:n,complexTensorInfos:a}=this.data.get(e);if("complex64"===n){const e=this.readSync(a.real.dataId),n=this.readSync(a.imag.dataId);return t.backend_util.mergeRealAndImagArrays(e,n)}return this.data.get(e).values}bufferSync(e){const n=this.readSync(e.dataId);let a=n;if("string"===e.dtype)try{a=n.map(e=>t.util.decodeString(e))}catch(e){throw new Error("Failed to decode encoded string bytes into utf-8")}return t.buffer(e.shape,e.dtype,a)}makeOutput(e,n,a){const s=this.write(e,n,a);return t.engine().makeTensorFromDataId(s,n,a,this)}disposeData(e,t=!1){if(this.data.has(e)){if(this.data.get(e).refCount--,!t&&this.data.get(e).refCount>0)return!1;const{complexTensorInfos:n}=this.data.get(e);null!=n&&(this.disposeData(n.real.dataId,!0),this.disposeData(n.imag.dataId,!0)),this.data.delete(e)}return!0}disposeIntermediateTensorInfo(e){this.disposeData(e.dataId)}async time(e){const n=t.util.now();e();return{kernelMs:t.util.now()-n}}memory(){return{unreliable:!0,reasons:["The reported memory is an upper bound. Due to automatic garbage collection, the true allocated memory may be less."]}}where(e){a([e],"where");const t=this.readSync(e.dataId);return s(e.shape,t)}dispose(){}floatPrecision(){return 32}epsilon(){return super.epsilon()}}function r(e){const t=new Float32Array(e.length);for(let n=0;n<e.length;++n)t[n]=Math.abs(e[n]);return t}o.nextDataId=0;const i={kernelName:t.Abs,backendName:"cpu",kernelFunc:e=>{const{x:n}=e.inputs,s=e.backend;a(n,"abs");let o=new Float32Array(t.util.sizeFromShape(n.shape));return o=r(s.data.get(n.dataId).values),s.makeOutput(o,n.shape,"float32")}};function l(e){return(n,a,s,o,r)=>{const i=t.backend_util.assertAndGetBroadcastShape(n,a),l=i.length,d=t.util.computeStrides(i),u=t.util.sizeFromShape(i),c=t.util.getTypedArrayFromDType(r,u),p=n.length,h=a.length,f=t.util.computeStrides(n),m=t.util.computeStrides(a),k=t.backend_util.getBroadcastDims(n,i),b=t.backend_util.getBroadcastDims(a,i);if(k.length+b.length===0)for(let t=0;t<c.length;++t)c[t]=e(s[t%s.length],o[t%o.length]);else for(let n=0;n<c.length;++n){const a=t.util.indexToLoc(n,l,d),r=a.slice(-p);k.forEach(e=>r[e]=0);const i=t.util.locToIndex(r,p,f),u=a.slice(-h);b.forEach(e=>u[e]=0);const g=t.util.locToIndex(u,h,m);c[n]=e(s[i],o[g])}return[c,i]}}function d(e){const{inputs:t,backend:n}=e,{real:a,imag:s}=t,o=n.data.get(a.dataId).values,r=n.data.get(s.dataId).values,i=n.makeTensorInfo(a.shape,"complex64");return n.data.get(i.dataId).complexTensorInfos={real:n.makeTensorInfo(a.shape,"float32",o),imag:n.makeTensorInfo(s.shape,"float32",r)},i}const u={kernelName:t.Complex,backendName:"cpu",kernelFunc:d};function c(e,n,a="float32"){if("complex64"===a){return d({inputs:{real:c(e,n,"float32"),imag:c(e,n,"float32")},backend:e})}const s=t.util.makeZerosTypedArray(t.util.sizeFromShape(n),a);return e.makeTensorInfo(n,a,s)}function p(e){const{inputs:t,backend:n}=e,{x:a}=t;return n.incRef(a.dataId),{dataId:a.dataId,shape:a.shape,dtype:a.dtype}}const h={kernelName:t.Identity,backendName:"cpu",kernelFunc:p};function f(e){const{inputs:t,backend:n}=e,{input:a}=t,s=n.data.get(a.dataId).complexTensorInfos.real,o=n.data.get(s.dataId).values;return n.makeTensorInfo(s.shape,s.dtype,o)}const m={kernelName:t.Real,backendName:"cpu",kernelFunc:f};function k(e){const{inputs:n,backend:a,attrs:s}=e,{x:o}=n,{dtype:r}=s;if("complex64"===r){if("complex64"===o.dtype)return p({inputs:{x:o},backend:a});const e=c(a,o.shape,o.dtype),t=k({inputs:{x:o},backend:a,attrs:{dtype:"float32"}}),n=d({inputs:{real:t,imag:e},backend:a});return a.disposeIntermediateTensorInfo(e),a.disposeIntermediateTensorInfo(t),n}if("complex64"===o.dtype){const e=f({inputs:{input:o},backend:a}),t=k({inputs:{x:e},backend:a,attrs:{dtype:r}});return a.disposeIntermediateTensorInfo(e),t}if(!t.util.hasEncodingLoss(o.dtype,r)){const e=p({inputs:{x:o},backend:a});return{dataId:e.dataId,shape:e.shape,dtype:r}}if("int32"===r){const e=a.data.get(o.dataId).values,t=Int32Array.from(e);return a.makeTensorInfo(o.shape,"int32",t)}if("bool"===r){const e=a.data.get(o.dataId).values,n=t.util.toTypedArray([0],o.dtype),[s,r]=l((e,t)=>e!==t?1:0)(o.shape,[],e,n,"bool");return a.makeTensorInfo(r,"bool",s)}throw new Error(`Error in Cast: failed to cast ${o.dtype} to ${r}`)}const b={kernelName:t.Cast,backendName:"cpu",kernelFunc:k};function g(e,t,n,s){return null==n?({inputs:n,backend:o})=>{const{a:r,b:i}=n,l=o;a([r,i],e);const d=l.data.get(r.dataId).values,u=l.data.get(i.dataId).values,c=s||r.dtype,[p,h]=t(r.shape,i.shape,d,u,c);return l.makeTensorInfo(h,c,p)}:({inputs:e,backend:a})=>{const{a:o,b:r}=e,i=a;if("complex64"===o.dtype||"complex64"===r.dtype){const e=k({inputs:{x:o},backend:i,attrs:{dtype:"complex64"}}),t=i.data.get(e.dataId),a=t.complexTensorInfos.real,s=t.complexTensorInfos.imag,l=i.data.get(a.dataId).values,u=i.data.get(s.dataId).values,c=k({inputs:{x:r},backend:i,attrs:{dtype:"complex64"}}),p=i.data.get(c.dataId),h=p.complexTensorInfos.real,f=p.complexTensorInfos.imag,m=i.data.get(h.dataId).values,b=i.data.get(f.dataId).values,[g,I,y]=n(o.shape,r.shape,l,u,m,b),N=i.makeTensorInfo(y,"float32",g),x=i.makeTensorInfo(y,"float32",I),T=d({inputs:{real:N,imag:x},backend:i});return i.disposeIntermediateTensorInfo(e),i.disposeIntermediateTensorInfo(c),i.disposeIntermediateTensorInfo(N),i.disposeIntermediateTensorInfo(x),T}{const e=i.data.get(o.dataId).values,n=i.data.get(r.dataId).values,a=s||o.dtype,[l,d]=t(o.shape,r.shape,e,n,a);return i.makeTensorInfo(d,a,l)}}}function I(e){return(n,a,s,o,r,i)=>{const l=t.backend_util.assertAndGetBroadcastShape(n,a),d=t.util.sizeFromShape(l),u=l.length,c=t.util.computeStrides(l),p=t.util.getTypedArrayFromDType("float32",d),h=t.util.getTypedArrayFromDType("float32",d),f=t.backend_util.getBroadcastDims(n,l),m=t.backend_util.getBroadcastDims(a,l),k=t.backend_util.mergeRealAndImagArrays(s,o),b=t.backend_util.mergeRealAndImagArrays(r,i),g=n.length,I=t.util.computeStrides(n),y=a.length,N=t.util.computeStrides(a);if(f.length+m.length===0)for(let t=0;t<p.length;t++){const n=t%k.length,a=t%b.length,s=e(k[2*n],k[2*n+1],b[2*a],b[2*a+1]);p[t]=s.real,h[t]=s.imag}else for(let n=0;n<p.length;n++){const a=t.util.indexToLoc(n,u,c),s=a.slice(-g);f.forEach(e=>s[e]=0);const o=t.util.locToIndex(s,g,I),r=a.slice(-y);m.forEach(e=>r[e]=0);const i=t.util.locToIndex(r,y,N),l=e(k[2*o],k[2*o+1],b[2*i],b[2*i+1]);p[n]=l.real,h[n]=l.imag}return[p,h,l]}}const y=l((e,t)=>e+t),N=I((e,t,n,a)=>({real:e+n,imag:t+a})),x=g(t.Add,y,N),T={kernelName:t.Add,backendName:"cpu",kernelFunc:x};function S(e,n,a,s,o){const r=t.util.sizeFromShape(s),i=t.util.makeZerosTypedArray(o,a);for(let t=0;t<e.length;t++){const a=e[t];if(a<0)throw new Error("Input x must be non-negative!");a>=o||(i[a]+=r>0?n[t]:1)}return i}function F(e,n,a,s=!1){const o=e.shape[0],r=e.shape[1],i=t.buffer([o,a],n.dtype);for(let t=0;t<o;t++)for(let o=0;o<r;o++){const r=e.get(t,o);if(r<0)throw new Error("Input x must be non-negative!");r>=a||(s?i.set(1,t,r):n.size>0?i.set(i.get(t,r)+n.get(t,o),t,r):i.set(i.get(t,r)+1,t,r))}return i}function v(e){return(n,a,s)=>{const o=t.util.getTypedArrayFromDType(a,n.length);for(let t=0;t<n.length;++t)o[t]=e(n[t],s);return o}}function M(e,n,s){return({inputs:o,attrs:r,backend:i})=>{const{x:l}=o;if(a(l,e),"string"===l.dtype||"string"===s)throw new Error("unaryKernelFunc does not support string input/output");const d=i,u=d.data.get(l.dataId).values,c=t.util.sizeFromShape(l.shape),p=s||l.dtype,h=t.util.getArrayFromDType(p,c);for(let e=0;e<c;++e)h[e]=n(u[e],r);return d.makeTensorInfo(l.shape,p,h)}}function A(e,t,n){return({inputs:s,attrs:o,backend:r})=>{const{x:i}=s;if(a(i,e),"string"===i.dtype||"string"===n)throw new Error("unaryKernelFunc does not support string input/output");const l=r,d=l.data.get(i.dataId).values,u=n||i.dtype,c=t(d,u,o);return l.makeTensorInfo(i.shape,u,c)}}const D=v(e=>Math.ceil(e)),w=A(t.Ceil,D),_={kernelName:t.Ceil,backendName:"cpu",kernelFunc:w};function z(e,n,a,s){const o=t.util.getArrayFromDType(a,t.util.sizeFromShape(n));if(s&&"string"!==a){let n=0;e.forEach(e=>{const a=t.util.sizeFromShape(e.shape);o.set(e.vals,n),n+=a})}else{let s=0;e.forEach(e=>{const r="string"===a?t.backend_util.fromUint8ToStringArray(e.vals):e.vals;let i=0;for(let t=0;t<e.shape[0];++t){const a=t*n[1]+s;for(let t=0;t<e.shape[1];++t)o[a+t]=r[i++]}s+=e.shape[1]})}return o}const E=v(e=>Math.exp(e)),C=A(t.Exp,E),W={kernelName:t.Exp,backendName:"cpu",kernelFunc:C},H=v(e=>Math.expm1(e)),R=A(t.Expm1,H),P={kernelName:t.Expm1,backendName:"cpu",kernelFunc:R},B=v(e=>Math.floor(e)),$=A(t.Floor,B),V={kernelName:t.Floor,backendName:"cpu",kernelFunc:$};function L(e,n,a){const s=t.buffer(a,e.dtype);for(let t=0;t<s.size;++t){const a=s.indexToLoc(t).slice(),o=a[0],r=a[2],i=n.locToIndex([o,r]);a[2]=n.values[i];const l=e.locToIndex(a);s.values[t]=e.values[l]}return s}const O=l((e,t)=>e>t?1:0),q=g(t.Greater,O,null,"bool"),G={kernelName:t.Greater,backendName:"cpu",kernelFunc:q},U=l((e,t)=>e<t?1:0),Z=g(t.Less,U,null,"bool"),j={kernelName:t.Less,backendName:"cpu",kernelFunc:Z};function K(e,n,a){const s=(n-e)/(a-1),o=t.util.makeZerosTypedArray(a,"float32");o[0]=e;for(let e=1;e<o.length;e++)o[e]=o[e-1]+s;return o}const Y=v(e=>Math.log(e)),J=A(t.Log,Y),Q={kernelName:t.Log,backendName:"cpu",kernelFunc:J};function X(e,n,a,s){const o=t.util.getTypedArrayFromDType(s,t.util.sizeFromShape(a));for(let t=0;t<o.length;++t){const a=t*n;let s=e[a];for(let t=0;t<n;++t){const n=e[a+t];n>s&&(s=n)}o[t]=s}return o}const ee=l((e,t)=>Math.max(e,t)),te=g(t.Maximum,ee),ne={kernelName:t.Maximum,backendName:"cpu",kernelFunc:te},ae=l((e,t)=>Math.min(e,t)),se=g(t.Minimum,ae),oe={kernelName:t.Minimum,backendName:"cpu",kernelFunc:se},re=l((e,t)=>e*t),ie=I((e,t,n,a)=>({real:e*n-t*a,imag:e*a+t*n})),le=g(t.Multiply,re,ie),de={kernelName:t.Multiply,backendName:"cpu",kernelFunc:le};function ue(e,n,a){const s=t.util.createScalarValue(-1,a);return re([],n,s,e,a)}const ce={kernelName:t.Neg,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{x:s}=t;a(s,"neg");const o=n.data.get(s.dataId).values,[r,i]=ue(o,s.shape,s.dtype);return n.makeTensorInfo(i,s.dtype,r)}},pe=l((e,t)=>e!==t?1:0),he=g(t.NotEqual,pe,null,"bool"),fe={kernelName:t.NotEqual,backendName:"cpu",kernelFunc:he};function me(e,n,a,s,o){const r=n.length,i=t.util.sizeFromShape(n),l=t.util.computeStrides(n),d=t.util.computeStrides(o),u=t.util.getTypedArrayFromDType(a,t.util.sizeFromShape(o));for(let n=0;n<i;++n){const a=t.util.indexToLoc(n,r,l),o=new Array(a.length);for(let e=0;e<o.length;e++)o[e]=a[s[e]];u[t.util.locToIndex(o,r,d)]=e[n]}return u}function ke(e){const{inputs:t,attrs:n,backend:s}=e,{x:o}=t,{perm:r}=n;a(o,"transpose");const i=o.shape.length,l=new Array(i);for(let e=0;e<l.length;e++)l[e]=o.shape[r[e]];const d=me(s.data.get(o.dataId).values,o.shape,o.dtype,r,l);return{dataId:s.write(d,l,o.dtype),shape:l,dtype:o.dtype}}const be={kernelName:t.Transpose,backendName:"cpu",kernelFunc:ke};function ge(e,n,a,s){const[o,r]=t.backend_util.computeOutAndReduceShapes(e,s),i=t.upcastType(n,"int32"),l=t.util.makeZerosTypedArray(t.util.sizeFromShape(o),i),d=t.util.sizeFromShape(r);for(let e=0;e<l.length;++e){const t=e*d;let n=1;for(let e=0;e<d;++e)n*=a[t+e];l[e]=n}return{outVals:l,outShape:o,outDtype:i}}const Ie={kernelName:t.Prod,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r}=n,{axis:i,keepDims:l}=o;a(r,"prod");const d=r.shape.length,u=t.util.parseAxisParam(i,r.shape),c=t.backend_util.getAxesPermutation(u,d);let p=u,h=r;const f=[];null!=c&&(h=ke({inputs:{x:r},backend:s,attrs:{perm:c}}),f.push(h),p=t.backend_util.getInnerMostAxes(p.length,d));const m=s.data.get(h.dataId).values,{outVals:k,outShape:b,outDtype:g}=ge(h.shape,h.dtype,m,p);let I=b;return l&&(I=t.backend_util.expandShapeToKeepDim(b,u)),f.forEach(e=>s.disposeIntermediateTensorInfo(e)),s.makeTensorInfo(I,g,k)}};function ye(e,n,a,s){if(e===n||e<n&&a<0||n<e&&a>1)return t.util.makeZerosTypedArray(0,s);const o=Math.abs(Math.ceil((n-e)/a)),r=t.util.makeZerosTypedArray(o,s);n<e&&1===a&&(a=-1),r[0]=e;for(let e=1;e<r.length;e++)r[e]=r[e-1]+a;return r}const Ne=v(e=>1/Math.sqrt(e)),xe=A(t.Rsqrt,Ne),Te={kernelName:t.Rsqrt,backendName:"cpu",kernelFunc:xe};function Se(e,n,a,s,o){const r=t.slice_util.isSliceContinous(s,n,a),i=t.util.sizeFromShape(a),l=t.util.computeStrides(s);if(r){const a=t.slice_util.computeFlatOffset(n,l);return"string"===o?e.slice(a,a+i):e.subarray(a,a+i)}const d="string"===o?t.backend_util.fromUint8ToStringArray(e):e,u=t.buffer(s,o,d),c=t.buffer(a,o);for(let e=0;e<c.size;++e){const t=c.indexToLoc(e),a=t.map((e,t)=>e+n[t]);c.set(u.get(...a),...t)}return"string"===o?t.backend_util.fromStringArrayToUint8(c.values):c.values}function Fe(e){const{inputs:n,backend:s,attrs:o}=e,{x:r}=n,{begin:i,size:l}=o;a(r,"slice");const[d,u]=t.slice_util.parseSliceParams(r,i,l);t.slice_util.assertParamsValid(r,d,u);const c=Se(s.data.get(r.dataId).values,d,u,r.shape,r.dtype);return s.makeTensorInfo(u,r.dtype,c)}const ve={kernelName:t.Slice,backendName:"cpu",kernelFunc:Fe};function Me(e,n,a,s,o,r,i){const l=n[0],d=r[0],u=new Array(d),c=new Array(l),p=n[1];if(0===d){if(0!==l)throw new Error("Received SparseTensor with denseShape[0] = 0 but\n         indices.shape[0] = "+l);return[t.util.getArrayFromDType(a,0),[0,p],t.util.getArrayFromDType(o,0),u,c]}let h=!0,f=0;const m=new Array(d).fill(0);for(let t=0;t<l;++t){const n=e[t*p];if(n<0)throw new Error(`indices(${t}, 0) is invalid: ${n} < 0`);if(n>=d)throw new Error(`indices(${t}, 0) is invalid: ${n} >= ${d}`);++m[n],h=h&&n>=f,f=n}let k=!0;for(let e=0;e<d;++e){const t=0===m[e];u[e]=t,k=k&&!t,m[e]=Math.max(m[e],1),e>0&&(m[e]+=m[e-1])}if(k&&h){const t=e,n=s;for(let e=0;e<l;++e)c[e]=e;return[t,[l,p],n,u,c]}{const n=m[d-1],r=t.util.getArrayFromDType(a,n*p),h=t.util.getArrayFromDType(o,n),f=new Array(d).fill(0);for(let t=0;t<l;++t){const n=e[t*p],a=f[n],o=(0===n?0:m[n-1])+a;f[n]++;for(let n=0;n<p;++n)r[o*p+n]=e[t*p+n];h[o]=s[t],c[t]=o}for(let e=0;e<d;++e){if(0===f[e]){const t=0===e?0:m[e-1];r[t*p+0]=e;for(let e=1;e<p;++e)r[t*p+e]=0;h[t]=i}}return[r,[l,p],h,u,c]}}function Ae(e,n,a,s,o){const r=t.util.sizeFromShape(s),i=n[0],l=o.length,d=[];let u=1,c=-1;for(let e=0;e<l;++e){const t=o[e];if(-1===t){if(-1!==c)throw new Error(`only one output dimension may be -1, not both ${c} and ${e}`);c=e,d.push(1)}else{if(t<0)throw new Error(`size ${e} must be non-negative, not ${t}`);u*=t,d.push(t)}}if(-1!==c){if(u<=0)throw new Error("reshape cannot infer the missing input size for an empty tensor unless all specified input sizes are non-zero");const e=Math.trunc(r/u);if(u*e!==r)throw new Error(`Input to reshape is a SparseTensor with ${r}\n          dense values, but the requested shape requires a multiple of ${u}. inputShape=${s} outputShape= ${d}`);d[c]=e}const p=t.util.sizeFromShape(d);if(p!==r)throw new Error(`Input to reshape is a tensor with ${r} dense values, but the requested shape has ${p}. inputShape=${s} outputShape=${d}`);const h=s.length,f=[];if(h>0){f[h-1]=1;for(let e=h-2;e>=0;--e)f[e]=f[e+1]*s[e+1]}const m=[];if(l>0){m[l-1]=1;for(let e=l-2;e>=0;--e)m[e]=m[e+1]*d[e+1]}const k=t.util.getArrayFromDType(a,i*l);for(let t=0;t<i;++t){let n=0;for(let a=0;a<h;++a)n+=e[t*h+a]*f[a];for(let e=0;e<l;++e)k[t*l+e]=Math.trunc(n/m[e]),n%=m[e]}return[k,[i,l],d]}const De=l((e,t)=>{const n=e-t;return n*n}),we=g(t.SquaredDifference,De),_e={kernelName:t.SquaredDifference,backendName:"cpu",kernelFunc:we};function ze(e,n,a,s){const o=t.buffer(e,n.dtype);for(let e=0;e<o.size;e++){const t=o.indexToLoc(e),r=new Array(t.length);for(let e=0;e<r.length;e++)r[e]=t[e]*a[e]+s[e];o.set(n.get(...r),...t)}return o}const Ee=l((e,t)=>e-t),Ce=I((e,t,n,a)=>({real:e-n,imag:t-a})),We=g(t.Sub,Ee,Ce),He={kernelName:t.Sub,backendName:"cpu",kernelFunc:We};function Re(e,n){const a=new Array(e.rank);for(let t=0;t<a.length;t++)a[t]=e.shape[t]*n[t];const s=t.buffer(a,e.dtype);for(let t=0;t<s.values.length;++t){const n=s.indexToLoc(t),a=new Array(e.rank);for(let t=0;t<a.length;t++)a[t]=n[t]%e.shape[t];const o=e.locToIndex(a);s.values[t]=e.values[o]}return s}function Pe(e,n,a,s,o){const r=n[n.length-1],[i,l]=[e.length/r,r],d=t.util.getTypedArrayFromDType(a,i*s),u=t.util.getTypedArrayFromDType("int32",i*s);for(let t=0;t<i;t++){const n=t*l,a=e.subarray(n,n+l),o=[];for(let e=0;e<a.length;e++)o.push({value:a[e],index:e});o.sort((e,t)=>t.value-e.value);const r=t*s,i=d.subarray(r,r+s),c=u.subarray(r,r+s);for(let e=0;e<s;e++)i[e]=o[e].value,c[e]=o[e].index}const c=n.slice();return c[c.length-1]=s,[t.buffer(c,a,d),t.buffer(c,"int32",u)]}function Be(e,n,a,s){const o=t.util.parseAxisParam(n,a)[0],r=[1,a[0],1];for(let e=0;e<o;e++)r[0]*=a[e];r[1]=a[o];for(let e=o+1;e<a.length;e++)r[2]*=a[e];const i={},l=new Int32Array(a[o]),d=new t.TensorBuffer(r,s,e),u=[],c=1===r[0]&&1===r[2];for(let t=0;t<a[o];t++){let n;if(c)n=e[t].toString();else{const e=[];for(let n=0;n<r[0];n++)for(let a=0;a<r[2];a++)e.push(d.get(n,t,a));n=e.join(",")}if(void 0!==i[n])l[t]=i[n];else{const e=Object.keys(i).length;i[n]=e,l[t]=e,u.push(t)}}const p=r.slice();p[1]=Object.keys(i).length;const h=new t.TensorBuffer(p,s);u.forEach((e,t)=>{for(let n=0;n<r[0];n++)for(let a=0;a<r[2];a++)h.set(d.get(n,e,a),n,t,a)});const f=a.slice();return f[o]=p[1],{outputValues:h.values,outputShape:f,indices:l}}var $e=Object.freeze({__proto__:null,simpleAbsImpl:r,addImpl:y,bincountImpl:S,bincountReduceImpl:F,ceilImpl:D,concatImpl:z,expImpl:E,expm1Impl:H,floorImpl:B,gatherV2Impl:L,greaterImpl:O,lessImpl:U,linSpaceImpl:K,logImpl:Y,maxImpl:X,maximumImpl:ee,minimumImpl:ae,multiplyImpl:re,negImpl:ue,notEqualImpl:pe,prodImpl:ge,rangeImpl:ye,rsqrtImpl:Ne,sliceImpl:Se,sparseFillEmptyRowsImpl:Me,sparseReshapeImpl:Ae,squaredDifferenceImpl:De,stridedSliceImpl:ze,subImpl:Ee,tileImpl:Re,topKImpl:Pe,transposeImpl:me,uniqueImpl:Be});t.registerBackend("cpu",()=>new o,1);const Ve=M(t.Elu,e=>e>=0?e:Math.exp(e)-1),Le={kernelName:t.Elu,backendName:"cpu",kernelFunc:Ve};function Oe(e){const{inputs:n,backend:s,attrs:o}=e,{x:r}=n,{alpha:i}=o;a([r],"leakyRelu");const l=t.util.sizeFromShape(r.shape),d=s.data.get(r.dataId).values,u=t.util.getTypedArrayFromDType("float32",l);for(let e=0;e<d.length;e++)u[e]=d[e]<0?i*d[e]:d[e];return s.makeTensorInfo(r.shape,"float32",u)}const qe={kernelName:t.LeakyRelu,backendName:"cpu",kernelFunc:Oe},Ge=l((e,t)=>e<0?t*e:e);function Ue(e){const{inputs:t,backend:n}=e,{x:s,alpha:o}=t;a([s,o],"prelu");const r=n.data.get(s.dataId).values,i=n.data.get(o.dataId).values,[l,d]=Ge(s.shape,o.shape,r,i,s.dtype);return n.makeTensorInfo(d,s.dtype,l)}const Ze={kernelName:t.Prelu,backendName:"cpu",kernelFunc:Ue},je=M(t.Relu,e=>Math.max(0,e)),Ke={kernelName:t.Relu,backendName:"cpu",kernelFunc:je},Ye=M(t.Relu6,e=>Math.min(Math.max(0,e),6)),Je={kernelName:t.Relu6,backendName:"cpu",kernelFunc:Ye},Qe=M(t.Sigmoid,e=>1/(1+Math.exp(-e))),Xe={kernelName:t.Sigmoid,backendName:"cpu",kernelFunc:Qe};function et(e,t,n,a,s){if("linear"===n)return p({inputs:{x:t},backend:e});if("relu"===n)return je({inputs:{x:t},backend:e});if("elu"===n)return Ve({inputs:{x:t},backend:e});if("relu6"===n)return Ye({inputs:{x:t},backend:e});if("prelu"===n)return Ue({inputs:{x:t,alpha:a},backend:e});if("leakyrelu"===n)return Oe({inputs:{x:t},backend:e,attrs:{alpha:s}});if("sigmoid"===n)return Qe({inputs:{x:t},backend:e});throw new Error(`Activation ${n} has not been implemented for the CPU backend.`)}function tt(e){const{inputs:n,backend:a,attrs:s}=e,{x:o}=n,{shape:r}=s,i=t.util.sizeFromShape(o.shape),l=t.util.inferFromImplicitShape(r,i),d=t.util.sizeFromShape(l);t.util.assert(i===d,()=>`The new shape (${l}) has ${d} elements and the old shape (${o.shape}) has ${i} elements. The new shape and old shape must have the same number of elements.`),a.incRef(o.dataId);const u=a.data.get(o.dataId);if(null!=u.complexTensorInfos){const e=u.complexTensorInfos.real,t=u.complexTensorInfos.imag;e.shape=l,t.shape=l}return{dataId:o.dataId,shape:l,dtype:o.dtype}}const nt={kernelName:t.Reshape,backendName:"cpu",kernelFunc:tt};function at(e){const{inputs:n,backend:s,attrs:o}=e,{a:r,b:i}=n,{transposeA:l,transposeB:d}=o;a([r,i],"matMul");const u=r.shape.length,c=i.shape.length,p=l?r.shape[u-2]:r.shape[u-1],h=d?i.shape[c-1]:i.shape[c-2],f=l?r.shape[u-1]:r.shape[u-2],m=d?i.shape[c-2]:i.shape[c-1],k=r.shape.slice(0,-2),b=i.shape.slice(0,-2),g=t.util.sizeFromShape(k),I=t.util.sizeFromShape(b),y=g===I||1===g||1===I;t.util.assert(u>=2&&c>=2&&y,()=>`Error in matMul: the input batch dimensions must either be the same or at least one input batch dimension must be 1. Got input batch dimensions of (${k}) and (${b}).`);const N=(g>I?r.shape.slice(0,-2):i.shape.slice(0,-2)).concat([f,m]);t.util.assert(p===h,()=>`Error in matMul: inner shapes (${p}) and (${h}) of Tensors with shapes ${r.shape} and ${i.shape} and transposeA=${l} and transposeB=${d} must match.`);const x=d?[I,m,h]:[I,h,m],T=tt({inputs:{x:r},backend:s,attrs:{shape:l?[g,p,f]:[g,f,p]}}),S=tt({inputs:{x:i},backend:s,attrs:{shape:x}}),F=l?T.shape[1]:T.shape[2],v=l?T.shape[2]:T.shape[1],M=d?S.shape[1]:S.shape[2],A=Math.max(g,I),D=s.data.get(T.dataId).values,w=s.data.get(S.dataId).values,_=t.util.computeStrides(T.shape),z=t.util.computeStrides(S.shape),[E,C,W]=l?[_[0],1,_[1]]:[_[0],_[1],1],[H,R,P]=d?[1,z[1],z[0]]:[z[1],1,z[0]],B=v*M,$=t.buffer([A,v,M],T.dtype),V=$.values,L=s.blockSize;for(let e=0;e<A;e++)for(let t=0;t<v;t+=L)for(let n=0;n<M;n+=L)for(let a=0;a<F;a+=L){const s=Math.min(t+L,v),o=Math.min(n+L,M),r=Math.min(a+L,F);for(let i=t;i<s;i++)for(let t=n;t<o;t++){let n=0;for(let s=a;s<r;s++){const a=Math.min(e,g-1)*E,o=Math.min(e,I-1)*P;n+=D[a+i*C+s*W]*w[s*H+t*R+o]}V[e*B+(i*M+t)]+=n}}return s.disposeIntermediateTensorInfo(T),s.disposeIntermediateTensorInfo(S),s.makeTensorInfo(N,$.dtype,$.values)}const st={kernelName:t.BatchMatMul,backendName:"cpu",kernelFunc:at};const ot={kernelName:t._FusedMatMul,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{a:s,b:o,bias:r,preluActivationWeights:i}=t,{transposeA:l,transposeB:d,activation:u,leakyreluAlpha:c}=a;let p,h,f;const m=[];p=at({inputs:{a:s,b:o},attrs:{transposeA:l,transposeB:d},backend:n}),r&&(h=x({inputs:{a:p,b:r},backend:n}),m.push(p),p=h),u&&(f=et(n,p,u,i,c),m.push(p),p=f);for(const e of m)n.disposeIntermediateTensorInfo(e);return p}},rt=M(t.Acos,e=>Math.acos(e)),it={kernelName:t.Acos,backendName:"cpu",kernelFunc:rt},lt=M(t.Acosh,e=>Math.acosh(e)),dt={kernelName:t.Acosh,backendName:"cpu",kernelFunc:lt};const ut={kernelName:t.AddN,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s}=e,o=n;a(n,"addN");const r=o.map(e=>s.data.get(e.dataId).values),i=t.buffer(o[0].shape,o[0].dtype),l=i.values;for(let e=0;e<o.length;e++){const t=r[e];for(let e=0;e<l.length;e++)l[e]+=t[e]}return s.makeTensorInfo(i.shape,i.dtype,i.values)}};const ct={kernelName:t.All,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r}=n,{axis:i,keepDims:l}=o;a(r,"all");const d=t.util.parseAxisParam(i,r.shape);let u=d;const c=t.backend_util.getAxesPermutation(u,r.shape.length);let p=r;null!=c&&(p=ke({inputs:{x:r},backend:s,attrs:{perm:c}}),u=t.backend_util.getInnerMostAxes(u.length,r.shape.length)),t.backend_util.assertAxesAreInnerMostDims("all",u,p.shape.length);const[h,f]=t.backend_util.computeOutAndReduceShapes(p.shape,u),m=t.util.sizeFromShape(f),k=t.util.makeZerosTypedArray(t.util.sizeFromShape(h),p.dtype),b=s.data.get(p.dataId).values;for(let e=0;e<k.length;++e){const t=e*m;let n=b[t];for(let e=0;e<m;++e){const a=b[t+e];n=n&&a}k[e]=n}null!=c&&s.disposeIntermediateTensorInfo(p);const g=s.makeTensorInfo(h,p.dtype,k);if(l){const e=tt({inputs:{x:g},backend:s,attrs:{shape:t.backend_util.expandShapeToKeepDim(h,d)}});return s.disposeIntermediateTensorInfo(g),e}return g}};const pt={kernelName:t.Any,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r}=n,{axis:i,keepDims:l}=o;a(r,"any");const d=t.util.parseAxisParam(i,r.shape);let u=d;const c=t.backend_util.getAxesPermutation(u,r.shape.length);let p=r;null!=c&&(p=ke({inputs:{x:r},backend:s,attrs:{perm:c}}),u=t.backend_util.getInnerMostAxes(u.length,r.shape.length)),t.backend_util.assertAxesAreInnerMostDims("any",u,p.shape.length);const[h,f]=t.backend_util.computeOutAndReduceShapes(p.shape,u),m=t.util.sizeFromShape(f),k=t.util.makeZerosTypedArray(t.util.sizeFromShape(h),p.dtype),b=s.data.get(p.dataId).values;for(let e=0;e<k.length;++e){const t=e*m;let n=b[t];for(let e=0;e<m;++e){const a=b[t+e];n=n||a}k[e]=n}null!=c&&s.disposeIntermediateTensorInfo(p);const g=s.makeTensorInfo(h,p.dtype,k);if(l){const e=tt({inputs:{x:g},backend:s,attrs:{shape:t.backend_util.expandShapeToKeepDim(h,d)}});return s.disposeIntermediateTensorInfo(g),e}return g}};const ht={kernelName:t.ArgMax,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r}=n,{axis:i}=o;a(r,"argMax");let l=t.util.parseAxisParam(i,r.shape);const d=t.backend_util.getAxesPermutation(l,r.shape.length);let u=r;const c=[];null!=d&&(u=ke({inputs:{x:r},backend:s,attrs:{perm:d}}),c.push(u),l=t.backend_util.getInnerMostAxes(l.length,u.shape.length)),l=[l[0]],t.backend_util.assertAxesAreInnerMostDims("argMax",l,u.shape.length);const[p,h]=t.backend_util.computeOutAndReduceShapes(u.shape,l),f=t.util.sizeFromShape(p),m=t.util.makeZerosTypedArray(f,"int32"),k=t.util.sizeFromShape(h),b=s.data.get(u.dataId).values;for(let e=0;e<m.length;++e){const t=e*k;let n=b[t],a=0;for(let e=0;e<k;++e){const s=b[t+e];s>n&&(n=s,a=e)}m[e]=a}return c.forEach(e=>s.disposeIntermediateTensorInfo(e)),s.makeTensorInfo(p,"int32",m)}};const ft={kernelName:t.ArgMin,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r}=n,{axis:i}=o;a(r,"argMin");let l=t.util.parseAxisParam(i,r.shape);const d=t.backend_util.getAxesPermutation(l,r.shape.length);let u=r;const c=[];null!=d&&(u=ke({inputs:{x:r},backend:s,attrs:{perm:d}}),c.push(u),l=t.backend_util.getInnerMostAxes(l.length,u.shape.length)),l=[l[0]],t.backend_util.assertAxesAreInnerMostDims("argMin",l,u.shape.length);const[p,h]=t.backend_util.computeOutAndReduceShapes(u.shape,l),f=t.util.sizeFromShape(p),m=t.util.makeZerosTypedArray(f,"int32"),k=t.util.sizeFromShape(h),b=s.data.get(u.dataId).values;for(let e=0;e<m.length;++e){const t=e*k;let n=b[t],a=0;for(let e=0;e<k;++e){const s=b[t+e];s<n&&(n=s,a=e)}m[e]=a}return c.forEach(e=>s.disposeIntermediateTensorInfo(e)),s.makeTensorInfo(p,"int32",m)}},mt=M(t.Asin,e=>Math.asin(e)),kt={kernelName:t.Asin,backendName:"cpu",kernelFunc:mt},bt=M(t.Asinh,e=>Math.asinh(e)),gt={kernelName:t.Asinh,backendName:"cpu",kernelFunc:bt},It=M(t.Atan,e=>Math.atan(e)),yt={kernelName:t.Atan,backendName:"cpu",kernelFunc:It},Nt=l((e,t)=>Math.atan2(e,t)),xt=g(t.Atan2,Nt),Tt={kernelName:t.Atan2,backendName:"cpu",kernelFunc:xt},St=M(t.Atanh,e=>Math.atanh(e)),Ft={kernelName:t.Atanh,backendName:"cpu",kernelFunc:St};function vt(e,n,a,s,o,r){const i=o.strideHeight,l=o.strideWidth,d=o.dilationHeight,u=o.dilationWidth,c=o.effectiveFilterHeight,p=o.effectiveFilterWidth,h=o.padInfo.top,f=o.padInfo.left,m="max"===r?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY,k=t.buffer(o.outShape,a),b=k.values,g=o.outShape[1]*o.outShape[2]*o.outShape[3],I=o.outShape[2]*o.outShape[3],y=o.outShape[3];for(let t=0;t<o.batchSize;++t){const n=t*g,a=t*s[0];for(let t=0;t<o.inChannels;++t)for(let k=0;k<o.outHeight;++k){const g=k*i-h,N=Math.max(0,g),x=Math.min(o.inHeight,c+g),T=n+k*I;for(let n=0;n<o.outWidth;++n){const i=n*l-f,c=Math.max(0,i),h=Math.min(o.inWidth,p+i);let k=m,g=0,I=0;for(let n=N;n<x;n+=d){const o=a+n*s[1];for(let n=c;n<h;n+=u){const a=e[o+n*s[2]+t];"max"===r&&a>k?k=a:"avg"===r&&(g+=a,I++)}if(isNaN(k))break}b[T+n*y+t]="avg"===r?g/I:k}}}return k}function Mt(e,n,a,s,o=!1,r=!1){const i=t.buffer(s.outShape,"int32"),l=s.strideHeight,d=s.strideWidth,u=s.dilationHeight,c=s.dilationWidth,p=s.effectiveFilterHeight,h=s.effectiveFilterWidth,f=s.padInfo.top,m=s.padInfo.left,k=t.buffer(n,a,e);for(let e=0;e<s.batchSize;++e)for(let t=0;t<s.inChannels;++t)for(let n=0;n<s.outHeight;++n){const a=n*l-f;let b=a;for(;b<0;)b+=u;const g=Math.min(s.inHeight,p+a);for(let l=0;l<s.outWidth;++l){const p=l*d-m;let f=p;for(;f<0;)f+=c;const I=Math.min(s.inWidth,h+p);let y=Number.NEGATIVE_INFINITY,N=-1;for(let n=b;n<g;n+=u){const i=n-a;for(let a=f;a<I;a+=c){const l=a-p,d=k.get(e,n,a,t);d>y&&(y=d,N=o?r?((e*s.inHeight+n)*s.inWidth+a)*s.inChannels+t:(n*s.inWidth+a)*s.inChannels+t:i*h+l)}}i.set(N,e,n,l,t)}}return i}function At(e,n,a,s,o,r){const i=o.strideDepth,l=o.strideHeight,d=o.strideWidth,u=o.dilationDepth,c=o.dilationHeight,p=o.dilationWidth,h=o.effectiveFilterDepth,f=o.effectiveFilterHeight,m=o.effectiveFilterWidth,k=o.padInfo.front,b=o.padInfo.top,g=o.padInfo.left,I="max"===r?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY,y=t.buffer(o.outShape,a),N=y.values,x=o.outShape[1]*o.outShape[2]*o.outShape[3]*o.outShape[4],T=o.outShape[2]*o.outShape[3]*o.outShape[4],S=o.outShape[3]*o.outShape[4],F=o.outShape[4];for(let t=0;t<o.batchSize;++t){const n=t*x,a=t*s[0];for(let t=0;t<o.inChannels;++t)for(let y=0;y<o.outDepth;++y){const x=y*i-k;let v=x;for(;v<0;)v+=u;const M=Math.min(o.inDepth,h+x),A=n+y*T;for(let n=0;n<o.outHeight;++n){const i=n*l-b;let h=i;for(;h<0;)h+=c;const k=Math.min(o.inHeight,f+i),y=A+n*S;for(let n=0;n<o.outWidth;++n){const i=n*d-g;let l=i;for(;l<0;)l+=p;const f=Math.min(o.inWidth,m+i),b=y+n*F;let x=I,T=0,S=0;for(let n=v;n<M;n+=u){const o=a+n*s[1];for(let n=h;n<k;n+=c){const a=o+n*s[2];for(let n=l;n<f;n+=p){const o=e[a+n*s[3]+t];if("max"===r&&o>x?x=o:"avg"===r&&(T+=o,S++),isNaN(x))break}if(isNaN(x))break}if(isNaN(x))break}N[b+t]="avg"===r?T/S:x}}}}return y}const Dt={kernelName:t.AvgPool,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r}=n;a(r,"avgPool");const{filterSize:i,strides:l,pad:d,dimRoundingMode:u}=o;t.util.assert(t.backend_util.eitherStridesOrDilationsAreOne(l,1),()=>`Error in avgPool: Either strides or dilations must be 1. Got strides ${l} and dilations '1'`);const c=t.backend_util.computePool2DInfo(r.shape,i,l,1,d,u);let h;if(1===c.filterWidth&&1===c.filterHeight&&t.util.arraysEqual(c.inShape,c.outShape))h=p({inputs:{x:r},backend:s});else{const e=s.data.get(r.dataId).values,n=t.util.computeStrides(r.shape),a=vt(e,r.shape,r.dtype,n,c,"avg");h=s.makeTensorInfo(c.outShape,r.dtype,a.values)}return h}};const wt={kernelName:t.AvgPool3D,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r}=n,{filterSize:i,strides:l,pad:d,dimRoundingMode:u,dataFormat:c}=o;a(r,"avgPool3d");const p=t.backend_util.computePool3DInfo(r.shape,i,l,1,d,u,c),h=At(s.data.get(r.dataId).values,r.shape,r.dtype,t.util.computeStrides(r.shape),p,"avg");return s.makeTensorInfo(h.shape,"float32",h.values)}};const _t={kernelName:t.AvgPool3DGrad,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{dy:r,input:i}=n,{filterSize:l,strides:d,pad:u,dimRoundingMode:c}=o;a([r,i],"avgPool3DGrad");const p=t.backend_util.computePool3DInfo(i.shape,l,d,1,u,c),h=p.strideDepth,f=p.strideHeight,m=p.strideWidth,k=p.filterDepth,b=p.filterHeight,g=p.filterWidth,I=p.dilationDepth,y=p.dilationHeight,N=p.dilationWidth,x=p.effectiveFilterDepth,T=p.effectiveFilterHeight,S=p.effectiveFilterWidth,F=x-1-p.padInfo.front,v=S-1-p.padInfo.left,M=T-1-p.padInfo.top,A=t.buffer(i.shape,"float32"),D=1/(k*b*g),w=s.bufferSync(r);for(let e=0;e<p.batchSize;++e)for(let t=0;t<p.inChannels;++t)for(let n=0;n<p.inDepth;++n)for(let a=0;a<p.inHeight;++a)for(let s=0;s<p.inWidth;++s){const o=n-F,r=a-M,i=s-v;let l=0;for(let n=0;n<x;n+=I){const a=(o+n)/h;if(!(a<0||a>=p.outDepth||Math.floor(a)!==a))for(let n=0;n<T;n+=y){const s=(r+n)/f;if(!(s<0||s>=p.outHeight||Math.floor(s)!==s))for(let n=0;n<S;n+=N){const o=(i+n)/m;if(o<0||o>=p.outWidth||Math.floor(o)!==o)continue;l+=w.get(e,a,s,o,t)}}}A.set(l*D,e,n,a,s,t)}return s.makeTensorInfo(A.shape,A.dtype,A.values)}};const zt={kernelName:t.AvgPoolGrad,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{dy:r,input:i}=n,l=i;a([r,i],"avgPoolGrad");const{filterSize:d,strides:u,pad:c}=o,p=t.backend_util.computePool2DInfo(l.shape,d,u,1,c),h=p.strideHeight,f=p.strideWidth,m=p.filterHeight,k=p.filterWidth,b=p.dilationHeight,g=p.dilationWidth,I=p.effectiveFilterHeight,y=p.effectiveFilterWidth,N=y-1-p.padInfo.left,x=I-1-p.padInfo.top,T=t.buffer(l.shape,"float32"),S=1/(m*k),F=s.data.get(r.dataId).values,v=t.buffer(r.shape,"float32",F);for(let e=0;e<p.batchSize;++e)for(let t=0;t<p.inChannels;++t)for(let n=0;n<p.inHeight;++n)for(let a=0;a<p.inWidth;++a){const s=n-x,o=a-N;let r=0;for(let n=0;n<I;n+=b){const a=(s+n)/h;if(!(a<0||a>=p.outHeight||Math.floor(a)!==a))for(let n=0;n<y;n+=g){const s=(o+n)/f;if(s<0||s>=p.outWidth||Math.floor(s)!==s)continue;r+=v.get(e,a,s,t)}}T.set(r*S,e,n,a,t)}return s.makeTensorInfo(T.shape,T.dtype,T.values)}};const Et={kernelName:t.FusedBatchNorm,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r,scale:i,offset:l,mean:d,variance:u}=n;t.util.assert(d.shape.length===u.shape.length,()=>"Batch normalization gradient requires mean and variance to have equal ranks."),t.util.assert(null==l||d.shape.length===l.shape.length,()=>"Batch normalization gradient requires mean and offset to have equal ranks."),t.util.assert(null==i||d.shape.length===i.shape.length,()=>"Batch normalization gradient requires mean and scale to have equal ranks."),a([r,d,u,i,l],"batchNorm");let{varianceEpsilon:c}=o;null==c&&(c=.001);const p=s.data.get(r.dataId).values,h=s.data.get(d.dataId).values,f=s.data.get(u.dataId).values,m=i?s.data.get(i.dataId).values:new Float32Array([1]),k=l?s.data.get(l.dataId).values:new Float32Array([0]),b=new Float32Array(p.length),g=k.length,I=m.length,y=f.length,N=h.length;let x=0,T=0,S=0,F=0;for(let e=0;e<p.length;++e)b[e]=k[x++]+(p[e]-h[T++])*m[S++]/Math.sqrt(f[F++]+c),x>=g&&(x=0),T>=N&&(T=0),S>=I&&(S=0),F>=y&&(F=0);return s.makeTensorInfo(r.shape,r.dtype,b)}};const Ct={kernelName:t.BatchToSpaceND,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r}=n,{blockShape:i,crops:l}=o;a([r],"batchToSpaceND");const d=i.reduce((e,t)=>e*t),u=t.backend_util.getReshaped(r.shape,i,d),c=t.backend_util.getPermuted(u.length,i.length),p=t.backend_util.getReshapedPermuted(r.shape,i,d),h=t.backend_util.getSliceBeginCoords(l,i.length),f=t.backend_util.getSliceSize(p,l,i.length),m=tt({inputs:{x:r},backend:s,attrs:{shape:u}}),k=ke({inputs:{x:m},backend:s,attrs:{perm:c}}),b=tt({inputs:{x:k},backend:s,attrs:{shape:p}}),g=Fe({inputs:{x:b},backend:s,attrs:{begin:h,size:f}});return s.disposeIntermediateTensorInfo(m),s.disposeIntermediateTensorInfo(k),s.disposeIntermediateTensorInfo(b),g}};const Wt={kernelName:t.Bincount,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{x:s,weights:o}=t,{size:r}=a,i=S(n.data.get(s.dataId).values,n.data.get(o.dataId).values,o.dtype,o.shape,r);return n.makeTensorInfo([r],o.dtype,i)}},Ht=M(t.ClipByValue,(e,t)=>{const n=t;return e>n.clipValueMax?n.clipValueMax:e<n.clipValueMin?n.clipValueMin:e}),Rt={kernelName:t.ClipByValue,backendName:"cpu",kernelFunc:Ht},Pt={kernelName:t.ComplexAbs,backendName:"cpu",kernelFunc:e=>{const{x:n}=e.inputs,a=e.backend,s=new Float32Array(t.util.sizeFromShape(n.shape)),o=a.data.get(n.dataId),r=o.complexTensorInfos.real,i=o.complexTensorInfos.imag,l=a.data.get(r.dataId).values,d=a.data.get(i.dataId).values;for(let e=0;e<l.length;e++){const t=l[e],n=d[e];s[e]=Math.hypot(t,n)}return a.makeOutput(s,n.shape,"float32")}};function Bt(e){const{inputs:t,backend:n}=e,{input:a}=t,s=n.data.get(a.dataId).complexTensorInfos.imag,o=n.data.get(s.dataId).values;return n.makeTensorInfo(s.shape,s.dtype,o)}const $t={kernelName:t.Imag,backendName:"cpu",kernelFunc:Bt};function Vt(e){const{inputs:n,backend:a,attrs:s}=e,{axis:o}=s,r=t.util.parseAxisParam(o,n[0].shape)[0];let i=t.backend_util.computeOutShape(n.map(e=>e.shape),r);if(0===t.util.sizeFromShape(i))return a.makeTensorInfo(i,n[0].dtype,[]);const l=n.filter(e=>t.util.sizeFromShape(e.shape)>0);if(1===l.length)return p({inputs:{x:l[0]},backend:a});const u=l.map(e=>e.shape);if(t.backend_util.assertParamsConsistent(u,r),"complex64"===l[0].dtype){const e=l.map(e=>f({inputs:{input:e},backend:a})),t=l.map(e=>Bt({inputs:{input:e},backend:a})),n=Vt({inputs:e,backend:a,attrs:{axis:r}}),s=Vt({inputs:t,backend:a,attrs:{axis:r}}),o=d({inputs:{real:n,imag:s},backend:a});return e.forEach(e=>a.disposeIntermediateTensorInfo(e)),t.forEach(e=>a.disposeIntermediateTensorInfo(e)),a.disposeIntermediateTensorInfo(n),a.disposeIntermediateTensorInfo(s),o}const c=l.map(e=>{const n=t.util.sizeFromShape(e.shape.slice(r));return tt({inputs:{x:e},backend:a,attrs:{shape:[-1,n]}})}),h=c.map(e=>({vals:a.data.get(e.dataId).values,shape:e.shape}));i=t.backend_util.computeOutShape(c.map(e=>e.shape),1);const m=1===c[0].shape[0],k=z(h,i,n[0].dtype,m),b=t.backend_util.computeOutShape(l.map(e=>e.shape),r),g=a.makeTensorInfo(b,n[0].dtype,k);return c.forEach(e=>a.disposeIntermediateTensorInfo(e)),g}const Lt={kernelName:t.Concat,backendName:"cpu",kernelFunc:Vt};function Ot(e){const{inputs:n,backend:s,attrs:o}=e,{x:r,filter:i}=n,{strides:l,pad:d,dataFormat:u,dilations:c,dimRoundingMode:p}=o;a([r,i],"conv2d");const h=t.backend_util.convertConv2DDataFormat(u),f=t.backend_util.computeConv2DInfo(r.shape,i.shape,l,c,d,p,!1,h),m=f.filterHeight,k=f.filterWidth,b=f.dilationHeight,g=f.dilationWidth,I=f.padInfo.left,y=f.padInfo.top,N="channelsLast"===f.dataFormat,x=new t.TensorBuffer(f.outShape,r.dtype),T=t.util.computeStrides(r.shape),S=t.util.computeStrides(i.shape),F=T[0],v=N?T[1]:T[2],M=N?T[2]:1,A=N?1:T[1],D=x.strides[0],w=N?x.strides[1]:x.strides[2],_=N?x.strides[2]:1,z=N?1:x.strides[1],E=s.data.get(r.dataId).values,C=s.data.get(i.dataId).values,W=x.values;for(let e=0;e<f.batchSize;++e){const t=e*F,n=e*D;for(let e=0;e<f.outHeight;++e){const a=n+e*w,s=e*f.strideHeight-y;for(let e=0;e<m;++e){const n=s+e*b;if(n<0||n>=f.inHeight)continue;const o=e*S[0],r=t+n*v;for(let e=0;e<f.outWidth;++e){const t=a+e*_,n=e*f.strideWidth-I;for(let e=0;e<k;++e){const a=n+e*g;if(a<0||a>=f.inWidth)continue;const s=r+a*M;let i=o+e*S[1];for(let e=0;e<f.inChannels;++e){const n=E[s+e*A];for(let e=0;e<f.outChannels;++e)W[t+e*z]+=n*C[i+e];i+=f.outChannels}}}}}}return s.makeTensorInfo(x.shape,x.dtype,W)}const qt={kernelName:t.Conv2D,backendName:"cpu",kernelFunc:Ot};const Gt={kernelName:t.Conv2DBackpropFilter,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r,dy:i}=n,{strides:l,pad:d,dataFormat:u,dimRoundingMode:c,filterShape:p}=o;a([r,i],"conv2dBackpropFilter");const h=t.backend_util.convertConv2DDataFormat(u),f=t.backend_util.computeConv2DInfo(r.shape,p,l,1,d,c,!1,h),{strideHeight:m,strideWidth:k,filterHeight:b,filterWidth:g}=f,I="channelsLast"===f.dataFormat,y=new t.TensorBuffer(f.filterShape,"float32"),N=f.padInfo.left,x=f.padInfo.top,T=s.data.get(r.dataId).values,S=s.data.get(i.dataId).values,F=new t.TensorBuffer(r.shape,r.dtype,T),v=new t.TensorBuffer(i.shape,i.dtype,S);for(let e=0;e<b;++e){const t=Math.max(0,Math.ceil((x-e)/m)),n=Math.min(f.outHeight,(f.inHeight+x-e)/m);for(let a=0;a<g;++a){const s=Math.max(0,Math.ceil((N-a)/k)),o=Math.min(f.outWidth,(f.inWidth+N-a)/k);for(let r=0;r<f.inChannels;++r)for(let i=0;i<f.outChannels;++i){let l=0;for(let d=0;d<f.batchSize;++d)for(let u=t;u<n;++u){const t=e+u*m-x;for(let e=s;e<o;++e){const n=a+e*k-N;l+=I?F.get(d,t,n,r)*v.get(d,u,e,i):F.get(d,r,t,n)*v.get(d,i,u,e)}}y.set(l,e,a,r,i)}}}return s.makeTensorInfo(y.shape,y.dtype,y.values)}};const Ut={kernelName:t.Conv2DBackpropInput,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{dy:r,filter:i}=n,{inputShape:l,strides:d,pad:u,dataFormat:c,dimRoundingMode:p}=o;a([r,i],"conv2dBackpropInput");const h=t.util.computeStrides(i.shape),f=t.util.computeStrides(r.shape);let m=t.backend_util.convertConv2DDataFormat(c);const k=t.backend_util.computeConv2DInfo(l,i.shape,d,1,u,p,!1,m),b=new t.TensorBuffer(k.inShape,"float32"),g=b.values,I=s.data.get(r.dataId).values,y=s.data.get(i.dataId).values,[N,x,T]=h,{batchSize:S,filterHeight:F,filterWidth:v,inChannels:M,inHeight:A,inWidth:D,outChannels:w,outHeight:_,outWidth:z,strideHeight:E,strideWidth:C}=k;m=k.dataFormat;const W=F-1-k.padInfo.top,H=v-1-k.padInfo.left,R="channelsLast"===m,P=b.strides[0],B=R?b.strides[1]:b.strides[2],$=R?b.strides[2]:1,V=R?1:b.strides[1],L=f[0],O=R?f[1]:f[2],q=R?f[2]:1,G=R?1:f[1];for(let e=0;e<S;++e)for(let t=0;t<M;++t)for(let n=0;n<A;++n){const a=n-W,s=Math.max(0,Math.ceil(a/E)),o=Math.min(_,(F+a)/E);for(let r=0;r<D;++r){const i=r-H,l=Math.max(0,Math.ceil(i/C)),d=Math.min(z,(v+i)/C);let u=0;for(let n=s;n<o;++n){const s=n*E-a;for(let a=l;a<d;++a){const o=L*e+O*n+q*a,r=N*(F-1-s)+x*(v-1-(a*C-i))+T*t;for(let e=0;e<w;++e){u+=I[o+G*e]*y[r+e]}}}g[P*e+B*n+$*r+V*t]=u}}return s.makeTensorInfo(b.shape,b.dtype,b.values)}};const Zt={kernelName:t.Conv3D,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r,filter:i}=n,{strides:l,pad:d,dilations:u}=o;a([r,i],"conv3d");const c=t.backend_util.computeConv3DInfo(r.shape,i.shape,l,u,d),{filterDepth:p,filterHeight:h,filterWidth:f,dilationDepth:m,dilationHeight:k,dilationWidth:b,padInfo:g}=c,I=g.front,y=g.left,N=g.top,x=new t.TensorBuffer(c.outShape,r.dtype),T=s.data.get(r.dataId).values,S=s.data.get(i.dataId).values,F=x.values,v=t.util.computeStrides(r.shape),M=t.util.computeStrides(i.shape);for(let e=0;e<c.batchSize;++e){const t=e*v[0],n=e*x.strides[0];for(let e=0;e<c.outDepth;++e){const a=n+e*x.strides[1],s=e*c.strideDepth-I;for(let e=0;e<p;++e){const n=s+e*m;if(n<0||n>=c.inDepth)continue;const o=e*M[0],r=t+n*v[1];for(let e=0;e<c.outHeight;++e){const t=a+e*x.strides[2],n=e*c.strideHeight-N;for(let e=0;e<h;++e){const a=n+e*k;if(a<0||a>=c.inHeight)continue;const s=o+e*M[1],i=r+a*v[2];for(let e=0;e<c.outWidth;++e){const n=t+e*c.outChannels,a=e*c.strideWidth-y;for(let e=0;e<f;++e){const t=a+e*b;if(t<0||t>=c.inWidth)continue;const o=s+e*M[2],r=i+t*c.inChannels;let l=o;for(let e=0;e<c.inChannels;++e){const t=T[r+e];for(let e=0;e<c.outChannels;++e)F[n+e]+=t*S[l+e];l+=c.outChannels}}}}}}}}return s.makeTensorInfo(x.shape,x.dtype,x.values)}};const jt={kernelName:t.Conv3DBackpropFilterV2,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r,dy:i}=n,{strides:l,pad:d,filterShape:u}=o;a([r,i],"conv3dBackpropFilterV2");const c=t.util.computeStrides(r.shape),p=t.util.computeStrides(i.shape),h=t.backend_util.computeConv3DInfo(r.shape,u,l,1,d),f=h.strideDepth,m=h.strideHeight,k=h.strideWidth,b=h.filterDepth,g=h.filterHeight,I=h.filterWidth,y=new t.TensorBuffer(h.filterShape,"float32"),N=y.values,[x,T,S,F]=y.strides,v=s.data.get(i.dataId).values,[M,A,D,w]=p,_=s.data.get(r.dataId).values,[z,E,C,W]=c,H=h.padInfo.front,R=h.padInfo.left,P=h.padInfo.top;for(let e=0;e<b;++e){const t=Math.max(0,Math.ceil((H-e)/f)),n=Math.min(h.outDepth,(h.inDepth+H-e)/f),a=e*x;for(let s=0;s<g;++s){const o=Math.max(0,Math.ceil((P-s)/m)),r=Math.min(h.outHeight,(h.inHeight+P-s)/m),i=s*T+a;for(let a=0;a<I;++a){const l=Math.max(0,Math.ceil((R-a)/k)),d=Math.min(h.outWidth,(h.inWidth+R-a)/k),u=a*S+i;for(let i=0;i<h.inChannels;++i){const c=i*F+u;for(let u=0;u<h.outChannels;++u){let p=0;for(let c=0;c<h.batchSize;++c){const h=c*z,b=c*M;for(let c=t;c<n;++c){const t=(e+c*f-H)*E+h,n=c*A+b;for(let e=o;e<r;++e){const o=(s+e*m-P)*C+t,r=e*D+n;for(let e=l;e<d;++e){const t=e*w+r;p+=_[(a+e*k-R)*W+o+i]*v[t+u]}}}}N[c+u]=p}}}}}return s.makeTensorInfo(y.shape,y.dtype,y.values)}};const Kt={kernelName:t.Conv3DBackpropInputV2,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{dy:r,filter:i}=n,{pad:l,strides:d,inputShape:u}=o;a([r],"conv3dBackpropInputV2");const c=t.util.computeStrides(r.shape),p=t.util.computeStrides(i.shape),h=t.backend_util.computeConv3DInfo(u,i.shape,d,1,l),f=new t.TensorBuffer(h.inShape,"float32"),m=f.values,[k,b,g,I]=f.strides,y=s.data.get(r.dataId).values,[N,x,T,S]=c,F=s.data.get(i.dataId).values,[v,M,A,D]=p,{batchSize:w,filterDepth:_,filterHeight:z,filterWidth:E,inChannels:C,inDepth:W,inHeight:H,inWidth:R,outChannels:P,outDepth:B,outHeight:$,outWidth:V,strideDepth:L,strideHeight:O,strideWidth:q}=h,G=_-1-h.padInfo.front,U=z-1-h.padInfo.top,Z=E-1-h.padInfo.left;for(let e=0;e<w;++e)for(let t=0;t<C;++t)for(let n=0;n<W;++n){const a=n-G,s=Math.max(0,Math.ceil(a/L)),o=Math.min(B,(_+a)/L);for(let r=0;r<H;++r){const i=r-U,l=Math.max(0,Math.ceil(i/O)),d=Math.min($,(z+i)/O);for(let u=0;u<R;++u){const c=u-Z,p=Math.max(0,Math.ceil(c/q)),h=Math.min(V,(E+c)/q);let f=0;for(let n=s;n<o;++n){const s=n*L-a;for(let a=l;a<d;++a){const o=a*O-i;for(let r=p;r<h;++r){const i=N*e+x*n+T*a+S*r,l=v*(_-1-s)+M*(z-1-o)+A*(E-1-(r*q-c))+D*t;for(let e=0;e<P;++e){f+=y[i+e]*F[l+e]}}}}m[k*e+b*n+g*r+I*u+t]=f}}}return s.makeTensorInfo(f.shape,f.dtype,f.values)}},Yt=M(t.Cos,e=>Math.cos(e)),Jt={kernelName:t.Cos,backendName:"cpu",kernelFunc:Yt},Qt=M(t.Cosh,e=>Math.cosh(e)),Xt={kernelName:t.Cosh,backendName:"cpu",kernelFunc:Qt};const en={kernelName:t.CropAndResize,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{image:o,boxes:r,boxInd:i}=n,{cropSize:l,method:d,extrapolationValue:u}=s,[c,p,h,f]=o.shape,m=r.shape[0],[k,b]=l,g=t.buffer([m,k,b,f],"float32"),I=a.data.get(r.dataId).values,y=a.data.get(i.dataId).values,N=a.data.get(o.dataId).values,x=t.util.computeStrides(o.shape),T=t.util.computeStrides(g.shape);for(let e=0;e<m;e++){const t=4*e,n=I[t],a=I[t+1],s=I[t+2],o=I[t+3],r=y[e];if(r>=c)continue;const i=k>1?(s-n)*(p-1)/(k-1):0,l=b>1?(o-a)*(h-1)/(b-1):0;for(let t=0;t<k;t++){const c=k>1?n*(p-1)+t*i:.5*(n+s)*(p-1);if(c<0||c>p-1)for(let n=0;n<b;n++)for(let a=0;a<f;a++){const s=a+n*T[2]+t*T[1]+e*T[0];g.values[s]=u}else if("bilinear"===d){const n=Math.floor(c),s=Math.ceil(c),i=c-n;for(let d=0;d<b;d++){const c=b>1?a*(h-1)+d*l:.5*(a+o)*(h-1);if(c<0||c>h-1){for(let n=0;n<f;n++){const a=n+d*T[2]+t*T[1]+e*T[0];g.values[a]=u}continue}const p=Math.floor(c),m=Math.ceil(c),k=c-p;for(let a=0;a<f;a++){let o=a+p*x[2]+n*x[1]+r*x[0];const l=N[o];o=a+m*x[2]+n*x[1]+r*x[0];const u=N[o];o=a+p*x[2]+s*x[1]+r*x[0];const c=N[o];o=a+m*x[2]+s*x[1]+r*x[0];const h=l+(u-l)*k,f=c+(N[o]-c)*k;o=a+d*T[2]+t*T[1]+e*T[0],g.values[o]=h+(f-h)*i}}}else for(let n=0;n<b;++n){const s=b>1?a*(h-1)+n*l:.5*(a+o)*(h-1);if(s<0||s>h-1){for(let a=0;a<f;a++){const s=a+n*T[2]+t*T[1]+e*T[0];g.values[s]=u}continue}const i=Math.round(s),d=Math.round(c);for(let a=0;a<f;a++){const s=a+i*x[2]+d*x[1]+r*x[0],o=a+n*T[2]+t*T[1]+e*T[0];g.values[o]=N[s]}}}}return a.makeTensorInfo(g.shape,g.dtype,g.values)}};const tn={kernelName:t.Cumsum,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r}=n,{axis:i,exclusive:l,reverse:d}=o;a(r,"cumsum");const u=t.backend_util.getAxesPermutation([i],r.shape.length);let c=r;null!=u&&(c=ke({inputs:{x:r},backend:s,attrs:{perm:u}}));const p=t.backend_util.getInnerMostAxes(1,r.shape.length)[0];if(p!==c.shape.length-1)throw new Error(`backend.cumsum in CPU expects an inner-most axis=${c.shape.length-1} but got axis=${p}`);const h=t.upcastType(c.dtype,"int32"),f=t.util.makeZerosTypedArray(t.util.sizeFromShape(c.shape),h),m=s.data.get(c.dataId).values,k=c.shape[c.shape.length-1],b=d?(e,t)=>e+k-t-1:(e,t)=>e+t;for(let e=0;e<m.length;e+=k)for(let t=0;t<k;t++){const n=b(e,t);if(0===t)f[n]=l?0:m[n];else{const a=b(e,t-1);f[n]=l?m[a]+f[a]:m[n]+f[a]}}const g=s.makeTensorInfo(c.shape,h,f);if(null!=u){const e=ke({inputs:{x:g},backend:s,attrs:{perm:t.backend_util.getUndoAxesPermutation(u)}});return s.disposeIntermediateTensorInfo(g),s.disposeIntermediateTensorInfo(c),e}return g}};const nn={kernelName:t.DenseBincount,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{x:s,weights:o}=t,{size:r,binaryOutput:i}=a;if(1===s.shape.length){const e=S(n.data.get(s.dataId).values,n.data.get(o.dataId).values,o.dtype,o.shape,r);return n.makeTensorInfo([r],o.dtype,e)}if(2===s.shape.length){const e=F(n.bufferSync(s),n.bufferSync(o),r,i);return n.makeTensorInfo(e.shape,o.dtype,e.values)}throw new Error("Error in denseBincount: input must be at most rank 2, but got rank"+s.shape.length+".")}};const an={kernelName:t.DepthToSpace,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{x:o}=n,{blockSize:r,dataFormat:i}=s;t.util.assert("NHWC"===i,()=>"Only NHWC dataFormat supported on CPU for depthToSpace. Got "+i),t.util.assert(r>1,()=>"blockSize should be > 1 for depthToSpace, but was: "+r);const l=o.shape[0],d=o.shape[1],u=o.shape[2],c=o.shape[3],p=d*r,h=u*r,f=c/(r*r),m=a.data.get(o.dataId).values,k=new Float32Array(l*p*h*f);let b=0;for(let e=0;e<l;++e)for(let t=0;t<p;++t){const n=Math.floor(t/r),a=t%r;for(let t=0;t<h;++t){const s=Math.floor(t/r),o=(a*r+t%r)*f;for(let t=0;t<f;++t){const a=t+o+c*(s+u*(n+d*e));k[b++]=m[a]}}}return a.makeTensorInfo([l,p,h,f],o.dtype,k)}};function sn(e){const{inputs:n,backend:s,attrs:o}=e,{x:r,filter:i}=n,{strides:l,pad:d,dilations:u,dimRoundingMode:c}=o;a([r,i],"depthwiseConv2DNative");const p=t.util.computeStrides(r.shape),h=t.util.computeStrides(i.shape);let f=u;null==f&&(f=[1,1]),t.util.assert(t.backend_util.eitherStridesOrDilationsAreOne(l,f),()=>`Error in depthwiseConv2d: Either strides or dilations must be 1. Got strides ${l} and dilations '${f}'`);const m=t.backend_util.computeConv2DInfo(r.shape,i.shape,l,f,d,c,!0),{filterHeight:k,filterWidth:b,dilationHeight:g,dilationWidth:I,padInfo:y}=m,N=y.left,x=y.top,T=m.outChannels/m.inChannels,S=new t.TensorBuffer(m.outShape,r.dtype),F=s.data.get(r.dataId).values,v=s.data.get(i.dataId).values,M=S.values;for(let e=0;e<m.batchSize;++e){const t=e*p[0],n=e*S.strides[0];for(let e=0;e<m.outHeight;++e){const a=n+e*S.strides[1],s=e*m.strideHeight-x;for(let e=0;e<k;++e){const n=s+e*g;if(n<0||n>=m.inHeight)continue;const o=e*h[0],r=t+n*p[1];for(let e=0;e<m.outWidth;++e){const t=a+e*S.strides[2],n=e*m.strideWidth-N;for(let e=0;e<b;++e){const a=n+e*I;if(a<0||a>=m.inWidth)continue;const s=o+e*h[1],i=r+a*m.inChannels;let l=t,d=s;for(let e=0;e<m.inChannels;++e){const t=F[i+e];for(let e=0;e<T;++e)M[l+e]+=t*v[d+e];l+=T,d+=T}}}}}}return s.makeTensorInfo(S.shape,S.dtype,S.values)}const on={kernelName:t.DepthwiseConv2dNative,backendName:"cpu",kernelFunc:sn};const rn={kernelName:t.DepthwiseConv2dNativeBackpropFilter,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r,dy:i}=n,{strides:l,dilations:d,pad:u,dimRoundingMode:c,filterShape:p}=o;a([r,i],"depthwiseConv2dNativeBackpropFilter");const h=t.backend_util.computeConv2DInfo(r.shape,p,l,d,u,c,!0),{strideHeight:f,strideWidth:m,filterHeight:k,filterWidth:b}=h,g=new t.TensorBuffer(h.filterShape,"float32"),I=h.padInfo.left,y=h.padInfo.top,N=h.outChannels/h.inChannels,x=s.data.get(r.dataId).values,T=new t.TensorBuffer(r.shape,r.dtype,x),S=s.data.get(i.dataId).values,F=new t.TensorBuffer(i.shape,i.dtype,S);for(let e=0;e<k;++e){const t=Math.max(0,Math.ceil((y-e)/f)),n=Math.min(h.outHeight,(h.inHeight+y-e)/f);for(let a=0;a<b;++a){const s=Math.max(0,Math.ceil((I-a)/m)),o=Math.min(h.outWidth,(h.inWidth+I-a)/m);for(let r=0;r<h.outChannels;++r){const i=Math.trunc(r/N),l=r%N;let d=0;for(let l=0;l<h.batchSize;++l)for(let u=t;u<n;++u){const t=e+u*f-y;for(let e=s;e<o;++e){const n=a+e*m-I;d+=T.get(l,t,n,i)*F.get(l,u,e,r)}}g.set(d,e,a,i,l)}}}return s.makeTensorInfo(g.shape,g.dtype,g.values)}};const ln={kernelName:t.DepthwiseConv2dNativeBackpropInput,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{dy:r,filter:i}=n,{strides:l,dilations:d,pad:u,dimRoundingMode:c,inputShape:p}=o;a([r,i],"depthwiseConv2DNativeBackpropInput");const h=t.util.computeStrides(r.shape),f=t.util.computeStrides(i.shape),m=t.backend_util.computeConv2DInfo(p,i.shape,l,d,u,c,!0),k=new t.TensorBuffer(m.inShape,"float32"),b=k.values,[g,I,y]=k.strides,N=s.data.get(r.dataId).values,[x,T,S]=h,F=s.data.get(i.dataId).values,[v,M,A]=f,{batchSize:D,filterHeight:w,filterWidth:_,inChannels:z,inHeight:E,inWidth:C,outChannels:W,outHeight:H,outWidth:R,strideHeight:P,strideWidth:B}=m,$=w-1-m.padInfo.top,V=_-1-m.padInfo.left,L=W/z;for(let e=0;e<D;++e)for(let t=0;t<z;++t)for(let n=0;n<E;++n){const a=n-$,s=Math.max(0,Math.ceil(a/P)),o=Math.min(H,(w+a)/P);for(let r=0;r<C;++r){const i=r-V,l=Math.max(0,Math.ceil(i/B)),d=Math.min(R,(_+i)/B);let u=0;for(let n=s;n<o;++n){const s=n*P-a;for(let a=l;a<d;++a){const o=x*e+T*n+S*a,r=v*(w-1-s)+M*(_-1-(a*B-i))+A*t;for(let e=0;e<L;++e){u+=N[o+(t*L+e)]*F[r+e]}}}b[g*e+I*n+y*r+t]=u}}return s.makeTensorInfo(k.shape,k.dtype,k.values)}};const dn={kernelName:t.Diag,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a}=e,{x:s}=n,o=t.util.sizeFromShape(s.shape),r=a.data.get(s.dataId).values,i=t.buffer([o,o],s.dtype),l=i.values;for(let e=0;e<r.length;e++)l[e*o+e]=r[e];const d=[...s.shape,...s.shape];return a.makeTensorInfo(d,i.dtype,i.values)}},un={kernelName:t.Dilation2D,backendName:"cpu",kernelFunc:({inputs:e,backend:n,attrs:a})=>{const{x:s,filter:o}=e,{strides:r,pad:i,dilations:l}=a,d=n,u=d.data.get(s.dataId).values,c=s.shape.length,p=d.data.get(o.dataId).values,h=o.shape.length,{batchSize:f,inHeight:m,inWidth:k,inChannels:b,outHeight:g,outWidth:I,padInfo:y,strideHeight:N,strideWidth:x,filterHeight:T,filterWidth:S,dilationHeight:F,dilationWidth:v,outShape:M}=t.backend_util.computeDilation2DInfo(s.shape,o.shape,r,i,"NHWC",l),A=t.util.sizeFromShape(M),D=M.length,w=t.util.getArrayFromDType(s.dtype,A);for(let e=0;e<f;++e)for(let n=0;n<g;++n){const a=n*N-y.top;for(let r=0;r<I;++r){const i=r*x-y.left;for(let l=0;l<b;++l){let d=Number.MIN_SAFE_INTEGER;for(let n=0;n<T;++n){const r=a+n*F;if(r>=0&&r<m)for(let a=0;a<S;++a){const f=i+a*v;if(f>=0&&f<k){const i=t.util.locToIndex([e,r,f,l],c,t.util.computeStrides(s.shape)),m=t.util.locToIndex([n,a,l],h,t.util.computeStrides(o.shape)),k=u[i]+p[m];k>d&&(d=k)}}}w[t.util.locToIndex([e,n,r,l],D,t.util.computeStrides(M))]=d}}}return{dataId:d.write(t.util.toTypedArray(w,s.dtype),M,s.dtype),shape:M,dtype:s.dtype}}},cn={kernelName:t.Dilation2DBackpropFilter,backendName:"cpu",kernelFunc:({inputs:e,backend:n,attrs:a})=>{const{x:s,filter:o,dy:r}=e,{strides:i,pad:l,dilations:d}=a,u=n,c=t.util.toNestedArray(s.shape,u.data.get(s.dataId).values),p=t.util.toNestedArray(o.shape,u.data.get(o.dataId).values),{batchSize:h,inHeight:f,inWidth:m,inChannels:k,outHeight:b,outWidth:g,padInfo:I,strideHeight:y,strideWidth:N,filterHeight:x,filterWidth:T,dilationHeight:S,dilationWidth:F,outShape:v}=t.backend_util.computeDilation2DInfo(s.shape,o.shape,i,l,"NHWC",d);t.util.assert(r.rank===v.length,()=>`Error in ${t.Dilation2DBackpropFilter}, dy must have the same rank as output ${v.length}, but got `+r.rank);const M=t.util.toNestedArray(v,u.data.get(r.dataId).values),A=t.util.makeZerosNestedTypedArray(o.shape,o.dtype);for(let e=0;e<h;++e)for(let t=0;t<b;++t){const n=t*y-I.top;for(let a=0;a<g;++a){const s=a*N-I.left;for(let o=0;o<k;++o){let r=Number.MIN_SAFE_INTEGER,i=0,l=0;for(let t=0;t<x;++t){const a=n+t*S;if(a>=0&&a<f)for(let n=0;n<T;++n){const d=s+n*F;if(d>=0&&d<m){const s=c[e][a][d][o]+p[t][n][o];s>r&&(r=s,i=t,l=n)}}}A[i][l][o]+=M[e][t][a][o]}}}return{dataId:u.write(t.util.toTypedArray(A,s.dtype),o.shape,o.dtype),shape:o.shape,dtype:o.dtype}}},pn={kernelName:t.Dilation2DBackpropInput,backendName:"cpu",kernelFunc:({inputs:e,backend:n,attrs:a})=>{const{x:s,filter:o,dy:r}=e,{strides:i,pad:l,dilations:d}=a,u=n,c=t.util.toNestedArray(s.shape,u.data.get(s.dataId).values),p=t.util.toNestedArray(o.shape,u.data.get(o.dataId).values),{batchSize:h,inHeight:f,inWidth:m,inChannels:k,outHeight:b,outWidth:g,padInfo:I,strideHeight:y,strideWidth:N,filterHeight:x,filterWidth:T,dilationHeight:S,dilationWidth:F,outShape:v}=t.backend_util.computeDilation2DInfo(s.shape,o.shape,i,l,"NHWC",d);t.util.assert(r.rank===v.length,()=>`Error in ${t.Dilation2DBackpropInput}, dy must have the same rank as output ${v.length}, but got `+r.rank);const M=t.util.toNestedArray(v,u.data.get(r.dataId).values),A=t.util.makeZerosNestedTypedArray(s.shape,s.dtype);for(let e=0;e<h;++e)for(let t=0;t<b;++t){const n=t*y-I.top;for(let a=0;a<g;++a){const s=a*N-I.left;for(let o=0;o<k;++o){let r=Number.MIN_SAFE_INTEGER,i=n<0?0:n,l=s<0?0:s;for(let t=0;t<x;++t){const a=n+t*S;if(a>=0&&a<f)for(let n=0;n<T;++n){const d=s+n*F;if(d>=0&&d<m){const s=c[e][a][d][o]+p[t][n][o];s>r&&(r=s,i=a,l=d)}}}A[e][i][l][o]+=M[e][t][a][o]}}}return{dataId:u.write(t.util.toTypedArray(A,s.dtype),s.shape,s.dtype),shape:s.shape,dtype:s.dtype}}};function hn(e){const{inputs:n,backend:s,attrs:o}=e,{x:r}=n,{axis:i,keepDims:l}=o;let d;a(r,"sum"),d="bool"===r.dtype?k({inputs:{x:r},backend:s,attrs:{dtype:"int32"}}):p({inputs:{x:r},backend:s});const u=d.shape.length,h=t.util.parseAxisParam(i,d.shape),f=t.backend_util.getAxesPermutation(h,u);let m=h,b=d;null!=f&&(b=ke({inputs:{x:d},backend:s,attrs:{perm:f}}),m=t.backend_util.getInnerMostAxes(m.length,u)),t.backend_util.assertAxesAreInnerMostDims("sum",m,b.shape.length);const[g,I]=t.backend_util.computeOutAndReduceShapes(b.shape,m);let y=c(s,g,t.backend_util.upcastType(b.dtype,"int32"));const N=t.util.sizeFromShape(I),x=s.data.get(y.dataId).values,T=s.data.get(b.dataId).values;for(let e=0;e<x.length;++e){const t=e*N;let n=0;for(let e=0;e<N;++e)n+=T[t+e];x[e]=n}if(l){const e=y;y=tt({inputs:{x:y},backend:s,attrs:{shape:t.backend_util.expandShapeToKeepDim(y.shape,h)}}),s.disposeIntermediateTensorInfo(e)}return s.disposeIntermediateTensorInfo(d),null!=f&&s.disposeIntermediateTensorInfo(b),y}const fn={kernelName:t.Sum,backendName:"cpu",kernelFunc:hn};const mn={kernelName:t.Einsum,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{equation:o}=s,r=n,{allDims:i,summedDims:l,idDims:d}=t.backend_util.decodeEinsumEquation(o,r.length);t.backend_util.checkEinsumDimSizes(i.length,d,r);const{path:u,steps:c}=t.backend_util.getEinsumComputePath(l,d),p=c.length;let h=null,f=i.length;const m=[];for(let e=0;e<p;++e){for(const n of c[e]){const{permutationIndices:e,expandDims:s}=t.backend_util.getEinsumPermutation(f,d[n]);let o;t.backend_util.isIdentityPermutation(e)?o=r[n]:(o=ke({inputs:{x:r[n]},backend:a,attrs:{perm:e}}),m.push(o));const i=o.shape.slice();for(let e=0;e<s.length;++e)i.splice(s[e],0,1);t.util.arraysEqual(o.shape,i)||(o=tt({inputs:{x:o},backend:a,attrs:{shape:i}}),m.push(o)),null===h?h=o:(h=le({inputs:{a:o,b:h},backend:a}),m.push(h))}e<p-1&&(u[e]>=0&&(h=hn({inputs:{x:h},backend:a,attrs:{axis:u[e]-(i.length-f),keepDims:!1}}),m.push(h)),f--)}for(const e of m)e!==h&&a.disposeIntermediateTensorInfo(e);return h}};const kn={kernelName:t.EluGrad,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s}=e,{dy:o,y:r}=n;a([o,r],"eluGrad");const i=new Float32Array(t.util.sizeFromShape(r.shape)),l=s.data.get(r.dataId).values,d=s.data.get(o.dataId).values;for(let e=0;e<l.length;++e){const t=l[e];i[e]=t>=1?d[e]:d[e]*(t+1)}return s.makeTensorInfo(r.shape,"float32",i)}},bn=l((e,t)=>e===t?1:0),gn=g(t.Equal,bn,null,"bool"),In={kernelName:t.Equal,backendName:"cpu",kernelFunc:gn},yn=t.backend_util.ERF_P,Nn=t.backend_util.ERF_A1,xn=t.backend_util.ERF_A2,Tn=t.backend_util.ERF_A3,Sn=t.backend_util.ERF_A4,Fn=t.backend_util.ERF_A5,vn=M(t.Erf,e=>{const t=Math.sign(e),n=Math.abs(e),a=1/(1+yn*n);return t*(1-((((Fn*a+Sn)*a+Tn)*a+xn)*a+Nn)*a*Math.exp(-n*n))}),Mn={kernelName:t.Erf,backendName:"cpu",kernelFunc:vn};function An(e){const{inputs:n,backend:a,attrs:s}=e,{input:o}=n,{dim:r}=s,i=o.shape.length,l=o.shape.slice();let d=r;return r<0&&(t.util.assert(-(i+1)<=r,()=>`Axis must be in the interval [${-(i+1)}, ${i}]`),d=i+r+1),l.splice(d,0,1),tt({inputs:{x:o},backend:a,attrs:{shape:l}})}const Dn={kernelName:t.ExpandDims,backendName:"cpu",kernelFunc:An},wn=l((e,t)=>e/t),_n=g(t.RealDiv,wn),zn={kernelName:t.RealDiv,backendName:"cpu",kernelFunc:_n};function En(e,n,a){const s=e.shape,o=s[0],r=s[1],i=a.data.get(e.dataId),l=i.complexTensorInfos.real,u=i.complexTensorInfos.imag,c=[o,r],p=t.util.sizeFromShape(c),h=t.util.getTypedArrayFromDType("float32",p),f=t.util.getTypedArrayFromDType("float32",p);for(let e=0;e<o;e++){const s=Fe({inputs:{x:l},backend:a,attrs:{begin:[e,0],size:[1,r]}}),o=Fe({inputs:{x:u},backend:a,attrs:{begin:[e,0],size:[1,r]}}),i=d({inputs:{real:s,imag:o},backend:a}),{real:c,imag:p}=Cn(i,n,a),m=t.backend_util.mergeRealAndImagArrays(c,p);for(let n=0;n<r;n++){const a=t.backend_util.getComplexWithIndex(m,n);h[e*r+n]=a.real,f[e*r+n]=a.imag}a.disposeIntermediateTensorInfo(s),a.disposeIntermediateTensorInfo(o),a.disposeIntermediateTensorInfo(i)}const m=a.makeTensorInfo(c,"float32",h),k=a.makeTensorInfo(c,"float32",f),b=d({inputs:{real:m,imag:k},backend:a});return a.disposeIntermediateTensorInfo(m),a.disposeIntermediateTensorInfo(k),b}function Cn(e,n,a){const s=t.util.sizeFromShape(e.shape),o=a.data.get(e.dataId),r=a.data.get(o.complexTensorInfos.real.dataId).values,i=a.data.get(o.complexTensorInfos.imag.dataId).values;if(0==((l=s)&l-1)){const o=function e(n,a,s,o,r){if(1===s)return{real:n,imag:a};const i=t.backend_util.mergeRealAndImagArrays(n,a),l=s/2,u=t.backend_util.complexWithEvenIndex(i),c=u.real,p=u.imag,h=[c.length],m=r.makeTensorInfo(h,"float32",c),k=r.makeTensorInfo(h,"float32",p),b=d({inputs:{real:m,imag:k},backend:r}),g=t.backend_util.complexWithOddIndex(i),I=g.real,y=g.imag,N=[I.length],T=r.makeTensorInfo(N,"float32",I),S=r.makeTensorInfo(N,"float32",y),F=d({inputs:{real:T,imag:S},backend:r}),v=e(c,p,l,o,r),M=v.real,A=v.imag,D=[M.length],w=r.makeTensorInfo(D,"float32",M),_=r.makeTensorInfo(D,"float32",A),z=d({inputs:{real:w,imag:_},backend:r}),E=e(I,y,l,o,r),C=E.real,W=E.imag,H=[C.length],R=r.makeTensorInfo(H,"float32",C),P=r.makeTensorInfo(H,"float32",W),B=d({inputs:{real:R,imag:P},backend:r}),$=t.backend_util.exponents(s,o),V=[$.real.length],L=r.makeTensorInfo(V,"float32",$.real),O=r.makeTensorInfo(V,"float32",$.imag),q=d({inputs:{real:L,imag:O},backend:r}),G=le({inputs:{a:q,b:B},backend:r}),U=x({inputs:{a:z,b:G},backend:r}),Z=We({inputs:{a:z,b:G},backend:r}),j=f({inputs:{input:U},backend:r}),K=f({inputs:{input:Z},backend:r}),Y=Bt({inputs:{input:U},backend:r}),J=Bt({inputs:{input:Z},backend:r}),Q=Vt({inputs:[j,K],backend:r,attrs:{axis:0}}),X=Vt({inputs:[Y,J],backend:r,attrs:{axis:0}}),ee=r.data.get(Q.dataId).values,te=r.data.get(X.dataId).values;return r.disposeIntermediateTensorInfo(m),r.disposeIntermediateTensorInfo(k),r.disposeIntermediateTensorInfo(b),r.disposeIntermediateTensorInfo(T),r.disposeIntermediateTensorInfo(S),r.disposeIntermediateTensorInfo(F),r.disposeIntermediateTensorInfo(w),r.disposeIntermediateTensorInfo(_),r.disposeIntermediateTensorInfo(z),r.disposeIntermediateTensorInfo(R),r.disposeIntermediateTensorInfo(P),r.disposeIntermediateTensorInfo(B),r.disposeIntermediateTensorInfo(L),r.disposeIntermediateTensorInfo(O),r.disposeIntermediateTensorInfo(q),r.disposeIntermediateTensorInfo(G),r.disposeIntermediateTensorInfo(U),r.disposeIntermediateTensorInfo(Z),r.disposeIntermediateTensorInfo(j),r.disposeIntermediateTensorInfo(Y),r.disposeIntermediateTensorInfo(K),r.disposeIntermediateTensorInfo(J),r.disposeIntermediateTensorInfo(Q),r.disposeIntermediateTensorInfo(X),{real:ee,imag:te}}(r,i,s,n,a),l=[e.shape[0],e.shape[1]];if(n){const e=a.makeTensorInfo(l,"float32",o.real),n=a.makeTensorInfo(l,"float32",o.imag),r=a.makeTensorInfo([],"float32",t.util.createScalarValue(s,"float32")),i=p({inputs:{x:r},backend:a}),d=zn.kernelFunc({inputs:{a:e,b:r},backend:a}),u=zn.kernelFunc({inputs:{a:n,b:i},backend:a}),c=a.data.get(d.dataId).values,h=a.data.get(u.dataId).values;return a.disposeIntermediateTensorInfo(e),a.disposeIntermediateTensorInfo(n),a.disposeIntermediateTensorInfo(r),a.disposeIntermediateTensorInfo(i),a.disposeIntermediateTensorInfo(d),a.disposeIntermediateTensorInfo(u),{real:c,imag:h}}return o}{const e=function(e,n,a){const s=new Float32Array(2*n);for(let o=0;o<n;o++){let r=0,i=0;for(let s=0;s<n;s++){const l=t.backend_util.exponent(o*s,n,a),d=t.backend_util.getComplexWithIndex(e,s);r+=d.real*l.real-d.imag*l.imag,i+=d.real*l.imag+d.imag*l.real}a&&(r/=n,i/=n),t.backend_util.assignToTypedArray(s,r,i,o)}return s}(t.backend_util.mergeRealAndImagArrays(r,i),s,n);return t.backend_util.splitRealAndImagArrays(e)}var l}const Wn={kernelName:t.FFT,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a}=e,{input:s}=n,o=t.util.sizeFromShape(s.shape),r=s.shape[s.shape.length-1],i=tt({inputs:{x:s},backend:a,attrs:{shape:[o/r,r]}}),l=En(i,!1,a),d=tt({inputs:{x:l},backend:a,attrs:{shape:s.shape}});return a.disposeIntermediateTensorInfo(i),a.disposeIntermediateTensorInfo(l),d}};function Hn(e){const{backend:n,attrs:a}=e,{shape:s,value:o,dtype:r}=a,i=r||t.util.inferDtype(o),l=t.util.getArrayFromDType(i,t.util.sizeFromShape(s));return function(e,t,n){e.fill(t)}(l,o),n.makeTensorInfo(s,i,l)}const Rn={kernelName:t.Fill,backendName:"cpu",kernelFunc:Hn};const Pn={kernelName:t.FlipLeftRight,backendName:"cpu",kernelFunc:({inputs:e,attrs:n,backend:a})=>{const{image:s}=e,o=a,r=t.util.getTypedArrayFromDType(s.dtype,t.util.sizeFromShape(s.shape)),[i,l,d,u]=s.shape,c=o.data.get(s.dataId).values;for(let e=0;e<i;e++){const t=e*d*l*u;for(let e=0;e<l;e++){const n=e*(d*u);for(let a=0;a<d;a++){const s=a*u;for(let o=0;o<u;o++){const l=[i,e,a,o][2],p=Math.round(d-l),h=t+n+s+o;let f=c[h];if(p>=0&&p<d){f=c[t+n+p*u+o]}r[h]=f}}}}return{dataId:o.write(r,s.shape,s.dtype),shape:s.shape,dtype:s.dtype}}},Bn=l((e,t)=>Math.floor(e/t)),$n=g(t.FloorDiv,Bn,null,"int32"),Vn={kernelName:t.FloorDiv,backendName:"cpu",kernelFunc:$n};const Ln={kernelName:t.FusedConv2D,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{x:s,filter:o,bias:r,preluActivationWeights:i}=t,{strides:l,pad:d,dataFormat:u,dilations:c,dimRoundingMode:p,activation:h,leakyreluAlpha:f}=a;let m=Ot({inputs:{x:s,filter:o},backend:n,attrs:{strides:l,pad:d,dataFormat:u,dilations:c,dimRoundingMode:p}});if(r){const e=m;m=x({inputs:{a:m,b:r},backend:n}),n.disposeIntermediateTensorInfo(e)}if(h){const e=m;m=et(n,m,h,i,f),n.disposeIntermediateTensorInfo(e)}return m}};const On={kernelName:t.FusedDepthwiseConv2D,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{x:s,filter:o,bias:r,preluActivationWeights:i}=t,{strides:l,pad:d,dataFormat:u,dilations:c,dimRoundingMode:p,activation:h,leakyreluAlpha:f}=a;let m=sn({inputs:{x:s,filter:o},backend:n,attrs:{strides:l,pad:d,dataFormat:u,dilations:c,dimRoundingMode:p}});if(r){const e=m;m=x({inputs:{a:m,b:r},backend:n}),n.disposeIntermediateTensorInfo(e)}if(h){const e=m;m=et(n,m,h,i,f),n.disposeIntermediateTensorInfo(e)}return m}};const qn={kernelName:t.GatherNd,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a}=e,{params:s,indices:o}=n,r=t.util.sizeFromShape(s.shape),i=o.shape,l=i[i.length-1],[d,u,c,p]=t.backend_util.prepareAndValidate(s,o);if(0===u)return a.makeTensorInfo(d,s.dtype,[]);const h=t.buffer([u,c],s.dtype),f=a.data.get(o.dataId).values,m=a.data.get(s.dataId).values;for(let e=0;e<u;e++){const t=[];let n=0;for(let a=0;a<l;a++){const s=f[e*l+a];n+=s*p[a],t.push(s)}if(n<0||n>=r/c)throw new Error(`Invalid indices: ${t} does not index into ${s.shape}`);for(let t=0;t<c;t++)h.values[e*c+t]=m[n*c+t]}return a.makeTensorInfo(d,h.dtype,h.values)}};const Gn={kernelName:t.GatherV2,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r,indices:i}=n,{axis:l,batchDims:d}=o;a([r,i],"gatherV2");let u=d;null==d&&(u=0);const c=t.util.sizeFromShape(i.shape),p=t.util.parseAxisParam(l,r.shape)[0],h=t.backend_util.segment_util.collectGatherOpShapeInfo(r,i,p,u),f=tt({inputs:{x:r},backend:s,attrs:{shape:[h.batchSize,h.outerSize,h.dimSize,h.sliceSize]}}),m=tt({inputs:{x:i},backend:s,attrs:{shape:[h.batchSize,c/h.batchSize]}}),k=[h.batchSize,h.outerSize,c/h.batchSize,h.sliceSize],b=s.bufferSync(m),g=L(s.bufferSync(f),b,k);return s.disposeIntermediateTensorInfo(f),s.disposeIntermediateTensorInfo(m),s.makeTensorInfo(h.outputShape,g.dtype,g.values)}},Un=l((e,t)=>e>=t?1:0),Zn=g(t.GreaterEqual,Un,null,"bool"),jn={kernelName:t.GreaterEqual,backendName:"cpu",kernelFunc:Zn};const Kn={kernelName:t.IFFT,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a}=e,{input:s}=n,o=t.util.sizeFromShape(s.shape),r=s.shape[s.shape.length-1],i=tt({inputs:{x:s},backend:a,attrs:{shape:[o/r,r]}}),l=En(i,!0,a),d=tt({inputs:{x:l},backend:a,attrs:{shape:s.shape}});return a.disposeIntermediateTensorInfo(i),a.disposeIntermediateTensorInfo(l),d}},Yn=M(t.IsFinite,e=>Number.isFinite(e)?1:0,"bool"),Jn={kernelName:t.IsFinite,backendName:"cpu",kernelFunc:Yn},Qn=M(t.IsInf,e=>Math.abs(e)===1/0?1:0,"bool"),Xn={kernelName:t.IsInf,backendName:"cpu",kernelFunc:Qn},ea=M(t.IsNan,e=>Number.isNaN(e)?1:0,"bool"),ta={kernelName:t.IsNan,backendName:"cpu",kernelFunc:ea},na=l((e,t)=>e<=t?1:0),aa=g(t.LessEqual,na,null,"bool"),sa={kernelName:t.LessEqual,backendName:"cpu",kernelFunc:aa};const oa={kernelName:t.LinSpace,backendName:"cpu",kernelFunc:function(e){const{backend:t,attrs:n}=e,{start:a,stop:s,num:o}=n,r=K(a,s,o);return t.makeTensorInfo([r.length],"float32",r)}},ra=M(t.Log1p,e=>Math.log1p(e)),ia={kernelName:t.Log1p,backendName:"cpu",kernelFunc:ra},la=l((e,t)=>e&&t),da=g(t.LogicalAnd,la,null,"bool"),ua={kernelName:t.LogicalAnd,backendName:"cpu",kernelFunc:da},ca=M(t.LogicalNot,e=>e?0:1,"bool"),pa={kernelName:t.LogicalNot,backendName:"cpu",kernelFunc:ca},ha=l((e,t)=>e||t),fa=g(t.LogicalOr,ha,null,"bool"),ma={kernelName:t.LogicalOr,backendName:"cpu",kernelFunc:fa};const ka={kernelName:t.LRN,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r}=n,{depthRadius:i,bias:l,alpha:d,beta:u}=o;a(r,"LRN");const c=r.shape[3],p=c-1,h=s.data.get(r.dataId).values,f=t.util.sizeFromShape(r.shape),m=new Float32Array(f);function k(e){const t=e%c;let n=e-t+Math.max(0,t-i);const a=e-t+Math.min(t+i,p);let s=0;for(;n<=a;n++){const e=h[n];s+=e*e}return s}for(let e=0;e<f;e++){const t=k(e),n=h[e]*Math.pow(l+d*t,-u);m[e]=n}return s.makeTensorInfo(r.shape,r.dtype,m)}};const ba={kernelName:t.LRNGrad,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r,y:i,dy:l}=n,{depthRadius:d,bias:u,alpha:c,beta:p}=o;a(l,"LRNGrad");const h=t.util.sizeFromShape(l.shape),f=l.shape[3],m=s.data.get(l.dataId).values,k=s.data.get(r.dataId).values,b=s.data.get(i.dataId).values,g=new Float32Array(h),I=h;for(let e=0;e<I;e++){const t=e%f,n=e-t+Math.max(0,t-d),a=e-t+Math.min(f,t+d+1);let s=0;for(let e=n;e<a;e++)s+=Math.pow(k[e],2);s=c*s+u;for(let t=n;t<a;t++){let n=-2*c*p*k[t]*b[e]/s;e===t&&(n+=Math.pow(s,-p)),n*=m[e],g[t]+=n}}return s.makeTensorInfo(l.shape,r.dtype,g)}};function ga(e){const{inputs:n,backend:s,attrs:o}=e,{x:r}=n,{reductionIndices:i,keepDims:l}=o,d=s;let u=r.shape;const c=u.length,p=t.util.parseAxisParam(i,u);let h=p;const f=t.backend_util.getAxesPermutation(h,c);let m=d.data.get(r.dataId).values;if(null!=f){const e=new Array(c);for(let t=0;t<e.length;t++)e[t]=u[f[t]];m=me(m,u,r.dtype,f,e),h=t.backend_util.getInnerMostAxes(h.length,c),u=e}a(r,"max"),t.backend_util.assertAxesAreInnerMostDims("max",h,c);const[k,b]=t.backend_util.computeOutAndReduceShapes(u,h),g=X(m,t.util.sizeFromShape(b),k,r.dtype),I=d.write(g,k,r.dtype);let y=k;if(l){y=t.backend_util.expandShapeToKeepDim(k,p)}return{dataId:I,shape:y,dtype:r.dtype}}const Ia={kernelName:t.Max,backendName:"cpu",kernelFunc:ga};const ya={kernelName:t.MaxPool,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r}=n;a(r,"maxPool");const{filterSize:i,strides:l,pad:d,dimRoundingMode:u}=o;t.util.assert(t.backend_util.eitherStridesOrDilationsAreOne(l,1),()=>`Error in maxPool: Either strides or dilations must be 1. Got strides ${l} and dilations '1'`);const c=t.backend_util.computePool2DInfo(r.shape,i,l,1,d,u);let h;if(1===c.filterWidth&&1===c.filterHeight&&t.util.arraysEqual(c.inShape,c.outShape))h=p({inputs:{x:r},backend:s});else{const e=s.data.get(r.dataId).values,n=t.util.computeStrides(r.shape),a=vt(e,r.shape,r.dtype,n,c,"max");h=s.makeTensorInfo(c.outShape,r.dtype,a.values)}return h}};const Na={kernelName:t.MaxPool3D,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r}=n,{filterSize:i,strides:l,pad:d,dimRoundingMode:u,dataFormat:c}=o;a(r,"maxPool3d");const p=t.backend_util.computePool3DInfo(r.shape,i,l,1,d,u,c),h=At(s.data.get(r.dataId).values,r.shape,r.dtype,t.util.computeStrides(r.shape),p,"max");return s.makeTensorInfo(h.shape,"float32",h.values)}};const xa={kernelName:t.MaxPool3DGrad,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{dy:r,input:i}=n,{filterSize:l,strides:d,pad:u,dimRoundingMode:c}=o;a([r,i],"maxPool3DGrad");const p=t.backend_util.computePool3DInfo(i.shape,l,d,1,u,c),h=function(e,n){const a=t.buffer(n.outShape,"int32"),s=n.strideDepth,o=n.strideHeight,r=n.strideWidth,i=n.dilationDepth,l=n.dilationHeight,d=n.dilationWidth,u=n.effectiveFilterDepth,c=n.effectiveFilterHeight,p=n.effectiveFilterWidth,h=n.padInfo.front,f=n.padInfo.top,m=n.padInfo.left;for(let t=0;t<n.batchSize;++t)for(let k=0;k<n.inChannels;++k)for(let b=0;b<n.outDepth;++b){const g=b*s-h;let I=g;for(;I<0;)I+=i;const y=Math.min(n.inDepth,u+g);for(let s=0;s<n.outHeight;++s){const u=s*o-f;let h=u;for(;h<0;)h+=l;const N=Math.min(n.inHeight,c+u);for(let o=0;o<n.outWidth;++o){const f=o*r-m;let x=f;for(;x<0;)x+=d;const T=Math.min(n.inWidth,p+f);let S=Number.NEGATIVE_INFINITY,F=-1;for(let n=I;n<y;n+=i){const a=n-g;for(let s=h;s<N;s+=l){const o=s-u;for(let r=x;r<T;r+=d){const i=r-f,l=e.get(t,n,s,r,k);l>=S&&(S=l,F=a*c*p+o*c+i)}}}a.set(F,t,b,s,o,k)}}}return a}(s.bufferSync(i),p),f=p.strideDepth,m=p.strideHeight,k=p.strideWidth,b=p.dilationDepth,g=p.dilationHeight,I=p.dilationWidth,y=p.effectiveFilterDepth,N=p.effectiveFilterHeight,x=p.effectiveFilterWidth,T=y-1-p.padInfo.front,S=x-1-p.padInfo.left,F=N-1-p.padInfo.top,v=t.buffer(i.shape,"float32"),M=s.bufferSync(r);for(let e=0;e<p.batchSize;++e)for(let t=0;t<p.inChannels;++t)for(let n=0;n<p.inDepth;++n)for(let a=0;a<p.inHeight;++a)for(let s=0;s<p.inWidth;++s){const o=n-T,r=a-F,i=s-S;let l=0;for(let n=0;n<y;n+=b){const a=(o+n)/f;if(!(a<0||a>=p.outDepth||Math.floor(a)!==a))for(let s=0;s<N;s+=g){const o=(r+s)/m;if(!(o<0||o>=p.outHeight||Math.floor(o)!==o))for(let r=0;r<x;r+=I){const d=(i+r)/k;if(d<0||d>=p.outWidth||Math.floor(d)!==d)continue;const u=y*N*x-1-h.get(e,a,o,d,t)===n*N*x+s*x+r?1:0;if(0===u)continue;l+=M.get(e,a,o,d,t)*u}}}v.set(l,e,n,a,s,t)}return s.makeTensorInfo(v.shape,v.dtype,v.values)}};const Ta={kernelName:t.MaxPoolGrad,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{dy:r,input:i,output:l}=n,d=i;a([i,l],"maxPoolGrad");const{filterSize:u,strides:c,pad:p,dimRoundingMode:h}=o,f=t.backend_util.computePool2DInfo(d.shape,u,c,1,p,h),m=s.data.get(d.dataId).values,k=t.buffer(f.outShape,d.dtype,Mt(m,d.shape,d.dtype,f).values),b=f.strideHeight,g=f.strideWidth,I=f.dilationHeight,y=f.dilationWidth,N=f.effectiveFilterHeight,x=f.effectiveFilterWidth,T=x-1-f.padInfo.left,S=N-1-f.padInfo.top,F=t.buffer(d.shape,"float32"),v=s.data.get(r.dataId).values,M=t.buffer(r.shape,"float32",v);for(let e=0;e<f.batchSize;++e)for(let t=0;t<f.inChannels;++t)for(let n=0;n<f.inHeight;++n)for(let a=0;a<f.inWidth;++a){const s=n-S,o=a-T;let r=0;for(let n=0;n<N;n+=I){const a=(s+n)/b;if(!(a<0||a>=f.outHeight||Math.floor(a)!==a))for(let s=0;s<x;s+=y){const i=(o+s)/g;if(i<0||i>=f.outWidth||Math.floor(i)!==i)continue;const l=N*x-1-k.get(e,a,i,t)===n*x+s?1:0;if(0===l)continue;r+=M.get(e,a,i,t)*l}}F.set(r,e,n,a,t)}return s.makeTensorInfo(F.shape,F.dtype,F.values)}};const Sa={kernelName:t.MaxPoolWithArgmax,backendName:"cpu",kernelFunc:({inputs:e,attrs:n,backend:s})=>{const{x:o}=e,{filterSize:r,strides:i,pad:l,includeBatchInIndex:d}=n,u=s;a(o,"MaxPoolWithArgmax");const c=u.data.get(o.dataId).values,p=t.backend_util.computePool2DInfo(o.shape,r,i,[1,1],l),[h,f]=function(e,n,a,s,o){const r=vt(e,0,a,t.util.computeStrides(n),o,"max"),i=Mt(e,n,a,o,!0,s);return[r.values,i.values]}(c,o.shape,o.dtype,d,p),m=u.write(h,p.outShape,o.dtype),k=u.write(f,p.outShape,o.dtype);return[{dataId:m,shape:p.outShape,dtype:o.dtype},{dataId:k,shape:p.outShape,dtype:"int32"}]}};const Fa={kernelName:t.Mean,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{x:o}=n,{axis:r,keepDims:i}=s,l=t.util.parseAxisParam(r,o.shape),d=t.backend_util.computeOutAndReduceShapes(o.shape,l)[1],u=t.util.sizeFromShape(d),c=[],p=a.makeTensorInfo([],"float32",new Float32Array([u]));c.push(p);const h=k({inputs:{x:o},backend:a,attrs:{dtype:"float32"}});c.push(h);const f=_n({inputs:{a:h,b:p},backend:a});c.push(f);const m=hn({inputs:{x:f},backend:a,attrs:{axis:r,keepDims:i}});return c.forEach(e=>a.disposeIntermediateTensorInfo(e)),m}};const va={kernelName:t.Min,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r}=n,{axis:i,keepDims:l}=o;a(r,"min");const d=t.util.parseAxisParam(i,r.shape);let u=d;const c=t.backend_util.getAxesPermutation(u,r.shape.length);let p=r;null!=c&&(p=ke({inputs:{x:r},backend:s,attrs:{perm:c}}),u=t.backend_util.getInnerMostAxes(u.length,r.shape.length)),t.backend_util.assertAxesAreInnerMostDims("min",u,p.shape.length);const[h,f]=t.backend_util.computeOutAndReduceShapes(p.shape,u),m=t.util.sizeFromShape(f),k=t.util.makeZerosTypedArray(t.util.sizeFromShape(h),p.dtype),b=s.data.get(p.dataId).values;for(let e=0;e<k.length;++e){const t=e*m;let n=b[t];for(let e=0;e<m;++e){const a=b[t+e];a<n&&(n=a)}k[e]=n}null!=c&&s.disposeIntermediateTensorInfo(p);const g=s.makeTensorInfo(h,p.dtype,k);if(l){const e=tt({inputs:{x:g},backend:s,attrs:{shape:t.backend_util.expandShapeToKeepDim(h,d)}});return s.disposeIntermediateTensorInfo(g),e}return g}};const Ma={kernelName:t.MirrorPad,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r}=n,{paddings:i,mode:l}=o;a(r,"mirrorPad");const d=i.map((e,t)=>e[0]+r.shape[t]+e[1]),u=i.map(e=>e[0]),c=i.map((e,t)=>e[0]+r.shape[t]),p="reflect"===l?0:1,h=s.data.get(r.dataId).values,f=r.shape.length,m=t.util.computeStrides(r.shape),k=t.util.sizeFromShape(d),b=d.length,g=t.util.computeStrides(d),I=t.util.getTypedArrayFromDType(r.dtype,k);for(let e=0;e<k;e++){let n=t.util.indexToLoc(e,b,g);for(let e=0;e<b;e++)n[e]<u[e]?n[e]=2*u[e]-n[e]-p:n[e]>=c[e]&&(n[e]=2*(c[e]-1)-n[e]+p);n=n.map((e,t)=>e-u[t]);const a=t.util.locToIndex(n,f,m);I[e]=h[a]}return{dataId:s.write(I,d,r.dtype),shape:d,dtype:r.dtype}}},Aa=l((e,t)=>{const n=e%t;return e<0&&t<0||e>=0&&t>=0?n:(n+t)%t}),Da=g(t.Mod,Aa),wa={kernelName:t.Mod,backendName:"cpu",kernelFunc:Da};function _a(e){const{inputs:n,backend:a,attrs:s}=e,{logits:o}=n,{dim:r}=s,i=o.shape.length;let l=r;if(-1===l&&(l=i-1),l!==i-1)throw Error(`Softmax along a non-last dimension is not yet supported. Logits was rank ${i} and dim was ${l}`);const d=t.util.parseAxisParam([l],o.shape),u=ga({inputs:{x:o},backend:a,attrs:{reductionIndices:d,keepDims:!1}}),c=t.backend_util.expandShapeToKeepDim(u.shape,d),p=tt({inputs:{x:u},backend:a,attrs:{shape:c}}),h=We({inputs:{a:o,b:p},backend:a}),f=C({inputs:{x:h},backend:a}),m=hn({inputs:{x:f},backend:a,attrs:{axis:d,keepDims:!1}}),k=tt({inputs:{x:m},backend:a,attrs:{shape:c}}),b=_n({inputs:{a:f,b:k},backend:a});return a.disposeIntermediateTensorInfo(u),a.disposeIntermediateTensorInfo(p),a.disposeIntermediateTensorInfo(h),a.disposeIntermediateTensorInfo(f),a.disposeIntermediateTensorInfo(m),a.disposeIntermediateTensorInfo(k),b}const za={kernelName:t.Softmax,backendName:"cpu",kernelFunc:_a};const Ea={kernelName:t.Multinomial,backendName:"cpu",kernelFunc:function(e){const{inputs:s,backend:o,attrs:r}=e,{logits:i}=s,{numSamples:l,seed:d,normalized:u}=r;a(i,"multinomial");const c=u?i:_a({inputs:{logits:i},backend:o,attrs:{dim:-1}}),p=c.shape[0],h=c.shape[1],f=o.data.get(c.dataId).values,m=[p,l],k=t.util.makeZerosTypedArray(t.util.sizeFromShape(m),"int32");for(let e=0;e<p;++e){const t=e*h,a=new Float32Array(h-1);a[0]=f[t];for(let e=1;e<a.length;++e)a[e]=a[e-1]+f[t+e];const s=n.alea(d.toString()),o=e*l;for(let e=0;e<l;++e){const t=s();k[o+e]=a.length;for(let n=0;n<a.length;n++)if(t<a[n]){k[o+e]=n;break}}}return u||o.disposeIntermediateTensorInfo(c),o.makeTensorInfo(m,"int32",k)}},Ca=t.kernel_impls.nonMaxSuppressionV3Impl;const Wa={kernelName:t.NonMaxSuppressionV3,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{boxes:o,scores:r}=t,{maxOutputSize:i,iouThreshold:l,scoreThreshold:d}=s;a(o,"NonMaxSuppression");const u=n.data.get(o.dataId).values,c=n.data.get(r.dataId).values,{selectedIndices:p}=Ca(u,c,i,l,d);return n.makeTensorInfo([p.length],"int32",new Int32Array(p))}},Ha=t.kernel_impls.nonMaxSuppressionV4Impl;const Ra={kernelName:t.NonMaxSuppressionV4,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{boxes:o,scores:r}=t,{maxOutputSize:i,iouThreshold:l,scoreThreshold:d,padToMaxOutputSize:u}=s;a(o,"NonMaxSuppressionPadded");const c=n.data.get(o.dataId).values,p=n.data.get(r.dataId).values,{selectedIndices:h,validOutputs:f}=Ha(c,p,i,l,d,u);return[n.makeTensorInfo([h.length],"int32",new Int32Array(h)),n.makeTensorInfo([],"int32",new Int32Array([f]))]}},Pa=t.kernel_impls.nonMaxSuppressionV5Impl;const Ba={kernelName:t.NonMaxSuppressionV5,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{boxes:o,scores:r}=t,{maxOutputSize:i,iouThreshold:l,scoreThreshold:d,softNmsSigma:u}=s;a(o,"NonMaxSuppressionWithScore");const c=n.data.get(o.dataId).values,p=n.data.get(r.dataId).values,h=i,f=l,m=d,k=u,{selectedIndices:b,selectedScores:g}=Pa(c,p,h,f,m,k);return[n.makeTensorInfo([b.length],"int32",new Int32Array(b)),n.makeTensorInfo([g.length],"float32",new Float32Array(g))]}};const $a={kernelName:t.OneHot,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{indices:r}=n,{depth:i,onValue:l,offValue:d}=o;a(r,"oneHot");const u=t.util.sizeFromShape(r.shape),c=new Float32Array(u*i);c.fill(d);const p=s.data.get(r.dataId).values;for(let e=0;e<u;++e)p[e]>=0&&p[e]<i&&(c[e*i+p[e]]=l);return s.makeTensorInfo([...r.shape,i],"int32",c)}};function Va(e){const{inputs:t,backend:n}=e,{x:a}=t;if("string"===a.dtype)throw new Error("zerosLike is not supported for string tensors");if("complex64"===a.dtype){const e=f({inputs:{input:a},backend:n}),t=Va({inputs:{x:e},backend:n}),s=Bt({inputs:{input:a},backend:n}),o=Va({inputs:{x:s},backend:n}),r=d({inputs:{real:t,imag:o},backend:n});return n.disposeIntermediateTensorInfo(e),n.disposeIntermediateTensorInfo(t),n.disposeIntermediateTensorInfo(s),n.disposeIntermediateTensorInfo(o),r}return Hn({backend:n,attrs:{shape:a.shape,value:0,dtype:a.dtype}})}const La={kernelName:t.ZerosLike,backendName:"cpu",kernelFunc:Va};const Oa={kernelName:t.OnesLike,backendName:"cpu",kernelFunc:function e(t){const{inputs:n,backend:a}=t,{x:s}=n;if("string"===s.dtype)throw new Error("onesLike is not supported for string tensors");if("complex64"===s.dtype){const t=f({inputs:{input:s},backend:a}),n=e({inputs:{x:t},backend:a}),o=Bt({inputs:{input:s},backend:a}),r=Va({inputs:{x:o},backend:a}),i=d({inputs:{real:n,imag:r},backend:a});return a.disposeIntermediateTensorInfo(t),a.disposeIntermediateTensorInfo(n),a.disposeIntermediateTensorInfo(o),a.disposeIntermediateTensorInfo(r),i}return Hn({backend:a,attrs:{shape:s.shape,value:1,dtype:s.dtype}})}};function qa(e){const{inputs:n,backend:a,attrs:s}=e,{axis:o}=s;if(1===n.length)return An({inputs:{input:n[0]},backend:a,attrs:{dim:o}});const r=n[0].shape,i=n[0].dtype;n.forEach(e=>{t.util.assertShapesMatch(r,e.shape,"All tensors passed to stack must have matching shapes"),t.util.assert(i===e.dtype,()=>"All tensors passed to stack must have matching dtypes")});const l=[],d=Vt({inputs:n.map(e=>{const t=An({inputs:{input:e},backend:a,attrs:{dim:o}});return l.push(t),t}),backend:a,attrs:{axis:o}});return l.forEach(e=>a.disposeIntermediateTensorInfo(e)),d}const Ga={kernelName:t.Pack,backendName:"cpu",kernelFunc:qa};const Ua={kernelName:t.PadV2,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r}=n,{paddings:i,constantValue:l}=o;a(r,"pad");const d=i.map((e,t)=>e[0]+r.shape[t]+e[1]),u=i.map(e=>e[0]),c=s.data.get(r.dataId).values,p=t.util.sizeFromShape(r.shape),h=r.shape.length,f=t.util.computeStrides(r.shape),m=t.util.sizeFromShape(d),k=d.length,b=t.util.computeStrides(d),g=t.util.getTypedArrayFromDType(r.dtype,m);0!==l&&g.fill(l);for(let e=0;e<p;e++){const n=t.util.indexToLoc(e,h,f).map((e,t)=>e+u[t]);g[t.util.locToIndex(n,k,b)]=c[e]}return{dataId:s.write(g,d,r.dtype),shape:d,dtype:r.dtype}}},Za=l((e,t)=>Math.pow(e,t)),ja=g(t.Pow,Za),Ka={kernelName:t.Pow,backendName:"cpu",kernelFunc:ja};const Ya={kernelName:t.Range,backendName:"cpu",kernelFunc:function(e){const{backend:t,attrs:n}=e,{start:a,stop:s,dtype:o,step:r}=n,i=ye(a,s,r,o);return t.makeTensorInfo([i.length],o,i)}},Ja=M(t.Reciprocal,e=>1/e),Qa={kernelName:t.Reciprocal,backendName:"cpu",kernelFunc:Ja};const Xa={kernelName:t.ResizeBilinear,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{images:r}=n,{alignCorners:i,halfPixelCenters:l,size:d}=o;a(r,"resizeBilinear");const u=t.util.computeStrides(r.shape),[c,p]=d,[h,f,m,k]=r.shape,b=s.data.get(r.dataId).values,g=new Float32Array(t.util.sizeFromShape([h,c,p,k])),I=[i&&c>1?f-1:f,i&&p>1?m-1:m],y=[i&&c>1?c-1:c,i&&p>1?p-1:p];let N=0;const x=I[0]/y[0],T=I[1]/y[1];for(let e=0;e<h;e++)for(let t=0;t<c;t++){let n;n=l?x*(t+.5)-.5:x*t;const a=Math.max(0,Math.floor(n)),s=n-a,o=Math.min(f-1,Math.ceil(n)),r=e*u[0]+a*u[1],i=e*u[0]+o*u[1];for(let e=0;e<p;e++){let t;t=l?T*(e+.5)-.5:T*e;const n=Math.max(0,Math.floor(t)),a=t-n,o=Math.min(m-1,Math.ceil(t)),d=r+n*u[2],c=i+n*u[2],p=r+o*u[2],h=i+o*u[2];for(let e=0;e<k;e++){const t=b[d+e],n=b[c+e],o=t+(b[p+e]-t)*a,r=o+(n+(b[h+e]-n)*a-o)*s;g[N++]=r}}}return s.makeTensorInfo([h,c,p,k],"float32",g)}};const es={kernelName:t.ResizeBilinearGrad,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{images:r,dy:i}=n,{alignCorners:l}=o;a([i,r],"resizeBilinearGrad");const d=t.util.computeStrides(r.shape),[u,c,p,h]=r.shape,[,f,m]=i.shape,k=new Float32Array(u*c*p*h),b=[l&&f>1?c-1:c,l&&m>1?p-1:p],g=[l&&f>1?f-1:f,l&&m>1?m-1:m],I=b[0]/g[0],y=b[1]/g[1],N=s.data.get(i.dataId).values;let x=0;for(let e=0;e<u;e++){const t=e*d[0];for(let e=0;e<f;e++){const n=e*I,a=Math.floor(n),s=Math.min(Math.ceil(n),c-1),o=t+a*d[1],r=t+s*d[1],i=n-a,l=1-i;for(let e=0;e<m;e++){const t=e*y,n=Math.floor(t),a=Math.min(Math.ceil(t),p-1),s=t-n,u=1-s,c=o+n*d[2],f=o+a*d[2],m=r+n*d[2],b=r+a*d[2],g=l*u,I=l*s,T=i*u,S=i*s;for(let e=0;e<h;e++){const t=N[x++];k[c+e]+=t*g,k[f+e]+=t*I,k[m+e]+=t*T,k[b+e]+=t*S}}}}return s.makeTensorInfo([u,p,c,h],"float32",k)}};const ts={kernelName:t.ResizeNearestNeighbor,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{images:r}=n,{alignCorners:i,halfPixelCenters:l,size:d}=o;a(r,"resizeNearestNeighbor");const u=t.util.computeStrides(r.shape),[c,p]=d,[h,f,m,k]=r.shape,b=s.data.get(r.dataId).values,g=new Float32Array(h*c*p*k),I=[i&&c>1?f-1:f,i&&p>1?m-1:m],y=[i&&c>1?c-1:c,i&&p>1?p-1:p],N=I[0]/y[0],x=I[1]/y[1];let T=0;for(let e=0;e<h;e++){const t=e*u[0];for(let e=0;e<c;e++){const n=l?N*(e+.5):N*e;let a=Math.min(f-1,i?Math.round(n):Math.floor(n));l&&(a=Math.max(0,a));const s=t+a*u[1];for(let e=0;e<p;e++){const t=l?x*(e+.5):x*e;let n=Math.min(m-1,i?Math.round(t):Math.floor(t));l&&(n=Math.max(0,n));const a=s+n*u[2];for(let e=0;e<k;e++){const t=b[a+e];g[T++]=t}}}}return s.makeTensorInfo([h,c,p,k],r.dtype,g)}};const ns={kernelName:t.ResizeNearestNeighborGrad,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{images:r,dy:i}=n,{alignCorners:l}=o;a([i,r],"resizeNearestNeighborGrad");const d=t.util.computeStrides(r.shape),u=t.util.computeStrides(i.shape),[c,p,h,f]=r.shape,[,m,k]=i.shape,b=new Float32Array(c*p*h*f),g=s.data.get(i.dataId).values,I=[l&&m>1?p-1:p,l&&k>1?h-1:h],y=[l&&m>1?m-1:m,l&&k>1?k-1:k],N=I[0]/y[0],x=I[1]/y[1],T=1/N,S=1/x,F=2*Math.ceil(T)+2,v=2*Math.ceil(S)+2;for(let e=0;e<c;e++){const t=e*d[0];for(let e=0;e<p;e++){const n=t+e*d[1],a=Math.floor(e*T),s=Math.floor(a-F/2);for(let a=0;a<h;a++){const o=n+a*d[2],r=Math.floor(a*S),i=Math.floor(r-v/2);for(let n=0;n<f;n++){let r=0;for(let o=0;o<F;o++){const d=o+s;if(d<0||d>=m)continue;const c=t+d*u[1],f=d*N;if(e===Math.min(p-1,l?Math.round(f):Math.floor(f)))for(let e=0;e<v;e++){const t=e+i;if(t<0||t>=k)continue;const s=c+t*u[2],o=t*x;a===Math.min(h-1,l?Math.round(o):Math.floor(o))&&(r+=g[s+n])}}b[o+n]=r}}}}return s.makeTensorInfo(r.shape,r.dtype,b)}};const as={kernelName:t.Reverse,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r}=n,{dims:i}=o;a(r,"reverse");const l=r.shape.length,d=t.util.parseAxisParam(i,r.shape);if(0===l)return p({inputs:{x:r},backend:s});const u=new t.TensorBuffer(r.shape,r.dtype),c=s.bufferSync(r);for(let e=0;e<u.size;e++){const t=u.indexToLoc(e),n=t.slice();d.forEach(e=>n[e]=r.shape[e]-1-n[e]),u.set(c.get(...n),...t)}return s.makeTensorInfo(u.shape,u.dtype,u.values)}},ss={kernelName:t.RotateWithOffset,backendName:"cpu",kernelFunc:({inputs:e,attrs:n,backend:a})=>{const{image:s}=e,{radians:o,fillValue:r,center:i}=n,l=a,d=t.util.getTypedArrayFromDType(s.dtype,t.util.sizeFromShape(s.shape)),[u,c,p,h]=s.shape,[f,m]=t.backend_util.getImageCenter(i,c,p),k=Math.sin(o),b=Math.cos(o),g=l.data.get(s.dataId).values;for(let e=0;e<u;e++){const t=e*p*c*h;for(let e=0;e<c;e++){const n=e*(p*h);for(let a=0;a<p;a++){const s=a*h;for(let o=0;o<h;o++){const i=[u,e,a,o],l=i[2],I=i[1];let y=(l-f)*b-(I-m)*k,N=(l-f)*k+(I-m)*b;y=Math.round(y+f),N=Math.round(N+m);let x=r;if("number"!=typeof r&&(x=3===o?255:r[o]),y>=0&&y<p&&N>=0&&N<c){x=g[t+N*(p*h)+y*h+o]}d[t+n+s+o]=x}}}}return{dataId:l.write(d,s.shape,s.dtype),shape:s.shape,dtype:s.dtype}}},os=M(t.Round,e=>{const t=Math.floor(e);return e-t<.5?Math.floor(e):e-t>.5?Math.ceil(e):t%2==0?t:t+1}),rs={kernelName:t.Round,backendName:"cpu",kernelFunc:os};function is(e,n,a,s,o,r,i,l,d,u){const c=[s/o,o],p=e.values,h=n.values;if(0===s)return t.buffer(a,n.dtype);const f=t.buffer(c,n.dtype);f.values.fill(d);for(let e=0;e<r;e++){const t=[];let r=0;for(let n=0;n<i;n++){const a=p[e*i+n];t.push(a),r+=a*l[n]}if(r<0||r>=s/o)throw new Error(`Invalid indices: ${t} does not index into ${a}`);for(let t=0;t<o;t++)u?f.values[r*o+t]+=h[e*o+t]:f.values[r*o+t]=0===n.rank?h[0]:h[e*o+t]}return f}const ls={kernelName:t.ScatterNd,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{indices:o,updates:r}=n,{shape:i}=s,{sliceRank:l,numUpdates:d,sliceSize:u,strides:c,outputSize:p}=t.backend_util.calculateShapes(r,o,i),h=is(a.bufferSync(o),a.bufferSync(r),i,p,u,d,l,c,0,!0);return a.makeTensorInfo(i,h.dtype,h.values)}};const ds={kernelName:t.Select,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s}=e,{condition:o,t:r,e:i}=n;a([o,r,i],"select");const l=o.shape.length,d=s.data.get(o.dataId).values,u=s.data.get(r.dataId).values,c=s.data.get(i.dataId).values,p=t.upcastType(r.dtype,i.dtype),h=t.util.makeZerosTypedArray(t.util.sizeFromShape(r.shape),p);let f=0;const m=0===l||l>1||1===r.shape.length?1:t.util.sizeFromShape(r.shape.slice(1));for(let e=0;e<d.length;e++)for(let t=0;t<m;t++)1===d[e]?h[f++]=u[e]:h[f++]=c[e];return s.makeTensorInfo(r.shape,p,h)}},us=t.backend_util.SELU_SCALEALPHA,cs=t.backend_util.SELU_SCALE,ps=M(t.Selu,e=>e>=0?cs*e:us*(Math.exp(e)-1)),hs={kernelName:t.Selu,backendName:"cpu",kernelFunc:ps},fs=M(t.Sign,e=>e<0?-1:e>0?1:0),ms={kernelName:t.Sign,backendName:"cpu",kernelFunc:fs},ks=M(t.Sin,e=>Math.sin(e)),bs={kernelName:t.Sin,backendName:"cpu",kernelFunc:ks},gs=M(t.Sinh,e=>Math.sinh(e)),Is={kernelName:t.Sinh,backendName:"cpu",kernelFunc:gs},ys=Math.log(1.1920928955078125e-7)+2,Ns=M(t.Softplus,e=>{const t=e>-ys,n=e<ys,a=Math.exp(e);let s;return s=n?a:t?e:Math.log(1+a),s}),xs={kernelName:t.Softplus,backendName:"cpu",kernelFunc:Ns};const Ts={kernelName:t.SpaceToBatchND,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r}=n,{blockShape:i,paddings:l}=o;a([r],"spaceToBatchND");const d=t.util.sizeFromShape(i),u=[[0,0]];u.push(...l);for(let e=1+i.length;e<r.shape.length;++e)u.push([0,0]);const c=Ua.kernelFunc({inputs:{x:r},backend:s,attrs:{paddings:u,constantValue:0}}),p=t.backend_util.getReshaped(c.shape,i,d,!1),h=t.backend_util.getPermuted(p.length,i.length,!1),f=t.backend_util.getReshapedPermuted(c.shape,i,d,!1),m=tt({inputs:{x:c},backend:s,attrs:{shape:p}}),k=ke({inputs:{x:m},backend:s,attrs:{perm:h}}),b=tt({inputs:{x:k},backend:s,attrs:{shape:f}});return s.disposeIntermediateTensorInfo(c),s.disposeIntermediateTensorInfo(m),s.disposeIntermediateTensorInfo(k),b}};const Ss={kernelName:t.SparseFillEmptyRows,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{indices:a,values:s,denseShape:o,defaultValue:r}=t;if(1!==o.shape.length)throw new Error("Dense shape must be a vector, saw:\n        "+o.shape);if(2!==a.shape.length)throw new Error("Indices must be a matrix, saw:\n        "+a.shape);if(1!==s.shape.length)throw new Error("Values must be a vector, saw:\n        "+s.shape);if(0!==r.shape.length)throw new Error("Default value must be a scalar, saw:\n        "+r.shape);const i=n.data.get(a.dataId).values,l=n.data.get(s.dataId).values,d=n.data.get(o.dataId).values,u=n.data.get(r.dataId).values[0],[c,p,h,f,m]=Me(i,a.shape,a.dtype,l,s.dtype,d,u);return[n.makeTensorInfo(p,a.dtype,c),n.makeTensorInfo([p[0]],s.dtype,h),n.makeTensorInfo([f.length],"bool",new Uint8Array(f.map(e=>Number(e)))),n.makeTensorInfo([m.length],a.dtype,new Int32Array(m))]}};const Fs={kernelName:t.SparseReshape,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{inputIndices:a,inputShape:s,newShape:o}=t;if(2!==a.shape.length)throw new Error("Input indices should be a matrix but received shape\n        "+a.shape);if(1!==s.shape.length)throw new Error("Input shape should be a vector but received shape\n        "+s.shape);if(1!==o.shape.length)throw new Error("Target shape should be a vector but received shape "+o.shape);const r=Array.from(n.data.get(s.dataId).values),i=n.data.get(a.dataId).values,l=Array.from(n.data.get(o.dataId).values),[d,u,c]=Ae(i,a.shape,a.dtype,r,l);return[n.makeTensorInfo(u,a.dtype,d),n.makeTensorInfo([c.length],o.dtype,new Int32Array(c))]}};const vs={kernelName:t.SparseToDense,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{sparseIndices:o,sparseValues:r,defaultValue:i}=n,{outputShape:l}=s,{sliceRank:d,numUpdates:u,sliceSize:c,strides:p,outputSize:h}=t.backend_util.calculateShapes(r,o,l),f=is(a.bufferSync(o),a.bufferSync(r),l,h,c,u,d,p,a.data.get(i.dataId).values[0],!1);return a.makeTensorInfo(l,f.dtype,f.values)}};const Ms={kernelName:t.SplitV,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{x:o}=n,{numOrSizeSplits:r,axis:i}=s,l=t.util.parseAxisParam(i,o.shape)[0],d=t.backend_util.prepareSplitSize(o,r,l),u=new Array(o.shape.length).fill(0),c=o.shape.slice();return d.map(e=>{const t=[...c];t[l]=e;const n=Fe({inputs:{x:o},backend:a,attrs:{begin:u,size:t}});return u[l]+=e,n})}},As=M(t.Sqrt,e=>Math.sqrt(e)),Ds={kernelName:t.Sqrt,backendName:"cpu",kernelFunc:As},ws={kernelName:t.Square,backendName:"cpu",kernelFunc:({inputs:e,backend:t})=>{const{x:n}=e,s=t;a(n,"square");const o=s.data.get(n.dataId).values,r=new Float32Array(o.length);for(let e=0;e<o.length;++e){const t=o[e];r[e]=t*t}return{dataId:s.write(r,n.shape,n.dtype),shape:n.shape,dtype:n.dtype}}},_s=M(t.Step,(e,t)=>{const n=t;return isNaN(e)?NaN:e>0?1:n.alpha}),zs={kernelName:t.Step,backendName:"cpu",kernelFunc:_s};const Es={kernelName:t.StridedSlice,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r}=n,{begin:i,end:l,strides:d,beginMask:u,endMask:c,ellipsisMask:p,newAxisMask:h,shrinkAxisMask:f}=o;a(r,"stridedSlice");const{nonStrided:m,$begin:k,$strides:b,size:g,newShape:I,outShape:y}=t.slice_util.sliceInfo(r.shape,i,l,d,u,c,p,h,f),N=tt({inputs:{x:r},backend:s,attrs:{shape:I}});let x;if(m){const e=Fe({inputs:{x:N},backend:s,attrs:{begin:k,size:g}});x=tt({inputs:{x:e},backend:s,attrs:{shape:y}}),s.disposeIntermediateTensorInfo(e)}else if(y.some(e=>0===e))x=s.makeTensorInfo(y,r.dtype,[]);else{const e=ze(y,s.bufferSync(N),b,k);x=s.makeTensorInfo(e.shape,e.dtype,e.values)}const T=tt({inputs:{x:x},backend:s,attrs:{shape:y}});return s.disposeIntermediateTensorInfo(N),s.disposeIntermediateTensorInfo(x),T}},Cs=M(t.Tan,e=>Math.tan(e)),Ws={kernelName:t.Tan,backendName:"cpu",kernelFunc:Cs},Hs=M(t.Tanh,e=>Math.tanh(e)),Rs={kernelName:t.Tanh,backendName:"cpu",kernelFunc:Hs};const Ps={kernelName:t.Tile,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:o}=t,{reps:r}=s;a(o,"tile");const i=Re(n.bufferSync(o),r);return n.makeTensorInfo(i.shape,i.dtype,i.values)}};const Bs={kernelName:t.TopK,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:o}=t,{k:r,sorted:i}=s;a(o,"topk");const l=n.data.get(o.dataId).values,[d,u]=Pe(l,o.shape,o.dtype,r);return[n.makeTensorInfo(d.shape,d.dtype,d.values),n.makeTensorInfo(u.shape,u.dtype,u.values)]}};const $s={kernelName:t.Transform,backendName:"cpu",kernelFunc:function(e){const{inputs:n,attrs:a,backend:s}=e,{image:o,transforms:r}=n,{interpolation:i,fillMode:l,fillValue:d,outputShape:u}=a,[c,p,h,f]=o.shape,[m,k]=null!=u?u:[p,h],b=[c,m,k,f],g=t.util.computeStrides(o.shape),I=g[0],y=g[1],N=g[2],x=t.util.getTypedArrayFromDType(o.dtype,t.util.sizeFromShape(b));x.fill(d);const T=s.data.get(o.dataId).values,S=s.data.get(r.dataId).values;for(let e=0;e<c;++e){const t=1===r.shape[0]?S:S.subarray(8*e,8*e+8);for(let n=0;n<m;++n)for(let a=0;a<k;++a)for(let s=0;s<f;++s){let o;const r=t[6]*a+t[7]*n+1;if(0===r)continue;const u=(t[0]*a+t[1]*n+t[2])/r,c=(t[3]*a+t[4]*n+t[5])/r,f=Vs(u,h,l),m=Vs(c,p,l);switch(i){case"nearest":o=Os(T,p,h,I,y,N,e,m,f,s,d);break;case"bilinear":o=qs(T,p,h,I,y,N,e,m,f,s,d);break;default:throw new Error("Error in Transform: Expect 'nearest' or 'bilinear', but got "+i)}x[e*I+n*y+a*N+s]=o}return s.makeTensorInfo(b,o.dtype,x)}return{dataId:s.write(x,b,o.dtype),shape:o.shape,dtype:o.dtype}}};function Vs(e,n,a){switch(a){case"reflect":return function(e,n){let a=e;if(a<0)if(n<=1)a=0;else{const e=2*n;a<e&&(a=e*Math.trunc(-a/e)+a),a=a<-n?a+e:-a-1}else if(a>n-1)if(n<=1)a=0;else{const e=2*n;a-=e*Math.trunc(a/e),a>=n&&(a=e-a-1)}return t.util.clamp(0,a,n-1)}(e,n);case"wrap":return function(e,n){let a=e;if(a<0)if(n<=1)a=0;else{const e=n-1;a+=n*(Math.trunc(-a/e)+1)}else if(a>n-1)if(n<=1)a=0;else{const e=n-1;a-=n*Math.trunc(a/e)}return t.util.clamp(0,a,n-1)}(e,n);case"nearest":return function(e,n){return t.util.clamp(0,e,n-1)}(e,n);case"constant":default:return function(e,t){return e}(e)}}function Ls(e,t,n,a,s,o,r,i,l,d,u){return 0<=i&&i<t&&0<=l&&l<n?e[r*a+i*s+l*o+d]:u}function Os(e,t,n,a,s,o,r,i,l,d,u){return Ls(e,t,n,a,s,o,r,Math.round(i),Math.round(l),d,u)}function qs(e,t,n,a,s,o,r,i,l,d,u){const c=Math.floor(i),p=Math.floor(l),h=c+1,f=p+1;return(h-i)*((f-l)*Ls(e,t,n,a,s,o,r,c,p,d,u)+(l-p)*Ls(e,t,n,a,s,o,r,c,f,d,u))+(i-c)*((f-l)*Ls(e,t,n,a,s,o,r,h,p,d,u)+(l-p)*Ls(e,t,n,a,s,o,r,h,f,d,u))}const Gs={kernelName:t.Unique,backendName:"cpu",kernelFunc:function(e){const{inputs:t,attrs:n,backend:s}=e,{axis:o}=n,{x:r}=t;a(r,"unique");const i=s.data.get(r.dataId).values,{outputValues:l,outputShape:d,indices:u}=Be(i,o,r.shape,r.dtype);return[s.makeTensorInfo(d,r.dtype,l),s.makeTensorInfo([u.length],"int32",u)]}};const Us={kernelName:t.Unpack,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{value:s}=t;let{axis:o}=a;o<0&&(o+=s.shape.length);const r=s.shape.length,i=s.shape[o],l=new Array(r-1);let d=0;for(let e=0;e<r;e++)e!==o&&(l[d++]=s.shape[e]);const u=new Array(r).fill(0),c=s.shape.slice();c[o]=1;const p=new Array(i);for(let e=0;e<p.length;e++){u[o]=e;const t=Fe({inputs:{x:s},backend:n,attrs:{begin:u,size:c}});p[e]=tt({inputs:{x:t},backend:n,attrs:{shape:l}}),n.disposeIntermediateTensorInfo(t)}return p}};const Zs={kernelName:t.UnsortedSegmentSum,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:o}=e,{x:r,segmentIds:i}=n,{numSegments:l}=o;a(r,"unsortedSegmentSum");const d=[],u=[],c=r.shape.length-i.shape.length;let p=i;for(let e=0;e<c;++e){const t=An({inputs:{input:p},backend:s,attrs:{dim:e+1}});p=t,u.push(t)}for(let e=0;e<l;++e){const n=t.util.createScalarValue(e,"int32"),a=s.makeTensorInfo([],"int32",n),o=gn({inputs:{a:a,b:p},backend:s}),i=k({inputs:{x:o},backend:s,attrs:{dtype:"float32"}}),l=le({inputs:{a:i,b:r},backend:s}),c=hn({inputs:{x:l},backend:s,attrs:{axis:0,keepDims:!1}});d.push(c),u.push(a),u.push(o),u.push(i),u.push(l),u.push(c)}const h=qa({inputs:d,backend:s,attrs:{axis:0}});return u.forEach(e=>s.disposeIntermediateTensorInfo(e)),h}},js=[ot,i,it,dt,T,ut,ct,pt,ht,ft,kt,gt,yt,Tt,Ft,Dt,wt,_t,zt,st,Et,Ct,Wt,b,_,Rt,u,Pt,Lt,Gt,Ut,qt,jt,Kt,Zt,Jt,Xt,en,tn,nn,an,on,rn,ln,dn,un,pn,cn,zn,mn,Le,kn,In,Mn,W,Dn,P,Wn,Rn,Pn,V,Vn,Ln,On,qn,Gn,G,jn,h,Kn,$t,Jn,Xn,ta,qe,j,sa,oa,Q,ia,ua,pa,ma,ka,ba,ne,ya,Na,xa,Ta,Sa,Ia,Fa,va,oe,Ma,wa,Ea,de,ce,Wa,Ra,Ba,fe,$a,Oa,Ga,Ua,Ka,Ze,Ie,Ya,m,Qa,Ke,Je,nt,Xa,es,ts,ns,as,ss,rs,Te,ls,ds,hs,Xe,ms,bs,Is,ve,za,xs,Ts,Ss,Fs,vs,Ms,Ds,ws,_e,zs,Es,He,fn,Ws,Rs,Ps,Bs,be,$s,Gs,Us,Zs,La];for(const e of js)t.registerKernel(e);e.MathBackendCPU=o,e.shared=$e,e.version_cpu="3.6.0",Object.defineProperty(e,"__esModule",{value:!0})}));
//# sourceMappingURL=tf-backend-cpu.es2017.min.js.map
