/**
 * @license
 * Copyright 2021 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
import{util as e,kernel_impls as t,KernelBackend as n,DataStorage as a,engine as s,env as o,backend_util as r,buffer as i,Abs as d,Complex as c,Identity as l,Real as p,Cast as u,Add as h,Ceil as f,Exp as m,Expm1 as k,Floor as I,Greater as g,Less as b,Log as y,Maximum as N,Minimum as x,Multiply as T,Neg as F,NotEqual as S,Transpose as v,upcastType as M,Prod as A,Rsqrt as w,slice_util as D,Slice as z,SquaredDifference as W,Sub as H,TensorBuffer as E,registerBackend as C,Elu as P,LeakyRelu as R,Prelu as $,Relu as O,Relu6 as V,Sigmoid as _,Reshape as B,BatchMatMul as L,_FusedMatMul as q,Acos as G,Acosh as U,AddN as Z,All as j,Any as K,ArgMax as Y,ArgMin as J,Asin as Q,Asinh as X,Atan as ee,Atan2 as te,Atanh as ne,AvgPool as ae,AvgPool3D as se,AvgPool3DGrad as oe,AvgPoolGrad as re,FusedBatchNorm as ie,BatchToSpaceND as de,Bincount as ce,ClipByValue as le,ComplexAbs as pe,Imag as ue,Concat as he,Conv2D as fe,Conv2DBackpropFilter as me,Conv2DBackpropInput as ke,Conv3D as Ie,Conv3DBackpropFilterV2 as ge,Conv3DBackpropInputV2 as be,Cos as ye,Cosh as Ne,CropAndResize as xe,Cumsum as Te,DenseBincount as Fe,DepthToSpace as Se,DepthwiseConv2dNative as ve,DepthwiseConv2dNativeBackpropFilter as Me,DepthwiseConv2dNativeBackpropInput as Ae,Diag as we,Dilation2D as De,Dilation2DBackpropFilter as ze,Dilation2DBackpropInput as We,Sum as He,Einsum as Ee,EluGrad as Ce,Equal as Pe,Erf as Re,ExpandDims as $e,RealDiv as Oe,FFT as Ve,Fill as _e,FlipLeftRight as Be,FloorDiv as Le,FusedConv2D as qe,FusedDepthwiseConv2D as Ge,GatherNd as Ue,GatherV2 as Ze,GreaterEqual as je,IFFT as Ke,IsFinite as Ye,IsInf as Je,IsNan as Qe,LessEqual as Xe,LinSpace as et,Log1p as tt,LogicalAnd as nt,LogicalNot as at,LogicalOr as st,LRN as ot,LRNGrad as rt,Max as it,MaxPool as dt,MaxPool3D as ct,MaxPool3DGrad as lt,MaxPoolGrad as pt,MaxPoolWithArgmax as ut,Mean as ht,Min as ft,MirrorPad as mt,Mod as kt,Softmax as It,Multinomial as gt,NonMaxSuppressionV3 as bt,NonMaxSuppressionV4 as yt,NonMaxSuppressionV5 as Nt,OneHot as xt,ZerosLike as Tt,OnesLike as Ft,Pack as St,PadV2 as vt,Pow as Mt,Range as At,Reciprocal as wt,ResizeBilinear as Dt,ResizeBilinearGrad as zt,ResizeNearestNeighbor as Wt,ResizeNearestNeighborGrad as Ht,Reverse as Et,RotateWithOffset as Ct,Round as Pt,ScatterNd as Rt,Select as $t,Selu as Ot,Sign as Vt,Sin as _t,Sinh as Bt,Softplus as Lt,SpaceToBatchND as qt,SparseFillEmptyRows as Gt,SparseReshape as Ut,SparseToDense as Zt,SplitV as jt,Sqrt as Kt,Square as Yt,Step as Jt,StridedSlice as Qt,Tan as Xt,Tanh as en,Tile as tn,TopK as nn,Transform as an,Unique as sn,Unpack as on,UnsortedSegmentSum as rn,registerKernel as dn}from"@tensorflow/tfjs-core";import{alea as cn}from"seedrandom";function ln(t,n){Array.isArray(t)||(t=[t]),t.forEach(t=>{null!=t&&e.assert("complex64"!==t.dtype,()=>n+" does not support complex64 tensors in the CPU backend.")})}const pn=t.whereImpl;class un extends n{constructor(){super(),this.blockSize=48,this.firstUse=!0,this.data=new a(this,s())}nextDataId(){return un.nextDataId++}write(e,t,n){this.firstUse&&(this.firstUse=!1,o().get("IS_NODE")&&r.warn("\n============================\nHi there 👋. Looks like you are running TensorFlow.js in Node.js. To speed things up dramatically, install our node backend, which binds to TensorFlow C++, by running npm i @tensorflow/tfjs-node, or npm i @tensorflow/tfjs-node-gpu if you have CUDA. Then call require('@tensorflow/tfjs-node'); (-gpu suffix for CUDA) at the start of your program. Visit https://github.com/tensorflow/tfjs-node for more details.\n============================"));const a={id:this.nextDataId()};return this.data.set(a,{values:e,dtype:n,refCount:1}),a}makeTensorInfo(t,n,a){let s;if("string"===n&&null!=a&&a.length>0&&e.isString(a[0])){const o=a.map(t=>e.encodeString(t));s=this.write(o,t,n)}else s=this.write(a,t,n);return{dataId:s,shape:t,dtype:n}}refCount(e){if(this.data.has(e)){return this.data.get(e).refCount}return 0}incRef(e){this.data.get(e).refCount++}decRef(e){if(this.data.has(e)){this.data.get(e).refCount--}}move(e,t,n,a,s){this.data.set(e,{values:t,dtype:a,refCount:s})}numDataIds(){return this.data.numDataIds()}async read(e){return this.readSync(e)}readSync(e){const{dtype:t,complexTensorInfos:n}=this.data.get(e);if("complex64"===t){const e=this.readSync(n.real.dataId),t=this.readSync(n.imag.dataId);return r.mergeRealAndImagArrays(e,t)}return this.data.get(e).values}bufferSync(t){const n=this.readSync(t.dataId);let a=n;if("string"===t.dtype)try{a=n.map(t=>e.decodeString(t))}catch(e){throw new Error("Failed to decode encoded string bytes into utf-8")}return i(t.shape,t.dtype,a)}makeOutput(e,t,n){const a=this.write(e,t,n);return s().makeTensorFromDataId(a,t,n,this)}disposeData(e,t=!1){if(this.data.has(e)){if(this.data.get(e).refCount--,!t&&this.data.get(e).refCount>0)return!1;const{complexTensorInfos:n}=this.data.get(e);null!=n&&(this.disposeData(n.real.dataId,!0),this.disposeData(n.imag.dataId,!0)),this.data.delete(e)}return!0}disposeIntermediateTensorInfo(e){this.disposeData(e.dataId)}async time(t){const n=e.now();t();return{kernelMs:e.now()-n}}memory(){return{unreliable:!0,reasons:["The reported memory is an upper bound. Due to automatic garbage collection, the true allocated memory may be less."]}}where(e){ln([e],"where");const t=this.readSync(e.dataId);return pn(e.shape,t)}dispose(){}floatPrecision(){return 32}epsilon(){return super.epsilon()}}function hn(e){const t=new Float32Array(e.length);for(let n=0;n<e.length;++n)t[n]=Math.abs(e[n]);return t}un.nextDataId=0;const fn={kernelName:d,backendName:"cpu",kernelFunc:t=>{const{x:n}=t.inputs,a=t.backend;ln(n,"abs");let s=new Float32Array(e.sizeFromShape(n.shape));return s=hn(a.data.get(n.dataId).values),a.makeOutput(s,n.shape,"float32")}};function mn(t){return(n,a,s,o,i)=>{const d=r.assertAndGetBroadcastShape(n,a),c=d.length,l=e.computeStrides(d),p=e.sizeFromShape(d),u=e.getTypedArrayFromDType(i,p),h=n.length,f=a.length,m=e.computeStrides(n),k=e.computeStrides(a),I=r.getBroadcastDims(n,d),g=r.getBroadcastDims(a,d);if(I.length+g.length===0)for(let e=0;e<u.length;++e)u[e]=t(s[e%s.length],o[e%o.length]);else for(let n=0;n<u.length;++n){const a=e.indexToLoc(n,c,l),r=a.slice(-h);I.forEach(e=>r[e]=0);const i=e.locToIndex(r,h,m),d=a.slice(-f);g.forEach(e=>d[e]=0);const p=e.locToIndex(d,f,k);u[n]=t(s[i],o[p])}return[u,d]}}function kn(e){const{inputs:t,backend:n}=e,{real:a,imag:s}=t,o=n.data.get(a.dataId).values,r=n.data.get(s.dataId).values,i=n.makeTensorInfo(a.shape,"complex64");return n.data.get(i.dataId).complexTensorInfos={real:n.makeTensorInfo(a.shape,"float32",o),imag:n.makeTensorInfo(s.shape,"float32",r)},i}const In={kernelName:c,backendName:"cpu",kernelFunc:kn};function gn(t,n,a="float32"){if("complex64"===a){return kn({inputs:{real:gn(t,n,"float32"),imag:gn(t,n,"float32")},backend:t})}const s=e.makeZerosTypedArray(e.sizeFromShape(n),a);return t.makeTensorInfo(n,a,s)}function bn(e){const{inputs:t,backend:n}=e,{x:a}=t;return n.incRef(a.dataId),{dataId:a.dataId,shape:a.shape,dtype:a.dtype}}const yn={kernelName:l,backendName:"cpu",kernelFunc:bn};function Nn(e){const{inputs:t,backend:n}=e,{input:a}=t,s=n.data.get(a.dataId).complexTensorInfos.real,o=n.data.get(s.dataId).values;return n.makeTensorInfo(s.shape,s.dtype,o)}const xn={kernelName:p,backendName:"cpu",kernelFunc:Nn};function Tn(t){const{inputs:n,backend:a,attrs:s}=t,{x:o}=n,{dtype:r}=s;if("complex64"===r){if("complex64"===o.dtype)return bn({inputs:{x:o},backend:a});const e=gn(a,o.shape,o.dtype),t=Tn({inputs:{x:o},backend:a,attrs:{dtype:"float32"}}),n=kn({inputs:{real:t,imag:e},backend:a});return a.disposeIntermediateTensorInfo(e),a.disposeIntermediateTensorInfo(t),n}if("complex64"===o.dtype){const e=Nn({inputs:{input:o},backend:a}),t=Tn({inputs:{x:e},backend:a,attrs:{dtype:r}});return a.disposeIntermediateTensorInfo(e),t}if(!e.hasEncodingLoss(o.dtype,r)){const e=bn({inputs:{x:o},backend:a});return{dataId:e.dataId,shape:e.shape,dtype:r}}if("int32"===r){const e=a.data.get(o.dataId).values,t=Int32Array.from(e);return a.makeTensorInfo(o.shape,"int32",t)}if("bool"===r){const t=a.data.get(o.dataId).values,n=e.toTypedArray([0],o.dtype),[s,r]=mn((e,t)=>e!==t?1:0)(o.shape,[],t,n,"bool");return a.makeTensorInfo(r,"bool",s)}throw new Error(`Error in Cast: failed to cast ${o.dtype} to ${r}`)}const Fn={kernelName:u,backendName:"cpu",kernelFunc:Tn};function Sn(e,t,n,a){return null==n?({inputs:n,backend:s})=>{const{a:o,b:r}=n,i=s;ln([o,r],e);const d=i.data.get(o.dataId).values,c=i.data.get(r.dataId).values,l=a||o.dtype,[p,u]=t(o.shape,r.shape,d,c,l);return i.makeTensorInfo(u,l,p)}:({inputs:e,backend:s})=>{const{a:o,b:r}=e,i=s;if("complex64"===o.dtype||"complex64"===r.dtype){const e=Tn({inputs:{x:o},backend:i,attrs:{dtype:"complex64"}}),t=i.data.get(e.dataId),a=t.complexTensorInfos.real,s=t.complexTensorInfos.imag,d=i.data.get(a.dataId).values,c=i.data.get(s.dataId).values,l=Tn({inputs:{x:r},backend:i,attrs:{dtype:"complex64"}}),p=i.data.get(l.dataId),u=p.complexTensorInfos.real,h=p.complexTensorInfos.imag,f=i.data.get(u.dataId).values,m=i.data.get(h.dataId).values,[k,I,g]=n(o.shape,r.shape,d,c,f,m),b=i.makeTensorInfo(g,"float32",k),y=i.makeTensorInfo(g,"float32",I),N=kn({inputs:{real:b,imag:y},backend:i});return i.disposeIntermediateTensorInfo(e),i.disposeIntermediateTensorInfo(l),i.disposeIntermediateTensorInfo(b),i.disposeIntermediateTensorInfo(y),N}{const e=i.data.get(o.dataId).values,n=i.data.get(r.dataId).values,s=a||o.dtype,[d,c]=t(o.shape,r.shape,e,n,s);return i.makeTensorInfo(c,s,d)}}}function vn(t){return(n,a,s,o,i,d)=>{const c=r.assertAndGetBroadcastShape(n,a),l=e.sizeFromShape(c),p=c.length,u=e.computeStrides(c),h=e.getTypedArrayFromDType("float32",l),f=e.getTypedArrayFromDType("float32",l),m=r.getBroadcastDims(n,c),k=r.getBroadcastDims(a,c),I=r.mergeRealAndImagArrays(s,o),g=r.mergeRealAndImagArrays(i,d),b=n.length,y=e.computeStrides(n),N=a.length,x=e.computeStrides(a);if(m.length+k.length===0)for(let e=0;e<h.length;e++){const n=e%I.length,a=e%g.length,s=t(I[2*n],I[2*n+1],g[2*a],g[2*a+1]);h[e]=s.real,f[e]=s.imag}else for(let n=0;n<h.length;n++){const a=e.indexToLoc(n,p,u),s=a.slice(-b);m.forEach(e=>s[e]=0);const o=e.locToIndex(s,b,y),r=a.slice(-N);k.forEach(e=>r[e]=0);const i=e.locToIndex(r,N,x),d=t(I[2*o],I[2*o+1],g[2*i],g[2*i+1]);h[n]=d.real,f[n]=d.imag}return[h,f,c]}}const Mn=mn((e,t)=>e+t),An=Sn(h,Mn,vn((e,t,n,a)=>({real:e+n,imag:t+a}))),wn={kernelName:h,backendName:"cpu",kernelFunc:An};function Dn(t,n,a,s,o){const r=e.sizeFromShape(s),i=e.makeZerosTypedArray(o,a);for(let e=0;e<t.length;e++){const a=t[e];if(a<0)throw new Error("Input x must be non-negative!");a>=o||(i[a]+=r>0?n[e]:1)}return i}function zn(e,t,n,a=!1){const s=e.shape[0],o=e.shape[1],r=i([s,n],t.dtype);for(let i=0;i<s;i++)for(let s=0;s<o;s++){const o=e.get(i,s);if(o<0)throw new Error("Input x must be non-negative!");o>=n||(a?r.set(1,i,o):t.size>0?r.set(r.get(i,o)+t.get(i,s),i,o):r.set(r.get(i,o)+1,i,o))}return r}function Wn(t){return(n,a,s)=>{const o=e.getTypedArrayFromDType(a,n.length);for(let e=0;e<n.length;++e)o[e]=t(n[e],s);return o}}function Hn(t,n,a){return({inputs:s,attrs:o,backend:r})=>{const{x:i}=s;if(ln(i,t),"string"===i.dtype||"string"===a)throw new Error("unaryKernelFunc does not support string input/output");const d=r,c=d.data.get(i.dataId).values,l=e.sizeFromShape(i.shape),p=a||i.dtype,u=e.getArrayFromDType(p,l);for(let e=0;e<l;++e)u[e]=n(c[e],o);return d.makeTensorInfo(i.shape,p,u)}}function En(e,t,n){return({inputs:a,attrs:s,backend:o})=>{const{x:r}=a;if(ln(r,e),"string"===r.dtype||"string"===n)throw new Error("unaryKernelFunc does not support string input/output");const i=o,d=i.data.get(r.dataId).values,c=n||r.dtype,l=t(d,c,s);return i.makeTensorInfo(r.shape,c,l)}}const Cn=Wn(e=>Math.ceil(e)),Pn={kernelName:f,backendName:"cpu",kernelFunc:En(f,Cn)};function Rn(t,n,a,s){const o=e.getArrayFromDType(a,e.sizeFromShape(n));if(s&&"string"!==a){let n=0;t.forEach(t=>{const a=e.sizeFromShape(t.shape);o.set(t.vals,n),n+=a})}else{let e=0;t.forEach(t=>{const s="string"===a?r.fromUint8ToStringArray(t.vals):t.vals;let i=0;for(let a=0;a<t.shape[0];++a){const r=a*n[1]+e;for(let e=0;e<t.shape[1];++e)o[r+e]=s[i++]}e+=t.shape[1]})}return o}const $n=Wn(e=>Math.exp(e)),On=En(m,$n),Vn={kernelName:m,backendName:"cpu",kernelFunc:On},_n=Wn(e=>Math.expm1(e)),Bn={kernelName:k,backendName:"cpu",kernelFunc:En(k,_n)},Ln=Wn(e=>Math.floor(e)),qn={kernelName:I,backendName:"cpu",kernelFunc:En(I,Ln)};function Gn(e,t,n){const a=i(n,e.dtype);for(let n=0;n<a.size;++n){const s=a.indexToLoc(n).slice(),o=s[0],r=s[2],i=t.locToIndex([o,r]);s[2]=t.values[i];const d=e.locToIndex(s);a.values[n]=e.values[d]}return a}const Un=mn((e,t)=>e>t?1:0),Zn={kernelName:g,backendName:"cpu",kernelFunc:Sn(g,Un,null,"bool")},jn=mn((e,t)=>e<t?1:0),Kn={kernelName:b,backendName:"cpu",kernelFunc:Sn(b,jn,null,"bool")};function Yn(t,n,a){const s=(n-t)/(a-1),o=e.makeZerosTypedArray(a,"float32");o[0]=t;for(let e=1;e<o.length;e++)o[e]=o[e-1]+s;return o}const Jn=Wn(e=>Math.log(e)),Qn={kernelName:y,backendName:"cpu",kernelFunc:En(y,Jn)};function Xn(t,n,a,s){const o=e.getTypedArrayFromDType(s,e.sizeFromShape(a));for(let e=0;e<o.length;++e){const a=e*n;let s=t[a];for(let e=0;e<n;++e){const n=t[a+e];n>s&&(s=n)}o[e]=s}return o}const ea=mn((e,t)=>Math.max(e,t)),ta={kernelName:N,backendName:"cpu",kernelFunc:Sn(N,ea)},na=mn((e,t)=>Math.min(e,t)),aa={kernelName:x,backendName:"cpu",kernelFunc:Sn(x,na)},sa=mn((e,t)=>e*t),oa=vn((e,t,n,a)=>({real:e*n-t*a,imag:e*a+t*n})),ra=Sn(T,sa,oa),ia={kernelName:T,backendName:"cpu",kernelFunc:ra};function da(t,n,a){const s=e.createScalarValue(-1,a);return sa([],n,s,t,a)}const ca={kernelName:F,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{x:a}=t;ln(a,"neg");const s=n.data.get(a.dataId).values,[o,r]=da(s,a.shape,a.dtype);return n.makeTensorInfo(r,a.dtype,o)}},la=mn((e,t)=>e!==t?1:0),pa={kernelName:S,backendName:"cpu",kernelFunc:Sn(S,la,null,"bool")};function ua(t,n,a,s,o){const r=n.length,i=e.sizeFromShape(n),d=e.computeStrides(n),c=e.computeStrides(o),l=e.getTypedArrayFromDType(a,e.sizeFromShape(o));for(let n=0;n<i;++n){const a=e.indexToLoc(n,r,d),o=new Array(a.length);for(let e=0;e<o.length;e++)o[e]=a[s[e]];l[e.locToIndex(o,r,c)]=t[n]}return l}function ha(e){const{inputs:t,attrs:n,backend:a}=e,{x:s}=t,{perm:o}=n;ln(s,"transpose");const r=s.shape.length,i=new Array(r);for(let e=0;e<i.length;e++)i[e]=s.shape[o[e]];const d=ua(a.data.get(s.dataId).values,s.shape,s.dtype,o,i);return{dataId:a.write(d,i,s.dtype),shape:i,dtype:s.dtype}}const fa={kernelName:v,backendName:"cpu",kernelFunc:ha};function ma(t,n,a,s){const[o,i]=r.computeOutAndReduceShapes(t,s),d=M(n,"int32"),c=e.makeZerosTypedArray(e.sizeFromShape(o),d),l=e.sizeFromShape(i);for(let e=0;e<c.length;++e){const t=e*l;let n=1;for(let e=0;e<l;++e)n*=a[t+e];c[e]=n}return{outVals:c,outShape:o,outDtype:d}}const ka={kernelName:A,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o}=n,{axis:i,keepDims:d}=s;ln(o,"prod");const c=o.shape.length,l=e.parseAxisParam(i,o.shape),p=r.getAxesPermutation(l,c);let u=l,h=o;const f=[];null!=p&&(h=ha({inputs:{x:o},backend:a,attrs:{perm:p}}),f.push(h),u=r.getInnerMostAxes(u.length,c));const m=a.data.get(h.dataId).values,{outVals:k,outShape:I,outDtype:g}=ma(h.shape,h.dtype,m,u);let b=I;return d&&(b=r.expandShapeToKeepDim(I,l)),f.forEach(e=>a.disposeIntermediateTensorInfo(e)),a.makeTensorInfo(b,g,k)}};function Ia(t,n,a,s){if(t===n||t<n&&a<0||n<t&&a>1)return e.makeZerosTypedArray(0,s);const o=Math.abs(Math.ceil((n-t)/a)),r=e.makeZerosTypedArray(o,s);n<t&&1===a&&(a=-1),r[0]=t;for(let e=1;e<r.length;e++)r[e]=r[e-1]+a;return r}const ga=Wn(e=>1/Math.sqrt(e)),ba={kernelName:w,backendName:"cpu",kernelFunc:En(w,ga)};function ya(t,n,a,s,o){const d=D.isSliceContinous(s,n,a),c=e.sizeFromShape(a),l=e.computeStrides(s);if(d){const e=D.computeFlatOffset(n,l);return"string"===o?t.slice(e,e+c):t.subarray(e,e+c)}const p="string"===o?r.fromUint8ToStringArray(t):t,u=i(s,o,p),h=i(a,o);for(let e=0;e<h.size;++e){const t=h.indexToLoc(e),a=t.map((e,t)=>e+n[t]);h.set(u.get(...a),...t)}return"string"===o?r.fromStringArrayToUint8(h.values):h.values}function Na(e){const{inputs:t,backend:n,attrs:a}=e,{x:s}=t,{begin:o,size:r}=a;ln(s,"slice");const[i,d]=D.parseSliceParams(s,o,r);D.assertParamsValid(s,i,d);const c=ya(n.data.get(s.dataId).values,i,d,s.shape,s.dtype);return n.makeTensorInfo(d,s.dtype,c)}const xa={kernelName:z,backendName:"cpu",kernelFunc:Na};function Ta(t,n,a,s,o,r,i){const d=n[0],c=r[0],l=new Array(c),p=new Array(d),u=n[1];if(0===c){if(0!==d)throw new Error("Received SparseTensor with denseShape[0] = 0 but\n         indices.shape[0] = "+d);return[e.getArrayFromDType(a,0),[0,u],e.getArrayFromDType(o,0),l,p]}let h=!0,f=0;const m=new Array(c).fill(0);for(let e=0;e<d;++e){const n=t[e*u];if(n<0)throw new Error(`indices(${e}, 0) is invalid: ${n} < 0`);if(n>=c)throw new Error(`indices(${e}, 0) is invalid: ${n} >= ${c}`);++m[n],h=h&&n>=f,f=n}let k=!0;for(let e=0;e<c;++e){const t=0===m[e];l[e]=t,k=k&&!t,m[e]=Math.max(m[e],1),e>0&&(m[e]+=m[e-1])}if(k&&h){const e=t,n=s;for(let e=0;e<d;++e)p[e]=e;return[e,[d,u],n,l,p]}{const n=m[c-1],r=e.getArrayFromDType(a,n*u),h=e.getArrayFromDType(o,n),f=new Array(c).fill(0);for(let e=0;e<d;++e){const n=t[e*u],a=f[n],o=(0===n?0:m[n-1])+a;f[n]++;for(let n=0;n<u;++n)r[o*u+n]=t[e*u+n];h[o]=s[e],p[e]=o}for(let e=0;e<c;++e){if(0===f[e]){const t=0===e?0:m[e-1];r[t*u+0]=e;for(let e=1;e<u;++e)r[t*u+e]=0;h[t]=i}}return[r,[d,u],h,l,p]}}function Fa(t,n,a,s,o){const r=e.sizeFromShape(s),i=n[0],d=o.length,c=[];let l=1,p=-1;for(let e=0;e<d;++e){const t=o[e];if(-1===t){if(-1!==p)throw new Error(`only one output dimension may be -1, not both ${p} and ${e}`);p=e,c.push(1)}else{if(t<0)throw new Error(`size ${e} must be non-negative, not ${t}`);l*=t,c.push(t)}}if(-1!==p){if(l<=0)throw new Error("reshape cannot infer the missing input size for an empty tensor unless all specified input sizes are non-zero");const e=Math.trunc(r/l);if(l*e!==r)throw new Error(`Input to reshape is a SparseTensor with ${r}\n          dense values, but the requested shape requires a multiple of ${l}. inputShape=${s} outputShape= ${c}`);c[p]=e}const u=e.sizeFromShape(c);if(u!==r)throw new Error(`Input to reshape is a tensor with ${r} dense values, but the requested shape has ${u}. inputShape=${s} outputShape=${c}`);const h=s.length,f=[];if(h>0){f[h-1]=1;for(let e=h-2;e>=0;--e)f[e]=f[e+1]*s[e+1]}const m=[];if(d>0){m[d-1]=1;for(let e=d-2;e>=0;--e)m[e]=m[e+1]*c[e+1]}const k=e.getArrayFromDType(a,i*d);for(let e=0;e<i;++e){let n=0;for(let a=0;a<h;++a)n+=t[e*h+a]*f[a];for(let t=0;t<d;++t)k[e*d+t]=Math.trunc(n/m[t]),n%=m[t]}return[k,[i,d],c]}const Sa=mn((e,t)=>{const n=e-t;return n*n}),va={kernelName:W,backendName:"cpu",kernelFunc:Sn(W,Sa)};function Ma(e,t,n,a){const s=i(e,t.dtype);for(let e=0;e<s.size;e++){const o=s.indexToLoc(e),r=new Array(o.length);for(let e=0;e<r.length;e++)r[e]=o[e]*n[e]+a[e];s.set(t.get(...r),...o)}return s}const Aa=mn((e,t)=>e-t),wa=Sn(H,Aa,vn((e,t,n,a)=>({real:e-n,imag:t-a}))),Da={kernelName:H,backendName:"cpu",kernelFunc:wa};function za(e,t){const n=new Array(e.rank);for(let a=0;a<n.length;a++)n[a]=e.shape[a]*t[a];const a=i(n,e.dtype);for(let t=0;t<a.values.length;++t){const n=a.indexToLoc(t),s=new Array(e.rank);for(let t=0;t<s.length;t++)s[t]=n[t]%e.shape[t];const o=e.locToIndex(s);a.values[t]=e.values[o]}return a}function Wa(t,n,a,s,o){const r=n[n.length-1],[d,c]=[t.length/r,r],l=e.getTypedArrayFromDType(a,d*s),p=e.getTypedArrayFromDType("int32",d*s);for(let e=0;e<d;e++){const n=e*c,a=t.subarray(n,n+c),o=[];for(let e=0;e<a.length;e++)o.push({value:a[e],index:e});o.sort((e,t)=>t.value-e.value);const r=e*s,i=l.subarray(r,r+s),d=p.subarray(r,r+s);for(let e=0;e<s;e++)i[e]=o[e].value,d[e]=o[e].index}const u=n.slice();return u[u.length-1]=s,[i(u,a,l),i(u,"int32",p)]}function Ha(t,n,a,s){const o=e.parseAxisParam(n,a)[0],r=[1,a[0],1];for(let e=0;e<o;e++)r[0]*=a[e];r[1]=a[o];for(let e=o+1;e<a.length;e++)r[2]*=a[e];const i={},d=new Int32Array(a[o]),c=new E(r,s,t),l=[],p=1===r[0]&&1===r[2];for(let e=0;e<a[o];e++){let n;if(p)n=t[e].toString();else{const t=[];for(let n=0;n<r[0];n++)for(let a=0;a<r[2];a++)t.push(c.get(n,e,a));n=t.join(",")}if(void 0!==i[n])d[e]=i[n];else{const t=Object.keys(i).length;i[n]=t,d[e]=t,l.push(e)}}const u=r.slice();u[1]=Object.keys(i).length;const h=new E(u,s);l.forEach((e,t)=>{for(let n=0;n<r[0];n++)for(let a=0;a<r[2];a++)h.set(c.get(n,e,a),n,t,a)});const f=a.slice();return f[o]=u[1],{outputValues:h.values,outputShape:f,indices:d}}var Ea=Object.freeze({__proto__:null,simpleAbsImpl:hn,addImpl:Mn,bincountImpl:Dn,bincountReduceImpl:zn,ceilImpl:Cn,concatImpl:Rn,expImpl:$n,expm1Impl:_n,floorImpl:Ln,gatherV2Impl:Gn,greaterImpl:Un,lessImpl:jn,linSpaceImpl:Yn,logImpl:Jn,maxImpl:Xn,maximumImpl:ea,minimumImpl:na,multiplyImpl:sa,negImpl:da,notEqualImpl:la,prodImpl:ma,rangeImpl:Ia,rsqrtImpl:ga,sliceImpl:ya,sparseFillEmptyRowsImpl:Ta,sparseReshapeImpl:Fa,squaredDifferenceImpl:Sa,stridedSliceImpl:Ma,subImpl:Aa,tileImpl:za,topKImpl:Wa,transposeImpl:ua,uniqueImpl:Ha});const Ca="3.6.0";C("cpu",()=>new un,1);const Pa=Hn(P,e=>e>=0?e:Math.exp(e)-1),Ra={kernelName:P,backendName:"cpu",kernelFunc:Pa};function $a(t){const{inputs:n,backend:a,attrs:s}=t,{x:o}=n,{alpha:r}=s;ln([o],"leakyRelu");const i=e.sizeFromShape(o.shape),d=a.data.get(o.dataId).values,c=e.getTypedArrayFromDType("float32",i);for(let e=0;e<d.length;e++)c[e]=d[e]<0?r*d[e]:d[e];return a.makeTensorInfo(o.shape,"float32",c)}const Oa={kernelName:R,backendName:"cpu",kernelFunc:$a},Va=mn((e,t)=>e<0?t*e:e);function _a(e){const{inputs:t,backend:n}=e,{x:a,alpha:s}=t;ln([a,s],"prelu");const o=n.data.get(a.dataId).values,r=n.data.get(s.dataId).values,[i,d]=Va(a.shape,s.shape,o,r,a.dtype);return n.makeTensorInfo(d,a.dtype,i)}const Ba={kernelName:$,backendName:"cpu",kernelFunc:_a},La=Hn(O,e=>Math.max(0,e)),qa={kernelName:O,backendName:"cpu",kernelFunc:La},Ga=Hn(V,e=>Math.min(Math.max(0,e),6)),Ua={kernelName:V,backendName:"cpu",kernelFunc:Ga},Za=Hn(_,e=>1/(1+Math.exp(-e))),ja={kernelName:_,backendName:"cpu",kernelFunc:Za};function Ka(e,t,n,a,s){if("linear"===n)return bn({inputs:{x:t},backend:e});if("relu"===n)return La({inputs:{x:t},backend:e});if("elu"===n)return Pa({inputs:{x:t},backend:e});if("relu6"===n)return Ga({inputs:{x:t},backend:e});if("prelu"===n)return _a({inputs:{x:t,alpha:a},backend:e});if("leakyrelu"===n)return $a({inputs:{x:t},backend:e,attrs:{alpha:s}});if("sigmoid"===n)return Za({inputs:{x:t},backend:e});throw new Error(`Activation ${n} has not been implemented for the CPU backend.`)}function Ya(t){const{inputs:n,backend:a,attrs:s}=t,{x:o}=n,{shape:r}=s,i=e.sizeFromShape(o.shape),d=e.inferFromImplicitShape(r,i),c=e.sizeFromShape(d);e.assert(i===c,()=>`The new shape (${d}) has ${c} elements and the old shape (${o.shape}) has ${i} elements. The new shape and old shape must have the same number of elements.`),a.incRef(o.dataId);const l=a.data.get(o.dataId);if(null!=l.complexTensorInfos){const e=l.complexTensorInfos.real,t=l.complexTensorInfos.imag;e.shape=d,t.shape=d}return{dataId:o.dataId,shape:d,dtype:o.dtype}}const Ja={kernelName:B,backendName:"cpu",kernelFunc:Ya};function Qa(t){const{inputs:n,backend:a,attrs:s}=t,{a:o,b:r}=n,{transposeA:d,transposeB:c}=s;ln([o,r],"matMul");const l=o.shape.length,p=r.shape.length,u=d?o.shape[l-2]:o.shape[l-1],h=c?r.shape[p-1]:r.shape[p-2],f=d?o.shape[l-1]:o.shape[l-2],m=c?r.shape[p-2]:r.shape[p-1],k=o.shape.slice(0,-2),I=r.shape.slice(0,-2),g=e.sizeFromShape(k),b=e.sizeFromShape(I),y=g===b||1===g||1===b;e.assert(l>=2&&p>=2&&y,()=>`Error in matMul: the input batch dimensions must either be the same or at least one input batch dimension must be 1. Got input batch dimensions of (${k}) and (${I}).`);const N=(g>b?o.shape.slice(0,-2):r.shape.slice(0,-2)).concat([f,m]);e.assert(u===h,()=>`Error in matMul: inner shapes (${u}) and (${h}) of Tensors with shapes ${o.shape} and ${r.shape} and transposeA=${d} and transposeB=${c} must match.`);const x=c?[b,m,h]:[b,h,m],T=Ya({inputs:{x:o},backend:a,attrs:{shape:d?[g,u,f]:[g,f,u]}}),F=Ya({inputs:{x:r},backend:a,attrs:{shape:x}}),S=d?T.shape[1]:T.shape[2],v=d?T.shape[2]:T.shape[1],M=c?F.shape[1]:F.shape[2],A=Math.max(g,b),w=a.data.get(T.dataId).values,D=a.data.get(F.dataId).values,z=e.computeStrides(T.shape),W=e.computeStrides(F.shape),[H,E,C]=d?[z[0],1,z[1]]:[z[0],z[1],1],[P,R,$]=c?[1,W[1],W[0]]:[W[1],1,W[0]],O=v*M,V=i([A,v,M],T.dtype),_=V.values,B=a.blockSize;for(let e=0;e<A;e++)for(let t=0;t<v;t+=B)for(let n=0;n<M;n+=B)for(let a=0;a<S;a+=B){const s=Math.min(t+B,v),o=Math.min(n+B,M),r=Math.min(a+B,S);for(let i=t;i<s;i++)for(let t=n;t<o;t++){let n=0;for(let s=a;s<r;s++){const a=Math.min(e,g-1)*H,o=Math.min(e,b-1)*$;n+=w[a+i*E+s*C]*D[s*P+t*R+o]}_[e*O+(i*M+t)]+=n}}return a.disposeIntermediateTensorInfo(T),a.disposeIntermediateTensorInfo(F),a.makeTensorInfo(N,V.dtype,V.values)}const Xa={kernelName:L,backendName:"cpu",kernelFunc:Qa};const es={kernelName:q,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{a:s,b:o,bias:r,preluActivationWeights:i}=t,{transposeA:d,transposeB:c,activation:l,leakyreluAlpha:p}=a;let u,h,f;const m=[];u=Qa({inputs:{a:s,b:o},attrs:{transposeA:d,transposeB:c},backend:n}),r&&(h=An({inputs:{a:u,b:r},backend:n}),m.push(u),u=h),l&&(f=Ka(n,u,l,i,p),m.push(u),u=f);for(const e of m)n.disposeIntermediateTensorInfo(e);return u}},ts={kernelName:G,backendName:"cpu",kernelFunc:Hn(G,e=>Math.acos(e))},ns={kernelName:U,backendName:"cpu",kernelFunc:Hn(U,e=>Math.acosh(e))};const as={kernelName:Z,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,a=t;ln(t,"addN");const s=a.map(e=>n.data.get(e.dataId).values),o=i(a[0].shape,a[0].dtype),r=o.values;for(let e=0;e<a.length;e++){const t=s[e];for(let e=0;e<r.length;e++)r[e]+=t[e]}return n.makeTensorInfo(o.shape,o.dtype,o.values)}};const ss={kernelName:j,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o}=n,{axis:i,keepDims:d}=s;ln(o,"all");const c=e.parseAxisParam(i,o.shape);let l=c;const p=r.getAxesPermutation(l,o.shape.length);let u=o;null!=p&&(u=ha({inputs:{x:o},backend:a,attrs:{perm:p}}),l=r.getInnerMostAxes(l.length,o.shape.length)),r.assertAxesAreInnerMostDims("all",l,u.shape.length);const[h,f]=r.computeOutAndReduceShapes(u.shape,l),m=e.sizeFromShape(f),k=e.makeZerosTypedArray(e.sizeFromShape(h),u.dtype),I=a.data.get(u.dataId).values;for(let e=0;e<k.length;++e){const t=e*m;let n=I[t];for(let e=0;e<m;++e){const a=I[t+e];n=n&&a}k[e]=n}null!=p&&a.disposeIntermediateTensorInfo(u);const g=a.makeTensorInfo(h,u.dtype,k);if(d){const e=Ya({inputs:{x:g},backend:a,attrs:{shape:r.expandShapeToKeepDim(h,c)}});return a.disposeIntermediateTensorInfo(g),e}return g}};const os={kernelName:K,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o}=n,{axis:i,keepDims:d}=s;ln(o,"any");const c=e.parseAxisParam(i,o.shape);let l=c;const p=r.getAxesPermutation(l,o.shape.length);let u=o;null!=p&&(u=ha({inputs:{x:o},backend:a,attrs:{perm:p}}),l=r.getInnerMostAxes(l.length,o.shape.length)),r.assertAxesAreInnerMostDims("any",l,u.shape.length);const[h,f]=r.computeOutAndReduceShapes(u.shape,l),m=e.sizeFromShape(f),k=e.makeZerosTypedArray(e.sizeFromShape(h),u.dtype),I=a.data.get(u.dataId).values;for(let e=0;e<k.length;++e){const t=e*m;let n=I[t];for(let e=0;e<m;++e){const a=I[t+e];n=n||a}k[e]=n}null!=p&&a.disposeIntermediateTensorInfo(u);const g=a.makeTensorInfo(h,u.dtype,k);if(d){const e=Ya({inputs:{x:g},backend:a,attrs:{shape:r.expandShapeToKeepDim(h,c)}});return a.disposeIntermediateTensorInfo(g),e}return g}};const rs={kernelName:Y,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o}=n,{axis:i}=s;ln(o,"argMax");let d=e.parseAxisParam(i,o.shape);const c=r.getAxesPermutation(d,o.shape.length);let l=o;const p=[];null!=c&&(l=ha({inputs:{x:o},backend:a,attrs:{perm:c}}),p.push(l),d=r.getInnerMostAxes(d.length,l.shape.length)),d=[d[0]],r.assertAxesAreInnerMostDims("argMax",d,l.shape.length);const[u,h]=r.computeOutAndReduceShapes(l.shape,d),f=e.sizeFromShape(u),m=e.makeZerosTypedArray(f,"int32"),k=e.sizeFromShape(h),I=a.data.get(l.dataId).values;for(let e=0;e<m.length;++e){const t=e*k;let n=I[t],a=0;for(let e=0;e<k;++e){const s=I[t+e];s>n&&(n=s,a=e)}m[e]=a}return p.forEach(e=>a.disposeIntermediateTensorInfo(e)),a.makeTensorInfo(u,"int32",m)}};const is={kernelName:J,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o}=n,{axis:i}=s;ln(o,"argMin");let d=e.parseAxisParam(i,o.shape);const c=r.getAxesPermutation(d,o.shape.length);let l=o;const p=[];null!=c&&(l=ha({inputs:{x:o},backend:a,attrs:{perm:c}}),p.push(l),d=r.getInnerMostAxes(d.length,l.shape.length)),d=[d[0]],r.assertAxesAreInnerMostDims("argMin",d,l.shape.length);const[u,h]=r.computeOutAndReduceShapes(l.shape,d),f=e.sizeFromShape(u),m=e.makeZerosTypedArray(f,"int32"),k=e.sizeFromShape(h),I=a.data.get(l.dataId).values;for(let e=0;e<m.length;++e){const t=e*k;let n=I[t],a=0;for(let e=0;e<k;++e){const s=I[t+e];s<n&&(n=s,a=e)}m[e]=a}return p.forEach(e=>a.disposeIntermediateTensorInfo(e)),a.makeTensorInfo(u,"int32",m)}},ds={kernelName:Q,backendName:"cpu",kernelFunc:Hn(Q,e=>Math.asin(e))},cs={kernelName:X,backendName:"cpu",kernelFunc:Hn(X,e=>Math.asinh(e))},ls={kernelName:ee,backendName:"cpu",kernelFunc:Hn(ee,e=>Math.atan(e))},ps={kernelName:te,backendName:"cpu",kernelFunc:Sn(te,mn((e,t)=>Math.atan2(e,t)))},us={kernelName:ne,backendName:"cpu",kernelFunc:Hn(ne,e=>Math.atanh(e))};function hs(e,t,n,a,s,o){const r=s.strideHeight,d=s.strideWidth,c=s.dilationHeight,l=s.dilationWidth,p=s.effectiveFilterHeight,u=s.effectiveFilterWidth,h=s.padInfo.top,f=s.padInfo.left,m="max"===o?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY,k=i(s.outShape,n),I=k.values,g=s.outShape[1]*s.outShape[2]*s.outShape[3],b=s.outShape[2]*s.outShape[3],y=s.outShape[3];for(let t=0;t<s.batchSize;++t){const n=t*g,i=t*a[0];for(let t=0;t<s.inChannels;++t)for(let k=0;k<s.outHeight;++k){const g=k*r-h,N=Math.max(0,g),x=Math.min(s.inHeight,p+g),T=n+k*b;for(let n=0;n<s.outWidth;++n){const r=n*d-f,p=Math.max(0,r),h=Math.min(s.inWidth,u+r);let k=m,g=0,b=0;for(let n=N;n<x;n+=c){const s=i+n*a[1];for(let n=p;n<h;n+=l){const r=e[s+n*a[2]+t];"max"===o&&r>k?k=r:"avg"===o&&(g+=r,b++)}if(isNaN(k))break}I[T+n*y+t]="avg"===o?g/b:k}}}return k}function fs(e,t,n,a,s=!1,o=!1){const r=i(a.outShape,"int32"),d=a.strideHeight,c=a.strideWidth,l=a.dilationHeight,p=a.dilationWidth,u=a.effectiveFilterHeight,h=a.effectiveFilterWidth,f=a.padInfo.top,m=a.padInfo.left,k=i(t,n,e);for(let e=0;e<a.batchSize;++e)for(let t=0;t<a.inChannels;++t)for(let n=0;n<a.outHeight;++n){const i=n*d-f;let I=i;for(;I<0;)I+=l;const g=Math.min(a.inHeight,u+i);for(let d=0;d<a.outWidth;++d){const u=d*c-m;let f=u;for(;f<0;)f+=p;const b=Math.min(a.inWidth,h+u);let y=Number.NEGATIVE_INFINITY,N=-1;for(let n=I;n<g;n+=l){const r=n-i;for(let i=f;i<b;i+=p){const d=i-u,c=k.get(e,n,i,t);c>y&&(y=c,N=s?o?((e*a.inHeight+n)*a.inWidth+i)*a.inChannels+t:(n*a.inWidth+i)*a.inChannels+t:r*h+d)}}r.set(N,e,n,d,t)}}return r}function ms(e,t,n,a,s,o){const r=s.strideDepth,d=s.strideHeight,c=s.strideWidth,l=s.dilationDepth,p=s.dilationHeight,u=s.dilationWidth,h=s.effectiveFilterDepth,f=s.effectiveFilterHeight,m=s.effectiveFilterWidth,k=s.padInfo.front,I=s.padInfo.top,g=s.padInfo.left,b="max"===o?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY,y=i(s.outShape,n),N=y.values,x=s.outShape[1]*s.outShape[2]*s.outShape[3]*s.outShape[4],T=s.outShape[2]*s.outShape[3]*s.outShape[4],F=s.outShape[3]*s.outShape[4],S=s.outShape[4];for(let t=0;t<s.batchSize;++t){const n=t*x,i=t*a[0];for(let t=0;t<s.inChannels;++t)for(let y=0;y<s.outDepth;++y){const x=y*r-k;let v=x;for(;v<0;)v+=l;const M=Math.min(s.inDepth,h+x),A=n+y*T;for(let n=0;n<s.outHeight;++n){const r=n*d-I;let h=r;for(;h<0;)h+=p;const k=Math.min(s.inHeight,f+r),y=A+n*F;for(let n=0;n<s.outWidth;++n){const r=n*c-g;let d=r;for(;d<0;)d+=u;const f=Math.min(s.inWidth,m+r),I=y+n*S;let x=b,T=0,F=0;for(let n=v;n<M;n+=l){const s=i+n*a[1];for(let n=h;n<k;n+=p){const r=s+n*a[2];for(let n=d;n<f;n+=u){const s=e[r+n*a[3]+t];if("max"===o&&s>x?x=s:"avg"===o&&(T+=s,F++),isNaN(x))break}if(isNaN(x))break}if(isNaN(x))break}N[I+t]="avg"===o?T/F:x}}}}return y}const ks={kernelName:ae,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o}=n;ln(o,"avgPool");const{filterSize:i,strides:d,pad:c,dimRoundingMode:l}=s;e.assert(r.eitherStridesOrDilationsAreOne(d,1),()=>`Error in avgPool: Either strides or dilations must be 1. Got strides ${d} and dilations '1'`);const p=r.computePool2DInfo(o.shape,i,d,1,c,l);let u;if(1===p.filterWidth&&1===p.filterHeight&&e.arraysEqual(p.inShape,p.outShape))u=bn({inputs:{x:o},backend:a});else{const t=a.data.get(o.dataId).values,n=e.computeStrides(o.shape),s=hs(t,o.shape,o.dtype,n,p,"avg");u=a.makeTensorInfo(p.outShape,o.dtype,s.values)}return u}};const Is={kernelName:se,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o}=n,{filterSize:i,strides:d,pad:c,dimRoundingMode:l,dataFormat:p}=s;ln(o,"avgPool3d");const u=r.computePool3DInfo(o.shape,i,d,1,c,l,p),h=ms(a.data.get(o.dataId).values,o.shape,o.dtype,e.computeStrides(o.shape),u,"avg");return a.makeTensorInfo(h.shape,"float32",h.values)}};const gs={kernelName:oe,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{dy:s,input:o}=t,{filterSize:d,strides:c,pad:l,dimRoundingMode:p}=a;ln([s,o],"avgPool3DGrad");const u=r.computePool3DInfo(o.shape,d,c,1,l,p),h=u.strideDepth,f=u.strideHeight,m=u.strideWidth,k=u.filterDepth,I=u.filterHeight,g=u.filterWidth,b=u.dilationDepth,y=u.dilationHeight,N=u.dilationWidth,x=u.effectiveFilterDepth,T=u.effectiveFilterHeight,F=u.effectiveFilterWidth,S=x-1-u.padInfo.front,v=F-1-u.padInfo.left,M=T-1-u.padInfo.top,A=i(o.shape,"float32"),w=1/(k*I*g),D=n.bufferSync(s);for(let e=0;e<u.batchSize;++e)for(let t=0;t<u.inChannels;++t)for(let n=0;n<u.inDepth;++n)for(let a=0;a<u.inHeight;++a)for(let s=0;s<u.inWidth;++s){const o=n-S,r=a-M,i=s-v;let d=0;for(let n=0;n<x;n+=b){const a=(o+n)/h;if(!(a<0||a>=u.outDepth||Math.floor(a)!==a))for(let n=0;n<T;n+=y){const s=(r+n)/f;if(!(s<0||s>=u.outHeight||Math.floor(s)!==s))for(let n=0;n<F;n+=N){const o=(i+n)/m;if(o<0||o>=u.outWidth||Math.floor(o)!==o)continue;d+=D.get(e,a,s,o,t)}}}A.set(d*w,e,n,a,s,t)}return n.makeTensorInfo(A.shape,A.dtype,A.values)}};const bs={kernelName:re,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{dy:s,input:o}=t,d=o;ln([s,o],"avgPoolGrad");const{filterSize:c,strides:l,pad:p}=a,u=r.computePool2DInfo(d.shape,c,l,1,p),h=u.strideHeight,f=u.strideWidth,m=u.filterHeight,k=u.filterWidth,I=u.dilationHeight,g=u.dilationWidth,b=u.effectiveFilterHeight,y=u.effectiveFilterWidth,N=y-1-u.padInfo.left,x=b-1-u.padInfo.top,T=i(d.shape,"float32"),F=1/(m*k),S=n.data.get(s.dataId).values,v=i(s.shape,"float32",S);for(let e=0;e<u.batchSize;++e)for(let t=0;t<u.inChannels;++t)for(let n=0;n<u.inHeight;++n)for(let a=0;a<u.inWidth;++a){const s=n-x,o=a-N;let r=0;for(let n=0;n<b;n+=I){const a=(s+n)/h;if(!(a<0||a>=u.outHeight||Math.floor(a)!==a))for(let n=0;n<y;n+=g){const s=(o+n)/f;if(s<0||s>=u.outWidth||Math.floor(s)!==s)continue;r+=v.get(e,a,s,t)}}T.set(r*F,e,n,a,t)}return n.makeTensorInfo(T.shape,T.dtype,T.values)}};const ys={kernelName:ie,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o,scale:r,offset:i,mean:d,variance:c}=n;e.assert(d.shape.length===c.shape.length,()=>"Batch normalization gradient requires mean and variance to have equal ranks."),e.assert(null==i||d.shape.length===i.shape.length,()=>"Batch normalization gradient requires mean and offset to have equal ranks."),e.assert(null==r||d.shape.length===r.shape.length,()=>"Batch normalization gradient requires mean and scale to have equal ranks."),ln([o,d,c,r,i],"batchNorm");let{varianceEpsilon:l}=s;null==l&&(l=.001);const p=a.data.get(o.dataId).values,u=a.data.get(d.dataId).values,h=a.data.get(c.dataId).values,f=r?a.data.get(r.dataId).values:new Float32Array([1]),m=i?a.data.get(i.dataId).values:new Float32Array([0]),k=new Float32Array(p.length),I=m.length,g=f.length,b=h.length,y=u.length;let N=0,x=0,T=0,F=0;for(let e=0;e<p.length;++e)k[e]=m[N++]+(p[e]-u[x++])*f[T++]/Math.sqrt(h[F++]+l),N>=I&&(N=0),x>=y&&(x=0),T>=g&&(T=0),F>=b&&(F=0);return a.makeTensorInfo(o.shape,o.dtype,k)}};const Ns={kernelName:de,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{x:s}=t,{blockShape:o,crops:i}=a;ln([s],"batchToSpaceND");const d=o.reduce((e,t)=>e*t),c=r.getReshaped(s.shape,o,d),l=r.getPermuted(c.length,o.length),p=r.getReshapedPermuted(s.shape,o,d),u=r.getSliceBeginCoords(i,o.length),h=r.getSliceSize(p,i,o.length),f=Ya({inputs:{x:s},backend:n,attrs:{shape:c}}),m=ha({inputs:{x:f},backend:n,attrs:{perm:l}}),k=Ya({inputs:{x:m},backend:n,attrs:{shape:p}}),I=Na({inputs:{x:k},backend:n,attrs:{begin:u,size:h}});return n.disposeIntermediateTensorInfo(f),n.disposeIntermediateTensorInfo(m),n.disposeIntermediateTensorInfo(k),I}};const xs={kernelName:ce,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{x:s,weights:o}=t,{size:r}=a,i=Dn(n.data.get(s.dataId).values,n.data.get(o.dataId).values,o.dtype,o.shape,r);return n.makeTensorInfo([r],o.dtype,i)}},Ts={kernelName:le,backendName:"cpu",kernelFunc:Hn(le,(e,t)=>{const n=t;return e>n.clipValueMax?n.clipValueMax:e<n.clipValueMin?n.clipValueMin:e})},Fs={kernelName:pe,backendName:"cpu",kernelFunc:t=>{const{x:n}=t.inputs,a=t.backend,s=new Float32Array(e.sizeFromShape(n.shape)),o=a.data.get(n.dataId),r=o.complexTensorInfos.real,i=o.complexTensorInfos.imag,d=a.data.get(r.dataId).values,c=a.data.get(i.dataId).values;for(let e=0;e<d.length;e++){const t=d[e],n=c[e];s[e]=Math.hypot(t,n)}return a.makeOutput(s,n.shape,"float32")}};function Ss(e){const{inputs:t,backend:n}=e,{input:a}=t,s=n.data.get(a.dataId).complexTensorInfos.imag,o=n.data.get(s.dataId).values;return n.makeTensorInfo(s.shape,s.dtype,o)}const vs={kernelName:ue,backendName:"cpu",kernelFunc:Ss};function Ms(t){const{inputs:n,backend:a,attrs:s}=t,{axis:o}=s,i=e.parseAxisParam(o,n[0].shape)[0];let d=r.computeOutShape(n.map(e=>e.shape),i);if(0===e.sizeFromShape(d))return a.makeTensorInfo(d,n[0].dtype,[]);const c=n.filter(t=>e.sizeFromShape(t.shape)>0);if(1===c.length)return bn({inputs:{x:c[0]},backend:a});const l=c.map(e=>e.shape);if(r.assertParamsConsistent(l,i),"complex64"===c[0].dtype){const e=c.map(e=>Nn({inputs:{input:e},backend:a})),t=c.map(e=>Ss({inputs:{input:e},backend:a})),n=Ms({inputs:e,backend:a,attrs:{axis:i}}),s=Ms({inputs:t,backend:a,attrs:{axis:i}}),o=kn({inputs:{real:n,imag:s},backend:a});return e.forEach(e=>a.disposeIntermediateTensorInfo(e)),t.forEach(e=>a.disposeIntermediateTensorInfo(e)),a.disposeIntermediateTensorInfo(n),a.disposeIntermediateTensorInfo(s),o}const p=c.map(t=>{const n=e.sizeFromShape(t.shape.slice(i));return Ya({inputs:{x:t},backend:a,attrs:{shape:[-1,n]}})}),u=p.map(e=>({vals:a.data.get(e.dataId).values,shape:e.shape}));d=r.computeOutShape(p.map(e=>e.shape),1);const h=1===p[0].shape[0],f=Rn(u,d,n[0].dtype,h),m=r.computeOutShape(c.map(e=>e.shape),i),k=a.makeTensorInfo(m,n[0].dtype,f);return p.forEach(e=>a.disposeIntermediateTensorInfo(e)),k}const As={kernelName:he,backendName:"cpu",kernelFunc:Ms};function ws(t){const{inputs:n,backend:a,attrs:s}=t,{x:o,filter:i}=n,{strides:d,pad:c,dataFormat:l,dilations:p,dimRoundingMode:u}=s;ln([o,i],"conv2d");const h=r.convertConv2DDataFormat(l),f=r.computeConv2DInfo(o.shape,i.shape,d,p,c,u,!1,h),m=f.filterHeight,k=f.filterWidth,I=f.dilationHeight,g=f.dilationWidth,b=f.padInfo.left,y=f.padInfo.top,N="channelsLast"===f.dataFormat,x=new E(f.outShape,o.dtype),T=e.computeStrides(o.shape),F=e.computeStrides(i.shape),S=T[0],v=N?T[1]:T[2],M=N?T[2]:1,A=N?1:T[1],w=x.strides[0],D=N?x.strides[1]:x.strides[2],z=N?x.strides[2]:1,W=N?1:x.strides[1],H=a.data.get(o.dataId).values,C=a.data.get(i.dataId).values,P=x.values;for(let e=0;e<f.batchSize;++e){const t=e*S,n=e*w;for(let e=0;e<f.outHeight;++e){const a=n+e*D,s=e*f.strideHeight-y;for(let e=0;e<m;++e){const n=s+e*I;if(n<0||n>=f.inHeight)continue;const o=e*F[0],r=t+n*v;for(let e=0;e<f.outWidth;++e){const t=a+e*z,n=e*f.strideWidth-b;for(let e=0;e<k;++e){const a=n+e*g;if(a<0||a>=f.inWidth)continue;const s=r+a*M;let i=o+e*F[1];for(let e=0;e<f.inChannels;++e){const n=H[s+e*A];for(let e=0;e<f.outChannels;++e)P[t+e*W]+=n*C[i+e];i+=f.outChannels}}}}}}return a.makeTensorInfo(x.shape,x.dtype,P)}const Ds={kernelName:fe,backendName:"cpu",kernelFunc:ws};const zs={kernelName:me,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{x:s,dy:o}=t,{strides:i,pad:d,dataFormat:c,dimRoundingMode:l,filterShape:p}=a;ln([s,o],"conv2dBackpropFilter");const u=r.convertConv2DDataFormat(c),h=r.computeConv2DInfo(s.shape,p,i,1,d,l,!1,u),{strideHeight:f,strideWidth:m,filterHeight:k,filterWidth:I}=h,g="channelsLast"===h.dataFormat,b=new E(h.filterShape,"float32"),y=h.padInfo.left,N=h.padInfo.top,x=n.data.get(s.dataId).values,T=n.data.get(o.dataId).values,F=new E(s.shape,s.dtype,x),S=new E(o.shape,o.dtype,T);for(let e=0;e<k;++e){const t=Math.max(0,Math.ceil((N-e)/f)),n=Math.min(h.outHeight,(h.inHeight+N-e)/f);for(let a=0;a<I;++a){const s=Math.max(0,Math.ceil((y-a)/m)),o=Math.min(h.outWidth,(h.inWidth+y-a)/m);for(let r=0;r<h.inChannels;++r)for(let i=0;i<h.outChannels;++i){let d=0;for(let c=0;c<h.batchSize;++c)for(let l=t;l<n;++l){const t=e+l*f-N;for(let e=s;e<o;++e){const n=a+e*m-y;d+=g?F.get(c,t,n,r)*S.get(c,l,e,i):F.get(c,r,t,n)*S.get(c,i,l,e)}}b.set(d,e,a,r,i)}}}return n.makeTensorInfo(b.shape,b.dtype,b.values)}};const Ws={kernelName:ke,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{dy:o,filter:i}=n,{inputShape:d,strides:c,pad:l,dataFormat:p,dimRoundingMode:u}=s;ln([o,i],"conv2dBackpropInput");const h=e.computeStrides(i.shape),f=e.computeStrides(o.shape);let m=r.convertConv2DDataFormat(p);const k=r.computeConv2DInfo(d,i.shape,c,1,l,u,!1,m),I=new E(k.inShape,"float32"),g=I.values,b=a.data.get(o.dataId).values,y=a.data.get(i.dataId).values,[N,x,T]=h,{batchSize:F,filterHeight:S,filterWidth:v,inChannels:M,inHeight:A,inWidth:w,outChannels:D,outHeight:z,outWidth:W,strideHeight:H,strideWidth:C}=k;m=k.dataFormat;const P=S-1-k.padInfo.top,R=v-1-k.padInfo.left,$="channelsLast"===m,O=I.strides[0],V=$?I.strides[1]:I.strides[2],_=$?I.strides[2]:1,B=$?1:I.strides[1],L=f[0],q=$?f[1]:f[2],G=$?f[2]:1,U=$?1:f[1];for(let e=0;e<F;++e)for(let t=0;t<M;++t)for(let n=0;n<A;++n){const a=n-P,s=Math.max(0,Math.ceil(a/H)),o=Math.min(z,(S+a)/H);for(let r=0;r<w;++r){const i=r-R,d=Math.max(0,Math.ceil(i/C)),c=Math.min(W,(v+i)/C);let l=0;for(let n=s;n<o;++n){const s=n*H-a;for(let a=d;a<c;++a){const o=L*e+q*n+G*a,r=N*(S-1-s)+x*(v-1-(a*C-i))+T*t;for(let e=0;e<D;++e){l+=b[o+U*e]*y[r+e]}}}g[O*e+V*n+_*r+B*t]=l}}return a.makeTensorInfo(I.shape,I.dtype,I.values)}};const Hs={kernelName:Ie,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o,filter:i}=n,{strides:d,pad:c,dilations:l}=s;ln([o,i],"conv3d");const p=r.computeConv3DInfo(o.shape,i.shape,d,l,c),{filterDepth:u,filterHeight:h,filterWidth:f,dilationDepth:m,dilationHeight:k,dilationWidth:I,padInfo:g}=p,b=g.front,y=g.left,N=g.top,x=new E(p.outShape,o.dtype),T=a.data.get(o.dataId).values,F=a.data.get(i.dataId).values,S=x.values,v=e.computeStrides(o.shape),M=e.computeStrides(i.shape);for(let e=0;e<p.batchSize;++e){const t=e*v[0],n=e*x.strides[0];for(let e=0;e<p.outDepth;++e){const a=n+e*x.strides[1],s=e*p.strideDepth-b;for(let e=0;e<u;++e){const n=s+e*m;if(n<0||n>=p.inDepth)continue;const o=e*M[0],r=t+n*v[1];for(let e=0;e<p.outHeight;++e){const t=a+e*x.strides[2],n=e*p.strideHeight-N;for(let e=0;e<h;++e){const a=n+e*k;if(a<0||a>=p.inHeight)continue;const s=o+e*M[1],i=r+a*v[2];for(let e=0;e<p.outWidth;++e){const n=t+e*p.outChannels,a=e*p.strideWidth-y;for(let e=0;e<f;++e){const t=a+e*I;if(t<0||t>=p.inWidth)continue;const o=s+e*M[2],r=i+t*p.inChannels;let d=o;for(let e=0;e<p.inChannels;++e){const t=T[r+e];for(let e=0;e<p.outChannels;++e)S[n+e]+=t*F[d+e];d+=p.outChannels}}}}}}}}return a.makeTensorInfo(x.shape,x.dtype,x.values)}};const Es={kernelName:ge,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o,dy:i}=n,{strides:d,pad:c,filterShape:l}=s;ln([o,i],"conv3dBackpropFilterV2");const p=e.computeStrides(o.shape),u=e.computeStrides(i.shape),h=r.computeConv3DInfo(o.shape,l,d,1,c),f=h.strideDepth,m=h.strideHeight,k=h.strideWidth,I=h.filterDepth,g=h.filterHeight,b=h.filterWidth,y=new E(h.filterShape,"float32"),N=y.values,[x,T,F,S]=y.strides,v=a.data.get(i.dataId).values,[M,A,w,D]=u,z=a.data.get(o.dataId).values,[W,H,C,P]=p,R=h.padInfo.front,$=h.padInfo.left,O=h.padInfo.top;for(let e=0;e<I;++e){const t=Math.max(0,Math.ceil((R-e)/f)),n=Math.min(h.outDepth,(h.inDepth+R-e)/f),a=e*x;for(let s=0;s<g;++s){const o=Math.max(0,Math.ceil((O-s)/m)),r=Math.min(h.outHeight,(h.inHeight+O-s)/m),i=s*T+a;for(let a=0;a<b;++a){const d=Math.max(0,Math.ceil(($-a)/k)),c=Math.min(h.outWidth,(h.inWidth+$-a)/k),l=a*F+i;for(let i=0;i<h.inChannels;++i){const p=i*S+l;for(let l=0;l<h.outChannels;++l){let u=0;for(let p=0;p<h.batchSize;++p){const h=p*W,I=p*M;for(let p=t;p<n;++p){const t=(e+p*f-R)*H+h,n=p*A+I;for(let e=o;e<r;++e){const o=(s+e*m-O)*C+t,r=e*w+n;for(let e=d;e<c;++e){const t=e*D+r;u+=z[(a+e*k-$)*P+o+i]*v[t+l]}}}}N[p+l]=u}}}}}return a.makeTensorInfo(y.shape,y.dtype,y.values)}};const Cs={kernelName:be,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{dy:o,filter:i}=n,{pad:d,strides:c,inputShape:l}=s;ln([o],"conv3dBackpropInputV2");const p=e.computeStrides(o.shape),u=e.computeStrides(i.shape),h=r.computeConv3DInfo(l,i.shape,c,1,d),f=new E(h.inShape,"float32"),m=f.values,[k,I,g,b]=f.strides,y=a.data.get(o.dataId).values,[N,x,T,F]=p,S=a.data.get(i.dataId).values,[v,M,A,w]=u,{batchSize:D,filterDepth:z,filterHeight:W,filterWidth:H,inChannels:C,inDepth:P,inHeight:R,inWidth:$,outChannels:O,outDepth:V,outHeight:_,outWidth:B,strideDepth:L,strideHeight:q,strideWidth:G}=h,U=z-1-h.padInfo.front,Z=W-1-h.padInfo.top,j=H-1-h.padInfo.left;for(let e=0;e<D;++e)for(let t=0;t<C;++t)for(let n=0;n<P;++n){const a=n-U,s=Math.max(0,Math.ceil(a/L)),o=Math.min(V,(z+a)/L);for(let r=0;r<R;++r){const i=r-Z,d=Math.max(0,Math.ceil(i/q)),c=Math.min(_,(W+i)/q);for(let l=0;l<$;++l){const p=l-j,u=Math.max(0,Math.ceil(p/G)),h=Math.min(B,(H+p)/G);let f=0;for(let n=s;n<o;++n){const s=n*L-a;for(let a=d;a<c;++a){const o=a*q-i;for(let r=u;r<h;++r){const i=N*e+x*n+T*a+F*r,d=v*(z-1-s)+M*(W-1-o)+A*(H-1-(r*G-p))+w*t;for(let e=0;e<O;++e){f+=y[i+e]*S[d+e]}}}}m[k*e+I*n+g*r+b*l+t]=f}}}return a.makeTensorInfo(f.shape,f.dtype,f.values)}},Ps={kernelName:ye,backendName:"cpu",kernelFunc:Hn(ye,e=>Math.cos(e))},Rs={kernelName:Ne,backendName:"cpu",kernelFunc:Hn(Ne,e=>Math.cosh(e))};const $s={kernelName:xe,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{image:o,boxes:r,boxInd:d}=n,{cropSize:c,method:l,extrapolationValue:p}=s,[u,h,f,m]=o.shape,k=r.shape[0],[I,g]=c,b=i([k,I,g,m],"float32"),y=a.data.get(r.dataId).values,N=a.data.get(d.dataId).values,x=a.data.get(o.dataId).values,T=e.computeStrides(o.shape),F=e.computeStrides(b.shape);for(let e=0;e<k;e++){const t=4*e,n=y[t],a=y[t+1],s=y[t+2],o=y[t+3],r=N[e];if(r>=u)continue;const i=I>1?(s-n)*(h-1)/(I-1):0,d=g>1?(o-a)*(f-1)/(g-1):0;for(let t=0;t<I;t++){const c=I>1?n*(h-1)+t*i:.5*(n+s)*(h-1);if(c<0||c>h-1)for(let n=0;n<g;n++)for(let a=0;a<m;a++){const s=a+n*F[2]+t*F[1]+e*F[0];b.values[s]=p}else if("bilinear"===l){const n=Math.floor(c),s=Math.ceil(c),i=c-n;for(let c=0;c<g;c++){const l=g>1?a*(f-1)+c*d:.5*(a+o)*(f-1);if(l<0||l>f-1){for(let n=0;n<m;n++){const a=n+c*F[2]+t*F[1]+e*F[0];b.values[a]=p}continue}const u=Math.floor(l),h=Math.ceil(l),k=l-u;for(let a=0;a<m;a++){let o=a+u*T[2]+n*T[1]+r*T[0];const d=x[o];o=a+h*T[2]+n*T[1]+r*T[0];const l=x[o];o=a+u*T[2]+s*T[1]+r*T[0];const p=x[o];o=a+h*T[2]+s*T[1]+r*T[0];const f=d+(l-d)*k,m=p+(x[o]-p)*k;o=a+c*F[2]+t*F[1]+e*F[0],b.values[o]=f+(m-f)*i}}}else for(let n=0;n<g;++n){const s=g>1?a*(f-1)+n*d:.5*(a+o)*(f-1);if(s<0||s>f-1){for(let a=0;a<m;a++){const s=a+n*F[2]+t*F[1]+e*F[0];b.values[s]=p}continue}const i=Math.round(s),l=Math.round(c);for(let a=0;a<m;a++){const s=a+i*T[2]+l*T[1]+r*T[0],o=a+n*F[2]+t*F[1]+e*F[0];b.values[o]=x[s]}}}}return a.makeTensorInfo(b.shape,b.dtype,b.values)}};const Os={kernelName:Te,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o}=n,{axis:i,exclusive:d,reverse:c}=s;ln(o,"cumsum");const l=r.getAxesPermutation([i],o.shape.length);let p=o;null!=l&&(p=ha({inputs:{x:o},backend:a,attrs:{perm:l}}));const u=r.getInnerMostAxes(1,o.shape.length)[0];if(u!==p.shape.length-1)throw new Error(`backend.cumsum in CPU expects an inner-most axis=${p.shape.length-1} but got axis=${u}`);const h=M(p.dtype,"int32"),f=e.makeZerosTypedArray(e.sizeFromShape(p.shape),h),m=a.data.get(p.dataId).values,k=p.shape[p.shape.length-1],I=c?(e,t)=>e+k-t-1:(e,t)=>e+t;for(let e=0;e<m.length;e+=k)for(let t=0;t<k;t++){const n=I(e,t);if(0===t)f[n]=d?0:m[n];else{const a=I(e,t-1);f[n]=d?m[a]+f[a]:m[n]+f[a]}}const g=a.makeTensorInfo(p.shape,h,f);if(null!=l){const e=ha({inputs:{x:g},backend:a,attrs:{perm:r.getUndoAxesPermutation(l)}});return a.disposeIntermediateTensorInfo(g),a.disposeIntermediateTensorInfo(p),e}return g}};const Vs={kernelName:Fe,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{x:s,weights:o}=t,{size:r,binaryOutput:i}=a;if(1===s.shape.length){const e=Dn(n.data.get(s.dataId).values,n.data.get(o.dataId).values,o.dtype,o.shape,r);return n.makeTensorInfo([r],o.dtype,e)}if(2===s.shape.length){const e=zn(n.bufferSync(s),n.bufferSync(o),r,i);return n.makeTensorInfo(e.shape,o.dtype,e.values)}throw new Error("Error in denseBincount: input must be at most rank 2, but got rank"+s.shape.length+".")}};const _s={kernelName:Se,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o}=n,{blockSize:r,dataFormat:i}=s;e.assert("NHWC"===i,()=>"Only NHWC dataFormat supported on CPU for depthToSpace. Got "+i),e.assert(r>1,()=>"blockSize should be > 1 for depthToSpace, but was: "+r);const d=o.shape[0],c=o.shape[1],l=o.shape[2],p=o.shape[3],u=c*r,h=l*r,f=p/(r*r),m=a.data.get(o.dataId).values,k=new Float32Array(d*u*h*f);let I=0;for(let e=0;e<d;++e)for(let t=0;t<u;++t){const n=Math.floor(t/r),a=t%r;for(let t=0;t<h;++t){const s=Math.floor(t/r),o=(a*r+t%r)*f;for(let t=0;t<f;++t){const a=t+o+p*(s+l*(n+c*e));k[I++]=m[a]}}}return a.makeTensorInfo([d,u,h,f],o.dtype,k)}};function Bs(t){const{inputs:n,backend:a,attrs:s}=t,{x:o,filter:i}=n,{strides:d,pad:c,dilations:l,dimRoundingMode:p}=s;ln([o,i],"depthwiseConv2DNative");const u=e.computeStrides(o.shape),h=e.computeStrides(i.shape);let f=l;null==f&&(f=[1,1]),e.assert(r.eitherStridesOrDilationsAreOne(d,f),()=>`Error in depthwiseConv2d: Either strides or dilations must be 1. Got strides ${d} and dilations '${f}'`);const m=r.computeConv2DInfo(o.shape,i.shape,d,f,c,p,!0),{filterHeight:k,filterWidth:I,dilationHeight:g,dilationWidth:b,padInfo:y}=m,N=y.left,x=y.top,T=m.outChannels/m.inChannels,F=new E(m.outShape,o.dtype),S=a.data.get(o.dataId).values,v=a.data.get(i.dataId).values,M=F.values;for(let e=0;e<m.batchSize;++e){const t=e*u[0],n=e*F.strides[0];for(let e=0;e<m.outHeight;++e){const a=n+e*F.strides[1],s=e*m.strideHeight-x;for(let e=0;e<k;++e){const n=s+e*g;if(n<0||n>=m.inHeight)continue;const o=e*h[0],r=t+n*u[1];for(let e=0;e<m.outWidth;++e){const t=a+e*F.strides[2],n=e*m.strideWidth-N;for(let e=0;e<I;++e){const a=n+e*b;if(a<0||a>=m.inWidth)continue;const s=o+e*h[1],i=r+a*m.inChannels;let d=t,c=s;for(let e=0;e<m.inChannels;++e){const t=S[i+e];for(let e=0;e<T;++e)M[d+e]+=t*v[c+e];d+=T,c+=T}}}}}}return a.makeTensorInfo(F.shape,F.dtype,F.values)}const Ls={kernelName:ve,backendName:"cpu",kernelFunc:Bs};const qs={kernelName:Me,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{x:s,dy:o}=t,{strides:i,dilations:d,pad:c,dimRoundingMode:l,filterShape:p}=a;ln([s,o],"depthwiseConv2dNativeBackpropFilter");const u=r.computeConv2DInfo(s.shape,p,i,d,c,l,!0),{strideHeight:h,strideWidth:f,filterHeight:m,filterWidth:k}=u,I=new E(u.filterShape,"float32"),g=u.padInfo.left,b=u.padInfo.top,y=u.outChannels/u.inChannels,N=n.data.get(s.dataId).values,x=new E(s.shape,s.dtype,N),T=n.data.get(o.dataId).values,F=new E(o.shape,o.dtype,T);for(let e=0;e<m;++e){const t=Math.max(0,Math.ceil((b-e)/h)),n=Math.min(u.outHeight,(u.inHeight+b-e)/h);for(let a=0;a<k;++a){const s=Math.max(0,Math.ceil((g-a)/f)),o=Math.min(u.outWidth,(u.inWidth+g-a)/f);for(let r=0;r<u.outChannels;++r){const i=Math.trunc(r/y),d=r%y;let c=0;for(let d=0;d<u.batchSize;++d)for(let l=t;l<n;++l){const t=e+l*h-b;for(let e=s;e<o;++e){const n=a+e*f-g;c+=x.get(d,t,n,i)*F.get(d,l,e,r)}}I.set(c,e,a,i,d)}}}return n.makeTensorInfo(I.shape,I.dtype,I.values)}};const Gs={kernelName:Ae,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{dy:o,filter:i}=n,{strides:d,dilations:c,pad:l,dimRoundingMode:p,inputShape:u}=s;ln([o,i],"depthwiseConv2DNativeBackpropInput");const h=e.computeStrides(o.shape),f=e.computeStrides(i.shape),m=r.computeConv2DInfo(u,i.shape,d,c,l,p,!0),k=new E(m.inShape,"float32"),I=k.values,[g,b,y]=k.strides,N=a.data.get(o.dataId).values,[x,T,F]=h,S=a.data.get(i.dataId).values,[v,M,A]=f,{batchSize:w,filterHeight:D,filterWidth:z,inChannels:W,inHeight:H,inWidth:C,outChannels:P,outHeight:R,outWidth:$,strideHeight:O,strideWidth:V}=m,_=D-1-m.padInfo.top,B=z-1-m.padInfo.left,L=P/W;for(let e=0;e<w;++e)for(let t=0;t<W;++t)for(let n=0;n<H;++n){const a=n-_,s=Math.max(0,Math.ceil(a/O)),o=Math.min(R,(D+a)/O);for(let r=0;r<C;++r){const i=r-B,d=Math.max(0,Math.ceil(i/V)),c=Math.min($,(z+i)/V);let l=0;for(let n=s;n<o;++n){const s=n*O-a;for(let a=d;a<c;++a){const o=x*e+T*n+F*a,r=v*(D-1-s)+M*(z-1-(a*V-i))+A*t;for(let e=0;e<L;++e){l+=N[o+(t*L+e)]*S[r+e]}}}I[g*e+b*n+y*r+t]=l}}return a.makeTensorInfo(k.shape,k.dtype,k.values)}};const Us={kernelName:we,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a}=t,{x:s}=n,o=e.sizeFromShape(s.shape),r=a.data.get(s.dataId).values,d=i([o,o],s.dtype),c=d.values;for(let e=0;e<r.length;e++)c[e*o+e]=r[e];const l=[...s.shape,...s.shape];return a.makeTensorInfo(l,d.dtype,d.values)}},Zs={kernelName:De,backendName:"cpu",kernelFunc:({inputs:t,backend:n,attrs:a})=>{const{x:s,filter:o}=t,{strides:i,pad:d,dilations:c}=a,l=n,p=l.data.get(s.dataId).values,u=s.shape.length,h=l.data.get(o.dataId).values,f=o.shape.length,{batchSize:m,inHeight:k,inWidth:I,inChannels:g,outHeight:b,outWidth:y,padInfo:N,strideHeight:x,strideWidth:T,filterHeight:F,filterWidth:S,dilationHeight:v,dilationWidth:M,outShape:A}=r.computeDilation2DInfo(s.shape,o.shape,i,d,"NHWC",c),w=e.sizeFromShape(A),D=A.length,z=e.getArrayFromDType(s.dtype,w);for(let t=0;t<m;++t)for(let n=0;n<b;++n){const a=n*x-N.top;for(let r=0;r<y;++r){const i=r*T-N.left;for(let d=0;d<g;++d){let c=Number.MIN_SAFE_INTEGER;for(let n=0;n<F;++n){const r=a+n*v;if(r>=0&&r<k)for(let a=0;a<S;++a){const l=i+a*M;if(l>=0&&l<I){const i=e.locToIndex([t,r,l,d],u,e.computeStrides(s.shape)),m=e.locToIndex([n,a,d],f,e.computeStrides(o.shape)),k=p[i]+h[m];k>c&&(c=k)}}}z[e.locToIndex([t,n,r,d],D,e.computeStrides(A))]=c}}}return{dataId:l.write(e.toTypedArray(z,s.dtype),A,s.dtype),shape:A,dtype:s.dtype}}},js={kernelName:ze,backendName:"cpu",kernelFunc:({inputs:t,backend:n,attrs:a})=>{const{x:s,filter:o,dy:i}=t,{strides:d,pad:c,dilations:l}=a,p=n,u=e.toNestedArray(s.shape,p.data.get(s.dataId).values),h=e.toNestedArray(o.shape,p.data.get(o.dataId).values),{batchSize:f,inHeight:m,inWidth:k,inChannels:I,outHeight:g,outWidth:b,padInfo:y,strideHeight:N,strideWidth:x,filterHeight:T,filterWidth:F,dilationHeight:S,dilationWidth:v,outShape:M}=r.computeDilation2DInfo(s.shape,o.shape,d,c,"NHWC",l);e.assert(i.rank===M.length,()=>`Error in ${ze}, dy must have the same rank as output ${M.length}, but got `+i.rank);const A=e.toNestedArray(M,p.data.get(i.dataId).values),w=e.makeZerosNestedTypedArray(o.shape,o.dtype);for(let e=0;e<f;++e)for(let t=0;t<g;++t){const n=t*N-y.top;for(let a=0;a<b;++a){const s=a*x-y.left;for(let o=0;o<I;++o){let r=Number.MIN_SAFE_INTEGER,i=0,d=0;for(let t=0;t<T;++t){const a=n+t*S;if(a>=0&&a<m)for(let n=0;n<F;++n){const c=s+n*v;if(c>=0&&c<k){const s=u[e][a][c][o]+h[t][n][o];s>r&&(r=s,i=t,d=n)}}}w[i][d][o]+=A[e][t][a][o]}}}return{dataId:p.write(e.toTypedArray(w,s.dtype),o.shape,o.dtype),shape:o.shape,dtype:o.dtype}}},Ks={kernelName:We,backendName:"cpu",kernelFunc:({inputs:t,backend:n,attrs:a})=>{const{x:s,filter:o,dy:i}=t,{strides:d,pad:c,dilations:l}=a,p=n,u=e.toNestedArray(s.shape,p.data.get(s.dataId).values),h=e.toNestedArray(o.shape,p.data.get(o.dataId).values),{batchSize:f,inHeight:m,inWidth:k,inChannels:I,outHeight:g,outWidth:b,padInfo:y,strideHeight:N,strideWidth:x,filterHeight:T,filterWidth:F,dilationHeight:S,dilationWidth:v,outShape:M}=r.computeDilation2DInfo(s.shape,o.shape,d,c,"NHWC",l);e.assert(i.rank===M.length,()=>`Error in ${We}, dy must have the same rank as output ${M.length}, but got `+i.rank);const A=e.toNestedArray(M,p.data.get(i.dataId).values),w=e.makeZerosNestedTypedArray(s.shape,s.dtype);for(let e=0;e<f;++e)for(let t=0;t<g;++t){const n=t*N-y.top;for(let a=0;a<b;++a){const s=a*x-y.left;for(let o=0;o<I;++o){let r=Number.MIN_SAFE_INTEGER,i=n<0?0:n,d=s<0?0:s;for(let t=0;t<T;++t){const a=n+t*S;if(a>=0&&a<m)for(let n=0;n<F;++n){const c=s+n*v;if(c>=0&&c<k){const s=u[e][a][c][o]+h[t][n][o];s>r&&(r=s,i=a,d=c)}}}w[e][i][d][o]+=A[e][t][a][o]}}}return{dataId:p.write(e.toTypedArray(w,s.dtype),s.shape,s.dtype),shape:s.shape,dtype:s.dtype}}};function Ys(t){const{inputs:n,backend:a,attrs:s}=t,{x:o}=n,{axis:i,keepDims:d}=s;let c;ln(o,"sum"),c="bool"===o.dtype?Tn({inputs:{x:o},backend:a,attrs:{dtype:"int32"}}):bn({inputs:{x:o},backend:a});const l=c.shape.length,p=e.parseAxisParam(i,c.shape),u=r.getAxesPermutation(p,l);let h=p,f=c;null!=u&&(f=ha({inputs:{x:c},backend:a,attrs:{perm:u}}),h=r.getInnerMostAxes(h.length,l)),r.assertAxesAreInnerMostDims("sum",h,f.shape.length);const[m,k]=r.computeOutAndReduceShapes(f.shape,h);let I=gn(a,m,r.upcastType(f.dtype,"int32"));const g=e.sizeFromShape(k),b=a.data.get(I.dataId).values,y=a.data.get(f.dataId).values;for(let e=0;e<b.length;++e){const t=e*g;let n=0;for(let e=0;e<g;++e)n+=y[t+e];b[e]=n}if(d){const e=I;I=Ya({inputs:{x:I},backend:a,attrs:{shape:r.expandShapeToKeepDim(I.shape,p)}}),a.disposeIntermediateTensorInfo(e)}return a.disposeIntermediateTensorInfo(c),null!=u&&a.disposeIntermediateTensorInfo(f),I}const Js={kernelName:He,backendName:"cpu",kernelFunc:Ys};const Qs={kernelName:Ee,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{equation:o}=s,i=n,{allDims:d,summedDims:c,idDims:l}=r.decodeEinsumEquation(o,i.length);r.checkEinsumDimSizes(d.length,l,i);const{path:p,steps:u}=r.getEinsumComputePath(c,l),h=u.length;let f=null,m=d.length;const k=[];for(let t=0;t<h;++t){for(const n of u[t]){const{permutationIndices:t,expandDims:s}=r.getEinsumPermutation(m,l[n]);let o;r.isIdentityPermutation(t)?o=i[n]:(o=ha({inputs:{x:i[n]},backend:a,attrs:{perm:t}}),k.push(o));const d=o.shape.slice();for(let e=0;e<s.length;++e)d.splice(s[e],0,1);e.arraysEqual(o.shape,d)||(o=Ya({inputs:{x:o},backend:a,attrs:{shape:d}}),k.push(o)),null===f?f=o:(f=ra({inputs:{a:o,b:f},backend:a}),k.push(f))}t<h-1&&(p[t]>=0&&(f=Ys({inputs:{x:f},backend:a,attrs:{axis:p[t]-(d.length-m),keepDims:!1}}),k.push(f)),m--)}for(const e of k)e!==f&&a.disposeIntermediateTensorInfo(e);return f}};const Xs={kernelName:Ce,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a}=t,{dy:s,y:o}=n;ln([s,o],"eluGrad");const r=new Float32Array(e.sizeFromShape(o.shape)),i=a.data.get(o.dataId).values,d=a.data.get(s.dataId).values;for(let e=0;e<i.length;++e){const t=i[e];r[e]=t>=1?d[e]:d[e]*(t+1)}return a.makeTensorInfo(o.shape,"float32",r)}},eo=Sn(Pe,mn((e,t)=>e===t?1:0),null,"bool"),to={kernelName:Pe,backendName:"cpu",kernelFunc:eo},no=r.ERF_P,ao=r.ERF_A1,so=r.ERF_A2,oo=r.ERF_A3,ro=r.ERF_A4,io=r.ERF_A5,co={kernelName:Re,backendName:"cpu",kernelFunc:Hn(Re,e=>{const t=Math.sign(e),n=Math.abs(e),a=1/(1+no*n);return t*(1-((((io*a+ro)*a+oo)*a+so)*a+ao)*a*Math.exp(-n*n))})};function lo(t){const{inputs:n,backend:a,attrs:s}=t,{input:o}=n,{dim:r}=s,i=o.shape.length,d=o.shape.slice();let c=r;return r<0&&(e.assert(-(i+1)<=r,()=>`Axis must be in the interval [${-(i+1)}, ${i}]`),c=i+r+1),d.splice(c,0,1),Ya({inputs:{x:o},backend:a,attrs:{shape:d}})}const po={kernelName:$e,backendName:"cpu",kernelFunc:lo},uo=Sn(Oe,mn((e,t)=>e/t)),ho={kernelName:Oe,backendName:"cpu",kernelFunc:uo};function fo(t,n,a){const s=t.shape,o=s[0],i=s[1],d=a.data.get(t.dataId),c=d.complexTensorInfos.real,l=d.complexTensorInfos.imag,p=[o,i],u=e.sizeFromShape(p),h=e.getTypedArrayFromDType("float32",u),f=e.getTypedArrayFromDType("float32",u);for(let e=0;e<o;e++){const t=Na({inputs:{x:c},backend:a,attrs:{begin:[e,0],size:[1,i]}}),s=Na({inputs:{x:l},backend:a,attrs:{begin:[e,0],size:[1,i]}}),o=kn({inputs:{real:t,imag:s},backend:a}),{real:d,imag:p}=mo(o,n,a),u=r.mergeRealAndImagArrays(d,p);for(let t=0;t<i;t++){const n=r.getComplexWithIndex(u,t);h[e*i+t]=n.real,f[e*i+t]=n.imag}a.disposeIntermediateTensorInfo(t),a.disposeIntermediateTensorInfo(s),a.disposeIntermediateTensorInfo(o)}const m=a.makeTensorInfo(p,"float32",h),k=a.makeTensorInfo(p,"float32",f),I=kn({inputs:{real:m,imag:k},backend:a});return a.disposeIntermediateTensorInfo(m),a.disposeIntermediateTensorInfo(k),I}function mo(t,n,a){const s=e.sizeFromShape(t.shape),o=a.data.get(t.dataId),i=a.data.get(o.complexTensorInfos.real.dataId).values,d=a.data.get(o.complexTensorInfos.imag.dataId).values;if(0==((c=s)&c-1)){const o=function e(t,n,a,s,o){if(1===a)return{real:t,imag:n};const i=r.mergeRealAndImagArrays(t,n),d=a/2,c=r.complexWithEvenIndex(i),l=c.real,p=c.imag,u=[l.length],h=o.makeTensorInfo(u,"float32",l),f=o.makeTensorInfo(u,"float32",p),m=kn({inputs:{real:h,imag:f},backend:o}),k=r.complexWithOddIndex(i),I=k.real,g=k.imag,b=[I.length],y=o.makeTensorInfo(b,"float32",I),N=o.makeTensorInfo(b,"float32",g),x=kn({inputs:{real:y,imag:N},backend:o}),T=e(l,p,d,s,o),F=T.real,S=T.imag,v=[F.length],M=o.makeTensorInfo(v,"float32",F),A=o.makeTensorInfo(v,"float32",S),w=kn({inputs:{real:M,imag:A},backend:o}),D=e(I,g,d,s,o),z=D.real,W=D.imag,H=[z.length],E=o.makeTensorInfo(H,"float32",z),C=o.makeTensorInfo(H,"float32",W),P=kn({inputs:{real:E,imag:C},backend:o}),R=r.exponents(a,s),$=[R.real.length],O=o.makeTensorInfo($,"float32",R.real),V=o.makeTensorInfo($,"float32",R.imag),_=kn({inputs:{real:O,imag:V},backend:o}),B=ra({inputs:{a:_,b:P},backend:o}),L=An({inputs:{a:w,b:B},backend:o}),q=wa({inputs:{a:w,b:B},backend:o}),G=Nn({inputs:{input:L},backend:o}),U=Nn({inputs:{input:q},backend:o}),Z=Ss({inputs:{input:L},backend:o}),j=Ss({inputs:{input:q},backend:o}),K=Ms({inputs:[G,U],backend:o,attrs:{axis:0}}),Y=Ms({inputs:[Z,j],backend:o,attrs:{axis:0}}),J=o.data.get(K.dataId).values,Q=o.data.get(Y.dataId).values;return o.disposeIntermediateTensorInfo(h),o.disposeIntermediateTensorInfo(f),o.disposeIntermediateTensorInfo(m),o.disposeIntermediateTensorInfo(y),o.disposeIntermediateTensorInfo(N),o.disposeIntermediateTensorInfo(x),o.disposeIntermediateTensorInfo(M),o.disposeIntermediateTensorInfo(A),o.disposeIntermediateTensorInfo(w),o.disposeIntermediateTensorInfo(E),o.disposeIntermediateTensorInfo(C),o.disposeIntermediateTensorInfo(P),o.disposeIntermediateTensorInfo(O),o.disposeIntermediateTensorInfo(V),o.disposeIntermediateTensorInfo(_),o.disposeIntermediateTensorInfo(B),o.disposeIntermediateTensorInfo(L),o.disposeIntermediateTensorInfo(q),o.disposeIntermediateTensorInfo(G),o.disposeIntermediateTensorInfo(Z),o.disposeIntermediateTensorInfo(U),o.disposeIntermediateTensorInfo(j),o.disposeIntermediateTensorInfo(K),o.disposeIntermediateTensorInfo(Y),{real:J,imag:Q}}(i,d,s,n,a),c=[t.shape[0],t.shape[1]];if(n){const t=a.makeTensorInfo(c,"float32",o.real),n=a.makeTensorInfo(c,"float32",o.imag),r=a.makeTensorInfo([],"float32",e.createScalarValue(s,"float32")),i=bn({inputs:{x:r},backend:a}),d=ho.kernelFunc({inputs:{a:t,b:r},backend:a}),l=ho.kernelFunc({inputs:{a:n,b:i},backend:a}),p=a.data.get(d.dataId).values,u=a.data.get(l.dataId).values;return a.disposeIntermediateTensorInfo(t),a.disposeIntermediateTensorInfo(n),a.disposeIntermediateTensorInfo(r),a.disposeIntermediateTensorInfo(i),a.disposeIntermediateTensorInfo(d),a.disposeIntermediateTensorInfo(l),{real:p,imag:u}}return o}{const e=function(e,t,n){const a=new Float32Array(2*t);for(let s=0;s<t;s++){let o=0,i=0;for(let a=0;a<t;a++){const d=r.exponent(s*a,t,n),c=r.getComplexWithIndex(e,a);o+=c.real*d.real-c.imag*d.imag,i+=c.real*d.imag+c.imag*d.real}n&&(o/=t,i/=t),r.assignToTypedArray(a,o,i,s)}return a}(r.mergeRealAndImagArrays(i,d),s,n);return r.splitRealAndImagArrays(e)}var c}const ko={kernelName:Ve,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a}=t,{input:s}=n,o=e.sizeFromShape(s.shape),r=s.shape[s.shape.length-1],i=Ya({inputs:{x:s},backend:a,attrs:{shape:[o/r,r]}}),d=fo(i,!1,a),c=Ya({inputs:{x:d},backend:a,attrs:{shape:s.shape}});return a.disposeIntermediateTensorInfo(i),a.disposeIntermediateTensorInfo(d),c}};function Io(t){const{backend:n,attrs:a}=t,{shape:s,value:o,dtype:r}=a,i=r||e.inferDtype(o),d=e.getArrayFromDType(i,e.sizeFromShape(s));return function(e,t,n){e.fill(t)}(d,o),n.makeTensorInfo(s,i,d)}const go={kernelName:_e,backendName:"cpu",kernelFunc:Io};const bo={kernelName:Be,backendName:"cpu",kernelFunc:({inputs:t,attrs:n,backend:a})=>{const{image:s}=t,o=a,r=e.getTypedArrayFromDType(s.dtype,e.sizeFromShape(s.shape)),[i,d,c,l]=s.shape,p=o.data.get(s.dataId).values;for(let e=0;e<i;e++){const t=e*c*d*l;for(let e=0;e<d;e++){const n=e*(c*l);for(let a=0;a<c;a++){const s=a*l;for(let o=0;o<l;o++){const d=[i,e,a,o][2],u=Math.round(c-d),h=t+n+s+o;let f=p[h];if(u>=0&&u<c){f=p[t+n+u*l+o]}r[h]=f}}}}return{dataId:o.write(r,s.shape,s.dtype),shape:s.shape,dtype:s.dtype}}},yo={kernelName:Le,backendName:"cpu",kernelFunc:Sn(Le,mn((e,t)=>Math.floor(e/t)),null,"int32")};const No={kernelName:qe,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{x:s,filter:o,bias:r,preluActivationWeights:i}=t,{strides:d,pad:c,dataFormat:l,dilations:p,dimRoundingMode:u,activation:h,leakyreluAlpha:f}=a;let m=ws({inputs:{x:s,filter:o},backend:n,attrs:{strides:d,pad:c,dataFormat:l,dilations:p,dimRoundingMode:u}});if(r){const e=m;m=An({inputs:{a:m,b:r},backend:n}),n.disposeIntermediateTensorInfo(e)}if(h){const e=m;m=Ka(n,m,h,i,f),n.disposeIntermediateTensorInfo(e)}return m}};const xo={kernelName:Ge,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{x:s,filter:o,bias:r,preluActivationWeights:i}=t,{strides:d,pad:c,dataFormat:l,dilations:p,dimRoundingMode:u,activation:h,leakyreluAlpha:f}=a;let m=Bs({inputs:{x:s,filter:o},backend:n,attrs:{strides:d,pad:c,dataFormat:l,dilations:p,dimRoundingMode:u}});if(r){const e=m;m=An({inputs:{a:m,b:r},backend:n}),n.disposeIntermediateTensorInfo(e)}if(h){const e=m;m=Ka(n,m,h,i,f),n.disposeIntermediateTensorInfo(e)}return m}};const To={kernelName:Ue,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a}=t,{params:s,indices:o}=n,d=e.sizeFromShape(s.shape),c=o.shape,l=c[c.length-1],[p,u,h,f]=r.prepareAndValidate(s,o);if(0===u)return a.makeTensorInfo(p,s.dtype,[]);const m=i([u,h],s.dtype),k=a.data.get(o.dataId).values,I=a.data.get(s.dataId).values;for(let e=0;e<u;e++){const t=[];let n=0;for(let a=0;a<l;a++){const s=k[e*l+a];n+=s*f[a],t.push(s)}if(n<0||n>=d/h)throw new Error(`Invalid indices: ${t} does not index into ${s.shape}`);for(let t=0;t<h;t++)m.values[e*h+t]=I[n*h+t]}return a.makeTensorInfo(p,m.dtype,m.values)}};const Fo={kernelName:Ze,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o,indices:i}=n,{axis:d,batchDims:c}=s;ln([o,i],"gatherV2");let l=c;null==c&&(l=0);const p=e.sizeFromShape(i.shape),u=e.parseAxisParam(d,o.shape)[0],h=r.segment_util.collectGatherOpShapeInfo(o,i,u,l),f=Ya({inputs:{x:o},backend:a,attrs:{shape:[h.batchSize,h.outerSize,h.dimSize,h.sliceSize]}}),m=Ya({inputs:{x:i},backend:a,attrs:{shape:[h.batchSize,p/h.batchSize]}}),k=[h.batchSize,h.outerSize,p/h.batchSize,h.sliceSize],I=a.bufferSync(m),g=Gn(a.bufferSync(f),I,k);return a.disposeIntermediateTensorInfo(f),a.disposeIntermediateTensorInfo(m),a.makeTensorInfo(h.outputShape,g.dtype,g.values)}},So={kernelName:je,backendName:"cpu",kernelFunc:Sn(je,mn((e,t)=>e>=t?1:0),null,"bool")};const vo={kernelName:Ke,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a}=t,{input:s}=n,o=e.sizeFromShape(s.shape),r=s.shape[s.shape.length-1],i=Ya({inputs:{x:s},backend:a,attrs:{shape:[o/r,r]}}),d=fo(i,!0,a),c=Ya({inputs:{x:d},backend:a,attrs:{shape:s.shape}});return a.disposeIntermediateTensorInfo(i),a.disposeIntermediateTensorInfo(d),c}},Mo={kernelName:Ye,backendName:"cpu",kernelFunc:Hn(Ye,e=>Number.isFinite(e)?1:0,"bool")},Ao={kernelName:Je,backendName:"cpu",kernelFunc:Hn(Je,e=>Math.abs(e)===1/0?1:0,"bool")},wo={kernelName:Qe,backendName:"cpu",kernelFunc:Hn(Qe,e=>Number.isNaN(e)?1:0,"bool")},Do={kernelName:Xe,backendName:"cpu",kernelFunc:Sn(Xe,mn((e,t)=>e<=t?1:0),null,"bool")};const zo={kernelName:et,backendName:"cpu",kernelFunc:function(e){const{backend:t,attrs:n}=e,{start:a,stop:s,num:o}=n,r=Yn(a,s,o);return t.makeTensorInfo([r.length],"float32",r)}},Wo={kernelName:tt,backendName:"cpu",kernelFunc:Hn(tt,e=>Math.log1p(e))},Ho={kernelName:nt,backendName:"cpu",kernelFunc:Sn(nt,mn((e,t)=>e&&t),null,"bool")},Eo={kernelName:at,backendName:"cpu",kernelFunc:Hn(at,e=>e?0:1,"bool")},Co={kernelName:st,backendName:"cpu",kernelFunc:Sn(st,mn((e,t)=>e||t),null,"bool")};const Po={kernelName:ot,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o}=n,{depthRadius:r,bias:i,alpha:d,beta:c}=s;ln(o,"LRN");const l=o.shape[3],p=l-1,u=a.data.get(o.dataId).values,h=e.sizeFromShape(o.shape),f=new Float32Array(h);function m(e){const t=e%l;let n=e-t+Math.max(0,t-r);const a=e-t+Math.min(t+r,p);let s=0;for(;n<=a;n++){const e=u[n];s+=e*e}return s}for(let e=0;e<h;e++){const t=m(e),n=u[e]*Math.pow(i+d*t,-c);f[e]=n}return a.makeTensorInfo(o.shape,o.dtype,f)}};const Ro={kernelName:rt,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o,y:r,dy:i}=n,{depthRadius:d,bias:c,alpha:l,beta:p}=s;ln(i,"LRNGrad");const u=e.sizeFromShape(i.shape),h=i.shape[3],f=a.data.get(i.dataId).values,m=a.data.get(o.dataId).values,k=a.data.get(r.dataId).values,I=new Float32Array(u),g=u;for(let e=0;e<g;e++){const t=e%h,n=e-t+Math.max(0,t-d),a=e-t+Math.min(h,t+d+1);let s=0;for(let e=n;e<a;e++)s+=Math.pow(m[e],2);s=l*s+c;for(let t=n;t<a;t++){let n=-2*l*p*m[t]*k[e]/s;e===t&&(n+=Math.pow(s,-p)),n*=f[e],I[t]+=n}}return a.makeTensorInfo(i.shape,o.dtype,I)}};function $o(t){const{inputs:n,backend:a,attrs:s}=t,{x:o}=n,{reductionIndices:i,keepDims:d}=s,c=a;let l=o.shape;const p=l.length,u=e.parseAxisParam(i,l);let h=u;const f=r.getAxesPermutation(h,p);let m=c.data.get(o.dataId).values;if(null!=f){const e=new Array(p);for(let t=0;t<e.length;t++)e[t]=l[f[t]];m=ua(m,l,o.dtype,f,e),h=r.getInnerMostAxes(h.length,p),l=e}ln(o,"max"),r.assertAxesAreInnerMostDims("max",h,p);const[k,I]=r.computeOutAndReduceShapes(l,h),g=Xn(m,e.sizeFromShape(I),k,o.dtype),b=c.write(g,k,o.dtype);let y=k;if(d){y=r.expandShapeToKeepDim(k,u)}return{dataId:b,shape:y,dtype:o.dtype}}const Oo={kernelName:it,backendName:"cpu",kernelFunc:$o};const Vo={kernelName:dt,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o}=n;ln(o,"maxPool");const{filterSize:i,strides:d,pad:c,dimRoundingMode:l}=s;e.assert(r.eitherStridesOrDilationsAreOne(d,1),()=>`Error in maxPool: Either strides or dilations must be 1. Got strides ${d} and dilations '1'`);const p=r.computePool2DInfo(o.shape,i,d,1,c,l);let u;if(1===p.filterWidth&&1===p.filterHeight&&e.arraysEqual(p.inShape,p.outShape))u=bn({inputs:{x:o},backend:a});else{const t=a.data.get(o.dataId).values,n=e.computeStrides(o.shape),s=hs(t,o.shape,o.dtype,n,p,"max");u=a.makeTensorInfo(p.outShape,o.dtype,s.values)}return u}};const _o={kernelName:ct,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o}=n,{filterSize:i,strides:d,pad:c,dimRoundingMode:l,dataFormat:p}=s;ln(o,"maxPool3d");const u=r.computePool3DInfo(o.shape,i,d,1,c,l,p),h=ms(a.data.get(o.dataId).values,o.shape,o.dtype,e.computeStrides(o.shape),u,"max");return a.makeTensorInfo(h.shape,"float32",h.values)}};const Bo={kernelName:lt,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{dy:s,input:o}=t,{filterSize:d,strides:c,pad:l,dimRoundingMode:p}=a;ln([s,o],"maxPool3DGrad");const u=r.computePool3DInfo(o.shape,d,c,1,l,p),h=function(e,t){const n=i(t.outShape,"int32"),a=t.strideDepth,s=t.strideHeight,o=t.strideWidth,r=t.dilationDepth,d=t.dilationHeight,c=t.dilationWidth,l=t.effectiveFilterDepth,p=t.effectiveFilterHeight,u=t.effectiveFilterWidth,h=t.padInfo.front,f=t.padInfo.top,m=t.padInfo.left;for(let i=0;i<t.batchSize;++i)for(let k=0;k<t.inChannels;++k)for(let I=0;I<t.outDepth;++I){const g=I*a-h;let b=g;for(;b<0;)b+=r;const y=Math.min(t.inDepth,l+g);for(let a=0;a<t.outHeight;++a){const l=a*s-f;let h=l;for(;h<0;)h+=d;const N=Math.min(t.inHeight,p+l);for(let s=0;s<t.outWidth;++s){const f=s*o-m;let x=f;for(;x<0;)x+=c;const T=Math.min(t.inWidth,u+f);let F=Number.NEGATIVE_INFINITY,S=-1;for(let t=b;t<y;t+=r){const n=t-g;for(let a=h;a<N;a+=d){const s=a-l;for(let o=x;o<T;o+=c){const r=o-f,d=e.get(i,t,a,o,k);d>=F&&(F=d,S=n*p*u+s*p+r)}}}n.set(S,i,I,a,s,k)}}}return n}(n.bufferSync(o),u),f=u.strideDepth,m=u.strideHeight,k=u.strideWidth,I=u.dilationDepth,g=u.dilationHeight,b=u.dilationWidth,y=u.effectiveFilterDepth,N=u.effectiveFilterHeight,x=u.effectiveFilterWidth,T=y-1-u.padInfo.front,F=x-1-u.padInfo.left,S=N-1-u.padInfo.top,v=i(o.shape,"float32"),M=n.bufferSync(s);for(let e=0;e<u.batchSize;++e)for(let t=0;t<u.inChannels;++t)for(let n=0;n<u.inDepth;++n)for(let a=0;a<u.inHeight;++a)for(let s=0;s<u.inWidth;++s){const o=n-T,r=a-S,i=s-F;let d=0;for(let n=0;n<y;n+=I){const a=(o+n)/f;if(!(a<0||a>=u.outDepth||Math.floor(a)!==a))for(let s=0;s<N;s+=g){const o=(r+s)/m;if(!(o<0||o>=u.outHeight||Math.floor(o)!==o))for(let r=0;r<x;r+=b){const c=(i+r)/k;if(c<0||c>=u.outWidth||Math.floor(c)!==c)continue;const l=y*N*x-1-h.get(e,a,o,c,t)===n*N*x+s*x+r?1:0;if(0===l)continue;d+=M.get(e,a,o,c,t)*l}}}v.set(d,e,n,a,s,t)}return n.makeTensorInfo(v.shape,v.dtype,v.values)}};const Lo={kernelName:pt,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{dy:s,input:o,output:d}=t,c=o;ln([o,d],"maxPoolGrad");const{filterSize:l,strides:p,pad:u,dimRoundingMode:h}=a,f=r.computePool2DInfo(c.shape,l,p,1,u,h),m=n.data.get(c.dataId).values,k=i(f.outShape,c.dtype,fs(m,c.shape,c.dtype,f).values),I=f.strideHeight,g=f.strideWidth,b=f.dilationHeight,y=f.dilationWidth,N=f.effectiveFilterHeight,x=f.effectiveFilterWidth,T=x-1-f.padInfo.left,F=N-1-f.padInfo.top,S=i(c.shape,"float32"),v=n.data.get(s.dataId).values,M=i(s.shape,"float32",v);for(let e=0;e<f.batchSize;++e)for(let t=0;t<f.inChannels;++t)for(let n=0;n<f.inHeight;++n)for(let a=0;a<f.inWidth;++a){const s=n-F,o=a-T;let r=0;for(let n=0;n<N;n+=b){const a=(s+n)/I;if(!(a<0||a>=f.outHeight||Math.floor(a)!==a))for(let s=0;s<x;s+=y){const i=(o+s)/g;if(i<0||i>=f.outWidth||Math.floor(i)!==i)continue;const d=N*x-1-k.get(e,a,i,t)===n*x+s?1:0;if(0===d)continue;r+=M.get(e,a,i,t)*d}}S.set(r,e,n,a,t)}return n.makeTensorInfo(S.shape,S.dtype,S.values)}};const qo={kernelName:ut,backendName:"cpu",kernelFunc:({inputs:t,attrs:n,backend:a})=>{const{x:s}=t,{filterSize:o,strides:i,pad:d,includeBatchInIndex:c}=n,l=a;ln(s,"MaxPoolWithArgmax");const p=l.data.get(s.dataId).values,u=r.computePool2DInfo(s.shape,o,i,[1,1],d),[h,f]=function(t,n,a,s,o){const r=hs(t,0,a,e.computeStrides(n),o,"max"),i=fs(t,n,a,o,!0,s);return[r.values,i.values]}(p,s.shape,s.dtype,c,u),m=l.write(h,u.outShape,s.dtype),k=l.write(f,u.outShape,s.dtype);return[{dataId:m,shape:u.outShape,dtype:s.dtype},{dataId:k,shape:u.outShape,dtype:"int32"}]}};const Go={kernelName:ht,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o}=n,{axis:i,keepDims:d}=s,c=e.parseAxisParam(i,o.shape),l=r.computeOutAndReduceShapes(o.shape,c)[1],p=e.sizeFromShape(l),u=[],h=a.makeTensorInfo([],"float32",new Float32Array([p]));u.push(h);const f=Tn({inputs:{x:o},backend:a,attrs:{dtype:"float32"}});u.push(f);const m=uo({inputs:{a:f,b:h},backend:a});u.push(m);const k=Ys({inputs:{x:m},backend:a,attrs:{axis:i,keepDims:d}});return u.forEach(e=>a.disposeIntermediateTensorInfo(e)),k}};const Uo={kernelName:ft,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o}=n,{axis:i,keepDims:d}=s;ln(o,"min");const c=e.parseAxisParam(i,o.shape);let l=c;const p=r.getAxesPermutation(l,o.shape.length);let u=o;null!=p&&(u=ha({inputs:{x:o},backend:a,attrs:{perm:p}}),l=r.getInnerMostAxes(l.length,o.shape.length)),r.assertAxesAreInnerMostDims("min",l,u.shape.length);const[h,f]=r.computeOutAndReduceShapes(u.shape,l),m=e.sizeFromShape(f),k=e.makeZerosTypedArray(e.sizeFromShape(h),u.dtype),I=a.data.get(u.dataId).values;for(let e=0;e<k.length;++e){const t=e*m;let n=I[t];for(let e=0;e<m;++e){const a=I[t+e];a<n&&(n=a)}k[e]=n}null!=p&&a.disposeIntermediateTensorInfo(u);const g=a.makeTensorInfo(h,u.dtype,k);if(d){const e=Ya({inputs:{x:g},backend:a,attrs:{shape:r.expandShapeToKeepDim(h,c)}});return a.disposeIntermediateTensorInfo(g),e}return g}};const Zo={kernelName:mt,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o}=n,{paddings:r,mode:i}=s;ln(o,"mirrorPad");const d=r.map((e,t)=>e[0]+o.shape[t]+e[1]),c=r.map(e=>e[0]),l=r.map((e,t)=>e[0]+o.shape[t]),p="reflect"===i?0:1,u=a.data.get(o.dataId).values,h=o.shape.length,f=e.computeStrides(o.shape),m=e.sizeFromShape(d),k=d.length,I=e.computeStrides(d),g=e.getTypedArrayFromDType(o.dtype,m);for(let t=0;t<m;t++){let n=e.indexToLoc(t,k,I);for(let e=0;e<k;e++)n[e]<c[e]?n[e]=2*c[e]-n[e]-p:n[e]>=l[e]&&(n[e]=2*(l[e]-1)-n[e]+p);n=n.map((e,t)=>e-c[t]);const a=e.locToIndex(n,h,f);g[t]=u[a]}return{dataId:a.write(g,d,o.dtype),shape:d,dtype:o.dtype}}},jo={kernelName:kt,backendName:"cpu",kernelFunc:Sn(kt,mn((e,t)=>{const n=e%t;return e<0&&t<0||e>=0&&t>=0?n:(n+t)%t}))};function Ko(t){const{inputs:n,backend:a,attrs:s}=t,{logits:o}=n,{dim:i}=s,d=o.shape.length;let c=i;if(-1===c&&(c=d-1),c!==d-1)throw Error(`Softmax along a non-last dimension is not yet supported. Logits was rank ${d} and dim was ${c}`);const l=e.parseAxisParam([c],o.shape),p=$o({inputs:{x:o},backend:a,attrs:{reductionIndices:l,keepDims:!1}}),u=r.expandShapeToKeepDim(p.shape,l),h=Ya({inputs:{x:p},backend:a,attrs:{shape:u}}),f=wa({inputs:{a:o,b:h},backend:a}),m=On({inputs:{x:f},backend:a}),k=Ys({inputs:{x:m},backend:a,attrs:{axis:l,keepDims:!1}}),I=Ya({inputs:{x:k},backend:a,attrs:{shape:u}}),g=uo({inputs:{a:m,b:I},backend:a});return a.disposeIntermediateTensorInfo(p),a.disposeIntermediateTensorInfo(h),a.disposeIntermediateTensorInfo(f),a.disposeIntermediateTensorInfo(m),a.disposeIntermediateTensorInfo(k),a.disposeIntermediateTensorInfo(I),g}const Yo={kernelName:It,backendName:"cpu",kernelFunc:Ko};const Jo={kernelName:gt,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{logits:o}=n,{numSamples:r,seed:i,normalized:d}=s;ln(o,"multinomial");const c=d?o:Ko({inputs:{logits:o},backend:a,attrs:{dim:-1}}),l=c.shape[0],p=c.shape[1],u=a.data.get(c.dataId).values,h=[l,r],f=e.makeZerosTypedArray(e.sizeFromShape(h),"int32");for(let e=0;e<l;++e){const t=e*p,n=new Float32Array(p-1);n[0]=u[t];for(let e=1;e<n.length;++e)n[e]=n[e-1]+u[t+e];const a=cn(i.toString()),s=e*r;for(let e=0;e<r;++e){const t=a();f[s+e]=n.length;for(let a=0;a<n.length;a++)if(t<n[a]){f[s+e]=a;break}}}return d||a.disposeIntermediateTensorInfo(c),a.makeTensorInfo(h,"int32",f)}},Qo=t.nonMaxSuppressionV3Impl;const Xo={kernelName:bt,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{boxes:s,scores:o}=t,{maxOutputSize:r,iouThreshold:i,scoreThreshold:d}=a;ln(s,"NonMaxSuppression");const c=n.data.get(s.dataId).values,l=n.data.get(o.dataId).values,{selectedIndices:p}=Qo(c,l,r,i,d);return n.makeTensorInfo([p.length],"int32",new Int32Array(p))}},er=t.nonMaxSuppressionV4Impl;const tr={kernelName:yt,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{boxes:s,scores:o}=t,{maxOutputSize:r,iouThreshold:i,scoreThreshold:d,padToMaxOutputSize:c}=a;ln(s,"NonMaxSuppressionPadded");const l=n.data.get(s.dataId).values,p=n.data.get(o.dataId).values,{selectedIndices:u,validOutputs:h}=er(l,p,r,i,d,c);return[n.makeTensorInfo([u.length],"int32",new Int32Array(u)),n.makeTensorInfo([],"int32",new Int32Array([h]))]}},nr=t.nonMaxSuppressionV5Impl;const ar={kernelName:Nt,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{boxes:s,scores:o}=t,{maxOutputSize:r,iouThreshold:i,scoreThreshold:d,softNmsSigma:c}=a;ln(s,"NonMaxSuppressionWithScore");const l=n.data.get(s.dataId).values,p=n.data.get(o.dataId).values,u=r,h=i,f=d,m=c,{selectedIndices:k,selectedScores:I}=nr(l,p,u,h,f,m);return[n.makeTensorInfo([k.length],"int32",new Int32Array(k)),n.makeTensorInfo([I.length],"float32",new Float32Array(I))]}};const sr={kernelName:xt,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{indices:o}=n,{depth:r,onValue:i,offValue:d}=s;ln(o,"oneHot");const c=e.sizeFromShape(o.shape),l=new Float32Array(c*r);l.fill(d);const p=a.data.get(o.dataId).values;for(let e=0;e<c;++e)p[e]>=0&&p[e]<r&&(l[e*r+p[e]]=i);return a.makeTensorInfo([...o.shape,r],"int32",l)}};function or(e){const{inputs:t,backend:n}=e,{x:a}=t;if("string"===a.dtype)throw new Error("zerosLike is not supported for string tensors");if("complex64"===a.dtype){const e=Nn({inputs:{input:a},backend:n}),t=or({inputs:{x:e},backend:n}),s=Ss({inputs:{input:a},backend:n}),o=or({inputs:{x:s},backend:n}),r=kn({inputs:{real:t,imag:o},backend:n});return n.disposeIntermediateTensorInfo(e),n.disposeIntermediateTensorInfo(t),n.disposeIntermediateTensorInfo(s),n.disposeIntermediateTensorInfo(o),r}return Io({backend:n,attrs:{shape:a.shape,value:0,dtype:a.dtype}})}const rr={kernelName:Tt,backendName:"cpu",kernelFunc:or};const ir={kernelName:Ft,backendName:"cpu",kernelFunc:function e(t){const{inputs:n,backend:a}=t,{x:s}=n;if("string"===s.dtype)throw new Error("onesLike is not supported for string tensors");if("complex64"===s.dtype){const t=Nn({inputs:{input:s},backend:a}),n=e({inputs:{x:t},backend:a}),o=Ss({inputs:{input:s},backend:a}),r=or({inputs:{x:o},backend:a}),i=kn({inputs:{real:n,imag:r},backend:a});return a.disposeIntermediateTensorInfo(t),a.disposeIntermediateTensorInfo(n),a.disposeIntermediateTensorInfo(o),a.disposeIntermediateTensorInfo(r),i}return Io({backend:a,attrs:{shape:s.shape,value:1,dtype:s.dtype}})}};function dr(t){const{inputs:n,backend:a,attrs:s}=t,{axis:o}=s;if(1===n.length)return lo({inputs:{input:n[0]},backend:a,attrs:{dim:o}});const r=n[0].shape,i=n[0].dtype;n.forEach(t=>{e.assertShapesMatch(r,t.shape,"All tensors passed to stack must have matching shapes"),e.assert(i===t.dtype,()=>"All tensors passed to stack must have matching dtypes")});const d=[],c=Ms({inputs:n.map(e=>{const t=lo({inputs:{input:e},backend:a,attrs:{dim:o}});return d.push(t),t}),backend:a,attrs:{axis:o}});return d.forEach(e=>a.disposeIntermediateTensorInfo(e)),c}const cr={kernelName:St,backendName:"cpu",kernelFunc:dr};const lr={kernelName:vt,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o}=n,{paddings:r,constantValue:i}=s;ln(o,"pad");const d=r.map((e,t)=>e[0]+o.shape[t]+e[1]),c=r.map(e=>e[0]),l=a.data.get(o.dataId).values,p=e.sizeFromShape(o.shape),u=o.shape.length,h=e.computeStrides(o.shape),f=e.sizeFromShape(d),m=d.length,k=e.computeStrides(d),I=e.getTypedArrayFromDType(o.dtype,f);0!==i&&I.fill(i);for(let t=0;t<p;t++){const n=e.indexToLoc(t,u,h).map((e,t)=>e+c[t]);I[e.locToIndex(n,m,k)]=l[t]}return{dataId:a.write(I,d,o.dtype),shape:d,dtype:o.dtype}}},pr={kernelName:Mt,backendName:"cpu",kernelFunc:Sn(Mt,mn((e,t)=>Math.pow(e,t)))};const ur={kernelName:At,backendName:"cpu",kernelFunc:function(e){const{backend:t,attrs:n}=e,{start:a,stop:s,dtype:o,step:r}=n,i=Ia(a,s,r,o);return t.makeTensorInfo([i.length],o,i)}},hr={kernelName:wt,backendName:"cpu",kernelFunc:Hn(wt,e=>1/e)};const fr={kernelName:Dt,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{images:o}=n,{alignCorners:r,halfPixelCenters:i,size:d}=s;ln(o,"resizeBilinear");const c=e.computeStrides(o.shape),[l,p]=d,[u,h,f,m]=o.shape,k=a.data.get(o.dataId).values,I=new Float32Array(e.sizeFromShape([u,l,p,m])),g=[r&&l>1?h-1:h,r&&p>1?f-1:f],b=[r&&l>1?l-1:l,r&&p>1?p-1:p];let y=0;const N=g[0]/b[0],x=g[1]/b[1];for(let e=0;e<u;e++)for(let t=0;t<l;t++){let n;n=i?N*(t+.5)-.5:N*t;const a=Math.max(0,Math.floor(n)),s=n-a,o=Math.min(h-1,Math.ceil(n)),r=e*c[0]+a*c[1],d=e*c[0]+o*c[1];for(let e=0;e<p;e++){let t;t=i?x*(e+.5)-.5:x*e;const n=Math.max(0,Math.floor(t)),a=t-n,o=Math.min(f-1,Math.ceil(t)),l=r+n*c[2],p=d+n*c[2],u=r+o*c[2],h=d+o*c[2];for(let e=0;e<m;e++){const t=k[l+e],n=k[p+e],o=t+(k[u+e]-t)*a,r=o+(n+(k[h+e]-n)*a-o)*s;I[y++]=r}}}return a.makeTensorInfo([u,l,p,m],"float32",I)}};const mr={kernelName:zt,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{images:o,dy:r}=n,{alignCorners:i}=s;ln([r,o],"resizeBilinearGrad");const d=e.computeStrides(o.shape),[c,l,p,u]=o.shape,[,h,f]=r.shape,m=new Float32Array(c*l*p*u),k=[i&&h>1?l-1:l,i&&f>1?p-1:p],I=[i&&h>1?h-1:h,i&&f>1?f-1:f],g=k[0]/I[0],b=k[1]/I[1],y=a.data.get(r.dataId).values;let N=0;for(let e=0;e<c;e++){const t=e*d[0];for(let e=0;e<h;e++){const n=e*g,a=Math.floor(n),s=Math.min(Math.ceil(n),l-1),o=t+a*d[1],r=t+s*d[1],i=n-a,c=1-i;for(let e=0;e<f;e++){const t=e*b,n=Math.floor(t),a=Math.min(Math.ceil(t),p-1),s=t-n,l=1-s,h=o+n*d[2],f=o+a*d[2],k=r+n*d[2],I=r+a*d[2],g=c*l,x=c*s,T=i*l,F=i*s;for(let e=0;e<u;e++){const t=y[N++];m[h+e]+=t*g,m[f+e]+=t*x,m[k+e]+=t*T,m[I+e]+=t*F}}}}return a.makeTensorInfo([c,p,l,u],"float32",m)}};const kr={kernelName:Wt,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{images:o}=n,{alignCorners:r,halfPixelCenters:i,size:d}=s;ln(o,"resizeNearestNeighbor");const c=e.computeStrides(o.shape),[l,p]=d,[u,h,f,m]=o.shape,k=a.data.get(o.dataId).values,I=new Float32Array(u*l*p*m),g=[r&&l>1?h-1:h,r&&p>1?f-1:f],b=[r&&l>1?l-1:l,r&&p>1?p-1:p],y=g[0]/b[0],N=g[1]/b[1];let x=0;for(let e=0;e<u;e++){const t=e*c[0];for(let e=0;e<l;e++){const n=i?y*(e+.5):y*e;let a=Math.min(h-1,r?Math.round(n):Math.floor(n));i&&(a=Math.max(0,a));const s=t+a*c[1];for(let e=0;e<p;e++){const t=i?N*(e+.5):N*e;let n=Math.min(f-1,r?Math.round(t):Math.floor(t));i&&(n=Math.max(0,n));const a=s+n*c[2];for(let e=0;e<m;e++){const t=k[a+e];I[x++]=t}}}}return a.makeTensorInfo([u,l,p,m],o.dtype,I)}};const Ir={kernelName:Ht,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{images:o,dy:r}=n,{alignCorners:i}=s;ln([r,o],"resizeNearestNeighborGrad");const d=e.computeStrides(o.shape),c=e.computeStrides(r.shape),[l,p,u,h]=o.shape,[,f,m]=r.shape,k=new Float32Array(l*p*u*h),I=a.data.get(r.dataId).values,g=[i&&f>1?p-1:p,i&&m>1?u-1:u],b=[i&&f>1?f-1:f,i&&m>1?m-1:m],y=g[0]/b[0],N=g[1]/b[1],x=1/y,T=1/N,F=2*Math.ceil(x)+2,S=2*Math.ceil(T)+2;for(let e=0;e<l;e++){const t=e*d[0];for(let e=0;e<p;e++){const n=t+e*d[1],a=Math.floor(e*x),s=Math.floor(a-F/2);for(let a=0;a<u;a++){const o=n+a*d[2],r=Math.floor(a*T),l=Math.floor(r-S/2);for(let n=0;n<h;n++){let r=0;for(let o=0;o<F;o++){const d=o+s;if(d<0||d>=f)continue;const h=t+d*c[1],k=d*y;if(e===Math.min(p-1,i?Math.round(k):Math.floor(k)))for(let e=0;e<S;e++){const t=e+l;if(t<0||t>=m)continue;const s=h+t*c[2],o=t*N;a===Math.min(u-1,i?Math.round(o):Math.floor(o))&&(r+=I[s+n])}}k[o+n]=r}}}}return a.makeTensorInfo(o.shape,o.dtype,k)}};const gr={kernelName:Et,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o}=n,{dims:r}=s;ln(o,"reverse");const i=o.shape.length,d=e.parseAxisParam(r,o.shape);if(0===i)return bn({inputs:{x:o},backend:a});const c=new E(o.shape,o.dtype),l=a.bufferSync(o);for(let e=0;e<c.size;e++){const t=c.indexToLoc(e),n=t.slice();d.forEach(e=>n[e]=o.shape[e]-1-n[e]),c.set(l.get(...n),...t)}return a.makeTensorInfo(c.shape,c.dtype,c.values)}},br={kernelName:Ct,backendName:"cpu",kernelFunc:({inputs:t,attrs:n,backend:a})=>{const{image:s}=t,{radians:o,fillValue:i,center:d}=n,c=a,l=e.getTypedArrayFromDType(s.dtype,e.sizeFromShape(s.shape)),[p,u,h,f]=s.shape,[m,k]=r.getImageCenter(d,u,h),I=Math.sin(o),g=Math.cos(o),b=c.data.get(s.dataId).values;for(let e=0;e<p;e++){const t=e*h*u*f;for(let e=0;e<u;e++){const n=e*(h*f);for(let a=0;a<h;a++){const s=a*f;for(let o=0;o<f;o++){const r=[p,e,a,o],d=r[2],c=r[1];let y=(d-m)*g-(c-k)*I,N=(d-m)*I+(c-k)*g;y=Math.round(y+m),N=Math.round(N+k);let x=i;if("number"!=typeof i&&(x=3===o?255:i[o]),y>=0&&y<h&&N>=0&&N<u){x=b[t+N*(h*f)+y*f+o]}l[t+n+s+o]=x}}}}return{dataId:c.write(l,s.shape,s.dtype),shape:s.shape,dtype:s.dtype}}},yr={kernelName:Pt,backendName:"cpu",kernelFunc:Hn(Pt,e=>{const t=Math.floor(e);return e-t<.5?Math.floor(e):e-t>.5?Math.ceil(e):t%2==0?t:t+1})};function Nr(e,t,n,a,s,o,r,d,c,l){const p=[a/s,s],u=e.values,h=t.values;if(0===a)return i(n,t.dtype);const f=i(p,t.dtype);f.values.fill(c);for(let e=0;e<o;e++){const o=[];let i=0;for(let t=0;t<r;t++){const n=u[e*r+t];o.push(n),i+=n*d[t]}if(i<0||i>=a/s)throw new Error(`Invalid indices: ${o} does not index into ${n}`);for(let n=0;n<s;n++)l?f.values[i*s+n]+=h[e*s+n]:f.values[i*s+n]=0===t.rank?h[0]:h[e*s+n]}return f}const xr={kernelName:Rt,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{indices:s,updates:o}=t,{shape:i}=a,{sliceRank:d,numUpdates:c,sliceSize:l,strides:p,outputSize:u}=r.calculateShapes(o,s,i),h=Nr(n.bufferSync(s),n.bufferSync(o),i,u,l,c,d,p,0,!0);return n.makeTensorInfo(i,h.dtype,h.values)}};const Tr={kernelName:$t,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a}=t,{condition:s,t:o,e:r}=n;ln([s,o,r],"select");const i=s.shape.length,d=a.data.get(s.dataId).values,c=a.data.get(o.dataId).values,l=a.data.get(r.dataId).values,p=M(o.dtype,r.dtype),u=e.makeZerosTypedArray(e.sizeFromShape(o.shape),p);let h=0;const f=0===i||i>1||1===o.shape.length?1:e.sizeFromShape(o.shape.slice(1));for(let e=0;e<d.length;e++)for(let t=0;t<f;t++)1===d[e]?u[h++]=c[e]:u[h++]=l[e];return a.makeTensorInfo(o.shape,p,u)}},Fr=r.SELU_SCALEALPHA,Sr=r.SELU_SCALE,vr={kernelName:Ot,backendName:"cpu",kernelFunc:Hn(Ot,e=>e>=0?Sr*e:Fr*(Math.exp(e)-1))},Mr={kernelName:Vt,backendName:"cpu",kernelFunc:Hn(Vt,e=>e<0?-1:e>0?1:0)},Ar={kernelName:_t,backendName:"cpu",kernelFunc:Hn(_t,e=>Math.sin(e))},wr={kernelName:Bt,backendName:"cpu",kernelFunc:Hn(Bt,e=>Math.sinh(e))},Dr=Math.log(1.1920928955078125e-7)+2,zr={kernelName:Lt,backendName:"cpu",kernelFunc:Hn(Lt,e=>{const t=e>-Dr,n=e<Dr,a=Math.exp(e);let s;return s=n?a:t?e:Math.log(1+a),s})};const Wr={kernelName:qt,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o}=n,{blockShape:i,paddings:d}=s;ln([o],"spaceToBatchND");const c=e.sizeFromShape(i),l=[[0,0]];l.push(...d);for(let e=1+i.length;e<o.shape.length;++e)l.push([0,0]);const p=lr.kernelFunc({inputs:{x:o},backend:a,attrs:{paddings:l,constantValue:0}}),u=r.getReshaped(p.shape,i,c,!1),h=r.getPermuted(u.length,i.length,!1),f=r.getReshapedPermuted(p.shape,i,c,!1),m=Ya({inputs:{x:p},backend:a,attrs:{shape:u}}),k=ha({inputs:{x:m},backend:a,attrs:{perm:h}}),I=Ya({inputs:{x:k},backend:a,attrs:{shape:f}});return a.disposeIntermediateTensorInfo(p),a.disposeIntermediateTensorInfo(m),a.disposeIntermediateTensorInfo(k),I}};const Hr={kernelName:Gt,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{indices:a,values:s,denseShape:o,defaultValue:r}=t;if(1!==o.shape.length)throw new Error("Dense shape must be a vector, saw:\n        "+o.shape);if(2!==a.shape.length)throw new Error("Indices must be a matrix, saw:\n        "+a.shape);if(1!==s.shape.length)throw new Error("Values must be a vector, saw:\n        "+s.shape);if(0!==r.shape.length)throw new Error("Default value must be a scalar, saw:\n        "+r.shape);const i=n.data.get(a.dataId).values,d=n.data.get(s.dataId).values,c=n.data.get(o.dataId).values,l=n.data.get(r.dataId).values[0],[p,u,h,f,m]=Ta(i,a.shape,a.dtype,d,s.dtype,c,l);return[n.makeTensorInfo(u,a.dtype,p),n.makeTensorInfo([u[0]],s.dtype,h),n.makeTensorInfo([f.length],"bool",new Uint8Array(f.map(e=>Number(e)))),n.makeTensorInfo([m.length],a.dtype,new Int32Array(m))]}};const Er={kernelName:Ut,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{inputIndices:a,inputShape:s,newShape:o}=t;if(2!==a.shape.length)throw new Error("Input indices should be a matrix but received shape\n        "+a.shape);if(1!==s.shape.length)throw new Error("Input shape should be a vector but received shape\n        "+s.shape);if(1!==o.shape.length)throw new Error("Target shape should be a vector but received shape "+o.shape);const r=Array.from(n.data.get(s.dataId).values),i=n.data.get(a.dataId).values,d=Array.from(n.data.get(o.dataId).values),[c,l,p]=Fa(i,a.shape,a.dtype,r,d);return[n.makeTensorInfo(l,a.dtype,c),n.makeTensorInfo([p.length],o.dtype,new Int32Array(p))]}};const Cr={kernelName:Zt,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{sparseIndices:s,sparseValues:o,defaultValue:i}=t,{outputShape:d}=a,{sliceRank:c,numUpdates:l,sliceSize:p,strides:u,outputSize:h}=r.calculateShapes(o,s,d),f=Nr(n.bufferSync(s),n.bufferSync(o),d,h,p,l,c,u,n.data.get(i.dataId).values[0],!1);return n.makeTensorInfo(d,f.dtype,f.values)}};const Pr={kernelName:jt,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o}=n,{numOrSizeSplits:i,axis:d}=s,c=e.parseAxisParam(d,o.shape)[0],l=r.prepareSplitSize(o,i,c),p=new Array(o.shape.length).fill(0),u=o.shape.slice();return l.map(e=>{const t=[...u];t[c]=e;const n=Na({inputs:{x:o},backend:a,attrs:{begin:p,size:t}});return p[c]+=e,n})}},Rr={kernelName:Kt,backendName:"cpu",kernelFunc:Hn(Kt,e=>Math.sqrt(e))},$r={kernelName:Yt,backendName:"cpu",kernelFunc:({inputs:e,backend:t})=>{const{x:n}=e,a=t;ln(n,"square");const s=a.data.get(n.dataId).values,o=new Float32Array(s.length);for(let e=0;e<s.length;++e){const t=s[e];o[e]=t*t}return{dataId:a.write(o,n.shape,n.dtype),shape:n.shape,dtype:n.dtype}}},Or={kernelName:Jt,backendName:"cpu",kernelFunc:Hn(Jt,(e,t)=>{const n=t;return isNaN(e)?NaN:e>0?1:n.alpha})};const Vr={kernelName:Qt,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{x:s}=t,{begin:o,end:r,strides:i,beginMask:d,endMask:c,ellipsisMask:l,newAxisMask:p,shrinkAxisMask:u}=a;ln(s,"stridedSlice");const{nonStrided:h,$begin:f,$strides:m,size:k,newShape:I,outShape:g}=D.sliceInfo(s.shape,o,r,i,d,c,l,p,u),b=Ya({inputs:{x:s},backend:n,attrs:{shape:I}});let y;if(h){const e=Na({inputs:{x:b},backend:n,attrs:{begin:f,size:k}});y=Ya({inputs:{x:e},backend:n,attrs:{shape:g}}),n.disposeIntermediateTensorInfo(e)}else if(g.some(e=>0===e))y=n.makeTensorInfo(g,s.dtype,[]);else{const e=Ma(g,n.bufferSync(b),m,f);y=n.makeTensorInfo(e.shape,e.dtype,e.values)}const N=Ya({inputs:{x:y},backend:n,attrs:{shape:g}});return n.disposeIntermediateTensorInfo(b),n.disposeIntermediateTensorInfo(y),N}},_r={kernelName:Xt,backendName:"cpu",kernelFunc:Hn(Xt,e=>Math.tan(e))},Br=Hn(en,e=>Math.tanh(e));function Lr(t,n,a){switch(a){case"reflect":return function(t,n){let a=t;if(a<0)if(n<=1)a=0;else{const e=2*n;a<e&&(a=e*Math.trunc(-a/e)+a),a=a<-n?a+e:-a-1}else if(a>n-1)if(n<=1)a=0;else{const e=2*n;a-=e*Math.trunc(a/e),a>=n&&(a=e-a-1)}return e.clamp(0,a,n-1)}(t,n);case"wrap":return function(t,n){let a=t;if(a<0)if(n<=1)a=0;else{const e=n-1;a+=n*(Math.trunc(-a/e)+1)}else if(a>n-1)if(n<=1)a=0;else{const e=n-1;a-=n*Math.trunc(a/e)}return e.clamp(0,a,n-1)}(t,n);case"nearest":return function(t,n){return e.clamp(0,t,n-1)}(t,n);case"constant":default:return function(e,t){return e}(t)}}function qr(e,t,n,a,s,o,r,i,d,c,l){return 0<=i&&i<t&&0<=d&&d<n?e[r*a+i*s+d*o+c]:l}function Gr(e,t,n,a,s,o,r,i,d,c,l){return qr(e,t,n,a,s,o,r,Math.round(i),Math.round(d),c,l)}function Ur(e,t,n,a,s,o,r,i,d,c,l){const p=Math.floor(i),u=Math.floor(d),h=p+1,f=u+1;return(h-i)*((f-d)*qr(e,t,n,a,s,o,r,p,u,c,l)+(d-u)*qr(e,t,n,a,s,o,r,p,f,c,l))+(i-p)*((f-d)*qr(e,t,n,a,s,o,r,h,u,c,l)+(d-u)*qr(e,t,n,a,s,o,r,h,f,c,l))}const Zr=[es,fn,ts,ns,wn,as,ss,os,rs,is,ds,cs,ls,ps,us,ks,Is,gs,bs,Xa,ys,Ns,xs,Fn,Pn,Ts,In,Fs,As,zs,Ws,Ds,Es,Cs,Hs,Ps,Rs,$s,Os,Vs,_s,Ls,qs,Gs,Us,Zs,Ks,js,ho,Qs,Ra,Xs,to,co,Vn,po,Bn,ko,go,bo,qn,yo,No,xo,To,Fo,Zn,So,yn,vo,vs,Mo,Ao,wo,Oa,Kn,Do,zo,Qn,Wo,Ho,Eo,Co,Po,Ro,ta,Vo,_o,Bo,Lo,qo,Oo,Go,Uo,aa,Zo,jo,Jo,ia,ca,Xo,tr,ar,pa,sr,ir,cr,lr,pr,Ba,ka,ur,xn,hr,qa,Ua,Ja,fr,mr,kr,Ir,gr,br,yr,ba,xr,Tr,vr,ja,Mr,Ar,wr,xa,Yo,zr,Wr,Hr,Er,Cr,Pr,Rr,$r,va,Or,Vr,Da,Js,_r,{kernelName:en,backendName:"cpu",kernelFunc:Br},{kernelName:tn,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{x:s}=t,{reps:o}=a;ln(s,"tile");const r=za(n.bufferSync(s),o);return n.makeTensorInfo(r.shape,r.dtype,r.values)}},{kernelName:nn,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{x:s}=t,{k:o,sorted:r}=a;ln(s,"topk");const i=n.data.get(s.dataId).values,[d,c]=Wa(i,s.shape,s.dtype,o);return[n.makeTensorInfo(d.shape,d.dtype,d.values),n.makeTensorInfo(c.shape,c.dtype,c.values)]}},fa,{kernelName:an,backendName:"cpu",kernelFunc:function(t){const{inputs:n,attrs:a,backend:s}=t,{image:o,transforms:r}=n,{interpolation:i,fillMode:d,fillValue:c,outputShape:l}=a,[p,u,h,f]=o.shape,[m,k]=null!=l?l:[u,h],I=[p,m,k,f],g=e.computeStrides(o.shape),b=g[0],y=g[1],N=g[2],x=e.getTypedArrayFromDType(o.dtype,e.sizeFromShape(I));x.fill(c);const T=s.data.get(o.dataId).values,F=s.data.get(r.dataId).values;for(let e=0;e<p;++e){const t=1===r.shape[0]?F:F.subarray(8*e,8*e+8);for(let n=0;n<m;++n)for(let a=0;a<k;++a)for(let s=0;s<f;++s){let o;const r=t[6]*a+t[7]*n+1;if(0===r)continue;const l=(t[0]*a+t[1]*n+t[2])/r,p=(t[3]*a+t[4]*n+t[5])/r,f=Lr(l,h,d),m=Lr(p,u,d);switch(i){case"nearest":o=Gr(T,u,h,b,y,N,e,m,f,s,c);break;case"bilinear":o=Ur(T,u,h,b,y,N,e,m,f,s,c);break;default:throw new Error("Error in Transform: Expect 'nearest' or 'bilinear', but got "+i)}x[e*b+n*y+a*N+s]=o}return s.makeTensorInfo(I,o.dtype,x)}return{dataId:s.write(x,I,o.dtype),shape:o.shape,dtype:o.dtype}}},{kernelName:sn,backendName:"cpu",kernelFunc:function(e){const{inputs:t,attrs:n,backend:a}=e,{axis:s}=n,{x:o}=t;ln(o,"unique");const r=a.data.get(o.dataId).values,{outputValues:i,outputShape:d,indices:c}=Ha(r,s,o.shape,o.dtype);return[a.makeTensorInfo(d,o.dtype,i),a.makeTensorInfo([c.length],"int32",c)]}},{kernelName:on,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{value:s}=t;let{axis:o}=a;o<0&&(o+=s.shape.length);const r=s.shape.length,i=s.shape[o],d=new Array(r-1);let c=0;for(let e=0;e<r;e++)e!==o&&(d[c++]=s.shape[e]);const l=new Array(r).fill(0),p=s.shape.slice();p[o]=1;const u=new Array(i);for(let e=0;e<u.length;e++){l[o]=e;const t=Na({inputs:{x:s},backend:n,attrs:{begin:l,size:p}});u[e]=Ya({inputs:{x:t},backend:n,attrs:{shape:d}}),n.disposeIntermediateTensorInfo(t)}return u}},{kernelName:rn,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:o,segmentIds:r}=n,{numSegments:i}=s;ln(o,"unsortedSegmentSum");const d=[],c=[],l=o.shape.length-r.shape.length;let p=r;for(let e=0;e<l;++e){const t=lo({inputs:{input:p},backend:a,attrs:{dim:e+1}});p=t,c.push(t)}for(let t=0;t<i;++t){const n=e.createScalarValue(t,"int32"),s=a.makeTensorInfo([],"int32",n),r=eo({inputs:{a:s,b:p},backend:a}),i=Tn({inputs:{x:r},backend:a,attrs:{dtype:"float32"}}),l=ra({inputs:{a:i,b:o},backend:a}),u=Ys({inputs:{x:l},backend:a,attrs:{axis:0,keepDims:!1}});d.push(u),c.push(s),c.push(r),c.push(i),c.push(l),c.push(u)}const u=dr({inputs:d,backend:a,attrs:{axis:0}});return c.forEach(e=>a.disposeIntermediateTensorInfo(e)),u}},rr];for(const e of Zr)dn(e);export{un as MathBackendCPU,Ea as shared,Ca as version_cpu};
//# sourceMappingURL=tf-backend-cpu.fesm.min.js.map
