/**
 * @license
 * Copyright 2021 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
!function(e,a){"object"==typeof exports&&"undefined"!=typeof module?a(exports,require("@tensorflow/tfjs-core"),require("seedrandom")):"function"==typeof define&&define.amd?define(["exports","@tensorflow/tfjs-core","seedrandom"],a):a((e=e||self).tf=e.tf||{},e.tf,e.seedrandom)}(this,(function(e,a,t){"use strict";var n=function(e,a){return(n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,a){e.__proto__=a}||function(e,a){for(var t in a)a.hasOwnProperty(t)&&(e[t]=a[t])})(e,a)};function r(e,a,t,n){return new(t||(t=Promise))((function(r,i){function s(e){try{u(n.next(e))}catch(e){i(e)}}function o(e){try{u(n.throw(e))}catch(e){i(e)}}function u(e){var a;e.done?r(e.value):(a=e.value,a instanceof t?a:new t((function(e){e(a)}))).then(s,o)}u((n=n.apply(e,a||[])).next())}))}function i(e,a){var t,n,r,i,s={label:0,sent:function(){if(1&r[0])throw r[1];return r[1]},trys:[],ops:[]};return i={next:o(0),throw:o(1),return:o(2)},"function"==typeof Symbol&&(i[Symbol.iterator]=function(){return this}),i;function o(i){return function(o){return function(i){if(t)throw new TypeError("Generator is already executing.");for(;s;)try{if(t=1,n&&(r=2&i[0]?n.return:i[0]?n.throw||((r=n.return)&&r.call(n),0):n.next)&&!(r=r.call(n,i[1])).done)return r;switch(n=0,r&&(i=[2&i[0],r.value]),i[0]){case 0:case 1:r=i;break;case 4:return s.label++,{value:i[1],done:!1};case 5:s.label++,n=i[1],i=[0];continue;case 7:i=s.ops.pop(),s.trys.pop();continue;default:if(!(r=s.trys,(r=r.length>0&&r[r.length-1])||6!==i[0]&&2!==i[0])){s=0;continue}if(3===i[0]&&(!r||i[1]>r[0]&&i[1]<r[3])){s.label=i[1];break}if(6===i[0]&&s.label<r[1]){s.label=r[1],r=i;break}if(r&&s.label<r[2]){s.label=r[2],s.ops.push(i);break}r[2]&&s.ops.pop(),s.trys.pop();continue}i=a.call(e,s)}catch(e){i=[6,e],n=0}finally{t=r=0}if(5&i[0])throw i[1];return{value:i[0]?i[1]:void 0,done:!0}}([i,o])}}}function s(e,t){Array.isArray(e)||(e=[e]),e.forEach((function(e){null!=e&&a.util.assert("complex64"!==e.dtype,(function(){return t+" does not support complex64 tensors in the CPU backend."}))}))}var o=a.kernel_impls.whereImpl,u=function(e){function t(){var t=e.call(this)||this;return t.blockSize=48,t.firstUse=!0,t.data=new a.DataStorage(t,a.engine()),t}return function(e,a){function t(){this.constructor=e}n(e,a),e.prototype=null===a?Object.create(a):(t.prototype=a.prototype,new t)}(t,e),t.prototype.nextDataId=function(){return t.nextDataId++},t.prototype.write=function(e,t,n){this.firstUse&&(this.firstUse=!1,a.env().get("IS_NODE")&&a.backend_util.warn("\n============================\nHi there 👋. Looks like you are running TensorFlow.js in Node.js. To speed things up dramatically, install our node backend, which binds to TensorFlow C++, by running npm i @tensorflow/tfjs-node, or npm i @tensorflow/tfjs-node-gpu if you have CUDA. Then call require('@tensorflow/tfjs-node'); (-gpu suffix for CUDA) at the start of your program. Visit https://github.com/tensorflow/tfjs-node for more details.\n============================"));var r={id:this.nextDataId()};return this.data.set(r,{values:e,dtype:n,refCount:1}),r},t.prototype.makeTensorInfo=function(e,t,n){var r;if("string"===t&&null!=n&&n.length>0&&a.util.isString(n[0])){var i=n.map((function(e){return a.util.encodeString(e)}));r=this.write(i,e,t)}else r=this.write(n,e,t);return{dataId:r,shape:e,dtype:t}},t.prototype.refCount=function(e){return this.data.has(e)?this.data.get(e).refCount:0},t.prototype.incRef=function(e){this.data.get(e).refCount++},t.prototype.decRef=function(e){this.data.has(e)&&this.data.get(e).refCount--},t.prototype.move=function(e,a,t,n,r){this.data.set(e,{values:a,dtype:n,refCount:r})},t.prototype.numDataIds=function(){return this.data.numDataIds()},t.prototype.read=function(e){return r(this,void 0,void 0,(function(){return i(this,(function(a){return[2,this.readSync(e)]}))}))},t.prototype.readSync=function(e){var t=this.data.get(e),n=t.dtype,r=t.complexTensorInfos;if("complex64"===n){var i=this.readSync(r.real.dataId),s=this.readSync(r.imag.dataId);return a.backend_util.mergeRealAndImagArrays(i,s)}return this.data.get(e).values},t.prototype.bufferSync=function(e){var t=this.readSync(e.dataId),n=t;if("string"===e.dtype)try{n=t.map((function(e){return a.util.decodeString(e)}))}catch(e){throw new Error("Failed to decode encoded string bytes into utf-8")}return a.buffer(e.shape,e.dtype,n)},t.prototype.makeOutput=function(e,t,n){var r=this.write(e,t,n);return a.engine().makeTensorFromDataId(r,t,n,this)},t.prototype.disposeData=function(e,a){if(void 0===a&&(a=!1),this.data.has(e)){if(this.data.get(e).refCount--,!a&&this.data.get(e).refCount>0)return!1;var t=this.data.get(e).complexTensorInfos;null!=t&&(this.disposeData(t.real.dataId,!0),this.disposeData(t.imag.dataId,!0)),this.data.delete(e)}return!0},t.prototype.disposeIntermediateTensorInfo=function(e){this.disposeData(e.dataId)},t.prototype.time=function(e){return r(this,void 0,void 0,(function(){var t;return i(this,(function(n){return t=a.util.now(),e(),[2,{kernelMs:a.util.now()-t}]}))}))},t.prototype.memory=function(){return{unreliable:!0,reasons:["The reported memory is an upper bound. Due to automatic garbage collection, the true allocated memory may be less."]}},t.prototype.where=function(e){s([e],"where");var a=this.readSync(e.dataId);return o(e.shape,a)},t.prototype.dispose=function(){},t.prototype.floatPrecision=function(){return 32},t.prototype.epsilon=function(){return e.prototype.epsilon.call(this)},t.nextDataId=0,t}(a.KernelBackend);function d(e){for(var a=new Float32Array(e.length),t=0;t<e.length;++t)a[t]=Math.abs(e[t]);return a}var p={kernelName:a.Abs,backendName:"cpu",kernelFunc:function(e){var t=e.inputs.x,n=e.backend;s(t,"abs");var r=new Float32Array(a.util.sizeFromShape(t.shape));return r=d(n.data.get(t.dataId).values),n.makeOutput(r,t.shape,"float32")}};function l(e){return function(t,n,r,i,s){var o=a.backend_util.assertAndGetBroadcastShape(t,n),u=o.length,d=a.util.computeStrides(o),p=a.util.sizeFromShape(o),l=a.util.getTypedArrayFromDType(s,p),c=t.length,f=n.length,h=a.util.computeStrides(t),m=a.util.computeStrides(n),v=a.backend_util.getBroadcastDims(t,o),k=a.backend_util.getBroadcastDims(n,o);if(v.length+k.length===0)for(var b=0;b<l.length;++b)l[b]=e(r[b%r.length],i[b%i.length]);else{var g=function(t){var n=a.util.indexToLoc(t,u,d),s=n.slice(-c);v.forEach((function(e){return s[e]=0}));var o=a.util.locToIndex(s,c,h),p=n.slice(-f);k.forEach((function(e){return p[e]=0}));var b=a.util.locToIndex(p,f,m);l[t]=e(r[o],i[b])};for(b=0;b<l.length;++b)g(b)}return[l,o]}}function c(e){var a=e.inputs,t=e.backend,n=a.real,r=a.imag,i=t.data.get(n.dataId).values,s=t.data.get(r.dataId).values,o=t.makeTensorInfo(n.shape,"complex64");return t.data.get(o.dataId).complexTensorInfos={real:t.makeTensorInfo(n.shape,"float32",i),imag:t.makeTensorInfo(r.shape,"float32",s)},o}var f={kernelName:a.Complex,backendName:"cpu",kernelFunc:c};function h(e,t,n){if(void 0===n&&(n="float32"),"complex64"===n)return c({inputs:{real:h(e,t,"float32"),imag:h(e,t,"float32")},backend:e});var r=a.util.makeZerosTypedArray(a.util.sizeFromShape(t),n);return e.makeTensorInfo(t,n,r)}function m(e){var a=e.inputs,t=e.backend,n=a.x;return t.incRef(n.dataId),{dataId:n.dataId,shape:n.shape,dtype:n.dtype}}var v={kernelName:a.Identity,backendName:"cpu",kernelFunc:m};function k(e){var a=e.inputs,t=e.backend,n=a.input,r=t.data.get(n.dataId).complexTensorInfos.real,i=t.data.get(r.dataId).values;return t.makeTensorInfo(r.shape,r.dtype,i)}var b={kernelName:a.Real,backendName:"cpu",kernelFunc:k};function g(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,s=r.dtype;if("complex64"===s){if("complex64"===i.dtype)return m({inputs:{x:i},backend:n});var o=h(n,i.shape,i.dtype),u=g({inputs:{x:i},backend:n,attrs:{dtype:"float32"}}),d=c({inputs:{real:u,imag:o},backend:n});return n.disposeIntermediateTensorInfo(o),n.disposeIntermediateTensorInfo(u),d}if("complex64"===i.dtype){var p=k({inputs:{input:i},backend:n}),d=g({inputs:{x:p},backend:n,attrs:{dtype:s}});return n.disposeIntermediateTensorInfo(p),d}if(!a.util.hasEncodingLoss(i.dtype,s))return{dataId:(d=m({inputs:{x:i},backend:n})).dataId,shape:d.shape,dtype:s};if("int32"===s){var f=n.data.get(i.dataId).values,v=Int32Array.from(f);return n.makeTensorInfo(i.shape,"int32",v)}if("bool"===s){var b=n.data.get(i.dataId).values,I=a.util.toTypedArray([0],i.dtype),y=l((function(e,a){return e!==a?1:0}))(i.shape,[],b,I,"bool"),N=y[0],x=y[1];return n.makeTensorInfo(x,"bool",N)}throw new Error("Error in Cast: failed to cast "+i.dtype+" to "+s)}var I={kernelName:a.Cast,backendName:"cpu",kernelFunc:g};function y(e,a,t,n){return null==t?function(t){var r=t.inputs,i=t.backend,o=r,u=o.a,d=o.b,p=i;s([u,d],e);var l=p.data.get(u.dataId).values,c=p.data.get(d.dataId).values,f=n||u.dtype,h=a(u.shape,d.shape,l,c,f),m=h[0],v=h[1];return p.makeTensorInfo(v,f,m)}:function(e){var r=e.inputs,i=e.backend,s=r,o=s.a,u=s.b,d=i;if("complex64"===o.dtype||"complex64"===u.dtype){var p=g({inputs:{x:o},backend:d,attrs:{dtype:"complex64"}}),l=d.data.get(p.dataId),f=l.complexTensorInfos.real,h=l.complexTensorInfos.imag,m=d.data.get(f.dataId).values,v=d.data.get(h.dataId).values,k=g({inputs:{x:u},backend:d,attrs:{dtype:"complex64"}}),b=d.data.get(k.dataId),I=b.complexTensorInfos.real,y=b.complexTensorInfos.imag,N=d.data.get(I.dataId).values,x=d.data.get(y.dataId).values,T=t(o.shape,u.shape,m,v,N,x),S=T[0],F=T[1],M=T[2],A=d.makeTensorInfo(M,"float32",S),w=d.makeTensorInfo(M,"float32",F),D=c({inputs:{real:A,imag:w},backend:d});return d.disposeIntermediateTensorInfo(p),d.disposeIntermediateTensorInfo(k),d.disposeIntermediateTensorInfo(A),d.disposeIntermediateTensorInfo(w),D}var _=d.data.get(o.dataId).values,z=d.data.get(u.dataId).values,E=n||o.dtype,C=a(o.shape,u.shape,_,z,E),W=C[0];M=C[1];return d.makeTensorInfo(M,E,W)}}function N(e){return function(t,n,r,i,s,o){var u=a.backend_util.assertAndGetBroadcastShape(t,n),d=a.util.sizeFromShape(u),p=u.length,l=a.util.computeStrides(u),c=a.util.getTypedArrayFromDType("float32",d),f=a.util.getTypedArrayFromDType("float32",d),h=a.backend_util.getBroadcastDims(t,u),m=a.backend_util.getBroadcastDims(n,u),v=a.backend_util.mergeRealAndImagArrays(r,i),k=a.backend_util.mergeRealAndImagArrays(s,o),b=t.length,g=a.util.computeStrides(t),I=n.length,y=a.util.computeStrides(n);if(h.length+m.length===0)for(var N=0;N<c.length;N++){var x=N%v.length,T=N%k.length,S=e(v[2*x],v[2*x+1],k[2*T],k[2*T+1]);c[N]=S.real,f[N]=S.imag}else{var F=function(t){var n=a.util.indexToLoc(t,p,l),r=n.slice(-b);h.forEach((function(e){return r[e]=0}));var i=a.util.locToIndex(r,b,g),s=n.slice(-I);m.forEach((function(e){return s[e]=0}));var o=a.util.locToIndex(s,I,y),u=e(v[2*i],v[2*i+1],k[2*o],k[2*o+1]);c[t]=u.real,f[t]=u.imag};for(N=0;N<c.length;N++)F(N)}return[c,f,u]}}var x=l((function(e,a){return e+a})),T=N((function(e,a,t,n){return{real:e+t,imag:a+n}})),S=y(a.Add,x,T),F={kernelName:a.Add,backendName:"cpu",kernelFunc:S};function M(e,t,n,r,i){for(var s=a.util.sizeFromShape(r),o=a.util.makeZerosTypedArray(i,n),u=0;u<e.length;u++){var d=e[u];if(d<0)throw new Error("Input x must be non-negative!");d>=i||(o[d]+=s>0?t[u]:1)}return o}function A(e,t,n,r){void 0===r&&(r=!1);for(var i=e.shape[0],s=e.shape[1],o=a.buffer([i,n],t.dtype),u=0;u<i;u++)for(var d=0;d<s;d++){var p=e.get(u,d);if(p<0)throw new Error("Input x must be non-negative!");p>=n||(r?o.set(1,u,p):t.size>0?o.set(o.get(u,p)+t.get(u,d),u,p):o.set(o.get(u,p)+1,u,p))}return o}function w(e){return function(t,n,r){for(var i=a.util.getTypedArrayFromDType(n,t.length),s=0;s<t.length;++s)i[s]=e(t[s],r);return i}}function D(e,t,n){return function(r){var i=r.inputs,o=r.attrs,u=r.backend,d=i.x;if(s(d,e),"string"===d.dtype||"string"===n)throw new Error("unaryKernelFunc does not support string input/output");for(var p=u,l=p.data.get(d.dataId).values,c=a.util.sizeFromShape(d.shape),f=n||d.dtype,h=a.util.getArrayFromDType(f,c),m=0;m<c;++m)h[m]=t(l[m],o);return p.makeTensorInfo(d.shape,f,h)}}function _(e,a,t){return function(n){var r=n.inputs,i=n.attrs,o=n.backend,u=r.x;if(s(u,e),"string"===u.dtype||"string"===t)throw new Error("unaryKernelFunc does not support string input/output");var d=o,p=d.data.get(u.dataId).values,l=t||u.dtype,c=a(p,l,i);return d.makeTensorInfo(u.shape,l,c)}}var z=w((function(e){return Math.ceil(e)})),E=_(a.Ceil,z),C={kernelName:a.Ceil,backendName:"cpu",kernelFunc:E};function W(e,t,n,r){var i=a.util.getArrayFromDType(n,a.util.sizeFromShape(t));if(r&&"string"!==n){var s=0;e.forEach((function(e){var t=a.util.sizeFromShape(e.shape);i.set(e.vals,s),s+=t}))}else{var o=0;e.forEach((function(e){for(var r="string"===n?a.backend_util.fromUint8ToStringArray(e.vals):e.vals,s=0,u=0;u<e.shape[0];++u)for(var d=u*t[1]+o,p=0;p<e.shape[1];++p)i[d+p]=r[s++];o+=e.shape[1]}))}return i}var H=w((function(e){return Math.exp(e)})),P=_(a.Exp,H),R={kernelName:a.Exp,backendName:"cpu",kernelFunc:P},B=w((function(e){return Math.expm1(e)})),V=_(a.Expm1,B),O={kernelName:a.Expm1,backendName:"cpu",kernelFunc:V},L=w((function(e){return Math.floor(e)})),q=_(a.Floor,L),G={kernelName:a.Floor,backendName:"cpu",kernelFunc:q};function U(e,t,n){for(var r=a.buffer(n,e.dtype),i=0;i<r.size;++i){var s=r.indexToLoc(i).slice(),o=s[0],u=s[2],d=t.locToIndex([o,u]);s[2]=t.values[d];var p=e.locToIndex(s);r.values[i]=e.values[p]}return r}var Z=l((function(e,a){return e>a?1:0})),j=y(a.Greater,Z,null,"bool"),K={kernelName:a.Greater,backendName:"cpu",kernelFunc:j},Y=l((function(e,a){return e<a?1:0})),$=y(a.Less,Y,null,"bool"),J={kernelName:a.Less,backendName:"cpu",kernelFunc:$};function Q(e,t,n){var r=(t-e)/(n-1),i=a.util.makeZerosTypedArray(n,"float32");i[0]=e;for(var s=1;s<i.length;s++)i[s]=i[s-1]+r;return i}var X=w((function(e){return Math.log(e)})),ee=_(a.Log,X),ae={kernelName:a.Log,backendName:"cpu",kernelFunc:ee};function te(e,t,n,r){for(var i=a.util.getTypedArrayFromDType(r,a.util.sizeFromShape(n)),s=0;s<i.length;++s){for(var o=s*t,u=e[o],d=0;d<t;++d){var p=e[o+d];p>u&&(u=p)}i[s]=u}return i}var ne=l((function(e,a){return Math.max(e,a)})),re=y(a.Maximum,ne),ie={kernelName:a.Maximum,backendName:"cpu",kernelFunc:re},se=l((function(e,a){return Math.min(e,a)})),oe=y(a.Minimum,se),ue={kernelName:a.Minimum,backendName:"cpu",kernelFunc:oe},de=l((function(e,a){return e*a})),pe=N((function(e,a,t,n){return{real:e*t-a*n,imag:e*n+a*t}})),le=y(a.Multiply,de,pe),ce={kernelName:a.Multiply,backendName:"cpu",kernelFunc:le};function fe(e,t,n){var r=a.util.createScalarValue(-1,n);return de([],t,r,e,n)}var he={kernelName:a.Neg,backendName:"cpu",kernelFunc:function(e){var a=e.inputs,t=e.backend,n=a.x;s(n,"neg");var r=fe(t.data.get(n.dataId).values,n.shape,n.dtype),i=r[0],o=r[1];return t.makeTensorInfo(o,n.dtype,i)}},me=l((function(e,a){return e!==a?1:0})),ve=y(a.NotEqual,me,null,"bool"),ke={kernelName:a.NotEqual,backendName:"cpu",kernelFunc:ve};function be(e,t,n,r,i){for(var s=t.length,o=a.util.sizeFromShape(t),u=a.util.computeStrides(t),d=a.util.computeStrides(i),p=a.util.getTypedArrayFromDType(n,a.util.sizeFromShape(i)),l=0;l<o;++l){for(var c=a.util.indexToLoc(l,s,u),f=new Array(c.length),h=0;h<f.length;h++)f[h]=c[r[h]];p[a.util.locToIndex(f,s,d)]=e[l]}return p}function ge(e){var a=e.inputs,t=e.attrs,n=e.backend,r=a.x,i=t.perm;s(r,"transpose");for(var o=r.shape.length,u=new Array(o),d=0;d<u.length;d++)u[d]=r.shape[i[d]];var p=be(n.data.get(r.dataId).values,r.shape,r.dtype,i,u);return{dataId:n.write(p,u,r.dtype),shape:u,dtype:r.dtype}}var Ie={kernelName:a.Transpose,backendName:"cpu",kernelFunc:ge};function ye(e,t,n,r){for(var i=a.backend_util.computeOutAndReduceShapes(e,r),s=i[0],o=i[1],u=a.upcastType(t,"int32"),d=a.util.makeZerosTypedArray(a.util.sizeFromShape(s),u),p=a.util.sizeFromShape(o),l=0;l<d.length;++l){for(var c=l*p,f=1,h=0;h<p;++h)f*=n[c+h];d[l]=f}return{outVals:d,outShape:s,outDtype:u}}var Ne={kernelName:a.Prod,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,o=r.axis,u=r.keepDims;s(i,"prod");var d=i.shape.length,p=a.util.parseAxisParam(o,i.shape),l=a.backend_util.getAxesPermutation(p,d),c=p,f=i,h=[];null!=l&&(f=ge({inputs:{x:i},backend:n,attrs:{perm:l}}),h.push(f),c=a.backend_util.getInnerMostAxes(c.length,d));var m=n.data.get(f.dataId).values,v=ye(f.shape,f.dtype,m,c),k=v.outVals,b=v.outShape,g=v.outDtype,I=b;return u&&(I=a.backend_util.expandShapeToKeepDim(b,p)),h.forEach((function(e){return n.disposeIntermediateTensorInfo(e)})),n.makeTensorInfo(I,g,k)}};function xe(e,t,n,r){if(e===t||e<t&&n<0||t<e&&n>1)return a.util.makeZerosTypedArray(0,r);var i=Math.abs(Math.ceil((t-e)/n)),s=a.util.makeZerosTypedArray(i,r);t<e&&1===n&&(n=-1),s[0]=e;for(var o=1;o<s.length;o++)s[o]=s[o-1]+n;return s}var Te=w((function(e){return 1/Math.sqrt(e)})),Se=_(a.Rsqrt,Te),Fe={kernelName:a.Rsqrt,backendName:"cpu",kernelFunc:Se};function Me(e,t,n,r,i){var s=a.slice_util.isSliceContinous(r,t,n),o=a.util.sizeFromShape(n),u=a.util.computeStrides(r);if(s){var d=a.slice_util.computeFlatOffset(t,u);return"string"===i?e.slice(d,d+o):e.subarray(d,d+o)}for(var p="string"===i?a.backend_util.fromUint8ToStringArray(e):e,l=a.buffer(r,i,p),c=a.buffer(n,i),f=0;f<c.size;++f){var h=c.indexToLoc(f),m=h.map((function(e,a){return e+t[a]}));c.set.apply(c,[l.get.apply(l,m)].concat(h))}return"string"===i?a.backend_util.fromStringArrayToUint8(c.values):c.values}function Ae(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,o=r.begin,u=r.size;s(i,"slice");var d=a.slice_util.parseSliceParams(i,o,u),p=d[0],l=d[1];a.slice_util.assertParamsValid(i,p,l);var c=Me(n.data.get(i.dataId).values,p,l,i.shape,i.dtype);return n.makeTensorInfo(l,i.dtype,c)}var we={kernelName:a.Slice,backendName:"cpu",kernelFunc:Ae};function De(e,t,n,r,i,s,o){var u=t[0],d=s[0],p=new Array(d),l=new Array(u),c=t[1];if(0===d){if(0!==u)throw new Error("Received SparseTensor with denseShape[0] = 0 but\n         indices.shape[0] = "+u);return[I=a.util.getArrayFromDType(n,0),[0,c],y=a.util.getArrayFromDType(i,0),p,l]}for(var f=!0,h=0,m=new Array(d).fill(0),v=0;v<u;++v){if((b=e[v*c])<0)throw new Error("indices("+v+", 0) is invalid: "+b+" < 0");if(b>=d)throw new Error("indices("+v+", 0) is invalid: "+b+" >= "+d);++m[b],f=f&&b>=h,h=b}for(var k=!0,b=0;b<d;++b){var g=0===m[b];p[b]=g,k=k&&!g,m[b]=Math.max(m[b],1),b>0&&(m[b]+=m[b-1])}if(k&&f){var I=e,y=r;for(v=0;v<u;++v)l[v]=v;return[I,[u,c],y,p,l]}var N=m[d-1],x=(I=a.util.getArrayFromDType(n,N*c),y=a.util.getArrayFromDType(i,N),new Array(d).fill(0));for(v=0;v<u;++v){var T=x[b=e[v*c]],S=(0===b?0:m[b-1])+T;x[b]++;for(var F=0;F<c;++F)I[S*c+F]=e[v*c+F];y[S]=r[v],l[v]=S}for(b=0;b<d;++b){if(0===x[b]){var M=0===b?0:m[b-1];I[M*c+0]=b;for(var A=1;A<c;++A)I[M*c+A]=0;y[M]=o}}return[I,[u,c],y,p,l]}function _e(e,t,n,r,i){for(var s=a.util.sizeFromShape(r),o=t[0],u=i.length,d=[],p=1,l=-1,c=0;c<u;++c){var f=i[c];if(-1===f){if(-1!==l)throw new Error("only one output dimension may be -1, not both "+l+" and "+c);l=c,d.push(1)}else{if(f<0)throw new Error("size "+c+" must be non-negative, not "+f);p*=f,d.push(f)}}if(-1!==l){if(p<=0)throw new Error("reshape cannot infer the missing input size for an empty tensor unless all specified input sizes are non-zero");var h=Math.trunc(s/p);if(p*h!==s)throw new Error("Input to reshape is a SparseTensor with "+s+"\n          dense values, but the requested shape requires a multiple of "+p+". inputShape="+r+" outputShape= "+d);d[l]=h}var m=a.util.sizeFromShape(d);if(m!==s)throw new Error("Input to reshape is a tensor with "+s+" dense values, but the requested shape has "+m+". inputShape="+r+" outputShape="+d);var v=r.length,k=[];if(v>0){k[v-1]=1;for(c=v-2;c>=0;--c)k[c]=k[c+1]*r[c+1]}var b=[];if(u>0){b[u-1]=1;for(c=u-2;c>=0;--c)b[c]=b[c+1]*d[c+1]}for(var g=a.util.getArrayFromDType(n,o*u),I=0;I<o;++I){for(var y=0,N=0;N<v;++N)y+=e[I*v+N]*k[N];for(N=0;N<u;++N)g[I*u+N]=Math.trunc(y/b[N]),y%=b[N]}return[g,[o,u],d]}var ze=l((function(e,a){var t=e-a;return t*t})),Ee=y(a.SquaredDifference,ze),Ce={kernelName:a.SquaredDifference,backendName:"cpu",kernelFunc:Ee};function We(e,t,n,r){for(var i=a.buffer(e,t.dtype),s=0;s<i.size;s++){for(var o=i.indexToLoc(s),u=new Array(o.length),d=0;d<u.length;d++)u[d]=o[d]*n[d]+r[d];i.set.apply(i,[t.get.apply(t,u)].concat(o))}return i}var He=l((function(e,a){return e-a})),Pe=N((function(e,a,t,n){return{real:e-t,imag:a-n}})),Re=y(a.Sub,He,Pe),Be={kernelName:a.Sub,backendName:"cpu",kernelFunc:Re};function Ve(e,t){for(var n=new Array(e.rank),r=0;r<n.length;r++)n[r]=e.shape[r]*t[r];var i=a.buffer(n,e.dtype);for(r=0;r<i.values.length;++r){for(var s=i.indexToLoc(r),o=new Array(e.rank),u=0;u<o.length;u++)o[u]=s[u]%e.shape[u];var d=e.locToIndex(o);i.values[r]=e.values[d]}return i}function Oe(e,t,n,r,i){for(var s=t[t.length-1],o=[e.length/s,s],u=o[0],d=o[1],p=a.util.getTypedArrayFromDType(n,u*r),l=a.util.getTypedArrayFromDType("int32",u*r),c=0;c<u;c++){for(var f=c*d,h=e.subarray(f,f+d),m=[],v=0;v<h.length;v++)m.push({value:h[v],index:v});m.sort((function(e,a){return a.value-e.value}));var k=c*r,b=p.subarray(k,k+r),g=l.subarray(k,k+r);for(v=0;v<r;v++)b[v]=m[v].value,g[v]=m[v].index}var I=t.slice();return I[I.length-1]=r,[a.buffer(I,n,p),a.buffer(I,"int32",l)]}function Le(e,t,n,r){for(var i=a.util.parseAxisParam(t,n)[0],s=[1,n[0],1],o=0;o<i;o++)s[0]*=n[o];s[1]=n[i];for(o=i+1;o<n.length;o++)s[2]*=n[o];var u={},d=new Int32Array(n[i]),p=new a.TensorBuffer(s,r,e),l=[],c=1===s[0]&&1===s[2];for(o=0;o<n[i];o++){var f=void 0;if(c)f=e[o].toString();else{for(var h=[],m=0;m<s[0];m++)for(var v=0;v<s[2];v++)h.push(p.get(m,o,v));f=h.join(",")}if(void 0!==u[f])d[o]=u[f];else{var k=Object.keys(u).length;u[f]=k,d[o]=k,l.push(o)}}var b=s.slice();b[1]=Object.keys(u).length;var g=new a.TensorBuffer(b,r);l.forEach((function(e,a){for(var t=0;t<s[0];t++)for(var n=0;n<s[2];n++)g.set(p.get(t,e,n),t,a,n)}));var I=n.slice();return I[i]=b[1],{outputValues:g.values,outputShape:I,indices:d}}var qe={__proto__:null,simpleAbsImpl:d,addImpl:x,bincountImpl:M,bincountReduceImpl:A,ceilImpl:z,concatImpl:W,expImpl:H,expm1Impl:B,floorImpl:L,gatherV2Impl:U,greaterImpl:Z,lessImpl:Y,linSpaceImpl:Q,logImpl:X,maxImpl:te,maximumImpl:ne,minimumImpl:se,multiplyImpl:de,negImpl:fe,notEqualImpl:me,prodImpl:ye,rangeImpl:xe,rsqrtImpl:Te,sliceImpl:Me,sparseFillEmptyRowsImpl:De,sparseReshapeImpl:_e,squaredDifferenceImpl:ze,stridedSliceImpl:We,subImpl:He,tileImpl:Ve,topKImpl:Oe,transposeImpl:be,uniqueImpl:Le};a.registerBackend("cpu",(function(){return new u}),1);var Ge=D(a.Elu,(function(e){return e>=0?e:Math.exp(e)-1})),Ue={kernelName:a.Elu,backendName:"cpu",kernelFunc:Ge};function Ze(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,o=r.alpha;s([i],"leakyRelu");for(var u=a.util.sizeFromShape(i.shape),d=n.data.get(i.dataId).values,p=a.util.getTypedArrayFromDType("float32",u),l=0;l<d.length;l++)p[l]=d[l]<0?o*d[l]:d[l];return n.makeTensorInfo(i.shape,"float32",p)}var je={kernelName:a.LeakyRelu,backendName:"cpu",kernelFunc:Ze},Ke=l((function(e,a){return e<0?a*e:e}));function Ye(e){var a=e.inputs,t=e.backend,n=a.x,r=a.alpha;s([n,r],"prelu");var i=t.data.get(n.dataId).values,o=t.data.get(r.dataId).values,u=Ke(n.shape,r.shape,i,o,n.dtype),d=u[0],p=u[1];return t.makeTensorInfo(p,n.dtype,d)}var $e={kernelName:a.Prelu,backendName:"cpu",kernelFunc:Ye},Je=D(a.Relu,(function(e){return Math.max(0,e)})),Qe={kernelName:a.Relu,backendName:"cpu",kernelFunc:Je},Xe=D(a.Relu6,(function(e){return Math.min(Math.max(0,e),6)})),ea={kernelName:a.Relu6,backendName:"cpu",kernelFunc:Xe},aa=D(a.Sigmoid,(function(e){return 1/(1+Math.exp(-e))})),ta={kernelName:a.Sigmoid,backendName:"cpu",kernelFunc:aa};function na(e,a,t,n,r){if("linear"===t)return m({inputs:{x:a},backend:e});if("relu"===t)return Je({inputs:{x:a},backend:e});if("elu"===t)return Ge({inputs:{x:a},backend:e});if("relu6"===t)return Xe({inputs:{x:a},backend:e});if("prelu"===t)return Ye({inputs:{x:a,alpha:n},backend:e});if("leakyrelu"===t)return Ze({inputs:{x:a},backend:e,attrs:{alpha:r}});if("sigmoid"===t)return aa({inputs:{x:a},backend:e});throw new Error("Activation "+t+" has not been implemented for the CPU backend.")}function ra(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,s=r.shape,o=a.util.sizeFromShape(i.shape),u=a.util.inferFromImplicitShape(s,o),d=a.util.sizeFromShape(u);a.util.assert(o===d,(function(){return"The new shape ("+u+") has "+d+" elements and the old shape ("+i.shape+") has "+o+" elements. The new shape and old shape must have the same number of elements."})),n.incRef(i.dataId);var p=n.data.get(i.dataId);if(null!=p.complexTensorInfos){var l=p.complexTensorInfos.real,c=p.complexTensorInfos.imag;l.shape=u,c.shape=u}return{dataId:i.dataId,shape:u,dtype:i.dtype}}var ia={kernelName:a.Reshape,backendName:"cpu",kernelFunc:ra};function sa(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.a,o=t.b,u=r.transposeA,d=r.transposeB;s([i,o],"matMul");var p=i.shape.length,l=o.shape.length,c=u?i.shape[p-2]:i.shape[p-1],f=d?o.shape[l-1]:o.shape[l-2],h=u?i.shape[p-1]:i.shape[p-2],m=d?o.shape[l-2]:o.shape[l-1],v=i.shape.slice(0,-2),k=o.shape.slice(0,-2),b=a.util.sizeFromShape(v),g=a.util.sizeFromShape(k),I=b===g||1===b||1===g;a.util.assert(p>=2&&l>=2&&I,(function(){return"Error in matMul: the input batch dimensions must either be the same or at least one input batch dimension must be 1. Got input batch dimensions of ("+v+") and ("+k+")."}));var y=(b>g?i.shape.slice(0,-2):o.shape.slice(0,-2)).concat([h,m]);a.util.assert(c===f,(function(){return"Error in matMul: inner shapes ("+c+") and ("+f+") of Tensors with shapes "+i.shape+" and "+o.shape+" and transposeA="+u+" and transposeB="+d+" must match."}));for(var N=d?[g,m,f]:[g,f,m],x=ra({inputs:{x:i},backend:n,attrs:{shape:u?[b,c,h]:[b,h,c]}}),T=ra({inputs:{x:o},backend:n,attrs:{shape:N}}),S=u?x.shape[1]:x.shape[2],F=u?x.shape[2]:x.shape[1],M=d?T.shape[1]:T.shape[2],A=Math.max(b,g),w=n.data.get(x.dataId).values,D=n.data.get(T.dataId).values,_=a.util.computeStrides(x.shape),z=a.util.computeStrides(T.shape),E=u?[_[0],1,_[1]]:[_[0],_[1],1],C=E[0],W=E[1],H=E[2],P=d?[1,z[1],z[0]]:[z[1],1,z[0]],R=P[0],B=P[1],V=P[2],O=F*M,L=a.buffer([A,F,M],x.dtype),q=L.values,G=n.blockSize,U=0;U<A;U++)for(var Z=0;Z<F;Z+=G)for(var j=0;j<M;j+=G)for(var K=0;K<S;K+=G)for(var Y=Math.min(Z+G,F),$=Math.min(j+G,M),J=Math.min(K+G,S),Q=Z;Q<Y;Q++)for(var X=j;X<$;X++){for(var ee=0,ae=K;ae<J;ae++){var te=Math.min(U,b-1)*C,ne=Math.min(U,g-1)*V;ee+=w[te+Q*W+ae*H]*D[ae*R+X*B+ne]}q[U*O+(Q*M+X)]+=ee}return n.disposeIntermediateTensorInfo(x),n.disposeIntermediateTensorInfo(T),n.makeTensorInfo(y,L.dtype,L.values)}var oa={kernelName:a.BatchMatMul,backendName:"cpu",kernelFunc:sa};var ua={kernelName:a._FusedMatMul,backendName:"cpu",kernelFunc:function(e){var a,t,n,r=e.inputs,i=e.backend,s=e.attrs,o=r.a,u=r.b,d=r.bias,p=r.preluActivationWeights,l=s.transposeA,c=s.transposeB,f=s.activation,h=s.leakyreluAlpha,m=[];a=sa({inputs:{a:o,b:u},attrs:{transposeA:l,transposeB:c},backend:i}),d&&(t=S({inputs:{a:a,b:d},backend:i}),m.push(a),a=t),f&&(n=na(i,a,f,p,h),m.push(a),a=n);for(var v=0,k=m;v<k.length;v++){var b=k[v];i.disposeIntermediateTensorInfo(b)}return a}},da=D(a.Acos,(function(e){return Math.acos(e)})),pa={kernelName:a.Acos,backendName:"cpu",kernelFunc:da},la=D(a.Acosh,(function(e){return Math.acosh(e)})),ca={kernelName:a.Acosh,backendName:"cpu",kernelFunc:la};var fa={kernelName:a.AddN,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=t;s(t,"addN");for(var i=r.map((function(e){return n.data.get(e.dataId).values})),o=a.buffer(r[0].shape,r[0].dtype),u=o.values,d=0;d<r.length;d++)for(var p=i[d],l=0;l<u.length;l++)u[l]+=p[l];return n.makeTensorInfo(o.shape,o.dtype,o.values)}};var ha={kernelName:a.All,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,o=r.axis,u=r.keepDims;s(i,"all");var d=a.util.parseAxisParam(o,i.shape),p=d,l=a.backend_util.getAxesPermutation(p,i.shape.length),c=i;null!=l&&(c=ge({inputs:{x:i},backend:n,attrs:{perm:l}}),p=a.backend_util.getInnerMostAxes(p.length,i.shape.length)),a.backend_util.assertAxesAreInnerMostDims("all",p,c.shape.length);for(var f=a.backend_util.computeOutAndReduceShapes(c.shape,p),h=f[0],m=f[1],v=a.util.sizeFromShape(m),k=a.util.makeZerosTypedArray(a.util.sizeFromShape(h),c.dtype),b=n.data.get(c.dataId).values,g=0;g<k.length;++g){for(var I=g*v,y=b[I],N=0;N<v;++N){var x=b[I+N];y=y&&x}k[g]=y}null!=l&&n.disposeIntermediateTensorInfo(c);var T=n.makeTensorInfo(h,c.dtype,k);if(u){var S=ra({inputs:{x:T},backend:n,attrs:{shape:a.backend_util.expandShapeToKeepDim(h,d)}});return n.disposeIntermediateTensorInfo(T),S}return T}};var ma={kernelName:a.Any,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,o=r.axis,u=r.keepDims;s(i,"any");var d=a.util.parseAxisParam(o,i.shape),p=d,l=a.backend_util.getAxesPermutation(p,i.shape.length),c=i;null!=l&&(c=ge({inputs:{x:i},backend:n,attrs:{perm:l}}),p=a.backend_util.getInnerMostAxes(p.length,i.shape.length)),a.backend_util.assertAxesAreInnerMostDims("any",p,c.shape.length);for(var f=a.backend_util.computeOutAndReduceShapes(c.shape,p),h=f[0],m=f[1],v=a.util.sizeFromShape(m),k=a.util.makeZerosTypedArray(a.util.sizeFromShape(h),c.dtype),b=n.data.get(c.dataId).values,g=0;g<k.length;++g){for(var I=g*v,y=b[I],N=0;N<v;++N){var x=b[I+N];y=y||x}k[g]=y}null!=l&&n.disposeIntermediateTensorInfo(c);var T=n.makeTensorInfo(h,c.dtype,k);if(u){var S=ra({inputs:{x:T},backend:n,attrs:{shape:a.backend_util.expandShapeToKeepDim(h,d)}});return n.disposeIntermediateTensorInfo(T),S}return T}};var va={kernelName:a.ArgMax,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,o=r.axis;s(i,"argMax");var u=a.util.parseAxisParam(o,i.shape),d=a.backend_util.getAxesPermutation(u,i.shape.length),p=i,l=[];null!=d&&(p=ge({inputs:{x:i},backend:n,attrs:{perm:d}}),l.push(p),u=a.backend_util.getInnerMostAxes(u.length,p.shape.length)),u=[u[0]],a.backend_util.assertAxesAreInnerMostDims("argMax",u,p.shape.length);for(var c=a.backend_util.computeOutAndReduceShapes(p.shape,u),f=c[0],h=c[1],m=a.util.sizeFromShape(f),v=a.util.makeZerosTypedArray(m,"int32"),k=a.util.sizeFromShape(h),b=n.data.get(p.dataId).values,g=0;g<v.length;++g){for(var I=g*k,y=b[I],N=0,x=0;x<k;++x){var T=b[I+x];T>y&&(y=T,N=x)}v[g]=N}return l.forEach((function(e){return n.disposeIntermediateTensorInfo(e)})),n.makeTensorInfo(f,"int32",v)}};var ka={kernelName:a.ArgMin,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,o=r.axis;s(i,"argMin");var u=a.util.parseAxisParam(o,i.shape),d=a.backend_util.getAxesPermutation(u,i.shape.length),p=i,l=[];null!=d&&(p=ge({inputs:{x:i},backend:n,attrs:{perm:d}}),l.push(p),u=a.backend_util.getInnerMostAxes(u.length,p.shape.length)),u=[u[0]],a.backend_util.assertAxesAreInnerMostDims("argMin",u,p.shape.length);for(var c=a.backend_util.computeOutAndReduceShapes(p.shape,u),f=c[0],h=c[1],m=a.util.sizeFromShape(f),v=a.util.makeZerosTypedArray(m,"int32"),k=a.util.sizeFromShape(h),b=n.data.get(p.dataId).values,g=0;g<v.length;++g){for(var I=g*k,y=b[I],N=0,x=0;x<k;++x){var T=b[I+x];T<y&&(y=T,N=x)}v[g]=N}return l.forEach((function(e){return n.disposeIntermediateTensorInfo(e)})),n.makeTensorInfo(f,"int32",v)}},ba=D(a.Asin,(function(e){return Math.asin(e)})),ga={kernelName:a.Asin,backendName:"cpu",kernelFunc:ba},Ia=D(a.Asinh,(function(e){return Math.asinh(e)})),ya={kernelName:a.Asinh,backendName:"cpu",kernelFunc:Ia},Na=D(a.Atan,(function(e){return Math.atan(e)})),xa={kernelName:a.Atan,backendName:"cpu",kernelFunc:Na},Ta=l((function(e,a){return Math.atan2(e,a)})),Sa=y(a.Atan2,Ta),Fa={kernelName:a.Atan2,backendName:"cpu",kernelFunc:Sa},Ma=D(a.Atanh,(function(e){return Math.atanh(e)})),Aa={kernelName:a.Atanh,backendName:"cpu",kernelFunc:Ma};function wa(e,t,n,r,i,s){for(var o=i.strideHeight,u=i.strideWidth,d=i.dilationHeight,p=i.dilationWidth,l=i.effectiveFilterHeight,c=i.effectiveFilterWidth,f=i.padInfo.top,h=i.padInfo.left,m="max"===s?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY,v=a.buffer(i.outShape,n),k=v.values,b=i.outShape[1]*i.outShape[2]*i.outShape[3],g=i.outShape[2]*i.outShape[3],I=i.outShape[3],y=0;y<i.batchSize;++y)for(var N=y*b,x=y*r[0],T=0;T<i.inChannels;++T)for(var S=0;S<i.outHeight;++S)for(var F=S*o-f,M=Math.max(0,F),A=Math.min(i.inHeight,l+F),w=N+S*g,D=0;D<i.outWidth;++D){for(var _=D*u-h,z=Math.max(0,_),E=Math.min(i.inWidth,c+_),C=m,W=0,H=0,P=M;P<A;P+=d){for(var R=x+P*r[1],B=z;B<E;B+=p){var V=e[R+B*r[2]+T];"max"===s&&V>C?C=V:"avg"===s&&(W+=V,H++)}if(isNaN(C))break}k[w+D*I+T]="avg"===s?W/H:C}return v}function Da(e,t,n,r,i,s){void 0===i&&(i=!1),void 0===s&&(s=!1);for(var o=a.buffer(r.outShape,"int32"),u=r.strideHeight,d=r.strideWidth,p=r.dilationHeight,l=r.dilationWidth,c=r.effectiveFilterHeight,f=r.effectiveFilterWidth,h=r.padInfo.top,m=r.padInfo.left,v=a.buffer(t,n,e),k=0;k<r.batchSize;++k)for(var b=0;b<r.inChannels;++b)for(var g=0;g<r.outHeight;++g){for(var I=g*u-h,y=I;y<0;)y+=p;for(var N=Math.min(r.inHeight,c+I),x=0;x<r.outWidth;++x){for(var T=x*d-m,S=T;S<0;)S+=l;for(var F=Math.min(r.inWidth,f+T),M=Number.NEGATIVE_INFINITY,A=-1,w=y;w<N;w+=p)for(var D=w-I,_=S;_<F;_+=l){var z=_-T,E=v.get(k,w,_,b);E>M&&(M=E,A=i?s?((k*r.inHeight+w)*r.inWidth+_)*r.inChannels+b:(w*r.inWidth+_)*r.inChannels+b:D*f+z)}o.set(A,k,g,x,b)}}return o}function _a(e,t,n,r,i,s){for(var o=i.strideDepth,u=i.strideHeight,d=i.strideWidth,p=i.dilationDepth,l=i.dilationHeight,c=i.dilationWidth,f=i.effectiveFilterDepth,h=i.effectiveFilterHeight,m=i.effectiveFilterWidth,v=i.padInfo.front,k=i.padInfo.top,b=i.padInfo.left,g="max"===s?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY,I=a.buffer(i.outShape,n),y=I.values,N=i.outShape[1]*i.outShape[2]*i.outShape[3]*i.outShape[4],x=i.outShape[2]*i.outShape[3]*i.outShape[4],T=i.outShape[3]*i.outShape[4],S=i.outShape[4],F=0;F<i.batchSize;++F)for(var M=F*N,A=F*r[0],w=0;w<i.inChannels;++w)for(var D=0;D<i.outDepth;++D){for(var _=D*o-v,z=_;z<0;)z+=p;for(var E=Math.min(i.inDepth,f+_),C=M+D*x,W=0;W<i.outHeight;++W){for(var H=W*u-k,P=H;P<0;)P+=l;for(var R=Math.min(i.inHeight,h+H),B=C+W*T,V=0;V<i.outWidth;++V){for(var O=V*d-b,L=O;L<0;)L+=c;for(var q=Math.min(i.inWidth,m+O),G=B+V*S,U=g,Z=0,j=0,K=z;K<E;K+=p){for(var Y=A+K*r[1],$=P;$<R;$+=l){for(var J=Y+$*r[2],Q=L;Q<q;Q+=c){var X=e[J+Q*r[3]+w];if("max"===s&&X>U?U=X:"avg"===s&&(Z+=X,j++),isNaN(U))break}if(isNaN(U))break}if(isNaN(U))break}y[G+w]="avg"===s?Z/j:U}}}return I}var za={kernelName:a.AvgPool,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x;s(i,"avgPool");var o=r.filterSize,u=r.strides,d=r.pad,p=r.dimRoundingMode;a.util.assert(a.backend_util.eitherStridesOrDilationsAreOne(u,1),(function(){return"Error in avgPool: Either strides or dilations must be 1. Got strides "+u+" and dilations '1'"}));var l,c=a.backend_util.computePool2DInfo(i.shape,o,u,1,d,p);if(1===c.filterWidth&&1===c.filterHeight&&a.util.arraysEqual(c.inShape,c.outShape))l=m({inputs:{x:i},backend:n});else{var f=n.data.get(i.dataId).values,h=a.util.computeStrides(i.shape),v=wa(f,i.shape,i.dtype,h,c,"avg");l=n.makeTensorInfo(c.outShape,i.dtype,v.values)}return l}};var Ea={kernelName:a.AvgPool3D,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,o=r.filterSize,u=r.strides,d=r.pad,p=r.dimRoundingMode,l=r.dataFormat;s(i,"avgPool3d");var c=a.backend_util.computePool3DInfo(i.shape,o,u,1,d,p,l),f=_a(n.data.get(i.dataId).values,i.shape,i.dtype,a.util.computeStrides(i.shape),c,"avg");return n.makeTensorInfo(f.shape,"float32",f.values)}};var Ca={kernelName:a.AvgPool3DGrad,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.dy,o=t.input,u=r.filterSize,d=r.strides,p=r.pad,l=r.dimRoundingMode;s([i,o],"avgPool3DGrad");for(var c=a.backend_util.computePool3DInfo(o.shape,u,d,1,p,l),f=c.strideDepth,h=c.strideHeight,m=c.strideWidth,v=c.filterDepth,k=c.filterHeight,b=c.filterWidth,g=c.dilationDepth,I=c.dilationHeight,y=c.dilationWidth,N=c.effectiveFilterDepth,x=c.effectiveFilterHeight,T=c.effectiveFilterWidth,S=N-1-c.padInfo.front,F=T-1-c.padInfo.left,M=x-1-c.padInfo.top,A=a.buffer(o.shape,"float32"),w=1/(v*k*b),D=n.bufferSync(i),_=0;_<c.batchSize;++_)for(var z=0;z<c.inChannels;++z)for(var E=0;E<c.inDepth;++E)for(var C=0;C<c.inHeight;++C)for(var W=0;W<c.inWidth;++W){for(var H=E-S,P=C-M,R=W-F,B=0,V=0;V<N;V+=g){var O=(H+V)/f;if(!(O<0||O>=c.outDepth||Math.floor(O)!==O))for(var L=0;L<x;L+=I){var q=(P+L)/h;if(!(q<0||q>=c.outHeight||Math.floor(q)!==q))for(var G=0;G<T;G+=y){var U=(R+G)/m;if(!(U<0||U>=c.outWidth||Math.floor(U)!==U))B+=D.get(_,O,q,U,z)}}}A.set(B*w,_,E,C,W,z)}return n.makeTensorInfo(A.shape,A.dtype,A.values)}};var Wa={kernelName:a.AvgPoolGrad,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.dy,o=t.input,u=o;s([i,o],"avgPoolGrad");for(var d=r.filterSize,p=r.strides,l=r.pad,c=a.backend_util.computePool2DInfo(u.shape,d,p,1,l),f=c.strideHeight,h=c.strideWidth,m=c.filterHeight,v=c.filterWidth,k=c.dilationHeight,b=c.dilationWidth,g=c.effectiveFilterHeight,I=c.effectiveFilterWidth,y=I-1-c.padInfo.left,N=g-1-c.padInfo.top,x=a.buffer(u.shape,"float32"),T=1/(m*v),S=n.data.get(i.dataId).values,F=a.buffer(i.shape,"float32",S),M=0;M<c.batchSize;++M)for(var A=0;A<c.inChannels;++A)for(var w=0;w<c.inHeight;++w)for(var D=0;D<c.inWidth;++D){for(var _=w-N,z=D-y,E=0,C=0;C<g;C+=k){var W=(_+C)/f;if(!(W<0||W>=c.outHeight||Math.floor(W)!==W))for(var H=0;H<I;H+=b){var P=(z+H)/h;if(!(P<0||P>=c.outWidth||Math.floor(P)!==P))E+=F.get(M,W,P,A)}}x.set(E*T,M,w,D,A)}return n.makeTensorInfo(x.shape,x.dtype,x.values)}};var Ha={kernelName:a.FusedBatchNorm,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,o=t.scale,u=t.offset,d=t.mean,p=t.variance;a.util.assert(d.shape.length===p.shape.length,(function(){return"Batch normalization gradient requires mean and variance to have equal ranks."})),a.util.assert(null==u||d.shape.length===u.shape.length,(function(){return"Batch normalization gradient requires mean and offset to have equal ranks."})),a.util.assert(null==o||d.shape.length===o.shape.length,(function(){return"Batch normalization gradient requires mean and scale to have equal ranks."})),s([i,d,p,o,u],"batchNorm");var l=r.varianceEpsilon;null==l&&(l=.001);for(var c=n.data.get(i.dataId).values,f=n.data.get(d.dataId).values,h=n.data.get(p.dataId).values,m=o?n.data.get(o.dataId).values:new Float32Array([1]),v=u?n.data.get(u.dataId).values:new Float32Array([0]),k=new Float32Array(c.length),b=v.length,g=m.length,I=h.length,y=f.length,N=0,x=0,T=0,S=0,F=0;F<c.length;++F)k[F]=v[N++]+(c[F]-f[x++])*m[T++]/Math.sqrt(h[S++]+l),N>=b&&(N=0),x>=y&&(x=0),T>=g&&(T=0),S>=I&&(S=0);return n.makeTensorInfo(i.shape,i.dtype,k)}};var Pa={kernelName:a.BatchToSpaceND,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,o=r.blockShape,u=r.crops;s([i],"batchToSpaceND");var d=o.reduce((function(e,a){return e*a})),p=a.backend_util.getReshaped(i.shape,o,d),l=a.backend_util.getPermuted(p.length,o.length),c=a.backend_util.getReshapedPermuted(i.shape,o,d),f=a.backend_util.getSliceBeginCoords(u,o.length),h=a.backend_util.getSliceSize(c,u,o.length),m=ra({inputs:{x:i},backend:n,attrs:{shape:p}}),v=ge({inputs:{x:m},backend:n,attrs:{perm:l}}),k=ra({inputs:{x:v},backend:n,attrs:{shape:c}}),b=Ae({inputs:{x:k},backend:n,attrs:{begin:f,size:h}});return n.disposeIntermediateTensorInfo(m),n.disposeIntermediateTensorInfo(v),n.disposeIntermediateTensorInfo(k),b}};var Ra={kernelName:a.Bincount,backendName:"cpu",kernelFunc:function(e){var a=e.inputs,t=e.backend,n=e.attrs,r=a.x,i=a.weights,s=n.size,o=M(t.data.get(r.dataId).values,t.data.get(i.dataId).values,i.dtype,i.shape,s);return t.makeTensorInfo([s],i.dtype,o)}},Ba=D(a.ClipByValue,(function(e,a){var t=a;return e>t.clipValueMax?t.clipValueMax:e<t.clipValueMin?t.clipValueMin:e})),Va={kernelName:a.ClipByValue,backendName:"cpu",kernelFunc:Ba},Oa={kernelName:a.ComplexAbs,backendName:"cpu",kernelFunc:function(e){for(var t=e.inputs.x,n=e.backend,r=new Float32Array(a.util.sizeFromShape(t.shape)),i=n.data.get(t.dataId),s=i.complexTensorInfos.real,o=i.complexTensorInfos.imag,u=n.data.get(s.dataId).values,d=n.data.get(o.dataId).values,p=0;p<u.length;p++){var l=u[p],c=d[p];r[p]=Math.hypot(l,c)}return n.makeOutput(r,t.shape,"float32")}};function La(e){var a=e.inputs,t=e.backend,n=a.input,r=t.data.get(n.dataId).complexTensorInfos.imag,i=t.data.get(r.dataId).values;return t.makeTensorInfo(r.shape,r.dtype,i)}var qa={kernelName:a.Imag,backendName:"cpu",kernelFunc:La};function Ga(e){var t=e.inputs,n=e.backend,r=e.attrs.axis,i=a.util.parseAxisParam(r,t[0].shape)[0],s=a.backend_util.computeOutShape(t.map((function(e){return e.shape})),i);if(0===a.util.sizeFromShape(s))return n.makeTensorInfo(s,t[0].dtype,[]);var o=t.filter((function(e){return a.util.sizeFromShape(e.shape)>0}));if(1===o.length)return m({inputs:{x:o[0]},backend:n});var u=o.map((function(e){return e.shape}));if(a.backend_util.assertParamsConsistent(u,i),"complex64"===o[0].dtype){var d=o.map((function(e){return k({inputs:{input:e},backend:n})})),p=o.map((function(e){return La({inputs:{input:e},backend:n})})),l=Ga({inputs:d,backend:n,attrs:{axis:i}}),f=Ga({inputs:p,backend:n,attrs:{axis:i}}),h=c({inputs:{real:l,imag:f},backend:n});return d.forEach((function(e){return n.disposeIntermediateTensorInfo(e)})),p.forEach((function(e){return n.disposeIntermediateTensorInfo(e)})),n.disposeIntermediateTensorInfo(l),n.disposeIntermediateTensorInfo(f),h}var v=o.map((function(e){var t=a.util.sizeFromShape(e.shape.slice(i));return ra({inputs:{x:e},backend:n,attrs:{shape:[-1,t]}})})),b=v.map((function(e){return{vals:n.data.get(e.dataId).values,shape:e.shape}}));s=a.backend_util.computeOutShape(v.map((function(e){return e.shape})),1);var g=1===v[0].shape[0],I=W(b,s,t[0].dtype,g),y=a.backend_util.computeOutShape(o.map((function(e){return e.shape})),i),N=n.makeTensorInfo(y,t[0].dtype,I);return v.forEach((function(e){return n.disposeIntermediateTensorInfo(e)})),N}var Ua={kernelName:a.Concat,backendName:"cpu",kernelFunc:Ga};function Za(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,o=t.filter,u=r.strides,d=r.pad,p=r.dataFormat,l=r.dilations,c=r.dimRoundingMode;s([i,o],"conv2d");for(var f=a.backend_util.convertConv2DDataFormat(p),h=a.backend_util.computeConv2DInfo(i.shape,o.shape,u,l,d,c,!1,f),m=h.filterHeight,v=h.filterWidth,k=h.dilationHeight,b=h.dilationWidth,g=h.padInfo.left,I=h.padInfo.top,y="channelsLast"===h.dataFormat,N=new a.TensorBuffer(h.outShape,i.dtype),x=a.util.computeStrides(i.shape),T=a.util.computeStrides(o.shape),S=x[0],F=y?x[1]:x[2],M=y?x[2]:1,A=y?1:x[1],w=N.strides[0],D=y?N.strides[1]:N.strides[2],_=y?N.strides[2]:1,z=y?1:N.strides[1],E=n.data.get(i.dataId).values,C=n.data.get(o.dataId).values,W=N.values,H=0;H<h.batchSize;++H)for(var P=H*S,R=H*w,B=0;B<h.outHeight;++B)for(var V=R+B*D,O=B*h.strideHeight-I,L=0;L<m;++L){var q=O+L*k;if(!(q<0||q>=h.inHeight))for(var G=L*T[0],U=P+q*F,Z=0;Z<h.outWidth;++Z)for(var j=V+Z*_,K=Z*h.strideWidth-g,Y=0;Y<v;++Y){var $=K+Y*b;if(!($<0||$>=h.inWidth))for(var J=U+$*M,Q=G+Y*T[1],X=0;X<h.inChannels;++X){for(var ee=E[J+X*A],ae=0;ae<h.outChannels;++ae)W[j+ae*z]+=ee*C[Q+ae];Q+=h.outChannels}}}return n.makeTensorInfo(N.shape,N.dtype,W)}var ja={kernelName:a.Conv2D,backendName:"cpu",kernelFunc:Za};var Ka={kernelName:a.Conv2DBackpropFilter,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,o=t.dy,u=r.strides,d=r.pad,p=r.dataFormat,l=r.dimRoundingMode,c=r.filterShape;s([i,o],"conv2dBackpropFilter");for(var f=a.backend_util.convertConv2DDataFormat(p),h=a.backend_util.computeConv2DInfo(i.shape,c,u,1,d,l,!1,f),m=h.strideHeight,v=h.strideWidth,k=h.filterHeight,b=h.filterWidth,g="channelsLast"===h.dataFormat,I=new a.TensorBuffer(h.filterShape,"float32"),y=h.padInfo.left,N=h.padInfo.top,x=n.data.get(i.dataId).values,T=n.data.get(o.dataId).values,S=new a.TensorBuffer(i.shape,i.dtype,x),F=new a.TensorBuffer(o.shape,o.dtype,T),M=0;M<k;++M)for(var A=Math.max(0,Math.ceil((N-M)/m)),w=Math.min(h.outHeight,(h.inHeight+N-M)/m),D=0;D<b;++D)for(var _=Math.max(0,Math.ceil((y-D)/v)),z=Math.min(h.outWidth,(h.inWidth+y-D)/v),E=0;E<h.inChannels;++E)for(var C=0;C<h.outChannels;++C){for(var W=0,H=0;H<h.batchSize;++H)for(var P=A;P<w;++P)for(var R=M+P*m-N,B=_;B<z;++B){var V=D+B*v-y;W+=g?S.get(H,R,V,E)*F.get(H,P,B,C):S.get(H,E,R,V)*F.get(H,C,P,B)}I.set(W,M,D,E,C)}return n.makeTensorInfo(I.shape,I.dtype,I.values)}};var Ya={kernelName:a.Conv2DBackpropInput,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.dy,o=t.filter,u=r.inputShape,d=r.strides,p=r.pad,l=r.dataFormat,c=r.dimRoundingMode;s([i,o],"conv2dBackpropInput");var f=a.util.computeStrides(o.shape),h=a.util.computeStrides(i.shape),m=a.backend_util.convertConv2DDataFormat(l),v=a.backend_util.computeConv2DInfo(u,o.shape,d,1,p,c,!1,m),k=new a.TensorBuffer(v.inShape,"float32"),b=k.values,g=n.data.get(i.dataId).values,I=n.data.get(o.dataId).values,y=f[0],N=f[1],x=f[2],T=v.batchSize,S=v.filterHeight,F=v.filterWidth,M=v.inChannels,A=v.inHeight,w=v.inWidth,D=v.outChannels,_=v.outHeight,z=v.outWidth,E=v.strideHeight,C=v.strideWidth;m=v.dataFormat;for(var W=S-1-v.padInfo.top,H=F-1-v.padInfo.left,P="channelsLast"===m,R=k.strides[0],B=P?k.strides[1]:k.strides[2],V=P?k.strides[2]:1,O=P?1:k.strides[1],L=h[0],q=P?h[1]:h[2],G=P?h[2]:1,U=P?1:h[1],Z=0;Z<T;++Z)for(var j=0;j<M;++j)for(var K=0;K<A;++K)for(var Y=K-W,$=Math.max(0,Math.ceil(Y/E)),J=Math.min(_,(S+Y)/E),Q=0;Q<w;++Q){for(var X=Q-H,ee=Math.max(0,Math.ceil(X/C)),ae=Math.min(z,(F+X)/C),te=0,ne=$;ne<J;++ne)for(var re=ne*E-Y,ie=ee;ie<ae;++ie)for(var se=L*Z+q*ne+G*ie,oe=y*(S-1-re)+N*(F-1-(ie*C-X))+x*j,ue=0;ue<D;++ue){te+=g[se+U*ue]*I[oe+ue]}b[R*Z+B*K+V*Q+O*j]=te}return n.makeTensorInfo(k.shape,k.dtype,k.values)}};var $a={kernelName:a.Conv3D,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,o=t.filter,u=r.strides,d=r.pad,p=r.dilations;s([i,o],"conv3d");for(var l=a.backend_util.computeConv3DInfo(i.shape,o.shape,u,p,d),c=l.filterDepth,f=l.filterHeight,h=l.filterWidth,m=l.dilationDepth,v=l.dilationHeight,k=l.dilationWidth,b=l.padInfo,g=b.front,I=b.left,y=b.top,N=new a.TensorBuffer(l.outShape,i.dtype),x=n.data.get(i.dataId).values,T=n.data.get(o.dataId).values,S=N.values,F=a.util.computeStrides(i.shape),M=a.util.computeStrides(o.shape),A=0;A<l.batchSize;++A)for(var w=A*F[0],D=A*N.strides[0],_=0;_<l.outDepth;++_)for(var z=D+_*N.strides[1],E=_*l.strideDepth-g,C=0;C<c;++C){var W=E+C*m;if(!(W<0||W>=l.inDepth))for(var H=C*M[0],P=w+W*F[1],R=0;R<l.outHeight;++R)for(var B=z+R*N.strides[2],V=R*l.strideHeight-y,O=0;O<f;++O){var L=V+O*v;if(!(L<0||L>=l.inHeight))for(var q=H+O*M[1],G=P+L*F[2],U=0;U<l.outWidth;++U)for(var Z=B+U*l.outChannels,j=U*l.strideWidth-I,K=0;K<h;++K){var Y=j+K*k;if(!(Y<0||Y>=l.inWidth))for(var $=q+K*M[2],J=G+Y*l.inChannels,Q=$,X=0;X<l.inChannels;++X){for(var ee=x[J+X],ae=0;ae<l.outChannels;++ae)S[Z+ae]+=ee*T[Q+ae];Q+=l.outChannels}}}}return n.makeTensorInfo(N.shape,N.dtype,N.values)}};var Ja={kernelName:a.Conv3DBackpropFilterV2,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,o=t.dy,u=r.strides,d=r.pad,p=r.filterShape;s([i,o],"conv3dBackpropFilterV2");for(var l=a.util.computeStrides(i.shape),c=a.util.computeStrides(o.shape),f=a.backend_util.computeConv3DInfo(i.shape,p,u,1,d),h=f.strideDepth,m=f.strideHeight,v=f.strideWidth,k=f.filterDepth,b=f.filterHeight,g=f.filterWidth,I=new a.TensorBuffer(f.filterShape,"float32"),y=I.values,N=I.strides,x=N[0],T=N[1],S=N[2],F=N[3],M=n.data.get(o.dataId).values,A=c[0],w=c[1],D=c[2],_=c[3],z=n.data.get(i.dataId).values,E=l[0],C=l[1],W=l[2],H=l[3],P=f.padInfo.front,R=f.padInfo.left,B=f.padInfo.top,V=0;V<k;++V)for(var O=Math.max(0,Math.ceil((P-V)/h)),L=Math.min(f.outDepth,(f.inDepth+P-V)/h),q=V*x,G=0;G<b;++G)for(var U=Math.max(0,Math.ceil((B-G)/m)),Z=Math.min(f.outHeight,(f.inHeight+B-G)/m),j=G*T+q,K=0;K<g;++K)for(var Y=Math.max(0,Math.ceil((R-K)/v)),$=Math.min(f.outWidth,(f.inWidth+R-K)/v),J=K*S+j,Q=0;Q<f.inChannels;++Q)for(var X=Q*F+J,ee=0;ee<f.outChannels;++ee){for(var ae=0,te=0;te<f.batchSize;++te)for(var ne=te*E,re=te*A,ie=O;ie<L;++ie)for(var se=(V+ie*h-P)*C+ne,oe=ie*w+re,ue=U;ue<Z;++ue)for(var de=(G+ue*m-B)*W+se,pe=ue*D+oe,le=Y;le<$;++le){var ce=le*_+pe;ae+=z[(K+le*v-R)*H+de+Q]*M[ce+ee]}y[X+ee]=ae}return n.makeTensorInfo(I.shape,I.dtype,I.values)}};var Qa={kernelName:a.Conv3DBackpropInputV2,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.dy,o=t.filter,u=r.pad,d=r.strides,p=r.inputShape;s([i],"conv3dBackpropInputV2");for(var l=a.util.computeStrides(i.shape),c=a.util.computeStrides(o.shape),f=a.backend_util.computeConv3DInfo(p,o.shape,d,1,u),h=new a.TensorBuffer(f.inShape,"float32"),m=h.values,v=h.strides,k=v[0],b=v[1],g=v[2],I=v[3],y=n.data.get(i.dataId).values,N=l[0],x=l[1],T=l[2],S=l[3],F=n.data.get(o.dataId).values,M=c[0],A=c[1],w=c[2],D=c[3],_=f.batchSize,z=f.filterDepth,E=f.filterHeight,C=f.filterWidth,W=f.inChannels,H=f.inDepth,P=f.inHeight,R=f.inWidth,B=f.outChannels,V=f.outDepth,O=f.outHeight,L=f.outWidth,q=f.strideDepth,G=f.strideHeight,U=f.strideWidth,Z=z-1-f.padInfo.front,j=E-1-f.padInfo.top,K=C-1-f.padInfo.left,Y=0;Y<_;++Y)for(var $=0;$<W;++$)for(var J=0;J<H;++J)for(var Q=J-Z,X=Math.max(0,Math.ceil(Q/q)),ee=Math.min(V,(z+Q)/q),ae=0;ae<P;++ae)for(var te=ae-j,ne=Math.max(0,Math.ceil(te/G)),re=Math.min(O,(E+te)/G),ie=0;ie<R;++ie){for(var se=ie-K,oe=Math.max(0,Math.ceil(se/U)),ue=Math.min(L,(C+se)/U),de=0,pe=X;pe<ee;++pe)for(var le=pe*q-Q,ce=ne;ce<re;++ce)for(var fe=ce*G-te,he=oe;he<ue;++he)for(var me=N*Y+x*pe+T*ce+S*he,ve=M*(z-1-le)+A*(E-1-fe)+w*(C-1-(he*U-se))+D*$,ke=0;ke<B;++ke){de+=y[me+ke]*F[ve+ke]}m[k*Y+b*J+g*ae+I*ie+$]=de}return n.makeTensorInfo(h.shape,h.dtype,h.values)}},Xa=D(a.Cos,(function(e){return Math.cos(e)})),et={kernelName:a.Cos,backendName:"cpu",kernelFunc:Xa},at=D(a.Cosh,(function(e){return Math.cosh(e)})),tt={kernelName:a.Cosh,backendName:"cpu",kernelFunc:at};var nt={kernelName:a.CropAndResize,backendName:"cpu",kernelFunc:function(e){for(var t=e.inputs,n=e.backend,r=e.attrs,i=t.image,s=t.boxes,o=t.boxInd,u=r.cropSize,d=r.method,p=r.extrapolationValue,l=i.shape,c=l[0],f=l[1],h=l[2],m=l[3],v=s.shape[0],k=u[0],b=u[1],g=a.buffer([v,k,b,m],"float32"),I=n.data.get(s.dataId).values,y=n.data.get(o.dataId).values,N=n.data.get(i.dataId).values,x=a.util.computeStrides(i.shape),T=a.util.computeStrides(g.shape),S=0;S<v;S++){var F=4*S,M=I[F],A=I[F+1],w=I[F+2],D=I[F+3],_=y[S];if(!(_>=c))for(var z=k>1?(w-M)*(f-1)/(k-1):0,E=b>1?(D-A)*(h-1)/(b-1):0,C=0;C<k;C++){var W=k>1?M*(f-1)+C*z:.5*(M+w)*(f-1);if(W<0||W>f-1)for(var H=0;H<b;H++)for(var P=0;P<m;P++){var R=P+H*T[2]+C*T[1]+S*T[0];g.values[R]=p}else if("bilinear"===d){var B=Math.floor(W),V=Math.ceil(W),O=W-B;for(H=0;H<b;H++){if(($=b>1?A*(h-1)+H*E:.5*(A+D)*(h-1))<0||$>h-1)for(P=0;P<m;P++){R=P+H*T[2]+C*T[1]+S*T[0];g.values[R]=p}else{var L=Math.floor($),q=Math.ceil($),G=$-L;for(P=0;P<m;P++){var U=N[R=P+L*x[2]+B*x[1]+_*x[0]],Z=N[R=P+q*x[2]+B*x[1]+_*x[0]],j=N[R=P+L*x[2]+V*x[1]+_*x[0]],K=U+(Z-U)*G,Y=j+(N[R=P+q*x[2]+V*x[1]+_*x[0]]-j)*G;R=P+H*T[2]+C*T[1]+S*T[0],g.values[R]=K+(Y-K)*O}}}}else for(H=0;H<b;++H){var $;if(($=b>1?A*(h-1)+H*E:.5*(A+D)*(h-1))<0||$>h-1)for(P=0;P<m;P++){R=P+H*T[2]+C*T[1]+S*T[0];g.values[R]=p}else{var J=Math.round($),Q=Math.round(W);for(P=0;P<m;P++){var X=P+J*x[2]+Q*x[1]+_*x[0],ee=P+H*T[2]+C*T[1]+S*T[0];g.values[ee]=N[X]}}}}}return n.makeTensorInfo(g.shape,g.dtype,g.values)}};var rt={kernelName:a.Cumsum,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,o=r.axis,u=r.exclusive,d=r.reverse;s(i,"cumsum");var p=a.backend_util.getAxesPermutation([o],i.shape.length),l=i;null!=p&&(l=ge({inputs:{x:i},backend:n,attrs:{perm:p}}));var c=a.backend_util.getInnerMostAxes(1,i.shape.length)[0];if(c!==l.shape.length-1)throw new Error("backend.cumsum in CPU expects an inner-most axis="+(l.shape.length-1)+" but got axis="+c);for(var f=a.upcastType(l.dtype,"int32"),h=a.util.makeZerosTypedArray(a.util.sizeFromShape(l.shape),f),m=n.data.get(l.dataId).values,v=l.shape[l.shape.length-1],k=d?function(e,a){return e+v-a-1}:function(e,a){return e+a},b=0;b<m.length;b+=v)for(var g=0;g<v;g++){var I=k(b,g);if(0===g)h[I]=u?0:m[I];else{var y=k(b,g-1);h[I]=u?m[y]+h[y]:m[I]+h[y]}}var N=n.makeTensorInfo(l.shape,f,h);if(null!=p){var x=ge({inputs:{x:N},backend:n,attrs:{perm:a.backend_util.getUndoAxesPermutation(p)}});return n.disposeIntermediateTensorInfo(N),n.disposeIntermediateTensorInfo(l),x}return N}};var it={kernelName:a.DenseBincount,backendName:"cpu",kernelFunc:function(e){var a=e.inputs,t=e.backend,n=e.attrs,r=a.x,i=a.weights,s=n.size,o=n.binaryOutput;if(1===r.shape.length){var u=M(t.data.get(r.dataId).values,t.data.get(i.dataId).values,i.dtype,i.shape,s);return t.makeTensorInfo([s],i.dtype,u)}if(2===r.shape.length){var d=A(t.bufferSync(r),t.bufferSync(i),s,o);return t.makeTensorInfo(d.shape,i.dtype,d.values)}throw new Error("Error in denseBincount: input must be at most rank 2, but got rank"+r.shape.length+".")}};var st={kernelName:a.DepthToSpace,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,s=r.blockSize,o=r.dataFormat;a.util.assert("NHWC"===o,(function(){return"Only NHWC dataFormat supported on CPU for depthToSpace. Got "+o})),a.util.assert(s>1,(function(){return"blockSize should be > 1 for depthToSpace, but was: "+s}));for(var u=i.shape[0],d=i.shape[1],p=i.shape[2],l=i.shape[3],c=d*s,f=p*s,h=l/(s*s),m=n.data.get(i.dataId).values,v=new Float32Array(u*c*f*h),k=0,b=0;b<u;++b)for(var g=0;g<c;++g)for(var I=Math.floor(g/s),y=g%s,N=0;N<f;++N)for(var x=Math.floor(N/s),T=(y*s+N%s)*h,S=0;S<h;++S){var F=S+T+l*(x+p*(I+d*b));v[k++]=m[F]}return n.makeTensorInfo([u,c,f,h],i.dtype,v)}};function ot(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,o=t.filter,u=r.strides,d=r.pad,p=r.dilations,l=r.dimRoundingMode;s([i,o],"depthwiseConv2DNative");var c=a.util.computeStrides(i.shape),f=a.util.computeStrides(o.shape),h=p;null==h&&(h=[1,1]),a.util.assert(a.backend_util.eitherStridesOrDilationsAreOne(u,h),(function(){return"Error in depthwiseConv2d: Either strides or dilations must be 1. Got strides "+u+" and dilations '"+h+"'"}));for(var m=a.backend_util.computeConv2DInfo(i.shape,o.shape,u,h,d,l,!0),v=m.filterHeight,k=m.filterWidth,b=m.dilationHeight,g=m.dilationWidth,I=m.padInfo,y=I.left,N=I.top,x=m.outChannels/m.inChannels,T=new a.TensorBuffer(m.outShape,i.dtype),S=n.data.get(i.dataId).values,F=n.data.get(o.dataId).values,M=T.values,A=0;A<m.batchSize;++A)for(var w=A*c[0],D=A*T.strides[0],_=0;_<m.outHeight;++_)for(var z=D+_*T.strides[1],E=_*m.strideHeight-N,C=0;C<v;++C){var W=E+C*b;if(!(W<0||W>=m.inHeight))for(var H=C*f[0],P=w+W*c[1],R=0;R<m.outWidth;++R)for(var B=z+R*T.strides[2],V=R*m.strideWidth-y,O=0;O<k;++O){var L=V+O*g;if(!(L<0||L>=m.inWidth))for(var q=H+O*f[1],G=P+L*m.inChannels,U=B,Z=q,j=0;j<m.inChannels;++j){for(var K=S[G+j],Y=0;Y<x;++Y)M[U+Y]+=K*F[Z+Y];U+=x,Z+=x}}}return n.makeTensorInfo(T.shape,T.dtype,T.values)}var ut={kernelName:a.DepthwiseConv2dNative,backendName:"cpu",kernelFunc:ot};var dt={kernelName:a.DepthwiseConv2dNativeBackpropFilter,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,o=t.dy,u=r.strides,d=r.dilations,p=r.pad,l=r.dimRoundingMode,c=r.filterShape;s([i,o],"depthwiseConv2dNativeBackpropFilter");for(var f=a.backend_util.computeConv2DInfo(i.shape,c,u,d,p,l,!0),h=f.strideHeight,m=f.strideWidth,v=f.filterHeight,k=f.filterWidth,b=new a.TensorBuffer(f.filterShape,"float32"),g=f.padInfo.left,I=f.padInfo.top,y=f.outChannels/f.inChannels,N=n.data.get(i.dataId).values,x=new a.TensorBuffer(i.shape,i.dtype,N),T=n.data.get(o.dataId).values,S=new a.TensorBuffer(o.shape,o.dtype,T),F=0;F<v;++F)for(var M=Math.max(0,Math.ceil((I-F)/h)),A=Math.min(f.outHeight,(f.inHeight+I-F)/h),w=0;w<k;++w)for(var D=Math.max(0,Math.ceil((g-w)/m)),_=Math.min(f.outWidth,(f.inWidth+g-w)/m),z=0;z<f.outChannels;++z){for(var E=Math.trunc(z/y),C=z%y,W=0,H=0;H<f.batchSize;++H)for(var P=M;P<A;++P)for(var R=F+P*h-I,B=D;B<_;++B){var V=w+B*m-g;W+=x.get(H,R,V,E)*S.get(H,P,B,z)}b.set(W,F,w,E,C)}return n.makeTensorInfo(b.shape,b.dtype,b.values)}};var pt={kernelName:a.DepthwiseConv2dNativeBackpropInput,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.dy,o=t.filter,u=r.strides,d=r.dilations,p=r.pad,l=r.dimRoundingMode,c=r.inputShape;s([i,o],"depthwiseConv2DNativeBackpropInput");for(var f=a.util.computeStrides(i.shape),h=a.util.computeStrides(o.shape),m=a.backend_util.computeConv2DInfo(c,o.shape,u,d,p,l,!0),v=new a.TensorBuffer(m.inShape,"float32"),k=v.values,b=v.strides,g=b[0],I=b[1],y=b[2],N=n.data.get(i.dataId).values,x=f[0],T=f[1],S=f[2],F=n.data.get(o.dataId).values,M=h[0],A=h[1],w=h[2],D=m.batchSize,_=m.filterHeight,z=m.filterWidth,E=m.inChannels,C=m.inHeight,W=m.inWidth,H=m.outChannels,P=m.outHeight,R=m.outWidth,B=m.strideHeight,V=m.strideWidth,O=_-1-m.padInfo.top,L=z-1-m.padInfo.left,q=H/E,G=0;G<D;++G)for(var U=0;U<E;++U)for(var Z=0;Z<C;++Z)for(var j=Z-O,K=Math.max(0,Math.ceil(j/B)),Y=Math.min(P,(_+j)/B),$=0;$<W;++$){for(var J=$-L,Q=Math.max(0,Math.ceil(J/V)),X=Math.min(R,(z+J)/V),ee=0,ae=K;ae<Y;++ae)for(var te=ae*B-j,ne=Q;ne<X;++ne)for(var re=x*G+T*ae+S*ne,ie=M*(_-1-te)+A*(z-1-(ne*V-J))+w*U,se=0;se<q;++se){ee+=N[re+(U*q+se)]*F[ie+se]}k[g*G+I*Z+y*$+U]=ee}return n.makeTensorInfo(v.shape,v.dtype,v.values)}};var lt={kernelName:a.Diag,backendName:"cpu",kernelFunc:function(e){for(var t=e.inputs,n=e.backend,r=t.x,i=a.util.sizeFromShape(r.shape),s=n.data.get(r.dataId).values,o=a.buffer([i,i],r.dtype),u=o.values,d=0;d<s.length;d++)u[d*i+d]=s[d];var p=r.shape.concat(r.shape);return n.makeTensorInfo(p,o.dtype,o.values)}},ct={kernelName:a.Dilation2D,backendName:"cpu",kernelFunc:function(e){for(var t=e.inputs,n=e.backend,r=e.attrs,i=t,s=i.x,o=i.filter,u=r,d=u.strides,p=u.pad,l=u.dilations,c=n,f=c.data.get(s.dataId).values,h=s.shape.length,m=c.data.get(o.dataId).values,v=o.shape.length,k=a.backend_util.computeDilation2DInfo(s.shape,o.shape,d,p,"NHWC",l),b=k.batchSize,g=k.inHeight,I=k.inWidth,y=k.inChannels,N=k.outHeight,x=k.outWidth,T=k.padInfo,S=k.strideHeight,F=k.strideWidth,M=k.filterHeight,A=k.filterWidth,w=k.dilationHeight,D=k.dilationWidth,_=k.outShape,z=a.util.sizeFromShape(_),E=_.length,C=a.util.getArrayFromDType(s.dtype,z),W=0;W<b;++W)for(var H=0;H<N;++H)for(var P=H*S-T.top,R=0;R<x;++R)for(var B=R*F-T.left,V=0;V<y;++V){for(var O=Number.MIN_SAFE_INTEGER,L=0;L<M;++L){var q=P+L*w;if(q>=0&&q<g)for(var G=0;G<A;++G){var U=B+G*D;if(U>=0&&U<I){var Z=a.util.locToIndex([W,q,U,V],h,a.util.computeStrides(s.shape)),j=a.util.locToIndex([L,G,V],v,a.util.computeStrides(o.shape)),K=f[Z]+m[j];K>O&&(O=K)}}}C[a.util.locToIndex([W,H,R,V],E,a.util.computeStrides(_))]=O}return{dataId:c.write(a.util.toTypedArray(C,s.dtype),_,s.dtype),shape:_,dtype:s.dtype}}},ft={kernelName:a.Dilation2DBackpropFilter,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t,s=i.x,o=i.filter,u=i.dy,d=r,p=d.strides,l=d.pad,c=d.dilations,f=n,h=a.util.toNestedArray(s.shape,f.data.get(s.dataId).values),m=a.util.toNestedArray(o.shape,f.data.get(o.dataId).values),v=a.backend_util.computeDilation2DInfo(s.shape,o.shape,p,l,"NHWC",c),k=v.batchSize,b=v.inHeight,g=v.inWidth,I=v.inChannels,y=v.outHeight,N=v.outWidth,x=v.padInfo,T=v.strideHeight,S=v.strideWidth,F=v.filterHeight,M=v.filterWidth,A=v.dilationHeight,w=v.dilationWidth,D=v.outShape;a.util.assert(u.rank===D.length,(function(){return"Error in "+a.Dilation2DBackpropFilter+", dy must have the same rank as output "+D.length+", but got "+u.rank}));for(var _=a.util.toNestedArray(D,f.data.get(u.dataId).values),z=a.util.makeZerosNestedTypedArray(o.shape,o.dtype),E=0;E<k;++E)for(var C=0;C<y;++C)for(var W=C*T-x.top,H=0;H<N;++H)for(var P=H*S-x.left,R=0;R<I;++R){for(var B=Number.MIN_SAFE_INTEGER,V=0,O=0,L=0;L<F;++L){var q=W+L*A;if(q>=0&&q<b)for(var G=0;G<M;++G){var U=P+G*w;if(U>=0&&U<g){var Z=h[E][q][U][R]+m[L][G][R];Z>B&&(B=Z,V=L,O=G)}}}z[V][O][R]+=_[E][C][H][R]}return{dataId:f.write(a.util.toTypedArray(z,s.dtype),o.shape,o.dtype),shape:o.shape,dtype:o.dtype}}},ht={kernelName:a.Dilation2DBackpropInput,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t,s=i.x,o=i.filter,u=i.dy,d=r,p=d.strides,l=d.pad,c=d.dilations,f=n,h=a.util.toNestedArray(s.shape,f.data.get(s.dataId).values),m=a.util.toNestedArray(o.shape,f.data.get(o.dataId).values),v=a.backend_util.computeDilation2DInfo(s.shape,o.shape,p,l,"NHWC",c),k=v.batchSize,b=v.inHeight,g=v.inWidth,I=v.inChannels,y=v.outHeight,N=v.outWidth,x=v.padInfo,T=v.strideHeight,S=v.strideWidth,F=v.filterHeight,M=v.filterWidth,A=v.dilationHeight,w=v.dilationWidth,D=v.outShape;a.util.assert(u.rank===D.length,(function(){return"Error in "+a.Dilation2DBackpropInput+", dy must have the same rank as output "+D.length+", but got "+u.rank}));for(var _=a.util.toNestedArray(D,f.data.get(u.dataId).values),z=a.util.makeZerosNestedTypedArray(s.shape,s.dtype),E=0;E<k;++E)for(var C=0;C<y;++C)for(var W=C*T-x.top,H=0;H<N;++H)for(var P=H*S-x.left,R=0;R<I;++R){for(var B=Number.MIN_SAFE_INTEGER,V=W<0?0:W,O=P<0?0:P,L=0;L<F;++L){var q=W+L*A;if(q>=0&&q<b)for(var G=0;G<M;++G){var U=P+G*w;if(U>=0&&U<g){var Z=h[E][q][U][R]+m[L][G][R];Z>B&&(B=Z,V=q,O=U)}}}z[E][V][O][R]+=_[E][C][H][R]}return{dataId:f.write(a.util.toTypedArray(z,s.dtype),s.shape,s.dtype),shape:s.shape,dtype:s.dtype}}};function mt(e){var t,n=e.inputs,r=e.backend,i=e.attrs,o=n.x,u=i.axis,d=i.keepDims;s(o,"sum");var p=(t="bool"===o.dtype?g({inputs:{x:o},backend:r,attrs:{dtype:"int32"}}):m({inputs:{x:o},backend:r})).shape.length,l=a.util.parseAxisParam(u,t.shape),c=a.backend_util.getAxesPermutation(l,p),f=l,v=t;null!=c&&(v=ge({inputs:{x:t},backend:r,attrs:{perm:c}}),f=a.backend_util.getInnerMostAxes(f.length,p)),a.backend_util.assertAxesAreInnerMostDims("sum",f,v.shape.length);for(var k=a.backend_util.computeOutAndReduceShapes(v.shape,f),b=k[0],I=k[1],y=h(r,b,a.backend_util.upcastType(v.dtype,"int32")),N=a.util.sizeFromShape(I),x=r.data.get(y.dataId).values,T=r.data.get(v.dataId).values,S=0;S<x.length;++S){for(var F=S*N,M=0,A=0;A<N;++A)M+=T[F+A];x[S]=M}if(d){var w=y;y=ra({inputs:{x:y},backend:r,attrs:{shape:a.backend_util.expandShapeToKeepDim(y.shape,l)}}),r.disposeIntermediateTensorInfo(w)}return r.disposeIntermediateTensorInfo(t),null!=c&&r.disposeIntermediateTensorInfo(v),y}var vt={kernelName:a.Sum,backendName:"cpu",kernelFunc:mt};var kt={kernelName:a.Einsum,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs.equation,i=t,s=a.backend_util.decodeEinsumEquation(r,i.length),o=s.allDims,u=s.summedDims,d=s.idDims;a.backend_util.checkEinsumDimSizes(o.length,d,i);for(var p=a.backend_util.getEinsumComputePath(u,d),l=p.path,c=p.steps,f=c.length,h=null,m=o.length,v=[],k=0;k<f;++k){for(var b=0,g=c[k];b<g.length;b++){var I=g[b],y=a.backend_util.getEinsumPermutation(m,d[I]),N=y.permutationIndices,x=y.expandDims,T=void 0;a.backend_util.isIdentityPermutation(N)?T=i[I]:(T=ge({inputs:{x:i[I]},backend:n,attrs:{perm:N}}),v.push(T));for(var S=T.shape.slice(),F=0;F<x.length;++F)S.splice(x[F],0,1);a.util.arraysEqual(T.shape,S)||(T=ra({inputs:{x:T},backend:n,attrs:{shape:S}}),v.push(T)),null===h?h=T:(h=le({inputs:{a:T,b:h},backend:n}),v.push(h))}k<f-1&&(l[k]>=0&&(h=mt({inputs:{x:h},backend:n,attrs:{axis:l[k]-(o.length-m),keepDims:!1}}),v.push(h)),m--)}for(var M=0,A=v;M<A.length;M++){var w=A[M];w!==h&&n.disposeIntermediateTensorInfo(w)}return h}};var bt={kernelName:a.EluGrad,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=t.dy,i=t.y;s([r,i],"eluGrad");for(var o=new Float32Array(a.util.sizeFromShape(i.shape)),u=n.data.get(i.dataId).values,d=n.data.get(r.dataId).values,p=0;p<u.length;++p){var l=u[p];o[p]=l>=1?d[p]:d[p]*(l+1)}return n.makeTensorInfo(i.shape,"float32",o)}},gt=l((function(e,a){return e===a?1:0})),It=y(a.Equal,gt,null,"bool"),yt={kernelName:a.Equal,backendName:"cpu",kernelFunc:It},Nt=a.backend_util.ERF_P,xt=a.backend_util.ERF_A1,Tt=a.backend_util.ERF_A2,St=a.backend_util.ERF_A3,Ft=a.backend_util.ERF_A4,Mt=a.backend_util.ERF_A5,At=D(a.Erf,(function(e){var a=Math.sign(e),t=Math.abs(e),n=1/(1+Nt*t);return a*(1-((((Mt*n+Ft)*n+St)*n+Tt)*n+xt)*n*Math.exp(-t*t))})),wt={kernelName:a.Erf,backendName:"cpu",kernelFunc:At};function Dt(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.input,s=r.dim,o=i.shape.length,u=i.shape.slice(),d=s;return s<0&&(a.util.assert(-(o+1)<=s,(function(){return"Axis must be in the interval ["+-(o+1)+", "+o+"]"})),d=o+s+1),u.splice(d,0,1),ra({inputs:{x:i},backend:n,attrs:{shape:u}})}var _t={kernelName:a.ExpandDims,backendName:"cpu",kernelFunc:Dt},zt=l((function(e,a){return e/a})),Et=y(a.RealDiv,zt),Ct={kernelName:a.RealDiv,backendName:"cpu",kernelFunc:Et};function Wt(e,t,n){for(var r=e.shape,i=r[0],s=r[1],o=n.data.get(e.dataId),u=o.complexTensorInfos.real,d=o.complexTensorInfos.imag,p=[i,s],l=a.util.sizeFromShape(p),f=a.util.getTypedArrayFromDType("float32",l),h=a.util.getTypedArrayFromDType("float32",l),m=0;m<i;m++){for(var v=Ae({inputs:{x:u},backend:n,attrs:{begin:[m,0],size:[1,s]}}),k=Ae({inputs:{x:d},backend:n,attrs:{begin:[m,0],size:[1,s]}}),b=c({inputs:{real:v,imag:k},backend:n}),g=Ht(b,t,n),I=g.real,y=g.imag,N=a.backend_util.mergeRealAndImagArrays(I,y),x=0;x<s;x++){var T=a.backend_util.getComplexWithIndex(N,x);f[m*s+x]=T.real,h[m*s+x]=T.imag}n.disposeIntermediateTensorInfo(v),n.disposeIntermediateTensorInfo(k),n.disposeIntermediateTensorInfo(b)}var S=n.makeTensorInfo(p,"float32",f),F=n.makeTensorInfo(p,"float32",h),M=c({inputs:{real:S,imag:F},backend:n});return n.disposeIntermediateTensorInfo(S),n.disposeIntermediateTensorInfo(F),M}function Ht(e,t,n){var r=a.util.sizeFromShape(e.shape),i=n.data.get(e.dataId),s=n.data.get(i.complexTensorInfos.real.dataId).values,o=n.data.get(i.complexTensorInfos.imag.dataId).values;if(0==((y=r)&y-1)){var u=function e(t,n,r,i,s){if(1===r)return{real:t,imag:n};var o=a.backend_util.mergeRealAndImagArrays(t,n),u=r/2,d=a.backend_util.complexWithEvenIndex(o),p=d.real,l=d.imag,f=[p.length],h=s.makeTensorInfo(f,"float32",p),m=s.makeTensorInfo(f,"float32",l),v=c({inputs:{real:h,imag:m},backend:s}),b=a.backend_util.complexWithOddIndex(o),g=b.real,I=b.imag,y=[g.length],N=s.makeTensorInfo(y,"float32",g),x=s.makeTensorInfo(y,"float32",I),T=c({inputs:{real:N,imag:x},backend:s}),F=e(p,l,u,i,s),M=F.real,A=F.imag,w=[M.length],D=s.makeTensorInfo(w,"float32",M),_=s.makeTensorInfo(w,"float32",A),z=c({inputs:{real:D,imag:_},backend:s}),E=e(g,I,u,i,s),C=E.real,W=E.imag,H=[C.length],P=s.makeTensorInfo(H,"float32",C),R=s.makeTensorInfo(H,"float32",W),B=c({inputs:{real:P,imag:R},backend:s}),V=a.backend_util.exponents(r,i),O=[V.real.length],L=s.makeTensorInfo(O,"float32",V.real),q=s.makeTensorInfo(O,"float32",V.imag),G=c({inputs:{real:L,imag:q},backend:s}),U=le({inputs:{a:G,b:B},backend:s}),Z=S({inputs:{a:z,b:U},backend:s}),j=Re({inputs:{a:z,b:U},backend:s}),K=k({inputs:{input:Z},backend:s}),Y=k({inputs:{input:j},backend:s}),$=La({inputs:{input:Z},backend:s}),J=La({inputs:{input:j},backend:s}),Q=Ga({inputs:[K,Y],backend:s,attrs:{axis:0}}),X=Ga({inputs:[$,J],backend:s,attrs:{axis:0}}),ee=s.data.get(Q.dataId).values,ae=s.data.get(X.dataId).values;return s.disposeIntermediateTensorInfo(h),s.disposeIntermediateTensorInfo(m),s.disposeIntermediateTensorInfo(v),s.disposeIntermediateTensorInfo(N),s.disposeIntermediateTensorInfo(x),s.disposeIntermediateTensorInfo(T),s.disposeIntermediateTensorInfo(D),s.disposeIntermediateTensorInfo(_),s.disposeIntermediateTensorInfo(z),s.disposeIntermediateTensorInfo(P),s.disposeIntermediateTensorInfo(R),s.disposeIntermediateTensorInfo(B),s.disposeIntermediateTensorInfo(L),s.disposeIntermediateTensorInfo(q),s.disposeIntermediateTensorInfo(G),s.disposeIntermediateTensorInfo(U),s.disposeIntermediateTensorInfo(Z),s.disposeIntermediateTensorInfo(j),s.disposeIntermediateTensorInfo(K),s.disposeIntermediateTensorInfo($),s.disposeIntermediateTensorInfo(Y),s.disposeIntermediateTensorInfo(J),s.disposeIntermediateTensorInfo(Q),s.disposeIntermediateTensorInfo(X),{real:ee,imag:ae}}(s,o,r,t,n),d=[e.shape[0],e.shape[1]];if(t){var p=n.makeTensorInfo(d,"float32",u.real),l=n.makeTensorInfo(d,"float32",u.imag),f=n.makeTensorInfo([],"float32",a.util.createScalarValue(r,"float32")),h=m({inputs:{x:f},backend:n}),v=Ct.kernelFunc({inputs:{a:p,b:f},backend:n}),b=Ct.kernelFunc({inputs:{a:l,b:h},backend:n}),g=n.data.get(v.dataId).values,I=n.data.get(b.dataId).values;return n.disposeIntermediateTensorInfo(p),n.disposeIntermediateTensorInfo(l),n.disposeIntermediateTensorInfo(f),n.disposeIntermediateTensorInfo(h),n.disposeIntermediateTensorInfo(v),n.disposeIntermediateTensorInfo(b),{real:g,imag:I}}return u}var y,N=function(e,t,n){for(var r=new Float32Array(2*t),i=0;i<t;i++){for(var s=0,o=0,u=0;u<t;u++){var d=a.backend_util.exponent(i*u,t,n),p=a.backend_util.getComplexWithIndex(e,u);s+=p.real*d.real-p.imag*d.imag,o+=p.real*d.imag+p.imag*d.real}n&&(s/=t,o/=t),a.backend_util.assignToTypedArray(r,s,o,i)}return r}(a.backend_util.mergeRealAndImagArrays(s,o),r,t);return a.backend_util.splitRealAndImagArrays(N)}var Pt={kernelName:a.FFT,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=t.input,i=a.util.sizeFromShape(r.shape),s=r.shape[r.shape.length-1],o=ra({inputs:{x:r},backend:n,attrs:{shape:[i/s,s]}}),u=Wt(o,!1,n),d=ra({inputs:{x:u},backend:n,attrs:{shape:r.shape}});return n.disposeIntermediateTensorInfo(o),n.disposeIntermediateTensorInfo(u),d}};function Rt(e){var t=e.backend,n=e.attrs,r=n.shape,i=n.value,s=n.dtype||a.util.inferDtype(i),o=a.util.getArrayFromDType(s,a.util.sizeFromShape(r));return function(e,a,t){e.fill(a)}(o,i),t.makeTensorInfo(r,s,o)}var Bt={kernelName:a.Fill,backendName:"cpu",kernelFunc:Rt};var Vt={kernelName:a.FlipLeftRight,backendName:"cpu",kernelFunc:function(e){for(var t=e.inputs,n=(e.attrs,e.backend),r=t.image,i=n,s=a.util.getTypedArrayFromDType(r.dtype,a.util.sizeFromShape(r.shape)),o=r.shape,u=o[0],d=o[1],p=o[2],l=o[3],c=i.data.get(r.dataId).values,f=0;f<u;f++)for(var h=f*p*d*l,m=0;m<d;m++)for(var v=m*(p*l),k=0;k<p;k++)for(var b=k*l,g=0;g<l;g++){var I=[u,m,k,g][2],y=Math.round(p-I),N=h+v+b+g,x=c[N];if(y>=0&&y<p)x=c[h+v+y*l+g];s[N]=x}return{dataId:i.write(s,r.shape,r.dtype),shape:r.shape,dtype:r.dtype}}},Ot=l((function(e,a){return Math.floor(e/a)})),Lt=y(a.FloorDiv,Ot,null,"int32"),qt={kernelName:a.FloorDiv,backendName:"cpu",kernelFunc:Lt};var Gt={kernelName:a.FusedConv2D,backendName:"cpu",kernelFunc:function(e){var a=e.inputs,t=e.backend,n=e.attrs,r=a.x,i=a.filter,s=a.bias,o=a.preluActivationWeights,u=n.strides,d=n.pad,p=n.dataFormat,l=n.dilations,c=n.dimRoundingMode,f=n.activation,h=n.leakyreluAlpha,m=Za({inputs:{x:r,filter:i},backend:t,attrs:{strides:u,pad:d,dataFormat:p,dilations:l,dimRoundingMode:c}});if(s){var v=m;m=S({inputs:{a:m,b:s},backend:t}),t.disposeIntermediateTensorInfo(v)}if(f){v=m;m=na(t,m,f,o,h),t.disposeIntermediateTensorInfo(v)}return m}};var Ut={kernelName:a.FusedDepthwiseConv2D,backendName:"cpu",kernelFunc:function(e){var a=e.inputs,t=e.backend,n=e.attrs,r=a.x,i=a.filter,s=a.bias,o=a.preluActivationWeights,u=n.strides,d=n.pad,p=n.dataFormat,l=n.dilations,c=n.dimRoundingMode,f=n.activation,h=n.leakyreluAlpha,m=ot({inputs:{x:r,filter:i},backend:t,attrs:{strides:u,pad:d,dataFormat:p,dilations:l,dimRoundingMode:c}});if(s){var v=m;m=S({inputs:{a:m,b:s},backend:t}),t.disposeIntermediateTensorInfo(v)}if(f){v=m;m=na(t,m,f,o,h),t.disposeIntermediateTensorInfo(v)}return m}};var Zt={kernelName:a.GatherNd,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=t.params,i=t.indices,s=a.util.sizeFromShape(r.shape),o=i.shape,u=o[o.length-1],d=a.backend_util.prepareAndValidate(r,i),p=d[0],l=d[1],c=d[2],f=d[3];if(0===l)return n.makeTensorInfo(p,r.dtype,[]);for(var h=a.buffer([l,c],r.dtype),m=n.data.get(i.dataId).values,v=n.data.get(r.dataId).values,k=0;k<l;k++){for(var b=[],g=0,I=0;I<u;I++){var y=m[k*u+I];g+=y*f[I],b.push(y)}if(g<0||g>=s/c)throw new Error("Invalid indices: "+b+" does not index into "+r.shape);for(var N=0;N<c;N++)h.values[k*c+N]=v[g*c+N]}return n.makeTensorInfo(p,h.dtype,h.values)}};var jt={kernelName:a.GatherV2,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,o=t.indices,u=r.axis,d=r.batchDims;s([i,o],"gatherV2");var p=d;null==d&&(p=0);var l=a.util.sizeFromShape(o.shape),c=a.util.parseAxisParam(u,i.shape)[0],f=a.backend_util.segment_util.collectGatherOpShapeInfo(i,o,c,p),h=ra({inputs:{x:i},backend:n,attrs:{shape:[f.batchSize,f.outerSize,f.dimSize,f.sliceSize]}}),m=ra({inputs:{x:o},backend:n,attrs:{shape:[f.batchSize,l/f.batchSize]}}),v=[f.batchSize,f.outerSize,l/f.batchSize,f.sliceSize],k=n.bufferSync(m),b=U(n.bufferSync(h),k,v);return n.disposeIntermediateTensorInfo(h),n.disposeIntermediateTensorInfo(m),n.makeTensorInfo(f.outputShape,b.dtype,b.values)}},Kt=l((function(e,a){return e>=a?1:0})),Yt=y(a.GreaterEqual,Kt,null,"bool"),$t={kernelName:a.GreaterEqual,backendName:"cpu",kernelFunc:Yt};var Jt={kernelName:a.IFFT,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=t.input,i=a.util.sizeFromShape(r.shape),s=r.shape[r.shape.length-1],o=ra({inputs:{x:r},backend:n,attrs:{shape:[i/s,s]}}),u=Wt(o,!0,n),d=ra({inputs:{x:u},backend:n,attrs:{shape:r.shape}});return n.disposeIntermediateTensorInfo(o),n.disposeIntermediateTensorInfo(u),d}},Qt=D(a.IsFinite,(function(e){return Number.isFinite(e)?1:0}),"bool"),Xt={kernelName:a.IsFinite,backendName:"cpu",kernelFunc:Qt},en=D(a.IsInf,(function(e){return Math.abs(e)===1/0?1:0}),"bool"),an={kernelName:a.IsInf,backendName:"cpu",kernelFunc:en},tn=D(a.IsNan,(function(e){return Number.isNaN(e)?1:0}),"bool"),nn={kernelName:a.IsNan,backendName:"cpu",kernelFunc:tn},rn=l((function(e,a){return e<=a?1:0})),sn=y(a.LessEqual,rn,null,"bool"),on={kernelName:a.LessEqual,backendName:"cpu",kernelFunc:sn};var un={kernelName:a.LinSpace,backendName:"cpu",kernelFunc:function(e){var a=e.backend,t=e.attrs,n=Q(t.start,t.stop,t.num);return a.makeTensorInfo([n.length],"float32",n)}},dn=D(a.Log1p,(function(e){return Math.log1p(e)})),pn={kernelName:a.Log1p,backendName:"cpu",kernelFunc:dn},ln=l((function(e,a){return e&&a})),cn=y(a.LogicalAnd,ln,null,"bool"),fn={kernelName:a.LogicalAnd,backendName:"cpu",kernelFunc:cn},hn=D(a.LogicalNot,(function(e){return e?0:1}),"bool"),mn={kernelName:a.LogicalNot,backendName:"cpu",kernelFunc:hn},vn=l((function(e,a){return e||a})),kn=y(a.LogicalOr,vn,null,"bool"),bn={kernelName:a.LogicalOr,backendName:"cpu",kernelFunc:kn};var gn={kernelName:a.LRN,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,o=r.depthRadius,u=r.bias,d=r.alpha,p=r.beta;s(i,"LRN");var l=i.shape[3],c=l-1,f=n.data.get(i.dataId).values,h=a.util.sizeFromShape(i.shape),m=new Float32Array(h);function v(e){for(var a=e%l,t=e-a+Math.max(0,a-o),n=e-a+Math.min(a+o,c),r=0;t<=n;t++){var i=f[t];r+=i*i}return r}for(var k=0;k<h;k++){var b=v(k),g=f[k]*Math.pow(u+d*b,-p);m[k]=g}return n.makeTensorInfo(i.shape,i.dtype,m)}};var In={kernelName:a.LRNGrad,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,o=t.y,u=t.dy,d=r.depthRadius,p=r.bias,l=r.alpha,c=r.beta;s(u,"LRNGrad");for(var f=a.util.sizeFromShape(u.shape),h=u.shape[3],m=n.data.get(u.dataId).values,v=n.data.get(i.dataId).values,k=n.data.get(o.dataId).values,b=new Float32Array(f),g=f,I=0;I<g;I++){for(var y=I%h,N=I-y+Math.max(0,y-d),x=I-y+Math.min(h,y+d+1),T=0,S=N;S<x;S++)T+=Math.pow(v[S],2);T=l*T+p;for(S=N;S<x;S++){var F=-2*l*c*v[S]*k[I]/T;I===S&&(F+=Math.pow(T,-c)),F*=m[I],b[S]+=F}}return n.makeTensorInfo(u.shape,i.dtype,b)}};function yn(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,o=r.reductionIndices,u=r.keepDims,d=n,p=i.shape,l=p.length,c=a.util.parseAxisParam(o,p),f=c,h=a.backend_util.getAxesPermutation(f,l),m=d.data.get(i.dataId).values;if(null!=h){for(var v=new Array(l),k=0;k<v.length;k++)v[k]=p[h[k]];m=be(m,p,i.dtype,h,v),f=a.backend_util.getInnerMostAxes(f.length,l),p=v}s(i,"max"),a.backend_util.assertAxesAreInnerMostDims("max",f,l);var b=a.backend_util.computeOutAndReduceShapes(p,f),g=b[0],I=b[1],y=te(m,a.util.sizeFromShape(I),g,i.dtype),N=d.write(y,g,i.dtype),x=g;u&&(x=v=a.backend_util.expandShapeToKeepDim(g,c));return{dataId:N,shape:x,dtype:i.dtype}}var Nn={kernelName:a.Max,backendName:"cpu",kernelFunc:yn};var xn={kernelName:a.MaxPool,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x;s(i,"maxPool");var o=r.filterSize,u=r.strides,d=r.pad,p=r.dimRoundingMode;a.util.assert(a.backend_util.eitherStridesOrDilationsAreOne(u,1),(function(){return"Error in maxPool: Either strides or dilations must be 1. Got strides "+u+" and dilations '1'"}));var l,c=a.backend_util.computePool2DInfo(i.shape,o,u,1,d,p);if(1===c.filterWidth&&1===c.filterHeight&&a.util.arraysEqual(c.inShape,c.outShape))l=m({inputs:{x:i},backend:n});else{var f=n.data.get(i.dataId).values,h=a.util.computeStrides(i.shape),v=wa(f,i.shape,i.dtype,h,c,"max");l=n.makeTensorInfo(c.outShape,i.dtype,v.values)}return l}};var Tn={kernelName:a.MaxPool3D,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,o=r.filterSize,u=r.strides,d=r.pad,p=r.dimRoundingMode,l=r.dataFormat;s(i,"maxPool3d");var c=a.backend_util.computePool3DInfo(i.shape,o,u,1,d,p,l),f=_a(n.data.get(i.dataId).values,i.shape,i.dtype,a.util.computeStrides(i.shape),c,"max");return n.makeTensorInfo(f.shape,"float32",f.values)}};var Sn={kernelName:a.MaxPool3DGrad,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.dy,o=t.input,u=r.filterSize,d=r.strides,p=r.pad,l=r.dimRoundingMode;s([i,o],"maxPool3DGrad");for(var c=a.backend_util.computePool3DInfo(o.shape,u,d,1,p,l),f=function(e,t){for(var n=a.buffer(t.outShape,"int32"),r=t.strideDepth,i=t.strideHeight,s=t.strideWidth,o=t.dilationDepth,u=t.dilationHeight,d=t.dilationWidth,p=t.effectiveFilterDepth,l=t.effectiveFilterHeight,c=t.effectiveFilterWidth,f=t.padInfo.front,h=t.padInfo.top,m=t.padInfo.left,v=0;v<t.batchSize;++v)for(var k=0;k<t.inChannels;++k)for(var b=0;b<t.outDepth;++b){for(var g=b*r-f,I=g;I<0;)I+=o;for(var y=Math.min(t.inDepth,p+g),N=0;N<t.outHeight;++N){for(var x=N*i-h,T=x;T<0;)T+=u;for(var S=Math.min(t.inHeight,l+x),F=0;F<t.outWidth;++F){for(var M=F*s-m,A=M;A<0;)A+=d;for(var w=Math.min(t.inWidth,c+M),D=Number.NEGATIVE_INFINITY,_=-1,z=I;z<y;z+=o)for(var E=z-g,C=T;C<S;C+=u)for(var W=C-x,H=A;H<w;H+=d){var P=H-M,R=e.get(v,z,C,H,k);R>=D&&(D=R,_=E*l*c+W*l+P)}n.set(_,v,b,N,F,k)}}}return n}(n.bufferSync(o),c),h=c.strideDepth,m=c.strideHeight,v=c.strideWidth,k=c.dilationDepth,b=c.dilationHeight,g=c.dilationWidth,I=c.effectiveFilterDepth,y=c.effectiveFilterHeight,N=c.effectiveFilterWidth,x=I-1-c.padInfo.front,T=N-1-c.padInfo.left,S=y-1-c.padInfo.top,F=a.buffer(o.shape,"float32"),M=n.bufferSync(i),A=0;A<c.batchSize;++A)for(var w=0;w<c.inChannels;++w)for(var D=0;D<c.inDepth;++D)for(var _=0;_<c.inHeight;++_)for(var z=0;z<c.inWidth;++z){for(var E=D-x,C=_-S,W=z-T,H=0,P=0;P<I;P+=k){var R=(E+P)/h;if(!(R<0||R>=c.outDepth||Math.floor(R)!==R))for(var B=0;B<y;B+=b){var V=(C+B)/m;if(!(V<0||V>=c.outHeight||Math.floor(V)!==V))for(var O=0;O<N;O+=g){var L=(W+O)/v;if(!(L<0||L>=c.outWidth||Math.floor(L)!==L)){var q=I*y*N-1-f.get(A,R,V,L,w)===P*y*N+B*N+O?1:0;if(0!==q)H+=M.get(A,R,V,L,w)*q}}}}F.set(H,A,D,_,z,w)}return n.makeTensorInfo(F.shape,F.dtype,F.values)}};var Fn={kernelName:a.MaxPoolGrad,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.dy,o=t.input,u=o;s([o,t.output],"maxPoolGrad");for(var d=r.filterSize,p=r.strides,l=r.pad,c=r.dimRoundingMode,f=a.backend_util.computePool2DInfo(u.shape,d,p,1,l,c),h=n.data.get(u.dataId).values,m=a.buffer(f.outShape,u.dtype,Da(h,u.shape,u.dtype,f).values),v=f.strideHeight,k=f.strideWidth,b=f.dilationHeight,g=f.dilationWidth,I=f.effectiveFilterHeight,y=f.effectiveFilterWidth,N=y-1-f.padInfo.left,x=I-1-f.padInfo.top,T=a.buffer(u.shape,"float32"),S=n.data.get(i.dataId).values,F=a.buffer(i.shape,"float32",S),M=0;M<f.batchSize;++M)for(var A=0;A<f.inChannels;++A)for(var w=0;w<f.inHeight;++w)for(var D=0;D<f.inWidth;++D){for(var _=w-x,z=D-N,E=0,C=0;C<I;C+=b){var W=(_+C)/v;if(!(W<0||W>=f.outHeight||Math.floor(W)!==W))for(var H=0;H<y;H+=g){var P=(z+H)/k;if(!(P<0||P>=f.outWidth||Math.floor(P)!==P)){var R=I*y-1-m.get(M,W,P,A)===C*y+H?1:0;if(0!==R)E+=F.get(M,W,P,A)*R}}}T.set(E,M,w,D,A)}return n.makeTensorInfo(T.shape,T.dtype,T.values)}};var Mn={kernelName:a.MaxPoolWithArgmax,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.attrs,r=e.backend,i=t.x,o=n,u=o.filterSize,d=o.strides,p=o.pad,l=o.includeBatchInIndex,c=r;s(i,"MaxPoolWithArgmax");var f=c.data.get(i.dataId).values,h=a.backend_util.computePool2DInfo(i.shape,u,d,[1,1],p),m=function(e,t,n,r,i){var s=wa(e,0,n,a.util.computeStrides(t),i,"max"),o=Da(e,t,n,i,!0,r);return[s.values,o.values]}(f,i.shape,i.dtype,l,h),v=m[0],k=m[1],b=c.write(v,h.outShape,i.dtype),g=c.write(k,h.outShape,i.dtype);return[{dataId:b,shape:h.outShape,dtype:i.dtype},{dataId:g,shape:h.outShape,dtype:"int32"}]}};var An={kernelName:a.Mean,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,s=r.axis,o=r.keepDims,u=a.util.parseAxisParam(s,i.shape),d=a.backend_util.computeOutAndReduceShapes(i.shape,u)[1],p=a.util.sizeFromShape(d),l=[],c=n.makeTensorInfo([],"float32",new Float32Array([p]));l.push(c);var f=g({inputs:{x:i},backend:n,attrs:{dtype:"float32"}});l.push(f);var h=Et({inputs:{a:f,b:c},backend:n});l.push(h);var m=mt({inputs:{x:h},backend:n,attrs:{axis:s,keepDims:o}});return l.forEach((function(e){return n.disposeIntermediateTensorInfo(e)})),m}};var wn={kernelName:a.Min,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,o=r.axis,u=r.keepDims;s(i,"min");var d=a.util.parseAxisParam(o,i.shape),p=d,l=a.backend_util.getAxesPermutation(p,i.shape.length),c=i;null!=l&&(c=ge({inputs:{x:i},backend:n,attrs:{perm:l}}),p=a.backend_util.getInnerMostAxes(p.length,i.shape.length)),a.backend_util.assertAxesAreInnerMostDims("min",p,c.shape.length);for(var f=a.backend_util.computeOutAndReduceShapes(c.shape,p),h=f[0],m=f[1],v=a.util.sizeFromShape(m),k=a.util.makeZerosTypedArray(a.util.sizeFromShape(h),c.dtype),b=n.data.get(c.dataId).values,g=0;g<k.length;++g){for(var I=g*v,y=b[I],N=0;N<v;++N){var x=b[I+N];x<y&&(y=x)}k[g]=y}null!=l&&n.disposeIntermediateTensorInfo(c);var T=n.makeTensorInfo(h,c.dtype,k);if(u){var S=ra({inputs:{x:T},backend:n,attrs:{shape:a.backend_util.expandShapeToKeepDim(h,d)}});return n.disposeIntermediateTensorInfo(T),S}return T}};var Dn={kernelName:a.MirrorPad,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,o=r.paddings,u=r.mode;s(i,"mirrorPad");for(var d=o.map((function(e,a){return e[0]+i.shape[a]+e[1]})),p=o.map((function(e){return e[0]})),l=o.map((function(e,a){return e[0]+i.shape[a]})),c="reflect"===u?0:1,f=n.data.get(i.dataId).values,h=i.shape.length,m=a.util.computeStrides(i.shape),v=a.util.sizeFromShape(d),k=d.length,b=a.util.computeStrides(d),g=a.util.getTypedArrayFromDType(i.dtype,v),I=0;I<v;I++){for(var y=a.util.indexToLoc(I,k,b),N=0;N<k;N++)y[N]<p[N]?y[N]=2*p[N]-y[N]-c:y[N]>=l[N]&&(y[N]=2*(l[N]-1)-y[N]+c);y=y.map((function(e,a){return e-p[a]}));var x=a.util.locToIndex(y,h,m);g[I]=f[x]}return{dataId:n.write(g,d,i.dtype),shape:d,dtype:i.dtype}}},_n=l((function(e,a){var t=e%a;return e<0&&a<0||e>=0&&a>=0?t:(t+a)%a})),zn=y(a.Mod,_n),En={kernelName:a.Mod,backendName:"cpu",kernelFunc:zn};function Cn(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.logits,s=r.dim,o=i.shape.length,u=s;if(-1===u&&(u=o-1),u!==o-1)throw Error("Softmax along a non-last dimension is not yet supported. Logits was rank "+o+" and dim was "+u);var d=a.util.parseAxisParam([u],i.shape),p=yn({inputs:{x:i},backend:n,attrs:{reductionIndices:d,keepDims:!1}}),l=a.backend_util.expandShapeToKeepDim(p.shape,d),c=ra({inputs:{x:p},backend:n,attrs:{shape:l}}),f=Re({inputs:{a:i,b:c},backend:n}),h=P({inputs:{x:f},backend:n}),m=mt({inputs:{x:h},backend:n,attrs:{axis:d,keepDims:!1}}),v=ra({inputs:{x:m},backend:n,attrs:{shape:l}}),k=Et({inputs:{a:h,b:v},backend:n});return n.disposeIntermediateTensorInfo(p),n.disposeIntermediateTensorInfo(c),n.disposeIntermediateTensorInfo(f),n.disposeIntermediateTensorInfo(h),n.disposeIntermediateTensorInfo(m),n.disposeIntermediateTensorInfo(v),k}var Wn={kernelName:a.Softmax,backendName:"cpu",kernelFunc:Cn};var Hn={kernelName:a.Multinomial,backendName:"cpu",kernelFunc:function(e){var n=e.inputs,r=e.backend,i=e.attrs,o=n.logits,u=i.numSamples,d=i.seed,p=i.normalized;s(o,"multinomial");for(var l=p?o:Cn({inputs:{logits:o},backend:r,attrs:{dim:-1}}),c=l.shape[0],f=l.shape[1],h=r.data.get(l.dataId).values,m=[c,u],v=a.util.makeZerosTypedArray(a.util.sizeFromShape(m),"int32"),k=0;k<c;++k){var b=k*f,g=new Float32Array(f-1);g[0]=h[b];for(var I=1;I<g.length;++I)g[I]=g[I-1]+h[b+I];for(var y=t.alea(d.toString()),N=k*u,x=0;x<u;++x){var T=y();v[N+x]=g.length;for(var S=0;S<g.length;S++)if(T<g[S]){v[N+x]=S;break}}}return p||r.disposeIntermediateTensorInfo(l),r.makeTensorInfo(m,"int32",v)}},Pn=a.kernel_impls.nonMaxSuppressionV3Impl;var Rn={kernelName:a.NonMaxSuppressionV3,backendName:"cpu",kernelFunc:function(e){var a=e.inputs,t=e.backend,n=e.attrs,r=a.boxes,i=a.scores,o=n.maxOutputSize,u=n.iouThreshold,d=n.scoreThreshold;s(r,"NonMaxSuppression");var p=t.data.get(r.dataId).values,l=t.data.get(i.dataId).values,c=Pn(p,l,o,u,d).selectedIndices;return t.makeTensorInfo([c.length],"int32",new Int32Array(c))}},Bn=a.kernel_impls.nonMaxSuppressionV4Impl;var Vn={kernelName:a.NonMaxSuppressionV4,backendName:"cpu",kernelFunc:function(e){var a=e.inputs,t=e.backend,n=e.attrs,r=a.boxes,i=a.scores,o=n.maxOutputSize,u=n.iouThreshold,d=n.scoreThreshold,p=n.padToMaxOutputSize;s(r,"NonMaxSuppressionPadded");var l=t.data.get(r.dataId).values,c=t.data.get(i.dataId).values,f=Bn(l,c,o,u,d,p),h=f.selectedIndices,m=f.validOutputs;return[t.makeTensorInfo([h.length],"int32",new Int32Array(h)),t.makeTensorInfo([],"int32",new Int32Array([m]))]}},On=a.kernel_impls.nonMaxSuppressionV5Impl;var Ln={kernelName:a.NonMaxSuppressionV5,backendName:"cpu",kernelFunc:function(e){var a=e.inputs,t=e.backend,n=e.attrs,r=a.boxes,i=a.scores,o=n.maxOutputSize,u=n.iouThreshold,d=n.scoreThreshold,p=n.softNmsSigma;s(r,"NonMaxSuppressionWithScore");var l=t.data.get(r.dataId).values,c=t.data.get(i.dataId).values,f=On(l,c,o,u,d,p),h=f.selectedIndices,m=f.selectedScores;return[t.makeTensorInfo([h.length],"int32",new Int32Array(h)),t.makeTensorInfo([m.length],"float32",new Float32Array(m))]}};var qn={kernelName:a.OneHot,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.indices,o=r.depth,u=r.onValue,d=r.offValue;s(i,"oneHot");var p=a.util.sizeFromShape(i.shape),l=new Float32Array(p*o);l.fill(d);for(var c=n.data.get(i.dataId).values,f=0;f<p;++f)c[f]>=0&&c[f]<o&&(l[f*o+c[f]]=u);return n.makeTensorInfo(i.shape.concat([o]),"int32",l)}};function Gn(e){var a=e.inputs,t=e.backend,n=a.x;if("string"===n.dtype)throw new Error("zerosLike is not supported for string tensors");if("complex64"===n.dtype){var r=k({inputs:{input:n},backend:t}),i=Gn({inputs:{x:r},backend:t}),s=La({inputs:{input:n},backend:t}),o=Gn({inputs:{x:s},backend:t}),u=c({inputs:{real:i,imag:o},backend:t});return t.disposeIntermediateTensorInfo(r),t.disposeIntermediateTensorInfo(i),t.disposeIntermediateTensorInfo(s),t.disposeIntermediateTensorInfo(o),u}return Rt({backend:t,attrs:{shape:n.shape,value:0,dtype:n.dtype}})}var Un={kernelName:a.ZerosLike,backendName:"cpu",kernelFunc:Gn};var Zn={kernelName:a.OnesLike,backendName:"cpu",kernelFunc:function e(a){var t=a.inputs,n=a.backend,r=t.x;if("string"===r.dtype)throw new Error("onesLike is not supported for string tensors");if("complex64"===r.dtype){var i=k({inputs:{input:r},backend:n}),s=e({inputs:{x:i},backend:n}),o=La({inputs:{input:r},backend:n}),u=Gn({inputs:{x:o},backend:n}),d=c({inputs:{real:s,imag:u},backend:n});return n.disposeIntermediateTensorInfo(i),n.disposeIntermediateTensorInfo(s),n.disposeIntermediateTensorInfo(o),n.disposeIntermediateTensorInfo(u),d}return Rt({backend:n,attrs:{shape:r.shape,value:1,dtype:r.dtype}})}};function jn(e){var t=e.inputs,n=e.backend,r=e.attrs.axis;if(1===t.length)return Dt({inputs:{input:t[0]},backend:n,attrs:{dim:r}});var i=t[0].shape,s=t[0].dtype;t.forEach((function(e){a.util.assertShapesMatch(i,e.shape,"All tensors passed to stack must have matching shapes"),a.util.assert(s===e.dtype,(function(){return"All tensors passed to stack must have matching dtypes"}))}));var o=[],u=Ga({inputs:t.map((function(e){var a=Dt({inputs:{input:e},backend:n,attrs:{dim:r}});return o.push(a),a})),backend:n,attrs:{axis:r}});return o.forEach((function(e){return n.disposeIntermediateTensorInfo(e)})),u}var Kn={kernelName:a.Pack,backendName:"cpu",kernelFunc:jn};var Yn={kernelName:a.PadV2,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,o=r.paddings,u=r.constantValue;s(i,"pad");var d=o.map((function(e,a){return e[0]+i.shape[a]+e[1]})),p=o.map((function(e){return e[0]})),l=n.data.get(i.dataId).values,c=a.util.sizeFromShape(i.shape),f=i.shape.length,h=a.util.computeStrides(i.shape),m=a.util.sizeFromShape(d),v=d.length,k=a.util.computeStrides(d),b=a.util.getTypedArrayFromDType(i.dtype,m);0!==u&&b.fill(u);for(var g=0;g<c;g++){var I=a.util.indexToLoc(g,f,h).map((function(e,a){return e+p[a]}));b[a.util.locToIndex(I,v,k)]=l[g]}return{dataId:n.write(b,d,i.dtype),shape:d,dtype:i.dtype}}},$n=l((function(e,a){return Math.pow(e,a)})),Jn=y(a.Pow,$n),Qn={kernelName:a.Pow,backendName:"cpu",kernelFunc:Jn};var Xn={kernelName:a.Range,backendName:"cpu",kernelFunc:function(e){var a=e.backend,t=e.attrs,n=t.start,r=t.stop,i=t.dtype,s=xe(n,r,t.step,i);return a.makeTensorInfo([s.length],i,s)}},er=D(a.Reciprocal,(function(e){return 1/e})),ar={kernelName:a.Reciprocal,backendName:"cpu",kernelFunc:er};var tr={kernelName:a.ResizeBilinear,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.images,o=r.alignCorners,u=r.halfPixelCenters,d=r.size;s(i,"resizeBilinear");for(var p=a.util.computeStrides(i.shape),l=d[0],c=d[1],f=i.shape,h=f[0],m=f[1],v=f[2],k=f[3],b=n.data.get(i.dataId).values,g=new Float32Array(a.util.sizeFromShape([h,l,c,k])),I=[o&&l>1?m-1:m,o&&c>1?v-1:v],y=[o&&l>1?l-1:l,o&&c>1?c-1:c],N=0,x=I[0]/y[0],T=I[1]/y[1],S=0;S<h;S++)for(var F=0;F<l;F++){var M=void 0;M=u?x*(F+.5)-.5:x*F;for(var A=Math.max(0,Math.floor(M)),w=M-A,D=Math.min(m-1,Math.ceil(M)),_=S*p[0]+A*p[1],z=S*p[0]+D*p[1],E=0;E<c;E++){var C=void 0;C=u?T*(E+.5)-.5:T*E;for(var W=Math.max(0,Math.floor(C)),H=C-W,P=Math.min(v-1,Math.ceil(C)),R=_+W*p[2],B=z+W*p[2],V=_+P*p[2],O=z+P*p[2],L=0;L<k;L++){var q=b[R+L],G=b[B+L],U=q+(b[V+L]-q)*H,Z=U+(G+(b[O+L]-G)*H-U)*w;g[N++]=Z}}}return n.makeTensorInfo([h,l,c,k],"float32",g)}};var nr={kernelName:a.ResizeBilinearGrad,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.images,o=t.dy,u=r.alignCorners;s([o,i],"resizeBilinearGrad");for(var d=a.util.computeStrides(i.shape),p=i.shape,l=p[0],c=p[1],f=p[2],h=p[3],m=o.shape,v=m[1],k=m[2],b=new Float32Array(l*c*f*h),g=[u&&v>1?c-1:c,u&&k>1?f-1:f],I=[u&&v>1?v-1:v,u&&k>1?k-1:k],y=g[0]/I[0],N=g[1]/I[1],x=n.data.get(o.dataId).values,T=0,S=0;S<l;S++)for(var F=S*d[0],M=0;M<v;M++)for(var A=M*y,w=Math.floor(A),D=Math.min(Math.ceil(A),c-1),_=F+w*d[1],z=F+D*d[1],E=A-w,C=1-E,W=0;W<k;W++)for(var H=W*N,P=Math.floor(H),R=Math.min(Math.ceil(H),f-1),B=H-P,V=1-B,O=_+P*d[2],L=_+R*d[2],q=z+P*d[2],G=z+R*d[2],U=C*V,Z=C*B,j=E*V,K=E*B,Y=0;Y<h;Y++){var $=x[T++];b[O+Y]+=$*U,b[L+Y]+=$*Z,b[q+Y]+=$*j,b[G+Y]+=$*K}return n.makeTensorInfo([l,f,c,h],"float32",b)}};var rr={kernelName:a.ResizeNearestNeighbor,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.images,o=r.alignCorners,u=r.halfPixelCenters,d=r.size;s(i,"resizeNearestNeighbor");for(var p=a.util.computeStrides(i.shape),l=d[0],c=d[1],f=i.shape,h=f[0],m=f[1],v=f[2],k=f[3],b=n.data.get(i.dataId).values,g=new Float32Array(h*l*c*k),I=[o&&l>1?m-1:m,o&&c>1?v-1:v],y=[o&&l>1?l-1:l,o&&c>1?c-1:c],N=I[0]/y[0],x=I[1]/y[1],T=0,S=0;S<h;S++)for(var F=S*p[0],M=0;M<l;M++){var A=u?N*(M+.5):N*M,w=Math.min(m-1,o?Math.round(A):Math.floor(A));u&&(w=Math.max(0,w));for(var D=F+w*p[1],_=0;_<c;_++){var z=u?x*(_+.5):x*_,E=Math.min(v-1,o?Math.round(z):Math.floor(z));u&&(E=Math.max(0,E));for(var C=D+E*p[2],W=0;W<k;W++){var H=b[C+W];g[T++]=H}}}return n.makeTensorInfo([h,l,c,k],i.dtype,g)}};var ir={kernelName:a.ResizeNearestNeighborGrad,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.images,o=t.dy,u=r.alignCorners;s([o,i],"resizeNearestNeighborGrad");for(var d=a.util.computeStrides(i.shape),p=a.util.computeStrides(o.shape),l=i.shape,c=l[0],f=l[1],h=l[2],m=l[3],v=o.shape,k=v[1],b=v[2],g=new Float32Array(c*f*h*m),I=n.data.get(o.dataId).values,y=[u&&k>1?f-1:f,u&&b>1?h-1:h],N=[u&&k>1?k-1:k,u&&b>1?b-1:b],x=y[0]/N[0],T=y[1]/N[1],S=1/x,F=1/T,M=2*Math.ceil(S)+2,A=2*Math.ceil(F)+2,w=0;w<c;w++)for(var D=w*d[0],_=0;_<f;_++)for(var z=D+_*d[1],E=Math.floor(_*S),C=Math.floor(E-M/2),W=0;W<h;W++)for(var H=z+W*d[2],P=Math.floor(W*F),R=Math.floor(P-A/2),B=0;B<m;B++){for(var V=0,O=0;O<M;O++){var L=O+C;if(!(L<0||L>=k)){var q=D+L*p[1],G=L*x;if(_===Math.min(f-1,u?Math.round(G):Math.floor(G)))for(var U=0;U<A;U++){var Z=U+R;if(!(Z<0||Z>=b)){var j=q+Z*p[2],K=Z*T;W===Math.min(h-1,u?Math.round(K):Math.floor(K))&&(V+=I[j+B])}}}}g[H+B]=V}return n.makeTensorInfo(i.shape,i.dtype,g)}};var sr={kernelName:a.Reverse,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,o=r.dims;s(i,"reverse");var u=i.shape.length,d=a.util.parseAxisParam(o,i.shape);if(0===u)return m({inputs:{x:i},backend:n});for(var p=new a.TensorBuffer(i.shape,i.dtype),l=n.bufferSync(i),c=function(e){var a=p.indexToLoc(e),t=a.slice();d.forEach((function(e){return t[e]=i.shape[e]-1-t[e]})),p.set.apply(p,[l.get.apply(l,t)].concat(a))},f=0;f<p.size;f++)c(f);return n.makeTensorInfo(p.shape,p.dtype,p.values)}},or={kernelName:a.RotateWithOffset,backendName:"cpu",kernelFunc:function(e){for(var t=e.inputs,n=e.attrs,r=e.backend,i=t.image,s=n,o=s.radians,u=s.fillValue,d=s.center,p=r,l=a.util.getTypedArrayFromDType(i.dtype,a.util.sizeFromShape(i.shape)),c=i.shape,f=c[0],h=c[1],m=c[2],v=c[3],k=a.backend_util.getImageCenter(d,h,m),b=k[0],g=k[1],I=Math.sin(o),y=Math.cos(o),N=p.data.get(i.dataId).values,x=0;x<f;x++)for(var T=x*m*h*v,S=0;S<h;S++)for(var F=S*(m*v),M=0;M<m;M++)for(var A=M*v,w=0;w<v;w++){var D=[f,S,M,w],_=D[2],z=D[1],E=(_-b)*y-(z-g)*I,C=(_-b)*I+(z-g)*y;E=Math.round(E+b),C=Math.round(C+g);var W=u;if("number"!=typeof u&&(W=3===w?255:u[w]),E>=0&&E<m&&C>=0&&C<h)W=N[T+C*(m*v)+E*v+w];l[T+F+A+w]=W}return{dataId:p.write(l,i.shape,i.dtype),shape:i.shape,dtype:i.dtype}}},ur=D(a.Round,(function(e){var a=Math.floor(e);return e-a<.5?Math.floor(e):e-a>.5?Math.ceil(e):a%2==0?a:a+1})),dr={kernelName:a.Round,backendName:"cpu",kernelFunc:ur};function pr(e,t,n,r,i,s,o,u,d,p){var l=[r/i,i],c=e.values,f=t.values;if(0===r)return a.buffer(n,t.dtype);var h=a.buffer(l,t.dtype);h.values.fill(d);for(var m=0;m<s;m++){for(var v=[],k=0,b=0;b<o;b++){var g=c[m*o+b];v.push(g),k+=g*u[b]}if(k<0||k>=r/i)throw new Error("Invalid indices: "+v+" does not index into "+n);for(var I=0;I<i;I++)p?h.values[k*i+I]+=f[m*i+I]:h.values[k*i+I]=0===t.rank?f[0]:f[m*i+I]}return h}var lr={kernelName:a.ScatterNd,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.indices,s=t.updates,o=r.shape,u=a.backend_util.calculateShapes(s,i,o),d=u.sliceRank,p=u.numUpdates,l=u.sliceSize,c=u.strides,f=u.outputSize,h=pr(n.bufferSync(i),n.bufferSync(s),o,f,l,p,d,c,0,!0);return n.makeTensorInfo(o,h.dtype,h.values)}};var cr={kernelName:a.Select,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=t.condition,i=t.t,o=t.e;s([r,i,o],"select");for(var u=r.shape.length,d=n.data.get(r.dataId).values,p=n.data.get(i.dataId).values,l=n.data.get(o.dataId).values,c=a.upcastType(i.dtype,o.dtype),f=a.util.makeZerosTypedArray(a.util.sizeFromShape(i.shape),c),h=0,m=0===u||u>1||1===i.shape.length?1:a.util.sizeFromShape(i.shape.slice(1)),v=0;v<d.length;v++)for(var k=0;k<m;k++)1===d[v]?f[h++]=p[v]:f[h++]=l[v];return n.makeTensorInfo(i.shape,c,f)}},fr=a.backend_util.SELU_SCALEALPHA,hr=a.backend_util.SELU_SCALE,mr=D(a.Selu,(function(e){return e>=0?hr*e:fr*(Math.exp(e)-1)})),vr={kernelName:a.Selu,backendName:"cpu",kernelFunc:mr},kr=D(a.Sign,(function(e){return e<0?-1:e>0?1:0})),br={kernelName:a.Sign,backendName:"cpu",kernelFunc:kr},gr=D(a.Sin,(function(e){return Math.sin(e)})),Ir={kernelName:a.Sin,backendName:"cpu",kernelFunc:gr},yr=D(a.Sinh,(function(e){return Math.sinh(e)})),Nr={kernelName:a.Sinh,backendName:"cpu",kernelFunc:yr},xr=Math.log(1.1920928955078125e-7)+2,Tr=D(a.Softplus,(function(e){var a=e>-xr,t=e<xr,n=Math.exp(e);return t?n:a?e:Math.log(1+n)})),Sr={kernelName:a.Softplus,backendName:"cpu",kernelFunc:Tr};var Fr={kernelName:a.SpaceToBatchND,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,o=r.blockShape,u=r.paddings;s([i],"spaceToBatchND");var d=a.util.sizeFromShape(o),p=[[0,0]];p.push.apply(p,u);for(var l=1+o.length;l<i.shape.length;++l)p.push([0,0]);var c=Yn.kernelFunc({inputs:{x:i},backend:n,attrs:{paddings:p,constantValue:0}}),f=a.backend_util.getReshaped(c.shape,o,d,!1),h=a.backend_util.getPermuted(f.length,o.length,!1),m=a.backend_util.getReshapedPermuted(c.shape,o,d,!1),v=ra({inputs:{x:c},backend:n,attrs:{shape:f}}),k=ge({inputs:{x:v},backend:n,attrs:{perm:h}}),b=ra({inputs:{x:k},backend:n,attrs:{shape:m}});return n.disposeIntermediateTensorInfo(c),n.disposeIntermediateTensorInfo(v),n.disposeIntermediateTensorInfo(k),b}};var Mr={kernelName:a.SparseFillEmptyRows,backendName:"cpu",kernelFunc:function(e){var a=e.inputs,t=e.backend,n=a.indices,r=a.values,i=a.denseShape,s=a.defaultValue;if(1!==i.shape.length)throw new Error("Dense shape must be a vector, saw:\n        "+i.shape);if(2!==n.shape.length)throw new Error("Indices must be a matrix, saw:\n        "+n.shape);if(1!==r.shape.length)throw new Error("Values must be a vector, saw:\n        "+r.shape);if(0!==s.shape.length)throw new Error("Default value must be a scalar, saw:\n        "+s.shape);var o=t.data.get(n.dataId).values,u=t.data.get(r.dataId).values,d=t.data.get(i.dataId).values,p=t.data.get(s.dataId).values[0],l=De(o,n.shape,n.dtype,u,r.dtype,d,p),c=l[0],f=l[1],h=l[2],m=l[3],v=l[4];return[t.makeTensorInfo(f,n.dtype,c),t.makeTensorInfo([f[0]],r.dtype,h),t.makeTensorInfo([m.length],"bool",new Uint8Array(m.map((function(e){return Number(e)})))),t.makeTensorInfo([v.length],n.dtype,new Int32Array(v))]}};var Ar={kernelName:a.SparseReshape,backendName:"cpu",kernelFunc:function(e){var a=e.inputs,t=e.backend,n=a.inputIndices,r=a.inputShape,i=a.newShape;if(2!==n.shape.length)throw new Error("Input indices should be a matrix but received shape\n        "+n.shape);if(1!==r.shape.length)throw new Error("Input shape should be a vector but received shape\n        "+r.shape);if(1!==i.shape.length)throw new Error("Target shape should be a vector but received shape "+i.shape);var s=Array.from(t.data.get(r.dataId).values),o=t.data.get(n.dataId).values,u=Array.from(t.data.get(i.dataId).values),d=_e(o,n.shape,n.dtype,s,u),p=d[0],l=d[1],c=d[2];return[t.makeTensorInfo(l,n.dtype,p),t.makeTensorInfo([c.length],i.dtype,new Int32Array(c))]}};var wr={kernelName:a.SparseToDense,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.sparseIndices,s=t.sparseValues,o=t.defaultValue,u=r.outputShape,d=a.backend_util.calculateShapes(s,i,u),p=d.sliceRank,l=d.numUpdates,c=d.sliceSize,f=d.strides,h=d.outputSize,m=pr(n.bufferSync(i),n.bufferSync(s),u,h,c,l,p,f,n.data.get(o.dataId).values[0],!1);return n.makeTensorInfo(u,m.dtype,m.values)}};var Dr={kernelName:a.SplitV,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,s=r.numOrSizeSplits,o=r.axis,u=a.util.parseAxisParam(o,i.shape)[0],d=a.backend_util.prepareSplitSize(i,s,u),p=new Array(i.shape.length).fill(0),l=i.shape.slice();return d.map((function(e){var a=l.slice();a[u]=e;var t=Ae({inputs:{x:i},backend:n,attrs:{begin:p,size:a}});return p[u]+=e,t}))}},_r=D(a.Sqrt,(function(e){return Math.sqrt(e)})),zr={kernelName:a.Sqrt,backendName:"cpu",kernelFunc:_r},Er={kernelName:a.Square,backendName:"cpu",kernelFunc:function(e){var a=e.inputs,t=e.backend,n=a.x,r=t;s(n,"square");for(var i=r.data.get(n.dataId).values,o=new Float32Array(i.length),u=0;u<i.length;++u){var d=i[u];o[u]=d*d}return{dataId:r.write(o,n.shape,n.dtype),shape:n.shape,dtype:n.dtype}}},Cr=D(a.Step,(function(e,a){var t=a;return isNaN(e)?NaN:e>0?1:t.alpha})),Wr={kernelName:a.Step,backendName:"cpu",kernelFunc:Cr};var Hr={kernelName:a.StridedSlice,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,o=r.begin,u=r.end,d=r.strides,p=r.beginMask,l=r.endMask,c=r.ellipsisMask,f=r.newAxisMask,h=r.shrinkAxisMask;s(i,"stridedSlice");var m,v=a.slice_util.sliceInfo(i.shape,o,u,d,p,l,c,f,h),k=v.nonStrided,b=v.$begin,g=v.$strides,I=v.size,y=v.newShape,N=v.outShape,x=ra({inputs:{x:i},backend:n,attrs:{shape:y}});if(k){var T=Ae({inputs:{x:x},backend:n,attrs:{begin:b,size:I}});m=ra({inputs:{x:T},backend:n,attrs:{shape:N}}),n.disposeIntermediateTensorInfo(T)}else if(N.some((function(e){return 0===e})))m=n.makeTensorInfo(N,i.dtype,[]);else{var S=We(N,n.bufferSync(x),g,b);m=n.makeTensorInfo(S.shape,S.dtype,S.values)}var F=ra({inputs:{x:m},backend:n,attrs:{shape:N}});return n.disposeIntermediateTensorInfo(x),n.disposeIntermediateTensorInfo(m),F}},Pr=D(a.Tan,(function(e){return Math.tan(e)})),Rr={kernelName:a.Tan,backendName:"cpu",kernelFunc:Pr},Br=D(a.Tanh,(function(e){return Math.tanh(e)})),Vr={kernelName:a.Tanh,backendName:"cpu",kernelFunc:Br};var Or={kernelName:a.Tile,backendName:"cpu",kernelFunc:function(e){var a=e.inputs,t=e.backend,n=e.attrs,r=a.x,i=n.reps;s(r,"tile");var o=Ve(t.bufferSync(r),i);return t.makeTensorInfo(o.shape,o.dtype,o.values)}};var Lr={kernelName:a.TopK,backendName:"cpu",kernelFunc:function(e){var a=e.inputs,t=e.backend,n=e.attrs,r=a.x,i=n.k;n.sorted,s(r,"topk");var o=Oe(t.data.get(r.dataId).values,r.shape,r.dtype,i),u=o[0],d=o[1];return[t.makeTensorInfo(u.shape,u.dtype,u.values),t.makeTensorInfo(d.shape,d.dtype,d.values)]}};var qr={kernelName:a.Transform,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.attrs,r=e.backend,i=t.image,s=t.transforms,o=n.interpolation,u=n.fillMode,d=n.fillValue,p=n.outputShape,l=i.shape,c=l[0],f=l[1],h=l[2],m=l[3],v=null!=p?p:[f,h],k=v[0],b=v[1],g=[c,k,b,m],I=a.util.computeStrides(i.shape),y=I[0],N=I[1],x=I[2],T=a.util.getTypedArrayFromDType(i.dtype,a.util.sizeFromShape(g));T.fill(d);for(var S=r.data.get(i.dataId).values,F=r.data.get(s.dataId).values,M=0;M<c;++M){for(var A=1===s.shape[0]?F:F.subarray(8*M,8*M+8),w=0;w<k;++w)for(var D=0;D<b;++D)for(var _=0;_<m;++_){var z=void 0,E=A[6]*D+A[7]*w+1;if(0!==E){var C=(A[0]*D+A[1]*w+A[2])/E,W=(A[3]*D+A[4]*w+A[5])/E,H=Gr(C,h,u),P=Gr(W,f,u);switch(o){case"nearest":z=Zr(S,f,h,y,N,x,M,P,H,_,d);break;case"bilinear":z=jr(S,f,h,y,N,x,M,P,H,_,d);break;default:throw new Error("Error in Transform: Expect 'nearest' or 'bilinear', but got "+o)}T[M*y+w*N+D*x+_]=z}}return r.makeTensorInfo(g,i.dtype,T)}return{dataId:r.write(T,g,i.dtype),shape:i.shape,dtype:i.dtype}}};function Gr(e,t,n){switch(n){case"reflect":return function(e,t){var n=e;if(n<0){if(t<=1)n=0;else n<(r=2*t)&&(n=r*Math.trunc(-n/r)+n),n=n<-t?n+r:-n-1}else if(n>t-1){var r;if(t<=1)n=0;else(n-=(r=2*t)*Math.trunc(n/r))>=t&&(n=r-n-1)}return a.util.clamp(0,n,t-1)}(e,t);case"wrap":return function(e,t){var n=e;if(n<0)if(t<=1)n=0;else{var r=t-1;n+=t*(Math.trunc(-n/r)+1)}else if(n>t-1)if(t<=1)n=0;else{r=t-1;n-=t*Math.trunc(n/r)}return a.util.clamp(0,n,t-1)}(e,t);case"nearest":return function(e,t){return a.util.clamp(0,e,t-1)}(e,t);case"constant":default:return function(e,a){return e}(e)}}function Ur(e,a,t,n,r,i,s,o,u,d,p){return 0<=o&&o<a&&0<=u&&u<t?e[s*n+o*r+u*i+d]:p}function Zr(e,a,t,n,r,i,s,o,u,d,p){return Ur(e,a,t,n,r,i,s,Math.round(o),Math.round(u),d,p)}function jr(e,a,t,n,r,i,s,o,u,d,p){var l=Math.floor(o),c=Math.floor(u),f=l+1,h=c+1;return(f-o)*((h-u)*Ur(e,a,t,n,r,i,s,l,c,d,p)+(u-c)*Ur(e,a,t,n,r,i,s,l,h,d,p))+(o-l)*((h-u)*Ur(e,a,t,n,r,i,s,f,c,d,p)+(u-c)*Ur(e,a,t,n,r,i,s,f,h,d,p))}var Kr={kernelName:a.Unique,backendName:"cpu",kernelFunc:function(e){var a=e.inputs,t=e.attrs,n=e.backend,r=t.axis,i=a.x;s(i,"unique");var o=Le(n.data.get(i.dataId).values,r,i.shape,i.dtype),u=o.outputValues,d=o.outputShape,p=o.indices;return[n.makeTensorInfo(d,i.dtype,u),n.makeTensorInfo([p.length],"int32",p)]}};var Yr={kernelName:a.Unpack,backendName:"cpu",kernelFunc:function(e){var a=e.inputs,t=e.backend,n=e.attrs,r=a.value,i=n.axis;i<0&&(i+=r.shape.length);for(var s=r.shape.length,o=r.shape[i],u=new Array(s-1),d=0,p=0;p<s;p++)p!==i&&(u[d++]=r.shape[p]);var l=new Array(s).fill(0),c=r.shape.slice();c[i]=1;var f=new Array(o);for(p=0;p<f.length;p++){l[i]=p;var h=Ae({inputs:{x:r},backend:t,attrs:{begin:l,size:c}});f[p]=ra({inputs:{x:h},backend:t,attrs:{shape:u}}),t.disposeIntermediateTensorInfo(h)}return f}};for(var $r={kernelName:a.UnsortedSegmentSum,backendName:"cpu",kernelFunc:function(e){var t=e.inputs,n=e.backend,r=e.attrs,i=t.x,o=t.segmentIds,u=r.numSegments;s(i,"unsortedSegmentSum");for(var d=[],p=[],l=i.shape.length-o.shape.length,c=o,f=0;f<l;++f){var h=Dt({inputs:{input:c},backend:n,attrs:{dim:f+1}});c=h,p.push(h)}for(f=0;f<u;++f){var m=a.util.createScalarValue(f,"int32"),v=n.makeTensorInfo([],"int32",m),k=It({inputs:{a:v,b:c},backend:n}),b=g({inputs:{x:k},backend:n,attrs:{dtype:"float32"}}),I=le({inputs:{a:b,b:i},backend:n}),y=mt({inputs:{x:I},backend:n,attrs:{axis:0,keepDims:!1}});d.push(y),p.push(v),p.push(k),p.push(b),p.push(I),p.push(y)}var N=jn({inputs:d,backend:n,attrs:{axis:0}});return p.forEach((function(e){return n.disposeIntermediateTensorInfo(e)})),N}},Jr=0,Qr=[ua,p,pa,ca,F,fa,ha,ma,va,ka,ga,ya,xa,Fa,Aa,za,Ea,Ca,Wa,oa,Ha,Pa,Ra,I,C,Va,f,Oa,Ua,Ka,Ya,ja,Ja,Qa,$a,et,tt,nt,rt,it,st,ut,dt,pt,lt,ct,ht,ft,Ct,kt,Ue,bt,yt,wt,R,_t,O,Pt,Bt,Vt,G,qt,Gt,Ut,Zt,jt,K,$t,v,Jt,qa,Xt,an,nn,je,J,on,un,ae,pn,fn,mn,bn,gn,In,ie,xn,Tn,Sn,Fn,Mn,Nn,An,wn,ue,Dn,En,Hn,ce,he,Rn,Vn,Ln,ke,qn,Zn,Kn,Yn,Qn,$e,Ne,Xn,b,ar,Qe,ea,ia,tr,nr,rr,ir,sr,or,dr,Fe,lr,cr,vr,ta,br,Ir,Nr,we,Wn,Sr,Fr,Mr,Ar,wr,Dr,zr,Er,Ce,Wr,Hr,Be,vt,Rr,Vr,Or,Lr,Ie,qr,Kr,Yr,$r,Un];Jr<Qr.length;Jr++){var Xr=Qr[Jr];a.registerKernel(Xr)}e.MathBackendCPU=u,e.shared=qe,e.version_cpu="3.6.0",Object.defineProperty(e,"__esModule",{value:!0})}));
//# sourceMappingURL=tf-backend-cpu.min.js.map
