/**
 * @license
 * Copyright 2021 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports,require("@tensorflow/tfjs-core"),require("seedrandom")):"function"==typeof define&&define.amd?define(["exports","@tensorflow/tfjs-core","seedrandom"],t):t((e=e||self).tf=e.tf||{},e.tf,e.seedrandom)}(this,(function(e,t,n){"use strict";function a(e,n){Array.isArray(e)||(e=[e]),e.forEach(e=>{null!=e&&t.util.assert("complex64"!==e.dtype,()=>n+" does not support complex64 tensors in the CPU backend.")})}const s=t.kernel_impls.whereImpl;class r extends t.KernelBackend{constructor(){super(),this.blockSize=48,this.firstUse=!0,this.data=new t.DataStorage(this,t.engine())}nextDataId(){return r.nextDataId++}write(e,n,a){this.firstUse&&(this.firstUse=!1,t.env().get("IS_NODE")&&t.backend_util.warn("\n============================\nHi there 👋. Looks like you are running TensorFlow.js in Node.js. To speed things up dramatically, install our node backend, which binds to TensorFlow C++, by running npm i @tensorflow/tfjs-node, or npm i @tensorflow/tfjs-node-gpu if you have CUDA. Then call require('@tensorflow/tfjs-node'); (-gpu suffix for CUDA) at the start of your program. Visit https://github.com/tensorflow/tfjs-node for more details.\n============================"));const s={id:this.nextDataId()};return this.data.set(s,{values:e,dtype:a,refCount:1}),s}makeTensorInfo(e,n,a){let s;if("string"===n&&null!=a&&a.length>0&&t.util.isString(a[0])){const r=a.map(e=>t.util.encodeString(e));s=this.write(r,e,n)}else s=this.write(a,e,n);return{dataId:s,shape:e,dtype:n}}refCount(e){if(this.data.has(e)){return this.data.get(e).refCount}return 0}incRef(e){this.data.get(e).refCount++}decRef(e){if(this.data.has(e)){this.data.get(e).refCount--}}move(e,t,n,a,s){this.data.set(e,{values:t,dtype:a,refCount:s})}numDataIds(){return this.data.numDataIds()}async read(e){return this.readSync(e)}readSync(e){const{dtype:n,complexTensorInfos:a}=this.data.get(e);if("complex64"===n){const e=this.readSync(a.real.dataId),n=this.readSync(a.imag.dataId);return t.backend_util.mergeRealAndImagArrays(e,n)}return this.data.get(e).values}bufferSync(e){const n=this.readSync(e.dataId);let a=n;if("string"===e.dtype)try{a=n.map(e=>t.util.decodeString(e))}catch(e){throw new Error("Failed to decode encoded string bytes into utf-8")}return t.buffer(e.shape,e.dtype,a)}makeOutput(e,n,a){const s=this.write(e,n,a);return t.engine().makeTensorFromDataId(s,n,a,this)}disposeData(e,t=!1){if(this.data.has(e)){if(this.data.get(e).refCount--,!t&&this.data.get(e).refCount>0)return!1;const{complexTensorInfos:n}=this.data.get(e);null!=n&&(this.disposeData(n.real.dataId,!0),this.disposeData(n.imag.dataId,!0)),this.data.delete(e)}return!0}disposeIntermediateTensorInfo(e){this.disposeData(e.dataId)}async time(e){const n=t.util.now();e();return{kernelMs:t.util.now()-n}}memory(){return{unreliable:!0,reasons:["The reported memory is an upper bound. Due to automatic garbage collection, the true allocated memory may be less."]}}where(e){a([e],"where");const t=this.readSync(e.dataId);return s(e.shape,t)}dispose(){}floatPrecision(){return 32}epsilon(){return super.epsilon()}}function o(e){const t=new Float32Array(e.length);for(let n=0;n<e.length;++n)t[n]=Math.abs(e[n]);return t}r.nextDataId=0;const i={kernelName:t.Abs,backendName:"cpu",kernelFunc:e=>{const{x:n}=e.inputs,s=e.backend;a(n,"abs");let r=new Float32Array(t.util.sizeFromShape(n.shape));return r=o(s.data.get(n.dataId).values),s.makeOutput(r,n.shape,"float32")}};function l(e){return(n,a,s,r,o)=>{const i=t.backend_util.assertAndGetBroadcastShape(n,a),l=i.length,d=t.util.computeStrides(i),u=t.util.sizeFromShape(i),c=t.util.getTypedArrayFromDType(o,u),p=n.length,h=a.length,f=t.util.computeStrides(n),m=t.util.computeStrides(a),k=t.backend_util.getBroadcastDims(n,i),g=t.backend_util.getBroadcastDims(a,i);if(k.length+g.length===0)for(let t=0;t<c.length;++t)c[t]=e(s[t%s.length],r[t%r.length]);else for(let n=0;n<c.length;++n){const a=t.util.indexToLoc(n,l,d),o=a.slice(-p);k.forEach(e=>o[e]=0);const i=t.util.locToIndex(o,p,f),u=a.slice(-h);g.forEach(e=>u[e]=0);const b=t.util.locToIndex(u,h,m);c[n]=e(s[i],r[b])}return[c,i]}}function d(e){const{inputs:t,backend:n}=e,{real:a,imag:s}=t,r=n.data.get(a.dataId).values,o=n.data.get(s.dataId).values,i=n.makeTensorInfo(a.shape,"complex64");return n.data.get(i.dataId).complexTensorInfos={real:n.makeTensorInfo(a.shape,"float32",r),imag:n.makeTensorInfo(s.shape,"float32",o)},i}const u={kernelName:t.Complex,backendName:"cpu",kernelFunc:d};function c(e,n,a="float32"){if("complex64"===a){return d({inputs:{real:c(e,n,"float32"),imag:c(e,n,"float32")},backend:e})}const s=t.util.makeZerosTypedArray(t.util.sizeFromShape(n),a);return e.makeTensorInfo(n,a,s)}function p(e){const{inputs:t,backend:n}=e,{x:a}=t;return n.incRef(a.dataId),{dataId:a.dataId,shape:a.shape,dtype:a.dtype}}const h={kernelName:t.Identity,backendName:"cpu",kernelFunc:p};function f(e){const{inputs:t,backend:n}=e,{input:a}=t,s=n.data.get(a.dataId).complexTensorInfos.real,r=n.data.get(s.dataId).values;return n.makeTensorInfo(s.shape,s.dtype,r)}const m={kernelName:t.Real,backendName:"cpu",kernelFunc:f};function k(e){const{inputs:n,backend:a,attrs:s}=e,{x:r}=n,{dtype:o}=s;if("complex64"===o){if("complex64"===r.dtype)return p({inputs:{x:r},backend:a});const e=c(a,r.shape,r.dtype),t=k({inputs:{x:r},backend:a,attrs:{dtype:"float32"}}),n=d({inputs:{real:t,imag:e},backend:a});return a.disposeIntermediateTensorInfo(e),a.disposeIntermediateTensorInfo(t),n}if("complex64"===r.dtype){const e=f({inputs:{input:r},backend:a}),t=k({inputs:{x:e},backend:a,attrs:{dtype:o}});return a.disposeIntermediateTensorInfo(e),t}if(!t.util.hasEncodingLoss(r.dtype,o)){const e=p({inputs:{x:r},backend:a});return{dataId:e.dataId,shape:e.shape,dtype:o}}if("int32"===o){const e=a.data.get(r.dataId).values,t=Int32Array.from(e);return a.makeTensorInfo(r.shape,"int32",t)}if("bool"===o){const e=a.data.get(r.dataId).values,n=t.util.toTypedArray([0],r.dtype),[s,o]=l((e,t)=>e!==t?1:0)(r.shape,[],e,n,"bool");return a.makeTensorInfo(o,"bool",s)}throw new Error(`Error in Cast: failed to cast ${r.dtype} to ${o}`)}const g={kernelName:t.Cast,backendName:"cpu",kernelFunc:k};function b(e,n,s,r){return null==s?({inputs:s,backend:o})=>{const{a:i,b:l}=s,d=o;a([i,l],e);const u=d.data.get(i.dataId).values,c=d.data.get(l.dataId).values,p="string"===i.dtype?t.backend_util.fromUint8ToStringArray(u):u,h="string"===i.dtype?t.backend_util.fromUint8ToStringArray(c):c,f=r||i.dtype,[m,k]=n(i.shape,l.shape,p,h,f);return d.makeTensorInfo(k,f,m)}:({inputs:e,backend:t})=>{const{a:a,b:o}=e,i=t;if("complex64"===a.dtype||"complex64"===o.dtype){const e=k({inputs:{x:a},backend:i,attrs:{dtype:"complex64"}}),t=i.data.get(e.dataId),n=t.complexTensorInfos.real,r=t.complexTensorInfos.imag,l=i.data.get(n.dataId).values,u=i.data.get(r.dataId).values,c=k({inputs:{x:o},backend:i,attrs:{dtype:"complex64"}}),p=i.data.get(c.dataId),h=p.complexTensorInfos.real,f=p.complexTensorInfos.imag,m=i.data.get(h.dataId).values,g=i.data.get(f.dataId).values,[b,I,y]=s(a.shape,o.shape,l,u,m,g),N=i.makeTensorInfo(y,"float32",b),T=i.makeTensorInfo(y,"float32",I),x=d({inputs:{real:N,imag:T},backend:i});return i.disposeIntermediateTensorInfo(e),i.disposeIntermediateTensorInfo(c),i.disposeIntermediateTensorInfo(N),i.disposeIntermediateTensorInfo(T),x}{const e=i.data.get(a.dataId).values,t=i.data.get(o.dataId).values,s=r||a.dtype,[l,d]=n(a.shape,o.shape,e,t,s);return i.makeTensorInfo(d,s,l)}}}function I(e){return(n,a,s,r,o,i)=>{const l=t.backend_util.assertAndGetBroadcastShape(n,a),d=t.util.sizeFromShape(l),u=l.length,c=t.util.computeStrides(l),p=t.util.getTypedArrayFromDType("float32",d),h=t.util.getTypedArrayFromDType("float32",d),f=t.backend_util.getBroadcastDims(n,l),m=t.backend_util.getBroadcastDims(a,l),k=t.backend_util.mergeRealAndImagArrays(s,r),g=t.backend_util.mergeRealAndImagArrays(o,i),b=n.length,I=t.util.computeStrides(n),y=a.length,N=t.util.computeStrides(a);if(f.length+m.length===0)for(let t=0;t<p.length;t++){const n=t%k.length,a=t%g.length,s=e(k[2*n],k[2*n+1],g[2*a],g[2*a+1]);p[t]=s.real,h[t]=s.imag}else for(let n=0;n<p.length;n++){const a=t.util.indexToLoc(n,u,c),s=a.slice(-b);f.forEach(e=>s[e]=0);const r=t.util.locToIndex(s,b,I),o=a.slice(-y);m.forEach(e=>o[e]=0);const i=t.util.locToIndex(o,y,N),l=e(k[2*r],k[2*r+1],g[2*i],g[2*i+1]);p[n]=l.real,h[n]=l.imag}return[p,h,l]}}const y=l((e,t)=>e+t),N=I((e,t,n,a)=>({real:e+n,imag:t+a})),T=b(t.Add,y,N),x={kernelName:t.Add,backendName:"cpu",kernelFunc:T};function S(e,n,a,s,r){const o=t.util.sizeFromShape(s),i=t.util.makeZerosTypedArray(r,a);for(let t=0;t<e.length;t++){const a=e[t];if(a<0)throw new Error("Input x must be non-negative!");a>=r||(i[a]+=o>0?n[t]:1)}return i}function v(e,n,a,s=!1){const r=e.shape[0],o=e.shape[1],i=t.buffer([r,a],n.dtype);for(let t=0;t<r;t++)for(let r=0;r<o;r++){const o=e.get(t,r);if(o<0)throw new Error("Input x must be non-negative!");o>=a||(s?i.set(1,t,o):n.size>0?i.set(i.get(t,o)+n.get(t,r),t,o):i.set(i.get(t,o)+1,t,o))}return i}function F(e){return(n,a,s)=>{const r=t.util.getTypedArrayFromDType(a,n.length);for(let t=0;t<n.length;++t)r[t]=e(n[t],s);return r}}function M(e,n,s){return({inputs:r,attrs:o,backend:i})=>{const{x:l}=r;if(a(l,e),"string"===l.dtype||"string"===s)throw new Error("unaryKernelFunc does not support string input/output");const d=i,u=d.data.get(l.dataId).values,c=t.util.sizeFromShape(l.shape),p=s||l.dtype,h=t.util.getArrayFromDType(p,c);for(let e=0;e<c;++e)h[e]=n(u[e],o);return d.makeTensorInfo(l.shape,p,h)}}function A(e,t,n){return({inputs:s,attrs:r,backend:o})=>{const{x:i}=s;if(a(i,e),"string"===i.dtype||"string"===n)throw new Error("unaryKernelFunc does not support string input/output");const l=o,d=l.data.get(i.dataId).values,u=n||i.dtype,c=t(d,u,r);return l.makeTensorInfo(i.shape,u,c)}}const w=F(e=>Math.ceil(e)),D=A(t.Ceil,w),_={kernelName:t.Ceil,backendName:"cpu",kernelFunc:D};function z(e,n,a,s){const r=t.util.getArrayFromDType(a,t.util.sizeFromShape(n));if(s&&"string"!==a){let n=0;e.forEach(e=>{const a=t.util.sizeFromShape(e.shape);r.set(e.vals,n),n+=a})}else{let s=0;e.forEach(e=>{const o="string"===a?t.backend_util.fromUint8ToStringArray(e.vals):e.vals;let i=0;for(let t=0;t<e.shape[0];++t){const a=t*n[1]+s;for(let t=0;t<e.shape[1];++t)r[a+t]=o[i++]}s+=e.shape[1]})}return r}const E=l((e,t)=>e===t?1:0),W=b(t.Equal,E,null,"bool"),C={kernelName:t.Equal,backendName:"cpu",kernelFunc:W},H=F(e=>Math.exp(e)),P=A(t.Exp,H),R={kernelName:t.Exp,backendName:"cpu",kernelFunc:P},B=F(e=>Math.expm1(e)),$=A(t.Expm1,B),G={kernelName:t.Expm1,backendName:"cpu",kernelFunc:$},L=F(e=>Math.floor(e)),V=A(t.Floor,L),q={kernelName:t.Floor,backendName:"cpu",kernelFunc:V};function O(e,n,a,s,r,o,i,l,d){const u=t.buffer([s,o],a);for(let t=0;t<s;t++){const a=[];let s=0;for(let n=0;n<r;n++){const o=e[t*r+n];s+=o*i[n],a.push(o)}if(s<0||s>=d/o)throw new Error(`Invalid indices: ${a} does not index into ${l}`);for(let e=0;e<o;e++)u.values[t*o+e]=n.get(...n.indexToLoc(s*o+e))}return u}function U(e,n,a){const s=t.buffer(a,e.dtype);for(let t=0;t<s.size;++t){const a=s.indexToLoc(t).slice(),r=a[0],o=a[2],i=n.locToIndex([r,o]);a[2]=n.values[i];const l=e.locToIndex(a);s.values[t]=e.values[l]}return s}const Z=l((e,t)=>e>t?1:0),j=b(t.Greater,Z,null,"bool"),K={kernelName:t.Greater,backendName:"cpu",kernelFunc:j},Y=l((e,t)=>e>=t?1:0),J=b(t.GreaterEqual,Y,null,"bool"),Q={kernelName:t.GreaterEqual,backendName:"cpu",kernelFunc:J},X=l((e,t)=>e<t?1:0),ee=b(t.Less,X,null,"bool"),te={kernelName:t.Less,backendName:"cpu",kernelFunc:ee},ne=l((e,t)=>e<=t?1:0),ae=b(t.LessEqual,ne,null,"bool"),se={kernelName:t.LessEqual,backendName:"cpu",kernelFunc:ae};function re(e,n,a){const s=(n-e)/(a-1),r=t.util.makeZerosTypedArray(a,"float32");r[0]=e;for(let e=1;e<r.length;e++)r[e]=r[e-1]+s;return r}const oe=F(e=>Math.log(e)),ie=A(t.Log,oe),le={kernelName:t.Log,backendName:"cpu",kernelFunc:ie};function de(e,n,a,s){const r=t.util.getTypedArrayFromDType(s,t.util.sizeFromShape(a));for(let t=0;t<r.length;++t){const a=t*n;let s=e[a];for(let t=0;t<n;++t){const n=e[a+t];(Number.isNaN(n)||n>s)&&(s=n)}r[t]=s}return r}const ue=l((e,t)=>Math.max(e,t)),ce=b(t.Maximum,ue),pe={kernelName:t.Maximum,backendName:"cpu",kernelFunc:ce},he=l((e,t)=>Math.min(e,t)),fe=b(t.Minimum,he),me={kernelName:t.Minimum,backendName:"cpu",kernelFunc:fe},ke=l((e,t)=>e*t),ge=I((e,t,n,a)=>({real:e*n-t*a,imag:e*a+t*n})),be=b(t.Multiply,ke,ge),Ie={kernelName:t.Multiply,backendName:"cpu",kernelFunc:be};function ye(e,n,a){const s=t.util.createScalarValue(-1,a);return ke([],n,s,e,a)}const Ne={kernelName:t.Neg,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{x:s}=t;a(s,"neg");const r=n.data.get(s.dataId).values,[o,i]=ye(r,s.shape,s.dtype);return n.makeTensorInfo(i,s.dtype,o)}},Te=l((e,t)=>e!==t?1:0),xe=b(t.NotEqual,Te,null,"bool"),Se={kernelName:t.NotEqual,backendName:"cpu",kernelFunc:xe};function ve(e,n,a,s,r){const o=n.length,i=t.util.sizeFromShape(n),l=t.util.computeStrides(n),d=t.util.computeStrides(r),u=t.util.getTypedArrayFromDType(a,t.util.sizeFromShape(r));for(let n=0;n<i;++n){const a=t.util.indexToLoc(n,o,l),r=new Array(a.length);for(let e=0;e<r.length;e++)r[e]=a[s[e]];u[t.util.locToIndex(r,o,d)]=e[n]}return u}function Fe(e){const{inputs:t,attrs:n,backend:s}=e,{x:r}=t,{perm:o}=n;a(r,"transpose");const i=r.shape.length,l=new Array(i);for(let e=0;e<l.length;e++)l[e]=r.shape[o[e]];const d=ve(s.data.get(r.dataId).values,r.shape,r.dtype,o,l);return{dataId:s.write(d,l,r.dtype),shape:l,dtype:r.dtype}}const Me={kernelName:t.Transpose,backendName:"cpu",kernelFunc:Fe};function Ae(e,n,a,s){const[r,o]=t.backend_util.computeOutAndReduceShapes(e,s),i=t.upcastType(n,"int32"),l=t.util.makeZerosTypedArray(t.util.sizeFromShape(r),i),d=t.util.sizeFromShape(o);for(let e=0;e<l.length;++e){const t=e*d;let n=1;for(let e=0;e<d;++e)n*=a[t+e];l[e]=n}return{outVals:l,outShape:r,outDtype:i}}const we={kernelName:t.Prod,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:r}=e,{x:o}=n,{axis:i,keepDims:l}=r;a(o,"prod");const d=o.shape.length,u=t.util.parseAxisParam(i,o.shape),c=t.backend_util.getAxesPermutation(u,d);let p=u,h=o;const f=[];null!=c&&(h=Fe({inputs:{x:o},backend:s,attrs:{perm:c}}),f.push(h),p=t.backend_util.getInnerMostAxes(p.length,d));const m=s.data.get(h.dataId).values,{outVals:k,outShape:g,outDtype:b}=Ae(h.shape,h.dtype,m,p);let I=g;return l&&(I=t.backend_util.expandShapeToKeepDim(g,u)),f.forEach(e=>s.disposeIntermediateTensorInfo(e)),s.makeTensorInfo(I,b,k)}};function De(e,n,a,s){if(e===n||e<n&&a<0||n<e&&a>1)return t.util.makeZerosTypedArray(0,s);const r=Math.abs(Math.ceil((n-e)/a)),o=t.util.makeZerosTypedArray(r,s);n<e&&1===a&&(a=-1),o[0]=e;for(let e=1;e<o.length;e++)o[e]=o[e-1]+a;return o}const _e=F(e=>1/Math.sqrt(e)),ze=A(t.Rsqrt,_e),Ee={kernelName:t.Rsqrt,backendName:"cpu",kernelFunc:ze};function We(e,n,a,s,r){const o=t.slice_util.isSliceContinous(s,n,a),i=t.util.sizeFromShape(a),l=t.util.computeStrides(s);if(o){const a=t.slice_util.computeFlatOffset(n,l);return"string"===r?e.slice(a,a+i):e.subarray(a,a+i)}const d="string"===r?t.backend_util.fromUint8ToStringArray(e):e,u=t.buffer(s,r,d),c=t.buffer(a,r);for(let e=0;e<c.size;++e){const t=c.indexToLoc(e),a=t.map((e,t)=>e+n[t]);c.set(u.get(...a),...t)}return"string"===r?t.backend_util.fromStringArrayToUint8(c.values):c.values}function Ce(e){const{inputs:n,backend:s,attrs:r}=e,{x:o}=n,{begin:i,size:l}=r;a(o,"slice");const[d,u]=t.slice_util.parseSliceParams(o,i,l);t.slice_util.assertParamsValid(o,d,u);const c=We(s.data.get(o.dataId).values,d,u,o.shape,o.dtype);return s.makeTensorInfo(u,o.dtype,c)}const He={kernelName:t.Slice,backendName:"cpu",kernelFunc:Ce};function Pe(e,n,a,s,r,o,i){const l=n[0],d=o[0],u=new Array(d),c=new Array(l),p=n[1];if(0===d){if(0!==l)throw new Error("Received SparseTensor with denseShape[0] = 0 but\n         indices.shape[0] = "+l);return[t.util.getArrayFromDType(a,0),[0,p],t.util.getArrayFromDType(r,0),u,c]}let h=!0,f=0;const m=new Array(d).fill(0);for(let t=0;t<l;++t){const n=e[t*p];if(n<0)throw new Error(`indices(${t}, 0) is invalid: ${n} < 0`);if(n>=d)throw new Error(`indices(${t}, 0) is invalid: ${n} >= ${d}`);++m[n],h=h&&n>=f,f=n}let k=!0;for(let e=0;e<d;++e){const t=0===m[e];u[e]=t,k=k&&!t,m[e]=Math.max(m[e],1),e>0&&(m[e]+=m[e-1])}if(k&&h){const t=e,n=s;for(let e=0;e<l;++e)c[e]=e;return[t,[l,p],n,u,c]}{const n=m[d-1],o=t.util.getArrayFromDType(a,n*p),h=t.util.getArrayFromDType(r,n),f=new Array(d).fill(0);for(let t=0;t<l;++t){const n=e[t*p],a=f[n],r=(0===n?0:m[n-1])+a;f[n]++;for(let n=0;n<p;++n)o[r*p+n]=e[t*p+n];h[r]=s[t],c[t]=r}for(let e=0;e<d;++e){if(0===f[e]){const t=0===e?0:m[e-1];o[t*p+0]=e;for(let e=1;e<p;++e)o[t*p+e]=0;h[t]=i}}return[o,[n,p],h,u,c]}}function Re(e,n,a,s,r){const o=t.util.sizeFromShape(s),i=n[0],l=r.length,d=[];let u=1,c=-1;for(let e=0;e<l;++e){const t=r[e];if(-1===t){if(-1!==c)throw new Error(`only one output dimension may be -1, not both ${c} and ${e}`);c=e,d.push(1)}else{if(t<0)throw new Error(`size ${e} must be non-negative, not ${t}`);u*=t,d.push(t)}}if(-1!==c){if(u<=0)throw new Error("reshape cannot infer the missing input size for an empty tensor unless all specified input sizes are non-zero");const e=Math.trunc(o/u);if(u*e!==o)throw new Error(`Input to reshape is a SparseTensor with ${o}\n          dense values, but the requested shape requires a multiple of ${u}. inputShape=${s} outputShape= ${d}`);d[c]=e}const p=t.util.sizeFromShape(d);if(p!==o)throw new Error(`Input to reshape is a tensor with ${o} dense values, but the requested shape has ${p}. inputShape=${s} outputShape=${d}`);const h=s.length,f=[];if(h>0){f[h-1]=1;for(let e=h-2;e>=0;--e)f[e]=f[e+1]*s[e+1]}const m=[];if(l>0){m[l-1]=1;for(let e=l-2;e>=0;--e)m[e]=m[e+1]*d[e+1]}const k=t.util.getArrayFromDType(a,i*l);for(let t=0;t<i;++t){let n=0;for(let a=0;a<h;++a)n+=e[t*h+a]*f[a];for(let e=0;e<l;++e)k[t*l+e]=Math.trunc(n/m[e]),n%=m[e]}return[k,[i,l],d]}function Be(e,n,a,s,r,o=!1,i=0){const l=s.length;if(l!==r.length)throw new Error("segmentIds and indices should have same size.");const d=[n[0],e.length/n[0]],u=d[1],c=l>0?r[l-1]+1:0;if(c<0)throw new Error("segment ids must be >= 0");const p=n.slice();p[0]=c;const h=p.reduce((e,t)=>e*t,1),f=t.util.getArrayFromDType(a,h);if(0===l)return c>0&&f.fill(i),[f,p];if(c<=0)throw new Error("segment ids must be >= 0");let m=0,k=1,g=0,b=r[m];for(;;){let t=0;if(k<l){if(t=r[k],b===t){++k;continue}if(b>=t)throw new Error("segment ids are not increasing")}if(b<0||b>=c)throw new Error(`Segment id ${b} out of range [0, ${c}), possibly because segmentIds input is not sorted.`);b>g&&f.fill(i,g*u,b*u);for(let t=m;t<k;++t){const n=s[t];if(n<0||n>=d[0])throw new Error(`Bad: indices[${t}] == ${s[t]} out of range [0, ${d[0]})`);for(let t=0;t<u;t++)f[b*u+t]+=e[n*u+t]}if(o)for(let e=0;e<u;e++)f[b*u+e]/=k-m;if(m=k,++k,g=b+1,b=t,k>l)break}return g<c&&f.fill(i,g*u,c*u),[f,p]}const $e=l((e,t)=>{const n=e-t;return n*n}),Ge=b(t.SquaredDifference,$e),Le={kernelName:t.SquaredDifference,backendName:"cpu",kernelFunc:Ge};function Ve(e,n,a,s){const r=t.buffer(e,n.dtype);for(let e=0;e<r.size;e++){const t=r.indexToLoc(e),o=new Array(t.length);for(let e=0;e<o.length;e++)o[e]=t[e]*a[e]+s[e];r.set(n.get(...o),...t)}return r}class qe{constructor(e,n,a,s,r,o){this.separator=t.util.encodeString(e),this.nGramWidths=n,this.leftPad=t.util.encodeString(a),this.rightPad=t.util.encodeString(s),this.padWidth=r,this.preserveShort=o}getPadWidth(e){return Math.min(this.padWidth<0?e-1:this.padWidth,e-1)}getNumNGrams(e,t){const n=this.getPadWidth(t);return Math.max(0,e+2*n-t+1)}createNGrams(e,t,n,a,s,r){for(let o=0;o<s;++o){const i=this.getPadWidth(r),l=Math.max(0,i-o),d=Math.max(0,i-(s-(o+1))),u=r-(l+d),c=t+(l>0?0:o-i);let p=0;p+=l*this.leftPad.length;for(let t=0;t<u;++t)p+=e[c+t].length;p+=d*this.rightPad.length;p+=(l+d+u-1)*this.separator.length,n[a+o]=new Uint8Array(p);const h=n[a+o];let f=0;const m=e=>e.forEach(e=>h[f++]=e);for(let e=0;e<l;++e)m(this.leftPad),m(this.separator);for(let t=0;t<u-1;++t)m(e[c+t]),m(this.separator);if(u>0){m(e[c+u-1]);for(let e=0;e<d;++e)m(this.separator),m(this.rightPad)}else{for(let e=0;e<d-1;++e)m(this.rightPad),m(this.separator);m(this.rightPad)}}}compute(e,n){const a=e.length,s=n.length;if(s>0){let e=n[0];if(0!==e)throw new Error("First split value must be 0, got "+e);for(let t=1;t<s;++t){let s=n[t]>=e;if(s=s&&n[t]<=a,!s)throw new Error(`Invalid split value ${n[t]}, must be in [${e}, ${a}]`);e=n[t]}if(e!==a)throw new Error(`Last split value must be data size. Expected ${a}, got ${e}`)}const r=s-1,o=t.util.getArrayFromDType("int32",s);if(0===a||0===s){const e=new Array(a);for(let e=0;e<=r;++e)o[e]=0;return[e,o]}o[0]=0;for(let e=1;e<=r;++e){const t=n[e]-n[e-1];let a=0;this.nGramWidths.forEach(e=>{a+=this.getNumNGrams(t,e)}),this.preserveShort&&t>0&&0===a&&(a=1),o[e]=o[e-1]+a}const i=new Array(o[r]);for(let t=0;t<r;++t){const a=n[t];let s=o[t];if(this.nGramWidths.forEach(r=>{const o=n[t+1]-n[t],l=this.getNumNGrams(o,r);this.createNGrams(e,a,i,s,l,r),s+=l}),this.preserveShort&&s===o[t]){const r=n[t+1]-n[t];if(0===r)continue;const o=r+2*this.padWidth,l=1;this.createNGrams(e,a,i,s,l,o)}}return[i,o]}}function Oe(e,t,n,a,s,r,o,i){return new qe(n,a,s,r,o,i).compute(e,t)}function Ue(e,t,n){if(!e.length)return[];if(0===t.length){const t=new Array(e.length);for(let n=0;n<e.length;++n)t[n]=e.subarray(n,n+1);return t}if(1===t.length){const a=t[0],s=[];let r=e.indexOf(a);for(;-1!==r;){const t=e.subarray(0,r);n&&0===t.length||s.push(t),r=(e=e.subarray(r+1)).indexOf(a)}return n&&0===e.length||s.push(e),s}const a=[];let s=0;for(let r=0;r<e.length+1;r++)if(r===e.length||-1!==t.indexOf(e[r])){const t=e.subarray(s,r);n&&0===t.length||a.push(t),s=r+1}return a}function Ze(e,n,a){const s=e.length,r=[];let o=0,i=0;const l=new Array(s);for(let t=0;t<s;++t){const s=Ue(e[t],n,a),d=s.length;l[t]=d,o+=d,i=Math.max(i,d),r.push(...s)}const d=t.util.getArrayFromDType("int32",2*o),u=new Array(o),c=[s,i];let p=0;for(let e=0;e<s;++e)for(let t=0;t<l[e];++t)d[2*p]=e,d[2*p+1]=t,u[p]=r[p],++p;return[d,u,c]}function je(e,n){const a=t.util.getArrayFromDType("int32",e.length);for(let s=0;s<e.length;++s)a[s]=t.util.fingerPrint64(e[s]).modulo(n).getLowBitsUnsigned();return a}const Ke=l((e,t)=>e-t),Ye=I((e,t,n,a)=>({real:e-n,imag:t-a})),Je=b(t.Sub,Ke,Ye),Qe={kernelName:t.Sub,backendName:"cpu",kernelFunc:Je};function Xe(e,n){const a=new Array(e.rank);for(let t=0;t<a.length;t++)a[t]=e.shape[t]*n[t];const s=t.buffer(a,e.dtype);for(let t=0;t<s.values.length;++t){const n=s.indexToLoc(t),a=new Array(e.rank);for(let t=0;t<a.length;t++)a[t]=n[t]%e.shape[t];const r=e.locToIndex(a);s.values[t]=e.values[r]}return s}const et=(e,t)=>{const n=t.value-e.value;return 0===n?e.index-t.index:n};function tt(e,n,a=0,s=e.length-1){for(;s>a;){if(s-a>600){const t=s-a+1,r=n-a+1,o=Math.log(t),i=.5*Math.exp(2*o/3),l=.5*Math.sqrt(o*i*(t-i)/t)*Math.sign(r-t/2);tt(e,n,Math.max(a,Math.floor(n-r*i/t+l)),Math.min(s,Math.floor(n+(t-r)*i/t+l)))}const r=e[n];let o=a,i=s;for(t.util.swap(e,a,n),et(e[s],r)>0&&t.util.swap(e,a,s);o<i;){for(t.util.swap(e,o,i),o++,i--;et(e[o],r)<0;)o+=1;for(;et(e[i],r)>0;)i-=1}0===et(e[a],r)?t.util.swap(e,a,i):(i+=1,t.util.swap(e,i,s)),i<=n&&(a=i+1),n<=i&&(s=i-1)}}function nt(e,n,a,s,r){const o=n[n.length-1],[i,l]=[e.length/o,o],d=t.util.getTypedArrayFromDType(a,i*s),u=t.util.getTypedArrayFromDType("int32",i*s);for(let t=0;t<i;t++){const n=t*l,a=e.subarray(n,n+l);let o=new Array(a.length);a.forEach((e,t)=>o[t]={value:e,index:t}),s<o.length&&(tt(o,s),o=o.slice(0,s)),r&&o.sort(et);const i=t*s,c=d.subarray(i,i+s),p=u.subarray(i,i+s);for(let e=0;e<s;e++)c[e]=o[e].value,p[e]=o[e].index}const c=n.slice();return c[c.length-1]=s,[t.buffer(c,a,d),t.buffer(c,"int32",u)]}function at(e,n,a,s){const r=t.util.parseAxisParam(n,a)[0],o=[1,a[0],1];for(let e=0;e<r;e++)o[0]*=a[e];o[1]=a[r];for(let e=r+1;e<a.length;e++)o[2]*=a[e];const i={},l=new Int32Array(a[r]),d=new t.TensorBuffer(o,s,e),u=[],c=1===o[0]&&1===o[2];for(let t=0;t<a[r];t++){let n;if(c)n=e[t].toString();else{const e=[];for(let n=0;n<o[0];n++)for(let a=0;a<o[2];a++)e.push(d.get(n,t,a));n=e.join(",")}if(void 0!==i[n])l[t]=i[n];else{const e=Object.keys(i).length;i[n]=e,l[t]=e,u.push(t)}}const p=o.slice();p[1]=Object.keys(i).length;const h=new t.TensorBuffer(p,s);u.forEach((e,t)=>{for(let n=0;n<o[0];n++)for(let a=0;a<o[2];a++)h.set(d.get(n,e,a),n,t,a)});const f=a.slice();return f[r]=p[1],{outputValues:h.values,outputShape:f,indices:l}}var st=Object.freeze({__proto__:null,simpleAbsImpl:o,addImpl:y,bincountImpl:S,bincountReduceImpl:v,ceilImpl:w,concatImpl:z,equalImpl:E,expImpl:H,expm1Impl:B,floorImpl:L,gatherNdImpl:O,gatherV2Impl:U,greaterImpl:Z,greaterEqualImpl:Y,lessImpl:X,lessEqualImpl:ne,linSpaceImpl:re,logImpl:oe,maxImpl:de,maximumImpl:ue,minimumImpl:he,multiplyImpl:ke,negImpl:ye,notEqualImpl:Te,prodImpl:Ae,rangeImpl:De,rsqrtImpl:_e,sliceImpl:We,sparseFillEmptyRowsImpl:Pe,sparseReshapeImpl:Re,sparseSegmentReductionImpl:Be,squaredDifferenceImpl:$e,stridedSliceImpl:Ve,stringNGramsImpl:Oe,stringSplitImpl:Ze,stringToHashBucketFastImpl:je,subImpl:Ke,tileImpl:Xe,topKImpl:nt,transposeImpl:ve,uniqueImpl:at});t.registerBackend("cpu",()=>new r,1);const rt=M(t.Elu,e=>e>=0?e:Math.exp(e)-1),ot={kernelName:t.Elu,backendName:"cpu",kernelFunc:rt};function it(e){const{inputs:n,backend:s,attrs:r}=e,{x:o}=n,{alpha:i}=r;a([o],"leakyRelu");const l=t.util.sizeFromShape(o.shape),d=s.data.get(o.dataId).values,u=t.util.getTypedArrayFromDType("float32",l);for(let e=0;e<d.length;e++)u[e]=d[e]<0?i*d[e]:d[e];return s.makeTensorInfo(o.shape,"float32",u)}const lt={kernelName:t.LeakyRelu,backendName:"cpu",kernelFunc:it},dt=l((e,t)=>e<0?t*e:e);function ut(e){const{inputs:t,backend:n}=e,{x:s,alpha:r}=t;a([s,r],"prelu");const o=n.data.get(s.dataId).values,i=n.data.get(r.dataId).values,[l,d]=dt(s.shape,r.shape,o,i,s.dtype);return n.makeTensorInfo(d,s.dtype,l)}const ct={kernelName:t.Prelu,backendName:"cpu",kernelFunc:ut},pt=M(t.Relu,e=>Math.max(0,e)),ht={kernelName:t.Relu,backendName:"cpu",kernelFunc:pt},ft=M(t.Relu6,e=>Math.min(Math.max(0,e),6)),mt={kernelName:t.Relu6,backendName:"cpu",kernelFunc:ft},kt=M(t.Sigmoid,e=>1/(1+Math.exp(-e))),gt={kernelName:t.Sigmoid,backendName:"cpu",kernelFunc:kt};function bt(e,t,n,a,s){if("linear"===n)return p({inputs:{x:t},backend:e});if("relu"===n)return pt({inputs:{x:t},backend:e});if("elu"===n)return rt({inputs:{x:t},backend:e});if("relu6"===n)return ft({inputs:{x:t},backend:e});if("prelu"===n)return ut({inputs:{x:t,alpha:a},backend:e});if("leakyrelu"===n)return it({inputs:{x:t},backend:e,attrs:{alpha:s}});if("sigmoid"===n)return kt({inputs:{x:t},backend:e});throw new Error(`Activation ${n} has not been implemented for the CPU backend.`)}function It(e){const{inputs:n,backend:a,attrs:s}=e,{x:r}=n,{shape:o}=s,i=t.util.sizeFromShape(r.shape),l=t.util.inferFromImplicitShape(o,i),d=t.util.sizeFromShape(l);t.util.assert(i===d,()=>`The new shape (${l}) has ${d} elements and the old shape (${r.shape}) has ${i} elements. The new shape and old shape must have the same number of elements.`),a.incRef(r.dataId);const u=a.data.get(r.dataId);if(null!=u.complexTensorInfos){const e=u.complexTensorInfos.real,t=u.complexTensorInfos.imag;e.shape=l,t.shape=l}return{dataId:r.dataId,shape:l,dtype:r.dtype}}const yt={kernelName:t.Reshape,backendName:"cpu",kernelFunc:It};function Nt(e){const{inputs:n,backend:s,attrs:r}=e,{a:o,b:i}=n,{transposeA:l,transposeB:d}=r;a([o,i],"matMul");const u=o.shape.length,c=i.shape.length,p=l?o.shape[u-2]:o.shape[u-1],h=d?i.shape[c-1]:i.shape[c-2],f=l?o.shape[u-1]:o.shape[u-2],m=d?i.shape[c-2]:i.shape[c-1],k=o.shape.slice(0,-2),g=i.shape.slice(0,-2),b=t.util.sizeFromShape(k),I=t.util.sizeFromShape(g),y=b===I||1===b||1===I;t.util.assert(u>=2&&c>=2&&y,()=>`Error in matMul: the input batch dimensions must either be the same or at least one input batch dimension must be 1. Got input batch dimensions of (${k}) and (${g}).`);const N=(b>I?o.shape.slice(0,-2):i.shape.slice(0,-2)).concat([f,m]);t.util.assert(p===h,()=>`Error in matMul: inner shapes (${p}) and (${h}) of Tensors with shapes ${o.shape} and ${i.shape} and transposeA=${l} and transposeB=${d} must match.`);const T=d?[I,m,h]:[I,h,m],x=It({inputs:{x:o},backend:s,attrs:{shape:l?[b,p,f]:[b,f,p]}}),S=It({inputs:{x:i},backend:s,attrs:{shape:T}}),v=l?x.shape[1]:x.shape[2],F=l?x.shape[2]:x.shape[1],M=d?S.shape[1]:S.shape[2],A=Math.max(b,I),w=s.data.get(x.dataId).values,D=s.data.get(S.dataId).values,_=t.util.computeStrides(x.shape),z=t.util.computeStrides(S.shape),[E,W,C]=l?[_[0],1,_[1]]:[_[0],_[1],1],[H,P,R]=d?[1,z[1],z[0]]:[z[1],1,z[0]],B=F*M,$=t.buffer([A,F,M],x.dtype),G=$.values,L=s.blockSize;for(let e=0;e<A;e++)for(let t=0;t<F;t+=L)for(let n=0;n<M;n+=L)for(let a=0;a<v;a+=L){const s=Math.min(t+L,F),r=Math.min(n+L,M),o=Math.min(a+L,v);for(let i=t;i<s;i++)for(let t=n;t<r;t++){let n=0;for(let s=a;s<o;s++){const a=Math.min(e,b-1)*E,r=Math.min(e,I-1)*R;n+=w[a+i*W+s*C]*D[s*H+t*P+r]}G[e*B+(i*M+t)]+=n}}return s.disposeIntermediateTensorInfo(x),s.disposeIntermediateTensorInfo(S),s.makeTensorInfo(N,$.dtype,$.values)}const Tt={kernelName:t.BatchMatMul,backendName:"cpu",kernelFunc:Nt};const xt={kernelName:t._FusedMatMul,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{a:s,b:r,bias:o,preluActivationWeights:i}=t,{transposeA:l,transposeB:d,activation:u,leakyreluAlpha:c}=a;let p,h,f;const m=[];p=Nt({inputs:{a:s,b:r},attrs:{transposeA:l,transposeB:d},backend:n}),o&&(h=T({inputs:{a:p,b:o},backend:n}),m.push(p),p=h),u&&(f=bt(n,p,u,i,c),m.push(p),p=f);for(const e of m)n.disposeIntermediateTensorInfo(e);return p}},St=M(t.Acos,e=>Math.acos(e)),vt={kernelName:t.Acos,backendName:"cpu",kernelFunc:St},Ft=M(t.Acosh,e=>Math.acosh(e)),Mt={kernelName:t.Acosh,backendName:"cpu",kernelFunc:Ft};const At={kernelName:t.AddN,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s}=e,r=n;a(n,"addN");const o=r.map(e=>s.data.get(e.dataId).values),i=t.buffer(r[0].shape,r[0].dtype),l=i.values;for(let e=0;e<r.length;e++){const t=o[e];for(let e=0;e<l.length;e++)l[e]+=t[e]}return s.makeTensorInfo(i.shape,i.dtype,i.values)}};const wt={kernelName:t.All,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:r}=e,{x:o}=n,{axis:i,keepDims:l}=r;a(o,"all");const d=t.util.parseAxisParam(i,o.shape);let u=d;const c=t.backend_util.getAxesPermutation(u,o.shape.length);let p=o;null!=c&&(p=Fe({inputs:{x:o},backend:s,attrs:{perm:c}}),u=t.backend_util.getInnerMostAxes(u.length,o.shape.length)),t.backend_util.assertAxesAreInnerMostDims("all",u,p.shape.length);const[h,f]=t.backend_util.computeOutAndReduceShapes(p.shape,u),m=t.util.sizeFromShape(f),k=t.util.makeZerosTypedArray(t.util.sizeFromShape(h),p.dtype),g=s.data.get(p.dataId).values;for(let e=0;e<k.length;++e){const t=e*m;let n=g[t];for(let e=0;e<m;++e){const a=g[t+e];n=n&&a}k[e]=n}null!=c&&s.disposeIntermediateTensorInfo(p);const b=s.makeTensorInfo(h,p.dtype,k);if(l){const e=It({inputs:{x:b},backend:s,attrs:{shape:t.backend_util.expandShapeToKeepDim(h,d)}});return s.disposeIntermediateTensorInfo(b),e}return b}};const Dt={kernelName:t.Any,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:r}=e,{x:o}=n,{axis:i,keepDims:l}=r;a(o,"any");const d=t.util.parseAxisParam(i,o.shape);let u=d;const c=t.backend_util.getAxesPermutation(u,o.shape.length);let p=o;null!=c&&(p=Fe({inputs:{x:o},backend:s,attrs:{perm:c}}),u=t.backend_util.getInnerMostAxes(u.length,o.shape.length)),t.backend_util.assertAxesAreInnerMostDims("any",u,p.shape.length);const[h,f]=t.backend_util.computeOutAndReduceShapes(p.shape,u),m=t.util.sizeFromShape(f),k=t.util.makeZerosTypedArray(t.util.sizeFromShape(h),p.dtype),g=s.data.get(p.dataId).values;for(let e=0;e<k.length;++e){const t=e*m;let n=g[t];for(let e=0;e<m;++e){const a=g[t+e];n=n||a}k[e]=n}null!=c&&s.disposeIntermediateTensorInfo(p);const b=s.makeTensorInfo(h,p.dtype,k);if(l){const e=It({inputs:{x:b},backend:s,attrs:{shape:t.backend_util.expandShapeToKeepDim(h,d)}});return s.disposeIntermediateTensorInfo(b),e}return b}};const _t={kernelName:t.ArgMax,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:r}=e,{x:o}=n,{axis:i}=r;a(o,"argMax");let l=t.util.parseAxisParam(i,o.shape);const d=t.backend_util.getAxesPermutation(l,o.shape.length);let u=o;const c=[];null!=d&&(u=Fe({inputs:{x:o},backend:s,attrs:{perm:d}}),c.push(u),l=t.backend_util.getInnerMostAxes(l.length,u.shape.length)),l=[l[0]],t.backend_util.assertAxesAreInnerMostDims("argMax",l,u.shape.length);const[p,h]=t.backend_util.computeOutAndReduceShapes(u.shape,l),f=t.util.sizeFromShape(p),m=t.util.makeZerosTypedArray(f,"int32"),k=t.util.sizeFromShape(h),g=s.data.get(u.dataId).values;for(let e=0;e<m.length;++e){const t=e*k;let n=g[t],a=0;for(let e=0;e<k;++e){const s=g[t+e];s>n&&(n=s,a=e)}m[e]=a}return c.forEach(e=>s.disposeIntermediateTensorInfo(e)),s.makeTensorInfo(p,"int32",m)}};const zt={kernelName:t.ArgMin,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:r}=e,{x:o}=n,{axis:i}=r;a(o,"argMin");let l=t.util.parseAxisParam(i,o.shape);const d=t.backend_util.getAxesPermutation(l,o.shape.length);let u=o;const c=[];null!=d&&(u=Fe({inputs:{x:o},backend:s,attrs:{perm:d}}),c.push(u),l=t.backend_util.getInnerMostAxes(l.length,u.shape.length)),l=[l[0]],t.backend_util.assertAxesAreInnerMostDims("argMin",l,u.shape.length);const[p,h]=t.backend_util.computeOutAndReduceShapes(u.shape,l),f=t.util.sizeFromShape(p),m=t.util.makeZerosTypedArray(f,"int32"),k=t.util.sizeFromShape(h),g=s.data.get(u.dataId).values;for(let e=0;e<m.length;++e){const t=e*k;let n=g[t],a=0;for(let e=0;e<k;++e){const s=g[t+e];s<n&&(n=s,a=e)}m[e]=a}return c.forEach(e=>s.disposeIntermediateTensorInfo(e)),s.makeTensorInfo(p,"int32",m)}},Et=M(t.Asin,e=>Math.asin(e)),Wt={kernelName:t.Asin,backendName:"cpu",kernelFunc:Et},Ct=M(t.Asinh,e=>Math.asinh(e)),Ht={kernelName:t.Asinh,backendName:"cpu",kernelFunc:Ct},Pt=M(t.Atan,e=>Math.atan(e)),Rt={kernelName:t.Atan,backendName:"cpu",kernelFunc:Pt},Bt=l((e,t)=>Math.atan2(e,t)),$t=b(t.Atan2,Bt),Gt={kernelName:t.Atan2,backendName:"cpu",kernelFunc:$t},Lt=M(t.Atanh,e=>Math.atanh(e)),Vt={kernelName:t.Atanh,backendName:"cpu",kernelFunc:Lt};function qt(e,n,a,s,r,o){const i=r.strideHeight,l=r.strideWidth,d=r.dilationHeight,u=r.dilationWidth,c=r.effectiveFilterHeight,p=r.effectiveFilterWidth,h=r.padInfo.top,f=r.padInfo.left,m="max"===o?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY,k=t.buffer(r.outShape,a),g=k.values,b=r.outShape[1]*r.outShape[2]*r.outShape[3],I=r.outShape[2]*r.outShape[3],y=r.outShape[3];for(let t=0;t<r.batchSize;++t){const n=t*b,a=t*s[0];for(let t=0;t<r.inChannels;++t)for(let k=0;k<r.outHeight;++k){const b=k*i-h,N=Math.max(0,b),T=Math.min(r.inHeight,c+b),x=n+k*I;for(let n=0;n<r.outWidth;++n){const i=n*l-f,c=Math.max(0,i),h=Math.min(r.inWidth,p+i);let k=m,b=0,I=0;for(let n=N;n<T;n+=d){const r=a+n*s[1];for(let n=c;n<h;n+=u){const a=e[r+n*s[2]+t];"max"===o&&a>k?k=a:"avg"===o&&(b+=a,I++)}if(isNaN(k))break}g[x+n*y+t]="avg"===o?b/I:k}}}return k}function Ot(e,n,a,s,r=!1,o=!1){const i=t.buffer(s.outShape,"int32"),l=s.strideHeight,d=s.strideWidth,u=s.dilationHeight,c=s.dilationWidth,p=s.effectiveFilterHeight,h=s.effectiveFilterWidth,f=s.padInfo.top,m=s.padInfo.left,k=t.buffer(n,a,e);for(let e=0;e<s.batchSize;++e)for(let t=0;t<s.inChannels;++t)for(let n=0;n<s.outHeight;++n){const a=n*l-f;let g=a;for(;g<0;)g+=u;const b=Math.min(s.inHeight,p+a);for(let l=0;l<s.outWidth;++l){const p=l*d-m;let f=p;for(;f<0;)f+=c;const I=Math.min(s.inWidth,h+p);let y=Number.NEGATIVE_INFINITY,N=-1;for(let n=g;n<b;n+=u){const i=n-a;for(let a=f;a<I;a+=c){const l=a-p,d=k.get(e,n,a,t);d>y&&(y=d,N=r?o?((e*s.inHeight+n)*s.inWidth+a)*s.inChannels+t:(n*s.inWidth+a)*s.inChannels+t:i*h+l)}}i.set(N,e,n,l,t)}}return i}function Ut(e,n,a,s,r,o){const i=r.strideDepth,l=r.strideHeight,d=r.strideWidth,u=r.dilationDepth,c=r.dilationHeight,p=r.dilationWidth,h=r.effectiveFilterDepth,f=r.effectiveFilterHeight,m=r.effectiveFilterWidth,k=r.padInfo.front,g=r.padInfo.top,b=r.padInfo.left,I="max"===o?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY,y=t.buffer(r.outShape,a),N=y.values,T=r.outShape[1]*r.outShape[2]*r.outShape[3]*r.outShape[4],x=r.outShape[2]*r.outShape[3]*r.outShape[4],S=r.outShape[3]*r.outShape[4],v=r.outShape[4];for(let t=0;t<r.batchSize;++t){const n=t*T,a=t*s[0];for(let t=0;t<r.inChannels;++t)for(let y=0;y<r.outDepth;++y){const T=y*i-k;let F=T;for(;F<0;)F+=u;const M=Math.min(r.inDepth,h+T),A=n+y*x;for(let n=0;n<r.outHeight;++n){const i=n*l-g;let h=i;for(;h<0;)h+=c;const k=Math.min(r.inHeight,f+i),y=A+n*S;for(let n=0;n<r.outWidth;++n){const i=n*d-b;let l=i;for(;l<0;)l+=p;const f=Math.min(r.inWidth,m+i),g=y+n*v;let T=I,x=0,S=0;for(let n=F;n<M;n+=u){const r=a+n*s[1];for(let n=h;n<k;n+=c){const a=r+n*s[2];for(let n=l;n<f;n+=p){const r=e[a+n*s[3]+t];if("max"===o&&r>T?T=r:"avg"===o&&(x+=r,S++),isNaN(T))break}if(isNaN(T))break}if(isNaN(T))break}N[g+t]="avg"===o?x/S:T}}}}return y}const Zt={kernelName:t.AvgPool,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:r}=e,{x:o}=n;a(o,"avgPool");const{filterSize:i,strides:l,pad:d,dimRoundingMode:u}=r;t.util.assert(t.backend_util.eitherStridesOrDilationsAreOne(l,1),()=>`Error in avgPool: Either strides or dilations must be 1. Got strides ${l} and dilations '1'`);const c=t.backend_util.computePool2DInfo(o.shape,i,l,1,d,u);let h;if(1===c.filterWidth&&1===c.filterHeight&&t.util.arraysEqual(c.inShape,c.outShape))h=p({inputs:{x:o},backend:s});else{const e=s.data.get(o.dataId).values,n=t.util.computeStrides(o.shape),a=qt(e,o.shape,o.dtype,n,c,"avg");h=s.makeTensorInfo(c.outShape,o.dtype,a.values)}return h}};const jt={kernelName:t.AvgPool3D,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:r}=e,{x:o}=n,{filterSize:i,strides:l,pad:d,dimRoundingMode:u,dataFormat:c}=r;a(o,"avgPool3d");const p=t.backend_util.computePool3DInfo(o.shape,i,l,1,d,u,c),h=Ut(s.data.get(o.dataId).values,o.shape,o.dtype,t.util.computeStrides(o.shape),p,"avg");return s.makeTensorInfo(h.shape,"float32",h.values)}};const Kt={kernelName:t.AvgPool3DGrad,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:r}=e,{dy:o,input:i}=n,{filterSize:l,strides:d,pad:u,dimRoundingMode:c}=r;a([o,i],"avgPool3DGrad");const p=t.backend_util.computePool3DInfo(i.shape,l,d,1,u,c),h=p.strideDepth,f=p.strideHeight,m=p.strideWidth,k=p.filterDepth,g=p.filterHeight,b=p.filterWidth,I=p.dilationDepth,y=p.dilationHeight,N=p.dilationWidth,T=p.effectiveFilterDepth,x=p.effectiveFilterHeight,S=p.effectiveFilterWidth,v=T-1-p.padInfo.front,F=S-1-p.padInfo.left,M=x-1-p.padInfo.top,A=t.buffer(i.shape,"float32"),w=1/(k*g*b),D=s.bufferSync(o);for(let e=0;e<p.batchSize;++e)for(let t=0;t<p.inChannels;++t)for(let n=0;n<p.inDepth;++n)for(let a=0;a<p.inHeight;++a)for(let s=0;s<p.inWidth;++s){const r=n-v,o=a-M,i=s-F;let l=0;for(let n=0;n<T;n+=I){const a=(r+n)/h;if(!(a<0||a>=p.outDepth||Math.floor(a)!==a))for(let n=0;n<x;n+=y){const s=(o+n)/f;if(!(s<0||s>=p.outHeight||Math.floor(s)!==s))for(let n=0;n<S;n+=N){const r=(i+n)/m;if(r<0||r>=p.outWidth||Math.floor(r)!==r)continue;l+=D.get(e,a,s,r,t)}}}A.set(l*w,e,n,a,s,t)}return s.makeTensorInfo(A.shape,A.dtype,A.values)}};const Yt={kernelName:t.AvgPoolGrad,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:r}=e,{dy:o,input:i}=n,l=i;a([o,i],"avgPoolGrad");const{filterSize:d,strides:u,pad:c}=r,p=t.backend_util.computePool2DInfo(l.shape,d,u,1,c),h=p.strideHeight,f=p.strideWidth,m=p.filterHeight,k=p.filterWidth,g=p.dilationHeight,b=p.dilationWidth,I=p.effectiveFilterHeight,y=p.effectiveFilterWidth,N=y-1-p.padInfo.left,T=I-1-p.padInfo.top,x=t.buffer(l.shape,"float32"),S=1/(m*k),v=s.data.get(o.dataId).values,F=t.buffer(o.shape,"float32",v);for(let e=0;e<p.batchSize;++e)for(let t=0;t<p.inChannels;++t)for(let n=0;n<p.inHeight;++n)for(let a=0;a<p.inWidth;++a){const s=n-T,r=a-N;let o=0;for(let n=0;n<I;n+=g){const a=(s+n)/h;if(!(a<0||a>=p.outHeight||Math.floor(a)!==a))for(let n=0;n<y;n+=b){const s=(r+n)/f;if(s<0||s>=p.outWidth||Math.floor(s)!==s)continue;o+=F.get(e,a,s,t)}}x.set(o*S,e,n,a,t)}return s.makeTensorInfo(x.shape,x.dtype,x.values)}};const Jt={kernelName:t.FusedBatchNorm,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:r}=e,{x:o,scale:i,offset:l,mean:d,variance:u}=n;t.util.assert(d.shape.length===u.shape.length,()=>"Batch normalization gradient requires mean and variance to have equal ranks."),t.util.assert(null==l||d.shape.length===l.shape.length,()=>"Batch normalization gradient requires mean and offset to have equal ranks."),t.util.assert(null==i||d.shape.length===i.shape.length,()=>"Batch normalization gradient requires mean and scale to have equal ranks."),a([o,d,u,i,l],"batchNorm");let{varianceEpsilon:c}=r;null==c&&(c=.001);const p=s.data.get(o.dataId).values,h=s.data.get(d.dataId).values,f=s.data.get(u.dataId).values,m=i?s.data.get(i.dataId).values:new Float32Array([1]),k=l?s.data.get(l.dataId).values:new Float32Array([0]),g=new Float32Array(p.length),b=k.length,I=m.length,y=f.length,N=h.length;let T=0,x=0,S=0,v=0;for(let e=0;e<p.length;++e)g[e]=k[T++]+(p[e]-h[x++])*m[S++]/Math.sqrt(f[v++]+c),T>=b&&(T=0),x>=N&&(x=0),S>=I&&(S=0),v>=y&&(v=0);return s.makeTensorInfo(o.shape,o.dtype,g)}};const Qt={kernelName:t.BatchToSpaceND,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:r}=e,{x:o}=n,{blockShape:i,crops:l}=r;a([o],"batchToSpaceND");const d=i.reduce((e,t)=>e*t),u=t.backend_util.getReshaped(o.shape,i,d),c=t.backend_util.getPermuted(u.length,i.length),p=t.backend_util.getReshapedPermuted(o.shape,i,d),h=t.backend_util.getSliceBeginCoords(l,i.length),f=t.backend_util.getSliceSize(p,l,i.length),m=It({inputs:{x:o},backend:s,attrs:{shape:u}}),k=Fe({inputs:{x:m},backend:s,attrs:{perm:c}}),g=It({inputs:{x:k},backend:s,attrs:{shape:p}}),b=Ce({inputs:{x:g},backend:s,attrs:{begin:h,size:f}});return s.disposeIntermediateTensorInfo(m),s.disposeIntermediateTensorInfo(k),s.disposeIntermediateTensorInfo(g),b}};const Xt={kernelName:t.Bincount,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{x:s,weights:r}=t,{size:o}=a,i=S(n.data.get(s.dataId).values,n.data.get(r.dataId).values,r.dtype,r.shape,o);return n.makeTensorInfo([o],r.dtype,i)}},en=M(t.ClipByValue,(e,t)=>{const n=t;return e>n.clipValueMax?n.clipValueMax:e<n.clipValueMin?n.clipValueMin:e}),tn={kernelName:t.ClipByValue,backendName:"cpu",kernelFunc:en},nn={kernelName:t.ComplexAbs,backendName:"cpu",kernelFunc:e=>{const{x:n}=e.inputs,a=e.backend,s=new Float32Array(t.util.sizeFromShape(n.shape)),r=a.data.get(n.dataId),o=r.complexTensorInfos.real,i=r.complexTensorInfos.imag,l=a.data.get(o.dataId).values,d=a.data.get(i.dataId).values;for(let e=0;e<l.length;e++){const t=l[e],n=d[e];s[e]=Math.hypot(t,n)}return a.makeOutput(s,n.shape,"float32")}};function an(e){const{inputs:t,backend:n}=e,{input:a}=t,s=n.data.get(a.dataId).complexTensorInfos.imag,r=n.data.get(s.dataId).values;return n.makeTensorInfo(s.shape,s.dtype,r)}const sn={kernelName:t.Imag,backendName:"cpu",kernelFunc:an};function rn(e){const{inputs:n,backend:a,attrs:s}=e,{axis:r}=s,o=t.util.parseAxisParam(r,n[0].shape)[0];let i=t.backend_util.computeOutShape(n.map(e=>e.shape),o);if(0===t.util.sizeFromShape(i))return a.makeTensorInfo(i,n[0].dtype,[]);const l=n.filter(e=>t.util.sizeFromShape(e.shape)>0);if(1===l.length)return p({inputs:{x:l[0]},backend:a});const u=l.map(e=>e.shape);if(t.backend_util.assertParamsConsistent(u,o),"complex64"===l[0].dtype){const e=l.map(e=>f({inputs:{input:e},backend:a})),t=l.map(e=>an({inputs:{input:e},backend:a})),n=rn({inputs:e,backend:a,attrs:{axis:o}}),s=rn({inputs:t,backend:a,attrs:{axis:o}}),r=d({inputs:{real:n,imag:s},backend:a});return e.forEach(e=>a.disposeIntermediateTensorInfo(e)),t.forEach(e=>a.disposeIntermediateTensorInfo(e)),a.disposeIntermediateTensorInfo(n),a.disposeIntermediateTensorInfo(s),r}const c=l.map(e=>{const n=t.util.sizeFromShape(e.shape.slice(o));return It({inputs:{x:e},backend:a,attrs:{shape:[-1,n]}})}),h=c.map(e=>({vals:a.data.get(e.dataId).values,shape:e.shape}));i=t.backend_util.computeOutShape(c.map(e=>e.shape),1);const m=1===c[0].shape[0],k=z(h,i,n[0].dtype,m),g=t.backend_util.computeOutShape(l.map(e=>e.shape),o),b=a.makeTensorInfo(g,n[0].dtype,k);return c.forEach(e=>a.disposeIntermediateTensorInfo(e)),b}const on={kernelName:t.Concat,backendName:"cpu",kernelFunc:rn};function ln(e){const{inputs:n,backend:s,attrs:r}=e,{x:o,filter:i}=n,{strides:l,pad:d,dataFormat:u,dilations:c,dimRoundingMode:p}=r;a([o,i],"conv2d");const h=t.backend_util.convertConv2DDataFormat(u),f=t.backend_util.computeConv2DInfo(o.shape,i.shape,l,c,d,p,!1,h),m=f.filterHeight,k=f.filterWidth,g=f.dilationHeight,b=f.dilationWidth,I=f.padInfo.left,y=f.padInfo.top,N="channelsLast"===f.dataFormat,T=new t.TensorBuffer(f.outShape,o.dtype),x=t.util.computeStrides(o.shape),S=t.util.computeStrides(i.shape),v=x[0],F=N?x[1]:x[2],M=N?x[2]:1,A=N?1:x[1],w=T.strides[0],D=N?T.strides[1]:T.strides[2],_=N?T.strides[2]:1,z=N?1:T.strides[1],E=s.data.get(o.dataId).values,W=s.data.get(i.dataId).values,C=T.values;for(let e=0;e<f.batchSize;++e){const t=e*v,n=e*w;for(let e=0;e<f.outHeight;++e){const a=n+e*D,s=e*f.strideHeight-y;for(let e=0;e<m;++e){const n=s+e*g;if(n<0||n>=f.inHeight)continue;const r=e*S[0],o=t+n*F;for(let e=0;e<f.outWidth;++e){const t=a+e*_,n=e*f.strideWidth-I;for(let e=0;e<k;++e){const a=n+e*b;if(a<0||a>=f.inWidth)continue;const s=o+a*M;let i=r+e*S[1];for(let e=0;e<f.inChannels;++e){const n=E[s+e*A];for(let e=0;e<f.outChannels;++e)C[t+e*z]+=n*W[i+e];i+=f.outChannels}}}}}}return s.makeTensorInfo(T.shape,T.dtype,C)}const dn={kernelName:t.Conv2D,backendName:"cpu",kernelFunc:ln};const un={kernelName:t.Conv2DBackpropFilter,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:r}=e,{x:o,dy:i}=n,{strides:l,pad:d,dataFormat:u,dimRoundingMode:c,filterShape:p}=r;a([o,i],"conv2dBackpropFilter");const h=t.backend_util.convertConv2DDataFormat(u),f=t.backend_util.computeConv2DInfo(o.shape,p,l,1,d,c,!1,h),{strideHeight:m,strideWidth:k,filterHeight:g,filterWidth:b}=f,I="channelsLast"===f.dataFormat,y=new t.TensorBuffer(f.filterShape,"float32"),N=f.padInfo.left,T=f.padInfo.top,x=s.data.get(o.dataId).values,S=s.data.get(i.dataId).values,v=new t.TensorBuffer(o.shape,o.dtype,x),F=new t.TensorBuffer(i.shape,i.dtype,S);for(let e=0;e<g;++e){const t=Math.max(0,Math.ceil((T-e)/m)),n=Math.min(f.outHeight,(f.inHeight+T-e)/m);for(let a=0;a<b;++a){const s=Math.max(0,Math.ceil((N-a)/k)),r=Math.min(f.outWidth,(f.inWidth+N-a)/k);for(let o=0;o<f.inChannels;++o)for(let i=0;i<f.outChannels;++i){let l=0;for(let d=0;d<f.batchSize;++d)for(let u=t;u<n;++u){const t=e+u*m-T;for(let e=s;e<r;++e){const n=a+e*k-N;l+=I?v.get(d,t,n,o)*F.get(d,u,e,i):v.get(d,o,t,n)*F.get(d,i,u,e)}}y.set(l,e,a,o,i)}}}return s.makeTensorInfo(y.shape,y.dtype,y.values)}};const cn={kernelName:t.Conv2DBackpropInput,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:r}=e,{dy:o,filter:i}=n,{inputShape:l,strides:d,pad:u,dataFormat:c,dimRoundingMode:p}=r;a([o,i],"conv2dBackpropInput");const h=t.util.computeStrides(i.shape),f=t.util.computeStrides(o.shape);let m=t.backend_util.convertConv2DDataFormat(c);const k=t.backend_util.computeConv2DInfo(l,i.shape,d,1,u,p,!1,m),g=new t.TensorBuffer(k.inShape,"float32"),b=g.values,I=s.data.get(o.dataId).values,y=s.data.get(i.dataId).values,[N,T,x]=h,{batchSize:S,filterHeight:v,filterWidth:F,inChannels:M,inHeight:A,inWidth:w,outChannels:D,outHeight:_,outWidth:z,strideHeight:E,strideWidth:W}=k;m=k.dataFormat;const C=v-1-k.padInfo.top,H=F-1-k.padInfo.left,P="channelsLast"===m,R=g.strides[0],B=P?g.strides[1]:g.strides[2],$=P?g.strides[2]:1,G=P?1:g.strides[1],L=f[0],V=P?f[1]:f[2],q=P?f[2]:1,O=P?1:f[1];for(let e=0;e<S;++e)for(let t=0;t<M;++t)for(let n=0;n<A;++n){const a=n-C,s=Math.max(0,Math.ceil(a/E)),r=Math.min(_,(v+a)/E);for(let o=0;o<w;++o){const i=o-H,l=Math.max(0,Math.ceil(i/W)),d=Math.min(z,(F+i)/W);let u=0;for(let n=s;n<r;++n){const s=n*E-a;for(let a=l;a<d;++a){const r=L*e+V*n+q*a,o=N*(v-1-s)+T*(F-1-(a*W-i))+x*t;for(let e=0;e<D;++e){u+=I[r+O*e]*y[o+e]}}}b[R*e+B*n+$*o+G*t]=u}}return s.makeTensorInfo(g.shape,g.dtype,g.values)}};const pn={kernelName:t.Conv3D,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:r}=e,{x:o,filter:i}=n,{strides:l,pad:d,dilations:u}=r;a([o,i],"conv3d");const c=t.backend_util.computeConv3DInfo(o.shape,i.shape,l,u,d),{filterDepth:p,filterHeight:h,filterWidth:f,dilationDepth:m,dilationHeight:k,dilationWidth:g,padInfo:b}=c,I=b.front,y=b.left,N=b.top,T=new t.TensorBuffer(c.outShape,o.dtype),x=s.data.get(o.dataId).values,S=s.data.get(i.dataId).values,v=T.values,F=t.util.computeStrides(o.shape),M=t.util.computeStrides(i.shape);for(let e=0;e<c.batchSize;++e){const t=e*F[0],n=e*T.strides[0];for(let e=0;e<c.outDepth;++e){const a=n+e*T.strides[1],s=e*c.strideDepth-I;for(let e=0;e<p;++e){const n=s+e*m;if(n<0||n>=c.inDepth)continue;const r=e*M[0],o=t+n*F[1];for(let e=0;e<c.outHeight;++e){const t=a+e*T.strides[2],n=e*c.strideHeight-N;for(let e=0;e<h;++e){const a=n+e*k;if(a<0||a>=c.inHeight)continue;const s=r+e*M[1],i=o+a*F[2];for(let e=0;e<c.outWidth;++e){const n=t+e*c.outChannels,a=e*c.strideWidth-y;for(let e=0;e<f;++e){const t=a+e*g;if(t<0||t>=c.inWidth)continue;const r=s+e*M[2],o=i+t*c.inChannels;let l=r;for(let e=0;e<c.inChannels;++e){const t=x[o+e];for(let e=0;e<c.outChannels;++e)v[n+e]+=t*S[l+e];l+=c.outChannels}}}}}}}}return s.makeTensorInfo(T.shape,T.dtype,T.values)}};const hn={kernelName:t.Conv3DBackpropFilterV2,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:r}=e,{x:o,dy:i}=n,{strides:l,pad:d,filterShape:u}=r;a([o,i],"conv3dBackpropFilterV2");const c=t.util.computeStrides(o.shape),p=t.util.computeStrides(i.shape),h=t.backend_util.computeConv3DInfo(o.shape,u,l,1,d),f=h.strideDepth,m=h.strideHeight,k=h.strideWidth,g=h.filterDepth,b=h.filterHeight,I=h.filterWidth,y=new t.TensorBuffer(h.filterShape,"float32"),N=y.values,[T,x,S,v]=y.strides,F=s.data.get(i.dataId).values,[M,A,w,D]=p,_=s.data.get(o.dataId).values,[z,E,W,C]=c,H=h.padInfo.front,P=h.padInfo.left,R=h.padInfo.top;for(let e=0;e<g;++e){const t=Math.max(0,Math.ceil((H-e)/f)),n=Math.min(h.outDepth,(h.inDepth+H-e)/f),a=e*T;for(let s=0;s<b;++s){const r=Math.max(0,Math.ceil((R-s)/m)),o=Math.min(h.outHeight,(h.inHeight+R-s)/m),i=s*x+a;for(let a=0;a<I;++a){const l=Math.max(0,Math.ceil((P-a)/k)),d=Math.min(h.outWidth,(h.inWidth+P-a)/k),u=a*S+i;for(let i=0;i<h.inChannels;++i){const c=i*v+u;for(let u=0;u<h.outChannels;++u){let p=0;for(let c=0;c<h.batchSize;++c){const h=c*z,g=c*M;for(let c=t;c<n;++c){const t=(e+c*f-H)*E+h,n=c*A+g;for(let e=r;e<o;++e){const r=(s+e*m-R)*W+t,o=e*w+n;for(let e=l;e<d;++e){const t=e*D+o;p+=_[(a+e*k-P)*C+r+i]*F[t+u]}}}}N[c+u]=p}}}}}return s.makeTensorInfo(y.shape,y.dtype,y.values)}};const fn={kernelName:t.Conv3DBackpropInputV2,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:r}=e,{dy:o,filter:i}=n,{pad:l,strides:d,inputShape:u}=r;a([o],"conv3dBackpropInputV2");const c=t.util.computeStrides(o.shape),p=t.util.computeStrides(i.shape),h=t.backend_util.computeConv3DInfo(u,i.shape,d,1,l),f=new t.TensorBuffer(h.inShape,"float32"),m=f.values,[k,g,b,I]=f.strides,y=s.data.get(o.dataId).values,[N,T,x,S]=c,v=s.data.get(i.dataId).values,[F,M,A,w]=p,{batchSize:D,filterDepth:_,filterHeight:z,filterWidth:E,inChannels:W,inDepth:C,inHeight:H,inWidth:P,outChannels:R,outDepth:B,outHeight:$,outWidth:G,strideDepth:L,strideHeight:V,strideWidth:q}=h,O=_-1-h.padInfo.front,U=z-1-h.padInfo.top,Z=E-1-h.padInfo.left;for(let e=0;e<D;++e)for(let t=0;t<W;++t)for(let n=0;n<C;++n){const a=n-O,s=Math.max(0,Math.ceil(a/L)),r=Math.min(B,(_+a)/L);for(let o=0;o<H;++o){const i=o-U,l=Math.max(0,Math.ceil(i/V)),d=Math.min($,(z+i)/V);for(let u=0;u<P;++u){const c=u-Z,p=Math.max(0,Math.ceil(c/q)),h=Math.min(G,(E+c)/q);let f=0;for(let n=s;n<r;++n){const s=n*L-a;for(let a=l;a<d;++a){const r=a*V-i;for(let o=p;o<h;++o){const i=N*e+T*n+x*a+S*o,l=F*(_-1-s)+M*(z-1-r)+A*(E-1-(o*q-c))+w*t;for(let e=0;e<R;++e){f+=y[i+e]*v[l+e]}}}}m[k*e+g*n+b*o+I*u+t]=f}}}return s.makeTensorInfo(f.shape,f.dtype,f.values)}},mn=M(t.Cos,e=>Math.cos(e)),kn={kernelName:t.Cos,backendName:"cpu",kernelFunc:mn},gn=M(t.Cosh,e=>Math.cosh(e)),bn={kernelName:t.Cosh,backendName:"cpu",kernelFunc:gn};const In={kernelName:t.CropAndResize,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{image:r,boxes:o,boxInd:i}=n,{cropSize:l,method:d,extrapolationValue:u}=s,[c,p,h,f]=r.shape,m=o.shape[0],[k,g]=l,b=t.buffer([m,k,g,f],"float32"),I=a.data.get(o.dataId).values,y=a.data.get(i.dataId).values,N=a.data.get(r.dataId).values,T=t.util.computeStrides(r.shape),x=t.util.computeStrides(b.shape);for(let e=0;e<m;e++){const t=4*e,n=I[t],a=I[t+1],s=I[t+2],r=I[t+3],o=y[e];if(o>=c)continue;const i=k>1?(s-n)*(p-1)/(k-1):0,l=g>1?(r-a)*(h-1)/(g-1):0;for(let t=0;t<k;t++){const c=k>1?n*(p-1)+t*i:.5*(n+s)*(p-1);if(c<0||c>p-1)for(let n=0;n<g;n++)for(let a=0;a<f;a++){const s=a+n*x[2]+t*x[1]+e*x[0];b.values[s]=u}else if("bilinear"===d){const n=Math.floor(c),s=Math.ceil(c),i=c-n;for(let d=0;d<g;d++){const c=g>1?a*(h-1)+d*l:.5*(a+r)*(h-1);if(c<0||c>h-1){for(let n=0;n<f;n++){const a=n+d*x[2]+t*x[1]+e*x[0];b.values[a]=u}continue}const p=Math.floor(c),m=Math.ceil(c),k=c-p;for(let a=0;a<f;a++){let r=a+p*T[2]+n*T[1]+o*T[0];const l=N[r];r=a+m*T[2]+n*T[1]+o*T[0];const u=N[r];r=a+p*T[2]+s*T[1]+o*T[0];const c=N[r];r=a+m*T[2]+s*T[1]+o*T[0];const h=l+(u-l)*k,f=c+(N[r]-c)*k;r=a+d*x[2]+t*x[1]+e*x[0],b.values[r]=h+(f-h)*i}}}else for(let n=0;n<g;++n){const s=g>1?a*(h-1)+n*l:.5*(a+r)*(h-1);if(s<0||s>h-1){for(let a=0;a<f;a++){const s=a+n*x[2]+t*x[1]+e*x[0];b.values[s]=u}continue}const i=Math.round(s),d=Math.round(c);for(let a=0;a<f;a++){const s=a+i*T[2]+d*T[1]+o*T[0],r=a+n*x[2]+t*x[1]+e*x[0];b.values[r]=N[s]}}}}return a.makeTensorInfo(b.shape,b.dtype,b.values)}};const yn={kernelName:t.Cumsum,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:r}=e,{x:o}=n,{axis:i,exclusive:l,reverse:d}=r;a(o,"cumsum");const u=t.backend_util.getAxesPermutation([i],o.shape.length);let c=o;null!=u&&(c=Fe({inputs:{x:o},backend:s,attrs:{perm:u}}));const p=t.backend_util.getInnerMostAxes(1,o.shape.length)[0];if(p!==c.shape.length-1)throw new Error(`backend.cumsum in CPU expects an inner-most axis=${c.shape.length-1} but got axis=${p}`);const h=t.upcastType(c.dtype,"int32"),f=t.util.makeZerosTypedArray(t.util.sizeFromShape(c.shape),h),m=s.data.get(c.dataId).values,k=c.shape[c.shape.length-1],g=d?(e,t)=>e+k-t-1:(e,t)=>e+t;for(let e=0;e<m.length;e+=k)for(let t=0;t<k;t++){const n=g(e,t);if(0===t)f[n]=l?0:m[n];else{const a=g(e,t-1);f[n]=l?m[a]+f[a]:m[n]+f[a]}}const b=s.makeTensorInfo(c.shape,h,f);if(null!=u){const e=Fe({inputs:{x:b},backend:s,attrs:{perm:t.backend_util.getUndoAxesPermutation(u)}});return s.disposeIntermediateTensorInfo(b),s.disposeIntermediateTensorInfo(c),e}return b}};const Nn={kernelName:t.DenseBincount,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{x:s,weights:r}=t,{size:o,binaryOutput:i}=a;if(1===s.shape.length){const e=S(n.data.get(s.dataId).values,n.data.get(r.dataId).values,r.dtype,r.shape,o);return n.makeTensorInfo([o],r.dtype,e)}if(2===s.shape.length){const e=v(n.bufferSync(s),n.bufferSync(r),o,i);return n.makeTensorInfo(e.shape,r.dtype,e.values)}throw new Error("Error in denseBincount: input must be at most rank 2, but got rank"+s.shape.length+".")}};const Tn={kernelName:t.DepthToSpace,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{x:r}=n,{blockSize:o,dataFormat:i}=s;t.util.assert("NHWC"===i,()=>"Only NHWC dataFormat supported on CPU for depthToSpace. Got "+i),t.util.assert(o>1,()=>"blockSize should be > 1 for depthToSpace, but was: "+o);const l=r.shape[0],d=r.shape[1],u=r.shape[2],c=r.shape[3],p=d*o,h=u*o,f=c/(o*o),m=a.data.get(r.dataId).values,k=new Float32Array(l*p*h*f);let g=0;for(let e=0;e<l;++e)for(let t=0;t<p;++t){const n=Math.floor(t/o),a=t%o;for(let t=0;t<h;++t){const s=Math.floor(t/o),r=(a*o+t%o)*f;for(let t=0;t<f;++t){const a=t+r+c*(s+u*(n+d*e));k[g++]=m[a]}}}return a.makeTensorInfo([l,p,h,f],r.dtype,k)}};function xn(e){const{inputs:n,backend:s,attrs:r}=e,{x:o,filter:i}=n,{strides:l,pad:d,dilations:u,dimRoundingMode:c}=r;a([o,i],"depthwiseConv2DNative");const p=t.util.computeStrides(o.shape),h=t.util.computeStrides(i.shape);let f=u;null==f&&(f=[1,1]),t.util.assert(t.backend_util.eitherStridesOrDilationsAreOne(l,f),()=>`Error in depthwiseConv2d: Either strides or dilations must be 1. Got strides ${l} and dilations '${f}'`);const m=t.backend_util.computeConv2DInfo(o.shape,i.shape,l,f,d,c,!0),{filterHeight:k,filterWidth:g,dilationHeight:b,dilationWidth:I,padInfo:y}=m,N=y.left,T=y.top,x=m.outChannels/m.inChannels,S=new t.TensorBuffer(m.outShape,o.dtype),v=s.data.get(o.dataId).values,F=s.data.get(i.dataId).values,M=S.values;for(let e=0;e<m.batchSize;++e){const t=e*p[0],n=e*S.strides[0];for(let e=0;e<m.outHeight;++e){const a=n+e*S.strides[1],s=e*m.strideHeight-T;for(let e=0;e<k;++e){const n=s+e*b;if(n<0||n>=m.inHeight)continue;const r=e*h[0],o=t+n*p[1];for(let e=0;e<m.outWidth;++e){const t=a+e*S.strides[2],n=e*m.strideWidth-N;for(let e=0;e<g;++e){const a=n+e*I;if(a<0||a>=m.inWidth)continue;const s=r+e*h[1],i=o+a*m.inChannels;let l=t,d=s;for(let e=0;e<m.inChannels;++e){const t=v[i+e];for(let e=0;e<x;++e)M[l+e]+=t*F[d+e];l+=x,d+=x}}}}}}return s.makeTensorInfo(S.shape,S.dtype,S.values)}const Sn={kernelName:t.DepthwiseConv2dNative,backendName:"cpu",kernelFunc:xn};const vn={kernelName:t.DepthwiseConv2dNativeBackpropFilter,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:r}=e,{x:o,dy:i}=n,{strides:l,dilations:d,pad:u,dimRoundingMode:c,filterShape:p}=r;a([o,i],"depthwiseConv2dNativeBackpropFilter");const h=t.backend_util.computeConv2DInfo(o.shape,p,l,d,u,c,!0),{strideHeight:f,strideWidth:m,filterHeight:k,filterWidth:g}=h,b=new t.TensorBuffer(h.filterShape,"float32"),I=h.padInfo.left,y=h.padInfo.top,N=h.outChannels/h.inChannels,T=s.data.get(o.dataId).values,x=new t.TensorBuffer(o.shape,o.dtype,T),S=s.data.get(i.dataId).values,v=new t.TensorBuffer(i.shape,i.dtype,S);for(let e=0;e<k;++e){const t=Math.max(0,Math.ceil((y-e)/f)),n=Math.min(h.outHeight,(h.inHeight+y-e)/f);for(let a=0;a<g;++a){const s=Math.max(0,Math.ceil((I-a)/m)),r=Math.min(h.outWidth,(h.inWidth+I-a)/m);for(let o=0;o<h.outChannels;++o){const i=Math.trunc(o/N),l=o%N;let d=0;for(let l=0;l<h.batchSize;++l)for(let u=t;u<n;++u){const t=e+u*f-y;for(let e=s;e<r;++e){const n=a+e*m-I;d+=x.get(l,t,n,i)*v.get(l,u,e,o)}}b.set(d,e,a,i,l)}}}return s.makeTensorInfo(b.shape,b.dtype,b.values)}};const Fn={kernelName:t.DepthwiseConv2dNativeBackpropInput,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:r}=e,{dy:o,filter:i}=n,{strides:l,dilations:d,pad:u,dimRoundingMode:c,inputShape:p}=r;a([o,i],"depthwiseConv2DNativeBackpropInput");const h=t.util.computeStrides(o.shape),f=t.util.computeStrides(i.shape),m=t.backend_util.computeConv2DInfo(p,i.shape,l,d,u,c,!0),k=new t.TensorBuffer(m.inShape,"float32"),g=k.values,[b,I,y]=k.strides,N=s.data.get(o.dataId).values,[T,x,S]=h,v=s.data.get(i.dataId).values,[F,M,A]=f,{batchSize:w,filterHeight:D,filterWidth:_,inChannels:z,inHeight:E,inWidth:W,outChannels:C,outHeight:H,outWidth:P,strideHeight:R,strideWidth:B}=m,$=D-1-m.padInfo.top,G=_-1-m.padInfo.left,L=C/z;for(let e=0;e<w;++e)for(let t=0;t<z;++t)for(let n=0;n<E;++n){const a=n-$,s=Math.max(0,Math.ceil(a/R)),r=Math.min(H,(D+a)/R);for(let o=0;o<W;++o){const i=o-G,l=Math.max(0,Math.ceil(i/B)),d=Math.min(P,(_+i)/B);let u=0;for(let n=s;n<r;++n){const s=n*R-a;for(let a=l;a<d;++a){const r=T*e+x*n+S*a,o=F*(D-1-s)+M*(_-1-(a*B-i))+A*t;for(let e=0;e<L;++e){u+=N[r+(t*L+e)]*v[o+e]}}}g[b*e+I*n+y*o+t]=u}}return s.makeTensorInfo(k.shape,k.dtype,k.values)}};const Mn={kernelName:t.Diag,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a}=e,{x:s}=n,r=t.util.sizeFromShape(s.shape),o=a.data.get(s.dataId).values,i=t.buffer([r,r],s.dtype),l=i.values;for(let e=0;e<o.length;e++)l[e*r+e]=o[e];const d=[...s.shape,...s.shape];return a.makeTensorInfo(d,i.dtype,i.values)}},An={kernelName:t.Dilation2D,backendName:"cpu",kernelFunc:({inputs:e,backend:n,attrs:a})=>{const{x:s,filter:r}=e,{strides:o,pad:i,dilations:l}=a,d=n,u=d.data.get(s.dataId).values,c=s.shape.length,p=d.data.get(r.dataId).values,h=r.shape.length,{batchSize:f,inHeight:m,inWidth:k,inChannels:g,outHeight:b,outWidth:I,padInfo:y,strideHeight:N,strideWidth:T,filterHeight:x,filterWidth:S,dilationHeight:v,dilationWidth:F,outShape:M}=t.backend_util.computeDilation2DInfo(s.shape,r.shape,o,i,"NHWC",l),A=t.util.sizeFromShape(M),w=M.length,D=t.util.getArrayFromDType(s.dtype,A);for(let e=0;e<f;++e)for(let n=0;n<b;++n){const a=n*N-y.top;for(let o=0;o<I;++o){const i=o*T-y.left;for(let l=0;l<g;++l){let d=Number.MIN_SAFE_INTEGER;for(let n=0;n<x;++n){const o=a+n*v;if(o>=0&&o<m)for(let a=0;a<S;++a){const f=i+a*F;if(f>=0&&f<k){const i=t.util.locToIndex([e,o,f,l],c,t.util.computeStrides(s.shape)),m=t.util.locToIndex([n,a,l],h,t.util.computeStrides(r.shape)),k=u[i]+p[m];k>d&&(d=k)}}}D[t.util.locToIndex([e,n,o,l],w,t.util.computeStrides(M))]=d}}}return{dataId:d.write(t.util.toTypedArray(D,s.dtype),M,s.dtype),shape:M,dtype:s.dtype}}},wn={kernelName:t.Dilation2DBackpropFilter,backendName:"cpu",kernelFunc:({inputs:e,backend:n,attrs:a})=>{const{x:s,filter:r,dy:o}=e,{strides:i,pad:l,dilations:d}=a,u=n,c=t.util.toNestedArray(s.shape,u.data.get(s.dataId).values),p=t.util.toNestedArray(r.shape,u.data.get(r.dataId).values),{batchSize:h,inHeight:f,inWidth:m,inChannels:k,outHeight:g,outWidth:b,padInfo:I,strideHeight:y,strideWidth:N,filterHeight:T,filterWidth:x,dilationHeight:S,dilationWidth:v,outShape:F}=t.backend_util.computeDilation2DInfo(s.shape,r.shape,i,l,"NHWC",d);t.util.assert(o.rank===F.length,()=>`Error in ${t.Dilation2DBackpropFilter}, dy must have the same rank as output ${F.length}, but got `+o.rank);const M=t.util.toNestedArray(F,u.data.get(o.dataId).values),A=t.util.makeZerosNestedTypedArray(r.shape,r.dtype);for(let e=0;e<h;++e)for(let t=0;t<g;++t){const n=t*y-I.top;for(let a=0;a<b;++a){const s=a*N-I.left;for(let r=0;r<k;++r){let o=Number.MIN_SAFE_INTEGER,i=0,l=0;for(let t=0;t<T;++t){const a=n+t*S;if(a>=0&&a<f)for(let n=0;n<x;++n){const d=s+n*v;if(d>=0&&d<m){const s=c[e][a][d][r]+p[t][n][r];s>o&&(o=s,i=t,l=n)}}}A[i][l][r]+=M[e][t][a][r]}}}return{dataId:u.write(t.util.toTypedArray(A,s.dtype),r.shape,r.dtype),shape:r.shape,dtype:r.dtype}}},Dn={kernelName:t.Dilation2DBackpropInput,backendName:"cpu",kernelFunc:({inputs:e,backend:n,attrs:a})=>{const{x:s,filter:r,dy:o}=e,{strides:i,pad:l,dilations:d}=a,u=n,c=t.util.toNestedArray(s.shape,u.data.get(s.dataId).values),p=t.util.toNestedArray(r.shape,u.data.get(r.dataId).values),{batchSize:h,inHeight:f,inWidth:m,inChannels:k,outHeight:g,outWidth:b,padInfo:I,strideHeight:y,strideWidth:N,filterHeight:T,filterWidth:x,dilationHeight:S,dilationWidth:v,outShape:F}=t.backend_util.computeDilation2DInfo(s.shape,r.shape,i,l,"NHWC",d);t.util.assert(o.rank===F.length,()=>`Error in ${t.Dilation2DBackpropInput}, dy must have the same rank as output ${F.length}, but got `+o.rank);const M=t.util.toNestedArray(F,u.data.get(o.dataId).values),A=t.util.makeZerosNestedTypedArray(s.shape,s.dtype);for(let e=0;e<h;++e)for(let t=0;t<g;++t){const n=t*y-I.top;for(let a=0;a<b;++a){const s=a*N-I.left;for(let r=0;r<k;++r){let o=Number.MIN_SAFE_INTEGER,i=n<0?0:n,l=s<0?0:s;for(let t=0;t<T;++t){const a=n+t*S;if(a>=0&&a<f)for(let n=0;n<x;++n){const d=s+n*v;if(d>=0&&d<m){const s=c[e][a][d][r]+p[t][n][r];s>o&&(o=s,i=a,l=d)}}}A[e][i][l][r]+=M[e][t][a][r]}}}return{dataId:u.write(t.util.toTypedArray(A,s.dtype),s.shape,s.dtype),shape:s.shape,dtype:s.dtype}}};function _n(e){const{inputs:n,backend:s,attrs:r}=e,{x:o}=n,{axis:i,keepDims:l}=r;let d;a(o,"sum"),d="bool"===o.dtype?k({inputs:{x:o},backend:s,attrs:{dtype:"int32"}}):p({inputs:{x:o},backend:s});const u=d.shape.length,h=t.util.parseAxisParam(i,d.shape),f=t.backend_util.getAxesPermutation(h,u);let m=h,g=d;null!=f&&(g=Fe({inputs:{x:d},backend:s,attrs:{perm:f}}),m=t.backend_util.getInnerMostAxes(m.length,u)),t.backend_util.assertAxesAreInnerMostDims("sum",m,g.shape.length);const[b,I]=t.backend_util.computeOutAndReduceShapes(g.shape,m);let y=c(s,b,t.backend_util.upcastType(g.dtype,"int32"));const N=t.util.sizeFromShape(I),T=s.data.get(y.dataId).values,x=s.data.get(g.dataId).values;for(let e=0;e<T.length;++e){const t=e*N;let n=0;for(let e=0;e<N;++e)n+=x[t+e];T[e]=n}if(l){const e=y;y=It({inputs:{x:y},backend:s,attrs:{shape:t.backend_util.expandShapeToKeepDim(y.shape,h)}}),s.disposeIntermediateTensorInfo(e)}return s.disposeIntermediateTensorInfo(d),null!=f&&s.disposeIntermediateTensorInfo(g),y}const zn={kernelName:t.Sum,backendName:"cpu",kernelFunc:_n};const En={kernelName:t.Einsum,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{equation:r}=s,o=n,{allDims:i,summedDims:l,idDims:d}=t.backend_util.decodeEinsumEquation(r,o.length);t.backend_util.checkEinsumDimSizes(i.length,d,o);const{path:u,steps:c}=t.backend_util.getEinsumComputePath(l,d),p=c.length;let h=null,f=i.length;const m=[];for(let e=0;e<p;++e){for(const n of c[e]){const{permutationIndices:e,expandDims:s}=t.backend_util.getEinsumPermutation(f,d[n]);let r;t.backend_util.isIdentityPermutation(e)?r=o[n]:(r=Fe({inputs:{x:o[n]},backend:a,attrs:{perm:e}}),m.push(r));const i=r.shape.slice();for(let e=0;e<s.length;++e)i.splice(s[e],0,1);t.util.arraysEqual(r.shape,i)||(r=It({inputs:{x:r},backend:a,attrs:{shape:i}}),m.push(r)),null===h?h=r:(h=be({inputs:{a:r,b:h},backend:a}),m.push(h))}e<p-1&&(u[e]>=0&&(h=_n({inputs:{x:h},backend:a,attrs:{axis:u[e]-(i.length-f),keepDims:!1}}),m.push(h)),f--)}for(const e of m)e!==h&&a.disposeIntermediateTensorInfo(e);return h}};const Wn={kernelName:t.EluGrad,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s}=e,{dy:r,y:o}=n;a([r,o],"eluGrad");const i=new Float32Array(t.util.sizeFromShape(o.shape)),l=s.data.get(o.dataId).values,d=s.data.get(r.dataId).values;for(let e=0;e<l.length;++e){const t=l[e];i[e]=t>=1?d[e]:d[e]*(t+1)}return s.makeTensorInfo(o.shape,"float32",i)}},Cn=t.backend_util.ERF_P,Hn=t.backend_util.ERF_A1,Pn=t.backend_util.ERF_A2,Rn=t.backend_util.ERF_A3,Bn=t.backend_util.ERF_A4,$n=t.backend_util.ERF_A5,Gn=M(t.Erf,e=>{const t=Math.sign(e),n=Math.abs(e),a=1/(1+Cn*n);return t*(1-(((($n*a+Bn)*a+Rn)*a+Pn)*a+Hn)*a*Math.exp(-n*n))}),Ln={kernelName:t.Erf,backendName:"cpu",kernelFunc:Gn};function Vn(e){const{inputs:n,backend:a,attrs:s}=e,{input:r}=n,{dim:o}=s,i=r.shape.length,l=r.shape.slice();let d=o;return o<0&&(t.util.assert(-(i+1)<=o,()=>`Axis must be in the interval [${-(i+1)}, ${i}]`),d=i+o+1),l.splice(d,0,1),It({inputs:{x:r},backend:a,attrs:{shape:l}})}const qn={kernelName:t.ExpandDims,backendName:"cpu",kernelFunc:Vn},On=l((e,t)=>e/t),Un=b(t.RealDiv,On),Zn={kernelName:t.RealDiv,backendName:"cpu",kernelFunc:Un};function jn(e,n,a){const s=e.shape,r=s[0],o=s[1],i=a.data.get(e.dataId),l=i.complexTensorInfos.real,u=i.complexTensorInfos.imag,c=[r,o],p=t.util.sizeFromShape(c),h=t.util.getTypedArrayFromDType("float32",p),f=t.util.getTypedArrayFromDType("float32",p);for(let e=0;e<r;e++){const s=Ce({inputs:{x:l},backend:a,attrs:{begin:[e,0],size:[1,o]}}),r=Ce({inputs:{x:u},backend:a,attrs:{begin:[e,0],size:[1,o]}}),i=d({inputs:{real:s,imag:r},backend:a}),{real:c,imag:p}=Kn(i,n,a),m=t.backend_util.mergeRealAndImagArrays(c,p);for(let n=0;n<o;n++){const a=t.backend_util.getComplexWithIndex(m,n);h[e*o+n]=a.real,f[e*o+n]=a.imag}a.disposeIntermediateTensorInfo(s),a.disposeIntermediateTensorInfo(r),a.disposeIntermediateTensorInfo(i)}const m=a.makeTensorInfo(c,"float32",h),k=a.makeTensorInfo(c,"float32",f),g=d({inputs:{real:m,imag:k},backend:a});return a.disposeIntermediateTensorInfo(m),a.disposeIntermediateTensorInfo(k),g}function Kn(e,n,a){const s=t.util.sizeFromShape(e.shape),r=a.data.get(e.dataId),o=a.data.get(r.complexTensorInfos.real.dataId).values,i=a.data.get(r.complexTensorInfos.imag.dataId).values;if(0==((l=s)&l-1)){const r=function e(n,a,s,r,o){if(1===s)return{real:n,imag:a};const i=t.backend_util.mergeRealAndImagArrays(n,a),l=s/2,u=t.backend_util.complexWithEvenIndex(i),c=u.real,p=u.imag,h=[c.length],m=o.makeTensorInfo(h,"float32",c),k=o.makeTensorInfo(h,"float32",p),g=d({inputs:{real:m,imag:k},backend:o}),b=t.backend_util.complexWithOddIndex(i),I=b.real,y=b.imag,N=[I.length],x=o.makeTensorInfo(N,"float32",I),S=o.makeTensorInfo(N,"float32",y),v=d({inputs:{real:x,imag:S},backend:o}),F=e(c,p,l,r,o),M=F.real,A=F.imag,w=[M.length],D=o.makeTensorInfo(w,"float32",M),_=o.makeTensorInfo(w,"float32",A),z=d({inputs:{real:D,imag:_},backend:o}),E=e(I,y,l,r,o),W=E.real,C=E.imag,H=[W.length],P=o.makeTensorInfo(H,"float32",W),R=o.makeTensorInfo(H,"float32",C),B=d({inputs:{real:P,imag:R},backend:o}),$=t.backend_util.exponents(s,r),G=[$.real.length],L=o.makeTensorInfo(G,"float32",$.real),V=o.makeTensorInfo(G,"float32",$.imag),q=d({inputs:{real:L,imag:V},backend:o}),O=be({inputs:{a:q,b:B},backend:o}),U=T({inputs:{a:z,b:O},backend:o}),Z=Je({inputs:{a:z,b:O},backend:o}),j=f({inputs:{input:U},backend:o}),K=f({inputs:{input:Z},backend:o}),Y=an({inputs:{input:U},backend:o}),J=an({inputs:{input:Z},backend:o}),Q=rn({inputs:[j,K],backend:o,attrs:{axis:0}}),X=rn({inputs:[Y,J],backend:o,attrs:{axis:0}}),ee=o.data.get(Q.dataId).values,te=o.data.get(X.dataId).values;return o.disposeIntermediateTensorInfo(m),o.disposeIntermediateTensorInfo(k),o.disposeIntermediateTensorInfo(g),o.disposeIntermediateTensorInfo(x),o.disposeIntermediateTensorInfo(S),o.disposeIntermediateTensorInfo(v),o.disposeIntermediateTensorInfo(D),o.disposeIntermediateTensorInfo(_),o.disposeIntermediateTensorInfo(z),o.disposeIntermediateTensorInfo(P),o.disposeIntermediateTensorInfo(R),o.disposeIntermediateTensorInfo(B),o.disposeIntermediateTensorInfo(L),o.disposeIntermediateTensorInfo(V),o.disposeIntermediateTensorInfo(q),o.disposeIntermediateTensorInfo(O),o.disposeIntermediateTensorInfo(U),o.disposeIntermediateTensorInfo(Z),o.disposeIntermediateTensorInfo(j),o.disposeIntermediateTensorInfo(Y),o.disposeIntermediateTensorInfo(K),o.disposeIntermediateTensorInfo(J),o.disposeIntermediateTensorInfo(Q),o.disposeIntermediateTensorInfo(X),{real:ee,imag:te}}(o,i,s,n,a),l=[e.shape[0],e.shape[1]];if(n){const e=a.makeTensorInfo(l,"float32",r.real),n=a.makeTensorInfo(l,"float32",r.imag),o=a.makeTensorInfo([],"float32",t.util.createScalarValue(s,"float32")),i=p({inputs:{x:o},backend:a}),d=Zn.kernelFunc({inputs:{a:e,b:o},backend:a}),u=Zn.kernelFunc({inputs:{a:n,b:i},backend:a}),c=a.data.get(d.dataId).values,h=a.data.get(u.dataId).values;return a.disposeIntermediateTensorInfo(e),a.disposeIntermediateTensorInfo(n),a.disposeIntermediateTensorInfo(o),a.disposeIntermediateTensorInfo(i),a.disposeIntermediateTensorInfo(d),a.disposeIntermediateTensorInfo(u),{real:c,imag:h}}return r}{const e=function(e,n,a){const s=new Float32Array(2*n);for(let r=0;r<n;r++){let o=0,i=0;for(let s=0;s<n;s++){const l=t.backend_util.exponent(r*s,n,a),d=t.backend_util.getComplexWithIndex(e,s);o+=d.real*l.real-d.imag*l.imag,i+=d.real*l.imag+d.imag*l.real}a&&(o/=n,i/=n),t.backend_util.assignToTypedArray(s,o,i,r)}return s}(t.backend_util.mergeRealAndImagArrays(o,i),s,n);return t.backend_util.splitRealAndImagArrays(e)}var l}const Yn={kernelName:t.FFT,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a}=e,{input:s}=n,r=t.util.sizeFromShape(s.shape),o=s.shape[s.shape.length-1],i=It({inputs:{x:s},backend:a,attrs:{shape:[r/o,o]}}),l=jn(i,!1,a),d=It({inputs:{x:l},backend:a,attrs:{shape:s.shape}});return a.disposeIntermediateTensorInfo(i),a.disposeIntermediateTensorInfo(l),d}};function Jn(e){const{backend:n,attrs:a}=e,{shape:s,value:r,dtype:o}=a,i=o||t.util.inferDtype(r),l=t.util.getArrayFromDType(i,t.util.sizeFromShape(s));return function(e,t,n){e.fill(t)}(l,r),n.makeTensorInfo(s,i,l)}const Qn={kernelName:t.Fill,backendName:"cpu",kernelFunc:Jn};const Xn={kernelName:t.FlipLeftRight,backendName:"cpu",kernelFunc:({inputs:e,attrs:n,backend:a})=>{const{image:s}=e,r=a,o=t.util.getTypedArrayFromDType(s.dtype,t.util.sizeFromShape(s.shape)),[i,l,d,u]=s.shape,c=r.data.get(s.dataId).values;for(let e=0;e<i;e++){const t=e*d*l*u;for(let e=0;e<l;e++){const n=e*(d*u);for(let e=0;e<d;e++){const a=e*u;for(let s=0;s<u;s++){const r=Math.round(d-e-1),i=t+n+a+s;let l=c[i];if(r>=0&&r<d){l=c[t+n+r*u+s]}o[i]=l}}}}return{dataId:r.write(o,s.shape,s.dtype),shape:s.shape,dtype:s.dtype}}},ea=l((e,t)=>Math.floor(e/t)),ta=b(t.FloorDiv,ea,null,"int32"),na={kernelName:t.FloorDiv,backendName:"cpu",kernelFunc:ta};const aa={kernelName:t.FusedConv2D,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{x:s,filter:r,bias:o,preluActivationWeights:i}=t,{strides:l,pad:d,dataFormat:u,dilations:c,dimRoundingMode:p,activation:h,leakyreluAlpha:f}=a;let m=ln({inputs:{x:s,filter:r},backend:n,attrs:{strides:l,pad:d,dataFormat:u,dilations:c,dimRoundingMode:p}});if(o){const e=m;m=T({inputs:{a:m,b:o},backend:n}),n.disposeIntermediateTensorInfo(e)}if(h){const e=m;m=bt(n,m,h,i,f),n.disposeIntermediateTensorInfo(e)}return m}};const sa={kernelName:t.FusedDepthwiseConv2D,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{x:s,filter:r,bias:o,preluActivationWeights:i}=t,{strides:l,pad:d,dataFormat:u,dilations:c,dimRoundingMode:p,activation:h,leakyreluAlpha:f}=a;let m=xn({inputs:{x:s,filter:r},backend:n,attrs:{strides:l,pad:d,dataFormat:u,dilations:c,dimRoundingMode:p}});if(o){const e=m;m=T({inputs:{a:m,b:o},backend:n}),n.disposeIntermediateTensorInfo(e)}if(h){const e=m;m=bt(n,m,h,i,f),n.disposeIntermediateTensorInfo(e)}return m}};const ra={kernelName:t.GatherNd,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a}=e,{params:s,indices:r}=n,o=t.util.sizeFromShape(s.shape),i=r.shape,l=i[i.length-1],[d,u,c,p]=t.backend_util.prepareAndValidate(s,r);if(0===u)return a.makeTensorInfo(d,s.dtype,[]);const h=O(a.data.get(r.dataId).values,a.bufferSync(s),s.dtype,u,l,c,p,s.shape,o);return a.makeTensorInfo(d,s.dtype,h.values)}};const oa={kernelName:t.GatherV2,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:r}=e,{x:o,indices:i}=n,{axis:l,batchDims:d}=r;a([o,i],"gatherV2");let u=d;null==d&&(u=0);const c=t.util.sizeFromShape(i.shape),p=t.util.parseAxisParam(l,o.shape)[0],h=t.backend_util.segment_util.collectGatherOpShapeInfo(o,i,p,u),f=It({inputs:{x:o},backend:s,attrs:{shape:[h.batchSize,h.outerSize,h.dimSize,h.sliceSize]}}),m=It({inputs:{x:i},backend:s,attrs:{shape:[h.batchSize,c/h.batchSize]}}),k=[h.batchSize,h.outerSize,c/h.batchSize,h.sliceSize],g=s.bufferSync(m),b=U(s.bufferSync(f),g,k);return s.disposeIntermediateTensorInfo(f),s.disposeIntermediateTensorInfo(m),s.makeTensorInfo(h.outputShape,b.dtype,b.values)}};const ia={kernelName:t.IFFT,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a}=e,{input:s}=n,r=t.util.sizeFromShape(s.shape),o=s.shape[s.shape.length-1],i=It({inputs:{x:s},backend:a,attrs:{shape:[r/o,o]}}),l=jn(i,!0,a),d=It({inputs:{x:l},backend:a,attrs:{shape:s.shape}});return a.disposeIntermediateTensorInfo(i),a.disposeIntermediateTensorInfo(l),d}},la=M(t.IsFinite,e=>Number.isFinite(e)?1:0,"bool"),da={kernelName:t.IsFinite,backendName:"cpu",kernelFunc:la},ua=M(t.IsInf,e=>Math.abs(e)===1/0?1:0,"bool"),ca={kernelName:t.IsInf,backendName:"cpu",kernelFunc:ua},pa=M(t.IsNan,e=>Number.isNaN(e)?1:0,"bool"),ha={kernelName:t.IsNan,backendName:"cpu",kernelFunc:pa};const fa={kernelName:t.LinSpace,backendName:"cpu",kernelFunc:function(e){const{backend:t,attrs:n}=e,{start:a,stop:s,num:r}=n,o=re(a,s,r);return t.makeTensorInfo([o.length],"float32",o)}},ma=M(t.Log1p,e=>Math.log1p(e)),ka={kernelName:t.Log1p,backendName:"cpu",kernelFunc:ma},ga=l((e,t)=>e&&t),ba=b(t.LogicalAnd,ga,null,"bool"),Ia={kernelName:t.LogicalAnd,backendName:"cpu",kernelFunc:ba},ya=M(t.LogicalNot,e=>e?0:1,"bool"),Na={kernelName:t.LogicalNot,backendName:"cpu",kernelFunc:ya},Ta=l((e,t)=>e||t),xa=b(t.LogicalOr,Ta,null,"bool"),Sa={kernelName:t.LogicalOr,backendName:"cpu",kernelFunc:xa};const va={kernelName:t.LRN,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:r}=e,{x:o}=n,{depthRadius:i,bias:l,alpha:d,beta:u}=r;a(o,"LRN");const c=o.shape[3],p=c-1,h=s.data.get(o.dataId).values,f=t.util.sizeFromShape(o.shape),m=new Float32Array(f);function k(e){const t=e%c;let n=e-t+Math.max(0,t-i);const a=e-t+Math.min(t+i,p);let s=0;for(;n<=a;n++){const e=h[n];s+=e*e}return s}for(let e=0;e<f;e++){const t=k(e),n=h[e]*Math.pow(l+d*t,-u);m[e]=n}return s.makeTensorInfo(o.shape,o.dtype,m)}};const Fa={kernelName:t.LRNGrad,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:r}=e,{x:o,y:i,dy:l}=n,{depthRadius:d,bias:u,alpha:c,beta:p}=r;a(l,"LRNGrad");const h=t.util.sizeFromShape(l.shape),f=l.shape[3],m=s.data.get(l.dataId).values,k=s.data.get(o.dataId).values,g=s.data.get(i.dataId).values,b=new Float32Array(h),I=h;for(let e=0;e<I;e++){const t=e%f,n=e-t+Math.max(0,t-d),a=e-t+Math.min(f,t+d+1);let s=0;for(let e=n;e<a;e++)s+=Math.pow(k[e],2);s=c*s+u;for(let t=n;t<a;t++){let n=-2*c*p*k[t]*g[e]/s;e===t&&(n+=Math.pow(s,-p)),n*=m[e],b[t]+=n}}return s.makeTensorInfo(l.shape,o.dtype,b)}};function Ma(e){const{inputs:n,backend:s,attrs:r}=e,{x:o}=n,{reductionIndices:i,keepDims:l}=r,d=s;let u=o.shape;const c=u.length,p=t.util.parseAxisParam(i,u);let h=p;const f=t.backend_util.getAxesPermutation(h,c);let m=d.data.get(o.dataId).values;if(null!=f){const e=new Array(c);for(let t=0;t<e.length;t++)e[t]=u[f[t]];m=ve(m,u,o.dtype,f,e),h=t.backend_util.getInnerMostAxes(h.length,c),u=e}a(o,"max"),t.backend_util.assertAxesAreInnerMostDims("max",h,c);const[k,g]=t.backend_util.computeOutAndReduceShapes(u,h),b=de(m,t.util.sizeFromShape(g),k,o.dtype),I=d.write(b,k,o.dtype);let y=k;if(l){y=t.backend_util.expandShapeToKeepDim(k,p)}return{dataId:I,shape:y,dtype:o.dtype}}const Aa={kernelName:t.Max,backendName:"cpu",kernelFunc:Ma};const wa={kernelName:t.MaxPool,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:r}=e,{x:o}=n;a(o,"maxPool");const{filterSize:i,strides:l,pad:d,dimRoundingMode:u}=r;t.util.assert(t.backend_util.eitherStridesOrDilationsAreOne(l,1),()=>`Error in maxPool: Either strides or dilations must be 1. Got strides ${l} and dilations '1'`);const c=t.backend_util.computePool2DInfo(o.shape,i,l,1,d,u);let h;if(1===c.filterWidth&&1===c.filterHeight&&t.util.arraysEqual(c.inShape,c.outShape))h=p({inputs:{x:o},backend:s});else{const e=s.data.get(o.dataId).values,n=t.util.computeStrides(o.shape),a=qt(e,o.shape,o.dtype,n,c,"max");h=s.makeTensorInfo(c.outShape,o.dtype,a.values)}return h}};const Da={kernelName:t.MaxPool3D,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:r}=e,{x:o}=n,{filterSize:i,strides:l,pad:d,dimRoundingMode:u,dataFormat:c}=r;a(o,"maxPool3d");const p=t.backend_util.computePool3DInfo(o.shape,i,l,1,d,u,c),h=Ut(s.data.get(o.dataId).values,o.shape,o.dtype,t.util.computeStrides(o.shape),p,"max");return s.makeTensorInfo(h.shape,"float32",h.values)}};const _a={kernelName:t.MaxPool3DGrad,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:r}=e,{dy:o,input:i}=n,{filterSize:l,strides:d,pad:u,dimRoundingMode:c}=r;a([o,i],"maxPool3DGrad");const p=t.backend_util.computePool3DInfo(i.shape,l,d,1,u,c),h=function(e,n){const a=t.buffer(n.outShape,"int32"),s=n.strideDepth,r=n.strideHeight,o=n.strideWidth,i=n.dilationDepth,l=n.dilationHeight,d=n.dilationWidth,u=n.effectiveFilterDepth,c=n.effectiveFilterHeight,p=n.effectiveFilterWidth,h=n.padInfo.front,f=n.padInfo.top,m=n.padInfo.left;for(let t=0;t<n.batchSize;++t)for(let k=0;k<n.inChannels;++k)for(let g=0;g<n.outDepth;++g){const b=g*s-h;let I=b;for(;I<0;)I+=i;const y=Math.min(n.inDepth,u+b);for(let s=0;s<n.outHeight;++s){const u=s*r-f;let h=u;for(;h<0;)h+=l;const N=Math.min(n.inHeight,c+u);for(let r=0;r<n.outWidth;++r){const f=r*o-m;let T=f;for(;T<0;)T+=d;const x=Math.min(n.inWidth,p+f);let S=Number.NEGATIVE_INFINITY,v=-1;for(let n=I;n<y;n+=i){const a=n-b;for(let s=h;s<N;s+=l){const r=s-u;for(let o=T;o<x;o+=d){const i=o-f,l=e.get(t,n,s,o,k);l>=S&&(S=l,v=a*c*p+r*c+i)}}}a.set(v,t,g,s,r,k)}}}return a}(s.bufferSync(i),p),f=p.strideDepth,m=p.strideHeight,k=p.strideWidth,g=p.dilationDepth,b=p.dilationHeight,I=p.dilationWidth,y=p.effectiveFilterDepth,N=p.effectiveFilterHeight,T=p.effectiveFilterWidth,x=y-1-p.padInfo.front,S=T-1-p.padInfo.left,v=N-1-p.padInfo.top,F=t.buffer(i.shape,"float32"),M=s.bufferSync(o);for(let e=0;e<p.batchSize;++e)for(let t=0;t<p.inChannels;++t)for(let n=0;n<p.inDepth;++n)for(let a=0;a<p.inHeight;++a)for(let s=0;s<p.inWidth;++s){const r=n-x,o=a-v,i=s-S;let l=0;for(let n=0;n<y;n+=g){const a=(r+n)/f;if(!(a<0||a>=p.outDepth||Math.floor(a)!==a))for(let s=0;s<N;s+=b){const r=(o+s)/m;if(!(r<0||r>=p.outHeight||Math.floor(r)!==r))for(let o=0;o<T;o+=I){const d=(i+o)/k;if(d<0||d>=p.outWidth||Math.floor(d)!==d)continue;const u=y*N*T-1-h.get(e,a,r,d,t)===n*N*T+s*T+o?1:0;if(0===u)continue;l+=M.get(e,a,r,d,t)*u}}}F.set(l,e,n,a,s,t)}return s.makeTensorInfo(F.shape,F.dtype,F.values)}};const za={kernelName:t.MaxPoolGrad,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:r}=e,{dy:o,input:i,output:l}=n,d=i;a([i,l],"maxPoolGrad");const{filterSize:u,strides:c,pad:p,dimRoundingMode:h}=r,f=t.backend_util.computePool2DInfo(d.shape,u,c,1,p,h),m=s.data.get(d.dataId).values,k=t.buffer(f.outShape,d.dtype,Ot(m,d.shape,d.dtype,f).values),g=f.strideHeight,b=f.strideWidth,I=f.dilationHeight,y=f.dilationWidth,N=f.effectiveFilterHeight,T=f.effectiveFilterWidth,x=T-1-f.padInfo.left,S=N-1-f.padInfo.top,v=t.buffer(d.shape,"float32"),F=s.data.get(o.dataId).values,M=t.buffer(o.shape,"float32",F);for(let e=0;e<f.batchSize;++e)for(let t=0;t<f.inChannels;++t)for(let n=0;n<f.inHeight;++n)for(let a=0;a<f.inWidth;++a){const s=n-S,r=a-x;let o=0;for(let n=0;n<N;n+=I){const a=(s+n)/g;if(!(a<0||a>=f.outHeight||Math.floor(a)!==a))for(let s=0;s<T;s+=y){const i=(r+s)/b;if(i<0||i>=f.outWidth||Math.floor(i)!==i)continue;const l=N*T-1-k.get(e,a,i,t)===n*T+s?1:0;if(0===l)continue;o+=M.get(e,a,i,t)*l}}v.set(o,e,n,a,t)}return s.makeTensorInfo(v.shape,v.dtype,v.values)}};const Ea={kernelName:t.MaxPoolWithArgmax,backendName:"cpu",kernelFunc:({inputs:e,attrs:n,backend:s})=>{const{x:r}=e,{filterSize:o,strides:i,pad:l,includeBatchInIndex:d}=n,u=s;a(r,"MaxPoolWithArgmax");const c=u.data.get(r.dataId).values,p=t.backend_util.computePool2DInfo(r.shape,o,i,[1,1],l),[h,f]=function(e,n,a,s,r){const o=qt(e,0,a,t.util.computeStrides(n),r,"max"),i=Ot(e,n,a,r,!0,s);return[o.values,i.values]}(c,r.shape,r.dtype,d,p),m=u.write(h,p.outShape,r.dtype),k=u.write(f,p.outShape,r.dtype);return[{dataId:m,shape:p.outShape,dtype:r.dtype},{dataId:k,shape:p.outShape,dtype:"int32"}]}};const Wa={kernelName:t.Mean,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{x:r}=n,{axis:o,keepDims:i}=s,l=t.util.parseAxisParam(o,r.shape),d=t.backend_util.computeOutAndReduceShapes(r.shape,l)[1],u=t.util.sizeFromShape(d),c=[],p=a.makeTensorInfo([],"float32",new Float32Array([u]));c.push(p);const h=k({inputs:{x:r},backend:a,attrs:{dtype:"float32"}});c.push(h);const f=Un({inputs:{a:h,b:p},backend:a});c.push(f);const m=_n({inputs:{x:f},backend:a,attrs:{axis:o,keepDims:i}});return c.forEach(e=>a.disposeIntermediateTensorInfo(e)),m}};const Ca={kernelName:t.Min,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:r}=e,{x:o}=n,{axis:i,keepDims:l}=r;a(o,"min");const d=t.util.parseAxisParam(i,o.shape);let u=d;const c=t.backend_util.getAxesPermutation(u,o.shape.length);let p=o;null!=c&&(p=Fe({inputs:{x:o},backend:s,attrs:{perm:c}}),u=t.backend_util.getInnerMostAxes(u.length,o.shape.length)),t.backend_util.assertAxesAreInnerMostDims("min",u,p.shape.length);const[h,f]=t.backend_util.computeOutAndReduceShapes(p.shape,u),m=t.util.sizeFromShape(f),k=t.util.makeZerosTypedArray(t.util.sizeFromShape(h),p.dtype),g=s.data.get(p.dataId).values;for(let e=0;e<k.length;++e){const t=e*m;let n=g[t];for(let e=0;e<m;++e){const a=g[t+e];(Number.isNaN(a)||a<n)&&(n=a)}k[e]=n}null!=c&&s.disposeIntermediateTensorInfo(p);const b=s.makeTensorInfo(h,p.dtype,k);if(l){const e=It({inputs:{x:b},backend:s,attrs:{shape:t.backend_util.expandShapeToKeepDim(h,d)}});return s.disposeIntermediateTensorInfo(b),e}return b}};const Ha={kernelName:t.MirrorPad,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:r}=e,{x:o}=n,{paddings:i,mode:l}=r;a(o,"mirrorPad");const d=i.map((e,t)=>e[0]+o.shape[t]+e[1]),u=i.map(e=>e[0]),c=i.map((e,t)=>e[0]+o.shape[t]),p="reflect"===l?0:1,h=s.data.get(o.dataId).values,f=o.shape.length,m=t.util.computeStrides(o.shape),k=t.util.sizeFromShape(d),g=d.length,b=t.util.computeStrides(d),I=t.util.getTypedArrayFromDType(o.dtype,k);for(let e=0;e<k;e++){let n=t.util.indexToLoc(e,g,b);for(let e=0;e<g;e++)n[e]<u[e]?n[e]=2*u[e]-n[e]-p:n[e]>=c[e]&&(n[e]=2*(c[e]-1)-n[e]+p);n=n.map((e,t)=>e-u[t]);const a=t.util.locToIndex(n,f,m);I[e]=h[a]}return{dataId:s.write(I,d,o.dtype),shape:d,dtype:o.dtype}}},Pa=l((e,t)=>{const n=e%t;return e<0&&t<0||e>=0&&t>=0?n:(n+t)%t}),Ra=b(t.Mod,Pa),Ba={kernelName:t.Mod,backendName:"cpu",kernelFunc:Ra};function $a(e){const{inputs:n,backend:a,attrs:s}=e,{logits:r}=n,{dim:o}=s,i=r.shape.length;let l=o;if(-1===l&&(l=i-1),l!==i-1)throw Error(`Softmax along a non-last dimension is not yet supported. Logits was rank ${i} and dim was ${l}`);const d=t.util.parseAxisParam([l],r.shape),u=Ma({inputs:{x:r},backend:a,attrs:{reductionIndices:d,keepDims:!1}}),c=t.backend_util.expandShapeToKeepDim(u.shape,d),p=It({inputs:{x:u},backend:a,attrs:{shape:c}}),h=Je({inputs:{a:r,b:p},backend:a}),f=P({inputs:{x:h},backend:a}),m=_n({inputs:{x:f},backend:a,attrs:{axis:d,keepDims:!1}}),k=It({inputs:{x:m},backend:a,attrs:{shape:c}}),g=Un({inputs:{a:f,b:k},backend:a});return a.disposeIntermediateTensorInfo(u),a.disposeIntermediateTensorInfo(p),a.disposeIntermediateTensorInfo(h),a.disposeIntermediateTensorInfo(f),a.disposeIntermediateTensorInfo(m),a.disposeIntermediateTensorInfo(k),g}const Ga={kernelName:t.Softmax,backendName:"cpu",kernelFunc:$a};const La={kernelName:t.Multinomial,backendName:"cpu",kernelFunc:function(e){const{inputs:s,backend:r,attrs:o}=e,{logits:i}=s,{numSamples:l,seed:d,normalized:u}=o;a(i,"multinomial");const c=u?i:$a({inputs:{logits:i},backend:r,attrs:{dim:-1}}),p=c.shape[0],h=c.shape[1],f=r.data.get(c.dataId).values,m=[p,l],k=t.util.makeZerosTypedArray(t.util.sizeFromShape(m),"int32");for(let e=0;e<p;++e){const t=e*h,a=new Float32Array(h-1);a[0]=f[t];for(let e=1;e<a.length;++e)a[e]=a[e-1]+f[t+e];const s=n.alea(d.toString()),r=e*l;for(let e=0;e<l;++e){const t=s();k[r+e]=a.length;for(let n=0;n<a.length;n++)if(t<a[n]){k[r+e]=n;break}}}return u||r.disposeIntermediateTensorInfo(c),r.makeTensorInfo(m,"int32",k)}},Va=t.kernel_impls.nonMaxSuppressionV3Impl;const qa={kernelName:t.NonMaxSuppressionV3,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{boxes:r,scores:o}=t,{maxOutputSize:i,iouThreshold:l,scoreThreshold:d}=s;a(r,"NonMaxSuppression");const u=n.data.get(r.dataId).values,c=n.data.get(o.dataId).values,{selectedIndices:p}=Va(u,c,i,l,d);return n.makeTensorInfo([p.length],"int32",new Int32Array(p))}},Oa=t.kernel_impls.nonMaxSuppressionV4Impl;const Ua={kernelName:t.NonMaxSuppressionV4,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{boxes:r,scores:o}=t,{maxOutputSize:i,iouThreshold:l,scoreThreshold:d,padToMaxOutputSize:u}=s;a(r,"NonMaxSuppressionPadded");const c=n.data.get(r.dataId).values,p=n.data.get(o.dataId).values,{selectedIndices:h,validOutputs:f}=Oa(c,p,i,l,d,u);return[n.makeTensorInfo([h.length],"int32",new Int32Array(h)),n.makeTensorInfo([],"int32",new Int32Array([f]))]}},Za=t.kernel_impls.nonMaxSuppressionV5Impl;const ja={kernelName:t.NonMaxSuppressionV5,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{boxes:r,scores:o}=t,{maxOutputSize:i,iouThreshold:l,scoreThreshold:d,softNmsSigma:u}=s;a(r,"NonMaxSuppressionWithScore");const c=n.data.get(r.dataId).values,p=n.data.get(o.dataId).values,h=i,f=l,m=d,k=u,{selectedIndices:g,selectedScores:b}=Za(c,p,h,f,m,k);return[n.makeTensorInfo([g.length],"int32",new Int32Array(g)),n.makeTensorInfo([b.length],"float32",new Float32Array(b))]}};const Ka={kernelName:t.OneHot,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:r}=e,{indices:o}=n,{depth:i,onValue:l,offValue:d}=r;a(o,"oneHot");const u=t.util.sizeFromShape(o.shape),c=new Float32Array(u*i);c.fill(d);const p=s.data.get(o.dataId).values;for(let e=0;e<u;++e)p[e]>=0&&p[e]<i&&(c[e*i+p[e]]=l);return s.makeTensorInfo([...o.shape,i],"int32",c)}};function Ya(e){const{inputs:t,backend:n}=e,{x:a}=t;if("string"===a.dtype)throw new Error("zerosLike is not supported for string tensors");if("complex64"===a.dtype){const e=f({inputs:{input:a},backend:n}),t=Ya({inputs:{x:e},backend:n}),s=an({inputs:{input:a},backend:n}),r=Ya({inputs:{x:s},backend:n}),o=d({inputs:{real:t,imag:r},backend:n});return n.disposeIntermediateTensorInfo(e),n.disposeIntermediateTensorInfo(t),n.disposeIntermediateTensorInfo(s),n.disposeIntermediateTensorInfo(r),o}return Jn({backend:n,attrs:{shape:a.shape,value:0,dtype:a.dtype}})}const Ja={kernelName:t.ZerosLike,backendName:"cpu",kernelFunc:Ya};const Qa={kernelName:t.OnesLike,backendName:"cpu",kernelFunc:function e(t){const{inputs:n,backend:a}=t,{x:s}=n;if("string"===s.dtype)throw new Error("onesLike is not supported for string tensors");if("complex64"===s.dtype){const t=f({inputs:{input:s},backend:a}),n=e({inputs:{x:t},backend:a}),r=an({inputs:{input:s},backend:a}),o=Ya({inputs:{x:r},backend:a}),i=d({inputs:{real:n,imag:o},backend:a});return a.disposeIntermediateTensorInfo(t),a.disposeIntermediateTensorInfo(n),a.disposeIntermediateTensorInfo(r),a.disposeIntermediateTensorInfo(o),i}return Jn({backend:a,attrs:{shape:s.shape,value:1,dtype:s.dtype}})}};function Xa(e){const{inputs:n,backend:a,attrs:s}=e,{axis:r}=s;if(1===n.length)return Vn({inputs:{input:n[0]},backend:a,attrs:{dim:r}});const o=n[0].shape,i=n[0].dtype;n.forEach(e=>{t.util.assertShapesMatch(o,e.shape,"All tensors passed to stack must have matching shapes"),t.util.assert(i===e.dtype,()=>"All tensors passed to stack must have matching dtypes")});const l=[],d=rn({inputs:n.map(e=>{const t=Vn({inputs:{input:e},backend:a,attrs:{dim:r}});return l.push(t),t}),backend:a,attrs:{axis:r}});return l.forEach(e=>a.disposeIntermediateTensorInfo(e)),d}const es={kernelName:t.Pack,backendName:"cpu",kernelFunc:Xa};const ts={kernelName:t.PadV2,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:r}=e,{x:o}=n,{paddings:i,constantValue:l}=r;a(o,"pad");const d=i.map((e,t)=>e[0]+o.shape[t]+e[1]),u=i.map(e=>e[0]),c=s.data.get(o.dataId).values,p=t.util.sizeFromShape(o.shape),h=o.shape.length,f=t.util.computeStrides(o.shape),m=t.util.sizeFromShape(d),k=d.length,g=t.util.computeStrides(d),b=t.util.getTypedArrayFromDType(o.dtype,m);0!==l&&b.fill(l);for(let e=0;e<p;e++){const n=t.util.indexToLoc(e,h,f).map((e,t)=>e+u[t]);b[t.util.locToIndex(n,k,g)]=c[e]}return{dataId:s.write(b,d,o.dtype),shape:d,dtype:o.dtype}}},ns=l((e,t)=>Math.pow(e,t)),as=b(t.Pow,ns),ss={kernelName:t.Pow,backendName:"cpu",kernelFunc:as};const rs={kernelName:t.Range,backendName:"cpu",kernelFunc:function(e){const{backend:t,attrs:n}=e,{start:a,stop:s,dtype:r,step:o}=n,i=De(a,s,o,r);return t.makeTensorInfo([i.length],r,i)}},os=M(t.Reciprocal,e=>1/e),is={kernelName:t.Reciprocal,backendName:"cpu",kernelFunc:os};const ls={kernelName:t.ResizeBilinear,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:r}=e,{images:o}=n,{alignCorners:i,halfPixelCenters:l,size:d}=r;a(o,"resizeBilinear");const u=t.util.computeStrides(o.shape),[c,p]=d,[h,f,m,k]=o.shape,g=s.data.get(o.dataId).values,b=new Float32Array(t.util.sizeFromShape([h,c,p,k])),I=[i&&c>1?f-1:f,i&&p>1?m-1:m],y=[i&&c>1?c-1:c,i&&p>1?p-1:p];let N=0;const T=I[0]/y[0],x=I[1]/y[1];for(let e=0;e<h;e++)for(let t=0;t<c;t++){let n;n=l?T*(t+.5)-.5:T*t;const a=Math.max(0,Math.floor(n)),s=n-a,r=Math.min(f-1,Math.ceil(n)),o=e*u[0]+a*u[1],i=e*u[0]+r*u[1];for(let e=0;e<p;e++){let t;t=l?x*(e+.5)-.5:x*e;const n=Math.max(0,Math.floor(t)),a=t-n,r=Math.min(m-1,Math.ceil(t)),d=o+n*u[2],c=i+n*u[2],p=o+r*u[2],h=i+r*u[2];for(let e=0;e<k;e++){const t=g[d+e],n=g[c+e],r=t+(g[p+e]-t)*a,o=r+(n+(g[h+e]-n)*a-r)*s;b[N++]=o}}}return s.makeTensorInfo([h,c,p,k],"float32",b)}};const ds={kernelName:t.ResizeBilinearGrad,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:r}=e,{images:o,dy:i}=n,{alignCorners:l}=r;a([i,o],"resizeBilinearGrad");const d=t.util.computeStrides(o.shape),[u,c,p,h]=o.shape,[,f,m]=i.shape,k=new Float32Array(u*c*p*h),g=[l&&f>1?c-1:c,l&&m>1?p-1:p],b=[l&&f>1?f-1:f,l&&m>1?m-1:m],I=g[0]/b[0],y=g[1]/b[1],N=s.data.get(i.dataId).values;let T=0;for(let e=0;e<u;e++){const t=e*d[0];for(let e=0;e<f;e++){const n=e*I,a=Math.floor(n),s=Math.min(Math.ceil(n),c-1),r=t+a*d[1],o=t+s*d[1],i=n-a,l=1-i;for(let e=0;e<m;e++){const t=e*y,n=Math.floor(t),a=Math.min(Math.ceil(t),p-1),s=t-n,u=1-s,c=r+n*d[2],f=r+a*d[2],m=o+n*d[2],g=o+a*d[2],b=l*u,I=l*s,x=i*u,S=i*s;for(let e=0;e<h;e++){const t=N[T++];k[c+e]+=t*b,k[f+e]+=t*I,k[m+e]+=t*x,k[g+e]+=t*S}}}}return s.makeTensorInfo([u,p,c,h],"float32",k)}};const us={kernelName:t.ResizeNearestNeighbor,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:r}=e,{images:o}=n,{alignCorners:i,halfPixelCenters:l,size:d}=r;a(o,"resizeNearestNeighbor");const u=t.util.computeStrides(o.shape),[c,p]=d,[h,f,m,k]=o.shape,g=s.data.get(o.dataId).values,b=new Float32Array(h*c*p*k),I=[i&&c>1?f-1:f,i&&p>1?m-1:m],y=[i&&c>1?c-1:c,i&&p>1?p-1:p],N=I[0]/y[0],T=I[1]/y[1];let x=0;for(let e=0;e<h;e++){const t=e*u[0];for(let e=0;e<c;e++){const n=l?N*(e+.5):N*e;let a=Math.min(f-1,i?Math.round(n):Math.floor(n));l&&(a=Math.max(0,a));const s=t+a*u[1];for(let e=0;e<p;e++){const t=l?T*(e+.5):T*e;let n=Math.min(m-1,i?Math.round(t):Math.floor(t));l&&(n=Math.max(0,n));const a=s+n*u[2];for(let e=0;e<k;e++){const t=g[a+e];b[x++]=t}}}}return s.makeTensorInfo([h,c,p,k],o.dtype,b)}};const cs={kernelName:t.ResizeNearestNeighborGrad,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:r}=e,{images:o,dy:i}=n,{alignCorners:l}=r;a([i,o],"resizeNearestNeighborGrad");const d=t.util.computeStrides(o.shape),u=t.util.computeStrides(i.shape),[c,p,h,f]=o.shape,[,m,k]=i.shape,g=new Float32Array(c*p*h*f),b=s.data.get(i.dataId).values,I=[l&&m>1?p-1:p,l&&k>1?h-1:h],y=[l&&m>1?m-1:m,l&&k>1?k-1:k],N=I[0]/y[0],T=I[1]/y[1],x=1/N,S=1/T,v=2*Math.ceil(x)+2,F=2*Math.ceil(S)+2;for(let e=0;e<c;e++){const t=e*d[0];for(let e=0;e<p;e++){const n=t+e*d[1],a=Math.floor(e*x),s=Math.floor(a-v/2);for(let a=0;a<h;a++){const r=n+a*d[2],o=Math.floor(a*S),i=Math.floor(o-F/2);for(let n=0;n<f;n++){let o=0;for(let r=0;r<v;r++){const d=r+s;if(d<0||d>=m)continue;const c=t+d*u[1],f=d*N;if(e===Math.min(p-1,l?Math.round(f):Math.floor(f)))for(let e=0;e<F;e++){const t=e+i;if(t<0||t>=k)continue;const s=c+t*u[2],r=t*T;a===Math.min(h-1,l?Math.round(r):Math.floor(r))&&(o+=b[s+n])}}g[r+n]=o}}}}return s.makeTensorInfo(o.shape,o.dtype,g)}};const ps={kernelName:t.Reverse,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:r}=e,{x:o}=n,{dims:i}=r;a(o,"reverse");const l=o.shape.length,d=t.util.parseAxisParam(i,o.shape);if(0===l)return p({inputs:{x:o},backend:s});const u=new t.TensorBuffer(o.shape,o.dtype),c=s.bufferSync(o);for(let e=0;e<u.size;e++){const t=u.indexToLoc(e),n=t.slice();d.forEach(e=>n[e]=o.shape[e]-1-n[e]),u.set(c.get(...n),...t)}return s.makeTensorInfo(u.shape,u.dtype,u.values)}},hs={kernelName:t.RotateWithOffset,backendName:"cpu",kernelFunc:({inputs:e,attrs:n,backend:a})=>{const{image:s}=e,{radians:r,fillValue:o,center:i}=n,l=a,d=t.util.getTypedArrayFromDType(s.dtype,t.util.sizeFromShape(s.shape)),[u,c,p,h]=s.shape,[f,m]=t.backend_util.getImageCenter(i,c,p),k=Math.sin(r),g=Math.cos(r),b=l.data.get(s.dataId).values;for(let e=0;e<u;e++){const t=e*p*c*h;for(let e=0;e<c;e++){const n=e*(p*h);for(let a=0;a<p;a++){const s=a*h;for(let r=0;r<h;r++){const i=[u,e,a,r],l=i[2],I=i[1];let y=(l-f)*g-(I-m)*k,N=(l-f)*k+(I-m)*g;y=Math.round(y+f),N=Math.round(N+m);let T=o;if("number"!=typeof o&&(T=3===r?255:o[r]),y>=0&&y<p&&N>=0&&N<c){T=b[t+N*(p*h)+y*h+r]}d[t+n+s+r]=T}}}}return{dataId:l.write(d,s.shape,s.dtype),shape:s.shape,dtype:s.dtype}}},fs=M(t.Round,e=>{const t=Math.floor(e);return e-t<.5?Math.floor(e):e-t>.5?Math.ceil(e):t%2==0?t:t+1}),ms={kernelName:t.Round,backendName:"cpu",kernelFunc:fs};function ks(e,n,a,s,r,o,i,l,d,u){const c=[s/r,r],p=e.values,h=n.values;if(0===s)return t.buffer(a,n.dtype);const f=t.buffer(c,n.dtype);f.values.fill(d);for(let e=0;e<o;e++){const t=[];let o=0;for(let n=0;n<i;n++){const a=p[e*i+n];t.push(a),o+=a*l[n]}if(o<0||o>=s/r)throw new Error(`Invalid indices: ${t} does not index into ${a}`);for(let t=0;t<r;t++)u?f.values[o*r+t]+=h[e*r+t]:f.values[o*r+t]=0===n.rank?h[0]:h[e*r+t]}return f}const gs={kernelName:t.ScatterNd,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{indices:r,updates:o}=n,{shape:i}=s,{sliceRank:l,numUpdates:d,sliceSize:u,strides:c,outputSize:p}=t.backend_util.calculateShapes(o,r,i),h=ks(a.bufferSync(r),a.bufferSync(o),i,p,u,d,l,c,0,!0);return a.makeTensorInfo(i,h.dtype,h.values)}};const bs={kernelName:t.Select,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s}=e,{condition:r,t:o,e:i}=n;a([r,o,i],"select");const l=r.shape.length,d=s.data.get(r.dataId).values,u=s.data.get(o.dataId).values,c=s.data.get(i.dataId).values,p=t.upcastType(o.dtype,i.dtype),h=t.util.makeZerosTypedArray(t.util.sizeFromShape(o.shape),p);let f=0;const m=0===l||l>1||1===o.shape.length?1:t.util.sizeFromShape(o.shape.slice(1));for(let e=0;e<d.length;e++)for(let t=0;t<m;t++)1===d[e]?h[f++]=u[e]:h[f++]=c[e];return s.makeTensorInfo(o.shape,p,h)}},Is=t.backend_util.SELU_SCALEALPHA,ys=t.backend_util.SELU_SCALE,Ns=M(t.Selu,e=>e>=0?ys*e:Is*(Math.exp(e)-1)),Ts={kernelName:t.Selu,backendName:"cpu",kernelFunc:Ns},xs=M(t.Sign,e=>e<0?-1:e>0?1:0),Ss={kernelName:t.Sign,backendName:"cpu",kernelFunc:xs},vs=M(t.Sin,e=>Math.sin(e)),Fs={kernelName:t.Sin,backendName:"cpu",kernelFunc:vs},Ms=M(t.Sinh,e=>Math.sinh(e)),As={kernelName:t.Sinh,backendName:"cpu",kernelFunc:Ms},ws=Math.log(1.1920928955078125e-7)+2,Ds=M(t.Softplus,e=>{const t=e>-ws,n=e<ws,a=Math.exp(e);let s;return s=n?a:t?e:Math.log(1+a),s}),_s={kernelName:t.Softplus,backendName:"cpu",kernelFunc:Ds};const zs={kernelName:t.SpaceToBatchND,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:r}=e,{x:o}=n,{blockShape:i,paddings:l}=r;a([o],"spaceToBatchND");const d=t.util.sizeFromShape(i),u=[[0,0]];u.push(...l);for(let e=1+i.length;e<o.shape.length;++e)u.push([0,0]);const c=ts.kernelFunc({inputs:{x:o},backend:s,attrs:{paddings:u,constantValue:0}}),p=t.backend_util.getReshaped(c.shape,i,d,!1),h=t.backend_util.getPermuted(p.length,i.length,!1),f=t.backend_util.getReshapedPermuted(c.shape,i,d,!1),m=It({inputs:{x:c},backend:s,attrs:{shape:p}}),k=Fe({inputs:{x:m},backend:s,attrs:{perm:h}}),g=It({inputs:{x:k},backend:s,attrs:{shape:f}});return s.disposeIntermediateTensorInfo(c),s.disposeIntermediateTensorInfo(m),s.disposeIntermediateTensorInfo(k),g}};const Es={kernelName:t.SparseFillEmptyRows,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{indices:a,values:s,denseShape:r,defaultValue:o}=t;if(1!==r.shape.length)throw new Error("Dense shape must be a vector, saw:\n        "+r.shape);if(2!==a.shape.length)throw new Error("Indices must be a matrix, saw:\n        "+a.shape);if(1!==s.shape.length)throw new Error("Values must be a vector, saw:\n        "+s.shape);if(0!==o.shape.length)throw new Error("Default value must be a scalar, saw:\n        "+o.shape);const i=n.data.get(a.dataId).values,l=n.data.get(s.dataId).values,d=n.data.get(r.dataId).values,u=n.data.get(o.dataId).values[0],[c,p,h,f,m]=Pe(i,a.shape,a.dtype,l,s.dtype,d,u);return[n.makeTensorInfo(p,a.dtype,c),n.makeTensorInfo([p[0]],s.dtype,h),n.makeTensorInfo([f.length],"bool",new Uint8Array(f.map(e=>Number(e)))),n.makeTensorInfo([m.length],a.dtype,new Int32Array(m))]}};const Ws={kernelName:t.SparseReshape,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{inputIndices:a,inputShape:s,newShape:r}=t;if(2!==a.shape.length)throw new Error("Input indices should be a matrix but received shape\n        "+a.shape);if(1!==s.shape.length)throw new Error("Input shape should be a vector but received shape\n        "+s.shape);if(1!==r.shape.length)throw new Error("Target shape should be a vector but received shape "+r.shape);const o=Array.from(n.data.get(s.dataId).values),i=n.data.get(a.dataId).values,l=Array.from(n.data.get(r.dataId).values),[d,u,c]=Re(i,a.shape,a.dtype,o,l);return[n.makeTensorInfo(u,a.dtype,d),n.makeTensorInfo([c.length],r.dtype,new Int32Array(c))]}};const Cs={kernelName:t.SparseSegmentMean,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{data:a,indices:s,segmentIds:r}=t;if(a.shape.length<1)throw new Error("Data should be at least 1 dimensional but received scalar");if(1!==s.shape.length)throw new Error("Indices should be a vector but received shape\n          "+s.shape);if(1!==r.shape.length)throw new Error("Segment ids should be a vector but received shape\n          "+r.shape);const o=n.data.get(a.dataId).values,i=n.data.get(s.dataId).values,l=n.data.get(r.dataId).values,[d,u]=Be(o,a.shape,a.dtype,i,l,!0);return n.makeTensorInfo(u,a.dtype,d)}};const Hs={kernelName:t.SparseSegmentSum,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{data:a,indices:s,segmentIds:r}=t;if(a.shape.length<1)throw new Error("Data should be at least 1 dimensional but received scalar");if(1!==s.shape.length)throw new Error("Indices should be a vector but received shape\n         "+s.shape);if(1!==r.shape.length)throw new Error("Segment ids should be a vector but received shape\n         "+r.shape);const o=n.data.get(a.dataId).values,i=n.data.get(s.dataId).values,l=n.data.get(r.dataId).values,[d,u]=Be(o,a.shape,a.dtype,i,l);return n.makeTensorInfo(u,a.dtype,d)}};const Ps={kernelName:t.SparseToDense,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{sparseIndices:r,sparseValues:o,defaultValue:i}=n,{outputShape:l}=s,{sliceRank:d,numUpdates:u,sliceSize:c,strides:p,outputSize:h}=t.backend_util.calculateShapes(o,r,l),f=ks(a.bufferSync(r),a.bufferSync(o),l,h,c,u,d,p,a.data.get(i.dataId).values[0],!1);return a.makeTensorInfo(l,f.dtype,f.values)}};const Rs={kernelName:t.SplitV,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{x:r}=n,{numOrSizeSplits:o,axis:i}=s,l=t.util.parseAxisParam(i,r.shape)[0],d=t.backend_util.prepareSplitSize(r,o,l),u=new Array(r.shape.length).fill(0),c=r.shape.slice();return d.map(e=>{const t=[...c];t[l]=e;const n=Ce({inputs:{x:r},backend:a,attrs:{begin:u,size:t}});return u[l]+=e,n})}},Bs=M(t.Sqrt,e=>Math.sqrt(e)),$s={kernelName:t.Sqrt,backendName:"cpu",kernelFunc:Bs},Gs={kernelName:t.Square,backendName:"cpu",kernelFunc:({inputs:e,backend:t})=>{const{x:n}=e,s=t;a(n,"square");const r=s.data.get(n.dataId).values,o=new Float32Array(r.length);for(let e=0;e<r.length;++e){const t=r[e];o[e]=t*t}return{dataId:s.write(o,n.shape,n.dtype),shape:n.shape,dtype:n.dtype}}},Ls=M(t.Step,(e,t)=>{const n=t;return isNaN(e)?NaN:e>0?1:n.alpha}),Vs={kernelName:t.Step,backendName:"cpu",kernelFunc:Ls};const qs={kernelName:t.StridedSlice,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:r}=e,{x:o}=n,{begin:i,end:l,strides:d,beginMask:u,endMask:c,ellipsisMask:p,newAxisMask:h,shrinkAxisMask:f}=r;a(o,"stridedSlice");const{nonStrided:m,$begin:k,$strides:g,size:b,newShape:I,outShape:y}=t.slice_util.sliceInfo(o.shape,i,l,d,u,c,p,h,f),N=It({inputs:{x:o},backend:s,attrs:{shape:I}});let T;if(m){const e=Ce({inputs:{x:N},backend:s,attrs:{begin:k,size:b}});T=It({inputs:{x:e},backend:s,attrs:{shape:y}}),s.disposeIntermediateTensorInfo(e)}else if(y.some(e=>0===e))T=s.makeTensorInfo(y,o.dtype,[]);else{const e=Ve(y,s.bufferSync(N),g,k);T=s.makeTensorInfo(e.shape,e.dtype,e.values)}const x=It({inputs:{x:T},backend:s,attrs:{shape:y}});return s.disposeIntermediateTensorInfo(N),s.disposeIntermediateTensorInfo(T),x}};const Os={kernelName:t.StringNGrams,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{separator:s,nGramWidths:r,leftPad:o,rightPad:i,padWidth:l,preserveShortSequences:d}=a,{data:u,dataSplits:c}=t,p=n.data.get(u.dataId).values,h=n.data.get(c.dataId).values,[f,m]=Oe(p,h,s,r,o,i,l,d);return[n.makeTensorInfo([f.length],"string",f),n.makeTensorInfo(c.shape,"int32",m)]}};const Us={kernelName:t.StringSplit,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{skipEmpty:s}=a,{input:r,delimiter:o}=t;if("string"!==r.dtype)throw new Error("Input must be of datatype string");if(1!==r.shape.length)throw new Error("Input must be a vector, got shape: "+r.shape);if(0!==o.shape.length)throw new Error("Delimiter must be a scalar, got shape: "+o.shape);const i=n.data.get(r.dataId).values,l=n.data.get(o.dataId).values[0],[d,u,c]=Ze(i,l,s),p=u.length;return[n.makeTensorInfo([p,2],"int32",d),n.makeTensorInfo([p],"string",u),n.makeTensorInfo([2],"int32",new Int32Array(c))]}};const Zs={kernelName:t.StringToHashBucketFast,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{numBuckets:s}=a,{input:r}=t;if("string"!==r.dtype)throw new Error("Input must be of datatype string");if(s<=0)throw new Error("Number of buckets must be at least 1");const o=je(n.data.get(r.dataId).values,s);return n.makeTensorInfo(r.shape,"int32",o)}},js=M(t.Tan,e=>Math.tan(e)),Ks={kernelName:t.Tan,backendName:"cpu",kernelFunc:js},Ys=M(t.Tanh,e=>Math.tanh(e)),Js={kernelName:t.Tanh,backendName:"cpu",kernelFunc:Ys};const Qs={kernelName:t.Tile,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{reps:o}=s;a(r,"tile");const i=Xe(n.bufferSync(r),o);return n.makeTensorInfo(i.shape,i.dtype,i.values)}};const Xs={kernelName:t.TopK,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{k:o,sorted:i}=s;a(r,"topk");const l=n.data.get(r.dataId).values,[d,u]=nt(l,r.shape,r.dtype,o,i);return[n.makeTensorInfo(d.shape,d.dtype,d.values),n.makeTensorInfo(u.shape,u.dtype,u.values)]}};const er={kernelName:t.Transform,backendName:"cpu",kernelFunc:function(e){const{inputs:n,attrs:a,backend:s}=e,{image:r,transforms:o}=n,{interpolation:i,fillMode:l,fillValue:d,outputShape:u}=a,[c,p,h,f]=r.shape,[m,k]=null!=u?u:[p,h],g=[c,m,k,f],b=t.util.computeStrides(r.shape),I=b[0],y=b[1],N=b[2],T=t.util.getTypedArrayFromDType(r.dtype,t.util.sizeFromShape(g));T.fill(d);const x=s.data.get(r.dataId).values,S=s.data.get(o.dataId).values;for(let e=0;e<c;++e){const t=1===o.shape[0]?S:S.subarray(8*e,8*e+8);for(let n=0;n<m;++n)for(let a=0;a<k;++a)for(let s=0;s<f;++s){let r;const o=t[6]*a+t[7]*n+1;if(0===o)continue;const u=(t[0]*a+t[1]*n+t[2])/o,c=(t[3]*a+t[4]*n+t[5])/o,f=tr(u,h,l),m=tr(c,p,l);switch(i){case"nearest":r=ar(x,p,h,I,y,N,e,m,f,s,d);break;case"bilinear":r=sr(x,p,h,I,y,N,e,m,f,s,d);break;default:throw new Error("Error in Transform: Expect 'nearest' or 'bilinear', but got "+i)}T[e*I+n*y+a*N+s]=r}return s.makeTensorInfo(g,r.dtype,T)}return{dataId:s.write(T,g,r.dtype),shape:r.shape,dtype:r.dtype}}};function tr(e,n,a){switch(a){case"reflect":return function(e,n){let a=e;if(a<0)if(n<=1)a=0;else{const e=2*n;a<e&&(a=e*Math.trunc(-a/e)+a),a=a<-n?a+e:-a-1}else if(a>n-1)if(n<=1)a=0;else{const e=2*n;a-=e*Math.trunc(a/e),a>=n&&(a=e-a-1)}return t.util.clamp(0,a,n-1)}(e,n);case"wrap":return function(e,n){let a=e;if(a<0)if(n<=1)a=0;else{const e=n-1;a+=n*(Math.trunc(-a/e)+1)}else if(a>n-1)if(n<=1)a=0;else{const e=n-1;a-=n*Math.trunc(a/e)}return t.util.clamp(0,a,n-1)}(e,n);case"nearest":return function(e,n){return t.util.clamp(0,e,n-1)}(e,n);case"constant":default:return function(e,t){return e}(e)}}function nr(e,t,n,a,s,r,o,i,l,d,u){return 0<=i&&i<t&&0<=l&&l<n?e[o*a+i*s+l*r+d]:u}function ar(e,t,n,a,s,r,o,i,l,d,u){return nr(e,t,n,a,s,r,o,Math.round(i),Math.round(l),d,u)}function sr(e,t,n,a,s,r,o,i,l,d,u){const c=Math.floor(i),p=Math.floor(l),h=c+1,f=p+1;return(h-i)*((f-l)*nr(e,t,n,a,s,r,o,c,p,d,u)+(l-p)*nr(e,t,n,a,s,r,o,c,f,d,u))+(i-c)*((f-l)*nr(e,t,n,a,s,r,o,h,p,d,u)+(l-p)*nr(e,t,n,a,s,r,o,h,f,d,u))}const rr={kernelName:t.Unique,backendName:"cpu",kernelFunc:function(e){const{inputs:t,attrs:n,backend:s}=e,{axis:r}=n,{x:o}=t;a(o,"unique");const i=s.data.get(o.dataId).values,{outputValues:l,outputShape:d,indices:u}=at(i,r,o.shape,o.dtype);return[s.makeTensorInfo(d,o.dtype,l),s.makeTensorInfo([u.length],"int32",u)]}};const or={kernelName:t.Unpack,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{value:s}=t;let{axis:r}=a;r<0&&(r+=s.shape.length);const o=s.shape.length,i=s.shape[r],l=new Array(o-1);let d=0;for(let e=0;e<o;e++)e!==r&&(l[d++]=s.shape[e]);const u=new Array(o).fill(0),c=s.shape.slice();c[r]=1;const p=new Array(i);for(let e=0;e<p.length;e++){u[r]=e;const t=Ce({inputs:{x:s},backend:n,attrs:{begin:u,size:c}});p[e]=It({inputs:{x:t},backend:n,attrs:{shape:l}}),n.disposeIntermediateTensorInfo(t)}return p}};const ir={kernelName:t.UnsortedSegmentSum,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:s,attrs:r}=e,{x:o,segmentIds:i}=n,{numSegments:l}=r;a(o,"unsortedSegmentSum");const d=[],u=[],c=o.shape.length-i.shape.length;let p=i;for(let e=0;e<c;++e){const t=Vn({inputs:{input:p},backend:s,attrs:{dim:e+1}});p=t,u.push(t)}for(let e=0;e<l;++e){const n=t.util.createScalarValue(e,"int32"),a=s.makeTensorInfo([],"int32",n),r=W({inputs:{a:a,b:p},backend:s}),i=k({inputs:{x:r},backend:s,attrs:{dtype:"float32"}}),l=be({inputs:{a:i,b:o},backend:s}),c=_n({inputs:{x:l},backend:s,attrs:{axis:0,keepDims:!1}});d.push(c),u.push(a),u.push(r),u.push(i),u.push(l),u.push(c)}const h=Xa({inputs:d,backend:s,attrs:{axis:0}});return u.forEach(e=>s.disposeIntermediateTensorInfo(e)),h}},lr=[xt,i,vt,Mt,x,At,wt,Dt,_t,zt,Wt,Ht,Rt,Gt,Vt,Zt,jt,Kt,Yt,Tt,Jt,Qt,Xt,g,_,tn,u,nn,on,un,cn,dn,hn,fn,pn,kn,bn,In,yn,Nn,Tn,Sn,vn,Fn,Mn,An,Dn,wn,Zn,En,ot,Wn,C,Ln,R,qn,G,Yn,Qn,Xn,q,na,aa,sa,ra,oa,K,Q,h,ia,sn,da,ca,ha,lt,te,se,fa,le,ka,Ia,Na,Sa,va,Fa,pe,wa,Da,_a,za,Ea,Aa,Wa,Ca,me,Ha,Ba,La,Ie,Ne,qa,Ua,ja,Se,Ka,Qa,es,ts,ss,ct,we,rs,m,is,ht,mt,yt,ls,ds,us,cs,ps,hs,ms,Ee,gs,bs,Ts,gt,Ss,Fs,As,He,Ga,_s,zs,Es,Ws,Cs,Hs,Ps,Rs,$s,Gs,Le,Vs,qs,Os,Us,Zs,Qe,zn,Ks,Js,Qs,Xs,Me,er,rr,or,ir,Ja];for(const e of lr)t.registerKernel(e);e.MathBackendCPU=r,e.shared=st,e.version_cpu="3.8.0",Object.defineProperty(e,"__esModule",{value:!0})}));
//# sourceMappingURL=tf-backend-cpu.es2017.min.js.map
