/**
 * @license
 * Copyright 2017 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
import { GPGPUProgram } from './gpgpu_math';
export declare const INT_DIV = "\n  float s = sign(a) * sign(b);\n  int ia = round(a);\n  int ib = round(b);\n  if (ib != 0) {\n    // Windows (D3D) wants guaranteed non-zero int division at compile-time.\n    return float(idiv(ia, ib, s));\n  } else {\n    return NAN;\n  }\n";
export declare const POW = "\nif(a < 0.0 && floor(b) < b){\n  return NAN;\n}\nif (b == 0.0) {\n  return 1.0;\n}\nreturn (round(mod(b, 2.0)) != 1) ?\n    pow(abs(a), b) : sign(a) * pow(abs(a), b);\n";
export declare const SQUARED_DIFFERENCE = "return (a - b) * (a - b);";
export declare const EQUAL = "return float(a == b);";
export declare const LESS = "return float(a < b);";
export declare const LESS_EQUAL = "return float(a <= b);";
export declare const GREATER = "return float(a > b);";
export declare const GREATER_EQUAL = "return float(a >= b);";
export declare const LOGICAL_AND = "return float(a >= 1.0 && b >= 1.0);";
export declare const LOGICAL_OR = "return float(a >= 1.0 || b >= 1.0);";
export declare const MAX: string;
export declare const MIN: string;
export declare const MOD = "if (b == 0.0) return NAN;\n  return mod(a, b);";
export declare const ELU_DER = "return (b >= 1.0) ? a : a * (b + 1.0);";
export declare const PRELU = "return (a < 0.) ? b * a : a;";
export declare class BinaryOpProgram implements GPGPUProgram {
    variableNames: string[];
    outputShape: number[];
    userCode: string;
    constructor(op: string, aShape: number[], bShape: number[]);
}
