/**
 * @license
 * Copyright 2020 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports,require("@tensorflow/tfjs-core")):"function"==typeof define&&define.amd?define(["exports","@tensorflow/tfjs-core"],t):t((e=e||self).tf=e.tf||{},e.tf)}(this,(function(e,t){"use strict";const n={},r={alpha:!1,antialias:!1,premultipliedAlpha:!1,preserveDrawingBuffer:!1,depth:!1,stencil:!1,failIfMajorPerformanceCaveat:!0};function o(e,t){n[e]=t}function i(e){if(!(e in n)){const t=function(e){if(1!==e&&2!==e)throw new Error("Cannot get WebGL rendering context, WebGL is disabled.");const t=function(e){if("undefined"!=typeof OffscreenCanvas&&2===e)return new OffscreenCanvas(300,150);if("undefined"!=typeof document)return document.createElement("canvas");throw new Error("Cannot create a canvas in this context")}(e);if(t.addEventListener("webglcontextlost",t=>{t.preventDefault(),delete n[e]},!1),1===e)return t.getContext("webgl",r)||t.getContext("experimental-webgl",r);return t.getContext("webgl2",r)}(e);if(null===t)return console.log("Could not get context for WebGL version",e),null;n[e]=t}const t=n[e];return t.isContextLost()?(delete n[e],i(e)):(t.disable(t.DEPTH_TEST),t.disable(t.STENCIL_TEST),t.disable(t.BLEND),t.disable(t.DITHER),t.disable(t.POLYGON_OFFSET_FILL),t.disable(t.SAMPLE_COVERAGE),t.enable(t.SCISSOR_TEST),t.enable(t.CULL_FACE),t.cullFace(t.BACK),n[e])}var a,s,u;function l(e,t){return[t,e]}function c(e){const n=t.util.sizeFromShape(e),r=Math.ceil(n/4);return t.util.sizeToSquarishShape(r)}function d(e,t){return[Math.max(1,Math.ceil(t/2)),Math.max(1,Math.ceil(e/2))]}function h(e,n){const r=e;let o,i,a,s,u,l,c,d,h,p;return 2===t.env().getNumber("WEBGL_VERSION")?(o=r.R32F,i=r.R16F,a=r.RGBA16F,s=r.RGBA32F,u=r.RED,c=4,d=1,h=r.HALF_FLOAT,p=r.FLOAT):(o=e.RGBA,i=e.RGBA,a=e.RGBA,s=r.RGBA,u=e.RGBA,c=4,d=4,h=null!=n?n.HALF_FLOAT_OES:null,p=e.FLOAT),l=e.RGBA,{internalFormatFloat:o,internalFormatHalfFloat:i,internalFormatPackedHalfFloat:a,internalFormatPackedFloat:s,textureFormatFloat:u,downloadTextureFormat:l,downloadUnpackNumChannels:c,defaultNumChannels:d,textureTypeHalfFloat:h,textureTypeFloat:p}}function p(e,n){const r=n();return t.env().getBool("DEBUG")&&function(e){const t=e.getError();if(t!==e.NO_ERROR)throw new Error("WebGL Error: "+x(e,t))}(e),r}!function(e){e[e.DENSE=0]="DENSE",e[e.SHARED_BATCH=1]="SHARED_BATCH"}(a||(a={})),function(e){e[e.RENDER=0]="RENDER",e[e.UPLOAD=1]="UPLOAD",e[e.PIXELS=2]="PIXELS",e[e.DOWNLOAD=3]="DOWNLOAD"}(s||(s={})),function(e){e[e.UNPACKED_FLOAT16=0]="UNPACKED_FLOAT16",e[e.UNPACKED_FLOAT32=1]="UNPACKED_FLOAT32",e[e.PACKED_4X1_UNSIGNED_BYTE=2]="PACKED_4X1_UNSIGNED_BYTE",e[e.PACKED_2X2_FLOAT32=3]="PACKED_2X2_FLOAT32",e[e.PACKED_2X2_FLOAT16=4]="PACKED_2X2_FLOAT16"}(u||(u={}));function f(e){return!!(t.env().getBool("WEBGL_RENDER_FLOAT32_ENABLED")||0===e||5.96e-8<Math.abs(e)&&Math.abs(e)<65504)}function x(e,t){switch(t){case e.NO_ERROR:return"NO_ERROR";case e.INVALID_ENUM:return"INVALID_ENUM";case e.INVALID_VALUE:return"INVALID_VALUE";case e.INVALID_OPERATION:return"INVALID_OPERATION";case e.INVALID_FRAMEBUFFER_OPERATION:return"INVALID_FRAMEBUFFER_OPERATION";case e.OUT_OF_MEMORY:return"OUT_OF_MEMORY";case e.CONTEXT_LOST_WEBGL:return"CONTEXT_LOST_WEBGL";default:return`Unknown error code ${t}`}}function g(e,t){return L(e,()=>e.getExtension(t),'Extension "'+t+'" not supported on this browser.')}function m(e,t){const n=L(e,()=>e.createShader(e.VERTEX_SHADER),"Unable to create vertex WebGLShader.");if(p(e,()=>e.shaderSource(n,t)),p(e,()=>e.compileShader(n)),!1===e.getShaderParameter(n,e.COMPILE_STATUS))throw console.log(e.getShaderInfoLog(n)),new Error("Failed to compile vertex shader.");return n}function C(e,n){const r=L(e,()=>e.createShader(e.FRAGMENT_SHADER),"Unable to create fragment WebGLShader.");if(p(e,()=>e.shaderSource(r,n)),p(e,()=>e.compileShader(r)),!1===e.getShaderParameter(r,e.COMPILE_STATUS))throw function(e,n){const r=v.exec(n);if(null==r)return console.log(`Couldn't parse line number in error: ${n}`),void console.log(e);const o=+r[1],i=e.split("\n"),a=i.length.toString().length+2,s=i.map((e,n)=>t.util.rightPad((n+1).toString(),a)+e);let u=0;for(let e=0;e<s.length;e++)u=Math.max(s[e].length,u);const l=s.slice(0,o-1),c=s.slice(o-1,o),d=s.slice(o);console.log(l.join("\n")),console.log(n.split("\n")[0]),console.log(`%c ${t.util.rightPad(c[0],u)}`,"border:1px solid red; background-color:#e3d2d2; color:#a61717"),console.log(d.join("\n"))}(n,e.getShaderInfoLog(r)),new Error("Failed to compile fragment shader.");return r}const v=/ERROR: [0-9]+:([0-9]+):/g;function $(e){return L(e,()=>e.createProgram(),"Unable to create WebGLProgram.")}function R(e,t){if(p(e,()=>e.linkProgram(t)),!1===e.getProgramParameter(t,e.LINK_STATUS))throw console.log(e.getProgramInfoLog(t)),new Error("Failed to link vertex and fragment shaders.")}function b(e,t){if(p(e,()=>e.validateProgram(t)),!1===e.getProgramParameter(t,e.VALIDATE_STATUS))throw console.log(e.getProgramInfoLog(t)),new Error("Shader program validation failed.")}function w(e,t){const n=L(e,()=>e.createBuffer(),"Unable to create WebGLBuffer");return p(e,()=>e.bindBuffer(e.ARRAY_BUFFER,n)),p(e,()=>e.bufferData(e.ARRAY_BUFFER,t,e.STATIC_DRAW)),n}function y(e,t){const n=L(e,()=>e.createBuffer(),"Unable to create WebGLBuffer");return p(e,()=>e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,n)),p(e,()=>e.bufferData(e.ELEMENT_ARRAY_BUFFER,t,e.STATIC_DRAW)),n}function I(e){return L(e,()=>e.createTexture(),"Unable to create WebGLTexture.")}function E(e,n){const r=t.env().getNumber("WEBGL_MAX_TEXTURE_SIZE");if(e<=0||n<=0){throw new Error("Requested texture size "+`[${e}x${n}]`+" is invalid.")}if(e>r||n>r){throw new Error("Requested texture size "+`[${e}x${n}]`+" greater than WebGL maximum on this browser / GPU "+`[${r}x${r}]`+".")}}function A(e){return L(e,()=>e.createFramebuffer(),"Unable to create WebGLFramebuffer.")}function T(e,t,n,r,o,i,a){const s=e.getAttribLocation(t,n);return-1!==s&&(p(e,()=>e.bindBuffer(e.ARRAY_BUFFER,r)),p(e,()=>e.vertexAttribPointer(s,o,e.FLOAT,!1,i,a)),p(e,()=>e.enableVertexAttribArray(s)),!0)}function O(e,t,n){B(e,n),p(e,()=>e.activeTexture(e.TEXTURE0+n)),p(e,()=>e.bindTexture(e.TEXTURE_2D,t))}function _(e,t,n){return L(e,()=>e.getUniformLocation(t,n),'uniform "'+n+'" not present in program.')}function S(e,t,n){return e.getUniformLocation(t,n)}function N(e,t,n,r){p(e,()=>O(e,t,r)),p(e,()=>e.uniform1i(n,r))}function F(e,t,n){p(e,()=>e.bindFramebuffer(e.FRAMEBUFFER,n)),p(e,()=>e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,t,0))}function k(e,t){p(e,()=>e.bindFramebuffer(e.FRAMEBUFFER,t)),p(e,()=>e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,null,0))}function D(e){const t=e.checkFramebufferStatus(e.FRAMEBUFFER);if(t!==e.FRAMEBUFFER_COMPLETE)throw new Error("Error binding framebuffer: "+P(e,t))}function P(e,t){switch(t){case e.FRAMEBUFFER_INCOMPLETE_ATTACHMENT:return"FRAMEBUFFER_INCOMPLETE_ATTACHMENT";case e.FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:return"FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT";case e.FRAMEBUFFER_INCOMPLETE_DIMENSIONS:return"FRAMEBUFFER_INCOMPLETE_DIMENSIONS";case e.FRAMEBUFFER_UNSUPPORTED:return"FRAMEBUFFER_UNSUPPORTED";default:return`unknown error ${t}`}}function L(e,t,n){const r=p(e,()=>t());if(null==r)throw new Error(n);return r}function B(e,t){const n=e.MAX_COMBINED_TEXTURE_IMAGE_UNITS-1,r=t+e.TEXTURE0;if(r<e.TEXTURE0||r>n){throw new Error(`textureUnit must be in ${`[gl.TEXTURE0, gl.TEXTURE${n}]`}.`)}}function V(e,n=2){return t.util.sizeFromShape(e.slice(0,e.length-n))}function M(e){if(0===e.length)throw Error("Cannot get rows and columns of an empty shape array.");return[e.length>1?e[e.length-2]:1,e[e.length-1]]}function W(e){let t=[1,1,1];return 0===e.length||1===e.length&&1===e[0]||(t=[V(e),...M(e)]),t}function U(e,n=!1){let r=t.env().getNumber("WEBGL_MAX_TEXTURE_SIZE");if(n&&(r*=2,1===(e=e.map((n,r)=>r>=e.length-2?t.util.nearestLargerEven(e[r]):e[r])).length&&(e=[2,e[0]])),2!==e.length){const n=t.util.squeezeShape(e);e=n.newShape}let o=t.util.sizeFromShape(e);if(e.length<=1&&o<=r)return[1,o];if(2===e.length&&e[0]<=r&&e[1]<=r)return e;if(3===e.length&&e[0]*e[1]<=r&&e[2]<=r)return[e[0]*e[1],e[2]];if(3===e.length&&e[0]<=r&&e[1]*e[2]<=r)return[e[0],e[1]*e[2]];if(4===e.length&&e[0]*e[1]*e[2]<=r&&e[3]<=r)return[e[0]*e[1]*e[2],e[3]];if(4===e.length&&e[0]<=r&&e[1]*e[2]*e[3]<=r)return[e[0],e[1]*e[2]*e[3]];if(n){const n=V(e);let r=2,i=2;return e.length&&([r,i]=M(e)),o=n*(r/2)*(i/2),t.util.sizeToSquarishShape(o).map(e=>2*e)}return t.util.sizeToSquarishShape(o)}function G(e){return e%2==0}function z(e,n){if(e=e.slice(-2),n=n.slice(-2),t.util.arraysEqual(e,n))return!0;if(!e.length||!n.length)return!0;if(0===e[0]||0===e[1]||0===n[0]||0===n[1])return!0;if(e.length!==n.length){const t=e.slice(-1)[0],r=n.slice(-1)[0];if(t===r)return!0;if(G(t)&&G(r)&&(1===e[0]||1===n[0]))return!0}return e[1]===n[1]&&G(e[0])&&G(n[0])}let X,H;function j(e){if(null==X){const t=i(e);X=t.getParameter(t.MAX_TEXTURE_SIZE)}return X}function K(e){if(null==H){const t=i(e);H=t.getParameter(t.MAX_TEXTURE_IMAGE_UNITS)}return Math.min(16,H)}function q(e){if(0===e)return 0;let t;const n=i(e);return t=Y(n,"EXT_disjoint_timer_query_webgl2")&&2===e?2:Y(n,"EXT_disjoint_timer_query")?1:0,t}function Y(e,t){return null!=e.getExtension(t)}function Q(e){try{if(null!=i(e))return!0}catch(e){return console.log("Error when getting WebGL context: ",e),!1}return!1}function Z(e){if(0===e)return!1;const t=i(e);if(1===e){if(!Y(t,"OES_texture_float"))return!1}else if(!Y(t,"EXT_color_buffer_float"))return!1;return ee(t)}function J(e){if(0===e)return!1;const t=i(e);if(1!==e){if(Y(t,"EXT_color_buffer_float"))return ee(t);const e="EXT_color_buffer_half_float";if(Y(t,e)){const n=t.getExtension(e);return function(e,t){const n=h(e,t),r=e.createTexture();e.bindTexture(e.TEXTURE_2D,r);e.texImage2D(e.TEXTURE_2D,0,n.internalFormatHalfFloat,1,1,0,n.textureFormatFloat,n.textureTypeHalfFloat,null);const o=e.createFramebuffer();e.bindFramebuffer(e.FRAMEBUFFER,o),e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,r,0);const i=e.checkFramebufferStatus(e.FRAMEBUFFER)===e.FRAMEBUFFER_COMPLETE;return e.bindTexture(e.TEXTURE_2D,null),e.bindFramebuffer(e.FRAMEBUFFER,null),e.deleteTexture(r),e.deleteFramebuffer(o),i}(t,n)}return!1}return!!Y(t,"OES_texture_float")&&(!!Y(t,"WEBGL_color_buffer_float")&&ee(t))}function ee(e){const t=h(e),n=e.createTexture();e.bindTexture(e.TEXTURE_2D,n);e.texImage2D(e.TEXTURE_2D,0,t.internalFormatFloat,1,1,0,t.textureFormatFloat,t.textureTypeFloat,null);const r=e.createFramebuffer();e.bindFramebuffer(e.FRAMEBUFFER,r),e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,n,0);const o=e.checkFramebufferStatus(e.FRAMEBUFFER)===e.FRAMEBUFFER_COMPLETE;return e.bindTexture(e.TEXTURE_2D,null),e.bindFramebuffer(e.FRAMEBUFFER,null),e.deleteTexture(n),e.deleteFramebuffer(r),o}function te(e){if(2!==e)return!1;return null!=i(e).fenceSync}function ne(e,n){Array.isArray(e)||(e=[e]),e.forEach(e=>{null!=e&&t.util.assert("complex64"!==e.dtype,()=>`${n} does not support complex64 tensors `+"in the WebGL backend.")})}var re=Object.freeze({__proto__:null,callAndCheck:p,canBeRepresented:f,getWebGLErrorMessage:x,getExtensionOrThrow:g,createVertexShader:m,createFragmentShader:C,createProgram:$,linkProgram:R,validateProgram:b,createStaticVertexBuffer:w,createStaticIndexBuffer:y,getNumChannels:function(){return 2===t.env().getNumber("WEBGL_VERSION")?1:4},createTexture:I,validateTextureSize:E,createFramebuffer:A,bindVertexBufferToProgramAttribute:T,bindTextureUnit:O,unbindTextureUnit:function(e,t){B(e,t),p(e,()=>e.activeTexture(e.TEXTURE0+t)),p(e,()=>e.bindTexture(e.TEXTURE_2D,null))},getProgramUniformLocationOrThrow:_,getProgramUniformLocation:S,bindTextureToProgramUniformSampler:N,bindCanvasToFramebuffer:function(e){p(e,()=>e.bindFramebuffer(e.FRAMEBUFFER,null)),p(e,()=>e.viewport(0,0,e.canvas.width,e.canvas.height)),p(e,()=>e.scissor(0,0,e.canvas.width,e.canvas.height))},bindColorTextureToFramebuffer:F,unbindColorTextureFromFramebuffer:k,validateFramebuffer:D,getFramebufferErrorMessage:P,getBatchDim:V,getRowsCols:M,getShapeAs3D:W,getTextureShapeFromLogicalShape:U,isReshapeFree:z,getWebGLMaxTextureSize:j,resetMaxTextureSize:function(){X=null},resetMaxTexturesInShader:function(){H=null},getMaxTexturesInShader:K,getWebGLDisjointQueryTimerVersion:q,hasExtension:Y,isWebGLVersionEnabled:Q,isCapableOfRenderingToFloatTexture:Z,isDownloadFloatTextureEnabled:J,isWebGLFenceEnabled:te,assertNotComplex:ne});const oe=t.env();function ie(e){return(n,r,o,i,a)=>{const s=t.backend_util.assertAndGetBroadcastShape(n,r),u=s.length,l=t.util.computeStrides(s),c=t.util.sizeFromShape(s),d=t.util.getTypedArrayFromDType(a,c),h=n.length,p=r.length,f=t.util.computeStrides(n),x=t.util.computeStrides(r),g=t.backend_util.getBroadcastDims(n,s),m=t.backend_util.getBroadcastDims(r,s);if(g.length+m.length===0)for(let t=0;t<d.length;++t)d[t]=e(o[t%o.length],i[t%i.length]);else for(let n=0;n<d.length;++n){const r=t.util.indexToLoc(n,u,l),a=r.slice(-h);g.forEach(e=>a[e]=0);const s=t.util.locToIndex(a,h,f),c=r.slice(-p);m.forEach(e=>c[e]=0);const C=t.util.locToIndex(c,p,x);d[n]=e(o[s],i[C])}return[d,s]}}oe.registerFlag("HAS_WEBGL",()=>oe.getNumber("WEBGL_VERSION")>0),oe.registerFlag("WEBGL_VERSION",()=>Q(2)?2:Q(1)?1:0),oe.registerFlag("WEBGL_CHECK_NUMERICAL_PROBLEMS",()=>!1),oe.registerFlag("WEBGL_BUFFER_SUPPORTED",()=>2===oe.get("WEBGL_VERSION")),oe.registerFlag("WEBGL_CPU_FORWARD",()=>!0),oe.registerFlag("WEBGL_FORCE_F16_TEXTURES",()=>!1),oe.registerFlag("WEBGL_PACK",()=>oe.getBool("HAS_WEBGL")),oe.registerFlag("WEBGL_PACK_NORMALIZATION",()=>oe.getBool("WEBGL_PACK")),oe.registerFlag("WEBGL_PACK_CLIP",()=>oe.getBool("WEBGL_PACK")),oe.registerFlag("WEBGL_PACK_DEPTHWISECONV",()=>!1),oe.registerFlag("WEBGL_PACK_BINARY_OPERATIONS",()=>oe.getBool("WEBGL_PACK")),oe.registerFlag("WEBGL_PACK_UNARY_OPERATIONS",()=>oe.getBool("WEBGL_PACK")),oe.registerFlag("WEBGL_PACK_ARRAY_OPERATIONS",()=>oe.getBool("WEBGL_PACK")),oe.registerFlag("WEBGL_PACK_IMAGE_OPERATIONS",()=>oe.getBool("WEBGL_PACK")),oe.registerFlag("WEBGL_PACK_REDUCE",()=>oe.getBool("WEBGL_PACK")),oe.registerFlag("WEBGL_LAZILY_UNPACK",()=>oe.getBool("WEBGL_PACK")),oe.registerFlag("WEBGL_CONV_IM2COL",()=>oe.getBool("WEBGL_PACK")),oe.registerFlag("WEBGL_MAX_TEXTURE_SIZE",()=>j(oe.getNumber("WEBGL_VERSION"))),oe.registerFlag("WEBGL_MAX_TEXTURES_IN_SHADER",()=>K(oe.getNumber("WEBGL_VERSION"))),oe.registerFlag("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION",()=>{const e=oe.getNumber("WEBGL_VERSION");return 0===e?0:q(e)}),oe.registerFlag("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE",()=>oe.getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION")>0&&!t.device_util.isMobile()),oe.registerFlag("WEBGL_RENDER_FLOAT32_CAPABLE",()=>Z(oe.getNumber("WEBGL_VERSION"))),oe.registerFlag("WEBGL_RENDER_FLOAT32_ENABLED",()=>!oe.getBool("WEBGL_FORCE_F16_TEXTURES")&&oe.getBool("WEBGL_RENDER_FLOAT32_CAPABLE")),oe.registerFlag("WEBGL_DOWNLOAD_FLOAT_ENABLED",()=>J(oe.getNumber("WEBGL_VERSION"))),oe.registerFlag("WEBGL_FENCE_API_ENABLED",()=>te(oe.getNumber("WEBGL_VERSION"))),oe.registerFlag("WEBGL_SIZE_UPLOAD_UNIFORM",()=>oe.getBool("WEBGL_RENDER_FLOAT32_ENABLED")?4:0),oe.registerFlag("WEBGL_DELETE_TEXTURE_THRESHOLD",()=>-1,e=>{if(e<0&&-1!==e)throw new Error("WEBGL_DELETE_TEXTURE_THRESHOLD must be -1 (indicating never "+`delete) or at least 0, but got ${e}.`)});const ae=ie((e,t)=>e+t);function se(e){return(n,r,o)=>{const i=t.util.getTypedArrayFromDType(r,n.length);for(let t=0;t<n.length;++t)i[t]=e(n[t],o);return i}}const ue=se(e=>Math.ceil(e)),le=se(e=>Math.exp(e)),ce=se(e=>Math.expm1(e)),de=se(e=>Math.floor(e)),he=se(e=>Math.log(e));const pe=ie((e,t)=>e*t),fe=ie((e,t)=>e!==t?1:0),xe=se(e=>1/Math.sqrt(e));const ge=ie((e,t)=>{const n=e-t;return n*n}),me=ie((e,t)=>e-t);var Ce=Object.freeze({__proto__:null,simpleAbsImpl:function(e){const t=new Float32Array(e.length);for(let n=0;n<e.length;++n)t[n]=Math.abs(e[n]);return t},addImpl:ae,ceilImpl:ue,expImpl:le,expm1Impl:ce,floorImpl:de,logImpl:he,maxImpl:function(e,n,r,o){const i=t.util.getTypedArrayFromDType(o,t.util.sizeFromShape(r));for(let t=0;t<i.length;++t){const r=t*n;let o=e[r];for(let t=0;t<n;++t){const n=e[r+t];n>o&&(o=n)}i[t]=o}return i},multiplyImpl:pe,notEqualImpl:fe,rsqrtImpl:xe,sliceImpl:function(e,n,r,o,i){const a=t.slice_util.isSliceContinous(o,n,r),s=t.util.sizeFromShape(r),u=t.util.computeStrides(o);if(a){const r=t.slice_util.computeFlatOffset(n,u);return e.subarray(r,r+s)}const l=t.util.getTypedArrayFromDType(i,s);for(let i=0;i<s;++i){const a=r.length,s=t.util.computeStrides(r),c=t.util.indexToLoc(i,a,s).map((e,t)=>e+n[t]),d=t.util.locToIndex(c,o.length,u);l[i]=e[d]}return l},squaredDifferenceImpl:ge,subImpl:me,transposeImpl:function(e,n,r,o,i){const a=n.length,s=t.util.sizeFromShape(n),u=t.util.computeStrides(n),l=t.util.computeStrides(i),c=t.util.getTypedArrayFromDType(r,t.util.sizeFromShape(i));for(let n=0;n<s;++n){const r=t.util.indexToLoc(n,a,u),i=new Array(r.length);for(let e=0;e<i.length;e++)i[e]=r[o[e]];c[t.util.locToIndex(i,a,l)]=e[n]}return c},uniqueImpl:function(e,n,r,o){const i=t.util.parseAxisParam(n,r)[0],a=[1,r[0],1];for(let e=0;e<i;e++)a[0]*=r[e];a[1]=r[i];for(let e=i+1;e<r.length;e++)a[2]*=r[e];const s={},u=new Int32Array(r[i]),l=new t.TensorBuffer(a,o,e),c=[],d=1===a[0]&&1===a[2];for(let t=0;t<r[i];t++){let n;if(d)n=e[t].toString();else{const e=[];for(let n=0;n<a[0];n++)for(let r=0;r<a[2];r++)e.push(l.get(n,t,r));n=e.join(",")}if(void 0!==s[n])u[t]=s[n];else{const e=Object.keys(s).length;s[n]=e,u[t]=e,c.push(t)}}const h=a.slice();h[1]=Object.keys(s).length;const p=new t.TensorBuffer(h,o);c.forEach((e,t)=>{for(let n=0;n<a[0];n++)for(let r=0;r<a[2];r++)p.set(l.get(n,e,r),n,t,r)});const f=r.slice();return f[i]=h[1],{outputValues:p.values,outputShape:f,indices:u}}});const{simpleAbsImpl:ve,addImpl:$e,ceilImpl:Re,expImpl:be,expm1Impl:we,floorImpl:ye,logImpl:Ie,maxImpl:Ee,multiplyImpl:Ae,rsqrtImpl:Te,sliceImpl:Oe,subImpl:_e,transposeImpl:Se,uniqueImpl:Ne}=Ce;class Fe{constructor(e,t){this.outputShape=[],this.outputShape=e,this.variableNames=t.map((e,t)=>`T${t}`);const n=[];this.variableNames.forEach(e=>{n.push(`float v${e} = get${e}AtOutCoords();`)});const r=this.variableNames.map(e=>`v${e}`).join(" + ");this.userCode=`\n      void main() {\n        ${n.join("\n        ")}\n\n        float result = ${r};\n        setOutput(result);\n      }\n    `}}class ke{constructor(e,t){this.outputShape=[],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=e,this.variableNames=t.map((e,t)=>`T${t}`);const n=[];this.variableNames.forEach(e=>{n.push(`vec4 v${e} = get${e}AtOutCoords();`)});const r=this.variableNames.map(e=>`v${e}`).join(" + ");this.userCode=`\n      void main() {\n        ${n.join("\n        ")}\n\n        vec4 result = ${r};\n        setOutput(result);\n      }\n    `}}class De{constructor(e,t,n){this.variableNames=["A"];const{windowSize:r,batchSize:o,outSize:i}=e;n||this.variableNames.push("bestIndicesA"),this.outputShape=[o,i];const a="max"===t?">":"<",s=n?"inOffset + i;":"round(getBestIndicesA(batch, inOffset + i));";this.userCode=`\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int batch = coords[0];\n        int outIdx = coords[1];\n        int inOffset = outIdx * ${r};\n\n        int bestIndex = inOffset;\n        float bestValue = getA(batch, bestIndex);\n\n        for (int i = 0; i < ${r}; i++) {\n          int inIdx = ${s};\n          float candidate = getA(batch, inIdx);\n          if (candidate ${a} bestValue) {\n            bestValue = candidate;\n            bestIndex = inIdx;\n          }\n        }\n        setOutput(float(bestIndex));\n      }\n    `}}function Pe(e,t){return["x","y","z","w","u","v"].slice(0,t).map(t=>`${e}.${t}`)}function Le(e,t){return 1===t?[e]:Pe(e,t)}function Be(){let e,n,r,o,i,a,s,u,l,c;return 2===t.env().getNumber("WEBGL_VERSION")?(e="#version 300 es",n="in",r="out",o="in",i="texture",a="outputColor",s="out vec4 outputColor;",u="\n      bool isnan_custom(float val) {\n        return (val > 0.0 || val < 0.0) ? false : val != 0.0;\n      }\n\n      bvec4 isnan_custom(vec4 val) {\n        return bvec4(isnan_custom(val.x),\n          isnan_custom(val.y), isnan_custom(val.z), isnan_custom(val.w));\n      }\n\n      #define isnan(value) isnan_custom(value)\n    ",l="",c="\n      #define round(value) newRound(value)\n      int newRound(float value) {\n        return int(floor(value + 0.5));\n      }\n\n      ivec4 newRound(vec4 value) {\n        return ivec4(floor(value + vec4(0.5)));\n      }\n    "):(e="",n="attribute",r="varying",o="varying",i="texture2D",a="gl_FragColor",s="",u="\n      #define isnan(value) isnan_custom(value)\n      bool isnan_custom(float val) {\n        return (val > 0. || val < 1. || val == 0.) ? false : true;\n      }\n      bvec4 isnan_custom(vec4 val) {\n        return bvec4(isnan(val.x), isnan(val.y), isnan(val.z), isnan(val.w));\n      }\n    ",l="\n      uniform float INFINITY;\n\n      bool isinf(float val) {\n        return abs(val) == INFINITY;\n      }\n      bvec4 isinf(vec4 val) {\n        return equal(abs(val), vec4(INFINITY));\n      }\n    ",c="\n      int round(float value) {\n        return int(floor(value + 0.5));\n      }\n\n      ivec4 round(vec4 value) {\n        return ivec4(floor(value + vec4(0.5)));\n      }\n    "),{version:e,attribute:n,varyingVs:r,varyingFs:o,texture2D:i,output:a,defineOutput:s,defineSpecialNaN:u,defineSpecialInf:l,defineRound:c}}function Ve(e,n,r="index"){const o=t.util.computeStrides(n);return o.map((t,n)=>`${`int ${e[n]} = ${r} / ${t}`}; ${n===o.length-1?`int ${e[n+1]} = ${r} - ${e[n]} * ${t}`:`index -= ${e[n]} * ${t}`};`).join("")}function Me(e){const n=t.util.computeStrides(e).map(e=>e.toString());return`\n  int getFlatIndex(ivec3 coords) {\n    return coords.x * ${n[0]} + coords.y * ${n[1]} + coords.z;\n  }\n`}const We="\n  const float FLOAT_MAX = 1.70141184e38;\n  const float FLOAT_MIN = 1.17549435e-38;\n\n  lowp vec4 encode_float(highp float v) {\n    if (isnan(v)) {\n      return vec4(255, 255, 255, 255);\n    }\n\n    highp float av = abs(v);\n\n    if(av < FLOAT_MIN) {\n      return vec4(0.0, 0.0, 0.0, 0.0);\n    } else if(v > FLOAT_MAX) {\n      return vec4(0.0, 0.0, 128.0, 127.0) / 255.0;\n    } else if(v < -FLOAT_MAX) {\n      return vec4(0.0, 0.0,  128.0, 255.0) / 255.0;\n    }\n\n    highp vec4 c = vec4(0,0,0,0);\n\n    highp float e = floor(log2(av));\n    highp float m = exp2(fract(log2(av))) - 1.0;\n\n    c[2] = floor(128.0 * m);\n    m -= c[2] / 128.0;\n    c[1] = floor(32768.0 * m);\n    m -= c[1] / 32768.0;\n    c[0] = floor(8388608.0 * m);\n\n    highp float ebias = e + 127.0;\n    c[3] = floor(ebias / 2.0);\n    ebias -= c[3] * 2.0;\n    c[2] += floor(ebias) * 128.0;\n\n    c[3] += 128.0 * step(0.0, -v);\n\n    return c / 255.0;\n  }\n",{getBroadcastDims:Ue}=t.backend_util;function Ge(e,n,r,o){const i=[];e.forEach(e=>{const n=t.util.sizeFromShape(e.shapeInfo.logicalShape);e.shapeInfo.isUniform?i.push(`uniform float ${e.name}${n>1?`[${n}]`:""};`):(i.push(`uniform sampler2D ${e.name};`),i.push(`uniform int offset${e.name};`))});const a=i.join("\n"),s=e.map(e=>function(e,n,r=!1){let o="";o+=r?Xe(e):ze(e);const i=e.shapeInfo.logicalShape,a=n.logicalShape;i.length<=a.length&&(o+=r?function(e,n){const r=e.name,o=r.charAt(0).toUpperCase()+r.slice(1),i="get"+o+"AtOutCoords",a=e.shapeInfo.logicalShape.length,s=n.logicalShape.length,u=Ue(e.shapeInfo.logicalShape,n.logicalShape),l=Je(s),c=s-a;let d;const h=["x","y","z","w","u","v"];d=0===a?"":s<2&&u.length>=1?"coords = 0;":u.map(e=>`coords.${h[e+c]} = 0;`).join("\n");let p="";p=s<2&&a>0?"coords":e.shapeInfo.logicalShape.map((e,t)=>`coords.${h[t+c]}`).join(", ");let f="return outputValue;";const x=1===t.util.sizeFromShape(e.shapeInfo.logicalShape),g=1===t.util.sizeFromShape(n.logicalShape);if(1!==a||x||g){if(x&&!g)f=1===s?"\n        return vec4(outputValue.x, outputValue.x, 0., 0.);\n      ":"\n        return vec4(outputValue.x);\n      ";else if(u.length){const e=a-2,t=a-1;u.indexOf(e)>-1&&u.indexOf(t)>-1?f="return vec4(outputValue.x);":u.indexOf(e)>-1?f="return vec4(outputValue.x, outputValue.y, outputValue.x, outputValue.y);":u.indexOf(t)>-1&&(f="return vec4(outputValue.xx, outputValue.zz);")}}else f="\n      return vec4(outputValue.xy, outputValue.xy);\n    ";return`\n    vec4 ${i}() {\n      ${l} coords = getOutputCoords();\n      ${d}\n      vec4 outputValue = get${o}(${p});\n      ${f}\n    }\n  `}(e,n):function(e,n){const r=e.name,o=r.charAt(0).toUpperCase()+r.slice(1),i="get"+o+"AtOutCoords",a=n.texShape,s=e.shapeInfo.texShape,u=e.shapeInfo.logicalShape.length,l=n.logicalShape.length;if(!e.shapeInfo.isUniform&&u===l&&null==e.shapeInfo.flatOffset&&t.util.arraysEqual(s,a))return`\n      float ${i}() {\n        return sampleTexture(${r}, resultUV);\n      }\n    `;const c=Je(l),d=Ue(e.shapeInfo.logicalShape,n.logicalShape),h=l-u;let p;const f=["x","y","z","w","u","v"];p=0===u?"":l<2&&d.length>=1?"coords = 0;":d.map(e=>`coords.${f[e+h]} = 0;`).join("\n");let x="";x=l<2&&u>0?"coords":e.shapeInfo.logicalShape.map((e,t)=>`coords.${f[t+h]}`).join(", ");return`\n    float ${i}() {\n      ${c} coords = getOutputCoords();\n      ${p}\n      return get${o}(${x});\n    }\n  `}(e,n));return o}(e,n,o)).join("\n"),u=n.texShape,l=Be(),c=function(e){return`\n    float sampleTexture(sampler2D textureSampler, vec2 uv) {\n      return ${e.texture2D}(textureSampler, uv).r;\n    }\n  `}(l);let d,h,p=function(e){return`${e.version}\n    precision highp float;\n    precision highp int;\n    precision highp sampler2D;\n    ${e.varyingFs} vec2 resultUV;\n    ${e.defineOutput}\n    const vec2 halfCR = vec2(0.5, 0.5);\n\n    struct ivec5\n    {\n      int x;\n      int y;\n      int z;\n      int w;\n      int u;\n    };\n\n    struct ivec6\n    {\n      int x;\n      int y;\n      int z;\n      int w;\n      int u;\n      int v;\n    };\n\n    uniform float NAN;\n    ${e.defineSpecialNaN}\n    ${e.defineSpecialInf}\n    ${e.defineRound}\n\n    int imod(int x, int y) {\n      return x - y * (x / y);\n    }\n\n    int idiv(int a, int b, float sign) {\n      int res = a / b;\n      int mod = imod(a, b);\n      if (sign < 0. && mod != 0) {\n        res -= 1;\n      }\n      return res;\n    }\n\n    //Based on the work of Dave Hoskins\n    //https://www.shadertoy.com/view/4djSRW\n    #define HASHSCALE1 443.8975\n    float random(float seed){\n      vec2 p = resultUV * seed;\n      vec3 p3  = fract(vec3(p.xyx) * HASHSCALE1);\n      p3 += dot(p3, p3.yzx + 19.19);\n      return fract((p3.x + p3.y) * p3.z);\n    }\n\n    ${He}\n    ${je}\n    ${Ke}\n  `}(l);return n.isPacked?(d=function(e,n){switch(e.length){case 0:return Ye();case 1:return function(e,t){const n=[Math.ceil(t[0]/2),Math.ceil(t[1]/2)];if(1===n[0])return`\n      int getOutputCoords() {\n        return 2 * int(resultUV.x * ${n[1]}.0);\n      }\n    `;if(1===n[1])return`\n      int getOutputCoords() {\n        return 2 * int(resultUV.y * ${n[0]}.0);\n      }\n    `;return`\n    int getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${n[0]}, ${n[1]}));\n      return 2 * (resTexRC.x * ${n[1]} + resTexRC.y);\n    }\n  `}(0,n);case 2:return function(e,n){const r=[Math.ceil(n[0]/2),Math.ceil(n[1]/2)];if(t.util.arraysEqual(e,n))return`\n      ivec2 getOutputCoords() {\n        return 2 * ivec2(resultUV.yx * vec2(${r[0]}, ${r[1]}));\n      }\n    `;const o=Math.ceil(e[1]/2);return`\n    ivec2 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${r[0]}, ${r[1]}));\n\n      int index = resTexRC.x * ${r[1]} + resTexRC.y;\n      int r = 2 * (index / ${o});\n      int c = imod(index, ${o}) * 2;\n\n      return ivec2(r, c);\n    }\n  `}(e,n);case 3:return function(e,t){const n=[Math.ceil(t[0]/2),Math.ceil(t[1]/2)],r=Math.ceil(e[2]/2),o=r*Math.ceil(e[1]/2);return`\n    ivec3 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${n[0]}, ${n[1]}));\n      int index = resTexRC.x * ${n[1]} + resTexRC.y;\n\n      int b = index / ${o};\n      index -= b * ${o};\n\n      int r = 2 * (index / ${r});\n      int c = imod(index, ${r}) * 2;\n\n      return ivec3(b, r, c);\n    }\n  `}(e,n);default:return function(e,t){const n=[Math.ceil(t[0]/2),Math.ceil(t[1]/2)],r=Math.ceil(e[e.length-1]/2),o=r*Math.ceil(e[e.length-2]/2);let i=o,a="",s="b, r, c";for(let t=2;t<e.length-1;t++)i*=e[e.length-t-1],a=`\n      int b${t} = index / ${i};\n      index -= b${t} * ${i};\n    `+a,s=`b${t}, `+s;return`\n    ivec${e.length} getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${n[0]}, ${n[1]}));\n      int index = resTexRC.x * ${n[1]} + resTexRC.y;\n\n      ${a}\n\n      int b = index / ${o};\n      index -= b * ${o};\n\n      int r = 2 * (index / ${r});\n      int c = imod(index, ${r}) * 2;\n\n      return ivec${e.length}(${s});\n    }\n  `}(e,n)}}(n.logicalShape,u),h=function(e){return`\n    void setOutput(vec4 val) {\n      ${e.output} = val;\n    }\n  `}(l)):(d=function(e,n){switch(e.length){case 0:return Ye();case 1:return function(e,t){if(1===t[0])return`\n      int getOutputCoords() {\n        return int(resultUV.x * ${t[1]}.0);\n      }\n    `;if(1===t[1])return`\n      int getOutputCoords() {\n        return int(resultUV.y * ${t[0]}.0);\n      }\n    `;return`\n    int getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${t[0]}, ${t[1]}));\n      return resTexRC.x * ${t[1]} + resTexRC.y;\n    }\n  `}(0,n);case 2:return function(e,n){if(t.util.arraysEqual(e,n))return`\n      ivec2 getOutputCoords() {\n        return ivec2(resultUV.yx * vec2(${n[0]}, ${n[1]}));\n      }\n    `;if(1===e[1])return`\n      ivec2 getOutputCoords() {\n        ivec2 resTexRC = ivec2(resultUV.yx *\n                               vec2(${n[0]}, ${n[1]}));\n        int index = resTexRC.x * ${n[1]} + resTexRC.y;\n        return ivec2(index, 0);\n      }\n    `;if(1===e[0])return`\n      ivec2 getOutputCoords() {\n        ivec2 resTexRC = ivec2(resultUV.yx *\n                               vec2(${n[0]}, ${n[1]}));\n        int index = resTexRC.x * ${n[1]} + resTexRC.y;\n        return ivec2(0, index);\n      }\n    `;return`\n    ivec2 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${n[0]}, ${n[1]}));\n      int index = resTexRC.x * ${n[1]} + resTexRC.y;\n      int r = index / ${e[1]};\n      int c = index - r * ${e[1]};\n      return ivec2(r, c);\n    }\n  `}(e,n);case 3:return function(e,t){const n=Ve(["r","c","d"],e);return`\n    ivec3 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${t[0]}, ${t[1]}));\n      int index = resTexRC.x * ${t[1]} + resTexRC.y;\n      ${n}\n      return ivec3(r, c, d);\n    }\n  `}(e,n);case 4:return function(e,t){const n=Ve(["r","c","d","d2"],e);return`\n    ivec4 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n        vec2(${t[0]}, ${t[1]}));\n      int index = resTexRC.x * ${t[1]} + resTexRC.y;\n      ${n}\n      return ivec4(r, c, d, d2);\n    }\n  `}(e,n);case 5:return function(e,t){const n=Ve(["r","c","d","d2","d3"],e);return`\n    ivec5 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx * vec2(${t[0]},\n                             ${t[1]}));\n\n      int index = resTexRC.x * ${t[1]} + resTexRC.y;\n\n      ${n}\n\n      ivec5 outShape = ivec5(r, c, d, d2, d3);\n      return outShape;\n    }\n  `}(e,n);case 6:return function(e,t){const n=Ve(["r","c","d","d2","d3","d4"],e);return`\n    ivec6 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n        vec2(${t[0]}, ${t[1]}));\n      int index = resTexRC.x * ${t[1]} + resTexRC.y;\n\n      ${n}\n\n      ivec6 result = ivec6(r, c, d, d2, d3, d4);\n      return result;\n    }\n  `}(e,n);default:throw new Error(`${e.length}-D output sampling is not yet supported`)}}(n.logicalShape,u),h=function(e){return`\n    void setOutput(float val) {\n      ${e.output} = vec4(val, 0, 0, 0);\n    }\n  `}(l)),o&&(p+=qe),[p,c,h,a,d,s,r].join("\n")}function ze(e){const n=e.shapeInfo.logicalShape;switch(n.length){case 0:return function(e){const t=e.name,n="get"+t.charAt(0).toUpperCase()+t.slice(1);if(e.shapeInfo.isUniform)return`float ${n}() {return ${t};}`;const[r,o]=e.shapeInfo.texShape;if(1===r&&1===o)return`\n      float ${n}() {\n        return sampleTexture(${t}, halfCR);\n      }\n    `;const[i,a]=e.shapeInfo.texShape,s=Qe(t);return`\n    float ${n}() {\n      vec2 uv = uvFromFlat(${i}, ${a}, ${s});\n      return sampleTexture(${t}, uv);\n    }\n  `}(e);case 1:return function(e){const t=e.name,n="get"+t.charAt(0).toUpperCase()+t.slice(1);if(e.shapeInfo.isUniform)return`\n      float ${n}(int index) {\n        ${Ze(e)}\n      }\n    `;const r=e.shapeInfo.texShape,o=r[0],i=r[1];if(1===i&&1===o)return`\n      float ${n}(int index) {\n        return sampleTexture(${t}, halfCR);\n      }\n    `;const a=Qe(t);if(1===i)return`\n      float ${n}(int index) {\n        vec2 uv = vec2(0.5, (float(index + ${a}) + 0.5) / ${o}.0);\n        return sampleTexture(${t}, uv);\n      }\n    `;if(1===o)return`\n      float ${n}(int index) {\n        vec2 uv = vec2((float(index + ${a}) + 0.5) / ${i}.0, 0.5);\n        return sampleTexture(${t}, uv);\n      }\n    `;return`\n    float ${n}(int index) {\n      vec2 uv = uvFromFlat(${o}, ${i}, index + ${a});\n      return sampleTexture(${t}, uv);\n    }\n  `}(e);case 2:return function(e){const n=e.shapeInfo.logicalShape,r=e.name,o="get"+r.charAt(0).toUpperCase()+r.slice(1),i=e.shapeInfo.texShape;if(null!=i&&t.util.arraysEqual(n,i)){const e=i[0],t=i[1];return`\n    float ${o}(int row, int col) {\n      vec2 uv = (vec2(col, row) + halfCR) / vec2(${t}.0, ${e}.0);\n      return sampleTexture(${r}, uv);\n    }\n  `}const{newShape:a,keptDims:s}=t.util.squeezeShape(n),u=a;if(u.length<n.length){const t=et(e,u),n=["row","col"];return`\n      ${ze(t)}\n      float ${o}(int row, int col) {\n        return ${o}(${tt(n,s)});\n      }\n    `}if(e.shapeInfo.isUniform)return`\n      float ${o}(int row, int col) {\n        int index = round(dot(vec2(row, col), vec2(${n[1]}, 1)));\n        ${Ze(e)}\n      }\n    `;const l=i[0],c=i[1],d=Qe(r);if(1===c)return`\n    float ${o}(int row, int col) {\n      float index = dot(vec3(row, col, ${d}), vec3(${n[1]}, 1, 1));\n      vec2 uv = vec2(0.5, (index + 0.5) / ${l}.0);\n      return sampleTexture(${r}, uv);\n    }\n  `;if(1===l)return`\n    float ${o}(int row, int col) {\n      float index = dot(vec3(row, col, ${d}), vec3(${n[1]}, 1, 1));\n      vec2 uv = vec2((index + 0.5) / ${c}.0, 0.5);\n      return sampleTexture(${r}, uv);\n    }\n  `;return`\n  float ${o}(int row, int col) {\n    // Explicitly use integer operations as dot() only works on floats.\n    int index = row * ${n[1]} + col + ${d};\n    vec2 uv = uvFromFlat(${l}, ${c}, index);\n    return sampleTexture(${r}, uv);\n  }\n`}(e);case 3:return function(e){const n=e.shapeInfo.logicalShape,r=e.name,o="get"+r.charAt(0).toUpperCase()+r.slice(1),i=n[1]*n[2],a=n[2],{newShape:s,keptDims:u}=t.util.squeezeShape(n),l=s;if(l.length<n.length){const t=et(e,l),n=["row","col","depth"];return`\n        ${ze(t)}\n        float ${o}(int row, int col, int depth) {\n          return ${o}(${tt(n,u)});\n        }\n      `}if(e.shapeInfo.isUniform)return`\n      float ${o}(int row, int col, int depth) {\n        int index = round(dot(vec3(row, col, depth),\n                          vec3(${i}, ${a}, 1)));\n        ${Ze(e)}\n      }\n    `;const c=e.shapeInfo.texShape,d=c[0],h=c[1],p=e.shapeInfo.flatOffset;if(h===i&&null==p)return`\n        float ${o}(int row, int col, int depth) {\n          float texR = float(row);\n          float texC = dot(vec2(col, depth), vec2(${a}, 1));\n          vec2 uv = (vec2(texC, texR) + halfCR) /\n                     vec2(${h}.0, ${d}.0);\n          return sampleTexture(${r}, uv);\n        }\n      `;if(h===a&&null==p)return`\n    float ${o}(int row, int col, int depth) {\n      float texR = dot(vec2(row, col), vec2(${n[1]}, 1));\n      float texC = float(depth);\n      vec2 uv = (vec2(texC, texR) + halfCR) / vec2(${h}.0, ${d}.0);\n      return sampleTexture(${r}, uv);\n    }\n  `;const f=Qe(r);return`\n      float ${o}(int row, int col, int depth) {\n        // Explicitly use integer operations as dot() only works on floats.\n        int index = row * ${i} + col * ${a} + depth + ${f};\n        vec2 uv = uvFromFlat(${d}, ${h}, index);\n        return sampleTexture(${r}, uv);\n      }\n  `}(e);case 4:return function(e){const n=e.shapeInfo.logicalShape,r=e.name,o="get"+r.charAt(0).toUpperCase()+r.slice(1),i=n[3],a=n[2]*i,s=n[1]*a,{newShape:u,keptDims:l}=t.util.squeezeShape(n);if(u.length<n.length){const t=et(e,u),n=["row","col","depth","depth2"];return`\n      ${ze(t)}\n      float ${o}(int row, int col, int depth, int depth2) {\n        return ${o}(${tt(n,l)});\n      }\n    `}if(e.shapeInfo.isUniform)return`\n      float ${o}(int row, int col, int depth, int depth2) {\n        int index = round(dot(vec4(row, col, depth, depth2),\n                          vec4(${s}, ${a}, ${i}, 1)));\n        ${Ze(e)}\n      }\n    `;const c=e.shapeInfo.flatOffset,d=e.shapeInfo.texShape,h=d[0],p=d[1];if(p===s&&null==c)return`\n      float ${o}(int row, int col, int depth, int depth2) {\n        float texR = float(row);\n        float texC =\n            dot(vec3(col, depth, depth2),\n                vec3(${a}, ${i}, 1));\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                   vec2(${p}.0, ${h}.0);\n        return sampleTexture(${r}, uv);\n      }\n    `;if(p===i&&null==c)return`\n      float ${o}(int row, int col, int depth, int depth2) {\n        float texR = dot(vec3(row, col, depth),\n                         vec3(${n[1]*n[2]}, ${n[2]}, 1));\n        float texC = float(depth2);\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                  vec2(${p}.0, ${h}.0);\n        return sampleTexture(${r}, uv);\n      }\n    `;const f=Qe(r);return`\n    float ${o}(int row, int col, int depth, int depth2) {\n      // Explicitly use integer operations as dot() only works on floats.\n      int index = row * ${s} + col * ${a} +\n          depth * ${i} + depth2;\n      vec2 uv = uvFromFlat(${h}, ${p}, index + ${f});\n      return sampleTexture(${r}, uv);\n    }\n  `}(e);case 5:return function(e){const n=e.shapeInfo.logicalShape,r=e.name,o="get"+r.charAt(0).toUpperCase()+r.slice(1),i=n[4],a=n[3]*i,s=n[2]*a,u=n[1]*s,{newShape:l,keptDims:c}=t.util.squeezeShape(n);if(l.length<n.length){const t=et(e,l),n=["row","col","depth","depth2","depth3"];return`\n      ${ze(t)}\n      float ${o}(int row, int col, int depth, int depth2, int depth3) {\n        return ${o}(${tt(n,c)});\n      }\n    `}if(e.shapeInfo.isUniform)return`\n      float ${o}(int row, int col, int depth, int depth2, int depth3) {\n        float index = dot(\n          vec4(row, col, depth, depth2),\n          vec4(${u}, ${s}, ${a}, ${i})) +\n          depth3;\n        ${Ze(e)}\n      }\n    `;const d=e.shapeInfo.flatOffset,h=e.shapeInfo.texShape,p=h[0],f=h[1];if(f===u&&null==d)return`\n      float ${o}(int row, int col, int depth, int depth2, int depth3) {\n        int texR = row;\n        float texC = dot(vec4(col, depth, depth2, depth3),\n                         vec4(${s}, ${a}, ${i}, 1));\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                   vec2(${f}.0, ${p}.0);\n        return sampleTexture(${r}, uv);\n      }\n    `;if(f===i&&null==d)return`\n      float ${o}(int row, int col, int depth, int depth2, int depth3) {\n        float texR = dot(\n          vec4(row, col, depth, depth2),\n          vec4(${n[1]*n[2]*n[3]},\n               ${n[2]*n[3]}, ${n[3]}, 1));\n        int texC = depth3;\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                  vec2(${f}.0, ${p}.0);\n        return sampleTexture(${r}, uv);\n      }\n    `;const x=Qe(r);return`\n    float ${o}(int row, int col, int depth, int depth2, int depth3) {\n      // Explicitly use integer operations as dot() only works on floats.\n      int index = row * ${u} + col * ${s} + depth * ${a} +\n          depth2 * ${i} + depth3 + ${x};\n      vec2 uv = uvFromFlat(${p}, ${f}, index);\n      return sampleTexture(${r}, uv);\n    }\n  `}(e);case 6:return function(e){const n=e.shapeInfo.logicalShape,r=e.name,o="get"+r.charAt(0).toUpperCase()+r.slice(1),{newShape:i,keptDims:a}=t.util.squeezeShape(n);if(i.length<n.length){const t=et(e,i),n=["row","col","depth","depth2","depth3","depth4"];return`\n      ${ze(t)}\n      float ${o}(int row, int col, int depth,\n                    int depth2, int depth3, int depth4) {\n        return ${o}(${tt(n,a)});\n      }\n    `}const s=n[5],u=n[4]*s,l=n[3]*u,c=n[2]*l,d=n[1]*c;if(e.shapeInfo.isUniform)return`\n      float ${o}(int row, int col, int depth,\n                  int depth2, int depth3, int depth4) {\n        int index = round(dot(\n          vec4(row, col, depth, depth2),\n          vec4(${d}, ${c}, ${l}, ${u})) +\n          dot(\n            vec2(depth3, depth4),\n            vec2(${s}, 1)));\n        ${Ze(e)}\n      }\n    `;const h=e.shapeInfo.flatOffset,p=e.shapeInfo.texShape,f=p[0],x=p[1];if(x===d&&null==h)return`\n      float ${o}(int row, int col, int depth,\n                    int depth2, int depth3, int depth4) {\n        int texR = row;\n        float texC = dot(vec4(col, depth, depth2, depth3),\n          vec4(${c}, ${l}, ${u}, ${s})) +\n               float(depth4);\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                   vec2(${x}.0, ${f}.0);\n        return sampleTexture(${r}, uv);\n      }\n    `;if(x===s&&null==h)return`\n      float ${o}(int row, int col, int depth,\n                    int depth2, int depth3, int depth4) {\n        float texR = dot(vec4(row, col, depth, depth2),\n          vec4(${n[1]*n[2]*n[3]*n[4]},\n               ${n[2]*n[3]*n[4]},\n               ${n[3]*n[4]},\n               ${n[4]})) + float(depth3);\n        int texC = depth4;\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                  vec2(${x}.0, ${f}.0);\n        return sampleTexture(${r}, uv);\n      }\n    `;const g=Qe(r);return`\n    float ${o}(int row, int col, int depth,\n                  int depth2, int depth3, int depth4) {\n      // Explicitly use integer operations as dot() only works on floats.\n      int index = row * ${d} + col * ${c} + depth * ${l} +\n          depth2 * ${u} + depth3 * ${s} + depth4 + ${g};\n      vec2 uv = uvFromFlat(${f}, ${x}, index);\n      return sampleTexture(${r}, uv);\n    }\n  `}(e);default:throw new Error(`${n.length}-D input sampling`+" is not yet supported")}}function Xe(e){switch(e.shapeInfo.logicalShape.length){case 0:return function(e){const t=e.name,n="get"+t.charAt(0).toUpperCase()+t.slice(1),r=Be();return`\n    vec4 ${n}() {\n      return ${r.texture2D}(${t}, halfCR);\n    }\n  `}(e);case 1:return function(e){const t=e.name,n="get"+t.charAt(0).toUpperCase()+t.slice(1),r=e.shapeInfo.texShape,o=[Math.ceil(r[0]/2),Math.ceil(r[1]/2)],i=Be();return`\n    vec4 ${n}(int index) {\n      vec2 uv = packedUVfrom1D(\n        ${o[0]}, ${o[1]}, index);\n      return ${i.texture2D}(${t}, uv);\n    }\n  `}(e);case 2:return function(e){const n=e.shapeInfo.logicalShape,r=e.name,o="get"+r.charAt(0).toUpperCase()+r.slice(1),i=e.shapeInfo.texShape,a=i[0],s=i[1],u=Be();if(null!=i&&t.util.arraysEqual(n,i))return`\n      vec4 ${o}(int row, int col) {\n        vec2 uv = (vec2(col, row) + halfCR) / vec2(${s}.0, ${a}.0);\n\n        return ${u.texture2D}(${r}, uv);\n      }\n    `;const l=[Math.ceil(i[0]/2),Math.ceil(i[1]/2)],c=Math.ceil(n[1]/2);return`\n    vec4 ${o}(int row, int col) {\n      vec2 uv = packedUVfrom2D(${c}, ${l[0]}, ${l[1]}, row, col);\n      return ${u.texture2D}(${r}, uv);\n    }\n  `}(e);case 3:return function(e){const t=e.shapeInfo.logicalShape,n=e.name,r="get"+n.charAt(0).toUpperCase()+n.slice(1),o=e.shapeInfo.texShape,i=[Math.ceil(o[0]/2),Math.ceil(o[1]/2)];if(1===t[0]){const n=t.slice(1),o=[1,2],i=et(e,n),a=["b","row","col"];return`\n        ${Xe(i)}\n        vec4 ${r}(int b, int row, int col) {\n          return ${r}(${tt(a,o)});\n        }\n      `}const a=i[0],s=i[1],u=Math.ceil(t[2]/2),l=u*Math.ceil(t[1]/2),c=Be();return`\n    vec4 ${r}(int b, int row, int col) {\n      vec2 uv = packedUVfrom3D(\n        ${a}, ${s}, ${l}, ${u}, b, row, col);\n      return ${c.texture2D}(${n}, uv);\n    }\n  `}(e);default:return function(e){const t=e.shapeInfo.logicalShape,n=t.length,r=e.name,o="get"+r.charAt(0).toUpperCase()+r.slice(1),i=e.shapeInfo.texShape,a=[Math.ceil(i[0]/2),Math.ceil(i[1]/2)],s=a[0],u=a[1],l=Math.ceil(t[n-1]/2);let c=l*Math.ceil(t[n-2]/2),d="int b, int row, int col",h=`b * ${c} + (row / 2) * ${l} + (col / 2)`;for(let e=2;e<n-1;e++)d=`int b${e}, `+d,c*=t[n-e-1],h=`b${e} * ${c} + `+h;const p=Be();return`\n    vec4 ${o}(${d}) {\n      int index = ${h};\n      int texR = index / ${u};\n      int texC = index - texR * ${u};\n      vec2 uv = (vec2(texC, texR) + halfCR) / vec2(${u}, ${s});\n      return ${p.texture2D}(${r}, uv);\n    }\n  `}(e)}}const He="\nvec2 uvFromFlat(int texNumR, int texNumC, int index) {\n  int texR = index / texNumC;\n  int texC = index - texR * texNumC;\n  return (vec2(texC, texR) + halfCR) / vec2(texNumC, texNumR);\n}\nvec2 packedUVfrom1D(int texNumR, int texNumC, int index) {\n  int texelIndex = index / 2;\n  int texR = texelIndex / texNumC;\n  int texC = texelIndex - texR * texNumC;\n  return (vec2(texC, texR) + halfCR) / vec2(texNumC, texNumR);\n}\n",je="\nvec2 packedUVfrom2D(int texelsInLogicalRow, int texNumR,\n  int texNumC, int row, int col) {\n  int texelIndex = (row / 2) * texelsInLogicalRow + (col / 2);\n  int texR = texelIndex / texNumC;\n  int texC = texelIndex - texR * texNumC;\n  return (vec2(texC, texR) + halfCR) / vec2(texNumC, texNumR);\n}\n",Ke="\nvec2 packedUVfrom3D(int texNumR, int texNumC,\n    int texelsInBatch, int texelsInLogicalRow, int b,\n    int row, int col) {\n  int index = b * texelsInBatch + (row / 2) * texelsInLogicalRow + (col / 2);\n  int texR = index / texNumC;\n  int texC = index - texR * texNumC;\n  return (vec2(texC, texR) + halfCR) / vec2(texNumC, texNumR);\n}\n",qe="\n  float getChannel(vec4 frag, vec2 innerDims) {\n    vec2 modCoord = mod(innerDims, 2.);\n    return modCoord.x == 0. ?\n      (modCoord.y == 0. ? frag.r : frag.g) :\n      (modCoord.y == 0. ? frag.b : frag.a);\n  }\n  float getChannel(vec4 frag, int dim) {\n    float modCoord = mod(float(dim), 2.);\n    return modCoord == 0. ? frag.r : frag.g;\n  }\n";function Ye(){return"\n    int getOutputCoords() {\n      return 0;\n    }\n  "}function Qe(e){return`offset${e}`}function Ze(e){const n=e.name,r=t.util.sizeFromShape(e.shapeInfo.logicalShape);return r<2?`return ${n};`:`\n    for (int i = 0; i < ${r}; i++) {\n      if (i == index) {\n        return ${n}[i];\n      }\n    }\n  `}function Je(e){if(e<=1)return"int";if(2===e)return"ivec2";if(3===e)return"ivec3";if(4===e)return"ivec4";if(5===e)return"ivec5";if(6===e)return"ivec6";throw Error(`GPU for rank ${e} is not yet supported`)}function et(e,t){const n=JSON.parse(JSON.stringify(e));return n.shapeInfo.logicalShape=t,n}function tt(e,t){return t.map(t=>e[t]).join(", ")}class nt{constructor(e,n,r,o){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,t.util.assert(e.length>2,()=>`Packed arg${r.charAt(0).toUpperCase()+r.slice(1)} supports only inputs with rank above 2.`);const i=e[e.length-1],a=Math.ceil(i/n);this.outputShape=e.slice(0,-1),a>1&&this.outputShape.push(a),o||this.variableNames.push("bestIndicesA");const s=this.outputShape,u=s.length,l=Je(u),c=Le("coords",u);let d,h;if(1===a){h=u+1;const e=Je(h);d=`\n        ${e} sourceLocR = ${e}(${c.join()}, 0);\n        ++${c[u-1]};\n        ${e} sourceLocG = ${e}(${c.join()}, 0);\n        ++${c[u-2]};\n        ${e} sourceLocA = ${e}(${c.join()}, 0);\n        --${c[u-1]};\n        ${e} sourceLocB = ${e}(${c.join()}, 0);\n        --${c[u-2]};`}else h=u,d=`\n        ${l} sourceLocR = coords;\n        ++${c[u-1]};\n        ${l} sourceLocG = coords;\n        ++${c[u-2]};\n        ${l} sourceLocA = coords;\n        --${c[u-1]};\n        ${l} sourceLocB = coords;\n        --${c[u-2]};`;const p=["x","y","z","w","u","v"].slice(0,h),f="."+p[h-1],x=p.map(e=>"int "+e),g=Le("sourceLocR",h-1).concat("inIdx.r"),m=Le("sourceLocG",h-1).concat("inIdx.g"),C=Le("sourceLocB",h-1).concat("inIdx.b"),v=Le("sourceLocA",h-1).concat("inIdx.a"),$="max"===r?"greaterThan":"lessThan",R=o?"":`\n          inIdx = round(vec4(getBestIndicesAChannel(${g.join()}),\n                             getBestIndicesAChannel(${m.join()}),\n                             getBestIndicesAChannel(${C.join()}),\n                             getBestIndicesAChannel(${v.join()})));`,b=`vec4(\n            getAChannel(${g.join()}),\n            hasNextCol ? getAChannel(${m.join()}) : 0.,\n            hasNextRow ? getAChannel(${C.join()}) : 0.,\n            hasNextRow && hasNextCol ? getAChannel(${v.join()}) : 0.)`,w=o?"":`\n      float getBestIndicesAChannel(${x.join()}) {\n        return getChannel(getBestIndicesA(${p.join()}),\n                                          vec2(${p.slice(-2).join()}));\n      }`;this.userCode=`\n      float getAChannel(${x.join()}) {\n        return getChannel(getA(${p.join()}),\n                               vec2(${p.slice(-2).join()}));\n      }\n      ${w}\n      void main() {\n        ${l} coords = getOutputCoords();\n        bool hasNextCol = ${c[u-1]} < ${s[u-1]-1};\n        bool hasNextRow = ${c[u-2]} < ${s[u-2]-1};\n        ${d}\n        ivec4 srcIdx = ivec4(sourceLocR${f}, sourceLocG${f},\n          sourceLocB${f}, sourceLocA${f}) * ${n};\n        ivec4 inIdx = srcIdx;\n        vec4 bestIndex = vec4(inIdx);\n        vec4 bestValue = ${b};\n\n        for (int i = 0; i < ${n}; i++) {\n          inIdx = srcIdx;\n          ${R}\n          vec4 candidate = ${b};\n          bvec4 nan = isnan(candidate);\n          bvec4 replace = bvec4(\n            vec4(${$}(candidate, bestValue)) * (vec4(1.0) - vec4(nan)));\n\n          bestValue = vec4(replace.x  ? candidate.x : bestValue.x,\n                           replace.y  ? candidate.y : bestValue.y,\n                           replace.z  ? candidate.z : bestValue.z,\n                           replace.w  ? candidate.w : bestValue.w);\n          bestIndex = mix(bestIndex, vec4(inIdx), vec4(replace));\n          srcIdx++;\n        }\n        setOutput(bestIndex);\n      }\n    `}}class rt{constructor(e){this.variableNames=["dy"],this.outputShape=e.inShape;const t=e.filterHeight,n=e.filterWidth,r=e.strideHeight,o=e.strideWidth,i=e.dilationHeight,a=e.dilationWidth,s=e.effectiveFilterHeight,u=e.effectiveFilterWidth,l=s-1-e.padInfo.top,c=u-1-e.padInfo.left,d=1/(t*n);this.userCode=`\n      const ivec2 pads = ivec2(${l}, ${c});\n      const float avgMultiplier = float(${d});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n\n        ivec2 dyRCCorner = coords.yz - pads;\n        int dyRCorner = dyRCCorner.x;\n        int dyCCorner = dyRCCorner.y;\n\n        // Convolve dy(?, ?, d) with pos mask(:, :, d) to get dx(xR, xC, d).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n        for (int wR = 0; wR < ${s};\n            wR += ${i}) {\n          float dyR = float(dyRCorner + wR) / ${r}.0;\n\n          if (dyR < 0.0 || dyR >= ${e.outHeight}.0 || fract(dyR) > 0.0) {\n            continue;\n          }\n          int idyR = int(dyR);\n\n          for (int wC = 0; wC < ${u};\n            wC+= ${a}) {\n            float dyC = float(dyCCorner + wC) / ${o}.0;\n\n            if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                fract(dyC) > 0.0) {\n              continue;\n            }\n            int idyC = int(dyC);\n\n            float dyValue = getDy(b, idyR, idyC, d);\n\n            dotProd += dyValue * avgMultiplier;\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class ot{constructor(e){this.variableNames=["dy"],this.outputShape=e.inShape;const t=e.filterDepth,n=e.filterHeight,r=e.filterWidth,o=e.strideDepth,i=e.strideHeight,a=e.strideWidth,s=e.dilationDepth,u=e.dilationHeight,l=e.dilationWidth,c=e.effectiveFilterDepth,d=e.effectiveFilterHeight,h=e.effectiveFilterWidth,p=c-1-e.padInfo.front,f=d-1-e.padInfo.top,x=h-1-e.padInfo.left,g=1/(t*n*r);this.userCode=`\n      const ivec3 pads = ivec3(${p}, ${f}, ${x});\n      const float avgMultiplier = float(${g});\n\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int batch = coords.x;\n        int ch = coords.u;\n\n        ivec3 dyCorner = ivec3(coords.y, coords.z, coords.w) - pads;\n        int dyDCorner = dyCorner.x;\n        int dyRCorner = dyCorner.y;\n        int dyCCorner = dyCorner.z;\n\n        // Convolve dy(?, ?, ?, d) with pos mask(:, :, :, ch) to get\n        // dx(xD, xR, xC, ch).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n\n        for (int wD = 0; wD < ${c};\n            wD += ${s}) {\n          float dyD = float(dyDCorner + wD) / ${o}.0;\n\n          if (dyD < 0.0 || dyD >= ${e.outDepth}.0 || fract(dyD) > 0.0) {\n            continue;\n          }\n          int idyD = int(dyD);\n\n          for (int wR = 0; wR < ${d};\n              wR += ${u}) {\n            float dyR = float(dyRCorner + wR) / ${i}.0;\n\n            if (dyR < 0.0 || dyR >= ${e.outHeight}.0 ||\n                fract(dyR) > 0.0) {\n              continue;\n            }\n            int idyR = int(dyR);\n\n            for (int wC = 0; wC < ${h};\n                wC += ${l}) {\n              float dyC = float(dyCCorner + wC) / ${a}.0;\n\n              if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                  fract(dyC) > 0.0) {\n                continue;\n              }\n              int idyC = int(dyC);\n\n              float dyValue = getDy(batch, idyD, idyR, idyC, ch);\n\n              dotProd += dyValue * avgMultiplier;\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}const it="return (a < 0.) ? b * a : a;";class at{constructor(e,n,r){this.variableNames=["A","B"],this.outputShape=t.backend_util.assertAndGetBroadcastShape(n,r),this.userCode=`\n      float binaryOperation(float a, float b) {\n        ${e}\n      }\n\n      void main() {\n        float a = getAAtOutCoords();\n        float b = getBAtOutCoords();\n        setOutput(binaryOperation(a, b));\n      }\n    `}}const st="\n  vec4 aLessThanZero = vec4(lessThan(a, vec4(0.)));\n  return (aLessThanZero * (b * a)) + ((vec4(1.0) - aLessThanZero) * a);\n";class ut{constructor(e,n,r,o=!1){this.variableNames=["A","B"],this.supportsBroadcasting=!0,this.packedInputs=!0,this.packedOutput=!0,this.outputShape=t.backend_util.assertAndGetBroadcastShape(n,r);const i=this.outputShape.length;let a="";if(o)if(0===i||1===t.util.sizeFromShape(this.outputShape))a="\n          result.y = 0.;\n          result.z = 0.;\n          result.w = 0.;\n        ";else{if(a=`\n          ${Je(i)} coords = getOutputCoords();\n        `,1===i)a+=`\n            result.y = (coords + 1) >= ${this.outputShape[0]} ? 0. : result.y;\n            result.z = 0.;\n            result.w = 0.;\n          `;else{const e=Le("coords",i);a+=`\n            bool nextRowOutOfBounds =\n              (${e[i-2]} + 1) >= ${this.outputShape[i-2]};\n            bool nextColOutOfBounds =\n              (${e[i-1]} + 1) >= ${this.outputShape[i-1]};\n            result.y = nextColOutOfBounds ? 0. : result.y;\n            result.z = nextRowOutOfBounds ? 0. : result.z;\n            result.w = nextColOutOfBounds || nextRowOutOfBounds ? 0. : result.w;\n          `}}this.userCode=`\n      vec4 binaryOperation(vec4 a, vec4 b) {\n        ${e}\n      }\n\n      void main() {\n        vec4 a = getAAtOutCoords();\n        vec4 b = getBAtOutCoords();\n\n        vec4 result = binaryOperation(a, b);\n        ${a}\n\n        setOutput(result);\n      }\n    `}}class lt{constructor(e){this.variableNames=["A"],this.outputShape=e,this.userCode="\n      uniform float minVal;\n      uniform float maxVal;\n\n      void main() {\n        float value = getAAtOutCoords();\n        if (isnan(value)) {\n          setOutput(value);\n          return;\n        }\n\n        setOutput(clamp(value, minVal, maxVal));\n      }\n    "}getCustomSetupFunc(e,t){return(n,r)=>{null==this.minLoc&&(this.minLoc=n.getUniformLocationNoThrow(r,"minVal"),this.maxLoc=n.getUniformLocationNoThrow(r,"maxVal")),n.gl.uniform1f(this.minLoc,e),n.gl.uniform1f(this.maxLoc,t)}}}class ct{constructor(e){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=e,this.userCode="\n      uniform float minVal;\n      uniform float maxVal;\n\n      void main() {\n        vec4 value = getAAtOutCoords();\n\n        if (any(isnan(value))) {\n          setOutput(value);\n          return;\n        }\n\n        setOutput(clamp(value, vec4(minVal), vec4(maxVal)));\n      }\n    "}getCustomSetupFunc(e,t){return(n,r)=>{null==this.minLoc&&(this.minLoc=n.getUniformLocationNoThrow(r,"minVal"),this.maxLoc=n.getUniformLocationNoThrow(r,"maxVal")),n.gl.uniform1f(this.minLoc,e),n.gl.uniform1f(this.maxLoc,t)}}}class dt{constructor(e){this.variableNames=["real","imag"],this.outputShape=e,this.userCode="\n      void main() {\n        float re = abs(getRealAtOutCoords());\n        float im = abs(getImagAtOutCoords());\n        float mx = max(re, im);\n\n        // sadly the length function in glsl is not underflow-safe\n        // (at least not on Intel GPUs). So the safe solution is\n        // to ensure underflow-safety in all cases.\n        setOutput(\n          mx == 0.0 ? 0.0 : mx * length(vec2(1, min(re, im)/mx))\n        );\n      }\n    "}}class ht{constructor(e){this.variableNames=["x","dy"],this.outputShape=e.filterShape;const t=e.strideHeight,n=e.strideWidth,r=e.padInfo.top,o=e.padInfo.left,i="channelsLast"===e.dataFormat;this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int wR = coords.x;\n        int wC = coords.y;\n        int d1 = coords.z;\n        int d2 = coords.w;\n\n        // Convolve x(?, ?, d1) with dy(:, :, d2) to get dw(wR, wC, d1, d2).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n\n        for (int b = 0; b < ${e.batchSize}; b++) {\n          for (int yR = 0; yR < ${e.outHeight}; yR++) {\n            int xR = wR + yR * ${t} - ${r};\n\n            if (xR < 0 || xR >= ${e.inHeight}) {\n              continue;\n            }\n\n            for (int yC = 0; yC < ${e.outWidth}; yC++) {\n              int xC = wC + yC * ${n} - ${o};\n\n              if (xC < 0 || xC >= ${e.inWidth}) {\n                continue;\n              }\n\n              if (${i}) {\n                float dyValue = getDy(b, yR, yC, d2);\n                float xValue = getX(b, xR, xC, d1);\n                dotProd += (xValue * dyValue);\n              } else {\n                float dyValue = getDy(b, d2, yR, yC);\n                float xValue = getX(b, d1, xR, xC);\n                dotProd += (xValue * dyValue);\n              }\n\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class pt{constructor(e){this.variableNames=["dy","W"],this.outputShape=e.inShape;const t=e.filterHeight,n=e.filterWidth,r=e.strideHeight,o=e.strideWidth,i="channelsLast"===e.dataFormat,a=t-1-e.padInfo.top,s=n-1-e.padInfo.left,u=i?1:2,l=i?2:3,c=i?3:1;this.userCode=`\n      const ivec2 pads = ivec2(${a}, ${s});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords[0];\n        int d1 = coords[${c}];\n\n        ivec2 dyCorner = ivec2(coords[${u}], coords[${l}]) - pads;\n        int dyRCorner = dyCorner.x;\n        int dyCCorner = dyCorner.y;\n\n        // Convolve dy(?, ?, d2) with w(:, :, d1, d2) to compute dx(xR, xC, d1).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n        for (int wR = 0; wR < ${t}; wR++) {\n          float dyR = float(dyRCorner + wR) / ${r}.0;\n\n          if (dyR < 0.0 || dyR >= ${e.outHeight}.0 || fract(dyR) > 0.0) {\n            continue;\n          }\n          int idyR = int(dyR);\n\n          int wRPerm = ${t} - 1 - wR;\n\n          for (int wC = 0; wC < ${n}; wC++) {\n            float dyC = float(dyCCorner + wC) / ${o}.0;\n\n            if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                fract(dyC) > 0.0) {\n              continue;\n            }\n            int idyC = int(dyC);\n\n            int wCPerm = ${n} - 1 - wC;\n\n            for (int d2 = 0; d2 < ${e.outChannels}; d2++) {\n\n              if (${i}) {\n                float xValue = getDy(batch, idyR, idyC, d2);\n                float wValue = getW(wRPerm, wCPerm, d1, d2);\n                dotProd += xValue * wValue;\n              } else {\n                float xValue = getDy(batch, d2, idyR, idyC);\n                float wValue = getW(wRPerm, wCPerm, d1, d2);\n                dotProd += xValue * wValue;\n              }\n\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class ft{constructor(e){this.variableNames=["x","dy"],this.outputShape=e.filterShape;const t=e.strideDepth,n=e.strideHeight,r=e.strideWidth,o=e.padInfo.front,i=e.padInfo.top,a=e.padInfo.left;this.userCode=`\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int wF = coords.x;\n        int wR = coords.y;\n        int wC = coords.z;\n        int d1 = coords.w;\n        int d2 = coords.u;\n\n        float dotProd = 0.0;\n\n        for (int b = 0; b < ${e.batchSize}; b++) {\n          for (int yF = 0; yF < ${e.outDepth}; yF++) {\n            int xF = wF + yF * ${t} - ${o};\n\n            if (xF < 0 || xF >= ${e.inDepth}) {\n              continue;\n            }\n\n            for (int yR = 0; yR < ${e.outHeight}; yR++) {\n              int xR = wR + yR * ${n} - ${i};\n\n              if (xR < 0 || xR >= ${e.inHeight}) {\n                continue;\n              }\n\n              for (int yC = 0; yC < ${e.outWidth}; yC++) {\n                int xC = wC + yC * ${r} - ${a};\n\n                if (xC < 0 || xC >= ${e.inWidth}) {\n                  continue;\n                }\n\n                float dyValue = getDy(b, yF, yR, yC, d2);\n                float xValue = getX(b, xF, xR, xC, d1);\n                dotProd += (xValue * dyValue);\n              }\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class xt{constructor(e){this.variableNames=["dy","W"],this.outputShape=e.inShape;const t=e.filterDepth,n=e.filterHeight,r=e.filterWidth,o=e.strideDepth,i=e.strideHeight,a=e.strideWidth,s=t-1-e.padInfo.front,u=n-1-e.padInfo.top,l=r-1-e.padInfo.left;this.userCode=`\n      const ivec3 pads = ivec3(${s}, ${u}, ${l});\n\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int batch = coords.x;\n        int d1 = coords.u;\n\n\n        ivec3 dyCorner = ivec3(coords.y, coords.z, coords.w) - pads;\n        int dyFCorner = dyCorner.x;\n        int dyRCorner = dyCorner.y;\n        int dyCCorner = dyCorner.z;\n\n        float dotProd = 0.0;\n        for (int wF = 0; wF < ${t}; wF++) {\n          float dyF = float(dyFCorner + wF) / ${o}.0;\n\n          if (dyF < 0.0 || dyF >= ${e.outDepth}.0 || fract(dyF) > 0.0) {\n            continue;\n          }\n          int idyF = int(dyF);\n\n          int wFPerm = ${t} - 1 - wF;\n\n          for (int wR = 0; wR < ${n}; wR++) {\n            float dyR = float(dyRCorner + wR) / ${i}.0;\n\n            if (dyR < 0.0 || dyR >= ${e.outHeight}.0 ||\n              fract(dyR) > 0.0) {\n              continue;\n            }\n            int idyR = int(dyR);\n\n            int wRPerm = ${n} - 1 - wR;\n\n            for (int wC = 0; wC < ${r}; wC++) {\n              float dyC = float(dyCCorner + wC) / ${a}.0;\n\n              if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                  fract(dyC) > 0.0) {\n                continue;\n              }\n              int idyC = int(dyC);\n\n              int wCPerm = ${r} - 1 - wC;\n\n              for (int d2 = 0; d2 < ${e.outChannels}; d2++) {\n                float xValue = getDy(batch, idyF, idyR, idyC, d2);\n                float wValue = getW(wFPerm, wRPerm, wCPerm, d1, d2);\n                dotProd += xValue * wValue;\n              }\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class gt{constructor(e){this.variableNames=["x","dy"],this.outputShape=e.filterShape;const t=e.strideHeight,n=e.strideWidth,r=e.padInfo.top,o=e.padInfo.left,i=e.outChannels/e.inChannels;this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int wR = coords.x;\n        int wC = coords.y;\n        int d1 = coords.z;\n        int dm = coords.w;\n        int d2 = d1 * ${i} + dm;\n\n        float dotProd = 0.0;\n\n        // TO DO: Vec4 over the batch size\n        for (int b = 0; b < ${e.batchSize}; b++) {\n          for (int yR = 0; yR < ${e.outHeight}; yR++) {\n            int xR = wR + yR * ${t} - ${r};\n\n            if (xR < 0 || xR >= ${e.inHeight}) {\n              continue;\n            }\n\n            for (int yC = 0; yC < ${e.outWidth}; yC++) {\n              int xC = wC + yC * ${n} - ${o};\n\n              if (xC < 0 || xC >= ${e.inWidth}) {\n                continue;\n              }\n\n              float dyValue = getDy(b, yR, yC, d2);\n              float xValue = getX(b, xR, xC, d1);\n              dotProd += (xValue * dyValue);\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class mt{constructor(e){this.variableNames=["dy","W"],this.outputShape=e.inShape;const t=e.filterHeight,n=e.filterWidth,r=e.strideHeight,o=e.strideWidth,i=t-1-e.padInfo.top,a=n-1-e.padInfo.left,s=e.outChannels/e.inChannels;this.userCode=`\n      const ivec2 pads = ivec2(${i}, ${a});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords[0];\n        int d1 = coords[3];\n        ivec2 dyCorner = coords.yz - pads;\n        int dyRCorner = dyCorner.x;\n        int dyCCorner = dyCorner.y;\n\n        float dotProd = 0.0;\n\n        for (int wR = 0; wR < ${t}; wR++) {\n          float dyR = float(dyRCorner + wR) / ${r}.0;\n\n          if (dyR < 0.0 || dyR >= ${e.outHeight}.0 || fract(dyR) > 0.0) {\n            continue;\n          }\n          int idyR = int(dyR);\n\n          int wRPerm = ${t} - 1 - wR;\n\n          for (int wC = 0; wC < ${n}; wC++) {\n            float dyC = float(dyCCorner + wC) / ${o}.0;\n\n            if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                fract(dyC) > 0.0) {\n              continue;\n            }\n            int idyC = int(dyC);\n\n            int wCPerm = ${n} - 1 - wC;\n\n            // TO DO: Vec4 over the channelMul\n            for (int dm = 0; dm < ${s}; dm++) {\n              int d2 = d1 * ${s} + dm;\n              float xValue = getDy(batch, idyR, idyC, d2);\n              float wValue = getW(wRPerm, wCPerm, d1, dm);\n              dotProd += xValue * wValue;\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class Ct{constructor(e,t=!1,n=null,r=!1){this.variableNames=["x","W"],this.outputShape=e.outShape;const o=e.padInfo.top,i=e.padInfo.left,a=e.strideHeight,s=e.strideWidth,u=e.dilationHeight,l=e.dilationWidth,c=e.filterHeight,d=e.filterWidth,h=4*Math.floor(e.inChannels/4),p=e.inChannels%4,f="channelsLast"===e.dataFormat,x=f?1:2,g=f?2:3,m=f?3:1;let C="",v="";n&&(C=r?`float activation(float a) {\n          float b = getPreluActivationWeightsAtOutCoords();\n          ${n}\n        }`:`\n          float activation(float x) {\n            ${n}\n          }\n        `,v="result = activation(result);");const $=t?"result += getBiasAtOutCoords();":"";t&&this.variableNames.push("bias"),r&&this.variableNames.push("preluActivationWeights"),this.userCode=`\n      ${C}\n\n      const ivec2 strides = ivec2(${a}, ${s});\n      const ivec2 pads = ivec2(${o}, ${i});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords[0];\n        int d2 = coords[${m}];\n\n        ivec2 xRCCorner =\n            ivec2(coords[${x}], coords[${g}]) * strides - pads;\n        int xRCorner = xRCCorner.x;\n        int xCCorner = xRCCorner.y;\n\n        // Convolve x(?, ?, d1) with w(:, :, d1, d2) to get y(yR, yC, d2).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n        for (int wR = 0; wR < ${c}; wR++) {\n          int xR = xRCorner + wR * ${u};\n\n          if (xR < 0 || xR >= ${e.inHeight}) {\n            continue;\n          }\n\n          for (int wC = 0; wC < ${d}; wC++) {\n            int xC = xCCorner + wC * ${l};\n\n            if (xC < 0 || xC >= ${e.inWidth}) {\n              continue;\n            }\n\n            for (int d1 = 0; d1 < ${h}; d1 += 4) {\n              vec4 wValues = vec4(\n                getW(wR, wC, d1, d2),\n                getW(wR, wC, d1 + 1, d2),\n                getW(wR, wC, d1 + 2, d2),\n                getW(wR, wC, d1 + 3, d2)\n              );\n\n              if (${f}) {\n                vec4 xValues = vec4(\n                  getX(batch, xR, xC, d1),\n                  getX(batch, xR, xC, d1 + 1),\n                  getX(batch, xR, xC, d1 + 2),\n                  getX(batch, xR, xC, d1 + 3)\n                );\n                dotProd += dot(xValues, wValues);\n              } else {\n                vec4 xValues = vec4(\n                  getX(batch, d1, xR, xC),\n                  getX(batch, d1 + 1, xR, xC),\n                  getX(batch, d1 + 2, xR, xC),\n                  getX(batch, d1 + 3, xR, xC)\n                );\n                dotProd += dot(xValues, wValues);\n              }\n            }\n\n            if (${1===p}) {\n\n              if (${f}) {\n                dotProd +=\n                    getX(batch, xR, xC, ${h}) *\n                    getW(wR, wC, ${h}, d2);\n              } else {\n                dotProd +=\n                    getX(batch, ${h}, xR, xC) *\n                    getW(wR, wC, ${h}, d2);\n              }\n\n            } else if (${2===p}) {\n              vec2 wValues = vec2(\n                getW(wR, wC, ${h}, d2),\n                getW(wR, wC, ${h} + 1, d2)\n              );\n\n              if (${f}) {\n                vec2 xValues = vec2(\n                  getX(batch, xR, xC, ${h}),\n                  getX(batch, xR, xC, ${h} + 1)\n                );\n                dotProd += dot(xValues, wValues);\n              } else {\n                vec2 xValues = vec2(\n                  getX(batch, ${h}, xR, xC),\n                  getX(batch, ${h} + 1, xR, xC)\n                );\n                dotProd += dot(xValues, wValues);\n              }\n\n            } else if (${3===p}) {\n              vec3 wValues = vec3(\n                getW(wR, wC, ${h}, d2),\n                getW(wR, wC, ${h} + 1, d2),\n                getW(wR, wC, ${h} + 2, d2)\n              );\n\n              if (${f}) {\n                vec3 xValues = vec3(\n                  getX(batch, xR, xC, ${h}),\n                  getX(batch, xR, xC, ${h} + 1),\n                  getX(batch, xR, xC, ${h} + 2)\n                );\n                dotProd += dot(xValues, wValues);\n              } else {\n                vec3 xValues = vec3(\n                  getX(batch, ${h}, xR, xC),\n                  getX(batch, ${h} + 1, xR, xC),\n                  getX(batch, ${h} + 2, xR, xC)\n                );\n                dotProd += dot(xValues, wValues);\n              }\n\n            }\n          }\n        }\n\n        float result = dotProd;\n        ${$}\n        ${v}\n        setOutput(result);\n      }\n    `}}class vt{constructor(e){this.variableNames=["x","W"],this.outputShape=e.outShape;const t=e.padInfo.front,n=e.padInfo.top,r=e.padInfo.left,o=e.strideDepth,i=e.strideHeight,a=e.strideWidth,s=e.dilationDepth,u=e.dilationHeight,l=e.dilationWidth,c=e.filterDepth,d=e.filterHeight,h=e.filterWidth,p=4*Math.floor(e.inChannels/4),f=e.inChannels%4;this.userCode=`\n      const ivec3 strides = ivec3(${o}, ${i}, ${a});\n      const ivec3 pads = ivec3(${t}, ${n}, ${r});\n\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int batch = coords.x;\n        int d2 = coords.u;\n\n        ivec3 xFRCCorner = ivec3(coords.y, coords.z, coords.w) * strides - pads;\n        int xFCorner = xFRCCorner.x;\n        int xRCorner = xFRCCorner.y;\n        int xCCorner = xFRCCorner.z;\n\n        // Convolve x(?, ?, ?, d1) with w(:, :, :, d1, d2) to get\n        // y(yF, yR, yC, d2). ? = to be determined. : = across all\n        // values in that axis.\n        float dotProd = 0.0;\n        for (int wF = 0; wF < ${c}; wF++) {\n          int xF = xFCorner + wF * ${s};\n\n          if (xF < 0 || xF >= ${e.inDepth}) {\n            continue;\n          }\n\n          for (int wR = 0; wR < ${d}; wR++) {\n            int xR = xRCorner + wR * ${u};\n\n            if (xR < 0 || xR >= ${e.inHeight}) {\n              continue;\n            }\n\n            for (int wC = 0; wC < ${h}; wC++) {\n              int xC = xCCorner + wC * ${l};\n\n              if (xC < 0 || xC >= ${e.inWidth}) {\n                continue;\n              }\n\n              for (int d1 = 0; d1 < ${p}; d1 += 4) {\n                vec4 xValues = vec4(\n                  getX(batch, xF, xR, xC, d1),\n                  getX(batch, xF, xR, xC, d1 + 1),\n                  getX(batch, xF, xR, xC, d1 + 2),\n                  getX(batch, xF, xR, xC, d1 + 3)\n                );\n                vec4 wValues = vec4(\n                  getW(wF, wR, wC, d1, d2),\n                  getW(wF, wR, wC, d1 + 1, d2),\n                  getW(wF, wR, wC, d1 + 2, d2),\n                  getW(wF, wR, wC, d1 + 3, d2)\n                );\n\n                dotProd += dot(xValues, wValues);\n              }\n\n              if (${1===f}) {\n                dotProd +=\n                  getX(batch, xF, xR, xC, ${p}) *\n                  getW(wF, wR, wC, ${p}, d2);\n              } else if (${2===f}) {\n                vec2 xValues = vec2(\n                  getX(batch, xF, xR, xC, ${p}),\n                  getX(batch, xF, xR, xC, ${p} + 1)\n                );\n                vec2 wValues = vec2(\n                  getW(wF, wR, wC, ${p}, d2),\n                  getW(wF, wR, wC, ${p} + 1, d2)\n                );\n                dotProd += dot(xValues, wValues);\n              } else if (${3===f}) {\n                vec3 xValues = vec3(\n                  getX(batch, xF, xR, xC, ${p}),\n                  getX(batch, xF, xR, xC, ${p} + 1),\n                  getX(batch, xF, xR, xC, ${p} + 2)\n                );\n                vec3 wValues = vec3(\n                  getW(wF, wR, wC, ${p}, d2),\n                  getW(wF, wR, wC, ${p} + 1, d2),\n                  getW(wF, wR, wC, ${p} + 2, d2)\n                );\n                dotProd += dot(xValues, wValues);\n              }\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class $t{constructor(e,t=!1,n=null,r=!1){this.variableNames=["x","W"],this.outputShape=e.outShape;const o=e.inHeight,i=e.inWidth,a=e.padInfo.top,s=e.padInfo.left,u=e.strideHeight,l=e.strideWidth,c=e.dilationHeight,d=e.dilationWidth,h=e.filterHeight,p=e.filterWidth,f=e.outChannels/e.inChannels;let x="",g="";n&&(x=r?`float activation(float a) {\n          float b = getPreluActivationWeightsAtOutCoords();\n          ${n}\n        }`:`\n          float activation(float x) {\n            ${n}\n          }\n        `,g="result = activation(result);");const m=t?"result += getBiasAtOutCoords();":"";t&&this.variableNames.push("bias"),r&&this.variableNames.push("preluActivationWeights"),this.userCode=`\n      ${x}\n\n      const ivec2 strides = ivec2(${u}, ${l});\n      const ivec2 pads = ivec2(${a}, ${s});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords.x;\n        ivec2 xRCCorner = coords.yz * strides - pads;\n        int d2 = coords.w;\n        int d1 = d2 / ${f};\n        int q = d2 - d1 * ${f};\n\n        int xRCorner = xRCCorner.x;\n        int xCCorner = xRCCorner.y;\n\n        // Convolve x(?, ?, d1) with w(:, :, d1, q) to get y(yR, yC, d2).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n        // TO DO(dsmilkov): Flatten the two for loops and vec4 the operations.\n        for (int wR = 0; wR < ${h}; wR++) {\n          int xR = xRCorner + wR * ${c};\n\n          if (xR < 0 || xR >= ${o}) {\n            continue;\n          }\n\n          for (int wC = 0; wC < ${p}; wC++) {\n            int xC = xCCorner + wC * ${d};\n\n            if (xC < 0 || xC >= ${i}) {\n              continue;\n            }\n\n            float xVal = getX(batch, xR, xC, d1);\n            float wVal = getW(wR, wC, d1, q);\n            dotProd += xVal * wVal;\n          }\n        }\n\n        float result = dotProd;\n        ${m}\n        ${g}\n        setOutput(result);\n      }\n    `}}class Rt{constructor(e,n=!1,r=null,o=!1){this.variableNames=["x","W"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=e.outShape;const i=e.inHeight,a=e.inWidth,s=e.padInfo.top,u=e.padInfo.left,l=e.strideHeight,c=e.strideWidth,d=e.dilationHeight,h=e.dilationWidth,p=e.filterHeight,f=e.filterWidth,x=f;let g="int xR; int xC; int xCOffset;";for(let e=0;e<p;e++)for(let t=0;t<f;t++)g+=`\n          vec4 xTexelR${e}C${2*t} = vec4(0.);\n          vec4 wR${e}C${t} = vec4(0.);\n          vec4 xR${e}C${t} = vec4(0.);`;for(let e=0;e<p;e++)for(let n=0;n<x;n++){const r=2*n;if(g+=`\n          xR = xRCorner + ${e*d};\n          xC = xCCorner + ${r*h};\n        `,1===c){if(r<f&&(g+=u%2==1?`\n                xCOffset = xC + 1;\n                if(xR >= 0 && xR < ${i} && xCOffset >= 0 && xCOffset < ${a}) {\n                  xTexelR${e}C${r} = getX(batch, xR, xCOffset, d1);\n\n                  // Need to manually clear unused channels in case\n                  // we're reading from recycled texture.\n                  if(xCOffset + 1 >= ${a}) {\n                    xTexelR${e}C${r}.zw = vec2(0.);\n                  }\n                } else {\n                  xTexelR${e}C${r} = vec4(0.);\n                }\n\n                xCOffset = xC + 1 - 2;\n                if(xR >= 0 && xR < ${i} && xCOffset >= 0 && xCOffset < ${a}) {\n                  vec4 previous = getX(batch, xR, xCOffset, d1);\n\n                  // Need to manually clear unused channels in case\n                  // we're reading from recycled texture.\n                  if(xCOffset + 1 >= ${a}) {\n                    previous.zw = vec2(0.);\n                  }\n\n                  xR${e}C${r} = vec4(previous.zw, xTexelR${e}C${r}.xy);\n                } else {\n                  xR${e}C${r} = vec4(0, 0, xTexelR${e}C${r}.xy);\n                }\n              `:`\n                if(xR >= 0 && xR < ${i} && xC >= 0 && xC < ${a}) {\n                  xTexelR${e}C${r} = getX(batch, xR, xC, d1);\n                } else {\n                  xTexelR${e}C${r} = vec4(0.);\n                }\n\n                xR${e}C${r} = xTexelR${e}C${r};\n              `,r+1<f)){const n=u%2==0?t.util.nearestLargerEven(h):h;h%2==0&&u%2==1||h%2!=0&&u%2!=1?(g+=`\n                  xCOffset = xC + ${u%2} + ${n};\n\n                  if(xR >= 0 && xR < ${i} &&\n                    xCOffset >= 0 && xCOffset < ${a}) {\n                    xTexelR${e}C${r+2} = getX(batch, xR, xCOffset, d1);\n                  }\n                `,h>1&&(g+=`\n                    xCOffset -= 2;\n                    if(xR >= 0 && xR < ${i} &&\n                      xCOffset >= 0 && xCOffset < ${a}) {\n                      xTexelR${e}C${r} = getX(batch, xR, xCOffset, d1);\n                    } else {\n                      xTexelR${e}C${r} = vec4(0.);\n                    }\n                  `),g+=`\n                  xR${e}C${r+1} = vec4(\n                    xTexelR${e}C${r}.zw, xTexelR${e}C${r+2}.xy);\n                `):g+=`\n                  xCOffset = xC + ${n};\n\n                  if(xR >= 0 && xR < ${i} &&\n                    xCOffset >= 0 && xCOffset < ${a}) {\n                    xTexelR${e}C${r+2} = getX(batch, xR, xCOffset, d1);\n                  }\n\n                  xR${e}C${r+1} = xTexelR${e}C${r+2};\n                `}}else r<f&&(g+=`\n              if(xR >= 0 && xR < ${i}) {\n            `,u%2==1?(g+=`\n                xCOffset = xC + 1 - ${c};\n                if(xCOffset >= 0 && xCOffset < ${a}) {\n                  xTexelR${e}C${r} = getX(batch, xR, xCOffset, d1);\n                } else {\n                  xTexelR${e}C${r} = vec4(0.);\n                }\n\n                if(xC + 1 >= 0 && xC + 1 < ${a}) {\n                  xTexelR${e}C${r+2} = getX(batch, xR, xC + 1, d1);\n                } else {\n                  xTexelR${e}C${r+2} = vec4(0.);\n                }\n\n                xR${e}C${r} = vec4(\n                  xTexelR${e}C${r}.zw, xTexelR${e}C${r+2}.zw);\n              `,r+1<f&&(g+=`\n                  vec4 final = vec4(0.);\n                  xCOffset = xC + 1 + ${c};\n                  if(xCOffset >= 0 && xCOffset < ${a}) {\n                    final = getX(batch, xR, xCOffset, d1);\n                  }\n                  xR${e}C${r+1} = vec4(xTexelR${e}C${r+2}.xy, final.xy);\n                `)):(g+=`\n                if(xC >= 0 && xC < ${a}) {\n                  xTexelR${e}C${r} = getX(batch, xR, xC, d1);\n                } else {\n                  xTexelR${e}C${r} = vec4(0.);\n                }\n\n                xCOffset = xC + ${c};\n                if(xCOffset >= 0 && xCOffset < ${a}) {\n                  xTexelR${e}C${r+2} = getX(batch, xR, xCOffset, d1);\n                } else {\n                  xTexelR${e}C${r+2} = vec4(0.);\n                }\n\n                xR${e}C${r} = vec4(\n                  xTexelR${e}C${r}.xy, xTexelR${e}C${r+2}.xy);\n              `,r+1<f&&(g+=`\n                  xR${e}C${r+1} = vec4(\n                    xTexelR${e}C${r}.zw, xTexelR${e}C${r+2}.zw);\n                `)),g+="}");r<f&&(g+=`\n            vec4 wTexelR${e}C${r} = getW(${e}, ${r}, d1, q);\n            wR${e}C${r} = vec4(wTexelR${e}C${r}.xz, wTexelR${e}C${r}.xz);\n          `,r+1<f&&(g+=`\n              vec4 wTexelR${e}C${r+1} = getW(${e}, ${r+1}, d1, q);\n              wR${e}C${r+1} =\n                vec4(wTexelR${e}C${r+1}.xz, wTexelR${e}C${r+1}.xz);`))}for(let e=0;e<p;e++)for(let t=0;t<f;t++)g+=`dotProd += xR${e}C${t} * wR${e}C${t};`;let m="",C="";r&&(m=o?`vec4 activation(vec4 a) {\n          vec4 b = getPreluActivationWeightsAtOutCoords();\n          ${r}\n        }`:`vec4 activation(vec4 x) {\n          ${r}\n        }`,C="result = activation(result);");const v=n?"result += getBiasAtOutCoords();":"";n&&this.variableNames.push("bias"),o&&this.variableNames.push("preluActivationWeights"),this.userCode=`\n      ${m}\n\n      const ivec2 strides = ivec2(${l}, ${c});\n      const ivec2 pads = ivec2(${s}, ${u});\n\n      void main() {\n\n        ivec4 coords = getOutputCoords();\n        int batch = coords.x;\n        ivec2 xRCCorner = coords.yz * strides - pads;\n        int d2 = coords.w;\n        int d1 = d2;\n        int q = 0;\n        int xRCorner = xRCCorner.x;\n        int xCCorner = xRCCorner.y;\n\n        vec4 dotProd = vec4(0.);\n\n        ${g}\n\n        vec4 result = dotProd;\n        ${v}\n        ${C}\n        setOutput(result);\n      }\n    `}}class bt{constructor(e,t,n,r,o){this.variableNames=["Image","Boxes","BoxInd"],this.outputShape=[];const[i,a,s,u]=e,[l]=t,[c,d]=n;this.outputShape=[l,c,d,u];const h="bilinear"===r?1:0,[p,f]=[`${a-1}.0`,`${s-1}.0`],[x,g,m]=c>1?[`${(a-1)/(c-1)}`,"(y2-y1) * height_ratio",`y1*${p} + float(y)*(height_scale)`]:["0.0","0.0",`0.5 * (y1+y2) * ${p}`],[C,v,$]=d>1?[`${(s-1)/(d-1)}`,"(x2-x1) * width_ratio",`x1*${f} + float(x)*(width_scale)`]:["0.0","0.0",`0.5 * (x1+x2) * ${f}`];this.userCode=`\n      const float height_ratio = float(${x});\n      const float width_ratio = float(${C});\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int y = coords[1];\n        int x = coords[2];\n        int d = coords[3];\n\n        // get box vals\n        float y1 = getBoxes(b,0);\n        float x1 = getBoxes(b,1);\n        float y2 = getBoxes(b,2);\n        float x2 = getBoxes(b,3);\n\n        // get image in batch index\n        int bInd = round(getBoxInd(b));\n        if(bInd < 0 || bInd >= ${i}) {\n          return;\n        }\n\n        float height_scale = ${g};\n        float width_scale = ${v};\n\n        float in_y = ${m};\n        if( in_y < 0.0 || in_y > ${p} ) {\n          setOutput(float(${o}));\n          return;\n        }\n        float in_x = ${$};\n        if( in_x < 0.0 || in_x > ${f} ) {\n          setOutput(float(${o}));\n          return;\n        }\n\n        vec2 sourceFracIndexCR = vec2(in_x,in_y);\n        if(${h} == 1) {\n          // Compute the four integer indices.\n          ivec2 sourceFloorCR = ivec2(sourceFracIndexCR);\n          ivec2 sourceCeilCR = ivec2(ceil(sourceFracIndexCR));\n\n          float topLeft = getImage(b, sourceFloorCR.y, sourceFloorCR.x, d);\n          float bottomLeft = getImage(b, sourceCeilCR.y, sourceFloorCR.x, d);\n          float topRight = getImage(b, sourceFloorCR.y, sourceCeilCR.x, d);\n          float bottomRight = getImage(b, sourceCeilCR.y, sourceCeilCR.x, d);\n\n          vec2 fracCR = sourceFracIndexCR - vec2(sourceFloorCR);\n\n          float top = topLeft + (topRight - topLeft) * fracCR.x;\n          float bottom = bottomLeft + (bottomRight - bottomLeft) * fracCR.x;\n          float newValue = top + (bottom - top) * fracCR.y;\n          setOutput(newValue);\n        } else {\n          // Compute the coordinators of nearest neighbor point.\n          ivec2 sourceNearestCR = ivec2(floor(\n            sourceFracIndexCR + vec2(0.5,0.5)));\n          float newValue = getImage(b, sourceNearestCR.y, sourceNearestCR.x, d);\n          setOutput(newValue);\n        }\n      }\n    `}}class wt{constructor(e,t,n){this.variableNames=["x"],this.outputShape=e;const r=e.length,o=t?"0.0":`getX(${yt(r,"coords")})`,i=e[e.length-1];let a="",s="";t?(a=n?`end != ${i-1}`:"end != 0",s=n?"end + 1":"end - 1"):(a=n?`end + pow2 < ${i}`:"end >= pow2",s=n?"end + pow2":"end - pow2"),this.userCode=`\n      uniform float index;\n      void main() {\n        ${Je(r)} coords = getOutputCoords();\n        int end = ${It(r,"coords")};\n        float val = ${o};\n        int pow2 = int(pow(2.0, index));\n        if (${a}) {\n          int idx = ${s};\n          ${It(r,"coords")} = idx;\n          val += getX(${yt(r,"coords")});\n        }\n        setOutput(val);\n      }\n    `}getCustomSetupFunc(e){return(t,n)=>{null==this.index&&(this.index=t.getUniformLocation(n,"index")),t.gl.uniform1f(this.index,e)}}}function yt(e,t){if(1===e)return`${t}`;if(2===e)return`${t}.x, ${t}.y`;if(3===e)return`${t}.x, ${t}.y, ${t}.z`;if(4===e)return`${t}.x, ${t}.y, ${t}.z, ${t}.w`;throw Error(`Cumulative sum for rank ${e} is not yet supported`)}function It(e,t){if(1===e)return`${t}`;if(2===e)return`${t}.y`;if(3===e)return`${t}.z`;if(4===e)return`${t}.w`;throw Error(`Cumulative sum for rank ${e} is not yet supported`)}class Et{constructor(e){this.variableNames=["A"],this.packedInputs=!1,this.packedOutput=!0,this.outPackingScheme=a.DENSE;const t=c(e),n=Be();this.outputShape=e,this.userCode=`\n      ivec3 outCoordsFromFlatIndex(int index) {\n        ${Ve(["r","c","d"],e)}\n        return ivec3(r, c, d);\n      }\n\n      void main() {\n        ivec2 resTexRC = ivec2(resultUV.yx *\n          vec2(${t[0]}, ${t[1]}));\n        int index = 4 * (resTexRC.x * ${t[1]} + resTexRC.y);\n\n        vec4 result = vec4(0.);\n\n        for (int i=0; i<4; i++) {\n          int flatIndex = index + i;\n          ivec3 rc = outCoordsFromFlatIndex(flatIndex);\n          result[i] = getA(rc.x, rc.y, rc.z);\n        }\n\n        ${n.output} = result;\n      }\n    `}}class At{constructor(e){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.outPackingScheme=a.DENSE;const t=c(e),n=Be();this.outputShape=e,this.userCode=`\n      ivec3 outCoordsFromFlatIndex(int index) {\n        ${Ve(["r","c","d"],e)}\n        return ivec3(r, c, d);\n      }\n\n      void main() {\n        ivec2 resTexRC = ivec2(resultUV.yx *\n          vec2(${t[0]}, ${t[1]}));\n        int index = 4 * (resTexRC.x * ${t[1]} + resTexRC.y);\n\n        vec4 result = vec4(0.);\n\n        for (int i=0; i<4; i++) {\n          int flatIndex = index + i;\n          ivec3 rc = outCoordsFromFlatIndex(flatIndex);\n          result[i] = getChannel(getA(rc.x, rc.y, rc.z), vec2(rc.y, rc.z));\n        }\n\n        ${n.output} = result;\n      }\n    `}}class Tt{constructor(e,t,n){this.variableNames=["x"],this.outputShape=[],this.outputShape=e,this.blockSize=t,this.dataFormat=n,this.userCode=`\n    void main() {\n      ivec4 coords = getOutputCoords();\n      int b = coords[0];\n      int h = ${this.getHeightCoordString()};\n      int w = ${this.getWidthCoordString()};\n      int d = ${this.getDepthCoordString()};\n\n      int in_h = h / ${t};\n      int offset_h = imod(h, ${t});\n      int in_w = w / ${t};\n      int offset_w = imod(w, ${t});\n      int offset_d = (offset_h * ${t} + offset_w) *\n        ${this.getOutputDepthSize()};\n      int in_d = d + offset_d;\n\n      float result = ${this.getInputSamplingString()};\n      setOutput(result);\n    }\n  `}getHeightCoordString(){return"NHWC"===this.dataFormat?"coords[1]":"coords[2]"}getWidthCoordString(){return"NHWC"===this.dataFormat?"coords[2]":"coords[3]"}getDepthCoordString(){return"NHWC"===this.dataFormat?"coords[3]":"coords[1]"}getOutputDepthSize(){return"NHWC"===this.dataFormat?this.outputShape[3]:this.outputShape[1]}getInputSamplingString(){return"NHWC"===this.dataFormat?"getX(b, in_h, in_w, in_d)":"getX(b, in_d, in_h, in_w)"}}class Ot{constructor(e){this.variableNames=["X"],this.outputShape=[e,e],this.userCode="\n      void main() {\n          ivec2 coords = getOutputCoords();\n          float val = coords[0] == coords[1] ? getX(coords[0]) : 0.0;\n          setOutput(val);\n      }\n    "}}class _t{constructor(e){this.variableNames=["A"],this.outTexUsage=s.DOWNLOAD;const t=Be();this.outputShape=e,this.userCode=`\n      ${We}\n\n      void main() {\n        float x = getAAtOutCoords();\n        ${t.output} = encode_float(x);\n      }\n    `}}class St{constructor(e){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!1,this.outTexUsage=s.DOWNLOAD;const t=Be();this.outputShape=e,this.userCode=`\n      ${We}\n\n      void main() {\n        ivec3 coords = getOutputCoords();\n        float x = getChannel(getAAtOutCoords(), vec2(coords.y, coords.z));\n        ${t.output} = encode_float(x);\n      }\n    `}}class Nt{constructor(e,t,n=!1){this.variableNames=["A"];const r=Be(),[o,i]=t;this.outputShape=e;let a="result";n&&(a="floor(result * 255. + 0.5)"),this.userCode=`\n      ${Me(e)}\n\n      void main() {\n        ivec3 coords = getOutputCoords();\n\n        int flatIndex = getFlatIndex(coords);\n        int offset = imod(flatIndex, 4);\n\n        flatIndex = idiv(flatIndex, 4, 1.);\n\n        int r = flatIndex / ${i};\n        int c = imod(flatIndex, ${i});\n        vec2 uv = (vec2(c, r) + halfCR) / vec2(${i}.0, ${o}.0);\n        vec4 values = ${r.texture2D}(A, uv);\n\n        float result;\n\n        if(offset == 0) {\n          result = values[0];\n        } else if(offset == 1) {\n          result = values[1];\n        } else if(offset == 2) {\n          result = values[2];\n        } else {\n          result = values[3];\n        }\n\n        ${r.output} = vec4(${a}, 0., 0., 0.);\n      }\n    `}}class Ft{constructor(e,t,n=!1){this.variableNames=["A"],this.packedInputs=!1,this.packedOutput=!0;const r=Be(),[o,i]=t;this.outputShape=e;let a="",s="result";n&&(s="floor(result * 255. + 0.5)");for(let t=0;t<=1;t++)for(let n=0;n<=1;n++){const s=2*t+n;a+=`\n          localCoords = coords;\n          if(localCoords[2] + ${n} < ${e[2]}) {\n            localCoords[2] += ${n};\n            if(localCoords[1] + ${t} < ${e[1]}) {\n              localCoords[1] += ${t};\n\n              flatIndex = getFlatIndex(localCoords);\n              offset = imod(flatIndex, 4);\n\n              flatIndex = idiv(flatIndex, 4, 1.);\n\n              r = flatIndex / ${i};\n              c = imod(flatIndex, ${i});\n              uv = (vec2(c, r) + halfCR) / vec2(${i}.0, ${o}.0);\n              values = ${r.texture2D}(A, uv);\n\n              if(offset == 0) {\n                result[${s}] = values[0];\n              } else if(offset == 1) {\n                result[${s}] = values[1];\n              } else if(offset == 2) {\n                result[${s}] = values[2];\n              } else {\n                result[${s}] = values[3];\n              }\n            }\n          }\n        `}this.userCode=`\n      ${Me(e)}\n\n      void main() {\n        ivec3 coords = getOutputCoords();\n\n        vec4 result = vec4(0.);\n        int flatIndex, r, c, offset;\n        ivec3 localCoords;\n        vec2 uv;\n        vec4 values;\n\n        ${a}\n\n        ${r.output} = ${s};\n      }\n    `}}class kt{constructor(e,t){this.outputShape=[],this.variableNames=["x"],this.outputShape=e,this.userCode="\n      uniform float value;\n      void main() {\n        // Input can be obtained from uniform value.\n        setOutput(value);\n      }\n    "}getCustomSetupFunc(e){return(t,n)=>{null==this.valueLoc&&(this.valueLoc=t.getUniformLocationNoThrow(n,"value")),t.gl.uniform1f(this.valueLoc,e)}}}class Dt{constructor(e,t,n){this.variableNames=["A","indices"];const r=e.slice();r[n]=t,this.outputShape=r,this.rank=r.length;const o=Je(this.rank),i=function(e,t){const n=e.length;if(n>4)throw Error(`Gather for rank ${n} is not yet supported`);if(1===n)return"int(getIndices(resRC))";const r=["resRC.x","resRC.y","resRC.z","resRC.w"],o=[];for(let n=0;n<e.length;n++)n===t?o.push(`int(getIndices(${r[n]}))`):o.push(`${r[n]}`);return o.join()}(e,n);this.userCode=`\n      void main() {\n        ${o} resRC = getOutputCoords();\n        setOutput(getA(${i}));\n      }\n    `}}class Pt{constructor(e,t,n){this.sliceDim=e,this.strides=t,this.variableNames=["x","indices"],this.outputShape=n;const r=Je(t.length),o=Je(n.length),i=this.sliceDim>1?"strides[j]":"strides";this.userCode=`\n        ${r} strides = ${r}(${this.strides});\n         void main() {\n          ${o} coords = getOutputCoords();\n          int flattenIndex = 0;\n          for (int j = 0; j < ${this.sliceDim}; j++) {\n            int index = round(getIndices(coords[0], j));\n            flattenIndex += index * ${i};\n          }\n          setOutput(getX(flattenIndex, coords[1]));\n        }\n      `}}function Lt(e){const t=Be();return m(e,`${t.version}\n    precision highp float;\n    ${t.attribute} vec3 clipSpacePos;\n    ${t.attribute} vec2 uv;\n    ${t.varyingVs} vec2 resultUV;\n\n    void main() {\n      gl_Position = vec4(clipSpacePos, 1);\n      resultUV = uv;\n    }`)}function Bt(e){return w(e,new Float32Array([-1,1,0,0,1,-1,-1,0,0,0,1,1,0,1,1,1,-1,0,1,0]))}function Vt(e){return y(e,new Uint16Array([0,1,2,2,1,3]))}function Mt(e,t,n,r,o,i){E(t,n);const a=I(e),s=e.TEXTURE_2D;return p(e,()=>e.bindTexture(s,a)),p(e,()=>e.texParameteri(s,e.TEXTURE_WRAP_S,e.CLAMP_TO_EDGE)),p(e,()=>e.texParameteri(s,e.TEXTURE_WRAP_T,e.CLAMP_TO_EDGE)),p(e,()=>e.texParameteri(s,e.TEXTURE_MIN_FILTER,e.NEAREST)),p(e,()=>e.texParameteri(s,e.TEXTURE_MAG_FILTER,e.NEAREST)),p(e,()=>e.texImage2D(s,0,r,t,n,0,o,i,null)),p(e,()=>e.bindTexture(e.TEXTURE_2D,null)),a}function Wt(e){return e.internalFormatFloat}function Ut(e,t,n,r){const[o,i]=l(t,n);return Mt(e,o,i,Wt(r),r.textureFormatFloat,e.FLOAT)}function Gt(e){return e.internalFormatHalfFloat}function zt(e,t,n,r){const[o,i]=l(t,n);return Mt(e,o,i,Gt(r),r.textureFormatFloat,r.textureTypeHalfFloat)}function Xt(e){return e.downloadTextureFormat}function Ht(e,t,n,r){const[o,i]=l(t,n);return Mt(e,o,i,Xt(r),e.RGBA,e.UNSIGNED_BYTE)}function jt(e){return e.internalFormatPackedFloat}function Kt(e,t,n,r){const[o,i]=d(t,n);return Mt(e,o,i,jt(r),e.RGBA,e.FLOAT)}function qt(e){return e.internalFormatPackedHalfFloat}function Yt(e,t,n,r){const[o,i]=d(t,n);return Mt(e,o,i,qt(r),e.RGBA,r.textureTypeHalfFloat)}function Qt(e,t,n){return p(e,()=>e.bindBuffer(e.ARRAY_BUFFER,n)),T(e,t,"clipSpacePos",n,3,20,0)&&T(e,t,"uv",n,2,20,12)}function Zt(e,t,n,r,o,i){let a,s,u;p(e,()=>e.bindTexture(e.TEXTURE_2D,t)),o instanceof Uint8Array?(a=new Uint8Array(n*r*4),s=e.UNSIGNED_BYTE,u=e.RGBA):(a=new Float32Array(n*r*4),s=e.FLOAT,u=i.internalFormatPackedFloat),a.set(o),p(e,()=>e.texImage2D(e.TEXTURE_2D,0,u,n,r,0,e.RGBA,s,a)),p(e,()=>e.bindTexture(e.TEXTURE_2D,null))}function Jt(e,t,n){p(e,()=>e.bindTexture(e.TEXTURE_2D,t)),n.data instanceof Uint8Array?p(e,()=>e.texImage2D(e.TEXTURE_2D,0,e.RGBA,n.width,n.height,0,e.RGBA,e.UNSIGNED_BYTE,n.data)):p(e,()=>e.texImage2D(e.TEXTURE_2D,0,e.RGBA,e.RGBA,e.UNSIGNED_BYTE,n)),p(e,()=>e.bindTexture(e.TEXTURE_2D,null))}function en(e,t,n,r){const o=e.createBuffer();p(e,()=>e.bindBuffer(e.PIXEL_PACK_BUFFER,o));const i=16*t*n;return p(e,()=>e.bufferData(e.PIXEL_PACK_BUFFER,i,e.STREAM_READ)),p(e,()=>e.readPixels(0,0,n,t,e.RGBA,e.FLOAT,0)),p(e,()=>e.bindBuffer(e.PIXEL_PACK_BUFFER,null)),o}function tn(e,t,n){const r=e,o=new Float32Array(n);return r.bindBuffer(r.PIXEL_PACK_BUFFER,t),r.getBufferSubData(r.PIXEL_PACK_BUFFER,0,o),r.bindBuffer(r.PIXEL_PACK_BUFFER,null),o}function nn(e,t,n,r){const[o,i]=l(t,n),a=new Uint8Array(t*n*4);return p(e,()=>e.readPixels(0,0,o,i,r.downloadTextureFormat,e.UNSIGNED_BYTE,a)),new Float32Array(a.buffer)}function rn(e,t,n,r,o,i,a,s){const u=e,l=new Float32Array(function(e,t){const[n,r]=d(e,t);return n*r*4}(i,a));return u.bindBuffer(u.PIXEL_PACK_BUFFER,t),u.getBufferSubData(u.PIXEL_PACK_BUFFER,0,l),u.bindBuffer(u.PIXEL_PACK_BUFFER,null),l}function on(e,t,n){const r=new Float32Array(t*n*4);return p(e,()=>e.readPixels(0,0,n,t,e.RGBA,e.FLOAT,r)),r}var an=Object.freeze({__proto__:null,createVertexShader:Lt,createVertexBuffer:Bt,createIndexBuffer:Vt,getInternalFormatForFloat32MatrixTexture:Wt,createFloat32MatrixTexture:Ut,getInternalFormatForFloat16MatrixTexture:Gt,createFloat16MatrixTexture:zt,getInternalFormatForUnsignedBytesMatrixTexture:Xt,createUnsignedBytesMatrixTexture:Ht,getInternalFormatForPackedMatrixTexture:jt,createPackedMatrixTexture:Kt,getInternalFormatForFloat16PackedMatrixTexture:qt,createFloat16PackedMatrixTexture:Yt,bindVertexProgramAttributeStreams:Qt,uploadDenseMatrixToTexture:Zt,uploadPixelDataToTexture:Jt,createBufferFromOutputTexture:en,downloadFloat32MatrixFromBuffer:tn,downloadByteEncodedFloatMatrixFromOutputTexture:nn,downloadPackedMatrixFromBuffer:rn,downloadMatrixFromPackedOutputTexture:on});class sn{constructor(e){this.outputTexture=null,this.program=null,this.disposed=!1,this.vertexAttrsAreBound=!1,this.itemsToPoll=[];const n=t.env().getNumber("WEBGL_VERSION");null!=e?(this.gl=e,o(n,e)):this.gl=i(n);let r="WEBGL_color_buffer_float";if(1===t.env().getNumber("WEBGL_VERSION")){const e="OES_texture_float",n="OES_texture_half_float";if(this.textureFloatExtension=g(this.gl,e),Y(this.gl,n))this.textureHalfFloatExtension=g(this.gl,n);else if(t.env().get("WEBGL_FORCE_F16_TEXTURES"))throw new Error("GL context does not support half float textures, yet the environment flag WEBGL_FORCE_F16_TEXTURES is set to true.");if(this.colorBufferFloatExtension=this.gl.getExtension(r),Y(this.gl,"EXT_color_buffer_half_float"))this.colorBufferHalfFloatExtension=g(this.gl,"EXT_color_buffer_half_float");else if(t.env().get("WEBGL_FORCE_F16_TEXTURES"))throw new Error("GL context does not support color renderable half floats, yet the environment flag WEBGL_FORCE_F16_TEXTURES is set to true.")}else if(r="EXT_color_buffer_float",Y(this.gl,r))this.colorBufferFloatExtension=this.gl.getExtension(r);else{if(!Y(this.gl,"EXT_color_buffer_half_float"))throw new Error("GL context does not support color renderable floats");this.colorBufferHalfFloatExtension=this.gl.getExtension("EXT_color_buffer_half_float")}this.vertexBuffer=Bt(this.gl),this.indexBuffer=Vt(this.gl),this.framebuffer=A(this.gl),this.textureConfig=h(this.gl,this.textureHalfFloatExtension)}get debug(){return t.env().getBool("DEBUG")}dispose(){if(this.disposed)return;null!=this.program&&console.warn("Disposing a GPGPUContext that still has a bound WebGLProgram. This is probably a resource leak, delete the program with GPGPUContext.deleteProgram before disposing."),null!=this.outputTexture&&console.warn("Disposing a GPGPUContext that still has a bound output matrix texture.  This is probably a resource leak, delete the output matrix texture with GPGPUContext.deleteMatrixTexture before disposing.");const e=this.gl;p(e,()=>e.finish()),p(e,()=>e.bindFramebuffer(e.FRAMEBUFFER,null)),p(e,()=>e.deleteFramebuffer(this.framebuffer)),p(e,()=>e.bindBuffer(e.ARRAY_BUFFER,null)),p(e,()=>e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,null)),p(e,()=>e.deleteBuffer(this.indexBuffer)),this.disposed=!0}createFloat32MatrixTexture(e,t){return this.throwIfDisposed(),Ut(this.gl,e,t,this.textureConfig)}createFloat16MatrixTexture(e,t){return this.throwIfDisposed(),zt(this.gl,e,t,this.textureConfig)}createUnsignedBytesMatrixTexture(e,t){return this.throwIfDisposed(),Ht(this.gl,e,t,this.textureConfig)}uploadPixelDataToTexture(e,t){this.throwIfDisposed(),Jt(this.gl,e,t)}uploadDenseMatrixToTexture(e,t,n,r){this.throwIfDisposed(),Zt(this.gl,e,t,n,r,this.textureConfig)}createFloat16PackedMatrixTexture(e,t){return this.throwIfDisposed(),Yt(this.gl,e,t,this.textureConfig)}createPackedMatrixTexture(e,t){return this.throwIfDisposed(),Kt(this.gl,e,t,this.textureConfig)}deleteMatrixTexture(e){this.throwIfDisposed(),this.outputTexture===e&&(k(this.gl,this.framebuffer),this.outputTexture=null),p(this.gl,()=>this.gl.deleteTexture(e))}downloadByteEncodedFloatMatrixFromOutputTexture(e,t,n){return this.downloadMatrixDriver(e,()=>nn(this.gl,t,n,this.textureConfig))}downloadPackedMatrixFromBuffer(e,t,n,r,o,i){return rn(this.gl,e,0,0,0,o,i,this.textureConfig)}downloadFloat32MatrixFromBuffer(e,t){return tn(this.gl,e,t)}createBufferFromTexture(e,t,n){this.bindTextureToFrameBuffer(e);const r=en(this.gl,t,n,this.textureConfig);return this.unbindTextureToFrameBuffer(),r}createAndWaitForFence(){const e=this.createFence(this.gl);return this.pollFence(e)}createFence(e){let n,r;if(t.env().getBool("WEBGL_FENCE_API_ENABLED")){const t=e,o=t.fenceSync(t.SYNC_GPU_COMMANDS_COMPLETE,0);e.flush(),r=()=>{const e=t.clientWaitSync(o,0,0);return e===t.ALREADY_SIGNALED||e===t.CONDITION_SATISFIED},n=o}else t.env().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION")>0?(n=this.beginQuery(),this.endQuery(),r=()=>this.isQueryAvailable(n,t.env().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION"))):r=()=>!0;return{query:n,isFencePassed:r}}downloadMatrixFromPackedTexture(e,t,n){return this.downloadMatrixDriver(e,()=>on(this.gl,t,n))}createProgram(e){this.throwIfDisposed();const t=this.gl,n=C(t,e),r=Lt(t),o=$(t);return p(t,()=>t.attachShader(o,r)),p(t,()=>t.attachShader(o,n)),R(t,o),this.debug&&b(t,o),this.vertexAttrsAreBound||(this.setProgram(o),this.vertexAttrsAreBound=Qt(t,this.program,this.vertexBuffer)),o}deleteProgram(e){this.throwIfDisposed(),e===this.program&&(this.program=null),null!=e&&p(this.gl,()=>this.gl.deleteProgram(e))}setProgram(e){this.throwIfDisposed(),this.program=e,null!=this.program&&this.debug&&b(this.gl,this.program),p(this.gl,()=>this.gl.useProgram(e))}getUniformLocation(e,t,n=!0){return this.throwIfDisposed(),n?_(this.gl,e,t):S(this.gl,e,t)}getAttributeLocation(e,t){return this.throwIfDisposed(),p(this.gl,()=>this.gl.getAttribLocation(e,t))}getUniformLocationNoThrow(e,t){return this.throwIfDisposed(),this.gl.getUniformLocation(e,t)}setInputMatrixTexture(e,t,n){this.throwIfDisposed(),this.throwIfNoProgram(),N(this.gl,e,t,n)}setOutputMatrixTexture(e,t,n){this.setOutputMatrixTextureDriver(e,n,t)}setOutputPackedMatrixTexture(e,t,n){this.throwIfDisposed();const[r,o]=d(t,n);this.setOutputMatrixTextureDriver(e,r,o)}setOutputMatrixWriteRegion(e,t,n,r){this.setOutputMatrixWriteRegionDriver(n,e,r,t)}setOutputPackedMatrixWriteRegion(e,t,n,r){throw new Error("setOutputPackedMatrixWriteRegion not implemented.")}debugValidate(){null!=this.program&&b(this.gl,this.program),D(this.gl)}executeProgram(){this.throwIfDisposed(),this.throwIfNoProgram();const e=this.gl;this.debug&&this.debugValidate(),p(e,()=>e.drawElements(e.TRIANGLES,6,e.UNSIGNED_SHORT,0))}blockUntilAllProgramsCompleted(){this.throwIfDisposed(),p(this.gl,()=>this.gl.finish())}getQueryTimerExtension(){return null==this.disjointQueryTimerExtension&&(this.disjointQueryTimerExtension=g(this.gl,2===t.env().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION")?"EXT_disjoint_timer_query_webgl2":"EXT_disjoint_timer_query")),this.disjointQueryTimerExtension}getQueryTimerExtensionWebGL2(){return this.getQueryTimerExtension()}getQueryTimerExtensionWebGL1(){return this.getQueryTimerExtension()}beginQuery(){if(2===t.env().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION")){const e=this.gl,t=this.getQueryTimerExtensionWebGL2(),n=e.createQuery();return e.beginQuery(t.TIME_ELAPSED_EXT,n),n}const e=this.getQueryTimerExtensionWebGL1(),n=e.createQueryEXT();return e.beginQueryEXT(e.TIME_ELAPSED_EXT,n),n}endQuery(){if(2===t.env().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION")){const e=this.gl,t=this.getQueryTimerExtensionWebGL2();return void e.endQuery(t.TIME_ELAPSED_EXT)}const e=this.getQueryTimerExtensionWebGL1();e.endQueryEXT(e.TIME_ELAPSED_EXT)}async waitForQueryAndGetTime(e){return await t.util.repeatedTry(()=>this.disposed||this.isQueryAvailable(e,t.env().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION"))),this.getQueryTime(e,t.env().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION"))}getQueryTime(e,t){if(0===t)return null;if(2===t){const t=this.gl;return t.getQueryParameter(e,t.QUERY_RESULT)/1e6}{const t=this.getQueryTimerExtensionWebGL1();return t.getQueryObjectEXT(e,t.QUERY_RESULT_EXT)/1e6}}isQueryAvailable(e,t){if(0===t)return!0;if(2===t){const t=this.gl,n=this.getQueryTimerExtensionWebGL2(),r=t.getQueryParameter(e,t.QUERY_RESULT_AVAILABLE);return null==this.disjoint&&(this.disjoint=this.gl.getParameter(n.GPU_DISJOINT_EXT)),r&&!this.disjoint}{const t=this.getQueryTimerExtensionWebGL1(),n=t.getQueryObjectEXT(e,t.QUERY_RESULT_AVAILABLE_EXT);return null==this.disjoint&&(this.disjoint=this.gl.getParameter(t.GPU_DISJOINT_EXT)),n&&!this.disjoint}}pollFence(e){return new Promise(t=>{this.addItemToPoll(()=>e.isFencePassed(),()=>t())})}pollItems(){const e=function(e){let t=0;for(;t<e.length;++t){if(!e[t]())break}return t-1}(this.itemsToPoll.map(e=>e.isDoneFn));for(let t=0;t<=e;++t){const{resolveFn:e}=this.itemsToPoll[t];e()}this.itemsToPoll=this.itemsToPoll.slice(e+1)}addItemToPoll(e,n){this.itemsToPoll.push({isDoneFn:e,resolveFn:n}),this.itemsToPoll.length>1||t.util.repeatedTry(()=>(this.pollItems(),0===this.itemsToPoll.length))}bindTextureToFrameBuffer(e){this.throwIfDisposed(),F(this.gl,e,this.framebuffer),this.debug&&D(this.gl)}unbindTextureToFrameBuffer(){null!=this.outputTexture?(F(this.gl,this.outputTexture,this.framebuffer),this.debug&&D(this.gl)):k(this.gl,this.framebuffer)}downloadMatrixDriver(e,t){this.bindTextureToFrameBuffer(e);const n=t();return this.unbindTextureToFrameBuffer(),n}setOutputMatrixTextureDriver(e,t,n){this.throwIfDisposed();const r=this.gl;F(r,e,this.framebuffer),this.debug&&D(r),this.outputTexture=e,p(r,()=>r.viewport(0,0,t,n)),p(r,()=>r.scissor(0,0,t,n))}setOutputMatrixWriteRegionDriver(e,t,n,r){this.throwIfDisposed(),p(this.gl,()=>this.gl.scissor(e,t,n,r))}throwIfDisposed(){if(this.disposed)throw new Error("Attempted to use disposed GPGPUContext.")}throwIfNoProgram(){if(null==this.program)throw new Error("No GPU program is currently set.")}}function un(e,n){if(e.length!==n.length)throw Error(`Binary was compiled with ${e.length} inputs, but `+`was executed with ${n.length} inputs`);e.forEach((e,r)=>{const o=e.logicalShape,i=n[r],a=i.shape;if(!t.util.arraysEqual(o,a))throw Error("Binary was compiled with different shapes than "+`the current args. Shapes ${o} and ${a} must match`);if(e.isUniform&&i.isUniform)return;const s=e.texShape,u=i.isUniform?null:i.texData.texShape;if(!t.util.arraysEqual(s,u))throw Error("Binary was compiled with different texture shapes than the"+` current args. Shape ${s} and ${u} must match`)})}class ln{constructor(e,t,n){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=e;const{filterWidth:r,inChannels:o,strideWidth:i,strideHeight:a,padInfo:s,outWidth:u,dilationWidth:l,dilationHeight:c,dataFormat:d}=n,{left:h,top:p}=s,f=o*r,x=Be(),g="channelsLast"===d,m=g?0:1,C=g?1:2;let v="";for(let n=0;n<=1;n++)for(let r=0;r<=1;r++)v+=`\n          blockIndex = rc.y + ${r};\n          pos = rc.x + ${n};\n\n          if(blockIndex < ${e[1]} && pos < ${e[0]}) {\n            offsetY = int(blockIndex / (${u})) * ${a} - ${p};\n            d0 = offsetY + ${c} * (pos / ${f});\n\n            if(d0 < ${t[m]} && d0 >= 0) {\n\n              offsetX = int(mod(float(blockIndex), ${u}.) * ${i}. - ${h}.);\n              d1 = offsetX + ${l} * (int(mod(float(pos), ${f}.) / ${o}.));\n\n              if(d1 < ${t[C]} && d1 >= 0) {\n\n                ch = int(mod(float(pos), ${o}.));\n\n                if (${g}) {\n                  innerDims = vec2(d1, ch);\n                  result[${2*n+r}] = getChannel(\n                    getA(d0, int(innerDims.x),\n                    int(innerDims.y)), innerDims);\n                } else {\n                  innerDims = vec2(d0, d1);\n                  result[${2*n+r}] = getChannel(\n                    getA(ch, int(innerDims.x),\n                    int(innerDims.y)), innerDims);\n                }\n              }\n            }\n          }\n        `;this.userCode=`\n      void main() {\n        ivec2 rc = getOutputCoords();\n\n        vec4 result = vec4(0);\n\n        int blockIndex, pos, offsetY, d0, offsetX, d1, ch;\n        vec2 innerDims;\n\n        ${v}\n\n        ${x.output} = result;\n      }\n    `}}class cn{constructor(e,t,n,r,o){this.variableNames=["x"],this.outputShape=[];const i=t,a=e[3]-1;let s;this.outputShape=e;const u=`float(${n}) + float(${r}) * sum`;s=.5===o?`inversesqrt(${u})`:1===o?`1.0/(${u})`:`exp(log(${u}) * float(-${o}));`,this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int r = coords[1];\n        int c = coords[2];\n        int d = coords[3];\n        float x = getX(b, r, c, d);\n        float sum = 0.0;\n        for (int j = -${i}; j <= ${i}; j++) {\n          int idx = d + j;\n          if (idx >= 0 && idx <=  ${a}) {\n            float z = getX(b, r, c, idx);\n            sum += z * z;\n          }\n        }\n        float val = x * ${s};\n        setOutput(val);\n      }\n    `}}class dn{constructor(e,t,n,r,o){this.variableNames=["inputImage","outputImage","dy"],this.outputShape=[],this.outputShape=e,this.depth=e[3],this.depthRadius=t,this.bias=n,this.alpha=r,this.beta=o,this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int r = coords[1];\n        int c = coords[2];\n\n        float result = 0.0;\n        for (int d = 0; d < ${this.depth}; ++d) {\n          int depthBegin = int(max(0.0, float(d - ${t})));\n          int depthEnd = int(min(float(${this.depth}),\n              float(d + ${t} + 1)));\n\n          const int MIN_DEPTH_BEGIN = 0;\n          const int MAX_DEPTH_END = ${this.depth};\n\n          float norm = 0.0;\n          for (int k = MIN_DEPTH_BEGIN; k < MAX_DEPTH_END; ++k) {\n            if (k < depthBegin){\n              continue;\n            }\n            else if (k >= depthBegin && k < depthEnd) {\n              norm += getInputImage(b, r, c, k) * getInputImage(b, r, c, k);\n            }\n            else {\n              break;\n            }\n          }\n\n          norm = float(${r}) * norm + float(${n});\n\n          for(int k = MIN_DEPTH_BEGIN; k < MAX_DEPTH_END; ++k){\n            if (k < depthBegin){\n              continue;\n            }\n            else if (k >= depthBegin && k < depthEnd){\n              float dyi = -2.0 * float(${r})\n                * float(${o})\n                * getInputImage(b ,r ,c, k) * getOutputImage(b, r, c, d)\n                / norm;\n              if (k == d) {\n                dyi += pow(norm, -1.0 * ${o});\n              }\n              if (k == coords[3]) {\n                dyi *= getDy(b, r, c, d);\n                result += dyi;\n              }\n            }\n            else {\n              break;\n            }\n          }\n      }\n      setOutput(result);\n      }\n    `}}class hn{constructor(e,t,n,r,o){this.variableNames=["x"],this.outputShape=[],this.packedInputs=!0,this.packedOutput=!0;const i=t,a=e[3]-1;let s;this.outputShape=e;const u=`float(${n}) + float(${r}) * sum`;s=.5===o?`inversesqrt(${u})`:1===o?`1.0/(${u})`:`exp(log(${u}) * float(-${o}));`,this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords.x;\n        int r = coords.y;\n        int c = coords.z;\n        int d = coords.w;\n\n        bool hasNextCol = d < ${this.outputShape[3]};\n        bool hasNextRow = c < ${this.outputShape[2]};\n\n        vec4 sum = vec4(0.);\n        vec4 xFragAtOutputCoords = getX(b, r, c, d);\n\n        vec4 xAtOutputCoords = vec4(\n          getChannel(xFragAtOutputCoords, vec2(c, d)),\n          hasNextCol ?\n            getChannel(xFragAtOutputCoords, vec2(c, d + 1)) : 0.0,\n          hasNextRow ?\n            getChannel(xFragAtOutputCoords , vec2(c + 1, d)) : 0.0,\n          (hasNextRow && hasNextCol) ?\n            getChannel(xFragAtOutputCoords, vec2(c + 1, d + 1)) : 0.0\n        );\n\n        int firstChannel = d - ${i};\n        vec2 cache = vec2(0.);\n        if(firstChannel >= 0){\n          vec4 firstChannelFrag = getX(b, r, c, firstChannel);\n          cache.x = getChannel(firstChannelFrag, vec2(c, firstChannel));\n            if(hasNextRow){\n              cache.y = getChannel(firstChannelFrag, vec2(c + 1, firstChannel));\n            }\n        }\n\n        ivec2 depth = ivec2(d, d + 1);\n        for (int j = - ${i}; j <= ${i}; j++) {\n          ivec2 idx = depth + j;\n          bvec2 aboveLowerBound = greaterThanEqual(idx, ivec2(0));\n          bvec2 belowUpperBound = lessThanEqual(idx, ivec2(${a}));\n\n          bool depthInRange = aboveLowerBound.x && belowUpperBound.x;\n          bool depthPlusOneInRange = aboveLowerBound.y && belowUpperBound.y;\n\n          if(depthInRange || depthPlusOneInRange){\n            vec4 z = vec4(0.);\n            vec4 xFragAtCurrentDepth;\n            z.xz = cache.xy;\n            if(depthPlusOneInRange && hasNextCol){\n              xFragAtCurrentDepth = idx.y != d ?\n                getX(b, r, c, idx.y) : xFragAtOutputCoords;\n              z.y = getChannel(xFragAtCurrentDepth, vec2(c, idx.y));\n              if(hasNextRow){\n                z.w = getChannel(xFragAtCurrentDepth, vec2(c + 1, idx.y));\n              }\n            }\n            cache.xy = z.yw;\n            sum += z * z;\n          }\n        }\n        vec4 result = xAtOutputCoords * ${s};\n        setOutput(result);\n      }\n    `}}class pn{constructor(e){this.variableNames=["dy","maxPos"],this.outputShape=e.inShape;const t=e.strideHeight,n=e.strideWidth,r=e.dilationHeight,o=e.effectiveFilterHeight,i=e.effectiveFilterWidth,a=o-1-e.padInfo.top,s=i-1-e.padInfo.left,u=o*i-1;this.userCode=`\n      const ivec2 pads = ivec2(${a}, ${s});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n\n        ivec2 dyRCCorner = coords.yz - pads;\n        int dyRCorner = dyRCCorner.x;\n        int dyCCorner = dyRCCorner.y;\n\n        // Convolve dy(?, ?, d) with pos mask(:, :, d) to get dx(xR, xC, d).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n        for (int wR = 0; wR < ${o};\n          wR += ${r}) {\n          float dyR = float(dyRCorner + wR) / ${t}.0;\n\n          if (dyR < 0.0 || dyR >= ${e.outHeight}.0 || fract(dyR) > 0.0) {\n            continue;\n          }\n          int idyR = int(dyR);\n\n          for (int wC = 0; wC < ${i}; wC++) {\n            float dyC = float(dyCCorner + wC) / ${n}.0;\n\n            if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                fract(dyC) > 0.0) {\n              continue;\n            }\n            int idyC = int(dyC);\n\n            float dyValue = getDy(b, idyR, idyC, d);\n            int maxPosValue = ${u} - int(getMaxPos(b, idyR, idyC, d));\n\n            // Get the current value, check it against the value from the\n            // position matrix.\n            int curPosValue = wR * ${i} + wC;\n            float mask = float(maxPosValue == curPosValue ? 1.0 : 0.0);\n\n            dotProd += dyValue * mask;\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class fn{constructor(e){this.variableNames=["dy","maxPos"],this.outputShape=e.inShape;const t=e.strideDepth,n=e.strideHeight,r=e.strideWidth,o=e.dilationDepth,i=e.dilationHeight,a=e.dilationWidth,s=e.effectiveFilterDepth,u=e.effectiveFilterHeight,l=e.effectiveFilterWidth,c=s-1-e.padInfo.front,d=u-1-e.padInfo.top,h=l-1-e.padInfo.left,p=s*u*l-1;this.userCode=`\n      const ivec3 pads = ivec3(${c}, ${d}, ${h});\n\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int batch = coords.x;\n        int ch = coords.u;\n\n        ivec3 dyCorner = ivec3(coords.y, coords.z, coords.w) - pads;\n        int dyDCorner = dyCorner.x;\n        int dyRCorner = dyCorner.y;\n        int dyCCorner = dyCorner.z;\n\n        // Convolve dy(?, ?, ?, ch) with pos mask(:, :, :, d) to get\n        // dx(xD, xR, xC, ch).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n\n        for (int wD = 0; wD < ${s};\n           wD += ${o}) {\n          float dyD = float(dyDCorner + wD) / ${t}.0;\n\n          if (dyD < 0.0 || dyD >= ${e.outDepth}.0 || fract(dyD) > 0.0) {\n            continue;\n          }\n          int idyD = int(dyD);\n\n          for (int wR = 0; wR < ${u};\n              wR += ${i}) {\n            float dyR = float(dyRCorner + wR) / ${n}.0;\n\n            if (dyR < 0.0 || dyR >= ${e.outHeight}.0 ||\n                fract(dyR) > 0.0) {\n              continue;\n            }\n            int idyR = int(dyR);\n\n            for (int wC = 0; wC < ${l};\n                wC += ${a}) {\n              float dyC = float(dyCCorner + wC) / ${r}.0;\n\n              if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                  fract(dyC) > 0.0) {\n                continue;\n              }\n              int idyC = int(dyC);\n\n              float dyValue = getDy(batch, idyD, idyR, idyC, ch);\n              int maxPosValue = ${p} -\n                  int(getMaxPos(batch, idyD, idyR, idyC, ch));\n\n              // Get the current value, check it against the value from the\n              // position matrix.\n              int curPosValue =\n                  wD * ${u} * ${l} +\n                  wR * ${l} + wC;\n              float mask = float(maxPosValue == curPosValue ? 1.0 : 0.0);\n\n              dotProd += dyValue * mask;\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class xn{constructor(e,t,n,r=!1,o=!1,i=!1,a=null,s=!1){this.variableNames=["matrixA","matrixB"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=n;const u=r?e[1]:e[2],l=Math.ceil(u/2),c=r?"i * 2, rc.y":"rc.y, i * 2",d=o?"rc.z, i * 2":"i * 2, rc.z",h=r?["a.xxyy","a.zzww"]:["a.xxzz","a.yyww"],p=o?["b.xzxz","b.ywyw"]:["b.xyxy","b.zwzw"];let f="",x="";a&&(f=s?`vec4 activation(vec4 a) {\n          vec4 b = getPreluActivationWeightsAtOutCoords();\n          ${a}\n        }`:`vec4 activation(vec4 x) {\n          ${a}\n        }`,x="result = activation(result);");const g=i?"result += getBiasAtOutCoords();":"";i&&this.variableNames.push("bias"),s&&this.variableNames.push("preluActivationWeights");let m="rc.x",C="rc.x";e[0]<t[0]?m=`int(min(float(rc.x), ${e[0]-1}.))`:t[0]<e[0]&&(C=`int(min(float(rc.x), ${t[0]-1}.))`),this.userCode=`\n      ${f}\n\n      const float sharedDimension = ${l}.0;\n\n      vec4 dot2x2ARowBCol(ivec3 rc) {\n        vec4 result = vec4(0);\n        for (int i = 0; i < ${l}; i++) {\n          int batchA = ${m};\n          int batchB = ${C};\n          vec4 a = getMatrixA(batchA, ${c});\n          vec4 b = getMatrixB(batchB, ${d});\n\n          // These swizzled products need to be separately added.\n          // See: https://github.com/tensorflow/tfjs/issues/1735\n          result += (${h[0]} * ${p[0]});\n          result += (${h[1]} * ${p[1]});\n        }\n        return result;\n      }\n\n      void main() {\n        ivec3 rc = getOutputCoords();\n        vec4 result = dot2x2ARowBCol(rc);\n\n        ${g}\n\n        ${x}\n\n        setOutput(result);\n      }\n    `}}class gn{constructor(e,t,n){this.variableNames=["probs"],this.outputShape=[e,n],this.userCode=`\n      uniform float seed;\n\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int batch = coords[0];\n\n        float r = random(seed);\n        float cdf = 0.0;\n\n        for (int i = 0; i < ${t-1}; i++) {\n          cdf += getProbs(batch, i);\n\n          if (r < cdf) {\n            setOutput(float(i));\n            return;\n          }\n        }\n\n        // If no other event happened, last event happened.\n        setOutput(float(${t-1}));\n      }\n    `}getCustomSetupFunc(e){return(t,n)=>{null==this.seedLoc&&(this.seedLoc=t.getUniformLocation(n,"seed")),t.gl.uniform1f(this.seedLoc,e)}}}class mn{constructor(e,t,n,r){this.variableNames=["indices"],this.outputShape=[e,t],this.userCode=`\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int index = round(getIndices(coords.x));\n        setOutput(mix(float(${r}), float(${n}),\n                      float(index == coords.y)));\n      }\n    `}}class Cn{constructor(e){this.variableNames=["A"],this.packedInputs=!1,this.packedOutput=!0,this.outputShape=e;const t=e.length;if(0===t)this.userCode="\n        void main() {\n          setOutput(vec4(getA(), 0., 0., 0.));\n        }\n      ";else{const n=Le("rc",t),r=Je(t),o=function(e,t,n){if(1===e)return`rc > ${t[0]}`;let r="";for(let o=e-2;o<e;o++)r+=`${n[o]} >= ${t[o]}`,o<e-1&&(r+="||");return r}(t,e,n),i=function(e,t,n,r){if(1===e)return"";const o=r.slice(-2);return`\n    int r = ${o[0]};\n    int c = ${o[1]};\n    int rp1 = r + 1;\n    int cp1 = c + 1;\n\n    bool cEdge = cp1 >= ${t};\n    bool rEdge = rp1 >= ${n};\n  `}(t,e[e.length-1],e[e.length-2],n),a=function(e,t){const n=e.length,r=function(e,t){const n=[];for(let r=0;r<=1;r++)for(let o=0;o<=1;o++){let i=`${0===r?"r":"rp1"}, ${0===o?"c":"cp1"}`;for(let n=2;n<e;n++)i=`${t[t.length-1-n]},`+i;n.push(i)}return n}(n,t);if(1===n)return`getA(rc),\n            rc + 1 >= ${e[0]} ? 0. : getA(rc + 1),\n            0, 0`;return`getA(${r[0]}),\n          cEdge ? 0. : getA(${r[1]}),\n          rEdge ? 0. : getA(${r[2]}),\n          rEdge || cEdge ? 0. : getA(${r[3]})`}(e,n);this.userCode=`\n        void main() {\n          ${r} rc = getOutputCoords();\n\n          if(${o}) {\n            setOutput(vec4(0));\n          } else {\n            ${i}\n\n            setOutput(vec4(${a}));\n          }\n        }\n      `}}}class vn{constructor(e,t,n){this.variableNames=["x"],this.outputShape=t.map((t,n)=>t[0]+e[n]+t[1]);const r=e.length,o=Je(r),i=t.map(e=>e[0]).join(","),a=t.map((t,n)=>t[0]+e[n]).join(","),s=["coords[0]","coords[1]","coords[2]","coords[3]"].slice(0,r);this.userCode=1!==r?`\n      ${o} start = ${o}(${i});\n      ${o} end = ${o}(${a});\n\n      void main() {\n        ${o} outC = getOutputCoords();\n        if (any(lessThan(outC, start)) || any(greaterThanEqual(outC, end))) {\n          setOutput(float(${n}));\n        } else {\n          ${o} coords = outC - start;\n          setOutput(getX(${s}));\n        }\n      }\n    `:`\n        int start = ${i};\n        int end = ${a};\n\n        void main() {\n          int outC = getOutputCoords();\n          if (outC < start || outC >= end) {\n            setOutput(float(${n}));\n          } else {\n            setOutput(getX(outC - start));\n          }\n        }\n      `}}class $n{constructor(e,t,n){this.variableNames=["x"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=t.map((t,n)=>t[0]+e[n]+t[1]);const r=e.length,o=Je(r),i=t.map(e=>e[0]).join(","),a=t.map((t,n)=>t[0]+e[n]).join(","),s=Le("rc",r),u=Le("source",r),l=`${s[r-1]} < ${this.outputShape[r-1]}`,c=1===r?"source":`vec2(${u.slice(-2).join()})`,d=[`${o} rc = outputLoc;`,`${s[r-1]} += 1;\n       if(${l}) {\n      `,1===r?"":`}\n       rc = outputLoc;\n       ${s[r-2]} += 1;\n       if(${s[r-2]} < ${this.outputShape[r-2]}) {`,1===r?"":`  ${s[r-1]} += 1;\n         if(${l}) {`],h=1===r?"rc < start || rc >= end":"any(lessThan(rc, start)) || any(greaterThanEqual(rc, end))";let p="";for(let e=0,t=1===r?2:4;e<t;e++)p+=`\n        ${d[e]}\n        if (${h}) {\n          result[${e}] = float(${n});\n        } else {\n          ${o} source = rc - start;\n          result[${e}] = getChannel(getX(${u.join()}), ${c});\n        }\n      `;p+=1===r?"} ":"}}",this.userCode=`\n      const ${o} start = ${o}(${i});\n      const ${o} end = ${o}(${a});\n\n      void main() {\n        ${o} outputLoc = getOutputCoords();\n        vec4 result = vec4(0.);\n        ${p}\n        setOutput(result);\n      }\n    `}}class Rn{constructor(e,t,n,r=!1,o=!1){if(this.variableNames=["x"],"avg"===t&&n)throw new Error("Cannot compute positions for average pool.");const i=e.filterWidth,a=e.strideHeight,s=e.strideWidth,u=e.dilationHeight,l=e.dilationWidth,c=e.effectiveFilterHeight,d=e.effectiveFilterWidth,h=e.padInfo.top,p=e.padInfo.left;this.outputShape=e.outShape;const f="avg"===t,x=`((batch  * ${e.inHeight} + xR) * ${e.inWidth} + xC) * ${e.inChannels} + d`,g=`(xR * ${e.inWidth} + xC) * ${e.inChannels} + d`;let m="0.0";if(f||(m="-1.0 / 1e-20"),n){const t=">=";return void(this.userCode=`\n        const ivec2 strides = ivec2(${a}, ${s});\n        const ivec2 pads = ivec2(${h}, ${p});\n\n        void main() {\n          ivec4 coords = getOutputCoords();\n          int batch = coords[0];\n          int d = coords[3];\n\n          ivec2 xRCCorner = coords.yz * strides - pads;\n          int xRCorner = xRCCorner.x;\n          int xCCorner = xRCCorner.y;\n\n          // max/min x(?, ?, d) to get y(yR, yC, d).\n          // ? = to be determined\n          float minMaxValue = 0.0;\n          float minMaxValueFound = 0.0;\n          int minMaxPosition = 0;\n          float avgValue = 0.0;\n\n          for (int wR = 0; wR < ${c};\n              wR += ${u}) {\n            int xR = xRCorner + wR;\n\n            if (xR < 0 || xR >= ${e.inHeight}) {\n              continue;\n            }\n\n            for (int wC = 0; wC < ${d};\n                wC += ${l}) {\n              int xC = xCCorner + wC;\n\n              if (xC < 0 || xC >= ${e.inWidth}) {\n                continue;\n              }\n\n              float value = getX(batch, xR, xC, d);\n\n              // If a min / max value has already been found, use it. If not,\n              // use the current value.\n              float currMinMaxValue = mix(\n                  value, minMaxValue, minMaxValueFound);\n              if (value ${t} currMinMaxValue) {\n                minMaxValue = value;\n                minMaxValueFound = 1.0;\n                minMaxPosition = ${r?o?x:g:`wR * ${d} + wC`};\n              }\n            }\n          }\n          setOutput(float(minMaxPosition));\n        }\n      `)}let C=`${t}(${t}(${t}(`+"minMaxValue[0], minMaxValue[1]), minMaxValue[2]), minMaxValue[3])";"avg"===t&&(C="avgValue / count");const v=4*Math.floor(i/4),$=i%4,R=`\n      if (${f}) {\n        avgValue += dot(values, ones);\n      } else {\n        minMaxValue = max(values, minMaxValue);\n      }\n    `;this.userCode=`\n      const ivec2 strides = ivec2(${a}, ${s});\n      const ivec2 pads = ivec2(${h}, ${p});\n      const float initializationValue = ${m};\n      const vec4 ones = vec4(1.0, 1.0, 1.0, 1.0);\n\n      float count = 0.0;\n\n      float getValue(int batch, int xR, int xC, int d) {\n        if (xC < 0 || xC >= ${e.inWidth}) {\n          return initializationValue;\n        }\n        count += 1.0;\n        return getX(batch, xR, xC, d);\n      }\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords[0];\n        int d = coords[3];\n\n        ivec2 xRCCorner = coords.yz * strides - pads;\n        int xRCorner = xRCCorner.x;\n        int xCCorner = xRCCorner.y;\n\n        // max/min x(?, ?, d) to get y(yR, yC, d).\n        // ? = to be determined\n        vec4 minMaxValue = vec4(${m});\n        float avgValue = 0.0;\n        count = 0.0;\n\n        for (int wR = 0; wR < ${c};\n            wR += ${u}) {\n          int xR = xRCorner + wR;\n\n          if (xR < 0 || xR >= ${e.inHeight}) {\n            continue;\n          }\n\n          for (int wC = 0; wC < ${v}; wC += 4) {\n            int xC = xCCorner + wC * ${l};\n\n            vec4 values = vec4(\n              getValue(batch, xR, xC, d),\n              getValue(batch, xR, xC + ${l}, d),\n              getValue(batch, xR, xC + 2 * ${l}, d),\n              getValue(batch, xR, xC + 3 * ${l}, d)\n            );\n\n            ${R}\n          }\n\n          int xC = xCCorner + ${v};\n          if (${1===$}) {\n            vec4 values = vec4(\n              getValue(batch, xR, xC, d),\n              initializationValue,\n              initializationValue,\n              initializationValue\n            );\n\n            ${R}\n          } else if (${2===$}) {\n            vec4 values = vec4(\n              getValue(batch, xR, xC, d),\n              getValue(batch, xR, xC + ${l}, d),\n              initializationValue,\n              initializationValue\n            );\n\n            ${R}\n          } else if (${3===$}) {\n            vec4 values = vec4(\n              getValue(batch, xR, xC, d),\n              getValue(batch, xR, xC + ${l}, d),\n              getValue(batch, xR, xC + 2 * ${l}, d),\n              initializationValue\n            );\n\n            ${R}\n          }\n        }\n        setOutput(${C});\n      }\n    `}}class bn{constructor(e,t,n,r=!1,o=!1){if(this.variableNames=["x"],"avg"===t&&n)throw new Error("Cannot compute positions for average pool.");const i=e.filterWidth,a=e.strideDepth,s=e.strideHeight,u=e.strideWidth,l=e.dilationDepth,c=e.dilationHeight,d=e.dilationWidth,h=e.effectiveFilterDepth,p=e.effectiveFilterHeight,f=e.effectiveFilterWidth,x=e.padInfo.front,g=e.padInfo.top,m=e.padInfo.left;this.outputShape=e.outShape;const C="avg"===t;let v="0.0";if(C||(v="-1.0 / 1e-20"),n){const t=">=";return void(this.userCode=`\n        const ivec3 strides =\n            ivec3(${a}, ${s}, ${u});\n        const ivec3 pads = ivec3(${x}, ${g}, ${m});\n\n        void main() {\n          ivec5 coords = getOutputCoords();\n          int batch = coords.x;\n          int ch = coords.u;\n\n          ivec3 xCorner = ivec3(coords.y, coords.z, coords.w) * strides - pads;\n          int xDCorner = xCorner.x;\n          int xRCorner = xCorner.y;\n          int xCCorner = xCorner.z;\n\n          // max/min x(?, ?, ?, ch) to get y(yD, yR, yC, ch).\n          // ? = to be determined\n          float minMaxValue = 0.0;\n          float minMaxValueFound = 0.0;\n          int minMaxPosition = 0;\n\n          for (int wD = 0; wD < ${h};\n              wD += ${l}) {\n            int xD = xDCorner + wD;\n\n            if (xD < 0 || xD >= ${e.inDepth}) {\n              continue;\n            }\n\n            for (int wR = 0; wR < ${p};\n                wR += ${c}) {\n              int xR = xRCorner + wR;\n\n              if (xR < 0 || xR >= ${e.inHeight}) {\n                continue;\n              }\n\n              for (int wC = 0; wC < ${f};\n                  wC += ${d}) {\n                int xC = xCCorner + wC;\n\n                if (xC < 0 || xC >= ${e.inWidth}) {\n                  continue;\n                }\n\n                float value = getX(batch, xD, xR, xC, ch);\n\n                // If a min / max value has already been found, use it. If not,\n                // use the current value.\n                float currMinMaxValue = mix(\n                    value, minMaxValue, minMaxValueFound);\n                if (value ${t} currMinMaxValue) {\n                  minMaxValue = value;\n                  minMaxValueFound = 1.0;\n                  minMaxPosition = ${r?o?`(((batch * ${e.inDepth} + xD) * ${e.inHeight} + xR) * ${e.inWidth} + xC) * ${e.inChannels} + ch`:`((xD * ${e.inHeight} + xR) * ${e.inWidth} + xC) * ${e.inChannels} + ch`:`wD * ${p} * ${f} +\n                      wR * ${f} + wC`};\n                }\n              }\n            }\n          }\n          setOutput(float(minMaxPosition));\n        }\n      `)}let $=`${t}(${t}(${t}(`+"minMaxValue[0], minMaxValue[1]), minMaxValue[2]), minMaxValue[3])";"avg"===t&&($="avgValue / count");const R=4*Math.floor(i/4),b=i%4,w=`\n      if (${C}) {\n        avgValue += dot(values, ones);\n      } else {\n        minMaxValue = max(values, minMaxValue);\n      }\n    `;this.userCode=`\n      const ivec3 strides =\n        ivec3(${a}, ${s}, ${u});\n      const ivec3 pads = ivec3(${x}, ${g}, ${m});\n      const float initializationValue = ${v};\n      const vec4 ones = vec4(1.0, 1.0, 1.0, 1.0);\n\n      float count = 0.0;\n\n      float getValue(int batch, int xD, int xR, int xC, int ch) {\n        if (xC < 0 || xC >= ${e.inWidth}) {\n          return initializationValue;\n        }\n        count += 1.0;\n        return getX(batch, xD, xR, xC, ch);\n      }\n\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int batch = coords.x;\n        int ch = coords.u;\n\n        ivec3 xCorner = ivec3(coords.y, coords.z, coords.w) * strides - pads;\n        int xDCorner = xCorner.x;\n        int xRCorner = xCorner.y;\n        int xCCorner = xCorner.z;\n\n        // max/min x(?, ?, ?, d) to get y(yD, yR, yC, ch).\n        // ? = to be determined\n        vec4 minMaxValue = vec4(${v});\n        float avgValue = 0.0;\n        count = 0.0;\n\n        for (int wD = 0; wD < ${h};\n            wD += ${l}) {\n          int xD = xDCorner + wD;\n\n          if (xD < 0 || xD >= ${e.inDepth}) {\n            continue;\n          }\n\n          for (int wR = 0; wR < ${p};\n            wR += ${c}) {\n            int xR = xRCorner + wR;\n\n            if (xR < 0 || xR >= ${e.inHeight}) {\n              continue;\n            }\n\n            for (int wC = 0; wC < ${R}; wC += 4) {\n              int xC = xCCorner + wC * ${d};\n\n              vec4 values = vec4(\n                getValue(batch, xD, xR, xC, ch),\n                getValue(batch, xD, xR, xC + ${d}, ch),\n                getValue(batch, xD, xR, xC + 2 * ${d}, ch),\n                getValue(batch, xD, xR, xC + 3 * ${d}, ch)\n              );\n\n              ${w}\n            }\n\n            int xC = xCCorner + ${R};\n            if (${1===b}) {\n              vec4 values = vec4(\n                getValue(batch, xD, xR, xC, ch),\n                initializationValue,\n                initializationValue,\n                initializationValue\n              );\n\n              ${w}\n            } else if (${2===b}) {\n              vec4 values = vec4(\n                getValue(batch, xD, xR, xC, ch),\n                getValue(batch, xD, xR, xC + ${d}, ch),\n                initializationValue,\n                initializationValue\n              );\n\n              ${w}\n            } else if (${3===b}) {\n              vec4 values = vec4(\n                getValue(batch, xD, xR, xC, ch),\n                getValue(batch, xD, xR, xC + ${d}, ch),\n                getValue(batch, xD, xR, xC + 2 * ${d}, ch),\n                initializationValue\n              );\n\n              ${w}\n            }\n          }\n          setOutput(${$});\n        }\n      }\n    `}}class wn{constructor(e,t){this.variableNames=["x"];const{windowSize:n,batchSize:r,inSize:o,outSize:i}=e;this.outputShape=[r,i];let a="0.0",s="";"prod"===t?a="1.0":"min"===t?(a="1.0 / 1e-20",s="min"):"max"===t&&(a="-1.0 / 1e-20",s="max");let u=`${t}(${t}(${t}(`+"minMaxValue[0], minMaxValue[1]), minMaxValue[2]), minMaxValue[3])";"sum"===t?u="sumValue":"prod"===t?u="prodValue":"all"===t?u="allValue":"any"===t&&(u="anyValue");const l=4*Math.floor(n/4),c=n%4;let d=`\n      if (${"sum"===t}) {\n        sumValue += dot(values, ones);\n      } else if (${"prod"===t}) {\n        vec2 tmp = vec2(values[0], values[1]) * vec2(values[2], values[3]);\n        prodValue *= tmp[0] * tmp[1];\n      } else {\n        minMaxValue = ${s}(values, minMaxValue);\n      }\n    `,h="vec4";"all"===t?(a="1.0",d="\n        bool reducedAllValue = all(values);\n        float floatedReducedAllValue = float(reducedAllValue);\n        allValue = float(allValue >= 1.0 && floatedReducedAllValue >= 1.0);\n      ",h="bvec4"):"any"===t&&(a="0.0",d="\n        bool reducedAnyValue = any(values);\n        float floatedReducedAnyValue = float(reducedAnyValue);\n        anyValue = float(anyValue >= 1.0 || floatedReducedAnyValue >= 1.0);\n      ",h="bvec4");let p="";o%n>0&&(p=`\n        if (inIdx < 0 || inIdx >= ${o}) {\n          return initializationValue;\n        }\n      `),this.userCode=`\n      const float initializationValue = ${a};\n      const vec4 ones = vec4(1.0, 1.0, 1.0, 1.0);\n\n      float getValue(int batch, int inIdx) {\n        ${p}\n        return getX(batch, inIdx);\n      }\n\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int batch = coords[0];\n        int outIdx = coords[1];\n        int inOffset = outIdx * ${n};\n\n        vec4 minMaxValue = vec4(${a});\n        float prodValue = 1.0;\n        float sumValue = 0.0;\n        float allValue = 1.0;\n        float anyValue = 0.0;\n\n        for (int i = 0; i < ${l}; i += 4) {\n          int inIdx = inOffset + i;\n          ${h} values = ${h}(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2),\n            getValue(batch, inIdx + 3)\n          );\n\n          ${d}\n        }\n\n        int inIdx = inOffset + ${l};\n        if (${1===c}) {\n          ${h} values = ${h}(\n            getValue(batch, inIdx),\n            initializationValue,\n            initializationValue,\n            initializationValue\n          );\n\n          ${d}\n        } else if (${2===c}) {\n          ${h} values = ${h}(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            initializationValue,\n            initializationValue\n          );\n\n          ${d}\n        } else if (${3===c}) {\n          ${h} values = ${h}(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2),\n            initializationValue\n          );\n\n          ${d}\n        }\n        setOutput(${u});\n      }\n    `}}class yn{constructor(e,t){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=e;let n="";for(let e=0;e<4;e++){let t="thisRC = rc;";e%2==1&&(t+="thisRC.z += 1;"),e>1&&(t+="thisRC.y += 1;"),n+=`\n        ${t}\n        ${e>0?"if(thisRC.y < rows && thisRC.z < cols){":""}\n          int flatIndex = getFlatIndex(thisRC);\n\n          ivec3 inputRC = inputCoordsFromReshapedOutCoords(flatIndex);\n          vec2 inputRCInnerDims = vec2(float(inputRC.y),float(inputRC.z));\n\n          result[${e}] =\n            getChannel(getA(inputRC.x, inputRC.y, inputRC.z), inputRCInnerDims);\n        ${e>0?"}":""}\n      `}var r;this.userCode=`\n      ${r=t,`\n    ivec3 inputCoordsFromReshapedOutCoords(int index) {\n      ${Ve(["r","c","d"],r)}\n      return ivec3(r, c, d);\n    }\n  `}\n      ${Me(e)}\n\n      void main() {\n        ivec3 rc = getOutputCoords();\n\n        vec4 result = vec4(0.);\n\n        ivec3 thisRC;\n        int rows = ${e[1]};\n        int cols = ${e[2]};\n\n        ${n}\n\n        setOutput(result);\n      }\n    `}}class In{constructor(e,t,n){this.variableNames=["dy"],this.outputShape=[],this.outputShape=t.shape;const[,r,o]=t.shape,[,i,a]=e.shape,s=[n&&i>1?r-1:r,n&&a>1?o-1:o],u=[n&&i>1?i-1:i,n&&a>1?a-1:a],l=s[0]/u[0],c=s[1]/u[1],d=1/l,h=1/c,p=2*Math.ceil(d)+2,f=2*Math.ceil(h)+2;this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n        int r = coords[1];\n        int c = coords[2];\n\n        float accumulator = 0.0;\n\n        const float heightScale = float(${l});\n        const float widthScale = float(${c});\n\n        const float invHeightScale = float(${d});\n        const float invWidthScale = float(${h});\n\n        const int winHeight = int(${p});\n        const int winWidth = int(${f});\n\n        // Compute bounds for where in dy we will look\n        float startRLerp = floor(float(r) * invHeightScale);\n        int startDyR = int(startRLerp - float(winHeight / 2));\n\n        float startCLerp = floor(float(c) * invWidthScale);\n        int startDyC = int(startCLerp - float(winWidth / 2));\n\n        // Loop over dy\n        for (int dyROffset = 0; dyROffset < winHeight; dyROffset++) {\n          int dyR = dyROffset + startDyR;\n\n          // Guard against the window exceeding the bounds of dy\n          if (dyR < 0 || dyR >= ${i}) {\n            continue;\n          }\n\n          for (int dyCOffset = 0; dyCOffset < winWidth; dyCOffset++) {\n            int dyC = dyCOffset + startDyC;\n\n            // Guard against the window exceeding the bounds of dy\n            if (dyC < 0 || dyC >= ${a}) {\n              continue;\n            }\n\n            float dxR = float(dyR) * heightScale;\n            int topDxRIndex = int(floor(dxR));\n            int bottomDxRIndex = int(min(ceil(dxR), ${r-1}.0));\n            float dxRLerp = dxR - float(topDxRIndex);\n            float inverseDxRLerp = 1.0 - dxRLerp;\n\n            float dxC = float(dyC) * widthScale;\n            int leftDxCIndex = int(floor(dxC));\n            int rightDxCIndex = int(min(ceil(dxC), ${o-1}.0));\n            float dxCLerp = dxC - float(leftDxCIndex);\n            float inverseDxCLerp = 1.0 - dxCLerp;\n\n            if (r == topDxRIndex && c == leftDxCIndex) {\n              // topLeft\n              accumulator +=\n                getDy(b, dyR, dyC, d) * inverseDxRLerp * inverseDxCLerp;\n            }\n\n            if (r == topDxRIndex && c == rightDxCIndex) {\n              // topRight\n              accumulator += getDy(b, dyR, dyC, d) * inverseDxRLerp * dxCLerp;\n            }\n\n            if (r == bottomDxRIndex && c == leftDxCIndex) {\n              // bottomLeft\n              accumulator += getDy(b, dyR, dyC, d) * dxRLerp * inverseDxCLerp;\n            }\n\n            if (r == bottomDxRIndex && c == rightDxCIndex) {\n              // bottomRight\n              accumulator += getDy(b, dyR, dyC, d) * dxRLerp * dxCLerp;\n            }\n          }\n        }\n        // End loop over dy\n\n        setOutput(accumulator);\n      }\n    `}}class En{constructor(e,t,n,r){this.variableNames=["A"],this.outputShape=[];const[o,i,a,s]=e;this.outputShape=[o,t,n,s];const u=[r&&t>1?i-1:i,r&&n>1?a-1:a],l=[r&&t>1?t-1:t,r&&n>1?n-1:n];this.userCode=`\n      const vec2 effectiveInputOverOutputRatioRC = vec2(\n          ${u[0]/l[0]},\n          ${u[1]/l[1]});\n      const vec2 inputShapeRC = vec2(${i}.0, ${a}.0);\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n        ivec2 yRC = coords.yz;\n\n        // Fractional source index.\n        vec2 sourceFracIndexRC = vec2(yRC) * effectiveInputOverOutputRatioRC;\n\n        // Compute the four integer indices.\n        ivec2 sourceFloorRC = ivec2(sourceFracIndexRC);\n        ivec2 sourceCeilRC = ivec2(\n          min(inputShapeRC - 1.0, ceil(sourceFracIndexRC)));\n\n        float topLeft = getA(b, sourceFloorRC.x, sourceFloorRC.y, d);\n        float bottomLeft = getA(b, sourceCeilRC.x, sourceFloorRC.y, d);\n        float topRight = getA(b, sourceFloorRC.x, sourceCeilRC.y, d);\n        float bottomRight = getA(b, sourceCeilRC.x, sourceCeilRC.y, d);\n\n        vec2 fracRC = sourceFracIndexRC - vec2(sourceFloorRC);\n\n        float top = topLeft + (topRight - topLeft) * fracRC.y;\n        float bottom = bottomLeft + (bottomRight - bottomLeft) * fracRC.y;\n        float newValue = top + (bottom - top) * fracRC.x;\n\n        setOutput(newValue);\n      }\n    `}}class An{constructor(e,t,n,r){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=[];const[o,i,a,s]=e;this.outputShape=[o,t,n,s];const u=[r&&t>1?i-1:i,r&&n>1?a-1:a],l=[r&&t>1?t-1:t,r&&n>1?n-1:n];this.userCode=`\n      const vec3 effectiveInputOverOutputRatioRC = vec3(\n          ${u[0]/l[0]},\n          ${u[1]/l[1]},\n          ${u[1]/l[1]});\n      const vec3 inputShapeRC = vec3(${i}.0, ${a}.0,\n                                     ${a}.0);\n\n      float getAValue(int b, int r, int c, int d) {\n        return getChannel(getA(b, r, c, d), vec2(c, d));\n      }\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n        // Calculate values for next column in yRC.z.\n        ivec3 yRC = coords.yzz + ivec3(0, 0, 1);\n\n        // Fractional source index.\n        vec3 sourceFracIndexRC = vec3(yRC) * effectiveInputOverOutputRatioRC;\n\n        // Compute the four integer indices.\n        ivec3 sourceFloorRC = ivec3(sourceFracIndexRC);\n        ivec3 sourceCeilRC = ivec3(\n          min(inputShapeRC - 1.0, ceil(sourceFracIndexRC)));\n\n        // Should we calculate next column and row elements in 2x2 packed cell.\n        bool hasNextCol = d < ${s-1};\n        bool hasNextRow = coords.z < ${n-1};\n\n        // In parallel, construct four corners for all four components in\n        // packed 2x2 cell.\n        vec4 topLeft = vec4(\n          getAValue(b, sourceFloorRC.x, sourceFloorRC.y, d),\n          hasNextCol ? getAValue(b, sourceFloorRC.x, sourceFloorRC.y, d + 1)\n                     : 0.0,\n          hasNextRow ? getAValue(b, sourceFloorRC.x, sourceFloorRC.z, d)\n                     : 0.0,\n          (hasNextRow && hasNextCol) ?\n            getAValue(b, sourceFloorRC.x, sourceFloorRC.z, d + 1) : 0.0);\n\n        vec4 bottomLeft = vec4(\n          getAValue(b, sourceCeilRC.x, sourceFloorRC.y, d),\n          hasNextCol ? getAValue(b, sourceCeilRC.x, sourceFloorRC.y, d + 1)\n                     : 0.0,\n          hasNextRow ? getAValue(b, sourceCeilRC.x, sourceFloorRC.z, d)\n                     : 0.0,\n          (hasNextRow && hasNextCol) ?\n            getAValue(b, sourceCeilRC.x, sourceFloorRC.z, d + 1) : 0.0);\n\n        vec4 topRight = vec4(\n          getAValue(b, sourceFloorRC.x, sourceCeilRC.y, d),\n          hasNextCol ? getAValue(b, sourceFloorRC.x, sourceCeilRC.y, d + 1)\n                     : 0.0,\n          hasNextRow ? getAValue(b, sourceFloorRC.x, sourceCeilRC.z, d)\n                     : 0.0,\n          (hasNextRow && hasNextCol) ?\n            getAValue(b, sourceFloorRC.x, sourceCeilRC.z, d + 1) : 0.0);\n\n        vec4 bottomRight = vec4(\n          getAValue(b, sourceCeilRC.x, sourceCeilRC.y, d),\n          hasNextCol ? getAValue(b, sourceCeilRC.x, sourceCeilRC.y, d + 1)\n                     : 0.0,\n          hasNextRow ? getAValue(b, sourceCeilRC.x, sourceCeilRC.z, d)\n                     : 0.0,\n          (hasNextRow && hasNextCol) ?\n            getAValue(b, sourceCeilRC.x, sourceCeilRC.z, d + 1) : 0.0);\n\n        vec3 fracRC = sourceFracIndexRC - vec3(sourceFloorRC);\n\n        vec4 top = mix(topLeft, topRight, fracRC.yyzz);\n        vec4 bottom = mix(bottomLeft, bottomRight, fracRC.yyzz);\n        vec4 newValue = mix(top, bottom, fracRC.x);\n\n        setOutput(newValue);\n      }\n    `}}class Tn{constructor(e,t,n){this.variableNames=["dy"],this.outputShape=[],this.outputShape=t.shape;const[,r,o]=t.shape,[,i,a]=e.shape,s=[n&&i>1?r-1:r,n&&a>1?o-1:o],u=[n&&i>1?i-1:i,n&&a>1?a-1:a],l=s[0]/u[0],c=s[1]/u[1],d=1/l,h=1/c,p=2*Math.ceil(d)+2,f=2*Math.ceil(h)+2;this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n        int r = coords[1];\n        int c = coords[2];\n\n        float accumulator = 0.0;\n\n        const float heightScale = float(${l});\n        const float widthScale = float(${c});\n\n        const float invHeightScale = float(${d});\n        const float invWidthScale = float(${h});\n\n        const int winHeight = int(${p});\n        const int winWidth = int(${f});\n\n        // Compute bounds for where in dy we will look\n        float startRLerp = floor(float(r) * invHeightScale);\n        int startDyR = int(floor(startRLerp - float(winHeight / 2)));\n\n        float startCLerp = floor(float(c) * invWidthScale);\n        int startDyC = int(floor(startCLerp - float(winWidth / 2)));\n\n        // Loop over dy\n        for (int dyROffset = 0; dyROffset < winHeight; dyROffset++) {\n          int dyR = dyROffset + startDyR;\n\n          // Guard against the window exceeding the bounds of dy\n          if (dyR < 0 || dyR >= ${i}) {\n            continue;\n          }\n\n          for (int dyCOffset = 0; dyCOffset < winWidth; dyCOffset++) {\n            int dyC = dyCOffset + startDyC;\n\n            // Guard against the window exceeding the bounds of dy\n            if (dyC < 0 || dyC >= ${a}) {\n              continue;\n            }\n\n            float sourceFracRow =\n              float(${s[0]}) *\n                (float(dyR) / float(${u[0]}));\n\n            float sourceFracCol =\n                float(${s[1]}) *\n                  (float(dyC) / float(${u[1]}));\n\n            int sourceNearestRow = int(min(\n                float(int(${r}) - 1),\n                ${n} ? float(round(sourceFracRow)) :\n                                  float(floor(sourceFracRow))));\n\n            int sourceNearestCol = int(min(\n                float(int(${o}) - 1),\n                ${n} ? float(round(sourceFracCol)) :\n                                  float(floor(sourceFracCol))));\n\n            if (r == sourceNearestRow && c == sourceNearestCol) {\n              accumulator += getDy(b, dyR, dyC, d);\n            }\n          }\n        }\n        // End loop over dy\n\n        setOutput(accumulator);\n      }\n    `}}class On{constructor(e,t,n,r){this.variableNames=["A"],this.outputShape=[];const[o,i,a,s]=e;this.outputShape=[o,t,n,s];const u=[r&&t>1?i-1:i,r&&n>1?a-1:a],l=[r&&t>1?t-1:t,r&&n>1?n-1:n],c=r?"0.5":"0.0";this.userCode=`\n      const vec2 effectiveInputOverOutputRatioRC = vec2(\n          ${u[0]/l[0]},\n          ${u[1]/l[1]});\n      const vec2 inputShapeRC = vec2(${i}.0, ${a}.0);\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n        ivec2 yRC = coords.yz;\n\n        // Fractional source index.\n        vec2 sourceFracIndexRC = vec2(yRC) * effectiveInputOverOutputRatioRC;\n\n        // Compute the coordinators of nearest neighbor point.\n        ivec2 sourceNearestRC = ivec2(\n          min(inputShapeRC - 1.0, floor(sourceFracIndexRC + ${c})));\n\n        float newValue = getA(b, sourceNearestRC.x, sourceNearestRC.y, d);\n\n        setOutput(newValue);\n      }\n    `}}class _n{constructor(e,t){this.variableNames=["x"];const n=e.length;if(n>4)throw new Error(`WebGL backend: Reverse of rank-${n} tensor is not yet supported`);if(this.outputShape=e,1===n)return void(this.userCode=`\n        void main() {\n          int coord = getOutputCoords();\n          setOutput(getX(${e[0]} - coord - 1));\n        }\n      `);const r=e.map((n,r)=>(n=>-1!==t.indexOf(n)&&1!==e[n]?`${e[n]} - coords[${n}] - 1`:`coords[${n}]`)(r)).join(","),o=Je(n);this.userCode=`\n      void main() {\n        ${o} coords = getOutputCoords();\n        setOutput(getX(${r}));\n      }\n    `}}class Sn{constructor(e,t){this.variableNames=["x"],this.packedInputs=!0,this.packedOutput=!0;const n=e.length;if(n>4)throw new Error(`WebGL backend: Reverse of rank-${n} tensor is not yet supported`);this.outputShape=e;const r=Le("rc",n),o=`${r[n-1]} + 1 < ${this.outputShape[n-1]}`,i=`${r[n-2]} + 1 < ${this.outputShape[n-2]}`,a=Je(n);function s(n){const r=e.map((r,o)=>function(n,r){return-1!==t.indexOf(n)&&1!==e[n]?`${e[n]} - ${r[n]} - 1`:`${r[n]}`}(o,n));return`getChannel(getX(${r.join(",")}), vec2(${r.slice(-2).join(",")}))`}this.userCode=1===n?`\n        void main(){\n          int rc = getOutputCoords();\n          vec4 result = vec4(0.);\n          result.r = getChannel(getX(${e[0]} - rc - 1),\n            ${e[0]} - rc - 1);\n          if(${o}){\n              result.g = getChannel(getX(${e[0]} - (rc  + 1) - 1),\n                ${e[0]} - (rc  + 1) - 1);\n          }\n          setOutput(result);\n        }\n      `:`\n        void main() {\n          ${a} rc = getOutputCoords();\n          vec4 result = vec4(0.);\n          result.r = ${function(e){return s(e)}(r.slice())};\n          if(${o}){\n            result.g = ${function(e){return e[n-1]="("+e[n-1]+" + 1)",s(e)}(r.slice())};\n          }\n          if(${i}) {\n            result.b = ${function(e){return e[n-2]="("+e[n-2]+" + 1)",s(e)}(r.slice())};\n            if(${o}) {\n              result.a = ${function(e){return e[n-1]="("+e[n-1]+" + 1)",e[n-2]="("+e[n-2]+" + 1)",s(e)}(r.slice())};\n            }\n          }\n          setOutput(result);\n        }\n    `}}class Nn{constructor(e,t,n,r,o,i,a=!0){this.variableNames=["updates","indices","defaultValue"],this.outputShape=i;const s=Je(o.length),u=Je(i.length);let l="";1===n?l="i":2===n&&(l="i, j");const c=`getIndices(${l})`;let d="";1===r?d="i":2===r&&(d="i, coords[1]");const h=`getUpdates(${d})`,p=t>1?"strides[j]":"strides";this.userCode=`\n        ${s} strides = ${s}(${o});\n\n        void main() {\n          ${u} coords = getOutputCoords();\n          float sum = 0.0;\n          bool found = false;\n          for (int i = 0; i < ${e}; i++) {\n            int flattenedIndex = 0;\n            for (int j = 0; j < ${t}; j++) {\n              int index = round(${c});\n              flattenedIndex += index * ${p};\n            }\n            if (flattenedIndex == coords[0]) {\n              sum += ${h};\n              found = true;\n            }\n          }\n          setOutput(mix(getDefaultValue(), sum, float(found)));\n        }\n      `}}class Fn{constructor(e,t){this.variableNames=["x","segmentIds"];const n=e.windowSize,r=e.batchSize,o=e.inSize,i=e.numSegments,a=i*Math.ceil(o/n);this.outputShape=[r,a];const s=4*Math.floor(n/4),u=n%4,l="\n        sumValue += dot(values, segFilter);\n    ";let c="";o%n>0&&(c=`\n        if (inIdx < 0 || inIdx >= ${o}) {\n          return initializationValue;\n        }\n      `);let d="";o%n>0&&(d=`\n        if (inIdx < 0 || inIdx >= ${o}) {\n          return -1.0;\n        }\n      `),this.userCode=`\n      const float initializationValue = 0.0;\n\n      float getValue(int batch, int inIdx) {\n        ${c}\n        return getX(batch, inIdx);\n      }\n\n      float getSegmentIdAtIndex(int inIdx) {\n        ${d}\n        return getSegmentIds(inIdx);\n      }\n\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int batch = coords[0];\n        int outIdx = coords[1];\n        int inOffset = int(floor(float(outIdx) / float(\n          ${i})) * float(${n}));\n        int currentSeg = int(mod(float(outIdx), float(${i})));\n\n        float sumValue = 0.0;\n\n        for (int i = 0; i < ${s}; i += 4) {\n          int inIdx = inOffset + i;\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2),\n            getValue(batch, inIdx + 3)\n          );\n\n          vec4 segFilter = vec4(\n            int(getSegmentIdAtIndex(inIdx)) == currentSeg ? 1 : 0,\n            int(getSegmentIdAtIndex(inIdx + 1)) == currentSeg ? 1 : 0,\n            int(getSegmentIdAtIndex(inIdx + 2)) == currentSeg ? 1 : 0,\n            int(getSegmentIdAtIndex(inIdx + 3)) == currentSeg ? 1 : 0\n          );\n\n          ${l}\n        }\n\n        int inIdx = inOffset + ${s};\n        if (${1===u}) {\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            initializationValue,\n            initializationValue,\n            initializationValue\n          );\n\n          int inIdxSeg = int(getSegmentIdAtIndex(inIdx));\n\n          vec4 segFilter = vec4(\n            int(getSegmentIdAtIndex(inIdx)) == currentSeg ? 1 : 0,\n            0,\n            0,\n            0\n          );\n\n          ${l}\n        } else if (${2===u}) {\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            initializationValue,\n            initializationValue\n          );\n\n          vec4 segFilter = vec4(\n            int(getSegmentIdAtIndex(inIdx)) == currentSeg ? 1 : 0,\n            int(getSegmentIdAtIndex(inIdx + 1)) == currentSeg ? 1 : 0,\n              0,\n              0\n          );\n\n          ${l}\n        } else if (${3===u}) {\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2),\n            initializationValue\n          );\n\n          vec4 segFilter = vec4(\n            int(getSegmentIdAtIndex(inIdx)) == currentSeg ? 1 : 0,\n            int(getSegmentIdAtIndex(inIdx + 1)) == currentSeg ? 1 : 0,\n            int(getSegmentIdAtIndex(inIdx + 2)) == currentSeg ? 1 : 0,\n            0\n          );\n\n          ${l}\n        }\n        setOutput(sumValue);\n      }\n    `}}class kn{constructor(e,t,n){let r,o;if(this.variableNames=["c","a","b"],this.outputShape=t,n>4)throw Error(`Where for rank ${n} is not yet supported`);if(1===n)o="resRC",r="resRC";else{const n=["resRC.x","resRC.y","resRC.z","resRC.w"],i=[],a=[];for(let r=0;r<t.length;r++)a.push(`${n[r]}`),r<e&&i.push(`${n[r]}`);r=i.join(),o=a.join()}const i=Je(n);this.userCode=`\n      void main() {\n        ${i} resRC = getOutputCoords();\n        float cVal = getC(${r});\n        if (cVal >= 1.0) {\n          setOutput(getA(${o}));\n        } else {\n          setOutput(getB(${o}));\n        }\n      }\n    `}}class Dn{constructor(e){this.variableNames=["source"],this.outputShape=e,this.rank=e.length;const t=Je(this.rank),n=`uniform int start[${this.rank}];`,r=function(e){if(1===e)return"sourceLoc";if(e<=6)return Pn.slice(0,e).map(e=>"sourceLoc."+e).join(",");throw Error(`Slicing for rank ${e} is not yet supported`)}(this.rank);let o;o=`\n        ${t} sourceLoc;\n        ${t} coords = getOutputCoords();\n        ${e.map((e,t)=>`sourceLoc.${Pn[t]} = start[${t}] + coords.${Pn[t]};`).join("\n")}\n      `,this.userCode=`\n      ${n}\n      void main() {\n        ${o}\n        setOutput(getSource(${r}));\n      }\n    `}getCustomSetupFunc(e){if(e.length!==this.rank)throw Error(`The rank (${this.rank}) of the program must match the `+`length of start (${e.length})`);return(t,n)=>{null==this.startLoc&&(this.startLoc=t.getUniformLocationNoThrow(n,"start"),null==this.startLoc)||t.gl.uniform1iv(this.startLoc,e)}}}const Pn=["x","y","z","w","u","v"];class Ln{constructor(e){this.variableNames=["source"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=e,this.rank=e.length;const t=Je(this.rank),n=Le("coords",this.rank),r=Le("sourceLoc",this.rank),o=1===this.rank?"sourceLoc":`vec2(${r.slice(-2).join()})`,i=`getChannel(getSource(${r.join()}), ${o})`,a=`\n      result.x = ${i};\n      if (++${n[this.rank-1]} < ${e[this.rank-1]}) {\n        ++${r[this.rank-1]};\n        result.y = ${i};\n        --${r[this.rank-1]};\n      }\n    `,s=1===this.rank?"":`\n      --${n[this.rank-1]};\n      if (++${n[this.rank-2]} < ${e[this.rank-2]}) {\n        ++${r[this.rank-2]};\n        result.z = ${i};\n        if (++${n[this.rank-1]} < ${e[this.rank-1]}) {\n          ++${r[this.rank-1]};\n          result.w = ${i};\n        }\n      }\n    `,u=this.rank<=4?`sourceLoc = coords +\n            ${t}(${e.map((e,t)=>`start[${t}]`).join()});`:e.map((e,t)=>`${r[t]} = ${n[t]} + start[${t}];`).join("\n");this.userCode=`\n      uniform int start[${this.rank}];\n      void main() {\n        ${t} coords = getOutputCoords();\n        ${t} sourceLoc;\n        ${u}\n        vec4 result = vec4(0.);\n        ${a}\n        ${s}\n        setOutput(result);\n      }\n    `}getCustomSetupFunc(e){if(e.length!==this.rank)throw Error(`The rank (${this.rank}) of the program must match the `+`length of start (${e.length})`);return(t,n)=>{null==this.startLoc&&(this.startLoc=t.getUniformLocationNoThrow(n,"start"),null==this.startLoc)||t.gl.uniform1iv(this.startLoc,e)}}}class Bn{constructor(e,t,n){this.variableNames=["x"],this.outputShape=n;const r=n.length,o=Je(n.length),i=Je(n.length);let a="";if(1===r)a="coords * strides + begin";else{let e=0;a=n.map((t,r)=>(e++,1===n.length?`coords * strides[${r}] + begin[${r}]`:`coords[${e-1}] * strides[${r}] + begin[${r}]`)).join(",")}this.userCode=`\n      ${o} begin = ${o}(${e});\n      ${o} strides = ${o}(${t});\n\n      void main() {\n        ${i} coords = getOutputCoords();\n        setOutput(getX(${a}));\n      }\n    `}}class Vn{constructor(e){this.gpgpu=e,this.numUsedTextures=0,this.numFreeTextures=0,this._numBytesAllocated=0,this._numBytesFree=0,this.freeTextures={},this.logEnabled=!1,this.usedTextures={}}acquireTexture(e,t,n){const r=Wn(t,n),o=Un(e,r,n);o in this.freeTextures||(this.freeTextures[o]=[]),o in this.usedTextures||(this.usedTextures[o]=[]);const i=Mn(e,r,this.gpgpu.gl,this.gpgpu.textureConfig,n);if(this.freeTextures[o].length>0){this.numFreeTextures--,this.numUsedTextures++,this._numBytesFree-=i,this.log();const e=this.freeTextures[o].shift();return this.usedTextures[o].push(e),e}let a;return r===u.PACKED_2X2_FLOAT32?a=this.gpgpu.createPackedMatrixTexture(e[0],e[1]):r===u.PACKED_2X2_FLOAT16?a=this.gpgpu.createFloat16PackedMatrixTexture(e[0],e[1]):r===u.UNPACKED_FLOAT32?a=this.gpgpu.createFloat32MatrixTexture(e[0],e[1]):r===u.UNPACKED_FLOAT16?a=this.gpgpu.createFloat16MatrixTexture(e[0],e[1]):r===u.PACKED_4X1_UNSIGNED_BYTE&&(a=this.gpgpu.createUnsignedBytesMatrixTexture(e[0],e[1])),this.usedTextures[o].push(a),this.numUsedTextures++,this._numBytesAllocated+=i,this.log(),a}releaseTexture(e,n,r,o){if(null==this.freeTextures)return;const i=Wn(r,o),a=Un(n,i,o);a in this.freeTextures||(this.freeTextures[a]=[]);const s=Mn(n,i,this.gpgpu.gl,this.gpgpu.textureConfig,o),u=t.env().get("WEBGL_DELETE_TEXTURE_THRESHOLD");-1!==u&&this._numBytesAllocated>u?(this.gpgpu.deleteMatrixTexture(e),this._numBytesAllocated-=s):(this.freeTextures[a].push(e),this.numFreeTextures++,this._numBytesFree+=s),this.numUsedTextures--;const l=this.usedTextures[a],c=l.indexOf(e);if(c<0)throw new Error("Cannot release a texture that was never provided by this texture manager");l.splice(c,1),this.log()}log(){if(!this.logEnabled)return;const e=this.numFreeTextures+this.numUsedTextures;console.log("Free/Used",`${this.numFreeTextures} / ${this.numUsedTextures}`,`(${e})`);const t=this._numBytesFree/this._numBytesAllocated;console.log(`Bytes allocated: ${this._numBytesAllocated}`),console.log(`Bytes unused: ${this._numBytesFree} (${Math.round(100*t)}%)`)}get numBytesAllocated(){return this._numBytesAllocated}get numBytesFree(){return this._numBytesFree}getNumUsedTextures(){return this.numUsedTextures}getNumFreeTextures(){return this.numFreeTextures}dispose(){if(null!=this.freeTextures){for(const e in this.freeTextures)this.freeTextures[e].forEach(e=>{this.gpgpu.deleteMatrixTexture(e)});for(const e in this.usedTextures)this.usedTextures[e].forEach(e=>{this.gpgpu.deleteMatrixTexture(e)});this.freeTextures=null,this.usedTextures=null,this.numUsedTextures=0,this.numFreeTextures=0,this._numBytesAllocated=0,this._numBytesFree=0}}}function Mn(e,t,n,r,o){const i=function(e,t){switch(e){case u.PACKED_2X2_FLOAT32:return jt(t);case u.PACKED_2X2_FLOAT16:return qt(t);case u.UNPACKED_FLOAT32:return Wt(t);case u.UNPACKED_FLOAT16:return Gt(t);case u.PACKED_4X1_UNSIGNED_BYTE:return Xt(t);default:throw new Error(`Unknown physical texture type ${e}`)}}(t,r);let a;if(o){const[t,n]=d(e[0],e[1]);a=t*n}else{const[t,n]=l(e[0],e[1]);a=t*n}return a*function(e,t){const n=e;if(t===n.R32F)return 4;if(t===n.R16F)return 2;if(t===n.RGBA32F)return 16;if(t===e.RGBA)return 16;if(t===n.RGBA16F)return 8;throw new Error(`Unknown internal format ${t}`)}(n,i)}function Wn(e,n){if(e===s.UPLOAD)return u.PACKED_2X2_FLOAT32;if(e===s.RENDER||null==e)return function(e){return t.env().getBool("WEBGL_RENDER_FLOAT32_ENABLED")?e?u.PACKED_2X2_FLOAT32:u.UNPACKED_FLOAT32:e?u.PACKED_2X2_FLOAT16:u.UNPACKED_FLOAT16}(n);if(e===s.DOWNLOAD||e===s.PIXELS)return u.PACKED_4X1_UNSIGNED_BYTE;throw new Error(`Unknown logical texture type ${e}`)}function Un(e,t,n){return`${e[0]}_${e[1]}_${t}_${n}`}class Gn{constructor(e,t){this.variableNames=["A"];const n=new Array(e.length);for(let r=0;r<n.length;r++)n[r]=e[r]*t[r];this.outputShape=n,this.rank=n.length;const r=Je(this.rank),o=function(e){const t=e.length;if(t>5)throw Error(`Tile for rank ${t} is not yet supported`);if(1===t)return`imod(resRC, ${e[0]})`;const n=["resRC.x","resRC.y","resRC.z","resRC.w","resRC.u"],r=[];for(let t=0;t<e.length;t++)r.push(`imod(${n[t]}, ${e[t]})`);return r.join()}(e);this.userCode=`\n      void main() {\n        ${r} resRC = getOutputCoords();\n        setOutput(getA(${o}));\n      }\n    `}}class zn{constructor(e,t){this.variableNames=["A"],this.outputShape=e,this.userCode=`\n      float unaryOperation(float x) {\n        ${t}\n      }\n\n      void main() {\n        float x = getAAtOutCoords();\n        float y = unaryOperation(x);\n\n        setOutput(y);\n      }\n    `}}const Xn="if (isnan(x)) return x;",Hn="return abs(x);",jn=Xn+"\n  return (x < 0.0) ? 0.0 : x;\n",Kn=Xn+"\n  return (x < 0.0) ? 0.0 : min(6.0, x);\n",qn="return (x >= 0.0) ? x : (exp(x) - 1.0);",Yn=`\n  // Stable and Attracting Fixed Point (0, 1) for Normalized Weights.\n  // see: https://arxiv.org/abs/1706.02515\n  float scaleAlpha = ${t.backend_util.SELU_SCALEALPHA};\n  float scale = ${t.backend_util.SELU_SCALE};\n  return (x >= 0.0) ? scale * x : scaleAlpha * (exp(x) - 1.0);\n`;const Qn="return -x;",Zn="return ceil(x);",Jn="return floor(x);",er="return exp(x);",tr="return exp(x) - 1.0;",nr=`\n  // Error function is calculated approximately with elementary function.\n  // See "Handbook of Mathematical Functions with Formulas,\n  // Graphs, and Mathematical Tables", Abramowitz and Stegun.\n  float p = ${t.backend_util.ERF_P};\n  float a1 = ${t.backend_util.ERF_A1};\n  float a2 = ${t.backend_util.ERF_A2};\n  float a3 = ${t.backend_util.ERF_A3};\n  float a4 = ${t.backend_util.ERF_A4};\n  float a5 = ${t.backend_util.ERF_A5};\n\n  float sign = sign(x);\n  x = abs(x);\n  float t = 1.0 / (1.0 + p * x);\n  return sign * (1.0 - (((((a5*t + a4)*t) + a3)*t + a2)*t + a1)*t*exp(-x*x));\n`,rr="return x;",or="\n  vec4 result = x * vec4(greaterThanEqual(x, vec4(0.0)));\n  bvec4 isNaN = isnan(x);\n\n  result.r = isNaN.r ? x.r : result.r;\n  result.g = isNaN.g ? x.g : result.g;\n  result.b = isNaN.b ? x.b : result.b;\n  result.a = isNaN.a ? x.a : result.a;\n\n  return result;\n",ir="\n  vec4 result = min(x, vec4(6.)) * vec4(greaterThanEqual(x, vec4(0.0)));\n  bvec4 isNaN = isnan(x);\n\n  result.r = isNaN.r ? x.r : result.r;\n  result.g = isNaN.g ? x.g : result.g;\n  result.b = isNaN.b ? x.b : result.b;\n  result.a = isNaN.a ? x.a : result.a;\n\n  return result;\n",ar="\n  vec4 result;\n\n  result.r = (x.r >= 0.0) ? x.r : (exp(x.r) - 1.0);\n  result.g = (x.g >= 0.0) ? x.g : (exp(x.g) - 1.0);\n  result.b = (x.b >= 0.0) ? x.b : (exp(x.b) - 1.0);\n  result.a = (x.a >= 0.0) ? x.a : (exp(x.a) - 1.0);\n\n  return result;\n";class sr{constructor(e,t){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=e,this.userCode=`\n      vec4 unaryOperation(vec4 x) {\n        ${t}\n      }\n\n      void main() {\n        vec4 x = getAAtOutCoords();\n        vec4 y = unaryOperation(x);\n\n        setOutput(y);\n      }\n    `}}class ur{constructor(e){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!1,this.outputShape=e;const t=e.length,n=Le("rc",t),r=Je(t),o=function(e,t){if(1===e)return"rc";let n="";for(let r=0;r<e;r++)n+=t[r],r<e-1&&(n+=",");return n}(t,n),i=n.slice(-2),a=t<=1?"rc":`vec2(${i.join(",")})`;this.userCode=`\n      void main() {\n        ${r} rc = getOutputCoords();\n        vec4 packedInput = getA(${o});\n\n        setOutput(getChannel(packedInput, ${a}));\n      }\n    `}}const{segment_util:lr}=t.backend_util,cr=t.kernel_impls.split,dr=t.kernel_impls.tile,hr=t.kernel_impls.topkImpl,pr=t.kernel_impls.whereImpl,fr={};function xr(e,t=!1){if("linear"===e)return"return x;";if("relu"===e)return t?or:jn;if("elu"===e)return t?ar:qn;if("relu6"===e)return t?ir:Kn;if("prelu"===e)return t?st:it;throw new Error(`Activation ${e} has not been implemented for the WebGL backend.`)}class gr extends t.KernelBackend{constructor(e){if(super(),this.pendingRead=new WeakMap,this.pendingDisposal=new WeakSet,this.dataRefCount=new WeakMap,this.numBytesInGPU=0,this.uploadWaitMs=0,this.downloadWaitMs=0,this.warnedAboutMemory=!1,this.warnedAboutCPUBackend=!1,this.pendingDeletes=0,this.disposed=!1,!t.env().getBool("HAS_WEBGL"))throw new Error("WebGL is not supported on this device");if(null==e){const e=i(t.env().getNumber("WEBGL_VERSION"));this.binaryCache=((n=t.env().getNumber("WEBGL_VERSION"))in fr||(fr[n]={}),fr[n]),this.gpgpu=new sn(e),this.canvas=e.canvas,this.gpgpuCreatedLocally=!0}else this.gpgpu=e,this.binaryCache={},this.gpgpuCreatedLocally=!1,this.canvas=e.gl.canvas;var n;this.textureManager=new Vn(this.gpgpu),this.numMBBeforeWarning=null==t.env().global.screen?1024:t.env().global.screen.height*t.env().global.screen.width*window.devicePixelRatio*600/1024/1024,this.texData=new t.DataStorage(this,t.engine())}numDataIds(){return this.texData.numDataIds()+(this.cpuBackend?this.cpuBackend.numDataIds():0)-this.pendingDeletes}write(e,n,r){if((t.env().getBool("WEBGL_CHECK_NUMERICAL_PROBLEMS")||t.env().getBool("DEBUG"))&&this.checkNumericalProblems(e),"complex64"===r&&null!=e)throw new Error("Cannot write to a complex64 dtype. Please use tf.complex(real, imag).");const o={};return this.texData.set(o,{shape:n,dtype:r,values:e,usage:s.UPLOAD,refCount:1,complexParentRefCount:0}),o}incRef(e){this.texData.get(e).refCount++}decRef(e){if(this.texData.has(e)){this.texData.get(e).refCount--}}move(e,n,r,o){if(t.env().getBool("DEBUG")&&this.checkNumericalProblems(n),"complex64"===o)throw new Error("Cannot write to a complex64 dtype. Please use tf.complex(real, imag).");this.texData.set(e,{shape:r,dtype:o,values:n,usage:s.UPLOAD,refCount:1,complexParentRefCount:0})}disposeIntermediateTensorInfo(e){const t=e.dataId;if(this.texData.has(t)){const e=this.texData.get(t);e.refCount--,e.refCount<1&&this.disposeData(t)}}readSync(e){const n=this.texData.get(e),{values:r,dtype:o,complexTensorInfos:i,slice:a,shape:s,isPacked:u}=n;if(null!=a){let t;t=u?new sr(s,rr):new zn(s,rr);const n=this.runWebGLProgram(t,[{dataId:e,shape:s,dtype:o}],o),r=this.readSync(n.dataId);return this.disposeIntermediateTensorInfo(n),r}if(null!=r)return this.convertAndCacheOnCPU(e);if("string"===o)return r;const l=null!=this.activeTimers;let c,d;if(l&&(c=t.util.now()),"complex64"===o){const e=this.readSync(i.real.dataId),n=this.readSync(i.imag.dataId);d=t.backend_util.mergeRealAndImagArrays(e,n)}else d=this.getValuesFromTexture(e);return l&&(this.downloadWaitMs+=t.util.now()-c),this.convertAndCacheOnCPU(e,d)}async read(e){if(this.pendingRead.has(e)){const t=this.pendingRead.get(e);return new Promise(e=>t.push(e))}const n=this.texData.get(e),{values:r,shape:o,slice:i,dtype:a,complexTensorInfos:s,isPacked:u}=n;if(null!=i){let t;t=u?new sr(o,rr):new zn(o,rr);const n=this.runWebGLProgram(t,[{dataId:e,shape:o,dtype:a}],a),r=this.read(n.dataId);return this.disposeIntermediateTensorInfo(n),r}if(null!=r)return this.convertAndCacheOnCPU(e);if(!t.env().getBool("WEBGL_DOWNLOAD_FLOAT_ENABLED")&&2===t.env().getNumber("WEBGL_VERSION"))throw new Error("tensor.data() with WEBGL_DOWNLOAD_FLOAT_ENABLED=false and WEBGL_VERSION=2 not yet supported.");let l,d,h=null;if("complex64"!==a&&t.env().get("WEBGL_BUFFER_SUPPORTED")){l=this.decode(e);const t=this.texData.get(l.dataId);h=this.gpgpu.createBufferFromTexture(t.texture,...c(o))}if(this.pendingRead.set(e,[]),"complex64"!==a&&await this.gpgpu.createAndWaitForFence(),"complex64"===a){const e=await Promise.all([this.read(s.real.dataId),this.read(s.imag.dataId)]),n=e[0],r=e[1];d=t.backend_util.mergeRealAndImagArrays(n,r)}else if(null==h)d=this.getValuesFromTexture(e);else{const e=t.util.sizeFromShape(o);d=this.gpgpu.downloadFloat32MatrixFromBuffer(h,e)}null!=l&&this.disposeIntermediateTensorInfo(l);const p=this.convertAndCacheOnCPU(e,d),f=this.pendingRead.get(e);return this.pendingRead.delete(e),f.forEach(e=>e(p)),this.pendingDisposal.has(e)&&(this.pendingDisposal.delete(e),this.disposeData(e),this.pendingDeletes--),p}checkNumericalProblems(e){if(null!=e)for(let n=0;n<e.length;n++){const r=e[n];if(!f(r)){if(t.env().getBool("WEBGL_RENDER_FLOAT32_CAPABLE"))throw Error(`The value ${r} cannot be represented with your `+"current settings. Consider enabling float32 rendering: 'tf.env().set('WEBGL_RENDER_FLOAT32_ENABLED', true);'");throw Error(`The value ${r} cannot be represented on this device.`)}}}getValuesFromTexture(e){const{shape:n,dtype:r,isPacked:o}=this.texData.get(e),i=t.util.sizeFromShape(n);if(t.env().getBool("WEBGL_DOWNLOAD_FLOAT_ENABLED")){const t=this.decode(e),r=this.texData.get(t.dataId),o=this.gpgpu.downloadMatrixFromPackedTexture(r.texture,...c(n)).subarray(0,i);return this.disposeIntermediateTensorInfo(t),o}const a=t.env().getBool("WEBGL_PACK")&&!0===o,s=a?W(n):n,u=a?new St(s):new _t(s),l=this.runWebGLProgram(u,[{shape:s,dtype:r,dataId:e}],"float32"),d=this.texData.get(l.dataId),h=this.gpgpu.downloadByteEncodedFloatMatrixFromOutputTexture(d.texture,d.texShape[0],d.texShape[1]).subarray(0,i);return this.disposeIntermediateTensorInfo(l),h}async time(e){const n=this.activeTimers,r=[];let o=!1;null==this.programTimersStack?(this.programTimersStack=r,o=!0):this.activeTimers.push(r),this.activeTimers=r,e();const i=t.util.flatten(this.activeTimers.map(e=>e.query)).filter(e=>null!=e),a=t.util.flatten(this.activeTimers.map(e=>e.name)).filter(e=>null!=e);this.activeTimers=n,o&&(this.programTimersStack=null);const s={uploadWaitMs:this.uploadWaitMs,downloadWaitMs:this.downloadWaitMs,kernelMs:null,wallMs:null};if(t.env().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE")>0){const e=await Promise.all(i);s.kernelMs=t.util.sum(e),s.getExtraProfileInfo=()=>e.map((e,t)=>({name:a[t],ms:e})).map(e=>`${e.name}: ${e.ms}`).join(", ")}else s.kernelMs={error:"WebGL query timers are not supported in this environment."};return this.uploadWaitMs=0,this.downloadWaitMs=0,s}memory(){return{unreliable:!1,numBytesInGPU:this.numBytesInGPU,numBytesInGPUAllocated:this.textureManager.numBytesAllocated,numBytesInGPUFree:this.textureManager.numBytesFree}}startTimer(){return t.env().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE")>0?this.gpgpu.beginQuery():{startMs:t.util.now(),endMs:null}}endTimer(e){return t.env().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE")>0?(this.gpgpu.endQuery(),e):(e.endMs=t.util.now(),e)}async getQueryTime(e){if(t.env().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE")>0)return this.gpgpu.waitForQueryAndGetTime(e);const n=e;return n.endMs-n.startMs}disposeData(e){if(this.pendingDisposal.has(e))return;if(this.pendingRead.has(e))return this.pendingDisposal.add(e),void this.pendingDeletes++;if(!this.texData.has(e))return;if(this.texData.get(e).complexParentRefCount>0)return void this.texData.get(e).refCount--;this.releaseGPUData(e);const{complexTensorInfos:t}=this.texData.get(e);null!=t&&(this.texData.get(t.real.dataId).complexParentRefCount--,this.disposeIntermediateTensorInfo(t.real),this.texData.get(t.imag.dataId).complexParentRefCount--,this.disposeIntermediateTensorInfo(t.imag)),this.texData.delete(e)}releaseGPUData(e){const{texture:t,dtype:n,texShape:r,usage:o,isPacked:i,slice:a}=this.texData.get(e),s=a&&a.origDataId||e,u=this.dataRefCount.get(s);u>1?this.dataRefCount.set(s,u-1):(this.dataRefCount.delete(s),null!=t&&(this.numBytesInGPU-=this.computeBytes(r,n),this.textureManager.releaseTexture(t,r,o,i)));const l=this.texData.get(e);l.texture=null,l.texShape=null,l.isPacked=!1,l.slice=null}getTexture(e){return this.uploadToGPU(e),this.texData.get(e).texture}getDataInfo(e){return this.texData.get(e)}getCPUBackend(){return t.env().getBool("WEBGL_CPU_FORWARD")?(null==this.cpuBackend&&(this.cpuBackend=t.engine().findBackend("cpu")),this.cpuBackend):null}shouldExecuteOnCPU(e,n=128){const r=this.getCPUBackend();return this.warnedAboutCPUBackend||null!=r||(console.warn("Your application contains ops that are small enough to be executed on the CPU backend, however the CPU backend cannot be found. Consider importing the CPU backend (@tensorflow/tfjs-backend-cpu) for better performance."),this.warnedAboutCPUBackend=!0),null!=r&&e.every(e=>null==this.texData.get(e.dataId).texture&&t.util.sizeFromShape(e.shape)<n)}getGPGPUContext(){return this.gpgpu}slice(e,n,r){if(this.shouldExecuteOnCPU([e])){const t=Oe(this.texData.get(e.dataId).values,n,r,e.shape,e.dtype);return this.makeOutput(r,e.dtype,t)}if(0===t.util.sizeFromShape(r))return t.tensor([],r,e.dtype);const{isPacked:o}=this.texData.get(e.dataId),i=t.slice_util.isSliceContinous(e.shape,n,r);if(o||!i){const o=t.env().getBool("WEBGL_PACK_ARRAY_OPERATIONS")?new Ln(r):new Dn(r),i=o.getCustomSetupFunc(n);return this.compileAndRun(o,[e],null,i)}return this.uploadToGPU(e.dataId),this.shallowSlice(e,n,r)}shallowSlice(e,n,r){const o=this.texData.get(e.dataId),i=this.makeOutput(r,e.dtype),a=this.texData.get(i.dataId);Object.assign(a,o),a.shape=r,a.dtype=e.dtype;let s=t.slice_util.computeFlatOffset(n,e.strides);o.slice&&(s+=o.slice.flatOffset),a.slice={flatOffset:s,origDataId:o.slice&&o.slice.origDataId||e.dataId};const u=this.dataRefCount.get(a.slice.origDataId)||1;return this.dataRefCount.set(a.slice.origDataId,u+1),i}stridedSlice(e,n,r,o){const i=this.tryRunOnCpuOrThrow([e],()=>this.cpuBackend.stridedSlice(e,n,r,o));if(i)return i;const a=t.slice_util.computeOutShape(n,r,o);if(a.some(e=>0===e))return t.tensor([],a);const s=new Bn(n,o,a);return this.compileAndRun(s,[e])}reverse(e,n){const r=t.env().getBool("WEBGL_PACK_ARRAY_OPERATIONS")?new Sn(e.shape,n):new _n(e.shape,n);return this.compileAndRun(r,[e])}neg(e){const n=this.tryRunOnCpuOrThrow([e],()=>this.cpuBackend.neg(e));if(n)return n;if(t.env().getBool("WEBGL_PACK_UNARY_OPERATIONS"))return this.packedUnaryOp(e,Qn,e.dtype);const r=new zn(e.shape,Qn);return this.compileAndRun(r,[e])}batchMatMul(e,n,r,o){const i=r?e.shape[2]:e.shape[1],a=o?n.shape[1]:n.shape[2],s=r?e.shape[1]:e.shape[2],u=Math.max(e.shape[0],n.shape[0]);if((1===i||1===a)&&s>1e3){r&&(e=t.transpose(e,[0,2,1])),o&&(n=t.transpose(n,[0,2,1]));const i=1===a?e:e.as3D(u,s,1),l=1===a?2:1,c=1===a?n.as3D(u,1,s):n;return t.mul(i,c).sum(l,!0)}const l=t.upcastType(e.dtype,n.dtype),c=new xn(e.shape,n.shape,[u,i,a],r,o);return this.compileAndRun(c,[e,n],l)}fusedBatchMatMul({a:e,b:n,transposeA:r,transposeB:o,bias:i,activation:a,preluActivationWeights:s}){const u=r?e.shape[2]:e.shape[1],l=o?n.shape[1]:n.shape[2],c=Math.max(e.shape[0],n.shape[0]),d=t.upcastType(e.dtype,n.dtype),h=null!=i,p=null!=s,f=a?xr(a,!0):null,x=new xn(e.shape,n.shape,[c,u,l],r,o,h,f,p),g=[e,n];return i&&g.push(i),s&&g.push(s),this.compileAndRun(x,g,d)}localResponseNormalization4D(e,n,r,o,i){const a=t.env().getBool("WEBGL_PACK_NORMALIZATION")?new hn(e.shape,n,r,o,i):new cn(e.shape,n,r,o,i);return this.compileAndRun(a,[e])}LRNGrad(e,t,n,r,o,i,a){const s=new dn(t.shape,r,o,i,a);return this.compileAndRun(s,[t,n,e])}tile(e,n){if("string"===e.dtype){const r=this.readSync(e.dataId).map(e=>t.util.decodeString(e)),o=t.buffer(e.shape,e.dtype,r);return dr(o,n)}const r=new Gn(e.shape,n);return this.compileAndRun(r,[e])}pad(e,n,r){const o=t.env().getBool("WEBGL_PACK_ARRAY_OPERATIONS")?new $n(e.shape,n,r):new vn(e.shape,n,r);return this.compileAndRun(o,[e])}gather(e,t,n){const r=this.tryRunOnCpuOrThrow([e,t],()=>this.cpuBackend.gather(e,t,n));if(r)return r;const o=new Dt(e.shape,t.size,n);return this.compileAndRun(o,[e,t])}batchToSpaceND(e,n,r){t.util.assert(e.rank<=4,()=>"batchToSpaceND for rank > 4 with a WebGL backend not implemented yet");const o=n.reduce((e,t)=>e*t),i=t.backend_util.getReshaped(e.shape,n,o),a=t.backend_util.getPermuted(i.length,n.length),s=t.backend_util.getReshapedPermuted(e.shape,n,o),u=t.backend_util.getSliceBeginCoords(r,n.length),l=t.backend_util.getSliceSize(s,r,n.length);return t.transpose(e.reshape(i),a).reshape(s).slice(u,l)}spaceToBatchND(e,n,r){t.util.assert(e.rank<=4,()=>"spaceToBatchND for rank > 4 with a WebGL backend not implemented yet");const o=n.reduce((e,t)=>e*t),i=[[0,0]];i.push(...r);for(let t=1+n.length;t<e.shape.length;++t)i.push([0,0]);const a=e.pad(i),s=t.backend_util.getReshaped(a.shape,n,o,!1),u=t.backend_util.getPermuted(s.length,n.length,!1),l=t.backend_util.getReshapedPermuted(a.shape,n,o,!1),c=t.transpose(a.reshape(s),u);return t.reshape(c,l)}reduce(e,n,r){const o=e.shape[0],i=e.shape[1],a=t.backend_util.computeOptimalWindowSize(i),s=Math.ceil(i/a),u=new wn({windowSize:a,inSize:i,batchSize:o,outSize:s},n),l=this.compileAndRun(u,[e],r);return 1===l.shape[1]?l:this.reduce(l,n,r)}argReduce(e,n,r=null){let o=e.shape[0],i=e.shape[1];null!=r&&(o=r.shape[0],i=r.shape[1]);const a=t.backend_util.computeOptimalWindowSize(i),s={windowSize:a,inSize:i,batchSize:o,outSize:Math.ceil(i/a)},u=new De(s,n,null==r),l=[e];null!=r&&l.push(r);const c=this.compileAndRun(u,l,"int32");return 1===c.shape[1]?c:this.argReduce(e,n,c)}argReducePacked(e,n,r=null){const o=null!=r?r.shape:e.shape,i=o[o.length-1],a=t.backend_util.computeOptimalWindowSize(i),s=new nt(o,a,n,null==r),u=null==r?[e]:[e,r],l=this.compileAndRun(s,u,"int32");return l.rank===e.rank?this.argReducePacked(e,n,l):l}sum(e,n){t.backend_util.assertAxesAreInnerMostDims("sum",n,e.rank);const[r,o]=t.backend_util.computeOutAndReduceShapes(e.shape,n),i=t.util.sizeFromShape(o),a=e.as2D(-1,i),s=t.sumOutType(e.dtype);return this.reduce(a,"sum",s).reshape(r)}prod(e,n){const r=this.tryRunOnCpuOrThrow([e],()=>this.cpuBackend.prod(e,n));if(r)return r;const[o,i]=t.backend_util.computeOutAndReduceShapes(e.shape,n),a=t.util.sizeFromShape(i),s=e.as2D(-1,a),u=t.sumOutType(e.dtype);return this.reduce(s,"prod",u).reshape(o)}unsortedSegmentSum(e,n,r){let o=0;const i=t.backend_util.getAxesPermutation([o],e.rank);let a=e;null!=i&&(a=t.transpose(e,i),o=t.backend_util.getInnerMostAxes(1,e.rank)[0]);const s=lr.computeOutShape(a.shape,o,r),u=t.util.sizeFromShape([a.shape[o]]),l=a.as2D(-1,u),c=t.sumOutType(e.dtype);let d=this.segOpCompute(l,"unsortedSegmentSum",n,c,r).reshape(s);return null!=i&&(d=t.transpose(d,t.backend_util.getUndoAxesPermutation(i))),d}segOpCompute(e,n,r,o,i){const a=e.shape[0],s=e.shape[1],u=lr.segOpComputeOptimalWindowSize(s,i),l=new Fn({windowSize:u,inSize:s,batchSize:a,numSegments:i},n),c=this.compileAndRun(l,[e,r],o);return c.shape[1]===i?c:(r=t.range(0,i).tile([s/u]),this.segOpCompute(c,n,r,o,i))}argMinMaxReduce(e,n,r){const o=[n];if(t.backend_util.assertAxesAreInnerMostDims("arg"+r.charAt(0).toUpperCase()+r.slice(1),o,e.rank),!t.env().getBool("WEBGL_PACK_REDUCE")||e.rank<=2){const[n,i]=t.backend_util.computeOutAndReduceShapes(e.shape,o),a=t.util.sizeFromShape(i),s=e.as2D(-1,a);return this.argReduce(s,r).reshape(n)}return this.argReducePacked(e,r)}argMin(e,t){return this.argMinMaxReduce(e,t,"min")}argMax(e,t){return this.argMinMaxReduce(e,t,"max")}cumsum(e,t,n,r){if(t!==e.rank-1)throw new Error(`WebGL cumsum shader expects an inner-most axis=${e.rank-1} `+`but got axis=${t}`);const o=e.shape[t];let i=e;for(let t=0;t<=Math.ceil(Math.log2(o))-1;t++){const n=new wt(e.shape,!1,r),o=n.getCustomSetupFunc(t),a=i;i=this.compileAndRun(n,[i],i.dtype,o),a.dispose()}if(n){const t=new wt(e.shape,n,r),o=i;i=this.compileAndRun(t,[i]),o.dispose()}return i}equal(e,n){if(t.env().getBool("WEBGL_PACK_BINARY_OPERATIONS"))return this.packedBinaryOp(e,n,"\n  return vec4(equal(a, b));\n","bool");const r=new at("return float(a == b);",e.shape,n.shape);return this.compileAndRun(r,[e,n],"bool")}less(e,n){const r=this.tryRunOnCpuOrThrow([e,n],()=>this.cpuBackend.less(e,n));if(r)return r;if(t.env().getBool("WEBGL_PACK_BINARY_OPERATIONS"))return this.packedBinaryOp(e,n,"\n  return vec4(lessThan(a, b));\n","bool");const o=new at("return float(a < b);",e.shape,n.shape);return this.compileAndRun(o,[e,n],"bool")}lessEqual(e,n){if(t.env().getBool("WEBGL_PACK_BINARY_OPERATIONS"))return this.packedBinaryOp(e,n,"\n  return vec4(lessThanEqual(a, b));\n","bool");const r=new at("return float(a <= b);",e.shape,n.shape);return this.compileAndRun(r,[e,n],"bool")}greater(e,n){const r=this.tryRunOnCpuOrThrow([e,n],()=>this.cpuBackend.greater(e,n));if(r)return r;if(t.env().getBool("WEBGL_PACK_BINARY_OPERATIONS"))return this.packedBinaryOp(e,n,"\n  return vec4(greaterThan(a, b));\n","bool");const o=new at("return float(a > b);",e.shape,n.shape);return this.compileAndRun(o,[e,n],"bool")}greaterEqual(e,n){if(t.env().getBool("WEBGL_PACK_BINARY_OPERATIONS"))return this.packedBinaryOp(e,n,"\n  return vec4(greaterThanEqual(a, b));\n","bool");const r=new at("return float(a >= b);",e.shape,n.shape);return this.compileAndRun(r,[e,n],"bool")}logicalNot(e){const t=new zn(e.shape,"return float(!(x >= 1.0));");return this.compileAndRun(t,[e])}logicalAnd(e,n){if(t.env().getBool("WEBGL_PACK_BINARY_OPERATIONS"))return this.packedBinaryOp(e,n,"\n  return vec4(\n    vec4(greaterThanEqual(a, vec4(1.0))) *\n    vec4(greaterThanEqual(b, vec4(1.0))));\n","bool");const r=new at("return float(a >= 1.0 && b >= 1.0);",e.shape,n.shape);return this.compileAndRun(r,[e,n],"bool")}logicalOr(e,n){if(t.env().getBool("WEBGL_PACK_BINARY_OPERATIONS"))return this.packedBinaryOp(e,n,"\n  return min(\n    vec4(greaterThanEqual(a, vec4(1.0))) +\n    vec4(greaterThanEqual(b, vec4(1.0))),\n    vec4(1.0));\n","bool");const r=new at("return float(a >= 1.0 || b >= 1.0);",e.shape,n.shape);return this.compileAndRun(r,[e,n],"bool")}select(e,n,r){const o=new kn(e.rank,n.shape,n.rank);return this.compileAndRun(o,[e,n,r],t.upcastType(n.dtype,r.dtype))}where(e){t.backend_util.warn("tf.where() in webgl locks the UI thread. Call tf.whereAsync() instead");const n=e.dataSync();return pr(e.shape,n)}topk(e,t,n){const r=e.dataSync();return hr(r,e.shape,e.dtype,t,n)}min(e,n){t.backend_util.assertAxesAreInnerMostDims("min",n,e.rank);const[r,o]=t.backend_util.computeOutAndReduceShapes(e.shape,n),i=t.util.sizeFromShape(o),a=e.as2D(-1,i);return this.reduce(a,"min",a.dtype).reshape(r)}minimum(e,n){const r=this.tryRunOnCpuOrThrow([e,n],()=>this.cpuBackend.minimum(e,n));if(r)return r;const o=t.env().getBool("WEBGL_PACK_BINARY_OPERATIONS")?new ut("\n  vec4 result = vec4(min(a, b));\n  vec4 isNaN = min(vec4(isnan(a)) + vec4(isnan(b)), vec4(1.0));\n  \n  result.r = isNaN.r > 0. ? NAN : result.r;\n  result.g = isNaN.g > 0. ? NAN : result.g;\n  result.b = isNaN.b > 0. ? NAN : result.b;\n  result.a = isNaN.a > 0. ? NAN : result.a;\n\n  return result;\n",e.shape,n.shape):new at("\n  if (isnan(a)) return a;\n  if (isnan(b)) return b;\n\n  return min(a, b);\n",e.shape,n.shape);return this.compileAndRun(o,[e,n])}mod(e,n){const r=t.env().getBool("WEBGL_PACK_BINARY_OPERATIONS")?new ut("\n  vec4 result = mod(a, b);\n  vec4 isNaN = vec4(equal(b, vec4(0.0)));\n  \n  result.r = isNaN.r > 0. ? NAN : result.r;\n  result.g = isNaN.g > 0. ? NAN : result.g;\n  result.b = isNaN.b > 0. ? NAN : result.b;\n  result.a = isNaN.a > 0. ? NAN : result.a;\n\n  return result;\n",e.shape,n.shape):new at("if (b == 0.0) return NAN;\n  return mod(a, b);",e.shape,n.shape);return this.compileAndRun(r,[e,n])}maximum(e,n){const r=this.tryRunOnCpuOrThrow([e,n],()=>this.cpuBackend.maximum(e,n));if(r)return r;const o=t.env().getBool("WEBGL_PACK_BINARY_OPERATIONS")?new ut("\n  vec4 result = vec4(max(a, b));\n  vec4 isNaN = min(vec4(isnan(a)) + vec4(isnan(b)), vec4(1.0));\n  \n  result.r = isNaN.r > 0. ? NAN : result.r;\n  result.g = isNaN.g > 0. ? NAN : result.g;\n  result.b = isNaN.b > 0. ? NAN : result.b;\n  result.a = isNaN.a > 0. ? NAN : result.a;\n\n  return result;\n",e.shape,n.shape):new at("\n  if (isnan(a)) return a;\n  if (isnan(b)) return b;\n\n  return max(a, b);\n",e.shape,n.shape);return this.compileAndRun(o,[e,n])}all(e,n){t.backend_util.assertAxesAreInnerMostDims("all",n,e.rank);const[r,o]=t.backend_util.computeOutAndReduceShapes(e.shape,n),i=t.util.sizeFromShape(o),a=e.as2D(-1,i);return this.reduce(a,"all",a.dtype).reshape(r)}any(e,n){t.backend_util.assertAxesAreInnerMostDims("any",n,e.rank);const[r,o]=t.backend_util.computeOutAndReduceShapes(e.shape,n),i=t.util.sizeFromShape(o),a=e.as2D(-1,i);return this.reduce(a,"any",a.dtype).reshape(r)}floorDiv(e,n){if(t.env().getBool("WEBGL_PACK_BINARY_OPERATIONS"))return this.packedBinaryOp(e,n,"\n  ivec4 ia = round(a);\n  ivec4 ib = round(b);\n  bvec4 cond = notEqual(ib, ivec4(0));\n  ivec4 result = ivec4(0);\n  vec4 s = sign(a) * sign(b);\n\n  // Windows (D3D) wants guaranteed non-zero int division at compile-time.\n  if (cond[0]) {\n    result[0] = idiv(ia[0], ib[0], s[0]);\n  }\n  if (cond[1]) {\n    result[1] = idiv(ia[1], ib[1], s[1]);\n  }\n  if (cond[2]) {\n    result[2] = idiv(ia[2], ib[2], s[2]);\n  }\n  if (cond[3]) {\n    result[3] = idiv(ia[3], ib[3], s[3]);\n  }\n  return vec4(result);\n","int32");const r=new at("\n  float s = sign(a) * sign(b);\n  int ia = round(a);\n  int ib = round(b);\n  if (ib != 0) {\n    // Windows (D3D) wants guaranteed non-zero int division at compile-time.\n    return float(idiv(ia, ib, s));\n  } else {\n    return NAN;\n  }\n",e.shape,n.shape);return this.compileAndRun(r,[e,n],"int32")}packedUnaryOp(e,t,n){const r=new sr(e.shape,t);return this.compileAndRun(r,[e],n)}packedBinaryOp(e,t,n,r,o=!1){const i=new ut(n,e.shape,t.shape,o);return this.compileAndRun(i,[e,t],r)}makeComplexComponentTensorInfo(e,t){return{dataId:t.dataId,dtype:t.dtype,shape:e.shape}}addN(e){if(1===e.length)return e[0];if(e.length>t.env().get("WEBGL_MAX_TEXTURES_IN_SHADER")){const t=Math.floor(e.length/2),n=this.addN(e.slice(0,t)),r=this.addN(e.slice(t));return this.addN([n,r])}const n=e.map(e=>e.dtype).reduce((e,n)=>t.upcastType(e,n)),r=e.map(e=>e.shape),o=t.env().getBool("WEBGL_PACK")?new ke(e[0].shape,r):new Fe(e[0].shape,r);return this.compileAndRun(o,e,n)}pow(e,n){const r=t.env().getBool("WEBGL_PACK_BINARY_OPERATIONS")?new ut("\n  // isModRound1 has 1 for components with round(mod(b, 2.0)) == 1, 0 otherwise.\n  vec4 isModRound1 = vec4(equal(round(mod(b, 2.0)), ivec4(1)));\n  vec4 multiplier = sign(a) * isModRound1 + (vec4(1.0) - isModRound1);\n  vec4 result = multiplier * pow(abs(a), b);\n\n  // Ensure that a^0 = 1, including 0^0 = 1 as this correspond to TF and JS\n  bvec4 isExpZero = equal(b, vec4(0.0));\n  result.r = isExpZero.r ? 1.0 : result.r;\n  result.g = isExpZero.g ? 1.0 : result.g;\n  result.b = isExpZero.b ? 1.0 : result.b;\n  result.a = isExpZero.a ? 1.0 : result.a;\n\n  vec4 isNaN = vec4(lessThan(a, vec4(0.0))) * vec4(lessThan(floor(b), b));\n  \n  result.r = isNaN.r > 0. ? NAN : result.r;\n  result.g = isNaN.g > 0. ? NAN : result.g;\n  result.b = isNaN.b > 0. ? NAN : result.b;\n  result.a = isNaN.a > 0. ? NAN : result.a;\n\n  return result;\n",e.shape,n.shape):new at("\nif(a < 0.0 && floor(b) < b){\n  return NAN;\n}\nif (b == 0.0) {\n  return 1.0;\n}\nreturn (round(mod(b, 2.0)) != 1) ?\n    pow(abs(a), b) : sign(a) * pow(abs(a), b);\n",e.shape,n.shape),o=t.upcastType(e.dtype,n.dtype);return this.compileAndRun(r,[e,n],o)}ceil(e){if(this.shouldExecuteOnCPU([e])){const t=Re(this.texData.get(e.dataId).values,e.dtype);return this.makeOutput(e.shape,e.dtype,t)}if(t.env().getBool("WEBGL_PACK_UNARY_OPERATIONS"))return this.packedUnaryOp(e,Zn,e.dtype);const n=new zn(e.shape,Zn);return this.compileAndRun(n,[e])}floor(e){if(this.shouldExecuteOnCPU([e])){const t=ye(this.texData.get(e.dataId).values,e.dtype);return this.makeOutput(e.shape,e.dtype,t)}if(t.env().getBool("WEBGL_PACK_UNARY_OPERATIONS"))return this.packedUnaryOp(e,Jn,e.dtype);const n=new zn(e.shape,Jn);return this.compileAndRun(n,[e])}sign(e){const t=new zn(e.shape,"\n  if (isnan(x)) { return 0.0; }\n  return sign(x);\n");return this.compileAndRun(t,[e])}isNaN(e){const t=new zn(e.shape,"return float(isnan(x));");return this.compileAndRun(t,[e],"bool")}isInf(e){const t=new zn(e.shape,"return float(isinf(x));");return this.compileAndRun(t,[e],"bool")}isFinite(e){const t=new zn(e.shape,"return float(!isnan(x) && !isinf(x));");return this.compileAndRun(t,[e],"bool")}round(e){const t=new zn(e.shape,"\n  // OpenGL ES does not support round function.\n  // The algorithm is based on banker's rounding.\n  float base = floor(x);\n  if ((x - base) < 0.5) {\n    return floor(x);\n  } else if ((x - base) > 0.5) {\n    return ceil(x);\n  } else {\n    if (mod(base, 2.0) == 0.0) {\n      return base;\n    } else {\n      return base + 1.0;\n    }\n  }\n");return this.compileAndRun(t,[e])}exp(e){if(this.shouldExecuteOnCPU([e])){const t=be(this.texData.get(e.dataId).values,e.dtype);return this.makeOutput(e.shape,e.dtype,t)}if(t.env().getBool("WEBGL_PACK_UNARY_OPERATIONS"))return this.packedUnaryOp(e,er,e.dtype);const n=new zn(e.shape,er);return this.compileAndRun(n,[e])}expm1(e){if(this.shouldExecuteOnCPU([e])){const t=we(this.texData.get(e.dataId).values,e.dtype);return this.makeOutput(e.shape,e.dtype,t)}if(t.env().getBool("WEBGL_PACK_UNARY_OPERATIONS"))return this.packedUnaryOp(e,tr,e.dtype);const n=new zn(e.shape,tr);return this.compileAndRun(n,[e])}softmax(e,n){const r=t.util.parseAxisParam([n],e.shape),o=t.max(e,r),i=t.backend_util.expandShapeToKeepDim(o.shape,r),a=t.sub(e,o.reshape(i)),s=this.exp(a),u=this.sum(s,r).reshape(i);return t.div(s,u)}log(e){if(this.shouldExecuteOnCPU([e])){const t=Ie(this.texData.get(e.dataId).values,e.dtype);return this.makeOutput(e.shape,e.dtype,t)}if(t.env().getBool("WEBGL_PACK_UNARY_OPERATIONS"))return this.packedUnaryOp(e,"\n  vec4 result = log(x);\n  vec4 isNaN = vec4(lessThan(x, vec4(0.0)));\n  result.r = isNaN.r == 1.0 ? NAN : result.r;\n  result.g = isNaN.g == 1.0 ? NAN : result.g;\n  result.b = isNaN.b == 1.0 ? NAN : result.b;\n  result.a = isNaN.a == 1.0 ? NAN : result.a;\n\n  return result;\n",e.dtype);const n=new zn(e.shape,"if (x < 0.0) return NAN;\n  return log(x);");return this.compileAndRun(n,[e])}log1p(e){const t=new zn(e.shape,"return log(1.0 + x);");return this.compileAndRun(t,[e])}sqrt(e){const t=new zn(e.shape,"return sqrt(x);");return this.compileAndRun(t,[e])}rsqrt(e){if(this.shouldExecuteOnCPU([e])){const t=Te(this.texData.get(e.dataId).values,e.dtype);return this.makeOutput(e.shape,e.dtype,t)}const t=new zn(e.shape,"return inversesqrt(x);");return this.compileAndRun(t,[e])}reciprocal(e){const t=new zn(e.shape,"return 1.0 / x;");return this.compileAndRun(t,[e])}relu(e){let n;return n=t.env().getBool("WEBGL_PACK")?new sr(e.shape,or):new zn(e.shape,jn),this.compileAndRun(n,[e])}relu6(e){let n;return n=t.env().getBool("WEBGL_PACK")?new sr(e.shape,ir):new zn(e.shape,Kn),this.compileAndRun(n,[e])}prelu(e,n){const r=t.env().getBool("WEBGL_PACK_BINARY_OPERATIONS")?new ut(st,e.shape,n.shape):new at(it,e.shape,n.shape);return this.compileAndRun(r,[e,n])}elu(e){if(t.env().getBool("WEBGL_PACK_UNARY_OPERATIONS"))return this.packedUnaryOp(e,ar,e.dtype);const n=new zn(e.shape,qn);return this.compileAndRun(n,[e])}eluDer(e,n){const r=t.env().getBool("WEBGL_PACK_BINARY_OPERATIONS")?new ut("\n  vec4 bGTEZero = vec4(greaterThanEqual(b, vec4(0.)));\n  return (bGTEZero * a) + ((vec4(1.0) - bGTEZero) * (a * (b + vec4(1.0))));\n",e.shape,n.shape):new at("return (b >= 1.0) ? a : a * (b + 1.0);",e.shape,n.shape);return this.compileAndRun(r,[e,n])}selu(e){const t=new zn(e.shape,Yn);return this.compileAndRun(t,[e])}clip(e,n,r){let o;o=t.env().getBool("WEBGL_PACK_CLIP")?new ct(e.shape):new lt(e.shape);const i=o.getCustomSetupFunc(n,r);return this.compileAndRun(o,[e],null,i)}abs(e){if(this.shouldExecuteOnCPU([e])&&"complex64"!==e.dtype){const t=ve(this.texData.get(e.dataId).values);return this.makeOutput(e.shape,e.dtype,t)}if(t.env().getBool("WEBGL_PACK_UNARY_OPERATIONS"))return this.packedUnaryOp(e,Hn,e.dtype);const n=new zn(e.shape,Hn);return this.compileAndRun(n,[e])}complexAbs(e){const t=this.texData.get(e.dataId),n=new dt(e.shape),r=[this.makeComplexComponentTensorInfo(e,t.complexTensorInfos.real),this.makeComplexComponentTensorInfo(e,t.complexTensorInfos.imag)];return this.compileAndRun(n,r)}sigmoid(e){const t=new zn(e.shape,"return 1.0 / (1.0 + exp(-1.0 * x));");return this.compileAndRun(t,[e])}softplus(e){const t=new zn(e.shape,"\n  float epsilon = 1.1920928955078125e-7;\n  float threshold = log(epsilon) + 2.0;\n\n  bool too_large = x > -threshold;\n  bool too_small = x < threshold;\n\n  float result;\n  float exp_x = exp(x);\n\n  if (too_large){\n    result = x;\n  }\n  else if (too_small){\n    result = exp_x;\n  }\n  else{\n    result = log(exp_x + 1.0);\n  }\n  return result;\n");return this.compileAndRun(t,[e])}asin(e){const t=new zn(e.shape,"if (isnan(x)) return x;\n  if (abs(x) > 1.) {\n    return NAN;\n  }\n  return asin(x);\n");return this.compileAndRun(t,[e])}acos(e){const t=new zn(e.shape,"if (isnan(x)) return x;\n  if (abs(x) > 1.) {\n    return NAN;\n  }\n  return acos(x);\n");return this.compileAndRun(t,[e])}atan(e){const t=new zn(e.shape,"if (isnan(x)) return x;\n  return atan(x);\n");return this.compileAndRun(t,[e])}sinh(e){const t=new zn(e.shape,"\n  float e2x = exp(x);\n  return (e2x - 1.0 / e2x) / 2.0;\n");return this.compileAndRun(t,[e])}cosh(e){const t=new zn(e.shape,"\n  float e2x = exp(-x);\n  return (e2x + 1.0 / e2x) / 2.0;\n");return this.compileAndRun(t,[e])}tanh(e){const t=new zn(e.shape,"\n  float e2x = exp(-2.0 * abs(x));\n  return sign(x) * (1.0 - e2x) / (1.0 + e2x);\n");return this.compileAndRun(t,[e])}asinh(e){const t=new zn(e.shape,"if (isnan(x)) return x;return log(x + sqrt(x * x + 1.0));");return this.compileAndRun(t,[e])}acosh(e){const t=new zn(e.shape,"if (isnan(x)) return x;\n  if (x < 1.0) return NAN;\n  return log(x + sqrt(x * x - 1.0));");return this.compileAndRun(t,[e])}atanh(e){const t=new zn(e.shape,"if (isnan(x)) return x;\n  if ((x < -1.0) || (x > 1.0)) return NAN;\n  return (log(1.0 + x) - log(1.0 - x)) / 2.0;");return this.compileAndRun(t,[e])}erf(e){const t=new zn(e.shape,nr);return this.compileAndRun(t,[e])}step(e,t){const n=new zn(e.shape,function(e=0){return Xn+`\n    return x > 0.0 ? 1.0 : float(${e});\n  `}(t));return this.compileAndRun(n,[e])}conv2dByMatMul(e,n,r,o,i,a){const s=e.shape,u=this.texData.get(e.dataId),l=r.inChannels,c=s[0]*s[1]*s[2],d=r.outChannels,h="channelsLast"===r.dataFormat,p=(1===c||1===d)&&l>1e3,f=s[2]%2!=0&&!!u.isPacked;if(p||!t.env().getBool("WEBGL_LAZILY_UNPACK")||!t.env().getBool("WEBGL_PACK_BINARY_OPERATIONS")||!f){const u=h?s[0]*s[1]*s[2]:s[0]*s[2]*s[3],l=t.reshape(e,[1,u,r.inChannels]),c=t.reshape(n,[1,r.inChannels,r.outChannels]),d=this.fusedBatchMatMul({a:l,b:c,transposeA:!1,transposeB:!1,bias:o,activation:i,preluActivationWeights:a});return t.reshape(d,r.outShape)}const x=h?s[0]*s[1]*(s[2]+1):s[0]*s[2]*(s[3]+1),g={dataId:e.dataId,shape:[1,x,r.inChannels],dtype:e.dtype},m=u.shape;u.shape=u.shape.slice(),u.shape[u.shape.length-2]++,t.util.assert(z(u.shape,g.shape),()=>`packed reshape ${u.shape} to ${g.shape} isn't free`);const C=t.reshape(n,[1,r.inChannels,r.outChannels]),v=this.fusedBatchMatMul({a:g,b:C,transposeA:!1,transposeB:!1,bias:o,activation:i,preluActivationWeights:a}),$=this.texData.get(v.dataId);return t.util.assert($.isPacked,()=>"batchMatMul result is expected to be packed"),u.shape=m,$.shape=r.outShape,t.engine().makeTensorFromDataId(v.dataId,r.outShape,v.dtype)}conv2dWithIm2Row(e,t,n,r,o,i){const{filterWidth:a,filterHeight:s,inChannels:u,outWidth:l,outHeight:c,dataFormat:d}=n,h="channelsLast"===d,p=a*s*u,f=c*l,x=[p,f],g=e.squeeze([0]),m=t.reshape([1,p,-1]),C=new ln(x,g.shape,n),v=this.compileAndRun(C,[g]).reshape([1,x[0],x[1]]),$=null!=r,R=null!=i,b=o?xr(o,!0):null,w=new xn(v.shape,m.shape,[1,f,n.outChannels],!0,!1,$,b,R),y=[v,m];r&&y.push(r),R&&y.push(i);const I=this.compileAndRun(w,y);return h?I.reshape([1,c,l,n.outChannels]):I.reshape([1,n.outChannels,c,l])}fusedConv2d({input:e,filter:n,convInfo:r,bias:o,activation:i,preluActivationWeights:a}){if(1===r.filterHeight&&1===r.filterWidth&&1===r.dilationHeight&&1===r.dilationWidth&&1===r.strideHeight&&1===r.strideWidth&&("SAME"===r.padInfo.type||"VALID"===r.padInfo.type))return this.conv2dByMatMul(e,n,r,o,i,a);if(t.env().getBool("WEBGL_CONV_IM2COL")&&1===e.shape[0])return this.conv2dWithIm2Row(e,n,r,o,i,a);const s=null!=o,u=null!=a,l=i?xr(i,!1):null,c=new Ct(r,s,l,u),d=[e,n];return o&&d.push(o),a&&d.push(a),this.compileAndRun(c,d)}conv2d(e,n,r){if(1===r.filterHeight&&1===r.filterWidth&&1===r.dilationHeight&&1===r.dilationWidth&&1===r.strideHeight&&1===r.strideWidth&&("SAME"===r.padInfo.type||"VALID"===r.padInfo.type))return this.conv2dByMatMul(e,n,r);if(t.env().getBool("WEBGL_CONV_IM2COL")&&1===e.shape[0])return this.conv2dWithIm2Row(e,n,r);const o=new Ct(r);return this.compileAndRun(o,[e,n])}conv2dDerInput(e,t,n){const r=new pt(n);return this.compileAndRun(r,[e,t])}conv2dDerFilter(e,t,n){const r=new ht(n);return this.compileAndRun(r,[e,t])}fusedDepthwiseConv2D({input:e,filter:n,convInfo:r,bias:o,activation:i,preluActivationWeights:a}){const s=t.env().getBool("WEBGL_PACK_DEPTHWISECONV")&&r.strideWidth<=2&&r.outChannels/r.inChannels==1,u=i?xr(i,s):null,l=[e,n],c=null!=o,d=null!=a;let h;return c&&l.push(o),d&&l.push(a),s?(h=new Rt(r,c,u,d),this.compileAndRun(h,l)):(h=new $t(r,c,u,d),this.compileAndRun(h,l))}depthwiseConv2D(e,n,r){let o;return t.env().getBool("WEBGL_PACK_DEPTHWISECONV")&&r.strideWidth<=2&&r.outChannels/r.inChannels==1?(o=new Rt(r),this.compileAndRun(o,[e,n])):(o=new $t(r),this.compileAndRun(o,[e,n]))}depthwiseConv2DDerInput(e,t,n){const r=new mt(n);return this.compileAndRun(r,[e,t])}depthwiseConv2DDerFilter(e,t,n){const r=new gt(n);return this.compileAndRun(r,[e,t])}conv3d(e,t,n){const r=new vt(n);return this.compileAndRun(r,[e,t])}conv3dDerInput(e,t,n){const r=new xt(n);return this.compileAndRun(r,[e,t])}conv3dDerFilter(e,t,n){const r=new ft(n);return this.compileAndRun(r,[e,t])}unstack(e,t){const n=e.shape[t],r=new Array(e.rank-1);let o=0;for(let n=0;n<e.rank;n++)n!==t&&(r[o++]=e.shape[n]);const i=new Array(e.rank).fill(0),a=e.shape.slice();a[t]=1;const s=new Array(n);for(let n=0;n<s.length;n++)i[t]=n,s[n]=this.slice(e,i,a).reshape(r);return s}avgPool3d(e,t){const n=new bn(t,"avg",!1);return this.compileAndRun(n,[e],"float32")}avgPool3dBackprop(e,t,n){const r=new ot(n);return this.compileAndRun(r,[e],t.dtype)}maxPool3d(e,t){const n=new bn(t,"max",!1);return this.compileAndRun(n,[e],"float32")}maxPool3dBackprop(e,t,n,r){const o=new bn(r,"max",!0),i=this.compileAndRun(o,[t]),a=new fn(r),s=this.compileAndRun(a,[e,i],t.dtype);return i.dispose(),s}resizeBilinear(e,n,r,o){const i=t.env().getBool("WEBGL_PACK_IMAGE_OPERATIONS")?new An(e.shape,n,r,o):new En(e.shape,n,r,o);return this.compileAndRun(i,[e],"float32")}resizeBilinearBackprop(e,t,n){const r=new In(e,t,n);return this.compileAndRun(r,[e])}resizeNearestNeighbor(e,t,n,r){const o=new On(e.shape,t,n,r);return this.compileAndRun(o,[e])}resizeNearestNeighborBackprop(e,t,n){const r=new Tn(e,t,n);return this.compileAndRun(r,[e])}multinomial(e,n,r,o){const i=n?e:t.softmax(e),a=i.shape[0],s=i.shape[1],u=new gn(a,s,r),l=u.getCustomSetupFunc(o);return this.compileAndRun(u,[i],"int32",l)}oneHot(e,t,n,r){const o=new mn(e.size,t,n,r);return this.compileAndRun(o,[e])}diag(e){const t=new Ot(e.size);return this.compileAndRun(t,[e])}cropAndResize(e,t,n,r,o,i){const a=new bt(e.shape,t.shape,r,o,i);return this.compileAndRun(a,[e,t,n],"float32")}depthToSpace(e,n,r){t.util.assert(n>1,()=>`blockSize should be > 1 for depthToSpace, but was: ${n}`);const o=e.shape[0],i="NHWC"===r?e.shape[1]:e.shape[2],a="NHWC"===r?e.shape[2]:e.shape[3],s="NHWC"===r?e.shape[3]:e.shape[1],u=i*n,l=a*n,c=s/(n*n),d=new Tt("NHWC"===r?[o,u,l,c]:[o,c,u,l],n,r);return this.compileAndRun(d,[e])}split(e,t,n){return cr(e,t,n)}scatterND(e,n,r){const{sliceRank:o,numUpdates:i,sliceSize:a,strides:s,outputSize:u}=t.backend_util.calculateShapes(n,e,r),l=[u/a,a],c=e.reshape([i,o]),d=n.reshape([i,a]);if(0===u)return t.backend_util.reshapeTensor(t.tensor([]),r);const h=t.scalar(0),p=new Nn(i,o,c.rank,d.rank,s,l);return this.compileAndRun(p,[d,c,h]).reshape(r)}sparseToDense(e,n,r,o){const{sliceRank:i,numUpdates:a,strides:s,outputSize:u}=t.backend_util.calculateShapes(n,e,r),l=new Nn(a,i,e.rank,n.rank,s,[u,1],!1);return this.compileAndRun(l,[n,e,o]).reshape(r)}gatherND(e,n){const r=n.shape,o=r[r.length-1],[i,a,s,u]=t.backend_util.prepareAndValidate(e,n),l=n.reshape([a,o]),c=e.reshape([e.size/s,s]),d=new Pt(o,u,[a,s]);return this.compileAndRun(d,[c,l]).reshape(i)}fill(e,n,r){if("string"===(r=r||t.util.inferDtype(n))){const o=t.util.getArrayFromDType(r,t.util.sizeFromShape(e));return o.fill(n),t.engine().makeTensor(o,e,r,this)}{const t=new kt(e,n),o=t.getCustomSetupFunc(n);return this.compileAndRun(t,[],r,o)}}onesLike(e){if("string"===e.dtype)throw new Error("onesLike is not supported under string dtype");return this.fill(e.shape,1,e.dtype)}zerosLike(e){return this.fill(e.shape,"string"===e.dtype?"":0,e.dtype)}linspace(e,n,r){return t.backend_util.linspaceImpl(e,n,r)}makeTensorInfo(e,t,n){const r=this.write(n,e,t);return this.texData.get(r).usage=null,{dataId:r,shape:e,dtype:t}}makeOutput(e,n,r){const{dataId:o}=this.makeTensorInfo(e,n,r);return t.engine().makeTensorFromDataId(o,e,n,this)}unpackTensor(e){const t=new ur(e.shape);return this.runWebGLProgram(t,[e],e.dtype)}packTensor(e){const t=new Cn(e.shape);return this.runWebGLProgram(t,[e],e.dtype,null,!0)}packedReshape(e,t){const n=[V(e.shape),...M(e.shape)],r={dtype:e.dtype,shape:n,dataId:e.dataId},o=[V(t),...M(t)],i=new yn(o,n),a=this.runWebGLProgram(i,[r],e.dtype,null,!0);return{dataId:a.dataId,shape:t,dtype:a.dtype}}decode(e){const t=this.texData.get(e),{isPacked:n,shape:r,dtype:o}=t,i=W(r);let a;a=n?new At(i):new Et(i);return{dtype:o,shape:r,dataId:this.runWebGLProgram(a,[{shape:i,dtype:o,dataId:e}],o,null,!0).dataId}}runWebGLProgram(e,n,r,o,i=!1){const s=this.makeTensorInfo(e.outputShape,r),u=this.texData.get(s.dataId);if(e.packedOutput&&(u.isPacked=!0),e.outPackingScheme===a.DENSE){const t=c(e.outputShape);u.texShape=t.map(e=>2*e)}if(null!=e.outTexUsage&&(u.usage=e.outTexUsage),0===t.util.sizeFromShape(s.shape))return u.values=t.util.getTypedArrayFromDType(s.dtype,0),s;const l=[],d=n.map(n=>{if("complex64"===n.dtype)throw new Error("GPGPUProgram does not support complex64 input. For complex64 dtypes, please separate the program into real and imaginary parts.");let r=this.texData.get(n.dataId);if(null==r.texture){if(!e.packedInputs&&t.util.sizeFromShape(n.shape)<=t.env().getNumber("WEBGL_SIZE_UPLOAD_UNIFORM"))return{shape:n.shape,texData:null,isUniform:!0,uniformValues:r.values};e.packedInputs&&(r.isPacked=!0,r.shape=n.shape)}else if(!!r.isPacked!=!!e.packedInputs)n=r.isPacked?this.unpackTensor(n):this.packTensor(n),l.push(n),r=this.texData.get(n.dataId);else if(r.isPacked&&!z(r.shape,n.shape)){const e=n,t=n.shape;n.shape=r.shape,n=this.packedReshape(n,t),l.push(n),r=this.texData.get(n.dataId),e.shape=t}return this.uploadToGPU(n.dataId),{shape:n.shape,texData:r,isUniform:!1}});this.uploadToGPU(s.dataId);const h={shape:s.shape,texData:u,isUniform:!1},p=function(e,t,n){let r="";t.concat(n).forEach(e=>{const t=null!=e.texData&&null!=e.texData.slice&&e.texData.slice.flatOffset>0,n=e.isUniform?"uniform":e.texData.texShape;r+=`${e.shape}_${n}_${t}`});const o=e.userCode;let i=e.constructor.name;return i+="_"+r+"_"+o,i}(e,d,h),f=this.getAndSaveBinary(p,()=>function(e,n,r,o){const i=n.userCode,a=r.map((e,t)=>{const r={logicalShape:e.shape,texShape:e.isUniform?null:e.texData.texShape,isUniform:e.isUniform,isPacked:!e.isUniform&&e.texData.isPacked,flatOffset:null};return null!=e.texData&&null!=e.texData.slice&&e.texData.slice.flatOffset>0&&(r.flatOffset=e.texData.slice.flatOffset),{name:n.variableNames[t],shapeInfo:r}}),s=a.map(e=>e.shapeInfo),u={logicalShape:o.shape,texShape:o.texData.texShape,isUniform:!1,isPacked:o.texData.isPacked,flatOffset:null},l=Ge(a,u,i,n.packedInputs),c=e.createProgram(l);let d=null;const h=e.getUniformLocation(c,"NAN",!1);1===t.env().getNumber("WEBGL_VERSION")&&(d=e.getUniformLocation(c,"INFINITY",!1));const p={};for(let t=0;t<n.variableNames.length;t++){const r=n.variableNames[t],o=!1;p[r]=e.getUniformLocation(c,r,o),p[`offset${r}`]=e.getUniformLocation(c,`offset${r}`,o)}return{program:n,source:l,webGLProgram:c,uniformLocations:p,inShapeInfos:s,outShapeInfo:u,infLoc:d,nanLoc:h}}(this.gpgpu,e,d,h)),x=null!=this.activeTimers;let g;if(x&&(g=this.startTimer()),function(e,n,r,o,i){un(n.inShapeInfos,r),un([n.outShapeInfo],[o]);const a=o.texData.texture,s=o.texData.texShape;o.texData.isPacked?e.setOutputPackedMatrixTexture(a,s[0],s[1]):e.setOutputMatrixTexture(a,s[0],s[1]),e.setProgram(n.webGLProgram),1===t.env().getNumber("WEBGL_VERSION")&&null!==n.infLoc&&e.gl.uniform1f(n.infLoc,1/0),null!==n.nanLoc&&e.gl.uniform1f(n.nanLoc,NaN),r.forEach((r,o)=>{const i=n.program.variableNames[o],a=n.uniformLocations[i],s=n.uniformLocations[`offset${i}`];if(null!=a)if(r.isUniform)if(t.util.sizeFromShape(r.shape)<2)e.gl.uniform1f(a,r.uniformValues[0]);else{let t=r.uniformValues;t instanceof Float32Array||(t=new Float32Array(t)),e.gl.uniform1fv(a,t)}else null!=r.texData.slice&&null!=s&&e.gl.uniform1i(s,r.texData.slice.flatOffset),e.setInputMatrixTexture(r.texData.texture,a,o)}),null!=i&&i(e,n.webGLProgram),e.executeProgram()}(this.gpgpu,f,d,h,o),l.forEach(e=>this.disposeIntermediateTensorInfo(e)),x&&(g=this.endTimer(g),this.activeTimers.push({name:e.constructor.name,query:this.getQueryTime(g)})),!t.env().getBool("WEBGL_LAZILY_UNPACK")&&u.isPacked&&!1===i){const e=this.unpackTensor(s);return this.disposeIntermediateTensorInfo(s),e}return s}compileAndRun(e,n,r,o,i=!1){r=r||n[0].dtype;const a=this.runWebGLProgram(e,n,r,o,i);return t.engine().makeTensorFromDataId(a.dataId,a.shape,a.dtype)}getAndSaveBinary(e,t){return e in this.binaryCache||(this.binaryCache[e]=t()),this.binaryCache[e]}getTextureManager(){return this.textureManager}dispose(){if(!this.disposed){if(!t.env().getBool("IS_TEST")){Object.keys(this.binaryCache).forEach(e=>{this.gpgpu.deleteProgram(this.binaryCache[e].webGLProgram),delete this.binaryCache[e]})}this.textureManager.dispose(),null!=this.canvas&&"undefined"!=typeof HTMLCanvasElement&&this.canvas instanceof HTMLCanvasElement?this.canvas.remove():this.canvas=null,this.gpgpuCreatedLocally&&(this.gpgpu.program=null,this.gpgpu.dispose()),this.disposed=!0}}floatPrecision(){return null==this.floatPrecisionValue&&(this.floatPrecisionValue=t.tidy(()=>{if(!t.env().get("WEBGL_RENDER_FLOAT32_ENABLED")){const e=t.env().getBool("DEBUG");t.env().set("DEBUG",!1);const n=this.abs(t.scalar(1e-8)).dataSync()[0];if(t.env().set("DEBUG",e),n>0)return 32}return 16})),this.floatPrecisionValue}epsilon(){return 32===this.floatPrecision()?1e-7:1e-4}uploadToGPU(e){const n=this.texData.get(e),{shape:r,dtype:o,values:i,texture:a,usage:u,isPacked:l}=n;if(null!=a)return;const c=null!=this.activeTimers;let h;c&&(h=t.util.now());let p=n.texShape;if(null==p&&(p=U(r,l),n.texShape=p),null!=i){const e=W(r);let a,u=p[1],f=p[0];const x=i instanceof Uint8Array;l?([u,f]=d(p[0],p[1]),a=new Ft(e,[f,u],x)):a=new Nt(e,[f,u],x);const g=this.makeTensorInfo([f,u],o);this.texData.get(g.dataId).usage=x?s.PIXELS:s.UPLOAD,this.gpgpu.uploadDenseMatrixToTexture(this.getTexture(g.dataId),u,f,i);const m=!0,C=this.runWebGLProgram(a,[g],o,null,m),v=this.texData.get(C.dataId);n.texture=v.texture,n.texShape=v.texShape,n.isPacked=v.isPacked,n.usage=v.usage,this.disposeIntermediateTensorInfo(g),this.texData.delete(C.dataId),n.values=null,c&&(this.uploadWaitMs+=t.util.now()-h)}else{const e=this.acquireTexture(p,u,o,l);n.texture=e}}convertAndCacheOnCPU(e,t){const n=this.texData.get(e),{dtype:r}=n;return this.releaseGPUData(e),null!=t&&(n.values=function(e,t){if("float32"===t||"complex64"===t)return e;if("int32"===t||"bool"===t){const n="int32"===t?new Int32Array(e.length):new Uint8Array(e.length);for(let t=0;t<n.length;++t)n[t]=Math.round(e[t]);return n}throw new Error(`Unknown dtype ${t}`)}(t,r)),n.values}acquireTexture(e,t,n,r){if(this.numBytesInGPU+=this.computeBytes(e,n),!this.warnedAboutMemory&&this.numBytesInGPU>1024*this.numMBBeforeWarning*1024){const e=(this.numBytesInGPU/1024/1024).toFixed(2);this.warnedAboutMemory=!0,console.warn(`High memory usage in GPU: ${e} MB, `+"most likely due to a memory leak")}return this.textureManager.acquireTexture(e,t,r)}computeBytes(e,n){return e[0]*e[1]*t.util.bytesPerElement(n)}tryRunOnCpuOrThrow(e,n){if(this.shouldExecuteOnCPU(e))try{return n()}catch(e){if(t.env().getBool("IS_TEST"))throw new Error("CPU forwarding failed")}return null}}function mr(){t.env().set("WEBGL_FORCE_F16_TEXTURES",!0)}t.device_util.isBrowser()&&t.registerBackend("webgl",()=>new gr,2);const Cr={forceHalfFloat:mr};function vr(e){const{inputs:t,backend:n}=e,{x:r}=t;return n.incRef(r.dataId),{dataId:r.dataId,shape:r.shape,dtype:r.dtype}}const $r={kernelName:t.Identity,backendName:"webgl",kernelFunc:vr};function Rr(e){const{inputs:t,backend:n}=e,{real:r,imag:o}=t,i=n.makeTensorInfo(r.shape,"complex64"),a=n.texData.get(i.dataId),s=vr({inputs:{x:r},backend:n});n.texData.get(s.dataId).complexParentRefCount++;const u=vr({inputs:{x:o},backend:n});return n.texData.get(u.dataId).complexParentRefCount++,a.complexTensorInfos={real:s,imag:u},i}const br={kernelName:t.Complex,backendName:"webgl",kernelFunc:Rr};function wr(e){return({inputs:t,backend:n})=>{const{x:r}=t,o=n,i=new zn(r.shape,e);return o.runWebGLProgram(i,[r],r.dtype)}}function yr({opSnippet:e,packedOpSnippet:n,checkOutOfBounds:r=!1,supportsComplex:o=!1,cpuKernelImpl:i,dtype:a}){return({inputs:s,backend:u})=>{const{a:l,b:c}=s,d=u;if(o&&"complex64"===l.dtype){const n=d.texData.get(l.dataId),r=d.texData.get(c.dataId),[o,i]=[[n.complexTensorInfos.real,r.complexTensorInfos.real],[n.complexTensorInfos.imag,r.complexTensorInfos.imag]].map(n=>{const[r,o]=n,i={dataId:r.dataId,dtype:r.dtype,shape:l.shape},a={dataId:o.dataId,dtype:o.dtype,shape:c.shape},s=new at(e,l.shape,c.shape);return d.runWebGLProgram(s,[i,a],t.upcastType(r.dtype,o.dtype))}),a=Rr({inputs:{real:o,imag:i},backend:d});return d.disposeIntermediateTensorInfo(o),d.disposeIntermediateTensorInfo(i),a}const h=a||t.upcastType(l.dtype,c.dtype);if(d.shouldExecuteOnCPU([l,c])&&null!=i){const e=d.texData.get(l.dataId),t=d.texData.get(c.dataId),[n,r]=i(l.shape,c.shape,e.values,t.values,h),o=d.makeTensorInfo(r,h);return d.texData.get(o.dataId).values=n,o}let p;return p=t.env().getBool("WEBGL_PACK_BINARY_OPERATIONS")&&null!=n?new ut(n,l.shape,c.shape,r):new at(e,l.shape,c.shape),d.runWebGLProgram(p,[l,c],h)}}const Ir="return a + b;",Er=yr({opSnippet:Ir,packedOpSnippet:Ir,supportsComplex:!0,cpuKernelImpl:$e}),Ar={kernelName:t.Add,backendName:"webgl",kernelFunc:Er},Tr=yr({opSnippet:"\n  if (isnan(a)) return a;\n  if (isnan(b)) return b;\n\n  return atan(a, b);\n",packedOpSnippet:"\n  vec4 result = atan(a, b);\n  vec4 isNaN = min(vec4(isnan(a)) + vec4(isnan(b)), vec4(1.0));\n  \n  result.r = isNaN.r > 0. ? NAN : result.r;\n  result.g = isNaN.g > 0. ? NAN : result.g;\n  result.b = isNaN.b > 0. ? NAN : result.b;\n  result.a = isNaN.a > 0. ? NAN : result.a;\n\n  return result;\n"}),Or={kernelName:t.Atan2,backendName:"webgl",kernelFunc:Tr};const _r={kernelName:t.AvgPool,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:r,attrs:o}=e,{x:i}=n;ne(i,"avgPool");const{filterSize:a,strides:s,pad:u,dimRoundingMode:l}=o;t.util.assert(t.backend_util.eitherStridesOrDilationsAreOne(s,1),()=>"Error in avgPool: Either strides or dilations must be 1. "+`Got strides ${s} and dilations '1'`);const c=t.backend_util.computePool2DInfo(i.shape,a,s,1,u,l);if(1===c.filterWidth&&1===c.filterHeight&&t.util.arraysEqual(c.inShape,c.outShape))return vr({inputs:{x:i},backend:r});const d=new Rn(c,"avg",!1);return r.runWebGLProgram(d,[i],"float32")}};const Sr={kernelName:t.AvgPoolBackprop,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:r,attrs:o}=e,{dy:i,input:a}=n,s=a;ne([i,a],"avgPoolBackprop");const{filterSize:u,strides:l,pad:c}=o,d=t.backend_util.computePool2DInfo(s.shape,u,l,1,c),h=new rt(d);return r.runWebGLProgram(h,[i],s.dtype)}};class Nr{constructor(e,n,r,o,i,a){this.outputShape=[],this.variableNames=["x","mean","variance"],t.backend_util.assertAndGetBroadcastShape(e,n),t.backend_util.assertAndGetBroadcastShape(e,r);let s="0.0";null!=o&&(t.backend_util.assertAndGetBroadcastShape(e,o),this.variableNames.push("offset"),s="getOffsetAtOutCoords()");let u="1.0";null!=i&&(t.backend_util.assertAndGetBroadcastShape(e,i),this.variableNames.push("scale"),u="getScaleAtOutCoords()"),this.outputShape=e,this.userCode=`\n      void main() {\n        float x = getXAtOutCoords();\n        float mean = getMeanAtOutCoords();\n        float variance = getVarianceAtOutCoords();\n        float offset = ${s};\n        float scale = ${u};\n        float inv = scale * inversesqrt(variance + float(${a}));\n        setOutput(dot(vec3(x, -mean, offset), vec3(inv, inv, 1)));\n      }\n    `}}class Fr{constructor(e,n,r,o,i,a){this.packedInputs=!0,this.packedOutput=!0,this.variableNames=["x","mean","variance"],t.backend_util.assertAndGetBroadcastShape(e,n),t.backend_util.assertAndGetBroadcastShape(e,r);let s="vec4(0.0)";null!=o&&(t.backend_util.assertAndGetBroadcastShape(e,o),this.variableNames.push("offset"),s="getOffsetAtOutCoords()");let u="vec4(1.0)";null!=i&&(t.backend_util.assertAndGetBroadcastShape(e,i),this.variableNames.push("scale"),u="getScaleAtOutCoords()"),this.outputShape=e,this.userCode=`\n      void main() {\n        vec4 offset = ${s};\n        vec4 scale = ${u};\n\n        vec4 x = getXAtOutCoords();\n        vec4 mean = getMeanAtOutCoords();\n        vec4 variance = getVarianceAtOutCoords();\n\n        vec4 inv = scale * inversesqrt(variance + vec4(${a}));\n\n        setOutput((x - mean) * inv + offset);\n      }\n    `}}const kr={kernelName:t.FusedBatchNorm,backendName:"webgl",kernelFunc:({inputs:e,backend:n,attrs:r})=>{const{x:o,mean:i,variance:a,offset:s,scale:u}=e;t.util.assert(i.shape.length===a.shape.length,()=>"Batch normalization gradient requires mean and variance to have equal ranks."),t.util.assert(null==s||i.shape.length===s.shape.length,()=>"Batch normalization gradient requires mean and offset to have equal ranks."),t.util.assert(null==u||i.shape.length===u.shape.length,()=>"Batch normalization gradient requires mean and scale to have equal ranks.");let{varianceEpsilon:l}=r;null==l&&(l=.001);const c=[o,i,a];let d=null;null!=s&&(d=s.shape,c.push(s));let h=null;null!=u&&(h=u.shape,c.push(u));const p=t.env().getBool("WEBGL_PACK_NORMALIZATION")?new Fr(o.shape,i.shape,a.shape,d,h,l):new Nr(o.shape,i.shape,a.shape,d,h,l);return n.runWebGLProgram(p,c,c[0].dtype)}},Dr=yr({opSnippet:"return float(a != b);",dtype:"bool"}),Pr={kernelName:t.NotEqual,backendName:"webgl",kernelFunc:Dr};function Lr(e){const{inputs:t,backend:n}=e,{input:r}=t;return vr({inputs:{x:n.texData.get(r.dataId).complexTensorInfos.real},backend:n})}const Br={kernelName:t.Real,backendName:"webgl",kernelFunc:Lr};const Vr={kernelName:t.Cast,backendName:"webgl",kernelFunc:function e(n){const{inputs:r,backend:o,attrs:i}=n,{x:a}=r,{dtype:s}=i;if("complex64"===s){if("complex64"===a.dtype)return vr({inputs:{x:a},backend:o});const n=t.zeros(a.shape),r=e({inputs:{x:a},backend:o,attrs:{dtype:"float32"}}),i=Rr({inputs:{real:r,imag:n},backend:o});return n.dispose(),o.disposeIntermediateTensorInfo(r),i}if("complex64"===a.dtype){const t=Lr({inputs:{input:a},backend:o}),n=e({inputs:{x:t},backend:o,attrs:{dtype:s}});return o.disposeIntermediateTensorInfo(t),n}if(!t.util.hasEncodingLoss(a.dtype,s)){const e=vr({inputs:{x:a},backend:o});return{dataId:e.dataId,shape:e.shape,dtype:s}}if("int32"===s)return function(e,t){const n=new zn(e.shape,"return float(int(x));"),r=t.runWebGLProgram(n,[e],"int32");return{dataId:r.dataId,shape:r.shape,dtype:r.dtype}}(a,o);if("bool"===s){const e=o.makeTensorInfo([],"bool",t.util.getTypedArrayFromDType("bool",1)),n=Dr({inputs:{a:a,b:e},backend:o});return o.disposeIntermediateTensorInfo(e),n}throw new Error(`Error in Cast: failed to cast ${a.dtype} to ${s}`)}};class Mr{constructor(e){this.outputShape=[],this.outputShape=t.backend_util.computeOutShape(e,1),this.variableNames=e.map((e,t)=>`T${t}`);const n=new Array(e.length-1);n[0]=e[0][1];for(let t=1;t<n.length;t++)n[t]=n[t-1]+e[t][1];const r=[`if (yC < ${n[0]}) setOutput(getT0(yR, yC));`];for(let e=1;e<n.length;e++){const t=n[e-1];r.push(`else if (yC < ${n[e]}) `+`setOutput(getT${e}(yR, yC-${t}));`)}const o=n.length,i=n[n.length-1];r.push(`else setOutput(getT${o}(yR, yC-${i}));`),this.userCode=`\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int yR = coords.x;\n        int yC = coords.y;\n\n        ${r.join("\n        ")}\n      }\n    `}}class Wr{constructor(e,n){this.packedInputs=!0,this.packedOutput=!0,this.outputShape=[],this.outputShape=t.backend_util.computeOutShape(e,n);const r=this.outputShape,o=r.length,i=Je(o),a=Le("coords",o),s=["x","y","z","w","u","v"].slice(0,o);this.variableNames=e.map((e,t)=>`T${t}`);const u=new Array(e.length-1);u[0]=e[0][n];for(let t=1;t<u.length;t++)u[t]=u[t-1]+e[t][n];const l=s[n],c=s.slice(-2),d=s.join();let h=`if (${l} < ${u[0]}) {\n        return getChannel(\n            getT0(${d}), vec2(${c.join()}));\n        }`;for(let e=1;e<u.length;e++){const t=u[e-1];h+=`\n        if (${l} < ${u[e]}  && ${l} >= ${u[e-1]}) {\n          return getChannel(\n            getT${e}(${Ur(s,l,t)}),\n            vec2(${Ur(c,l,t)}));\n        }`}const p=u.length,f=u[u.length-1];h+=`\n        return getChannel(\n          getT${p}(${Ur(s,l,f)}),\n          vec2(${Ur(c,l,f)}));`,this.userCode=`\n      float getValue(${s.map(e=>"int "+e)}) {\n        ${h}\n      }\n\n      void main() {\n        ${i} coords = getOutputCoords();\n        vec4 result = vec4(getValue(${a}), 0., 0., 0.);\n\n        ${a[o-1]} = ${a[o-1]} + 1;\n        if (${a[o-1]} < ${r[o-1]}) {\n          result.g = getValue(${a});\n        }\n\n        ${a[o-2]} = ${a[o-2]} + 1;\n        if (${a[o-2]} < ${r[o-2]}) {\n          result.a = getValue(${a});\n        }\n\n        ${a[o-1]} = ${a[o-1]} - 1;\n        if (${a[o-2]} < ${r[o-2]} &&\n            ${a[o-1]} < ${r[o-1]}) {\n          result.b = getValue(${a});\n        }\n        setOutput(result);\n      }\n    `}}function Ur(e,t,n){const r=e.indexOf(t);return e.map((e,t)=>t===r?`${e} - ${n}`:e).join()}function Gr(e){const{inputs:t,backend:n}=e,{input:r}=t;return vr({inputs:{x:n.texData.get(r.dataId).complexTensorInfos.imag},backend:n})}const zr={kernelName:t.Imag,backendName:"webgl",kernelFunc:Gr};function Xr(e){const{inputs:n,backend:r,attrs:o}=e,{x:i}=n,{shape:a}=o,s=r,u=t.util.sizeFromShape(i.shape),l=t.util.inferFromImplicitShape(a,u),c=t.util.sizeFromShape(l);t.util.assert(u===c,()=>`The new shape (${l}) has ${c} elements and the old `+`shape (${i.shape}) has ${u} elements. The new shape and old `+"shape must have the same number of elements.");const d=s.texData.get(i.dataId);return!d.isPacked||z(i.shape,l)||null!==d.texture&&z(d.shape,l)?(s.incRef(i.dataId),{dataId:i.dataId,shape:l,dtype:i.dtype}):function(e,t,n){const r=[V(e.shape),...M(e.shape)],o={dtype:e.dtype,shape:r,dataId:e.dataId},i=[V(t),...M(t)],a=new yn(i,r),s=n.runWebGLProgram(a,[o],e.dtype,null,!0);return{dataId:s.dataId,shape:t,dtype:s.dtype}}(i,l,s)}const Hr={kernelName:t.Reshape,backendName:"webgl",kernelFunc:Xr};const jr={kernelName:t.Concat,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:r,attrs:o}=e,{axis:i}=o,a=t.util.parseAxisParam(i,n[0].shape)[0],s=t.backend_util.computeOutShape(n.map(e=>e.shape),a);if(0===t.util.sizeFromShape(s))return r.makeTensorInfo(s,n[0].dtype,[]);const u=n.filter(e=>t.util.sizeFromShape(e.shape)>0);if(1===u.length)return u[0];const l=u.map(e=>e.shape);return t.backend_util.assertParamsConsistent(l,a),function e(n,r,o){const i=n[0].dtype;if("complex64"===i){const t=n.map(e=>Lr({inputs:{input:e},backend:o})),i=n.map(e=>Gr({inputs:{input:e},backend:o})),a=e(t,r,o),s=e(i,r,o),u=Rr({inputs:{real:a,imag:s},backend:o});return t.forEach(e=>o.disposeIntermediateTensorInfo(e)),i.forEach(e=>o.disposeIntermediateTensorInfo(e)),o.disposeIntermediateTensorInfo(a),o.disposeIntermediateTensorInfo(s),u}if(n.length>t.env().getNumber("WEBGL_MAX_TEXTURES_IN_SHADER")){const t=Math.floor(n.length/2),i=e(n.slice(0,t),r,o),a=e(n.slice(t),r,o),s=e([i,a],r,o);return o.disposeIntermediateTensorInfo(i),o.disposeIntermediateTensorInfo(a),s}if(t.env().getBool("WEBGL_PACK_ARRAY_OPERATIONS")&&n[0].shape.length>1){const e=new Wr(n.map(e=>e.shape),r);return o.runWebGLProgram(e,n,i)}const a=t.backend_util.computeOutShape(n.map(e=>e.shape),r),s=n.map(e=>Xr({inputs:{x:e},attrs:{shape:[-1,t.util.sizeFromShape(e.shape.slice(r))]},backend:o})),u=new Mr(s.map(e=>e.shape)),l=o.runWebGLProgram(u,s,i);s.forEach(e=>o.disposeIntermediateTensorInfo(e));const c=Xr({inputs:{x:l},attrs:{shape:a},backend:o});return o.disposeIntermediateTensorInfo(l),c}(u,a,r)}},Kr=wr("if (isnan(x)) return x;\n  return cos(x);\n"),qr={kernelName:t.Cos,backendName:"webgl",kernelFunc:Kr},Yr=yr({opSnippet:"\nif (a == b) {\n  return 1.0;\n};\nreturn a / b;",packedOpSnippet:"\n  // vec4 one = vec4(equal(a, b));\n  // return one + (vec4(1.0) - one) * a / b;\n  vec4 result = a / b;\n  if(a.x == b.x) {\n    result.x = 1.;\n  }\n  if(a.y == b.y) {\n    result.y = 1.;\n  }\n  if(a.z == b.z) {\n    result.z = 1.;\n  }\n  if(a.w == b.w) {\n    result.w = 1.;\n  }\n\n  return result;\n",checkOutOfBounds:!0}),Qr={kernelName:t.Div,backendName:"webgl",kernelFunc:Yr};class Zr{constructor(e,t,n){this.variableNames=["real","imag"];const r=t[1];this.outputShape=t;const o=n?`2.0 * ${Math.PI}`:`-2.0 * ${Math.PI}`,i=n?`${r}.0`:"1.0";let a;if("real"===e)a="return real * expR - imag * expI;";else{if("imag"!==e)throw new Error(`FFT component must be either "real" or "imag", got ${e}.`);a="return real * expI + imag * expR;"}this.userCode=`\n      const float exponentMultiplier = ${o};\n\n      float unaryOpComplex(float real, float expR, float imag, float expI) {\n        ${a}\n      }\n\n      float mulMatDFT(int batch, int index) {\n        float indexRatio = float(index) / float(${r});\n        float exponentMultiplierTimesIndexRatio =\n            exponentMultiplier * indexRatio;\n\n        float result = 0.0;\n\n        for (int i = 0; i < ${r}; i++) {\n          // x = (-2|2 * PI / N) * index * i;\n          float x = exponentMultiplierTimesIndexRatio * float(i);\n          float expR = cos(x);\n          float expI = sin(x);\n          float real = getReal(batch, i);\n          float imag = getImag(batch, i);\n\n          result +=\n              unaryOpComplex(real, expR, imag, expI) / ${i};\n        }\n\n        return result;\n      }\n\n      void main() {\n        ivec2 coords = getOutputCoords();\n        setOutput(mulMatDFT(coords[0], coords[1]));\n      }\n    `}}function Jr(e,n,r){const o=r.texData.get(e.dataId),i=t.util.sizeFromShape(e.shape),a=e.shape[e.shape.length-1],s=Xr({inputs:{x:e},backend:r,attrs:{shape:[i/a,a]}}).shape,u=new Zr("real",s,n),l=new Zr("imag",s,n),c=[{dataId:o.complexTensorInfos.real.dataId,dtype:o.complexTensorInfos.real.dtype,shape:s},{dataId:o.complexTensorInfos.imag.dataId,dtype:o.complexTensorInfos.imag.dtype,shape:s}],d=r.runWebGLProgram(u,c,"float32"),h=r.runWebGLProgram(l,c,"float32"),p=Rr({inputs:{real:d,imag:h},backend:r});r.disposeIntermediateTensorInfo(d),r.disposeIntermediateTensorInfo(h);const f=Xr({inputs:{x:p},backend:r,attrs:{shape:e.shape}});return r.disposeIntermediateTensorInfo(f),f}const eo={kernelName:t.FFT,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n}=e,{input:r}=t;return Jr(r,!1,n)}};class to{constructor(e){this.variableNames=["Image"],this.outputShape=[];const t=e[2];this.outputShape=e,this.userCode=`\n        void main() {\n          ivec4 coords = getOutputCoords();\n          int x = coords[2];\n\n          int coordX = ${t} - x;\n          float outputValue;\n          if(coordX >= 0 && coordX < ${t}) {\n            outputValue = getImage(coords[0], coords[1], coordX, coords[3]);\n          } else {\n            outputValue = getImage(coords[0], coords[1], coords[2], coords[3]);\n          }\n          setOutput(outputValue);\n        }\n    `}}const no={kernelName:t.FlipLeftRight,backendName:"webgl",kernelFunc:({inputs:e,backend:t})=>{const{image:n}=e,r=t,o=new to(n.shape);return r.runWebGLProgram(o,[n],n.dtype)}};class ro{constructor(e){this.variableNames=["A"];const t=Be(),[n,r]=e;this.outputShape=e,this.userCode=`\n      void main() {\n        ivec3 coords = getOutputCoords();\n        int texR = coords[0];\n        int texC = coords[1];\n        int depth = coords[2];\n        vec2 uv = (vec2(texC, texR) + halfCR) / vec2(${r}.0, ${n}.0);\n\n        vec4 values = ${t.texture2D}(A, uv);\n        float value;\n        if (depth == 0) {\n          value = values.r;\n        } else if (depth == 1) {\n          value = values.g;\n        } else if (depth == 2) {\n          value = values.b;\n        } else if (depth == 3) {\n          value = values.a;\n        }\n\n        setOutput(floor(value * 255.0 + 0.5));\n      }\n    `}}class oo{constructor(e){this.variableNames=["A"],this.packedInputs=!1,this.packedOutput=!0;const t=Be(),[n,r]=e;this.outputShape=e,this.userCode=`\n      void main() {\n        ivec3 coords = getOutputCoords();\n        int texR = coords[0];\n        int texC = coords[1];\n        int depth = coords[2];\n\n        vec4 result = vec4(0.);\n\n        for(int row=0; row<=1; row++) {\n          for(int col=0; col<=1; col++) {\n            texC = coords[1] + row;\n            depth = coords[2] + col;\n\n            vec2 uv = (vec2(texC, texR) + halfCR) /\n                       vec2(${r}.0, ${n}.0);\n            vec4 values = ${t.texture2D}(A, uv);\n            float value;\n            if (depth == 0) {\n              value = values.r;\n            } else if (depth == 1) {\n              value = values.g;\n            } else if (depth == 2) {\n              value = values.b;\n            } else if (depth == 3) {\n              value = values.a;\n            }\n\n            result[row * 2 + col] = floor(value * 255.0 + 0.5);\n          }\n        }\n\n        ${t.output} = result;\n      }\n    `}}const io={kernelName:t.FromPixels,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:r,attrs:o}=e;let{pixels:i}=n;const{numChannels:a}=o,u="undefined"!=typeof HTMLVideoElement&&i instanceof HTMLVideoElement,l="undefined"!=typeof HTMLImageElement&&i instanceof HTMLImageElement,[c,d]=u?[i.videoWidth,i.videoHeight]:[i.width,i.height],h=[d,c],p=[d,c,a];(l||u)&&(null==ao&&(ao=document.createElement("canvas").getContext("2d")),ao.canvas.width=c,ao.canvas.height=d,ao.drawImage(i,0,0,c,d),i=ao.canvas);const f=r.makeTensorInfo(h,"int32");r.texData.get(f.dataId).usage=s.PIXELS,r.gpgpu.uploadPixelDataToTexture(r.getTexture(f.dataId),i);const x=t.env().getBool("WEBGL_PACK")?new oo(p):new ro(p),g=r.runWebGLProgram(x,[f],"int32");return r.disposeData(f.dataId),g}};let ao;const so={kernelName:t.IFFT,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n}=e,{input:r}=t;return Jr(r,!0,n)}};class uo{constructor(e,n){this.variableNames=["x"];const{windowSize:r,batchSize:o,inSize:i,outSize:a}=e;this.outputShape=[o,a];const s=4*Math.floor(r/4),u=r%4;let l="sumValue += dot(values, ones);";if(null!=n){const e=1/n;l=`sumValue += dot(values * ${t.util.isInt(e)?e.toPrecision(2):e}, ones);`}let c="";i%r>0&&(c=`\n        if (inIdx < 0 || inIdx >= ${i}) {\n          return 0.0;\n        }\n      `),this.userCode=`\n      const vec4 ones = vec4(1.0, 1.0, 1.0, 1.0);\n\n      float getValue(int batch, int inIdx) {\n        ${c}\n        return getX(batch, inIdx);\n      }\n\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int batch = coords[0];\n        int outIdx = coords[1];\n        int inOffset = outIdx * ${r};\n\n        float sumValue = 0.0;\n\n        for (int i = 0; i < ${s}; i += 4) {\n          int inIdx = inOffset + i;\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2),\n            getValue(batch, inIdx + 3)\n          );\n\n          ${l}\n        }\n\n        int inIdx = inOffset + ${s};\n        if (${1===u}) {\n          vec4 values = vec4(getValue(batch, inIdx), 0.0, 0.0, 0.0);\n\n          ${l}\n        } else if (${2===u}) {\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1), 0.0, 0.0);\n\n          ${l}\n        } else if (${3===u}) {\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2), 0.0);\n\n          ${l}\n        }\n        setOutput(sumValue);\n      }\n    `}}function lo(e,n,r,o){const i=function(e){const n=[];for(;0===n.length||1!==n[n.length-1].outSize;){const r=n.length?n[n.length-1].outSize:e[1],o=t.backend_util.computeOptimalWindowSize(r);n.push({inSize:r,windowSize:o,outSize:Math.ceil(r/o)})}return n}(e.shape);let a=e;for(let t=0;t<i.length;t++){const{inSize:s,windowSize:u,outSize:l}=i[t];let c,d;c="mean"===r?0===t?new uo({windowSize:u,inSize:s,batchSize:e.shape[0],outSize:l},s):new uo({windowSize:u,inSize:s,batchSize:e.shape[0],outSize:l}):new wn({windowSize:u,inSize:s,batchSize:e.shape[0],outSize:l},r),d=a,a=o.runWebGLProgram(c,[a],n),d.dataId!==e.dataId&&o.disposeIntermediateTensorInfo(d)}return a}class co{constructor(e,t){this.variableNames=["A"];const n=new Array(e.length);for(let r=0;r<n.length;r++)n[r]=e[t[r]];this.outputShape=n,this.rank=n.length;const r=Je(this.rank),o=function(e){const t=e.length;if(t>6)throw Error(`Transpose for rank ${t} is not yet supported`);const n=["resRC.x","resRC.y","resRC.z","resRC.w","resRC.u","resRC.v"],r=new Array(t);for(let t=0;t<e.length;t++)r[e[t]]=n[t];return r.join()}(t);this.userCode=`\n    void main() {\n      ${r} resRC = getOutputCoords();\n      setOutput(getA(${o}));\n    }\n    `}}class ho{constructor(e,t){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0;const n=new Array(e.length);for(let r=0;r<n.length;r++)n[r]=e[t[r]];if(this.outputShape=n,this.rank=n.length,this.rank>6)throw Error(`Packed transpose for rank ${this.rank} is not yet supported.`);const r=Je(this.rank),o=Pe("rc",this.rank),i=new Array(this.rank);for(let e=0;e<t.length;e++)i[t[e]]=o[e];const a=`vec2(${i.slice(-2).join()})`,s=`++${o[this.rank-1]} < ${n[this.rank-1]}`,u=`getChannel(getA(${i.join()}), ${a})`;this.userCode=`\n    void main() {\n      ${r} rc = getOutputCoords();\n      vec4 result = vec4(0.);\n      result[0] = ${u};\n      if(${s}) {\n        result[1] = ${u};\n      }\n      --${o[this.rank-1]};\n      if(++${o[this.rank-2]} < ${n[this.rank-2]}) {\n        result[2] = ${u};\n        if(${s}) {\n          result[3] = ${u};\n        }\n      }\n      setOutput(result);\n    }\n    `}}function po(e,n,r){const o=t.env().getBool("WEBGL_PACK_ARRAY_OPERATIONS")?new ho(e.shape,n):new co(e.shape,n);return r.runWebGLProgram(o,[e],e.dtype)}const fo={kernelName:t.Max,backendName:"webgl",kernelFunc:({inputs:e,attrs:n,backend:r})=>{const{x:o}=e,{reductionIndices:i,keepDims:a}=n,s=r,u=o.shape.length,l=t.util.parseAxisParam(i,o.shape);let c=l;const d=t.backend_util.getAxesPermutation(c,u),h=null!=d,p=s.shouldExecuteOnCPU([o]);let f=o;if(h){if(p){const e=s.texData.get(f.dataId).values,t=new Array(u);for(let e=0;e<t.length;e++)t[e]=o.shape[d[e]];const n=Se(e,o.shape,o.dtype,d,t);f=s.makeTensorInfo(t,o.dtype),s.texData.get(f.dataId).values=n}else f=po(o,d,s);c=t.backend_util.getInnerMostAxes(c.length,u)}t.backend_util.assertAxesAreInnerMostDims("max",c,u);const[x,g]=t.backend_util.computeOutAndReduceShapes(f.shape,c);let m,C=x;if(a&&(C=t.backend_util.expandShapeToKeepDim(x,l)),p){const e=s.texData.get(f.dataId).values,n=Ee(e,t.util.sizeFromShape(g),C,o.dtype);m=s.makeTensorInfo(C,o.dtype),s.texData.get(m.dataId).values=n}else m=function(e,n,r,o){const i=t.util.sizeFromShape(n),a=Xr({inputs:{x:e},attrs:{shape:[t.util.sizeFromShape(e.shape)/i,i]},backend:o}),s=lo(a,e.dtype,"max",o),u=Xr({inputs:{x:s},attrs:{shape:r},backend:o});return o.disposeIntermediateTensorInfo(a),o.disposeIntermediateTensorInfo(s),u}(f,g,C,s);return h&&s.disposeIntermediateTensorInfo(f),m}};const xo={kernelName:t.MaxPool,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:r,attrs:o}=e,{x:i}=n;ne(i,"maxPool");const{filterSize:a,strides:s,pad:u,dimRoundingMode:l}=o;t.util.assert(t.backend_util.eitherStridesOrDilationsAreOne(s,1),()=>"Error in maxPool: Either strides or dilations must be 1. "+`Got strides ${s} and dilations '1'`);const c=t.backend_util.computePool2DInfo(i.shape,a,s,1,u,l);if(1===c.filterWidth&&1===c.filterHeight&&t.util.arraysEqual(c.inShape,c.outShape))return vr({inputs:{x:i},backend:r});const d=new Rn(c,"max",!1);return r.runWebGLProgram(d,[i],i.dtype)}};const go={kernelName:t.MaxPoolBackprop,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:r,attrs:o}=e,{dy:i,input:a,output:s}=n,u=a;ne([a,s],"maxPoolBackprop");const{filterSize:l,strides:c,pad:d,dimRoundingMode:h}=o,p=t.backend_util.computePool2DInfo(u.shape,l,c,1,d,h),f=new Rn(p,"max",!0),x=r.runWebGLProgram(f,[u],u.dtype),g=new pn(p),m=r.runWebGLProgram(g,[i,x],u.dtype);return r.disposeIntermediateTensorInfo(x),m}};const mo={kernelName:t.MaxPoolWithArgmax,backendName:"webgl",kernelFunc:({inputs:e,attrs:n,backend:r})=>{const{x:o}=e,{filterSize:i,strides:a,pad:s,includeBatchInIndex:u}=n,l=r;t.util.assert(4===o.shape.length,()=>`Error in maxPool: input must be rank 4 but got rank ${o.shape.length}.`);const c=[1,1];t.util.assert(t.backend_util.eitherStridesOrDilationsAreOne(a,c),()=>"Error in maxPool: Either strides or dilations must be 1. "+`Got strides ${a} and dilations '${c}'`);const d=t.backend_util.computePool2DInfo(o.shape,i,a,c,s),[h,p]=function(e,t,n,r){let o=new Rn(n,"max",!1);const i=r.runWebGLProgram(o,[e],"float32");return o=new Rn(n,"max",!0,!0,t),[i,r.runWebGLProgram(o,[e],"float32")]}(o,u,d,l);return[h,p]}};const Co={kernelName:t.Mean,backendName:"webgl",kernelFunc:({inputs:e,attrs:n,backend:r})=>{const{x:o}=e,{keepDims:i,axis:a}=n,s=r,u=o.shape.length,l=t.util.parseAxisParam(a,o.shape);let c=l;const d=t.backend_util.getAxesPermutation(c,u),h=null!=d,p=s.shouldExecuteOnCPU([o]),f=[];let x=o;if(h){if(p){const e=s.texData.get(x.dataId).values,t=new Array(u);for(let e=0;e<t.length;e++)t[e]=o.shape[d[e]];const n=Se(e,o.shape,o.dtype,d,t);x=s.makeTensorInfo(t,o.dtype),s.texData.get(x.dataId).values=n}else x=po(o,d,s);f.push(x),c=t.backend_util.getInnerMostAxes(c.length,u)}t.backend_util.assertAxesAreInnerMostDims("sum",c,u);const[g,m]=t.backend_util.computeOutAndReduceShapes(x.shape,c);let C=g;i&&(C=t.backend_util.expandShapeToKeepDim(g,l));const v=function(e,n,r,o){const i=t.util.sizeFromShape(n),a=Xr({inputs:{x:e},attrs:{shape:[t.util.sizeFromShape(e.shape)/i,i]},backend:o}),s=lo(a,"float32","mean",o),u=Xr({inputs:{x:s},attrs:{shape:r},backend:o});return o.disposeIntermediateTensorInfo(a),o.disposeIntermediateTensorInfo(s),u}(x,m,C,s);for(const e of f)s.disposeIntermediateTensorInfo(e);return v}};class vo{constructor(e,t,n){this.variableNames=["x"],this.outputShape=t.map((t,n)=>t[0]+e[n]+t[1]);const r=e.length,o=Je(r),i=t.map(e=>e[0]).join(","),a=t.map((t,n)=>t[0]+e[n]).join(","),s=["coords[0]","coords[1]","coords[2]","coords[3]"].slice(0,r),u="reflect"===n?0:1;this.userCode=1!==r?`\n      ${o} start = ${o}(${i});\n      ${o} end = ${o}(${a});\n\n      void main() {\n        ${o} outC = getOutputCoords();\n        for (int i = 0; i < ${r}; i++) {\n          if (outC[i] < start[i]) {\n            outC[i] = start[i] * 2 - outC[i] - ${u};\n          } else if(outC[i] >= end[i]) {\n            outC[i] = (end[i] - 1) * 2 - outC[i] + ${u};\n          }\n        }\n        ${o} coords = outC - start;\n        setOutput(getX(${s}));\n      }\n    `:`\n        int start = ${i};\n        int end = ${a};\n\n        void main() {\n          int outC = getOutputCoords();\n          if (outC < start) {\n            outC = start * 2 - outC - ${u};\n          } else if(outC >= end) {\n            outC = (end - 1) * 2 - outC + ${u};\n          }\n          setOutput(getX(outC - start));\n        }\n      `}}class $o{constructor(e,t,n){this.variableNames=["x"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=t.map((t,n)=>t[0]+e[n]+t[1]);const r=e.length,o=Je(r),i=t.map(e=>e[0]).join(","),a=t.map((t,n)=>t[0]+e[n]).join(","),s=Le("rc",r),u=Le("source",r),l=`${s[r-1]} < ${this.outputShape[r-1]}`,c=1===r?"source":`vec2(${u.slice(-2).join()})`,d="reflect"===n?0:1;let h="";if(1===r){const e=`\n        ${o} source = rc;\n        if (source < start) {\n          source = start * 2 - source - ${d};\n        } else if (source >= end) {\n          source = (end - 1) * 2 - source + ${d};\n        }\n        source -= start;\n      `;h=`\n        ${o} rc = outputLoc;\n        ${e}\n        result[0] = getChannel(getX(${u.join()}), ${c});\n        ${s[r-1]} += 1;\n        if(${l}) {\n          ${e}\n          result[1] = getChannel(getX(${u.join()}), ${c});\n        }\n      `}else{const e=`\n        ${o} source = rc;\n        ${o} lt = ${o}(lessThan(source, start));\n        ${o} gte = ${o}(greaterThanEqual(source, end));\n        ${o} orig = 1 - (lt + gte);\n        source = orig * source +\n                lt * (start * 2 - source - ${d}) +\n                gte * ((end - 1) * 2 - source + ${d});\n        source -= start;\n      `;h=`\n        ${o} rc = outputLoc;\n        ${e}\n        result[0] = getChannel(getX(${u.join()}), ${c});\n        ${s[r-1]} += 1;\n        if(${l}) {\n          ${e}\n          result[1] = getChannel(getX(${u.join()}), ${c});\n        }\n        rc = outputLoc;\n        ${s[r-2]} += 1;\n        if(${s[r-2]} < ${this.outputShape[r-2]}) {\n          ${e}\n          result[2] = getChannel(getX(${u.join()}), ${c});\n          ${s[r-1]} += 1;\n          if(${l}) {\n            ${e}\n            result[3] = getChannel(getX(${u.join()}), ${c});\n          }\n        }\n      `}this.userCode=`\n      const ${o} start = ${o}(${i});\n      const ${o} end = ${o}(${a});\n\n      void main() {\n        ${o} outputLoc = getOutputCoords();\n        vec4 result = vec4(0.);\n        ${h}\n        setOutput(result);\n      }\n    `}}const Ro={kernelName:t.MirrorPad,backendName:"webgl",kernelFunc:({inputs:e,backend:n,attrs:r})=>{const{x:o}=e,{paddings:i,mode:a}=r,s=t.env().getBool("WEBGL_PACK_ARRAY_OPERATIONS")?new $o(o.shape,i,a):new vo(o.shape,i,a);return n.runWebGLProgram(s,[o],o.dtype)}},bo="return areal * breal - aimag * bimag;",wo="return areal * bimag + aimag * breal;";class yo{constructor(e,n,r){this.variableNames=["AReal","AImag","BReal","BImag"],this.outputShape=t.backend_util.assertAndGetBroadcastShape(n,r),this.userCode=`\n      float binaryOpComplex(\n          float areal, float aimag, float breal, float bimag) {\n        ${e}\n      }\n\n      void main() {\n        float areal = getARealAtOutCoords();\n        float aimag = getAImagAtOutCoords();\n        float breal = getBRealAtOutCoords();\n        float bimag = getBImagAtOutCoords();\n        setOutput(binaryOpComplex(areal, aimag, breal, bimag));\n      }\n    `}}const Io="return a * b;";const Eo={kernelName:t.Multiply,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:r}=e,{a:o,b:i}=n,a=t.backend_util.upcastType(o.dtype,i.dtype);if("complex64"===o.dtype){const e=r.texData.get(o.dataId),t=r.texData.get(i.dataId),n=new yo(bo,o.shape,i.shape),a=new yo(wo,o.shape,i.shape),s=[{dataId:e.complexTensorInfos.real.dataId,dtype:e.complexTensorInfos.real.dtype,shape:o.shape},{dataId:e.complexTensorInfos.imag.dataId,dtype:e.complexTensorInfos.imag.dtype,shape:o.shape},{dataId:t.complexTensorInfos.real.dataId,dtype:t.complexTensorInfos.real.dtype,shape:i.shape},{dataId:t.complexTensorInfos.imag.dataId,dtype:t.complexTensorInfos.imag.dtype,shape:i.shape}],u=r.runWebGLProgram(n,s,"float32"),l=r.runWebGLProgram(a,s,"float32"),c=Rr({inputs:{real:u,imag:l},backend:r});return r.disposeIntermediateTensorInfo(u),r.disposeIntermediateTensorInfo(l),c}if(r.shouldExecuteOnCPU([o,i])){const e=r.texData.get(o.dataId),t=r.texData.get(i.dataId),[n,s]=Ae(o.shape,i.shape,e.values,t.values,a),u=r.makeTensorInfo(s,a);return r.texData.get(u.dataId).values=n,u}let s;return s=t.env().getBool("WEBGL_PACK_BINARY_OPERATIONS")?new ut(Io,o.shape,i.shape):new at(Io,o.shape,i.shape),r.runWebGLProgram(s,[o,i],a)}},Ao={kernelName:t.NonMaxSuppressionV3,backendName:"webgl",kernelFunc:({inputs:e,backend:n,attrs:r})=>{t.backend_util.warn("tf.nonMaxSuppression() in webgl locks the UI thread. Call tf.nonMaxSuppressionAsync() instead");const{boxes:o,scores:i}=e,{maxOutputSize:a,iouThreshold:s,scoreThreshold:u}=r,l=n,c=l.readSync(o.dataId),d=l.readSync(i.dataId),h=a,p=s,f=u;return t.kernel_impls.nonMaxSuppressionV3Impl(c,d,h,p,f)}},To=t.kernel_impls.nonMaxSuppressionV4Impl,Oo={kernelName:t.NonMaxSuppressionV4,backendName:"webgl",kernelFunc:({inputs:e,backend:n,attrs:r})=>{t.backend_util.warn("tf.nonMaxSuppression() in webgl locks the UI thread. Call tf.nonMaxSuppressionAsync() instead");const{boxes:o,scores:i}=e,{maxOutputSize:a,iouThreshold:s,scoreThreshold:u,padToMaxOutputSize:l}=r,c=n,d=c.readSync(o.dataId),h=c.readSync(i.dataId),{selectedIndices:p,validOutputs:f}=To(d,h,a,s,u,l);return[p,f]}},_o=t.kernel_impls.nonMaxSuppressionV5Impl,So={kernelName:t.NonMaxSuppressionV5,backendName:"webgl",kernelFunc:({inputs:e,backend:n,attrs:r})=>{t.backend_util.warn("tf.nonMaxSuppression() in webgl locks the UI thread. Call tf.nonMaxSuppressionAsync() instead");const{boxes:o,scores:i}=e,{maxOutputSize:a,iouThreshold:s,scoreThreshold:u,softNmsSigma:l}=r,c=n,d=c.readSync(o.dataId),h=c.readSync(i.dataId),p=a,f=s,x=u,g=l,{selectedIndices:m,selectedScores:C}=_o(d,h,p,f,x,g);return[m,C]}};class No{constructor(e,n,r,o){this.variableNames=["Image"],this.outputShape=[];const i=e[1],a=e[2],s=Math.sin(n).toFixed(3),u=Math.cos(n).toFixed(3);this.outputShape=e;const[l,c]=t.backend_util.getImageCenter(o,i,a),d=l.toFixed(3),h=c.toFixed(3);let p="";p="number"==typeof r?`float outputValue = ${r.toFixed(2)};`:`\n        vec3 fill = vec3(${r.join(",")});\n        float outputValue = fill[coords[3]];`,this.userCode=`\n        void main() {\n          ivec4 coords = getOutputCoords();\n          int x = coords[2];\n          int y = coords[1];\n          float coordXFloat = (float(x) - ${d}) * ${u} - (float(y) - ${h}) * ${s};\n          float coordYFloat = (float(x) - ${d}) * ${s} + (float(y) - ${h}) * ${u};\n          int coordX = int(round(coordXFloat + ${d}));\n          int coordY = int(round(coordYFloat + ${h}));\n          ${p}\n          if(coordX >= 0 && coordX < ${a} && coordY >= 0 && coordY < ${i}) {\n            outputValue = getImage(coords[0], coordY, coordX, coords[3]);\n          }\n          setOutput(outputValue);\n        }\n    `}}const Fo={kernelName:t.RotateWithOffset,backendName:"webgl",kernelFunc:({inputs:e,attrs:t,backend:n})=>{const{image:r}=e,{radians:o,fillValue:i,center:a}=t,s=n,u=new No(r.shape,o,i,a);return s.runWebGLProgram(u,[r],r.dtype)}},ko=wr("if (isnan(x)) return x;\n  return sin(x);\n"),Do={kernelName:t.Sin,backendName:"webgl",kernelFunc:ko},Po=wr("return x * x;"),Lo={kernelName:t.Square,backendName:"webgl",kernelFunc:Po},Bo=yr({opSnippet:"return (a - b) * (a - b);",packedOpSnippet:"return (a - b) * (a - b);"}),Vo={kernelName:t.SquaredDifference,backendName:"webgl",kernelFunc:Bo},Mo="return a - b;",Wo=yr({opSnippet:Mo,packedOpSnippet:Mo,supportsComplex:!0,cpuKernelImpl:_e}),Uo={kernelName:t.Sub,backendName:"webgl",kernelFunc:Wo},Go=wr("return tan(x);");const zo=[Ar,Or,_r,Sr,kr,Vr,br,jr,qr,Qr,eo,no,io,$r,so,zr,fo,xo,go,mo,Co,Ro,Eo,Ao,Oo,So,Pr,Br,Hr,Fo,Do,Lo,Uo,Vo,{kernelName:t.Tan,backendName:"webgl",kernelFunc:Go},{kernelName:t.Transpose,backendName:"webgl",kernelFunc:({inputs:e,attrs:t,backend:n})=>{const{x:r}=e,{perm:o}=t,i=n,a=r.shape.length,s=new Array(a);for(let e=0;e<s.length;e++)s[e]=r.shape[o[e]];let u;if(i.shouldExecuteOnCPU([r])){const e=i.texData.get(r.dataId).values,t=Se(e,r.shape,r.dtype,o,s);u=i.makeTensorInfo(s,r.dtype),i.texData.get(u.dataId).values=t}else u=po(r,o,i);return u}},{kernelName:t.Unique,backendName:"webgl",kernelFunc:function(e){const{inputs:t,attrs:n,backend:r}=e,{axis:o}=n,{x:i}=t;ne(i,"unique"),console.warn("WARNING: ","UI might be locked temporarily as data is being downloaded");const a=r.readSync(i.dataId),{outputValues:s,outputShape:u,indices:l}=Ne(a,o,i.shape,i.dtype);return[r.makeTensorInfo(u,i.dtype,s),r.makeTensorInfo([l.length],"int32",l)]}}];for(const e of zo)t.registerKernel(e);e.GPGPUContext=sn,e.MathBackendWebGL=gr,e.forceHalfFloat=mr,e.gpgpu_util=an,e.setWebGLContext=o,e.version_webgl="2.7.0",e.webgl=Cr,e.webgl_util=re,Object.defineProperty(e,"__esModule",{value:!0})}));
//# sourceMappingURL=tf-backend-webgl.es2017.min.js.map
