/**
 * @license
 * Copyright 2020 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
import { ReshapePackedProgram } from '../reshape_packed_gpu';
import { getBatchDim, getRowsCols } from '../webgl_util';
export function packedReshape(input, afterShape, backend) {
    const input3DShape = [getBatchDim(input.shape),
        ...getRowsCols(input.shape)];
    const input3D = {
        dtype: input.dtype,
        shape: input3DShape,
        dataId: input.dataId
    };
    const afterShapeAs3D = [getBatchDim(afterShape),
        ...getRowsCols(afterShape)];
    const program = new ReshapePackedProgram(afterShapeAs3D, input3DShape);
    const preventEagerUnpackingOfOutput = true;
    const customValues = [input3DShape];
    const output = backend.runWebGLProgram(program, [input3D], input.dtype, customValues, preventEagerUnpackingOfOutput);
    return { dataId: output.dataId, shape: afterShape, dtype: output.dtype };
}
//# sourceMappingURL=data:application/json;base64,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