/**
 * @license
 * Copyright 2021 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
import { StringNGrams } from '@tensorflow/tfjs-core';
import { stringNGramsImplCPU } from '../kernel_utils/shared';
export function stringNGrams(args) {
    const { inputs, backend, attrs } = args;
    const { separator, nGramWidths, leftPad, rightPad, padWidth, preserveShortSequences } = attrs;
    const { data, dataSplits } = inputs;
    const $data = backend.readSync(data.dataId);
    const $dataSplits = backend.readSync(dataSplits.dataId);
    const [nGrams, nGramsSplits] = stringNGramsImplCPU($data, $dataSplits, separator, nGramWidths, leftPad, rightPad, padWidth, preserveShortSequences);
    return [
        backend.makeTensorInfo([nGrams.length], 'string', nGrams),
        backend.makeTensorInfo(dataSplits.shape, 'int32', nGramsSplits),
    ];
}
export const stringNGramsConfig = {
    kernelName: StringNGrams,
    backendName: 'webgl',
    kernelFunc: stringNGrams,
};
//# sourceMappingURL=data:application/json;base64,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