/**
 * @license
 * Copyright 2017 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
import { backend_util } from '@tensorflow/tfjs-core';
import { GPGPUProgram } from './gpgpu_math';
export declare class Pool2DProgram implements GPGPUProgram {
    variableNames: string[];
    outputShape: number[];
    userCode: string;
    constructor(convInfo: backend_util.Conv2DInfo, poolType: 'max' | 'avg', computePositions: boolean, flattenPositions?: boolean, includeBatchInIndex?: boolean);
}
export declare class Pool3DProgram implements GPGPUProgram {
    variableNames: string[];
    outputShape: number[];
    userCode: string;
    constructor(convInfo: backend_util.Conv3DInfo, poolType: 'max' | 'avg', computePositions: boolean, flattenPositions?: boolean, includeBatchInIndex?: boolean);
}
