/**
 * @license
 * Copyright 2021 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
import{util as e,env as n,device_util as t,backend_util as r,buffer as a,upcastType as o,slice_util as s,TensorBuffer as i,kernel_impls as u,KernelBackend as l,DataStorage as c,engine as d,tidy as p,scalar as h,registerBackend as f,Identity as x,Complex as g,LeakyRelu as m,Prelu as b,Multiply as C,Reshape as v,sumOutType as $,Sum as I,Transpose as R,_FusedMatMul as y,Abs as w,Acos as k,Acosh as T,Add as E,AddN as N,All as S,Any as A,ArgMax as F,ArgMin as O,Asin as _,Asinh as D,Atan as L,Atan2 as P,Atanh as B,AvgPool as W,AvgPool3D as V,AvgPool3DGrad as M,AvgPoolGrad as G,BatchMatMul as U,FusedBatchNorm as z,Slice as X,BatchToSpaceND as H,Bincount as j,NotEqual as K,Real as q,Cast as Y,zeros as Q,Ceil as Z,ClipByValue as J,ComplexAbs as ee,Imag as ne,Concat as te,Conv2D as re,Conv2DBackpropFilter as ae,Conv2DBackpropInput as oe,Conv3D as se,Conv3DBackpropFilterV2 as ie,Conv3DBackpropInputV2 as ue,Cos as le,Cosh as ce,CropAndResize as de,Cumsum as pe,DenseBincount as he,DepthToSpace as fe,DepthwiseConv2dNative as xe,DepthwiseConv2dNativeBackpropFilter as ge,DepthwiseConv2dNativeBackpropInput as me,Diag as be,Dilation2D as Ce,Elu as ve,EluGrad as $e,Equal as Ie,Erf as Re,Exp as ye,ExpandDims as we,Expm1 as ke,FFT as Te,Fill as Ee,FlipLeftRight as Ne,Floor as Se,FloorDiv as Ae,FromPixels as Fe,FusedConv2D as Oe,FusedDepthwiseConv2D as _e,GatherNd as De,GatherV2 as Le,Greater as Pe,GreaterEqual as Be,IFFT as We,IsFinite as Ve,IsInf as Me,IsNan as Ge,Less as Ue,LessEqual as ze,LinSpace as Xe,Log as He,Log1p as je,LogicalAnd as Ke,LogicalNot as qe,LogicalOr as Ye,LRN as Qe,LRNGrad as Ze,Max as Je,Maximum as en,MaxPool as nn,MaxPool3D as tn,MaxPool3DGrad as rn,MaxPoolGrad as an,MaxPoolWithArgmax as on,Mean as sn,Min as un,Minimum as ln,MirrorPad as cn,Mod as dn,RealDiv as pn,Sub as hn,Softmax as fn,Multinomial as xn,Neg as gn,NonMaxSuppressionV3 as mn,NonMaxSuppressionV4 as bn,NonMaxSuppressionV5 as Cn,OneHot as vn,ZerosLike as $n,OnesLike as In,Pack as Rn,PadV2 as yn,Pow as wn,Prod as kn,Range as Tn,Reciprocal as En,Relu as Nn,Relu6 as Sn,ResizeBilinear as An,ResizeBilinearGrad as Fn,ResizeNearestNeighbor as On,ResizeNearestNeighborGrad as _n,Reverse as Dn,RotateWithOffset as Ln,Round as Pn,Rsqrt as Bn,ScatterNd as Wn,Select as Vn,Selu as Mn,Sigmoid as Gn,Sign as Un,Sin as zn,Sinh as Xn,Softplus as Hn,SpaceToBatchND as jn,SparseToDense as Kn,SplitV as qn,Sqrt as Yn,Square as Qn,SquaredDifference as Zn,Step as Jn,StridedSlice as et,Tan as nt,Tanh as tt,Tile as rt,TopK as at,Unique as ot,Unpack as st,UnsortedSegmentSum as it,registerKernel as ut}from"@tensorflow/tfjs-core";const lt={},ct={alpha:!1,antialias:!1,premultipliedAlpha:!1,preserveDrawingBuffer:!1,depth:!1,stencil:!1,failIfMajorPerformanceCaveat:!0};function dt(e,n){lt[e]=n}function pt(e){if(!(e in lt)){const n=function(e){if(1!==e&&2!==e)throw new Error("Cannot get WebGL rendering context, WebGL is disabled.");const n=function(e){if("undefined"!=typeof OffscreenCanvas&&2===e)return new OffscreenCanvas(300,150);if("undefined"!=typeof document)return document.createElement("canvas");throw new Error("Cannot create a canvas in this context")}(e);if(n.addEventListener("webglcontextlost",n=>{n.preventDefault(),delete lt[e]},!1),1===e)return n.getContext("webgl",ct)||n.getContext("experimental-webgl",ct);return n.getContext("webgl2",ct)}(e);if(null===n)return console.log("Could not get context for WebGL version",e),null;lt[e]=n}const n=lt[e];return n.isContextLost()?(delete lt[e],pt(e)):(n.disable(n.DEPTH_TEST),n.disable(n.STENCIL_TEST),n.disable(n.BLEND),n.disable(n.DITHER),n.disable(n.POLYGON_OFFSET_FILL),n.disable(n.SAMPLE_COVERAGE),n.enable(n.SCISSOR_TEST),n.enable(n.CULL_FACE),n.cullFace(n.BACK),lt[e])}var ht,ft,xt;function gt(e,n){return[n,e]}function mt(n){const t=e.sizeFromShape(n),r=Math.ceil(t/4);return e.sizeToSquarishShape(r)}function bt(e,n){return[Math.max(1,Math.ceil(n/2)),Math.max(1,Math.ceil(e/2))]}function Ct(e,t){const r=e;let a,o,s,i,u,l,c,d,p,h;return 2===n().getNumber("WEBGL_VERSION")?(a=r.R32F,o=r.R16F,s=r.RGBA16F,i=r.RGBA32F,u=r.RED,c=4,d=1,p=r.HALF_FLOAT,h=r.FLOAT):(a=e.RGBA,o=e.RGBA,s=e.RGBA,i=r.RGBA,u=e.RGBA,c=4,d=4,p=null!=t?t.HALF_FLOAT_OES:null,h=e.FLOAT),l=e.RGBA,{internalFormatFloat:a,internalFormatHalfFloat:o,internalFormatPackedHalfFloat:s,internalFormatPackedFloat:i,textureFormatFloat:u,downloadTextureFormat:l,downloadUnpackNumChannels:c,defaultNumChannels:d,textureTypeHalfFloat:p,textureTypeFloat:h}}function vt(e,t){const r=t();return n().getBool("DEBUG")&&function(e){const n=e.getError();if(n!==e.NO_ERROR)throw new Error("WebGL Error: "+It(e,n))}(e),r}!function(e){e[e.DENSE=0]="DENSE",e[e.SHARED_BATCH=1]="SHARED_BATCH"}(ht||(ht={})),function(e){e[e.RENDER=0]="RENDER",e[e.UPLOAD=1]="UPLOAD",e[e.PIXELS=2]="PIXELS",e[e.DOWNLOAD=3]="DOWNLOAD"}(ft||(ft={})),function(e){e[e.UNPACKED_FLOAT16=0]="UNPACKED_FLOAT16",e[e.UNPACKED_FLOAT32=1]="UNPACKED_FLOAT32",e[e.PACKED_4X1_UNSIGNED_BYTE=2]="PACKED_4X1_UNSIGNED_BYTE",e[e.PACKED_2X2_FLOAT32=3]="PACKED_2X2_FLOAT32",e[e.PACKED_2X2_FLOAT16=4]="PACKED_2X2_FLOAT16"}(xt||(xt={}));function $t(e){return!!(n().getBool("WEBGL_RENDER_FLOAT32_ENABLED")||0===e||5.96e-8<Math.abs(e)&&Math.abs(e)<65504)}function It(e,n){switch(n){case e.NO_ERROR:return"NO_ERROR";case e.INVALID_ENUM:return"INVALID_ENUM";case e.INVALID_VALUE:return"INVALID_VALUE";case e.INVALID_OPERATION:return"INVALID_OPERATION";case e.INVALID_FRAMEBUFFER_OPERATION:return"INVALID_FRAMEBUFFER_OPERATION";case e.OUT_OF_MEMORY:return"OUT_OF_MEMORY";case e.CONTEXT_LOST_WEBGL:return"CONTEXT_LOST_WEBGL";default:return`Unknown error code ${n}`}}function Rt(e,n){return zt(e,()=>e.getExtension(n),'Extension "'+n+'" not supported on this browser.')}function yt(e,n){const t=zt(e,()=>e.createShader(e.VERTEX_SHADER),"Unable to create vertex WebGLShader.");if(vt(e,()=>e.shaderSource(t,n)),vt(e,()=>e.compileShader(t)),!1===e.getShaderParameter(t,e.COMPILE_STATUS))throw console.log(e.getShaderInfoLog(t)),new Error("Failed to compile vertex shader.");return t}function wt(n,t){const r=zt(n,()=>n.createShader(n.FRAGMENT_SHADER),"Unable to create fragment WebGLShader.");if(vt(n,()=>n.shaderSource(r,t)),vt(n,()=>n.compileShader(r)),!1===n.getShaderParameter(r,n.COMPILE_STATUS))throw function(n,t){const r=kt.exec(t);if(null==r)return console.log(`Couldn't parse line number in error: ${t}`),void console.log(n);const a=+r[1],o=n.split("\n"),s=o.length.toString().length+2,i=o.map((n,t)=>e.rightPad((t+1).toString(),s)+n);let u=0;for(let e=0;e<i.length;e++)u=Math.max(i[e].length,u);const l=i.slice(0,a-1),c=i.slice(a-1,a),d=i.slice(a);console.log(l.join("\n")),console.log(t.split("\n")[0]),console.log(`%c ${e.rightPad(c[0],u)}`,"border:1px solid red; background-color:#e3d2d2; color:#a61717"),console.log(d.join("\n"))}(t,n.getShaderInfoLog(r)),new Error("Failed to compile fragment shader.");return r}const kt=/ERROR: [0-9]+:([0-9]+):/g;function Tt(e){return zt(e,()=>e.createProgram(),"Unable to create WebGLProgram.")}function Et(e,n){if(vt(e,()=>e.linkProgram(n)),!1===e.getProgramParameter(n,e.LINK_STATUS))throw console.log(e.getProgramInfoLog(n)),new Error("Failed to link vertex and fragment shaders.")}function Nt(e,n){if(vt(e,()=>e.validateProgram(n)),!1===e.getProgramParameter(n,e.VALIDATE_STATUS))throw console.log(e.getProgramInfoLog(n)),new Error("Shader program validation failed.")}function St(e,n){const t=zt(e,()=>e.createBuffer(),"Unable to create WebGLBuffer");return vt(e,()=>e.bindBuffer(e.ARRAY_BUFFER,t)),vt(e,()=>e.bufferData(e.ARRAY_BUFFER,n,e.STATIC_DRAW)),t}function At(e,n){const t=zt(e,()=>e.createBuffer(),"Unable to create WebGLBuffer");return vt(e,()=>e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,t)),vt(e,()=>e.bufferData(e.ELEMENT_ARRAY_BUFFER,n,e.STATIC_DRAW)),t}function Ft(e){return zt(e,()=>e.createTexture(),"Unable to create WebGLTexture.")}function Ot(e,t){const r=n().getNumber("WEBGL_MAX_TEXTURE_SIZE");if(e<=0||t<=0){throw new Error("Requested texture size "+`[${e}x${t}]`+" is invalid.")}if(e>r||t>r){throw new Error("Requested texture size "+`[${e}x${t}]`+" greater than WebGL maximum on this browser / GPU "+`[${r}x${r}]`+".")}}function _t(e){return zt(e,()=>e.createFramebuffer(),"Unable to create WebGLFramebuffer.")}function Dt(e,n,t,r,a,o,s){const i=e.getAttribLocation(n,t);return-1!==i&&(vt(e,()=>e.bindBuffer(e.ARRAY_BUFFER,r)),vt(e,()=>e.vertexAttribPointer(i,a,e.FLOAT,!1,o,s)),vt(e,()=>e.enableVertexAttribArray(i)),!0)}function Lt(e,n,t){Xt(e,t),vt(e,()=>e.activeTexture(e.TEXTURE0+t)),vt(e,()=>e.bindTexture(e.TEXTURE_2D,n))}function Pt(e,n,t){return zt(e,()=>e.getUniformLocation(n,t),'uniform "'+t+'" not present in program.')}function Bt(e,n,t){return e.getUniformLocation(n,t)}function Wt(e,n,t,r){vt(e,()=>Lt(e,n,r)),vt(e,()=>e.uniform1i(t,r))}function Vt(e,n,t){vt(e,()=>e.bindFramebuffer(e.FRAMEBUFFER,t)),vt(e,()=>e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,n,0))}function Mt(e,n){vt(e,()=>e.bindFramebuffer(e.FRAMEBUFFER,n)),vt(e,()=>e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,null,0))}function Gt(e){const n=e.checkFramebufferStatus(e.FRAMEBUFFER);if(n!==e.FRAMEBUFFER_COMPLETE)throw new Error("Error binding framebuffer: "+Ut(e,n))}function Ut(e,n){switch(n){case e.FRAMEBUFFER_INCOMPLETE_ATTACHMENT:return"FRAMEBUFFER_INCOMPLETE_ATTACHMENT";case e.FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:return"FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT";case e.FRAMEBUFFER_INCOMPLETE_DIMENSIONS:return"FRAMEBUFFER_INCOMPLETE_DIMENSIONS";case e.FRAMEBUFFER_UNSUPPORTED:return"FRAMEBUFFER_UNSUPPORTED";default:return`unknown error ${n}`}}function zt(e,n,t){const r=vt(e,()=>n());if(null==r)throw new Error(t);return r}function Xt(e,n){const t=e.MAX_COMBINED_TEXTURE_IMAGE_UNITS-1,r=n+e.TEXTURE0;if(r<e.TEXTURE0||r>t){throw new Error(`textureUnit must be in ${`[gl.TEXTURE0, gl.TEXTURE${t}]`}.`)}}function Ht(n,t=2){return e.sizeFromShape(n.slice(0,n.length-t))}function jt(e){if(0===e.length)throw Error("Cannot get rows and columns of an empty shape array.");return[e.length>1?e[e.length-2]:1,e[e.length-1]]}function Kt(e){let n=[1,1,1];return 0===e.length||1===e.length&&1===e[0]||(n=[Ht(e),...jt(e)]),n}function qt(t,r=!1){let a=n().getNumber("WEBGL_MAX_TEXTURE_SIZE");if(r&&(a*=2,1===(t=t.map((n,r)=>r>=t.length-2?e.nearestLargerEven(t[r]):t[r])).length&&(t=[2,t[0]])),2!==t.length){const n=e.squeezeShape(t);t=n.newShape}let o=e.sizeFromShape(t);if(t.length<=1&&o<=a)return[1,o];if(2===t.length&&t[0]<=a&&t[1]<=a)return t;if(3===t.length&&t[0]*t[1]<=a&&t[2]<=a)return[t[0]*t[1],t[2]];if(3===t.length&&t[0]<=a&&t[1]*t[2]<=a)return[t[0],t[1]*t[2]];if(4===t.length&&t[0]*t[1]*t[2]<=a&&t[3]<=a)return[t[0]*t[1]*t[2],t[3]];if(4===t.length&&t[0]<=a&&t[1]*t[2]*t[3]<=a)return[t[0],t[1]*t[2]*t[3]];if(r){const n=Ht(t);let r=2,a=2;return t.length&&([r,a]=jt(t)),o=n*(r/2)*(a/2),e.sizeToSquarishShape(o).map(e=>2*e)}return e.sizeToSquarishShape(o)}function Yt(e){return e%2==0}function Qt(n,t){if(n=n.slice(-2),t=t.slice(-2),e.arraysEqual(n,t))return!0;if(!n.length||!t.length)return!0;if(0===n[0]||0===n[1]||0===t[0]||0===t[1])return!0;if(n.length!==t.length){const e=n.slice(-1)[0],r=t.slice(-1)[0];if(e===r)return!0;if(Yt(e)&&Yt(r)&&(1===n[0]||1===t[0]))return!0}return n[1]===t[1]&&Yt(n[0])&&Yt(t[0])}let Zt,Jt;function er(e){if(null==Zt){const n=pt(e);Zt=n.getParameter(n.MAX_TEXTURE_SIZE)}return Zt}function nr(e){if(null==Jt){const n=pt(e);Jt=n.getParameter(n.MAX_TEXTURE_IMAGE_UNITS)}return Math.min(16,Jt)}function tr(e){if(0===e)return 0;let n;const t=pt(e);return n=rr(t,"EXT_disjoint_timer_query_webgl2")&&2===e?2:rr(t,"EXT_disjoint_timer_query")?1:0,n}function rr(e,n){return null!=e.getExtension(n)}function ar(e){try{if(null!=pt(e))return!0}catch(e){return console.log("Error when getting WebGL context: ",e),!1}return!1}function or(e){if(0===e)return!1;const n=pt(e);if(1===e){if(!rr(n,"OES_texture_float"))return!1}else if(!rr(n,"EXT_color_buffer_float"))return!1;return ir(n)}function sr(e){if(0===e)return!1;const n=pt(e);if(1!==e){if(rr(n,"EXT_color_buffer_float"))return ir(n);const e="EXT_color_buffer_half_float";if(rr(n,e)){const t=n.getExtension(e);return function(e,n){const t=Ct(e,n),r=e.createTexture();e.bindTexture(e.TEXTURE_2D,r);e.texImage2D(e.TEXTURE_2D,0,t.internalFormatHalfFloat,1,1,0,t.textureFormatFloat,t.textureTypeHalfFloat,null);const a=e.createFramebuffer();e.bindFramebuffer(e.FRAMEBUFFER,a),e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,r,0);const o=e.checkFramebufferStatus(e.FRAMEBUFFER)===e.FRAMEBUFFER_COMPLETE;return e.bindTexture(e.TEXTURE_2D,null),e.bindFramebuffer(e.FRAMEBUFFER,null),e.deleteTexture(r),e.deleteFramebuffer(a),o}(n,t)}return!1}return!!rr(n,"OES_texture_float")&&(!!rr(n,"WEBGL_color_buffer_float")&&ir(n))}function ir(e){const n=Ct(e),t=e.createTexture();e.bindTexture(e.TEXTURE_2D,t);e.texImage2D(e.TEXTURE_2D,0,n.internalFormatFloat,1,1,0,n.textureFormatFloat,n.textureTypeFloat,null);const r=e.createFramebuffer();e.bindFramebuffer(e.FRAMEBUFFER,r),e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,t,0);const a=e.checkFramebufferStatus(e.FRAMEBUFFER)===e.FRAMEBUFFER_COMPLETE;return e.bindTexture(e.TEXTURE_2D,null),e.bindFramebuffer(e.FRAMEBUFFER,null),e.deleteTexture(t),e.deleteFramebuffer(r),a}function ur(e){if(2!==e)return!1;return null!=pt(e).fenceSync}function lr(n,t){Array.isArray(n)||(n=[n]),n.forEach(n=>{null!=n&&e.assert("complex64"!==n.dtype,()=>`${t} does not support complex64 tensors `+"in the WebGL backend.")})}var cr=Object.freeze({__proto__:null,callAndCheck:vt,canBeRepresented:$t,getWebGLErrorMessage:It,getExtensionOrThrow:Rt,createVertexShader:yt,createFragmentShader:wt,createProgram:Tt,linkProgram:Et,validateProgram:Nt,createStaticVertexBuffer:St,createStaticIndexBuffer:At,getNumChannels:function(){return 2===n().getNumber("WEBGL_VERSION")?1:4},createTexture:Ft,validateTextureSize:Ot,createFramebuffer:_t,bindVertexBufferToProgramAttribute:Dt,bindTextureUnit:Lt,unbindTextureUnit:function(e,n){Xt(e,n),vt(e,()=>e.activeTexture(e.TEXTURE0+n)),vt(e,()=>e.bindTexture(e.TEXTURE_2D,null))},getProgramUniformLocationOrThrow:Pt,getProgramUniformLocation:Bt,bindTextureToProgramUniformSampler:Wt,bindCanvasToFramebuffer:function(e){vt(e,()=>e.bindFramebuffer(e.FRAMEBUFFER,null)),vt(e,()=>e.viewport(0,0,e.canvas.width,e.canvas.height)),vt(e,()=>e.scissor(0,0,e.canvas.width,e.canvas.height))},bindColorTextureToFramebuffer:Vt,unbindColorTextureFromFramebuffer:Mt,validateFramebuffer:Gt,getFramebufferErrorMessage:Ut,getBatchDim:Ht,getRowsCols:jt,getShapeAs3D:Kt,getTextureShapeFromLogicalShape:qt,isReshapeFree:Qt,getWebGLMaxTextureSize:er,resetMaxTextureSize:function(){Zt=null},resetMaxTexturesInShader:function(){Jt=null},getMaxTexturesInShader:nr,getWebGLDisjointQueryTimerVersion:tr,hasExtension:rr,isWebGLVersionEnabled:ar,isCapableOfRenderingToFloatTexture:or,isDownloadFloatTextureEnabled:sr,isWebGLFenceEnabled:ur,assertNotComplex:lr});const dr=n();function pr(){let e,t,r,a,o,s,i,u,l,c;return 2===n().getNumber("WEBGL_VERSION")?(e="#version 300 es",t="in",r="out",a="in",o="texture",s="outputColor",i="out vec4 outputColor;",u="\n      bool isnan_custom(float val) {\n        return (val > 0.0 || val < 0.0) ? false : val != 0.0;\n      }\n\n      bvec4 isnan_custom(vec4 val) {\n        return bvec4(isnan_custom(val.x),\n          isnan_custom(val.y), isnan_custom(val.z), isnan_custom(val.w));\n      }\n\n      #define isnan(value) isnan_custom(value)\n    ",l="",c="\n      #define round(value) newRound(value)\n      int newRound(float value) {\n        return int(floor(value + 0.5));\n      }\n\n      ivec4 newRound(vec4 value) {\n        return ivec4(floor(value + vec4(0.5)));\n      }\n    "):(e="",t="attribute",r="varying",a="varying",o="texture2D",s="gl_FragColor",i="",u="\n      #define isnan(value) isnan_custom(value)\n      bool isnan_custom(float val) {\n        return (val > 0. || val < 1. || val == 0.) ? false : true;\n      }\n      bvec4 isnan_custom(vec4 val) {\n        return bvec4(isnan(val.x), isnan(val.y), isnan(val.z), isnan(val.w));\n      }\n    ",l="\n      uniform float INFINITY;\n\n      bool isinf(float val) {\n        return abs(val) == INFINITY;\n      }\n      bvec4 isinf(vec4 val) {\n        return equal(abs(val), vec4(INFINITY));\n      }\n    ",c="\n      int round(float value) {\n        return int(floor(value + 0.5));\n      }\n\n      ivec4 round(vec4 value) {\n        return ivec4(floor(value + vec4(0.5)));\n      }\n    "),{version:e,attribute:t,varyingVs:r,varyingFs:a,texture2D:o,output:s,defineOutput:i,defineSpecialNaN:u,defineSpecialInf:l,defineRound:c}}function hr(n,t,r="index"){const a=e.computeStrides(t);return a.map((e,t)=>`${`int ${n[t]} = ${r} / ${e}`}; ${t===a.length-1?`int ${n[t+1]} = ${r} - ${n[t]} * ${e}`:`index -= ${n[t]} * ${e}`};`).join("")}function fr(n){const t=e.computeStrides(n).map(e=>e.toString());return`\n  int getFlatIndex(ivec3 coords) {\n    return coords.x * ${t[0]} + coords.y * ${t[1]} + coords.z;\n  }\n`}dr.registerFlag("HAS_WEBGL",()=>dr.getNumber("WEBGL_VERSION")>0),dr.registerFlag("WEBGL_VERSION",()=>ar(2)?2:ar(1)?1:0),dr.registerFlag("WEBGL_CHECK_NUMERICAL_PROBLEMS",()=>!1),dr.registerFlag("WEBGL_BUFFER_SUPPORTED",()=>2===dr.get("WEBGL_VERSION")),dr.registerFlag("WEBGL_CPU_FORWARD",()=>!0),dr.registerFlag("WEBGL_FORCE_F16_TEXTURES",()=>!1),dr.registerFlag("WEBGL_PACK",()=>dr.getBool("HAS_WEBGL")),dr.registerFlag("WEBGL_PACK_NORMALIZATION",()=>dr.getBool("WEBGL_PACK")),dr.registerFlag("WEBGL_PACK_CLIP",()=>dr.getBool("WEBGL_PACK")),dr.registerFlag("WEBGL_PACK_DEPTHWISECONV",()=>!1),dr.registerFlag("WEBGL_PACK_BINARY_OPERATIONS",()=>dr.getBool("WEBGL_PACK")),dr.registerFlag("WEBGL_PACK_UNARY_OPERATIONS",()=>dr.getBool("WEBGL_PACK")),dr.registerFlag("WEBGL_PACK_ARRAY_OPERATIONS",()=>dr.getBool("WEBGL_PACK")),dr.registerFlag("WEBGL_PACK_IMAGE_OPERATIONS",()=>dr.getBool("WEBGL_PACK")),dr.registerFlag("WEBGL_PACK_REDUCE",()=>dr.getBool("WEBGL_PACK")),dr.registerFlag("WEBGL_LAZILY_UNPACK",()=>dr.getBool("WEBGL_PACK")),dr.registerFlag("WEBGL_CONV_IM2COL",()=>dr.getBool("WEBGL_PACK")),dr.registerFlag("WEBGL_MAX_TEXTURE_SIZE",()=>er(dr.getNumber("WEBGL_VERSION"))),dr.registerFlag("WEBGL_MAX_TEXTURES_IN_SHADER",()=>nr(dr.getNumber("WEBGL_VERSION"))),dr.registerFlag("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION",()=>{const e=dr.getNumber("WEBGL_VERSION");return 0===e?0:tr(e)}),dr.registerFlag("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE",()=>dr.getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION")>0&&!t.isMobile()),dr.registerFlag("WEBGL_RENDER_FLOAT32_CAPABLE",()=>or(dr.getNumber("WEBGL_VERSION"))),dr.registerFlag("WEBGL_RENDER_FLOAT32_ENABLED",()=>!dr.getBool("WEBGL_FORCE_F16_TEXTURES")&&dr.getBool("WEBGL_RENDER_FLOAT32_CAPABLE")),dr.registerFlag("WEBGL_DOWNLOAD_FLOAT_ENABLED",()=>sr(dr.getNumber("WEBGL_VERSION"))),dr.registerFlag("WEBGL_FENCE_API_ENABLED",()=>ur(dr.getNumber("WEBGL_VERSION"))),dr.registerFlag("WEBGL_SIZE_UPLOAD_UNIFORM",()=>dr.getBool("WEBGL_RENDER_FLOAT32_ENABLED")?4:0),dr.registerFlag("WEBGL_DELETE_TEXTURE_THRESHOLD",()=>-1,e=>{if(e<0&&-1!==e)throw new Error("WEBGL_DELETE_TEXTURE_THRESHOLD must be -1 (indicating never "+`delete) or at least 0, but got ${e}.`)}),dr.registerFlag("WEBGL_FLUSH_THRESHOLD",()=>-1,e=>{if(e<0&&-1!==e)throw new Error("WEBGL_FLUSH_THRESHOLD must be -1 (indicating never "+`manual flush) or at least 0, but got ${e}.`)});const xr="\n  const float FLOAT_MAX = 1.70141184e38;\n  const float FLOAT_MIN = 1.17549435e-38;\n\n  lowp vec4 encode_float(highp float v) {\n    if (isnan(v)) {\n      return vec4(255, 255, 255, 255);\n    }\n\n    highp float av = abs(v);\n\n    if(av < FLOAT_MIN) {\n      return vec4(0.0, 0.0, 0.0, 0.0);\n    } else if(v > FLOAT_MAX) {\n      return vec4(0.0, 0.0, 128.0, 127.0) / 255.0;\n    } else if(v < -FLOAT_MAX) {\n      return vec4(0.0, 0.0,  128.0, 255.0) / 255.0;\n    }\n\n    highp vec4 c = vec4(0,0,0,0);\n\n    highp float e = floor(log2(av));\n    highp float m = exp2(fract(log2(av))) - 1.0;\n\n    c[2] = floor(128.0 * m);\n    m -= c[2] / 128.0;\n    c[1] = floor(32768.0 * m);\n    m -= c[1] / 32768.0;\n    c[0] = floor(8388608.0 * m);\n\n    highp float ebias = e + 127.0;\n    c[3] = floor(ebias / 2.0);\n    ebias -= c[3] * 2.0;\n    c[2] += floor(ebias) * 128.0;\n\n    c[3] += 128.0 * step(0.0, -v);\n\n    return c / 255.0;\n  }\n";class gr{constructor(e){this.variableNames=["A"],this.packedInputs=!1,this.packedOutput=!0,this.outPackingScheme=ht.DENSE;const n=mt(e),t=pr();this.outputShape=e,this.userCode=`\n      ivec3 outCoordsFromFlatIndex(int index) {\n        ${hr(["r","c","d"],e)}\n        return ivec3(r, c, d);\n      }\n\n      void main() {\n        ivec2 resTexRC = ivec2(resultUV.yx *\n          vec2(${n[0]}, ${n[1]}));\n        int index = 4 * (resTexRC.x * ${n[1]} + resTexRC.y);\n\n        vec4 result = vec4(0.);\n\n        for (int i=0; i<4; i++) {\n          int flatIndex = index + i;\n          ivec3 rc = outCoordsFromFlatIndex(flatIndex);\n          result[i] = getA(rc.x, rc.y, rc.z);\n        }\n\n        ${t.output} = result;\n      }\n    `}}class mr{constructor(e){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.outPackingScheme=ht.DENSE;const n=mt(e),t=pr();this.outputShape=e,this.userCode=`\n      ivec3 outCoordsFromFlatIndex(int index) {\n        ${hr(["r","c","d"],e)}\n        return ivec3(r, c, d);\n      }\n\n      void main() {\n        ivec2 resTexRC = ivec2(resultUV.yx *\n          vec2(${n[0]}, ${n[1]}));\n        int index = 4 * (resTexRC.x * ${n[1]} + resTexRC.y);\n\n        vec4 result = vec4(0.);\n\n        for (int i=0; i<4; i++) {\n          int flatIndex = index + i;\n          ivec3 rc = outCoordsFromFlatIndex(flatIndex);\n          result[i] = getChannel(getA(rc.x, rc.y, rc.z), vec2(rc.y, rc.z));\n        }\n\n        ${t.output} = result;\n      }\n    `}}class br{constructor(e){this.variableNames=["A"],this.outTexUsage=ft.DOWNLOAD;const n=pr();this.outputShape=e,this.userCode=`\n      ${xr}\n\n      void main() {\n        float x = getAAtOutCoords();\n        ${n.output} = encode_float(x);\n      }\n    `}}class Cr{constructor(e){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!1,this.outTexUsage=ft.DOWNLOAD;const n=pr();this.outputShape=e,this.userCode=`\n      ${xr}\n\n      void main() {\n        ivec3 coords = getOutputCoords();\n        float x = getChannel(getAAtOutCoords(), vec2(coords.y, coords.z));\n        ${n.output} = encode_float(x);\n      }\n    `}}class vr{constructor(e,n,t=!1){this.variableNames=["A"];const r=pr(),[a,o]=n;this.outputShape=e;let s="result";t&&(s="floor(result * 255. + 0.5)"),this.userCode=`\n      ${fr(e)}\n\n      void main() {\n        ivec3 coords = getOutputCoords();\n\n        int flatIndex = getFlatIndex(coords);\n        int offset = imod(flatIndex, 4);\n\n        flatIndex = idiv(flatIndex, 4, 1.);\n\n        int r = flatIndex / ${o};\n        int c = imod(flatIndex, ${o});\n        vec2 uv = (vec2(c, r) + halfCR) / vec2(${o}.0, ${a}.0);\n        vec4 values = ${r.texture2D}(A, uv);\n\n        float result;\n\n        if(offset == 0) {\n          result = values[0];\n        } else if(offset == 1) {\n          result = values[1];\n        } else if(offset == 2) {\n          result = values[2];\n        } else {\n          result = values[3];\n        }\n\n        ${r.output} = vec4(${s}, 0., 0., 0.);\n      }\n    `}}class $r{constructor(e,n,t=!1){this.variableNames=["A"],this.packedInputs=!1,this.packedOutput=!0;const r=pr(),[a,o]=n;this.outputShape=e;let s="",i="result";t&&(i="floor(result * 255. + 0.5)");for(let n=0;n<=1;n++)for(let t=0;t<=1;t++){const i=2*n+t;s+=`\n          localCoords = coords;\n          if(localCoords[2] + ${t} < ${e[2]}) {\n            localCoords[2] += ${t};\n            if(localCoords[1] + ${n} < ${e[1]}) {\n              localCoords[1] += ${n};\n\n              flatIndex = getFlatIndex(localCoords);\n              offset = imod(flatIndex, 4);\n\n              flatIndex = idiv(flatIndex, 4, 1.);\n\n              r = flatIndex / ${o};\n              c = imod(flatIndex, ${o});\n              uv = (vec2(c, r) + halfCR) / vec2(${o}.0, ${a}.0);\n              values = ${r.texture2D}(A, uv);\n\n              if(offset == 0) {\n                result[${i}] = values[0];\n              } else if(offset == 1) {\n                result[${i}] = values[1];\n              } else if(offset == 2) {\n                result[${i}] = values[2];\n              } else {\n                result[${i}] = values[3];\n              }\n            }\n          }\n        `}this.userCode=`\n      ${fr(e)}\n\n      void main() {\n        ivec3 coords = getOutputCoords();\n\n        vec4 result = vec4(0.);\n        int flatIndex, r, c, offset;\n        ivec3 localCoords;\n        vec2 uv;\n        vec4 values;\n\n        ${s}\n\n        ${r.output} = ${i};\n      }\n    `}}function Ir(e){const n=pr();return yt(e,`${n.version}\n    precision highp float;\n    ${n.attribute} vec3 clipSpacePos;\n    ${n.attribute} vec2 uv;\n    ${n.varyingVs} vec2 resultUV;\n\n    void main() {\n      gl_Position = vec4(clipSpacePos, 1);\n      resultUV = uv;\n    }`)}function Rr(e){return St(e,new Float32Array([-1,1,0,0,1,-1,-1,0,0,0,1,1,0,1,1,1,-1,0,1,0]))}function yr(e){return At(e,new Uint16Array([0,1,2,2,1,3]))}function wr(e,n,t,r,a,o){Ot(n,t);const s=Ft(e),i=e.TEXTURE_2D;return vt(e,()=>e.bindTexture(i,s)),vt(e,()=>e.texParameteri(i,e.TEXTURE_WRAP_S,e.CLAMP_TO_EDGE)),vt(e,()=>e.texParameteri(i,e.TEXTURE_WRAP_T,e.CLAMP_TO_EDGE)),vt(e,()=>e.texParameteri(i,e.TEXTURE_MIN_FILTER,e.NEAREST)),vt(e,()=>e.texParameteri(i,e.TEXTURE_MAG_FILTER,e.NEAREST)),vt(e,()=>e.texImage2D(i,0,r,n,t,0,a,o,null)),vt(e,()=>e.bindTexture(e.TEXTURE_2D,null)),s}function kr(e){return e.internalFormatFloat}function Tr(e,n,t,r){const[a,o]=gt(n,t);return wr(e,a,o,kr(r),r.textureFormatFloat,e.FLOAT)}function Er(e){return e.internalFormatHalfFloat}function Nr(e,n,t,r){const[a,o]=gt(n,t);return wr(e,a,o,Er(r),r.textureFormatFloat,r.textureTypeHalfFloat)}function Sr(e){return e.downloadTextureFormat}function Ar(e,n,t,r){const[a,o]=gt(n,t);return wr(e,a,o,Sr(r),e.RGBA,e.UNSIGNED_BYTE)}function Fr(e){return e.internalFormatPackedFloat}function Or(e,n,t,r){const[a,o]=bt(n,t);return wr(e,a,o,Fr(r),e.RGBA,e.FLOAT)}function _r(e){return e.internalFormatPackedHalfFloat}function Dr(e,n,t,r){const[a,o]=bt(n,t);return wr(e,a,o,_r(r),e.RGBA,r.textureTypeHalfFloat)}function Lr(e,n,t){return vt(e,()=>e.bindBuffer(e.ARRAY_BUFFER,t)),Dt(e,n,"clipSpacePos",t,3,20,0)&&Dt(e,n,"uv",t,2,20,12)}function Pr(e,n,t,r,a,o){let s,i,u;vt(e,()=>e.bindTexture(e.TEXTURE_2D,n)),a instanceof Uint8Array?(s=new Uint8Array(t*r*4),i=e.UNSIGNED_BYTE,u=e.RGBA):(s=new Float32Array(t*r*4),i=e.FLOAT,u=o.internalFormatPackedFloat),s.set(a),vt(e,()=>e.texImage2D(e.TEXTURE_2D,0,u,t,r,0,e.RGBA,i,s)),vt(e,()=>e.bindTexture(e.TEXTURE_2D,null))}function Br(e,n,t){vt(e,()=>e.bindTexture(e.TEXTURE_2D,n)),t.data instanceof Uint8Array?vt(e,()=>e.texImage2D(e.TEXTURE_2D,0,e.RGBA,t.width,t.height,0,e.RGBA,e.UNSIGNED_BYTE,t.data)):vt(e,()=>e.texImage2D(e.TEXTURE_2D,0,e.RGBA,e.RGBA,e.UNSIGNED_BYTE,t)),vt(e,()=>e.bindTexture(e.TEXTURE_2D,null))}function Wr(e,n,t,r){const a=e.createBuffer();vt(e,()=>e.bindBuffer(e.PIXEL_PACK_BUFFER,a));const o=16*n*t;return vt(e,()=>e.bufferData(e.PIXEL_PACK_BUFFER,o,e.STREAM_READ)),vt(e,()=>e.readPixels(0,0,t,n,e.RGBA,e.FLOAT,0)),vt(e,()=>e.bindBuffer(e.PIXEL_PACK_BUFFER,null)),a}function Vr(e,n,t){const r=e,a=new Float32Array(t);return r.bindBuffer(r.PIXEL_PACK_BUFFER,n),r.getBufferSubData(r.PIXEL_PACK_BUFFER,0,a),r.bindBuffer(r.PIXEL_PACK_BUFFER,null),a}function Mr(e,n,t,r){const[a,o]=gt(n,t),s=new Uint8Array(n*t*4);return vt(e,()=>e.readPixels(0,0,a,o,r.downloadTextureFormat,e.UNSIGNED_BYTE,s)),new Float32Array(s.buffer)}function Gr(e,n,t,r,a,o,s,i){const u=e,l=new Float32Array(function(e,n){const[t,r]=bt(e,n);return t*r*4}(o,s));return u.bindBuffer(u.PIXEL_PACK_BUFFER,n),u.getBufferSubData(u.PIXEL_PACK_BUFFER,0,l),u.bindBuffer(u.PIXEL_PACK_BUFFER,null),l}function Ur(e,n,t){const r=new Float32Array(n*t*4);return vt(e,()=>e.readPixels(0,0,t,n,e.RGBA,e.FLOAT,r)),r}var zr=Object.freeze({__proto__:null,createVertexShader:Ir,createVertexBuffer:Rr,createIndexBuffer:yr,getInternalFormatForFloat32MatrixTexture:kr,createFloat32MatrixTexture:Tr,getInternalFormatForFloat16MatrixTexture:Er,createFloat16MatrixTexture:Nr,getInternalFormatForUnsignedBytesMatrixTexture:Sr,createUnsignedBytesMatrixTexture:Ar,getInternalFormatForPackedMatrixTexture:Fr,createPackedMatrixTexture:Or,getInternalFormatForFloat16PackedMatrixTexture:_r,createFloat16PackedMatrixTexture:Dr,bindVertexProgramAttributeStreams:Lr,uploadDenseMatrixToTexture:Pr,uploadPixelDataToTexture:Br,createBufferFromOutputTexture:Wr,downloadFloat32MatrixFromBuffer:Vr,downloadByteEncodedFloatMatrixFromOutputTexture:Mr,downloadPackedMatrixFromBuffer:Gr,downloadMatrixFromPackedOutputTexture:Ur});class Xr{constructor(e){this.outputTexture=null,this.program=null,this.disposed=!1,this.vertexAttrsAreBound=!1,this.itemsToPoll=[];const t=n().getNumber("WEBGL_VERSION");null!=e?(this.gl=e,dt(t,e)):this.gl=pt(t);let r="WEBGL_color_buffer_float";if(1===n().getNumber("WEBGL_VERSION")){const e="OES_texture_float",t="OES_texture_half_float";if(this.textureFloatExtension=Rt(this.gl,e),rr(this.gl,t))this.textureHalfFloatExtension=Rt(this.gl,t);else if(n().get("WEBGL_FORCE_F16_TEXTURES"))throw new Error("GL context does not support half float textures, yet the environment flag WEBGL_FORCE_F16_TEXTURES is set to true.");if(this.colorBufferFloatExtension=this.gl.getExtension(r),rr(this.gl,"EXT_color_buffer_half_float"))this.colorBufferHalfFloatExtension=Rt(this.gl,"EXT_color_buffer_half_float");else if(n().get("WEBGL_FORCE_F16_TEXTURES"))throw new Error("GL context does not support color renderable half floats, yet the environment flag WEBGL_FORCE_F16_TEXTURES is set to true.")}else if(r="EXT_color_buffer_float",rr(this.gl,r))this.colorBufferFloatExtension=this.gl.getExtension(r);else{if(!rr(this.gl,"EXT_color_buffer_half_float"))throw new Error("GL context does not support color renderable floats");this.colorBufferHalfFloatExtension=this.gl.getExtension("EXT_color_buffer_half_float")}this.vertexBuffer=Rr(this.gl),this.indexBuffer=yr(this.gl),this.framebuffer=_t(this.gl),this.textureConfig=Ct(this.gl,this.textureHalfFloatExtension)}get debug(){return n().getBool("DEBUG")}dispose(){if(this.disposed)return;null!=this.program&&console.warn("Disposing a GPGPUContext that still has a bound WebGLProgram. This is probably a resource leak, delete the program with GPGPUContext.deleteProgram before disposing."),null!=this.outputTexture&&console.warn("Disposing a GPGPUContext that still has a bound output matrix texture.  This is probably a resource leak, delete the output matrix texture with GPGPUContext.deleteMatrixTexture before disposing.");const e=this.gl;vt(e,()=>e.finish()),vt(e,()=>e.bindFramebuffer(e.FRAMEBUFFER,null)),vt(e,()=>e.deleteFramebuffer(this.framebuffer)),vt(e,()=>e.bindBuffer(e.ARRAY_BUFFER,null)),vt(e,()=>e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,null)),vt(e,()=>e.deleteBuffer(this.indexBuffer)),this.disposed=!0}createFloat32MatrixTexture(e,n){return this.throwIfDisposed(),Tr(this.gl,e,n,this.textureConfig)}createFloat16MatrixTexture(e,n){return this.throwIfDisposed(),Nr(this.gl,e,n,this.textureConfig)}createUnsignedBytesMatrixTexture(e,n){return this.throwIfDisposed(),Ar(this.gl,e,n,this.textureConfig)}uploadPixelDataToTexture(e,n){this.throwIfDisposed(),Br(this.gl,e,n)}uploadDenseMatrixToTexture(e,n,t,r){this.throwIfDisposed(),Pr(this.gl,e,n,t,r,this.textureConfig)}createFloat16PackedMatrixTexture(e,n){return this.throwIfDisposed(),Dr(this.gl,e,n,this.textureConfig)}createPackedMatrixTexture(e,n){return this.throwIfDisposed(),Or(this.gl,e,n,this.textureConfig)}deleteMatrixTexture(e){this.throwIfDisposed(),this.outputTexture===e&&(Mt(this.gl,this.framebuffer),this.outputTexture=null),vt(this.gl,()=>this.gl.deleteTexture(e))}downloadByteEncodedFloatMatrixFromOutputTexture(e,n,t){return this.downloadMatrixDriver(e,()=>Mr(this.gl,n,t,this.textureConfig))}downloadPackedMatrixFromBuffer(e,n,t,r,a,o){return Gr(this.gl,e,0,0,0,a,o,this.textureConfig)}downloadFloat32MatrixFromBuffer(e,n){return Vr(this.gl,e,n)}createBufferFromTexture(e,n,t){this.bindTextureToFrameBuffer(e);const r=Wr(this.gl,n,t,this.textureConfig);return this.unbindTextureToFrameBuffer(),r}createAndWaitForFence(){const e=this.createFence(this.gl);return this.pollFence(e)}createFence(e){let t,r;if(n().getBool("WEBGL_FENCE_API_ENABLED")){const n=e,a=n.fenceSync(n.SYNC_GPU_COMMANDS_COMPLETE,0);e.flush(),r=()=>{const e=n.clientWaitSync(a,0,0);return e===n.ALREADY_SIGNALED||e===n.CONDITION_SATISFIED},t=a}else n().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION")>0?(t=this.beginQuery(),this.endQuery(),r=()=>this.isQueryAvailable(t,n().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION"))):r=()=>!0;return{query:t,isFencePassed:r}}downloadMatrixFromPackedTexture(e,n,t){return this.downloadMatrixDriver(e,()=>Ur(this.gl,n,t))}createProgram(e){this.throwIfDisposed();const n=this.gl,t=wt(n,e),r=Ir(n),a=Tt(n);return vt(n,()=>n.attachShader(a,r)),vt(n,()=>n.attachShader(a,t)),Et(n,a),this.debug&&Nt(n,a),this.vertexAttrsAreBound||(this.setProgram(a),this.vertexAttrsAreBound=Lr(n,this.program,this.vertexBuffer)),a}deleteProgram(e){this.throwIfDisposed(),e===this.program&&(this.program=null),null!=e&&vt(this.gl,()=>this.gl.deleteProgram(e))}setProgram(e){this.throwIfDisposed(),this.program=e,null!=this.program&&this.debug&&Nt(this.gl,this.program),vt(this.gl,()=>this.gl.useProgram(e))}getUniformLocation(e,n,t=!0){return this.throwIfDisposed(),t?Pt(this.gl,e,n):Bt(this.gl,e,n)}getAttributeLocation(e,n){return this.throwIfDisposed(),vt(this.gl,()=>this.gl.getAttribLocation(e,n))}getUniformLocationNoThrow(e,n){return this.throwIfDisposed(),this.gl.getUniformLocation(e,n)}setInputMatrixTexture(e,n,t){this.throwIfDisposed(),this.throwIfNoProgram(),Wt(this.gl,e,n,t)}setOutputMatrixTexture(e,n,t){this.setOutputMatrixTextureDriver(e,t,n)}setOutputPackedMatrixTexture(e,n,t){this.throwIfDisposed();const[r,a]=bt(n,t);this.setOutputMatrixTextureDriver(e,r,a)}setOutputMatrixWriteRegion(e,n,t,r){this.setOutputMatrixWriteRegionDriver(t,e,r,n)}setOutputPackedMatrixWriteRegion(e,n,t,r){throw new Error("setOutputPackedMatrixWriteRegion not implemented.")}debugValidate(){null!=this.program&&Nt(this.gl,this.program),Gt(this.gl)}executeProgram(){this.throwIfDisposed(),this.throwIfNoProgram();const e=this.gl;this.debug&&this.debugValidate(),vt(e,()=>e.drawElements(e.TRIANGLES,6,e.UNSIGNED_SHORT,0))}blockUntilAllProgramsCompleted(){this.throwIfDisposed(),vt(this.gl,()=>this.gl.finish())}getQueryTimerExtension(){return null==this.disjointQueryTimerExtension&&(this.disjointQueryTimerExtension=Rt(this.gl,2===n().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION")?"EXT_disjoint_timer_query_webgl2":"EXT_disjoint_timer_query")),this.disjointQueryTimerExtension}getQueryTimerExtensionWebGL2(){return this.getQueryTimerExtension()}getQueryTimerExtensionWebGL1(){return this.getQueryTimerExtension()}beginQuery(){if(2===n().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION")){const e=this.gl,n=this.getQueryTimerExtensionWebGL2(),t=e.createQuery();return e.beginQuery(n.TIME_ELAPSED_EXT,t),t}const e=this.getQueryTimerExtensionWebGL1(),t=e.createQueryEXT();return e.beginQueryEXT(e.TIME_ELAPSED_EXT,t),t}endQuery(){if(2===n().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION")){const e=this.gl,n=this.getQueryTimerExtensionWebGL2();return void e.endQuery(n.TIME_ELAPSED_EXT)}const e=this.getQueryTimerExtensionWebGL1();e.endQueryEXT(e.TIME_ELAPSED_EXT)}async waitForQueryAndGetTime(t){return await e.repeatedTry(()=>this.disposed||this.isQueryAvailable(t,n().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION"))),this.getQueryTime(t,n().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION"))}getQueryTime(e,n){if(0===n)return null;if(2===n){const n=this.gl;return n.getQueryParameter(e,n.QUERY_RESULT)/1e6}{const n=this.getQueryTimerExtensionWebGL1();return n.getQueryObjectEXT(e,n.QUERY_RESULT_EXT)/1e6}}isQueryAvailable(e,n){if(0===n)return!0;if(2===n){const n=this.gl,t=this.getQueryTimerExtensionWebGL2(),r=n.getQueryParameter(e,n.QUERY_RESULT_AVAILABLE);return null==this.disjoint&&(this.disjoint=this.gl.getParameter(t.GPU_DISJOINT_EXT)),r&&!this.disjoint}{const n=this.getQueryTimerExtensionWebGL1(),t=n.getQueryObjectEXT(e,n.QUERY_RESULT_AVAILABLE_EXT);return null==this.disjoint&&(this.disjoint=this.gl.getParameter(n.GPU_DISJOINT_EXT)),t&&!this.disjoint}}pollFence(e){return new Promise(n=>{this.addItemToPoll(()=>e.isFencePassed(),()=>n())})}pollItems(){const e=function(e){let n=0;for(;n<e.length;++n){if(!e[n]())break}return n-1}(this.itemsToPoll.map(e=>e.isDoneFn));for(let n=0;n<=e;++n){const{resolveFn:e}=this.itemsToPoll[n];e()}this.itemsToPoll=this.itemsToPoll.slice(e+1)}addItemToPoll(n,t){this.itemsToPoll.push({isDoneFn:n,resolveFn:t}),this.itemsToPoll.length>1||e.repeatedTry(()=>(this.pollItems(),0===this.itemsToPoll.length))}bindTextureToFrameBuffer(e){this.throwIfDisposed(),Vt(this.gl,e,this.framebuffer),this.debug&&Gt(this.gl)}unbindTextureToFrameBuffer(){null!=this.outputTexture?(Vt(this.gl,this.outputTexture,this.framebuffer),this.debug&&Gt(this.gl)):Mt(this.gl,this.framebuffer)}downloadMatrixDriver(e,n){this.bindTextureToFrameBuffer(e);const t=n();return this.unbindTextureToFrameBuffer(),t}setOutputMatrixTextureDriver(e,n,t){this.throwIfDisposed();const r=this.gl;Vt(r,e,this.framebuffer),this.debug&&Gt(r),this.outputTexture=e,vt(r,()=>r.viewport(0,0,n,t)),vt(r,()=>r.scissor(0,0,n,t))}setOutputMatrixWriteRegionDriver(e,n,t,r){this.throwIfDisposed(),vt(this.gl,()=>this.gl.scissor(e,n,t,r))}throwIfDisposed(){if(this.disposed)throw new Error("Attempted to use disposed GPGPUContext.")}throwIfNoProgram(){if(null==this.program)throw new Error("No GPU program is currently set.")}}const{getBroadcastDims:Hr}=r;function jr(n,t,r,a){const o=[];n.forEach(n=>{const t=e.sizeFromShape(n.shapeInfo.logicalShape);n.shapeInfo.isUniform?o.push(`uniform float ${n.name}${t>1?`[${t}]`:""};`):(o.push(`uniform sampler2D ${n.name};`),o.push(`uniform int offset${n.name};`))});const s=o.join("\n"),i=n.map(n=>function(n,t,r=!1){let a="";a+=r?qr(n):Kr(n);const o=n.shapeInfo.logicalShape,s=t.logicalShape;o.length<=s.length&&(a+=r?function(n,t){const r=n.name,a=r.charAt(0).toUpperCase()+r.slice(1),o="get"+a+"AtOutCoords",s=n.shapeInfo.logicalShape.length,i=t.logicalShape.length,u=Hr(n.shapeInfo.logicalShape,t.logicalShape),l=ra(i),c=i-s;let d;const p=["x","y","z","w","u","v"];d=0===s?"":i<2&&u.length>=1?"coords = 0;":u.map(e=>`coords.${p[e+c]} = 0;`).join("\n");let h="";h=i<2&&s>0?"coords":n.shapeInfo.logicalShape.map((e,n)=>`coords.${p[n+c]}`).join(", ");let f="return outputValue;";const x=1===e.sizeFromShape(n.shapeInfo.logicalShape),g=1===e.sizeFromShape(t.logicalShape);if(1!==s||x||g){if(x&&!g)f=1===i?"\n        return vec4(outputValue.x, outputValue.x, 0., 0.);\n      ":"\n        return vec4(outputValue.x);\n      ";else if(u.length){const e=s-2,n=s-1;u.indexOf(e)>-1&&u.indexOf(n)>-1?f="return vec4(outputValue.x);":u.indexOf(e)>-1?f="return vec4(outputValue.x, outputValue.y, outputValue.x, outputValue.y);":u.indexOf(n)>-1&&(f="return vec4(outputValue.xx, outputValue.zz);")}}else f="\n      return vec4(outputValue.xy, outputValue.xy);\n    ";return`\n    vec4 ${o}() {\n      ${l} coords = getOutputCoords();\n      ${d}\n      vec4 outputValue = get${a}(${h});\n      ${f}\n    }\n  `}(n,t):function(n,t){const r=n.name,a=r.charAt(0).toUpperCase()+r.slice(1),o="get"+a+"AtOutCoords",s=t.texShape,i=n.shapeInfo.texShape,u=n.shapeInfo.logicalShape.length,l=t.logicalShape.length;if(!n.shapeInfo.isUniform&&u===l&&null==n.shapeInfo.flatOffset&&e.arraysEqual(i,s))return`\n      float ${o}() {\n        return sampleTexture(${r}, resultUV);\n      }\n    `;const c=ra(l),d=Hr(n.shapeInfo.logicalShape,t.logicalShape),p=l-u;let h;const f=["x","y","z","w","u","v"];h=0===u?"":l<2&&d.length>=1?"coords = 0;":d.map(e=>`coords.${f[e+p]} = 0;`).join("\n");let x="";x=l<2&&u>0?"coords":n.shapeInfo.logicalShape.map((e,n)=>`coords.${f[n+p]}`).join(", ");return`\n    float ${o}() {\n      ${c} coords = getOutputCoords();\n      ${h}\n      return get${a}(${x});\n    }\n  `}(n,t));return a}(n,t,a)).join("\n"),u=t.texShape,l=pr(),c=function(e){return`\n    float sampleTexture(sampler2D textureSampler, vec2 uv) {\n      return ${e.texture2D}(textureSampler, uv).r;\n    }\n  `}(l);let d,p,h=function(e){return`${e.version}\n    precision highp float;\n    precision highp int;\n    precision highp sampler2D;\n    ${e.varyingFs} vec2 resultUV;\n    ${e.defineOutput}\n    const vec2 halfCR = vec2(0.5, 0.5);\n\n    struct ivec5\n    {\n      int x;\n      int y;\n      int z;\n      int w;\n      int u;\n    };\n\n    struct ivec6\n    {\n      int x;\n      int y;\n      int z;\n      int w;\n      int u;\n      int v;\n    };\n\n    uniform float NAN;\n    ${e.defineSpecialNaN}\n    ${e.defineSpecialInf}\n    ${e.defineRound}\n\n    int imod(int x, int y) {\n      return x - y * (x / y);\n    }\n\n    int idiv(int a, int b, float sign) {\n      int res = a / b;\n      int mod = imod(a, b);\n      if (sign < 0. && mod != 0) {\n        res -= 1;\n      }\n      return res;\n    }\n\n    //Based on the work of Dave Hoskins\n    //https://www.shadertoy.com/view/4djSRW\n    #define HASHSCALE1 443.8975\n    float random(float seed){\n      vec2 p = resultUV * seed;\n      vec3 p3  = fract(vec3(p.xyx) * HASHSCALE1);\n      p3 += dot(p3, p3.yzx + 19.19);\n      return fract((p3.x + p3.y) * p3.z);\n    }\n\n    ${Yr}\n    ${Qr}\n    ${Zr}\n  `}(l);return t.isPacked?(d=function(n,t){switch(n.length){case 0:return ea();case 1:return function(e,n){const t=[Math.ceil(n[0]/2),Math.ceil(n[1]/2)];if(1===t[0])return`\n      int getOutputCoords() {\n        return 2 * int(resultUV.x * ${t[1]}.0);\n      }\n    `;if(1===t[1])return`\n      int getOutputCoords() {\n        return 2 * int(resultUV.y * ${t[0]}.0);\n      }\n    `;return`\n    int getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${t[0]}, ${t[1]}));\n      return 2 * (resTexRC.x * ${t[1]} + resTexRC.y);\n    }\n  `}(0,t);case 2:return function(n,t){const r=[Math.ceil(t[0]/2),Math.ceil(t[1]/2)];if(e.arraysEqual(n,t))return`\n      ivec2 getOutputCoords() {\n        return 2 * ivec2(resultUV.yx * vec2(${r[0]}, ${r[1]}));\n      }\n    `;const a=Math.ceil(n[1]/2);return`\n    ivec2 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${r[0]}, ${r[1]}));\n\n      int index = resTexRC.x * ${r[1]} + resTexRC.y;\n      int r = 2 * (index / ${a});\n      int c = imod(index, ${a}) * 2;\n\n      return ivec2(r, c);\n    }\n  `}(n,t);case 3:return function(e,n){const t=[Math.ceil(n[0]/2),Math.ceil(n[1]/2)],r=Math.ceil(e[2]/2),a=r*Math.ceil(e[1]/2);return`\n    ivec3 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${t[0]}, ${t[1]}));\n      int index = resTexRC.x * ${t[1]} + resTexRC.y;\n\n      int b = index / ${a};\n      index -= b * ${a};\n\n      int r = 2 * (index / ${r});\n      int c = imod(index, ${r}) * 2;\n\n      return ivec3(b, r, c);\n    }\n  `}(n,t);default:return function(e,n){const t=[Math.ceil(n[0]/2),Math.ceil(n[1]/2)],r=Math.ceil(e[e.length-1]/2),a=r*Math.ceil(e[e.length-2]/2);let o=a,s="",i="b, r, c";for(let n=2;n<e.length-1;n++)o*=e[e.length-n-1],s=`\n      int b${n} = index / ${o};\n      index -= b${n} * ${o};\n    `+s,i=`b${n}, `+i;return`\n    ivec${e.length} getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${t[0]}, ${t[1]}));\n      int index = resTexRC.x * ${t[1]} + resTexRC.y;\n\n      ${s}\n\n      int b = index / ${a};\n      index -= b * ${a};\n\n      int r = 2 * (index / ${r});\n      int c = imod(index, ${r}) * 2;\n\n      return ivec${e.length}(${i});\n    }\n  `}(n,t)}}(t.logicalShape,u),p=function(e){return`\n    void setOutput(vec4 val) {\n      ${e.output} = val;\n    }\n  `}(l)):(d=function(n,t){switch(n.length){case 0:return ea();case 1:return function(e,n){if(1===n[0])return`\n      int getOutputCoords() {\n        return int(resultUV.x * ${n[1]}.0);\n      }\n    `;if(1===n[1])return`\n      int getOutputCoords() {\n        return int(resultUV.y * ${n[0]}.0);\n      }\n    `;return`\n    int getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${n[0]}, ${n[1]}));\n      return resTexRC.x * ${n[1]} + resTexRC.y;\n    }\n  `}(0,t);case 2:return function(n,t){if(e.arraysEqual(n,t))return`\n      ivec2 getOutputCoords() {\n        return ivec2(resultUV.yx * vec2(${t[0]}, ${t[1]}));\n      }\n    `;if(1===n[1])return`\n      ivec2 getOutputCoords() {\n        ivec2 resTexRC = ivec2(resultUV.yx *\n                               vec2(${t[0]}, ${t[1]}));\n        int index = resTexRC.x * ${t[1]} + resTexRC.y;\n        return ivec2(index, 0);\n      }\n    `;if(1===n[0])return`\n      ivec2 getOutputCoords() {\n        ivec2 resTexRC = ivec2(resultUV.yx *\n                               vec2(${t[0]}, ${t[1]}));\n        int index = resTexRC.x * ${t[1]} + resTexRC.y;\n        return ivec2(0, index);\n      }\n    `;return`\n    ivec2 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${t[0]}, ${t[1]}));\n      int index = resTexRC.x * ${t[1]} + resTexRC.y;\n      int r = index / ${n[1]};\n      int c = index - r * ${n[1]};\n      return ivec2(r, c);\n    }\n  `}(n,t);case 3:return function(e,n){const t=hr(["r","c","d"],e);return`\n    ivec3 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${n[0]}, ${n[1]}));\n      int index = resTexRC.x * ${n[1]} + resTexRC.y;\n      ${t}\n      return ivec3(r, c, d);\n    }\n  `}(n,t);case 4:return function(e,n){const t=hr(["r","c","d","d2"],e);return`\n    ivec4 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n        vec2(${n[0]}, ${n[1]}));\n      int index = resTexRC.x * ${n[1]} + resTexRC.y;\n      ${t}\n      return ivec4(r, c, d, d2);\n    }\n  `}(n,t);case 5:return function(e,n){const t=hr(["r","c","d","d2","d3"],e);return`\n    ivec5 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx * vec2(${n[0]},\n                             ${n[1]}));\n\n      int index = resTexRC.x * ${n[1]} + resTexRC.y;\n\n      ${t}\n\n      ivec5 outShape = ivec5(r, c, d, d2, d3);\n      return outShape;\n    }\n  `}(n,t);case 6:return function(e,n){const t=hr(["r","c","d","d2","d3","d4"],e);return`\n    ivec6 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n        vec2(${n[0]}, ${n[1]}));\n      int index = resTexRC.x * ${n[1]} + resTexRC.y;\n\n      ${t}\n\n      ivec6 result = ivec6(r, c, d, d2, d3, d4);\n      return result;\n    }\n  `}(n,t);default:throw new Error(`${n.length}-D output sampling is not yet supported`)}}(t.logicalShape,u),p=function(e){return`\n    void setOutput(float val) {\n      ${e.output} = vec4(val, 0, 0, 0);\n    }\n  `}(l)),a&&(h+=Jr),[h,c,p,s,d,i,r].join("\n")}function Kr(n){const t=n.shapeInfo.logicalShape;switch(t.length){case 0:return function(e){const n=e.name,t="get"+n.charAt(0).toUpperCase()+n.slice(1);if(e.shapeInfo.isUniform)return`float ${t}() {return ${n};}`;const[r,a]=e.shapeInfo.texShape;if(1===r&&1===a)return`\n      float ${t}() {\n        return sampleTexture(${n}, halfCR);\n      }\n    `;const[o,s]=e.shapeInfo.texShape,i=na(n);return`\n    float ${t}() {\n      vec2 uv = uvFromFlat(${o}, ${s}, ${i});\n      return sampleTexture(${n}, uv);\n    }\n  `}(n);case 1:return function(e){const n=e.name,t="get"+n.charAt(0).toUpperCase()+n.slice(1);if(e.shapeInfo.isUniform)return`\n      float ${t}(int index) {\n        ${ta(e)}\n      }\n    `;const r=e.shapeInfo.texShape,a=r[0],o=r[1];if(1===o&&1===a)return`\n      float ${t}(int index) {\n        return sampleTexture(${n}, halfCR);\n      }\n    `;const s=na(n);if(1===o)return`\n      float ${t}(int index) {\n        vec2 uv = vec2(0.5, (float(index + ${s}) + 0.5) / ${a}.0);\n        return sampleTexture(${n}, uv);\n      }\n    `;if(1===a)return`\n      float ${t}(int index) {\n        vec2 uv = vec2((float(index + ${s}) + 0.5) / ${o}.0, 0.5);\n        return sampleTexture(${n}, uv);\n      }\n    `;return`\n    float ${t}(int index) {\n      vec2 uv = uvFromFlat(${a}, ${o}, index + ${s});\n      return sampleTexture(${n}, uv);\n    }\n  `}(n);case 2:return function(n){const t=n.shapeInfo.logicalShape,r=n.name,a="get"+r.charAt(0).toUpperCase()+r.slice(1),o=n.shapeInfo.texShape;if(null!=o&&e.arraysEqual(t,o)){const e=o[0],n=o[1];return`\n    float ${a}(int row, int col) {\n      vec2 uv = (vec2(col, row) + halfCR) / vec2(${n}.0, ${e}.0);\n      return sampleTexture(${r}, uv);\n    }\n  `}const{newShape:s,keptDims:i}=e.squeezeShape(t),u=s;if(u.length<t.length){const e=aa(n,u),t=["row","col"];return`\n      ${Kr(e)}\n      float ${a}(int row, int col) {\n        return ${a}(${oa(t,i)});\n      }\n    `}if(n.shapeInfo.isUniform)return`\n      float ${a}(int row, int col) {\n        int index = round(dot(vec2(row, col), vec2(${t[1]}, 1)));\n        ${ta(n)}\n      }\n    `;const l=o[0],c=o[1],d=na(r);if(1===c)return`\n    float ${a}(int row, int col) {\n      float index = dot(vec3(row, col, ${d}), vec3(${t[1]}, 1, 1));\n      vec2 uv = vec2(0.5, (index + 0.5) / ${l}.0);\n      return sampleTexture(${r}, uv);\n    }\n  `;if(1===l)return`\n    float ${a}(int row, int col) {\n      float index = dot(vec3(row, col, ${d}), vec3(${t[1]}, 1, 1));\n      vec2 uv = vec2((index + 0.5) / ${c}.0, 0.5);\n      return sampleTexture(${r}, uv);\n    }\n  `;return`\n  float ${a}(int row, int col) {\n    // Explicitly use integer operations as dot() only works on floats.\n    int index = row * ${t[1]} + col + ${d};\n    vec2 uv = uvFromFlat(${l}, ${c}, index);\n    return sampleTexture(${r}, uv);\n  }\n`}(n);case 3:return function(n){const t=n.shapeInfo.logicalShape,r=n.name,a="get"+r.charAt(0).toUpperCase()+r.slice(1),o=t[1]*t[2],s=t[2],{newShape:i,keptDims:u}=e.squeezeShape(t),l=i;if(l.length<t.length){const e=aa(n,l),t=["row","col","depth"];return`\n        ${Kr(e)}\n        float ${a}(int row, int col, int depth) {\n          return ${a}(${oa(t,u)});\n        }\n      `}if(n.shapeInfo.isUniform)return`\n      float ${a}(int row, int col, int depth) {\n        int index = round(dot(vec3(row, col, depth),\n                          vec3(${o}, ${s}, 1)));\n        ${ta(n)}\n      }\n    `;const c=n.shapeInfo.texShape,d=c[0],p=c[1],h=n.shapeInfo.flatOffset;if(p===o&&null==h)return`\n        float ${a}(int row, int col, int depth) {\n          float texR = float(row);\n          float texC = dot(vec2(col, depth), vec2(${s}, 1));\n          vec2 uv = (vec2(texC, texR) + halfCR) /\n                     vec2(${p}.0, ${d}.0);\n          return sampleTexture(${r}, uv);\n        }\n      `;if(p===s&&null==h)return`\n    float ${a}(int row, int col, int depth) {\n      float texR = dot(vec2(row, col), vec2(${t[1]}, 1));\n      float texC = float(depth);\n      vec2 uv = (vec2(texC, texR) + halfCR) / vec2(${p}.0, ${d}.0);\n      return sampleTexture(${r}, uv);\n    }\n  `;const f=na(r);return`\n      float ${a}(int row, int col, int depth) {\n        // Explicitly use integer operations as dot() only works on floats.\n        int index = row * ${o} + col * ${s} + depth + ${f};\n        vec2 uv = uvFromFlat(${d}, ${p}, index);\n        return sampleTexture(${r}, uv);\n      }\n  `}(n);case 4:return function(n){const t=n.shapeInfo.logicalShape,r=n.name,a="get"+r.charAt(0).toUpperCase()+r.slice(1),o=t[3],s=t[2]*o,i=t[1]*s,{newShape:u,keptDims:l}=e.squeezeShape(t);if(u.length<t.length){const e=aa(n,u),t=["row","col","depth","depth2"];return`\n      ${Kr(e)}\n      float ${a}(int row, int col, int depth, int depth2) {\n        return ${a}(${oa(t,l)});\n      }\n    `}if(n.shapeInfo.isUniform)return`\n      float ${a}(int row, int col, int depth, int depth2) {\n        int index = round(dot(vec4(row, col, depth, depth2),\n                          vec4(${i}, ${s}, ${o}, 1)));\n        ${ta(n)}\n      }\n    `;const c=n.shapeInfo.flatOffset,d=n.shapeInfo.texShape,p=d[0],h=d[1];if(h===i&&null==c)return`\n      float ${a}(int row, int col, int depth, int depth2) {\n        float texR = float(row);\n        float texC =\n            dot(vec3(col, depth, depth2),\n                vec3(${s}, ${o}, 1));\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                   vec2(${h}.0, ${p}.0);\n        return sampleTexture(${r}, uv);\n      }\n    `;if(h===o&&null==c)return`\n      float ${a}(int row, int col, int depth, int depth2) {\n        float texR = dot(vec3(row, col, depth),\n                         vec3(${t[1]*t[2]}, ${t[2]}, 1));\n        float texC = float(depth2);\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                  vec2(${h}.0, ${p}.0);\n        return sampleTexture(${r}, uv);\n      }\n    `;const f=na(r);return`\n    float ${a}(int row, int col, int depth, int depth2) {\n      // Explicitly use integer operations as dot() only works on floats.\n      int index = row * ${i} + col * ${s} +\n          depth * ${o} + depth2;\n      vec2 uv = uvFromFlat(${p}, ${h}, index + ${f});\n      return sampleTexture(${r}, uv);\n    }\n  `}(n);case 5:return function(n){const t=n.shapeInfo.logicalShape,r=n.name,a="get"+r.charAt(0).toUpperCase()+r.slice(1),o=t[4],s=t[3]*o,i=t[2]*s,u=t[1]*i,{newShape:l,keptDims:c}=e.squeezeShape(t);if(l.length<t.length){const e=aa(n,l),t=["row","col","depth","depth2","depth3"];return`\n      ${Kr(e)}\n      float ${a}(int row, int col, int depth, int depth2, int depth3) {\n        return ${a}(${oa(t,c)});\n      }\n    `}if(n.shapeInfo.isUniform)return`\n      float ${a}(int row, int col, int depth, int depth2, int depth3) {\n        float index = dot(\n          vec4(row, col, depth, depth2),\n          vec4(${u}, ${i}, ${s}, ${o})) +\n          depth3;\n        ${ta(n)}\n      }\n    `;const d=n.shapeInfo.flatOffset,p=n.shapeInfo.texShape,h=p[0],f=p[1];if(f===u&&null==d)return`\n      float ${a}(int row, int col, int depth, int depth2, int depth3) {\n        int texR = row;\n        float texC = dot(vec4(col, depth, depth2, depth3),\n                         vec4(${i}, ${s}, ${o}, 1));\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                   vec2(${f}.0, ${h}.0);\n        return sampleTexture(${r}, uv);\n      }\n    `;if(f===o&&null==d)return`\n      float ${a}(int row, int col, int depth, int depth2, int depth3) {\n        float texR = dot(\n          vec4(row, col, depth, depth2),\n          vec4(${t[1]*t[2]*t[3]},\n               ${t[2]*t[3]}, ${t[3]}, 1));\n        int texC = depth3;\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                  vec2(${f}.0, ${h}.0);\n        return sampleTexture(${r}, uv);\n      }\n    `;const x=na(r);return`\n    float ${a}(int row, int col, int depth, int depth2, int depth3) {\n      // Explicitly use integer operations as dot() only works on floats.\n      int index = row * ${u} + col * ${i} + depth * ${s} +\n          depth2 * ${o} + depth3 + ${x};\n      vec2 uv = uvFromFlat(${h}, ${f}, index);\n      return sampleTexture(${r}, uv);\n    }\n  `}(n);case 6:return function(n){const t=n.shapeInfo.logicalShape,r=n.name,a="get"+r.charAt(0).toUpperCase()+r.slice(1),{newShape:o,keptDims:s}=e.squeezeShape(t);if(o.length<t.length){const e=aa(n,o),t=["row","col","depth","depth2","depth3","depth4"];return`\n      ${Kr(e)}\n      float ${a}(int row, int col, int depth,\n                    int depth2, int depth3, int depth4) {\n        return ${a}(${oa(t,s)});\n      }\n    `}const i=t[5],u=t[4]*i,l=t[3]*u,c=t[2]*l,d=t[1]*c;if(n.shapeInfo.isUniform)return`\n      float ${a}(int row, int col, int depth,\n                  int depth2, int depth3, int depth4) {\n        int index = round(dot(\n          vec4(row, col, depth, depth2),\n          vec4(${d}, ${c}, ${l}, ${u})) +\n          dot(\n            vec2(depth3, depth4),\n            vec2(${i}, 1)));\n        ${ta(n)}\n      }\n    `;const p=n.shapeInfo.flatOffset,h=n.shapeInfo.texShape,f=h[0],x=h[1];if(x===d&&null==p)return`\n      float ${a}(int row, int col, int depth,\n                    int depth2, int depth3, int depth4) {\n        int texR = row;\n        float texC = dot(vec4(col, depth, depth2, depth3),\n          vec4(${c}, ${l}, ${u}, ${i})) +\n               float(depth4);\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                   vec2(${x}.0, ${f}.0);\n        return sampleTexture(${r}, uv);\n      }\n    `;if(x===i&&null==p)return`\n      float ${a}(int row, int col, int depth,\n                    int depth2, int depth3, int depth4) {\n        float texR = dot(vec4(row, col, depth, depth2),\n          vec4(${t[1]*t[2]*t[3]*t[4]},\n               ${t[2]*t[3]*t[4]},\n               ${t[3]*t[4]},\n               ${t[4]})) + float(depth3);\n        int texC = depth4;\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                  vec2(${x}.0, ${f}.0);\n        return sampleTexture(${r}, uv);\n      }\n    `;const g=na(r);return`\n    float ${a}(int row, int col, int depth,\n                  int depth2, int depth3, int depth4) {\n      // Explicitly use integer operations as dot() only works on floats.\n      int index = row * ${d} + col * ${c} + depth * ${l} +\n          depth2 * ${u} + depth3 * ${i} + depth4 + ${g};\n      vec2 uv = uvFromFlat(${f}, ${x}, index);\n      return sampleTexture(${r}, uv);\n    }\n  `}(n);default:throw new Error(`${t.length}-D input sampling`+" is not yet supported")}}function qr(n){switch(n.shapeInfo.logicalShape.length){case 0:return function(e){const n=e.name,t="get"+n.charAt(0).toUpperCase()+n.slice(1),r=pr();return`\n    vec4 ${t}() {\n      return ${r.texture2D}(${n}, halfCR);\n    }\n  `}(n);case 1:return function(e){const n=e.name,t="get"+n.charAt(0).toUpperCase()+n.slice(1),r=e.shapeInfo.texShape,a=[Math.ceil(r[0]/2),Math.ceil(r[1]/2)],o=pr();return`\n    vec4 ${t}(int index) {\n      vec2 uv = packedUVfrom1D(\n        ${a[0]}, ${a[1]}, index);\n      return ${o.texture2D}(${n}, uv);\n    }\n  `}(n);case 2:return function(n){const t=n.shapeInfo.logicalShape,r=n.name,a="get"+r.charAt(0).toUpperCase()+r.slice(1),o=n.shapeInfo.texShape,s=o[0],i=o[1],u=pr();if(null!=o&&e.arraysEqual(t,o))return`\n      vec4 ${a}(int row, int col) {\n        vec2 uv = (vec2(col, row) + halfCR) / vec2(${i}.0, ${s}.0);\n\n        return ${u.texture2D}(${r}, uv);\n      }\n    `;const l=[Math.ceil(o[0]/2),Math.ceil(o[1]/2)],c=Math.ceil(t[1]/2);return`\n    vec4 ${a}(int row, int col) {\n      vec2 uv = packedUVfrom2D(${c}, ${l[0]}, ${l[1]}, row, col);\n      return ${u.texture2D}(${r}, uv);\n    }\n  `}(n);case 3:return function(e){const n=e.shapeInfo.logicalShape,t=e.name,r="get"+t.charAt(0).toUpperCase()+t.slice(1),a=e.shapeInfo.texShape,o=[Math.ceil(a[0]/2),Math.ceil(a[1]/2)];if(1===n[0]){const t=n.slice(1),a=[1,2],o=aa(e,t),s=["b","row","col"];return`\n        ${qr(o)}\n        vec4 ${r}(int b, int row, int col) {\n          return ${r}(${oa(s,a)});\n        }\n      `}const s=o[0],i=o[1],u=Math.ceil(n[2]/2),l=u*Math.ceil(n[1]/2),c=pr();return`\n    vec4 ${r}(int b, int row, int col) {\n      vec2 uv = packedUVfrom3D(\n        ${s}, ${i}, ${l}, ${u}, b, row, col);\n      return ${c.texture2D}(${t}, uv);\n    }\n  `}(n);default:return function(e){const n=e.shapeInfo.logicalShape,t=n.length,r=e.name,a="get"+r.charAt(0).toUpperCase()+r.slice(1),o=e.shapeInfo.texShape,s=[Math.ceil(o[0]/2),Math.ceil(o[1]/2)],i=s[0],u=s[1],l=Math.ceil(n[t-1]/2);let c=l*Math.ceil(n[t-2]/2),d="int b, int row, int col",p=`b * ${c} + (row / 2) * ${l} + (col / 2)`;for(let e=2;e<t-1;e++)d=`int b${e}, `+d,c*=n[t-e-1],p=`b${e} * ${c} + `+p;const h=pr();return`\n    vec4 ${a}(${d}) {\n      int index = ${p};\n      int texR = index / ${u};\n      int texC = index - texR * ${u};\n      vec2 uv = (vec2(texC, texR) + halfCR) / vec2(${u}, ${i});\n      return ${h.texture2D}(${r}, uv);\n    }\n  `}(n)}}const Yr="\nvec2 uvFromFlat(int texNumR, int texNumC, int index) {\n  int texR = index / texNumC;\n  int texC = index - texR * texNumC;\n  return (vec2(texC, texR) + halfCR) / vec2(texNumC, texNumR);\n}\nvec2 packedUVfrom1D(int texNumR, int texNumC, int index) {\n  int texelIndex = index / 2;\n  int texR = texelIndex / texNumC;\n  int texC = texelIndex - texR * texNumC;\n  return (vec2(texC, texR) + halfCR) / vec2(texNumC, texNumR);\n}\n",Qr="\nvec2 packedUVfrom2D(int texelsInLogicalRow, int texNumR,\n  int texNumC, int row, int col) {\n  int texelIndex = (row / 2) * texelsInLogicalRow + (col / 2);\n  int texR = texelIndex / texNumC;\n  int texC = texelIndex - texR * texNumC;\n  return (vec2(texC, texR) + halfCR) / vec2(texNumC, texNumR);\n}\n",Zr="\nvec2 packedUVfrom3D(int texNumR, int texNumC,\n    int texelsInBatch, int texelsInLogicalRow, int b,\n    int row, int col) {\n  int index = b * texelsInBatch + (row / 2) * texelsInLogicalRow + (col / 2);\n  int texR = index / texNumC;\n  int texC = index - texR * texNumC;\n  return (vec2(texC, texR) + halfCR) / vec2(texNumC, texNumR);\n}\n",Jr="\n  float getChannel(vec4 frag, vec2 innerDims) {\n    vec2 modCoord = mod(innerDims, 2.);\n    return modCoord.x == 0. ?\n      (modCoord.y == 0. ? frag.r : frag.g) :\n      (modCoord.y == 0. ? frag.b : frag.a);\n  }\n  float getChannel(vec4 frag, int dim) {\n    float modCoord = mod(float(dim), 2.);\n    return modCoord == 0. ? frag.r : frag.g;\n  }\n";function ea(){return"\n    int getOutputCoords() {\n      return 0;\n    }\n  "}function na(e){return`offset${e}`}function ta(n){const t=n.name,r=e.sizeFromShape(n.shapeInfo.logicalShape);return r<2?`return ${t};`:`\n    for (int i = 0; i < ${r}; i++) {\n      if (i == index) {\n        return ${t}[i];\n      }\n    }\n  `}function ra(e){if(e<=1)return"int";if(2===e)return"ivec2";if(3===e)return"ivec3";if(4===e)return"ivec4";if(5===e)return"ivec5";if(6===e)return"ivec6";throw Error(`GPU for rank ${e} is not yet supported`)}function aa(e,n){const t=JSON.parse(JSON.stringify(e));return t.shapeInfo.logicalShape=n,t}function oa(e,n){return n.map(n=>e[n]).join(", ")}function sa(n,t){if(n.length!==t.length)throw Error(`Binary was compiled with ${n.length} inputs, but `+`was executed with ${t.length} inputs`);n.forEach((n,r)=>{const a=n.logicalShape,o=t[r],s=o.shape;if(!e.arraysEqual(a,s))throw Error("Binary was compiled with different shapes than "+`the current args. Shapes ${a} and ${s} must match`);if(n.isUniform&&o.isUniform)return;const i=n.texShape,u=o.isUniform?null:o.texData.texShape;if(!e.arraysEqual(i,u))throw Error("Binary was compiled with different texture shapes than the"+` current args. Shape ${i} and ${u} must match`)})}function ia(n){return(t,a,o,s,i)=>{const u=r.assertAndGetBroadcastShape(t,a),l=u.length,c=e.computeStrides(u),d=e.sizeFromShape(u),p=e.getTypedArrayFromDType(i,d),h=t.length,f=a.length,x=e.computeStrides(t),g=e.computeStrides(a),m=r.getBroadcastDims(t,u),b=r.getBroadcastDims(a,u);if(m.length+b.length===0)for(let e=0;e<p.length;++e)p[e]=n(o[e%o.length],s[e%s.length]);else for(let t=0;t<p.length;++t){const r=e.indexToLoc(t,l,c),a=r.slice(-h);m.forEach(e=>a[e]=0);const i=e.locToIndex(a,h,x),u=r.slice(-f);b.forEach(e=>u[e]=0);const d=e.locToIndex(u,f,g);p[t]=n(o[i],s[d])}return[p,u]}}const ua=ia((e,n)=>e+n);function la(n){return(t,r,a)=>{const o=e.getTypedArrayFromDType(r,t.length);for(let e=0;e<t.length;++e)o[e]=n(t[e],a);return o}}const ca=la(e=>Math.ceil(e));const da=la(e=>Math.exp(e)),pa=la(e=>Math.expm1(e)),ha=la(e=>Math.floor(e));const fa=ia((e,n)=>e>n?1:0),xa=ia((e,n)=>e<n?1:0);const ga=la(e=>Math.log(e));const ma=ia((e,n)=>Math.max(e,n)),ba=ia((e,n)=>Math.min(e,n)),Ca=ia((e,n)=>e*n);const va=ia((e,n)=>e!==n?1:0);const $a=la(e=>1/Math.sqrt(e));const Ia=ia((e,n)=>{const t=e-n;return t*t});const Ra=ia((e,n)=>e-n);var ya=Object.freeze({__proto__:null,simpleAbsImpl:function(e){const n=new Float32Array(e.length);for(let t=0;t<e.length;++t)n[t]=Math.abs(e[t]);return n},addImpl:ua,bincountImpl:function(n,t,r,a,o){const s=e.sizeFromShape(a),i=e.makeZerosTypedArray(o,r);for(let e=0;e<n.length;e++){const r=n[e];if(r<0)throw new Error("Input x must be non-negative!");r>=o||(i[r]+=s>0?t[e]:1)}return i},bincountReduceImpl:function(e,n,t,r=!1){const o=e.shape[0],s=e.shape[1],i=a([o,t],n.dtype);for(let a=0;a<o;a++)for(let o=0;o<s;o++){const s=e.get(a,o);if(s<0)throw new Error("Input x must be non-negative!");s>=t||(r?i.set(1,a,s):n.size>0?i.set(i.get(a,s)+n.get(a,o),a,s):i.set(i.get(a,s)+1,a,s))}return i},ceilImpl:ca,concatImpl:function(n,t,a,o){const s=e.getArrayFromDType(a,e.sizeFromShape(t));if(o&&"string"!==a){let t=0;n.forEach(n=>{const r=e.sizeFromShape(n.shape);s.set(n.vals,t),t+=r})}else{let e=0;n.forEach(n=>{const o="string"===a?r.fromUint8ToStringArray(n.vals):n.vals;let i=0;for(let r=0;r<n.shape[0];++r){const a=r*t[1]+e;for(let e=0;e<n.shape[1];++e)s[a+e]=o[i++]}e+=n.shape[1]})}return s},expImpl:da,expm1Impl:pa,floorImpl:ha,gatherV2Impl:function(e,n,t){const r=a(t,e.dtype);for(let t=0;t<r.size;++t){const a=r.indexToLoc(t).slice(),o=a[0],s=a[2],i=n.locToIndex([o,s]);a[2]=n.values[i];const u=e.locToIndex(a);r.values[t]=e.values[u]}return r},greaterImpl:fa,lessImpl:xa,linSpaceImpl:function(n,t,r){const a=(t-n)/(r-1),o=e.makeZerosTypedArray(r,"float32");o[0]=n;for(let e=1;e<o.length;e++)o[e]=o[e-1]+a;return o},logImpl:ga,maxImpl:function(n,t,r,a){const o=e.getTypedArrayFromDType(a,e.sizeFromShape(r));for(let e=0;e<o.length;++e){const r=e*t;let a=n[r];for(let e=0;e<t;++e){const t=n[r+e];t>a&&(a=t)}o[e]=a}return o},maximumImpl:ma,minimumImpl:ba,multiplyImpl:Ca,negImpl:function(n,t,r){const a=e.createScalarValue(-1,r);return Ca([],t,a,n,r)},notEqualImpl:va,prodImpl:function(n,t,a,s){const[i,u]=r.computeOutAndReduceShapes(n,s),l=o(t,"int32"),c=e.makeZerosTypedArray(e.sizeFromShape(i),l),d=e.sizeFromShape(u);for(let e=0;e<c.length;++e){const n=e*d;let t=1;for(let e=0;e<d;++e)t*=a[n+e];c[e]=t}return{outVals:c,outShape:i,outDtype:l}},rangeImpl:function(n,t,r,a){if(n===t||n<t&&r<0||t<n&&r>1)return e.makeZerosTypedArray(0,a);const o=Math.abs(Math.ceil((t-n)/r)),s=e.makeZerosTypedArray(o,a);t<n&&1===r&&(r=-1),s[0]=n;for(let e=1;e<s.length;e++)s[e]=s[e-1]+r;return s},rsqrtImpl:$a,sliceImpl:function(n,t,o,i,u){const l=s.isSliceContinous(i,t,o),c=e.sizeFromShape(o),d=e.computeStrides(i);if(l){const e=s.computeFlatOffset(t,d);return"string"===u?n.slice(e,e+c):n.subarray(e,e+c)}const p="string"===u?r.fromUint8ToStringArray(n):n,h=a(i,u,p),f=a(o,u);for(let e=0;e<f.size;++e){const n=f.indexToLoc(e),r=n.map((e,n)=>e+t[n]);f.set(h.get(...r),...n)}return"string"===u?r.fromStringArrayToUint8(f.values):f.values},squaredDifferenceImpl:Ia,stridedSliceImpl:function(e,n,t,r){const o=a(e,n.dtype);for(let e=0;e<o.size;e++){const a=o.indexToLoc(e),s=new Array(a.length);for(let e=0;e<s.length;e++)s[e]=a[e]*t[e]+r[e];o.set(n.get(...s),...a)}return o},subImpl:Ra,tileImpl:function(e,n){const t=new Array(e.rank);for(let r=0;r<t.length;r++)t[r]=e.shape[r]*n[r];const r=a(t,e.dtype);for(let n=0;n<r.values.length;++n){const t=r.indexToLoc(n),a=new Array(e.rank);for(let n=0;n<a.length;n++)a[n]=t[n]%e.shape[n];const o=e.locToIndex(a);r.values[n]=e.values[o]}return r},topKImpl:function(n,t,r,o,s){const i=t[t.length-1],[u,l]=[n.length/i,i],c=e.getTypedArrayFromDType(r,u*o),d=e.getTypedArrayFromDType("int32",u*o);for(let e=0;e<u;e++){const t=e*l,r=n.subarray(t,t+l),a=[];for(let e=0;e<r.length;e++)a.push({value:r[e],index:e});a.sort((e,n)=>n.value-e.value);const s=e*o,i=c.subarray(s,s+o),u=d.subarray(s,s+o);for(let e=0;e<o;e++)i[e]=a[e].value,u[e]=a[e].index}const p=t.slice();return p[p.length-1]=o,[a(p,r,c),a(p,"int32",d)]},transposeImpl:function(n,t,r,a,o){const s=t.length,i=e.sizeFromShape(t),u=e.computeStrides(t),l=e.computeStrides(o),c=e.getTypedArrayFromDType(r,e.sizeFromShape(o));for(let t=0;t<i;++t){const r=e.indexToLoc(t,s,u),o=new Array(r.length);for(let e=0;e<o.length;e++)o[e]=r[a[e]];c[e.locToIndex(o,s,l)]=n[t]}return c},uniqueImpl:function(n,t,r,a){const o=e.parseAxisParam(t,r)[0],s=[1,r[0],1];for(let e=0;e<o;e++)s[0]*=r[e];s[1]=r[o];for(let e=o+1;e<r.length;e++)s[2]*=r[e];const u={},l=new Int32Array(r[o]),c=new i(s,a,n),d=[],p=1===s[0]&&1===s[2];for(let e=0;e<r[o];e++){let t;if(p)t=n[e].toString();else{const n=[];for(let t=0;t<s[0];t++)for(let r=0;r<s[2];r++)n.push(c.get(t,e,r));t=n.join(",")}if(void 0!==u[t])l[e]=u[t];else{const n=Object.keys(u).length;u[t]=n,l[e]=n,d.push(e)}}const h=s.slice();h[1]=Object.keys(u).length;const f=new i(h,a);d.forEach((e,n)=>{for(let t=0;t<s[0];t++)for(let r=0;r<s[2];r++)f.set(c.get(t,e,r),t,n,r)});const x=r.slice();return x[o]=h[1],{outputValues:f.values,outputShape:x,indices:l}}});const{addImpl:wa,bincountImpl:ka,bincountReduceImpl:Ta,ceilImpl:Ea,concatImpl:Na,expImpl:Sa,expm1Impl:Aa,floorImpl:Fa,gatherV2Impl:Oa,greaterImpl:_a,lessImpl:Da,linSpaceImpl:La,logImpl:Pa,maxImpl:Ba,maximumImpl:Wa,minimumImpl:Va,multiplyImpl:Ma,negImpl:Ga,prodImpl:Ua,rangeImpl:za,rsqrtImpl:Xa,simpleAbsImpl:Ha,sliceImpl:ja,stridedSliceImpl:Ka,subImpl:qa,tileImpl:Ya,topKImpl:Qa,transposeImpl:Za,uniqueImpl:Ja}=ya;function eo(e,n){return["x","y","z","w","u","v"].slice(0,n).map(n=>`${e}.${n}`)}function no(e,n){return 1===n?[e]:eo(e,n)}class to{constructor(e){this.variableNames=["A"],this.packedInputs=!1,this.packedOutput=!0,this.outputShape=e;const n=e.length;if(0===n)this.userCode="\n        void main() {\n          setOutput(vec4(getA(), 0., 0., 0.));\n        }\n      ";else{const t=no("rc",n),r=ra(n),a=function(e,n,t){if(1===e)return`rc > ${n[0]}`;let r="";for(let a=e-2;a<e;a++)r+=`${t[a]} >= ${n[a]}`,a<e-1&&(r+="||");return r}(n,e,t),o=function(e,n,t,r){if(1===e)return"";const a=r.slice(-2);return`\n    int r = ${a[0]};\n    int c = ${a[1]};\n    int rp1 = r + 1;\n    int cp1 = c + 1;\n\n    bool cEdge = cp1 >= ${n};\n    bool rEdge = rp1 >= ${t};\n  `}(n,e[e.length-1],e[e.length-2],t),s=function(e,n){const t=e.length,r=function(e,n){const t=[];for(let r=0;r<=1;r++)for(let a=0;a<=1;a++){let o=`${0===r?"r":"rp1"}, ${0===a?"c":"cp1"}`;for(let t=2;t<e;t++)o=`${n[n.length-1-t]},`+o;t.push(o)}return t}(t,n);if(1===t)return`getA(rc),\n            rc + 1 >= ${e[0]} ? 0. : getA(rc + 1),\n            0, 0`;return`getA(${r[0]}),\n          cEdge ? 0. : getA(${r[1]}),\n          rEdge ? 0. : getA(${r[2]}),\n          rEdge || cEdge ? 0. : getA(${r[3]})`}(e,t);this.userCode=`\n        void main() {\n          ${r} rc = getOutputCoords();\n\n          if(${a}) {\n            setOutput(vec4(0));\n          } else {\n            ${o}\n\n            setOutput(vec4(${s}));\n          }\n        }\n      `}}}class ro{constructor(e,n){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=e;let t="";for(let e=0;e<4;e++){let n="thisRC = rc;";e%2==1&&(n+="thisRC.z += 1;"),e>1&&(n+="thisRC.y += 1;"),t+=`\n        ${n}\n        ${e>0?"if(thisRC.y < rows && thisRC.z < cols){":""}\n          int flatIndex = getFlatIndex(thisRC);\n\n          ivec3 inputRC = inputCoordsFromReshapedOutCoords(flatIndex);\n          vec2 inputRCInnerDims = vec2(float(inputRC.y),float(inputRC.z));\n\n          result[${e}] =\n            getChannel(getA(inputRC.x, inputRC.y, inputRC.z), inputRCInnerDims);\n        ${e>0?"}":""}\n      `}var r;this.userCode=`\n      ${r=n,`\n    ivec3 inputCoordsFromReshapedOutCoords(int index) {\n      ${hr(["r","c","d"],r)}\n      return ivec3(r, c, d);\n    }\n  `}\n      ${fr(e)}\n\n      void main() {\n        ivec3 rc = getOutputCoords();\n\n        vec4 result = vec4(0.);\n\n        ivec3 thisRC;\n        int rows = ${e[1]};\n        int cols = ${e[2]};\n\n        ${t}\n\n        setOutput(result);\n      }\n    `}}class ao{constructor(e){this.gpgpu=e,this.numUsedTextures=0,this.numFreeTextures=0,this._numBytesAllocated=0,this._numBytesFree=0,this.freeTextures={},this.logEnabled=!1,this.usedTextures={}}acquireTexture(e,n,t){const r=so(n,t),a=io(e,r,t);a in this.freeTextures||(this.freeTextures[a]=[]),a in this.usedTextures||(this.usedTextures[a]=[]);const o=oo(e,r,this.gpgpu.gl,this.gpgpu.textureConfig,t);if(this.freeTextures[a].length>0){this.numFreeTextures--,this.numUsedTextures++,this._numBytesFree-=o,this.log();const e=this.freeTextures[a].shift();return this.usedTextures[a].push(e),e}let s;return r===xt.PACKED_2X2_FLOAT32?s=this.gpgpu.createPackedMatrixTexture(e[0],e[1]):r===xt.PACKED_2X2_FLOAT16?s=this.gpgpu.createFloat16PackedMatrixTexture(e[0],e[1]):r===xt.UNPACKED_FLOAT32?s=this.gpgpu.createFloat32MatrixTexture(e[0],e[1]):r===xt.UNPACKED_FLOAT16?s=this.gpgpu.createFloat16MatrixTexture(e[0],e[1]):r===xt.PACKED_4X1_UNSIGNED_BYTE&&(s=this.gpgpu.createUnsignedBytesMatrixTexture(e[0],e[1])),this.usedTextures[a].push(s),this.numUsedTextures++,this._numBytesAllocated+=o,this.log(),s}releaseTexture(e,t,r,a){if(null==this.freeTextures)return;const o=so(r,a),s=io(t,o,a);s in this.freeTextures||(this.freeTextures[s]=[]);const i=oo(t,o,this.gpgpu.gl,this.gpgpu.textureConfig,a),u=n().get("WEBGL_DELETE_TEXTURE_THRESHOLD");-1!==u&&this._numBytesAllocated>u?(this.gpgpu.deleteMatrixTexture(e),this._numBytesAllocated-=i):(this.freeTextures[s].push(e),this.numFreeTextures++,this._numBytesFree+=i),this.numUsedTextures--;const l=this.usedTextures[s],c=l.indexOf(e);if(c<0)throw new Error("Cannot release a texture that was never provided by this texture manager");l.splice(c,1),this.log()}log(){if(!this.logEnabled)return;const e=this.numFreeTextures+this.numUsedTextures;console.log("Free/Used",`${this.numFreeTextures} / ${this.numUsedTextures}`,`(${e})`);const n=this._numBytesFree/this._numBytesAllocated;console.log(`Bytes allocated: ${this._numBytesAllocated}`),console.log(`Bytes unused: ${this._numBytesFree} (${Math.round(100*n)}%)`)}get numBytesAllocated(){return this._numBytesAllocated}get numBytesFree(){return this._numBytesFree}getNumUsedTextures(){return this.numUsedTextures}getNumFreeTextures(){return this.numFreeTextures}dispose(){if(null!=this.freeTextures){for(const e in this.freeTextures)this.freeTextures[e].forEach(e=>{this.gpgpu.deleteMatrixTexture(e)});for(const e in this.usedTextures)this.usedTextures[e].forEach(e=>{this.gpgpu.deleteMatrixTexture(e)});this.freeTextures=null,this.usedTextures=null,this.numUsedTextures=0,this.numFreeTextures=0,this._numBytesAllocated=0,this._numBytesFree=0}}}function oo(e,n,t,r,a){const o=function(e,n){switch(e){case xt.PACKED_2X2_FLOAT32:return Fr(n);case xt.PACKED_2X2_FLOAT16:return _r(n);case xt.UNPACKED_FLOAT32:return kr(n);case xt.UNPACKED_FLOAT16:return Er(n);case xt.PACKED_4X1_UNSIGNED_BYTE:return Sr(n);default:throw new Error(`Unknown physical texture type ${e}`)}}(n,r);let s;if(a){const[n,t]=bt(e[0],e[1]);s=n*t}else{const[n,t]=gt(e[0],e[1]);s=n*t}return s*function(e,n){const t=e;if(n===t.R32F)return 4;if(n===t.R16F)return 2;if(n===t.RGBA32F)return 16;if(n===e.RGBA)return 16;if(n===t.RGBA16F)return 8;throw new Error(`Unknown internal format ${n}`)}(t,o)}function so(e,t){if(e===ft.UPLOAD)return xt.PACKED_2X2_FLOAT32;if(e===ft.RENDER||null==e)return function(e){return n().getBool("WEBGL_RENDER_FLOAT32_ENABLED")?e?xt.PACKED_2X2_FLOAT32:xt.UNPACKED_FLOAT32:e?xt.PACKED_2X2_FLOAT16:xt.UNPACKED_FLOAT16}(t);if(e===ft.DOWNLOAD||e===ft.PIXELS)return xt.PACKED_4X1_UNSIGNED_BYTE;throw new Error(`Unknown logical texture type ${e}`)}function io(e,n,t){return`${e[0]}_${e[1]}_${n}_${t}`}class uo{constructor(e,n){this.variableNames=["A"],this.outputShape=e,this.userCode=`\n      float unaryOperation(float x) {\n        ${n}\n      }\n\n      void main() {\n        float x = getAAtOutCoords();\n        float y = unaryOperation(x);\n\n        setOutput(y);\n      }\n    `}}const lo="if (isnan(x)) return x;",co="return abs(x);",po="return x;";class ho{constructor(e,n){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=e,this.userCode=`\n      vec4 unaryOperation(vec4 x) {\n        ${n}\n      }\n\n      void main() {\n        vec4 x = getAAtOutCoords();\n        vec4 y = unaryOperation(x);\n\n        setOutput(y);\n      }\n    `}}class fo{constructor(e){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!1,this.outputShape=e;const n=e.length,t=no("rc",n),r=ra(n),a=function(e,n){if(1===e)return"rc";let t="";for(let r=0;r<e;r++)t+=n[r],r<e-1&&(t+=",");return t}(n,t),o=t.slice(-2),s=n<=1?"rc":`vec2(${o.join(",")})`;this.userCode=`\n      void main() {\n        ${r} rc = getOutputCoords();\n        vec4 packedInput = getA(${a});\n\n        setOutput(getChannel(packedInput, ${s}));\n      }\n    `}}const xo=u.whereImpl,go={};class mo extends l{constructor(e){if(super(),this.pendingRead=new WeakMap,this.pendingDisposal=new WeakSet,this.dataRefCount=new WeakMap,this.numBytesInGPU=0,this.uploadWaitMs=0,this.downloadWaitMs=0,this.lastGlFlushTime=0,this.warnedAboutMemory=!1,this.warnedAboutCPUBackend=!1,this.pendingDeletes=0,this.disposed=!1,!n().getBool("HAS_WEBGL"))throw new Error("WebGL is not supported on this device");if(null==e){const e=pt(n().getNumber("WEBGL_VERSION"));this.binaryCache=((t=n().getNumber("WEBGL_VERSION"))in go||(go[t]={}),go[t]),this.gpgpu=new Xr(e),this.canvas=e.canvas,this.gpgpuCreatedLocally=!0}else this.gpgpu=e,this.binaryCache={},this.gpgpuCreatedLocally=!1,this.canvas=e.gl.canvas;var t;this.textureManager=new ao(this.gpgpu),this.numMBBeforeWarning=null==n().global.screen?1024:n().global.screen.height*n().global.screen.width*window.devicePixelRatio*600/1024/1024,this.texData=new c(this,d())}nextDataId(){return mo.nextDataId++}numDataIds(){return this.texData.numDataIds()+(this.cpuBackend?this.cpuBackend.numDataIds():0)-this.pendingDeletes}write(e,t,r){if((n().getBool("WEBGL_CHECK_NUMERICAL_PROBLEMS")||n().getBool("DEBUG"))&&this.checkNumericalProblems(e),"complex64"===r&&null!=e)throw new Error("Cannot write to a complex64 dtype. Please use tf.complex(real, imag).");const a={id:this.nextDataId()};return this.texData.set(a,{shape:t,dtype:r,values:e,usage:ft.UPLOAD,refCount:1}),a}refCount(e){if(this.texData.has(e)){return this.texData.get(e).refCount}return 0}incRef(e){this.texData.get(e).refCount++}decRef(e){if(this.texData.has(e)){this.texData.get(e).refCount--}}move(e,t,r,a,o){if(n().getBool("DEBUG")&&this.checkNumericalProblems(t),"complex64"===a)throw new Error("Cannot write to a complex64 dtype. Please use tf.complex(real, imag).");this.texData.set(e,{shape:r,dtype:a,values:t,usage:ft.UPLOAD,refCount:o})}disposeIntermediateTensorInfo(e){this.disposeData(e.dataId)}readSync(n){const t=this.texData.get(n),{values:a,dtype:o,complexTensorInfos:s,slice:i,shape:u,isPacked:l}=t;if(null!=i){let e;e=l?new ho(u,po):new uo(u,po);const t=this.runWebGLProgram(e,[{dataId:n,shape:u,dtype:o}],o),r=this.readSync(t.dataId);return this.disposeIntermediateTensorInfo(t),r}if(null!=a)return this.convertAndCacheOnCPU(n);if("string"===o)return a;const c=null!=this.activeTimers;let d,p;if(c&&(d=e.now()),"complex64"===o){const e=this.readSync(s.real.dataId),n=this.readSync(s.imag.dataId);p=r.mergeRealAndImagArrays(e,n)}else p=this.getValuesFromTexture(n);return c&&(this.downloadWaitMs+=e.now()-d),this.convertAndCacheOnCPU(n,p)}async read(t){if(this.pendingRead.has(t)){const e=this.pendingRead.get(t);return new Promise(n=>e.push(n))}const a=this.texData.get(t),{values:o,shape:s,slice:i,dtype:u,complexTensorInfos:l,isPacked:c}=a;if(null!=i){let e;e=c?new ho(s,po):new uo(s,po);const n=this.runWebGLProgram(e,[{dataId:t,shape:s,dtype:u}],u),r=this.read(n.dataId);return this.disposeIntermediateTensorInfo(n),r}if(null!=o)return this.convertAndCacheOnCPU(t);if(!n().getBool("WEBGL_DOWNLOAD_FLOAT_ENABLED")&&2===n().getNumber("WEBGL_VERSION"))throw new Error("tensor.data() with WEBGL_DOWNLOAD_FLOAT_ENABLED=false and WEBGL_VERSION=2 not yet supported.");let p,h,f=null;if("complex64"!==u&&n().get("WEBGL_BUFFER_SUPPORTED")){p=this.decode(t);const e=this.texData.get(p.dataId);f=this.gpgpu.createBufferFromTexture(e.texture,...mt(s))}if(this.pendingRead.set(t,[]),"complex64"!==u&&await this.gpgpu.createAndWaitForFence(),"complex64"===u){const e=await Promise.all([this.read(l.real.dataId),this.read(l.imag.dataId)]),n=e[0],t=e[1];h=r.mergeRealAndImagArrays(n,t)}else if(null==f)h=this.getValuesFromTexture(t);else{const n=e.sizeFromShape(s);h=this.gpgpu.downloadFloat32MatrixFromBuffer(f,n)}null!=p&&this.disposeIntermediateTensorInfo(p);const x=this.convertAndCacheOnCPU(t,h),g=this.pendingRead.get(t);return this.pendingRead.delete(t),g.forEach(e=>e(x)),this.pendingDisposal.has(t)&&(this.pendingDisposal.delete(t),this.disposeData(t)&&d().removeDataId(t,this),this.pendingDeletes--),x}bufferSync(n){const t=this.readSync(n.dataId);let r=t;if("string"===n.dtype)try{r=t.map(n=>e.decodeString(n))}catch(e){throw new Error("Failed to decode encoded string bytes into utf-8")}return a(n.shape,n.dtype,r)}checkNumericalProblems(e){if(null!=e)for(let t=0;t<e.length;t++){const r=e[t];if(!$t(r)){if(n().getBool("WEBGL_RENDER_FLOAT32_CAPABLE"))throw Error(`The value ${r} cannot be represented with your `+"current settings. Consider enabling float32 rendering: 'tf.env().set('WEBGL_RENDER_FLOAT32_ENABLED', true);'");throw Error(`The value ${r} cannot be represented on this device.`)}}}getValuesFromTexture(t){const{shape:r,dtype:a,isPacked:o}=this.texData.get(t),s=e.sizeFromShape(r);if(n().getBool("WEBGL_DOWNLOAD_FLOAT_ENABLED")){const e=this.decode(t),n=this.texData.get(e.dataId),a=this.gpgpu.downloadMatrixFromPackedTexture(n.texture,...mt(r)).subarray(0,s);return this.disposeIntermediateTensorInfo(e),a}const i=n().getBool("WEBGL_PACK")&&!0===o,u=i?Kt(r):r,l=i?new Cr(u):new br(u),c=this.runWebGLProgram(l,[{shape:u,dtype:a,dataId:t}],"float32"),d=this.texData.get(c.dataId),p=this.gpgpu.downloadByteEncodedFloatMatrixFromOutputTexture(d.texture,d.texShape[0],d.texShape[1]).subarray(0,s);return this.disposeIntermediateTensorInfo(c),p}timerAvailable(){return n().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE")>0}async time(t){const r=this.activeTimers,a=[];let o=!1;null==this.programTimersStack?(this.programTimersStack=a,o=!0):this.activeTimers.push(a),this.activeTimers=a,t();const s=e.flatten(this.activeTimers.map(e=>e.query)).filter(e=>null!=e),i=e.flatten(this.activeTimers.map(e=>e.name)).filter(e=>null!=e);this.activeTimers=r,o&&(this.programTimersStack=null);const u={uploadWaitMs:this.uploadWaitMs,downloadWaitMs:this.downloadWaitMs,kernelMs:null,wallMs:null};if(n().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE")>0){const n=await Promise.all(s);u.kernelMs=e.sum(n),u.getExtraProfileInfo=()=>n.map((e,n)=>({name:i[n],ms:e})).map(e=>`${e.name}: ${e.ms}`).join(", ")}else u.kernelMs={error:"WebGL query timers are not supported in this environment."};return this.uploadWaitMs=0,this.downloadWaitMs=0,u}memory(){return{unreliable:!1,numBytesInGPU:this.numBytesInGPU,numBytesInGPUAllocated:this.textureManager.numBytesAllocated,numBytesInGPUFree:this.textureManager.numBytesFree}}startTimer(){return n().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE")>0?this.gpgpu.beginQuery():{startMs:e.now(),endMs:null}}endTimer(t){return n().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE")>0?(this.gpgpu.endQuery(),t):(t.endMs=e.now(),t)}async getQueryTime(e){if(n().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE")>0)return this.gpgpu.waitForQueryAndGetTime(e);const t=e;return t.endMs-t.startMs}disposeData(e,n=!1){if(this.pendingDisposal.has(e))return!1;if(!this.texData.has(e))return!0;if(n?this.texData.get(e).refCount=0:this.texData.get(e).refCount--,!n&&this.texData.get(e).refCount>0)return!1;if(this.pendingRead.has(e))return this.pendingDisposal.add(e),this.pendingDeletes++,!1;this.releaseGPUData(e);const{complexTensorInfos:t}=this.texData.get(e);return null!=t&&(this.disposeData(t.real.dataId,n),this.disposeData(t.imag.dataId,n)),this.texData.delete(e),!0}releaseGPUData(e){const{texture:n,dtype:t,texShape:r,usage:a,isPacked:o,slice:s}=this.texData.get(e),i=s&&s.origDataId||e,u=this.dataRefCount.get(i);u>1?this.dataRefCount.set(i,u-1):(this.dataRefCount.delete(i),null!=n&&(this.numBytesInGPU-=this.computeBytes(r,t),this.textureManager.releaseTexture(n,r,a,o)));const l=this.texData.get(e);l.texture=null,l.texShape=null,l.isPacked=!1,l.slice=null}getTexture(e){return this.uploadToGPU(e),this.texData.get(e).texture}getDataInfo(e){return this.texData.get(e)}getCPUBackend(){return n().getBool("WEBGL_CPU_FORWARD")?(null==this.cpuBackend&&(this.cpuBackend=d().findBackend("cpu")),this.cpuBackend):null}shouldExecuteOnCPU(t,r=128){const a=this.getCPUBackend();return n().getBool("IS_TEST")||this.warnedAboutCPUBackend||null!=a||(console.warn("Your application contains ops that are small enough to be executed on the CPU backend, however the CPU backend cannot be found. Consider importing the CPU backend (@tensorflow/tfjs-backend-cpu) for better performance."),this.warnedAboutCPUBackend=!0),null!=a&&t.every(n=>null==this.texData.get(n.dataId).texture&&e.sizeFromShape(n.shape)<r)}getGPGPUContext(){return this.gpgpu}where(e){r.warn("tf.where() in webgl locks the UI thread. Call tf.whereAsync() instead");const n=e.dataSync();return xo(e.shape,n)}packedUnaryOp(e,n,t){const r=new ho(e.shape,n),a=this.compileAndRun(r,[e],t);return d().makeTensorFromDataId(a.dataId,a.shape,a.dtype)}abs(e){if(this.shouldExecuteOnCPU([e])&&"complex64"!==e.dtype){const n=Ha(this.texData.get(e.dataId).values);return this.makeOutput(e.shape,e.dtype,n)}if(n().getBool("WEBGL_PACK_UNARY_OPERATIONS"))return this.packedUnaryOp(e,co,e.dtype);const t=new uo(e.shape,co),r=this.compileAndRun(t,[e]);return d().makeTensorFromDataId(r.dataId,r.shape,r.dtype)}makeTensorInfo(n,t,r){let a;if("string"===t&&null!=r&&r.length>0&&e.isString(r[0])){const o=r.map(n=>e.encodeString(n));a=this.write(o,n,t)}else a=this.write(r,n,t);return this.texData.get(a).usage=null,{dataId:a,shape:n,dtype:t}}makeOutput(e,n,t){const{dataId:r}=this.makeTensorInfo(e,n,t);return d().makeTensorFromDataId(r,e,n,this)}unpackTensor(e){const n=new fo(e.shape);return this.runWebGLProgram(n,[e],e.dtype)}packTensor(e){const n=new to(e.shape);return this.runWebGLProgram(n,[e],e.dtype,null,!0)}packedReshape(e,n){const t=[Ht(e.shape),...jt(e.shape)],r={dtype:e.dtype,shape:t,dataId:e.dataId},a=[Ht(n),...jt(n)],o=new ro(a,t),s=this.runWebGLProgram(o,[r],e.dtype,null,!0);return{dataId:s.dataId,shape:n,dtype:s.dtype}}decode(e){const n=this.texData.get(e),{isPacked:t,shape:r,dtype:a}=n,o=Kt(r);let s;s=t?new mr(o):new gr(o);return{dtype:a,shape:r,dataId:this.runWebGLProgram(s,[{shape:o,dtype:a,dataId:e}],a,null,!0).dataId}}runWebGLProgram(t,r,a,o,s=!1){const i=this.makeTensorInfo(t.outputShape,a),u=this.texData.get(i.dataId);if(t.packedOutput&&(u.isPacked=!0),t.outPackingScheme===ht.DENSE){const e=mt(t.outputShape);u.texShape=e.map(e=>2*e)}if(null!=t.outTexUsage&&(u.usage=t.outTexUsage),0===e.sizeFromShape(i.shape))return u.values=e.getTypedArrayFromDType(i.dtype,0),i;const l=[],c=r.map(r=>{if("complex64"===r.dtype)throw new Error("GPGPUProgram does not support complex64 input. For complex64 dtypes, please separate the program into real and imaginary parts.");let a=this.texData.get(r.dataId);if(null==a.texture){if(!t.packedInputs&&e.sizeFromShape(r.shape)<=n().getNumber("WEBGL_SIZE_UPLOAD_UNIFORM"))return{shape:r.shape,texData:null,isUniform:!0,uniformValues:a.values};t.packedInputs&&(a.isPacked=!0,a.shape=r.shape)}else if(!!a.isPacked!=!!t.packedInputs)r=a.isPacked?this.unpackTensor(r):this.packTensor(r),l.push(r),a=this.texData.get(r.dataId);else if(a.isPacked&&!Qt(a.shape,r.shape)){const e=r,n=r.shape;r.shape=a.shape,r=this.packedReshape(r,n),l.push(r),a=this.texData.get(r.dataId),e.shape=n}return this.uploadToGPU(r.dataId),{shape:r.shape,texData:a,isUniform:!1}});this.uploadToGPU(i.dataId);const d={shape:i.shape,texData:u,isUniform:!1},p=function(e,n,t){let r="";n.concat(t).forEach(e=>{const n=null!=e.texData&&null!=e.texData.slice&&e.texData.slice.flatOffset>0,t=e.isUniform?"uniform":e.texData.texShape;r+=`${e.shape}_${t}_${n}`});const a=e.userCode;let o=e.constructor.name;return o+="_"+r+"_"+a,o}(t,c,d),h=this.getAndSaveBinary(p,()=>function(e,t,r,a){const o=t.userCode,s=r.map((e,n)=>{const r={logicalShape:e.shape,texShape:e.isUniform?null:e.texData.texShape,isUniform:e.isUniform,isPacked:!e.isUniform&&e.texData.isPacked,flatOffset:null};return null!=e.texData&&null!=e.texData.slice&&e.texData.slice.flatOffset>0&&(r.flatOffset=e.texData.slice.flatOffset),{name:t.variableNames[n],shapeInfo:r}}),i=s.map(e=>e.shapeInfo),u={logicalShape:a.shape,texShape:a.texData.texShape,isUniform:!1,isPacked:a.texData.isPacked,flatOffset:null},l=jr(s,u,o,t.packedInputs),c=e.createProgram(l);let d=null;const p=e.getUniformLocation(c,"NAN",!1);1===n().getNumber("WEBGL_VERSION")&&(d=e.getUniformLocation(c,"INFINITY",!1));const h={};for(let n=0;n<t.variableNames.length;n++){const r=t.variableNames[n],a=!1;h[r]=e.getUniformLocation(c,r,a),h[`offset${r}`]=e.getUniformLocation(c,`offset${r}`,a)}return{program:t,source:l,webGLProgram:c,uniformLocations:h,inShapeInfos:i,outShapeInfo:u,infLoc:d,nanLoc:p}}(this.gpgpu,t,c,d)),f=null!=this.activeTimers;let x;f&&(x=this.startTimer()),function(t,r,a,o,s){sa(r.inShapeInfos,a),sa([r.outShapeInfo],[o]);const i=o.texData.texture,u=o.texData.texShape;o.texData.isPacked?t.setOutputPackedMatrixTexture(i,u[0],u[1]):t.setOutputMatrixTexture(i,u[0],u[1]),t.setProgram(r.webGLProgram),1===n().getNumber("WEBGL_VERSION")&&null!==r.infLoc&&t.gl.uniform1f(r.infLoc,1/0),null!==r.nanLoc&&t.gl.uniform1f(r.nanLoc,NaN),a.forEach((n,a)=>{const o=r.program.variableNames[a],s=r.uniformLocations[o],i=r.uniformLocations[`offset${o}`];if(null!=s)if(n.isUniform)if(e.sizeFromShape(n.shape)<2)t.gl.uniform1f(s,n.uniformValues[0]);else{let e=n.uniformValues;e instanceof Float32Array||(e=new Float32Array(e)),t.gl.uniform1fv(s,e)}else null!=n.texData.slice&&null!=i&&t.gl.uniform1i(i,n.texData.slice.flatOffset),t.setInputMatrixTexture(n.texData.texture,s,a)}),null!=s&&s(t,r.webGLProgram),t.executeProgram()}(this.gpgpu,h,c,d,o),l.forEach(e=>this.disposeIntermediateTensorInfo(e)),f&&(x=this.endTimer(x),this.activeTimers.push({name:t.constructor.name,query:this.getQueryTime(x)}));const g=n().get("WEBGL_FLUSH_THRESHOLD");if(g>0){const n=e.now();n-this.lastGlFlushTime>g&&(this.gpgpu.gl.flush(),this.lastGlFlushTime=n)}if(!n().getBool("WEBGL_LAZILY_UNPACK")&&u.isPacked&&!1===s){const e=this.unpackTensor(i);return this.disposeIntermediateTensorInfo(i),e}return i}compileAndRun(e,n,t,r,a=!1){return t=t||n[0].dtype,this.runWebGLProgram(e,n,t,r,a)}getAndSaveBinary(e,n){return e in this.binaryCache||(this.binaryCache[e]=n()),this.binaryCache[e]}getTextureManager(){return this.textureManager}dispose(){if(!this.disposed){if(!n().getBool("IS_TEST")){Object.keys(this.binaryCache).forEach(e=>{this.gpgpu.deleteProgram(this.binaryCache[e].webGLProgram),delete this.binaryCache[e]})}this.textureManager.dispose(),null!=this.canvas&&"undefined"!=typeof HTMLCanvasElement&&this.canvas instanceof HTMLCanvasElement?this.canvas.remove():this.canvas=null,this.gpgpuCreatedLocally&&(this.gpgpu.program=null,this.gpgpu.dispose()),this.disposed=!0}}floatPrecision(){return null==this.floatPrecisionValue&&(this.floatPrecisionValue=p(()=>{if(!n().get("WEBGL_RENDER_FLOAT32_ENABLED")){const e=n().getBool("DEBUG");n().set("DEBUG",!1);const t=this.abs(h(1e-8)).dataSync()[0];if(n().set("DEBUG",e),t>0)return 32}return 16})),this.floatPrecisionValue}epsilon(){return 32===this.floatPrecision()?1e-7:1e-4}uploadToGPU(n){const t=this.texData.get(n),{shape:r,dtype:a,values:o,texture:s,usage:i,isPacked:u}=t;if(null!=s)return;const l=null!=this.activeTimers;let c;l&&(c=e.now());let d=t.texShape;if(null==d&&(d=qt(r,u),t.texShape=d),null!=o){const n=Kt(r);let s,i=d[1],p=d[0];const h=o instanceof Uint8Array;u?([i,p]=bt(d[0],d[1]),s=new $r(n,[p,i],h)):s=new vr(n,[p,i],h);const f=this.makeTensorInfo([p,i],a);this.texData.get(f.dataId).usage=h?ft.PIXELS:ft.UPLOAD,this.gpgpu.uploadDenseMatrixToTexture(this.getTexture(f.dataId),i,p,o);const x=!0,g=this.runWebGLProgram(s,[f],a,null,x),m=this.texData.get(g.dataId);t.texture=m.texture,t.texShape=m.texShape,t.isPacked=m.isPacked,t.usage=m.usage,this.disposeIntermediateTensorInfo(f),this.texData.delete(g.dataId),t.values=null,l&&(this.uploadWaitMs+=e.now()-c)}else{const e=this.acquireTexture(d,i,a,u);t.texture=e}}convertAndCacheOnCPU(e,n){const t=this.texData.get(e),{dtype:r}=t;return this.releaseGPUData(e),null!=n&&(t.values=function(e,n){if("float32"===n||"complex64"===n)return e;if("int32"===n||"bool"===n){const t="int32"===n?new Int32Array(e.length):new Uint8Array(e.length);for(let n=0;n<t.length;++n)t[n]=Math.round(e[n]);return t}throw new Error(`Unknown dtype ${n}`)}(n,r)),t.values}acquireTexture(e,n,t,r){if(this.numBytesInGPU+=this.computeBytes(e,t),!this.warnedAboutMemory&&this.numBytesInGPU>1024*this.numMBBeforeWarning*1024){const e=(this.numBytesInGPU/1024/1024).toFixed(2);this.warnedAboutMemory=!0,console.warn(`High memory usage in GPU: ${e} MB, `+"most likely due to a memory leak")}return this.textureManager.acquireTexture(e,n,r)}computeBytes(n,t){return n[0]*n[1]*e.bytesPerElement(t)}}mo.nextDataId=0;const bo="3.2.0";function Co(){n().set("WEBGL_FORCE_F16_TEXTURES",!0)}t.isBrowser()&&f("webgl",()=>new mo,2);const vo={forceHalfFloat:Co};class $o{constructor(e,n,t){this.variableNames=["A","B"],this.outputShape=r.assertAndGetBroadcastShape(n,t),this.userCode=`\n      float binaryOperation(float a, float b) {\n        ${e}\n      }\n\n      void main() {\n        float a = getAAtOutCoords();\n        float b = getBAtOutCoords();\n        setOutput(binaryOperation(a, b));\n      }\n    `}}class Io{constructor(n,t,a,o=!1){this.variableNames=["A","B"],this.supportsBroadcasting=!0,this.packedInputs=!0,this.packedOutput=!0,this.outputShape=r.assertAndGetBroadcastShape(t,a);const s=this.outputShape.length;let i="";if(o)if(0===s||1===e.sizeFromShape(this.outputShape))i="\n          result.y = 0.;\n          result.z = 0.;\n          result.w = 0.;\n        ";else{if(i=`\n          ${ra(s)} coords = getOutputCoords();\n        `,1===s)i+=`\n            result.y = (coords + 1) >= ${this.outputShape[0]} ? 0. : result.y;\n            result.z = 0.;\n            result.w = 0.;\n          `;else{const e=no("coords",s);i+=`\n            bool nextRowOutOfBounds =\n              (${e[s-2]} + 1) >= ${this.outputShape[s-2]};\n            bool nextColOutOfBounds =\n              (${e[s-1]} + 1) >= ${this.outputShape[s-1]};\n            result.y = nextColOutOfBounds ? 0. : result.y;\n            result.z = nextRowOutOfBounds ? 0. : result.z;\n            result.w = nextColOutOfBounds || nextRowOutOfBounds ? 0. : result.w;\n          `}}this.userCode=`\n      vec4 binaryOperation(vec4 a, vec4 b) {\n        ${n}\n      }\n\n      void main() {\n        vec4 a = getAAtOutCoords();\n        vec4 b = getBAtOutCoords();\n\n        vec4 result = binaryOperation(a, b);\n        ${i}\n\n        setOutput(result);\n      }\n    `}}function Ro(e){const{inputs:n,backend:t}=e,{x:r}=n;return t.incRef(r.dataId),{dataId:r.dataId,shape:r.shape,dtype:r.dtype}}const yo={kernelName:x,backendName:"webgl",kernelFunc:Ro};function wo(e){const{inputs:n,backend:t}=e,{real:r,imag:a}=n,o=t.makeTensorInfo(r.shape,"complex64"),s=t.texData.get(o.dataId),i=Ro({inputs:{x:r},backend:t}),u=Ro({inputs:{x:a},backend:t});return s.complexTensorInfos={real:i,imag:u},o}const ko={kernelName:g,backendName:"webgl",kernelFunc:wo},To="return (a < 0.) ? b * a : a;",Eo="\n  vec4 aLessThanZero = vec4(lessThan(a, vec4(0.)));\n  return (aLessThanZero * (b * a)) + ((vec4(1.0) - aLessThanZero) * a);\n";const No={kernelName:m,backendName:"webgl",kernelFunc:function(t){const{inputs:r,backend:a,attrs:o}=t,{x:s}=r,{alpha:i}=o,u=a.makeTensorInfo([],"float32",e.createScalarValue(i,"float32")),l=n().getBool("WEBGL_PACK_BINARY_OPERATIONS")?new Io(Eo,s.shape,u.shape):new $o(To,s.shape,u.shape),c=a.runWebGLProgram(l,[s,u],s.dtype);return a.disposeIntermediateTensorInfo(u),c}},So="return (a < 0.) ? b * a : a;",Ao="\n  vec4 aLessThanZero = vec4(lessThan(a, vec4(0.)));\n  return (aLessThanZero * (b * a)) + ((vec4(1.0) - aLessThanZero) * a);\n";const Fo={kernelName:b,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:r}=e,{x:a,alpha:o}=t,s=n().getBool("WEBGL_PACK_BINARY_OPERATIONS")?new Io(Ao,a.shape,o.shape):new $o(So,a.shape,o.shape);return r.runWebGLProgram(s,[a,o],a.dtype)}};function Oo({opSnippet:e,packedOpSnippet:t,cpuKernelImpl:r,dtype:a}){return({inputs:o,backend:s})=>{const{x:i}=o,u=s,l=a||i.dtype;if(u.shouldExecuteOnCPU([i])&&null!=r){const e=u.texData.get(i.dataId),n=r(e.values,l);return u.makeTensorInfo(i.shape,l,n)}let c;return c=n().getBool("WEBGL_PACK_UNARY_OPERATIONS")&&null!=t?new ho(i.shape,t):new uo(i.shape,e),u.runWebGLProgram(c,[i],l)}}function _o({opSnippet:e,packedOpSnippet:t,checkOutOfBounds:r=!1,supportsComplex:a=!1,cpuKernelImpl:s,dtype:i}){return({inputs:u,backend:l})=>{const{a:c,b:d}=u,p=l;if(a&&"complex64"===c.dtype){const n=p.texData.get(c.dataId),t=p.texData.get(d.dataId),[r,a]=[[n.complexTensorInfos.real,t.complexTensorInfos.real],[n.complexTensorInfos.imag,t.complexTensorInfos.imag]].map(n=>{const[t,r]=n,a={dataId:t.dataId,dtype:t.dtype,shape:c.shape},s={dataId:r.dataId,dtype:r.dtype,shape:d.shape},i=new $o(e,c.shape,d.shape);return p.runWebGLProgram(i,[a,s],o(t.dtype,r.dtype))}),s=wo({inputs:{real:r,imag:a},backend:p});return p.disposeIntermediateTensorInfo(r),p.disposeIntermediateTensorInfo(a),s}const h=i||o(c.dtype,d.dtype);if(p.shouldExecuteOnCPU([c,d])&&null!=s){const e=p.texData.get(c.dataId),n=p.texData.get(d.dataId),[t,r]=s(c.shape,d.shape,e.values,n.values,h),a=p.makeTensorInfo(r,h);return p.texData.get(a.dataId).values=t,a}let f;return f=n().getBool("WEBGL_PACK_BINARY_OPERATIONS")&&null!=t?new Io(t,c.shape,d.shape,r):new $o(e,c.shape,d.shape),p.runWebGLProgram(f,[c,d],h)}}function Do(e,n=!1){if("linear"===e)return"return x;";if("relu"===e)return n?"\n  vec4 result = x * vec4(greaterThanEqual(x, vec4(0.0)));\n  bvec4 isNaN = isnan(x);\n\n  result.r = isNaN.r ? x.r : result.r;\n  result.g = isNaN.g ? x.g : result.g;\n  result.b = isNaN.b ? x.b : result.b;\n  result.a = isNaN.a ? x.a : result.a;\n\n  return result;\n":"if (isnan(x)) return x;\n  return (x < 0.0) ? 0.0 : x;\n";if("elu"===e)return n?"\n  vec4 result;\n\n  result.r = (x.r >= 0.0) ? x.r : (exp(x.r) - 1.0);\n  result.g = (x.g >= 0.0) ? x.g : (exp(x.g) - 1.0);\n  result.b = (x.b >= 0.0) ? x.b : (exp(x.b) - 1.0);\n  result.a = (x.a >= 0.0) ? x.a : (exp(x.a) - 1.0);\n\n  return result;\n":"return (x >= 0.0) ? x : (exp(x) - 1.0);";if("relu6"===e)return n?"\n  vec4 result = min(x, vec4(6.)) * vec4(greaterThanEqual(x, vec4(0.0)));\n  bvec4 isNaN = isnan(x);\n\n  result.r = isNaN.r ? x.r : result.r;\n  result.g = isNaN.g ? x.g : result.g;\n  result.b = isNaN.b ? x.b : result.b;\n  result.a = isNaN.a ? x.a : result.a;\n\n  return result;\n":"if (isnan(x)) return x;\n  return (x < 0.0) ? 0.0 : min(6.0, x);\n";if("prelu"===e)return n?Ao:So;if("leakyrelu"===e)return n?Eo:To;throw new Error(`Activation ${e} has not been implemented for the WebGL backend.`)}class Lo{constructor(e,n,t,r=!1,a=!1,o=!1,s=null,i=!1,u=!1){this.variableNames=["matrixA","matrixB"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=t;const l=r?e[1]:e[2],c=Math.ceil(l/2),d=r?"i * 2, rc.y":"rc.y, i * 2",p=a?"rc.z, i * 2":"i * 2, rc.z",h=r?["a.xxyy","a.zzww"]:["a.xxzz","a.yyww"],f=a?["b.xzxz","b.ywyw"]:["b.xyxy","b.zwzw"];let x="",g="";s&&(x=i?`vec4 activation(vec4 a) {\n          vec4 b = getPreluActivationWeightsAtOutCoords();\n          ${s}\n        }`:u?`vec4 activation(vec4 a) {\n          vec4 b = getLeakyreluAlphaAtOutCoords();\n          ${s}\n        }`:`vec4 activation(vec4 x) {\n          ${s}\n        }`,g="result = activation(result);");const m=o?"result += getBiasAtOutCoords();":"";o&&this.variableNames.push("bias"),i&&this.variableNames.push("preluActivationWeights"),u&&this.variableNames.push("leakyreluAlpha");let b="rc.x",C="rc.x";e[0]<n[0]?b=`int(min(float(rc.x), ${e[0]-1}.))`:n[0]<e[0]&&(C=`int(min(float(rc.x), ${n[0]-1}.))`),this.userCode=`\n      ${x}\n\n      const float sharedDimension = ${c}.0;\n\n      vec4 dot2x2ARowBCol(ivec3 rc) {\n        vec4 result = vec4(0);\n        for (int i = 0; i < ${c}; i++) {\n          int batchA = ${b};\n          int batchB = ${C};\n          vec4 a = getMatrixA(batchA, ${d});\n          vec4 b = getMatrixB(batchB, ${p});\n\n          // These swizzled products need to be separately added.\n          // See: https://github.com/tensorflow/tfjs/issues/1735\n          result += (${h[0]} * ${f[0]});\n          result += (${h[1]} * ${f[1]});\n        }\n        return result;\n      }\n\n      void main() {\n        ivec3 rc = getOutputCoords();\n        vec4 result = dot2x2ARowBCol(rc);\n\n        ${m}\n\n        ${g}\n\n        setOutput(result);\n      }\n    `}}const Po="return areal * breal - aimag * bimag;",Bo="return areal * bimag + aimag * breal;";class Wo{constructor(e,n,t){this.variableNames=["AReal","AImag","BReal","BImag"],this.outputShape=r.assertAndGetBroadcastShape(n,t),this.userCode=`\n      float binaryOpComplex(\n          float areal, float aimag, float breal, float bimag) {\n        ${e}\n      }\n\n      void main() {\n        float areal = getARealAtOutCoords();\n        float aimag = getAImagAtOutCoords();\n        float breal = getBRealAtOutCoords();\n        float bimag = getBImagAtOutCoords();\n        setOutput(binaryOpComplex(areal, aimag, breal, bimag));\n      }\n    `}}const Vo="return a * b;";function Mo(e){const{inputs:t,backend:a}=e,{a:o,b:s}=t,i=r.upcastType(o.dtype,s.dtype);if("complex64"===o.dtype){const e=a.texData.get(o.dataId),n=a.texData.get(s.dataId),t=new Wo(Po,o.shape,s.shape),r=new Wo(Bo,o.shape,s.shape),i=[{dataId:e.complexTensorInfos.real.dataId,dtype:e.complexTensorInfos.real.dtype,shape:o.shape},{dataId:e.complexTensorInfos.imag.dataId,dtype:e.complexTensorInfos.imag.dtype,shape:o.shape},{dataId:n.complexTensorInfos.real.dataId,dtype:n.complexTensorInfos.real.dtype,shape:s.shape},{dataId:n.complexTensorInfos.imag.dataId,dtype:n.complexTensorInfos.imag.dtype,shape:s.shape}],u=a.runWebGLProgram(t,i,"float32"),l=a.runWebGLProgram(r,i,"float32"),c=wo({inputs:{real:u,imag:l},backend:a});return a.disposeIntermediateTensorInfo(u),a.disposeIntermediateTensorInfo(l),c}if(a.shouldExecuteOnCPU([o,s])){const e=a.texData.get(o.dataId),n=a.texData.get(s.dataId),[t,r]=Ma(o.shape,s.shape,e.values,n.values,i),u=a.makeTensorInfo(r,i);return a.texData.get(u.dataId).values=t,u}let u;return u=n().getBool("WEBGL_PACK_BINARY_OPERATIONS")?new Io(Vo,o.shape,s.shape):new $o(Vo,o.shape,s.shape),a.runWebGLProgram(u,[o,s],i)}const Go={kernelName:C,backendName:"webgl",kernelFunc:Mo};function Uo(n){const{inputs:t,backend:r,attrs:a}=n,{x:o}=t,{shape:s}=a,i=r,u=e.sizeFromShape(o.shape),l=e.inferFromImplicitShape(s,u),c=e.sizeFromShape(l);e.assert(u===c,()=>`The new shape (${l}) has ${c} elements and the old `+`shape (${o.shape}) has ${u} elements. The new shape and old `+"shape must have the same number of elements.");const d=i.texData.get(o.dataId);return!d.isPacked||Qt(o.shape,l)||null!==d.texture&&Qt(d.shape,l)?(i.incRef(o.dataId),{dataId:o.dataId,shape:l,dtype:o.dtype}):function(e,n,t){const r=[Ht(e.shape),...jt(e.shape)],a={dtype:e.dtype,shape:r,dataId:e.dataId},o=[Ht(n),...jt(n)],s=new ro(o,r),i=t.runWebGLProgram(s,[a],e.dtype,null,!0);return{dataId:i.dataId,shape:n,dtype:i.dtype}}(o,l,i)}const zo={kernelName:v,backendName:"webgl",kernelFunc:Uo};class Xo{constructor(n,t){this.variableNames=["x"];const{windowSize:r,batchSize:a,inSize:o,outSize:s}=n;this.outputShape=[a,s];const i=4*Math.floor(r/4),u=r%4;let l="sumValue += dot(values, ones);";if(null!=t){const n=1/t;l=`sumValue += dot(values * ${e.isInt(n)?n.toPrecision(2):n}, ones);`}let c="";o%r>0&&(c=`\n        if (inIdx < 0 || inIdx >= ${o}) {\n          return 0.0;\n        }\n      `),this.userCode=`\n      const vec4 ones = vec4(1.0, 1.0, 1.0, 1.0);\n\n      float getValue(int batch, int inIdx) {\n        ${c}\n        return getX(batch, inIdx);\n      }\n\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int batch = coords[0];\n        int outIdx = coords[1];\n        int inOffset = outIdx * ${r};\n\n        float sumValue = 0.0;\n\n        for (int i = 0; i < ${i}; i += 4) {\n          int inIdx = inOffset + i;\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2),\n            getValue(batch, inIdx + 3)\n          );\n\n          ${l}\n        }\n\n        int inIdx = inOffset + ${i};\n        if (${1===u}) {\n          vec4 values = vec4(getValue(batch, inIdx), 0.0, 0.0, 0.0);\n\n          ${l}\n        } else if (${2===u}) {\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1), 0.0, 0.0);\n\n          ${l}\n        } else if (${3===u}) {\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2), 0.0);\n\n          ${l}\n        }\n        setOutput(sumValue);\n      }\n    `}}class Ho{constructor(e,n){this.variableNames=["x"];const{windowSize:t,batchSize:r,inSize:a,outSize:o}=e;this.outputShape=[r,o];let s="0.0",i="";"prod"===n?s="1.0":"min"===n?(s="1.0 / 1e-20",i="min"):"max"===n&&(s="-1.0 / 1e-20",i="max");let u=`${n}(${n}(${n}(`+"minMaxValue[0], minMaxValue[1]), minMaxValue[2]), minMaxValue[3])";"sum"===n?u="sumValue":"prod"===n?u="prodValue":"all"===n?u="allValue":"any"===n&&(u="anyValue");const l=4*Math.floor(t/4),c=t%4;let d=`\n      if (${"sum"===n}) {\n        sumValue += dot(values, ones);\n      } else if (${"prod"===n}) {\n        vec2 tmp = vec2(values[0], values[1]) * vec2(values[2], values[3]);\n        prodValue *= tmp[0] * tmp[1];\n      } else {\n        minMaxValue = ${i}(values, minMaxValue);\n      }\n    `,p="vec4";"all"===n?(s="1.0",d="\n        bool reducedAllValue = all(values);\n        float floatedReducedAllValue = float(reducedAllValue);\n        allValue = float(allValue >= 1.0 && floatedReducedAllValue >= 1.0);\n      ",p="bvec4"):"any"===n&&(s="0.0",d="\n        bool reducedAnyValue = any(values);\n        float floatedReducedAnyValue = float(reducedAnyValue);\n        anyValue = float(anyValue >= 1.0 || floatedReducedAnyValue >= 1.0);\n      ",p="bvec4");let h="";a%t>0&&(h=`\n        if (inIdx < 0 || inIdx >= ${a}) {\n          return initializationValue;\n        }\n      `),this.userCode=`\n      const float initializationValue = ${s};\n      const vec4 ones = vec4(1.0, 1.0, 1.0, 1.0);\n\n      float getValue(int batch, int inIdx) {\n        ${h}\n        return getX(batch, inIdx);\n      }\n\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int batch = coords[0];\n        int outIdx = coords[1];\n        int inOffset = outIdx * ${t};\n\n        vec4 minMaxValue = vec4(${s});\n        float prodValue = 1.0;\n        float sumValue = 0.0;\n        float allValue = 1.0;\n        float anyValue = 0.0;\n\n        for (int i = 0; i < ${l}; i += 4) {\n          int inIdx = inOffset + i;\n          ${p} values = ${p}(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2),\n            getValue(batch, inIdx + 3)\n          );\n\n          ${d}\n        }\n\n        int inIdx = inOffset + ${l};\n        if (${1===c}) {\n          ${p} values = ${p}(\n            getValue(batch, inIdx),\n            initializationValue,\n            initializationValue,\n            initializationValue\n          );\n\n          ${d}\n        } else if (${2===c}) {\n          ${p} values = ${p}(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            initializationValue,\n            initializationValue\n          );\n\n          ${d}\n        } else if (${3===c}) {\n          ${p} values = ${p}(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2),\n            initializationValue\n          );\n\n          ${d}\n        }\n        setOutput(${u});\n      }\n    `}}function jo(e,n,t,a){const o=function(e){const n=[];for(;0===n.length||1!==n[n.length-1].outSize;){const t=n.length?n[n.length-1].outSize:e[1],a=r.computeOptimalWindowSize(t);n.push({inSize:t,windowSize:a,outSize:Math.ceil(t/a)})}return n}(e.shape);let s=e;for(let r=0;r<o.length;r++){const{inSize:i,windowSize:u,outSize:l}=o[r];let c,d;c="mean"===t?0===r?new Xo({windowSize:u,inSize:i,batchSize:e.shape[0],outSize:l},i):new Xo({windowSize:u,inSize:i,batchSize:e.shape[0],outSize:l}):new Ho({windowSize:u,inSize:i,batchSize:e.shape[0],outSize:l},t),d=s,s=a.runWebGLProgram(c,[s],n),d.dataId!==e.dataId&&a.disposeIntermediateTensorInfo(d)}return s}class Ko{constructor(e,n){this.variableNames=["A"];const t=new Array(e.length);for(let r=0;r<t.length;r++)t[r]=e[n[r]];this.outputShape=t,this.rank=t.length;const r=ra(this.rank),a=function(e){const n=e.length;if(n>6)throw Error(`Transpose for rank ${n} is not yet supported`);const t=["resRC.x","resRC.y","resRC.z","resRC.w","resRC.u","resRC.v"],r=new Array(n);for(let n=0;n<e.length;n++)r[e[n]]=t[n];return r.join()}(n);this.userCode=`\n    void main() {\n      ${r} resRC = getOutputCoords();\n      setOutput(getA(${a}));\n    }\n    `}}class qo{constructor(e,n){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0;const t=new Array(e.length);for(let r=0;r<t.length;r++)t[r]=e[n[r]];if(this.outputShape=t,this.rank=t.length,this.rank>6)throw Error(`Packed transpose for rank ${this.rank} is not yet supported.`);const r=ra(this.rank),a=eo("rc",this.rank),o=new Array(this.rank);for(let e=0;e<n.length;e++)o[n[e]]=a[e];const s=`vec2(${o.slice(-2).join()})`,i=`++${a[this.rank-1]} < ${t[this.rank-1]}`,u=`getChannel(getA(${o.join()}), ${s})`;this.userCode=`\n    void main() {\n      ${r} rc = getOutputCoords();\n      vec4 result = vec4(0.);\n      result[0] = ${u};\n      if(${i}) {\n        result[1] = ${u};\n      }\n      --${a[this.rank-1]};\n      if(++${a[this.rank-2]} < ${t[this.rank-2]}) {\n        result[2] = ${u};\n        if(${i}) {\n          result[3] = ${u};\n        }\n      }\n      setOutput(result);\n    }\n    `}}function Yo(e,t,r){const a=n().getBool("WEBGL_PACK_ARRAY_OPERATIONS")?new qo(e.shape,t):new Ko(e.shape,t);return r.runWebGLProgram(a,[e],e.dtype)}function Qo(n){const{inputs:t,backend:a,attrs:o}=n,{x:s}=t,{axis:i,keepDims:u}=o;return function(n,t,a,o){const s=t,i=n.shape.length,u=e.parseAxisParam(s,n.shape);let l=u;const c=r.getAxesPermutation(l,i),d=null!=c;let p=n;d&&(p=Yo(n,c,o),l=r.getInnerMostAxes(l.length,i)),r.assertAxesAreInnerMostDims("sum",l,i);const[h,f]=r.computeOutAndReduceShapes(p.shape,l);let x=h;a&&(x=r.expandShapeToKeepDim(h,u));const g=e.sizeFromShape(f),m=Uo({inputs:{x:p},attrs:{shape:[e.sizeFromShape(n.shape)/g,g]},backend:o}),b=jo(m,$(n.dtype),"sum",o),C=Uo({inputs:{x:b},attrs:{shape:x},backend:o});return o.disposeIntermediateTensorInfo(m),o.disposeIntermediateTensorInfo(b),d&&o.disposeIntermediateTensorInfo(p),C}(s,i,u,a)}const Zo={kernelName:I,backendName:"webgl",kernelFunc:Qo};function Jo(e){const{inputs:n,backend:t,attrs:r}=e,{x:a}=n,{perm:o}=r,s=t,i=a.shape.length,u=new Array(i);for(let e=0;e<u.length;e++)u[e]=a.shape[o[e]];let l;if(s.shouldExecuteOnCPU([a])){const e=s.texData.get(a.dataId).values,n=Za(e,a.shape,a.dtype,o,u);l=s.makeTensorInfo(u,a.dtype),s.texData.get(l.dataId).values=n}else l=Yo(a,o,s);return l}const es={kernelName:R,backendName:"webgl",kernelFunc:Jo};function ns({a:n,b:t,transposeA:r,transposeB:a,backend:s,bias:i=null,preluActivationWeights:u=null,leakyreluAlpha:l=0,activation:c=null}){const d=n.shape.length,p=t.shape.length,h=r?n.shape[d-2]:n.shape[d-1],f=a?t.shape[p-1]:t.shape[p-2],x=r?n.shape[d-1]:n.shape[d-2],g=a?t.shape[p-2]:t.shape[p-1],m=n.shape.slice(0,-2),b=t.shape.slice(0,-2),C=e.sizeFromShape(m),v=e.sizeFromShape(b),$=C===v||1===C||1===v;e.assert(d>=2&&p>=2&&$,()=>"Error in matMul: the input batch dimensions must either be the same or at least one input batch dimension must be 1. Got input "+`batch dimensions of (${m}) and (${b}).`);const I=(C>v?n.shape.slice(0,-2):t.shape.slice(0,-2)).concat([x,g]);e.assert(h===f,()=>`Error in matMul: inner shapes (${h}) and (`+`${f}) of Tensors with shapes ${n.shape} and `+`${t.shape} and transposeA=${r}`+` and transposeB=${a} must match.`);const R=r?[C,h,x]:[C,x,h],y=a?[v,g,f]:[v,f,g],w=Uo({inputs:{x:n},backend:s,attrs:{shape:R}}),k=Uo({inputs:{x:t},backend:s,attrs:{shape:y}}),T=[w,k],E=Math.max(C,v),N=r?w.shape[1]:w.shape[2],S=null!=i,A=null!=u,F="leakyrelu"===c,O=null!=c?Do(c,!0):null;let _;if((1===x||1===g)&&N>1e3&&!1===(S||A||F||null!=O)){let e=w,n=k;r&&(e=Jo({inputs:{x:w},backend:s,attrs:{perm:[0,2,1]}}),T.push(e)),a&&(n=Jo({inputs:{x:k},backend:s,attrs:{perm:[0,2,1]}}),T.push(n));const t=1===g;let o=e;1!==g&&(o=Uo({inputs:{x:e},backend:s,attrs:{shape:[E,N,1]}}),T.push(o));const i=1===g?2:1;let u=n;t&&(u=Uo({inputs:{x:n},backend:s,attrs:{shape:[E,1,N]}}),T.push(u));const l=Mo({inputs:{a:o,b:u},backend:s});_=Qo({inputs:{x:l},backend:s,attrs:{axis:i,keepDims:!0}}),T.push(l)}else{const c=o(n.dtype,t.dtype),d=new Lo(R,y,[E,x,g],r,a,S,O,A,F),p=[w,k];if(null!=i&&p.push(i),A&&p.push(u),F){const n=s.makeTensorInfo([],"float32",e.createScalarValue(l,"float32"));p.push(n),T.push(n)}_=s.runWebGLProgram(d,p,c)}const D=Uo({inputs:{x:_},backend:s,attrs:{shape:I}});T.push(_);for(const e of T)s.disposeIntermediateTensorInfo(e);return D}const ts={kernelName:y,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t,attrs:r}=e,{a:a,b:o,bias:s,preluActivationWeights:i}=n,{transposeA:u,transposeB:l,activation:c,leakyreluAlpha:d}=r;return ns({a:a,b:o,transposeA:u,transposeB:l,backend:t,bias:s,preluActivationWeights:i,leakyreluAlpha:d,activation:c})}};const rs={kernelName:w,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:r}=e,{x:a}=t;if(r.shouldExecuteOnCPU([a])&&"complex64"!==a.dtype){const e=r.texData.get(a.dataId),n=Ha(e.values);return r.makeTensorInfo(a.shape,a.dtype,n)}let o;return o=n().getBool("WEBGL_PACK_UNARY_OPERATIONS")?new ho(a.shape,"return abs(x);"):new uo(a.shape,"return abs(x);"),r.runWebGLProgram(o,[a],a.dtype)}},as={kernelName:k,backendName:"webgl",kernelFunc:Oo({opSnippet:"if (isnan(x)) return x;\n  if (abs(x) > 1.) {\n    return NAN;\n  }\n  return acos(x);\n"})},os={kernelName:T,backendName:"webgl",kernelFunc:Oo({opSnippet:"if (isnan(x)) return x;\n  if (x < 1.0) return NAN;\nreturn log(x + sqrt(x * x - 1.0));"})},ss="return a + b;",is={kernelName:E,backendName:"webgl",kernelFunc:_o({opSnippet:ss,packedOpSnippet:ss,supportsComplex:!0,cpuKernelImpl:wa})};class us{constructor(e,n){this.outputShape=[],this.outputShape=e,this.variableNames=n.map((e,n)=>`T${n}`);const t=[];this.variableNames.forEach(e=>{t.push(`float v${e} = get${e}AtOutCoords();`)});const r=this.variableNames.map(e=>`v${e}`).join(" + ");this.userCode=`\n      void main() {\n        ${t.join("\n        ")}\n\n        float result = ${r};\n        setOutput(result);\n      }\n    `}}class ls{constructor(e,n){this.outputShape=[],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=e,this.variableNames=n.map((e,n)=>`T${n}`);const t=[];this.variableNames.forEach(e=>{t.push(`vec4 v${e} = get${e}AtOutCoords();`)});const r=this.variableNames.map(e=>`v${e}`).join(" + ");this.userCode=`\n      void main() {\n        ${t.join("\n        ")}\n\n        vec4 result = ${r};\n        setOutput(result);\n      }\n    `}}const cs={kernelName:N,backendName:"webgl",kernelFunc:function e(t){const{inputs:r,backend:a}=t,s=r;if(1===s.length)return Ro({inputs:{x:s[0]},backend:a});if(s.length>n().get("WEBGL_MAX_TEXTURES_IN_SHADER")){const n=Math.floor(s.length/2),t=e({inputs:s.slice(0,n),backend:a}),r=e({inputs:s.slice(n),backend:a});return e({inputs:[t,r],backend:a})}const i=s.map(e=>e.dtype).reduce((e,n)=>o(e,n)),u=s.map(e=>e.shape),l=n().getBool("WEBGL_PACK")?new ls(s[0].shape,u):new us(s[0].shape,u);return a.runWebGLProgram(l,s,i)}};const ds={kernelName:S,backendName:"webgl",kernelFunc:function(n){const{inputs:t,backend:a,attrs:o}=n,{x:s}=t,{axis:i,keepDims:u}=o,l=s.shape.length,c=e.parseAxisParam(i,s.shape);let d=c;const p=r.getAxesPermutation(d,l);let h=s;null!=p&&(h=Jo({inputs:{x:s},backend:a,attrs:{perm:p}}),d=r.getInnerMostAxes(d.length,l)),r.assertAxesAreInnerMostDims("all",d,l);const[f,x]=r.computeOutAndReduceShapes(h.shape,d),g=Uo({inputs:{x:h},backend:a,attrs:{shape:[-1,e.sizeFromShape(x)]}}),m=jo(g,g.dtype,"all",a);let b;if(u){b=Uo({inputs:{x:m},backend:a,attrs:{shape:r.expandShapeToKeepDim(f,c)}})}else b=Uo({inputs:{x:m},backend:a,attrs:{shape:f}});return a.disposeIntermediateTensorInfo(g),a.disposeIntermediateTensorInfo(m),null!=p&&a.disposeIntermediateTensorInfo(h),b}};const ps={kernelName:A,backendName:"webgl",kernelFunc:function(n){const{inputs:t,backend:a,attrs:o}=n,{x:s}=t,{axis:i,keepDims:u}=o,l=s.shape.length,c=e.parseAxisParam(i,s.shape);let d=c;const p=r.getAxesPermutation(d,l);let h=s;null!=p&&(h=Jo({inputs:{x:s},backend:a,attrs:{perm:p}}),d=r.getInnerMostAxes(d.length,l)),r.assertAxesAreInnerMostDims("any",d,l);const[f,x]=r.computeOutAndReduceShapes(h.shape,d),g=Uo({inputs:{x:h},backend:a,attrs:{shape:[-1,e.sizeFromShape(x)]}}),m=jo(g,g.dtype,"any",a);let b;if(u){b=Uo({inputs:{x:m},backend:a,attrs:{shape:r.expandShapeToKeepDim(f,c)}})}else b=Uo({inputs:{x:m},backend:a,attrs:{shape:f}});return a.disposeIntermediateTensorInfo(g),a.disposeIntermediateTensorInfo(m),null!=p&&a.disposeIntermediateTensorInfo(h),b}};class hs{constructor(e,n,t){this.variableNames=["A"];const{windowSize:r,batchSize:a,outSize:o}=e;t||this.variableNames.push("bestIndicesA"),this.outputShape=[a,o];const s="max"===n?">":"<",i=t?"inOffset + i;":"round(getBestIndicesA(batch, inOffset + i));";this.userCode=`\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int batch = coords[0];\n        int outIdx = coords[1];\n        int inOffset = outIdx * ${r};\n\n        int bestIndex = inOffset;\n        float bestValue = getA(batch, bestIndex);\n\n        for (int i = 0; i < ${r}; i++) {\n          int inIdx = ${i};\n          float candidate = getA(batch, inIdx);\n          if (candidate ${s} bestValue) {\n            bestValue = candidate;\n            bestIndex = inIdx;\n          }\n        }\n        setOutput(float(bestIndex));\n      }\n    `}}class fs{constructor(n,t,r,a){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,e.assert(n.length>2,()=>`Packed arg${r.charAt(0).toUpperCase()+r.slice(1)} supports only inputs with rank above 2.`);const o=n[n.length-1],s=Math.ceil(o/t);this.outputShape=n.slice(0,-1),s>1&&this.outputShape.push(s),a||this.variableNames.push("bestIndicesA");const i=this.outputShape,u=i.length,l=ra(u),c=no("coords",u);let d,p;if(1===s){p=u+1;const e=ra(p);d=`\n        ${e} sourceLocR = ${e}(${c.join()}, 0);\n        ++${c[u-1]};\n        ${e} sourceLocG = ${e}(${c.join()}, 0);\n        ++${c[u-2]};\n        ${e} sourceLocA = ${e}(${c.join()}, 0);\n        --${c[u-1]};\n        ${e} sourceLocB = ${e}(${c.join()}, 0);\n        --${c[u-2]};`}else p=u,d=`\n        ${l} sourceLocR = coords;\n        ++${c[u-1]};\n        ${l} sourceLocG = coords;\n        ++${c[u-2]};\n        ${l} sourceLocA = coords;\n        --${c[u-1]};\n        ${l} sourceLocB = coords;\n        --${c[u-2]};`;const h=["x","y","z","w","u","v"].slice(0,p),f="."+h[p-1],x=h.map(e=>"int "+e),g=no("sourceLocR",p-1).concat("inIdx.r"),m=no("sourceLocG",p-1).concat("inIdx.g"),b=no("sourceLocB",p-1).concat("inIdx.b"),C=no("sourceLocA",p-1).concat("inIdx.a"),v="max"===r?"greaterThan":"lessThan",$=a?"":`\n          inIdx = round(vec4(getBestIndicesAChannel(${g.join()}),\n                             getBestIndicesAChannel(${m.join()}),\n                             getBestIndicesAChannel(${b.join()}),\n                             getBestIndicesAChannel(${C.join()})));`,I=`vec4(\n            getAChannel(${g.join()}),\n            hasNextCol ? getAChannel(${m.join()}) : 0.,\n            hasNextRow ? getAChannel(${b.join()}) : 0.,\n            hasNextRow && hasNextCol ? getAChannel(${C.join()}) : 0.)`,R=a?"":`\n      float getBestIndicesAChannel(${x.join()}) {\n        return getChannel(getBestIndicesA(${h.join()}),\n                                          vec2(${h.slice(-2).join()}));\n      }`;this.userCode=`\n      float getAChannel(${x.join()}) {\n        return getChannel(getA(${h.join()}),\n                               vec2(${h.slice(-2).join()}));\n      }\n      ${R}\n      void main() {\n        ${l} coords = getOutputCoords();\n        bool hasNextCol = ${c[u-1]} < ${i[u-1]-1};\n        bool hasNextRow = ${c[u-2]} < ${i[u-2]-1};\n        ${d}\n        ivec4 srcIdx = ivec4(sourceLocR${f}, sourceLocG${f},\n          sourceLocB${f}, sourceLocA${f}) * ${t};\n        ivec4 inIdx = srcIdx;\n        vec4 bestIndex = vec4(inIdx);\n        vec4 bestValue = ${I};\n\n        for (int i = 0; i < ${t}; i++) {\n          inIdx = srcIdx;\n          ${$}\n          vec4 candidate = ${I};\n          bvec4 nan = isnan(candidate);\n          bvec4 replace = bvec4(\n            vec4(${v}(candidate, bestValue)) * (vec4(1.0) - vec4(nan)));\n\n          bestValue = vec4(replace.x  ? candidate.x : bestValue.x,\n                           replace.y  ? candidate.y : bestValue.y,\n                           replace.z  ? candidate.z : bestValue.z,\n                           replace.w  ? candidate.w : bestValue.w);\n          bestIndex = mix(bestIndex, vec4(inIdx), vec4(replace));\n          srcIdx++;\n        }\n        setOutput(bestIndex);\n      }\n    `}}function xs(t,a,o,s){const i=[o];if(r.assertAxesAreInnerMostDims("arg"+s.charAt(0).toUpperCase()+s.slice(1),i,a.shape.length),!n().getBool("WEBGL_PACK_REDUCE")||a.shape.length<=2){const n=[],[o,u]=r.computeOutAndReduceShapes(a.shape,i),l=e.sizeFromShape(u),c=Uo({inputs:{x:a},backend:t,attrs:{shape:[-1,l]}});n.push(c);const d=function e(n,t,a,o=null){let s=t.shape[0],i=t.shape[1];null!=o&&(s=o.shape[0],i=o.shape[1]);const u=r.computeOptimalWindowSize(i),l={windowSize:u,inSize:i,batchSize:s,outSize:Math.ceil(i/u)},c=new hs(l,a,null==o),d=[t];null!=o&&d.push(o);const p=n.runWebGLProgram(c,d,"int32");if(1===p.shape[1])return p;const h=e(n,t,a,p);return n.disposeIntermediateTensorInfo(p),h}(t,c,s);n.push(d);const p=Uo({inputs:{x:d},backend:t,attrs:{shape:o}});return n.forEach(e=>t.disposeIntermediateTensorInfo(e)),p}return function e(n,t,a,o=null){const s=null!=o?o.shape:t.shape,i=s[s.length-1],u=r.computeOptimalWindowSize(i),l=new fs(s,u,a,null==o),c=null==o?[t]:[t,o],d=n.runWebGLProgram(l,c,"int32");if(d.shape.length===t.shape.length){const r=e(n,t,a,d);return n.disposeIntermediateTensorInfo(d),r}return d}(t,a,s)}const gs={kernelName:F,backendName:"webgl",kernelFunc:function(n){const{inputs:t,backend:a,attrs:o}=n,{x:s}=t,{axis:i}=o;let u=e.parseAxisParam(i,s.shape);const l=r.getAxesPermutation(u,s.shape.length);let c=s;const d=[];null!=l&&(c=Jo({inputs:{x:s},backend:a,attrs:{perm:l}}),d.push(c),u=r.getInnerMostAxes(u.length,c.shape.length)),r.assertAxesAreInnerMostDims("argMax",[u[0]],c.shape.length);const p=xs(a,c,u[0],"max");return d.forEach(e=>a.disposeIntermediateTensorInfo(e)),p}};const ms={kernelName:O,backendName:"webgl",kernelFunc:function(n){const{inputs:t,backend:a,attrs:o}=n,{x:s}=t,{axis:i}=o;let u=e.parseAxisParam(i,s.shape);const l=r.getAxesPermutation(u,s.shape.length);let c=s;const d=[];null!=l&&(c=Jo({inputs:{x:s},backend:a,attrs:{perm:l}}),d.push(c),u=r.getInnerMostAxes(u.length,c.shape.length)),r.assertAxesAreInnerMostDims("argMin",[u[0]],c.shape.length);const p=xs(a,c,u[0],"min");return d.forEach(e=>a.disposeIntermediateTensorInfo(e)),p}},bs={kernelName:_,backendName:"webgl",kernelFunc:Oo({opSnippet:"if (isnan(x)) return x;\n  if (abs(x) > 1.) {\n    return NAN;\n  }\n  return asin(x);\n"})},Cs={kernelName:D,backendName:"webgl",kernelFunc:Oo({opSnippet:"if (isnan(x)) return x;return log(x + sqrt(x * x + 1.0));"})},vs={kernelName:L,backendName:"webgl",kernelFunc:Oo({opSnippet:"if (isnan(x)) return x;\n  return atan(x);\n"})},$s={kernelName:P,backendName:"webgl",kernelFunc:_o({opSnippet:"\n  if (isnan(a)) return a;\n  if (isnan(b)) return b;\n\n  return atan(a, b);\n",packedOpSnippet:"\n  vec4 result = atan(a, b);\n  vec4 isNaN = min(vec4(isnan(a)) + vec4(isnan(b)), vec4(1.0));\n  \n  result.r = isNaN.r > 0. ? NAN : result.r;\n  result.g = isNaN.g > 0. ? NAN : result.g;\n  result.b = isNaN.b > 0. ? NAN : result.b;\n  result.a = isNaN.a > 0. ? NAN : result.a;\n\n  return result;\n"})},Is={kernelName:B,backendName:"webgl",kernelFunc:Oo({opSnippet:"if (isnan(x)) return x;\n  if ((x < -1.0) || (x > 1.0)) return NAN;\nreturn (log(1.0 + x) - log(1.0 - x)) / 2.0;"})};class Rs{constructor(e,n,t,r=!1,a=!1){if(this.variableNames=["x"],"avg"===n&&t)throw new Error("Cannot compute positions for average pool.");const o=e.filterWidth,s=e.strideHeight,i=e.strideWidth,u=e.dilationHeight,l=e.dilationWidth,c=e.effectiveFilterHeight,d=e.effectiveFilterWidth,p=e.padInfo.top,h=e.padInfo.left;this.outputShape=e.outShape;const f="avg"===n,x=`((batch  * ${e.inHeight} + xR) * ${e.inWidth} + xC) * ${e.inChannels} + d`,g=`(xR * ${e.inWidth} + xC) * ${e.inChannels} + d`;let m="0.0";if(f||(m="-1.0 / 1e-20"),t){const n=">=";return void(this.userCode=`\n        const ivec2 strides = ivec2(${s}, ${i});\n        const ivec2 pads = ivec2(${p}, ${h});\n\n        void main() {\n          ivec4 coords = getOutputCoords();\n          int batch = coords[0];\n          int d = coords[3];\n\n          ivec2 xRCCorner = coords.yz * strides - pads;\n          int xRCorner = xRCCorner.x;\n          int xCCorner = xRCCorner.y;\n\n          // max/min x(?, ?, d) to get y(yR, yC, d).\n          // ? = to be determined\n          float minMaxValue = 0.0;\n          float minMaxValueFound = 0.0;\n          int minMaxPosition = 0;\n          float avgValue = 0.0;\n\n          for (int wR = 0; wR < ${c};\n              wR += ${u}) {\n            int xR = xRCorner + wR;\n\n            if (xR < 0 || xR >= ${e.inHeight}) {\n              continue;\n            }\n\n            for (int wC = 0; wC < ${d};\n                wC += ${l}) {\n              int xC = xCCorner + wC;\n\n              if (xC < 0 || xC >= ${e.inWidth}) {\n                continue;\n              }\n\n              float value = getX(batch, xR, xC, d);\n\n              // If a min / max value has already been found, use it. If not,\n              // use the current value.\n              float currMinMaxValue = mix(\n                  value, minMaxValue, minMaxValueFound);\n              if (value ${n} currMinMaxValue) {\n                minMaxValue = value;\n                minMaxValueFound = 1.0;\n                minMaxPosition = ${r?a?x:g:`wR * ${d} + wC`};\n              }\n            }\n          }\n          setOutput(float(minMaxPosition));\n        }\n      `)}let b=`${n}(${n}(${n}(`+"minMaxValue[0], minMaxValue[1]), minMaxValue[2]), minMaxValue[3])";"avg"===n&&(b="avgValue / count");const C=4*Math.floor(o/4),v=o%4,$=`\n      if (${f}) {\n        avgValue += dot(values, ones);\n      } else {\n        minMaxValue = max(values, minMaxValue);\n      }\n    `;this.userCode=`\n      const ivec2 strides = ivec2(${s}, ${i});\n      const ivec2 pads = ivec2(${p}, ${h});\n      const float initializationValue = ${m};\n      const vec4 ones = vec4(1.0, 1.0, 1.0, 1.0);\n\n      float count = 0.0;\n\n      float getValue(int batch, int xR, int xC, int d) {\n        if (xC < 0 || xC >= ${e.inWidth}) {\n          return initializationValue;\n        }\n        count += 1.0;\n        return getX(batch, xR, xC, d);\n      }\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords[0];\n        int d = coords[3];\n\n        ivec2 xRCCorner = coords.yz * strides - pads;\n        int xRCorner = xRCCorner.x;\n        int xCCorner = xRCCorner.y;\n\n        // max/min x(?, ?, d) to get y(yR, yC, d).\n        // ? = to be determined\n        vec4 minMaxValue = vec4(${m});\n        float avgValue = 0.0;\n        count = 0.0;\n\n        for (int wR = 0; wR < ${c};\n            wR += ${u}) {\n          int xR = xRCorner + wR;\n\n          if (xR < 0 || xR >= ${e.inHeight}) {\n            continue;\n          }\n\n          for (int wC = 0; wC < ${C}; wC += 4) {\n            int xC = xCCorner + wC * ${l};\n\n            vec4 values = vec4(\n              getValue(batch, xR, xC, d),\n              getValue(batch, xR, xC + ${l}, d),\n              getValue(batch, xR, xC + 2 * ${l}, d),\n              getValue(batch, xR, xC + 3 * ${l}, d)\n            );\n\n            ${$}\n          }\n\n          int xC = xCCorner + ${C};\n          if (${1===v}) {\n            vec4 values = vec4(\n              getValue(batch, xR, xC, d),\n              initializationValue,\n              initializationValue,\n              initializationValue\n            );\n\n            ${$}\n          } else if (${2===v}) {\n            vec4 values = vec4(\n              getValue(batch, xR, xC, d),\n              getValue(batch, xR, xC + ${l}, d),\n              initializationValue,\n              initializationValue\n            );\n\n            ${$}\n          } else if (${3===v}) {\n            vec4 values = vec4(\n              getValue(batch, xR, xC, d),\n              getValue(batch, xR, xC + ${l}, d),\n              getValue(batch, xR, xC + 2 * ${l}, d),\n              initializationValue\n            );\n\n            ${$}\n          }\n        }\n        setOutput(${b});\n      }\n    `}}class ys{constructor(e,n,t,r=!1,a=!1){if(this.variableNames=["x"],"avg"===n&&t)throw new Error("Cannot compute positions for average pool.");const o=e.filterWidth,s=e.strideDepth,i=e.strideHeight,u=e.strideWidth,l=e.dilationDepth,c=e.dilationHeight,d=e.dilationWidth,p=e.effectiveFilterDepth,h=e.effectiveFilterHeight,f=e.effectiveFilterWidth,x=e.padInfo.front,g=e.padInfo.top,m=e.padInfo.left;this.outputShape=e.outShape;const b="avg"===n;let C="0.0";if(b||(C="-1.0 / 1e-20"),t){const n=">=";return void(this.userCode=`\n        const ivec3 strides =\n            ivec3(${s}, ${i}, ${u});\n        const ivec3 pads = ivec3(${x}, ${g}, ${m});\n\n        void main() {\n          ivec5 coords = getOutputCoords();\n          int batch = coords.x;\n          int ch = coords.u;\n\n          ivec3 xCorner = ivec3(coords.y, coords.z, coords.w) * strides - pads;\n          int xDCorner = xCorner.x;\n          int xRCorner = xCorner.y;\n          int xCCorner = xCorner.z;\n\n          // max/min x(?, ?, ?, ch) to get y(yD, yR, yC, ch).\n          // ? = to be determined\n          float minMaxValue = 0.0;\n          float minMaxValueFound = 0.0;\n          int minMaxPosition = 0;\n\n          for (int wD = 0; wD < ${p};\n              wD += ${l}) {\n            int xD = xDCorner + wD;\n\n            if (xD < 0 || xD >= ${e.inDepth}) {\n              continue;\n            }\n\n            for (int wR = 0; wR < ${h};\n                wR += ${c}) {\n              int xR = xRCorner + wR;\n\n              if (xR < 0 || xR >= ${e.inHeight}) {\n                continue;\n              }\n\n              for (int wC = 0; wC < ${f};\n                  wC += ${d}) {\n                int xC = xCCorner + wC;\n\n                if (xC < 0 || xC >= ${e.inWidth}) {\n                  continue;\n                }\n\n                float value = getX(batch, xD, xR, xC, ch);\n\n                // If a min / max value has already been found, use it. If not,\n                // use the current value.\n                float currMinMaxValue = mix(\n                    value, minMaxValue, minMaxValueFound);\n                if (value ${n} currMinMaxValue) {\n                  minMaxValue = value;\n                  minMaxValueFound = 1.0;\n                  minMaxPosition = ${r?a?`(((batch * ${e.inDepth} + xD) * ${e.inHeight} + xR) * ${e.inWidth} + xC) * ${e.inChannels} + ch`:`((xD * ${e.inHeight} + xR) * ${e.inWidth} + xC) * ${e.inChannels} + ch`:`wD * ${h} * ${f} +\n                      wR * ${f} + wC`};\n                }\n              }\n            }\n          }\n          setOutput(float(minMaxPosition));\n        }\n      `)}let v=`${n}(${n}(${n}(`+"minMaxValue[0], minMaxValue[1]), minMaxValue[2]), minMaxValue[3])";"avg"===n&&(v="avgValue / count");const $=4*Math.floor(o/4),I=o%4,R=`\n      if (${b}) {\n        avgValue += dot(values, ones);\n      } else {\n        minMaxValue = max(values, minMaxValue);\n      }\n    `;this.userCode=`\n      const ivec3 strides =\n        ivec3(${s}, ${i}, ${u});\n      const ivec3 pads = ivec3(${x}, ${g}, ${m});\n      const float initializationValue = ${C};\n      const vec4 ones = vec4(1.0, 1.0, 1.0, 1.0);\n\n      float count = 0.0;\n\n      float getValue(int batch, int xD, int xR, int xC, int ch) {\n        if (xC < 0 || xC >= ${e.inWidth}) {\n          return initializationValue;\n        }\n        count += 1.0;\n        return getX(batch, xD, xR, xC, ch);\n      }\n\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int batch = coords.x;\n        int ch = coords.u;\n\n        ivec3 xCorner = ivec3(coords.y, coords.z, coords.w) * strides - pads;\n        int xDCorner = xCorner.x;\n        int xRCorner = xCorner.y;\n        int xCCorner = xCorner.z;\n\n        // max/min x(?, ?, ?, d) to get y(yD, yR, yC, ch).\n        // ? = to be determined\n        vec4 minMaxValue = vec4(${C});\n        float avgValue = 0.0;\n        count = 0.0;\n\n        for (int wD = 0; wD < ${p};\n            wD += ${l}) {\n          int xD = xDCorner + wD;\n\n          if (xD < 0 || xD >= ${e.inDepth}) {\n            continue;\n          }\n\n          for (int wR = 0; wR < ${h};\n            wR += ${c}) {\n            int xR = xRCorner + wR;\n\n            if (xR < 0 || xR >= ${e.inHeight}) {\n              continue;\n            }\n\n            for (int wC = 0; wC < ${$}; wC += 4) {\n              int xC = xCCorner + wC * ${d};\n\n              vec4 values = vec4(\n                getValue(batch, xD, xR, xC, ch),\n                getValue(batch, xD, xR, xC + ${d}, ch),\n                getValue(batch, xD, xR, xC + 2 * ${d}, ch),\n                getValue(batch, xD, xR, xC + 3 * ${d}, ch)\n              );\n\n              ${R}\n            }\n\n            int xC = xCCorner + ${$};\n            if (${1===I}) {\n              vec4 values = vec4(\n                getValue(batch, xD, xR, xC, ch),\n                initializationValue,\n                initializationValue,\n                initializationValue\n              );\n\n              ${R}\n            } else if (${2===I}) {\n              vec4 values = vec4(\n                getValue(batch, xD, xR, xC, ch),\n                getValue(batch, xD, xR, xC + ${d}, ch),\n                initializationValue,\n                initializationValue\n              );\n\n              ${R}\n            } else if (${3===I}) {\n              vec4 values = vec4(\n                getValue(batch, xD, xR, xC, ch),\n                getValue(batch, xD, xR, xC + ${d}, ch),\n                getValue(batch, xD, xR, xC + 2 * ${d}, ch),\n                initializationValue\n              );\n\n              ${R}\n            }\n          }\n          setOutput(${v});\n        }\n      }\n    `}}const ws={kernelName:W,backendName:"webgl",kernelFunc:function(n){const{inputs:t,backend:a,attrs:o}=n,{x:s}=t;lr(s,"avgPool");const{filterSize:i,strides:u,pad:l,dimRoundingMode:c}=o;e.assert(r.eitherStridesOrDilationsAreOne(u,1),()=>"Error in avgPool: Either strides or dilations must be 1. "+`Got strides ${u} and dilations '1'`);const d=r.computePool2DInfo(s.shape,i,u,1,l,c);if(1===d.filterWidth&&1===d.filterHeight&&e.arraysEqual(d.inShape,d.outShape))return Ro({inputs:{x:s},backend:a});const p=new Rs(d,"avg",!1);return a.runWebGLProgram(p,[s],"float32")}};const ks={kernelName:V,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t,attrs:a}=e,{x:o}=n,{filterSize:s,strides:i,pad:u,dimRoundingMode:l,dataFormat:c}=a,d=r.computePool3DInfo(o.shape,s,i,[1,1,1],u,l,c),p=new ys(d,"avg",!1);return t.runWebGLProgram(p,[o],"float32")}};class Ts{constructor(e){this.variableNames=["dy"],this.outputShape=e.inShape;const n=e.filterHeight,t=e.filterWidth,r=e.strideHeight,a=e.strideWidth,o=e.dilationHeight,s=e.dilationWidth,i=e.effectiveFilterHeight,u=e.effectiveFilterWidth,l=i-1-e.padInfo.top,c=u-1-e.padInfo.left,d=1/(n*t);this.userCode=`\n      const ivec2 pads = ivec2(${l}, ${c});\n      const float avgMultiplier = float(${d});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n\n        ivec2 dyRCCorner = coords.yz - pads;\n        int dyRCorner = dyRCCorner.x;\n        int dyCCorner = dyRCCorner.y;\n\n        // Convolve dy(?, ?, d) with pos mask(:, :, d) to get dx(xR, xC, d).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n        for (int wR = 0; wR < ${i};\n            wR += ${o}) {\n          float dyR = float(dyRCorner + wR) / ${r}.0;\n\n          if (dyR < 0.0 || dyR >= ${e.outHeight}.0 || fract(dyR) > 0.0) {\n            continue;\n          }\n          int idyR = int(dyR);\n\n          for (int wC = 0; wC < ${u};\n            wC+= ${s}) {\n            float dyC = float(dyCCorner + wC) / ${a}.0;\n\n            if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                fract(dyC) > 0.0) {\n              continue;\n            }\n            int idyC = int(dyC);\n\n            float dyValue = getDy(b, idyR, idyC, d);\n\n            dotProd += dyValue * avgMultiplier;\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class Es{constructor(e){this.variableNames=["dy"],this.outputShape=e.inShape;const n=e.filterDepth,t=e.filterHeight,r=e.filterWidth,a=e.strideDepth,o=e.strideHeight,s=e.strideWidth,i=e.dilationDepth,u=e.dilationHeight,l=e.dilationWidth,c=e.effectiveFilterDepth,d=e.effectiveFilterHeight,p=e.effectiveFilterWidth,h=c-1-e.padInfo.front,f=d-1-e.padInfo.top,x=p-1-e.padInfo.left,g=1/(n*t*r);this.userCode=`\n      const ivec3 pads = ivec3(${h}, ${f}, ${x});\n      const float avgMultiplier = float(${g});\n\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int batch = coords.x;\n        int ch = coords.u;\n\n        ivec3 dyCorner = ivec3(coords.y, coords.z, coords.w) - pads;\n        int dyDCorner = dyCorner.x;\n        int dyRCorner = dyCorner.y;\n        int dyCCorner = dyCorner.z;\n\n        // Convolve dy(?, ?, ?, d) with pos mask(:, :, :, ch) to get\n        // dx(xD, xR, xC, ch).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n\n        for (int wD = 0; wD < ${c};\n            wD += ${i}) {\n          float dyD = float(dyDCorner + wD) / ${a}.0;\n\n          if (dyD < 0.0 || dyD >= ${e.outDepth}.0 || fract(dyD) > 0.0) {\n            continue;\n          }\n          int idyD = int(dyD);\n\n          for (int wR = 0; wR < ${d};\n              wR += ${u}) {\n            float dyR = float(dyRCorner + wR) / ${o}.0;\n\n            if (dyR < 0.0 || dyR >= ${e.outHeight}.0 ||\n                fract(dyR) > 0.0) {\n              continue;\n            }\n            int idyR = int(dyR);\n\n            for (int wC = 0; wC < ${p};\n                wC += ${l}) {\n              float dyC = float(dyCCorner + wC) / ${s}.0;\n\n              if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                  fract(dyC) > 0.0) {\n                continue;\n              }\n              int idyC = int(dyC);\n\n              float dyValue = getDy(batch, idyD, idyR, idyC, ch);\n\n              dotProd += dyValue * avgMultiplier;\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}const Ns={kernelName:M,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t,attrs:a}=e,{dy:o,input:s}=n,i=s,{filterSize:u,strides:l,pad:c,dimRoundingMode:d}=a,p=r.computePool3DInfo(i.shape,u,l,[1,1,1],c,d),h=new Es(p);return t.runWebGLProgram(h,[o],i.dtype)}};const Ss={kernelName:G,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t,attrs:a}=e,{dy:o,input:s}=n,i=s;lr([o,s],"avgPoolGrad");const{filterSize:u,strides:l,pad:c}=a,d=r.computePool2DInfo(i.shape,u,l,1,c),p=new Ts(d);return t.runWebGLProgram(p,[o],i.dtype)}};const As={kernelName:U,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t,attrs:r}=e,{a:a,b:o}=n,{transposeA:s,transposeB:i}=r;return ns({a:a,b:o,transposeA:s,transposeB:i,backend:t})}};class Fs{constructor(e,n,t,a,o,s){this.outputShape=[],this.variableNames=["x","mean","variance"],r.assertAndGetBroadcastShape(e,n),r.assertAndGetBroadcastShape(e,t);let i="0.0";null!=a&&(r.assertAndGetBroadcastShape(e,a),this.variableNames.push("offset"),i="getOffsetAtOutCoords()");let u="1.0";null!=o&&(r.assertAndGetBroadcastShape(e,o),this.variableNames.push("scale"),u="getScaleAtOutCoords()"),this.outputShape=e,this.userCode=`\n      void main() {\n        float x = getXAtOutCoords();\n        float mean = getMeanAtOutCoords();\n        float variance = getVarianceAtOutCoords();\n        float offset = ${i};\n        float scale = ${u};\n        float inv = scale * inversesqrt(variance + float(${s}));\n        setOutput(dot(vec3(x, -mean, offset), vec3(inv, inv, 1)));\n      }\n    `}}class Os{constructor(e,n,t,a,o,s){this.packedInputs=!0,this.packedOutput=!0,this.variableNames=["x","mean","variance"],r.assertAndGetBroadcastShape(e,n),r.assertAndGetBroadcastShape(e,t);let i="vec4(0.0)";null!=a&&(r.assertAndGetBroadcastShape(e,a),this.variableNames.push("offset"),i="getOffsetAtOutCoords()");let u="vec4(1.0)";null!=o&&(r.assertAndGetBroadcastShape(e,o),this.variableNames.push("scale"),u="getScaleAtOutCoords()"),this.outputShape=e,this.userCode=`\n      void main() {\n        vec4 offset = ${i};\n        vec4 scale = ${u};\n\n        vec4 x = getXAtOutCoords();\n        vec4 mean = getMeanAtOutCoords();\n        vec4 variance = getVarianceAtOutCoords();\n\n        vec4 inv = scale * inversesqrt(variance + vec4(${s}));\n\n        setOutput((x - mean) * inv + offset);\n      }\n    `}}const _s={kernelName:z,backendName:"webgl",kernelFunc:({inputs:t,backend:r,attrs:a})=>{const{x:o,mean:s,variance:i,offset:u,scale:l}=t;e.assert(s.shape.length===i.shape.length,()=>"Batch normalization gradient requires mean and variance to have equal ranks."),e.assert(null==u||s.shape.length===u.shape.length,()=>"Batch normalization gradient requires mean and offset to have equal ranks."),e.assert(null==l||s.shape.length===l.shape.length,()=>"Batch normalization gradient requires mean and scale to have equal ranks.");let{varianceEpsilon:c}=a;null==c&&(c=.001);const d=[o,s,i];let p=null;null!=u&&(p=u.shape,d.push(u));let h=null;null!=l&&(h=l.shape,d.push(l));const f=n().getBool("WEBGL_PACK_NORMALIZATION")?new Os(o.shape,s.shape,i.shape,p,h,c):new Fs(o.shape,s.shape,i.shape,p,h,c);return r.runWebGLProgram(f,d,d[0].dtype)}};class Ds{constructor(e){this.variableNames=["source"],this.outputShape=e,this.rank=e.length;const n=ra(this.rank),t=`uniform int start[${this.rank}];`,r=function(e){if(1===e)return"sourceLoc";if(e<=6)return Ls.slice(0,e).map(e=>"sourceLoc."+e).join(",");throw Error(`Slicing for rank ${e} is not yet supported`)}(this.rank);let a;a=`\n        ${n} sourceLoc;\n        ${n} coords = getOutputCoords();\n        ${e.map((e,n)=>`sourceLoc.${Ls[n]} = start[${n}] + coords.${Ls[n]};`).join("\n")}\n      `,this.userCode=`\n      ${t}\n      void main() {\n        ${a}\n        setOutput(getSource(${r}));\n      }\n    `}getCustomSetupFunc(e){if(e.length!==this.rank)throw Error(`The rank (${this.rank}) of the program must match the `+`length of start (${e.length})`);return(n,t)=>{null==this.startLoc&&(this.startLoc=n.getUniformLocationNoThrow(t,"start"),null==this.startLoc)||n.gl.uniform1iv(this.startLoc,e)}}}const Ls=["x","y","z","w","u","v"];class Ps{constructor(e){this.variableNames=["source"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=e,this.rank=e.length;const n=ra(this.rank),t=no("coords",this.rank),r=no("sourceLoc",this.rank),a=1===this.rank?"sourceLoc":`vec2(${r.slice(-2).join()})`,o=`getChannel(getSource(${r.join()}), ${a})`,s=`\n      result.x = ${o};\n      if (++${t[this.rank-1]} < ${e[this.rank-1]}) {\n        ++${r[this.rank-1]};\n        result.y = ${o};\n        --${r[this.rank-1]};\n      }\n    `,i=1===this.rank?"":`\n      --${t[this.rank-1]};\n      if (++${t[this.rank-2]} < ${e[this.rank-2]}) {\n        ++${r[this.rank-2]};\n        result.z = ${o};\n        if (++${t[this.rank-1]} < ${e[this.rank-1]}) {\n          ++${r[this.rank-1]};\n          result.w = ${o};\n        }\n      }\n    `,u=this.rank<=4?`sourceLoc = coords +\n            ${n}(${e.map((e,n)=>`start[${n}]`).join()});`:e.map((e,n)=>`${r[n]} = ${t[n]} + start[${n}];`).join("\n");this.userCode=`\n      uniform int start[${this.rank}];\n      void main() {\n        ${n} coords = getOutputCoords();\n        ${n} sourceLoc;\n        ${u}\n        vec4 result = vec4(0.);\n        ${s}\n        ${i}\n        setOutput(result);\n      }\n    `}getCustomSetupFunc(e){if(e.length!==this.rank)throw Error(`The rank (${this.rank}) of the program must match the `+`length of start (${e.length})`);return(n,t)=>{null==this.startLoc&&(this.startLoc=n.getUniformLocationNoThrow(t,"start"),null==this.startLoc)||n.gl.uniform1iv(this.startLoc,e)}}}function Bs(t){const{inputs:r,backend:a,attrs:o}=t,{x:i}=r,{begin:u,size:l}=o,[c,d]=s.parseSliceParams(i,u,l);if(s.assertParamsValid(i,c,d),0===e.sizeFromShape(d))return a.makeTensorInfo(d,i.dtype,[]);if(a.shouldExecuteOnCPU([i])||"string"===i.dtype){const e=a.texData.get(i.dataId),n=ja(e.values,c,d,i.shape,i.dtype);return a.makeTensorInfo(d,i.dtype,n)}const{isPacked:p}=a.texData.get(i.dataId),h=s.isSliceContinous(i.shape,c,d);if(p||!h){const e=n().getBool("WEBGL_PACK_ARRAY_OPERATIONS")?new Ps(d):new Ds(d),t=e.getCustomSetupFunc(c);return a.runWebGLProgram(e,[i],i.dtype,t)}return a.uploadToGPU(i.dataId),function(n,t,r,a){const o=a.texData.get(n.dataId),i=a.makeTensorInfo(r,n.dtype),u=a.texData.get(i.dataId);Object.assign(u,o),u.refCount=1,u.shape=r,u.dtype=n.dtype;let l=s.computeFlatOffset(t,e.computeStrides(n.shape));o.slice&&(l+=o.slice.flatOffset),u.slice={flatOffset:l,origDataId:o.slice&&o.slice.origDataId||n.dataId};const c=a.dataRefCount.get(u.slice.origDataId)||1;return a.dataRefCount.set(u.slice.origDataId,c+1),i}(i,c,d,a)}const Ws={kernelName:X,backendName:"webgl",kernelFunc:Bs},Vs={kernelName:H,backendName:"webgl",kernelFunc:n=>{const{inputs:t,backend:a,attrs:o}=n,{x:s}=t,{blockShape:i,crops:u}=o;e.assert(s.shape.length<=4,()=>"batchToSpaceND for rank > 4 with a WebGL backend not implemented yet");const l=i.reduce((e,n)=>e*n),c=r.getReshaped(s.shape,i,l),d=r.getPermuted(c.length,i.length),p=r.getReshapedPermuted(s.shape,i,l),h=r.getSliceBeginCoords(u,i.length),f=r.getSliceSize(p,u,i.length),x=[],g=Uo({inputs:{x:s},backend:a,attrs:{shape:c}}),m=Jo({inputs:{x:g},backend:a,attrs:{perm:d}}),b=Uo({inputs:{x:m},backend:a,attrs:{shape:p}}),C=Bs({inputs:{x:b},backend:a,attrs:{begin:h,size:f}});return x.push(g),x.push(m),x.push(b),x.forEach(e=>a.disposeIntermediateTensorInfo(e)),C}};const Ms={kernelName:j,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t,attrs:r}=e,{x:a,weights:o}=n,{size:s}=r,i=t.readSync(a.dataId),u=t.readSync(o.dataId),l=ka(i,u,o.dtype,o.shape,s);return t.makeTensorInfo([s],o.dtype,l)}},Gs=_o({opSnippet:"return float(a != b);",dtype:"bool"}),Us={kernelName:K,backendName:"webgl",kernelFunc:Gs};function zs(e){const{inputs:n,backend:t}=e,{input:r}=n;return Ro({inputs:{x:t.texData.get(r.dataId).complexTensorInfos.real},backend:t})}const Xs={kernelName:q,backendName:"webgl",kernelFunc:zs};const Hs={kernelName:Y,backendName:"webgl",kernelFunc:function n(t){const{inputs:r,backend:a,attrs:o}=t,{x:s}=r,{dtype:i}=o;if("complex64"===i){if("complex64"===s.dtype)return Ro({inputs:{x:s},backend:a});const e=Q(s.shape),t=n({inputs:{x:s},backend:a,attrs:{dtype:"float32"}}),r=wo({inputs:{real:t,imag:e},backend:a});return e.dispose(),a.disposeIntermediateTensorInfo(t),r}if("complex64"===s.dtype){const e=zs({inputs:{input:s},backend:a}),t=n({inputs:{x:e},backend:a,attrs:{dtype:i}});return a.disposeIntermediateTensorInfo(e),t}if(!e.hasEncodingLoss(s.dtype,i)){const e=Ro({inputs:{x:s},backend:a});return{dataId:e.dataId,shape:e.shape,dtype:i}}if("int32"===i)return function(e,n){const t=new uo(e.shape,"return float(int(x));"),r=n.runWebGLProgram(t,[e],"int32");return{dataId:r.dataId,shape:r.shape,dtype:r.dtype}}(s,a);if("bool"===i){const n=a.makeTensorInfo([],"bool",e.getTypedArrayFromDType("bool",1)),t=Gs({inputs:{a:s,b:n},backend:a});return a.disposeIntermediateTensorInfo(n),t}throw new Error(`Error in Cast: failed to cast ${s.dtype} to ${i}`)}},js="return ceil(x);",Ks={kernelName:Z,backendName:"webgl",kernelFunc:Oo({opSnippet:js,packedOpSnippet:js,cpuKernelImpl:Ea})};class qs{constructor(e){this.variableNames=["A"],this.outputShape=e,this.userCode="\n      uniform float minVal;\n      uniform float maxVal;\n\n      void main() {\n        float value = getAAtOutCoords();\n        if (isnan(value)) {\n          setOutput(value);\n          return;\n        }\n\n        setOutput(clamp(value, minVal, maxVal));\n      }\n    "}getCustomSetupFunc(e,n){return(t,r)=>{null==this.minLoc&&(this.minLoc=t.getUniformLocationNoThrow(r,"minVal"),this.maxLoc=t.getUniformLocationNoThrow(r,"maxVal")),t.gl.uniform1f(this.minLoc,e),t.gl.uniform1f(this.maxLoc,n)}}}class Ys{constructor(e){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=e,this.userCode="\n      uniform float minVal;\n      uniform float maxVal;\n\n      void main() {\n        vec4 value = getAAtOutCoords();\n\n        if (any(isnan(value))) {\n          setOutput(value);\n          return;\n        }\n\n        setOutput(clamp(value, vec4(minVal), vec4(maxVal)));\n      }\n    "}getCustomSetupFunc(e,n){return(t,r)=>{null==this.minLoc&&(this.minLoc=t.getUniformLocationNoThrow(r,"minVal"),this.maxLoc=t.getUniformLocationNoThrow(r,"maxVal")),t.gl.uniform1f(this.minLoc,e),t.gl.uniform1f(this.maxLoc,n)}}}const Qs={kernelName:J,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:r,attrs:a}=e,{x:o}=t,{clipValueMin:s,clipValueMax:i}=a;let u;u=n().getBool("WEBGL_PACK_CLIP")?new Ys(o.shape):new qs(o.shape);const l=u.getCustomSetupFunc(s,i);return r.runWebGLProgram(u,[o],o.dtype,l)}};class Zs{constructor(e){this.variableNames=["real","imag"],this.outputShape=e,this.userCode="\n      void main() {\n        float re = abs(getRealAtOutCoords());\n        float im = abs(getImagAtOutCoords());\n        float mx = max(re, im);\n\n        // sadly the length function in glsl is not underflow-safe\n        // (at least not on Intel GPUs). So the safe solution is\n        // to ensure underflow-safety in all cases.\n        setOutput(\n          mx == 0.0 ? 0.0 : mx * length(vec2(1, min(re, im)/mx))\n        );\n      }\n    "}}function Js(e,n){return{dataId:n.dataId,dtype:n.dtype,shape:e.shape}}const ei={kernelName:ee,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t}=e,{x:r}=n,a=t.texData.get(r.dataId),o=new Zs(r.shape),s=[Js(r,a.complexTensorInfos.real),Js(r,a.complexTensorInfos.imag)];return t.runWebGLProgram(o,s,s[0].dtype)}};class ni{constructor(e){this.outputShape=[],this.outputShape=r.computeOutShape(e,1),this.variableNames=e.map((e,n)=>`T${n}`);const n=new Array(e.length-1);n[0]=e[0][1];for(let t=1;t<n.length;t++)n[t]=n[t-1]+e[t][1];const t=[`if (yC < ${n[0]}) setOutput(getT0(yR, yC));`];for(let e=1;e<n.length;e++){const r=n[e-1];t.push(`else if (yC < ${n[e]}) `+`setOutput(getT${e}(yR, yC-${r}));`)}const a=n.length,o=n[n.length-1];t.push(`else setOutput(getT${a}(yR, yC-${o}));`),this.userCode=`\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int yR = coords.x;\n        int yC = coords.y;\n\n        ${t.join("\n        ")}\n      }\n    `}}class ti{constructor(e,n){this.packedInputs=!0,this.packedOutput=!0,this.outputShape=[],this.outputShape=r.computeOutShape(e,n);const t=this.outputShape,a=t.length,o=ra(a),s=no("coords",a),i=["x","y","z","w","u","v"].slice(0,a);this.variableNames=e.map((e,n)=>`T${n}`);const u=new Array(e.length-1);u[0]=e[0][n];for(let t=1;t<u.length;t++)u[t]=u[t-1]+e[t][n];const l=i[n],c=i.slice(-2),d=i.join();let p=`if (${l} < ${u[0]}) {\n        return getChannel(\n            getT0(${d}), vec2(${c.join()}));\n        }`;for(let e=1;e<u.length;e++){const n=u[e-1];p+=`\n        if (${l} < ${u[e]}  && ${l} >= ${u[e-1]}) {\n          return getChannel(\n            getT${e}(${ri(i,l,n)}),\n            vec2(${ri(c,l,n)}));\n        }`}const h=u.length,f=u[u.length-1];p+=`\n        return getChannel(\n          getT${h}(${ri(i,l,f)}),\n          vec2(${ri(c,l,f)}));`,this.userCode=`\n      float getValue(${i.map(e=>"int "+e)}) {\n        ${p}\n      }\n\n      void main() {\n        ${o} coords = getOutputCoords();\n        vec4 result = vec4(getValue(${s}), 0., 0., 0.);\n\n        ${s[a-1]} = ${s[a-1]} + 1;\n        if (${s[a-1]} < ${t[a-1]}) {\n          result.g = getValue(${s});\n        }\n\n        ${s[a-2]} = ${s[a-2]} + 1;\n        if (${s[a-2]} < ${t[a-2]}) {\n          result.a = getValue(${s});\n        }\n\n        ${s[a-1]} = ${s[a-1]} - 1;\n        if (${s[a-2]} < ${t[a-2]} &&\n            ${s[a-1]} < ${t[a-1]}) {\n          result.b = getValue(${s});\n        }\n        setOutput(result);\n      }\n    `}}function ri(e,n,t){const r=e.indexOf(n);return e.map((e,n)=>n===r?`${e} - ${t}`:e).join()}function ai(e){const{inputs:n,backend:t}=e,{input:r}=n;return Ro({inputs:{x:t.texData.get(r.dataId).complexTensorInfos.imag},backend:t})}const oi={kernelName:ne,backendName:"webgl",kernelFunc:ai};function si(n,t,a){const o=r.computeOutShape(n.map(e=>e.shape),t);return{tensors2D:n.map(n=>Uo({inputs:{x:n},attrs:{shape:[-1,e.sizeFromShape(n.shape.slice(t))]},backend:a})),outShape:o}}function ii(t){const{inputs:a,backend:o,attrs:s}=t,{axis:i}=s,u=e.parseAxisParam(i,a[0].shape)[0],l=r.computeOutShape(a.map(e=>e.shape),u);if(0===e.sizeFromShape(l))return o.makeTensorInfo(l,a[0].dtype,[]);const c=a.filter(n=>e.sizeFromShape(n.shape)>0);if(1===c.length)return Ro({inputs:{x:c[0]},backend:o});const d=c.map(e=>e.shape);return r.assertParamsConsistent(d,u),function e(t,a,o){const s=t[0].dtype;if("complex64"===s){const n=t.map(e=>zs({inputs:{input:e},backend:o})),r=t.map(e=>ai({inputs:{input:e},backend:o})),s=e(n,a,o),i=e(r,a,o),u=wo({inputs:{real:s,imag:i},backend:o});return n.forEach(e=>o.disposeIntermediateTensorInfo(e)),r.forEach(e=>o.disposeIntermediateTensorInfo(e)),o.disposeIntermediateTensorInfo(s),o.disposeIntermediateTensorInfo(i),u}if("string"===s){const{tensors2D:e,outShape:n}=si(t,a,o),i=e.map(e=>({vals:o.readSync(e.dataId),shape:e.shape})),u=1===e[0].shape[0],l=Na(i,n,s,u),c=r.computeOutShape(t.map(e=>e.shape),a),d=o.makeTensorInfo(c,s,l);return e.forEach(e=>o.disposeIntermediateTensorInfo(e)),d}if(t.length>n().getNumber("WEBGL_MAX_TEXTURES_IN_SHADER")){const n=Math.floor(t.length/2),r=e(t.slice(0,n),a,o),s=e(t.slice(n),a,o),i=e([r,s],a,o);return o.disposeIntermediateTensorInfo(r),o.disposeIntermediateTensorInfo(s),i}if(n().getBool("WEBGL_PACK_ARRAY_OPERATIONS")&&t[0].shape.length>1){const e=new ti(t.map(e=>e.shape),a);return o.runWebGLProgram(e,t,s)}const{tensors2D:i,outShape:u}=si(t,a,o),l=new ni(i.map(e=>e.shape)),c=o.runWebGLProgram(l,i,s);i.forEach(e=>o.disposeIntermediateTensorInfo(e));const d=Uo({inputs:{x:c},attrs:{shape:u},backend:o});return o.disposeIntermediateTensorInfo(c),d}(c,u,o)}const ui={kernelName:te,backendName:"webgl",kernelFunc:ii};class li{constructor(e,n=!1,t=null,r=!1,a=!1){this.variableNames=["x","W"],this.outputShape=e.outShape;const o=e.padInfo.top,s=e.padInfo.left,i=e.strideHeight,u=e.strideWidth,l=e.dilationHeight,c=e.dilationWidth,d=e.filterHeight,p=e.filterWidth,h=4*Math.floor(e.inChannels/4),f=e.inChannels%4,x="channelsLast"===e.dataFormat,g=x?1:2,m=x?2:3,b=x?3:1;let C="",v="";t&&(C=r?`float activation(float a) {\n          float b = getPreluActivationWeightsAtOutCoords();\n          ${t}\n        }`:a?`float activation(float a) {\n          float b = getLeakyreluAlphaAtOutCoords();\n          ${t}\n        }`:`\n          float activation(float x) {\n            ${t}\n          }\n        `,v="result = activation(result);");const $=n?"result += getBiasAtOutCoords();":"";n&&this.variableNames.push("bias"),r&&this.variableNames.push("preluActivationWeights"),a&&this.variableNames.push("leakyreluAlpha"),this.userCode=`\n      ${C}\n\n      const ivec2 strides = ivec2(${i}, ${u});\n      const ivec2 pads = ivec2(${o}, ${s});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords[0];\n        int d2 = coords[${b}];\n\n        ivec2 xRCCorner =\n            ivec2(coords[${g}], coords[${m}]) * strides - pads;\n        int xRCorner = xRCCorner.x;\n        int xCCorner = xRCCorner.y;\n\n        // Convolve x(?, ?, d1) with w(:, :, d1, d2) to get y(yR, yC, d2).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n        for (int wR = 0; wR < ${d}; wR++) {\n          int xR = xRCorner + wR * ${l};\n\n          if (xR < 0 || xR >= ${e.inHeight}) {\n            continue;\n          }\n\n          for (int wC = 0; wC < ${p}; wC++) {\n            int xC = xCCorner + wC * ${c};\n\n            if (xC < 0 || xC >= ${e.inWidth}) {\n              continue;\n            }\n\n            for (int d1 = 0; d1 < ${h}; d1 += 4) {\n              vec4 wValues = vec4(\n                getW(wR, wC, d1, d2),\n                getW(wR, wC, d1 + 1, d2),\n                getW(wR, wC, d1 + 2, d2),\n                getW(wR, wC, d1 + 3, d2)\n              );\n\n              if (${x}) {\n                vec4 xValues = vec4(\n                  getX(batch, xR, xC, d1),\n                  getX(batch, xR, xC, d1 + 1),\n                  getX(batch, xR, xC, d1 + 2),\n                  getX(batch, xR, xC, d1 + 3)\n                );\n                dotProd += dot(xValues, wValues);\n              } else {\n                vec4 xValues = vec4(\n                  getX(batch, d1, xR, xC),\n                  getX(batch, d1 + 1, xR, xC),\n                  getX(batch, d1 + 2, xR, xC),\n                  getX(batch, d1 + 3, xR, xC)\n                );\n                dotProd += dot(xValues, wValues);\n              }\n            }\n\n            if (${1===f}) {\n\n              if (${x}) {\n                dotProd +=\n                    getX(batch, xR, xC, ${h}) *\n                    getW(wR, wC, ${h}, d2);\n              } else {\n                dotProd +=\n                    getX(batch, ${h}, xR, xC) *\n                    getW(wR, wC, ${h}, d2);\n              }\n\n            } else if (${2===f}) {\n              vec2 wValues = vec2(\n                getW(wR, wC, ${h}, d2),\n                getW(wR, wC, ${h} + 1, d2)\n              );\n\n              if (${x}) {\n                vec2 xValues = vec2(\n                  getX(batch, xR, xC, ${h}),\n                  getX(batch, xR, xC, ${h} + 1)\n                );\n                dotProd += dot(xValues, wValues);\n              } else {\n                vec2 xValues = vec2(\n                  getX(batch, ${h}, xR, xC),\n                  getX(batch, ${h} + 1, xR, xC)\n                );\n                dotProd += dot(xValues, wValues);\n              }\n\n            } else if (${3===f}) {\n              vec3 wValues = vec3(\n                getW(wR, wC, ${h}, d2),\n                getW(wR, wC, ${h} + 1, d2),\n                getW(wR, wC, ${h} + 2, d2)\n              );\n\n              if (${x}) {\n                vec3 xValues = vec3(\n                  getX(batch, xR, xC, ${h}),\n                  getX(batch, xR, xC, ${h} + 1),\n                  getX(batch, xR, xC, ${h} + 2)\n                );\n                dotProd += dot(xValues, wValues);\n              } else {\n                vec3 xValues = vec3(\n                  getX(batch, ${h}, xR, xC),\n                  getX(batch, ${h} + 1, xR, xC),\n                  getX(batch, ${h} + 2, xR, xC)\n                );\n                dotProd += dot(xValues, wValues);\n              }\n\n            }\n          }\n        }\n\n        float result = dotProd;\n        ${$}\n        ${v}\n        setOutput(result);\n      }\n    `}}class ci{constructor(e){this.variableNames=["x","W"],this.outputShape=e.outShape;const n=e.padInfo.front,t=e.padInfo.top,r=e.padInfo.left,a=e.strideDepth,o=e.strideHeight,s=e.strideWidth,i=e.dilationDepth,u=e.dilationHeight,l=e.dilationWidth,c=e.filterDepth,d=e.filterHeight,p=e.filterWidth,h=4*Math.floor(e.inChannels/4),f=e.inChannels%4;this.userCode=`\n      const ivec3 strides = ivec3(${a}, ${o}, ${s});\n      const ivec3 pads = ivec3(${n}, ${t}, ${r});\n\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int batch = coords.x;\n        int d2 = coords.u;\n\n        ivec3 xFRCCorner = ivec3(coords.y, coords.z, coords.w) * strides - pads;\n        int xFCorner = xFRCCorner.x;\n        int xRCorner = xFRCCorner.y;\n        int xCCorner = xFRCCorner.z;\n\n        // Convolve x(?, ?, ?, d1) with w(:, :, :, d1, d2) to get\n        // y(yF, yR, yC, d2). ? = to be determined. : = across all\n        // values in that axis.\n        float dotProd = 0.0;\n        for (int wF = 0; wF < ${c}; wF++) {\n          int xF = xFCorner + wF * ${i};\n\n          if (xF < 0 || xF >= ${e.inDepth}) {\n            continue;\n          }\n\n          for (int wR = 0; wR < ${d}; wR++) {\n            int xR = xRCorner + wR * ${u};\n\n            if (xR < 0 || xR >= ${e.inHeight}) {\n              continue;\n            }\n\n            for (int wC = 0; wC < ${p}; wC++) {\n              int xC = xCCorner + wC * ${l};\n\n              if (xC < 0 || xC >= ${e.inWidth}) {\n                continue;\n              }\n\n              for (int d1 = 0; d1 < ${h}; d1 += 4) {\n                vec4 xValues = vec4(\n                  getX(batch, xF, xR, xC, d1),\n                  getX(batch, xF, xR, xC, d1 + 1),\n                  getX(batch, xF, xR, xC, d1 + 2),\n                  getX(batch, xF, xR, xC, d1 + 3)\n                );\n                vec4 wValues = vec4(\n                  getW(wF, wR, wC, d1, d2),\n                  getW(wF, wR, wC, d1 + 1, d2),\n                  getW(wF, wR, wC, d1 + 2, d2),\n                  getW(wF, wR, wC, d1 + 3, d2)\n                );\n\n                dotProd += dot(xValues, wValues);\n              }\n\n              if (${1===f}) {\n                dotProd +=\n                  getX(batch, xF, xR, xC, ${h}) *\n                  getW(wF, wR, wC, ${h}, d2);\n              } else if (${2===f}) {\n                vec2 xValues = vec2(\n                  getX(batch, xF, xR, xC, ${h}),\n                  getX(batch, xF, xR, xC, ${h} + 1)\n                );\n                vec2 wValues = vec2(\n                  getW(wF, wR, wC, ${h}, d2),\n                  getW(wF, wR, wC, ${h} + 1, d2)\n                );\n                dotProd += dot(xValues, wValues);\n              } else if (${3===f}) {\n                vec3 xValues = vec3(\n                  getX(batch, xF, xR, xC, ${h}),\n                  getX(batch, xF, xR, xC, ${h} + 1),\n                  getX(batch, xF, xR, xC, ${h} + 2)\n                );\n                vec3 wValues = vec3(\n                  getW(wF, wR, wC, ${h}, d2),\n                  getW(wF, wR, wC, ${h} + 1, d2),\n                  getW(wF, wR, wC, ${h} + 2, d2)\n                );\n                dotProd += dot(xValues, wValues);\n              }\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class di{constructor(e,n,t){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=e;const{filterWidth:r,inChannels:a,strideWidth:o,strideHeight:s,padInfo:i,outWidth:u,dilationWidth:l,dilationHeight:c,dataFormat:d}=t,{left:p,top:h}=i,f=a*r,x=pr(),g="channelsLast"===d,m=g?0:1,b=g?1:2;let C="";for(let t=0;t<=1;t++)for(let r=0;r<=1;r++)C+=`\n          blockIndex = rc.y + ${r};\n          pos = rc.x + ${t};\n\n          if(blockIndex < ${e[1]} && pos < ${e[0]}) {\n            offsetY = int(blockIndex / (${u})) * ${s} - ${h};\n            d0 = offsetY + ${c} * (pos / ${f});\n\n            if(d0 < ${n[m]} && d0 >= 0) {\n\n              offsetX = int(mod(float(blockIndex), ${u}.) * ${o}. - ${p}.);\n              d1 = offsetX + ${l} * (int(mod(float(pos), ${f}.) / ${a}.));\n\n              if(d1 < ${n[b]} && d1 >= 0) {\n\n                ch = int(mod(float(pos), ${a}.));\n\n                if (${g}) {\n                  innerDims = vec2(d1, ch);\n                  result[${2*t+r}] = getChannel(\n                    getA(d0, int(innerDims.x),\n                    int(innerDims.y)), innerDims);\n                } else {\n                  innerDims = vec2(d0, d1);\n                  result[${2*t+r}] = getChannel(\n                    getA(ch, int(innerDims.x),\n                    int(innerDims.y)), innerDims);\n                }\n              }\n            }\n          }\n        `;this.userCode=`\n      void main() {\n        ivec2 rc = getOutputCoords();\n\n        vec4 result = vec4(0);\n\n        int blockIndex, pos, offsetY, d0, offsetX, d1, ch;\n        vec2 innerDims;\n\n        ${C}\n\n        ${x.output} = result;\n      }\n    `}}function pi({x:t,filter:r,convInfo:a,backend:o,bias:s=null,preluActivationWeights:i=null,leakyreluAlpha:u=0,activation:l=null}){const c=t.shape,d=o.texData.get(t.dataId),p=a.inChannels,h=c[0]*c[1]*c[2],f=a.outChannels,x="channelsLast"===a.dataFormat;let g;const m=[],b=(1===h||1===f)&&p>1e3,C=c[2]%2!=0&&!!d.isPacked;if(!b&&n().getBool("WEBGL_LAZILY_UNPACK")&&n().getBool("WEBGL_PACK_BINARY_OPERATIONS")&&C){const n=x?c[0]*c[1]*(c[2]+1):c[0]*c[2]*(c[3]+1),p={dataId:t.dataId,shape:[1,n,a.inChannels],dtype:t.dtype},h=d.shape;d.shape=d.shape.slice(),d.shape[d.shape.length-2]++,e.assert(Qt(d.shape,p.shape),()=>`packed reshape ${d.shape} to ${p.shape} isn't free`);const f=Uo({inputs:{x:r},backend:o,attrs:{shape:[1,a.inChannels,a.outChannels]}});m.push(f);const b=ns({a:p,b:f,backend:o,transposeA:!1,transposeB:!1,bias:s,activation:l,preluActivationWeights:i,leakyreluAlpha:u}),C=o.texData.get(b.dataId);e.assert(C.isPacked,()=>"batchMatMul result is expected to be packed"),d.shape=h,C.shape=a.outShape,g=Ro({inputs:{x:b},backend:o}),g.shape=a.outShape,m.push(b)}else{const e=Uo({inputs:{x:t},backend:o,attrs:{shape:[1,x?c[0]*c[1]*c[2]:c[0]*c[2]*c[3],a.inChannels]}}),n=Uo({inputs:{x:r},backend:o,attrs:{shape:[1,a.inChannels,a.outChannels]}}),d=ns({a:e,b:n,transposeA:!1,transposeB:!1,backend:o,bias:s,activation:l,preluActivationWeights:i,leakyreluAlpha:u});g=Uo({inputs:{x:d},backend:o,attrs:{shape:a.outShape}}),m.push(e),m.push(n),m.push(d)}for(const e of m)o.disposeIntermediateTensorInfo(e);return g}function hi({x:n,filter:t,convInfo:r,backend:a,bias:o=null,preluActivationWeights:s=null,leakyreluAlpha:i=0,activation:u=null}){const{filterWidth:l,filterHeight:c,inChannels:d,outWidth:p,outHeight:h,dataFormat:f}=r,x="channelsLast"===f,g=l*c*d,m=h*p,b=[g,m],C=[],v=Uo({inputs:{x:n},backend:a,attrs:{shape:n.shape.slice(1)}}),$=Uo({inputs:{x:t},backend:a,attrs:{shape:[1,g,e.sizeFromShape(t.shape)/g]}});C.push(v),C.push($);const I=new di(b,v.shape,r),R=a.runWebGLProgram(I,[v],"float32"),y=Uo({inputs:{x:R},backend:a,attrs:{shape:[1,b[0],b[1]]}});C.push(R),C.push(y);const w=null!=o,k=null!=s,T="leakyrelu"===u,E=u?Do(u,!0):null,N=new Lo(y.shape,$.shape,[1,m,r.outChannels],!0,!1,w,E,k,T),S=[y,$];if(o&&S.push(o),k&&S.push(s),T){const n=a.makeTensorInfo([],"float32",e.createScalarValue(i,"float32"));S.push(n),C.push(n)}const A=a.runWebGLProgram(N,S,"float32"),F=Uo({inputs:{x:A},backend:a,attrs:{shape:x?[1,h,p,r.outChannels]:[1,r.outChannels,h,p]}});C.push(A);for(const e of C)a.disposeIntermediateTensorInfo(e);return F}const fi={kernelName:re,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:a,attrs:o}=e,{x:s,filter:i}=t,{strides:u,pad:l,dataFormat:c,dilations:d,dimRoundingMode:p}=o,h=r.convertConv2DDataFormat(c),f=r.computeConv2DInfo(s.shape,i.shape,u,d,l,p,!1,h);let x;if(1!==f.filterHeight||1!==f.filterWidth||1!==f.dilationHeight||1!==f.dilationWidth||1!==f.strideHeight||1!==f.strideWidth||"SAME"!==f.padInfo.type&&"VALID"!==f.padInfo.type)if(n().getBool("WEBGL_CONV_IM2COL")&&1===s.shape[0])x=hi({x:s,filter:i,convInfo:f,backend:a});else{const e=new li(f);x=a.runWebGLProgram(e,[s,i],"float32")}else x=pi({x:s,filter:i,convInfo:f,backend:a});const g=Uo({inputs:{x:x},backend:a,attrs:{shape:f.outShape}});return a.disposeIntermediateTensorInfo(x),g}};class xi{constructor(e){this.variableNames=["x","dy"],this.outputShape=e.filterShape;const n=e.strideHeight,t=e.strideWidth,r=e.padInfo.top,a=e.padInfo.left,o="channelsLast"===e.dataFormat;this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int wR = coords.x;\n        int wC = coords.y;\n        int d1 = coords.z;\n        int d2 = coords.w;\n\n        // Convolve x(?, ?, d1) with dy(:, :, d2) to get dw(wR, wC, d1, d2).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n\n        for (int b = 0; b < ${e.batchSize}; b++) {\n          for (int yR = 0; yR < ${e.outHeight}; yR++) {\n            int xR = wR + yR * ${n} - ${r};\n\n            if (xR < 0 || xR >= ${e.inHeight}) {\n              continue;\n            }\n\n            for (int yC = 0; yC < ${e.outWidth}; yC++) {\n              int xC = wC + yC * ${t} - ${a};\n\n              if (xC < 0 || xC >= ${e.inWidth}) {\n                continue;\n              }\n\n              if (${o}) {\n                float dyValue = getDy(b, yR, yC, d2);\n                float xValue = getX(b, xR, xC, d1);\n                dotProd += (xValue * dyValue);\n              } else {\n                float dyValue = getDy(b, d2, yR, yC);\n                float xValue = getX(b, d1, xR, xC);\n                dotProd += (xValue * dyValue);\n              }\n\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class gi{constructor(e){this.variableNames=["dy","W"],this.outputShape=e.inShape;const n=e.filterHeight,t=e.filterWidth,r=e.strideHeight,a=e.strideWidth,o="channelsLast"===e.dataFormat,s=n-1-e.padInfo.top,i=t-1-e.padInfo.left,u=o?1:2,l=o?2:3,c=o?3:1;this.userCode=`\n      const ivec2 pads = ivec2(${s}, ${i});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords[0];\n        int d1 = coords[${c}];\n\n        ivec2 dyCorner = ivec2(coords[${u}], coords[${l}]) - pads;\n        int dyRCorner = dyCorner.x;\n        int dyCCorner = dyCorner.y;\n\n        // Convolve dy(?, ?, d2) with w(:, :, d1, d2) to compute dx(xR, xC, d1).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n        for (int wR = 0; wR < ${n}; wR++) {\n          float dyR = float(dyRCorner + wR) / ${r}.0;\n\n          if (dyR < 0.0 || dyR >= ${e.outHeight}.0 || fract(dyR) > 0.0) {\n            continue;\n          }\n          int idyR = int(dyR);\n\n          int wRPerm = ${n} - 1 - wR;\n\n          for (int wC = 0; wC < ${t}; wC++) {\n            float dyC = float(dyCCorner + wC) / ${a}.0;\n\n            if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                fract(dyC) > 0.0) {\n              continue;\n            }\n            int idyC = int(dyC);\n\n            int wCPerm = ${t} - 1 - wC;\n\n            for (int d2 = 0; d2 < ${e.outChannels}; d2++) {\n\n              if (${o}) {\n                float xValue = getDy(batch, idyR, idyC, d2);\n                float wValue = getW(wRPerm, wCPerm, d1, d2);\n                dotProd += xValue * wValue;\n              } else {\n                float xValue = getDy(batch, d2, idyR, idyC);\n                float wValue = getW(wRPerm, wCPerm, d1, d2);\n                dotProd += xValue * wValue;\n              }\n\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class mi{constructor(e){this.variableNames=["x","dy"],this.outputShape=e.filterShape;const n=e.strideDepth,t=e.strideHeight,r=e.strideWidth,a=e.padInfo.front,o=e.padInfo.top,s=e.padInfo.left;this.userCode=`\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int wF = coords.x;\n        int wR = coords.y;\n        int wC = coords.z;\n        int d1 = coords.w;\n        int d2 = coords.u;\n\n        float dotProd = 0.0;\n\n        for (int b = 0; b < ${e.batchSize}; b++) {\n          for (int yF = 0; yF < ${e.outDepth}; yF++) {\n            int xF = wF + yF * ${n} - ${a};\n\n            if (xF < 0 || xF >= ${e.inDepth}) {\n              continue;\n            }\n\n            for (int yR = 0; yR < ${e.outHeight}; yR++) {\n              int xR = wR + yR * ${t} - ${o};\n\n              if (xR < 0 || xR >= ${e.inHeight}) {\n                continue;\n              }\n\n              for (int yC = 0; yC < ${e.outWidth}; yC++) {\n                int xC = wC + yC * ${r} - ${s};\n\n                if (xC < 0 || xC >= ${e.inWidth}) {\n                  continue;\n                }\n\n                float dyValue = getDy(b, yF, yR, yC, d2);\n                float xValue = getX(b, xF, xR, xC, d1);\n                dotProd += (xValue * dyValue);\n              }\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class bi{constructor(e){this.variableNames=["dy","W"],this.outputShape=e.inShape;const n=e.filterDepth,t=e.filterHeight,r=e.filterWidth,a=e.strideDepth,o=e.strideHeight,s=e.strideWidth,i=n-1-e.padInfo.front,u=t-1-e.padInfo.top,l=r-1-e.padInfo.left;this.userCode=`\n      const ivec3 pads = ivec3(${i}, ${u}, ${l});\n\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int batch = coords.x;\n        int d1 = coords.u;\n\n\n        ivec3 dyCorner = ivec3(coords.y, coords.z, coords.w) - pads;\n        int dyFCorner = dyCorner.x;\n        int dyRCorner = dyCorner.y;\n        int dyCCorner = dyCorner.z;\n\n        float dotProd = 0.0;\n        for (int wF = 0; wF < ${n}; wF++) {\n          float dyF = float(dyFCorner + wF) / ${a}.0;\n\n          if (dyF < 0.0 || dyF >= ${e.outDepth}.0 || fract(dyF) > 0.0) {\n            continue;\n          }\n          int idyF = int(dyF);\n\n          int wFPerm = ${n} - 1 - wF;\n\n          for (int wR = 0; wR < ${t}; wR++) {\n            float dyR = float(dyRCorner + wR) / ${o}.0;\n\n            if (dyR < 0.0 || dyR >= ${e.outHeight}.0 ||\n              fract(dyR) > 0.0) {\n              continue;\n            }\n            int idyR = int(dyR);\n\n            int wRPerm = ${t} - 1 - wR;\n\n            for (int wC = 0; wC < ${r}; wC++) {\n              float dyC = float(dyCCorner + wC) / ${s}.0;\n\n              if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                  fract(dyC) > 0.0) {\n                continue;\n              }\n              int idyC = int(dyC);\n\n              int wCPerm = ${r} - 1 - wC;\n\n              for (int d2 = 0; d2 < ${e.outChannels}; d2++) {\n                float xValue = getDy(batch, idyF, idyR, idyC, d2);\n                float wValue = getW(wFPerm, wRPerm, wCPerm, d1, d2);\n                dotProd += xValue * wValue;\n              }\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}const Ci={kernelName:ae,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t,attrs:a}=e,{x:o,dy:s}=n,{strides:i,pad:u,dataFormat:l,dimRoundingMode:c,filterShape:d}=a,p=r.convertConv2DDataFormat(l),h=r.computeConv2DInfo(o.shape,d,i,1,u,c,!1,p),f=new xi(h);return t.runWebGLProgram(f,[o,s],"float32")}};const vi={kernelName:oe,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t,attrs:a}=e,{dy:o,filter:s}=n,{inputShape:i,strides:u,pad:l,dataFormat:c,dimRoundingMode:d}=a,p=r.convertConv2DDataFormat(c),h=r.computeConv2DInfo(i,s.shape,u,1,l,d,!1,p),f=new gi(h);return t.runWebGLProgram(f,[o,s],"float32")}};const $i={kernelName:se,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t,attrs:a}=e,{x:o,filter:s}=n,{strides:i,pad:u,dilations:l}=a,c=r.computeConv3DInfo(o.shape,s.shape,i,l,u),d=new ci(c);return t.runWebGLProgram(d,[o,s],"float32")}};const Ii={kernelName:ie,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t,attrs:a}=e,{x:o,dy:s}=n,{strides:i,pad:u,filterShape:l}=a,c=r.computeConv3DInfo(o.shape,l,i,1,u),d=new mi(c);return t.runWebGLProgram(d,[o,s],"float32")}};const Ri={kernelName:ue,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t,attrs:a}=e,{dy:o,filter:s}=n,{pad:i,strides:u,inputShape:l}=a,c=r.computeConv3DInfo(l,s.shape,u,1,i),d=new bi(c);return t.runWebGLProgram(d,[o,s],"float32")}},yi={kernelName:le,backendName:"webgl",kernelFunc:Oo({opSnippet:"if (isnan(x)) return x;\n  return cos(x);\n"})},wi={kernelName:ce,backendName:"webgl",kernelFunc:Oo({opSnippet:"\n  float e2x = exp(-x);\n  return (e2x + 1.0 / e2x) / 2.0;\n"})};class ki{constructor(e,n,t,r,a){this.variableNames=["Image","Boxes","BoxInd"],this.outputShape=[];const[o,s,i,u]=e,[l]=n,[c,d]=t;this.outputShape=[l,c,d,u];const p="bilinear"===r?1:0,[h,f]=[`${s-1}.0`,`${i-1}.0`],[x,g,m]=c>1?[`${(s-1)/(c-1)}`,"(y2-y1) * height_ratio",`y1*${h} + float(y)*(height_scale)`]:["0.0","0.0",`0.5 * (y1+y2) * ${h}`],[b,C,v]=d>1?[`${(i-1)/(d-1)}`,"(x2-x1) * width_ratio",`x1*${f} + float(x)*(width_scale)`]:["0.0","0.0",`0.5 * (x1+x2) * ${f}`];this.userCode=`\n      const float height_ratio = float(${x});\n      const float width_ratio = float(${b});\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int y = coords[1];\n        int x = coords[2];\n        int d = coords[3];\n\n        // get box vals\n        float y1 = getBoxes(b,0);\n        float x1 = getBoxes(b,1);\n        float y2 = getBoxes(b,2);\n        float x2 = getBoxes(b,3);\n\n        // get image in batch index\n        int bInd = round(getBoxInd(b));\n        if(bInd < 0 || bInd >= ${o}) {\n          return;\n        }\n\n        float height_scale = ${g};\n        float width_scale = ${C};\n\n        float in_y = ${m};\n        if( in_y < 0.0 || in_y > ${h} ) {\n          setOutput(float(${a}));\n          return;\n        }\n        float in_x = ${v};\n        if( in_x < 0.0 || in_x > ${f} ) {\n          setOutput(float(${a}));\n          return;\n        }\n\n        vec2 sourceFracIndexCR = vec2(in_x,in_y);\n        if(${p} == 1) {\n          // Compute the four integer indices.\n          ivec2 sourceFloorCR = ivec2(sourceFracIndexCR);\n          ivec2 sourceCeilCR = ivec2(ceil(sourceFracIndexCR));\n\n          float topLeft = getImage(b, sourceFloorCR.y, sourceFloorCR.x, d);\n          float bottomLeft = getImage(b, sourceCeilCR.y, sourceFloorCR.x, d);\n          float topRight = getImage(b, sourceFloorCR.y, sourceCeilCR.x, d);\n          float bottomRight = getImage(b, sourceCeilCR.y, sourceCeilCR.x, d);\n\n          vec2 fracCR = sourceFracIndexCR - vec2(sourceFloorCR);\n\n          float top = topLeft + (topRight - topLeft) * fracCR.x;\n          float bottom = bottomLeft + (bottomRight - bottomLeft) * fracCR.x;\n          float newValue = top + (bottom - top) * fracCR.y;\n          setOutput(newValue);\n        } else {\n          // Compute the coordinators of nearest neighbor point.\n          ivec2 sourceNearestCR = ivec2(floor(\n            sourceFracIndexCR + vec2(0.5,0.5)));\n          float newValue = getImage(b, sourceNearestCR.y, sourceNearestCR.x, d);\n          setOutput(newValue);\n        }\n      }\n    `}}const Ti={kernelName:de,backendName:"webgl",kernelFunc:e=>{const{inputs:n,backend:t,attrs:r}=e,{image:a,boxes:o,boxInd:s}=n,{cropSize:i,method:u,extrapolationValue:l}=r,c=new ki(a.shape,o.shape,i,u,l);return t.runWebGLProgram(c,[a,o,s],"float32")}};class Ei{constructor(e,n,t){this.variableNames=["x"],this.outputShape=e;const r=e.length,a=n?"0.0":`getX(${Ni(r,"coords")})`,o=e[e.length-1];let s="",i="";n?(s=t?`end != ${o-1}`:"end != 0",i=t?"end + 1":"end - 1"):(s=t?`end + pow2 < ${o}`:"end >= pow2",i=t?"end + pow2":"end - pow2"),this.userCode=`\n      uniform float index;\n      void main() {\n        ${ra(r)} coords = getOutputCoords();\n        int end = ${Si(r,"coords")};\n        float val = ${a};\n        int pow2 = int(pow(2.0, index));\n        if (${s}) {\n          int idx = ${i};\n          ${Si(r,"coords")} = idx;\n          val += getX(${Ni(r,"coords")});\n        }\n        setOutput(val);\n      }\n    `}getCustomSetupFunc(e){return(n,t)=>{null==this.index&&(this.index=n.getUniformLocation(t,"index")),n.gl.uniform1f(this.index,e)}}}function Ni(e,n){if(1===e)return`${n}`;if(2===e)return`${n}.x, ${n}.y`;if(3===e)return`${n}.x, ${n}.y, ${n}.z`;if(4===e)return`${n}.x, ${n}.y, ${n}.z, ${n}.w`;throw Error(`Cumulative sum for rank ${e} is not yet supported`)}function Si(e,n){if(1===e)return`${n}`;if(2===e)return`${n}.y`;if(3===e)return`${n}.z`;if(4===e)return`${n}.w`;throw Error(`Cumulative sum for rank ${e} is not yet supported`)}const Ai={kernelName:pe,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t,attrs:a}=e,{x:o}=n,{axis:s,exclusive:i,reverse:u}=a,l=o.shape.length,c=r.getAxesPermutation([s],l);let d=o;null!=c&&(d=Jo({inputs:{x:o},backend:t,attrs:{perm:c}}));const p=r.getInnerMostAxes(1,l)[0];if(p!==l-1)throw new Error(`WebGL cumsum shader expects an inner-most axis=${o.shape.length-1} `+`but got axis=${s}`);const h=d.shape[p];let f=Ro({inputs:{x:d},backend:t});for(let e=0;e<=Math.ceil(Math.log2(h))-1;e++){const n=new Ei(d.shape,!1,u),r=n.getCustomSetupFunc(e),a=f;f=t.runWebGLProgram(n,[f],f.dtype,r),t.disposeIntermediateTensorInfo(a)}if(i){const e=new Ei(d.shape,i,u),n=f;f=t.runWebGLProgram(e,[f],f.dtype),t.disposeIntermediateTensorInfo(n)}if(null!=c){const e=Jo({inputs:{x:f},backend:t,attrs:{perm:r.getUndoAxesPermutation(c)}});return t.disposeIntermediateTensorInfo(f),t.disposeIntermediateTensorInfo(d),e}return f}};const Fi={kernelName:he,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t,attrs:r}=e,{x:a,weights:o}=n,{size:s,binaryOutput:i}=r;if(1===a.shape.length){const e=t.readSync(a.dataId),n=t.readSync(o.dataId),r=ka(e,n,o.dtype,o.shape,s);return t.makeTensorInfo([s],o.dtype,r)}if(2===a.shape.length){const e=t.bufferSync(a),n=t.bufferSync(o),r=Ta(e,n,s,i);return t.makeTensorInfo(r.shape,o.dtype,r.values)}throw new Error("Error in denseBincount: input must be at most rank 2, but got rank"+`${a.shape.length}.`)}};class Oi{constructor(e,n,t){this.variableNames=["x"],this.outputShape=[],this.outputShape=e,this.blockSize=n,this.dataFormat=t,this.userCode=`\n    void main() {\n      ivec4 coords = getOutputCoords();\n      int b = coords[0];\n      int h = ${this.getHeightCoordString()};\n      int w = ${this.getWidthCoordString()};\n      int d = ${this.getDepthCoordString()};\n\n      int in_h = h / ${n};\n      int offset_h = imod(h, ${n});\n      int in_w = w / ${n};\n      int offset_w = imod(w, ${n});\n      int offset_d = (offset_h * ${n} + offset_w) *\n        ${this.getOutputDepthSize()};\n      int in_d = d + offset_d;\n\n      float result = ${this.getInputSamplingString()};\n      setOutput(result);\n    }\n  `}getHeightCoordString(){return"NHWC"===this.dataFormat?"coords[1]":"coords[2]"}getWidthCoordString(){return"NHWC"===this.dataFormat?"coords[2]":"coords[3]"}getDepthCoordString(){return"NHWC"===this.dataFormat?"coords[3]":"coords[1]"}getOutputDepthSize(){return"NHWC"===this.dataFormat?this.outputShape[3]:this.outputShape[1]}getInputSamplingString(){return"NHWC"===this.dataFormat?"getX(b, in_h, in_w, in_d)":"getX(b, in_d, in_h, in_w)"}}const _i={kernelName:fe,backendName:"webgl",kernelFunc:function(n){const{inputs:t,backend:r,attrs:a}=n,{x:o}=t,{blockSize:s,dataFormat:i}=a;e.assert(s>1,()=>`blockSize should be > 1 for depthToSpace, but was: ${s}`);const u=o.shape[0],l="NHWC"===i?o.shape[1]:o.shape[2],c="NHWC"===i?o.shape[2]:o.shape[3],d="NHWC"===i?o.shape[3]:o.shape[1],p=l*s,h=c*s,f=d/(s*s),x=new Oi("NHWC"===i?[u,p,h,f]:[u,f,p,h],s,i);return r.runWebGLProgram(x,[o],o.dtype)}};class Di{constructor(e,n=!1,t=null,r=!1,a=!1){this.variableNames=["x","W"],this.outputShape=e.outShape;const o=e.inHeight,s=e.inWidth,i=e.padInfo.top,u=e.padInfo.left,l=e.strideHeight,c=e.strideWidth,d=e.dilationHeight,p=e.dilationWidth,h=e.filterHeight,f=e.filterWidth,x=e.outChannels/e.inChannels;let g="",m="";t&&(g=r?`float activation(float a) {\n          float b = getPreluActivationWeightsAtOutCoords();\n          ${t}\n        }`:a?`float activation(float a) {\n          float b = getLeakyreluAlphaAtOutCoords();\n          ${t}\n        }`:`\n          float activation(float x) {\n            ${t}\n          }\n        `,m="result = activation(result);");const b=n?"result += getBiasAtOutCoords();":"";n&&this.variableNames.push("bias"),r&&this.variableNames.push("preluActivationWeights"),a&&this.variableNames.push("leakyreluAlpha"),this.userCode=`\n      ${g}\n\n      const ivec2 strides = ivec2(${l}, ${c});\n      const ivec2 pads = ivec2(${i}, ${u});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords.x;\n        ivec2 xRCCorner = coords.yz * strides - pads;\n        int d2 = coords.w;\n        int d1 = d2 / ${x};\n        int q = d2 - d1 * ${x};\n\n        int xRCorner = xRCCorner.x;\n        int xCCorner = xRCCorner.y;\n\n        // Convolve x(?, ?, d1) with w(:, :, d1, q) to get y(yR, yC, d2).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n        // TO DO(dsmilkov): Flatten the two for loops and vec4 the operations.\n        for (int wR = 0; wR < ${h}; wR++) {\n          int xR = xRCorner + wR * ${d};\n\n          if (xR < 0 || xR >= ${o}) {\n            continue;\n          }\n\n          for (int wC = 0; wC < ${f}; wC++) {\n            int xC = xCCorner + wC * ${p};\n\n            if (xC < 0 || xC >= ${s}) {\n              continue;\n            }\n\n            float xVal = getX(batch, xR, xC, d1);\n            float wVal = getW(wR, wC, d1, q);\n            dotProd += xVal * wVal;\n          }\n        }\n\n        float result = dotProd;\n        ${b}\n        ${m}\n        setOutput(result);\n      }\n    `}}class Li{constructor(n,t=!1,r=null,a=!1,o=!1){this.variableNames=["x","W"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=n.outShape;const s=n.inHeight,i=n.inWidth,u=n.padInfo.top,l=n.padInfo.left,c=n.strideHeight,d=n.strideWidth,p=n.dilationHeight,h=n.dilationWidth,f=n.filterHeight,x=n.filterWidth,g=x;let m="int xR; int xC; int xCOffset;";for(let e=0;e<f;e++)for(let n=0;n<x;n++)m+=`\n          vec4 xTexelR${e}C${2*n} = vec4(0.);\n          vec4 wR${e}C${n} = vec4(0.);\n          vec4 xR${e}C${n} = vec4(0.);`;for(let n=0;n<f;n++)for(let t=0;t<g;t++){const r=2*t;if(m+=`\n          xR = xRCorner + ${n*p};\n          xC = xCCorner + ${r*h};\n        `,1===d){if(r<x&&(m+=l%2==1?`\n                xCOffset = xC + 1;\n                if(xR >= 0 && xR < ${s} && xCOffset >= 0 && xCOffset < ${i}) {\n                  xTexelR${n}C${r} = getX(batch, xR, xCOffset, d1);\n\n                  // Need to manually clear unused channels in case\n                  // we're reading from recycled texture.\n                  if(xCOffset + 1 >= ${i}) {\n                    xTexelR${n}C${r}.zw = vec2(0.);\n                  }\n                } else {\n                  xTexelR${n}C${r} = vec4(0.);\n                }\n\n                xCOffset = xC + 1 - 2;\n                if(xR >= 0 && xR < ${s} && xCOffset >= 0 && xCOffset < ${i}) {\n                  vec4 previous = getX(batch, xR, xCOffset, d1);\n\n                  // Need to manually clear unused channels in case\n                  // we're reading from recycled texture.\n                  if(xCOffset + 1 >= ${i}) {\n                    previous.zw = vec2(0.);\n                  }\n\n                  xR${n}C${r} = vec4(previous.zw, xTexelR${n}C${r}.xy);\n                } else {\n                  xR${n}C${r} = vec4(0, 0, xTexelR${n}C${r}.xy);\n                }\n              `:`\n                if(xR >= 0 && xR < ${s} && xC >= 0 && xC < ${i}) {\n                  xTexelR${n}C${r} = getX(batch, xR, xC, d1);\n                } else {\n                  xTexelR${n}C${r} = vec4(0.);\n                }\n\n                xR${n}C${r} = xTexelR${n}C${r};\n              `,r+1<x)){const t=l%2==0?e.nearestLargerEven(h):h;h%2==0&&l%2==1||h%2!=0&&l%2!=1?(m+=`\n                  xCOffset = xC + ${l%2} + ${t};\n\n                  if(xR >= 0 && xR < ${s} &&\n                    xCOffset >= 0 && xCOffset < ${i}) {\n                    xTexelR${n}C${r+2} = getX(batch, xR, xCOffset, d1);\n                  }\n                `,h>1&&(m+=`\n                    xCOffset -= 2;\n                    if(xR >= 0 && xR < ${s} &&\n                      xCOffset >= 0 && xCOffset < ${i}) {\n                      xTexelR${n}C${r} = getX(batch, xR, xCOffset, d1);\n                    } else {\n                      xTexelR${n}C${r} = vec4(0.);\n                    }\n                  `),m+=`\n                  xR${n}C${r+1} = vec4(\n                    xTexelR${n}C${r}.zw, xTexelR${n}C${r+2}.xy);\n                `):m+=`\n                  xCOffset = xC + ${t};\n\n                  if(xR >= 0 && xR < ${s} &&\n                    xCOffset >= 0 && xCOffset < ${i}) {\n                    xTexelR${n}C${r+2} = getX(batch, xR, xCOffset, d1);\n                  }\n\n                  xR${n}C${r+1} = xTexelR${n}C${r+2};\n                `}}else r<x&&(m+=`\n              if(xR >= 0 && xR < ${s}) {\n            `,l%2==1?(m+=`\n                xCOffset = xC + 1 - ${d};\n                if(xCOffset >= 0 && xCOffset < ${i}) {\n                  xTexelR${n}C${r} = getX(batch, xR, xCOffset, d1);\n                } else {\n                  xTexelR${n}C${r} = vec4(0.);\n                }\n\n                if(xC + 1 >= 0 && xC + 1 < ${i}) {\n                  xTexelR${n}C${r+2} = getX(batch, xR, xC + 1, d1);\n                } else {\n                  xTexelR${n}C${r+2} = vec4(0.);\n                }\n\n                xR${n}C${r} = vec4(\n                  xTexelR${n}C${r}.zw, xTexelR${n}C${r+2}.zw);\n              `,r+1<x&&(m+=`\n                  vec4 final = vec4(0.);\n                  xCOffset = xC + 1 + ${d};\n                  if(xCOffset >= 0 && xCOffset < ${i}) {\n                    final = getX(batch, xR, xCOffset, d1);\n                  }\n                  xR${n}C${r+1} = vec4(xTexelR${n}C${r+2}.xy, final.xy);\n                `)):(m+=`\n                if(xC >= 0 && xC < ${i}) {\n                  xTexelR${n}C${r} = getX(batch, xR, xC, d1);\n                } else {\n                  xTexelR${n}C${r} = vec4(0.);\n                }\n\n                xCOffset = xC + ${d};\n                if(xCOffset >= 0 && xCOffset < ${i}) {\n                  xTexelR${n}C${r+2} = getX(batch, xR, xCOffset, d1);\n                } else {\n                  xTexelR${n}C${r+2} = vec4(0.);\n                }\n\n                xR${n}C${r} = vec4(\n                  xTexelR${n}C${r}.xy, xTexelR${n}C${r+2}.xy);\n              `,r+1<x&&(m+=`\n                  xR${n}C${r+1} = vec4(\n                    xTexelR${n}C${r}.zw, xTexelR${n}C${r+2}.zw);\n                `)),m+="}");r<x&&(m+=`\n            vec4 wTexelR${n}C${r} = getW(${n}, ${r}, d1, q);\n            wR${n}C${r} = vec4(wTexelR${n}C${r}.xz, wTexelR${n}C${r}.xz);\n          `,r+1<x&&(m+=`\n              vec4 wTexelR${n}C${r+1} = getW(${n}, ${r+1}, d1, q);\n              wR${n}C${r+1} =\n                vec4(wTexelR${n}C${r+1}.xz, wTexelR${n}C${r+1}.xz);`))}for(let e=0;e<f;e++)for(let n=0;n<x;n++)m+=`dotProd += xR${e}C${n} * wR${e}C${n};`;let b="",C="";r&&(b=a?`vec4 activation(vec4 a) {\n          vec4 b = getPreluActivationWeightsAtOutCoords();\n          ${r}\n        }`:o?`vec4 activation(vec4 a) {\n          vec4 b = getLeakyreluAlphaAtOutCoords();\n          ${r}\n        }`:`vec4 activation(vec4 x) {\n          ${r}\n        }`,C="result = activation(result);");const v=t?"result += getBiasAtOutCoords();":"";t&&this.variableNames.push("bias"),a&&this.variableNames.push("preluActivationWeights"),o&&this.variableNames.push("leakyreluAlpha"),this.userCode=`\n      ${b}\n\n      const ivec2 strides = ivec2(${c}, ${d});\n      const ivec2 pads = ivec2(${u}, ${l});\n\n      void main() {\n\n        ivec4 coords = getOutputCoords();\n        int batch = coords.x;\n        ivec2 xRCCorner = coords.yz * strides - pads;\n        int d2 = coords.w;\n        int d1 = d2;\n        int q = 0;\n        int xRCorner = xRCCorner.x;\n        int xCCorner = xRCCorner.y;\n\n        vec4 dotProd = vec4(0.);\n\n        ${m}\n\n        vec4 result = dotProd;\n        ${v}\n        ${C}\n        setOutput(result);\n      }\n    `}}const Pi={kernelName:xe,backendName:"webgl",kernelFunc:function(t){const{inputs:a,backend:o,attrs:s}=t,{x:i,filter:u}=a,{strides:l,pad:c,dilations:d,dimRoundingMode:p}=s;let h=d;null==h&&(h=[1,1]),e.assert(r.eitherStridesOrDilationsAreOne(l,h),()=>"Error in depthwiseConv2d: Either strides or dilations must be "+`1. Got strides ${l} and dilations '${h}'`);const f=r.computeConv2DInfo(i.shape,u.shape,l,h,c,p,!0);let x;return x=n().getBool("WEBGL_PACK_DEPTHWISECONV")&&f.strideWidth<=2&&f.outChannels/f.inChannels==1?new Li(f):new Di(f),o.runWebGLProgram(x,[i,u],"float32")}};class Bi{constructor(e){this.variableNames=["x","dy"],this.outputShape=e.filterShape;const n=e.strideHeight,t=e.strideWidth,r=e.padInfo.top,a=e.padInfo.left,o=e.outChannels/e.inChannels;this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int wR = coords.x;\n        int wC = coords.y;\n        int d1 = coords.z;\n        int dm = coords.w;\n        int d2 = d1 * ${o} + dm;\n\n        float dotProd = 0.0;\n\n        // TO DO: Vec4 over the batch size\n        for (int b = 0; b < ${e.batchSize}; b++) {\n          for (int yR = 0; yR < ${e.outHeight}; yR++) {\n            int xR = wR + yR * ${n} - ${r};\n\n            if (xR < 0 || xR >= ${e.inHeight}) {\n              continue;\n            }\n\n            for (int yC = 0; yC < ${e.outWidth}; yC++) {\n              int xC = wC + yC * ${t} - ${a};\n\n              if (xC < 0 || xC >= ${e.inWidth}) {\n                continue;\n              }\n\n              float dyValue = getDy(b, yR, yC, d2);\n              float xValue = getX(b, xR, xC, d1);\n              dotProd += (xValue * dyValue);\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class Wi{constructor(e){this.variableNames=["dy","W"],this.outputShape=e.inShape;const n=e.filterHeight,t=e.filterWidth,r=e.strideHeight,a=e.strideWidth,o=n-1-e.padInfo.top,s=t-1-e.padInfo.left,i=e.outChannels/e.inChannels;this.userCode=`\n      const ivec2 pads = ivec2(${o}, ${s});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords[0];\n        int d1 = coords[3];\n        ivec2 dyCorner = coords.yz - pads;\n        int dyRCorner = dyCorner.x;\n        int dyCCorner = dyCorner.y;\n\n        float dotProd = 0.0;\n\n        for (int wR = 0; wR < ${n}; wR++) {\n          float dyR = float(dyRCorner + wR) / ${r}.0;\n\n          if (dyR < 0.0 || dyR >= ${e.outHeight}.0 || fract(dyR) > 0.0) {\n            continue;\n          }\n          int idyR = int(dyR);\n\n          int wRPerm = ${n} - 1 - wR;\n\n          for (int wC = 0; wC < ${t}; wC++) {\n            float dyC = float(dyCCorner + wC) / ${a}.0;\n\n            if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                fract(dyC) > 0.0) {\n              continue;\n            }\n            int idyC = int(dyC);\n\n            int wCPerm = ${t} - 1 - wC;\n\n            // TO DO: Vec4 over the channelMul\n            for (int dm = 0; dm < ${i}; dm++) {\n              int d2 = d1 * ${i} + dm;\n              float xValue = getDy(batch, idyR, idyC, d2);\n              float wValue = getW(wRPerm, wCPerm, d1, dm);\n              dotProd += xValue * wValue;\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}const Vi={kernelName:ge,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t,attrs:a}=e,{x:o,dy:s}=n,{strides:i,dilations:u,pad:l,dimRoundingMode:c,filterShape:d}=a,p=r.computeConv2DInfo(o.shape,d,i,u,l,c,!0),h=new Bi(p);return t.runWebGLProgram(h,[o,s],"float32")}};const Mi={kernelName:me,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t,attrs:a}=e,{dy:o,filter:s}=n,{strides:i,dilations:u,pad:l,dimRoundingMode:c,inputShape:d}=a,p=r.computeConv2DInfo(d,s.shape,i,u,l,c,!0),h=new Wi(p);return t.runWebGLProgram(h,[o,s],"float32")}};class Gi{constructor(e){this.variableNames=["X"],this.outputShape=[e,e],this.userCode="\n      void main() {\n          ivec2 coords = getOutputCoords();\n          float val = coords[0] == coords[1] ? getX(coords[0]) : 0.0;\n          setOutput(val);\n      }\n    "}}const Ui={kernelName:be,backendName:"webgl",kernelFunc:function(n){const{inputs:t,backend:r}=n,{x:a}=t,o=[...a.shape,...a.shape],s=e.sizeFromShape(a.shape),i=Uo({inputs:{x:a},backend:r,attrs:{shape:[s]}}),u=new Gi(s),l=r.runWebGLProgram(u,[i],i.dtype),c=Uo({inputs:{x:l},backend:r,attrs:{shape:o}});return r.disposeIntermediateTensorInfo(i),r.disposeIntermediateTensorInfo(l),c}};class zi{constructor(e){this.variableNames=["x","W"],this.outputShape=e.outShape;const{inHeight:n,inWidth:t,padInfo:r,strideHeight:a,strideWidth:o,filterHeight:s,filterWidth:i,dilationHeight:u,dilationWidth:l}=e,{top:c,left:d}=r;this.userCode=`\n      const ivec2 strides = ivec2(${a}, ${o});\n      const ivec2 pads = ivec2(${c}, ${d});\n      const float neg_infinity = -3.4e38;\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords.x;\n        int d1 = coords.w;\n        ivec2 outTopLeftCorner =\n            coords.yz * strides - pads;\n        int hBeg = outTopLeftCorner.x;\n        int wBeg = outTopLeftCorner.y;\n\n        float curVal = neg_infinity;\n        for (int h = 0; h < ${s}; h++) {\n          int hIn = hBeg + h * ${u};\n\n          if (hIn >= 0 && hIn < ${n}) {\n            for (int w = 0; w < ${i}; w++) {\n              int wIn = wBeg + w * ${l};\n\n              if (wIn >= 0 && wIn < ${t}) {\n                float xVal = getX(batch, hIn, wIn, d1);\n                float wVal = getW(h, w, d1);\n\n                float val = xVal + wVal;\n                if (val > curVal) {\n                  curVal = val;\n                }\n              }\n            }\n          }\n        }\n\n        float result = curVal;\n        setOutput(result);\n      }\n    `}}const Xi={kernelName:Ce,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t,attrs:a}=e,{x:o,filter:s}=n,{strides:i,pad:u,dilations:l}=a,c=r.computeDilation2DInfo(o.shape,s.shape,i,u,"NHWC",l);let d;const p=new zi(c);d=t.runWebGLProgram(p,[o,s],"float32");const h=Uo({inputs:{x:d},backend:t,attrs:{shape:c.outShape}});return t.disposeIntermediateTensorInfo(d),h}},Hi={kernelName:ve,backendName:"webgl",kernelFunc:Oo({opSnippet:"return (x >= 0.0) ? x : (exp(x) - 1.0);",packedOpSnippet:"\n  vec4 result;\n\n  result.r = (x.r >= 0.0) ? x.r : (exp(x.r) - 1.0);\n  result.g = (x.g >= 0.0) ? x.g : (exp(x.g) - 1.0);\n  result.b = (x.b >= 0.0) ? x.b : (exp(x.b) - 1.0);\n  result.a = (x.a >= 0.0) ? x.a : (exp(x.a) - 1.0);\n\n  return result;\n"})},ji={kernelName:$e,backendName:"webgl",kernelFunc:e=>{const{inputs:t,backend:r}=e,{dy:a,y:o}=t,s=n().getBool("WEBGL_PACK_BINARY_OPERATIONS")?new Io("\n  vec4 bGTEZero = vec4(greaterThanEqual(b, vec4(0.)));\n  return (bGTEZero * a) + ((vec4(1.0) - bGTEZero) * (a * (b + vec4(1.0))));\n",a.shape,o.shape):new $o("return (b >= 1.0) ? a : a * (b + 1.0);",a.shape,o.shape);return r.runWebGLProgram(s,[a,o],a.dtype)}},Ki={kernelName:Ie,backendName:"webgl",kernelFunc:_o({opSnippet:"return float(a == b);",packedOpSnippet:"\n  return vec4(equal(a, b));\n",dtype:"bool"})},qi={kernelName:Re,backendName:"webgl",kernelFunc:Oo({opSnippet:`\n  // Error function is calculated approximately with elementary function.\n  // See "Handbook of Mathematical Functions with Formulas,\n  // Graphs, and Mathematical Tables", Abramowitz and Stegun.\n  float p = ${r.ERF_P};\n  float a1 = ${r.ERF_A1};\n  float a2 = ${r.ERF_A2};\n  float a3 = ${r.ERF_A3};\n  float a4 = ${r.ERF_A4};\n  float a5 = ${r.ERF_A5};\n\n  float sign = sign(x);\n  x = abs(x);\n  float t = 1.0 / (1.0 + p * x);\n  return sign * (1.0 - (((((a5*t + a4)*t) + a3)*t + a2)*t + a1)*t*exp(-x*x));\n`})},Yi="return exp(x);",Qi=Oo({opSnippet:Yi,packedOpSnippet:Yi,cpuKernelImpl:Sa}),Zi={kernelName:ye,backendName:"webgl",kernelFunc:Qi};function Ji(n){const{inputs:t,attrs:r,backend:a}=n,{dim:o}=r,{input:s}=t,i=s.shape.length,u=s.shape.slice();let l=o;return o<0&&(e.assert(-(i+1)<=o,()=>`Axis must be in the interval [${-(i+1)}, ${i}]`),l=i+o+1),u.splice(l,0,1),Uo({inputs:{x:s},backend:a,attrs:{shape:u}})}const eu={kernelName:we,backendName:"webgl",kernelFunc:Ji},nu="return exp(x) - 1.0;",tu={kernelName:ke,backendName:"webgl",kernelFunc:Oo({opSnippet:nu,packedOpSnippet:nu,cpuKernelImpl:Aa})};class ru{constructor(e,n,t){this.variableNames=["real","imag"];const r=n[1];this.outputShape=n;const a=t?`2.0 * ${Math.PI}`:`-2.0 * ${Math.PI}`,o=t?`${r}.0`:"1.0";let s;if("real"===e)s="return real * expR - imag * expI;";else{if("imag"!==e)throw new Error(`FFT component must be either "real" or "imag", got ${e}.`);s="return real * expI + imag * expR;"}this.userCode=`\n      const float exponentMultiplier = ${a};\n\n      float unaryOpComplex(float real, float expR, float imag, float expI) {\n        ${s}\n      }\n\n      float mulMatDFT(int batch, int index) {\n        float indexRatio = float(index) / float(${r});\n        float exponentMultiplierTimesIndexRatio =\n            exponentMultiplier * indexRatio;\n\n        float result = 0.0;\n\n        for (int i = 0; i < ${r}; i++) {\n          // x = (-2|2 * PI / N) * index * i;\n          float x = exponentMultiplierTimesIndexRatio * float(i);\n          float expR = cos(x);\n          float expI = sin(x);\n          float real = getReal(batch, i);\n          float imag = getImag(batch, i);\n\n          result +=\n              unaryOpComplex(real, expR, imag, expI) / ${o};\n        }\n\n        return result;\n      }\n\n      void main() {\n        ivec2 coords = getOutputCoords();\n        setOutput(mulMatDFT(coords[0], coords[1]));\n      }\n    `}}function au(n,t,r){const a=r.texData.get(n.dataId),o=e.sizeFromShape(n.shape),s=n.shape[n.shape.length-1],i=Uo({inputs:{x:n},backend:r,attrs:{shape:[o/s,s]}}),u=i.shape,l=new ru("real",u,t),c=new ru("imag",u,t),d=[{dataId:a.complexTensorInfos.real.dataId,dtype:a.complexTensorInfos.real.dtype,shape:u},{dataId:a.complexTensorInfos.imag.dataId,dtype:a.complexTensorInfos.imag.dtype,shape:u}],p=r.runWebGLProgram(l,d,"float32"),h=r.runWebGLProgram(c,d,"float32"),f=wo({inputs:{real:p,imag:h},backend:r});r.disposeIntermediateTensorInfo(p),r.disposeIntermediateTensorInfo(h);const x=Uo({inputs:{x:f},backend:r,attrs:{shape:n.shape}});return r.disposeIntermediateTensorInfo(i),r.disposeIntermediateTensorInfo(f),x}const ou={kernelName:Te,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t}=e,{input:r}=n;return au(r,!1,t)}};class su{constructor(e,n){this.outputShape=[],this.variableNames=["x"],this.outputShape=e,this.userCode="\n      uniform float value;\n      void main() {\n        // Input can be obtained from uniform value.\n        setOutput(value);\n      }\n    "}getCustomSetupFunc(e){return(n,t)=>{null==this.valueLoc&&(this.valueLoc=n.getUniformLocationNoThrow(t,"value")),n.gl.uniform1f(this.valueLoc,e)}}}function iu(n){const{backend:t,attrs:r}=n,{shape:a,value:o}=r;let{dtype:s}=r;if(s=s||e.inferDtype(o),"string"===s){const n=e.getArrayFromDType(s,e.sizeFromShape(a));return n.fill(o),t.makeTensorInfo(a,s,n)}{const e=new su(a,o),n=e.getCustomSetupFunc(o);return t.runWebGLProgram(e,[],s,n)}}const uu={kernelName:Ee,backendName:"webgl",kernelFunc:iu};class lu{constructor(e){this.variableNames=["Image"],this.outputShape=[];const n=e[2];this.outputShape=e,this.userCode=`\n        void main() {\n          ivec4 coords = getOutputCoords();\n          int x = coords[2];\n\n          int coordX = ${n} - x;\n          float outputValue;\n          if(coordX >= 0 && coordX < ${n}) {\n            outputValue = getImage(coords[0], coords[1], coordX, coords[3]);\n          } else {\n            outputValue = getImage(coords[0], coords[1], coords[2], coords[3]);\n          }\n          setOutput(outputValue);\n        }\n    `}}const cu={kernelName:Ne,backendName:"webgl",kernelFunc:({inputs:e,backend:n})=>{const{image:t}=e,r=n,a=new lu(t.shape);return r.runWebGLProgram(a,[t],t.dtype)}},du="return floor(x);",pu={kernelName:Se,backendName:"webgl",kernelFunc:Oo({opSnippet:du,packedOpSnippet:du,cpuKernelImpl:Fa})},hu={kernelName:Ae,backendName:"webgl",kernelFunc:_o({opSnippet:"\n  float s = sign(a) * sign(b);\n  int ia = round(a);\n  int ib = round(b);\n  if (ib != 0) {\n    // Windows (D3D) wants guaranteed non-zero int division at compile-time.\n    return float(idiv(ia, ib, s));\n  } else {\n    return NAN;\n  }\n",packedOpSnippet:"\n  ivec4 ia = round(a);\n  ivec4 ib = round(b);\n  bvec4 cond = notEqual(ib, ivec4(0));\n  ivec4 result = ivec4(0);\n  vec4 s = sign(a) * sign(b);\n\n  // Windows (D3D) wants guaranteed non-zero int division at compile-time.\n  if (cond[0]) {\n    result[0] = idiv(ia[0], ib[0], s[0]);\n  }\n  if (cond[1]) {\n    result[1] = idiv(ia[1], ib[1], s[1]);\n  }\n  if (cond[2]) {\n    result[2] = idiv(ia[2], ib[2], s[2]);\n  }\n  if (cond[3]) {\n    result[3] = idiv(ia[3], ib[3], s[3]);\n  }\n  return vec4(result);\n",dtype:"int32"})};class fu{constructor(e){this.variableNames=["A"];const n=pr(),[t,r]=e;this.outputShape=e,this.userCode=`\n      void main() {\n        ivec3 coords = getOutputCoords();\n        int texR = coords[0];\n        int texC = coords[1];\n        int depth = coords[2];\n        vec2 uv = (vec2(texC, texR) + halfCR) / vec2(${r}.0, ${t}.0);\n\n        vec4 values = ${n.texture2D}(A, uv);\n        float value;\n        if (depth == 0) {\n          value = values.r;\n        } else if (depth == 1) {\n          value = values.g;\n        } else if (depth == 2) {\n          value = values.b;\n        } else if (depth == 3) {\n          value = values.a;\n        }\n\n        setOutput(floor(value * 255.0 + 0.5));\n      }\n    `}}class xu{constructor(e){this.variableNames=["A"],this.packedInputs=!1,this.packedOutput=!0;const n=pr(),[t,r]=e;this.outputShape=e,this.userCode=`\n      void main() {\n        ivec3 coords = getOutputCoords();\n        int texR = coords[0];\n        int texC = coords[1];\n        int depth = coords[2];\n\n        vec4 result = vec4(0.);\n\n        for(int row=0; row<=1; row++) {\n          for(int col=0; col<=1; col++) {\n            texC = coords[1] + row;\n            depth = coords[2] + col;\n\n            vec2 uv = (vec2(texC, texR) + halfCR) /\n                       vec2(${r}.0, ${t}.0);\n            vec4 values = ${n.texture2D}(A, uv);\n            float value;\n            if (depth == 0) {\n              value = values.r;\n            } else if (depth == 1) {\n              value = values.g;\n            } else if (depth == 2) {\n              value = values.b;\n            } else if (depth == 3) {\n              value = values.a;\n            }\n\n            result[row * 2 + col] = floor(value * 255.0 + 0.5);\n          }\n        }\n\n        ${n.output} = result;\n      }\n    `}}const gu={kernelName:Fe,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:r,attrs:a}=e;let{pixels:o}=t;const{numChannels:s}=a,i="undefined"!=typeof HTMLVideoElement&&o instanceof HTMLVideoElement,u="undefined"!=typeof HTMLImageElement&&o instanceof HTMLImageElement,l="undefined"!=typeof ImageBitmap&&o instanceof ImageBitmap,[c,d]=i?[o.videoWidth,o.videoHeight]:[o.width,o.height],p=[d,c],h=[d,c,s];(u||i||l)&&(null==mu&&(mu=document.createElement("canvas").getContext("2d")),mu.canvas.width=c,mu.canvas.height=d,mu.drawImage(o,0,0,c,d),o=mu.canvas);const f=r.makeTensorInfo(p,"int32");r.texData.get(f.dataId).usage=ft.PIXELS,r.gpgpu.uploadPixelDataToTexture(r.getTexture(f.dataId),o);const x=n().getBool("WEBGL_PACK")?new xu(h):new fu(h),g=r.runWebGLProgram(x,[f],"int32");return r.disposeData(f.dataId),g}};let mu;const bu={kernelName:Oe,backendName:"webgl",kernelFunc:function(t){const{inputs:a,backend:o,attrs:s}=t,{x:i,filter:u,bias:l,preluActivationWeights:c}=a,{strides:d,pad:p,dataFormat:h,dilations:f,dimRoundingMode:x,activation:g,leakyreluAlpha:m}=s,b=r.convertConv2DDataFormat(h),C=r.computeConv2DInfo(i.shape,u.shape,d,f,p,x,!1,b);let v;const $=[];if(1!==C.filterHeight||1!==C.filterWidth||1!==C.dilationHeight||1!==C.dilationWidth||1!==C.strideHeight||1!==C.strideWidth||"SAME"!==C.padInfo.type&&"VALID"!==C.padInfo.type)if(n().getBool("WEBGL_CONV_IM2COL")&&1===i.shape[0])v=hi({x:i,filter:u,convInfo:C,backend:o,bias:l,activation:g,preluActivationWeights:c,leakyreluAlpha:m});else{const n=null!=l,t=null!=c,r="leakyrelu"===g,a=g?Do(g,!1):null,s=new li(C,n,a,t,r),d=[i,u];if(l&&d.push(l),c&&d.push(c),r){const n=o.makeTensorInfo([],"float32",e.createScalarValue(m,"float32"));d.push(n),$.push(n)}v=o.runWebGLProgram(s,d,"float32")}else v=pi({x:i,filter:u,convInfo:C,backend:o,bias:l,activation:g,preluActivationWeights:c,leakyreluAlpha:m});const I=Uo({inputs:{x:v},backend:o,attrs:{shape:C.outShape}});return $.push(v),$.forEach(e=>o.disposeIntermediateTensorInfo(e)),I}};const Cu={kernelName:_e,backendName:"webgl",kernelFunc:function(t){const{inputs:a,backend:o,attrs:s}=t,{x:i,filter:u,bias:l,preluActivationWeights:c}=a,{strides:d,pad:p,dilations:h,dimRoundingMode:f,activation:x,leakyreluAlpha:g}=s,m=[];let b=h;null==b&&(b=[1,1]),e.assert(r.eitherStridesOrDilationsAreOne(d,b),()=>"Error in depthwiseConv2d: Either strides or dilations must be "+`1. Got strides ${d} and dilations '${b}'`);const C=r.computeConv2DInfo(i.shape,u.shape,d,b,p,f,!0),v=n().getBool("WEBGL_PACK_DEPTHWISECONV")&&C.strideWidth<=2&&C.outChannels/C.inChannels==1,$=x?Do(x,v):null,I=[i,u],R=null!=l,y=null!=c,w="leakyrelu"===x;if(R&&I.push(l),y&&I.push(c),w){const n=o.makeTensorInfo([],"float32",e.createScalarValue(g,"float32"));I.push(n),m.push(n)}let k;k=v?new Li(C,R,$,y,w):new Di(C,R,$,y,w);const T=o.runWebGLProgram(k,I,"float32");return m.forEach(e=>o.disposeIntermediateTensorInfo(e)),T}};class vu{constructor(e,n,t){this.sliceDim=e,this.strides=n,this.variableNames=["x","indices"],this.outputShape=t;const r=ra(n.length),a=ra(t.length),o=this.sliceDim>1?"strides[j]":"strides";this.userCode=`\n        ${r} strides = ${r}(${this.strides});\n         void main() {\n          ${a} coords = getOutputCoords();\n          int flattenIndex = 0;\n          for (int j = 0; j < ${this.sliceDim}; j++) {\n            int index = round(getIndices(coords[0], j));\n            flattenIndex += index * ${o};\n          }\n          setOutput(getX(flattenIndex, coords[1]));\n        }\n      `}}const $u={kernelName:De,backendName:"webgl",kernelFunc:function(n){const{inputs:t,backend:a}=n,{params:o,indices:s}=t,i=s.shape,u=i[i.length-1],[l,c,d,p]=r.prepareAndValidate(o,s),h=Uo({inputs:{x:s},backend:a,attrs:{shape:[c,u]}}),f=Uo({inputs:{x:o},backend:a,attrs:{shape:[e.sizeFromShape(o.shape)/d,d]}}),x=new vu(u,p,[c,d]),g=a.runWebGLProgram(x,[f,h],f.dtype),m=Uo({inputs:{x:g},backend:a,attrs:{shape:l}});return a.disposeIntermediateTensorInfo(h),a.disposeIntermediateTensorInfo(f),a.disposeIntermediateTensorInfo(g),m}};class Iu{constructor(e,n){this.variableNames=["A","indices"],this.outputShape=n,this.rank=n.length;const t=ra(this.rank),r=function(e,n){const t=["resRC.x","resRC.y","resRC.z","resRC.w"],r=[];for(let n=0;n<e.length;n++)2===n?r.push("int(getIndices(resRC.x, resRC.z))"):r.push(`${t[n]}`);return r.join()}(e);this.userCode=`\n      void main() {\n        ${t} resRC = getOutputCoords();\n        setOutput(getA(${r}));\n      }\n    `}}const Ru={kernelName:Le,backendName:"webgl",kernelFunc:function(n){const{inputs:t,backend:a,attrs:o}=n,{x:s,indices:i}=t,{axis:u,batchDims:l}=o,c=e.parseAxisParam(u,s.shape)[0],d=r.segment_util.collectGatherOpShapeInfo(s,i,c,l),p=e.sizeFromShape(i.shape),h=[],f=Uo({inputs:{x:s},backend:a,attrs:{shape:[d.batchSize,d.outerSize,d.dimSize,d.sliceSize]}}),x=Uo({inputs:{x:i},backend:a,attrs:{shape:[d.batchSize,p/d.batchSize]}});h.push(f),h.push(x);const g=[d.batchSize,d.outerSize,p/d.batchSize,d.sliceSize];if(a.shouldExecuteOnCPU([s,i])||"string"===s.dtype){const e=a.bufferSync(x),n=a.bufferSync(f),t=Oa(n,e,g);return h.forEach(e=>a.disposeIntermediateTensorInfo(e)),a.makeTensorInfo(d.outputShape,t.dtype,t.values)}const m=new Iu(f.shape,g),b=a.runWebGLProgram(m,[f,x],f.dtype);h.push(b);const C=Uo({inputs:{x:b},backend:a,attrs:{shape:d.outputShape}});return h.forEach(e=>a.disposeIntermediateTensorInfo(e)),C}},yu={kernelName:Pe,backendName:"webgl",kernelFunc:_o({opSnippet:"return float(a > b);",packedOpSnippet:"\n  return vec4(greaterThan(a, b));\n",cpuKernelImpl:_a,dtype:"bool"})},wu={kernelName:Be,backendName:"webgl",kernelFunc:_o({opSnippet:"return float(a >= b);",packedOpSnippet:"\n  return vec4(greaterThanEqual(a, b));\n",dtype:"bool"})};const ku={kernelName:We,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t}=e,{input:r}=n;return au(r,!0,t)}},Tu={kernelName:Ve,backendName:"webgl",kernelFunc:Oo({opSnippet:"return float(!isnan(x) && !isinf(x));",dtype:"bool"})},Eu={kernelName:Me,backendName:"webgl",kernelFunc:Oo({opSnippet:"return float(isinf(x));",dtype:"bool"})},Nu={kernelName:Ge,backendName:"webgl",kernelFunc:Oo({opSnippet:"return float(isnan(x));",dtype:"bool"})},Su={kernelName:Ue,backendName:"webgl",kernelFunc:_o({opSnippet:"return float(a < b);",packedOpSnippet:"\n  return vec4(lessThan(a, b));\n",cpuKernelImpl:Da,dtype:"bool"})},Au={kernelName:ze,backendName:"webgl",kernelFunc:_o({opSnippet:"return float(a <= b);",packedOpSnippet:"\n  return vec4(lessThanEqual(a, b));\n",dtype:"bool"})};const Fu={kernelName:Xe,backendName:"webgl",kernelFunc:function(e){const{backend:n,attrs:t}=e,{start:r,stop:a,num:o}=t,s=La(r,a,o);return n.makeTensorInfo([s.length],"float32",s)}},Ou={kernelName:He,backendName:"webgl",kernelFunc:Oo({opSnippet:"if (x < 0.0) return NAN;\n  return log(x);",packedOpSnippet:"\n  vec4 result = log(x);\n  vec4 isNaN = vec4(lessThan(x, vec4(0.0)));\n  result.r = isNaN.r == 1.0 ? NAN : result.r;\n  result.g = isNaN.g == 1.0 ? NAN : result.g;\n  result.b = isNaN.b == 1.0 ? NAN : result.b;\n  result.a = isNaN.a == 1.0 ? NAN : result.a;\n\n  return result;\n",cpuKernelImpl:Pa})},_u={kernelName:je,backendName:"webgl",kernelFunc:Oo({opSnippet:"return log(1.0 + x);"})},Du={kernelName:Ke,backendName:"webgl",kernelFunc:_o({opSnippet:"return float(a >= 1.0 && b >= 1.0);",packedOpSnippet:"\n  return vec4(\n    vec4(greaterThanEqual(a, vec4(1.0))) *\n    vec4(greaterThanEqual(b, vec4(1.0))));\n",dtype:"bool"})},Lu={kernelName:qe,backendName:"webgl",kernelFunc:Oo({opSnippet:"return float(!(x >= 1.0));"})},Pu={kernelName:Ye,backendName:"webgl",kernelFunc:_o({opSnippet:"return float(a >= 1.0 || b >= 1.0);",packedOpSnippet:"\n  return min(\n    vec4(greaterThanEqual(a, vec4(1.0))) +\n    vec4(greaterThanEqual(b, vec4(1.0))),\n    vec4(1.0));\n",dtype:"bool"})};class Bu{constructor(e,n,t,r,a){this.variableNames=["x"],this.outputShape=[];const o=n,s=e[3]-1;let i;this.outputShape=e;const u=`float(${t}) + float(${r}) * sum`;i=.5===a?`inversesqrt(${u})`:1===a?`1.0/(${u})`:`exp(log(${u}) * float(-${a}));`,this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int r = coords[1];\n        int c = coords[2];\n        int d = coords[3];\n        float x = getX(b, r, c, d);\n        float sum = 0.0;\n        for (int j = -${o}; j <= ${o}; j++) {\n          int idx = d + j;\n          if (idx >= 0 && idx <=  ${s}) {\n            float z = getX(b, r, c, idx);\n            sum += z * z;\n          }\n        }\n        float val = x * ${i};\n        setOutput(val);\n      }\n    `}}class Wu{constructor(e,n,t,r,a){this.variableNames=["x"],this.outputShape=[],this.packedInputs=!0,this.packedOutput=!0;const o=n,s=e[3]-1;let i;this.outputShape=e;const u=`float(${t}) + float(${r}) * sum`;i=.5===a?`inversesqrt(${u})`:1===a?`1.0/(${u})`:`exp(log(${u}) * float(-${a}));`,this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords.x;\n        int r = coords.y;\n        int c = coords.z;\n        int d = coords.w;\n\n        bool hasNextCol = d < ${this.outputShape[3]};\n        bool hasNextRow = c < ${this.outputShape[2]};\n\n        vec4 sum = vec4(0.);\n        vec4 xFragAtOutputCoords = getX(b, r, c, d);\n\n        vec4 xAtOutputCoords = vec4(\n          getChannel(xFragAtOutputCoords, vec2(c, d)),\n          hasNextCol ?\n            getChannel(xFragAtOutputCoords, vec2(c, d + 1)) : 0.0,\n          hasNextRow ?\n            getChannel(xFragAtOutputCoords , vec2(c + 1, d)) : 0.0,\n          (hasNextRow && hasNextCol) ?\n            getChannel(xFragAtOutputCoords, vec2(c + 1, d + 1)) : 0.0\n        );\n\n        int firstChannel = d - ${o};\n        vec2 cache = vec2(0.);\n        if(firstChannel >= 0){\n          vec4 firstChannelFrag = getX(b, r, c, firstChannel);\n          cache.x = getChannel(firstChannelFrag, vec2(c, firstChannel));\n            if(hasNextRow){\n              cache.y = getChannel(firstChannelFrag, vec2(c + 1, firstChannel));\n            }\n        }\n\n        ivec2 depth = ivec2(d, d + 1);\n        for (int j = - ${o}; j <= ${o}; j++) {\n          ivec2 idx = depth + j;\n          bvec2 aboveLowerBound = greaterThanEqual(idx, ivec2(0));\n          bvec2 belowUpperBound = lessThanEqual(idx, ivec2(${s}));\n\n          bool depthInRange = aboveLowerBound.x && belowUpperBound.x;\n          bool depthPlusOneInRange = aboveLowerBound.y && belowUpperBound.y;\n\n          if(depthInRange || depthPlusOneInRange){\n            vec4 z = vec4(0.);\n            vec4 xFragAtCurrentDepth;\n            z.xz = cache.xy;\n            if(depthPlusOneInRange && hasNextCol){\n              xFragAtCurrentDepth = idx.y != d ?\n                getX(b, r, c, idx.y) : xFragAtOutputCoords;\n              z.y = getChannel(xFragAtCurrentDepth, vec2(c, idx.y));\n              if(hasNextRow){\n                z.w = getChannel(xFragAtCurrentDepth, vec2(c + 1, idx.y));\n              }\n            }\n            cache.xy = z.yw;\n            sum += z * z;\n          }\n        }\n        vec4 result = xAtOutputCoords * ${i};\n        setOutput(result);\n      }\n    `}}const Vu={kernelName:Qe,backendName:"webgl",kernelFunc:e=>{const{inputs:t,backend:r,attrs:a}=e,{x:o}=t,{depthRadius:s,bias:i,alpha:u,beta:l}=a,c=n().getBool("WEBGL_PACK_NORMALIZATION")?new Wu(o.shape,s,i,u,l):new Bu(o.shape,s,i,u,l);return r.runWebGLProgram(c,[o],o.dtype)}};class Mu{constructor(e,n,t,r,a){this.variableNames=["inputImage","outputImage","dy"],this.outputShape=[],this.outputShape=e,this.depth=e[3],this.depthRadius=n,this.bias=t,this.alpha=r,this.beta=a,this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int r = coords[1];\n        int c = coords[2];\n\n        float result = 0.0;\n        for (int d = 0; d < ${this.depth}; ++d) {\n          int depthBegin = int(max(0.0, float(d - ${n})));\n          int depthEnd = int(min(float(${this.depth}),\n              float(d + ${n} + 1)));\n\n          const int MIN_DEPTH_BEGIN = 0;\n          const int MAX_DEPTH_END = ${this.depth};\n\n          float norm = 0.0;\n          for (int k = MIN_DEPTH_BEGIN; k < MAX_DEPTH_END; ++k) {\n            if (k < depthBegin){\n              continue;\n            }\n            else if (k >= depthBegin && k < depthEnd) {\n              norm += getInputImage(b, r, c, k) * getInputImage(b, r, c, k);\n            }\n            else {\n              break;\n            }\n          }\n\n          norm = float(${r}) * norm + float(${t});\n\n          for(int k = MIN_DEPTH_BEGIN; k < MAX_DEPTH_END; ++k){\n            if (k < depthBegin){\n              continue;\n            }\n            else if (k >= depthBegin && k < depthEnd){\n              float dyi = -2.0 * float(${r})\n                * float(${a})\n                * getInputImage(b ,r ,c, k) * getOutputImage(b, r, c, d)\n                / norm;\n              if (k == d) {\n                dyi += pow(norm, -1.0 * ${a});\n              }\n              if (k == coords[3]) {\n                dyi *= getDy(b, r, c, d);\n                result += dyi;\n              }\n            }\n            else {\n              break;\n            }\n          }\n      }\n      setOutput(result);\n      }\n    `}}const Gu={kernelName:Ze,backendName:"webgl",kernelFunc:e=>{const{inputs:n,backend:t,attrs:r}=e,{x:a,y:o,dy:s}=n,{depthRadius:i,bias:u,alpha:l,beta:c}=r,d=new Mu(a.shape,i,u,l,c);return t.runWebGLProgram(d,[a,o,s],a.dtype)}};function Uu(n){const{inputs:t,backend:a,attrs:o}=n,{x:s}=t,{reductionIndices:i,keepDims:u}=o,l=s.shape.length,c=e.parseAxisParam(i,s.shape);let d=c;const p=r.getAxesPermutation(d,l),h=null!=p,f=a.shouldExecuteOnCPU([s]);let x=s;if(h){if(f){const e=a.texData.get(x.dataId).values,n=new Array(l);for(let e=0;e<n.length;e++)n[e]=s.shape[p[e]];const t=Za(e,s.shape,s.dtype,p,n);x=a.makeTensorInfo(n,s.dtype),a.texData.get(x.dataId).values=t}else x=Yo(s,p,a);d=r.getInnerMostAxes(d.length,l)}r.assertAxesAreInnerMostDims("max",d,l);const[g,m]=r.computeOutAndReduceShapes(x.shape,d);let b,C=g;if(u&&(C=r.expandShapeToKeepDim(g,c)),f){const n=a.texData.get(x.dataId).values,t=Ba(n,e.sizeFromShape(m),C,s.dtype);b=a.makeTensorInfo(C,s.dtype),a.texData.get(b.dataId).values=t}else b=function(n,t,r,a){const o=e.sizeFromShape(t),s=Uo({inputs:{x:n},attrs:{shape:[e.sizeFromShape(n.shape)/o,o]},backend:a}),i=jo(s,n.dtype,"max",a),u=Uo({inputs:{x:i},attrs:{shape:r},backend:a});return a.disposeIntermediateTensorInfo(s),a.disposeIntermediateTensorInfo(i),u}(x,m,C,a);return h&&a.disposeIntermediateTensorInfo(x),b}const zu={kernelName:Je,backendName:"webgl",kernelFunc:Uu},Xu={kernelName:en,backendName:"webgl",kernelFunc:_o({opSnippet:"\n  if (isnan(a)) return a;\n  if (isnan(b)) return b;\n\n  return max(a, b);\n",packedOpSnippet:"\n  vec4 result = vec4(max(a, b));\n  vec4 isNaN = min(vec4(isnan(a)) + vec4(isnan(b)), vec4(1.0));\n  \n  result.r = isNaN.r > 0. ? NAN : result.r;\n  result.g = isNaN.g > 0. ? NAN : result.g;\n  result.b = isNaN.b > 0. ? NAN : result.b;\n  result.a = isNaN.a > 0. ? NAN : result.a;\n\n  return result;\n",cpuKernelImpl:Wa})};const Hu={kernelName:nn,backendName:"webgl",kernelFunc:function(n){const{inputs:t,backend:a,attrs:o}=n,{x:s}=t;lr(s,"maxPool");const{filterSize:i,strides:u,pad:l,dimRoundingMode:c}=o;e.assert(r.eitherStridesOrDilationsAreOne(u,1),()=>"Error in maxPool: Either strides or dilations must be 1. "+`Got strides ${u} and dilations '1'`);const d=r.computePool2DInfo(s.shape,i,u,1,l,c);if(1===d.filterWidth&&1===d.filterHeight&&e.arraysEqual(d.inShape,d.outShape))return Ro({inputs:{x:s},backend:a});const p=new Rs(d,"max",!1);return a.runWebGLProgram(p,[s],s.dtype)}};const ju={kernelName:tn,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t,attrs:a}=e,{x:o}=n,{filterSize:s,strides:i,pad:u,dataFormat:l,dimRoundingMode:c}=a,d=r.computePool3DInfo(o.shape,s,i,[1,1,1],u,c,l),p=new ys(d,"max",!1);return t.runWebGLProgram(p,[o],o.dtype)}};class Ku{constructor(e){this.variableNames=["dy","maxPos"],this.outputShape=e.inShape;const n=e.strideHeight,t=e.strideWidth,r=e.dilationHeight,a=e.effectiveFilterHeight,o=e.effectiveFilterWidth,s=a-1-e.padInfo.top,i=o-1-e.padInfo.left,u=a*o-1;this.userCode=`\n      const ivec2 pads = ivec2(${s}, ${i});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n\n        ivec2 dyRCCorner = coords.yz - pads;\n        int dyRCorner = dyRCCorner.x;\n        int dyCCorner = dyRCCorner.y;\n\n        // Convolve dy(?, ?, d) with pos mask(:, :, d) to get dx(xR, xC, d).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n        for (int wR = 0; wR < ${a};\n          wR += ${r}) {\n          float dyR = float(dyRCorner + wR) / ${n}.0;\n\n          if (dyR < 0.0 || dyR >= ${e.outHeight}.0 || fract(dyR) > 0.0) {\n            continue;\n          }\n          int idyR = int(dyR);\n\n          for (int wC = 0; wC < ${o}; wC++) {\n            float dyC = float(dyCCorner + wC) / ${t}.0;\n\n            if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                fract(dyC) > 0.0) {\n              continue;\n            }\n            int idyC = int(dyC);\n\n            float dyValue = getDy(b, idyR, idyC, d);\n            int maxPosValue = ${u} - int(getMaxPos(b, idyR, idyC, d));\n\n            // Get the current value, check it against the value from the\n            // position matrix.\n            int curPosValue = wR * ${o} + wC;\n            float mask = float(maxPosValue == curPosValue ? 1.0 : 0.0);\n\n            dotProd += dyValue * mask;\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class qu{constructor(e){this.variableNames=["dy","maxPos"],this.outputShape=e.inShape;const n=e.strideDepth,t=e.strideHeight,r=e.strideWidth,a=e.dilationDepth,o=e.dilationHeight,s=e.dilationWidth,i=e.effectiveFilterDepth,u=e.effectiveFilterHeight,l=e.effectiveFilterWidth,c=i-1-e.padInfo.front,d=u-1-e.padInfo.top,p=l-1-e.padInfo.left,h=i*u*l-1;this.userCode=`\n      const ivec3 pads = ivec3(${c}, ${d}, ${p});\n\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int batch = coords.x;\n        int ch = coords.u;\n\n        ivec3 dyCorner = ivec3(coords.y, coords.z, coords.w) - pads;\n        int dyDCorner = dyCorner.x;\n        int dyRCorner = dyCorner.y;\n        int dyCCorner = dyCorner.z;\n\n        // Convolve dy(?, ?, ?, ch) with pos mask(:, :, :, d) to get\n        // dx(xD, xR, xC, ch).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n\n        for (int wD = 0; wD < ${i};\n           wD += ${a}) {\n          float dyD = float(dyDCorner + wD) / ${n}.0;\n\n          if (dyD < 0.0 || dyD >= ${e.outDepth}.0 || fract(dyD) > 0.0) {\n            continue;\n          }\n          int idyD = int(dyD);\n\n          for (int wR = 0; wR < ${u};\n              wR += ${o}) {\n            float dyR = float(dyRCorner + wR) / ${t}.0;\n\n            if (dyR < 0.0 || dyR >= ${e.outHeight}.0 ||\n                fract(dyR) > 0.0) {\n              continue;\n            }\n            int idyR = int(dyR);\n\n            for (int wC = 0; wC < ${l};\n                wC += ${s}) {\n              float dyC = float(dyCCorner + wC) / ${r}.0;\n\n              if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                  fract(dyC) > 0.0) {\n                continue;\n              }\n              int idyC = int(dyC);\n\n              float dyValue = getDy(batch, idyD, idyR, idyC, ch);\n              int maxPosValue = ${h} -\n                  int(getMaxPos(batch, idyD, idyR, idyC, ch));\n\n              // Get the current value, check it against the value from the\n              // position matrix.\n              int curPosValue =\n                  wD * ${u} * ${l} +\n                  wR * ${l} + wC;\n              float mask = float(maxPosValue == curPosValue ? 1.0 : 0.0);\n\n              dotProd += dyValue * mask;\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}const Yu={kernelName:rn,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t,attrs:a}=e,{dy:o,input:s}=n,i=s,{filterSize:u,strides:l,pad:c,dimRoundingMode:d}=a,p=r.computePool3DInfo(i.shape,u,l,[1,1,1],c,d),h=new ys(p,"max",!0),f=t.runWebGLProgram(h,[i],i.dtype),x=new qu(p),g=t.runWebGLProgram(x,[o,f],i.dtype);return t.disposeIntermediateTensorInfo(f),g}};const Qu={kernelName:an,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t,attrs:a}=e,{dy:o,input:s,output:i}=n,u=s;lr([s,i],"maxPoolGrad");const{filterSize:l,strides:c,pad:d,dimRoundingMode:p}=a,h=r.computePool2DInfo(u.shape,l,c,1,d,p),f=new Rs(h,"max",!0),x=t.runWebGLProgram(f,[u],u.dtype),g=new Ku(h),m=t.runWebGLProgram(g,[o,x],u.dtype);return t.disposeIntermediateTensorInfo(x),m}};const Zu={kernelName:on,backendName:"webgl",kernelFunc:({inputs:n,attrs:t,backend:a})=>{const{x:o}=n,{filterSize:s,strides:i,pad:u,includeBatchInIndex:l}=t,c=a;e.assert(4===o.shape.length,()=>`Error in maxPool: input must be rank 4 but got rank ${o.shape.length}.`);const d=[1,1];e.assert(r.eitherStridesOrDilationsAreOne(i,d),()=>"Error in maxPool: Either strides or dilations must be 1. "+`Got strides ${i} and dilations '${d}'`);const p=r.computePool2DInfo(o.shape,s,i,d,u),[h,f]=function(e,n,t,r){let a=new Rs(t,"max",!1);const o=r.runWebGLProgram(a,[e],"float32");return a=new Rs(t,"max",!0,!0,n),[o,r.runWebGLProgram(a,[e],"float32")]}(o,l,p,c);return[h,f]}};const Ju={kernelName:sn,backendName:"webgl",kernelFunc:({inputs:n,attrs:t,backend:a})=>{const{x:o}=n,{keepDims:s,axis:i}=t,u=a,l=o.shape.length,c=e.parseAxisParam(i,o.shape);let d=c;const p=r.getAxesPermutation(d,l),h=null!=p,f=u.shouldExecuteOnCPU([o]),x=[];let g=o;if(h){if(f){const e=u.texData.get(g.dataId).values,n=new Array(l);for(let e=0;e<n.length;e++)n[e]=o.shape[p[e]];const t=Za(e,o.shape,o.dtype,p,n);g=u.makeTensorInfo(n,o.dtype),u.texData.get(g.dataId).values=t}else g=Yo(o,p,u);x.push(g),d=r.getInnerMostAxes(d.length,l)}r.assertAxesAreInnerMostDims("sum",d,l);const[m,b]=r.computeOutAndReduceShapes(g.shape,d);let C=m;s&&(C=r.expandShapeToKeepDim(m,c));const v=function(n,t,r,a){const o=e.sizeFromShape(t),s=Uo({inputs:{x:n},attrs:{shape:[e.sizeFromShape(n.shape)/o,o]},backend:a}),i=jo(s,"float32","mean",a),u=Uo({inputs:{x:i},attrs:{shape:r},backend:a});return a.disposeIntermediateTensorInfo(s),a.disposeIntermediateTensorInfo(i),u}(g,b,C,u);for(const e of x)u.disposeIntermediateTensorInfo(e);return v}};const el={kernelName:un,backendName:"webgl",kernelFunc:function(n){const{inputs:t,backend:a,attrs:o}=n,{x:s}=t,{axis:i,keepDims:u}=o,l=s.shape.length,c=e.parseAxisParam(i,s.shape);let d=c;const p=r.getAxesPermutation(d,l);let h=s;null!=p&&(h=Jo({inputs:{x:s},backend:a,attrs:{perm:p}}),d=r.getInnerMostAxes(d.length,s.shape.length)),r.assertAxesAreInnerMostDims("min",d,l);const[f,x]=r.computeOutAndReduceShapes(h.shape,d),g=Uo({inputs:{x:h},backend:a,attrs:{shape:[-1,e.sizeFromShape(x)]}}),m=jo(g,g.dtype,"min",a);let b;if(u){b=Uo({inputs:{x:m},backend:a,attrs:{shape:r.expandShapeToKeepDim(f,c)}})}else b=Uo({inputs:{x:m},backend:a,attrs:{shape:f}});return a.disposeIntermediateTensorInfo(g),a.disposeIntermediateTensorInfo(m),null!=p&&a.disposeIntermediateTensorInfo(h),b}},nl={kernelName:ln,backendName:"webgl",kernelFunc:_o({opSnippet:"\n  if (isnan(a)) return a;\n  if (isnan(b)) return b;\n\n  return min(a, b);\n",packedOpSnippet:"\n  vec4 result = vec4(min(a, b));\n  vec4 isNaN = min(vec4(isnan(a)) + vec4(isnan(b)), vec4(1.0));\n  \n  result.r = isNaN.r > 0. ? NAN : result.r;\n  result.g = isNaN.g > 0. ? NAN : result.g;\n  result.b = isNaN.b > 0. ? NAN : result.b;\n  result.a = isNaN.a > 0. ? NAN : result.a;\n\n  return result;\n",cpuKernelImpl:Va})};class tl{constructor(e,n,t){this.variableNames=["x"],this.outputShape=n.map((n,t)=>n[0]+e[t]+n[1]);const r=e.length,a=ra(r),o=n.map(e=>e[0]).join(","),s=n.map((n,t)=>n[0]+e[t]).join(","),i=["coords[0]","coords[1]","coords[2]","coords[3]"].slice(0,r),u="reflect"===t?0:1;this.userCode=1!==r?`\n      ${a} start = ${a}(${o});\n      ${a} end = ${a}(${s});\n\n      void main() {\n        ${a} outC = getOutputCoords();\n        for (int i = 0; i < ${r}; i++) {\n          if (outC[i] < start[i]) {\n            outC[i] = start[i] * 2 - outC[i] - ${u};\n          } else if(outC[i] >= end[i]) {\n            outC[i] = (end[i] - 1) * 2 - outC[i] + ${u};\n          }\n        }\n        ${a} coords = outC - start;\n        setOutput(getX(${i}));\n      }\n    `:`\n        int start = ${o};\n        int end = ${s};\n\n        void main() {\n          int outC = getOutputCoords();\n          if (outC < start) {\n            outC = start * 2 - outC - ${u};\n          } else if(outC >= end) {\n            outC = (end - 1) * 2 - outC + ${u};\n          }\n          setOutput(getX(outC - start));\n        }\n      `}}class rl{constructor(e,n,t){this.variableNames=["x"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=n.map((n,t)=>n[0]+e[t]+n[1]);const r=e.length,a=ra(r),o=n.map(e=>e[0]).join(","),s=n.map((n,t)=>n[0]+e[t]).join(","),i=no("rc",r),u=no("source",r),l=`${i[r-1]} < ${this.outputShape[r-1]}`,c=1===r?"source":`vec2(${u.slice(-2).join()})`,d="reflect"===t?0:1;let p="";if(1===r){const e=`\n        ${a} source = rc;\n        if (source < start) {\n          source = start * 2 - source - ${d};\n        } else if (source >= end) {\n          source = (end - 1) * 2 - source + ${d};\n        }\n        source -= start;\n      `;p=`\n        ${a} rc = outputLoc;\n        ${e}\n        result[0] = getChannel(getX(${u.join()}), ${c});\n        ${i[r-1]} += 1;\n        if(${l}) {\n          ${e}\n          result[1] = getChannel(getX(${u.join()}), ${c});\n        }\n      `}else{const e=`\n        ${a} source = rc;\n        ${a} lt = ${a}(lessThan(source, start));\n        ${a} gte = ${a}(greaterThanEqual(source, end));\n        ${a} orig = 1 - (lt + gte);\n        source = orig * source +\n                lt * (start * 2 - source - ${d}) +\n                gte * ((end - 1) * 2 - source + ${d});\n        source -= start;\n      `;p=`\n        ${a} rc = outputLoc;\n        ${e}\n        result[0] = getChannel(getX(${u.join()}), ${c});\n        ${i[r-1]} += 1;\n        if(${l}) {\n          ${e}\n          result[1] = getChannel(getX(${u.join()}), ${c});\n        }\n        rc = outputLoc;\n        ${i[r-2]} += 1;\n        if(${i[r-2]} < ${this.outputShape[r-2]}) {\n          ${e}\n          result[2] = getChannel(getX(${u.join()}), ${c});\n          ${i[r-1]} += 1;\n          if(${l}) {\n            ${e}\n            result[3] = getChannel(getX(${u.join()}), ${c});\n          }\n        }\n      `}this.userCode=`\n      const ${a} start = ${a}(${o});\n      const ${a} end = ${a}(${s});\n\n      void main() {\n        ${a} outputLoc = getOutputCoords();\n        vec4 result = vec4(0.);\n        ${p}\n        setOutput(result);\n      }\n    `}}const al={kernelName:cn,backendName:"webgl",kernelFunc:({inputs:e,backend:t,attrs:r})=>{const{x:a}=e,{paddings:o,mode:s}=r,i=n().getBool("WEBGL_PACK_ARRAY_OPERATIONS")?new rl(a.shape,o,s):new tl(a.shape,o,s);return t.runWebGLProgram(i,[a],a.dtype)}},ol={kernelName:dn,backendName:"webgl",kernelFunc:_o({opSnippet:"if (b == 0.0) return NAN;\n  return mod(a, b);",packedOpSnippet:"\n  vec4 result = mod(a, b);\n  vec4 isNaN = vec4(equal(b, vec4(0.0)));\n  \n  result.r = isNaN.r > 0. ? NAN : result.r;\n  result.g = isNaN.g > 0. ? NAN : result.g;\n  result.b = isNaN.b > 0. ? NAN : result.b;\n  result.a = isNaN.a > 0. ? NAN : result.a;\n\n  return result;\n"})};class sl{constructor(e,n,t){this.variableNames=["probs"],this.outputShape=[e,t],this.userCode=`\n      uniform float seed;\n\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int batch = coords[0];\n\n        float r = random(seed);\n        float cdf = 0.0;\n\n        for (int i = 0; i < ${n-1}; i++) {\n          cdf += getProbs(batch, i);\n\n          if (r < cdf) {\n            setOutput(float(i));\n            return;\n          }\n        }\n\n        // If no other event happened, last event happened.\n        setOutput(float(${n-1}));\n      }\n    `}getCustomSetupFunc(e){return(n,t)=>{null==this.seedLoc&&(this.seedLoc=n.getUniformLocation(t,"seed")),n.gl.uniform1f(this.seedLoc,e)}}}const il=_o({opSnippet:"\nif (a == b) {\n  return 1.0;\n};\nreturn a / b;",packedOpSnippet:"\n  // vec4 one = vec4(equal(a, b));\n  // return one + (vec4(1.0) - one) * a / b;\n  vec4 result = a / b;\n  if(a.x == b.x) {\n    result.x = 1.;\n  }\n  if(a.y == b.y) {\n    result.y = 1.;\n  }\n  if(a.z == b.z) {\n    result.z = 1.;\n  }\n  if(a.w == b.w) {\n    result.w = 1.;\n  }\n\n  return result;\n",checkOutOfBounds:!0}),ul={kernelName:pn,backendName:"webgl",kernelFunc:il},ll="return a - b;",cl=_o({opSnippet:ll,packedOpSnippet:ll,supportsComplex:!0,cpuKernelImpl:qa}),dl={kernelName:hn,backendName:"webgl",kernelFunc:cl};function pl(n){const{inputs:t,backend:a,attrs:o}=n,{logits:s}=t,{dim:i}=o,u=e.parseAxisParam([i],s.shape),l=Uu({inputs:{x:s},backend:a,attrs:{reductionIndices:u,keepDims:!1}}),c=r.expandShapeToKeepDim(l.shape,u),d=Uo({inputs:{x:l},backend:a,attrs:{shape:c}}),p=cl({inputs:{a:s,b:d},backend:a}),h=Qi({inputs:{x:p},backend:a}),f=Qo({inputs:{x:h},backend:a,attrs:{axis:u,keepDims:!1}}),x=Uo({inputs:{x:f},backend:a,attrs:{shape:c}}),g=il({inputs:{a:h,b:x},backend:a});return a.disposeIntermediateTensorInfo(l),a.disposeIntermediateTensorInfo(d),a.disposeIntermediateTensorInfo(p),a.disposeIntermediateTensorInfo(h),a.disposeIntermediateTensorInfo(f),a.disposeIntermediateTensorInfo(x),g}const hl={kernelName:fn,backendName:"webgl",kernelFunc:pl};const fl={kernelName:xn,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t,attrs:r}=e,{logits:a}=n,{numSamples:o,seed:s,normalized:i}=r,u=i?a:pl({inputs:{logits:a},backend:t,attrs:{dim:a.shape.length-1}}),l=u.shape[0],c=u.shape[1],d=new sl(l,c,o),p=d.getCustomSetupFunc(s),h=t.runWebGLProgram(d,[u],"int32",p);return i||t.disposeIntermediateTensorInfo(u),h}},xl="return -x;";const gl={kernelName:gn,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:r}=e,{x:a}=t;if(r.shouldExecuteOnCPU([a])){const e=r.texData.get(a.dataId),[n,t]=Ga(e.values,a.shape,a.dtype);return r.makeTensorInfo(t,a.dtype,n)}let o;return o=n().getBool("WEBGL_PACK_UNARY_OPERATIONS")?new ho(a.shape,xl):new uo(a.shape,xl),r.runWebGLProgram(o,[a],a.dtype)}},ml=u.nonMaxSuppressionV3Impl;const bl={kernelName:mn,backendName:"webgl",kernelFunc:function(e){r.warn("tf.nonMaxSuppression() in webgl locks the UI thread. Call tf.nonMaxSuppressionAsync() instead");const{inputs:n,backend:t,attrs:a}=e,{boxes:o,scores:s}=n,{maxOutputSize:i,iouThreshold:u,scoreThreshold:l}=a,c=t.readSync(o.dataId),d=t.readSync(s.dataId),{selectedIndices:p}=ml(c,d,i,u,l);return t.makeTensorInfo([p.length],"int32",new Int32Array(p))}},Cl=u.nonMaxSuppressionV4Impl;const vl={kernelName:bn,backendName:"webgl",kernelFunc:function(e){r.warn("tf.nonMaxSuppression() in webgl locks the UI thread. Call tf.nonMaxSuppressionAsync() instead");const{inputs:n,backend:t,attrs:a}=e,{boxes:o,scores:s}=n,{maxOutputSize:i,iouThreshold:u,scoreThreshold:l,padToMaxOutputSize:c}=a,d=t.readSync(o.dataId),p=t.readSync(s.dataId),{selectedIndices:h,validOutputs:f}=Cl(d,p,i,u,l,c);return[t.makeTensorInfo([h.length],"int32",new Int32Array(h)),t.makeTensorInfo([],"int32",new Int32Array([f]))]}},$l=u.nonMaxSuppressionV5Impl;const Il={kernelName:Cn,backendName:"webgl",kernelFunc:function(e){r.warn("tf.nonMaxSuppression() in webgl locks the UI thread. Call tf.nonMaxSuppressionAsync() instead");const{inputs:n,backend:t,attrs:a}=e,{boxes:o,scores:s}=n,{maxOutputSize:i,iouThreshold:u,scoreThreshold:l,softNmsSigma:c}=a,d=t.readSync(o.dataId),p=t.readSync(s.dataId),h=i,f=u,x=l,g=c,{selectedIndices:m,selectedScores:b}=$l(d,p,h,f,x,g);return[t.makeTensorInfo([m.length],"int32",new Int32Array(m)),t.makeTensorInfo([b.length],"float32",new Float32Array(b))]}};class Rl{constructor(e,n,t,r){this.variableNames=["indices"],this.outputShape=[e,n],this.userCode=`\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int index = round(getIndices(coords.x));\n        setOutput(mix(float(${r}), float(${t}),\n                      float(index == coords.y)));\n      }\n    `}}const yl={kernelName:vn,backendName:"webgl",kernelFunc:n=>{const{inputs:t,backend:r,attrs:a}=n,{indices:o}=t,{depth:s,onValue:i,offValue:u}=a,l=e.sizeFromShape(o.shape),c=new Rl(l,s,i,u),d=Uo({inputs:{x:o},backend:r,attrs:{shape:[l]}}),p=r.runWebGLProgram(c,[d],o.dtype);r.disposeIntermediateTensorInfo(d);const h=Uo({inputs:{x:p},backend:r,attrs:{shape:[...o.shape,s]}});return r.disposeIntermediateTensorInfo(p),h}};function wl(e){const{inputs:n,backend:t}=e,{x:r}=n;if("complex64"===r.dtype){const e=zs({inputs:{input:r},backend:t}),n=wl({inputs:{x:e},backend:t}),a=ai({inputs:{input:r},backend:t}),o=wl({inputs:{x:a},backend:t}),s=wo({inputs:{real:n,imag:o},backend:t});return t.disposeIntermediateTensorInfo(e),t.disposeIntermediateTensorInfo(n),t.disposeIntermediateTensorInfo(a),t.disposeIntermediateTensorInfo(o),s}return iu({attrs:{shape:r.shape,dtype:r.dtype,value:"string"===r.dtype?"":0},backend:t})}const kl={kernelName:$n,backendName:"webgl",kernelFunc:wl};const Tl={kernelName:In,backendName:"webgl",kernelFunc:function e(n){const{inputs:t,backend:r}=n,{x:a}=t;if("string"===a.dtype)throw new Error("onesLike is not supported under string dtype");if("complex64"===a.dtype){const n=zs({inputs:{input:a},backend:r}),t=e({inputs:{x:n},backend:r}),o=ai({inputs:{input:a},backend:r}),s=wl({inputs:{x:o},backend:r}),i=wo({inputs:{real:t,imag:s},backend:r});return r.disposeIntermediateTensorInfo(n),r.disposeIntermediateTensorInfo(t),r.disposeIntermediateTensorInfo(o),r.disposeIntermediateTensorInfo(s),i}return iu({attrs:{shape:a.shape,dtype:a.dtype,value:1},backend:r})}};const El={kernelName:Rn,backendName:"webgl",kernelFunc:function(n){const{inputs:t,backend:r,attrs:a}=n,{axis:o}=a;if(1===t.length)return Ji({inputs:{input:t[0]},backend:r,attrs:{dim:o}});const s=t[0].shape,i=t[0].dtype;t.forEach(n=>{e.assertShapesMatch(s,n.shape,"All tensors passed to stack must have matching shapes"),e.assert(i===n.dtype,()=>"All tensors passed to stack must have matching dtypes")});const u=[],l=ii({inputs:t.map(e=>{const n=Ji({inputs:{input:e},backend:r,attrs:{dim:o}});return u.push(n),n}),backend:r,attrs:{axis:o}});return u.forEach(e=>r.disposeIntermediateTensorInfo(e)),l}};class Nl{constructor(e,n,t){this.variableNames=["x"],this.outputShape=n.map((n,t)=>n[0]+e[t]+n[1]);const r=e.length,a=ra(r),o=n.map(e=>e[0]).join(","),s=n.map((n,t)=>n[0]+e[t]).join(","),i=["coords[0]","coords[1]","coords[2]","coords[3]"].slice(0,r);this.userCode=1!==r?`\n      ${a} start = ${a}(${o});\n      ${a} end = ${a}(${s});\n\n      void main() {\n        ${a} outC = getOutputCoords();\n        if (any(lessThan(outC, start)) || any(greaterThanEqual(outC, end))) {\n          setOutput(float(${t}));\n        } else {\n          ${a} coords = outC - start;\n          setOutput(getX(${i}));\n        }\n      }\n    `:`\n        int start = ${o};\n        int end = ${s};\n\n        void main() {\n          int outC = getOutputCoords();\n          if (outC < start || outC >= end) {\n            setOutput(float(${t}));\n          } else {\n            setOutput(getX(outC - start));\n          }\n        }\n      `}}class Sl{constructor(e,n,t){this.variableNames=["x"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=n.map((n,t)=>n[0]+e[t]+n[1]);const r=e.length,a=ra(r),o=n.map(e=>e[0]).join(","),s=n.map((n,t)=>n[0]+e[t]).join(","),i=no("rc",r),u=no("source",r),l=`${i[r-1]} < ${this.outputShape[r-1]}`,c=1===r?"source":`vec2(${u.slice(-2).join()})`,d=[`${a} rc = outputLoc;`,`${i[r-1]} += 1;\n       if(${l}) {\n      `,1===r?"":`}\n       rc = outputLoc;\n       ${i[r-2]} += 1;\n       if(${i[r-2]} < ${this.outputShape[r-2]}) {`,1===r?"":`  ${i[r-1]} += 1;\n         if(${l}) {`],p=1===r?"rc < start || rc >= end":"any(lessThan(rc, start)) || any(greaterThanEqual(rc, end))";let h="";for(let e=0,n=1===r?2:4;e<n;e++)h+=`\n        ${d[e]}\n        if (${p}) {\n          result[${e}] = float(${t});\n        } else {\n          ${a} source = rc - start;\n          result[${e}] = getChannel(getX(${u.join()}), ${c});\n        }\n      `;h+=1===r?"} ":"}}",this.userCode=`\n      const ${a} start = ${a}(${o});\n      const ${a} end = ${a}(${s});\n\n      void main() {\n        ${a} outputLoc = getOutputCoords();\n        vec4 result = vec4(0.);\n        ${h}\n        setOutput(result);\n      }\n    `}}const Al=e=>{const{inputs:t,backend:r,attrs:a}=e,{x:o}=t,{paddings:s,constantValue:i}=a,u=n().getBool("WEBGL_PACK_ARRAY_OPERATIONS")?new Sl(o.shape,s,i):new Nl(o.shape,s,i);return r.runWebGLProgram(u,[o],o.dtype)},Fl={kernelName:yn,backendName:"webgl",kernelFunc:Al},Ol={kernelName:wn,backendName:"webgl",kernelFunc:_o({opSnippet:"\n  if(a < 0.0 && floor(b) < b){\n    return NAN;\n  }\n  if (b == 0.0) {\n    return 1.0;\n  }\n  return (round(mod(b, 2.0)) != 1) ?\n      pow(abs(a), b) : sign(a) * pow(abs(a), b);\n",packedOpSnippet:"\n  // isModRound1 has 1 for components with round(mod(b, 2.0)) == 1, 0 otherwise.\n  vec4 isModRound1 = vec4(equal(round(mod(b, 2.0)), ivec4(1)));\n  vec4 multiplier = sign(a) * isModRound1 + (vec4(1.0) - isModRound1);\n  vec4 result = multiplier * pow(abs(a), b);\n\n  // Ensure that a^0 = 1, including 0^0 = 1 as this correspond to TF and JS\n  bvec4 isExpZero = equal(b, vec4(0.0));\n  result.r = isExpZero.r ? 1.0 : result.r;\n  result.g = isExpZero.g ? 1.0 : result.g;\n  result.b = isExpZero.b ? 1.0 : result.b;\n  result.a = isExpZero.a ? 1.0 : result.a;\n\n  vec4 isNaN = vec4(lessThan(a, vec4(0.0))) * vec4(lessThan(floor(b), b));\n  \n  result.r = isNaN.r > 0. ? NAN : result.r;\n  result.g = isNaN.g > 0. ? NAN : result.g;\n  result.b = isNaN.b > 0. ? NAN : result.b;\n  result.a = isNaN.a > 0. ? NAN : result.a;\n\n  return result;\n"})};const _l={kernelName:kn,backendName:"webgl",kernelFunc:function(n){const{inputs:t,backend:a,attrs:o}=n,{x:s}=t,{axis:i,keepDims:u}=o,l=s.shape.length,c=[],d=e.parseAxisParam(i,s.shape);let p=d;const h=r.getAxesPermutation(p,l);let f,x=s;if(null!=h&&(x=Jo({inputs:{x:s},backend:a,attrs:{perm:h}}),p=r.getInnerMostAxes(p.length,l),c.push(x)),r.assertAxesAreInnerMostDims("prod",p,l),a.shouldExecuteOnCPU([x])){const e=a.texData.get(x.dataId).values,{outVals:n,outShape:t,outDtype:r}=Ua(x.shape,x.dtype,e,p);f=a.makeTensorInfo(t,r,n)}else{const[n,t]=r.computeOutAndReduceShapes(x.shape,p),o=e.sizeFromShape(t),i=Uo({inputs:{x:x},backend:a,attrs:{shape:[-1,o]}}),u=jo(i,$(s.dtype),"prod",a);f=Uo({inputs:{x:u},backend:a,attrs:{shape:n}}),c.push(i),c.push(u)}if(u){c.push(f);const e=r.expandShapeToKeepDim(f.shape,d);f=Uo({inputs:{x:f},backend:a,attrs:{shape:e}})}return c.forEach(e=>a.disposeIntermediateTensorInfo(e)),f}},Dl=e=>{const{backend:n,attrs:t}=e,{start:r,stop:a,step:o,dtype:s}=t,i=za(r,a,o,s);return n.makeTensorInfo([i.length],s,i)},Ll={kernelName:Tn,backendName:"webgl",kernelFunc:Dl},Pl={kernelName:En,backendName:"webgl",kernelFunc:Oo({opSnippet:"return 1.0 / x;"})},Bl={kernelName:Nn,backendName:"webgl",kernelFunc:Oo({opSnippet:"if (isnan(x)) return x;\n  return (x < 0.0) ? 0.0 : x;\n",packedOpSnippet:"\n  vec4 result = x * vec4(greaterThanEqual(x, vec4(0.0)));\n  bvec4 isNaN = isnan(x);\n\n  result.r = isNaN.r ? x.r : result.r;\n  result.g = isNaN.g ? x.g : result.g;\n  result.b = isNaN.b ? x.b : result.b;\n  result.a = isNaN.a ? x.a : result.a;\n\n  return result;\n"})},Wl={kernelName:Sn,backendName:"webgl",kernelFunc:Oo({opSnippet:"if (isnan(x)) return x;\n  return (x < 0.0) ? 0.0 : min(6.0, x);\n",packedOpSnippet:"\n  vec4 result = min(x, vec4(6.)) * vec4(greaterThanEqual(x, vec4(0.0)));\n  bvec4 isNaN = isnan(x);\n\n  result.r = isNaN.r ? x.r : result.r;\n  result.g = isNaN.g ? x.g : result.g;\n  result.b = isNaN.b ? x.b : result.b;\n  result.a = isNaN.a ? x.a : result.a;\n\n  return result;\n"})};class Vl{constructor(e,n,t,r,a){this.variableNames=["A"],this.outputShape=[];const[o,s,i,u]=e;this.outputShape=[o,n,t,u];const l=[r&&n>1?s-1:s,r&&t>1?i-1:i],c=[r&&n>1?n-1:n,r&&t>1?t-1:t];let d;d=a?"(vec2(yRC) + vec2(0.5)) * effectiveInputOverOutputRatioRC - vec2(0.5)":"vec2(yRC) * effectiveInputOverOutputRatioRC",this.userCode=`\n      const vec2 effectiveInputOverOutputRatioRC = vec2(\n          ${l[0]/c[0]},\n          ${l[1]/c[1]});\n      const vec2 inputShapeRC = vec2(${s}.0, ${i}.0);\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n        ivec2 yRC = coords.yz;\n\n        // Fractional source index.\n        vec2 sourceFracIndexRC = ${d};\n\n        // Compute the four integer indices.\n        ivec2 sourceFloorRC = ivec2(max(sourceFracIndexRC, vec2(0.0)));\n        ivec2 sourceCeilRC = ivec2(\n          min(inputShapeRC - 1.0, ceil(sourceFracIndexRC)));\n\n        float topLeft = getA(b, sourceFloorRC.x, sourceFloorRC.y, d);\n        float bottomLeft = getA(b, sourceCeilRC.x, sourceFloorRC.y, d);\n        float topRight = getA(b, sourceFloorRC.x, sourceCeilRC.y, d);\n        float bottomRight = getA(b, sourceCeilRC.x, sourceCeilRC.y, d);\n\n        vec2 fracRC = sourceFracIndexRC - vec2(sourceFloorRC);\n\n        float top = topLeft + (topRight - topLeft) * fracRC.y;\n        float bottom = bottomLeft + (bottomRight - bottomLeft) * fracRC.y;\n        float newValue = top + (bottom - top) * fracRC.x;\n\n        setOutput(newValue);\n      }\n    `}}class Ml{constructor(e,n,t,r,a){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=[];const[o,s,i,u]=e;this.outputShape=[o,n,t,u];const l=[r&&n>1?s-1:s,r&&t>1?i-1:i],c=[r&&n>1?n-1:n,r&&t>1?t-1:t];let d;d=a?"(vec3(yRC) + vec3(0.5)) * effectiveInputOverOutputRatioRC - vec3(0.5)":"vec3(yRC) * effectiveInputOverOutputRatioRC",this.userCode=`\n      const vec3 effectiveInputOverOutputRatioRC = vec3(\n          ${l[0]/c[0]},\n          ${l[1]/c[1]},\n          ${l[1]/c[1]});\n      const vec3 inputShapeRC = vec3(${s}.0, ${i}.0,\n                                     ${i}.0);\n\n      float getAValue(int b, int r, int c, int d) {\n        return getChannel(getA(b, r, c, d), vec2(c, d));\n      }\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n        // Calculate values for next column in yRC.z.\n        ivec3 yRC = coords.yzz + ivec3(0, 0, 1);\n\n        // Fractional source index.\n        vec3 sourceFracIndexRC = ${d};\n\n        // Compute the four integer indices.\n        ivec3 sourceFloorRC = ivec3(max(sourceFracIndexRC, vec3(0.0)));\n        ivec3 sourceCeilRC = ivec3(\n          min(inputShapeRC - 1.0, ceil(sourceFracIndexRC)));\n\n        // Should we calculate next column and row elements in 2x2 packed cell.\n        bool hasNextCol = d < ${u-1};\n        bool hasNextRow = coords.z < ${t-1};\n\n        // In parallel, construct four corners for all four components in\n        // packed 2x2 cell.\n        vec4 topLeft = vec4(\n          getAValue(b, sourceFloorRC.x, sourceFloorRC.y, d),\n          hasNextCol ? getAValue(b, sourceFloorRC.x, sourceFloorRC.y, d + 1)\n                     : 0.0,\n          hasNextRow ? getAValue(b, sourceFloorRC.x, sourceFloorRC.z, d)\n                     : 0.0,\n          (hasNextRow && hasNextCol) ?\n            getAValue(b, sourceFloorRC.x, sourceFloorRC.z, d + 1) : 0.0);\n\n        vec4 bottomLeft = vec4(\n          getAValue(b, sourceCeilRC.x, sourceFloorRC.y, d),\n          hasNextCol ? getAValue(b, sourceCeilRC.x, sourceFloorRC.y, d + 1)\n                     : 0.0,\n          hasNextRow ? getAValue(b, sourceCeilRC.x, sourceFloorRC.z, d)\n                     : 0.0,\n          (hasNextRow && hasNextCol) ?\n            getAValue(b, sourceCeilRC.x, sourceFloorRC.z, d + 1) : 0.0);\n\n        vec4 topRight = vec4(\n          getAValue(b, sourceFloorRC.x, sourceCeilRC.y, d),\n          hasNextCol ? getAValue(b, sourceFloorRC.x, sourceCeilRC.y, d + 1)\n                     : 0.0,\n          hasNextRow ? getAValue(b, sourceFloorRC.x, sourceCeilRC.z, d)\n                     : 0.0,\n          (hasNextRow && hasNextCol) ?\n            getAValue(b, sourceFloorRC.x, sourceCeilRC.z, d + 1) : 0.0);\n\n        vec4 bottomRight = vec4(\n          getAValue(b, sourceCeilRC.x, sourceCeilRC.y, d),\n          hasNextCol ? getAValue(b, sourceCeilRC.x, sourceCeilRC.y, d + 1)\n                     : 0.0,\n          hasNextRow ? getAValue(b, sourceCeilRC.x, sourceCeilRC.z, d)\n                     : 0.0,\n          (hasNextRow && hasNextCol) ?\n            getAValue(b, sourceCeilRC.x, sourceCeilRC.z, d + 1) : 0.0);\n\n        vec3 fracRC = sourceFracIndexRC - vec3(sourceFloorRC);\n\n        vec4 top = mix(topLeft, topRight, fracRC.yyzz);\n        vec4 bottom = mix(bottomLeft, bottomRight, fracRC.yyzz);\n        vec4 newValue = mix(top, bottom, fracRC.x);\n\n        setOutput(newValue);\n      }\n    `}}const Gl={kernelName:An,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:r,attrs:a}=e,{images:o}=t,{alignCorners:s,halfPixelCenters:i,size:u}=a,[l,c]=u,d=n().getBool("WEBGL_PACK_IMAGE_OPERATIONS")?new Ml(o.shape,l,c,s,i):new Vl(o.shape,l,c,s,i);return r.runWebGLProgram(d,[o],"float32")}};class Ul{constructor(e,n,t){this.variableNames=["dy"],this.outputShape=[],this.outputShape=n;const[,r,a]=n,[,o,s]=e,i=[t&&o>1?r-1:r,t&&s>1?a-1:a],u=[t&&o>1?o-1:o,t&&s>1?s-1:s],l=i[0]/u[0],c=i[1]/u[1],d=1/l,p=1/c,h=2*Math.ceil(d)+2,f=2*Math.ceil(p)+2;this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n        int r = coords[1];\n        int c = coords[2];\n\n        float accumulator = 0.0;\n\n        const float heightScale = float(${l});\n        const float widthScale = float(${c});\n\n        const float invHeightScale = float(${d});\n        const float invWidthScale = float(${p});\n\n        const int winHeight = int(${h});\n        const int winWidth = int(${f});\n\n        // Compute bounds for where in dy we will look\n        float startRLerp = floor(float(r) * invHeightScale);\n        int startDyR = int(startRLerp - float(winHeight / 2));\n\n        float startCLerp = floor(float(c) * invWidthScale);\n        int startDyC = int(startCLerp - float(winWidth / 2));\n\n        // Loop over dy\n        for (int dyROffset = 0; dyROffset < winHeight; dyROffset++) {\n          int dyR = dyROffset + startDyR;\n\n          // Guard against the window exceeding the bounds of dy\n          if (dyR < 0 || dyR >= ${o}) {\n            continue;\n          }\n\n          for (int dyCOffset = 0; dyCOffset < winWidth; dyCOffset++) {\n            int dyC = dyCOffset + startDyC;\n\n            // Guard against the window exceeding the bounds of dy\n            if (dyC < 0 || dyC >= ${s}) {\n              continue;\n            }\n\n            float dxR = float(dyR) * heightScale;\n            int topDxRIndex = int(floor(dxR));\n            int bottomDxRIndex = int(min(ceil(dxR), ${r-1}.0));\n            float dxRLerp = dxR - float(topDxRIndex);\n            float inverseDxRLerp = 1.0 - dxRLerp;\n\n            float dxC = float(dyC) * widthScale;\n            int leftDxCIndex = int(floor(dxC));\n            int rightDxCIndex = int(min(ceil(dxC), ${a-1}.0));\n            float dxCLerp = dxC - float(leftDxCIndex);\n            float inverseDxCLerp = 1.0 - dxCLerp;\n\n            if (r == topDxRIndex && c == leftDxCIndex) {\n              // topLeft\n              accumulator +=\n                getDy(b, dyR, dyC, d) * inverseDxRLerp * inverseDxCLerp;\n            }\n\n            if (r == topDxRIndex && c == rightDxCIndex) {\n              // topRight\n              accumulator += getDy(b, dyR, dyC, d) * inverseDxRLerp * dxCLerp;\n            }\n\n            if (r == bottomDxRIndex && c == leftDxCIndex) {\n              // bottomLeft\n              accumulator += getDy(b, dyR, dyC, d) * dxRLerp * inverseDxCLerp;\n            }\n\n            if (r == bottomDxRIndex && c == rightDxCIndex) {\n              // bottomRight\n              accumulator += getDy(b, dyR, dyC, d) * dxRLerp * dxCLerp;\n            }\n          }\n        }\n        // End loop over dy\n\n        setOutput(accumulator);\n      }\n    `}}const zl={kernelName:Fn,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t,attrs:r}=e,{images:a,dy:o}=n,{alignCorners:s}=r,i=new Ul(o.shape,a.shape,s);return t.runWebGLProgram(i,[o],o.dtype)}};class Xl{constructor(e,n,t,r,a){this.variableNames=["A"],this.outputShape=[];const[o,s,i,u]=e;this.outputShape=[o,n,t,u];const l=[r&&n>1?s-1:s,r&&t>1?i-1:i],c=[r&&n>1?n-1:n,r&&t>1?t-1:t],d=r?"0.5":"0.0";let p;p=a?"max((vec2(yRC) + vec2(0.5)) * effectiveInputOverOutputRatioRC, vec2(0.0))":"vec2(yRC) * effectiveInputOverOutputRatioRC",this.userCode=`\n      const vec2 effectiveInputOverOutputRatioRC = vec2(\n          ${l[0]/c[0]},\n          ${l[1]/c[1]});\n      const vec2 inputShapeRC = vec2(${s}.0, ${i}.0);\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n        ivec2 yRC = coords.yz;\n\n        // Fractional source index.\n        vec2 sourceFracIndexRC = ${p};\n\n        // Compute the coordinators of nearest neighbor point.\n        ivec2 sourceNearestRC = ivec2(\n          min(inputShapeRC - 1.0, floor(sourceFracIndexRC + ${d})));\n        float newValue = getA(b, sourceNearestRC.x, sourceNearestRC.y, d);\n\n        setOutput(newValue);\n      }\n    `}}const Hl={kernelName:On,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t,attrs:r}=e,{images:a}=n,{alignCorners:o,halfPixelCenters:s,size:i}=r,[u,l]=i,c=new Xl(a.shape,u,l,o,s);return t.runWebGLProgram(c,[a],a.dtype)}};class jl{constructor(e,n,t){this.variableNames=["dy"],this.outputShape=[],this.outputShape=n;const[,r,a]=n,[,o,s]=e,i=[t&&o>1?r-1:r,t&&s>1?a-1:a],u=[t&&o>1?o-1:o,t&&s>1?s-1:s],l=i[0]/u[0],c=i[1]/u[1],d=1/l,p=1/c,h=2*Math.ceil(d)+2,f=2*Math.ceil(p)+2;this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n        int r = coords[1];\n        int c = coords[2];\n\n        float accumulator = 0.0;\n\n        const float heightScale = float(${l});\n        const float widthScale = float(${c});\n\n        const float invHeightScale = float(${d});\n        const float invWidthScale = float(${p});\n\n        const int winHeight = int(${h});\n        const int winWidth = int(${f});\n\n        // Compute bounds for where in dy we will look\n        float startRLerp = floor(float(r) * invHeightScale);\n        int startDyR = int(floor(startRLerp - float(winHeight / 2)));\n\n        float startCLerp = floor(float(c) * invWidthScale);\n        int startDyC = int(floor(startCLerp - float(winWidth / 2)));\n\n        // Loop over dy\n        for (int dyROffset = 0; dyROffset < winHeight; dyROffset++) {\n          int dyR = dyROffset + startDyR;\n\n          // Guard against the window exceeding the bounds of dy\n          if (dyR < 0 || dyR >= ${o}) {\n            continue;\n          }\n\n          for (int dyCOffset = 0; dyCOffset < winWidth; dyCOffset++) {\n            int dyC = dyCOffset + startDyC;\n\n            // Guard against the window exceeding the bounds of dy\n            if (dyC < 0 || dyC >= ${s}) {\n              continue;\n            }\n\n            float sourceFracRow =\n              float(${i[0]}) *\n                (float(dyR) / float(${u[0]}));\n\n            float sourceFracCol =\n                float(${i[1]}) *\n                  (float(dyC) / float(${u[1]}));\n\n            int sourceNearestRow = int(min(\n                float(int(${r}) - 1),\n                ${t} ? float(round(sourceFracRow)) :\n                                  float(floor(sourceFracRow))));\n\n            int sourceNearestCol = int(min(\n                float(int(${a}) - 1),\n                ${t} ? float(round(sourceFracCol)) :\n                                  float(floor(sourceFracCol))));\n\n            if (r == sourceNearestRow && c == sourceNearestCol) {\n              accumulator += getDy(b, dyR, dyC, d);\n            }\n          }\n        }\n        // End loop over dy\n\n        setOutput(accumulator);\n      }\n    `}}const Kl={kernelName:_n,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t,attrs:r}=e,{images:a,dy:o}=n,{alignCorners:s}=r,i=new jl(o.shape,a.shape,s);return t.runWebGLProgram(i,[o],o.dtype)}};class ql{constructor(e,n){this.variableNames=["x"];const t=e.length;if(t>4)throw new Error(`WebGL backend: Reverse of rank-${t} tensor is not yet supported`);if(this.outputShape=e,1===t)return void(this.userCode=`\n        void main() {\n          int coord = getOutputCoords();\n          setOutput(getX(${e[0]} - coord - 1));\n        }\n      `);const r=e.map((t,r)=>(t=>-1!==n.indexOf(t)&&1!==e[t]?`${e[t]} - coords[${t}] - 1`:`coords[${t}]`)(r)).join(","),a=ra(t);this.userCode=`\n      void main() {\n        ${a} coords = getOutputCoords();\n        setOutput(getX(${r}));\n      }\n    `}}class Yl{constructor(e,n){this.variableNames=["x"],this.packedInputs=!0,this.packedOutput=!0;const t=e.length;if(t>4)throw new Error(`WebGL backend: Reverse of rank-${t} tensor is not yet supported`);this.outputShape=e;const r=no("rc",t),a=`${r[t-1]} + 1 < ${this.outputShape[t-1]}`,o=`${r[t-2]} + 1 < ${this.outputShape[t-2]}`,s=ra(t);function i(t){const r=e.map((r,a)=>function(t,r){return-1!==n.indexOf(t)&&1!==e[t]?`${e[t]} - ${r[t]} - 1`:`${r[t]}`}(a,t));return`getChannel(getX(${r.join(",")}), vec2(${r.slice(-2).join(",")}))`}this.userCode=1===t?`\n        void main(){\n          int rc = getOutputCoords();\n          vec4 result = vec4(0.);\n          result.r = getChannel(getX(${e[0]} - rc - 1),\n            ${e[0]} - rc - 1);\n          if(${a}){\n              result.g = getChannel(getX(${e[0]} - (rc  + 1) - 1),\n                ${e[0]} - (rc  + 1) - 1);\n          }\n          setOutput(result);\n        }\n      `:`\n        void main() {\n          ${s} rc = getOutputCoords();\n          vec4 result = vec4(0.);\n          result.r = ${function(e){return i(e)}(r.slice())};\n          if(${a}){\n            result.g = ${function(e){return e[t-1]="("+e[t-1]+" + 1)",i(e)}(r.slice())};\n          }\n          if(${o}) {\n            result.b = ${function(e){return e[t-2]="("+e[t-2]+" + 1)",i(e)}(r.slice())};\n            if(${a}) {\n              result.a = ${function(e){return e[t-1]="("+e[t-1]+" + 1)",e[t-2]="("+e[t-2]+" + 1)",i(e)}(r.slice())};\n            }\n          }\n          setOutput(result);\n        }\n    `}}const Ql={kernelName:Dn,backendName:"webgl",kernelFunc:function(t){const{inputs:r,backend:a,attrs:o}=t,{x:s}=r,{dims:i}=o,u=s.shape.length,l=e.parseAxisParam(i,s.shape);if(0===u)return Ro({inputs:{x:s},backend:a});const c=n().getBool("WEBGL_PACK_ARRAY_OPERATIONS")?new Yl(s.shape,l):new ql(s.shape,l);return a.runWebGLProgram(c,[s],s.dtype)}};class Zl{constructor(e,n,t,a){this.variableNames=["Image"],this.outputShape=[];const o=e[1],s=e[2],i=Math.sin(n).toFixed(3),u=Math.cos(n).toFixed(3);this.outputShape=e;const[l,c]=r.getImageCenter(a,o,s),d=l.toFixed(3),p=c.toFixed(3);let h="";h="number"==typeof t?`float outputValue = ${t.toFixed(2)};`:`\n        vec3 fill = vec3(${t.join(",")});\n        float outputValue = fill[coords[3]];`,this.userCode=`\n        void main() {\n          ivec4 coords = getOutputCoords();\n          int x = coords[2];\n          int y = coords[1];\n          float coordXFloat = (float(x) - ${d}) * ${u} - (float(y) - ${p}) * ${i};\n          float coordYFloat = (float(x) - ${d}) * ${i} + (float(y) - ${p}) * ${u};\n          int coordX = int(round(coordXFloat + ${d}));\n          int coordY = int(round(coordYFloat + ${p}));\n          ${h}\n          if(coordX >= 0 && coordX < ${s} && coordY >= 0 && coordY < ${o}) {\n            outputValue = getImage(coords[0], coordY, coordX, coords[3]);\n          }\n          setOutput(outputValue);\n        }\n    `}}const Jl={kernelName:Ln,backendName:"webgl",kernelFunc:({inputs:e,attrs:n,backend:t})=>{const{image:r}=e,{radians:a,fillValue:o,center:s}=n,i=t,u=new Zl(r.shape,a,o,s);return i.runWebGLProgram(u,[r],r.dtype)}},ec={kernelName:Pn,backendName:"webgl",kernelFunc:Oo({opSnippet:"\n  // OpenGL ES does not support round function.\n  // The algorithm is based on banker's rounding.\n  float base = floor(x);\n  if ((x - base) < 0.5) {\n    return floor(x);\n  } else if ((x - base) > 0.5) {\n    return ceil(x);\n  } else {\n    if (mod(base, 2.0) == 0.0) {\n      return base;\n    } else {\n      return base + 1.0;\n    }\n  }\n"})},nc={kernelName:Bn,backendName:"webgl",kernelFunc:Oo({opSnippet:"return inversesqrt(x);",cpuKernelImpl:Xa})};class tc{constructor(e,n,t,r,a,o,s=!0){this.variableNames=["updates","indices","defaultValue"],this.outputShape=o;const i=ra(a.length),u=ra(o.length);let l="";1===t?l="i":2===t&&(l="i, j");const c=`getIndices(${l})`;let d="";1===r?d="i":2===r&&(d="i, coords[1]");const p=`getUpdates(${d})`,h=n>1?"strides[j]":"strides";this.userCode=`\n        ${i} strides = ${i}(${a});\n\n        void main() {\n          ${u} coords = getOutputCoords();\n          float sum = 0.0;\n          bool found = false;\n          for (int i = 0; i < ${e}; i++) {\n            int flattenedIndex = 0;\n            for (int j = 0; j < ${n}; j++) {\n              int index = round(${c});\n              flattenedIndex += index * ${h};\n            }\n            if (flattenedIndex == coords[0]) {\n              sum += ${p};\n              found = true;\n            }\n          }\n          setOutput(mix(getDefaultValue(), sum, float(found)));\n        }\n      `}}const rc={kernelName:Wn,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t,attrs:a}=e,{indices:o,updates:s}=n,{shape:i}=a,{sliceRank:u,numUpdates:l,sliceSize:c,strides:d,outputSize:p}=r.calculateShapes(s,o,i),h=[p/c,c];if(0===p)return t.makeTensorInfo(i,o.dtype);const f=Uo({inputs:{x:o},backend:t,attrs:{shape:[l,u]}}),x=Uo({inputs:{x:s},backend:t,attrs:{shape:[l,c]}}),g=t.makeTensorInfo([],"float32",new Float32Array([0])),m=new tc(l,u,f.shape.length,x.shape.length,d,h),b=t.runWebGLProgram(m,[x,f,g],x.dtype),C=Uo({inputs:{x:b},backend:t,attrs:{shape:i}});return t.disposeIntermediateTensorInfo(f),t.disposeIntermediateTensorInfo(x),t.disposeIntermediateTensorInfo(b),t.disposeIntermediateTensorInfo(g),C}};class ac{constructor(e,n,t){let r,a;if(this.variableNames=["c","a","b"],this.outputShape=n,t>4)throw Error(`Where for rank ${t} is not yet supported`);if(1===t)a="resRC",r="resRC";else{const t=["resRC.x","resRC.y","resRC.z","resRC.w"],o=[],s=[];for(let r=0;r<n.length;r++)s.push(`${t[r]}`),r<e&&o.push(`${t[r]}`);r=o.join(),a=s.join()}const o=ra(t);this.userCode=`\n      void main() {\n        ${o} resRC = getOutputCoords();\n        float cVal = getC(${r});\n        if (cVal >= 1.0) {\n          setOutput(getA(${a}));\n        } else {\n          setOutput(getB(${a}));\n        }\n      }\n    `}}const oc={kernelName:Vn,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t}=e,{condition:r,t:a,e:s}=n,i=new ac(r.shape.length,a.shape,a.shape.length);return t.runWebGLProgram(i,[r,a,s],o(a.dtype,s.dtype))}},sc={kernelName:Mn,backendName:"webgl",kernelFunc:Oo({opSnippet:`\n  // Stable and Attracting Fixed Point (0, 1) for Normalized Weights.\n  // see: https://arxiv.org/abs/1706.02515\n  float scaleAlpha = ${r.SELU_SCALEALPHA};\n  float scale = ${r.SELU_SCALE};\n  return (x >= 0.0) ? scale * x : scaleAlpha * (exp(x) - 1.0);\n`})},ic={kernelName:Gn,backendName:"webgl",kernelFunc:Oo({opSnippet:"return 1.0 / (1.0 + exp(-1.0 * x));"})},uc={kernelName:Un,backendName:"webgl",kernelFunc:Oo({opSnippet:"\n  if (isnan(x)) { return 0.0; }\n  return sign(x);\n"})},lc={kernelName:zn,backendName:"webgl",kernelFunc:Oo({opSnippet:"if (isnan(x)) return x;\n  return sin(x);\n"})},cc={kernelName:Xn,backendName:"webgl",kernelFunc:Oo({opSnippet:"\n  float e2x = exp(x);\n  return (e2x - 1.0 / e2x) / 2.0;\n"})},dc={kernelName:Hn,backendName:"webgl",kernelFunc:Oo({opSnippet:"\n  float epsilon = 1.1920928955078125e-7;\n  float threshold = log(epsilon) + 2.0;\n\n  bool too_large = x > -threshold;\n  bool too_small = x < threshold;\n\n  float result;\n  float exp_x = exp(x);\n\n  if (too_large){\n    result = x;\n  }\n  else if (too_small){\n    result = exp_x;\n  }\n  else{\n    result = log(exp_x + 1.0);\n  }\n  return result;\n"})},pc={kernelName:jn,backendName:"webgl",kernelFunc:n=>{const{inputs:t,backend:a,attrs:o}=n,{x:s}=t,{blockShape:i,paddings:u}=o;e.assert(s.shape.length<=4,()=>"spaceToBatchND for rank > 4 with a WebGL backend not implemented yet");const l=i.reduce((e,n)=>e*n),c=[[0,0]];c.push(...u);for(let e=1+i.length;e<s.shape.length;++e)c.push([0,0]);const d=[],p=Al({inputs:{x:s},backend:a,attrs:{paddings:c,constantValue:0}}),h=r.getReshaped(p.shape,i,l,!1),f=r.getPermuted(h.length,i.length,!1),x=r.getReshapedPermuted(p.shape,i,l,!1),g=Uo({inputs:{x:p},backend:a,attrs:{shape:h}}),m=Jo({inputs:{x:g},backend:a,attrs:{perm:f}}),b=Uo({inputs:{x:m},backend:a,attrs:{shape:x}});return d.push(p),d.push(g),d.push(m),d.forEach(e=>a.disposeIntermediateTensorInfo(e)),b}};const hc={kernelName:Kn,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t,attrs:a}=e,{sparseIndices:o,sparseValues:s,defaultValue:i}=n,{outputShape:u}=a,{sliceRank:l,numUpdates:c,strides:d,outputSize:p}=r.calculateShapes(s,o,u),h=new tc(c,l,o.shape.length,s.shape.length,d,[p,1],!1),f=t.runWebGLProgram(h,[s,o,i],s.dtype),x=Uo({inputs:{x:f},backend:t,attrs:{shape:u}});return t.disposeIntermediateTensorInfo(f),x}};const fc={kernelName:qn,backendName:"webgl",kernelFunc:function(n){const{inputs:t,backend:a,attrs:o}=n,{x:s}=t,{numOrSizeSplits:i,axis:u}=o,l=e.parseAxisParam(u,s.shape)[0],c=r.prepareSplitSize(s,i,l),d=s.shape.length,p=new Array(d).fill(0),h=s.shape.slice();return c.map(e=>{const n=[...h];n[l]=e;const t=Bs({inputs:{x:s},backend:a,attrs:{begin:p,size:n}});return p[l]+=e,t})}},xc={kernelName:Yn,backendName:"webgl",kernelFunc:Oo({opSnippet:"return sqrt(x);"})},gc={kernelName:Qn,backendName:"webgl",kernelFunc:Oo({opSnippet:"return x * x;"})},mc={kernelName:Zn,backendName:"webgl",kernelFunc:_o({opSnippet:"return (a - b) * (a - b);",packedOpSnippet:"return (a - b) * (a - b);"})};const bc={kernelName:Jn,backendName:"webgl",kernelFunc:function({inputs:e,attrs:n,backend:t}){const{x:r}=e,a=lo+`\n    return x > 0.0 ? 1.0 : float(${n.alpha});\n  `,o=new uo(r.shape,a);return t.runWebGLProgram(o,[r],r.dtype)}};class Cc{constructor(e,n,t){this.variableNames=["x"],this.outputShape=t;const r=t.length,a=ra(t.length),o=ra(t.length);let s="";if(1===r)s="coords * strides + begin";else{let e=0;s=t.map((n,r)=>(e++,1===t.length?`coords * strides[${r}] + begin[${r}]`:`coords[${e-1}] * strides[${r}] + begin[${r}]`)).join(",")}this.userCode=`\n      ${a} begin = ${a}(${e});\n      ${a} strides = ${a}(${n});\n\n      void main() {\n        ${o} coords = getOutputCoords();\n        setOutput(getX(${s}));\n      }\n    `}}const vc={kernelName:et,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t,attrs:r}=e,{x:o}=n,{begin:i,end:u,strides:l,beginMask:c,endMask:d,ellipsisMask:p,newAxisMask:h,shrinkAxisMask:f}=r,{nonStrided:x,$begin:g,$strides:m,size:b,newShape:C,outShape:v}=s.sliceInfo(o.shape,i,u,l,c,d,p,h,f),$=Uo({inputs:{x:o},backend:t,attrs:{shape:C}});let I;if(x){const e=Bs({inputs:{x:$},backend:t,attrs:{begin:g,size:b}});I=Uo({inputs:{x:e},backend:t,attrs:{shape:v}}),t.disposeIntermediateTensorInfo(e)}else if(v.some(e=>0===e))I=t.makeTensorInfo(v,o.dtype,[]);else{if(t.shouldExecuteOnCPU([$])){const e=t.texData.get($.dataId).values,n=a($.shape,$.dtype,e),r=Ka(v,n,m,g);I=t.makeTensorInfo(v,$.dtype,r.values)}else{const e=new Cc(g,m,v);I=t.runWebGLProgram(e,[$],$.dtype)}}const R=Uo({inputs:{x:I},backend:t,attrs:{shape:v}});return t.disposeIntermediateTensorInfo($),t.disposeIntermediateTensorInfo(I),R}},$c={kernelName:nt,backendName:"webgl",kernelFunc:Oo({opSnippet:"return tan(x);"})},Ic={kernelName:tt,backendName:"webgl",kernelFunc:Oo({opSnippet:"\n  float e2x = exp(-2.0 * abs(x));\n  return sign(x) * (1.0 - e2x) / (1.0 + e2x);\n"})};class Rc{constructor(e,n){this.variableNames=["A"];const t=new Array(e.length);for(let r=0;r<t.length;r++)t[r]=e[r]*n[r];this.outputShape=t,this.rank=t.length;const r=ra(this.rank),a=function(e){const n=e.length;if(n>5)throw Error(`Tile for rank ${n} is not yet supported`);if(1===n)return`imod(resRC, ${e[0]})`;const t=["resRC.x","resRC.y","resRC.z","resRC.w","resRC.u"],r=[];for(let n=0;n<e.length;n++)r.push(`imod(${t[n]}, ${e[n]})`);return r.join()}(e);this.userCode=`\n      void main() {\n        ${r} resRC = getOutputCoords();\n        setOutput(getA(${a}));\n      }\n    `}}function yc(n){const{inputs:t,backend:r,attrs:o}=n,{x:s}=t,{reps:i}=o;if("string"===s.dtype){const n=r.readSync(s.dataId).map(n=>e.decodeString(n)),t=a(s.shape,s.dtype,n),o=Ya(t,i);return r.makeTensorInfo(o.shape,o.dtype,o.values)}const u=new Rc(s.shape,i);return r.runWebGLProgram(u,[s],s.dtype)}const wc={kernelName:rt,backendName:"webgl",kernelFunc:yc};const kc={kernelName:at,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t,attrs:r}=e,{x:a}=n,{k:o,sorted:s}=r,i=t.readSync(a.dataId),[u,l]=Qa(i,a.shape,a.dtype,o,s);return[t.makeTensorInfo(u.shape,u.dtype,u.values),t.makeTensorInfo(l.shape,l.dtype,l.values)]}};const Tc={kernelName:ot,backendName:"webgl",kernelFunc:function(e){const{inputs:n,attrs:t,backend:r}=e,{axis:a}=t,{x:o}=n;lr(o,"unique"),console.warn("WARNING: ","UI might be locked temporarily as data is being downloaded");const s=r.readSync(o.dataId),{outputValues:i,outputShape:u,indices:l}=Ja(s,a,o.shape,o.dtype);return[r.makeTensorInfo(u,o.dtype,i),r.makeTensorInfo([l.length],"int32",l)]}};const Ec={kernelName:st,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t,attrs:r}=e,{value:a}=n;let{axis:o}=r;o<0&&(o+=a.shape.length);const s=a,i=s.shape.length,u=a.shape[o],l=new Array(i-1);let c=0;for(let e=0;e<i;e++)e!==o&&(l[c++]=s.shape[e]);const d=[],p=new Array(i).fill(0),h=s.shape.slice();h[o]=1;const f=new Array(u);for(let e=0;e<f.length;e++){p[o]=e;const n=Bs({inputs:{x:s},backend:t,attrs:{begin:p,size:h}}),r=Uo({inputs:{x:n},backend:t,attrs:{shape:l}});f[e]=r,d.push(n)}return d.forEach(e=>t.disposeIntermediateTensorInfo(e)),f}};class Nc{constructor(e,n){this.variableNames=["x","segmentIds"];const t=e.windowSize,r=e.batchSize,a=e.inSize,o=e.numSegments,s=o*Math.ceil(a/t);this.outputShape=[r,s];const i=4*Math.floor(t/4),u=t%4,l="\n        sumValue += dot(values, segFilter);\n    ";let c="";a%t>0&&(c=`\n        if (inIdx < 0 || inIdx >= ${a}) {\n          return initializationValue;\n        }\n      `);let d="";a%t>0&&(d=`\n        if (inIdx < 0 || inIdx >= ${a}) {\n          return -1.0;\n        }\n      `),this.userCode=`\n      const float initializationValue = 0.0;\n\n      float getValue(int batch, int inIdx) {\n        ${c}\n        return getX(batch, inIdx);\n      }\n\n      float getSegmentIdAtIndex(int inIdx) {\n        ${d}\n        return getSegmentIds(inIdx);\n      }\n\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int batch = coords[0];\n        int outIdx = coords[1];\n        int inOffset = int(floor(float(outIdx) / float(\n          ${o})) * float(${t}));\n        int currentSeg = int(mod(float(outIdx), float(${o})));\n\n        float sumValue = 0.0;\n\n        for (int i = 0; i < ${i}; i += 4) {\n          int inIdx = inOffset + i;\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2),\n            getValue(batch, inIdx + 3)\n          );\n\n          vec4 segFilter = vec4(\n            int(getSegmentIdAtIndex(inIdx)) == currentSeg ? 1 : 0,\n            int(getSegmentIdAtIndex(inIdx + 1)) == currentSeg ? 1 : 0,\n            int(getSegmentIdAtIndex(inIdx + 2)) == currentSeg ? 1 : 0,\n            int(getSegmentIdAtIndex(inIdx + 3)) == currentSeg ? 1 : 0\n          );\n\n          ${l}\n        }\n\n        int inIdx = inOffset + ${i};\n        if (${1===u}) {\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            initializationValue,\n            initializationValue,\n            initializationValue\n          );\n\n          int inIdxSeg = int(getSegmentIdAtIndex(inIdx));\n\n          vec4 segFilter = vec4(\n            int(getSegmentIdAtIndex(inIdx)) == currentSeg ? 1 : 0,\n            0,\n            0,\n            0\n          );\n\n          ${l}\n        } else if (${2===u}) {\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            initializationValue,\n            initializationValue\n          );\n\n          vec4 segFilter = vec4(\n            int(getSegmentIdAtIndex(inIdx)) == currentSeg ? 1 : 0,\n            int(getSegmentIdAtIndex(inIdx + 1)) == currentSeg ? 1 : 0,\n              0,\n              0\n          );\n\n          ${l}\n        } else if (${3===u}) {\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2),\n            initializationValue\n          );\n\n          vec4 segFilter = vec4(\n            int(getSegmentIdAtIndex(inIdx)) == currentSeg ? 1 : 0,\n            int(getSegmentIdAtIndex(inIdx + 1)) == currentSeg ? 1 : 0,\n            int(getSegmentIdAtIndex(inIdx + 2)) == currentSeg ? 1 : 0,\n            0\n          );\n\n          ${l}\n        }\n        setOutput(sumValue);\n      }\n    `}}const Sc=[Vu,Gu,ts,rs,as,os,is,cs,ds,ps,gs,ms,bs,Cs,$s,vs,Is,ks,ws,Ns,Ss,As,_s,Vs,Ms,Hs,Ks,Qs,ei,ko,ui,Ci,vi,fi,Ii,Ri,$i,yi,wi,Ti,Ai,Fi,_i,Vi,Mi,Pi,Ui,Xi,Hi,ji,Ki,qi,Zi,eu,tu,ou,uu,cu,pu,hu,gu,bu,Cu,$u,Ru,yu,wu,yo,ku,oi,Tu,Eu,Nu,No,Su,Au,Fu,_u,Ou,Du,Lu,Pu,zu,ju,Hu,Yu,Qu,Zu,Xu,Ju,el,nl,al,ol,fl,Go,gl,bl,vl,Il,Us,yl,Tl,El,Fl,Ol,Fo,_l,Ll,Xs,ul,Pl,Wl,Bl,zo,Gl,zl,Hl,Kl,Ql,Jl,ec,nc,rc,oc,sc,ic,uc,lc,cc,Ws,hl,dc,pc,hc,fc,xc,gc,mc,bc,vc,dl,Zo,$c,Ic,wc,kc,es,Tc,Ec,{kernelName:it,backendName:"webgl",kernelFunc:function(n){const{inputs:t,backend:a,attrs:o}=n,{x:s,segmentIds:i}=t,{numSegments:u}=o,l=s.shape.length,c=[];let d=0;const p=r.getAxesPermutation([d],l);let h=s;null!=p&&(h=Jo({inputs:{x:s},backend:a,attrs:{perm:p}}),c.push(h),d=r.getInnerMostAxes(1,l)[0]);const f=r.segment_util.computeOutShape(h.shape,d,u),x=e.sizeFromShape([h.shape[d]]),g=Uo({inputs:{x:h},backend:a,attrs:{shape:[-1,x]}});c.push(g);const m=$(s.dtype),b=(e,n,t,o,s)=>{const i=e.shape[0],u=e.shape[1],l=r.segment_util.segOpComputeOptimalWindowSize(u,s),d=new Nc({windowSize:l,inSize:u,batchSize:i,numSegments:s},n),p=a.compileAndRun(d,[e,t],o);if(c.push(p),p.shape[1]===s)return p;const h=Dl({backend:a,attrs:{start:0,stop:s,step:1,dtype:"float32"}}),f=yc({inputs:{x:h},backend:a,attrs:{reps:[u/l]}});return c.push(h),c.push(f),b(p,n,f,o,s)},C=Uo({inputs:{x:b(g,"unsortedSegmentSum",i,m,u)},backend:a,attrs:{shape:f}});let v=C;if(null!=p){c.push(C);const e=r.getUndoAxesPermutation(p);v=Jo({inputs:{x:v},backend:a,attrs:{perm:e}})}return c.forEach(e=>a.disposeIntermediateTensorInfo(e)),v}},kl];for(const e of Sc)ut(e);export{Xr as GPGPUContext,mo as MathBackendWebGL,Co as forceHalfFloat,zr as gpgpu_util,dt as setWebGLContext,bo as version_webgl,vo as webgl,cr as webgl_util};
//# sourceMappingURL=tf-backend-webgl.fesm.min.js.map
