/**
 * @license
 * Copyright 2021 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
!function(e,n){"object"==typeof exports&&"undefined"!=typeof module?n(exports,require("@tensorflow/tfjs-core")):"function"==typeof define&&define.amd?define(["exports","@tensorflow/tfjs-core"],n):n((e=e||self).tf=e.tf||{},e.tf)}(this,(function(e,n){"use strict";const t={},a={alpha:!1,antialias:!1,premultipliedAlpha:!1,preserveDrawingBuffer:!1,depth:!1,stencil:!1,failIfMajorPerformanceCaveat:!0};function r(e,n){t[e]=n}function o(e){if(!(e in t)){const n=function(e){if(1!==e&&2!==e)throw new Error("Cannot get WebGL rendering context, WebGL is disabled.");const n=function(e){if("undefined"!=typeof OffscreenCanvas&&2===e)return new OffscreenCanvas(300,150);if("undefined"!=typeof document)return document.createElement("canvas");throw new Error("Cannot create a canvas in this context")}(e);if(n.addEventListener("webglcontextlost",(n=>{n.preventDefault(),delete t[e]}),!1),1===e)return n.getContext("webgl",a)||n.getContext("experimental-webgl",a);return n.getContext("webgl2",a)}(e);if(null===n)return console.log("Could not get context for WebGL version",e),null;t[e]=n}const n=t[e];return n.isContextLost()?(delete t[e],o(e)):(n.disable(n.DEPTH_TEST),n.disable(n.STENCIL_TEST),n.disable(n.BLEND),n.disable(n.DITHER),n.disable(n.POLYGON_OFFSET_FILL),n.disable(n.SAMPLE_COVERAGE),n.enable(n.SCISSOR_TEST),n.enable(n.CULL_FACE),n.cullFace(n.BACK),t[e])}var i,s,u;function l(e,n){return[n,e]}function c(e){const t=n.util.sizeFromShape(e),a=Math.ceil(t/4);return n.util.sizeToSquarishShape(a)}function d(e,n){return[Math.max(1,Math.ceil(n/2)),Math.max(1,Math.ceil(e/2))]}function p(e,t){const a=e;let r,o,i,s,u,l,c,d,p,h;return 2===n.env().getNumber("WEBGL_VERSION")?(r=a.R32F,o=a.R16F,i=a.RGBA16F,s=a.RGBA32F,u=a.RED,c=4,d=1,p=a.HALF_FLOAT,h=a.FLOAT):(r=e.RGBA,o=e.RGBA,i=e.RGBA,s=a.RGBA,u=e.RGBA,c=4,d=4,p=null!=t?t.HALF_FLOAT_OES:null,h=e.FLOAT),l=e.RGBA,{internalFormatFloat:r,internalFormatHalfFloat:o,internalFormatPackedHalfFloat:i,internalFormatPackedFloat:s,textureFormatFloat:u,downloadTextureFormat:l,downloadUnpackNumChannels:c,defaultNumChannels:d,textureTypeHalfFloat:p,textureTypeFloat:h}}function h(e,t){const a=t();return n.env().getBool("DEBUG")&&function(e){const n=e.getError();if(n!==e.NO_ERROR)throw new Error("WebGL Error: "+x(e,n))}(e),a}!function(e){e[e.DENSE=0]="DENSE",e[e.SHARED_BATCH=1]="SHARED_BATCH"}(i||(i={})),function(e){e[e.RENDER=0]="RENDER",e[e.UPLOAD=1]="UPLOAD",e[e.PIXELS=2]="PIXELS",e[e.DOWNLOAD=3]="DOWNLOAD"}(s||(s={})),function(e){e[e.UNPACKED_FLOAT16=0]="UNPACKED_FLOAT16",e[e.UNPACKED_FLOAT32=1]="UNPACKED_FLOAT32",e[e.PACKED_4X1_UNSIGNED_BYTE=2]="PACKED_4X1_UNSIGNED_BYTE",e[e.PACKED_2X2_FLOAT32=3]="PACKED_2X2_FLOAT32",e[e.PACKED_2X2_FLOAT16=4]="PACKED_2X2_FLOAT16"}(u||(u={}));function f(e){return!!(n.env().getBool("WEBGL_RENDER_FLOAT32_ENABLED")||0===e||5.96e-8<Math.abs(e)&&Math.abs(e)<65504)}function x(e,n){switch(n){case e.NO_ERROR:return"NO_ERROR";case e.INVALID_ENUM:return"INVALID_ENUM";case e.INVALID_VALUE:return"INVALID_VALUE";case e.INVALID_OPERATION:return"INVALID_OPERATION";case e.INVALID_FRAMEBUFFER_OPERATION:return"INVALID_FRAMEBUFFER_OPERATION";case e.OUT_OF_MEMORY:return"OUT_OF_MEMORY";case e.CONTEXT_LOST_WEBGL:return"CONTEXT_LOST_WEBGL";default:return`Unknown error code ${n}`}}function m(e,n){return L(e,(()=>e.getExtension(n)),'Extension "'+n+'" not supported on this browser.')}function g(e,n){const t=L(e,(()=>e.createShader(e.VERTEX_SHADER)),"Unable to create vertex WebGLShader.");if(h(e,(()=>e.shaderSource(t,n))),h(e,(()=>e.compileShader(t))),!1===e.getShaderParameter(t,e.COMPILE_STATUS))throw console.log(e.getShaderInfoLog(t)),new Error("Failed to compile vertex shader.");return t}function b(e,t){const a=L(e,(()=>e.createShader(e.FRAGMENT_SHADER)),"Unable to create fragment WebGLShader.");if(h(e,(()=>e.shaderSource(a,t))),h(e,(()=>e.compileShader(a))),!1===e.getShaderParameter(a,e.COMPILE_STATUS))throw function(e,t){const a=v.exec(t);if(null==a)return console.log(`Couldn't parse line number in error: ${t}`),void console.log(e);const r=+a[1],o=e.split("\n"),i=o.length.toString().length+2,s=o.map(((e,t)=>n.util.rightPad((t+1).toString(),i)+e));let u=0;for(let e=0;e<s.length;e++)u=Math.max(s[e].length,u);const l=s.slice(0,r-1),c=s.slice(r-1,r),d=s.slice(r);console.log(l.join("\n")),console.log(t.split("\n")[0]),console.log(`%c ${n.util.rightPad(c[0],u)}`,"border:1px solid red; background-color:#e3d2d2; color:#a61717"),console.log(d.join("\n"))}(t,e.getShaderInfoLog(a)),new Error("Failed to compile fragment shader.");return a}const v=/ERROR: [0-9]+:([0-9]+):/g;function C(e){return L(e,(()=>e.createProgram()),"Unable to create WebGLProgram.")}function $(e,n){if(h(e,(()=>e.linkProgram(n))),!1===e.getProgramParameter(n,e.LINK_STATUS))throw console.log(e.getProgramInfoLog(n)),new Error("Failed to link vertex and fragment shaders.")}function I(e,n){if(h(e,(()=>e.validateProgram(n))),!1===e.getProgramParameter(n,e.VALIDATE_STATUS))throw console.log(e.getProgramInfoLog(n)),new Error("Shader program validation failed.")}function y(e,n){const t=L(e,(()=>e.createBuffer()),"Unable to create WebGLBuffer");return h(e,(()=>e.bindBuffer(e.ARRAY_BUFFER,t))),h(e,(()=>e.bufferData(e.ARRAY_BUFFER,n,e.STATIC_DRAW))),t}function k(e,n){const t=L(e,(()=>e.createBuffer()),"Unable to create WebGLBuffer");return h(e,(()=>e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,t))),h(e,(()=>e.bufferData(e.ELEMENT_ARRAY_BUFFER,n,e.STATIC_DRAW))),t}function w(e){return L(e,(()=>e.createTexture()),"Unable to create WebGLTexture.")}function R(e,t){const a=n.env().getNumber("WEBGL_MAX_TEXTURE_SIZE");if(e<=0||t<=0){throw new Error("Requested texture size "+`[${e}x${t}]`+" is invalid.")}if(e>a||t>a){throw new Error("Requested texture size "+`[${e}x${t}]`+" greater than WebGL maximum on this browser / GPU "+`[${a}x${a}]`+".")}}function S(e){return L(e,(()=>e.createFramebuffer()),"Unable to create WebGLFramebuffer.")}function T(e,n,t,a,r,o,i){const s=e.getAttribLocation(n,t);return-1!==s&&(h(e,(()=>e.bindBuffer(e.ARRAY_BUFFER,a))),h(e,(()=>e.vertexAttribPointer(s,r,e.FLOAT,!1,o,i))),h(e,(()=>e.enableVertexAttribArray(s))),!0)}function E(e,n,t){B(e,t),h(e,(()=>e.activeTexture(e.TEXTURE0+t))),h(e,(()=>e.bindTexture(e.TEXTURE_2D,n)))}function N(e,n,t){return L(e,(()=>e.getUniformLocation(n,t)),'uniform "'+t+'" not present in program.')}function A(e,n,t){return e.getUniformLocation(n,t)}function F(e,n,t,a){h(e,(()=>E(e,n,a))),h(e,(()=>e.uniform1i(t,a)))}function _(e,n,t){h(e,(()=>e.bindFramebuffer(e.FRAMEBUFFER,t))),h(e,(()=>e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,n,0)))}function O(e,n){h(e,(()=>e.bindFramebuffer(e.FRAMEBUFFER,n))),h(e,(()=>e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,null,0)))}function D(e){const n=e.checkFramebufferStatus(e.FRAMEBUFFER);if(n!==e.FRAMEBUFFER_COMPLETE)throw new Error("Error binding framebuffer: "+P(e,n))}function P(e,n){switch(n){case e.FRAMEBUFFER_INCOMPLETE_ATTACHMENT:return"FRAMEBUFFER_INCOMPLETE_ATTACHMENT";case e.FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:return"FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT";case e.FRAMEBUFFER_INCOMPLETE_DIMENSIONS:return"FRAMEBUFFER_INCOMPLETE_DIMENSIONS";case e.FRAMEBUFFER_UNSUPPORTED:return"FRAMEBUFFER_UNSUPPORTED";default:return`unknown error ${n}`}}function L(e,n,t){const a=h(e,(()=>n()));if(null==a)throw new Error(t);return a}function B(e,n){const t=e.MAX_COMBINED_TEXTURE_IMAGE_UNITS-1,a=n+e.TEXTURE0;if(a<e.TEXTURE0||a>t){throw new Error(`textureUnit must be in ${`[gl.TEXTURE0, gl.TEXTURE${t}]`}.`)}}function V(e,t=2){return n.util.sizeFromShape(e.slice(0,e.length-t))}function W(e){if(0===e.length)throw Error("Cannot get rows and columns of an empty shape array.");return[e.length>1?e[e.length-2]:1,e[e.length-1]]}function U(e){let n=[1,1,1];return 0===e.length||1===e.length&&1===e[0]||(n=[V(e),...W(e)]),n}function M(e,t=!1){let a=n.env().getNumber("WEBGL_MAX_TEXTURE_SIZE");if(t&&(a*=2,1===(e=e.map(((t,a)=>a>=e.length-2?n.util.nearestLargerEven(e[a]):e[a]))).length&&(e=[2,e[0]])),2!==e.length){const t=n.util.squeezeShape(e);e=t.newShape}let r=n.util.sizeFromShape(e);if(e.length<=1&&r<=a)return[1,r];if(2===e.length&&e[0]<=a&&e[1]<=a)return e;if(3===e.length&&e[0]*e[1]<=a&&e[2]<=a)return[e[0]*e[1],e[2]];if(3===e.length&&e[0]<=a&&e[1]*e[2]<=a)return[e[0],e[1]*e[2]];if(4===e.length&&e[0]*e[1]*e[2]<=a&&e[3]<=a)return[e[0]*e[1]*e[2],e[3]];if(4===e.length&&e[0]<=a&&e[1]*e[2]*e[3]<=a)return[e[0],e[1]*e[2]*e[3]];if(t){const t=V(e);let a=2,o=2;return e.length&&([a,o]=W(e)),r=t*(a/2)*(o/2),n.util.sizeToSquarishShape(r).map((e=>2*e))}return n.util.sizeToSquarishShape(r)}function G(e){return e%2==0}function z(e,t){if(e=e.slice(-2),t=t.slice(-2),n.util.arraysEqual(e,t))return!0;if(!e.length||!t.length)return!0;if(0===e[0]||0===e[1]||0===t[0]||0===t[1])return!0;if(e.length!==t.length){const n=e.slice(-1)[0],a=t.slice(-1)[0];if(n===a)return!0;if(G(n)&&G(a)&&(1===e[0]||1===t[0]))return!0}return e[1]===t[1]&&G(e[0])&&G(t[0])}let X,H;function j(e){if(null==X){const n=o(e);X=n.getParameter(n.MAX_TEXTURE_SIZE)}return X}function K(e){if(null==H){const n=o(e);H=n.getParameter(n.MAX_TEXTURE_IMAGE_UNITS)}return Math.min(16,H)}function q(e){if(0===e)return 0;let n;const t=o(e);return n=Y(t,"EXT_disjoint_timer_query_webgl2")&&2===e?2:Y(t,"EXT_disjoint_timer_query")?1:0,n}function Y(e,n){return null!=e.getExtension(n)}function Q(e){try{if(null!=o(e))return!0}catch(e){return console.log("Error when getting WebGL context: ",e),!1}return!1}function Z(e){if(0===e)return!1;const n=o(e);if(1===e){if(!Y(n,"OES_texture_float"))return!1}else if(!Y(n,"EXT_color_buffer_float"))return!1;return ee(n)}function J(e){if(0===e)return!1;const n=o(e);if(1!==e){if(Y(n,"EXT_color_buffer_float"))return ee(n);const e="EXT_color_buffer_half_float";if(Y(n,e)){const t=n.getExtension(e);return function(e,n){const t=p(e,n),a=e.createTexture();e.bindTexture(e.TEXTURE_2D,a);const r=1,o=1;e.texImage2D(e.TEXTURE_2D,0,t.internalFormatHalfFloat,r,o,0,t.textureFormatFloat,t.textureTypeHalfFloat,null);const i=e.createFramebuffer();e.bindFramebuffer(e.FRAMEBUFFER,i),e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,a,0);const s=e.checkFramebufferStatus(e.FRAMEBUFFER)===e.FRAMEBUFFER_COMPLETE;return e.bindTexture(e.TEXTURE_2D,null),e.bindFramebuffer(e.FRAMEBUFFER,null),e.deleteTexture(a),e.deleteFramebuffer(i),s}(n,t)}return!1}if(!Y(n,"OES_texture_float"))return!1;if(!Y(n,"WEBGL_color_buffer_float"))return!1;return ee(n)}function ee(e){const n=p(e),t=e.createTexture();e.bindTexture(e.TEXTURE_2D,t);e.texImage2D(e.TEXTURE_2D,0,n.internalFormatFloat,1,1,0,n.textureFormatFloat,n.textureTypeFloat,null);const a=e.createFramebuffer();e.bindFramebuffer(e.FRAMEBUFFER,a),e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,t,0);const r=e.checkFramebufferStatus(e.FRAMEBUFFER)===e.FRAMEBUFFER_COMPLETE;return e.bindTexture(e.TEXTURE_2D,null),e.bindFramebuffer(e.FRAMEBUFFER,null),e.deleteTexture(t),e.deleteFramebuffer(a),r}function ne(e){if(2!==e)return!1;return null!=o(e).fenceSync}function te(e,t){Array.isArray(e)||(e=[e]),e.forEach((e=>{null!=e&&n.util.assert("complex64"!==e.dtype,(()=>`${t} does not support complex64 tensors in the WebGL backend.`))}))}var ae=Object.freeze({__proto__:null,callAndCheck:h,canBeRepresented:f,getWebGLErrorMessage:x,getExtensionOrThrow:m,createVertexShader:g,createFragmentShader:b,createProgram:C,linkProgram:$,validateProgram:I,createStaticVertexBuffer:y,createStaticIndexBuffer:k,getNumChannels:function(){return 2===n.env().getNumber("WEBGL_VERSION")?1:4},createTexture:w,validateTextureSize:R,createFramebuffer:S,bindVertexBufferToProgramAttribute:T,bindTextureUnit:E,unbindTextureUnit:function(e,n){B(e,n),h(e,(()=>e.activeTexture(e.TEXTURE0+n))),h(e,(()=>e.bindTexture(e.TEXTURE_2D,null)))},getProgramUniformLocationOrThrow:N,getProgramUniformLocation:A,bindTextureToProgramUniformSampler:F,bindCanvasToFramebuffer:function(e){h(e,(()=>e.bindFramebuffer(e.FRAMEBUFFER,null))),h(e,(()=>e.viewport(0,0,e.canvas.width,e.canvas.height))),h(e,(()=>e.scissor(0,0,e.canvas.width,e.canvas.height)))},bindColorTextureToFramebuffer:_,unbindColorTextureFromFramebuffer:O,validateFramebuffer:D,getFramebufferErrorMessage:P,getBatchDim:V,getRowsCols:W,getShapeAs3D:U,getTextureShapeFromLogicalShape:M,isReshapeFree:z,getWebGLMaxTextureSize:j,resetMaxTextureSize:function(){X=null},resetMaxTexturesInShader:function(){H=null},getMaxTexturesInShader:K,getWebGLDisjointQueryTimerVersion:q,hasExtension:Y,isWebGLVersionEnabled:Q,isCapableOfRenderingToFloatTexture:Z,isDownloadFloatTextureEnabled:J,isWebGLFenceEnabled:ne,assertNotComplex:te});const re=n.env();function oe(){let e,t,a,r,o,i,s,u,l,c;return 2===n.env().getNumber("WEBGL_VERSION")?(e="#version 300 es",t="in",a="out",r="in",o="texture",i="outputColor",s="out vec4 outputColor;",u="\n      bool isnan_custom(float val) {\n        return (val > 0.0 || val < 0.0) ? false : val != 0.0;\n      }\n\n      bvec4 isnan_custom(vec4 val) {\n        return bvec4(isnan_custom(val.x),\n          isnan_custom(val.y), isnan_custom(val.z), isnan_custom(val.w));\n      }\n\n      #define isnan(value) isnan_custom(value)\n    ",l="",c="\n      #define round(value) newRound(value)\n      int newRound(float value) {\n        return int(floor(value + 0.5));\n      }\n\n      ivec4 newRound(vec4 value) {\n        return ivec4(floor(value + vec4(0.5)));\n      }\n    "):(e="",t="attribute",a="varying",r="varying",o="texture2D",i="gl_FragColor",s="",u="\n      #define isnan(value) isnan_custom(value)\n      bool isnan_custom(float val) {\n        return (val > 0. || val < 1. || val == 0.) ? false : true;\n      }\n      bvec4 isnan_custom(vec4 val) {\n        return bvec4(isnan(val.x), isnan(val.y), isnan(val.z), isnan(val.w));\n      }\n    ",l="\n      uniform float INFINITY;\n\n      bool isinf(float val) {\n        return abs(val) == INFINITY;\n      }\n      bvec4 isinf(vec4 val) {\n        return equal(abs(val), vec4(INFINITY));\n      }\n    ",c="\n      int round(float value) {\n        return int(floor(value + 0.5));\n      }\n\n      ivec4 round(vec4 value) {\n        return ivec4(floor(value + vec4(0.5)));\n      }\n    "),{version:e,attribute:t,varyingVs:a,varyingFs:r,texture2D:o,output:i,defineOutput:s,defineSpecialNaN:u,defineSpecialInf:l,defineRound:c}}function ie(e,t,a="index"){const r=n.util.computeStrides(t);return r.map(((n,t)=>`${`int ${e[t]} = ${a} / ${n}`}; ${t===r.length-1?`int ${e[t+1]} = ${a} - ${e[t]} * ${n}`:`index -= ${e[t]} * ${n}`};`)).join("")}function se(e,t,a="index"){const r=n.util.computeStrides(t);return r.map(((n,t)=>`${`int ${e[t]} = ${a} / outShapeStrides[${t}]`}; ${t===r.length-1?`int ${e[t+1]} = ${a} - ${e[t]} * outShapeStrides[${t}]`:`index -= ${e[t]} * outShapeStrides[${t}]`};`)).join("")}function ue(e,n,t="index"){const a=function(e,n){const t=e.length,a=e.map((e=>`${n}[${e}]`)),r=new Array(t-1);r[t-2]=a[t-1];for(let e=t-3;e>=0;--e)r[e]=`(${r[e+1]} * ${a[e+1]})`;return r}(e.map(((e,n)=>n)),n);return a.map(((n,r)=>`${`int ${e[r]} = ${t} / ${a[r]}`}; ${r===a.length-1?`int ${e[r+1]} = ${t} - ${e[r]} * ${a[r]}`:`index -= ${e[r]} * ${a[r]}`};`)).join("")}function le(e){const t=n.util.computeStrides(e).map((e=>e.toString()));return`\n  int getFlatIndex(ivec3 coords) {\n    return coords.x * ${t[0]} + coords.y * ${t[1]} + coords.z;\n  }\n`}re.registerFlag("HAS_WEBGL",(()=>re.getNumber("WEBGL_VERSION")>0)),re.registerFlag("WEBGL_VERSION",(()=>Q(2)?2:Q(1)?1:0)),re.registerFlag("WEBGL_CHECK_NUMERICAL_PROBLEMS",(()=>!1)),re.registerFlag("WEBGL_BUFFER_SUPPORTED",(()=>2===re.get("WEBGL_VERSION"))),re.registerFlag("WEBGL_CPU_FORWARD",(()=>!0)),re.registerFlag("WEBGL_FORCE_F16_TEXTURES",(()=>!1)),re.registerFlag("WEBGL_PACK",(()=>re.getBool("HAS_WEBGL"))),re.registerFlag("WEBGL_PACK_NORMALIZATION",(()=>re.getBool("WEBGL_PACK"))),re.registerFlag("WEBGL_PACK_CLIP",(()=>re.getBool("WEBGL_PACK"))),re.registerFlag("WEBGL_PACK_DEPTHWISECONV",(()=>re.getBool("WEBGL_PACK"))),re.registerFlag("WEBGL_PACK_BINARY_OPERATIONS",(()=>re.getBool("WEBGL_PACK"))),re.registerFlag("WEBGL_PACK_UNARY_OPERATIONS",(()=>re.getBool("WEBGL_PACK"))),re.registerFlag("WEBGL_PACK_ARRAY_OPERATIONS",(()=>re.getBool("WEBGL_PACK"))),re.registerFlag("WEBGL_PACK_IMAGE_OPERATIONS",(()=>re.getBool("WEBGL_PACK"))),re.registerFlag("WEBGL_PACK_REDUCE",(()=>re.getBool("WEBGL_PACK"))),re.registerFlag("WEBGL_LAZILY_UNPACK",(()=>re.getBool("WEBGL_PACK"))),re.registerFlag("WEBGL_CONV_IM2COL",(()=>re.getBool("WEBGL_PACK"))),re.registerFlag("WEBGL_MAX_TEXTURE_SIZE",(()=>j(re.getNumber("WEBGL_VERSION")))),re.registerFlag("WEBGL_MAX_TEXTURES_IN_SHADER",(()=>K(re.getNumber("WEBGL_VERSION")))),re.registerFlag("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION",(()=>{const e=re.getNumber("WEBGL_VERSION");return 0===e?0:q(e)})),re.registerFlag("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE",(()=>re.getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION")>0&&!n.device_util.isMobile())),re.registerFlag("WEBGL_RENDER_FLOAT32_CAPABLE",(()=>Z(re.getNumber("WEBGL_VERSION")))),re.registerFlag("WEBGL_RENDER_FLOAT32_ENABLED",(()=>!re.getBool("WEBGL_FORCE_F16_TEXTURES")&&re.getBool("WEBGL_RENDER_FLOAT32_CAPABLE"))),re.registerFlag("WEBGL_DOWNLOAD_FLOAT_ENABLED",(()=>J(re.getNumber("WEBGL_VERSION")))),re.registerFlag("WEBGL_FENCE_API_ENABLED",(()=>ne(re.getNumber("WEBGL_VERSION")))),re.registerFlag("WEBGL_SIZE_UPLOAD_UNIFORM",(()=>re.getBool("WEBGL_RENDER_FLOAT32_ENABLED")?4:0)),re.registerFlag("WEBGL_DELETE_TEXTURE_THRESHOLD",(()=>-1),(e=>{if(e<0&&-1!==e)throw new Error(`WEBGL_DELETE_TEXTURE_THRESHOLD must be -1 (indicating never delete) or at least 0, but got ${e}.`)})),re.registerFlag("WEBGL_FLUSH_THRESHOLD",(()=>n.device_util.isMobile()&&re.getBool("IS_CHROME")?1:-1),(e=>{if(e<0&&-1!==e)throw new Error(`WEBGL_FLUSH_THRESHOLD must be -1 (indicating never manual flush) or at least 0, but got ${e}.`)})),re.registerFlag("CPU_HANDOFF_SIZE_THRESHOLD",(()=>128)),re.registerFlag("WEBGL_USE_SHAPES_UNIFORMS",(()=>!1)),re.registerFlag("TOPK_LAST_DIM_CPU_HANDOFF_SIZE_THRESHOLD",(()=>1e5)),re.registerFlag("TOPK_K_CPU_HANDOFF_THRESHOLD",(()=>128));const ce="\n  const float FLOAT_MAX = 1.70141184e38;\n  const float FLOAT_MIN = 1.17549435e-38;\n\n  lowp vec4 encode_float(highp float v) {\n    if (isnan(v)) {\n      return vec4(255, 255, 255, 255);\n    }\n\n    highp float av = abs(v);\n\n    if(av < FLOAT_MIN) {\n      return vec4(0.0, 0.0, 0.0, 0.0);\n    } else if(v > FLOAT_MAX) {\n      return vec4(0.0, 0.0, 128.0, 127.0) / 255.0;\n    } else if(v < -FLOAT_MAX) {\n      return vec4(0.0, 0.0,  128.0, 255.0) / 255.0;\n    }\n\n    highp vec4 c = vec4(0,0,0,0);\n\n    highp float e = floor(log2(av));\n    highp float m = exp2(fract(log2(av))) - 1.0;\n\n    c[2] = floor(128.0 * m);\n    m -= c[2] / 128.0;\n    c[1] = floor(32768.0 * m);\n    m -= c[1] / 32768.0;\n    c[0] = floor(8388608.0 * m);\n\n    highp float ebias = e + 127.0;\n    c[3] = floor(ebias / 2.0);\n    ebias -= c[3] * 2.0;\n    c[2] += floor(ebias) * 128.0;\n\n    c[3] += 128.0 * step(0.0, -v);\n\n    return c / 255.0;\n  }\n",{getBroadcastDims:de}=n.backend_util;function pe(e,t,a){const r=[];if(e.forEach((e=>{const t=n.util.sizeFromShape(e.shapeInfo.logicalShape);if(e.shapeInfo.isUniform?r.push(`uniform float ${e.name}${t>1?`[${t}]`:""};`):(r.push(`uniform sampler2D ${e.name};`),r.push(`uniform int offset${e.name};`)),a.enableShapeUniforms){const{uniformShape:n}=ye(a.packedInputs,e.shapeInfo.logicalShape,e.shapeInfo.texShape);switch(n.length){case 1:r.push(`uniform int ${e.name}Shape;`);break;case 2:r.push(`uniform ivec2 ${e.name}Shape;`);break;case 3:r.push(`uniform ivec3 ${e.name}Shape;`);break;case 4:r.push(`uniform ivec4 ${e.name}Shape;`)}r.push(`uniform ivec2 ${e.name}TexShape;`)}})),a.enableShapeUniforms){switch(t.logicalShape.length){case 1:r.push("uniform int outShape;");break;case 2:r.push("uniform ivec2 outShape;"),r.push("uniform int outShapeStrides;");break;case 3:r.push("uniform ivec3 outShape;"),r.push("uniform ivec2 outShapeStrides;");break;case 4:r.push("uniform ivec4 outShape;"),r.push("uniform ivec3 outShapeStrides;")}r.push("uniform ivec2 outTexShape;")}a.customUniforms&&a.customUniforms.forEach((e=>{r.push(`uniform ${e.type} ${e.name}${e.arrayIndex?`[${e.arrayIndex}]`:""};`)}));const o=r.join("\n"),i=e.map((e=>function(e,t,a=!1,r){let o="";o+=a?fe(e,r):he(e,r);const i=e.shapeInfo.logicalShape,s=t.logicalShape;i.length<=s.length&&(o+=a?function(e,t){const a=e.name,r=a.charAt(0).toUpperCase()+a.slice(1),o="get"+r+"AtOutCoords",i=e.shapeInfo.logicalShape.length,s=t.logicalShape.length,u=de(e.shapeInfo.logicalShape,t.logicalShape),l=Ie(s),c=s-i;let d;const p=["x","y","z","w","u","v"];d=0===i?"":s<2&&u.length>=1?"coords = 0;":u.map((e=>`coords.${p[e+c]} = 0;`)).join("\n");let h="";h=s<2&&i>0?"coords":e.shapeInfo.logicalShape.map(((e,n)=>`coords.${p[n+c]}`)).join(", ");let f="return outputValue;";const x=1===n.util.sizeFromShape(e.shapeInfo.logicalShape),m=1===n.util.sizeFromShape(t.logicalShape);if(1!==i||x||m){if(x&&!m)f=1===s?"\n        return vec4(outputValue.x, outputValue.x, 0., 0.);\n      ":"\n        return vec4(outputValue.x);\n      ";else if(u.length){const e=i-2,n=i-1;u.indexOf(e)>-1&&u.indexOf(n)>-1?f="return vec4(outputValue.x);":u.indexOf(e)>-1?f="return vec4(outputValue.x, outputValue.y, outputValue.x, outputValue.y);":u.indexOf(n)>-1&&(f="return vec4(outputValue.xx, outputValue.zz);")}}else f="\n      return vec4(outputValue.xy, outputValue.xy);\n    ";return`\n    vec4 ${o}() {\n      ${l} coords = getOutputCoords();\n      ${d}\n      vec4 outputValue = get${r}(${h});\n      ${f}\n    }\n  `}(e,t):function(e,t){const a=e.name,r=a.charAt(0).toUpperCase()+a.slice(1),o="get"+r+"AtOutCoords",i=t.texShape,s=e.shapeInfo.texShape,u=e.shapeInfo.logicalShape.length,l=t.logicalShape.length;if(!e.shapeInfo.isUniform&&u===l&&null==e.shapeInfo.flatOffset&&n.util.arraysEqual(s,i))return`\n      float ${o}() {\n        return sampleTexture(${a}, resultUV);\n      }\n    `;const c=Ie(l),d=de(e.shapeInfo.logicalShape,t.logicalShape),p=l-u;let h;const f=["x","y","z","w","u","v"];h=0===u?"":l<2&&d.length>=1?"coords = 0;":d.map((e=>`coords.${f[e+p]} = 0;`)).join("\n");let x="";x=l<2&&u>0?"coords":e.shapeInfo.logicalShape.map(((e,n)=>`coords.${f[n+p]}`)).join(", ");return`\n    float ${o}() {\n      ${c} coords = getOutputCoords();\n      ${h}\n      return get${r}(${x});\n    }\n  `}(e,t));return o}(e,t,a.packedInputs,a.enableShapeUniforms))).join("\n"),s=t.texShape,u=oe(),l=function(e){return`\n    float sampleTexture(sampler2D textureSampler, vec2 uv) {\n      return ${e.texture2D}(textureSampler, uv).r;\n    }\n  `}(u);let c,d,p=function(e){return`${e.version}\n    precision highp float;\n    precision highp int;\n    precision highp sampler2D;\n    ${e.varyingFs} vec2 resultUV;\n    ${e.defineOutput}\n    const vec2 halfCR = vec2(0.5, 0.5);\n\n    struct ivec5\n    {\n      int x;\n      int y;\n      int z;\n      int w;\n      int u;\n    };\n\n    struct ivec6\n    {\n      int x;\n      int y;\n      int z;\n      int w;\n      int u;\n      int v;\n    };\n\n    uniform float NAN;\n    ${e.defineSpecialNaN}\n    ${e.defineSpecialInf}\n    ${e.defineRound}\n\n    int imod(int x, int y) {\n      return x - y * (x / y);\n    }\n\n    int idiv(int a, int b, float sign) {\n      int res = a / b;\n      int mod = imod(a, b);\n      if (sign < 0. && mod != 0) {\n        res -= 1;\n      }\n      return res;\n    }\n\n    //Based on the work of Dave Hoskins\n    //https://www.shadertoy.com/view/4djSRW\n    #define HASHSCALE1 443.8975\n    float random(float seed){\n      vec2 p = resultUV * seed;\n      vec3 p3  = fract(vec3(p.xyx) * HASHSCALE1);\n      p3 += dot(p3, p3.yzx + 19.19);\n      return fract((p3.x + p3.y) * p3.z);\n    }\n\n    ${xe}\n    ${me}\n    ${ge}\n  `}(u);t.isPacked?(c=function(e,t,a){switch(e.length){case 0:return ve();case 1:return function(e,n,t){const a=[Math.ceil(n[0]/2),Math.ceil(n[1]/2)];if(1===a[0])return t?"\n      int getOutputCoords() {\n        return 2 * int(resultUV.x * ceil(float(outTexShape[1]) / 2.0));\n      }\n    ":`\n      int getOutputCoords() {\n        return 2 * int(resultUV.x * ${a[1]}.0);\n      }\n    `;if(1===a[1])return t?"\n      int getOutputCoords() {\n        return 2 * int(resultUV.y * ceil(float(outTexShape[0]) / 2.0));\n      }\n    ":`\n      int getOutputCoords() {\n        return 2 * int(resultUV.y * ${a[0]}.0);\n      }\n    `;if(t)return"\n    int getOutputCoords() {\n      ivec2 packedTexShape = ivec2(ceil(float(outTexShape[0]) / 2.0), ceil(float(outTexShape[1]) / 2.0));\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(packedTexShape[0], packedTexShape[1]));\n      return 2 * (resTexRC.x * packedTexShape[1] + resTexRC.y);\n    }\n  ";return`\n    int getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${a[0]}, ${a[1]}));\n      return 2 * (resTexRC.x * ${a[1]} + resTexRC.y);\n    }\n  `}(0,t,a);case 2:return function(e,t,a){const r=[Math.ceil(t[0]/2),Math.ceil(t[1]/2)];if(n.util.arraysEqual(e,t))return a?"\n      ivec2 getOutputCoords() {\n        ivec2 packedTexShape = ivec2(ceil(float(outTexShape[0]) / 2.0), ceil(float(outTexShape[1]) / 2.0));\n        return 2 * ivec2(resultUV.yx * vec2(packedTexShape[0], packedTexShape[1]));\n      }\n    ":`\n      ivec2 getOutputCoords() {\n        return 2 * ivec2(resultUV.yx * vec2(${r[0]}, ${r[1]}));\n      }\n    `;const o=Math.ceil(e[1]/2);if(a)return"\n    ivec2 getOutputCoords() {\n      ivec2 packedTexShape = ivec2(ceil(float(outTexShape[0]) / 2.0), ceil(float(outTexShape[1]) / 2.0));\n      int texelsInLogicalRow = int(ceil(float(outShape[1]) / 2.0));\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(packedTexShape[0], packedTexShape[1]));\n\n      int index = resTexRC.x * packedTexShape[1] + resTexRC.y;\n      int r = 2 * (index / texelsInLogicalRow);\n      int c = imod(index, texelsInLogicalRow) * 2;\n\n      return ivec2(r, c);\n    }\n  ";return`\n    ivec2 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${r[0]}, ${r[1]}));\n\n      int index = resTexRC.x * ${r[1]} + resTexRC.y;\n      int r = 2 * (index / ${o});\n      int c = imod(index, ${o}) * 2;\n\n      return ivec2(r, c);\n    }\n  `}(e,t,a);case 3:return function(e,n,t){if(t)return"\n    ivec3 getOutputCoords() {\n      ivec2 packedTexShape = ivec2(ceil(float(outTexShape[0]) / 2.0), ceil(float(outTexShape[1]) / 2.0));\n      int texelsInLogicalRow = int(ceil(float(outShape[2]) / 2.0));\n      int texelsInBatch = texelsInLogicalRow * int(ceil(float(outShape[1]) / 2.0));\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(packedTexShape[0], packedTexShape[1]));\n      int index = resTexRC.x * packedTexShape[1] + resTexRC.y;\n\n      int b = index / texelsInBatch;\n      index -= b * texelsInBatch;\n\n      int r = 2 * (index / texelsInLogicalRow);\n      int c = imod(index, texelsInLogicalRow) * 2;\n\n      return ivec3(b, r, c);\n    }\n  ";const a=[Math.ceil(n[0]/2),Math.ceil(n[1]/2)],r=Math.ceil(e[2]/2),o=r*Math.ceil(e[1]/2);return`\n    ivec3 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${a[0]}, ${a[1]}));\n      int index = resTexRC.x * ${a[1]} + resTexRC.y;\n\n      int b = index / ${o};\n      index -= b * ${o};\n\n      int r = 2 * (index / ${r});\n      int c = imod(index, ${r}) * 2;\n\n      return ivec3(b, r, c);\n    }\n  `}(e,t,a);default:return function(e,n,t){if(t)return"\n    ivec4 getOutputCoords() {\n      ivec2 packedTexShape = ivec2(ceil(float(outTexShape[0]) / 2.0), ceil(float(outTexShape[1]) / 2.0));\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(packedTexShape[0], packedTexShape[1]));\n      int index = resTexRC.x * packedTexShape[1] + resTexRC.y;\n\n      int texelsInLogicalRow = int(ceil(float(outShape[3]) / 2.0));\n      int texelsInBatch = texelsInLogicalRow * int(ceil(float(outShape[2]) / 2.0));\n      int texelsInBatchN = texelsInBatch * outShape[1];\n\n      int b2 = index / texelsInBatchN;\n      index -= b2 * texelsInBatchN;\n\n      int b = index / texelsInBatch;\n      index -= b * texelsInBatch;\n\n      int r = 2 * (index / texelsInLogicalRow);\n      int c = imod(index, texelsInLogicalRow) * 2;\n\n      return ivec4(b2, b, r, c);\n    }\n  ";const a=[Math.ceil(n[0]/2),Math.ceil(n[1]/2)],r=Math.ceil(e[e.length-1]/2),o=r*Math.ceil(e[e.length-2]/2);let i=o,s="",u="b, r, c";for(let n=2;n<e.length-1;n++)i*=e[e.length-n-1],s=`\n      int b${n} = index / ${i};\n      index -= b${n} * ${i};\n    `+s,u=`b${n}, `+u;return`\n    ivec${e.length} getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${a[0]}, ${a[1]}));\n      int index = resTexRC.x * ${a[1]} + resTexRC.y;\n\n      ${s}\n\n      int b = index / ${o};\n      index -= b * ${o};\n\n      int r = 2 * (index / ${r});\n      int c = imod(index, ${r}) * 2;\n\n      return ivec${e.length}(${u});\n    }\n  `}(e,t,a)}}(t.logicalShape,s,a.enableShapeUniforms),d=function(e){return`\n    void setOutput(vec4 val) {\n      ${e.output} = val;\n    }\n  `}(u)):(c=function(e,t,a){switch(e.length){case 0:return ve();case 1:return function(e,n,t){if(1===n[0])return t?"\n      int getOutputCoords() {\n        return int(resultUV.x * float(outTexShape[1]));\n      }\n    ":`\n      int getOutputCoords() {\n        return int(resultUV.x * ${n[1]}.0);\n      }\n    `;if(1===n[1])return t?"\n      int getOutputCoords() {\n        return int(resultUV.y * float(outTexShape[0]));\n      }\n    ":`\n      int getOutputCoords() {\n        return int(resultUV.y * ${n[0]}.0);\n      }\n    `;if(t)return"\n    int getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(outTexShape[0], outTexShape[1]));\n      return resTexRC.x * outTexShape[1] + resTexRC.y;\n    }\n  ";return`\n    int getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${n[0]}, ${n[1]}));\n      return resTexRC.x * ${n[1]} + resTexRC.y;\n    }\n  `}(0,t,a);case 2:return function(e,t,a){if(n.util.arraysEqual(e,t))return a?"\n      ivec2 getOutputCoords() {\n        return ivec2(resultUV.yx * vec2(outTexShape[0], outTexShape[1]));\n      }\n    ":`\n      ivec2 getOutputCoords() {\n        return ivec2(resultUV.yx * vec2(${t[0]}, ${t[1]}));\n      }\n    `;if(1===e[1])return a?"\n      ivec2 getOutputCoords() {\n        ivec2 resTexRC = ivec2(resultUV.yx *\n                               vec2(outTexShape[0], outTexShape[1]));\n        int index = resTexRC.x * outTexShape[1] + resTexRC.y;\n        return ivec2(index, 0);\n      }\n    ":`\n      ivec2 getOutputCoords() {\n        ivec2 resTexRC = ivec2(resultUV.yx *\n                               vec2(${t[0]}, ${t[1]}));\n        int index = resTexRC.x * ${t[1]} + resTexRC.y;\n        return ivec2(index, 0);\n      }\n    `;if(1===e[0])return a?"\n      ivec2 getOutputCoords() {\n        ivec2 resTexRC = ivec2(resultUV.yx *\n                               vec2(outTexShape[0], outTexShape[1]));\n        int index = resTexRC.x * outTexShape[1] + resTexRC.y;\n        return ivec2(0, index);\n      }\n    ":`\n      ivec2 getOutputCoords() {\n        ivec2 resTexRC = ivec2(resultUV.yx *\n                               vec2(${t[0]}, ${t[1]}));\n        int index = resTexRC.x * ${t[1]} + resTexRC.y;\n        return ivec2(0, index);\n      }\n    `;if(a)return"\n    ivec2 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(outTexShape[0], outTexShape[1]));\n      int index = resTexRC.x * outTexShape[1] + resTexRC.y;\n      int r = index / outShape[1];\n      int c = index - r * outShape[1];\n      return ivec2(r, c);\n    }\n  ";return`\n    ivec2 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${t[0]}, ${t[1]}));\n      int index = resTexRC.x * ${t[1]} + resTexRC.y;\n      int r = index / ${e[1]};\n      int c = index - r * ${e[1]};\n      return ivec2(r, c);\n    }\n  `}(e,t,a);case 3:return function(e,n,t){if(t){return`\n  ivec3 getOutputCoords() {\n    ivec2 resTexRC = ivec2(resultUV.yx *\n                           vec2(outTexShape[0], outTexShape[1]));\n    int index = resTexRC.x * outTexShape[1] + resTexRC.y;\n    ${se(["r","c","d"],e)}\n    return ivec3(r, c, d);\n  }\n`}const a=ie(["r","c","d"],e);return`\n    ivec3 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${n[0]}, ${n[1]}));\n      int index = resTexRC.x * ${n[1]} + resTexRC.y;\n      ${a}\n      return ivec3(r, c, d);\n    }\n  `}(e,t,a);case 4:return function(e,n,t){if(t){return`\n    ivec4 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n        vec2(outTexShape[0], outTexShape[1]));\n      int index = resTexRC.x * outTexShape[1] + resTexRC.y;\n      ${se(["r","c","d","d2"],e)}\n      return ivec4(r, c, d, d2);\n    }\n  `}const a=ie(["r","c","d","d2"],e);return`\n    ivec4 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n        vec2(${n[0]}, ${n[1]}));\n      int index = resTexRC.x * ${n[1]} + resTexRC.y;\n      ${a}\n      return ivec4(r, c, d, d2);\n    }\n  `}(e,t,a);case 5:return function(e,n){const t=ie(["r","c","d","d2","d3"],e);return`\n    ivec5 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx * vec2(${n[0]},\n                             ${n[1]}));\n\n      int index = resTexRC.x * ${n[1]} + resTexRC.y;\n\n      ${t}\n\n      ivec5 outShape = ivec5(r, c, d, d2, d3);\n      return outShape;\n    }\n  `}(e,t);case 6:return function(e,n){const t=ie(["r","c","d","d2","d3","d4"],e);return`\n    ivec6 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n        vec2(${n[0]}, ${n[1]}));\n      int index = resTexRC.x * ${n[1]} + resTexRC.y;\n\n      ${t}\n\n      ivec6 result = ivec6(r, c, d, d2, d3, d4);\n      return result;\n    }\n  `}(e,t);default:throw new Error(`${e.length}-D output sampling is not yet supported`)}}(t.logicalShape,s,a.enableShapeUniforms),d=function(e){return`\n    void setOutput(float val) {\n      ${e.output} = vec4(val, 0, 0, 0);\n    }\n  `}(u)),a.packedInputs&&(p+=be);return[p,l,d,o,c,i,a.userCode].join("\n")}function he(e,t=!1){const a=e.shapeInfo.logicalShape;switch(a.length){case 0:return function(e,n){const t=e.name,a="get"+t.charAt(0).toUpperCase()+t.slice(1);if(e.shapeInfo.isUniform)return`float ${a}() {return ${t};}`;const[r,o]=e.shapeInfo.texShape;if(1===r&&1===o)return`\n      float ${a}() {\n        return sampleTexture(${t}, halfCR);\n      }\n    `;const i=Ce(t);if(n)return`\n    float ${a}() {\n      vec2 uv = uvFromFlat(${t}TexShape[0], ${t}TexShape[1], ${i});\n      return sampleTexture(${t}, uv);\n    }\n  `;const[s,u]=e.shapeInfo.texShape;return`\n    float ${a}() {\n      vec2 uv = uvFromFlat(${s}, ${u}, ${i});\n      return sampleTexture(${t}, uv);\n    }\n  `}(e,t);case 1:return function(e,n){const t=e.name,a="get"+t.charAt(0).toUpperCase()+t.slice(1);if(e.shapeInfo.isUniform)return`\n      float ${a}(int index) {\n        ${$e(e)}\n      }\n    `;const r=e.shapeInfo.texShape,o=r[0],i=r[1];if(1===i&&1===o)return`\n      float ${a}(int index) {\n        return sampleTexture(${t}, halfCR);\n      }\n    `;const s=Ce(t);if(1===i)return n?`\n      float ${a}(int index) {\n        vec2 uv = vec2(0.5, (float(index + ${s}) + 0.5) / float(${t}TexShape[0]));\n        return sampleTexture(${t}, uv);\n      }\n    `:`\n      float ${a}(int index) {\n        vec2 uv = vec2(0.5, (float(index + ${s}) + 0.5) / ${o}.0);\n        return sampleTexture(${t}, uv);\n      }\n    `;if(1===o)return n?`\n      float ${a}(int index) {\n        vec2 uv = vec2((float(index + ${s}) + 0.5) / float(${t}TexShape[1]), 0.5);\n        return sampleTexture(${t}, uv);\n      }\n    `:`\n      float ${a}(int index) {\n        vec2 uv = vec2((float(index + ${s}) + 0.5) / ${i}.0, 0.5);\n        return sampleTexture(${t}, uv);\n      }\n    `;if(n)return`\n    float ${a}(int index) {\n      vec2 uv = uvFromFlat(${t}TexShape[0], ${t}TexShape[1], index + ${s});\n      return sampleTexture(${t}, uv);\n    }\n  `;return`\n    float ${a}(int index) {\n      vec2 uv = uvFromFlat(${o}, ${i}, index + ${s});\n      return sampleTexture(${t}, uv);\n    }\n  `}(e,t);case 2:return function(e,t){const a=e.shapeInfo.logicalShape,r=e.name,o="get"+r.charAt(0).toUpperCase()+r.slice(1),i=e.shapeInfo.texShape;if(null!=i&&n.util.arraysEqual(a,i)){if(t)return`\n      float ${o}(int row, int col) {\n        vec2 uv = (vec2(col, row) + halfCR) / vec2(${r}TexShape[1], ${r}TexShape[0]);\n        return sampleTexture(${r}, uv);\n      }\n    `;const e=i[0];return`\n    float ${o}(int row, int col) {\n      vec2 uv = (vec2(col, row) + halfCR) / vec2(${i[1]}.0, ${e}.0);\n      return sampleTexture(${r}, uv);\n    }\n  `}const{newShape:s,keptDims:u}=n.util.squeezeShape(a),l=s;if(l.length<a.length){const n=["row","col"];return`\n      ${he(ke(e,l),t)}\n      float ${o}(int row, int col) {\n        return ${o}(${we(n,u)});\n      }\n    `}if(e.shapeInfo.isUniform)return`\n      float ${o}(int row, int col) {\n        int index = round(dot(vec2(row, col), vec2(${a[1]}, 1)));\n        ${$e(e)}\n      }\n    `;const c=i[0],d=i[1],p=Ce(r);if(1===d)return t?`\n      float ${o}(int row, int col) {\n        float index = dot(vec3(row, col, ${p}), vec3(${r}Shape[1], 1, 1));\n        vec2 uv = vec2(0.5, (index + 0.5) / float(${r}TexShape[0]));\n        return sampleTexture(${r}, uv);\n      }\n    `:`\n    float ${o}(int row, int col) {\n      float index = dot(vec3(row, col, ${p}), vec3(${a[1]}, 1, 1));\n      vec2 uv = vec2(0.5, (index + 0.5) / ${c}.0);\n      return sampleTexture(${r}, uv);\n    }\n  `;if(1===c)return t?`\n      float ${o}(int row, int col) {\n        float index = dot(vec3(row, col, ${p}), vec3(${r}Shape[1], 1, 1));\n        vec2 uv = vec2((index + 0.5) / float(${r}TexShape[1]), 0.5);\n        return sampleTexture(${r}, uv);\n      }\n    `:`\n    float ${o}(int row, int col) {\n      float index = dot(vec3(row, col, ${p}), vec3(${a[1]}, 1, 1));\n      vec2 uv = vec2((index + 0.5) / ${d}.0, 0.5);\n      return sampleTexture(${r}, uv);\n    }\n  `;if(t)return`\n      float ${o}(int row, int col) {\n        // Explicitly use integer operations as dot() only works on floats.\n        int index = row * ${r}Shape[1] + col + ${p};\n        vec2 uv = uvFromFlat(${r}TexShape[0], ${r}TexShape[1], index);\n        return sampleTexture(${r}, uv);\n      }\n    `;return`\n  float ${o}(int row, int col) {\n    // Explicitly use integer operations as dot() only works on floats.\n    int index = row * ${a[1]} + col + ${p};\n    vec2 uv = uvFromFlat(${c}, ${d}, index);\n    return sampleTexture(${r}, uv);\n  }\n`}(e,t);case 3:return function(e,t){const a=e.shapeInfo.logicalShape,r=e.name,o="get"+r.charAt(0).toUpperCase()+r.slice(1),i=a[1]*a[2],s=a[2],{newShape:u,keptDims:l}=n.util.squeezeShape(a),c=u;if(c.length<a.length){const n=["row","col","depth"];return`\n        ${he(ke(e,c),t)}\n        float ${o}(int row, int col, int depth) {\n          return ${o}(${we(n,l)});\n        }\n      `}if(e.shapeInfo.isUniform)return`\n      float ${o}(int row, int col, int depth) {\n        int index = round(dot(vec3(row, col, depth),\n                          vec3(${i}, ${s}, 1)));\n        ${$e(e)}\n      }\n    `;const d=e.shapeInfo.texShape,p=d[0],h=d[1],f=e.shapeInfo.flatOffset;if(h===i&&null==f)return t?`\n      float ${o}(int row, int col, int depth) {\n        int stride1 = ${r}Shape[2];\n        float texR = float(row);\n        float texC = dot(vec2(col, depth), vec2(stride1, 1));\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                   vec2(${r}TexShape[1], ${r}TexShape[0]);\n        return sampleTexture(${r}, uv);\n      }\n    `:`\n        float ${o}(int row, int col, int depth) {\n          float texR = float(row);\n          float texC = dot(vec2(col, depth), vec2(${s}, 1));\n          vec2 uv = (vec2(texC, texR) + halfCR) /\n                     vec2(${h}.0, ${p}.0);\n          return sampleTexture(${r}, uv);\n        }\n      `;if(h===s&&null==f)return t?`\n      float ${o}(int row, int col, int depth) {\n        float texR = dot(vec2(row, col), vec2(${r}Shape[1], 1));\n        float texC = float(depth);\n        vec2 uv = (vec2(texC, texR) + halfCR) / vec2(${r}TexShape[1], ${r}TexShape[0]);\n        return sampleTexture(${r}, uv);\n      }\n    `:`\n    float ${o}(int row, int col, int depth) {\n      float texR = dot(vec2(row, col), vec2(${a[1]}, 1));\n      float texC = float(depth);\n      vec2 uv = (vec2(texC, texR) + halfCR) / vec2(${h}.0, ${p}.0);\n      return sampleTexture(${r}, uv);\n    }\n  `;const x=Ce(r);if(t)return`\n    float ${o}(int row, int col, int depth) {\n      // Explicitly use integer operations as dot() only works on floats.\n      int stride0 = ${r}Shape[1] * ${r}Shape[2];\n      int stride1 = ${r}Shape[2];\n      int index = row * ${i} + col * ${s} + depth + ${x};\n      vec2 uv = uvFromFlat(${r}TexShape[0], ${r}TexShape[1], index);\n      return sampleTexture(${r}, uv);\n    }\n    `;return`\n      float ${o}(int row, int col, int depth) {\n        // Explicitly use integer operations as dot() only works on floats.\n        int index = row * ${i} + col * ${s} + depth + ${x};\n        vec2 uv = uvFromFlat(${p}, ${h}, index);\n        return sampleTexture(${r}, uv);\n      }\n  `}(e,t);case 4:return function(e,t){const a=e.shapeInfo.logicalShape,r=e.name,o="get"+r.charAt(0).toUpperCase()+r.slice(1),i=a[3],s=a[2]*i,u=a[1]*s,{newShape:l,keptDims:c}=n.util.squeezeShape(a);if(l.length<a.length){const n=["row","col","depth","depth2"];return`\n      ${he(ke(e,l),t)}\n      float ${o}(int row, int col, int depth, int depth2) {\n        return ${o}(${we(n,c)});\n      }\n    `}if(e.shapeInfo.isUniform)return`\n      float ${o}(int row, int col, int depth, int depth2) {\n        int index = round(dot(vec4(row, col, depth, depth2),\n                          vec4(${u}, ${s}, ${i}, 1)));\n        ${$e(e)}\n      }\n    `;const d=e.shapeInfo.flatOffset,p=e.shapeInfo.texShape,h=p[0],f=p[1],x=`int stride2 = ${r}Shape[3];`,m=`int stride1 = ${r}Shape[2] * stride2;`,g=`int stride0 = ${r}Shape[1] * stride1;`;if(f===u&&null==d)return t?`\n      float ${o}(int row, int col, int depth, int depth2) {\n        ${x}\n        ${m}\n        float texR = float(row);\n        float texC =\n            dot(vec3(col, depth, depth2),\n                vec3(stride1, stride2, 1));\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                   vec2(${r}TexShape[1], ${r}TexShape[0]);\n        return sampleTexture(${r}, uv);\n      }\n    `:`\n      float ${o}(int row, int col, int depth, int depth2) {\n        float texR = float(row);\n        float texC =\n            dot(vec3(col, depth, depth2),\n                vec3(${s}, ${i}, 1));\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                   vec2(${f}.0, ${h}.0);\n        return sampleTexture(${r}, uv);\n      }\n    `;if(f===i&&null==d)return t?`\n      float ${o}(int row, int col, int depth, int depth2) {\n        float texR = dot(vec3(row, col, depth),\n                         vec3(${r}Shape[1] * ${r}Shape[2], ${r}Shape[2], 1));\n        float texC = float(depth2);\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                  vec2(${r}TexShape[1], ${r}TexShape[0]);\n        return sampleTexture(${r}, uv);\n      }\n    `:`\n      float ${o}(int row, int col, int depth, int depth2) {\n        float texR = dot(vec3(row, col, depth),\n                         vec3(${a[1]*a[2]}, ${a[2]}, 1));\n        float texC = float(depth2);\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                  vec2(${f}.0, ${h}.0);\n        return sampleTexture(${r}, uv);\n      }\n    `;const b=Ce(r);if(t)return`\n    float ${o}(int row, int col, int depth, int depth2) {\n      // Explicitly use integer operations as dot() only works on floats.\n      ${x}\n      ${m}\n      ${g}\n      int index = row * stride0 + col * stride1 +\n          depth * stride2 + depth2;\n      vec2 uv = uvFromFlat(${r}TexShape[0], ${r}TexShape[1], index + ${b});\n      return sampleTexture(${r}, uv);\n    }\n  `;return`\n    float ${o}(int row, int col, int depth, int depth2) {\n      // Explicitly use integer operations as dot() only works on floats.\n      int index = row * ${u} + col * ${s} +\n          depth * ${i} + depth2;\n      vec2 uv = uvFromFlat(${h}, ${f}, index + ${b});\n      return sampleTexture(${r}, uv);\n    }\n  `}(e,t);case 5:return function(e){const t=e.shapeInfo.logicalShape,a=e.name,r="get"+a.charAt(0).toUpperCase()+a.slice(1),o=t[4],i=t[3]*o,s=t[2]*i,u=t[1]*s,{newShape:l,keptDims:c}=n.util.squeezeShape(t);if(l.length<t.length){const n=["row","col","depth","depth2","depth3"];return`\n      ${he(ke(e,l))}\n      float ${r}(int row, int col, int depth, int depth2, int depth3) {\n        return ${r}(${we(n,c)});\n      }\n    `}if(e.shapeInfo.isUniform)return`\n      float ${r}(int row, int col, int depth, int depth2, int depth3) {\n        float index = dot(\n          vec4(row, col, depth, depth2),\n          vec4(${u}, ${s}, ${i}, ${o})) +\n          depth3;\n        ${$e(e)}\n      }\n    `;const d=e.shapeInfo.flatOffset,p=e.shapeInfo.texShape,h=p[0],f=p[1];if(f===u&&null==d)return`\n      float ${r}(int row, int col, int depth, int depth2, int depth3) {\n        int texR = row;\n        float texC = dot(vec4(col, depth, depth2, depth3),\n                         vec4(${s}, ${i}, ${o}, 1));\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                   vec2(${f}.0, ${h}.0);\n        return sampleTexture(${a}, uv);\n      }\n    `;if(f===o&&null==d)return`\n      float ${r}(int row, int col, int depth, int depth2, int depth3) {\n        float texR = dot(\n          vec4(row, col, depth, depth2),\n          vec4(${t[1]*t[2]*t[3]},\n               ${t[2]*t[3]}, ${t[3]}, 1));\n        int texC = depth3;\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                  vec2(${f}.0, ${h}.0);\n        return sampleTexture(${a}, uv);\n      }\n    `;const x=Ce(a);return`\n    float ${r}(int row, int col, int depth, int depth2, int depth3) {\n      // Explicitly use integer operations as dot() only works on floats.\n      int index = row * ${u} + col * ${s} + depth * ${i} +\n          depth2 * ${o} + depth3 + ${x};\n      vec2 uv = uvFromFlat(${h}, ${f}, index);\n      return sampleTexture(${a}, uv);\n    }\n  `}(e);case 6:return function(e){const t=e.shapeInfo.logicalShape,a=e.name,r="get"+a.charAt(0).toUpperCase()+a.slice(1),{newShape:o,keptDims:i}=n.util.squeezeShape(t);if(o.length<t.length){const n=["row","col","depth","depth2","depth3","depth4"];return`\n      ${he(ke(e,o))}\n      float ${r}(int row, int col, int depth,\n                    int depth2, int depth3, int depth4) {\n        return ${r}(${we(n,i)});\n      }\n    `}const s=t[5],u=t[4]*s,l=t[3]*u,c=t[2]*l,d=t[1]*c;if(e.shapeInfo.isUniform)return`\n      float ${r}(int row, int col, int depth,\n                  int depth2, int depth3, int depth4) {\n        int index = round(dot(\n          vec4(row, col, depth, depth2),\n          vec4(${d}, ${c}, ${l}, ${u})) +\n          dot(\n            vec2(depth3, depth4),\n            vec2(${s}, 1)));\n        ${$e(e)}\n      }\n    `;const p=e.shapeInfo.flatOffset,h=e.shapeInfo.texShape,f=h[0],x=h[1];if(x===d&&null==p)return`\n      float ${r}(int row, int col, int depth,\n                    int depth2, int depth3, int depth4) {\n        int texR = row;\n        float texC = dot(vec4(col, depth, depth2, depth3),\n          vec4(${c}, ${l}, ${u}, ${s})) +\n               float(depth4);\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                   vec2(${x}.0, ${f}.0);\n        return sampleTexture(${a}, uv);\n      }\n    `;if(x===s&&null==p)return`\n      float ${r}(int row, int col, int depth,\n                    int depth2, int depth3, int depth4) {\n        float texR = dot(vec4(row, col, depth, depth2),\n          vec4(${t[1]*t[2]*t[3]*t[4]},\n               ${t[2]*t[3]*t[4]},\n               ${t[3]*t[4]},\n               ${t[4]})) + float(depth3);\n        int texC = depth4;\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                  vec2(${x}.0, ${f}.0);\n        return sampleTexture(${a}, uv);\n      }\n    `;const m=Ce(a);return`\n    float ${r}(int row, int col, int depth,\n                  int depth2, int depth3, int depth4) {\n      // Explicitly use integer operations as dot() only works on floats.\n      int index = row * ${d} + col * ${c} + depth * ${l} +\n          depth2 * ${u} + depth3 * ${s} + depth4 + ${m};\n      vec2 uv = uvFromFlat(${f}, ${x}, index);\n      return sampleTexture(${a}, uv);\n    }\n  `}(e);default:throw new Error(`${a.length}-D input sampling is not yet supported`)}}function fe(e,t){switch(e.shapeInfo.logicalShape.length){case 0:return function(e){const n=e.name,t="get"+n.charAt(0).toUpperCase()+n.slice(1),a=oe();return`\n    vec4 ${t}() {\n      return ${a.texture2D}(${n}, halfCR);\n    }\n  `}(e);case 1:return function(e,n){const t=e.name,a="get"+t.charAt(0).toUpperCase()+t.slice(1),r=e.shapeInfo.texShape,o=oe();if(n)return`\n    vec4 ${a}(int index) {\n      ivec2 packedTexShape = ivec2(ceil(float(${t}TexShape[0]) / 2.0), ceil(float(${t}TexShape[1]) / 2.0));\n      vec2 uv = packedUVfrom1D(\n        packedTexShape[0], packedTexShape[1], index);\n      return ${o.texture2D}(${t}, uv);\n    }\n  `;const i=[Math.ceil(r[0]/2),Math.ceil(r[1]/2)];return`\n    vec4 ${a}(int index) {\n      vec2 uv = packedUVfrom1D(\n        ${i[0]}, ${i[1]}, index);\n      return ${o.texture2D}(${t}, uv);\n    }\n  `}(e,t);case 2:return function(e,t){const a=e.shapeInfo.logicalShape,r=e.name,o="get"+r.charAt(0).toUpperCase()+r.slice(1),i=e.shapeInfo.texShape,s=i[0],u=i[1],l=oe();if(null!=i&&n.util.arraysEqual(a,i))return t?`\n      vec4 ${o}(int row, int col) {\n        vec2 uv = (vec2(col, row) + halfCR) / vec2(${r}TexShape[1], ${r}TexShape[0]);\n\n        return ${l.texture2D}(${r}, uv);\n      }\n    `:`\n      vec4 ${o}(int row, int col) {\n        vec2 uv = (vec2(col, row) + halfCR) / vec2(${u}.0, ${s}.0);\n\n        return ${l.texture2D}(${r}, uv);\n      }\n    `;if(t)return`\n    vec4 ${o}(int row, int col) {\n      ivec2 packedTexShape = ivec2(ceil(float(${r}TexShape[0]) / 2.0), ceil(float(${r}TexShape[1]) / 2.0));\n      int valuesPerRow = int(ceil(float(${r}Shape[1]) / 2.0));\n      vec2 uv = packedUVfrom2D(valuesPerRow, packedTexShape[0], packedTexShape[1], row, col);\n      return ${l.texture2D}(${r}, uv);\n    }\n  `;const c=[Math.ceil(i[0]/2),Math.ceil(i[1]/2)],d=Math.ceil(a[1]/2);return`\n    vec4 ${o}(int row, int col) {\n      vec2 uv = packedUVfrom2D(${d}, ${c[0]}, ${c[1]}, row, col);\n      return ${l.texture2D}(${r}, uv);\n    }\n  `}(e,t);case 3:return function(e,n){const t=e.shapeInfo.logicalShape,a=e.name,r="get"+a.charAt(0).toUpperCase()+a.slice(1),o=e.shapeInfo.texShape,i=[Math.ceil(o[0]/2),Math.ceil(o[1]/2)];if(1===t[0]){const a=[1,2],o=["b","row","col"];return`\n        ${fe(ke(e,t.slice(1)),n)}\n        vec4 ${r}(int b, int row, int col) {\n          return ${r}(${we(o,a)});\n        }\n      `}const s=oe();if(n)return`\n    vec4 ${r}(int b, int row, int col) {\n      ivec2 packedTexShape = ivec2(ceil(float(${a}TexShape[0]) / 2.0), ceil(float(${a}TexShape[1]) / 2.0));\n      int valuesPerRow = int(ceil(float(${a}Shape[2]) / 2.0));\n      int texelsInBatch = valuesPerRow * int(ceil(float(${a}Shape[1]) / 2.0));\n      vec2 uv = packedUVfrom3D(\n        packedTexShape[0], packedTexShape[1], texelsInBatch, valuesPerRow, b, row, col);\n      return ${s.texture2D}(${a}, uv);\n    }\n  `;const u=i[0],l=i[1],c=Math.ceil(t[2]/2),d=c*Math.ceil(t[1]/2);return`\n    vec4 ${r}(int b, int row, int col) {\n      vec2 uv = packedUVfrom3D(\n        ${u}, ${l}, ${d}, ${c}, b, row, col);\n      return ${s.texture2D}(${a}, uv);\n    }\n  `}(e,t);default:return function(e,n){const t=e.name,a="get"+t.charAt(0).toUpperCase()+t.slice(1),r=oe();if(n)return`\n    vec4 ${a}(int b2, int b, int row, int col) {\n      int valuesPerRow = int(ceil(float(${t}Shape[3]) / 2.0));\n      int texelsInBatch = valuesPerRow * int(ceil(float(${t}Shape[2]) / 2.0));\n      int index = b * texelsInBatch + (row / 2) * valuesPerRow + (col / 2);\n      texelsInBatch *= ${t}Shape[1];\n      index = b2 * texelsInBatch + index;\n      ivec2 packedTexShape = ivec2(ceil(float(${t}TexShape[0]) / 2.0), ceil(float(${t}TexShape[1]) / 2.0));\n      int texR = index / packedTexShape[1];\n      int texC = index - texR * packedTexShape[1];\n      vec2 uv = (vec2(texC, texR) + halfCR) / vec2(packedTexShape[1], packedTexShape[0]); return ${r.texture2D}(${t}, uv);\n    }\n  `;const o=e.shapeInfo.logicalShape,i=o.length,s=e.shapeInfo.texShape,u=[Math.ceil(s[0]/2),Math.ceil(s[1]/2)],l=u[0],c=u[1],d=Math.ceil(o[i-1]/2);let p=d*Math.ceil(o[i-2]/2),h="int b, int row, int col",f=`b * ${p} + (row / 2) * ${d} + (col / 2)`;for(let e=2;e<i-1;e++)h=`int b${e}, `+h,p*=o[i-e-1],f=`b${e} * ${p} + `+f;return`\n    vec4 ${a}(${h}) {\n      int index = ${f};\n      int texR = index / ${c};\n      int texC = index - texR * ${c};\n      vec2 uv = (vec2(texC, texR) + halfCR) / vec2(${c}, ${l});\n      return ${r.texture2D}(${t}, uv);\n    }\n  `}(e,t)}}const xe="\nvec2 uvFromFlat(int texNumR, int texNumC, int index) {\n  int texR = index / texNumC;\n  int texC = index - texR * texNumC;\n  return (vec2(texC, texR) + halfCR) / vec2(texNumC, texNumR);\n}\nvec2 packedUVfrom1D(int texNumR, int texNumC, int index) {\n  int texelIndex = index / 2;\n  int texR = texelIndex / texNumC;\n  int texC = texelIndex - texR * texNumC;\n  return (vec2(texC, texR) + halfCR) / vec2(texNumC, texNumR);\n}\n",me="\nvec2 packedUVfrom2D(int texelsInLogicalRow, int texNumR,\n  int texNumC, int row, int col) {\n  int texelIndex = (row / 2) * texelsInLogicalRow + (col / 2);\n  int texR = texelIndex / texNumC;\n  int texC = texelIndex - texR * texNumC;\n  return (vec2(texC, texR) + halfCR) / vec2(texNumC, texNumR);\n}\n",ge="\nvec2 packedUVfrom3D(int texNumR, int texNumC,\n    int texelsInBatch, int texelsInLogicalRow, int b,\n    int row, int col) {\n  int index = b * texelsInBatch + (row / 2) * texelsInLogicalRow + (col / 2);\n  int texR = index / texNumC;\n  int texC = index - texR * texNumC;\n  return (vec2(texC, texR) + halfCR) / vec2(texNumC, texNumR);\n}\n",be="\n  float getChannel(vec4 frag, vec2 innerDims) {\n    vec2 modCoord = mod(innerDims, 2.);\n    return modCoord.x == 0. ?\n      (modCoord.y == 0. ? frag.r : frag.g) :\n      (modCoord.y == 0. ? frag.b : frag.a);\n  }\n  float getChannel(vec4 frag, int dim) {\n    float modCoord = mod(float(dim), 2.);\n    return modCoord == 0. ? frag.r : frag.g;\n  }\n";function ve(){return"\n    int getOutputCoords() {\n      return 0;\n    }\n  "}function Ce(e){return`offset${e}`}function $e(e){const t=e.name,a=n.util.sizeFromShape(e.shapeInfo.logicalShape);return a<2?`return ${t};`:`\n    for (int i = 0; i < ${a}; i++) {\n      if (i == index) {\n        return ${t}[i];\n      }\n    }\n  `}function Ie(e){if(e<=1)return"int";if(2===e)return"ivec2";if(3===e)return"ivec3";if(4===e)return"ivec4";if(5===e)return"ivec5";if(6===e)return"ivec6";throw Error(`GPU for rank ${e} is not yet supported`)}function ye(e,t,a){const{newShape:r,keptDims:o}=n.util.squeezeShape(t),i=t.length,s=e&&3===i&&1===t[0],u=s?t.slice(1):r,l=!e&&i>1&&!n.util.arraysEqual(t,a)&&r.length<i||s;return{useSqueezeShape:l,uniformShape:l?u:t,keptDims:o}}function ke(e,n){const t=JSON.parse(JSON.stringify(e));return t.shapeInfo.logicalShape=n,t}function we(e,n){return n.map((n=>e[n])).join(", ")}function Re(e,t){if(e.length!==t.length)throw Error(`Binary was compiled with ${e.length} inputs, but was executed with ${t.length} inputs`);e.forEach(((e,a)=>{const r=e.logicalShape,o=t[a],i=o.shape;if(!n.util.arraysEqual(r,i))throw Error(`Binary was compiled with different shapes than the current args. Shapes ${r} and ${i} must match`);if(e.isUniform&&o.isUniform)return;const s=e.texShape,u=o.isUniform?null:o.texData.texShape;if(!n.util.arraysEqual(s,u))throw Error(`Binary was compiled with different texture shapes than the current args. Shape ${s} and ${u} must match`)}))}function Se(e){return n.env().getBool("WEBGL_USE_SHAPES_UNIFORMS")&&e<=4}class Te{constructor(e){this.variableNames=["A"],this.packedInputs=!1,this.packedOutput=!0,this.outPackingScheme=i.DENSE,this.customUniforms=[{name:"texShape",type:"ivec2"}];const n=oe();this.outputShape=e,this.enableShapeUniforms=Se(this.outputShape.length),this.userCode=`\n      ivec3 outCoordsFromFlatIndex(int index) {\n        ${this.enableShapeUniforms?se(["r","c","d"],e):ie(["r","c","d"],e)}\n        return ivec3(r, c, d);\n      }\n\n      void main() {\n        ivec2 resTexRC = ivec2(resultUV.yx * vec2(texShape[0], texShape[1]));\n        int index = 4 * (resTexRC.x * texShape[1] + resTexRC.y);\n\n        vec4 result = vec4(0.);\n\n        for (int i=0; i<4; i++) {\n          int flatIndex = index + i;\n          ivec3 rc = outCoordsFromFlatIndex(flatIndex);\n          result[i] = getA(rc.x, rc.y, rc.z);\n        }\n\n        ${n.output} = result;\n      }\n    `}}class Ee{constructor(e){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.outPackingScheme=i.DENSE,this.customUniforms=[{name:"texShape",type:"ivec2"}];const n=oe();this.outputShape=e,this.enableShapeUniforms=Se(this.outputShape.length),this.userCode=`\n      ivec3 outCoordsFromFlatIndex(int index) {\n        ${this.enableShapeUniforms?se(["r","c","d"],e):ie(["r","c","d"],e)}\n        return ivec3(r, c, d);\n      }\n\n      void main() {\n        ivec2 resTexRC = ivec2(resultUV.yx * vec2(texShape[0], texShape[1]));\n        int index = 4 * (resTexRC.x * texShape[1] + resTexRC.y);\n\n        vec4 result = vec4(0.);\n\n        for (int i=0; i<4; i++) {\n          int flatIndex = index + i;\n          ivec3 rc = outCoordsFromFlatIndex(flatIndex);\n          result[i] = getChannel(getA(rc.x, rc.y, rc.z), vec2(rc.y, rc.z));\n        }\n\n        ${n.output} = result;\n      }\n    `}}class Ne{constructor(e){this.variableNames=["A"],this.outTexUsage=s.DOWNLOAD;const n=oe();this.outputShape=e,this.userCode=`\n      ${ce}\n\n      void main() {\n        float x = getAAtOutCoords();\n        ${n.output} = encode_float(x);\n      }\n    `}}class Ae{constructor(e){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!1,this.outTexUsage=s.DOWNLOAD;const n=oe();this.outputShape=e,this.userCode=`\n      ${ce}\n\n      void main() {\n        ivec3 coords = getOutputCoords();\n        float x = getChannel(getAAtOutCoords(), vec2(coords.y, coords.z));\n        ${n.output} = encode_float(x);\n      }\n    `}}class Fe{constructor(e,n=!1){this.variableNames=["A"],this.customUniforms=[{name:"texShape",type:"ivec2"}];const t=oe();this.outputShape=e,this.enableShapeUniforms=Se(this.outputShape.length);let a="result";n&&(a="floor(result * 255. + 0.5)"),this.userCode=`\n      ${this.enableShapeUniforms?"\n  int getFlatIndex(ivec3 coords) {\n    return coords.x * outShapeStrides[0] + coords.y * outShapeStrides[1] + coords.z;\n  }\n":le(e)}\n\n      void main() {\n        ivec3 coords = getOutputCoords();\n\n        int flatIndex = getFlatIndex(coords);\n        int offset = imod(flatIndex, 4);\n\n        flatIndex = idiv(flatIndex, 4, 1.);\n\n        int r = flatIndex / texShape[1];\n        int c = imod(flatIndex, texShape[1]);\n        vec2 uv = (vec2(c, r) + halfCR) / vec2(texShape[1], texShape[0]);\n        vec4 values = ${t.texture2D}(A, uv);\n\n        float result;\n\n        if(offset == 0) {\n          result = values[0];\n        } else if(offset == 1) {\n          result = values[1];\n        } else if(offset == 2) {\n          result = values[2];\n        } else {\n          result = values[3];\n        }\n\n        ${t.output} = vec4(${a}, 0., 0., 0.);\n      }\n    `}}class _e{constructor(e,n=!1){this.variableNames=["A"],this.packedInputs=!1,this.packedOutput=!0,this.customUniforms=[{name:"texShape",type:"ivec2"}];const t=oe();this.outputShape=e,this.enableShapeUniforms=Se(this.outputShape.length);let a="",r="result";n&&(r="floor(result * 255. + 0.5)");for(let n=0;n<=1;n++)for(let r=0;r<=1;r++){const o=2*n+r;a+=`\n          localCoords = coords;\n          if(localCoords[2] + ${r} < ${this.enableShapeUniforms?"outShape[2]":`${e[2]}`}) {\n          localCoords[2] += ${r};\n          if (localCoords[1] + ${n} < ${this.enableShapeUniforms?"outShape[1]":`${e[1]}`}) {\n            localCoords[1] += ${n};\n\n            flatIndex = getFlatIndex(localCoords);\n            offset = imod(flatIndex, 4);\n\n            flatIndex = idiv(flatIndex, 4, 1.);\n\n            int r = flatIndex / texShape[1];\n            int c = imod(flatIndex, texShape[1]);\n            vec2 uv = (vec2(c, r) + halfCR) / vec2(texShape[1], texShape[0]);\n            values = ${t.texture2D}(A, uv);\n\n            if (offset == 0) {\n              result[${o}] = values[0];\n            } else if (offset == 1) {\n              result[${o}] = values[1];\n            } else if (offset == 2) {\n              result[${o}] = values[2];\n            } else {\n              result[${o}] = values[3];\n            }\n          }\n        }\n        `}this.userCode=`\n        ${this.enableShapeUniforms?"\n  int getFlatIndex(ivec3 coords) {\n    return coords.x * outShapeStrides[0] + coords.y * outShapeStrides[1] + coords.z;\n  }\n":le(e)}\n\n        void main() {\n          ivec3 coords = getOutputCoords();\n\n          vec4 result = vec4(0.);\n          int flatIndex, r, c, offset;\n          ivec3 localCoords;\n          vec2 uv;\n          vec4 values;\n\n          ${a}\n\n          ${t.output} = ${r};\n        }\n    `}}function Oe(e){const n=oe();return g(e,`${n.version}\n    precision highp float;\n    ${n.attribute} vec3 clipSpacePos;\n    ${n.attribute} vec2 uv;\n    ${n.varyingVs} vec2 resultUV;\n\n    void main() {\n      gl_Position = vec4(clipSpacePos, 1);\n      resultUV = uv;\n    }`)}function De(e){return y(e,new Float32Array([-1,1,0,0,1,-1,-1,0,0,0,1,1,0,1,1,1,-1,0,1,0]))}function Pe(e){return k(e,new Uint16Array([0,1,2,2,1,3]))}function Le(e,n,t,a,r,o){R(n,t);const i=w(e),s=e.TEXTURE_2D;return h(e,(()=>e.bindTexture(s,i))),h(e,(()=>e.texParameteri(s,e.TEXTURE_WRAP_S,e.CLAMP_TO_EDGE))),h(e,(()=>e.texParameteri(s,e.TEXTURE_WRAP_T,e.CLAMP_TO_EDGE))),h(e,(()=>e.texParameteri(s,e.TEXTURE_MIN_FILTER,e.NEAREST))),h(e,(()=>e.texParameteri(s,e.TEXTURE_MAG_FILTER,e.NEAREST))),h(e,(()=>e.texImage2D(s,0,a,n,t,0,r,o,null))),h(e,(()=>e.bindTexture(e.TEXTURE_2D,null))),i}function Be(e){return e.internalFormatFloat}function Ve(e,n,t,a){const[r,o]=l(n,t);return Le(e,r,o,Be(a),a.textureFormatFloat,e.FLOAT)}function We(e){return e.internalFormatHalfFloat}function Ue(e,n,t,a){const[r,o]=l(n,t);return Le(e,r,o,We(a),a.textureFormatFloat,a.textureTypeHalfFloat)}function Me(e){return e.downloadTextureFormat}function Ge(e,n,t,a){const[r,o]=l(n,t);return Le(e,r,o,Me(a),e.RGBA,e.UNSIGNED_BYTE)}function ze(e){return e.internalFormatPackedFloat}function Xe(e,n,t,a){const[r,o]=d(n,t);return Le(e,r,o,ze(a),e.RGBA,e.FLOAT)}function He(e){return e.internalFormatPackedHalfFloat}function je(e,n,t,a){const[r,o]=d(n,t);return Le(e,r,o,He(a),e.RGBA,a.textureTypeHalfFloat)}function Ke(e,n,t){h(e,(()=>e.bindBuffer(e.ARRAY_BUFFER,t)));return T(e,n,"clipSpacePos",t,3,20,0)&&T(e,n,"uv",t,2,20,12)}function qe(e,n,t,a,r,o){let i,s,u;h(e,(()=>e.bindTexture(e.TEXTURE_2D,n))),r instanceof Uint8Array?(i=new Uint8Array(t*a*4),s=e.UNSIGNED_BYTE,u=e.RGBA):(i=new Float32Array(t*a*4),s=e.FLOAT,u=o.internalFormatPackedFloat),i.set(r),h(e,(()=>e.texImage2D(e.TEXTURE_2D,0,u,t,a,0,e.RGBA,s,i))),h(e,(()=>e.bindTexture(e.TEXTURE_2D,null)))}function Ye(e,n,t){h(e,(()=>e.bindTexture(e.TEXTURE_2D,n))),t.data instanceof Uint8Array?h(e,(()=>e.texImage2D(e.TEXTURE_2D,0,e.RGBA,t.width,t.height,0,e.RGBA,e.UNSIGNED_BYTE,t.data))):h(e,(()=>e.texImage2D(e.TEXTURE_2D,0,e.RGBA,e.RGBA,e.UNSIGNED_BYTE,t))),h(e,(()=>e.bindTexture(e.TEXTURE_2D,null)))}function Qe(e,n,t,a){const r=e.createBuffer();h(e,(()=>e.bindBuffer(e.PIXEL_PACK_BUFFER,r)));const o=16*n*t;return h(e,(()=>e.bufferData(e.PIXEL_PACK_BUFFER,o,e.STREAM_READ))),h(e,(()=>e.readPixels(0,0,t,n,e.RGBA,e.FLOAT,0))),h(e,(()=>e.bindBuffer(e.PIXEL_PACK_BUFFER,null))),r}function Ze(e,n,t){const a=e,r=new Float32Array(t);return a.bindBuffer(a.PIXEL_PACK_BUFFER,n),a.getBufferSubData(a.PIXEL_PACK_BUFFER,0,r),a.bindBuffer(a.PIXEL_PACK_BUFFER,null),r}function Je(e,n,t,a){const[r,o]=l(n,t),i=new Uint8Array(n*t*4);return h(e,(()=>e.readPixels(0,0,r,o,a.downloadTextureFormat,e.UNSIGNED_BYTE,i))),new Float32Array(i.buffer)}function en(e,n,t,a,r,o,i,s){const u=e,l=new Float32Array(function(e,n){const[t,a]=d(e,n);return t*a*4}(o,i));return u.bindBuffer(u.PIXEL_PACK_BUFFER,n),u.getBufferSubData(u.PIXEL_PACK_BUFFER,0,l),u.bindBuffer(u.PIXEL_PACK_BUFFER,null),l}function nn(e,n,t){const a=new Float32Array(n*t*4);return h(e,(()=>e.readPixels(0,0,t,n,e.RGBA,e.FLOAT,a))),a}var tn=Object.freeze({__proto__:null,createVertexShader:Oe,createVertexBuffer:De,createIndexBuffer:Pe,getInternalFormatForFloat32MatrixTexture:Be,createFloat32MatrixTexture:Ve,getInternalFormatForFloat16MatrixTexture:We,createFloat16MatrixTexture:Ue,getInternalFormatForUnsignedBytesMatrixTexture:Me,createUnsignedBytesMatrixTexture:Ge,getInternalFormatForPackedMatrixTexture:ze,createPackedMatrixTexture:Xe,getInternalFormatForFloat16PackedMatrixTexture:He,createFloat16PackedMatrixTexture:je,bindVertexProgramAttributeStreams:Ke,uploadDenseMatrixToTexture:qe,uploadPixelDataToTexture:Ye,createBufferFromOutputTexture:Qe,downloadFloat32MatrixFromBuffer:Ze,downloadByteEncodedFloatMatrixFromOutputTexture:Je,downloadPackedMatrixFromBuffer:en,downloadMatrixFromPackedOutputTexture:nn});class an{constructor(e){this.outputTexture=null,this.program=null,this.disposed=!1,this.vertexAttrsAreBound=!1,this.itemsToPoll=[];const t=n.env().getNumber("WEBGL_VERSION");null!=e?(this.gl=e,r(t,e)):this.gl=o(t);let a="WEBGL_color_buffer_float";const i="EXT_color_buffer_half_float";if(1===n.env().getNumber("WEBGL_VERSION")){const e="OES_texture_float",t="OES_texture_half_float";if(this.textureFloatExtension=m(this.gl,e),Y(this.gl,t))this.textureHalfFloatExtension=m(this.gl,t);else if(n.env().get("WEBGL_FORCE_F16_TEXTURES"))throw new Error("GL context does not support half float textures, yet the environment flag WEBGL_FORCE_F16_TEXTURES is set to true.");if(this.colorBufferFloatExtension=this.gl.getExtension(a),Y(this.gl,i))this.colorBufferHalfFloatExtension=m(this.gl,i);else if(n.env().get("WEBGL_FORCE_F16_TEXTURES"))throw new Error("GL context does not support color renderable half floats, yet the environment flag WEBGL_FORCE_F16_TEXTURES is set to true.")}else if(a="EXT_color_buffer_float",Y(this.gl,a))this.colorBufferFloatExtension=this.gl.getExtension(a);else{if(!Y(this.gl,i))throw new Error("GL context does not support color renderable floats");this.colorBufferHalfFloatExtension=this.gl.getExtension(i)}this.vertexBuffer=De(this.gl),this.indexBuffer=Pe(this.gl),this.framebuffer=S(this.gl),this.textureConfig=p(this.gl,this.textureHalfFloatExtension)}get debug(){return n.env().getBool("DEBUG")}dispose(){if(this.disposed)return;null!=this.program&&console.warn("Disposing a GPGPUContext that still has a bound WebGLProgram. This is probably a resource leak, delete the program with GPGPUContext.deleteProgram before disposing."),null!=this.outputTexture&&console.warn("Disposing a GPGPUContext that still has a bound output matrix texture.  This is probably a resource leak, delete the output matrix texture with GPGPUContext.deleteMatrixTexture before disposing.");const e=this.gl;h(e,(()=>e.finish())),h(e,(()=>e.bindFramebuffer(e.FRAMEBUFFER,null))),h(e,(()=>e.deleteFramebuffer(this.framebuffer))),h(e,(()=>e.bindBuffer(e.ARRAY_BUFFER,null))),h(e,(()=>e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,null))),h(e,(()=>e.deleteBuffer(this.indexBuffer))),this.disposed=!0}createFloat32MatrixTexture(e,n){return this.throwIfDisposed(),Ve(this.gl,e,n,this.textureConfig)}createFloat16MatrixTexture(e,n){return this.throwIfDisposed(),Ue(this.gl,e,n,this.textureConfig)}createUnsignedBytesMatrixTexture(e,n){return this.throwIfDisposed(),Ge(this.gl,e,n,this.textureConfig)}uploadPixelDataToTexture(e,n){this.throwIfDisposed(),Ye(this.gl,e,n)}uploadDenseMatrixToTexture(e,n,t,a){this.throwIfDisposed(),qe(this.gl,e,n,t,a,this.textureConfig)}createFloat16PackedMatrixTexture(e,n){return this.throwIfDisposed(),je(this.gl,e,n,this.textureConfig)}createPackedMatrixTexture(e,n){return this.throwIfDisposed(),Xe(this.gl,e,n,this.textureConfig)}deleteMatrixTexture(e){this.throwIfDisposed(),this.outputTexture===e&&(O(this.gl,this.framebuffer),this.outputTexture=null),h(this.gl,(()=>this.gl.deleteTexture(e)))}downloadByteEncodedFloatMatrixFromOutputTexture(e,n,t){return this.downloadMatrixDriver(e,(()=>Je(this.gl,n,t,this.textureConfig)))}downloadPackedMatrixFromBuffer(e,n,t,a,r,o){return en(this.gl,e,0,0,0,r,o,this.textureConfig)}downloadFloat32MatrixFromBuffer(e,n){return Ze(this.gl,e,n)}createBufferFromTexture(e,n,t){this.bindTextureToFrameBuffer(e);const a=Qe(this.gl,n,t,this.textureConfig);return this.unbindTextureToFrameBuffer(),a}createAndWaitForFence(){const e=this.createFence(this.gl);return this.pollFence(e)}createFence(e){let t,a;if(n.env().getBool("WEBGL_FENCE_API_ENABLED")){const n=e,r=n.fenceSync(n.SYNC_GPU_COMMANDS_COMPLETE,0);e.flush(),a=()=>{const e=n.clientWaitSync(r,0,0);return e===n.ALREADY_SIGNALED||e===n.CONDITION_SATISFIED},t=r}else n.env().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION")>0?(t=this.beginQuery(),this.endQuery(),a=()=>this.isQueryAvailable(t,n.env().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION"))):a=()=>!0;return{query:t,isFencePassed:a}}downloadMatrixFromPackedTexture(e,n,t){return this.downloadMatrixDriver(e,(()=>nn(this.gl,n,t)))}createProgram(e){this.throwIfDisposed();const n=this.gl,t=b(n,e);null==this.vertexShader&&(this.vertexShader=Oe(n));const a=C(n);return h(n,(()=>n.attachShader(a,this.vertexShader))),h(n,(()=>n.attachShader(a,t))),$(n,a),this.debug&&I(n,a),this.vertexAttrsAreBound||(this.setProgram(a),this.vertexAttrsAreBound=Ke(n,this.program,this.vertexBuffer)),a}deleteProgram(e){this.throwIfDisposed(),e===this.program&&(this.program=null),null!=e&&h(this.gl,(()=>this.gl.deleteProgram(e)))}setProgram(e){this.throwIfDisposed(),this.program=e,null!=this.program&&this.debug&&I(this.gl,this.program),h(this.gl,(()=>this.gl.useProgram(e)))}getUniformLocation(e,n,t=!0){return this.throwIfDisposed(),t?N(this.gl,e,n):A(this.gl,e,n)}getAttributeLocation(e,n){return this.throwIfDisposed(),h(this.gl,(()=>this.gl.getAttribLocation(e,n)))}getUniformLocationNoThrow(e,n){return this.throwIfDisposed(),this.gl.getUniformLocation(e,n)}setInputMatrixTexture(e,n,t){this.throwIfDisposed(),this.throwIfNoProgram(),F(this.gl,e,n,t)}setOutputMatrixTexture(e,n,t){this.setOutputMatrixTextureDriver(e,t,n)}setOutputPackedMatrixTexture(e,n,t){this.throwIfDisposed();const[a,r]=d(n,t);this.setOutputMatrixTextureDriver(e,a,r)}setOutputMatrixWriteRegion(e,n,t,a){this.setOutputMatrixWriteRegionDriver(t,e,a,n)}setOutputPackedMatrixWriteRegion(e,n,t,a){throw new Error("setOutputPackedMatrixWriteRegion not implemented.")}debugValidate(){null!=this.program&&I(this.gl,this.program),D(this.gl)}executeProgram(){this.throwIfDisposed(),this.throwIfNoProgram();const e=this.gl;this.debug&&this.debugValidate(),h(e,(()=>e.drawElements(e.TRIANGLES,6,e.UNSIGNED_SHORT,0)))}blockUntilAllProgramsCompleted(){this.throwIfDisposed(),h(this.gl,(()=>this.gl.finish()))}getQueryTimerExtension(){return null==this.disjointQueryTimerExtension&&(this.disjointQueryTimerExtension=m(this.gl,2===n.env().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION")?"EXT_disjoint_timer_query_webgl2":"EXT_disjoint_timer_query")),this.disjointQueryTimerExtension}getQueryTimerExtensionWebGL2(){return this.getQueryTimerExtension()}getQueryTimerExtensionWebGL1(){return this.getQueryTimerExtension()}beginQuery(){if(2===n.env().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION")){const e=this.gl,n=this.getQueryTimerExtensionWebGL2(),t=e.createQuery();return e.beginQuery(n.TIME_ELAPSED_EXT,t),t}const e=this.getQueryTimerExtensionWebGL1(),t=e.createQueryEXT();return e.beginQueryEXT(e.TIME_ELAPSED_EXT,t),t}endQuery(){if(2===n.env().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION")){const e=this.gl,n=this.getQueryTimerExtensionWebGL2();return void e.endQuery(n.TIME_ELAPSED_EXT)}const e=this.getQueryTimerExtensionWebGL1();e.endQueryEXT(e.TIME_ELAPSED_EXT)}async waitForQueryAndGetTime(e){return await n.util.repeatedTry((()=>this.disposed||this.isQueryAvailable(e,n.env().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION")))),this.getQueryTime(e,n.env().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION"))}getQueryTime(e,n){if(0===n)return null;if(2===n){const n=this.gl;return n.getQueryParameter(e,n.QUERY_RESULT)/1e6}{const n=this.getQueryTimerExtensionWebGL1();return n.getQueryObjectEXT(e,n.QUERY_RESULT_EXT)/1e6}}isQueryAvailable(e,n){if(0===n)return!0;if(2===n){const n=this.gl,t=this.getQueryTimerExtensionWebGL2(),a=n.getQueryParameter(e,n.QUERY_RESULT_AVAILABLE);return null==this.disjoint&&(this.disjoint=this.gl.getParameter(t.GPU_DISJOINT_EXT)),a&&!this.disjoint}{const n=this.getQueryTimerExtensionWebGL1(),t=n.getQueryObjectEXT(e,n.QUERY_RESULT_AVAILABLE_EXT);return null==this.disjoint&&(this.disjoint=this.gl.getParameter(n.GPU_DISJOINT_EXT)),t&&!this.disjoint}}pollFence(e){return new Promise((n=>{this.addItemToPoll((()=>e.isFencePassed()),(()=>n()))}))}pollItems(){const e=function(e){let n=0;for(;n<e.length;++n){if(!e[n]())break}return n-1}(this.itemsToPoll.map((e=>e.isDoneFn)));for(let n=0;n<=e;++n){const{resolveFn:e}=this.itemsToPoll[n];e()}this.itemsToPoll=this.itemsToPoll.slice(e+1)}addItemToPoll(e,t){this.itemsToPoll.push({isDoneFn:e,resolveFn:t}),this.itemsToPoll.length>1||n.util.repeatedTry((()=>(this.pollItems(),0===this.itemsToPoll.length)))}bindTextureToFrameBuffer(e){this.throwIfDisposed(),_(this.gl,e,this.framebuffer),this.debug&&D(this.gl)}unbindTextureToFrameBuffer(){null!=this.outputTexture?(_(this.gl,this.outputTexture,this.framebuffer),this.debug&&D(this.gl)):O(this.gl,this.framebuffer)}downloadMatrixDriver(e,n){this.bindTextureToFrameBuffer(e);const t=n();return this.unbindTextureToFrameBuffer(),t}setOutputMatrixTextureDriver(e,n,t){this.throwIfDisposed();const a=this.gl;_(a,e,this.framebuffer),this.debug&&D(a),this.outputTexture=e,h(a,(()=>a.viewport(0,0,n,t))),h(a,(()=>a.scissor(0,0,n,t)))}setOutputMatrixWriteRegionDriver(e,n,t,a){this.throwIfDisposed(),h(this.gl,(()=>this.gl.scissor(e,n,t,a)))}throwIfDisposed(){if(this.disposed)throw new Error("Attempted to use disposed GPGPUContext.")}throwIfNoProgram(){if(null==this.program)throw new Error("No GPU program is currently set.")}}function rn(e){return(t,a,r,o,i)=>{const s=n.backend_util.assertAndGetBroadcastShape(t,a),u=s.length,l=n.util.computeStrides(s),c=n.util.sizeFromShape(s),d=n.util.getTypedArrayFromDType(i,c),p=t.length,h=a.length,f=n.util.computeStrides(t),x=n.util.computeStrides(a),m=n.backend_util.getBroadcastDims(t,s),g=n.backend_util.getBroadcastDims(a,s);if(m.length+g.length===0)for(let n=0;n<d.length;++n)d[n]=e(r[n%r.length],o[n%o.length]);else for(let t=0;t<d.length;++t){const a=n.util.indexToLoc(t,u,l),i=a.slice(-p);m.forEach((e=>i[e]=0));const s=n.util.locToIndex(i,p,f),c=a.slice(-h);g.forEach((e=>c[e]=0));const b=n.util.locToIndex(c,h,x);d[t]=e(r[s],o[b])}return[d,s]}}const on=rn(((e,n)=>e+n));function sn(e){return(t,a,r)=>{const o=n.util.getTypedArrayFromDType(a,t.length);for(let n=0;n<t.length;++n)o[n]=e(t[n],r);return o}}const un=sn((e=>Math.ceil(e)));const ln=rn(((e,n)=>e===n?1:0)),cn=sn((e=>Math.exp(e))),dn=sn((e=>Math.expm1(e))),pn=sn((e=>Math.floor(e)));const hn=rn(((e,n)=>e>n?1:0)),fn=rn(((e,n)=>e>=n?1:0)),xn=rn(((e,n)=>e<n?1:0)),mn=rn(((e,n)=>e<=n?1:0));const gn=sn((e=>Math.log(e)));const bn=rn(((e,n)=>Math.max(e,n))),vn=rn(((e,n)=>Math.min(e,n))),Cn=rn(((e,n)=>e*n));const $n=rn(((e,n)=>e!==n?1:0));const In=sn((e=>1/Math.sqrt(e))),yn=sn((e=>1/(1+Math.exp(-e))));const kn=sn((e=>Math.sqrt(e))),wn=rn(((e,n)=>{const t=e-n;return t*t}));class Rn{constructor(e,t,a,r,o,i){this.separator=n.util.encodeString(e),this.nGramWidths=t,this.leftPad=n.util.encodeString(a),this.rightPad=n.util.encodeString(r),this.padWidth=o,this.preserveShort=i}getPadWidth(e){return Math.min(this.padWidth<0?e-1:this.padWidth,e-1)}getNumNGrams(e,n){const t=this.getPadWidth(n);return Math.max(0,e+2*t-n+1)}createNGrams(e,n,t,a,r,o){for(let i=0;i<r;++i){const s=this.getPadWidth(o),u=Math.max(0,s-i),l=Math.max(0,s-(r-(i+1))),c=o-(u+l),d=n+(u>0?0:i-s);let p=0;p+=u*this.leftPad.length;for(let n=0;n<c;++n)p+=e[d+n].length;p+=l*this.rightPad.length;p+=(u+l+c-1)*this.separator.length,t[a+i]=new Uint8Array(p);const h=t[a+i];let f=0;const x=e=>e.forEach((e=>h[f++]=e));for(let e=0;e<u;++e)x(this.leftPad),x(this.separator);for(let n=0;n<c-1;++n)x(e[d+n]),x(this.separator);if(c>0){x(e[d+c-1]);for(let e=0;e<l;++e)x(this.separator),x(this.rightPad)}else{for(let e=0;e<l-1;++e)x(this.rightPad),x(this.separator);x(this.rightPad)}}}compute(e,t){const a=e.length,r=t.length;if(r>0){let e=t[0];if(0!==e)throw new Error(`First split value must be 0, got ${e}`);for(let n=1;n<r;++n){let r=t[n]>=e;if(r=r&&t[n]<=a,!r)throw new Error(`Invalid split value ${t[n]}, must be in [${e}, ${a}]`);e=t[n]}if(e!==a)throw new Error(`Last split value must be data size. Expected ${a}, got ${e}`)}const o=r-1,i=n.util.getArrayFromDType("int32",r);if(0===a||0===r){const e=new Array(a);for(let e=0;e<=o;++e)i[e]=0;return[e,i]}i[0]=0;for(let e=1;e<=o;++e){const n=t[e]-t[e-1];let a=0;this.nGramWidths.forEach((e=>{a+=this.getNumNGrams(n,e)})),this.preserveShort&&n>0&&0===a&&(a=1),i[e]=i[e-1]+a}const s=new Array(i[o]);for(let n=0;n<o;++n){const a=t[n];let r=i[n];if(this.nGramWidths.forEach((o=>{const i=t[n+1]-t[n],u=this.getNumNGrams(i,o);this.createNGrams(e,a,s,r,u,o),r+=u})),this.preserveShort&&r===i[n]){const o=t[n+1]-t[n];if(0===o)continue;const i=o+2*this.padWidth,u=1;this.createNGrams(e,a,s,r,u,i)}}return[s,i]}}function Sn(e,n,t,a){if(!e.length)return;if(0===n.length){for(let n=0;n<e.length;++n)a.push(e.subarray(n,n+1));return}if(1===n.length){const r=n[0];let o=e.indexOf(r);for(;-1!==o;){const n=e.subarray(0,o);t&&0===n.length||a.push(n),o=(e=e.subarray(o+1)).indexOf(r)}return void(t&&0===e.length||a.push(e))}let r=0;for(let o=0;o<e.length+1;o++)if(o===e.length||-1!==n.indexOf(e[o])){const n=e.subarray(r,o);t&&0===n.length||a.push(n),r=o+1}}const Tn=rn(((e,n)=>e-n));const En=(e,n)=>{const t=n.value-e.value;return 0===t?e.index-n.index:t};function Nn(e,t,a=0,r=e.length-1){for(;r>a;){if(r-a>600){const n=r-a+1,o=t-a+1,i=Math.log(n),s=.5*Math.exp(2*i/3),u=.5*Math.sqrt(i*s*(n-s)/n)*Math.sign(o-n/2);Nn(e,t,Math.max(a,Math.floor(t-o*s/n+u)),Math.min(r,Math.floor(t+(n-o)*s/n+u)))}const o=e[t];let i=a,s=r;for(n.util.swap(e,a,t),En(e[r],o)>0&&n.util.swap(e,a,r);i<s;){for(n.util.swap(e,i,s),i++,s--;En(e[i],o)<0;)i+=1;for(;En(e[s],o)>0;)s-=1}0===En(e[a],o)?n.util.swap(e,a,s):(s+=1,n.util.swap(e,s,r)),s<=t&&(a=s+1),t<=s&&(r=s-1)}}var An=Object.freeze({__proto__:null,simpleAbsImpl:function(e){const n=new Float32Array(e.length);for(let t=0;t<e.length;++t)n[t]=Math.abs(e[t]);return n},addImpl:on,bincountImpl:function(e,t,a,r,o){const i=n.util.sizeFromShape(r),s=n.util.makeZerosTypedArray(o,a);for(let n=0;n<e.length;n++){const a=e[n];if(a<0)throw new Error("Input x must be non-negative!");a>=o||(s[a]+=i>0?t[n]:1)}return s},bincountReduceImpl:function(e,t,a,r=!1){const o=e.shape[0],i=e.shape[1],s=n.buffer([o,a],t.dtype);for(let n=0;n<o;n++)for(let o=0;o<i;o++){const i=e.get(n,o);if(i<0)throw new Error("Input x must be non-negative!");i>=a||(r?s.set(1,n,i):t.size>0?s.set(s.get(n,i)+t.get(n,o),n,i):s.set(s.get(n,i)+1,n,i))}return s},ceilImpl:un,concatImpl:function(e,t,a,r){const o=n.util.getArrayFromDType(a,n.util.sizeFromShape(t));if(r&&"string"!==a){let t=0;e.forEach((e=>{const a=n.util.sizeFromShape(e.shape);o.set(e.vals,t),t+=a}))}else{let r=0;e.forEach((e=>{const i="string"===a?n.backend_util.fromUint8ToStringArray(e.vals):e.vals;let s=0;for(let n=0;n<e.shape[0];++n){const a=n*t[1]+r;for(let n=0;n<e.shape[1];++n)o[a+n]=i[s++]}r+=e.shape[1]}))}return o},equalImpl:ln,expImpl:cn,expm1Impl:dn,floorImpl:pn,gatherNdImpl:function(e,t,a,r,o,i,s,u,l){const c=n.buffer([r,i],a);for(let n=0;n<r;n++){const a=[];let r=0;for(let t=0;t<o;t++){const i=e[n*o+t];r+=i*s[t],a.push(i)}if(r<0||r>=l/i)throw new Error(`Invalid indices: ${a} does not index into ${u}`);for(let e=0;e<i;e++)c.values[n*i+e]=t.get(...t.indexToLoc(r*i+e))}return c},gatherV2Impl:function(e,t,a){const r=n.buffer(a,e.dtype);for(let n=0;n<r.size;++n){const a=r.indexToLoc(n).slice(),o=a[0],i=a[2],s=t.locToIndex([o,i]);a[2]=t.values[s];const u=e.locToIndex(a);r.values[n]=e.values[u]}return r},greaterImpl:hn,greaterEqualImpl:fn,lessImpl:xn,lessEqualImpl:mn,linSpaceImpl:function(e,t,a){const r=(t-e)/(a-1),o=n.util.makeZerosTypedArray(a,"float32");o[0]=e;for(let e=1;e<o.length;e++)o[e]=o[e-1]+r;return o},logImpl:gn,maxImpl:function(e,t,a,r){const o=n.util.getTypedArrayFromDType(r,n.util.sizeFromShape(a));for(let n=0;n<o.length;++n){const a=n*t;let r=e[a];for(let n=0;n<t;++n){const t=e[a+n];(Number.isNaN(t)||t>r)&&(r=t)}o[n]=r}return o},maximumImpl:bn,minimumImpl:vn,multiplyImpl:Cn,negImpl:function(e,t,a){const r=n.util.createScalarValue(-1,a);return Cn([],t,r,e,a)},notEqualImpl:$n,prodImpl:function(e,t,a,r){const[o,i]=n.backend_util.computeOutAndReduceShapes(e,r),s=n.upcastType(t,"int32"),u=n.util.makeZerosTypedArray(n.util.sizeFromShape(o),s),l=n.util.sizeFromShape(i);for(let e=0;e<u.length;++e){const n=e*l;let t=1;for(let e=0;e<l;++e)t*=a[n+e];u[e]=t}return{outVals:u,outShape:o,outDtype:s}},rangeImpl:function(e,t,a,r){if(e===t||e<t&&a<0||t<e&&a>1)return n.util.makeZerosTypedArray(0,r);const o=Math.abs(Math.ceil((t-e)/a)),i=n.util.makeZerosTypedArray(o,r);t<e&&1===a&&(a=-1),i[0]=e;for(let e=1;e<i.length;e++)i[e]=i[e-1]+a;return i},rsqrtImpl:In,sigmoidImpl:yn,sliceImpl:function(e,t,a,r,o){const i=n.slice_util.isSliceContinous(r,t,a),s=n.util.sizeFromShape(a),u=n.util.computeStrides(r);if(i){const a=n.slice_util.computeFlatOffset(t,u);return"string"===o?e.slice(a,a+s):e.subarray(a,a+s)}const l="string"===o?n.backend_util.fromUint8ToStringArray(e):e,c=n.buffer(r,o,l),d=n.buffer(a,o);for(let e=0;e<d.size;++e){const n=d.indexToLoc(e),a=n.map(((e,n)=>e+t[n]));d.set(c.get(...a),...n)}return"string"===o?n.backend_util.fromStringArrayToUint8(d.values):d.values},sparseFillEmptyRowsImpl:function(e,t,a,r,o,i,s){const u=t[0],l=i[0],c=new Array(l),d=new Array(u),p=t[1];if(0===l){if(0!==u)throw new Error(`Received SparseTensor with denseShape[0] = 0 but\n         indices.shape[0] = ${u}`);return[n.util.getArrayFromDType(a,0),[0,p],n.util.getArrayFromDType(o,0),c,d]}let h=!0,f=0;const x=new Array(l).fill(0);for(let n=0;n<u;++n){const t=e[n*p];if(t<0)throw new Error(`indices(${n}, 0) is invalid: ${t} < 0`);if(t>=l)throw new Error(`indices(${n}, 0) is invalid: ${t} >= ${l}`);++x[t],h=h&&t>=f,f=t}let m=!0;for(let e=0;e<l;++e){const n=0===x[e];c[e]=n,m=m&&!n,x[e]=Math.max(x[e],1),e>0&&(x[e]+=x[e-1])}if(m&&h){const n=e,t=r;for(let e=0;e<u;++e)d[e]=e;return[n,[u,p],t,c,d]}{const t=x[l-1],i=n.util.getArrayFromDType(a,t*p),h=n.util.getArrayFromDType(o,t),f=new Array(l).fill(0);for(let n=0;n<u;++n){const t=e[n*p],a=f[t],o=(0===t?0:x[t-1])+a;f[t]++;for(let t=0;t<p;++t)i[o*p+t]=e[n*p+t];h[o]=r[n],d[n]=o}for(let e=0;e<l;++e){if(0===f[e]){const n=0===e?0:x[e-1];i[n*p+0]=e;for(let e=1;e<p;++e)i[n*p+e]=0;h[n]=s}}return[i,[t,p],h,c,d]}},sparseReshapeImpl:function(e,t,a,r,o){const i=n.util.sizeFromShape(r),s=t[0],u=o.length,l=[];let c=1,d=-1;for(let e=0;e<u;++e){const n=o[e];if(-1===n){if(-1!==d)throw new Error(`only one output dimension may be -1, not both ${d} and ${e}`);d=e,l.push(1)}else{if(n<0)throw new Error(`size ${e} must be non-negative, not ${n}`);c*=n,l.push(n)}}if(-1!==d){if(c<=0)throw new Error("reshape cannot infer the missing input size for an empty tensor unless all specified input sizes are non-zero");const e=Math.trunc(i/c);if(c*e!==i)throw new Error(`Input to reshape is a SparseTensor with ${i}\n          dense values, but the requested shape requires a multiple of ${c}. inputShape=${r} outputShape= ${l}`);l[d]=e}const p=n.util.sizeFromShape(l);if(p!==i)throw new Error(`Input to reshape is a tensor with ${i} dense values, but the requested shape has ${p}. inputShape=${r} outputShape=${l}`);const h=r.length,f=[];if(h>0){f[h-1]=1;for(let e=h-2;e>=0;--e)f[e]=f[e+1]*r[e+1]}const x=[];if(u>0){x[u-1]=1;for(let e=u-2;e>=0;--e)x[e]=x[e+1]*l[e+1]}const m=n.util.getArrayFromDType(a,s*u);for(let n=0;n<s;++n){let t=0;for(let a=0;a<h;++a)t+=e[n*h+a]*f[a];for(let e=0;e<u;++e)m[n*u+e]=Math.trunc(t/x[e]),t%=x[e]}return[m,[s,u],l]},sparseSegmentReductionImpl:function(e,t,a,r,o,i=!1,s=0){const u=r.length;if(u!==o.length)throw new Error("segmentIds and indices should have same size.");const l=[t[0],e.length/t[0]],c=l[1],d=u>0?o[u-1]+1:0;if(d<0)throw new Error("segment ids must be >= 0");const p=t.slice();p[0]=d;const h=p.reduce(((e,n)=>e*n),1),f=n.util.getArrayFromDType(a,h);if(0===u)return d>0&&f.fill(s),[f,p];if(d<=0)throw new Error("segment ids must be >= 0");let x=0,m=1,g=0,b=o[x];for(;;){let n=0;if(m<u){if(n=o[m],b===n){++m;continue}if(b>=n)throw new Error("segment ids are not increasing")}if(b<0||b>=d)throw new Error(`Segment id ${b} out of range [0, ${d}), possibly because segmentIds input is not sorted.`);b>g&&f.fill(s,g*c,b*c);for(let n=x;n<m;++n){const t=r[n];if(t<0||t>=l[0])throw new Error(`Bad: indices[${n}] == ${r[n]} out of range [0, ${l[0]})`);for(let n=0;n<c;n++)f[b*c+n]+=e[t*c+n]}if(i)for(let e=0;e<c;e++)f[b*c+e]/=m-x;if(x=m,++m,g=b+1,b=n,m>u)break}return g<d&&f.fill(s,g*c,d*c),[f,p]},sqrtImpl:kn,squaredDifferenceImpl:wn,stridedSliceImpl:function(e,t,a,r){const o=n.buffer(e,t.dtype);for(let e=0;e<o.size;e++){const n=o.indexToLoc(e),i=new Array(n.length);for(let e=0;e<i.length;e++)i[e]=n[e]*a[e]+r[e];o.set(t.get(...i),...n)}return o},stringNGramsImpl:function(e,n,t,a,r,o,i,s){return new Rn(t,a,r,o,i,s).compute(e,n)},stringSplitImpl:function(e,t,a){const r=e.length,o=[];let i=0,s=0;const u=new Array(r);for(let n=0;n<r;++n){const r=o.length;Sn(e[n],t,a,o);const l=o.length-r;u[n]=l,i+=l,s=Math.max(s,l)}const l=n.util.getArrayFromDType("int32",2*i),c=new Array(i),d=[r,s];let p=0;for(let e=0;e<r;++e)for(let n=0;n<u[e];++n)l[2*p]=e,l[2*p+1]=n,c[p]=o[p],++p;return[l,c,d]},stringToHashBucketFastImpl:function(e,t){const a=n.util.getArrayFromDType("int32",e.length);for(let r=0;r<e.length;++r)a[r]=n.util.fingerPrint64(e[r]).modulo(t).getLowBitsUnsigned();return a},subImpl:Tn,tileImpl:function(e,t){const a=new Array(e.rank);for(let n=0;n<a.length;n++)a[n]=e.shape[n]*t[n];const r=n.buffer(a,e.dtype);for(let n=0;n<r.values.length;++n){const t=r.indexToLoc(n),a=new Array(e.rank);for(let n=0;n<a.length;n++)a[n]=t[n]%e.shape[n];const o=e.locToIndex(a);r.values[n]=e.values[o]}return r},topKImpl:function(e,t,a,r,o){const i=t[t.length-1],[s,u]=[e.length/i,i],l=n.util.getTypedArrayFromDType(a,s*r),c=n.util.getTypedArrayFromDType("int32",s*r);for(let n=0;n<s;n++){const t=n*u,a=e.subarray(t,t+u);let i=new Array(a.length);a.forEach(((e,n)=>i[n]={value:e,index:n})),r<i.length&&(Nn(i,r),i=i.slice(0,r)),o&&i.sort(En);const s=n*r,d=l.subarray(s,s+r),p=c.subarray(s,s+r);for(let e=0;e<r;e++)d[e]=i[e].value,p[e]=i[e].index}const d=t.slice();return d[d.length-1]=r,[n.buffer(d,a,l),n.buffer(d,"int32",c)]},transposeImpl:function(e,t,a,r,o){const i=t.length,s=n.util.sizeFromShape(t),u=n.util.computeStrides(t),l=n.util.computeStrides(o),c=n.util.getTypedArrayFromDType(a,n.util.sizeFromShape(o));for(let t=0;t<s;++t){const a=n.util.indexToLoc(t,i,u),o=new Array(a.length);for(let e=0;e<o.length;e++)o[e]=a[r[e]];c[n.util.locToIndex(o,i,l)]=e[t]}return c},uniqueImpl:function(e,t,a,r){const o=n.util.parseAxisParam(t,a)[0],i=[1,a[0],1];for(let e=0;e<o;e++)i[0]*=a[e];i[1]=a[o];for(let e=o+1;e<a.length;e++)i[2]*=a[e];const s={},u=new Int32Array(a[o]),l=new n.TensorBuffer(i,r,e),c=[],d=1===i[0]&&1===i[2];for(let n=0;n<a[o];n++){let t;if(d)t=e[n].toString();else{const e=[];for(let t=0;t<i[0];t++)for(let a=0;a<i[2];a++)e.push(l.get(t,n,a));t=e.join(",")}if(void 0!==s[t])u[n]=s[t];else{const e=Object.keys(s).length;s[t]=e,u[n]=e,c.push(n)}}const p=i.slice();p[1]=Object.keys(s).length;const h=new n.TensorBuffer(p,r);c.forEach(((e,n)=>{for(let t=0;t<i[0];t++)for(let a=0;a<i[2];a++)h.set(l.get(t,e,a),t,n,a)}));const f=a.slice();return f[o]=p[1],{outputValues:h.values,outputShape:f,indices:u}}});const{addImpl:Fn,bincountImpl:_n,bincountReduceImpl:On,ceilImpl:Dn,concatImpl:Pn,equalImpl:Ln,expImpl:Bn,expm1Impl:Vn,floorImpl:Wn,gatherNdImpl:Un,gatherV2Impl:Mn,greaterImpl:Gn,greaterEqualImpl:zn,lessImpl:Xn,lessEqualImpl:Hn,linSpaceImpl:jn,logImpl:Kn,maxImpl:qn,maximumImpl:Yn,minimumImpl:Qn,multiplyImpl:Zn,negImpl:Jn,notEqualImpl:et,prodImpl:nt,rangeImpl:tt,rsqrtImpl:at,sigmoidImpl:rt,simpleAbsImpl:ot,sliceImpl:it,sparseFillEmptyRowsImpl:st,sparseReshapeImpl:ut,sparseSegmentReductionImpl:lt,sqrtImpl:ct,stridedSliceImpl:dt,stringNGramsImpl:pt,stringSplitImpl:ht,stringToHashBucketFastImpl:ft,subImpl:xt,tileImpl:mt,topKImpl:gt,transposeImpl:bt,uniqueImpl:vt}=An;function Ct(e,n){return["x","y","z","w","u","v"].slice(0,n).map((n=>`${e}.${n}`))}function $t(e,n){return 1===n?[e]:Ct(e,n)}class It{constructor(e){this.variableNames=["A"],this.packedInputs=!1,this.packedOutput=!0,this.outputShape=e;const n=e.length;if(0===n)this.userCode="\n        void main() {\n          setOutput(vec4(getA(), 0., 0., 0.));\n        }\n      ";else{const t=$t("rc",n),a=Ie(n),r=function(e,n,t){if(1===e)return`rc > ${n[0]}`;let a="";for(let r=e-2;r<e;r++)a+=`${t[r]} >= ${n[r]}`,r<e-1&&(a+="||");return a}(n,e,t),o=function(e,n,t,a){if(1===e)return"";const r=a.slice(-2);return`\n    int r = ${r[0]};\n    int c = ${r[1]};\n    int rp1 = r + 1;\n    int cp1 = c + 1;\n\n    bool cEdge = cp1 >= ${n};\n    bool rEdge = rp1 >= ${t};\n  `}(n,e[e.length-1],e[e.length-2],t),i=function(e,n){const t=e.length,a=function(e,n){const t=[];for(let a=0;a<=1;a++)for(let r=0;r<=1;r++){let o=`${0===a?"r":"rp1"}, ${0===r?"c":"cp1"}`;for(let t=2;t<e;t++)o=`${n[n.length-1-t]},`+o;t.push(o)}return t}(t,n);if(1===t)return`getA(rc),\n            rc + 1 >= ${e[0]} ? 0. : getA(rc + 1),\n            0, 0`;return`getA(${a[0]}),\n          cEdge ? 0. : getA(${a[1]}),\n          rEdge ? 0. : getA(${a[2]}),\n          rEdge || cEdge ? 0. : getA(${a[3]})`}(e,t);this.userCode=`\n        void main() {\n          ${a} rc = getOutputCoords();\n\n          if(${r}) {\n            setOutput(vec4(0));\n          } else {\n            ${o}\n\n            setOutput(vec4(${i}));\n          }\n        }\n      `}}}class yt{constructor(e,n){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.customUniforms=[{name:"inputShape",type:"ivec3"}],this.outputShape=e,this.enableShapeUniforms=Se(this.outputShape.length);let t="";for(let e=0;e<4;e++){let n="thisRC = rc;";e%2==1&&(n+="thisRC.z += 1;"),e>1&&(n+="thisRC.y += 1;"),t+=`\n        ${n}\n        ${e>0?"if(thisRC.y < rows && thisRC.z < cols){":""}\n          int flatIndex = getFlatIndex(thisRC);\n\n          ivec3 inputRC = inputCoordsFromReshapedOutCoords(flatIndex);\n          vec2 inputRCInnerDims = vec2(float(inputRC.y),float(inputRC.z));\n\n          result[${e}] =\n            getChannel(getA(inputRC.x, inputRC.y, inputRC.z), inputRCInnerDims);\n        ${e>0?"}":""}\n      `}var a,r;this.userCode=`\n      ${a=n,r=this.enableShapeUniforms,`\n    ivec3 inputCoordsFromReshapedOutCoords(int index) {\n      ${r?ue(["r","c","d"],"inputShape"):ie(["r","c","d"],a)}\n      return ivec3(r, c, d);\n    }\n  `}\n      ${this.enableShapeUniforms?"\n  int getFlatIndex(ivec3 coords) {\n    return coords.x * outShapeStrides[0] + coords.y * outShapeStrides[1] + coords.z;\n  }\n":le(e)}\n\n      void main() {\n        ivec3 rc = getOutputCoords();\n\n        vec4 result = vec4(0.);\n\n        ivec3 thisRC;\n        int rows = ${this.enableShapeUniforms?"outShape[1]":e[1]};\n        int cols = ${this.enableShapeUniforms?"outShape[2]":e[2]};\n\n        ${t}\n\n        setOutput(result);\n      }\n    `}}class kt{constructor(e){this.gpgpu=e,this.numUsedTextures=0,this.numFreeTextures=0,this._numBytesAllocated=0,this._numBytesFree=0,this.freeTextures={},this.logEnabled=!1,this.usedTextures={}}acquireTexture(e,n,t){const a=Rt(n,t),r=St(e,a,t);r in this.freeTextures||(this.freeTextures[r]=[]),r in this.usedTextures||(this.usedTextures[r]=[]);const o=wt(e,a,this.gpgpu.gl,this.gpgpu.textureConfig,t);if(this.freeTextures[r].length>0){this.numFreeTextures--,this.numUsedTextures++,this._numBytesFree-=o,this.log();const e=this.freeTextures[r].shift();return this.usedTextures[r].push(e),e}let i;return a===u.PACKED_2X2_FLOAT32?i=this.gpgpu.createPackedMatrixTexture(e[0],e[1]):a===u.PACKED_2X2_FLOAT16?i=this.gpgpu.createFloat16PackedMatrixTexture(e[0],e[1]):a===u.UNPACKED_FLOAT32?i=this.gpgpu.createFloat32MatrixTexture(e[0],e[1]):a===u.UNPACKED_FLOAT16?i=this.gpgpu.createFloat16MatrixTexture(e[0],e[1]):a===u.PACKED_4X1_UNSIGNED_BYTE&&(i=this.gpgpu.createUnsignedBytesMatrixTexture(e[0],e[1])),this.usedTextures[r].push(i),this.numUsedTextures++,this._numBytesAllocated+=o,this.log(),i}releaseTexture(e,t,a,r){if(null==this.freeTextures)return;const o=Rt(a,r),i=St(t,o,r);i in this.freeTextures||(this.freeTextures[i]=[]);const s=wt(t,o,this.gpgpu.gl,this.gpgpu.textureConfig,r),u=n.env().get("WEBGL_DELETE_TEXTURE_THRESHOLD");-1!==u&&this._numBytesAllocated>u?(this.gpgpu.deleteMatrixTexture(e),this._numBytesAllocated-=s):(this.freeTextures[i].push(e),this.numFreeTextures++,this._numBytesFree+=s),this.numUsedTextures--;const l=this.usedTextures[i],c=l.indexOf(e);if(c<0)throw new Error("Cannot release a texture that was never provided by this texture manager");l.splice(c,1),this.log()}log(){if(!this.logEnabled)return;const e=this.numFreeTextures+this.numUsedTextures;console.log("Free/Used",`${this.numFreeTextures} / ${this.numUsedTextures}`,`(${e})`);const n=this._numBytesFree/this._numBytesAllocated;console.log(`Bytes allocated: ${this._numBytesAllocated}`),console.log(`Bytes unused: ${this._numBytesFree} (${Math.round(100*n)}%)`)}get numBytesAllocated(){return this._numBytesAllocated}get numBytesFree(){return this._numBytesFree}getNumUsedTextures(){return this.numUsedTextures}getNumFreeTextures(){return this.numFreeTextures}dispose(){if(null!=this.freeTextures){for(const e in this.freeTextures)this.freeTextures[e].forEach((e=>{this.gpgpu.deleteMatrixTexture(e)}));for(const e in this.usedTextures)this.usedTextures[e].forEach((e=>{this.gpgpu.deleteMatrixTexture(e)}));this.freeTextures=null,this.usedTextures=null,this.numUsedTextures=0,this.numFreeTextures=0,this._numBytesAllocated=0,this._numBytesFree=0}}}function wt(e,n,t,a,r){const o=function(e,n){switch(e){case u.PACKED_2X2_FLOAT32:return ze(n);case u.PACKED_2X2_FLOAT16:return He(n);case u.UNPACKED_FLOAT32:return Be(n);case u.UNPACKED_FLOAT16:return We(n);case u.PACKED_4X1_UNSIGNED_BYTE:return Me(n);default:throw new Error(`Unknown physical texture type ${e}`)}}(n,a);let i;if(r){const[n,t]=d(e[0],e[1]);i=n*t}else{const[n,t]=l(e[0],e[1]);i=n*t}return i*function(e,n){const t=e;if(n===t.R32F)return 4;if(n===t.R16F)return 2;if(n===t.RGBA32F)return 16;if(n===e.RGBA)return 16;if(n===t.RGBA16F)return 8;throw new Error(`Unknown internal format ${n}`)}(t,o)}function Rt(e,t){if(e===s.UPLOAD)return u.PACKED_2X2_FLOAT32;if(e===s.RENDER||null==e)return function(e){return n.env().getBool("WEBGL_RENDER_FLOAT32_ENABLED")?e?u.PACKED_2X2_FLOAT32:u.UNPACKED_FLOAT32:e?u.PACKED_2X2_FLOAT16:u.UNPACKED_FLOAT16}(t);if(e===s.DOWNLOAD||e===s.PIXELS)return u.PACKED_4X1_UNSIGNED_BYTE;throw new Error(`Unknown logical texture type ${e}`)}function St(e,n,t){return`${e[0]}_${e[1]}_${n}_${t}`}class Tt{constructor(e,n){this.variableNames=["A"],this.outputShape=e,this.enableShapeUniforms=Se(this.outputShape.length),this.userCode=`\n      float unaryOperation(float x) {\n        ${n}\n      }\n\n      void main() {\n        float x = getAAtOutCoords();\n        float y = unaryOperation(x);\n\n        setOutput(y);\n      }\n    `}}const Et="return abs(x);",Nt="return x;";class At{constructor(e,n){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=e,this.enableShapeUniforms=Se(this.outputShape.length),this.userCode=`\n      vec4 unaryOperation(vec4 x) {\n        ${n}\n      }\n\n      void main() {\n        vec4 x = getAAtOutCoords();\n        vec4 y = unaryOperation(x);\n\n        setOutput(y);\n      }\n    `}}class Ft{constructor(e){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!1,this.outputShape=e;const n=e.length,t=$t("rc",n),a=Ie(n),r=function(e,n){if(1===e)return"rc";let t="";for(let a=0;a<e;a++)t+=n[a],a<e-1&&(t+=",");return t}(n,t),o=t.slice(-2),i=n<=1?"rc":`vec2(${o.join(",")})`;this.userCode=`\n      void main() {\n        ${a} rc = getOutputCoords();\n        vec4 packedInput = getA(${r});\n\n        setOutput(getChannel(packedInput, ${i}));\n      }\n    `}}const _t=n.kernel_impls.whereImpl,Ot={};const Dt=n.env().getNumber("CPU_HANDOFF_SIZE_THRESHOLD");class Pt extends n.KernelBackend{constructor(e){if(super(),this.pendingRead=new WeakMap,this.pendingDisposal=new WeakSet,this.dataRefCount=new WeakMap,this.numBytesInGPU=0,this.uploadWaitMs=0,this.downloadWaitMs=0,this.lastGlFlushTime=0,this.warnedAboutMemory=!1,this.pendingDeletes=0,this.disposed=!1,!n.env().getBool("HAS_WEBGL"))throw new Error("WebGL is not supported on this device");if(null==e){const e=o(n.env().getNumber("WEBGL_VERSION"));this.binaryCache=((t=n.env().getNumber("WEBGL_VERSION"))in Ot||(Ot[t]={}),Ot[t]),this.gpgpu=new an(e),this.canvas=e.canvas,this.gpgpuCreatedLocally=!0}else this.gpgpu=e,this.binaryCache={},this.gpgpuCreatedLocally=!1,this.canvas=e.gl.canvas;var t;this.textureManager=new kt(this.gpgpu),this.numMBBeforeWarning=null==n.env().global.screen?1024:n.env().global.screen.height*n.env().global.screen.width*window.devicePixelRatio*600/1024/1024,this.texData=new n.DataStorage(this,n.engine())}nextDataId(){return Pt.nextDataId++}numDataIds(){return this.texData.numDataIds()-this.pendingDeletes}write(e,t,a){if((n.env().getBool("WEBGL_CHECK_NUMERICAL_PROBLEMS")||n.env().getBool("DEBUG"))&&this.checkNumericalProblems(e),"complex64"===a&&null!=e)throw new Error("Cannot write to a complex64 dtype. Please use tf.complex(real, imag).");const r={id:this.nextDataId()};return this.texData.set(r,{shape:t,dtype:a,values:e,usage:s.UPLOAD,refCount:1}),r}refCount(e){if(this.texData.has(e)){return this.texData.get(e).refCount}return 0}incRef(e){this.texData.get(e).refCount++}decRef(e){if(this.texData.has(e)){this.texData.get(e).refCount--}}move(e,t,a,r,o){if(n.env().getBool("DEBUG")&&this.checkNumericalProblems(t),"complex64"===r)throw new Error("Cannot write to a complex64 dtype. Please use tf.complex(real, imag).");this.texData.set(e,{shape:a,dtype:r,values:t,usage:s.UPLOAD,refCount:o})}disposeIntermediateTensorInfo(e){this.disposeData(e.dataId)}readSync(e){const t=this.texData.get(e),{values:a,dtype:r,complexTensorInfos:o,slice:i,shape:s,isPacked:u}=t;if(null!=i){let n;n=u?new At(s,Nt):new Tt(s,Nt);const t=this.runWebGLProgram(n,[{dataId:e,shape:s,dtype:r}],r),a=this.readSync(t.dataId);return this.disposeIntermediateTensorInfo(t),a}if(null!=a)return this.convertAndCacheOnCPU(e);if("string"===r)return a;const l=null!=this.activeTimers;let c,d;if(l&&(c=n.util.now()),"complex64"===r){const e=this.readSync(o.real.dataId),t=this.readSync(o.imag.dataId);d=n.backend_util.mergeRealAndImagArrays(e,t)}else d=this.getValuesFromTexture(e);return l&&(this.downloadWaitMs+=n.util.now()-c),this.convertAndCacheOnCPU(e,d)}async read(e){if(this.pendingRead.has(e)){const n=this.pendingRead.get(e);return new Promise((e=>n.push(e)))}const t=this.texData.get(e),{values:a,shape:r,slice:o,dtype:i,complexTensorInfos:s,isPacked:u}=t;if(null!=o){let n;n=u?new At(r,Nt):new Tt(r,Nt);const t=this.runWebGLProgram(n,[{dataId:e,shape:r,dtype:i}],i),a=this.read(t.dataId);return this.disposeIntermediateTensorInfo(t),a}if(null!=a)return this.convertAndCacheOnCPU(e);if(!n.env().getBool("WEBGL_DOWNLOAD_FLOAT_ENABLED")&&2===n.env().getNumber("WEBGL_VERSION"))throw new Error("tensor.data() with WEBGL_DOWNLOAD_FLOAT_ENABLED=false and WEBGL_VERSION=2 not yet supported.");let l,d,p=null;if("complex64"!==i&&n.env().get("WEBGL_BUFFER_SUPPORTED")){l=this.decode(e);const n=this.texData.get(l.dataId);p=this.gpgpu.createBufferFromTexture(n.texture,...c(r))}if(this.pendingRead.set(e,[]),"complex64"!==i&&await this.gpgpu.createAndWaitForFence(),"complex64"===i){const e=await Promise.all([this.read(s.real.dataId),this.read(s.imag.dataId)]),t=e[0],a=e[1];d=n.backend_util.mergeRealAndImagArrays(t,a)}else if(null==p)d=this.getValuesFromTexture(e);else{const e=n.util.sizeFromShape(r);d=this.gpgpu.downloadFloat32MatrixFromBuffer(p,e)}if(null!=l&&this.disposeIntermediateTensorInfo(l),null!=p){const e=this.gpgpu.gl;h(e,(()=>e.deleteBuffer(p)))}const f=this.convertAndCacheOnCPU(e,d),x=this.pendingRead.get(e);return this.pendingRead.delete(e),x.forEach((e=>e(f))),this.pendingDisposal.has(e)&&(this.pendingDisposal.delete(e),this.disposeData(e)&&n.engine().removeDataId(e,this),this.pendingDeletes--),f}bufferSync(e){const t=this.readSync(e.dataId);let a=t;if("string"===e.dtype)try{a=t.map((e=>n.util.decodeString(e)))}catch(e){throw new Error("Failed to decode encoded string bytes into utf-8")}return n.buffer(e.shape,e.dtype,a)}checkNumericalProblems(e){if(null!=e)for(let t=0;t<e.length;t++){const a=e[t];if(!f(a)){if(n.env().getBool("WEBGL_RENDER_FLOAT32_CAPABLE"))throw Error(`The value ${a} cannot be represented with your current settings. Consider enabling float32 rendering: 'tf.env().set('WEBGL_RENDER_FLOAT32_ENABLED', true);'`);throw Error(`The value ${a} cannot be represented on this device.`)}}}getValuesFromTexture(e){const{shape:t,dtype:a,isPacked:r}=this.texData.get(e),o=n.util.sizeFromShape(t);if(n.env().getBool("WEBGL_DOWNLOAD_FLOAT_ENABLED")){const n=this.decode(e),a=this.texData.get(n.dataId),r=this.gpgpu.downloadMatrixFromPackedTexture(a.texture,...c(t)).subarray(0,o);return this.disposeIntermediateTensorInfo(n),r}const i=n.env().getBool("WEBGL_PACK")&&!0===r,s=i?U(t):t,u=i?new Ae(s):new Ne(s),l=this.runWebGLProgram(u,[{shape:s,dtype:a,dataId:e}],"float32"),d=this.texData.get(l.dataId),p=this.gpgpu.downloadByteEncodedFloatMatrixFromOutputTexture(d.texture,d.texShape[0],d.texShape[1]).subarray(0,o);return this.disposeIntermediateTensorInfo(l),p}timerAvailable(){return n.env().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE")>0}async time(e){const t=this.activeTimers,a=[];let r=!1;null==this.programTimersStack?(this.programTimersStack=a,r=!0):this.activeTimers.push(a),this.activeTimers=a,e();const o=n.util.flatten(this.activeTimers.map((e=>e.query))).filter((e=>null!=e)),i=n.util.flatten(this.activeTimers.map((e=>e.name))).filter((e=>null!=e));this.activeTimers=t,r&&(this.programTimersStack=null);const s={uploadWaitMs:this.uploadWaitMs,downloadWaitMs:this.downloadWaitMs,kernelMs:null,wallMs:null};if(n.env().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE")>0){const e=await Promise.all(o);s.kernelMs=n.util.sum(e),s.getExtraProfileInfo=()=>e.map(((e,n)=>({name:i[n],ms:e}))).map((e=>`${e.name}: ${e.ms}`)).join(", ")}else s.kernelMs={error:"WebGL query timers are not supported in this environment."};return this.uploadWaitMs=0,this.downloadWaitMs=0,s}memory(){return{unreliable:!1,numBytesInGPU:this.numBytesInGPU,numBytesInGPUAllocated:this.textureManager.numBytesAllocated,numBytesInGPUFree:this.textureManager.numBytesFree}}startTimer(){return n.env().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE")>0?this.gpgpu.beginQuery():{startMs:n.util.now(),endMs:null}}endTimer(e){return n.env().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE")>0?(this.gpgpu.endQuery(),e):(e.endMs=n.util.now(),e)}async getQueryTime(e){if(n.env().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE")>0)return this.gpgpu.waitForQueryAndGetTime(e);const t=e;return t.endMs-t.startMs}disposeData(e,n=!1){if(this.pendingDisposal.has(e))return!1;if(!this.texData.has(e))return!0;if(n?this.texData.get(e).refCount=0:this.texData.get(e).refCount--,!n&&this.texData.get(e).refCount>0)return!1;if(this.pendingRead.has(e))return this.pendingDisposal.add(e),this.pendingDeletes++,!1;this.releaseGPUData(e);const{complexTensorInfos:t}=this.texData.get(e);return null!=t&&(this.disposeData(t.real.dataId,n),this.disposeData(t.imag.dataId,n)),this.texData.delete(e),!0}releaseGPUData(e){const{texture:n,dtype:t,texShape:a,usage:r,isPacked:o,slice:i}=this.texData.get(e),s=i&&i.origDataId||e,u=this.dataRefCount.get(s);u>1?this.dataRefCount.set(s,u-1):(this.dataRefCount.delete(s),null!=n&&(this.numBytesInGPU-=this.computeBytes(a,t),this.textureManager.releaseTexture(n,a,r,o)));const l=this.texData.get(e);l.texture=null,l.texShape=null,l.isPacked=!1,l.slice=null}getTexture(e){return this.uploadToGPU(e),this.texData.get(e).texture}getDataInfo(e){return this.texData.get(e)}shouldExecuteOnCPU(e,t=Dt){return n.env().getBool("WEBGL_CPU_FORWARD")&&e.every((e=>null==this.texData.get(e.dataId).texture&&n.util.sizeFromShape(e.shape)<t))}getGPGPUContext(){return this.gpgpu}where(e){n.backend_util.warn("tf.where() in webgl locks the UI thread. Call tf.whereAsync() instead");const t=e.dataSync();return _t(e.shape,t)}packedUnaryOp(e,t,a){const r=new At(e.shape,t),o=this.compileAndRun(r,[e],a);return n.engine().makeTensorFromDataId(o.dataId,o.shape,o.dtype)}abs(e){if(this.shouldExecuteOnCPU([e])&&"complex64"!==e.dtype){const n=ot(this.texData.get(e.dataId).values);return this.makeOutput(e.shape,e.dtype,n)}if(n.env().getBool("WEBGL_PACK_UNARY_OPERATIONS"))return this.packedUnaryOp(e,Et,e.dtype);const t=new Tt(e.shape,Et),a=this.compileAndRun(t,[e]);return n.engine().makeTensorFromDataId(a.dataId,a.shape,a.dtype)}makeTensorInfo(e,t,a){let r;if("string"===t&&null!=a&&a.length>0&&n.util.isString(a[0])){const o=a.map((e=>n.util.encodeString(e)));r=this.write(o,e,t)}else r=this.write(a,e,t);return this.texData.get(r).usage=null,{dataId:r,shape:e,dtype:t}}makeOutput(e,t,a){const{dataId:r}=this.makeTensorInfo(e,t,a);return n.engine().makeTensorFromDataId(r,e,t,this)}unpackTensor(e){const n=new Ft(e.shape);return this.runWebGLProgram(n,[e],e.dtype)}packTensor(e){const n=new It(e.shape);return this.runWebGLProgram(n,[e],e.dtype,null,!0)}packedReshape(e,n){const t=[V(e.shape),...W(e.shape)],a={dtype:e.dtype,shape:t,dataId:e.dataId},r=[V(n),...W(n)],o=new yt(r,t),i=[t],s=this.runWebGLProgram(o,[a],e.dtype,i,!0);return{dataId:s.dataId,shape:n,dtype:s.dtype}}decode(e){const n=this.texData.get(e),{isPacked:t,shape:a,dtype:r}=n,o=U(a);let i;const s=c(o);i=t?new Ee(o):new Te(o);const u=[s];return{dtype:r,shape:a,dataId:this.runWebGLProgram(i,[{shape:o,dtype:r,dataId:e}],r,u,!0).dataId}}runWebGLProgram(e,t,a,r,o=!1){const s=this.makeTensorInfo(e.outputShape,a),u=this.texData.get(s.dataId);if(e.packedOutput&&(u.isPacked=!0),e.outPackingScheme===i.DENSE){const n=c(e.outputShape);u.texShape=n.map((e=>2*e))}if(null!=e.outTexUsage&&(u.usage=e.outTexUsage),0===n.util.sizeFromShape(s.shape))return u.values=n.util.getTypedArrayFromDType(s.dtype,0),s;const l=[],d=t.map((t=>{if("complex64"===t.dtype)throw new Error("GPGPUProgram does not support complex64 input. For complex64 dtypes, please separate the program into real and imaginary parts.");let a=this.texData.get(t.dataId);if(null==a.texture){if(!e.packedInputs&&n.util.sizeFromShape(t.shape)<=n.env().getNumber("WEBGL_SIZE_UPLOAD_UNIFORM"))return{shape:t.shape,texData:null,isUniform:!0,uniformValues:a.values};e.packedInputs&&(a.isPacked=!0,a.shape=t.shape)}else if(!!a.isPacked!=!!e.packedInputs)t=a.isPacked?this.unpackTensor(t):this.packTensor(t),l.push(t),a=this.texData.get(t.dataId);else if(a.isPacked&&!z(a.shape,t.shape)){const e=t,n=t.shape;t.shape=a.shape,t=this.packedReshape(t,n),l.push(t),a=this.texData.get(t.dataId),e.shape=n}return this.uploadToGPU(t.dataId),{shape:t.shape,texData:a,isUniform:!1}}));this.uploadToGPU(s.dataId);const p={shape:s.shape,texData:u,isUniform:!1},h=function(e,t,a){let r="";t.concat(a).forEach((t=>{const o=null!=t.texData&&null!=t.texData.slice&&t.texData.slice.flatOffset>0;if(e.enableShapeUniforms&&!t.isUniform){const i=t.texData.texShape,{useSqueezeShape:s,uniformShape:u,keptDims:l}=ye(e.packedInputs,t.shape,i);let c="",d="",p="";if(1===u.length&&e.packedInputs){const e=[Math.ceil(i[0]/2),Math.ceil(i[1]/2)];c=`${e[0]>1}_${e[1]>1}`}else if(2!==u.length||e.packedInputs){if(u.length>2&&!e.packedInputs){const e=n.util.computeStrides(u);p=`${e[0]===i[1]}_${e[e.length-1]===i[1]}`}}else d=`${u[0]>1}_${u[1]>1}`;const h=t.shape.length,f=2===u.length&&n.util.arraysEqual(t.shape,i),x=1===n.util.sizeFromShape(t.shape),m=n.backend_util.getBroadcastDims(t.shape,a.shape),g=!e.packedInputs&&h===a.shape.length&&n.util.arraysEqual(i,a.texData.texShape),b=e.packedInputs||u.length>2?"":`${i[0]>1}_${i[1]>1}`;r+=`${h}_${g}_${s?l:""}_${u.length}_${x}_${m}_${f}_${c}_${d}_${p}_${b}_${o}`}else{const e=t.isUniform?"uniform":t.texData.texShape;r+=`${t.shape}_${e}_${o}`}}));const o=e.userCode;let i=e.constructor.name;return i+="_"+r+"_"+o+`${n.env().getNumber("WEBGL_VERSION")}`,i}(e,d,p),f=this.getAndSaveBinary(h,(()=>function(e,t,a,r){const o=a.map(((e,n)=>{const a={logicalShape:e.shape,texShape:e.isUniform?null:e.texData.texShape,isUniform:e.isUniform,isPacked:!e.isUniform&&e.texData.isPacked,flatOffset:null};return null!=e.texData&&null!=e.texData.slice&&e.texData.slice.flatOffset>0&&(a.flatOffset=e.texData.slice.flatOffset),{name:t.variableNames[n],shapeInfo:a}})),i=o.map((e=>e.shapeInfo)),s={logicalShape:r.shape,texShape:r.texData.texShape,isUniform:!1,isPacked:r.texData.isPacked,flatOffset:null},u=pe(o,s,t),l=e.createProgram(u);let c=null;const d=e.getUniformLocation(l,"NAN",!1);1===n.env().getNumber("WEBGL_VERSION")&&(c=e.getUniformLocation(l,"INFINITY",!1));const p=!1,h={},f={},x={};for(let n=0;n<t.variableNames.length;n++){const a=t.variableNames[n];h[a]=e.getUniformLocation(l,a,p),h[`offset${a}`]=e.getUniformLocation(l,`offset${a}`,p),t.enableShapeUniforms&&(f[`${a}Shape`]=e.getUniformLocation(l,`${a}Shape`,p),x[`${a}TexShape`]=e.getUniformLocation(l,`${a}TexShape`,p))}let m,g,b;t.enableShapeUniforms&&(m=e.getUniformLocation(l,"outShape",p),b=e.getUniformLocation(l,"outShapeStrides",p),g=e.getUniformLocation(l,"outTexShape",p));const v=[];return t.customUniforms&&t.customUniforms.forEach(((n,t)=>{v[t]=e.getUniformLocation(l,n.name,p)})),{program:t,source:u,webGLProgram:l,uniformLocations:h,customUniformLocations:v,inShapeInfos:i,outShapeInfo:s,infLoc:c,nanLoc:d,inShapesLocations:f,inTexShapesLocations:x,outShapeLocation:m,outShapeStridesLocation:b,outTexShapeLocation:g}}(this.gpgpu,e,d,p))),x=null!=this.activeTimers;let m;x&&(m=this.startTimer()),function(e,t,a,r,o){t.program.enableShapeUniforms||(Re(t.inShapeInfos,a),Re([t.outShapeInfo],[r]));const i=r.texData.texture,s=r.texData.texShape;r.texData.isPacked?e.setOutputPackedMatrixTexture(i,s[0],s[1]):e.setOutputMatrixTexture(i,s[0],s[1]),e.setProgram(t.webGLProgram),1===n.env().getNumber("WEBGL_VERSION")&&null!==t.infLoc&&e.gl.uniform1f(t.infLoc,1/0),null!==t.nanLoc&&e.gl.uniform1f(t.nanLoc,NaN),a.forEach(((a,r)=>{const o=t.program.variableNames[r],i=t.uniformLocations[o],s=t.uniformLocations[`offset${o}`],u=t.inShapesLocations[`${o}Shape`],l=t.inTexShapesLocations[`${o}TexShape`];if(u){const{uniformShape:n}=ye(t.program.packedInputs,a.shape,a.texData.texShape);switch(n.length){case 1:e.gl.uniform1iv(u,new Int32Array(n));break;case 2:e.gl.uniform2iv(u,new Int32Array(n));break;case 3:e.gl.uniform3iv(u,new Int32Array(n));break;case 4:e.gl.uniform4iv(u,new Int32Array(n))}}if(l&&e.gl.uniform2i(l,a.texData.texShape[0],a.texData.texShape[1]),null!=i)if(a.isUniform)if(n.util.sizeFromShape(a.shape)<2)e.gl.uniform1f(i,a.uniformValues[0]);else{let n=a.uniformValues;n instanceof Float32Array||(n=new Float32Array(n)),e.gl.uniform1fv(i,n)}else null!=a.texData.slice&&null!=s&&e.gl.uniform1i(s,a.texData.slice.flatOffset),e.setInputMatrixTexture(a.texData.texture,i,r)}));const u=t.outShapeLocation;if(u)switch(r.shape.length){case 1:e.gl.uniform1iv(u,new Int32Array(r.shape));break;case 2:e.gl.uniform2iv(u,new Int32Array(r.shape));break;case 3:e.gl.uniform3iv(u,new Int32Array(r.shape));break;case 4:e.gl.uniform4iv(u,new Int32Array(r.shape))}if(t.outShapeStridesLocation){const a=n.util.computeStrides(r.shape);switch(r.shape.length){case 2:e.gl.uniform1iv(t.outShapeStridesLocation,new Int32Array(a));break;case 3:e.gl.uniform2iv(t.outShapeStridesLocation,new Int32Array(a));break;case 4:e.gl.uniform3iv(t.outShapeStridesLocation,new Int32Array(a))}}t.outTexShapeLocation&&e.gl.uniform2i(t.outTexShapeLocation,r.texData.texShape[0],r.texData.texShape[1]),t.program.customUniforms&&o&&t.program.customUniforms.forEach(((n,a)=>{const r=t.customUniformLocations[a],i=o[a];if("float"===n.type)e.gl.uniform1fv(r,i);else if("vec2"===n.type)e.gl.uniform2fv(r,i);else if("vec3"===n.type)e.gl.uniform3fv(r,i);else if("vec4"===n.type)e.gl.uniform4fv(r,i);else if("int"===n.type)e.gl.uniform1iv(r,i);else if("ivec2"===n.type)e.gl.uniform2iv(r,i);else if("ivec3"===n.type)e.gl.uniform3iv(r,i);else{if("ivec4"!==n.type)throw Error(`uniform type ${n.type} is not supported yet.`);e.gl.uniform4iv(r,i)}})),e.executeProgram()}(this.gpgpu,f,d,p,r),l.forEach((e=>this.disposeIntermediateTensorInfo(e))),x&&(m=this.endTimer(m),this.activeTimers.push({name:e.constructor.name,query:this.getQueryTime(m)}));const g=n.env().get("WEBGL_FLUSH_THRESHOLD");if(g>0){const e=n.util.now();e-this.lastGlFlushTime>g&&(this.gpgpu.gl.flush(),this.lastGlFlushTime=e)}if(!n.env().getBool("WEBGL_LAZILY_UNPACK")&&u.isPacked&&!1===o){const e=this.unpackTensor(s);return this.disposeIntermediateTensorInfo(s),e}return s}compileAndRun(e,n,t,a,r=!1){t=t||n[0].dtype;return this.runWebGLProgram(e,n,t,a,r)}getAndSaveBinary(e,n){return e in this.binaryCache||(this.binaryCache[e]=n()),this.binaryCache[e]}getTextureManager(){return this.textureManager}dispose(){if(!this.disposed){if(!n.env().getBool("IS_TEST")){Object.keys(this.binaryCache).forEach((e=>{this.gpgpu.deleteProgram(this.binaryCache[e].webGLProgram),delete this.binaryCache[e]}))}this.textureManager.dispose(),null!=this.canvas&&"undefined"!=typeof HTMLCanvasElement&&this.canvas instanceof HTMLCanvasElement?this.canvas.remove():this.canvas=null,this.gpgpuCreatedLocally&&(this.gpgpu.program=null,this.gpgpu.dispose()),this.disposed=!0}}floatPrecision(){return null==this.floatPrecisionValue&&(this.floatPrecisionValue=n.tidy((()=>{if(!n.env().get("WEBGL_RENDER_FLOAT32_ENABLED")){const e=n.env().getBool("DEBUG");n.env().set("DEBUG",!1);const t=this.abs(n.scalar(1e-8)).dataSync()[0];if(n.env().set("DEBUG",e),t>0)return 32}return 16}))),this.floatPrecisionValue}epsilon(){return 32===this.floatPrecision()?1e-7:1e-4}uploadToGPU(e){const t=this.texData.get(e),{shape:a,dtype:r,values:o,texture:i,usage:u,isPacked:l}=t;if(null!=i)return;const c=null!=this.activeTimers;let p;c&&(p=n.util.now());let h=t.texShape;if(null==h&&(h=M(a,l),t.texShape=h),null!=o){const e=U(a);let i,u=h[1],f=h[0];const x=o instanceof Uint8Array;l?([u,f]=d(h[0],h[1]),i=new _e(e,x)):i=new Fe(e,x);const m=this.makeTensorInfo([f,u],r);this.texData.get(m.dataId).usage=x?s.PIXELS:s.UPLOAD,this.gpgpu.uploadDenseMatrixToTexture(this.getTexture(m.dataId),u,f,o);const g=[[f,u]],b=!0,v=this.runWebGLProgram(i,[m],r,g,b),C=this.texData.get(v.dataId);t.texture=C.texture,t.texShape=C.texShape,t.isPacked=C.isPacked,t.usage=C.usage,this.disposeIntermediateTensorInfo(m),this.texData.delete(v.dataId),t.values=null,c&&(this.uploadWaitMs+=n.util.now()-p)}else{const e=this.acquireTexture(h,u,r,l);t.texture=e}}convertAndCacheOnCPU(e,n){const t=this.texData.get(e),{dtype:a}=t;return this.releaseGPUData(e),null!=n&&(t.values=function(e,n){if("float32"===n||"complex64"===n)return e;if("int32"===n||"bool"===n){const t="int32"===n?new Int32Array(e.length):new Uint8Array(e.length);for(let n=0;n<t.length;++n)t[n]=Math.round(e[n]);return t}throw new Error(`Unknown dtype ${n}`)}(n,a)),t.values}acquireTexture(e,n,t,a){if(this.numBytesInGPU+=this.computeBytes(e,t),!this.warnedAboutMemory&&this.numBytesInGPU>1024*this.numMBBeforeWarning*1024){const e=(this.numBytesInGPU/1024/1024).toFixed(2);this.warnedAboutMemory=!0,console.warn(`High memory usage in GPU: ${e} MB, most likely due to a memory leak`)}return this.textureManager.acquireTexture(e,n,a)}computeBytes(e,t){return e[0]*e[1]*n.util.bytesPerElement(t)}}Pt.nextDataId=0;function Lt(){n.env().set("WEBGL_FORCE_F16_TEXTURES",!0)}n.device_util.isBrowser()&&n.registerBackend("webgl",(()=>new Pt),2);const Bt={forceHalfFloat:Lt};class Vt{constructor(e,t,a){this.variableNames=["A","B"],this.outputShape=n.backend_util.assertAndGetBroadcastShape(t,a),this.enableShapeUniforms=Se(this.outputShape.length),this.userCode=`\n      float binaryOperation(float a, float b) {\n        ${e}\n      }\n\n      void main() {\n        float a = getAAtOutCoords();\n        float b = getBAtOutCoords();\n        setOutput(binaryOperation(a, b));\n      }\n    `}}class Wt{constructor(e,t,a,r=!1){this.variableNames=["A","B"],this.supportsBroadcasting=!0,this.packedInputs=!0,this.packedOutput=!0,this.outputShape=n.backend_util.assertAndGetBroadcastShape(t,a);const o=this.outputShape.length;this.enableShapeUniforms=Se(o);let i="";if(r)if(0===o||1===n.util.sizeFromShape(this.outputShape))i="\n          result.y = 0.;\n          result.z = 0.;\n          result.w = 0.;\n        ";else{if(i=`\n          ${Ie(o)} coords = getOutputCoords();\n        `,1===o)this.enableShapeUniforms?i+="\n            result.y = (coords + 1) >= outShape ? 0. : result.y;\n            result.z = 0.;\n            result.w = 0.;\n          ":i+=`\n            result.y = (coords + 1) >= ${this.outputShape[0]} ? 0. : result.y;\n            result.z = 0.;\n            result.w = 0.;\n          `;else{const e=$t("coords",o);this.enableShapeUniforms?i+=`\n            bool nextRowOutOfBounds =\n              (${e[o-2]} + 1) >= outShape[${o} - 2];\n            bool nextColOutOfBounds =\n              (${e[o-1]} + 1) >= outShape[${o} - 1];\n            result.y = nextColOutOfBounds ? 0. : result.y;\n            result.z = nextRowOutOfBounds ? 0. : result.z;\n            result.w = nextColOutOfBounds || nextRowOutOfBounds ? 0. : result.w;\n          `:i+=`\n            bool nextRowOutOfBounds =\n              (${e[o-2]} + 1) >= ${this.outputShape[o-2]};\n            bool nextColOutOfBounds =\n              (${e[o-1]} + 1) >= ${this.outputShape[o-1]};\n            result.y = nextColOutOfBounds ? 0. : result.y;\n            result.z = nextRowOutOfBounds ? 0. : result.z;\n            result.w = nextColOutOfBounds || nextRowOutOfBounds ? 0. : result.w;\n          `}}this.userCode=`\n      vec4 binaryOperation(vec4 a, vec4 b) {\n        ${e}\n      }\n\n      void main() {\n        vec4 a = getAAtOutCoords();\n        vec4 b = getBAtOutCoords();\n\n        vec4 result = binaryOperation(a, b);\n        ${i}\n\n        setOutput(result);\n      }\n    `}}function Ut(e){const{inputs:n,backend:t}=e,{x:a}=n;return t.incRef(a.dataId),{dataId:a.dataId,shape:a.shape,dtype:a.dtype}}const Mt={kernelName:n.Identity,backendName:"webgl",kernelFunc:Ut};function Gt(e){const{inputs:n,backend:t}=e,{real:a,imag:r}=n,o=t.makeTensorInfo(a.shape,"complex64"),i=t.texData.get(o.dataId),s=Ut({inputs:{x:a},backend:t}),u=Ut({inputs:{x:r},backend:t});return i.complexTensorInfos={real:s,imag:u},o}const zt={kernelName:n.Complex,backendName:"webgl",kernelFunc:Gt},Xt="return (a < 0.) ? b * a : a;",Ht="\n  vec4 aLessThanZero = vec4(lessThan(a, vec4(0.)));\n  return (aLessThanZero * (b * a)) + ((vec4(1.0) - aLessThanZero) * a);\n";const jt={kernelName:n.LeakyRelu,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:a,attrs:r}=e,{x:o}=t,{alpha:i}=r,s=a.makeTensorInfo([],"float32",n.util.createScalarValue(i,"float32")),u=n.env().getBool("WEBGL_PACK_BINARY_OPERATIONS")?new Wt(Ht,o.shape,s.shape):new Vt(Xt,o.shape,s.shape),l=a.runWebGLProgram(u,[o,s],o.dtype);return a.disposeIntermediateTensorInfo(s),l}},Kt="return (a < 0.) ? b * a : a;",qt="\n  vec4 aLessThanZero = vec4(lessThan(a, vec4(0.)));\n  return (aLessThanZero * (b * a)) + ((vec4(1.0) - aLessThanZero) * a);\n";const Yt={kernelName:n.Prelu,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:a}=e,{x:r,alpha:o}=t,i=n.env().getBool("WEBGL_PACK_BINARY_OPERATIONS")?new Wt(qt,r.shape,o.shape):new Vt(Kt,r.shape,o.shape);return a.runWebGLProgram(i,[r,o],r.dtype)}};function Qt({opSnippet:e,packedOpSnippet:t,cpuKernelImpl:a,dtype:r}){return({inputs:o,backend:i})=>{const{x:s}=o,u=i,l=r||s.dtype;if(u.shouldExecuteOnCPU([s])&&null!=a){const e=u.texData.get(s.dataId),n=a(e.values,l);return u.makeTensorInfo(s.shape,l,n)}let c;return c=n.env().getBool("WEBGL_PACK_UNARY_OPERATIONS")&&null!=t?new At(s.shape,t):new Tt(s.shape,e),u.runWebGLProgram(c,[s],l)}}function Zt({opSnippet:e,packedOpSnippet:t,checkOutOfBounds:a=!1,supportsComplex:r=!1,cpuKernelImpl:o,dtype:i}){return({inputs:s,backend:u})=>{const{a:l,b:c}=s,d=u;if(r&&"complex64"===l.dtype){const t=d.texData.get(l.dataId),a=d.texData.get(c.dataId),[r,o]=[[t.complexTensorInfos.real,a.complexTensorInfos.real],[t.complexTensorInfos.imag,a.complexTensorInfos.imag]].map((t=>{const[a,r]=t,o={dataId:a.dataId,dtype:a.dtype,shape:l.shape},i={dataId:r.dataId,dtype:r.dtype,shape:c.shape},s=new Vt(e,l.shape,c.shape);return d.runWebGLProgram(s,[o,i],n.upcastType(a.dtype,r.dtype))})),i=Gt({inputs:{real:r,imag:o},backend:d});return d.disposeIntermediateTensorInfo(r),d.disposeIntermediateTensorInfo(o),i}const p=i||n.upcastType(l.dtype,c.dtype);if(("string"===l.dtype||"string"===c.dtype||d.shouldExecuteOnCPU([l,c]))&&null!=o){const e=d.texData.get(l.dataId).values,t=d.texData.get(c.dataId).values,a="string"===l.dtype?n.backend_util.fromUint8ToStringArray(e):e,r="string"===l.dtype?n.backend_util.fromUint8ToStringArray(t):t,[i,s]=o(l.shape,c.shape,a,r,p),u=d.makeTensorInfo(s,p);return d.texData.get(u.dataId).values=i,u}let h;return h=n.env().getBool("WEBGL_PACK_BINARY_OPERATIONS")&&null!=t?new Wt(t,l.shape,c.shape,a):new Vt(e,l.shape,c.shape),d.runWebGLProgram(h,[l,c],p)}}function Jt(e,n=!1){if("linear"===e)return"return x;";if("relu"===e)return n?"\n  vec4 result = x * vec4(greaterThanEqual(x, vec4(0.0)));\n  bvec4 isNaN = isnan(x);\n\n  result.r = isNaN.r ? x.r : result.r;\n  result.g = isNaN.g ? x.g : result.g;\n  result.b = isNaN.b ? x.b : result.b;\n  result.a = isNaN.a ? x.a : result.a;\n\n  return result;\n":"if (isnan(x)) return x;\n  return (x < 0.0) ? 0.0 : x;\n";if("elu"===e)return n?"\n  vec4 result;\n\n  result.r = (x.r >= 0.0) ? x.r : (exp(x.r) - 1.0);\n  result.g = (x.g >= 0.0) ? x.g : (exp(x.g) - 1.0);\n  result.b = (x.b >= 0.0) ? x.b : (exp(x.b) - 1.0);\n  result.a = (x.a >= 0.0) ? x.a : (exp(x.a) - 1.0);\n\n  return result;\n":"return (x >= 0.0) ? x : (exp(x) - 1.0);";if("relu6"===e)return n?"\n  vec4 result = min(x, vec4(6.)) * vec4(greaterThanEqual(x, vec4(0.0)));\n  bvec4 isNaN = isnan(x);\n\n  result.r = isNaN.r ? x.r : result.r;\n  result.g = isNaN.g ? x.g : result.g;\n  result.b = isNaN.b ? x.b : result.b;\n  result.a = isNaN.a ? x.a : result.a;\n\n  return result;\n":"if (isnan(x)) return x;\n  return (x < 0.0) ? 0.0 : min(6.0, x);\n";if("prelu"===e)return n?qt:Kt;if("leakyrelu"===e)return n?Ht:Xt;if("sigmoid"===e)return"return 1.0 / (1.0 + exp(-1.0 * x));";throw new Error(`Activation ${e} has not been implemented for the WebGL backend.`)}class ea{constructor(e,n,t,a=!1,r=!1,o=!1,i=null,s=!1,u=!1){this.variableNames=["matrixA","matrixB"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=t,this.enableShapeUniforms=Se(this.outputShape.length);const l=a?e[1]:e[2],c=Math.ceil(l/2),d=a?"i * 2, rc.y":"rc.y, i * 2",p=r?"rc.z, i * 2":"i * 2, rc.z",h=a?["a.xxyy","a.zzww"]:["a.xxzz","a.yyww"],f=r?["b.xzxz","b.ywyw"]:["b.xyxy","b.zwzw"];let x="",m="";i&&(x=s?`vec4 activation(vec4 a) {\n          vec4 b = getPreluActivationWeightsAtOutCoords();\n          ${i}\n        }`:u?`vec4 activation(vec4 a) {\n          vec4 b = getLeakyreluAlphaAtOutCoords();\n          ${i}\n        }`:`vec4 activation(vec4 x) {\n          ${i}\n        }`,m="result = activation(result);");const g=o?"result += getBiasAtOutCoords();":"";o&&this.variableNames.push("bias"),s&&this.variableNames.push("preluActivationWeights"),u&&this.variableNames.push("leakyreluAlpha");let b="rc.x",v="rc.x";e[0]<n[0]?b=`int(min(float(rc.x), ${e[0]-1}.))`:n[0]<e[0]&&(v=`int(min(float(rc.x), ${n[0]-1}.))`),this.userCode=`\n      ${x}\n      // Don't use uniform for sharedDimensionPacked for performance.\n      const float sharedDimension = ${c}.0;\n\n      vec4 dot2x2ARowBCol(ivec3 rc) {\n        vec4 result = vec4(0);\n        for (int i = 0; i < ${c}; i++) {\n          int batchA = ${b};\n          int batchB = ${v};\n          vec4 a = getMatrixA(batchA, ${d});\n          vec4 b = getMatrixB(batchB, ${p});\n\n          // These swizzled products need to be separately added.\n          // See: https://github.com/tensorflow/tfjs/issues/1735\n          result += (${h[0]} * ${f[0]});\n          result += (${h[1]} * ${f[1]});\n        }\n        return result;\n      }\n\n      void main() {\n        ivec3 rc = getOutputCoords();\n        vec4 result = dot2x2ARowBCol(rc);\n\n        ${g}\n\n        ${m}\n\n        setOutput(result);\n      }\n    `}}const na="return areal * breal - aimag * bimag;",ta="return areal * bimag + aimag * breal;";class aa{constructor(e,t,a){this.variableNames=["AReal","AImag","BReal","BImag"],this.outputShape=n.backend_util.assertAndGetBroadcastShape(t,a),this.userCode=`\n      float binaryOpComplex(\n          float areal, float aimag, float breal, float bimag) {\n        ${e}\n      }\n\n      void main() {\n        float areal = getARealAtOutCoords();\n        float aimag = getAImagAtOutCoords();\n        float breal = getBRealAtOutCoords();\n        float bimag = getBImagAtOutCoords();\n        setOutput(binaryOpComplex(areal, aimag, breal, bimag));\n      }\n    `}}const ra="return a * b;";function oa(e){const{inputs:t,backend:a}=e,{a:r,b:o}=t,i=n.backend_util.upcastType(r.dtype,o.dtype);if("complex64"===r.dtype){const e=a.texData.get(r.dataId),n=a.texData.get(o.dataId),t=new aa(na,r.shape,o.shape),i=new aa(ta,r.shape,o.shape),s=[{dataId:e.complexTensorInfos.real.dataId,dtype:e.complexTensorInfos.real.dtype,shape:r.shape},{dataId:e.complexTensorInfos.imag.dataId,dtype:e.complexTensorInfos.imag.dtype,shape:r.shape},{dataId:n.complexTensorInfos.real.dataId,dtype:n.complexTensorInfos.real.dtype,shape:o.shape},{dataId:n.complexTensorInfos.imag.dataId,dtype:n.complexTensorInfos.imag.dtype,shape:o.shape}],u=a.runWebGLProgram(t,s,"float32"),l=a.runWebGLProgram(i,s,"float32"),c=Gt({inputs:{real:u,imag:l},backend:a});return a.disposeIntermediateTensorInfo(u),a.disposeIntermediateTensorInfo(l),c}if(a.shouldExecuteOnCPU([r,o])){const e=a.texData.get(r.dataId),n=a.texData.get(o.dataId),[t,s]=Zn(r.shape,o.shape,e.values,n.values,i),u=a.makeTensorInfo(s,i);return a.texData.get(u.dataId).values=t,u}let s;return s=n.env().getBool("WEBGL_PACK_BINARY_OPERATIONS")?new Wt(ra,r.shape,o.shape):new Vt(ra,r.shape,o.shape),a.runWebGLProgram(s,[r,o],i)}const ia={kernelName:n.Multiply,backendName:"webgl",kernelFunc:oa};function sa(e){const{inputs:t,backend:a,attrs:r}=e,{x:o}=t,{shape:i}=r,s=a,u=n.util.sizeFromShape(o.shape),l=n.util.inferFromImplicitShape(i,u),c=n.util.sizeFromShape(l);n.util.assert(u===c,(()=>`The new shape (${l}) has ${c} elements and the old shape (${o.shape}) has ${u} elements. The new shape and old shape must have the same number of elements.`));const d=s.texData.get(o.dataId);return!d.isPacked||z(o.shape,l)||null!==d.texture&&z(d.shape,l)?(s.incRef(o.dataId),{dataId:o.dataId,shape:l,dtype:o.dtype}):function(e,n,t){const a=[V(e.shape),...W(e.shape)],r={dtype:e.dtype,shape:a,dataId:e.dataId},o=[V(n),...W(n)],i=new yt(o,a),s=[a],u=t.runWebGLProgram(i,[r],e.dtype,s,!0);return{dataId:u.dataId,shape:n,dtype:u.dtype}}(o,l,s)}const ua={kernelName:n.Reshape,backendName:"webgl",kernelFunc:sa};class la{constructor(e,t){this.variableNames=["x"];const{windowSize:a,batchSize:r,inSize:o,outSize:i}=e;this.outputShape=[r,i];const s=4*Math.floor(a/4),u=a%4;let l="sumValue += dot(values, ones);";if(null!=t){const e=1/t;l=`sumValue += dot(values * ${n.util.isInt(e)?e.toPrecision(2):e}, ones);`}let c="";o%a>0&&(c=`\n        if (inIdx < 0 || inIdx >= ${o}) {\n          return 0.0;\n        }\n      `),this.userCode=`\n      const vec4 ones = vec4(1.0, 1.0, 1.0, 1.0);\n\n      float getValue(int batch, int inIdx) {\n        ${c}\n        return getX(batch, inIdx);\n      }\n\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int batch = coords[0];\n        int outIdx = coords[1];\n        int inOffset = outIdx * ${a};\n\n        float sumValue = 0.0;\n\n        for (int i = 0; i < ${s}; i += 4) {\n          int inIdx = inOffset + i;\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2),\n            getValue(batch, inIdx + 3)\n          );\n\n          ${l}\n        }\n\n        int inIdx = inOffset + ${s};\n        if (${1===u}) {\n          vec4 values = vec4(getValue(batch, inIdx), 0.0, 0.0, 0.0);\n\n          ${l}\n        } else if (${2===u}) {\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1), 0.0, 0.0);\n\n          ${l}\n        } else if (${3===u}) {\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2), 0.0);\n\n          ${l}\n        }\n        setOutput(sumValue);\n      }\n    `}}class ca{constructor(e,n){this.variableNames=["x"];const{windowSize:t,batchSize:a,inSize:r,outSize:o}=e;this.outputShape=[a,o];let i="0.0",s="";"prod"===n?i="1.0":"min"===n?(i="1.0 / 1e-20",s="min"):"max"===n&&(i="-1.0 / 1e-20",s="max");let u=`${n}(${n}(${n}(minMaxValue[0], minMaxValue[1]), minMaxValue[2]), minMaxValue[3])`;"sum"===n?u="sumValue":"prod"===n?u="prodValue":"all"===n?u="allValue":"any"===n&&(u="anyValue");const l=4*Math.floor(t/4),c=t%4;let d=`\n      if (${"sum"===n}) {\n        sumValue += dot(values, ones);\n      } else if (${"prod"===n}) {\n        vec2 tmp = vec2(values[0], values[1]) * vec2(values[2], values[3]);\n        prodValue *= tmp[0] * tmp[1];\n      } else {\n        minMaxValue = ${s}(values, minMaxValue);\n        if (${"min"===n} || ${"max"===n}) {\n          minMaxValue = ${s}(values, minMaxValue);\n          bvec4 isNaN = isnan(values);\n          if (isNaN.r || isNaN.g || isNaN.b || isNaN.a) {\n            minMaxValue = vec4(NAN);\n          }\n        }\n      }\n    `,p="vec4";"all"===n?(i="1.0",d="\n        bool reducedAllValue = all(values);\n        float floatedReducedAllValue = float(reducedAllValue);\n        allValue = float(allValue >= 1.0 && floatedReducedAllValue >= 1.0);\n      ",p="bvec4"):"any"===n&&(i="0.0",d="\n        bool reducedAnyValue = any(values);\n        float floatedReducedAnyValue = float(reducedAnyValue);\n        anyValue = float(anyValue >= 1.0 || floatedReducedAnyValue >= 1.0);\n      ",p="bvec4");let h="";r%t>0&&(h=`\n        if (inIdx < 0 || inIdx >= ${r}) {\n          return initializationValue;\n        }\n      `),this.userCode=`\n      const float initializationValue = ${i};\n      const vec4 ones = vec4(1.0, 1.0, 1.0, 1.0);\n\n      float getValue(int batch, int inIdx) {\n        ${h}\n        return getX(batch, inIdx);\n      }\n\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int batch = coords[0];\n        int outIdx = coords[1];\n        int inOffset = outIdx * ${t};\n\n        vec4 minMaxValue = vec4(${i});\n        float prodValue = 1.0;\n        float sumValue = 0.0;\n        float allValue = 1.0;\n        float anyValue = 0.0;\n\n        for (int i = 0; i < ${l}; i += 4) {\n          int inIdx = inOffset + i;\n          ${p} values = ${p}(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2),\n            getValue(batch, inIdx + 3)\n          );\n\n          ${d}\n        }\n\n        int inIdx = inOffset + ${l};\n        if (${1===c}) {\n          ${p} values = ${p}(\n            getValue(batch, inIdx),\n            initializationValue,\n            initializationValue,\n            initializationValue\n          );\n\n          ${d}\n        } else if (${2===c}) {\n          ${p} values = ${p}(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            initializationValue,\n            initializationValue\n          );\n\n          ${d}\n        } else if (${3===c}) {\n          ${p} values = ${p}(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2),\n            initializationValue\n          );\n\n          ${d}\n        }\n        setOutput(${u});\n      }\n    `}}function da(e,t,a,r){const o=function(e){const t=[];for(;0===t.length||1!==t[t.length-1].outSize;){const a=t.length?t[t.length-1].outSize:e[1],r=n.backend_util.computeOptimalWindowSize(a);t.push({inSize:a,windowSize:r,outSize:Math.ceil(a/r)})}return t}(e.shape);let i=e;for(let n=0;n<o.length;n++){const{inSize:s,windowSize:u,outSize:l}=o[n];let c,d;c="mean"===a?0===n?new la({windowSize:u,inSize:s,batchSize:e.shape[0],outSize:l},s):new la({windowSize:u,inSize:s,batchSize:e.shape[0],outSize:l}):new ca({windowSize:u,inSize:s,batchSize:e.shape[0],outSize:l},a),d=i,i=r.runWebGLProgram(c,[i],t),d.dataId!==e.dataId&&r.disposeIntermediateTensorInfo(d)}return i}class pa{constructor(e,n){this.variableNames=["A"];const t=new Array(e.length);for(let a=0;a<t.length;a++)t[a]=e[n[a]];this.outputShape=t,this.rank=t.length;const a=Ie(this.rank),r=function(e){const n=e.length;if(n>6)throw Error(`Transpose for rank ${n} is not yet supported`);const t=["resRC.x","resRC.y","resRC.z","resRC.w","resRC.u","resRC.v"],a=new Array(n);for(let n=0;n<e.length;n++)a[e[n]]=t[n];return a.join()}(n);this.userCode=`\n    void main() {\n      ${a} resRC = getOutputCoords();\n      setOutput(getA(${r}));\n    }\n    `}}class ha{constructor(e,n){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0;const t=new Array(e.length);for(let a=0;a<t.length;a++)t[a]=e[n[a]];if(this.outputShape=t,this.rank=t.length,this.rank>6)throw Error(`Packed transpose for rank ${this.rank} is not yet supported.`);const a=Ie(this.rank),r=Ct("rc",this.rank),o=new Array(this.rank);for(let e=0;e<n.length;e++)o[n[e]]=r[e];const i=`vec2(${o.slice(-2).join()})`,s=`++${r[this.rank-1]} < ${t[this.rank-1]}`,u=`getChannel(getA(${o.join()}), ${i})`;this.userCode=`\n    void main() {\n      ${a} rc = getOutputCoords();\n      vec4 result = vec4(0.);\n      result[0] = ${u};\n      if(${s}) {\n        result[1] = ${u};\n      }\n      --${r[this.rank-1]};\n      if(++${r[this.rank-2]} < ${t[this.rank-2]}) {\n        result[2] = ${u};\n        if(${s}) {\n          result[3] = ${u};\n        }\n      }\n      setOutput(result);\n    }\n    `}}function fa(e,t,a){const r=n.env().getBool("WEBGL_PACK_ARRAY_OPERATIONS")?new ha(e.shape,t):new pa(e.shape,t);return a.runWebGLProgram(r,[e],e.dtype)}function xa(e){const{inputs:t,backend:a,attrs:r}=e,{x:o}=t,{axis:i,keepDims:s}=r;return function(e,t,a,r){const o=t,i=e.shape.length,s=n.util.parseAxisParam(o,e.shape);let u=s;const l=n.backend_util.getAxesPermutation(u,i),c=null!=l;let d=e;c&&(d=fa(e,l,r),u=n.backend_util.getInnerMostAxes(u.length,i)),n.backend_util.assertAxesAreInnerMostDims("sum",u,i);const[p,h]=n.backend_util.computeOutAndReduceShapes(d.shape,u);let f=p;a&&(f=n.backend_util.expandShapeToKeepDim(p,s));const x=n.util.sizeFromShape(h),m=sa({inputs:{x:d},attrs:{shape:[n.util.sizeFromShape(e.shape)/x,x]},backend:r}),g=da(m,n.sumOutType(e.dtype),"sum",r),b=sa({inputs:{x:g},attrs:{shape:f},backend:r});return r.disposeIntermediateTensorInfo(m),r.disposeIntermediateTensorInfo(g),c&&r.disposeIntermediateTensorInfo(d),b}(o,i,s,a)}const ma={kernelName:n.Sum,backendName:"webgl",kernelFunc:xa};function ga(e){const{inputs:n,backend:t,attrs:a}=e,{x:r}=n,{perm:o}=a,i=t,s=r.shape.length,u=new Array(s);for(let e=0;e<u.length;e++)u[e]=r.shape[o[e]];let l;if(i.shouldExecuteOnCPU([r])){const e=i.texData.get(r.dataId).values,n=bt(e,r.shape,r.dtype,o,u);l=i.makeTensorInfo(u,r.dtype);i.texData.get(l.dataId).values=n}else l=fa(r,o,i);return l}const ba={kernelName:n.Transpose,backendName:"webgl",kernelFunc:ga};function va({a:e,b:t,transposeA:a,transposeB:r,backend:o,bias:i=null,preluActivationWeights:s=null,leakyreluAlpha:u=0,activation:l=null}){const c=e.shape.length,d=t.shape.length,p=a?e.shape[c-2]:e.shape[c-1],h=r?t.shape[d-1]:t.shape[d-2],f=a?e.shape[c-1]:e.shape[c-2],x=r?t.shape[d-2]:t.shape[d-1],m=e.shape.slice(0,-2),g=t.shape.slice(0,-2),b=n.util.sizeFromShape(m),v=n.util.sizeFromShape(g),C=b===v||1===b||1===v;n.util.assert(c>=2&&d>=2&&C,(()=>`Error in matMul: the input batch dimensions must either be the same or at least one input batch dimension must be 1. Got input batch dimensions of (${m}) and (${g}).`));const $=(b>v?e.shape.slice(0,-2):t.shape.slice(0,-2)).concat([f,x]);n.util.assert(p===h,(()=>`Error in matMul: inner shapes (${p}) and (${h}) of Tensors with shapes ${e.shape} and ${t.shape} and transposeA=${a} and transposeB=${r} must match.`));const I=a?[b,p,f]:[b,f,p],y=r?[v,x,h]:[v,h,x],k=sa({inputs:{x:e},backend:o,attrs:{shape:I}}),w=sa({inputs:{x:t},backend:o,attrs:{shape:y}}),R=[k,w],S=Math.max(b,v),T=a?k.shape[1]:k.shape[2],E=null!=i,N=null!=s,A="leakyrelu"===l,F=null!=l?Jt(l,!0):null;let _;if((1===f||1===x)&&T>1e3&&!1===(E||N||A||null!=F)){let e=k,n=w;a&&(e=ga({inputs:{x:k},backend:o,attrs:{perm:[0,2,1]}}),R.push(e)),r&&(n=ga({inputs:{x:w},backend:o,attrs:{perm:[0,2,1]}}),R.push(n));const t=1===x;let i=e;1!==x&&(i=sa({inputs:{x:e},backend:o,attrs:{shape:[S,T,1]}}),R.push(i));const s=1===x?2:1;let u=n;t&&(u=sa({inputs:{x:n},backend:o,attrs:{shape:[S,1,T]}}),R.push(u));const l=oa({inputs:{a:i,b:u},backend:o});_=xa({inputs:{x:l},backend:o,attrs:{axis:s,keepDims:!0}}),R.push(l)}else{const l=n.upcastType(e.dtype,t.dtype),c=new ea(I,y,[S,f,x],a,r,E,F,N,A),d=[k,w];if(null!=i&&d.push(i),N&&d.push(s),A){const e=o.makeTensorInfo([],"float32",n.util.createScalarValue(u,"float32"));d.push(e),R.push(e)}_=o.runWebGLProgram(c,d,l)}const O=sa({inputs:{x:_},backend:o,attrs:{shape:$}});R.push(_);for(const e of R)o.disposeIntermediateTensorInfo(e);return O}const Ca={kernelName:n._FusedMatMul,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t,attrs:a}=e,{a:r,b:o,bias:i,preluActivationWeights:s}=n,{transposeA:u,transposeB:l,activation:c,leakyreluAlpha:d}=a;return va({a:r,b:o,transposeA:u,transposeB:l,backend:t,bias:i,preluActivationWeights:s,leakyreluAlpha:d,activation:c})}},$a="return abs(x);";const Ia={kernelName:n.Abs,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:a}=e,{x:r}=t;if(a.shouldExecuteOnCPU([r])&&"complex64"!==r.dtype){const e=a.texData.get(r.dataId),n=ot(e.values);return a.makeTensorInfo(r.shape,r.dtype,n)}let o;return o=n.env().getBool("WEBGL_PACK_UNARY_OPERATIONS")?new At(r.shape,$a):new Tt(r.shape,$a),a.runWebGLProgram(o,[r],r.dtype)}},ya=Qt({opSnippet:"if (isnan(x)) return x;\n  if (abs(x) > 1.) {\n    return NAN;\n  }\n  return acos(x);\n"}),ka={kernelName:n.Acos,backendName:"webgl",kernelFunc:ya},wa=Qt({opSnippet:"if (isnan(x)) return x;\n  if (x < 1.0) return NAN;\nreturn log(x + sqrt(x * x - 1.0));"}),Ra={kernelName:n.Acosh,backendName:"webgl",kernelFunc:wa},Sa="return a + b;",Ta=Zt({opSnippet:Sa,packedOpSnippet:Sa,supportsComplex:!0,cpuKernelImpl:Fn}),Ea={kernelName:n.Add,backendName:"webgl",kernelFunc:Ta};class Na{constructor(e,n){this.outputShape=[],this.outputShape=e,this.variableNames=n.map(((e,n)=>`T${n}`));const t=[];this.variableNames.forEach((e=>{t.push(`float v${e} = get${e}AtOutCoords();`)}));const a=this.variableNames.map((e=>`v${e}`)).join(" + ");this.userCode=`\n      void main() {\n        ${t.join("\n        ")}\n\n        float result = ${a};\n        setOutput(result);\n      }\n    `}}class Aa{constructor(e,n){this.outputShape=[],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=e,this.variableNames=n.map(((e,n)=>`T${n}`));const t=[];this.variableNames.forEach((e=>{t.push(`vec4 v${e} = get${e}AtOutCoords();`)}));const a=this.variableNames.map((e=>`v${e}`)).join(" + ");this.userCode=`\n      void main() {\n        ${t.join("\n        ")}\n\n        vec4 result = ${a};\n        setOutput(result);\n      }\n    `}}const Fa={kernelName:n.AddN,backendName:"webgl",kernelFunc:function e(t){const{inputs:a,backend:r}=t,o=a;if(1===o.length)return Ut({inputs:{x:o[0]},backend:r});if(o.length>n.env().get("WEBGL_MAX_TEXTURES_IN_SHADER")){const n=Math.floor(o.length/2),t=e({inputs:o.slice(0,n),backend:r}),a=e({inputs:o.slice(n),backend:r});return e({inputs:[t,a],backend:r})}const i=o.map((e=>e.dtype)).reduce(((e,t)=>n.upcastType(e,t))),s=o.map((e=>e.shape)),u=n.env().getBool("WEBGL_PACK")?new Aa(o[0].shape,s):new Na(o[0].shape,s);return r.runWebGLProgram(u,o,i)}};const _a={kernelName:n.All,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:a,attrs:r}=e,{x:o}=t,{axis:i,keepDims:s}=r,u=o.shape.length,l=n.util.parseAxisParam(i,o.shape);let c=l;const d=n.backend_util.getAxesPermutation(c,u);let p=o;null!=d&&(p=ga({inputs:{x:o},backend:a,attrs:{perm:d}}),c=n.backend_util.getInnerMostAxes(c.length,u)),n.backend_util.assertAxesAreInnerMostDims("all",c,u);const[h,f]=n.backend_util.computeOutAndReduceShapes(p.shape,c),x=sa({inputs:{x:p},backend:a,attrs:{shape:[-1,n.util.sizeFromShape(f)]}}),m=da(x,x.dtype,"all",a);let g;if(s){g=sa({inputs:{x:m},backend:a,attrs:{shape:n.backend_util.expandShapeToKeepDim(h,l)}})}else g=sa({inputs:{x:m},backend:a,attrs:{shape:h}});return a.disposeIntermediateTensorInfo(x),a.disposeIntermediateTensorInfo(m),null!=d&&a.disposeIntermediateTensorInfo(p),g}};const Oa={kernelName:n.Any,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:a,attrs:r}=e,{x:o}=t,{axis:i,keepDims:s}=r,u=o.shape.length,l=n.util.parseAxisParam(i,o.shape);let c=l;const d=n.backend_util.getAxesPermutation(c,u);let p=o;null!=d&&(p=ga({inputs:{x:o},backend:a,attrs:{perm:d}}),c=n.backend_util.getInnerMostAxes(c.length,u)),n.backend_util.assertAxesAreInnerMostDims("any",c,u);const[h,f]=n.backend_util.computeOutAndReduceShapes(p.shape,c),x=sa({inputs:{x:p},backend:a,attrs:{shape:[-1,n.util.sizeFromShape(f)]}}),m=da(x,x.dtype,"any",a);let g;if(s){g=sa({inputs:{x:m},backend:a,attrs:{shape:n.backend_util.expandShapeToKeepDim(h,l)}})}else g=sa({inputs:{x:m},backend:a,attrs:{shape:h}});return a.disposeIntermediateTensorInfo(x),a.disposeIntermediateTensorInfo(m),null!=d&&a.disposeIntermediateTensorInfo(p),g}};class Da{constructor(e,n,t){this.variableNames=["A"];const{windowSize:a,batchSize:r,outSize:o}=e;t||this.variableNames.push("bestIndicesA"),this.outputShape=[r,o];const i="max"===n?">":"<",s=t?"inOffset + i;":"round(getBestIndicesA(batch, inOffset + i));";this.userCode=`\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int batch = coords[0];\n        int outIdx = coords[1];\n        int inOffset = outIdx * ${a};\n\n        int bestIndex = inOffset;\n        float bestValue = getA(batch, bestIndex);\n\n        for (int i = 0; i < ${a}; i++) {\n          int inIdx = ${s};\n          float candidate = getA(batch, inIdx);\n          if (candidate ${i} bestValue) {\n            bestValue = candidate;\n            bestIndex = inIdx;\n          }\n        }\n        setOutput(float(bestIndex));\n      }\n    `}}class Pa{constructor(e,t,a,r){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,n.util.assert(e.length>2,(()=>`Packed arg${a.charAt(0).toUpperCase()+a.slice(1)} supports only inputs with rank above 2.`));const o=e[e.length-1],i=Math.ceil(o/t);this.outputShape=e.slice(0,-1),i>1&&this.outputShape.push(i),r||this.variableNames.push("bestIndicesA");const s=this.outputShape,u=s.length,l=Ie(u),c=$t("coords",u);let d,p;if(1===i){p=u+1;const e=Ie(p);d=`\n        ${e} sourceLocR = ${e}(${c.join()}, 0);\n        ++${c[u-1]};\n        ${e} sourceLocG = ${e}(${c.join()}, 0);\n        ++${c[u-2]};\n        ${e} sourceLocA = ${e}(${c.join()}, 0);\n        --${c[u-1]};\n        ${e} sourceLocB = ${e}(${c.join()}, 0);\n        --${c[u-2]};`}else p=u,d=`\n        ${l} sourceLocR = coords;\n        ++${c[u-1]};\n        ${l} sourceLocG = coords;\n        ++${c[u-2]};\n        ${l} sourceLocA = coords;\n        --${c[u-1]};\n        ${l} sourceLocB = coords;\n        --${c[u-2]};`;const h=["x","y","z","w","u","v"].slice(0,p),f="."+h[p-1],x=h.map((e=>"int "+e)),m=$t("sourceLocR",p-1).concat("inIdx.r"),g=$t("sourceLocG",p-1).concat("inIdx.g"),b=$t("sourceLocB",p-1).concat("inIdx.b"),v=$t("sourceLocA",p-1).concat("inIdx.a"),C="max"===a?"greaterThan":"lessThan",$=r?"":`\n          inIdx = round(vec4(getBestIndicesAChannel(${m.join()}),\n                             getBestIndicesAChannel(${g.join()}),\n                             getBestIndicesAChannel(${b.join()}),\n                             getBestIndicesAChannel(${v.join()})));`,I=`vec4(\n            getAChannel(${m.join()}),\n            hasNextCol ? getAChannel(${g.join()}) : 0.,\n            hasNextRow ? getAChannel(${b.join()}) : 0.,\n            hasNextRow && hasNextCol ? getAChannel(${v.join()}) : 0.)`,y=r?"":`\n      float getBestIndicesAChannel(${x.join()}) {\n        return getChannel(getBestIndicesA(${h.join()}),\n                                          vec2(${h.slice(-2).join()}));\n      }`;this.userCode=`\n      float getAChannel(${x.join()}) {\n        return getChannel(getA(${h.join()}),\n                               vec2(${h.slice(-2).join()}));\n      }\n      ${y}\n      void main() {\n        ${l} coords = getOutputCoords();\n        bool hasNextCol = ${c[u-1]} < ${s[u-1]-1};\n        bool hasNextRow = ${c[u-2]} < ${s[u-2]-1};\n        ${d}\n        ivec4 srcIdx = ivec4(sourceLocR${f}, sourceLocG${f},\n          sourceLocB${f}, sourceLocA${f}) * ${t};\n        ivec4 inIdx = srcIdx;\n        vec4 bestIndex = vec4(inIdx);\n        vec4 bestValue = ${I};\n\n        for (int i = 0; i < ${t}; i++) {\n          inIdx = srcIdx;\n          ${$}\n          vec4 candidate = ${I};\n          bvec4 nan = isnan(candidate);\n          bvec4 replace = bvec4(\n            vec4(${C}(candidate, bestValue)) * (vec4(1.0) - vec4(nan)));\n\n          bestValue = vec4(replace.x  ? candidate.x : bestValue.x,\n                           replace.y  ? candidate.y : bestValue.y,\n                           replace.z  ? candidate.z : bestValue.z,\n                           replace.w  ? candidate.w : bestValue.w);\n          bestIndex = mix(bestIndex, vec4(inIdx), vec4(replace));\n          srcIdx++;\n        }\n        setOutput(bestIndex);\n      }\n    `}}function La(e,t,a,r=null){let o=t.shape[0],i=t.shape[1];null!=r&&(o=r.shape[0],i=r.shape[1]);const s=n.backend_util.computeOptimalWindowSize(i),u={windowSize:s,inSize:i,batchSize:o,outSize:Math.ceil(i/s)},l=new Da(u,a,null==r),c=[t];null!=r&&c.push(r);const d=e.runWebGLProgram(l,c,"int32");if(1===d.shape[1])return d;const p=La(e,t,a,d);return e.disposeIntermediateTensorInfo(d),p}function Ba(e,t,a,r=null){const o=null!=r?r.shape:t.shape,i=o[o.length-1],s=n.backend_util.computeOptimalWindowSize(i),u=new Pa(o,s,a,null==r),l=null==r?[t]:[t,r],c=e.runWebGLProgram(u,l,"int32");if(c.shape.length===t.shape.length){const n=Ba(e,t,a,c);return e.disposeIntermediateTensorInfo(c),n}return c}function Va(e,t,a,r){const o=[a];if(n.backend_util.assertAxesAreInnerMostDims("arg"+r.charAt(0).toUpperCase()+r.slice(1),o,t.shape.length),!n.env().getBool("WEBGL_PACK_REDUCE")||t.shape.length<=2){const a=[],i=e.texData.get(t.dataId);let s=t;null!==i&&i.isPacked&&(s=e.unpackTensor(t),a.push(s));const[u,l]=n.backend_util.computeOutAndReduceShapes(s.shape,o),c=n.util.sizeFromShape(l),d=sa({inputs:{x:s},backend:e,attrs:{shape:[-1,c]}});a.push(d);const p=La(e,d,r);a.push(p);const h=sa({inputs:{x:p},backend:e,attrs:{shape:u}});return a.forEach((n=>e.disposeIntermediateTensorInfo(n))),h}return Ba(e,t,r)}const Wa={kernelName:n.ArgMax,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:a,attrs:r}=e,{x:o}=t,{axis:i}=r;let s=n.util.parseAxisParam(i,o.shape);const u=n.backend_util.getAxesPermutation(s,o.shape.length);let l=o;const c=[];null!=u&&(l=ga({inputs:{x:o},backend:a,attrs:{perm:u}}),c.push(l),s=n.backend_util.getInnerMostAxes(s.length,l.shape.length)),n.backend_util.assertAxesAreInnerMostDims("argMax",[s[0]],l.shape.length);const d=Va(a,l,s[0],"max");return c.forEach((e=>a.disposeIntermediateTensorInfo(e))),d}};const Ua={kernelName:n.ArgMin,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:a,attrs:r}=e,{x:o}=t,{axis:i}=r;let s=n.util.parseAxisParam(i,o.shape);const u=n.backend_util.getAxesPermutation(s,o.shape.length);let l=o;const c=[];null!=u&&(l=ga({inputs:{x:o},backend:a,attrs:{perm:u}}),c.push(l),s=n.backend_util.getInnerMostAxes(s.length,l.shape.length)),n.backend_util.assertAxesAreInnerMostDims("argMin",[s[0]],l.shape.length);const d=Va(a,l,s[0],"min");return c.forEach((e=>a.disposeIntermediateTensorInfo(e))),d}},Ma=Qt({opSnippet:"if (isnan(x)) return x;\n  if (abs(x) > 1.) {\n    return NAN;\n  }\n  return asin(x);\n"}),Ga={kernelName:n.Asin,backendName:"webgl",kernelFunc:Ma},za=Qt({opSnippet:"if (isnan(x)) return x;return log(x + sqrt(x * x + 1.0));"}),Xa={kernelName:n.Asinh,backendName:"webgl",kernelFunc:za},Ha=Qt({opSnippet:"if (isnan(x)) return x;\n  return atan(x);\n"}),ja={kernelName:n.Atan,backendName:"webgl",kernelFunc:Ha},Ka=Zt({opSnippet:"\n  if (isnan(a)) return a;\n  if (isnan(b)) return b;\n\n  return atan(a, b);\n",packedOpSnippet:"\n  vec4 result = atan(a, b);\n  vec4 isNaN = min(vec4(isnan(a)) + vec4(isnan(b)), vec4(1.0));\n  \n  result.r = isNaN.r > 0. ? NAN : result.r;\n  result.g = isNaN.g > 0. ? NAN : result.g;\n  result.b = isNaN.b > 0. ? NAN : result.b;\n  result.a = isNaN.a > 0. ? NAN : result.a;\n\n  return result;\n"}),qa={kernelName:n.Atan2,backendName:"webgl",kernelFunc:Ka},Ya=Qt({opSnippet:"if (isnan(x)) return x;\n  if ((x < -1.0) || (x > 1.0)) return NAN;\nreturn (log(1.0 + x) - log(1.0 - x)) / 2.0;"}),Qa={kernelName:n.Atanh,backendName:"webgl",kernelFunc:Ya};class Za{constructor(e,n,t,a=!1,r=!1){if(this.variableNames=["x"],"avg"===n&&t)throw new Error("Cannot compute positions for average pool.");const o=e.filterWidth,i=e.strideHeight,s=e.strideWidth,u=e.dilationHeight,l=e.dilationWidth,c=e.effectiveFilterHeight,d=e.effectiveFilterWidth,p=e.padInfo.top,h=e.padInfo.left;this.outputShape=e.outShape;const f="avg"===n,x=`((batch  * ${e.inHeight} + xR) * ${e.inWidth} + xC) * ${e.inChannels} + d`,m=`(xR * ${e.inWidth} + xC) * ${e.inChannels} + d`;let g="0.0";if(f||(g="-1.0 / 1e-20"),t){const n=">=";return void(this.userCode=`\n        const ivec2 strides = ivec2(${i}, ${s});\n        const ivec2 pads = ivec2(${p}, ${h});\n\n        void main() {\n          ivec4 coords = getOutputCoords();\n          int batch = coords[0];\n          int d = coords[3];\n\n          ivec2 xRCCorner = coords.yz * strides - pads;\n          int xRCorner = xRCCorner.x;\n          int xCCorner = xRCCorner.y;\n\n          // max/min x(?, ?, d) to get y(yR, yC, d).\n          // ? = to be determined\n          float minMaxValue = 0.0;\n          float minMaxValueFound = 0.0;\n          int minMaxPosition = 0;\n          float avgValue = 0.0;\n\n          for (int wR = 0; wR < ${c};\n              wR += ${u}) {\n            int xR = xRCorner + wR;\n\n            if (xR < 0 || xR >= ${e.inHeight}) {\n              continue;\n            }\n\n            for (int wC = 0; wC < ${d};\n                wC += ${l}) {\n              int xC = xCCorner + wC;\n\n              if (xC < 0 || xC >= ${e.inWidth}) {\n                continue;\n              }\n\n              float value = getX(batch, xR, xC, d);\n\n              // If a min / max value has already been found, use it. If not,\n              // use the current value.\n              float currMinMaxValue = mix(\n                  value, minMaxValue, minMaxValueFound);\n              if (value ${n} currMinMaxValue) {\n                minMaxValue = value;\n                minMaxValueFound = 1.0;\n                minMaxPosition = ${a?r?x:m:`wR * ${d} + wC`};\n              }\n            }\n          }\n          setOutput(float(minMaxPosition));\n        }\n      `)}let b=`${n}(${n}(${n}(minMaxValue[0], minMaxValue[1]), minMaxValue[2]), minMaxValue[3])`;"avg"===n&&(b="avgValue / count");const v=4*Math.floor(o/4),C=o%4,$=`\n      if (${f}) {\n        avgValue += dot(values, ones);\n      } else {\n        minMaxValue = max(values, minMaxValue);\n      }\n    `;this.userCode=`\n      const ivec2 strides = ivec2(${i}, ${s});\n      const ivec2 pads = ivec2(${p}, ${h});\n      const float initializationValue = ${g};\n      const vec4 ones = vec4(1.0, 1.0, 1.0, 1.0);\n\n      float count = 0.0;\n\n      float getValue(int batch, int xR, int xC, int d) {\n        if (xC < 0 || xC >= ${e.inWidth}) {\n          return initializationValue;\n        }\n        count += 1.0;\n        return getX(batch, xR, xC, d);\n      }\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords[0];\n        int d = coords[3];\n\n        ivec2 xRCCorner = coords.yz * strides - pads;\n        int xRCorner = xRCCorner.x;\n        int xCCorner = xRCCorner.y;\n\n        // max/min x(?, ?, d) to get y(yR, yC, d).\n        // ? = to be determined\n        vec4 minMaxValue = vec4(${g});\n        float avgValue = 0.0;\n        count = 0.0;\n\n        for (int wR = 0; wR < ${c};\n            wR += ${u}) {\n          int xR = xRCorner + wR;\n\n          if (xR < 0 || xR >= ${e.inHeight}) {\n            continue;\n          }\n\n          for (int wC = 0; wC < ${v}; wC += 4) {\n            int xC = xCCorner + wC * ${l};\n\n            vec4 values = vec4(\n              getValue(batch, xR, xC, d),\n              getValue(batch, xR, xC + ${l}, d),\n              getValue(batch, xR, xC + 2 * ${l}, d),\n              getValue(batch, xR, xC + 3 * ${l}, d)\n            );\n\n            ${$}\n          }\n\n          int xC = xCCorner + ${v};\n          if (${1===C}) {\n            vec4 values = vec4(\n              getValue(batch, xR, xC, d),\n              initializationValue,\n              initializationValue,\n              initializationValue\n            );\n\n            ${$}\n          } else if (${2===C}) {\n            vec4 values = vec4(\n              getValue(batch, xR, xC, d),\n              getValue(batch, xR, xC + ${l}, d),\n              initializationValue,\n              initializationValue\n            );\n\n            ${$}\n          } else if (${3===C}) {\n            vec4 values = vec4(\n              getValue(batch, xR, xC, d),\n              getValue(batch, xR, xC + ${l}, d),\n              getValue(batch, xR, xC + 2 * ${l}, d),\n              initializationValue\n            );\n\n            ${$}\n          }\n        }\n        setOutput(${b});\n      }\n    `}}class Ja{constructor(e,n,t,a=!1,r=!1){if(this.variableNames=["x"],"avg"===n&&t)throw new Error("Cannot compute positions for average pool.");const o=e.filterWidth,i=e.strideDepth,s=e.strideHeight,u=e.strideWidth,l=e.dilationDepth,c=e.dilationHeight,d=e.dilationWidth,p=e.effectiveFilterDepth,h=e.effectiveFilterHeight,f=e.effectiveFilterWidth,x=e.padInfo.front,m=e.padInfo.top,g=e.padInfo.left;this.outputShape=e.outShape;const b="avg"===n;let v="0.0";if(b||(v="-1.0 / 1e-20"),t){const n=">=";return void(this.userCode=`\n        const ivec3 strides =\n            ivec3(${i}, ${s}, ${u});\n        const ivec3 pads = ivec3(${x}, ${m}, ${g});\n\n        void main() {\n          ivec5 coords = getOutputCoords();\n          int batch = coords.x;\n          int ch = coords.u;\n\n          ivec3 xCorner = ivec3(coords.y, coords.z, coords.w) * strides - pads;\n          int xDCorner = xCorner.x;\n          int xRCorner = xCorner.y;\n          int xCCorner = xCorner.z;\n\n          // max/min x(?, ?, ?, ch) to get y(yD, yR, yC, ch).\n          // ? = to be determined\n          float minMaxValue = 0.0;\n          float minMaxValueFound = 0.0;\n          int minMaxPosition = 0;\n\n          for (int wD = 0; wD < ${p};\n              wD += ${l}) {\n            int xD = xDCorner + wD;\n\n            if (xD < 0 || xD >= ${e.inDepth}) {\n              continue;\n            }\n\n            for (int wR = 0; wR < ${h};\n                wR += ${c}) {\n              int xR = xRCorner + wR;\n\n              if (xR < 0 || xR >= ${e.inHeight}) {\n                continue;\n              }\n\n              for (int wC = 0; wC < ${f};\n                  wC += ${d}) {\n                int xC = xCCorner + wC;\n\n                if (xC < 0 || xC >= ${e.inWidth}) {\n                  continue;\n                }\n\n                float value = getX(batch, xD, xR, xC, ch);\n\n                // If a min / max value has already been found, use it. If not,\n                // use the current value.\n                float currMinMaxValue = mix(\n                    value, minMaxValue, minMaxValueFound);\n                if (value ${n} currMinMaxValue) {\n                  minMaxValue = value;\n                  minMaxValueFound = 1.0;\n                  minMaxPosition = ${a?r?`(((batch * ${e.inDepth} + xD) * ${e.inHeight} + xR) * ${e.inWidth} + xC) * ${e.inChannels} + ch`:`((xD * ${e.inHeight} + xR) * ${e.inWidth} + xC) * ${e.inChannels} + ch`:`wD * ${h} * ${f} +\n                      wR * ${f} + wC`};\n                }\n              }\n            }\n          }\n          setOutput(float(minMaxPosition));\n        }\n      `)}let C=`${n}(${n}(${n}(minMaxValue[0], minMaxValue[1]), minMaxValue[2]), minMaxValue[3])`;"avg"===n&&(C="avgValue / count");const $=4*Math.floor(o/4),I=o%4,y=`\n      if (${b}) {\n        avgValue += dot(values, ones);\n      } else {\n        minMaxValue = max(values, minMaxValue);\n      }\n    `;this.userCode=`\n      const ivec3 strides =\n        ivec3(${i}, ${s}, ${u});\n      const ivec3 pads = ivec3(${x}, ${m}, ${g});\n      const float initializationValue = ${v};\n      const vec4 ones = vec4(1.0, 1.0, 1.0, 1.0);\n\n      float count = 0.0;\n\n      float getValue(int batch, int xD, int xR, int xC, int ch) {\n        if (xC < 0 || xC >= ${e.inWidth}) {\n          return initializationValue;\n        }\n        count += 1.0;\n        return getX(batch, xD, xR, xC, ch);\n      }\n\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int batch = coords.x;\n        int ch = coords.u;\n\n        ivec3 xCorner = ivec3(coords.y, coords.z, coords.w) * strides - pads;\n        int xDCorner = xCorner.x;\n        int xRCorner = xCorner.y;\n        int xCCorner = xCorner.z;\n\n        // max/min x(?, ?, ?, d) to get y(yD, yR, yC, ch).\n        // ? = to be determined\n        vec4 minMaxValue = vec4(${v});\n        float avgValue = 0.0;\n        count = 0.0;\n\n        for (int wD = 0; wD < ${p};\n            wD += ${l}) {\n          int xD = xDCorner + wD;\n\n          if (xD < 0 || xD >= ${e.inDepth}) {\n            continue;\n          }\n\n          for (int wR = 0; wR < ${h};\n            wR += ${c}) {\n            int xR = xRCorner + wR;\n\n            if (xR < 0 || xR >= ${e.inHeight}) {\n              continue;\n            }\n\n            for (int wC = 0; wC < ${$}; wC += 4) {\n              int xC = xCCorner + wC * ${d};\n\n              vec4 values = vec4(\n                getValue(batch, xD, xR, xC, ch),\n                getValue(batch, xD, xR, xC + ${d}, ch),\n                getValue(batch, xD, xR, xC + 2 * ${d}, ch),\n                getValue(batch, xD, xR, xC + 3 * ${d}, ch)\n              );\n\n              ${y}\n            }\n\n            int xC = xCCorner + ${$};\n            if (${1===I}) {\n              vec4 values = vec4(\n                getValue(batch, xD, xR, xC, ch),\n                initializationValue,\n                initializationValue,\n                initializationValue\n              );\n\n              ${y}\n            } else if (${2===I}) {\n              vec4 values = vec4(\n                getValue(batch, xD, xR, xC, ch),\n                getValue(batch, xD, xR, xC + ${d}, ch),\n                initializationValue,\n                initializationValue\n              );\n\n              ${y}\n            } else if (${3===I}) {\n              vec4 values = vec4(\n                getValue(batch, xD, xR, xC, ch),\n                getValue(batch, xD, xR, xC + ${d}, ch),\n                getValue(batch, xD, xR, xC + 2 * ${d}, ch),\n                initializationValue\n              );\n\n              ${y}\n            }\n          }\n          setOutput(${C});\n        }\n      }\n    `}}const er={kernelName:n.AvgPool,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:a,attrs:r}=e,{x:o}=t;te(o,"avgPool");const{filterSize:i,strides:s,pad:u,dimRoundingMode:l}=r;n.util.assert(n.backend_util.eitherStridesOrDilationsAreOne(s,1),(()=>`Error in avgPool: Either strides or dilations must be 1. Got strides ${s} and dilations '1'`));const c=n.backend_util.computePool2DInfo(o.shape,i,s,1,u,l);if(1===c.filterWidth&&1===c.filterHeight&&n.util.arraysEqual(c.inShape,c.outShape))return Ut({inputs:{x:o},backend:a});const d=new Za(c,"avg",!1);return a.runWebGLProgram(d,[o],"float32")}};const nr={kernelName:n.AvgPool3D,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:a,attrs:r}=e,{x:o}=t,{filterSize:i,strides:s,pad:u,dimRoundingMode:l,dataFormat:c}=r,d=n.backend_util.computePool3DInfo(o.shape,i,s,[1,1,1],u,l,c),p=new Ja(d,"avg",!1);return a.runWebGLProgram(p,[o],"float32")}};class tr{constructor(e){this.variableNames=["dy"],this.outputShape=e.inShape;const n=e.filterHeight,t=e.filterWidth,a=e.strideHeight,r=e.strideWidth,o=e.dilationHeight,i=e.dilationWidth,s=e.effectiveFilterHeight,u=e.effectiveFilterWidth,l=s-1-e.padInfo.top,c=u-1-e.padInfo.left,d=1/(n*t);this.userCode=`\n      const ivec2 pads = ivec2(${l}, ${c});\n      const float avgMultiplier = float(${d});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n\n        ivec2 dyRCCorner = coords.yz - pads;\n        int dyRCorner = dyRCCorner.x;\n        int dyCCorner = dyRCCorner.y;\n\n        // Convolve dy(?, ?, d) with pos mask(:, :, d) to get dx(xR, xC, d).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n        for (int wR = 0; wR < ${s};\n            wR += ${o}) {\n          float dyR = float(dyRCorner + wR) / ${a}.0;\n\n          if (dyR < 0.0 || dyR >= ${e.outHeight}.0 || fract(dyR) > 0.0) {\n            continue;\n          }\n          int idyR = int(dyR);\n\n          for (int wC = 0; wC < ${u};\n            wC+= ${i}) {\n            float dyC = float(dyCCorner + wC) / ${r}.0;\n\n            if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                fract(dyC) > 0.0) {\n              continue;\n            }\n            int idyC = int(dyC);\n\n            float dyValue = getDy(b, idyR, idyC, d);\n\n            dotProd += dyValue * avgMultiplier;\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class ar{constructor(e){this.variableNames=["dy"],this.outputShape=e.inShape;const n=e.filterDepth,t=e.filterHeight,a=e.filterWidth,r=e.strideDepth,o=e.strideHeight,i=e.strideWidth,s=e.dilationDepth,u=e.dilationHeight,l=e.dilationWidth,c=e.effectiveFilterDepth,d=e.effectiveFilterHeight,p=e.effectiveFilterWidth,h=c-1-e.padInfo.front,f=d-1-e.padInfo.top,x=p-1-e.padInfo.left,m=1/(n*t*a);this.userCode=`\n      const ivec3 pads = ivec3(${h}, ${f}, ${x});\n      const float avgMultiplier = float(${m});\n\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int batch = coords.x;\n        int ch = coords.u;\n\n        ivec3 dyCorner = ivec3(coords.y, coords.z, coords.w) - pads;\n        int dyDCorner = dyCorner.x;\n        int dyRCorner = dyCorner.y;\n        int dyCCorner = dyCorner.z;\n\n        // Convolve dy(?, ?, ?, d) with pos mask(:, :, :, ch) to get\n        // dx(xD, xR, xC, ch).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n\n        for (int wD = 0; wD < ${c};\n            wD += ${s}) {\n          float dyD = float(dyDCorner + wD) / ${r}.0;\n\n          if (dyD < 0.0 || dyD >= ${e.outDepth}.0 || fract(dyD) > 0.0) {\n            continue;\n          }\n          int idyD = int(dyD);\n\n          for (int wR = 0; wR < ${d};\n              wR += ${u}) {\n            float dyR = float(dyRCorner + wR) / ${o}.0;\n\n            if (dyR < 0.0 || dyR >= ${e.outHeight}.0 ||\n                fract(dyR) > 0.0) {\n              continue;\n            }\n            int idyR = int(dyR);\n\n            for (int wC = 0; wC < ${p};\n                wC += ${l}) {\n              float dyC = float(dyCCorner + wC) / ${i}.0;\n\n              if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                  fract(dyC) > 0.0) {\n                continue;\n              }\n              int idyC = int(dyC);\n\n              float dyValue = getDy(batch, idyD, idyR, idyC, ch);\n\n              dotProd += dyValue * avgMultiplier;\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}const rr={kernelName:n.AvgPool3DGrad,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:a,attrs:r}=e,{dy:o,input:i}=t,s=i,{filterSize:u,strides:l,pad:c,dimRoundingMode:d}=r,p=n.backend_util.computePool3DInfo(s.shape,u,l,[1,1,1],c,d),h=new ar(p);return a.runWebGLProgram(h,[o],s.dtype)}};const or={kernelName:n.AvgPoolGrad,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:a,attrs:r}=e,{dy:o,input:i}=t,s=i;te([o,i],"avgPoolGrad");const{filterSize:u,strides:l,pad:c}=r,d=n.backend_util.computePool2DInfo(s.shape,u,l,1,c),p=new tr(d);return a.runWebGLProgram(p,[o],s.dtype)}};const ir={kernelName:n.BatchMatMul,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t,attrs:a}=e,{a:r,b:o}=n,{transposeA:i,transposeB:s}=a;return va({a:r,b:o,transposeA:i,transposeB:s,backend:t})}};class sr{constructor(e,t,a,r,o,i){this.outputShape=[],this.variableNames=["x","mean","variance"],n.backend_util.assertAndGetBroadcastShape(e,t),n.backend_util.assertAndGetBroadcastShape(e,a);let s="0.0";null!=r&&(n.backend_util.assertAndGetBroadcastShape(e,r),this.variableNames.push("offset"),s="getOffsetAtOutCoords()");let u="1.0";null!=o&&(n.backend_util.assertAndGetBroadcastShape(e,o),this.variableNames.push("scale"),u="getScaleAtOutCoords()"),this.outputShape=e,this.userCode=`\n      void main() {\n        float x = getXAtOutCoords();\n        float mean = getMeanAtOutCoords();\n        float variance = getVarianceAtOutCoords();\n        float offset = ${s};\n        float scale = ${u};\n        float inv = scale * inversesqrt(variance + float(${i}));\n        setOutput(dot(vec3(x, -mean, offset), vec3(inv, inv, 1)));\n      }\n    `}}class ur{constructor(e,t,a,r,o,i){this.packedInputs=!0,this.packedOutput=!0,this.variableNames=["x","mean","variance"],n.backend_util.assertAndGetBroadcastShape(e,t),n.backend_util.assertAndGetBroadcastShape(e,a);let s="vec4(0.0)";null!=r&&(n.backend_util.assertAndGetBroadcastShape(e,r),this.variableNames.push("offset"),s="getOffsetAtOutCoords()");let u="vec4(1.0)";null!=o&&(n.backend_util.assertAndGetBroadcastShape(e,o),this.variableNames.push("scale"),u="getScaleAtOutCoords()"),this.outputShape=e,this.userCode=`\n      void main() {\n        vec4 offset = ${s};\n        vec4 scale = ${u};\n\n        vec4 x = getXAtOutCoords();\n        vec4 mean = getMeanAtOutCoords();\n        vec4 variance = getVarianceAtOutCoords();\n\n        vec4 inv = scale * inversesqrt(variance + vec4(${i}));\n\n        setOutput((x - mean) * inv + offset);\n      }\n    `}}const lr={kernelName:n.FusedBatchNorm,backendName:"webgl",kernelFunc:({inputs:e,backend:t,attrs:a})=>{const{x:r,mean:o,variance:i,offset:s,scale:u}=e;n.util.assert(o.shape.length===i.shape.length,(()=>"Batch normalization gradient requires mean and variance to have equal ranks.")),n.util.assert(null==s||o.shape.length===s.shape.length,(()=>"Batch normalization gradient requires mean and offset to have equal ranks.")),n.util.assert(null==u||o.shape.length===u.shape.length,(()=>"Batch normalization gradient requires mean and scale to have equal ranks."));let{varianceEpsilon:l}=a;null==l&&(l=.001);const c=[r,o,i];let d=null;null!=s&&(d=s.shape,c.push(s));let p=null;null!=u&&(p=u.shape,c.push(u));const h=n.env().getBool("WEBGL_PACK_NORMALIZATION")?new ur(r.shape,o.shape,i.shape,d,p,l):new sr(r.shape,o.shape,i.shape,d,p,l);return t.runWebGLProgram(h,c,c[0].dtype)}};class cr{constructor(e){this.variableNames=["source"],this.outputShape=e,this.rank=e.length;const n=Ie(this.rank);this.customUniforms=[{name:"start",arrayIndex:this.rank,type:"int"}];const t=function(e){if(1===e)return"sourceLoc";if(e<=6)return dr.slice(0,e).map((e=>"sourceLoc."+e)).join(",");throw Error(`Slicing for rank ${e} is not yet supported`)}(this.rank);let a;a=`\n        ${n} sourceLoc;\n        ${n} coords = getOutputCoords();\n        ${e.map(((e,n)=>`sourceLoc.${dr[n]} = start[${n}] + coords.${dr[n]};`)).join("\n")}\n      `,this.userCode=`\n      void main() {\n        ${a}\n        setOutput(getSource(${t}));\n      }\n    `}}const dr=["x","y","z","w","u","v"];class pr{constructor(e){this.variableNames=["source"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=e,this.rank=e.length,this.customUniforms=[{name:"start",arrayIndex:this.rank,type:"int"}];const n=Ie(this.rank),t=$t("coords",this.rank),a=$t("sourceLoc",this.rank),r=1===this.rank?"sourceLoc":`vec2(${a.slice(-2).join()})`,o=`getChannel(getSource(${a.join()}), ${r})`,i=`\n      result.x = ${o};\n      if (++${t[this.rank-1]} < ${e[this.rank-1]}) {\n        ++${a[this.rank-1]};\n        result.y = ${o};\n        --${a[this.rank-1]};\n      }\n    `,s=1===this.rank?"":`\n      --${t[this.rank-1]};\n      if (++${t[this.rank-2]} < ${e[this.rank-2]}) {\n        ++${a[this.rank-2]};\n        result.z = ${o};\n        if (++${t[this.rank-1]} < ${e[this.rank-1]}) {\n          ++${a[this.rank-1]};\n          result.w = ${o};\n        }\n      }\n    `,u=this.rank<=4?`sourceLoc = coords +\n            ${n}(${e.map(((e,n)=>`start[${n}]`)).join()});`:e.map(((e,n)=>`${a[n]} = ${t[n]} + start[${n}];`)).join("\n");this.userCode=`\n      void main() {\n        ${n} coords = getOutputCoords();\n        ${n} sourceLoc;\n        ${u}\n        vec4 result = vec4(0.);\n        ${i}\n        ${s}\n        setOutput(result);\n      }\n    `}}function hr(e){const{inputs:t,backend:a,attrs:r}=e,{x:o}=t,{begin:i,size:s}=r,[u,l]=n.slice_util.parseSliceParams(o,i,s);if(n.slice_util.assertParamsValid(o,u,l),0===n.util.sizeFromShape(l))return a.makeTensorInfo(l,o.dtype,[]);if(a.shouldExecuteOnCPU([o])||"string"===o.dtype){const e=a.texData.get(o.dataId),n=it(e.values,u,l,o.shape,o.dtype);return a.makeTensorInfo(l,o.dtype,n)}const{isPacked:c}=a.texData.get(o.dataId),d=n.slice_util.isSliceContinous(o.shape,u,l);if(c||!d){const e=n.env().getBool("WEBGL_PACK_ARRAY_OPERATIONS")?new pr(l):new cr(l),t=[u];return a.runWebGLProgram(e,[o],o.dtype,t)}return a.uploadToGPU(o.dataId),function(e,t,a,r){const o=r.texData.get(e.dataId),i=r.makeTensorInfo(a,e.dtype),s=r.texData.get(i.dataId);Object.assign(s,o),s.refCount=1,s.shape=a,s.dtype=e.dtype;let u=n.slice_util.computeFlatOffset(t,n.util.computeStrides(e.shape));o.slice&&(u+=o.slice.flatOffset),s.slice={flatOffset:u,origDataId:o.slice&&o.slice.origDataId||e.dataId};const l=r.dataRefCount.get(s.slice.origDataId)||1;return r.dataRefCount.set(s.slice.origDataId,l+1),i}(o,u,l,a)}const fr={kernelName:n.Slice,backendName:"webgl",kernelFunc:hr},xr={kernelName:n.BatchToSpaceND,backendName:"webgl",kernelFunc:e=>{const{inputs:t,backend:a,attrs:r}=e,{x:o}=t,{blockShape:i,crops:s}=r;n.util.assert(o.shape.length<=4,(()=>"batchToSpaceND for rank > 4 with a WebGL backend not implemented yet"));const u=i.reduce(((e,n)=>e*n)),l=n.backend_util.getReshaped(o.shape,i,u),c=n.backend_util.getPermuted(l.length,i.length),d=n.backend_util.getReshapedPermuted(o.shape,i,u),p=n.backend_util.getSliceBeginCoords(s,i.length),h=n.backend_util.getSliceSize(d,s,i.length),f=[],x=sa({inputs:{x:o},backend:a,attrs:{shape:l}}),m=ga({inputs:{x:x},backend:a,attrs:{perm:c}}),g=sa({inputs:{x:m},backend:a,attrs:{shape:d}}),b=hr({inputs:{x:g},backend:a,attrs:{begin:p,size:h}});return f.push(x),f.push(m),f.push(g),f.forEach((e=>a.disposeIntermediateTensorInfo(e))),b}};const mr={kernelName:n.Bincount,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t,attrs:a}=e,{x:r,weights:o}=n,{size:i}=a,s=t.readSync(r.dataId),u=t.readSync(o.dataId),l=_n(s,u,o.dtype,o.shape,i);return t.makeTensorInfo([i],o.dtype,l)}},gr=Zt({opSnippet:"return float(a != b);",cpuKernelImpl:et,dtype:"bool"}),br={kernelName:n.NotEqual,backendName:"webgl",kernelFunc:gr};function vr(e){const{inputs:n,backend:t}=e,{input:a}=n;return Ut({inputs:{x:t.texData.get(a.dataId).complexTensorInfos.real},backend:t})}const Cr={kernelName:n.Real,backendName:"webgl",kernelFunc:vr};const $r={kernelName:n.Cast,backendName:"webgl",kernelFunc:function e(t){const{inputs:a,backend:r,attrs:o}=t,{x:i}=a,{dtype:s}=o;if("complex64"===s){if("complex64"===i.dtype)return Ut({inputs:{x:i},backend:r});const t=n.zeros(i.shape),a=e({inputs:{x:i},backend:r,attrs:{dtype:"float32"}}),o=Gt({inputs:{real:a,imag:t},backend:r});return t.dispose(),r.disposeIntermediateTensorInfo(a),o}if("complex64"===i.dtype){const n=vr({inputs:{input:i},backend:r}),t=e({inputs:{x:n},backend:r,attrs:{dtype:s}});return r.disposeIntermediateTensorInfo(n),t}if(!n.util.hasEncodingLoss(i.dtype,s)){const e=Ut({inputs:{x:i},backend:r});return{dataId:e.dataId,shape:e.shape,dtype:s}}if("int32"===s)return function(e,n){const t=new Tt(e.shape,"return float(int(x));"),a=n.runWebGLProgram(t,[e],"int32");return{dataId:a.dataId,shape:a.shape,dtype:a.dtype}}(i,r);if("bool"===s){const e=r.makeTensorInfo([],"bool",n.util.getTypedArrayFromDType("bool",1)),t=gr({inputs:{a:i,b:e},backend:r});return r.disposeIntermediateTensorInfo(e),t}throw new Error(`Error in Cast: failed to cast ${i.dtype} to ${s}`)}},Ir="return ceil(x);",yr=Qt({opSnippet:Ir,packedOpSnippet:Ir,cpuKernelImpl:Dn}),kr={kernelName:n.Ceil,backendName:"webgl",kernelFunc:yr};class wr{constructor(e){this.variableNames=["A"],this.customUniforms=[{name:"minVal",type:"float"},{name:"maxVal",type:"float"}],this.outputShape=e,this.userCode="\n\n      void main() {\n        float value = getAAtOutCoords();\n        if (isnan(value)) {\n          setOutput(value);\n          return;\n        }\n\n        setOutput(clamp(value, minVal, maxVal));\n      }\n    "}}class Rr{constructor(e){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.customUniforms=[{name:"minVal",type:"float"},{name:"maxVal",type:"float"}],this.outputShape=e,this.userCode="\n      void main() {\n        vec4 value = getAAtOutCoords();\n\n        if (any(isnan(value))) {\n          setOutput(value);\n          return;\n        }\n\n        setOutput(clamp(value, vec4(minVal), vec4(maxVal)));\n      }\n    "}}const Sr={kernelName:n.ClipByValue,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:a,attrs:r}=e,{x:o}=t,{clipValueMin:i,clipValueMax:s}=r;let u;u=n.env().getBool("WEBGL_PACK_CLIP")?new Rr(o.shape):new wr(o.shape);const l=[[i],[s]];return a.runWebGLProgram(u,[o],o.dtype,l)}};class Tr{constructor(e){this.variableNames=["real","imag"],this.outputShape=e,this.userCode="\n      void main() {\n        float re = abs(getRealAtOutCoords());\n        float im = abs(getImagAtOutCoords());\n        float mx = max(re, im);\n\n        // sadly the length function in glsl is not underflow-safe\n        // (at least not on Intel GPUs). So the safe solution is\n        // to ensure underflow-safety in all cases.\n        setOutput(\n          mx == 0.0 ? 0.0 : mx * length(vec2(1, min(re, im)/mx))\n        );\n      }\n    "}}function Er(e,n){return{dataId:n.dataId,dtype:n.dtype,shape:e.shape}}const Nr={kernelName:n.ComplexAbs,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t}=e,{x:a}=n,r=t.texData.get(a.dataId),o=new Tr(a.shape),i=[Er(a,r.complexTensorInfos.real),Er(a,r.complexTensorInfos.imag)];return t.runWebGLProgram(o,i,i[0].dtype)}};class Ar{constructor(e){this.outputShape=[],this.outputShape=n.backend_util.computeOutShape(e,1),this.variableNames=e.map(((e,n)=>`T${n}`));const t=new Array(e.length-1);t[0]=e[0][1];for(let n=1;n<t.length;n++)t[n]=t[n-1]+e[n][1];const a=[`if (yC < ${t[0]}) setOutput(getT0(yR, yC));`];for(let e=1;e<t.length;e++){const n=t[e-1];a.push(`else if (yC < ${t[e]}) setOutput(getT${e}(yR, yC-${n}));`)}const r=t.length,o=t[t.length-1];a.push(`else setOutput(getT${r}(yR, yC-${o}));`),this.userCode=`\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int yR = coords.x;\n        int yC = coords.y;\n\n        ${a.join("\n        ")}\n      }\n    `}}class Fr{constructor(e,t){this.packedInputs=!0,this.packedOutput=!0,this.outputShape=[],this.outputShape=n.backend_util.computeOutShape(e,t);const a=this.outputShape,r=a.length,o=Ie(r),i=$t("coords",r),s=["x","y","z","w","u","v"].slice(0,r);this.variableNames=e.map(((e,n)=>`T${n}`));const u=new Array(e.length-1);u[0]=e[0][t];for(let n=1;n<u.length;n++)u[n]=u[n-1]+e[n][t];const l=s[t],c=s.slice(-2),d=s.join();let p=`if (${l} < ${u[0]}) {\n        return getChannel(\n            getT0(${d}), vec2(${c.join()}));\n        }`;for(let e=1;e<u.length;e++){const n=u[e-1];p+=`\n        if (${l} < ${u[e]}  && ${l} >= ${u[e-1]}) {\n          return getChannel(\n            getT${e}(${_r(s,l,n)}),\n            vec2(${_r(c,l,n)}));\n        }`}const h=u.length,f=u[u.length-1];p+=`\n        return getChannel(\n          getT${h}(${_r(s,l,f)}),\n          vec2(${_r(c,l,f)}));`,this.userCode=`\n      float getValue(${s.map((e=>"int "+e))}) {\n        ${p}\n      }\n\n      void main() {\n        ${o} coords = getOutputCoords();\n        vec4 result = vec4(getValue(${i}), 0., 0., 0.);\n\n        ${i[r-1]} = ${i[r-1]} + 1;\n        if (${i[r-1]} < ${a[r-1]}) {\n          result.g = getValue(${i});\n        }\n\n        ${i[r-2]} = ${i[r-2]} + 1;\n        if (${i[r-2]} < ${a[r-2]}) {\n          result.a = getValue(${i});\n        }\n\n        ${i[r-1]} = ${i[r-1]} - 1;\n        if (${i[r-2]} < ${a[r-2]} &&\n            ${i[r-1]} < ${a[r-1]}) {\n          result.b = getValue(${i});\n        }\n        setOutput(result);\n      }\n    `}}function _r(e,n,t){const a=e.indexOf(n);return e.map(((e,n)=>n===a?`${e} - ${t}`:e)).join()}function Or(e){const{inputs:n,backend:t}=e,{input:a}=n;return Ut({inputs:{x:t.texData.get(a.dataId).complexTensorInfos.imag},backend:t})}const Dr={kernelName:n.Imag,backendName:"webgl",kernelFunc:Or};function Pr(e,t,a){const r=e[0].dtype;if("complex64"===r){const n=e.map((e=>vr({inputs:{input:e},backend:a}))),r=e.map((e=>Or({inputs:{input:e},backend:a}))),o=Pr(n,t,a),i=Pr(r,t,a),s=Gt({inputs:{real:o,imag:i},backend:a});return n.forEach((e=>a.disposeIntermediateTensorInfo(e))),r.forEach((e=>a.disposeIntermediateTensorInfo(e))),a.disposeIntermediateTensorInfo(o),a.disposeIntermediateTensorInfo(i),s}let o=a.shouldExecuteOnCPU(e);if("string"===r&&(o=!0),o){const o=e.map((e=>{const r=n.util.sizeFromShape(e.shape.slice(t));return sa({inputs:{x:e},backend:a,attrs:{shape:[-1,r]}})})),i=o.map((e=>({vals:a.readSync(e.dataId),shape:e.shape}))),s=n.backend_util.computeOutShape(o.map((e=>e.shape)),1),u=1===o[0].shape[0],l=Pn(i,s,r,u),c=n.backend_util.computeOutShape(e.map((e=>e.shape)),t),d=a.makeTensorInfo(c,r,l);return o.forEach((e=>a.disposeIntermediateTensorInfo(e))),d}if(e.length>n.env().getNumber("WEBGL_MAX_TEXTURES_IN_SHADER")){const n=Math.floor(e.length/2),r=Pr(e.slice(0,n),t,a),o=Pr(e.slice(n),t,a),i=Pr([r,o],t,a);return a.disposeIntermediateTensorInfo(r),a.disposeIntermediateTensorInfo(o),i}if(n.env().getBool("WEBGL_PACK_ARRAY_OPERATIONS")&&e[0].shape.length>1){const n=new Fr(e.map((e=>e.shape)),t);return a.runWebGLProgram(n,e,r)}const{tensors2D:i,outShape:s}=function(e,t,a){const r=n.backend_util.computeOutShape(e.map((e=>e.shape)),t);return{tensors2D:e.map((e=>sa({inputs:{x:e},attrs:{shape:[-1,n.util.sizeFromShape(e.shape.slice(t))]},backend:a}))),outShape:r}}(e,t,a),u=new Ar(i.map((e=>e.shape))),l=a.runWebGLProgram(u,i,r);i.forEach((e=>a.disposeIntermediateTensorInfo(e)));const c=sa({inputs:{x:l},attrs:{shape:s},backend:a});return a.disposeIntermediateTensorInfo(l),c}function Lr(e){const{inputs:t,backend:a,attrs:r}=e,{axis:o}=r,i=n.util.parseAxisParam(o,t[0].shape)[0],s=n.backend_util.computeOutShape(t.map((e=>e.shape)),i);if(0===n.util.sizeFromShape(s))return a.makeTensorInfo(s,t[0].dtype,[]);const u=t.filter((e=>n.util.sizeFromShape(e.shape)>0));if(1===u.length)return Ut({inputs:{x:u[0]},backend:a});const l=u.map((e=>e.shape));return n.backend_util.assertParamsConsistent(l,i),Pr(u,i,a)}const Br={kernelName:n.Concat,backendName:"webgl",kernelFunc:Lr};class Vr{constructor(e,n=!1,t=null,a=!1,r=!1){this.variableNames=["x","W"],this.outputShape=e.outShape;const o=e.padInfo.top,i=e.padInfo.left,s=e.strideHeight,u=e.strideWidth,l=e.dilationHeight,c=e.dilationWidth,d=e.filterHeight,p=e.filterWidth,h=4*Math.floor(e.inChannels/4),f=e.inChannels%4,x="channelsLast"===e.dataFormat,m=x?1:2,g=x?2:3,b=x?3:1;let v="",C="";t&&(v=a?`float activation(float a) {\n          float b = getPreluActivationWeightsAtOutCoords();\n          ${t}\n        }`:r?`float activation(float a) {\n          float b = getLeakyreluAlphaAtOutCoords();\n          ${t}\n        }`:`\n          float activation(float x) {\n            ${t}\n          }\n        `,C="result = activation(result);");const $=n?"result += getBiasAtOutCoords();":"";n&&this.variableNames.push("bias"),a&&this.variableNames.push("preluActivationWeights"),r&&this.variableNames.push("leakyreluAlpha"),this.userCode=`\n      ${v}\n\n      const ivec2 strides = ivec2(${s}, ${u});\n      const ivec2 pads = ivec2(${o}, ${i});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords[0];\n        int d2 = coords[${b}];\n\n        ivec2 xRCCorner =\n            ivec2(coords[${m}], coords[${g}]) * strides - pads;\n        int xRCorner = xRCCorner.x;\n        int xCCorner = xRCCorner.y;\n\n        // Convolve x(?, ?, d1) with w(:, :, d1, d2) to get y(yR, yC, d2).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n        for (int wR = 0; wR < ${d}; wR++) {\n          int xR = xRCorner + wR * ${l};\n\n          if (xR < 0 || xR >= ${e.inHeight}) {\n            continue;\n          }\n\n          for (int wC = 0; wC < ${p}; wC++) {\n            int xC = xCCorner + wC * ${c};\n\n            if (xC < 0 || xC >= ${e.inWidth}) {\n              continue;\n            }\n\n            for (int d1 = 0; d1 < ${h}; d1 += 4) {\n              vec4 wValues = vec4(\n                getW(wR, wC, d1, d2),\n                getW(wR, wC, d1 + 1, d2),\n                getW(wR, wC, d1 + 2, d2),\n                getW(wR, wC, d1 + 3, d2)\n              );\n\n              if (${x}) {\n                vec4 xValues = vec4(\n                  getX(batch, xR, xC, d1),\n                  getX(batch, xR, xC, d1 + 1),\n                  getX(batch, xR, xC, d1 + 2),\n                  getX(batch, xR, xC, d1 + 3)\n                );\n                dotProd += dot(xValues, wValues);\n              } else {\n                vec4 xValues = vec4(\n                  getX(batch, d1, xR, xC),\n                  getX(batch, d1 + 1, xR, xC),\n                  getX(batch, d1 + 2, xR, xC),\n                  getX(batch, d1 + 3, xR, xC)\n                );\n                dotProd += dot(xValues, wValues);\n              }\n            }\n\n            if (${1===f}) {\n\n              if (${x}) {\n                dotProd +=\n                    getX(batch, xR, xC, ${h}) *\n                    getW(wR, wC, ${h}, d2);\n              } else {\n                dotProd +=\n                    getX(batch, ${h}, xR, xC) *\n                    getW(wR, wC, ${h}, d2);\n              }\n\n            } else if (${2===f}) {\n              vec2 wValues = vec2(\n                getW(wR, wC, ${h}, d2),\n                getW(wR, wC, ${h} + 1, d2)\n              );\n\n              if (${x}) {\n                vec2 xValues = vec2(\n                  getX(batch, xR, xC, ${h}),\n                  getX(batch, xR, xC, ${h} + 1)\n                );\n                dotProd += dot(xValues, wValues);\n              } else {\n                vec2 xValues = vec2(\n                  getX(batch, ${h}, xR, xC),\n                  getX(batch, ${h} + 1, xR, xC)\n                );\n                dotProd += dot(xValues, wValues);\n              }\n\n            } else if (${3===f}) {\n              vec3 wValues = vec3(\n                getW(wR, wC, ${h}, d2),\n                getW(wR, wC, ${h} + 1, d2),\n                getW(wR, wC, ${h} + 2, d2)\n              );\n\n              if (${x}) {\n                vec3 xValues = vec3(\n                  getX(batch, xR, xC, ${h}),\n                  getX(batch, xR, xC, ${h} + 1),\n                  getX(batch, xR, xC, ${h} + 2)\n                );\n                dotProd += dot(xValues, wValues);\n              } else {\n                vec3 xValues = vec3(\n                  getX(batch, ${h}, xR, xC),\n                  getX(batch, ${h} + 1, xR, xC),\n                  getX(batch, ${h} + 2, xR, xC)\n                );\n                dotProd += dot(xValues, wValues);\n              }\n\n            }\n          }\n        }\n\n        float result = dotProd;\n        ${$}\n        ${C}\n        setOutput(result);\n      }\n    `}}class Wr{constructor(e){this.variableNames=["x","W"],this.outputShape=e.outShape;const n=e.padInfo.front,t=e.padInfo.top,a=e.padInfo.left,r=e.strideDepth,o=e.strideHeight,i=e.strideWidth,s=e.dilationDepth,u=e.dilationHeight,l=e.dilationWidth,c=e.filterDepth,d=e.filterHeight,p=e.filterWidth,h=4*Math.floor(e.inChannels/4),f=e.inChannels%4;this.userCode=`\n      const ivec3 strides = ivec3(${r}, ${o}, ${i});\n      const ivec3 pads = ivec3(${n}, ${t}, ${a});\n\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int batch = coords.x;\n        int d2 = coords.u;\n\n        ivec3 xFRCCorner = ivec3(coords.y, coords.z, coords.w) * strides - pads;\n        int xFCorner = xFRCCorner.x;\n        int xRCorner = xFRCCorner.y;\n        int xCCorner = xFRCCorner.z;\n\n        // Convolve x(?, ?, ?, d1) with w(:, :, :, d1, d2) to get\n        // y(yF, yR, yC, d2). ? = to be determined. : = across all\n        // values in that axis.\n        float dotProd = 0.0;\n        for (int wF = 0; wF < ${c}; wF++) {\n          int xF = xFCorner + wF * ${s};\n\n          if (xF < 0 || xF >= ${e.inDepth}) {\n            continue;\n          }\n\n          for (int wR = 0; wR < ${d}; wR++) {\n            int xR = xRCorner + wR * ${u};\n\n            if (xR < 0 || xR >= ${e.inHeight}) {\n              continue;\n            }\n\n            for (int wC = 0; wC < ${p}; wC++) {\n              int xC = xCCorner + wC * ${l};\n\n              if (xC < 0 || xC >= ${e.inWidth}) {\n                continue;\n              }\n\n              for (int d1 = 0; d1 < ${h}; d1 += 4) {\n                vec4 xValues = vec4(\n                  getX(batch, xF, xR, xC, d1),\n                  getX(batch, xF, xR, xC, d1 + 1),\n                  getX(batch, xF, xR, xC, d1 + 2),\n                  getX(batch, xF, xR, xC, d1 + 3)\n                );\n                vec4 wValues = vec4(\n                  getW(wF, wR, wC, d1, d2),\n                  getW(wF, wR, wC, d1 + 1, d2),\n                  getW(wF, wR, wC, d1 + 2, d2),\n                  getW(wF, wR, wC, d1 + 3, d2)\n                );\n\n                dotProd += dot(xValues, wValues);\n              }\n\n              if (${1===f}) {\n                dotProd +=\n                  getX(batch, xF, xR, xC, ${h}) *\n                  getW(wF, wR, wC, ${h}, d2);\n              } else if (${2===f}) {\n                vec2 xValues = vec2(\n                  getX(batch, xF, xR, xC, ${h}),\n                  getX(batch, xF, xR, xC, ${h} + 1)\n                );\n                vec2 wValues = vec2(\n                  getW(wF, wR, wC, ${h}, d2),\n                  getW(wF, wR, wC, ${h} + 1, d2)\n                );\n                dotProd += dot(xValues, wValues);\n              } else if (${3===f}) {\n                vec3 xValues = vec3(\n                  getX(batch, xF, xR, xC, ${h}),\n                  getX(batch, xF, xR, xC, ${h} + 1),\n                  getX(batch, xF, xR, xC, ${h} + 2)\n                );\n                vec3 wValues = vec3(\n                  getW(wF, wR, wC, ${h}, d2),\n                  getW(wF, wR, wC, ${h} + 1, d2),\n                  getW(wF, wR, wC, ${h} + 2, d2)\n                );\n                dotProd += dot(xValues, wValues);\n              }\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class Ur{constructor(e,n){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.customUniforms=[{name:"inputShape",type:"ivec3"},{name:"pad",type:"ivec2"},{name:"stride",type:"ivec2"},{name:"dilation",type:"ivec2"},{name:"inChannels",type:"int"},{name:"itemsPerBlockRow",type:"int"},{name:"outWidth",type:"int"}],this.outputShape=e,this.enableShapeUniforms=Se(this.outputShape.length);const{dataFormat:t}=n,a=oe(),r="channelsLast"===t,o=r?0:1,i=r?1:2,s=this.enableShapeUniforms?"if(blockIndex < outShape[1] && pos < outShape[0]) {":`if(blockIndex < ${e[1]} && pos < ${e[0]}) {`;let u="";for(let e=0;e<=1;e++)for(let n=0;n<=1;n++)u+=`\n          blockIndex = rc.y + ${n};\n          pos = rc.x + ${e};\n\n          ${s}\n            offsetY = int(blockIndex / outWidth) * stride[0] - pad[0];\n            d0 = offsetY + dilation[0] * (pos / itemsPerBlockRow);\n\n            if(d0 < inputShape[${o}] && d0 >= 0) {\n              // Use custom imod instead mod. On Intel GPU, mod may generate\n              // unexpected value.\n              // https://github.com/tensorflow/tfjs/issues/5447\n              offsetX = imod(blockIndex, outWidth) * stride[1] - pad[1];\n              d1 = offsetX + dilation[1] * (imod(pos, itemsPerBlockRow) /\n                  inChannels);\n\n              if(d1 < inputShape[${i}] && d1 >= 0) {\n\n                ch = imod(pos, inChannels);\n\n                if (${r}) {\n                  innerDims = vec2(d1, ch);\n                  result[${2*e+n}] = getChannel(\n                    getA(d0, int(innerDims.x),\n                    int(innerDims.y)), innerDims);\n                } else {\n                  innerDims = vec2(d0, d1);\n                  result[${2*e+n}] = getChannel(\n                    getA(ch, int(innerDims.x),\n                    int(innerDims.y)), innerDims);\n                }\n              }\n            }\n          }\n        `;this.userCode=`\n      void main() {\n        ivec2 rc = getOutputCoords();\n\n        vec4 result = vec4(0);\n\n        int blockIndex, pos, offsetY, d0, offsetX, d1, ch;\n        vec2 innerDims;\n\n        ${u}\n\n        ${a.output} = result;\n      }\n    `}}function Mr({x:e,filter:t,convInfo:a,backend:r,bias:o=null,preluActivationWeights:i=null,leakyreluAlpha:s=0,activation:u=null}){const l=e.shape,c=r.texData.get(e.dataId),d=a.inChannels,p=l[0]*l[1]*l[2],h=a.outChannels,f="channelsLast"===a.dataFormat;let x;const m=[];if(!((1===p||1===h)&&d>1e3)&&c.isPacked&&f&&null!=c.texture&&l[2]%2!=0&&n.util.arraysEqual(c.shape.slice(-3),l.slice(-3))){const d=l[0]*l[1]*(l[2]+1),p={dataId:e.dataId,shape:[1,d,a.inChannels],dtype:e.dtype},h=c.shape;c.shape=c.shape.slice(),c.shape[c.shape.length-2]++,n.util.assert(z(c.shape,p.shape),(()=>`packed reshape ${c.shape} to ${p.shape} isn't free`));const f=sa({inputs:{x:t},backend:r,attrs:{shape:[1,a.inChannels,a.outChannels]}});m.push(f);const g=va({a:p,b:f,backend:r,transposeA:false,transposeB:false,bias:o,activation:u,preluActivationWeights:i,leakyreluAlpha:s}),b=r.texData.get(g.dataId);n.util.assert(b.isPacked,(()=>"batchMatMul result is expected to be packed")),c.shape=h,b.shape=a.outShape,x=Ut({inputs:{x:g},backend:r}),x.shape=a.outShape,m.push(g)}else{const n=sa({inputs:{x:e},backend:r,attrs:{shape:[1,f?l[0]*l[1]*l[2]:l[0]*l[2]*l[3],a.inChannels]}}),c=sa({inputs:{x:t},backend:r,attrs:{shape:[1,a.inChannels,a.outChannels]}}),d=va({a:n,b:c,transposeA:false,transposeB:false,backend:r,bias:o,activation:u,preluActivationWeights:i,leakyreluAlpha:s});x=sa({inputs:{x:d},backend:r,attrs:{shape:a.outShape}}),m.push(n),m.push(c),m.push(d)}for(const e of m)r.disposeIntermediateTensorInfo(e);return x}function Gr({x:e,filter:t,convInfo:a,backend:r,bias:o=null,preluActivationWeights:i=null,leakyreluAlpha:s=0,activation:u=null}){const{filterWidth:l,filterHeight:c,inChannels:d,outWidth:p,outHeight:h,dataFormat:f}=a,x="channelsLast"===f,m=l*c*d,g=h*p,b=[m,g],v=[],C=sa({inputs:{x:e},backend:r,attrs:{shape:e.shape.slice(1)}}),$=sa({inputs:{x:t},backend:r,attrs:{shape:[1,m,n.util.sizeFromShape(t.shape)/m]}});v.push(C),v.push($);const I=new Ur(b,a),y=[C.shape,[a.padInfo.top,a.padInfo.left],[a.strideHeight,a.strideWidth],[a.dilationHeight,a.dilationWidth],[a.inChannels],[a.filterWidth*a.inChannels],[a.outWidth]],k=r.runWebGLProgram(I,[C],"float32",y),w=sa({inputs:{x:k},backend:r,attrs:{shape:[1,b[0],b[1]]}});v.push(k),v.push(w);const R=null!=o,S=null!=i,T="leakyrelu"===u,E=u?Jt(u,!0):null,N=new ea(w.shape,$.shape,[1,g,a.outChannels],!0,!1,R,E,S,T),A=[w,$];if(o&&A.push(o),S&&A.push(i),T){const e=r.makeTensorInfo([],"float32",n.util.createScalarValue(s,"float32"));A.push(e),v.push(e)}const F=r.runWebGLProgram(N,A,"float32"),_=sa({inputs:{x:F},backend:r,attrs:{shape:x?[1,h,p,a.outChannels]:[1,a.outChannels,h,p]}});v.push(F);for(const e of v)r.disposeIntermediateTensorInfo(e);return _}const zr={kernelName:n.Conv2D,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:a,attrs:r}=e,{x:o,filter:i}=t,{strides:s,pad:u,dataFormat:l,dilations:c,dimRoundingMode:d}=r,p=n.backend_util.convertConv2DDataFormat(l),h=n.backend_util.computeConv2DInfo(o.shape,i.shape,s,c,u,d,!1,p);let f;if(1!==h.filterHeight||1!==h.filterWidth||1!==h.dilationHeight||1!==h.dilationWidth||1!==h.strideHeight||1!==h.strideWidth||"SAME"!==h.padInfo.type&&"VALID"!==h.padInfo.type)if(n.env().getBool("WEBGL_CONV_IM2COL")&&1===o.shape[0])f=Gr({x:o,filter:i,convInfo:h,backend:a});else{const e=new Vr(h);f=a.runWebGLProgram(e,[o,i],"float32")}else f=Mr({x:o,filter:i,convInfo:h,backend:a});const x=sa({inputs:{x:f},backend:a,attrs:{shape:h.outShape}});return a.disposeIntermediateTensorInfo(f),x}};class Xr{constructor(e){this.variableNames=["x","dy"],this.outputShape=e.filterShape;const n=e.strideHeight,t=e.strideWidth,a=e.padInfo.top,r=e.padInfo.left,o="channelsLast"===e.dataFormat;this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int wR = coords.x;\n        int wC = coords.y;\n        int d1 = coords.z;\n        int d2 = coords.w;\n\n        // Convolve x(?, ?, d1) with dy(:, :, d2) to get dw(wR, wC, d1, d2).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n\n        for (int b = 0; b < ${e.batchSize}; b++) {\n          for (int yR = 0; yR < ${e.outHeight}; yR++) {\n            int xR = wR + yR * ${n} - ${a};\n\n            if (xR < 0 || xR >= ${e.inHeight}) {\n              continue;\n            }\n\n            for (int yC = 0; yC < ${e.outWidth}; yC++) {\n              int xC = wC + yC * ${t} - ${r};\n\n              if (xC < 0 || xC >= ${e.inWidth}) {\n                continue;\n              }\n\n              if (${o}) {\n                float dyValue = getDy(b, yR, yC, d2);\n                float xValue = getX(b, xR, xC, d1);\n                dotProd += (xValue * dyValue);\n              } else {\n                float dyValue = getDy(b, d2, yR, yC);\n                float xValue = getX(b, d1, xR, xC);\n                dotProd += (xValue * dyValue);\n              }\n\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class Hr{constructor(e){this.variableNames=["dy","W"],this.outputShape=e.inShape;const n=e.filterHeight,t=e.filterWidth,a=e.strideHeight,r=e.strideWidth,o="channelsLast"===e.dataFormat,i=n-1-e.padInfo.top,s=t-1-e.padInfo.left,u=o?1:2,l=o?2:3,c=o?3:1;this.userCode=`\n      const ivec2 pads = ivec2(${i}, ${s});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords[0];\n        int d1 = coords[${c}];\n\n        ivec2 dyCorner = ivec2(coords[${u}], coords[${l}]) - pads;\n        int dyRCorner = dyCorner.x;\n        int dyCCorner = dyCorner.y;\n\n        // Convolve dy(?, ?, d2) with w(:, :, d1, d2) to compute dx(xR, xC, d1).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n        for (int wR = 0; wR < ${n}; wR++) {\n          float dyR = float(dyRCorner + wR) / ${a}.0;\n\n          if (dyR < 0.0 || dyR >= ${e.outHeight}.0 || fract(dyR) > 0.0) {\n            continue;\n          }\n          int idyR = int(dyR);\n\n          int wRPerm = ${n} - 1 - wR;\n\n          for (int wC = 0; wC < ${t}; wC++) {\n            float dyC = float(dyCCorner + wC) / ${r}.0;\n\n            if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                fract(dyC) > 0.0) {\n              continue;\n            }\n            int idyC = int(dyC);\n\n            int wCPerm = ${t} - 1 - wC;\n\n            for (int d2 = 0; d2 < ${e.outChannels}; d2++) {\n\n              if (${o}) {\n                float xValue = getDy(batch, idyR, idyC, d2);\n                float wValue = getW(wRPerm, wCPerm, d1, d2);\n                dotProd += xValue * wValue;\n              } else {\n                float xValue = getDy(batch, d2, idyR, idyC);\n                float wValue = getW(wRPerm, wCPerm, d1, d2);\n                dotProd += xValue * wValue;\n              }\n\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class jr{constructor(e){this.variableNames=["x","dy"],this.outputShape=e.filterShape;const n=e.strideDepth,t=e.strideHeight,a=e.strideWidth,r=e.padInfo.front,o=e.padInfo.top,i=e.padInfo.left;this.userCode=`\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int wF = coords.x;\n        int wR = coords.y;\n        int wC = coords.z;\n        int d1 = coords.w;\n        int d2 = coords.u;\n\n        float dotProd = 0.0;\n\n        for (int b = 0; b < ${e.batchSize}; b++) {\n          for (int yF = 0; yF < ${e.outDepth}; yF++) {\n            int xF = wF + yF * ${n} - ${r};\n\n            if (xF < 0 || xF >= ${e.inDepth}) {\n              continue;\n            }\n\n            for (int yR = 0; yR < ${e.outHeight}; yR++) {\n              int xR = wR + yR * ${t} - ${o};\n\n              if (xR < 0 || xR >= ${e.inHeight}) {\n                continue;\n              }\n\n              for (int yC = 0; yC < ${e.outWidth}; yC++) {\n                int xC = wC + yC * ${a} - ${i};\n\n                if (xC < 0 || xC >= ${e.inWidth}) {\n                  continue;\n                }\n\n                float dyValue = getDy(b, yF, yR, yC, d2);\n                float xValue = getX(b, xF, xR, xC, d1);\n                dotProd += (xValue * dyValue);\n              }\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class Kr{constructor(e){this.variableNames=["dy","W"],this.outputShape=e.inShape;const n=e.filterDepth,t=e.filterHeight,a=e.filterWidth,r=e.strideDepth,o=e.strideHeight,i=e.strideWidth,s=n-1-e.padInfo.front,u=t-1-e.padInfo.top,l=a-1-e.padInfo.left;this.userCode=`\n      const ivec3 pads = ivec3(${s}, ${u}, ${l});\n\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int batch = coords.x;\n        int d1 = coords.u;\n\n\n        ivec3 dyCorner = ivec3(coords.y, coords.z, coords.w) - pads;\n        int dyFCorner = dyCorner.x;\n        int dyRCorner = dyCorner.y;\n        int dyCCorner = dyCorner.z;\n\n        float dotProd = 0.0;\n        for (int wF = 0; wF < ${n}; wF++) {\n          float dyF = float(dyFCorner + wF) / ${r}.0;\n\n          if (dyF < 0.0 || dyF >= ${e.outDepth}.0 || fract(dyF) > 0.0) {\n            continue;\n          }\n          int idyF = int(dyF);\n\n          int wFPerm = ${n} - 1 - wF;\n\n          for (int wR = 0; wR < ${t}; wR++) {\n            float dyR = float(dyRCorner + wR) / ${o}.0;\n\n            if (dyR < 0.0 || dyR >= ${e.outHeight}.0 ||\n              fract(dyR) > 0.0) {\n              continue;\n            }\n            int idyR = int(dyR);\n\n            int wRPerm = ${t} - 1 - wR;\n\n            for (int wC = 0; wC < ${a}; wC++) {\n              float dyC = float(dyCCorner + wC) / ${i}.0;\n\n              if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                  fract(dyC) > 0.0) {\n                continue;\n              }\n              int idyC = int(dyC);\n\n              int wCPerm = ${a} - 1 - wC;\n\n              for (int d2 = 0; d2 < ${e.outChannels}; d2++) {\n                float xValue = getDy(batch, idyF, idyR, idyC, d2);\n                float wValue = getW(wFPerm, wRPerm, wCPerm, d1, d2);\n                dotProd += xValue * wValue;\n              }\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}const qr={kernelName:n.Conv2DBackpropFilter,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:a,attrs:r}=e,{x:o,dy:i}=t,{strides:s,pad:u,dataFormat:l,dimRoundingMode:c,filterShape:d}=r,p=n.backend_util.convertConv2DDataFormat(l),h=n.backend_util.computeConv2DInfo(o.shape,d,s,1,u,c,!1,p),f=new Xr(h);return a.runWebGLProgram(f,[o,i],"float32")}};const Yr={kernelName:n.Conv2DBackpropInput,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:a,attrs:r}=e,{dy:o,filter:i}=t,{inputShape:s,strides:u,pad:l,dataFormat:c,dimRoundingMode:d}=r,p=n.backend_util.convertConv2DDataFormat(c),h=n.backend_util.computeConv2DInfo(s,i.shape,u,1,l,d,!1,p),f=new Hr(h);return a.runWebGLProgram(f,[o,i],"float32")}};const Qr={kernelName:n.Conv3D,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:a,attrs:r}=e,{x:o,filter:i}=t,{strides:s,pad:u,dilations:l}=r,c=n.backend_util.computeConv3DInfo(o.shape,i.shape,s,l,u),d=new Wr(c);return a.runWebGLProgram(d,[o,i],"float32")}};const Zr={kernelName:n.Conv3DBackpropFilterV2,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:a,attrs:r}=e,{x:o,dy:i}=t,{strides:s,pad:u,filterShape:l}=r,c=n.backend_util.computeConv3DInfo(o.shape,l,s,1,u),d=new jr(c);return a.runWebGLProgram(d,[o,i],"float32")}};const Jr={kernelName:n.Conv3DBackpropInputV2,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:a,attrs:r}=e,{dy:o,filter:i}=t,{pad:s,strides:u,inputShape:l}=r,c=n.backend_util.computeConv3DInfo(l,i.shape,u,1,s),d=new Kr(c);return a.runWebGLProgram(d,[o,i],"float32")}},eo=Qt({opSnippet:"if (isnan(x)) return x;\n  return cos(x);\n"}),no={kernelName:n.Cos,backendName:"webgl",kernelFunc:eo},to=Qt({opSnippet:"\n  float e2x = exp(-x);\n  return (e2x + 1.0 / e2x) / 2.0;\n"}),ao={kernelName:n.Cosh,backendName:"webgl",kernelFunc:to};class ro{constructor(e,n,t,a,r){this.variableNames=["Image","Boxes","BoxInd"],this.outputShape=[];const[o,i,s,u]=e,[l]=n,[c,d]=t;this.outputShape=[l,c,d,u];const p="bilinear"===a?1:0,[h,f]=[i-1+".0",s-1+".0"],[x,m,g]=c>1?[""+(i-1)/(c-1),"(y2-y1) * height_ratio",`y1*${h} + float(y)*(height_scale)`]:["0.0","0.0",`0.5 * (y1+y2) * ${h}`],[b,v,C]=d>1?[""+(s-1)/(d-1),"(x2-x1) * width_ratio",`x1*${f} + float(x)*(width_scale)`]:["0.0","0.0",`0.5 * (x1+x2) * ${f}`];this.userCode=`\n      const float height_ratio = float(${x});\n      const float width_ratio = float(${b});\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int y = coords[1];\n        int x = coords[2];\n        int d = coords[3];\n\n        // get box vals\n        float y1 = getBoxes(b,0);\n        float x1 = getBoxes(b,1);\n        float y2 = getBoxes(b,2);\n        float x2 = getBoxes(b,3);\n\n        // get image in batch index\n        int bInd = round(getBoxInd(b));\n        if(bInd < 0 || bInd >= ${o}) {\n          return;\n        }\n\n        float height_scale = ${m};\n        float width_scale = ${v};\n\n        float in_y = ${g};\n        if( in_y < 0.0 || in_y > ${h} ) {\n          setOutput(float(${r}));\n          return;\n        }\n        float in_x = ${C};\n        if( in_x < 0.0 || in_x > ${f} ) {\n          setOutput(float(${r}));\n          return;\n        }\n\n        vec2 sourceFracIndexCR = vec2(in_x,in_y);\n        if(${p} == 1) {\n          // Compute the four integer indices.\n          ivec2 sourceFloorCR = ivec2(sourceFracIndexCR);\n          ivec2 sourceCeilCR = ivec2(ceil(sourceFracIndexCR));\n\n          float topLeft = getImage(b, sourceFloorCR.y, sourceFloorCR.x, d);\n          float bottomLeft = getImage(b, sourceCeilCR.y, sourceFloorCR.x, d);\n          float topRight = getImage(b, sourceFloorCR.y, sourceCeilCR.x, d);\n          float bottomRight = getImage(b, sourceCeilCR.y, sourceCeilCR.x, d);\n\n          vec2 fracCR = sourceFracIndexCR - vec2(sourceFloorCR);\n\n          float top = topLeft + (topRight - topLeft) * fracCR.x;\n          float bottom = bottomLeft + (bottomRight - bottomLeft) * fracCR.x;\n          float newValue = top + (bottom - top) * fracCR.y;\n          setOutput(newValue);\n        } else {\n          // Compute the coordinators of nearest neighbor point.\n          ivec2 sourceNearestCR = ivec2(floor(\n            sourceFracIndexCR + vec2(0.5,0.5)));\n          float newValue = getImage(b, sourceNearestCR.y, sourceNearestCR.x, d);\n          setOutput(newValue);\n        }\n      }\n    `}}const oo={kernelName:n.CropAndResize,backendName:"webgl",kernelFunc:e=>{const{inputs:n,backend:t,attrs:a}=e,{image:r,boxes:o,boxInd:i}=n,{cropSize:s,method:u,extrapolationValue:l}=a,c=new ro(r.shape,o.shape,s,u,l);return t.runWebGLProgram(c,[r,o,i],"float32")}};class io{constructor(e,n,t){this.variableNames=["x"],this.customUniforms=[{name:"index",type:"float"}],this.outputShape=e;const a=e.length,r=n?"0.0":`getX(${so(a,"coords")})`,o=e[e.length-1];let i="",s="";n?(i=t?"end != "+(o-1):"end != 0",s=t?"end + 1":"end - 1"):(i=t?`end + pow2 < ${o}`:"end >= pow2",s=t?"end + pow2":"end - pow2"),this.userCode=`\n      void main() {\n        ${Ie(a)} coords = getOutputCoords();\n        int end = ${uo(a,"coords")};\n        float val = ${r};\n        int pow2 = int(pow(2.0, index));\n        if (${i}) {\n          int idx = ${s};\n          ${uo(a,"coords")} = idx;\n          val += getX(${so(a,"coords")});\n        }\n        setOutput(val);\n      }\n    `}}function so(e,n){if(1===e)return`${n}`;if(2===e)return`${n}.x, ${n}.y`;if(3===e)return`${n}.x, ${n}.y, ${n}.z`;if(4===e)return`${n}.x, ${n}.y, ${n}.z, ${n}.w`;throw Error(`Cumulative sum for rank ${e} is not yet supported`)}function uo(e,n){if(1===e)return`${n}`;if(2===e)return`${n}.y`;if(3===e)return`${n}.z`;if(4===e)return`${n}.w`;throw Error(`Cumulative sum for rank ${e} is not yet supported`)}const lo={kernelName:n.Cumsum,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:a,attrs:r}=e,{x:o}=t,{axis:i,exclusive:s,reverse:u}=r,l=o.shape.length,c=n.backend_util.getAxesPermutation([i],l);let d=o;null!=c&&(d=ga({inputs:{x:o},backend:a,attrs:{perm:c}}));const p=n.backend_util.getInnerMostAxes(1,l)[0];if(p!==l-1)throw new Error(`WebGL cumsum shader expects an inner-most axis=${o.shape.length-1} but got axis=${i}`);const h=d.shape[p];let f=Ut({inputs:{x:d},backend:a});for(let e=0;e<=Math.ceil(Math.log2(h))-1;e++){const n=new io(d.shape,!1,u),t=[[e]],r=f;f=a.runWebGLProgram(n,[f],f.dtype,t),a.disposeIntermediateTensorInfo(r)}if(s){const e=new io(d.shape,s,u),n=f;f=a.runWebGLProgram(e,[f],f.dtype),a.disposeIntermediateTensorInfo(n)}if(null!=c){const e=ga({inputs:{x:f},backend:a,attrs:{perm:n.backend_util.getUndoAxesPermutation(c)}});return a.disposeIntermediateTensorInfo(f),a.disposeIntermediateTensorInfo(d),e}return f}};const co={kernelName:n.DenseBincount,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t,attrs:a}=e,{x:r,weights:o}=n,{size:i,binaryOutput:s}=a;if(1===r.shape.length){const e=t.readSync(r.dataId),n=t.readSync(o.dataId),a=_n(e,n,o.dtype,o.shape,i);return t.makeTensorInfo([i],o.dtype,a)}if(2===r.shape.length){const e=t.bufferSync(r),n=t.bufferSync(o),a=On(e,n,i,s);return t.makeTensorInfo(a.shape,o.dtype,a.values)}throw new Error(`Error in denseBincount: input must be at most rank 2, but got rank${r.shape.length}.`)}};class po{constructor(e,n,t){this.variableNames=["x"],this.outputShape=[],this.outputShape=e,this.blockSize=n,this.dataFormat=t,this.userCode=`\n    void main() {\n      ivec4 coords = getOutputCoords();\n      int b = coords[0];\n      int h = ${this.getHeightCoordString()};\n      int w = ${this.getWidthCoordString()};\n      int d = ${this.getDepthCoordString()};\n\n      int in_h = h / ${n};\n      int offset_h = imod(h, ${n});\n      int in_w = w / ${n};\n      int offset_w = imod(w, ${n});\n      int offset_d = (offset_h * ${n} + offset_w) *\n        ${this.getOutputDepthSize()};\n      int in_d = d + offset_d;\n\n      float result = ${this.getInputSamplingString()};\n      setOutput(result);\n    }\n  `}getHeightCoordString(){return"NHWC"===this.dataFormat?"coords[1]":"coords[2]"}getWidthCoordString(){return"NHWC"===this.dataFormat?"coords[2]":"coords[3]"}getDepthCoordString(){return"NHWC"===this.dataFormat?"coords[3]":"coords[1]"}getOutputDepthSize(){return"NHWC"===this.dataFormat?this.outputShape[3]:this.outputShape[1]}getInputSamplingString(){return"NHWC"===this.dataFormat?"getX(b, in_h, in_w, in_d)":"getX(b, in_d, in_h, in_w)"}}const ho={kernelName:n.DepthToSpace,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:a,attrs:r}=e,{x:o}=t,{blockSize:i,dataFormat:s}=r;n.util.assert(i>1,(()=>`blockSize should be > 1 for depthToSpace, but was: ${i}`));const u=o.shape[0],l="NHWC"===s?o.shape[1]:o.shape[2],c="NHWC"===s?o.shape[2]:o.shape[3],d="NHWC"===s?o.shape[3]:o.shape[1],p=l*i,h=c*i,f=d/(i*i),x=new po("NHWC"===s?[u,p,h,f]:[u,f,p,h],i,s);return a.runWebGLProgram(x,[o],o.dtype)}};class fo{constructor(e,n=!1,t=null,a=!1,r=!1){this.variableNames=["x","W"],this.customUniforms=[{name:"pads",type:"ivec2"},{name:"strides",type:"ivec2"},{name:"dilations",type:"ivec2"},{name:"inDims",type:"ivec2"}],this.outputShape=e.outShape,this.enableShapeUniforms=Se(this.outputShape.length);const o=e.filterHeight,i=e.filterWidth,s=e.outChannels/e.inChannels;let u="",l="";t&&(u=a?`float activation(float a) {\n          float b = getPreluActivationWeightsAtOutCoords();\n          ${t}\n        }`:r?`float activation(float a) {\n          float b = getLeakyreluAlphaAtOutCoords();\n          ${t}\n        }`:`\n          float activation(float x) {\n            ${t}\n          }\n        `,l="result = activation(result);");const c=n?"result += getBiasAtOutCoords();":"";n&&this.variableNames.push("bias"),a&&this.variableNames.push("preluActivationWeights"),r&&this.variableNames.push("leakyreluAlpha"),this.userCode=`\n      ${u}\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords.x;\n        ivec2 xRCCorner = coords.yz * strides - pads;\n        int d2 = coords.w;\n        int d1 = d2 / ${s};\n        int q = d2 - d1 * ${s};\n\n        int xRCorner = xRCCorner.x;\n        int xCCorner = xRCCorner.y;\n\n        // Convolve x(?, ?, d1) with w(:, :, d1, q) to get y(yR, yC, d2).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n        // TO DO(dsmilkov): Flatten the two for loops and vec4 the operations.\n        for (int wR = 0; wR < ${o}; wR++) {\n          int xR = xRCorner + wR * dilations[0];\n\n          if (xR < 0 || xR >= inDims[0]) {\n            continue;\n          }\n\n          for (int wC = 0; wC < ${i}; wC++) {\n            int xC = xCCorner + wC * dilations[1];\n\n            if (xC < 0 || xC >= inDims[1]) {\n              continue;\n            }\n\n            float xVal = getX(batch, xR, xC, d1);\n            float wVal = getW(wR, wC, d1, q);\n            dotProd += xVal * wVal;\n          }\n        }\n\n        float result = dotProd;\n        ${c}\n        ${l}\n        setOutput(result);\n      }\n    `}}class xo{constructor(e,t=!1,a=null,r=!1,o=!1){this.variableNames=["x","W"],this.packedInputs=!0,this.packedOutput=!0,this.customUniforms=[{name:"pads",type:"ivec2"},{name:"strides",type:"ivec2"},{name:"dilations",type:"ivec2"},{name:"inDims",type:"ivec2"}],this.outputShape=e.outShape,this.enableShapeUniforms=Se(this.outputShape.length);const i=e.outChannels/e.inChannels,s=e.padInfo.left,u=e.strideWidth,l=e.dilationWidth,c=e.filterHeight,d=e.filterWidth,p=d;let h="\n      int xR; int xC; int xCOffset;\n      vec4 wTexel; vec4 previous; vec4 final;";for(let e=0;e<d;e++)h+=`\n          vec4 xTexelC${2*e};\n          int xTexelC${2*e}Ready;\n          vec4 xTexelC${2*e+1};\n          int xTexelC${2*e+1}Ready;\n          vec4 xC${e};`;for(let e=0;e<c;e++){for(let e=0;e<d;e++)h+=`\n          xTexelC${2*e} = vec4(0.0);\n          xTexelC${2*e}Ready = 0;\n          xTexelC${2*e+1} = vec4(0.0);\n          xTexelC${2*e+1}Ready = 0;\n          xC${e} = vec4(0.0);`;h+=`\n        xR = xRCorner + ${e} * dilations[0];\n        if (xR >=0 && xR < inDims[0]) {\n      `;for(let t=0;t<(p+1)/2;t++){const a=2*t;if(h+=`\n          xC = xCCorner + ${a*l};\n          `,1===u){if(a<d&&(s%2==1?(h+=`\n                xCOffset = xC + 1;\n                if (xCOffset >= 0 && xCOffset < inDims[1] && xTexelC${a}Ready == 0) {\n                  xTexelC${a} = getX(batch, xR, xCOffset, d1);\n\n                  // Need to manually clear unused channels in case\n                  // we're reading from recycled texture.\n                  if (xCOffset + 1 >= inDims[1]) {\n                    xTexelC${a}.zw = vec2(0.0);\n                  }\n                  xTexelC${a}Ready = 1;\n                }\n              `,h+=1===l&&a>0?`\n                xC${a} = vec4(xTexelC${a-2}.zw, xTexelC${a}.xy);\n                `:`\n                  xCOffset = xC + 1 - 2;\n\n                  if (xCOffset >= 0 && xCOffset < inDims[1]) {\n                    previous = getX(batch, xR, xCOffset, d1);\n\n                    // Need to manually clear unused channels in case\n                    // we're reading from recycled texture.\n                    if (xCOffset + 1 >= inDims[1]) {\n                      previous.zw = vec2(0.0);\n                    }\n\n                    xC${a} = vec4(previous.zw, xTexelC${a}.xy);\n                  } else {\n                    xC${a} = vec4(0.0, 0.0, xTexelC${a}.xy);\n                  }\n                  `):h+=`\n                if (xC >= 0 && xC < inDims[1] && xTexelC${a}Ready == 0) {\n                  xTexelC${a} = getX(batch, xR, xC, d1);\n                  if (xC + 1 >= inDims[1]) {\n                    xTexelC${a}.zw = vec2(0.0);\n                  }\n                  xTexelC${a}Ready = 1;\n                }\n\n                xC${a} = xTexelC${a};\n                `,a+1<d)){const e=s%2==0?n.util.nearestLargerEven(l):l;l%2==0&&s%2==1||l%2!=0&&s%2!=1?(h+=`\n                  xCOffset = xC + imod(pads[1], 2) + ${e};\n\n                  if (xCOffset >= 0 && xCOffset < inDims[1] && xTexelC${a+1}Ready == 0) {\n                    xTexelC${a+1} = getX(batch, xR, xCOffset, d1);\n\n                    // Need to manually clear unused channels in case\n                    // we're reading from recycled texture.\n                    if (xCOffset + 1 >= inDims[1]) {\n                      xTexelC${a+1}.zw = vec2(0.0);\n                    }\n                    xTexelC${a+1}Ready = 1;\n                  }\n                  `,l>1&&(h+=`\n                    xCOffset -= 2;\n                    if (xCOffset >= 0 && xCOffset < inDims[1] && xTexelC${a}Ready == 0) {\n                      xTexelC${a} = getX(batch, xR, xCOffset, d1);\n                      xTexelC${a}Ready = 1;\n                    }\n                    `),h+=`\n                  xC${a+1} = vec4(xTexelC${a}.zw, xTexelC${a+1}.xy);\n                  `):h+=1===e?`\n                    xC${a+1} = xTexelC${a};\n                    `:`\n                    xCOffset = xC + ${e};\n\n                    if (xCOffset >= 0 && xCOffset < inDims[1] && xTexelC${a+1}Ready == 0) {\n                      xTexelC${a+1} = getX(batch, xR, xCOffset, d1);\n                      if (xCOffset + 1 >= inDims[1]) {\n                        xTexelC${a+1}.zw = vec2(0.0);\n                      }\n                      xTexelC${a+1}Ready = 1;\n                    }\n\n                    xC${a+1} = xTexelC${a+1};\n                    `}}else a<d&&(s%2==1?(h+=`\n                xCOffset = xC + 1 - strides[1];\n                if(xCOffset >= 0 && xCOffset < inDims[1] && xTexelC${a}Ready == 0) {\n                  xTexelC${a} = getX(batch, xR, xCOffset, d1);\n                  // Need to manually clear unused channels in case\n                  // we're reading from recycled texture.\n                  if (xCOffset + 1 >= inDims[1]) {\n                    xTexelC${a}.zw = vec2(0.0);\n                  }\n                  xTexelC${a}Ready = 1;\n                }\n\n                if(xC + 1 >= 0 && xC + 1 < inDims[1] && xTexelC${a+1}Ready == 0) {\n                  xTexelC${a+1} = getX(batch, xR, xC + 1, d1);\n                  // Need to manually clear unused channels in case\n                  // we're reading from recycled texture.\n                  if (xC + 2 >= inDims[1]) {\n                    xTexelC${a+1}.zw = vec2(0.0);\n                  }\n                  xTexelC${a+1}Ready = 1;\n                }\n\n                xC${a} = vec4(xTexelC${a}.zw, xTexelC${a+1}.zw);\n              `,a+1<d&&(h+=`\n                  final = vec4(0.0);\n                  xCOffset = xC + 1 + strides[1];\n                  if(xCOffset >= 0 && xCOffset < inDims[1]) {\n                    final = getX(batch, xR, xCOffset, d1);\n                  }\n                  xC${a+1} = vec4(xTexelC${a+1}.xy, final.xy);\n                `)):(h+=`\n                if(xC >= 0 && xC < inDims[1] && xTexelC${a}Ready == 0) {\n                  xTexelC${a} = getX(batch, xR, xC, d1);\n                  if (xC + 1 >= inDims[1]) {\n                    xTexelC${a}.zw = vec2(0.0);\n                  }\n                  xTexelC${a}Ready = 1;\n                }\n\n                xCOffset = xC + strides[1];\n                if(xCOffset >= 0 && xCOffset < inDims[1] && xTexelC${a+1}Ready == 0) {\n                  xTexelC${a+1} = getX(batch, xR, xCOffset, d1);\n                  if (xCOffset + 1 >= inDims[1]) {\n                    xTexelC${a+1}.zw = vec2(0.);\n                  }\n                  xTexelC${a+1}Ready = 1;\n                }\n\n                xC${a} = vec4(\n                  xTexelC${a}.xy, xTexelC${a+1}.xy);\n              `,a+1<d&&(h+=`\n                  xC${a+1} = vec4(xTexelC${a}.zw, xTexelC${a+1}.zw);\n                `)));a<d&&(h+=`\n            wTexel = getW(${e}, ${a}, d1, q);\n            dotProd += xC${a} * vec4(wTexel.xz, wTexel.xz);\n          `,a+1<d&&(h+=`\n              wTexel = getW(${e}, ${a+1}, d1, q);\n              dotProd += xC${a+1} * vec4(wTexel.xz, wTexel.xz);\n            `))}h+="\n        }\n      "}let f="",x="";a&&(f=r?`vec4 activation(vec4 a) {\n          vec4 b = getPreluActivationWeightsAtOutCoords();\n          ${a}\n        }`:o?`vec4 activation(vec4 a) {\n          vec4 b = getLeakyreluAlphaAtOutCoords();\n          ${a}\n        }`:`vec4 activation(vec4 x) {\n          ${a}\n        }`,x="result = activation(result);");const m=t?"result += getBiasAtOutCoords();":"";t&&this.variableNames.push("bias"),r&&this.variableNames.push("preluActivationWeights"),o&&this.variableNames.push("leakyreluAlpha"),this.userCode=`\n      ${f}\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords.x;\n        ivec2 xRCCorner = coords.yz * strides - pads;\n        int d2 = coords.w;\n        int d1 = d2 / ${i};\n        int q = d2 - d1 * ${i};\n        int xRCorner = xRCCorner.x;\n        int xCCorner = xRCCorner.y;\n\n        //intialize dotProd with a small epsilon seems to reduce GPU accuracy loss.\n        vec4 dotProd = vec4(0.000000000000001);\n\n        ${h}\n\n        vec4 result = dotProd - vec4(0.000000000000001);\n        ${m}\n        ${x}\n        setOutput(result);\n      }\n    `}}const mo={kernelName:n.DepthwiseConv2dNative,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:a,attrs:r}=e,{x:o,filter:i}=t,{strides:s,pad:u,dilations:l,dimRoundingMode:c}=r;let d=l;null==d&&(d=[1,1]),n.util.assert(n.backend_util.eitherStridesOrDilationsAreOne(s,d),(()=>`Error in depthwiseConv2d: Either strides or dilations must be 1. Got strides ${s} and dilations '${d}'`));const p=n.backend_util.computeConv2DInfo(o.shape,i.shape,s,d,u,c,!0);let h;h=n.env().getBool("WEBGL_PACK_DEPTHWISECONV")&&p.strideWidth<=2&&p.outChannels/p.inChannels==1?new xo(p):new fo(p);const f=[[p.padInfo.top,p.padInfo.left],[p.strideHeight,p.strideWidth],[p.dilationHeight,p.dilationWidth],[p.inHeight,p.inWidth]];return a.runWebGLProgram(h,[o,i],"float32",f)}};class go{constructor(e){this.variableNames=["x","dy"],this.outputShape=e.filterShape;const n=e.strideHeight,t=e.strideWidth,a=e.padInfo.top,r=e.padInfo.left,o=e.outChannels/e.inChannels;this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int wR = coords.x;\n        int wC = coords.y;\n        int d1 = coords.z;\n        int dm = coords.w;\n        int d2 = d1 * ${o} + dm;\n\n        float dotProd = 0.0;\n\n        // TO DO: Vec4 over the batch size\n        for (int b = 0; b < ${e.batchSize}; b++) {\n          for (int yR = 0; yR < ${e.outHeight}; yR++) {\n            int xR = wR + yR * ${n} - ${a};\n\n            if (xR < 0 || xR >= ${e.inHeight}) {\n              continue;\n            }\n\n            for (int yC = 0; yC < ${e.outWidth}; yC++) {\n              int xC = wC + yC * ${t} - ${r};\n\n              if (xC < 0 || xC >= ${e.inWidth}) {\n                continue;\n              }\n\n              float dyValue = getDy(b, yR, yC, d2);\n              float xValue = getX(b, xR, xC, d1);\n              dotProd += (xValue * dyValue);\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class bo{constructor(e){this.variableNames=["dy","W"],this.outputShape=e.inShape;const n=e.filterHeight,t=e.filterWidth,a=e.strideHeight,r=e.strideWidth,o=n-1-e.padInfo.top,i=t-1-e.padInfo.left,s=e.outChannels/e.inChannels;this.userCode=`\n      const ivec2 pads = ivec2(${o}, ${i});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords[0];\n        int d1 = coords[3];\n        ivec2 dyCorner = coords.yz - pads;\n        int dyRCorner = dyCorner.x;\n        int dyCCorner = dyCorner.y;\n\n        float dotProd = 0.0;\n\n        for (int wR = 0; wR < ${n}; wR++) {\n          float dyR = float(dyRCorner + wR) / ${a}.0;\n\n          if (dyR < 0.0 || dyR >= ${e.outHeight}.0 || fract(dyR) > 0.0) {\n            continue;\n          }\n          int idyR = int(dyR);\n\n          int wRPerm = ${n} - 1 - wR;\n\n          for (int wC = 0; wC < ${t}; wC++) {\n            float dyC = float(dyCCorner + wC) / ${r}.0;\n\n            if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                fract(dyC) > 0.0) {\n              continue;\n            }\n            int idyC = int(dyC);\n\n            int wCPerm = ${t} - 1 - wC;\n\n            // TO DO: Vec4 over the channelMul\n            for (int dm = 0; dm < ${s}; dm++) {\n              int d2 = d1 * ${s} + dm;\n              float xValue = getDy(batch, idyR, idyC, d2);\n              float wValue = getW(wRPerm, wCPerm, d1, dm);\n              dotProd += xValue * wValue;\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}const vo={kernelName:n.DepthwiseConv2dNativeBackpropFilter,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:a,attrs:r}=e,{x:o,dy:i}=t,{strides:s,dilations:u,pad:l,dimRoundingMode:c,filterShape:d}=r,p=n.backend_util.computeConv2DInfo(o.shape,d,s,u,l,c,!0),h=new go(p);return a.runWebGLProgram(h,[o,i],"float32")}};const Co={kernelName:n.DepthwiseConv2dNativeBackpropInput,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:a,attrs:r}=e,{dy:o,filter:i}=t,{strides:s,dilations:u,pad:l,dimRoundingMode:c,inputShape:d}=r,p=n.backend_util.computeConv2DInfo(d,i.shape,s,u,l,c,!0),h=new bo(p);return a.runWebGLProgram(h,[o,i],"float32")}};class $o{constructor(e){this.variableNames=["X"],this.outputShape=[e,e],this.userCode="\n      void main() {\n          ivec2 coords = getOutputCoords();\n          float val = coords[0] == coords[1] ? getX(coords[0]) : 0.0;\n          setOutput(val);\n      }\n    "}}const Io={kernelName:n.Diag,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:a}=e,{x:r}=t,o=[...r.shape,...r.shape],i=n.util.sizeFromShape(r.shape),s=sa({inputs:{x:r},backend:a,attrs:{shape:[i]}}),u=new $o(i),l=a.runWebGLProgram(u,[s],s.dtype),c=sa({inputs:{x:l},backend:a,attrs:{shape:o}});return a.disposeIntermediateTensorInfo(s),a.disposeIntermediateTensorInfo(l),c}};class yo{constructor(e){this.variableNames=["x","W"],this.outputShape=e.outShape;const{inHeight:n,inWidth:t,padInfo:a,strideHeight:r,strideWidth:o,filterHeight:i,filterWidth:s,dilationHeight:u,dilationWidth:l}=e,{top:c,left:d}=a;this.userCode=`\n      const ivec2 strides = ivec2(${r}, ${o});\n      const ivec2 pads = ivec2(${c}, ${d});\n      const float neg_infinity = -3.4e38;\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords.x;\n        int d1 = coords.w;\n        ivec2 outTopLeftCorner =\n            coords.yz * strides - pads;\n        int hBeg = outTopLeftCorner.x;\n        int wBeg = outTopLeftCorner.y;\n\n        float curVal = neg_infinity;\n        for (int h = 0; h < ${i}; h++) {\n          int hIn = hBeg + h * ${u};\n\n          if (hIn >= 0 && hIn < ${n}) {\n            for (int w = 0; w < ${s}; w++) {\n              int wIn = wBeg + w * ${l};\n\n              if (wIn >= 0 && wIn < ${t}) {\n                float xVal = getX(batch, hIn, wIn, d1);\n                float wVal = getW(h, w, d1);\n\n                float val = xVal + wVal;\n                if (val > curVal) {\n                  curVal = val;\n                }\n              }\n            }\n          }\n        }\n\n        float result = curVal;\n        setOutput(result);\n      }\n    `}}const ko={kernelName:n.Dilation2D,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:a,attrs:r}=e,{x:o,filter:i}=t,{strides:s,pad:u,dilations:l}=r,c=n.backend_util.computeDilation2DInfo(o.shape,i.shape,s,u,"NHWC",l);let d;const p=new yo(c);d=a.runWebGLProgram(p,[o,i],"float32");const h=sa({inputs:{x:d},backend:a,attrs:{shape:c.outShape}});return a.disposeIntermediateTensorInfo(d),h}};const wo={kernelName:n.Einsum,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:a,attrs:r}=e,{equation:o}=r,i=t,{allDims:s,summedDims:u,idDims:l}=n.backend_util.decodeEinsumEquation(o,i.length);n.backend_util.checkEinsumDimSizes(s.length,l,i);const{path:c,steps:d}=n.backend_util.getEinsumComputePath(u,l),p=d.length;let h=null,f=s.length;const x=[];for(let e=0;e<p;++e){for(const t of d[e]){const{permutationIndices:e,expandDims:r}=n.backend_util.getEinsumPermutation(f,l[t]);let o;n.backend_util.isIdentityPermutation(e)?o=i[t]:(o=ga({inputs:{x:i[t]},backend:a,attrs:{perm:e}}),x.push(o));const s=o.shape.slice();for(let e=0;e<r.length;++e)s.splice(r[e],0,1);n.util.arraysEqual(o.shape,s)||(o=sa({inputs:{x:o},backend:a,attrs:{shape:s}}),x.push(o)),null===h?h=o:(h=oa({inputs:{a:o,b:h},backend:a}),x.push(h))}e<p-1&&(c[e]>=0&&(h=xa({inputs:{x:h},backend:a,attrs:{axis:c[e]-(s.length-f),keepDims:!1}}),x.push(h)),f--)}for(const e of x)e!==h&&a.disposeIntermediateTensorInfo(e);return h}},Ro=Qt({opSnippet:"return (x >= 0.0) ? x : (exp(x) - 1.0);",packedOpSnippet:"\n  vec4 result;\n\n  result.r = (x.r >= 0.0) ? x.r : (exp(x.r) - 1.0);\n  result.g = (x.g >= 0.0) ? x.g : (exp(x.g) - 1.0);\n  result.b = (x.b >= 0.0) ? x.b : (exp(x.b) - 1.0);\n  result.a = (x.a >= 0.0) ? x.a : (exp(x.a) - 1.0);\n\n  return result;\n"}),So={kernelName:n.Elu,backendName:"webgl",kernelFunc:Ro},To={kernelName:n.EluGrad,backendName:"webgl",kernelFunc:e=>{const{inputs:t,backend:a}=e,{dy:r,y:o}=t,i=n.env().getBool("WEBGL_PACK_BINARY_OPERATIONS")?new Wt("\n  vec4 bGTEZero = vec4(greaterThanEqual(b, vec4(0.)));\n  return (bGTEZero * a) + ((vec4(1.0) - bGTEZero) * (a * (b + vec4(1.0))));\n",r.shape,o.shape):new Vt("return (b >= 1.0) ? a : a * (b + 1.0);",r.shape,o.shape);return a.runWebGLProgram(i,[r,o],r.dtype)}},Eo=Zt({opSnippet:"return float(a == b);",packedOpSnippet:"\n  return vec4(equal(a, b));\n",dtype:"bool",cpuKernelImpl:Ln}),No={kernelName:n.Equal,backendName:"webgl",kernelFunc:Eo},Ao=Qt({opSnippet:`\n  // Error function is calculated approximately with elementary function.\n  // See "Handbook of Mathematical Functions with Formulas,\n  // Graphs, and Mathematical Tables", Abramowitz and Stegun.\n  float p = ${n.backend_util.ERF_P};\n  float a1 = ${n.backend_util.ERF_A1};\n  float a2 = ${n.backend_util.ERF_A2};\n  float a3 = ${n.backend_util.ERF_A3};\n  float a4 = ${n.backend_util.ERF_A4};\n  float a5 = ${n.backend_util.ERF_A5};\n\n  float sign = sign(x);\n  x = abs(x);\n  float t = 1.0 / (1.0 + p * x);\n  return sign * (1.0 - (((((a5*t + a4)*t) + a3)*t + a2)*t + a1)*t*exp(-x*x));\n`}),Fo={kernelName:n.Erf,backendName:"webgl",kernelFunc:Ao},_o="return exp(x);",Oo=Qt({opSnippet:_o,packedOpSnippet:_o,cpuKernelImpl:Bn}),Do={kernelName:n.Exp,backendName:"webgl",kernelFunc:Oo};function Po(e){const{inputs:t,attrs:a,backend:r}=e,{dim:o}=a,{input:i}=t,s=i.shape.length,u=i.shape.slice();let l=o;return o<0&&(n.util.assert(-(s+1)<=o,(()=>`Axis must be in the interval [${-(s+1)}, ${s}]`)),l=s+o+1),u.splice(l,0,1),sa({inputs:{x:i},backend:r,attrs:{shape:u}})}const Lo={kernelName:n.ExpandDims,backendName:"webgl",kernelFunc:Po},Bo="return exp(x) - 1.0;",Vo=Qt({opSnippet:Bo,packedOpSnippet:Bo,cpuKernelImpl:Vn}),Wo={kernelName:n.Expm1,backendName:"webgl",kernelFunc:Vo};class Uo{constructor(e,n,t){this.variableNames=["real","imag"];const a=n[1];this.outputShape=n;const r=t?`2.0 * ${Math.PI}`:`-2.0 * ${Math.PI}`,o=t?`${a}.0`:"1.0";let i;if("real"===e)i="return real * expR - imag * expI;";else{if("imag"!==e)throw new Error(`FFT component must be either "real" or "imag", got ${e}.`);i="return real * expI + imag * expR;"}this.userCode=`\n      const float exponentMultiplier = ${r};\n\n      float unaryOpComplex(float real, float expR, float imag, float expI) {\n        ${i}\n      }\n\n      float mulMatDFT(int batch, int index) {\n        float indexRatio = float(index) / float(${a});\n        float exponentMultiplierTimesIndexRatio =\n            exponentMultiplier * indexRatio;\n\n        float result = 0.0;\n\n        for (int i = 0; i < ${a}; i++) {\n          // x = (-2|2 * PI / N) * index * i;\n          float x = exponentMultiplierTimesIndexRatio * float(i);\n          float expR = cos(x);\n          float expI = sin(x);\n          float real = getReal(batch, i);\n          float imag = getImag(batch, i);\n\n          result +=\n              unaryOpComplex(real, expR, imag, expI) / ${o};\n        }\n\n        return result;\n      }\n\n      void main() {\n        ivec2 coords = getOutputCoords();\n        setOutput(mulMatDFT(coords[0], coords[1]));\n      }\n    `}}function Mo(e,t,a){const r=a.texData.get(e.dataId),o=n.util.sizeFromShape(e.shape),i=e.shape[e.shape.length-1],s=sa({inputs:{x:e},backend:a,attrs:{shape:[o/i,i]}}),u=s.shape,l=new Uo("real",u,t),c=new Uo("imag",u,t),d=[{dataId:r.complexTensorInfos.real.dataId,dtype:r.complexTensorInfos.real.dtype,shape:u},{dataId:r.complexTensorInfos.imag.dataId,dtype:r.complexTensorInfos.imag.dtype,shape:u}],p=a.runWebGLProgram(l,d,"float32"),h=a.runWebGLProgram(c,d,"float32"),f=Gt({inputs:{real:p,imag:h},backend:a});a.disposeIntermediateTensorInfo(p),a.disposeIntermediateTensorInfo(h);const x=sa({inputs:{x:f},backend:a,attrs:{shape:e.shape}});return a.disposeIntermediateTensorInfo(s),a.disposeIntermediateTensorInfo(f),x}const Go={kernelName:n.FFT,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t}=e,{input:a}=n;return Mo(a,!1,t)}};class zo{constructor(e,n){this.outputShape=[],this.customUniforms=[{name:"value",type:"float"}],this.variableNames=["x"],this.outputShape=e,this.userCode="\n      void main() {\n        // Input can be obtained from uniform value.\n        setOutput(value);\n      }\n    "}}function Xo(e){const{backend:t,attrs:a}=e,{shape:r,value:o}=a;let{dtype:i}=a;if(i=i||n.util.inferDtype(o),"string"===i){const e=n.util.getArrayFromDType(i,n.util.sizeFromShape(r));return e.fill(o),t.makeTensorInfo(r,i,e)}{const e=new zo(r,o),n=[[o]];return t.runWebGLProgram(e,[],i,n)}}const Ho={kernelName:n.Fill,backendName:"webgl",kernelFunc:Xo};class jo{constructor(e){this.variableNames=["Image"],this.outputShape=[];const n=e[2];this.outputShape=e,this.userCode=`\n        void main() {\n          ivec4 coords = getOutputCoords();\n          int x = coords[2];\n\n          int coordX = ${n} - x - 1;\n          float outputValue;\n          if(coordX >= 0 && coordX < ${n}) {\n            outputValue = getImage(coords[0], coords[1], coordX, coords[3]);\n          } else {\n            outputValue = getImage(coords[0], coords[1], coords[2], coords[3]);\n          }\n          setOutput(outputValue);\n        }\n    `}}const Ko={kernelName:n.FlipLeftRight,backendName:"webgl",kernelFunc:({inputs:e,backend:n})=>{const{image:t}=e,a=n,r=new jo(t.shape);return a.runWebGLProgram(r,[t],t.dtype)}},qo="return floor(x);",Yo=Qt({opSnippet:qo,packedOpSnippet:qo,cpuKernelImpl:Wn}),Qo={kernelName:n.Floor,backendName:"webgl",kernelFunc:Yo},Zo=Zt({opSnippet:"\n  float s = sign(a) * sign(b);\n  int ia = round(a);\n  int ib = round(b);\n  if (ib != 0) {\n    // Windows (D3D) wants guaranteed non-zero int division at compile-time.\n    return float(idiv(ia, ib, s));\n  } else {\n    return NAN;\n  }\n",packedOpSnippet:"\n  ivec4 ia = round(a);\n  ivec4 ib = round(b);\n  bvec4 cond = notEqual(ib, ivec4(0));\n  ivec4 result = ivec4(0);\n  vec4 s = sign(a) * sign(b);\n\n  // Windows (D3D) wants guaranteed non-zero int division at compile-time.\n  if (cond[0]) {\n    result[0] = idiv(ia[0], ib[0], s[0]);\n  }\n  if (cond[1]) {\n    result[1] = idiv(ia[1], ib[1], s[1]);\n  }\n  if (cond[2]) {\n    result[2] = idiv(ia[2], ib[2], s[2]);\n  }\n  if (cond[3]) {\n    result[3] = idiv(ia[3], ib[3], s[3]);\n  }\n  return vec4(result);\n",dtype:"int32"}),Jo={kernelName:n.FloorDiv,backendName:"webgl",kernelFunc:Zo};class ei{constructor(e){this.variableNames=["A"];const n=oe(),[t,a]=e;this.outputShape=e,this.userCode=`\n      void main() {\n        ivec3 coords = getOutputCoords();\n        int texR = coords[0];\n        int texC = coords[1];\n        int depth = coords[2];\n        vec2 uv = (vec2(texC, texR) + halfCR) / vec2(${a}.0, ${t}.0);\n\n        vec4 values = ${n.texture2D}(A, uv);\n        float value;\n        if (depth == 0) {\n          value = values.r;\n        } else if (depth == 1) {\n          value = values.g;\n        } else if (depth == 2) {\n          value = values.b;\n        } else if (depth == 3) {\n          value = values.a;\n        }\n\n        setOutput(floor(value * 255.0 + 0.5));\n      }\n    `}}class ni{constructor(e){this.variableNames=["A"],this.packedInputs=!1,this.packedOutput=!0;const n=oe(),[t,a]=e;this.outputShape=e,this.userCode=`\n      void main() {\n        ivec3 coords = getOutputCoords();\n        int texR = coords[0];\n        int texC = coords[1];\n        int depth = coords[2];\n\n        vec4 result = vec4(0.);\n\n        for(int row=0; row<=1; row++) {\n          for(int col=0; col<=1; col++) {\n            texC = coords[1] + row;\n            depth = coords[2] + col;\n\n            vec2 uv = (vec2(texC, texR) + halfCR) /\n                       vec2(${a}.0, ${t}.0);\n            vec4 values = ${n.texture2D}(A, uv);\n            float value;\n            if (depth == 0) {\n              value = values.r;\n            } else if (depth == 1) {\n              value = values.g;\n            } else if (depth == 2) {\n              value = values.b;\n            } else if (depth == 3) {\n              value = values.a;\n            }\n\n            result[row * 2 + col] = floor(value * 255.0 + 0.5);\n          }\n        }\n\n        ${n.output} = result;\n      }\n    `}}const ti={kernelName:n.FromPixels,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:a,attrs:r}=e;let{pixels:o}=t;const{numChannels:i}=r,u="undefined"!=typeof HTMLVideoElement&&o instanceof HTMLVideoElement,l="undefined"!=typeof HTMLImageElement&&o instanceof HTMLImageElement,[c,d]=u?[o.videoWidth,o.videoHeight]:[o.width,o.height],p=[d,c],h=[d,c,i];(l||u)&&(null==ai&&(ai=document.createElement("canvas").getContext("2d")),ai.canvas.width=c,ai.canvas.height=d,ai.drawImage(o,0,0,c,d),o=ai.canvas);const f=a.makeTensorInfo(p,"int32");a.texData.get(f.dataId).usage=s.PIXELS,a.gpgpu.uploadPixelDataToTexture(a.getTexture(f.dataId),o);const x=n.env().getBool("WEBGL_PACK")?new ni(h):new ei(h),m=a.runWebGLProgram(x,[f],"int32");return a.disposeData(f.dataId),m}};let ai;const ri={kernelName:n.FusedConv2D,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:a,attrs:r}=e,{x:o,filter:i,bias:s,preluActivationWeights:u}=t,{strides:l,pad:c,dataFormat:d,dilations:p,dimRoundingMode:h,activation:f,leakyreluAlpha:x}=r,m=n.backend_util.convertConv2DDataFormat(d),g=n.backend_util.computeConv2DInfo(o.shape,i.shape,l,p,c,h,!1,m);let b;const v=[];if(1!==g.filterHeight||1!==g.filterWidth||1!==g.dilationHeight||1!==g.dilationWidth||1!==g.strideHeight||1!==g.strideWidth||"SAME"!==g.padInfo.type&&"VALID"!==g.padInfo.type)if(n.env().getBool("WEBGL_CONV_IM2COL")&&1===o.shape[0])b=Gr({x:o,filter:i,convInfo:g,backend:a,bias:s,activation:f,preluActivationWeights:u,leakyreluAlpha:x});else{const e=null!=s,t=null!=u,r="leakyrelu"===f,l=f?Jt(f,!1):null,c=new Vr(g,e,l,t,r),d=[o,i];if(s&&d.push(s),u&&d.push(u),r){const e=a.makeTensorInfo([],"float32",n.util.createScalarValue(x,"float32"));d.push(e),v.push(e)}b=a.runWebGLProgram(c,d,"float32")}else b=Mr({x:o,filter:i,convInfo:g,backend:a,bias:s,activation:f,preluActivationWeights:u,leakyreluAlpha:x});const C=sa({inputs:{x:b},backend:a,attrs:{shape:g.outShape}});return v.push(b),v.forEach((e=>a.disposeIntermediateTensorInfo(e))),C}};const oi={kernelName:n.FusedDepthwiseConv2D,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:a,attrs:r}=e,{x:o,filter:i,bias:s,preluActivationWeights:u}=t,{strides:l,pad:c,dilations:d,dimRoundingMode:p,activation:h,leakyreluAlpha:f}=r,x=[];let m=d;null==m&&(m=[1,1]),n.util.assert(n.backend_util.eitherStridesOrDilationsAreOne(l,m),(()=>`Error in depthwiseConv2d: Either strides or dilations must be 1. Got strides ${l} and dilations '${m}'`));const g=n.backend_util.computeConv2DInfo(o.shape,i.shape,l,m,c,p,!0),b=n.env().getBool("WEBGL_PACK_DEPTHWISECONV")&&g.strideWidth<=2&&g.outChannels/g.inChannels==1,v=h?Jt(h,b):null,C=[o,i],$=null!=s,I=null!=u,y="leakyrelu"===h;if($&&C.push(s),I&&C.push(u),y){const e=a.makeTensorInfo([],"float32",n.util.createScalarValue(f,"float32"));C.push(e),x.push(e)}let k;k=b?new xo(g,$,v,I,y):new fo(g,$,v,I,y);const w=[[g.padInfo.top,g.padInfo.left],[g.strideHeight,g.strideWidth],[g.dilationHeight,g.dilationWidth],[g.inHeight,g.inWidth]],R=a.runWebGLProgram(k,C,"float32",w);return x.forEach((e=>a.disposeIntermediateTensorInfo(e))),R}};class ii{constructor(e,n,t){this.sliceDim=e,this.strides=n,this.variableNames=["x","indices"],this.outputShape=t;const a=Ie(n.length),r=Ie(t.length),o=this.sliceDim>1?"strides[j]":"strides";this.userCode=`\n        ${a} strides = ${a}(${this.strides});\n         void main() {\n          ${r} coords = getOutputCoords();\n          int flattenIndex = 0;\n          for (int j = 0; j < ${this.sliceDim}; j++) {\n            int index = round(getIndices(coords[0], j));\n            flattenIndex += index * ${o};\n          }\n          setOutput(getX(flattenIndex, coords[1]));\n        }\n      `}}const si={kernelName:n.GatherNd,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:a}=e,{params:r,indices:o}=t,i=o.shape,s=i[i.length-1],u=n.util.sizeFromShape(r.shape),[l,c,d,p]=n.backend_util.prepareAndValidate(r,o),h=sa({inputs:{x:o},backend:a,attrs:{shape:[c,s]}}),f=sa({inputs:{x:r},backend:a,attrs:{shape:[n.util.sizeFromShape(r.shape)/d,d]}});if(a.shouldExecuteOnCPU([r,o])||"string"===r.dtype){const e=a.readSync(o.dataId),n=a.bufferSync(r),t=Un(e,n,r.dtype,c,s,d,p,r.shape,u);return a.makeTensorInfo(l,r.dtype,t.values)}const x=new ii(s,p,[c,d]),m=a.runWebGLProgram(x,[f,h],f.dtype),g=sa({inputs:{x:m},backend:a,attrs:{shape:l}});return a.disposeIntermediateTensorInfo(h),a.disposeIntermediateTensorInfo(f),a.disposeIntermediateTensorInfo(m),g}};class ui{constructor(e,n){this.variableNames=["A","indices"],this.outputShape=n,this.rank=n.length;const t=Ie(this.rank),a=function(e,n){const t=["resRC.x","resRC.y","resRC.z","resRC.w"],a=[];for(let n=0;n<e.length;n++)2===n?a.push("int(getIndices(resRC.x, resRC.z))"):a.push(`${t[n]}`);return a.join()}(e);this.userCode=`\n      void main() {\n        ${t} resRC = getOutputCoords();\n        setOutput(getA(${a}));\n      }\n    `}}function li(e){const{inputs:t,backend:a,attrs:r}=e,{x:o,indices:i}=t,{axis:s,batchDims:u}=r,l=n.util.parseAxisParam(s,o.shape)[0],c=n.backend_util.segment_util.collectGatherOpShapeInfo(o,i,l,u),d=n.util.sizeFromShape(i.shape),p=[],h=sa({inputs:{x:o},backend:a,attrs:{shape:[c.batchSize,c.outerSize,c.dimSize,c.sliceSize]}}),f=sa({inputs:{x:i},backend:a,attrs:{shape:[c.batchSize,d/c.batchSize]}});p.push(h),p.push(f);const x=[c.batchSize,c.outerSize,d/c.batchSize,c.sliceSize];if(a.shouldExecuteOnCPU([o,i])||"string"===o.dtype){const e=a.bufferSync(f),n=a.bufferSync(h),t=Mn(n,e,x);return p.forEach((e=>a.disposeIntermediateTensorInfo(e))),a.makeTensorInfo(c.outputShape,t.dtype,t.values)}const m=new ui(h.shape,x),g=a.runWebGLProgram(m,[h,f],h.dtype);p.push(g);const b=sa({inputs:{x:g},backend:a,attrs:{shape:c.outputShape}});return p.forEach((e=>a.disposeIntermediateTensorInfo(e))),b}const ci={kernelName:n.GatherV2,backendName:"webgl",kernelFunc:li},di=Zt({opSnippet:"return float(a > b);",packedOpSnippet:"\n  return vec4(greaterThan(a, b));\n",cpuKernelImpl:Gn,dtype:"bool"}),pi={kernelName:n.Greater,backendName:"webgl",kernelFunc:di},hi=Zt({opSnippet:"return float(a >= b);",packedOpSnippet:"\n  return vec4(greaterThanEqual(a, b));\n",dtype:"bool",cpuKernelImpl:zn}),fi={kernelName:n.GreaterEqual,backendName:"webgl",kernelFunc:hi};const xi={kernelName:n.IFFT,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t}=e,{input:a}=n;return Mo(a,!0,t)}},mi=Qt({opSnippet:"return float(!isnan(x) && !isinf(x));",dtype:"bool"}),gi={kernelName:n.IsFinite,backendName:"webgl",kernelFunc:mi},bi=Qt({opSnippet:"return float(isinf(x));",dtype:"bool"}),vi={kernelName:n.IsInf,backendName:"webgl",kernelFunc:bi},Ci=Qt({opSnippet:"return float(isnan(x));",dtype:"bool"}),$i={kernelName:n.IsNan,backendName:"webgl",kernelFunc:Ci},Ii=Zt({opSnippet:"return float(a < b);",packedOpSnippet:"\n  return vec4(lessThan(a, b));\n",cpuKernelImpl:Xn,dtype:"bool"}),yi={kernelName:n.Less,backendName:"webgl",kernelFunc:Ii},ki=Zt({opSnippet:"return float(a <= b);",packedOpSnippet:"\n  return vec4(lessThanEqual(a, b));\n",cpuKernelImpl:Hn,dtype:"bool"}),wi={kernelName:n.LessEqual,backendName:"webgl",kernelFunc:ki};const Ri={kernelName:n.LinSpace,backendName:"webgl",kernelFunc:function(e){const{backend:n,attrs:t}=e,{start:a,stop:r,num:o}=t,i=jn(a,r,o);return n.makeTensorInfo([i.length],"float32",i)}},Si=Qt({opSnippet:"if (x < 0.0) return NAN;\n  return log(x);",packedOpSnippet:"\n  vec4 result = log(x);\n  vec4 isNaN = vec4(lessThan(x, vec4(0.0)));\n  result.r = isNaN.r == 1.0 ? NAN : result.r;\n  result.g = isNaN.g == 1.0 ? NAN : result.g;\n  result.b = isNaN.b == 1.0 ? NAN : result.b;\n  result.a = isNaN.a == 1.0 ? NAN : result.a;\n\n  return result;\n",cpuKernelImpl:Kn}),Ti={kernelName:n.Log,backendName:"webgl",kernelFunc:Si},Ei=Qt({opSnippet:"return log(1.0 + x);"}),Ni={kernelName:n.Log1p,backendName:"webgl",kernelFunc:Ei},Ai=Zt({opSnippet:"return float(a >= 1.0 && b >= 1.0);",packedOpSnippet:"\n  return vec4(\n    vec4(greaterThanEqual(a, vec4(1.0))) *\n    vec4(greaterThanEqual(b, vec4(1.0))));\n",dtype:"bool"}),Fi={kernelName:n.LogicalAnd,backendName:"webgl",kernelFunc:Ai},_i=Qt({opSnippet:"return float(!(x >= 1.0));"}),Oi={kernelName:n.LogicalNot,backendName:"webgl",kernelFunc:_i},Di=Zt({opSnippet:"return float(a >= 1.0 || b >= 1.0);",packedOpSnippet:"\n  return min(\n    vec4(greaterThanEqual(a, vec4(1.0))) +\n    vec4(greaterThanEqual(b, vec4(1.0))),\n    vec4(1.0));\n",dtype:"bool"}),Pi={kernelName:n.LogicalOr,backendName:"webgl",kernelFunc:Di};class Li{constructor(e,n,t,a,r){this.variableNames=["x"],this.outputShape=[];const o=n,i=e[3]-1;let s;this.outputShape=e;const u=`float(${t}) + float(${a}) * sum`;s=.5===r?`inversesqrt(${u})`:1===r?`1.0/(${u})`:`exp(log(${u}) * float(-${r}));`,this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int r = coords[1];\n        int c = coords[2];\n        int d = coords[3];\n        float x = getX(b, r, c, d);\n        float sum = 0.0;\n        for (int j = -${o}; j <= ${o}; j++) {\n          int idx = d + j;\n          if (idx >= 0 && idx <=  ${i}) {\n            float z = getX(b, r, c, idx);\n            sum += z * z;\n          }\n        }\n        float val = x * ${s};\n        setOutput(val);\n      }\n    `}}class Bi{constructor(e,n,t,a,r){this.variableNames=["x"],this.outputShape=[],this.packedInputs=!0,this.packedOutput=!0;const o=n,i=e[3]-1;let s;this.outputShape=e;const u=`float(${t}) + float(${a}) * sum`;s=.5===r?`inversesqrt(${u})`:1===r?`1.0/(${u})`:`exp(log(${u}) * float(-${r}));`,this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords.x;\n        int r = coords.y;\n        int c = coords.z;\n        int d = coords.w;\n\n        bool hasNextCol = d < ${this.outputShape[3]};\n        bool hasNextRow = c < ${this.outputShape[2]};\n\n        vec4 sum = vec4(0.);\n        vec4 xFragAtOutputCoords = getX(b, r, c, d);\n\n        vec4 xAtOutputCoords = vec4(\n          getChannel(xFragAtOutputCoords, vec2(c, d)),\n          hasNextCol ?\n            getChannel(xFragAtOutputCoords, vec2(c, d + 1)) : 0.0,\n          hasNextRow ?\n            getChannel(xFragAtOutputCoords , vec2(c + 1, d)) : 0.0,\n          (hasNextRow && hasNextCol) ?\n            getChannel(xFragAtOutputCoords, vec2(c + 1, d + 1)) : 0.0\n        );\n\n        int firstChannel = d - ${o};\n        vec2 cache = vec2(0.);\n        if(firstChannel >= 0){\n          vec4 firstChannelFrag = getX(b, r, c, firstChannel);\n          cache.x = getChannel(firstChannelFrag, vec2(c, firstChannel));\n            if(hasNextRow){\n              cache.y = getChannel(firstChannelFrag, vec2(c + 1, firstChannel));\n            }\n        }\n\n        ivec2 depth = ivec2(d, d + 1);\n        for (int j = - ${o}; j <= ${o}; j++) {\n          ivec2 idx = depth + j;\n          bvec2 aboveLowerBound = greaterThanEqual(idx, ivec2(0));\n          bvec2 belowUpperBound = lessThanEqual(idx, ivec2(${i}));\n\n          bool depthInRange = aboveLowerBound.x && belowUpperBound.x;\n          bool depthPlusOneInRange = aboveLowerBound.y && belowUpperBound.y;\n\n          if(depthInRange || depthPlusOneInRange){\n            vec4 z = vec4(0.);\n            vec4 xFragAtCurrentDepth;\n            z.xz = cache.xy;\n            if(depthPlusOneInRange && hasNextCol){\n              xFragAtCurrentDepth = idx.y != d ?\n                getX(b, r, c, idx.y) : xFragAtOutputCoords;\n              z.y = getChannel(xFragAtCurrentDepth, vec2(c, idx.y));\n              if(hasNextRow){\n                z.w = getChannel(xFragAtCurrentDepth, vec2(c + 1, idx.y));\n              }\n            }\n            cache.xy = z.yw;\n            sum += z * z;\n          }\n        }\n        vec4 result = xAtOutputCoords * ${s};\n        setOutput(result);\n      }\n    `}}const Vi={kernelName:n.LRN,backendName:"webgl",kernelFunc:e=>{const{inputs:t,backend:a,attrs:r}=e,{x:o}=t,{depthRadius:i,bias:s,alpha:u,beta:l}=r,c=n.env().getBool("WEBGL_PACK_NORMALIZATION")?new Bi(o.shape,i,s,u,l):new Li(o.shape,i,s,u,l);return a.runWebGLProgram(c,[o],o.dtype)}};class Wi{constructor(e,n,t,a,r){this.variableNames=["inputImage","outputImage","dy"],this.outputShape=[],this.outputShape=e,this.depth=e[3],this.depthRadius=n,this.bias=t,this.alpha=a,this.beta=r,this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int r = coords[1];\n        int c = coords[2];\n\n        float result = 0.0;\n        for (int d = 0; d < ${this.depth}; ++d) {\n          int depthBegin = int(max(0.0, float(d - ${n})));\n          int depthEnd = int(min(float(${this.depth}),\n              float(d + ${n} + 1)));\n\n          const int MIN_DEPTH_BEGIN = 0;\n          const int MAX_DEPTH_END = ${this.depth};\n\n          float norm = 0.0;\n          for (int k = MIN_DEPTH_BEGIN; k < MAX_DEPTH_END; ++k) {\n            if (k < depthBegin){\n              continue;\n            }\n            else if (k >= depthBegin && k < depthEnd) {\n              norm += getInputImage(b, r, c, k) * getInputImage(b, r, c, k);\n            }\n            else {\n              break;\n            }\n          }\n\n          norm = float(${a}) * norm + float(${t});\n\n          for(int k = MIN_DEPTH_BEGIN; k < MAX_DEPTH_END; ++k){\n            if (k < depthBegin){\n              continue;\n            }\n            else if (k >= depthBegin && k < depthEnd){\n              float dyi = -2.0 * float(${a})\n                * float(${r})\n                * getInputImage(b ,r ,c, k) * getOutputImage(b, r, c, d)\n                / norm;\n              if (k == d) {\n                dyi += pow(norm, -1.0 * ${r});\n              }\n              if (k == coords[3]) {\n                dyi *= getDy(b, r, c, d);\n                result += dyi;\n              }\n            }\n            else {\n              break;\n            }\n          }\n      }\n      setOutput(result);\n      }\n    `}}const Ui={kernelName:n.LRNGrad,backendName:"webgl",kernelFunc:e=>{const{inputs:n,backend:t,attrs:a}=e,{x:r,y:o,dy:i}=n,{depthRadius:s,bias:u,alpha:l,beta:c}=a,d=new Wi(r.shape,s,u,l,c);return t.runWebGLProgram(d,[r,o,i],r.dtype)}};function Mi(e){const{inputs:t,backend:a,attrs:r}=e,{x:o}=t,{reductionIndices:i,keepDims:s}=r,u=o.shape.length,l=n.util.parseAxisParam(i,o.shape);let c=l;const d=n.backend_util.getAxesPermutation(c,u),p=null!=d,h=a.shouldExecuteOnCPU([o]);let f=o;if(p){if(h){const e=a.texData.get(f.dataId).values,n=new Array(u);for(let e=0;e<n.length;e++)n[e]=o.shape[d[e]];const t=bt(e,o.shape,o.dtype,d,n);f=a.makeTensorInfo(n,o.dtype);a.texData.get(f.dataId).values=t}else f=fa(o,d,a);c=n.backend_util.getInnerMostAxes(c.length,u)}n.backend_util.assertAxesAreInnerMostDims("max",c,u);const[x,m]=n.backend_util.computeOutAndReduceShapes(f.shape,c);let g,b=x;if(s&&(b=n.backend_util.expandShapeToKeepDim(x,l)),h){const e=a.texData.get(f.dataId).values,t=qn(e,n.util.sizeFromShape(m),b,o.dtype);g=a.makeTensorInfo(b,o.dtype);a.texData.get(g.dataId).values=t}else g=function(e,t,a,r){const o=n.util.sizeFromShape(t),i=sa({inputs:{x:e},attrs:{shape:[n.util.sizeFromShape(e.shape)/o,o]},backend:r}),s=da(i,e.dtype,"max",r),u=sa({inputs:{x:s},attrs:{shape:a},backend:r});return r.disposeIntermediateTensorInfo(i),r.disposeIntermediateTensorInfo(s),u}(f,m,b,a);return p&&a.disposeIntermediateTensorInfo(f),g}const Gi={kernelName:n.Max,backendName:"webgl",kernelFunc:Mi},zi=Zt({opSnippet:"\n  if (isnan(a)) return a;\n  if (isnan(b)) return b;\n\n  return max(a, b);\n",packedOpSnippet:"\n  vec4 result = vec4(max(a, b));\n  vec4 isNaN = min(vec4(isnan(a)) + vec4(isnan(b)), vec4(1.0));\n  \n  result.r = isNaN.r > 0. ? NAN : result.r;\n  result.g = isNaN.g > 0. ? NAN : result.g;\n  result.b = isNaN.b > 0. ? NAN : result.b;\n  result.a = isNaN.a > 0. ? NAN : result.a;\n\n  return result;\n",cpuKernelImpl:Yn}),Xi={kernelName:n.Maximum,backendName:"webgl",kernelFunc:zi};const Hi={kernelName:n.MaxPool,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:a,attrs:r}=e,{x:o}=t;te(o,"maxPool");const{filterSize:i,strides:s,pad:u,dimRoundingMode:l}=r;n.util.assert(n.backend_util.eitherStridesOrDilationsAreOne(s,1),(()=>`Error in maxPool: Either strides or dilations must be 1. Got strides ${s} and dilations '1'`));const c=n.backend_util.computePool2DInfo(o.shape,i,s,1,u,l);if(1===c.filterWidth&&1===c.filterHeight&&n.util.arraysEqual(c.inShape,c.outShape))return Ut({inputs:{x:o},backend:a});const d=new Za(c,"max",!1);return a.runWebGLProgram(d,[o],o.dtype)}};const ji={kernelName:n.MaxPool3D,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:a,attrs:r}=e,{x:o}=t,{filterSize:i,strides:s,pad:u,dataFormat:l,dimRoundingMode:c}=r,d=n.backend_util.computePool3DInfo(o.shape,i,s,[1,1,1],u,c,l),p=new Ja(d,"max",!1);return a.runWebGLProgram(p,[o],o.dtype)}};class Ki{constructor(e){this.variableNames=["dy","maxPos"],this.outputShape=e.inShape;const n=e.strideHeight,t=e.strideWidth,a=e.dilationHeight,r=e.effectiveFilterHeight,o=e.effectiveFilterWidth,i=r-1-e.padInfo.top,s=o-1-e.padInfo.left,u=r*o-1;this.userCode=`\n      const ivec2 pads = ivec2(${i}, ${s});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n\n        ivec2 dyRCCorner = coords.yz - pads;\n        int dyRCorner = dyRCCorner.x;\n        int dyCCorner = dyRCCorner.y;\n\n        // Convolve dy(?, ?, d) with pos mask(:, :, d) to get dx(xR, xC, d).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n        for (int wR = 0; wR < ${r};\n          wR += ${a}) {\n          float dyR = float(dyRCorner + wR) / ${n}.0;\n\n          if (dyR < 0.0 || dyR >= ${e.outHeight}.0 || fract(dyR) > 0.0) {\n            continue;\n          }\n          int idyR = int(dyR);\n\n          for (int wC = 0; wC < ${o}; wC++) {\n            float dyC = float(dyCCorner + wC) / ${t}.0;\n\n            if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                fract(dyC) > 0.0) {\n              continue;\n            }\n            int idyC = int(dyC);\n\n            float dyValue = getDy(b, idyR, idyC, d);\n            int maxPosValue = ${u} - int(getMaxPos(b, idyR, idyC, d));\n\n            // Get the current value, check it against the value from the\n            // position matrix.\n            int curPosValue = wR * ${o} + wC;\n            float mask = float(maxPosValue == curPosValue ? 1.0 : 0.0);\n\n            dotProd += dyValue * mask;\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class qi{constructor(e){this.variableNames=["dy","maxPos"],this.outputShape=e.inShape;const n=e.strideDepth,t=e.strideHeight,a=e.strideWidth,r=e.dilationDepth,o=e.dilationHeight,i=e.dilationWidth,s=e.effectiveFilterDepth,u=e.effectiveFilterHeight,l=e.effectiveFilterWidth,c=s-1-e.padInfo.front,d=u-1-e.padInfo.top,p=l-1-e.padInfo.left,h=s*u*l-1;this.userCode=`\n      const ivec3 pads = ivec3(${c}, ${d}, ${p});\n\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int batch = coords.x;\n        int ch = coords.u;\n\n        ivec3 dyCorner = ivec3(coords.y, coords.z, coords.w) - pads;\n        int dyDCorner = dyCorner.x;\n        int dyRCorner = dyCorner.y;\n        int dyCCorner = dyCorner.z;\n\n        // Convolve dy(?, ?, ?, ch) with pos mask(:, :, :, d) to get\n        // dx(xD, xR, xC, ch).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n\n        for (int wD = 0; wD < ${s};\n           wD += ${r}) {\n          float dyD = float(dyDCorner + wD) / ${n}.0;\n\n          if (dyD < 0.0 || dyD >= ${e.outDepth}.0 || fract(dyD) > 0.0) {\n            continue;\n          }\n          int idyD = int(dyD);\n\n          for (int wR = 0; wR < ${u};\n              wR += ${o}) {\n            float dyR = float(dyRCorner + wR) / ${t}.0;\n\n            if (dyR < 0.0 || dyR >= ${e.outHeight}.0 ||\n                fract(dyR) > 0.0) {\n              continue;\n            }\n            int idyR = int(dyR);\n\n            for (int wC = 0; wC < ${l};\n                wC += ${i}) {\n              float dyC = float(dyCCorner + wC) / ${a}.0;\n\n              if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                  fract(dyC) > 0.0) {\n                continue;\n              }\n              int idyC = int(dyC);\n\n              float dyValue = getDy(batch, idyD, idyR, idyC, ch);\n              int maxPosValue = ${h} -\n                  int(getMaxPos(batch, idyD, idyR, idyC, ch));\n\n              // Get the current value, check it against the value from the\n              // position matrix.\n              int curPosValue =\n                  wD * ${u} * ${l} +\n                  wR * ${l} + wC;\n              float mask = float(maxPosValue == curPosValue ? 1.0 : 0.0);\n\n              dotProd += dyValue * mask;\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}const Yi={kernelName:n.MaxPool3DGrad,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:a,attrs:r}=e,{dy:o,input:i}=t,s=i,{filterSize:u,strides:l,pad:c,dimRoundingMode:d}=r,p=n.backend_util.computePool3DInfo(s.shape,u,l,[1,1,1],c,d),h=new Ja(p,"max",!0),f=a.runWebGLProgram(h,[s],s.dtype),x=new qi(p),m=a.runWebGLProgram(x,[o,f],s.dtype);return a.disposeIntermediateTensorInfo(f),m}};const Qi={kernelName:n.MaxPoolGrad,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:a,attrs:r}=e,{dy:o,input:i,output:s}=t,u=i;te([i,s],"maxPoolGrad");const{filterSize:l,strides:c,pad:d,dimRoundingMode:p}=r,h=n.backend_util.computePool2DInfo(u.shape,l,c,1,d,p),f=new Za(h,"max",!0),x=a.runWebGLProgram(f,[u],u.dtype),m=new Ki(h),g=a.runWebGLProgram(m,[o,x],u.dtype);return a.disposeIntermediateTensorInfo(x),g}};const Zi={kernelName:n.MaxPoolWithArgmax,backendName:"webgl",kernelFunc:({inputs:e,attrs:t,backend:a})=>{const{x:r}=e,{filterSize:o,strides:i,pad:s,includeBatchInIndex:u}=t,l=a;n.util.assert(4===r.shape.length,(()=>`Error in maxPool: input must be rank 4 but got rank ${r.shape.length}.`));const c=[1,1];n.util.assert(n.backend_util.eitherStridesOrDilationsAreOne(i,c),(()=>`Error in maxPool: Either strides or dilations must be 1. Got strides ${i} and dilations '${c}'`));const d=n.backend_util.computePool2DInfo(r.shape,o,i,c,s),[p,h]=function(e,n,t,a){let r=new Za(t,"max",!1);const o=a.runWebGLProgram(r,[e],"float32");return r=new Za(t,"max",!0,!0,n),[o,a.runWebGLProgram(r,[e],"float32")]}(r,u,d,l);return[p,h]}};const Ji={kernelName:n.Mean,backendName:"webgl",kernelFunc:({inputs:e,attrs:t,backend:a})=>{const{x:r}=e,{keepDims:o,axis:i}=t,s=a,u=r.shape.length,l=n.util.parseAxisParam(i,r.shape);let c=l;const d=n.backend_util.getAxesPermutation(c,u),p=null!=d,h=s.shouldExecuteOnCPU([r]),f=[];let x=r;if(p){if(h){const e=s.texData.get(x.dataId).values,n=new Array(u);for(let e=0;e<n.length;e++)n[e]=r.shape[d[e]];const t=bt(e,r.shape,r.dtype,d,n);x=s.makeTensorInfo(n,r.dtype);s.texData.get(x.dataId).values=t}else x=fa(r,d,s);f.push(x),c=n.backend_util.getInnerMostAxes(c.length,u)}n.backend_util.assertAxesAreInnerMostDims("sum",c,u);const[m,g]=n.backend_util.computeOutAndReduceShapes(x.shape,c);let b=m;o&&(b=n.backend_util.expandShapeToKeepDim(m,l));const v=function(e,t,a,r){const o=n.util.sizeFromShape(t),i=sa({inputs:{x:e},attrs:{shape:[n.util.sizeFromShape(e.shape)/o,o]},backend:r}),s=da(i,"float32","mean",r),u=sa({inputs:{x:s},attrs:{shape:a},backend:r});return r.disposeIntermediateTensorInfo(i),r.disposeIntermediateTensorInfo(s),u}(x,g,b,s);for(const e of f)s.disposeIntermediateTensorInfo(e);return v}};const es={kernelName:n.Min,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:a,attrs:r}=e,{x:o}=t,{axis:i,keepDims:s}=r,u=o.shape.length,l=n.util.parseAxisParam(i,o.shape);let c=l;const d=n.backend_util.getAxesPermutation(c,u);let p=o;null!=d&&(p=ga({inputs:{x:o},backend:a,attrs:{perm:d}}),c=n.backend_util.getInnerMostAxes(c.length,o.shape.length)),n.backend_util.assertAxesAreInnerMostDims("min",c,u);const[h,f]=n.backend_util.computeOutAndReduceShapes(p.shape,c),x=sa({inputs:{x:p},backend:a,attrs:{shape:[-1,n.util.sizeFromShape(f)]}}),m=da(x,x.dtype,"min",a);let g;if(s){g=sa({inputs:{x:m},backend:a,attrs:{shape:n.backend_util.expandShapeToKeepDim(h,l)}})}else g=sa({inputs:{x:m},backend:a,attrs:{shape:h}});return a.disposeIntermediateTensorInfo(x),a.disposeIntermediateTensorInfo(m),null!=d&&a.disposeIntermediateTensorInfo(p),g}},ns=Zt({opSnippet:"\n  if (isnan(a)) return a;\n  if (isnan(b)) return b;\n\n  return min(a, b);\n",packedOpSnippet:"\n  vec4 result = vec4(min(a, b));\n  vec4 isNaN = min(vec4(isnan(a)) + vec4(isnan(b)), vec4(1.0));\n  \n  result.r = isNaN.r > 0. ? NAN : result.r;\n  result.g = isNaN.g > 0. ? NAN : result.g;\n  result.b = isNaN.b > 0. ? NAN : result.b;\n  result.a = isNaN.a > 0. ? NAN : result.a;\n\n  return result;\n",cpuKernelImpl:Qn}),ts={kernelName:n.Minimum,backendName:"webgl",kernelFunc:ns};class as{constructor(e,n,t){this.variableNames=["x"],this.outputShape=n.map(((n,t)=>n[0]+e[t]+n[1]));const a=e.length,r=Ie(a),o=n.map((e=>e[0])).join(","),i=n.map(((n,t)=>n[0]+e[t])).join(","),s=["coords[0]","coords[1]","coords[2]","coords[3]"].slice(0,a),u="reflect"===t?0:1;this.userCode=1!==a?`\n      ${r} start = ${r}(${o});\n      ${r} end = ${r}(${i});\n\n      void main() {\n        ${r} outC = getOutputCoords();\n        for (int i = 0; i < ${a}; i++) {\n          if (outC[i] < start[i]) {\n            outC[i] = start[i] * 2 - outC[i] - ${u};\n          } else if(outC[i] >= end[i]) {\n            outC[i] = (end[i] - 1) * 2 - outC[i] + ${u};\n          }\n        }\n        ${r} coords = outC - start;\n        setOutput(getX(${s}));\n      }\n    `:`\n        int start = ${o};\n        int end = ${i};\n\n        void main() {\n          int outC = getOutputCoords();\n          if (outC < start) {\n            outC = start * 2 - outC - ${u};\n          } else if(outC >= end) {\n            outC = (end - 1) * 2 - outC + ${u};\n          }\n          setOutput(getX(outC - start));\n        }\n      `}}class rs{constructor(e,n,t){this.variableNames=["x"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=n.map(((n,t)=>n[0]+e[t]+n[1]));const a=e.length,r=Ie(a),o=n.map((e=>e[0])).join(","),i=n.map(((n,t)=>n[0]+e[t])).join(","),s=$t("rc",a),u=$t("source",a),l=`${s[a-1]} < ${this.outputShape[a-1]}`,c=1===a?"source":`vec2(${u.slice(-2).join()})`,d="reflect"===t?0:1;let p="";if(1===a){const e=`\n        ${r} source = rc;\n        if (source < start) {\n          source = start * 2 - source - ${d};\n        } else if (source >= end) {\n          source = (end - 1) * 2 - source + ${d};\n        }\n        source -= start;\n      `;p=`\n        ${r} rc = outputLoc;\n        ${e}\n        result[0] = getChannel(getX(${u.join()}), ${c});\n        ${s[a-1]} += 1;\n        if(${l}) {\n          ${e}\n          result[1] = getChannel(getX(${u.join()}), ${c});\n        }\n      `}else{const e=`\n        ${r} source = rc;\n        ${r} lt = ${r}(lessThan(source, start));\n        ${r} gte = ${r}(greaterThanEqual(source, end));\n        ${r} orig = 1 - (lt + gte);\n        source = orig * source +\n                lt * (start * 2 - source - ${d}) +\n                gte * ((end - 1) * 2 - source + ${d});\n        source -= start;\n      `;p=`\n        ${r} rc = outputLoc;\n        ${e}\n        result[0] = getChannel(getX(${u.join()}), ${c});\n        ${s[a-1]} += 1;\n        if(${l}) {\n          ${e}\n          result[1] = getChannel(getX(${u.join()}), ${c});\n        }\n        rc = outputLoc;\n        ${s[a-2]} += 1;\n        if(${s[a-2]} < ${this.outputShape[a-2]}) {\n          ${e}\n          result[2] = getChannel(getX(${u.join()}), ${c});\n          ${s[a-1]} += 1;\n          if(${l}) {\n            ${e}\n            result[3] = getChannel(getX(${u.join()}), ${c});\n          }\n        }\n      `}this.userCode=`\n      const ${r} start = ${r}(${o});\n      const ${r} end = ${r}(${i});\n\n      void main() {\n        ${r} outputLoc = getOutputCoords();\n        vec4 result = vec4(0.);\n        ${p}\n        setOutput(result);\n      }\n    `}}const os={kernelName:n.MirrorPad,backendName:"webgl",kernelFunc:({inputs:e,backend:t,attrs:a})=>{const{x:r}=e,{paddings:o,mode:i}=a,s=n.env().getBool("WEBGL_PACK_ARRAY_OPERATIONS")?new rs(r.shape,o,i):new as(r.shape,o,i);return t.runWebGLProgram(s,[r],r.dtype)}},is=Zt({opSnippet:"if (b == 0.0) return NAN;\n  return mod(a, b);",packedOpSnippet:"\n  vec4 result = mod(a, b);\n  vec4 isNaN = vec4(equal(b, vec4(0.0)));\n  \n  result.r = isNaN.r > 0. ? NAN : result.r;\n  result.g = isNaN.g > 0. ? NAN : result.g;\n  result.b = isNaN.b > 0. ? NAN : result.b;\n  result.a = isNaN.a > 0. ? NAN : result.a;\n\n  return result;\n"}),ss={kernelName:n.Mod,backendName:"webgl",kernelFunc:is};class us{constructor(e,n,t){this.variableNames=["probs"],this.customUniforms=[{name:"seed",type:"float"}],this.outputShape=[e,t],this.userCode=`\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int batch = coords[0];\n\n        float r = random(seed);\n        float cdf = 0.0;\n\n        for (int i = 0; i < ${n-1}; i++) {\n          cdf += getProbs(batch, i);\n\n          if (r < cdf) {\n            setOutput(float(i));\n            return;\n          }\n        }\n\n        // If no other event happened, last event happened.\n        setOutput(float(${n-1}));\n      }\n    `}}const ls=Zt({opSnippet:"\nif (a == b) {\n  return 1.0;\n};\nreturn a / b;",packedOpSnippet:"\n  // vec4 one = vec4(equal(a, b));\n  // return one + (vec4(1.0) - one) * a / b;\n  vec4 result = a / b;\n  if(a.x == b.x) {\n    result.x = 1.;\n  }\n  if(a.y == b.y) {\n    result.y = 1.;\n  }\n  if(a.z == b.z) {\n    result.z = 1.;\n  }\n  if(a.w == b.w) {\n    result.w = 1.;\n  }\n\n  return result;\n",checkOutOfBounds:!0}),cs={kernelName:n.RealDiv,backendName:"webgl",kernelFunc:ls},ds="return a - b;",ps=Zt({opSnippet:ds,packedOpSnippet:ds,supportsComplex:!0,cpuKernelImpl:xt}),hs={kernelName:n.Sub,backendName:"webgl",kernelFunc:ps};function fs(e){const{inputs:t,backend:a,attrs:r}=e,{logits:o}=t,{dim:i}=r,s=n.util.parseAxisParam([i],o.shape),u=Mi({inputs:{x:o},backend:a,attrs:{reductionIndices:s,keepDims:!1}}),l=n.backend_util.expandShapeToKeepDim(u.shape,s),c=sa({inputs:{x:u},backend:a,attrs:{shape:l}}),d=ps({inputs:{a:o,b:c},backend:a}),p=Oo({inputs:{x:d},backend:a}),h=xa({inputs:{x:p},backend:a,attrs:{axis:s,keepDims:!1}}),f=sa({inputs:{x:h},backend:a,attrs:{shape:l}}),x=ls({inputs:{a:p,b:f},backend:a});return a.disposeIntermediateTensorInfo(u),a.disposeIntermediateTensorInfo(c),a.disposeIntermediateTensorInfo(d),a.disposeIntermediateTensorInfo(p),a.disposeIntermediateTensorInfo(h),a.disposeIntermediateTensorInfo(f),x}const xs={kernelName:n.Softmax,backendName:"webgl",kernelFunc:fs};const ms={kernelName:n.Multinomial,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t,attrs:a}=e,{logits:r}=n,{numSamples:o,seed:i,normalized:s}=a,u=s?r:fs({inputs:{logits:r},backend:t,attrs:{dim:r.shape.length-1}}),l=u.shape[0],c=u.shape[1],d=new us(l,c,o),p=[[i]],h=t.runWebGLProgram(d,[u],"int32",p);return s||t.disposeIntermediateTensorInfo(u),h}},gs="return -x;";const bs={kernelName:n.Neg,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:a}=e,{x:r}=t;if(a.shouldExecuteOnCPU([r])){const e=a.texData.get(r.dataId),[n,t]=Jn(e.values,r.shape,r.dtype);return a.makeTensorInfo(t,r.dtype,n)}let o;return o=n.env().getBool("WEBGL_PACK_UNARY_OPERATIONS")?new At(r.shape,gs):new Tt(r.shape,gs),a.runWebGLProgram(o,[r],r.dtype)}},vs=n.kernel_impls.nonMaxSuppressionV3Impl;const Cs={kernelName:n.NonMaxSuppressionV3,backendName:"webgl",kernelFunc:function(e){n.backend_util.warn("tf.nonMaxSuppression() in webgl locks the UI thread. Call tf.nonMaxSuppressionAsync() instead");const{inputs:t,backend:a,attrs:r}=e,{boxes:o,scores:i}=t,{maxOutputSize:s,iouThreshold:u,scoreThreshold:l}=r,c=a.readSync(o.dataId),d=a.readSync(i.dataId),{selectedIndices:p}=vs(c,d,s,u,l);return a.makeTensorInfo([p.length],"int32",new Int32Array(p))}},$s=n.kernel_impls.nonMaxSuppressionV4Impl;const Is={kernelName:n.NonMaxSuppressionV4,backendName:"webgl",kernelFunc:function(e){n.backend_util.warn("tf.nonMaxSuppression() in webgl locks the UI thread. Call tf.nonMaxSuppressionAsync() instead");const{inputs:t,backend:a,attrs:r}=e,{boxes:o,scores:i}=t,{maxOutputSize:s,iouThreshold:u,scoreThreshold:l,padToMaxOutputSize:c}=r,d=a.readSync(o.dataId),p=a.readSync(i.dataId),{selectedIndices:h,validOutputs:f}=$s(d,p,s,u,l,c);return[a.makeTensorInfo([h.length],"int32",new Int32Array(h)),a.makeTensorInfo([],"int32",new Int32Array([f]))]}},ys=n.kernel_impls.nonMaxSuppressionV5Impl;const ks={kernelName:n.NonMaxSuppressionV5,backendName:"webgl",kernelFunc:function(e){n.backend_util.warn("tf.nonMaxSuppression() in webgl locks the UI thread. Call tf.nonMaxSuppressionAsync() instead");const{inputs:t,backend:a,attrs:r}=e,{boxes:o,scores:i}=t,{maxOutputSize:s,iouThreshold:u,scoreThreshold:l,softNmsSigma:c}=r,d=a.readSync(o.dataId),p=a.readSync(i.dataId),h=s,f=u,x=l,m=c,{selectedIndices:g,selectedScores:b}=ys(d,p,h,f,x,m);return[a.makeTensorInfo([g.length],"int32",new Int32Array(g)),a.makeTensorInfo([b.length],"float32",new Float32Array(b))]}};class ws{constructor(e,n,t,a){this.variableNames=["indices"],this.outputShape=[e,n],this.userCode=`\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int index = round(getIndices(coords.x));\n        setOutput(mix(float(${a}), float(${t}),\n                      float(index == coords.y)));\n      }\n    `}}const Rs={kernelName:n.OneHot,backendName:"webgl",kernelFunc:e=>{const{inputs:t,backend:a,attrs:r}=e,{indices:o}=t,{depth:i,onValue:s,offValue:u}=r,l=n.util.sizeFromShape(o.shape),c=new ws(l,i,s,u),d=sa({inputs:{x:o},backend:a,attrs:{shape:[l]}}),p=a.runWebGLProgram(c,[d],o.dtype);a.disposeIntermediateTensorInfo(d);const h=sa({inputs:{x:p},backend:a,attrs:{shape:[...o.shape,i]}});return a.disposeIntermediateTensorInfo(p),h}};function Ss(e){const{inputs:n,backend:t}=e,{x:a}=n;if("complex64"===a.dtype){const e=vr({inputs:{input:a},backend:t}),n=Ss({inputs:{x:e},backend:t}),r=Or({inputs:{input:a},backend:t}),o=Ss({inputs:{x:r},backend:t}),i=Gt({inputs:{real:n,imag:o},backend:t});return t.disposeIntermediateTensorInfo(e),t.disposeIntermediateTensorInfo(n),t.disposeIntermediateTensorInfo(r),t.disposeIntermediateTensorInfo(o),i}return Xo({attrs:{shape:a.shape,dtype:a.dtype,value:"string"===a.dtype?"":0},backend:t})}const Ts={kernelName:n.ZerosLike,backendName:"webgl",kernelFunc:Ss};const Es={kernelName:n.OnesLike,backendName:"webgl",kernelFunc:function e(n){const{inputs:t,backend:a}=n,{x:r}=t;if("string"===r.dtype)throw new Error("onesLike is not supported under string dtype");if("complex64"===r.dtype){const n=vr({inputs:{input:r},backend:a}),t=e({inputs:{x:n},backend:a}),o=Or({inputs:{input:r},backend:a}),i=Ss({inputs:{x:o},backend:a}),s=Gt({inputs:{real:t,imag:i},backend:a});return a.disposeIntermediateTensorInfo(n),a.disposeIntermediateTensorInfo(t),a.disposeIntermediateTensorInfo(o),a.disposeIntermediateTensorInfo(i),s}return Xo({attrs:{shape:r.shape,dtype:r.dtype,value:1},backend:a})}};const Ns={kernelName:n.Pack,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:a,attrs:r}=e,{axis:o}=r;if(1===t.length)return Po({inputs:{input:t[0]},backend:a,attrs:{dim:o}});const i=t[0].shape,s=t[0].dtype;t.forEach((e=>{n.util.assertShapesMatch(i,e.shape,"All tensors passed to stack must have matching shapes"),n.util.assert(s===e.dtype,(()=>"All tensors passed to stack must have matching dtypes"))}));const u=[],l=Lr({inputs:t.map((e=>{const n=Po({inputs:{input:e},backend:a,attrs:{dim:o}});return u.push(n),n})),backend:a,attrs:{axis:o}});return u.forEach((e=>a.disposeIntermediateTensorInfo(e))),l}};class As{constructor(e,n,t){this.variableNames=["x"],this.customUniforms=[{name:"value",type:"float"}],this.outputShape=n.map(((n,t)=>n[0]+e[t]+n[1]));const a=e.length,r=Ie(a),o=n.map((e=>e[0])).join(","),i=n.map(((n,t)=>n[0]+e[t])).join(","),s=["coords[0]","coords[1]","coords[2]","coords[3]"].slice(0,a);this.userCode=1!==a?`\n      ${r} start = ${r}(${o});\n      ${r} end = ${r}(${i});\n\n      void main() {\n        ${r} outC = getOutputCoords();\n        if (any(lessThan(outC, start)) || any(greaterThanEqual(outC, end))) {\n          setOutput(value);\n        } else {\n          ${r} coords = outC - start;\n          setOutput(getX(${s}));\n        }\n      }\n    `:`\n        int start = ${o};\n        int end = ${i};\n\n        void main() {\n          int outC = getOutputCoords();\n          if (outC < start || outC >= end) {\n            setOutput(value);\n          } else {\n            setOutput(getX(outC - start));\n          }\n        }\n      `}}class Fs{constructor(e,n,t){this.variableNames=["x"],this.packedInputs=!0,this.packedOutput=!0,this.customUniforms=[{name:"value",type:"float"}],this.outputShape=n.map(((n,t)=>n[0]+e[t]+n[1]));const a=e.length,r=Ie(a),o=n.map((e=>e[0])).join(","),i=n.map(((n,t)=>n[0]+e[t])).join(","),s=$t("rc",a),u=$t("source",a),l=`${s[a-1]} < ${this.outputShape[a-1]}`,c=1===a?"source":`vec2(${u.slice(-2).join()})`,d=[`${r} rc = outputLoc;`,`${s[a-1]} += 1;\n       if(${l}) {\n      `,1===a?"":`}\n       rc = outputLoc;\n       ${s[a-2]} += 1;\n       if(${s[a-2]} < ${this.outputShape[a-2]}) {`,1===a?"":`  ${s[a-1]} += 1;\n         if(${l}) {`],p=1===a?"rc < start || rc >= end":"any(lessThan(rc, start)) || any(greaterThanEqual(rc, end))";let h="";for(let e=0,n=1===a?2:4;e<n;e++)h+=`\n        ${d[e]}\n        if (${p}) {\n          result[${e}] = float(value);\n        } else {\n          ${r} source = rc - start;\n          result[${e}] = getChannel(getX(${u.join()}), ${c});\n        }\n      `;h+=1===a?"} ":"}}",this.userCode=`\n      const ${r} start = ${r}(${o});\n      const ${r} end = ${r}(${i});\n\n      void main() {\n        ${r} outputLoc = getOutputCoords();\n        vec4 result = vec4(0.);\n        ${h}\n        setOutput(result);\n      }\n    `}}const _s=e=>{const{inputs:t,backend:a,attrs:r}=e,{x:o}=t,{paddings:i,constantValue:s}=r;if(0===n.util.sizeFromShape(o.shape)){return Xo({backend:a,attrs:{shape:i.map(((e,n)=>e[0]+o.shape[n]+e[1])),value:s,dtype:o.dtype}})}const u=n.env().getBool("WEBGL_PACK_ARRAY_OPERATIONS")?new Fs(o.shape,i,s):new As(o.shape,i,s),l=[[s]];return a.runWebGLProgram(u,[o],o.dtype,l)},Os={kernelName:n.PadV2,backendName:"webgl",kernelFunc:_s},Ds=Zt({opSnippet:"\n  if(a < 0.0 && floor(b) < b){\n    return NAN;\n  }\n  if (b == 0.0) {\n    return 1.0;\n  }\n  return (round(mod(b, 2.0)) != 1) ?\n      pow(abs(a), b) : sign(a) * pow(abs(a), b);\n",packedOpSnippet:"\n  // isModRound1 has 1 for components with round(mod(b, 2.0)) == 1, 0 otherwise.\n  vec4 isModRound1 = vec4(equal(round(mod(b, 2.0)), ivec4(1)));\n  vec4 multiplier = sign(a) * isModRound1 + (vec4(1.0) - isModRound1);\n  vec4 result = multiplier * pow(abs(a), b);\n\n  // Ensure that a^0 = 1, including 0^0 = 1 as this correspond to TF and JS\n  bvec4 isExpZero = equal(b, vec4(0.0));\n  result.r = isExpZero.r ? 1.0 : result.r;\n  result.g = isExpZero.g ? 1.0 : result.g;\n  result.b = isExpZero.b ? 1.0 : result.b;\n  result.a = isExpZero.a ? 1.0 : result.a;\n\n  vec4 isNaN = vec4(lessThan(a, vec4(0.0))) * vec4(lessThan(floor(b), b));\n  \n  result.r = isNaN.r > 0. ? NAN : result.r;\n  result.g = isNaN.g > 0. ? NAN : result.g;\n  result.b = isNaN.b > 0. ? NAN : result.b;\n  result.a = isNaN.a > 0. ? NAN : result.a;\n\n  return result;\n"}),Ps={kernelName:n.Pow,backendName:"webgl",kernelFunc:Ds};const Ls={kernelName:n.Prod,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:a,attrs:r}=e,{x:o}=t,{axis:i,keepDims:s}=r,u=o.shape.length,l=[],c=n.util.parseAxisParam(i,o.shape);let d=c;const p=n.backend_util.getAxesPermutation(d,u);let h,f=o;if(null!=p&&(f=ga({inputs:{x:o},backend:a,attrs:{perm:p}}),d=n.backend_util.getInnerMostAxes(d.length,u),l.push(f)),n.backend_util.assertAxesAreInnerMostDims("prod",d,u),a.shouldExecuteOnCPU([f])){const e=a.texData.get(f.dataId).values,{outVals:n,outShape:t,outDtype:r}=nt(f.shape,f.dtype,e,d);h=a.makeTensorInfo(t,r,n)}else{const[e,t]=n.backend_util.computeOutAndReduceShapes(f.shape,d),r=n.util.sizeFromShape(t),i=sa({inputs:{x:f},backend:a,attrs:{shape:[-1,r]}}),s=da(i,n.sumOutType(o.dtype),"prod",a);h=sa({inputs:{x:s},backend:a,attrs:{shape:e}}),l.push(i),l.push(s)}if(s){l.push(h);const e=n.backend_util.expandShapeToKeepDim(h.shape,c);h=sa({inputs:{x:h},backend:a,attrs:{shape:e}})}return l.forEach((e=>a.disposeIntermediateTensorInfo(e))),h}},Bs=e=>{const{backend:n,attrs:t}=e,{start:a,stop:r,step:o,dtype:i}=t,s=tt(a,r,o,i);return n.makeTensorInfo([s.length],i,s)},Vs={kernelName:n.Range,backendName:"webgl",kernelFunc:Bs},Ws=Qt({opSnippet:"return 1.0 / x;"}),Us={kernelName:n.Reciprocal,backendName:"webgl",kernelFunc:Ws},Ms=Qt({opSnippet:"if (isnan(x)) return x;\n  return (x < 0.0) ? 0.0 : x;\n",packedOpSnippet:"\n  vec4 result = x * vec4(greaterThanEqual(x, vec4(0.0)));\n  bvec4 isNaN = isnan(x);\n\n  result.r = isNaN.r ? x.r : result.r;\n  result.g = isNaN.g ? x.g : result.g;\n  result.b = isNaN.b ? x.b : result.b;\n  result.a = isNaN.a ? x.a : result.a;\n\n  return result;\n"}),Gs={kernelName:n.Relu,backendName:"webgl",kernelFunc:Ms},zs=Qt({opSnippet:"if (isnan(x)) return x;\n  return (x < 0.0) ? 0.0 : min(6.0, x);\n",packedOpSnippet:"\n  vec4 result = min(x, vec4(6.)) * vec4(greaterThanEqual(x, vec4(0.0)));\n  bvec4 isNaN = isnan(x);\n\n  result.r = isNaN.r ? x.r : result.r;\n  result.g = isNaN.g ? x.g : result.g;\n  result.b = isNaN.b ? x.b : result.b;\n  result.a = isNaN.a ? x.a : result.a;\n\n  return result;\n"}),Xs={kernelName:n.Relu6,backendName:"webgl",kernelFunc:zs};class Hs{constructor(e,n,t,a,r){this.variableNames=["A"],this.outputShape=[];const[o,i,s,u]=e;this.outputShape=[o,n,t,u];const l=[a&&n>1?i-1:i,a&&t>1?s-1:s],c=[a&&n>1?n-1:n,a&&t>1?t-1:t];let d;d=r?"(vec2(yRC) + vec2(0.5)) * effectiveInputOverOutputRatioRC - vec2(0.5)":"vec2(yRC) * effectiveInputOverOutputRatioRC",this.userCode=`\n      const vec2 effectiveInputOverOutputRatioRC = vec2(\n          ${l[0]/c[0]},\n          ${l[1]/c[1]});\n      const vec2 inputShapeRC = vec2(${i}.0, ${s}.0);\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n        ivec2 yRC = coords.yz;\n\n        // Fractional source index.\n        vec2 sourceFracIndexRC = ${d};\n\n        // Compute the four integer indices.\n        ivec2 sourceFloorRC = ivec2(max(sourceFracIndexRC, vec2(0.0)));\n        ivec2 sourceCeilRC = ivec2(\n          min(inputShapeRC - 1.0, ceil(sourceFracIndexRC)));\n\n        float topLeft = getA(b, sourceFloorRC.x, sourceFloorRC.y, d);\n        float bottomLeft = getA(b, sourceCeilRC.x, sourceFloorRC.y, d);\n        float topRight = getA(b, sourceFloorRC.x, sourceCeilRC.y, d);\n        float bottomRight = getA(b, sourceCeilRC.x, sourceCeilRC.y, d);\n\n        vec2 fracRC = sourceFracIndexRC - vec2(sourceFloorRC);\n\n        float top = topLeft + (topRight - topLeft) * fracRC.y;\n        float bottom = bottomLeft + (bottomRight - bottomLeft) * fracRC.y;\n        float newValue = top + (bottom - top) * fracRC.x;\n\n        setOutput(newValue);\n      }\n    `}}class js{constructor(e,n,t,a,r){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=[];const[o,i,s,u]=e;this.outputShape=[o,n,t,u];const l=[a&&n>1?i-1:i,a&&t>1?s-1:s],c=[a&&n>1?n-1:n,a&&t>1?t-1:t];let d;d=r?"(vec3(yRC) + vec3(0.5)) * effectiveInputOverOutputRatioRC - vec3(0.5)":"vec3(yRC) * effectiveInputOverOutputRatioRC",this.userCode=`\n      const vec3 effectiveInputOverOutputRatioRC = vec3(\n          ${l[0]/c[0]},\n          ${l[1]/c[1]},\n          ${l[1]/c[1]});\n      const vec3 inputShapeRC = vec3(${i}.0, ${s}.0,\n                                     ${s}.0);\n\n      float getAValue(int b, int r, int c, int d) {\n        return getChannel(getA(b, r, c, d), vec2(c, d));\n      }\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n        // Calculate values for next column in yRC.z.\n        ivec3 yRC = coords.yzz + ivec3(0, 0, 1);\n\n        // Fractional source index.\n        vec3 sourceFracIndexRC = ${d};\n\n        // Compute the four integer indices.\n        ivec3 sourceFloorRC = ivec3(max(sourceFracIndexRC, vec3(0.0)));\n        ivec3 sourceCeilRC = ivec3(\n          min(inputShapeRC - 1.0, ceil(sourceFracIndexRC)));\n\n        // Should we calculate next column and row elements in 2x2 packed cell.\n        bool hasNextCol = d < ${u-1};\n        bool hasNextRow = coords.z < ${t-1};\n\n        // In parallel, construct four corners for all four components in\n        // packed 2x2 cell.\n        vec4 topLeft = vec4(\n          getAValue(b, sourceFloorRC.x, sourceFloorRC.y, d),\n          hasNextCol ? getAValue(b, sourceFloorRC.x, sourceFloorRC.y, d + 1)\n                     : 0.0,\n          hasNextRow ? getAValue(b, sourceFloorRC.x, sourceFloorRC.z, d)\n                     : 0.0,\n          (hasNextRow && hasNextCol) ?\n            getAValue(b, sourceFloorRC.x, sourceFloorRC.z, d + 1) : 0.0);\n\n        vec4 bottomLeft = vec4(\n          getAValue(b, sourceCeilRC.x, sourceFloorRC.y, d),\n          hasNextCol ? getAValue(b, sourceCeilRC.x, sourceFloorRC.y, d + 1)\n                     : 0.0,\n          hasNextRow ? getAValue(b, sourceCeilRC.x, sourceFloorRC.z, d)\n                     : 0.0,\n          (hasNextRow && hasNextCol) ?\n            getAValue(b, sourceCeilRC.x, sourceFloorRC.z, d + 1) : 0.0);\n\n        vec4 topRight = vec4(\n          getAValue(b, sourceFloorRC.x, sourceCeilRC.y, d),\n          hasNextCol ? getAValue(b, sourceFloorRC.x, sourceCeilRC.y, d + 1)\n                     : 0.0,\n          hasNextRow ? getAValue(b, sourceFloorRC.x, sourceCeilRC.z, d)\n                     : 0.0,\n          (hasNextRow && hasNextCol) ?\n            getAValue(b, sourceFloorRC.x, sourceCeilRC.z, d + 1) : 0.0);\n\n        vec4 bottomRight = vec4(\n          getAValue(b, sourceCeilRC.x, sourceCeilRC.y, d),\n          hasNextCol ? getAValue(b, sourceCeilRC.x, sourceCeilRC.y, d + 1)\n                     : 0.0,\n          hasNextRow ? getAValue(b, sourceCeilRC.x, sourceCeilRC.z, d)\n                     : 0.0,\n          (hasNextRow && hasNextCol) ?\n            getAValue(b, sourceCeilRC.x, sourceCeilRC.z, d + 1) : 0.0);\n\n        vec3 fracRC = sourceFracIndexRC - vec3(sourceFloorRC);\n\n        vec4 top = mix(topLeft, topRight, fracRC.yyzz);\n        vec4 bottom = mix(bottomLeft, bottomRight, fracRC.yyzz);\n        vec4 newValue = mix(top, bottom, fracRC.x);\n\n        setOutput(newValue);\n      }\n    `}}const Ks={kernelName:n.ResizeBilinear,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:a,attrs:r}=e,{images:o}=t,{alignCorners:i,halfPixelCenters:s,size:u}=r,[l,c]=u,d=n.env().getBool("WEBGL_PACK_IMAGE_OPERATIONS")?new js(o.shape,l,c,i,s):new Hs(o.shape,l,c,i,s);return a.runWebGLProgram(d,[o],"float32")}};class qs{constructor(e,n,t){this.variableNames=["dy"],this.outputShape=[],this.outputShape=n;const[,a,r]=n,[,o,i]=e,s=[t&&o>1?a-1:a,t&&i>1?r-1:r],u=[t&&o>1?o-1:o,t&&i>1?i-1:i],l=s[0]/u[0],c=s[1]/u[1],d=1/l,p=1/c,h=2*Math.ceil(d)+2,f=2*Math.ceil(p)+2;this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n        int r = coords[1];\n        int c = coords[2];\n\n        float accumulator = 0.0;\n\n        const float heightScale = float(${l});\n        const float widthScale = float(${c});\n\n        const float invHeightScale = float(${d});\n        const float invWidthScale = float(${p});\n\n        const int winHeight = int(${h});\n        const int winWidth = int(${f});\n\n        // Compute bounds for where in dy we will look\n        float startRLerp = floor(float(r) * invHeightScale);\n        int startDyR = int(startRLerp - float(winHeight / 2));\n\n        float startCLerp = floor(float(c) * invWidthScale);\n        int startDyC = int(startCLerp - float(winWidth / 2));\n\n        // Loop over dy\n        for (int dyROffset = 0; dyROffset < winHeight; dyROffset++) {\n          int dyR = dyROffset + startDyR;\n\n          // Guard against the window exceeding the bounds of dy\n          if (dyR < 0 || dyR >= ${o}) {\n            continue;\n          }\n\n          for (int dyCOffset = 0; dyCOffset < winWidth; dyCOffset++) {\n            int dyC = dyCOffset + startDyC;\n\n            // Guard against the window exceeding the bounds of dy\n            if (dyC < 0 || dyC >= ${i}) {\n              continue;\n            }\n\n            float dxR = float(dyR) * heightScale;\n            int topDxRIndex = int(floor(dxR));\n            int bottomDxRIndex = int(min(ceil(dxR), ${a-1}.0));\n            float dxRLerp = dxR - float(topDxRIndex);\n            float inverseDxRLerp = 1.0 - dxRLerp;\n\n            float dxC = float(dyC) * widthScale;\n            int leftDxCIndex = int(floor(dxC));\n            int rightDxCIndex = int(min(ceil(dxC), ${r-1}.0));\n            float dxCLerp = dxC - float(leftDxCIndex);\n            float inverseDxCLerp = 1.0 - dxCLerp;\n\n            if (r == topDxRIndex && c == leftDxCIndex) {\n              // topLeft\n              accumulator +=\n                getDy(b, dyR, dyC, d) * inverseDxRLerp * inverseDxCLerp;\n            }\n\n            if (r == topDxRIndex && c == rightDxCIndex) {\n              // topRight\n              accumulator += getDy(b, dyR, dyC, d) * inverseDxRLerp * dxCLerp;\n            }\n\n            if (r == bottomDxRIndex && c == leftDxCIndex) {\n              // bottomLeft\n              accumulator += getDy(b, dyR, dyC, d) * dxRLerp * inverseDxCLerp;\n            }\n\n            if (r == bottomDxRIndex && c == rightDxCIndex) {\n              // bottomRight\n              accumulator += getDy(b, dyR, dyC, d) * dxRLerp * dxCLerp;\n            }\n          }\n        }\n        // End loop over dy\n\n        setOutput(accumulator);\n      }\n    `}}const Ys={kernelName:n.ResizeBilinearGrad,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t,attrs:a}=e,{images:r,dy:o}=n,{alignCorners:i}=a,s=new qs(o.shape,r.shape,i);return t.runWebGLProgram(s,[o],o.dtype)}};class Qs{constructor(e,n,t,a,r){this.variableNames=["A"],this.outputShape=[];const[o,i,s,u]=e;this.outputShape=[o,n,t,u];const l=[a&&n>1?i-1:i,a&&t>1?s-1:s],c=[a&&n>1?n-1:n,a&&t>1?t-1:t],d=a?"0.5":"0.0";let p;p=r?"max((vec2(yRC) + vec2(0.5)) * effectiveInputOverOutputRatioRC, vec2(0.0))":"vec2(yRC) * effectiveInputOverOutputRatioRC",this.userCode=`\n      const vec2 effectiveInputOverOutputRatioRC = vec2(\n          ${l[0]/c[0]},\n          ${l[1]/c[1]});\n      const vec2 inputShapeRC = vec2(${i}.0, ${s}.0);\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n        ivec2 yRC = coords.yz;\n\n        // Fractional source index.\n        vec2 sourceFracIndexRC = ${p};\n\n        // Compute the coordinators of nearest neighbor point.\n        ivec2 sourceNearestRC = ivec2(\n          min(inputShapeRC - 1.0, floor(sourceFracIndexRC + ${d})));\n        float newValue = getA(b, sourceNearestRC.x, sourceNearestRC.y, d);\n\n        setOutput(newValue);\n      }\n    `}}class Zs{constructor(e,n,t,a,r){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=[];const[o,i,s,u]=e;this.outputShape=[o,n,t,u];const l=[a&&n>1?i-1:i,a&&t>1?s-1:s],c=[a&&n>1?n-1:n,a&&t>1?t-1:t],d=a?"0.5":"0.0";let p;p=r?"max((vec3(yRC) + vec3(0.5)) * effectiveInputOverOutputRatioRC, vec3(0.0))":"vec3(yRC) * effectiveInputOverOutputRatioRC",this.userCode=`\n      const vec3 effectiveInputOverOutputRatioRC = vec3(\n          ${l[0]/c[0]},\n          ${l[1]/c[1]},\n          ${l[1]/c[1]});\n      const vec3 inputShapeRC = vec3(${i}.0, ${s}.0,\n                                     ${s}.0);\n\n      float getAValue(int b, int r, int c, int d) {\n        return getChannel(getA(b, r, c, d), vec2(c, d));\n      }\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n        // Calculate values for next column in yRC.z.\n        ivec3 yRC = coords.yzz + ivec3(0, 0, 1);\n\n        // Fractional source index.\n        vec3 sourceFracIndexRC = ${p};\n\n        // Compute the coordinators of nearest neighbor point.\n        ivec3 sourceNearestRC = ivec3(\n          min(inputShapeRC - 1.0, floor(sourceFracIndexRC + ${d})));\n\n        // Should we calculate next column and row elements in 2x2 packed cell.\n        bool hasNextCol = d < ${u-1};\n        bool hasNextRow = coords.z < ${t-1};\n\n        vec4 newValue = vec4(\n          getAValue(b, sourceNearestRC.x, sourceNearestRC.y, d),\n          hasNextCol ? getAValue(b, sourceNearestRC.x, sourceNearestRC.y, d + 1)\n                     : 0.0,\n          hasNextRow ? getAValue(b, sourceNearestRC.x, sourceNearestRC.z, d)\n                     : 0.0,\n          (hasNextRow && hasNextCol) ?\n            getAValue(b, sourceNearestRC.x, sourceNearestRC.z, d + 1) : 0.0);\n\n        setOutput(newValue);\n      }\n    `}}const Js={kernelName:n.ResizeNearestNeighbor,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:a,attrs:r}=e,{images:o}=t,{alignCorners:i,halfPixelCenters:s,size:u}=r,[l,c]=u,d=n.env().getBool("WEBGL_PACK_IMAGE_OPERATIONS")?new Zs(o.shape,l,c,i,s):new Qs(o.shape,l,c,i,s);return a.runWebGLProgram(d,[o],o.dtype)}};class eu{constructor(e,n,t){this.variableNames=["dy"],this.outputShape=[],this.outputShape=n;const[,a,r]=n,[,o,i]=e,s=[t&&o>1?a-1:a,t&&i>1?r-1:r],u=[t&&o>1?o-1:o,t&&i>1?i-1:i],l=s[0]/u[0],c=s[1]/u[1],d=1/l,p=1/c,h=2*Math.ceil(d)+2,f=2*Math.ceil(p)+2;this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n        int r = coords[1];\n        int c = coords[2];\n\n        float accumulator = 0.0;\n\n        const float heightScale = float(${l});\n        const float widthScale = float(${c});\n\n        const float invHeightScale = float(${d});\n        const float invWidthScale = float(${p});\n\n        const int winHeight = int(${h});\n        const int winWidth = int(${f});\n\n        // Compute bounds for where in dy we will look\n        float startRLerp = floor(float(r) * invHeightScale);\n        int startDyR = int(floor(startRLerp - float(winHeight / 2)));\n\n        float startCLerp = floor(float(c) * invWidthScale);\n        int startDyC = int(floor(startCLerp - float(winWidth / 2)));\n\n        // Loop over dy\n        for (int dyROffset = 0; dyROffset < winHeight; dyROffset++) {\n          int dyR = dyROffset + startDyR;\n\n          // Guard against the window exceeding the bounds of dy\n          if (dyR < 0 || dyR >= ${o}) {\n            continue;\n          }\n\n          for (int dyCOffset = 0; dyCOffset < winWidth; dyCOffset++) {\n            int dyC = dyCOffset + startDyC;\n\n            // Guard against the window exceeding the bounds of dy\n            if (dyC < 0 || dyC >= ${i}) {\n              continue;\n            }\n\n            float sourceFracRow =\n              float(${s[0]}) *\n                (float(dyR) / float(${u[0]}));\n\n            float sourceFracCol =\n                float(${s[1]}) *\n                  (float(dyC) / float(${u[1]}));\n\n            int sourceNearestRow = int(min(\n                float(int(${a}) - 1),\n                ${t} ? float(round(sourceFracRow)) :\n                                  float(floor(sourceFracRow))));\n\n            int sourceNearestCol = int(min(\n                float(int(${r}) - 1),\n                ${t} ? float(round(sourceFracCol)) :\n                                  float(floor(sourceFracCol))));\n\n            if (r == sourceNearestRow && c == sourceNearestCol) {\n              accumulator += getDy(b, dyR, dyC, d);\n            }\n          }\n        }\n        // End loop over dy\n\n        setOutput(accumulator);\n      }\n    `}}const nu={kernelName:n.ResizeNearestNeighborGrad,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t,attrs:a}=e,{images:r,dy:o}=n,{alignCorners:i}=a,s=new eu(o.shape,r.shape,i);return t.runWebGLProgram(s,[o],o.dtype)}};class tu{constructor(e,n){this.variableNames=["x"];const t=e.length;if(t>4)throw new Error(`WebGL backend: Reverse of rank-${t} tensor is not yet supported`);if(this.outputShape=e,1===t)return void(this.userCode=`\n        void main() {\n          int coord = getOutputCoords();\n          setOutput(getX(${e[0]} - coord - 1));\n        }\n      `);const a=e.map(((t,a)=>(t=>-1!==n.indexOf(t)&&1!==e[t]?`${e[t]} - coords[${t}] - 1`:`coords[${t}]`)(a))).join(","),r=Ie(t);this.userCode=`\n      void main() {\n        ${r} coords = getOutputCoords();\n        setOutput(getX(${a}));\n      }\n    `}}class au{constructor(e,n){this.variableNames=["x"],this.packedInputs=!0,this.packedOutput=!0;const t=e.length;if(t>4)throw new Error(`WebGL backend: Reverse of rank-${t} tensor is not yet supported`);this.outputShape=e;const a=$t("rc",t),r=`${a[t-1]} + 1 < ${this.outputShape[t-1]}`,o=`${a[t-2]} + 1 < ${this.outputShape[t-2]}`,i=Ie(t);function s(t){const a=e.map(((a,r)=>function(t,a){return-1!==n.indexOf(t)&&1!==e[t]?`${e[t]} - ${a[t]} - 1`:`${a[t]}`}(r,t)));return`getChannel(getX(${a.join(",")}), vec2(${a.slice(-2).join(",")}))`}this.userCode=1===t?`\n        void main(){\n          int rc = getOutputCoords();\n          vec4 result = vec4(0.);\n          result.r = getChannel(getX(${e[0]} - rc - 1),\n            ${e[0]} - rc - 1);\n          if(${r}){\n              result.g = getChannel(getX(${e[0]} - (rc  + 1) - 1),\n                ${e[0]} - (rc  + 1) - 1);\n          }\n          setOutput(result);\n        }\n      `:`\n        void main() {\n          ${i} rc = getOutputCoords();\n          vec4 result = vec4(0.);\n          result.r = ${function(e){return s(e)}(a.slice())};\n          if(${r}){\n            result.g = ${function(e){return e[t-1]="("+e[t-1]+" + 1)",s(e)}(a.slice())};\n          }\n          if(${o}) {\n            result.b = ${function(e){return e[t-2]="("+e[t-2]+" + 1)",s(e)}(a.slice())};\n            if(${r}) {\n              result.a = ${function(e){return e[t-1]="("+e[t-1]+" + 1)",e[t-2]="("+e[t-2]+" + 1)",s(e)}(a.slice())};\n            }\n          }\n          setOutput(result);\n        }\n    `}}const ru={kernelName:n.Reverse,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:a,attrs:r}=e,{x:o}=t,{dims:i}=r,s=o.shape.length,u=n.util.parseAxisParam(i,o.shape);if(0===s)return Ut({inputs:{x:o},backend:a});const l=n.env().getBool("WEBGL_PACK_ARRAY_OPERATIONS")?new au(o.shape,u):new tu(o.shape,u);return a.runWebGLProgram(l,[o],o.dtype)}};class ou{constructor(e,n){this.variableNames=["Image"],this.outputShape=[],this.customUniforms=[{name:"params",type:"vec4"}];const t=e[1],a=e[2];this.outputShape=e;let r="";r="number"==typeof n?`float outputValue = ${n.toFixed(2)};`:`\n        vec3 fill = vec3(${n.join(",")});\n        float outputValue = fill[coords[3]];`,this.userCode=`\n        void main() {\n          ivec4 coords = getOutputCoords();\n          int x = coords[2];\n          int y = coords[1];\n          float coordXFloat = (float(x) - params[0]) * params[3] -\n            (float(y) - params[1]) * params[2];\n          float coordYFloat = (float(x) - params[0]) * params[2] +\n            (float(y) - params[1]) * params[3];\n          int coordX = int(round(coordXFloat + params[0]));\n          int coordY = int(round(coordYFloat + params[1]));\n          ${r}\n          if(coordX >= 0 && coordX < ${a} && coordY >= 0 && coordY < ${t}) {\n            outputValue = getImage(coords[0], coordY, coordX, coords[3]);\n          }\n          setOutput(outputValue);\n        }\n    `}}const iu={kernelName:n.RotateWithOffset,backendName:"webgl",kernelFunc:({inputs:e,attrs:t,backend:a})=>{const{image:r}=e,{radians:o,fillValue:i,center:s}=t,u=a,l=new ou(r.shape,i),[c,d]=n.backend_util.getImageCenter(s,r.shape[1],r.shape[2]),p=[[c,d,Math.sin(o),Math.cos(o)]];return u.runWebGLProgram(l,[r],r.dtype,p)}},su=Qt({opSnippet:"\n  // OpenGL ES does not support round function.\n  // The algorithm is based on banker's rounding.\n  float base = floor(x);\n  if ((x - base) < 0.5) {\n    return floor(x);\n  } else if ((x - base) > 0.5) {\n    return ceil(x);\n  } else {\n    if (mod(base, 2.0) == 0.0) {\n      return base;\n    } else {\n      return base + 1.0;\n    }\n  }\n"}),uu={kernelName:n.Round,backendName:"webgl",kernelFunc:su},lu=Qt({opSnippet:"return inversesqrt(x);",cpuKernelImpl:at}),cu={kernelName:n.Rsqrt,backendName:"webgl",kernelFunc:lu};class du{constructor(e,n,t,a,r,o,i=!0){this.variableNames=["updates","indices","defaultValue"],this.outputShape=o;const s=Ie(r.length),u=Ie(o.length);let l="";1===t?l="i":2===t&&(l="i, j");const c=`getIndices(${l})`;let d="";1===a?d="i":2===a&&(d="i, coords[1]");const p=`getUpdates(${d})`,h=n>1?"strides[j]":"strides";this.userCode=`\n        ${s} strides = ${s}(${r});\n\n        void main() {\n          ${u} coords = getOutputCoords();\n          float sum = 0.0;\n          bool found = false;\n          for (int i = 0; i < ${e}; i++) {\n            int flattenedIndex = 0;\n            for (int j = 0; j < ${n}; j++) {\n              int index = round(${c});\n              flattenedIndex += index * ${h};\n            }\n            if (flattenedIndex == coords[0]) {\n              sum += ${p};\n              found = true;\n            }\n          }\n          setOutput(mix(getDefaultValue(), sum, float(found)));\n        }\n      `}}const pu={kernelName:n.ScatterNd,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:a,attrs:r}=e,{indices:o,updates:i}=t,{shape:s}=r,{sliceRank:u,numUpdates:l,sliceSize:c,strides:d,outputSize:p}=n.backend_util.calculateShapes(i,o,s),h=[p/c,c];if(0===p)return a.makeTensorInfo(s,o.dtype);const f=sa({inputs:{x:o},backend:a,attrs:{shape:[l,u]}}),x=sa({inputs:{x:i},backend:a,attrs:{shape:[l,c]}}),m=a.makeTensorInfo([],"float32",new Float32Array([0])),g=new du(l,u,f.shape.length,x.shape.length,d,h),b=a.runWebGLProgram(g,[x,f,m],x.dtype),v=sa({inputs:{x:b},backend:a,attrs:{shape:s}});return a.disposeIntermediateTensorInfo(f),a.disposeIntermediateTensorInfo(x),a.disposeIntermediateTensorInfo(b),a.disposeIntermediateTensorInfo(m),v}};class hu{constructor(e,n,t){let a,r;if(this.variableNames=["c","a","b"],this.outputShape=n,t>4)throw Error(`Where for rank ${t} is not yet supported`);if(1===t)r="resRC",a="resRC";else{const t=["resRC.x","resRC.y","resRC.z","resRC.w"],o=[],i=[];for(let a=0;a<n.length;a++)i.push(`${t[a]}`),a<e&&o.push(`${t[a]}`);a=o.join(),r=i.join()}const o=Ie(t);this.userCode=`\n      void main() {\n        ${o} resRC = getOutputCoords();\n        float cVal = getC(${a});\n        if (cVal >= 1.0) {\n          setOutput(getA(${r}));\n        } else {\n          setOutput(getB(${r}));\n        }\n      }\n    `}}const fu={kernelName:n.Select,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:a}=e,{condition:r,t:o,e:i}=t,s=new hu(r.shape.length,o.shape,o.shape.length);return a.runWebGLProgram(s,[r,o,i],n.upcastType(o.dtype,i.dtype))}},xu=Qt({opSnippet:`\n  // Stable and Attracting Fixed Point (0, 1) for Normalized Weights.\n  // see: https://arxiv.org/abs/1706.02515\n  float scaleAlpha = ${n.backend_util.SELU_SCALEALPHA};\n  float scale = ${n.backend_util.SELU_SCALE};\n  return (x >= 0.0) ? scale * x : scaleAlpha * (exp(x) - 1.0);\n`}),mu={kernelName:n.Selu,backendName:"webgl",kernelFunc:xu},gu="return 1.0 / (1.0 + exp(-1.0 * x));",bu=Qt({opSnippet:gu,packedOpSnippet:gu,cpuKernelImpl:rt}),vu={kernelName:n.Sigmoid,backendName:"webgl",kernelFunc:bu},Cu=Qt({opSnippet:"\n  if (isnan(x)) { return 0.0; }\n  return sign(x);\n"}),$u={kernelName:n.Sign,backendName:"webgl",kernelFunc:Cu},Iu=Qt({opSnippet:"if (isnan(x)) return x;\n  return sin(x);\n"}),yu={kernelName:n.Sin,backendName:"webgl",kernelFunc:Iu},ku=Qt({opSnippet:"\n  float e2x = exp(x);\n  return (e2x - 1.0 / e2x) / 2.0;\n"}),wu={kernelName:n.Sinh,backendName:"webgl",kernelFunc:ku},Ru=Qt({opSnippet:"\n  float epsilon = 1.1920928955078125e-7;\n  float threshold = log(epsilon) + 2.0;\n\n  bool too_large = x > -threshold;\n  bool too_small = x < threshold;\n\n  float result;\n  float exp_x = exp(x);\n\n  if (too_large){\n    result = x;\n  }\n  else if (too_small){\n    result = exp_x;\n  }\n  else{\n    result = log(exp_x + 1.0);\n  }\n  return result;\n"}),Su={kernelName:n.Softplus,backendName:"webgl",kernelFunc:Ru},Tu={kernelName:n.SpaceToBatchND,backendName:"webgl",kernelFunc:e=>{const{inputs:t,backend:a,attrs:r}=e,{x:o}=t,{blockShape:i,paddings:s}=r;n.util.assert(o.shape.length<=4,(()=>"spaceToBatchND for rank > 4 with a WebGL backend not implemented yet"));const u=i.reduce(((e,n)=>e*n)),l=[[0,0]];l.push(...s);for(let e=1+i.length;e<o.shape.length;++e)l.push([0,0]);const c=[],d=_s({inputs:{x:o},backend:a,attrs:{paddings:l,constantValue:0}}),p=n.backend_util.getReshaped(d.shape,i,u,!1),h=n.backend_util.getPermuted(p.length,i.length,!1),f=n.backend_util.getReshapedPermuted(d.shape,i,u,!1),x=sa({inputs:{x:d},backend:a,attrs:{shape:p}}),m=ga({inputs:{x:x},backend:a,attrs:{perm:h}}),g=sa({inputs:{x:m},backend:a,attrs:{shape:f}});return c.push(d),c.push(x),c.push(m),c.forEach((e=>a.disposeIntermediateTensorInfo(e))),g}};const Eu={kernelName:n.SparseFillEmptyRows,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t}=e,{indices:a,values:r,denseShape:o,defaultValue:i}=n;if(1!==o.shape.length)throw new Error(`Dense shape must be a vector, saw:\n         ${o.shape}`);if(2!==a.shape.length)throw new Error(`Indices must be a matrix, saw:\n         ${a.shape}`);if(1!==r.shape.length)throw new Error(`Values must be a vector, saw:\n         ${r.shape}`);if(0!==i.shape.length)throw new Error(`Default value must be a scalar, saw:\n        ${i.shape}`);const s=t.readSync(a.dataId),u=t.readSync(r.dataId),l=t.readSync(o.dataId),c=t.readSync(i.dataId)[0],[d,p,h,f,x]=st(s,a.shape,a.dtype,u,r.dtype,l,c);return[t.makeTensorInfo(p,a.dtype,d),t.makeTensorInfo([p[0]],r.dtype,h),t.makeTensorInfo([f.length],"bool",new Uint8Array(f.map((e=>Number(e))))),t.makeTensorInfo([x.length],a.dtype,new Int32Array(x))]}};const Nu={kernelName:n.SparseReshape,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t}=e,{inputIndices:a,inputShape:r,newShape:o}=n;if(2!==a.shape.length)throw new Error(`Input indices should be a matrix but received shape ${a.shape}`);if(1!==r.shape.length)throw new Error(`Input shape should be a vector but received shape ${r.shape}`);if(1!==o.shape.length)throw new Error(`Target shape should be a vector but received shape ${o.shape}`);const i=Array.from(t.readSync(r.dataId)),s=t.readSync(a.dataId),u=Array.from(t.readSync(o.dataId)),[l,c,d]=ut(s,a.shape,a.dtype,i,u);return[t.makeTensorInfo(c,a.dtype,l),t.makeTensorInfo([d.length],o.dtype,new Int32Array(d))]}};const Au={kernelName:n.SparseSegmentMean,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t}=e,{data:a,indices:r,segmentIds:o}=n;if(a.shape.length<1)throw new Error("Data should be at least 1 dimensional but received scalar");if(1!==r.shape.length)throw new Error(`Indices should be a vector but received shape\n              ${r.shape}`);if(1!==o.shape.length)throw new Error(`Segment ids should be a vector but received shape\n              ${o.shape}`);const i=t.readSync(a.dataId),s=t.readSync(r.dataId),u=t.readSync(o.dataId),[l,c]=lt(i,a.shape,a.dtype,s,u,!0);return t.makeTensorInfo(c,a.dtype,l)}};const Fu={kernelName:n.SparseSegmentSum,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t}=e,{data:a,indices:r,segmentIds:o}=n;if(a.shape.length<1)throw new Error("Data should be at least 1 dimensional but received scalar");if(1!==r.shape.length)throw new Error(`Indices should be a vector but received shape\n             ${r.shape}`);if(1!==o.shape.length)throw new Error(`Segment ids should be a vector but received shape\n             ${o.shape}`);const i=t.readSync(a.dataId),s=t.readSync(r.dataId),u=t.readSync(o.dataId),[l,c]=lt(i,a.shape,a.dtype,s,u);return t.makeTensorInfo(c,a.dtype,l)}};const _u={kernelName:n.SparseToDense,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:a,attrs:r}=e,{sparseIndices:o,sparseValues:i,defaultValue:s}=t,{outputShape:u}=r,{sliceRank:l,numUpdates:c,strides:d,outputSize:p}=n.backend_util.calculateShapes(i,o,u),h=new du(c,l,o.shape.length,i.shape.length,d,[p,1],!1),f=a.runWebGLProgram(h,[i,o,s],i.dtype),x=sa({inputs:{x:f},backend:a,attrs:{shape:u}});return a.disposeIntermediateTensorInfo(f),x}};const Ou={kernelName:n.SplitV,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:a,attrs:r}=e,{x:o}=t,{numOrSizeSplits:i,axis:s}=r,u=n.util.parseAxisParam(s,o.shape)[0],l=n.backend_util.prepareSplitSize(o,i,u),c=o.shape.length,d=new Array(c).fill(0),p=o.shape.slice();return l.map((e=>{const n=[...p];n[u]=e;const t=hr({inputs:{x:o},backend:a,attrs:{begin:d,size:n}});return d[u]+=e,t}))}},Du="return sqrt(x);",Pu=Qt({opSnippet:Du,packedOpSnippet:Du,cpuKernelImpl:ct}),Lu={kernelName:n.Sqrt,backendName:"webgl",kernelFunc:Pu},Bu=Qt({opSnippet:"return x * x;"}),Vu={kernelName:n.Square,backendName:"webgl",kernelFunc:Bu},Wu="return (a - b) * (a - b);",Uu=Zt({opSnippet:Wu,packedOpSnippet:Wu}),Mu={kernelName:n.SquaredDifference,backendName:"webgl",kernelFunc:Uu};const Gu={kernelName:n.Step,backendName:"webgl",kernelFunc:function({inputs:e,attrs:n,backend:t}){const{x:a}=e,r=`if (isnan(x)) return x;\n    return x > 0.0 ? 1.0 : float(${n.alpha});\n  `,o=new Tt(a.shape,r);return t.runWebGLProgram(o,[a],a.dtype)}};class zu{constructor(e,n,t){this.variableNames=["x"],this.outputShape=t;const a=t.length,r=Ie(t.length),o=Ie(t.length);let i="";if(1===a)i="coords * strides + begin";else{let e=0;i=t.map(((n,a)=>(e++,1===t.length?`coords * strides[${a}] + begin[${a}]`:`coords[${e-1}] * strides[${a}] + begin[${a}]`))).join(",")}this.userCode=`\n      ${r} begin = ${r}(${e});\n      ${r} strides = ${r}(${n});\n\n      void main() {\n        ${o} coords = getOutputCoords();\n        setOutput(getX(${i}));\n      }\n    `}}const Xu={kernelName:n.StridedSlice,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:a,attrs:r}=e,{x:o}=t,{begin:i,end:s,strides:u,beginMask:l,endMask:c,ellipsisMask:d,newAxisMask:p,shrinkAxisMask:h}=r,{nonStrided:f,$begin:x,$strides:m,size:g,newShape:b,outShape:v}=n.slice_util.sliceInfo(o.shape,i,s,u,l,c,d,p,h),C=sa({inputs:{x:o},backend:a,attrs:{shape:b}});let $;if(f){const e=hr({inputs:{x:C},backend:a,attrs:{begin:x,size:g}});$=sa({inputs:{x:e},backend:a,attrs:{shape:v}}),a.disposeIntermediateTensorInfo(e)}else if(v.some((e=>0===e)))$=a.makeTensorInfo(v,o.dtype,[]);else{if(a.shouldExecuteOnCPU([C])){const e=a.texData.get(C.dataId).values,t=n.buffer(C.shape,C.dtype,e),r=dt(v,t,m,x);$=a.makeTensorInfo(v,C.dtype,r.values)}else{const e=new zu(x,m,v);$=a.runWebGLProgram(e,[C],C.dtype)}}const I=sa({inputs:{x:$},backend:a,attrs:{shape:v}});return a.disposeIntermediateTensorInfo(C),a.disposeIntermediateTensorInfo($),I}};const Hu={kernelName:n.StringNGrams,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t,attrs:a}=e,{separator:r,nGramWidths:o,leftPad:i,rightPad:s,padWidth:u,preserveShortSequences:l}=a,{data:c,dataSplits:d}=n,p=t.readSync(c.dataId),h=t.readSync(d.dataId),[f,x]=pt(p,h,r,o,i,s,u,l);return[t.makeTensorInfo([f.length],"string",f),t.makeTensorInfo(d.shape,"int32",x)]}};const ju={kernelName:n.StringSplit,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t,attrs:a}=e,{skipEmpty:r}=a,{input:o,delimiter:i}=n;if("string"!==o.dtype)throw new Error("Input must be of datatype string");if(1!==o.shape.length)throw new Error(`Input must be a vector, got shape: ${o.shape}`);if(0!==i.shape.length)throw new Error(`Delimiter must be a scalar, got shape: ${i.shape}`);const s=t.readSync(o.dataId),u=t.readSync(i.dataId)[0],[l,c,d]=ht(s,u,r),p=c.length;return[t.makeTensorInfo([p,2],"int32",l),t.makeTensorInfo([p],"string",c),t.makeTensorInfo([2],"int32",new Int32Array(d))]}};const Ku={kernelName:n.StringToHashBucketFast,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t,attrs:a}=e,{numBuckets:r}=a,{input:o}=n;if("string"!==o.dtype)throw new Error("Input must be of datatype string");if(r<=0)throw new Error("Number of buckets must be at least 1");const i=t.readSync(o.dataId),s=ft(i,r);return t.makeTensorInfo(o.shape,"int32",s)}},qu=Qt({opSnippet:"return tan(x);"}),Yu={kernelName:n.Tan,backendName:"webgl",kernelFunc:qu},Qu=Qt({opSnippet:"\n  float e2x = exp(-2.0 * abs(x));\n  return sign(x) * (1.0 - e2x) / (1.0 + e2x);\n"}),Zu={kernelName:n.Tanh,backendName:"webgl",kernelFunc:Qu};class Ju{constructor(e,n){this.variableNames=["A"];const t=new Array(e.length);for(let a=0;a<t.length;a++)t[a]=e[a]*n[a];this.outputShape=t,this.rank=t.length;const a=Ie(this.rank),r=function(e){const n=e.length;if(n>5)throw Error(`Tile for rank ${n} is not yet supported`);if(1===n)return`imod(resRC, ${e[0]})`;const t=["resRC.x","resRC.y","resRC.z","resRC.w","resRC.u"],a=[];for(let n=0;n<e.length;n++)a.push(`imod(${t[n]}, ${e[n]})`);return a.join()}(e);this.userCode=`\n      void main() {\n        ${a} resRC = getOutputCoords();\n        setOutput(getA(${r}));\n      }\n    `}}function el(e){const{inputs:t,backend:a,attrs:r}=e,{x:o}=t,{reps:i}=r;if("string"===o.dtype||o.shape.length>5){const e=a.readSync(o.dataId),t="string"===o.dtype?e.map((e=>n.util.decodeString(e))):e,r=n.buffer(o.shape,o.dtype,t),s=mt(r,i);return a.makeTensorInfo(s.shape,s.dtype,s.values)}const s=new Ju(o.shape,i);return a.runWebGLProgram(s,[o],o.dtype)}const nl={kernelName:n.Tile,backendName:"webgl",kernelFunc:el};class tl{constructor(e){this.variableNames=["x","indices"],this.customUniforms=[{name:"n",type:"int"},{name:"firstPass",type:"int"},{name:"negativeInf",type:"float"},{name:"dir",type:"int"},{name:"inc",type:"int"}],this.outputShape=e,this.userCode="\n       void main() {\n         ivec2 coords = getOutputCoords();\n         int batch = coords[0];\n         int elemIdx = coords[1];\n\n         // We compare elements pair-wise within a group of size 2 * inc.\n         // The comparing rule for each group alternates between ascending\n         // and descending. Within each group, we compare each pair at\n         // positions i and i+inc. To decide whether an element at position i\n         // is x0 or x1, we mod it by 2 * inc, if the result is smaller than\n         // inc, it is in the first half of the group, we denote it as x0,\n         // otherwise we denote it as x1.\n         // For example, as shown in the Bitonic top K paper referenced above,\n         // Figure5(a) shows that element[1] is in the\n         // second half of the group when group size is 2, but it is in the\n         // first half of the group when group size is 4.\n\n         bool isFirstInPair = imod(elemIdx, 2 * inc) < inc;\n         int i = isFirstInPair ? elemIdx : elemIdx - inc;\n\n         int i0 = firstPass == 1 ? i : int(getIndices(batch, i));\n         int i1 = firstPass == 1 ? i + inc : int(getIndices(batch, i + inc));\n         float x0 = i0 < n ? getX(batch, i0) : negativeInf;\n         float x1 = i1 < n ? getX(batch, i1) : negativeInf;\n\n         // Denotes which direction indices are in (ascending or descending).\n         bool reverse = imod(elemIdx, 2 * dir) >= dir;\n         bool isGreater = x0 > x1 || (x0 == x1 && i1 > i0);\n         if (reverse == isGreater) { // Elements in opposite order of direction\n           int iTemp = i0;\n           i0 = i1;\n           i1 = iTemp;\n         }\n         if (isFirstInPair) {\n            setOutput(float(i0));\n         } else {\n            setOutput(float(i1));\n         }\n       }\n     "}}class al{constructor(e){this.variableNames=["x","indices"],this.customUniforms=[{name:"n",type:"int"},{name:"firstPass",type:"int"},{name:"k",type:"int"}],this.outputShape=e,this.userCode="\n    void main() {\n         // Takes max of indices (0, k), (1, k + 1), (2, k + 2) ...\n         ivec2 coords = getOutputCoords();\n         int batch = coords[0];\n         int elemIdx = coords[1];\n\n         // The output size is half of the previous size.\n         // If the previous sequence is | | | | _ _ _ _  | | | |  _ _ _ _ (k=4),\n         // we only need to output the indices at positions |, the indices at\n         // positions _ can be thrown away, see Figure5(b) After Phase 2\n         // (Merge phase) in the Bitonic Top K paper referenced above.\n         // For example, the paper shows we only need to output the orange bars.\n         // The output sequence should look like this | | | | | | | |.\n         // Because the sequence is halved, to map the output index back\n         // to the previous sequence to find the corresponding value,\n         // we need to double the index. When we double the index,\n         // we basically interpolate a position, so 2i looks like\n         // | _ | _ | _ | _ | _ | _ | _. We move the | to the first k position\n         // of each 2k positions by - elemIdx % k. E.g. for output at\n         // index 4,5,6,7, we want to get the corresponding element at\n         // original index 8,9,10,11, for output at index 8,9,10,11,\n         // we want to get the corresponding element at original index\n         // 16,17,18,19, so on and so forth.\n\n         int i = elemIdx < k ? elemIdx : (elemIdx * 2 - imod(elemIdx, k));\n         int i0 = firstPass == 1 ? i : int(getIndices(batch, i));\n         int i1 = firstPass == 1 ? i + k : int(getIndices(batch, i + k));\n\n         float x0 = getX(batch, i0);\n         float x1 = i1 < n ? getX(batch, i1) : x0;\n\n         setOutput(x0 >= x1 ? float(i0) : float(i1));\n       }\n     "}}function rl(e,n){null!==n&&e.disposeIntermediateTensorInfo(n)}function ol(e){let n=1;for(;n<e;)n*=2;return n}const il={kernelName:n.TopK,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:a,attrs:r}=e,{x:o}=t,{k:i,sorted:s}=r,u=n.env().getNumber("TOPK_LAST_DIM_CPU_HANDOFF_SIZE_THRESHOLD"),l=n.env().getNumber("TOPK_K_CPU_HANDOFF_THRESHOLD"),c=o.shape,d=c[c.length-1];if(a.shouldExecuteOnCPU([o])||d<u||i>l){const e=a.readSync(o.dataId),[n,t]=gt(e,c,o.dtype,i,s);return[a.makeTensorInfo(n.shape,n.dtype,n.values),a.makeTensorInfo(t.shape,t.dtype,t.values)]}if(0===i)return c[c.length-1]=0,[a.makeTensorInfo(c,o.dtype,[]),a.makeTensorInfo(c,"int32",[])];if(1===d)return[o,Xo({attrs:{shape:c,dtype:"int32",value:0},backend:a})];const p=a.texData.get(o.dataId),h=null!==p&&p.isPacked,f=h?a.unpackTensor(o):o,x=n.util.sizeFromShape(c)/d,m=sa({inputs:{x:f},attrs:{shape:[x,d]},backend:a});h&&rl(a,f);const g=ol(i),b=ol(d);let v=null;const C=()=>null===v?[m,m]:[m,v],$=(e,n,t)=>{const r=C(),o=new tl(t),i=[[d],[null===v?1:0],[Number.NEGATIVE_INFINITY],[e],[n]],s=v;v=a.runWebGLProgram(o,r,"int32",i),rl(a,s)};for(let e=1;e<g;e*=2){const n=2*e;for(let t=e;t>=1;t/=2)$(n,t,[x,b])}for(let e=b;e>g;e/=2){const n=C(),t=new al([x,e/2]),r=[[d],[null===v?1:0],[g]],o=v;v=a.runWebGLProgram(t,n,"int32",r),rl(a,o);const i=g/2,s=2*i;for(let e=i;e>=1;e/=2)$(s,e,v.shape)}let I=v;v=hr({inputs:{x:v},backend:a,attrs:{begin:0,size:[x,i]}}),rl(a,I);let y=li({inputs:{x:m,indices:v},backend:a,attrs:{axis:1,batchDims:1}});rl(a,m);const k=c.slice(0,-1);k.push(i),I=v,v=sa({inputs:{x:v},attrs:{shape:k},backend:a}),rl(a,I);const w=y;return y=sa({inputs:{x:y},attrs:{shape:k},backend:a}),rl(a,w),[y,v]}};class sl{constructor(e,n,t,a,r,o){this.variableNames=["Image","Transforms"],this.outputShape=o;const i="nearest"===t?1:2;let s;switch(a){case"constant":s=1;break;case"reflect":s=2;break;case"wrap":s=3;break;case"nearest":s=4;break;default:s=1}this.userCode=`\n            float mapCoord(float outCoord, float len) {\n              float inCoord = outCoord;\n              if(${s} == 2) {\n                if (inCoord < 0.0) {\n                  if (len <= 1.0) {\n                    inCoord = 0.0;\n                  } else {\n                    float sz2 = 2.0 * len;\n                    if (inCoord < sz2) {\n                      inCoord = sz2 * float(int(float(-inCoord / sz2))) +\n                      inCoord;\n                    }\n                    inCoord = inCoord < -len ? inCoord + sz2 : -inCoord - 1.0;\n                  }\n                } else if (inCoord > len - 1.0) {\n                  if (len <= 1.0) {\n                    inCoord = 0.0;\n                  } else {\n                    float sz2 = 2.0 * len;\n                    inCoord -= sz2 * float(int(float(inCoord / sz2)));\n                    if (inCoord >= len) {\n                      inCoord = sz2 - inCoord - 1.0;\n                    }\n                  }\n                }\n                return clamp(inCoord, 0.0, len - 1.0);\n              } else if (${s} == 3) {\n                if (inCoord < 0.0) {\n                  if (len <= 1.0) {\n                    inCoord = 0.0;\n                  } else {\n                    float sz = len - 1.0;\n                    inCoord += len * (float(int(float(-inCoord / sz))) + 1.0);\n                  }\n                } else if (inCoord > len - 1.0) {\n                  if (len <= 1.0) {\n                    inCoord = 0.0;\n                  } else {\n                    float sz = len - 1.0;\n                    inCoord -= len * float(int(float(inCoord / sz)));\n                  }\n                }\n                return clamp(inCoord, 0.0, len - 1.0);\n              } else if (${s} == 4) {\n                return clamp(outCoord, 0.0, len - 1.0);\n              } else {\n                return outCoord;\n              }\n            }\n\n            float readWithFillValue(int batch, int coordY, int coordX,\n              int channel) {\n              float outputValue;\n              if (0 <= coordY && coordY < ${e} && 0 <= coordX && coordX < ${n}) {\n                  outputValue = getImage(batch, coordY, coordX, channel);\n              } else {\n                outputValue = float(${r});\n              }\n              return outputValue;\n            }\n\n            void main() {\n              ivec4 coords = getOutputCoords();\n              float outputValue;\n              int batch = coords[0];\n              int x = coords[2];\n              int y = coords[1];\n              int channel = coords[3];\n              float xf = float(x);\n              float yf = float(y);\n              float a1 = getTransforms(batch, 0);\n              float a2 = getTransforms(batch, 1);\n              float a3 = getTransforms(batch, 2);\n              float b1 = getTransforms(batch, 3);\n              float b2 = getTransforms(batch, 4);\n              float b3 = getTransforms(batch, 5);\n              float c1 = getTransforms(batch, 6);\n              float c2 = getTransforms(batch, 7);\n              float projection = c1 * xf + c2 * yf + 1.0;\n              if (projection == 0.0) {\n                outputValue = float(${r});\n              } else {\n                float inX = (a1 * xf + a2 * yf + a3) / projection;\n                float inY = (b1 * xf + b2 * yf + b3) / projection;\n                float mapX = mapCoord(inX, float(${n}));\n                float mapY = mapCoord(inY, float(${e}));\n\n                if (${i} == 1) {\n                  int coordY = int(round(mapY));\n                  int coordX = int(round(mapX));\n                  outputValue = readWithFillValue(batch, coordY, coordX,\n                    channel);\n                } else {\n                  float yFloor = floor(mapY);\n                  float xFloor = floor(mapX);\n                  float yCeil = yFloor + 1.0;\n                  float xCeil = xFloor + 1.0;\n                  float valueYFloor = (xCeil - mapX) *\n                  readWithFillValue(batch, int(yFloor), int(xFloor), channel) +\n                  (mapX - xFloor) *\n                  readWithFillValue(batch, int(yFloor), int(xCeil), channel);\n                  float valueYCeil = (xCeil - mapX) *\n                  readWithFillValue(batch, int(yCeil), int(xFloor), channel) +\n                  (mapX - xFloor) *\n                  readWithFillValue(batch, int(yCeil), int(xCeil), channel);\n                  outputValue = (yCeil - mapY) * valueYFloor +\n                  (mapY - yFloor) * valueYCeil;\n                }\n              }\n              setOutput(outputValue);\n            }\n        `}}const ul={kernelName:n.Transform,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t,attrs:a}=e,{image:r,transforms:o}=n,{interpolation:i,fillMode:s,fillValue:u,outputShape:l}=a,[c,d,p,h]=r.shape,[f,x]=null!=l?l:[d,p],m=new sl(d,p,i,s,u,[c,f,x,h]);return t.runWebGLProgram(m,[r,o],"float32")}};const ll={kernelName:n.Unique,backendName:"webgl",kernelFunc:function(e){const{inputs:n,attrs:t,backend:a}=e,{axis:r}=t,{x:o}=n;te(o,"unique"),console.warn("WARNING: ","UI might be locked temporarily as data is being downloaded");const i=a.readSync(o.dataId),{outputValues:s,outputShape:u,indices:l}=vt(i,r,o.shape,o.dtype);return[a.makeTensorInfo(u,o.dtype,s),a.makeTensorInfo([l.length],"int32",l)]}};const cl={kernelName:n.Unpack,backendName:"webgl",kernelFunc:function(e){const{inputs:n,backend:t,attrs:a}=e,{value:r}=n;let{axis:o}=a;o<0&&(o+=r.shape.length);const i=r,s=i.shape.length,u=r.shape[o],l=new Array(s-1);let c=0;for(let e=0;e<s;e++)e!==o&&(l[c++]=i.shape[e]);const d=[],p=new Array(s).fill(0),h=i.shape.slice();h[o]=1;const f=new Array(u);for(let e=0;e<f.length;e++){p[o]=e;const n=hr({inputs:{x:i},backend:t,attrs:{begin:p,size:h}}),a=sa({inputs:{x:n},backend:t,attrs:{shape:l}});f[e]=a,d.push(n)}return d.forEach((e=>t.disposeIntermediateTensorInfo(e))),f}};class dl{constructor(e,n){this.variableNames=["x","segmentIds"];const t=e.windowSize,a=e.batchSize,r=e.inSize,o=e.numSegments,i=o*Math.ceil(r/t);this.outputShape=[a,i];const s=4*Math.floor(t/4),u=t%4,l="\n        sumValue += dot(values, segFilter);\n    ";let c="";r%t>0&&(c=`\n        if (inIdx < 0 || inIdx >= ${r}) {\n          return initializationValue;\n        }\n      `);let d="";r%t>0&&(d=`\n        if (inIdx < 0 || inIdx >= ${r}) {\n          return -1.0;\n        }\n      `),this.userCode=`\n      const float initializationValue = 0.0;\n\n      float getValue(int batch, int inIdx) {\n        ${c}\n        return getX(batch, inIdx);\n      }\n\n      float getSegmentIdAtIndex(int inIdx) {\n        ${d}\n        return getSegmentIds(inIdx);\n      }\n\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int batch = coords[0];\n        int outIdx = coords[1];\n        int inOffset = int(floor(float(outIdx) / float(\n          ${o})) * float(${t}));\n        int currentSeg = int(mod(float(outIdx), float(${o})));\n\n        float sumValue = 0.0;\n\n        for (int i = 0; i < ${s}; i += 4) {\n          int inIdx = inOffset + i;\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2),\n            getValue(batch, inIdx + 3)\n          );\n\n          vec4 segFilter = vec4(\n            int(getSegmentIdAtIndex(inIdx)) == currentSeg ? 1 : 0,\n            int(getSegmentIdAtIndex(inIdx + 1)) == currentSeg ? 1 : 0,\n            int(getSegmentIdAtIndex(inIdx + 2)) == currentSeg ? 1 : 0,\n            int(getSegmentIdAtIndex(inIdx + 3)) == currentSeg ? 1 : 0\n          );\n\n          ${l}\n        }\n\n        int inIdx = inOffset + ${s};\n        if (${1===u}) {\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            initializationValue,\n            initializationValue,\n            initializationValue\n          );\n\n          int inIdxSeg = int(getSegmentIdAtIndex(inIdx));\n\n          vec4 segFilter = vec4(\n            int(getSegmentIdAtIndex(inIdx)) == currentSeg ? 1 : 0,\n            0,\n            0,\n            0\n          );\n\n          ${l}\n        } else if (${2===u}) {\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            initializationValue,\n            initializationValue\n          );\n\n          vec4 segFilter = vec4(\n            int(getSegmentIdAtIndex(inIdx)) == currentSeg ? 1 : 0,\n            int(getSegmentIdAtIndex(inIdx + 1)) == currentSeg ? 1 : 0,\n              0,\n              0\n          );\n\n          ${l}\n        } else if (${3===u}) {\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2),\n            initializationValue\n          );\n\n          vec4 segFilter = vec4(\n            int(getSegmentIdAtIndex(inIdx)) == currentSeg ? 1 : 0,\n            int(getSegmentIdAtIndex(inIdx + 1)) == currentSeg ? 1 : 0,\n            int(getSegmentIdAtIndex(inIdx + 2)) == currentSeg ? 1 : 0,\n            0\n          );\n\n          ${l}\n        }\n        setOutput(sumValue);\n      }\n    `}}const pl=[Vi,Ui,Ca,Ia,ka,Ra,Ea,Fa,_a,Oa,Wa,Ua,Ga,Xa,qa,ja,Qa,nr,er,rr,or,ir,lr,xr,mr,$r,kr,Sr,Nr,zt,Br,qr,Yr,zr,Zr,Jr,Qr,no,ao,oo,lo,co,ho,vo,Co,mo,Io,ko,wo,So,To,No,Fo,Do,Lo,Wo,Go,Ho,Ko,Qo,Jo,ti,ri,oi,si,ci,pi,fi,Mt,xi,Dr,gi,vi,$i,jt,yi,wi,Ri,Ni,Ti,Fi,Oi,Pi,Gi,ji,Hi,Yi,Qi,Zi,Xi,Ji,es,ts,os,ss,ms,ia,bs,Cs,Is,ks,br,Rs,Es,Ns,Os,Ps,Yt,Ls,Vs,Cr,cs,Us,Xs,Gs,ua,Ks,Ys,Js,nu,ru,iu,uu,cu,pu,fu,mu,vu,$u,yu,wu,fr,xs,Su,Tu,Eu,Nu,Au,Fu,_u,Ou,Lu,Vu,Mu,Gu,Xu,Hu,ju,Ku,hs,ma,Yu,Zu,nl,il,ul,ba,ll,cl,{kernelName:n.UnsortedSegmentSum,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:a,attrs:r}=e,{x:o,segmentIds:i}=t,{numSegments:s}=r,u=o.shape.length,l=[];let c=0;const d=n.backend_util.getAxesPermutation([c],u);let p=o;null!=d&&(p=ga({inputs:{x:o},backend:a,attrs:{perm:d}}),l.push(p),c=n.backend_util.getInnerMostAxes(1,u)[0]);const h=n.backend_util.segment_util.computeOutShape(p.shape,c,s),f=n.util.sizeFromShape([p.shape[c]]),x=sa({inputs:{x:p},backend:a,attrs:{shape:[-1,f]}});l.push(x);const m=n.sumOutType(o.dtype),g=(e,t,r,o,i)=>{const s=e.shape[0],u=e.shape[1],c=n.backend_util.segment_util.segOpComputeOptimalWindowSize(u,i),d=new dl({windowSize:c,inSize:u,batchSize:s,numSegments:i},t),p=a.compileAndRun(d,[e,r],o);if(l.push(p),p.shape[1]===i)return p;const h=Bs({backend:a,attrs:{start:0,stop:i,step:1,dtype:"float32"}}),f=el({inputs:{x:h},backend:a,attrs:{reps:[u/c]}});l.push(h),l.push(f);return g(p,t,f,o,i)},b=sa({inputs:{x:g(x,"unsortedSegmentSum",i,m,s)},backend:a,attrs:{shape:h}});let v=b;if(null!=d){l.push(b);const e=n.backend_util.getUndoAxesPermutation(d);v=ga({inputs:{x:v},backend:a,attrs:{perm:e}})}return l.forEach((e=>a.disposeIntermediateTensorInfo(e))),v}},Ts];for(const e of pl)n.registerKernel(e);e.GPGPUContext=an,e.MathBackendWebGL=Pt,e.forceHalfFloat=Lt,e.gpgpu_util=tn,e.setWebGLContext=r,e.version_webgl="3.9.0",e.webgl=Bt,e.webgl_util=ae,Object.defineProperty(e,"__esModule",{value:!0})}));
//# sourceMappingURL=tf-backend-webgl.es2017.min.js.map
